<?php

namespace app\student\service;

use app\student\model\ScratchLecturePostModel;
use app\student\model\ScratchHomeworkPostModel;
use app\student\model\ScratchWorksPostModel;

class HomeworkService 
{

    public function createHomework($filter = array())
    {
        $lectureId   = isset($filter['lecture_id']) ? $filter['lecture_id'] : 0;

        $lectureModel = new ScratchLecturePostModel();
        $homeworkModel = new ScratchHomeworkPostModel();
        $worksModel = new ScratchWorksPostModel();

        $lectureFind = $lectureModel
                        ->where('id',$lectureId)
                        ->find();
        $time = time();

        if(!$lectureFind){
            $this->error('异常错误！');
        }

        $homeworkFind = $homeworkModel
            ->where('create_user_id',getUserId())
            ->where('student_id',getStudentId())
            ->where('lecture_id',$lectureId)
            ->find();

        if ($homeworkFind && $homeworkFind['works_id']) {
            $projectId = $homeworkFind['works_id'];

            return $projectId;
        }
        
        if (!empty($lectureFind['start_works_id'])) {
            $startWorksFind = $worksModel
                        ->where('id',$lectureFind['start_works_id'])
                        ->find();
            if(!$startWorksFind){
                $post_content = file_get_contents('./upload/works/start/start.json');
                $thumbnail = 'works/start/start.png';

            }else{
                $post_content = file_get_contents('./upload/'.$startWorksFind['works_path']);

                $thumbnail = $startWorksFind['thumbnail'];
            }

        } else {
            $post_content = file_get_contents('./upload/works/start/start.json');
            $thumbnail = 'works/start/start.png';
        }

        $folder = './upload/works/'.date('Ymd',$time).'/';
        $folder2 = 'works/'.date('Ymd',$time).'/';
        $filename = md5(uniqid(md5(microtime(true)),true)).'.json';
        if(!is_dir($folder))
        {
            mkdir($folder,0755,true);
        }
        file_put_contents($folder.$filename, $post_content);
        
        $worksData = [
            'works_name'=>$lectureFind['lecture_name'].' 作业',
            'works_path'=>$folder2.$filename,
            'thumbnail'=>$thumbnail
        ];

        $worksModel->save($worksData);
        $projectId = $worksModel->id;


        $homeworkData = [
            'student_id'    => getStudentId(),
            'lecture_id'    => $lectureId,
            'homework_name' => $lectureFind['lecture_name'].' 作业',
            'works_id'      => $projectId,
            'thumbnail'     => $thumbnail,
            'teacher_remark'=>''

        ];

        $homeworkModel->save($homeworkData);

        $projectId = encode($projectId);

        return $projectId;
        

    }
    /**
     * 获取作品统计信息（Statistics）
     * @throws \think\exception\DbException
     */
    public function getHomeworksStatistics()
    {
        $userId      =   getUserId();
        $worksModel  =   new ScratchHomeworkPostModel();
        $workscount  =   $worksModel
                        ->where('create_user_id', '=', $userId)
                        ->count();
        return $workscount;
    }


}