<?php

namespace app\student\service;

use app\student\model\ScratchLecturePostModel;
use app\student\model\ScratchHomeworkPostModel;

class LectureService 
{

    /**
     * 课时查询
     * @param      $filter
     * @return \think\Paginator
     * @throws \think\exception\DbException
     */
    // 二次查询。第一次查询主表，然后使用in 一次性查询相关的表详情，并组装出来。
    public function lectureListByCourseId($filter = array())
    {

        $where = [];
  



        if (!empty($filter['course_id']) && $filter['course_id'] != 0) {
            if (is_array($filter['course_id'])) {
                $where = [['course_id','in',$filter['course_id']]];
            } else {
                $where['course_id'] = $filter['course_id'];
            }
            

            
        }



        $field = '*';


        $lectureModel = new ScratchLecturePostModel();
        $homeworkModel = new ScratchHomeworkPostModel();

        // 查询课时列表
        $lecture      = $lectureModel
            ->where($where)
            ->field($field)
            ->append(['status_text','lecture_status_text'])
            ->order('list_order asc')
            ->select()
            ->toArray();




        $data = $lecture;
        $ids = [];
        $categoryIds = [];
        foreach ($data as $key => $value) {
            $ids[] = $value['id'];
        }


        $homework      = $homeworkModel
            ->where('lecture_id','in',$ids)
            ->where('create_user_id',getUserId())
            ->field($field)
            ->append(['status_text'])
            ->select()
            ->toArray();




        // 数据组装
        foreach ($data as $key => $value) {
            $data[$key]['homework'] = [];
            $data[$key]['homework_status'] = 0;
            foreach ($homework as $k => $v) {
                if ($v['lecture_id'] == $value['id']){
                    $data[$key]['homework'][] = $v;

                    if ($v['homework_status'] == 1) {
                        $data[$key]['homework_status'] = 1;
                    }
                    
                    unset($homework[$k]);
                }
            }

        }

        $lecture = $data;


        return $lecture;


    }



    

}