<?php

namespace app\teacher\model;

use think\Model;
// 软删除
use think\model\concern\SoftDelete;

class SchoolStudentContactsModel extends Model
{
	// 软删除
	use SoftDelete;
    protected $deleteTime = 'delete_time';
    protected $defaultSoftDelete = 0;

    protected $autoWriteTimestamp = true;
    protected $createTime = 'create_time';
    protected $updateTime = 'update_time';

    // 自动完成
    protected $auto = ['query_mobile'];
    protected $insert = ['create_user_id','status' => 1];  
    protected $update = []; 

    // 类型转换
    protected $type = [
        'status'        =>  'integer', // 数据状态

    ];

    // 多对多关联
    public function students()
    {
        return $this->belongsToMany('school_student');
    }



    public function setCreateUserIdAttr($value)
    {
        return getUserId();
    }

    public function getCreateUserIdAttr($value)
    {
        return getUserInfoById($value);
    }


    // 获取器
    public function getStatusTextAttr($value,$data)
    {
        $status = [0=>'无效',1=>'有效',2=>'待审核'];
        return $status[$data['status']];
    }

    // 修改器
    public function setMobileAttr($value)
    {
        return strEncode(trim($value));
    }

    // 修改器
    public function setQueryMobileAttr($value,$data)
    {
        return md5(trim($data['mobile']));
    }

    // 获取器
    public function getMobileAttr($value)
    {
        //return encryptTel(strDecode($value));
        return strDecode($value);
    }



}