<?php
namespace app\teacher\service;
use app\teacher\model\UserModel;
use think\Db;
class AccountService
{
    /**
     * author: jfour
     * 获取登录用户的个人信息
     * @return 
     * @throws \think\exception\DbException
     */
    public function getUserInfo()
    {
        $uid         = getUserId();

        $userModel  = new UserModel();
        $userFind   = $userModel
                      ->field('*')
                      ->append(['sex_text'])
                      ->find($uid);
        return $userFind;
    }

    /**
     * author: jfour    
     * 修改登录用户的基本信息
     * @param      $filter
     * @throws \think\exception\DbException
     */
    public function editUserInfo($filter = array())
    {
        $userModel = new UserModel();
        $uid = getUserId();
        
        $editData['user_nickname']  = $filter['user_nickname'];
        $editData['signature']  =  $filter['signature'];
        $editData['user_email']  =  $filter['user_email'];        
        $editData['sex']  = $filter['sex'];
        $editData['birthday']  =  $filter['birthday'];

        $res = $userModel->save($editData,['id' => $uid]);

        return $res;
    }
 
    
    //重置密码
    public function resetPassword($filter = array())
    {

        $id           = isset($filter['id'])?$filter['id']:0;

        $res = Db::name('user')
                    ->where('id',$id)
                    ->update([
                        'user_pass'=>password(getOption('site_defaultvalue','overall')['pass'])
                    ]);

        return $res;
    }
    
    /**
     * 用户密码修改
     * @param $user
     * @return int
     */
    public function editPassword($user)
    {
        $userId    = getUserId();
        $userQuery = Db::name("user");
        if ($user['password'] != $user['repassword']) {
            return ['code'=>0,'msg'=>'两次输入密码不一致！'];
        }
        $pass = $userQuery->where('id', $userId)->find();
        if (!comparePassword($user['old_password'], $pass['user_pass'])) {
            return ['code'=>0,'msg'=>'原密码不正确！'];
        }
        $data['user_pass'] = password($user['password']);
        $res = Db::name("user")->where('id', $userId)->update($data);
        
        if ($res) {
			return ['code'=>1,'msg'=>'修改成功！'];
		} else {
			return ['code'=>0,'msg'=>'修改成功！'];
		}
    }    
}