<?php

namespace app\teacher\service;

use app\teacher\model\OrgDeptModel;

class DeptService 
{
    /**
     * 查询
     * @param      $filter
     * @return \think\Paginator
     * @throws \think\exception\DbException
     */
    // 二次查询。第一次查询主表，然后使用in 一次性查询相关的表详情，并组装出来。
    public function getDept($filter = array())
    {


        $where = [];



        $field = '*';


        $deptModel = new OrgDeptModel();

        // 查询学生列表
        $dept      = $deptModel
            ->order('update_time', 'DESC')
            ->where('status', 1)
            ->where($where)
            ->field($field)
            ->select()
            ->append(['status_text','dept_status_text'])
            ->toArray();

        foreach ($dept as $key => $value) {
            $dept[$key]['title'] = $value['dept_name'];
            $dept[$key]['value'] = $value['id'];
            $dept[$key]['key'] = $value['id'];
        }




        return $dept;

    }
    public function getDeptById($id)
    {


		$where = [];
		
		if(is_array($id)){
			$where[] = ['id','in',$id];
		}else{
			$where['id'] = $id;
		}

        $field = '*';

        $deptModel = new OrgDeptModel();

        // 查询学生列表
        $dept      = $deptModel
            ->where('status', 1)
            ->where($where)
            ->field($field)
            ->select()
            ->append(['status_text','dept_status_text'])
            ->toArray();

        


        return $dept;

    }
        /**
     * 查询
     * @param      $filter
     * @return \think\Paginator
     * @throws \think\exception\DbException
     */
    // 二次查询。第一次查询主表，然后使用in 一次性查询相关的表详情，并组装出来。
    public function getTreeDept($filter = array())
    {


        $where = [];



        $field = '*';


        $deptModel = new OrgDeptModel();

        // 查询学生列表
        $dept      = $deptModel
            ->order('update_time', 'DESC')
            ->where('status', 1)
            ->where($where)
            ->field($field)
            ->select()
            ->append(['status_text','dept_status_text'])
            ->toArray();

        foreach ($dept as $key => $value) {
            $dept[$key]['title'] = $value['dept_name'];
            $dept[$key]['value'] = $value['id'];
            $dept[$key]['key'] = $value['id'];
        }

        $dept = getRecursionTree($dept);



        return $dept;

    }



    public function addDept($filter = array())
    {
        $deptModel = new OrgDeptModel();


        $addData['dept_name']    = isset($filter['dept_name']) ? $filter['dept_name'] : '';
        $addData['dept_status']  = isset($filter['dept_status']) ? $filter['dept_status'] : 0;
        $addData['parent_id']       = isset($filter['parent_id']) ? $filter['parent_id'] : 0;

        $res = $deptModel->save($addData);

        

        return $res;

    }



    public function editDept($filter = array())
    {

        $deptModel = new OrgDeptModel();

        $id                         = isset($filter['id']) ? $filter['id'] : 0;

        $editData['dept_name']    = isset($filter['dept_name']) ? $filter['dept_name'] : '';
        $editData['dept_status']  = isset($filter['dept_status']) ? $filter['dept_status'] : 0;
        $editData['parent_id']       = isset($filter['parent_id']) ? $filter['parent_id'] : 0;

        return $deptModel->save($editData,['id' => $id]);

    }



    public function deleteDept($filter = array())
    {

        $deptModel = new OrgDeptModel();

        $id           = isset($filter['id'])?$filter['id']:0;


        return $deptModel->destroy($id);

    }

}