<?php

namespace app\teacher\service;

use app\teacher\model\SchoolClassesPostModel;
use app\teacher\model\SchoolClassesUserPostModel;
use app\teacher\model\SchoolPostModel;

class ScratchClassesService 
{

    /**
     * 校区查询
     * @param      $filter
     * @return \think\Paginator
     * @throws \think\exception\DbException
     */
    // 二次查询。第一次查询主表，然后使用in 一次性查询相关的表详情，并组装出来。
    public function classesData($filter = array())
    {


        $field = '*';


        $SchoolClassesPostModel = new SchoolClassesPostModel();

        

        $classes = $SchoolClassesPostModel
                ->field('id,classes_name')
                ->where('app','scratch')
                ->limit(20)
                ->select()
                ->toArray();



        return $classes;

    }


    /**
     * 班级查询
     * @param      $filter
     * @return \think\Paginator
     * @throws \think\exception\DbException
     */
    // 二次查询。第一次查询主表，然后使用in 一次性查询相关的表详情，并组装出来。
    public function classesList($filter = array())
    {


        $where = [];
  
        $pageNo = 1;
        $pageSize = 20;


        $where['app'] = 'scratch';
  
        if (!empty($filter['search'])) {
            $where['classes_name'] = $filter['search'];
        }

        if (!empty($filter['school_id']) && $filter['school_id'] != 0) {
            $where['school_id'] = $filter['school_id'];
        }

        if (!empty($filter['classes_status']) && $filter['classes_status'] != 0) {
            $where['classes_status'] = $filter['classes_status'];
        }

        if (!empty($filter['pageNo']) && $filter['pageNo'] != 0 && is_int($filter['pageNo'])) {
            $pageNo = $filter['pageNo'];
        }

        if (!empty($filter['pageSize']) && $filter['pageSize'] != 0 && $filter['pageSize'] <= 100) {
            $pageSize = $filter['pageSize'];
        }




        $field = '*';


        $classesModel = new SchoolClassesPostModel();


        $classesUserModel = new SchoolClassesUserPostModel();

        $schoolPostModel = new SchoolPostModel();

        // 查询班级列表
        $classes      = $classesModel
            ->order('update_time', 'DESC')
            ->where('status', 1)
            ->where($where)
            ->field($field)
            ->paginate($pageSize)
            ->append(['status_text','classes_status_text'])
            ->toArray();

        $data = $classes['data'];
        $ids = [];
        $schoolIds = [];
        foreach ($data as $key => $value) {
            $ids[] = $value['id'];
            $schoolIds[] = $value['school_id'];
        }


        // 查询已分页数据的教师（ in ）
        $teachers = $classesUserModel

                ->where('create_time', '>=', 0)
                ->where('delete_time', 0)
                ->where('status', 1)
                ->where('user_type', 1)

                ->where('classes_id','in',$ids)
                ->field('user_id,classes_id,user_duty')
                ->select()
                ->toArray();

        $school = $schoolPostModel
                ->where('id','in',$schoolIds)
                ->field('id,school_name')
                ->select()
                ->toArray();


        // 数据组装
        foreach ($data as $key => $value) {
            foreach ($teachers as $k => $v) {
                if ($value['id'] == $v['classes_id']) {
                    $s = $v;
                    $s['username'] = getUserInfoById($v['user_id'])['user_nickname'];
                    $data[$key]['teachers'][] = $s;
                    unset($teachers[$k]);
                }
            }

            foreach ($school as $k => $v) {
                if ($value['school_id'] == $v['id']) {
                    $data[$key]['school_name'] = $v['school_name'];
                    $data[$key]['school_id'] = $v['id'];
                    unset($school[$k]);
                }
            }
        }
        $classes['data'] = $data;


        return $classes;

    }



    public function addClasses($filter = array())
    {
        $classesModel = new SchoolClassesPostModel();

        $addData['app']    = 'scratch';


        $addData['classes_name']    = isset($filter['classes_name']) ? $filter['classes_name'] : '';
        $addData['classes_status']  = isset($filter['classes_status']) ? $filter['classes_status'] : 0;
        $addData['school_id']       = isset($filter['school_id']) ? $filter['school_id'] : 0;
        $addData['start_student_num']       = isset($filter['start_student_num']) ? $filter['start_student_num'] : 0;
        $addData['limit_student_num']       = isset($filter['limit_student_num']) ? $filter['limit_student_num'] : 0;

        $res = $classesModel->save($addData);

        

        return $res;

    }



    public function editClasses($filter = array())
    {

        $classesModel = new SchoolClassesPostModel();

        $id                         = isset($filter['id']) ? $filter['id'] : 0;

        $editData['classes_name']    = isset($filter['classes_name']) ? $filter['classes_name'] : '';
        $editData['classes_status']  = isset($filter['classes_status']) ? $filter['classes_status'] : 0;
        $editData['school_id']       = isset($filter['school_id']) ? $filter['school_id'] : 0;
        $editData['start_student_num']       = isset($filter['start_student_num']) ? $filter['start_student_num'] : 0;
        $editData['limit_student_num']       = isset($filter['limit_student_num']) ? $filter['limit_student_num'] : 0;

        return $classesModel->save($editData,['id' => $id]);

    }



    public function delClasses($filter = array())
    {

        $classesModel = new SchoolClassesPostModel();

        $id           = isset($filter['id'])?$filter['id']:0;


        return $classesModel->destroy($id);

    }

}