<?php

namespace app\teacher\service;

use app\teacher\model\ScratchCoursePostModel;
use app\teacher\model\SchoolPostModel;
use app\teacher\model\ScratchLecturePostModel;
use app\teacher\service\ScratchLectureService;

class ScratchCourseService 
{
    /**
     * 课程查询
     * @param      $filter
     * @param bool $isPage
     * @return \think\Paginator
     * @throws \think\exception\DbException
     */
    // 二次查询。第一次查询主表，然后使用in 一次性查询相关的表详情，并组装出来。
    public function courseList($filter = array())
    {

        $where = [];
  

        if (!empty($filter['search'])) {
            $where['course_name'] = $filter['search'];
        }

        if (!empty($filter['school_id']) && $filter['school_id'] != 0) {
            $where['school_id'] = $filter['school_id'];
        }

        if (!empty($filter['course_status']) && $filter['course_status'] != 0) {
            $where['course_status'] = $filter['course_status'];
        }



        $field = '*';


        $courseModel = new ScratchCoursePostModel();
        $schoolPostModel = new SchoolPostModel();
        $lectureModel = new ScratchLecturePostModel();

        // 查询课程列表
        $course      = $courseModel
            ->where('parent_id',0)
            ->where($where)
                ->order('list_order asc')
            ->field($field)
            ->select()
            ->append(['status_text','course_status_text'])
            ->toArray();

        $data = $course;
        $ids = [];
        $schoolIds = [];
        foreach ($data as $key => $value) {
            $ids[] = $value['id'];
            $schoolIds[] = $value['school_id'];
        }



        $school = $schoolPostModel
                ->where('id','in',$schoolIds)
                ->field('id,school_name')
                ->select()
                ->toArray();

        $lecture = $lectureModel
                ->where('course_id','in',$ids)
                ->order('list_order asc')
                ->select()
                ->toArray();
        // 数据组装
        foreach ($data as $key => $value) {


            foreach ($school as $k => $v) {
                if ($value['school_id'] == $v['id']) {
                    $data[$key]['school_name'] = $v['school_name'];
                    $data[$key]['school_id'] = $v['id'];

                }
            }

            foreach ($lecture as $k => $v) {
                if ($value['id'] == $v['course_id']) {
                    $data[$key]['lectures'][] = $v;
                    unset($lecture[$k]);
                }
            }

        }
        $course = $data;
        return $course;
    }



    public function addCourse($filter = array())
    {

        $courseModel = new ScratchCoursePostModel();

        $addData['course_name']    = isset($filter['course_name']) ? $filter['course_name'] : '';
        $addData['course_status']  = isset($filter['course_status']) ? $filter['course_status'] : 0;
        $addData['school_id']       = isset($filter['school_id']) ? $filter['school_id'] : 0;

        
        $addData['list_order']       = isset($filter['list_order']) ? $filter['list_order'] : 10000;

        $addData['parent_id']       = isset($filter['parent_id']) ? $filter['parent_id'] : 0;

        $addData['subclass_type']       = isset($filter['subclass_type'])?$filter['subclass_type']:'';
        $addData['lecture_number']       = isset($filter['lecture_number'])?$filter['lecture_number']:'';
        //$addData['map_photo']       = isset($filter['map_photo'])?$filter['map_photo']:'';
        //$addData['thumbnail']       = isset($filter['thumbnail'])?$filter['thumbnail']:'';

        if(isset($filter['parent_id']) && $filter['parent_id'] != 0){
            $addData['subclass_type']       = 'lecture';
            $addData['course_type'] = 'project';
        }else{

            $addData['course_type'] = 'course';
        }
        
        $res = $courseModel->save($addData);
        
        return $res;

    }



    public function editCourse($filter = array())
    {

        $courseModel = new ScratchCoursePostModel();

        $id                         = isset($filter['id']) ? $filter['id'] : 0;

        


        $editData['course_name']    = isset($filter['course_name']) ? $filter['course_name'] : '';
        $editData['course_status']  = isset($filter['course_status']) ? $filter['course_status'] : 0;
        $editData['school_id']       = isset($filter['school_id']) ? $filter['school_id'] : 0;
        $editData['lecture_number']       = isset($filter['lecture_number'])?$filter['lecture_number']:'';
        //$editData['map_photo']       = isset($filter['map_photo'])?$filter['map_photo']:'';
        //$editData['thumbnail']       = isset($filter['thumbnail'])?$filter['thumbnail']:'';
        $editData['list_order']       = isset($filter['list_order']) ? $filter['list_order'] : 10000;


        return $courseModel->save($editData,['id' => $id]);

    }



    public function delStudent($filter = array())
    {

        $courseModel = new ScratchCoursePostModel();

        $id                         = isset($filter['id'])?$filter['id']:0;


        return $courseModel->destroy($id);

    }



    public function getCourseInfo($filter = array())
    {
        $courseModel = new ScratchCoursePostModel();
        $schoolPostModel = new SchoolPostModel();

        $id      = isset($filter['id'])?$filter['id']:0;

        $courseFind = $courseModel
            ->append(['status_text','course_status_text'])->find($id);

        
        $schoolFind = $schoolPostModel
                ->where('id',$courseFind['school_id'])
                ->field('id,school_name')
                ->find();

        $courseFind['school_name'] = $schoolFind['school_name'];


        return $courseFind;
    }



    public function getCourseByParentId($filter = array())
    {
        $where = [];
  



        if (!empty($filter['parent_id']) && $filter['parent_id'] != 0) {
            $where['parent_id'] = $filter['parent_id'];
        }



        $field = '*';


        $courseModel = new ScratchCoursePostModel();
        $lectureService = new ScratchLectureService();

        // 查询课时列表
        $course      = $courseModel
            ->where($where)
            ->field($field)
            ->append(['status_text','course_status_text'])
            ->order('list_order asc')
            ->select()
            ->toArray();

        $data = $course;
        $ids = [];
        $categoryIds = [];
        foreach ($data as $key => $value) {
            $ids[] = $value['id'];
            $data[$key]['thumbnail'] = getAssetUrl($value['thumbnail']);
        }


        




        // 数据组装
        foreach ($data as $key => $value) {
            $data[$key]['lectures'] = $lectureService->lectureListByCourseId(['course_id'=>$value['id']]);

        }

        $course = $data;


        return $course;
    }

}