<?php

namespace app\teacher\service;

use app\teacher\model\SchoolStudentPostModel;
use app\teacher\model\SchoolStudentContactsModel;

use app\teacher\model\ScratchHomeworkPostModel;

use think\Db;

class ScratchHomeworkService 
{





    public function studentList($filter = array())
    {

        $where = [];
  
        $pageNo = 1;
        $pageSize = 20;


        if (!empty($filter['search'])) {
            $where['student_name'] = $filter['search'];
        }

        if (!empty($filter['student_status']) && $filter['student_status'] != 0) {
            $where['student_status'] = $filter['student_status'];
        }

        if (!empty($filter['classes_id']) && $filter['classes_id'] != 0) {
            $userIds = Db::name('school_classes_user_post')
                    ->where('classes_id',$filter['classes_id'])
                    ->where('delete_time',0)
                    ->where('user_type',2)
                    ->column('user_id');
            $where['id'] = $userIds;
        }

        if (!empty($filter['pageNo']) && $filter['pageNo'] != 0 && is_int($filter['pageNo'])) {
            $pageNo = $filter['pageNo'];
        }

        if (!empty($filter['pageSize']) && $filter['pageSize'] != 0 && $filter['pageSize'] <= 100) {
            $pageSize = $filter['pageSize'];
        }

        if (!empty($filter['lecture_id']) && $filter['lecture_id'] != 0) {
            $lectureId = $filter['lecture_id'];
        } else {
            // $where['id'] = 1;
            $lectureId = 1;
        }





        $field = 'id,student_name,sex,student_status,status';


        $studentModel = new SchoolStudentPostModel();
        $contactsModel = new SchoolStudentContactsModel();

        $homeworkModel = new ScratchHomeworkPostModel();

        // 查询学生列表
        $students      = $studentModel
            ->where('create_time', '>=', 0)
            ->where('delete_time', 0)
            ->order('update_time', 'DESC')
            ->where('status', 1)
            ->where('user_id','<>',0)
            ->where($where)
            ->field($field)
            ->paginate($pageSize)
            ->append(['status_text','sex_text','student_status_text'])
            ->toArray();

        $data = $students['data'];
        $ids = [];
        $schoolIds = [];
        foreach ($data as $key => $value) {
            $ids[] = $value['id'];
        }


        // 查询已分页数据的联系方式（ in ）
        $contacts = $contactsModel
                ->alias('a')
                ->join([['__SCHOOL_STUDENT_CONTACTS_POST__ b', 'a.id = b.contacts_id']])
                ->where('a.create_time', '>=', 0)
                ->where('a.delete_time', 0)
                ->where('a.status', 1)

                ->where('b.create_time', '>=', 0)
                ->where('b.delete_time', 0)
                ->where('b.status', 1)

                ->where('b.student_id','in',$ids)
                ->order('a.update_time', 'DESC')
                ->field('a.mobile,b.student_id,b.relation_type')
                ->select()
                ->toArray();


        

        $homework = $homeworkModel
                    ->where('lecture_id',$lectureId)
                    ->where('student_id','in',$ids)
                    ->field('*')
                    ->select()
                    ->toArray();
        // 数据组装
        foreach ($data as $key => $value) {


            foreach ($contacts as $k => $v) {
                if ($value['id'] == $v['student_id']) {
                    $data[$key]['contacts'][] = $v;
                    unset($contacts[$k]);
                }
            }

            $data[$key]['correct'] = 0;
            $data[$key]['push'] = 0;
            $data[$key]['submit'] = 0;

            foreach ($homework as $k => $v) {
                if ($value['id'] == $v['student_id']) {

                    $array = $v;

                    $array['thumbnail'] = getAssetUrl($array['thumbnail']);
                    $array['works_id'] = encode($array['works_id']);

                    $data[$key]['homework'][] = $array;
                    

                    $data[$key]['submit'] = 1;

                    if ($v['correct_status']) {
                        $data[$key]['correct'] = 1;
                    }

                    if ($v['push_status']) {
                        $data[$key]['push'] = 1;
                    }

                    unset($homework[$k]);
                }
            }

            
        }
        $students['data'] = $data;


        return $students;
    }



    /**
     * 批改作业
     * @param      $filter
     * @param bool $isPage
     * @return \think\Paginator
     * @throws \think\exception\DbException
     */
    public function correct($filter = array())
    {

        

        return false;

        
    }    

    /**
     * 推送作业
     * @param      $filter
     * @param bool $isPage
     * @return \think\Paginator
     * @throws \think\exception\DbException
     */
    public function push($filter = array())
    {

        

        return false;
        

        
    }





}