<?php

namespace app\teacher\service;

use app\teacher\model\ScratchLecturePostModel;

class ScratchLectureService 
{

    /**
     * 课时查询
     * @param      $filter
     * @return \think\Paginator
     * @throws \think\exception\DbException
     */
    // 二次查询。第一次查询主表，然后使用in 一次性查询相关的表详情，并组装出来。
    public function lectureListByCourseId($filter = array())
    {

        $where = [];
  



        if (!empty($filter['course_id']) && $filter['course_id'] != 0) {
            $where['course_id'] = $filter['course_id'];
        }



        $field = '*';


        $lectureModel = new ScratchLecturePostModel();

        // 查询课时列表
        $lecture      = $lectureModel
            ->where($where)
            ->order('list_order asc')
            ->field($field)
            ->append(['status_text','lecture_status_text'])
            ->select()
            ->toArray();




        $data = $lecture;
        $ids = [];
        $categoryIds = [];
        foreach ($data as $key => $value) {
            $ids[] = $value['id'];
            $data[$key]['thumbnail'] = getAssetUrl($value['thumbnail']);
        }





        // 数据组装
        foreach ($data as $key => $value) {
            

        }

        $lecture = $data;


        return $lecture;


    }


    public function addLecture($filter = array())
    {

        $lectureModel = new ScratchLecturePostModel();

        $addData['lecture_name']    = isset($filter['lecture_name']) ? $filter['lecture_name'] : '';
        $addData['lecture_status']  = isset($filter['lecture_status']) ? $filter['lecture_status'] : 0;

        $addData['course_id']       = isset($filter['course_id']) ? $filter['course_id'] : 0;
        $addData['list_order']       = isset($filter['list_order']) ? $filter['list_order'] : 10000;

        $addData['example_works_id']       = isset($filter['example_works_id']) ? $filter['example_works_id'] : 0;
        $addData['start_works_id']       = isset($filter['start_works_id']) ? $filter['start_works_id'] : 0;

        $addData['lecture_excerpt']       = $filter['lecture_excerpt'];


        $addData['style']       = 'top: 0px;left: 0px;transform: scale(0.6);width: 120px;  height: 180px;background-image: url(/static/demo-img/1000.png);';

        

        $res = $lectureModel->save($addData);
        

        return $res;

    }



    public function editLecture($filter = array())
    {

        $lectureModel = new ScratchLecturePostModel();

        $id                         = isset($filter['id']) ? $filter['id'] : 0;

        $editData['lecture_name']    = isset($filter['lecture_name']) ? $filter['lecture_name'] : '';
        $editData['lecture_status']  = isset($filter['lecture_status']) ? $filter['lecture_status'] : 0;
        $editData['list_order']       = isset($filter['list_order']) ? $filter['list_order'] : 10000;


        $editData['example_works_id']       = isset($filter['example_works_id']) ? $filter['example_works_id'] : 0;
        $editData['start_works_id']       = isset($filter['start_works_id']) ? $filter['start_works_id'] : 0;

        $editData['lecture_excerpt']       = isset($filter['lecture_excerpt'])?$filter['lecture_excerpt']:'';

        


        return $lectureModel->save($editData,['id' => $id]);

    }


    public function editLectureCoordinate($filter = array())
    {
        $lectureModel = new ScratchLecturePostModel();

        $id                         = isset($filter['id']) ? $filter['id'] : 0;


        $editData['style_width']    = (isset($filter['style_width']) && $filter['style_width'] != '') ? $filter['style_width'] : '120';
        $editData['style_height']    = (isset($filter['style_height']) && $filter['style_height'] != '') ? $filter['style_height'] : '180';
        $editData['style_top']    = (isset($filter['style_top']) && $filter['style_top'] != '') ? $filter['style_top'] : 0;
        $editData['style_left']    = (isset($filter['style_left']) && $filter['style_left'] != '') ? $filter['style_left'] : 0;
        $editData['style_transform']    = isset($filter['style_transform']) ? $filter['style_transform'] : 0.6;
        $editData['style_background']    = (isset($filter['style_background']) && $filter['style_background'] != '') ? $filter['style_background'] : '/static/demo-img/1000.png';

        $editData['style']       = 'top: '.$editData['style_top'].'px;left: '.$editData['style_left'].'px;transform: scale('.$editData['style_transform'].');width: '.$editData['style_width'].'px;  height: '.$editData['style_height'].'px;background-image: url('.$editData['style_background'].');';

        


        return $lectureModel->save($editData,['id' => $id]);
    }



    public function delLecture($filter = array())
    {

        $lectureModel = new ScratchLecturePostModel();

        $id                         = isset($filter['id']) ? $filter['id'] : 0;

        
        return $lectureModel->destroy($id);

    }
    

}