<?php

namespace app\teacher\service;

use app\teacher\model\SchoolStudentPostModel;
use app\teacher\model\SchoolStudentContactsModel;
use app\teacher\model\SchoolPostModel;
use app\teacher\model\SchoolStudentContactsPostModel;
use app\teacher\model\SchoolClassesPostModel;
use app\teacher\model\SchoolClassesUserPostModel;



use think\Db;

class ScratchStudentService 
{


    /**
     * 学生查询
     * @param      $filter
     * @param bool $isPage
     * @return \think\Paginator
     * @throws \think\exception\DbException
     */
    // 二次查询。第一次查询主表，然后使用in 一次性查询相关的表详情，并组装出来。
    public function studentList($filter = array())
    {


        $studentModel = new SchoolStudentPostModel();
        $contactsModel = new SchoolStudentContactsModel();
        $schoolPostModel = new SchoolPostModel();
        
        $classesModel = new SchoolClassesPostModel();

        $where = [];
  
        $pageNo = 1;
        $pageSize = 20;

        if (!empty($filter['search'])) {
            $where['student_name'] = $filter['search'];
        }

        if (!empty($filter['sex']) && $filter['sex'] != 0) {
            $where['sex'] = $filter['sex'];
        }

        if (!empty($filter['school_id']) && $filter['school_id'] != 0) {
            $where['school_id'] = $filter['school_id'];
        }

        if (!empty($filter['classes_id']) && $filter['classes_id'] != 0) {
            $filterClasses = $classesModel
                ->alias('a')
                ->join([['__SCHOOL_CLASSES_USER_POST__ b', 'a.id = b.classes_id']])
                ->where('a.create_time', '>=', 0)
                ->where('a.delete_time', 0)
                ->where('a.status', 1)

                ->where('b.create_time', '>=', 0)
                ->where('b.delete_time', 0)
                ->where('b.status', 1)

                ->where('b.classes_id',$filter['classes_id'])
                ->where('b.user_type',2)
                ->field('a.id,b.user_id,a.classes_name')
                ->select()
                ->toArray();
            $classesIds = [];
            foreach ($filterClasses as $key => $value) {
                $classesIds[] = $value['user_id'];
            }

            $where['id'] = $classesIds;
        }

        if (!empty($filter['student_status']) && $filter['student_status'] != 0) {
            $where['student_status'] = $filter['student_status'];
        }

        if (!empty($filter['pageNo']) && $filter['pageNo'] != 0 && is_int($filter['pageNo'])) {
            $pageNo = $filter['pageNo'];
        }

        if (!empty($filter['pageSize']) && $filter['pageSize'] != 0 && $filter['pageSize'] <= 100) {
            $pageSize = $filter['pageSize'];
        }



        $field = '*';




        // 查询学生列表
        $students      = $studentModel
            ->where('create_time', '>=', 0)
            ->where('delete_time', 0)
            ->order('update_time', 'DESC')
            ->where('status', 1)
            ->where('user_id', '<>',0)
            ->where($where)
            ->field($field)
            ->paginate($pageSize)
            ->append(['status_text','sex_text','student_status_text'])
            ->toArray();

        $data = $students['data'];
        $ids = [];
        $schoolIds = [];
        foreach ($data as $key => $value) {
            $ids[] = $value['id'];
            $schoolIds[] = $value['school_id'];
        }


        // 查询已分页数据的联系方式（ in ）
        $classes = $classesModel
                ->alias('a')
                ->join([['__SCHOOL_CLASSES_USER_POST__ b', 'a.id = b.classes_id']])
                ->where('a.create_time', '>=', 0)
                ->where('a.delete_time', 0)
                ->where('a.status', 1)

                ->where('b.create_time', '>=', 0)
                ->where('b.delete_time', 0)
                ->where('b.status', 1)

                ->where('b.user_id','in',$ids)
                ->where('b.user_type',2)
                ->order('a.update_time', 'DESC')
                ->field('a.id,b.user_id,a.classes_name')
                ->select()
                ->toArray();
        // 查询已分页数据的联系方式（ in ）
        $contacts = $contactsModel
                ->alias('a')
                ->join([['__SCHOOL_STUDENT_CONTACTS_POST__ b', 'a.id = b.contacts_id']])
                ->where('a.create_time', '>=', 0)
                ->where('a.delete_time', 0)
                ->where('a.status', 1)

                ->where('b.create_time', '>=', 0)
                ->where('b.delete_time', 0)
                ->where('b.status', 1)

                ->where('b.student_id','in',$ids)
                ->order('a.update_time', 'DESC')
                ->field('a.mobile,b.student_id,b.relation_type')
                ->select()
                ->toArray();

        $school = $schoolPostModel
                ->where('id','in',$schoolIds)
                ->field('id,school_name')
                ->select()
                ->toArray();

        // 数据组装
        foreach ($data as $key => $value) {
            foreach ($contacts as $k => $v) {
                if ($value['id'] == $v['student_id']) {
                    $data[$key]['contacts'][] = $v;
                    unset($contacts[$k]);
                }
            }

            foreach ($classes as $k => $v) {
                if ($value['id'] == $v['user_id']) {
                    $data[$key]['classes_id'] = $v['id'];
                    $data[$key]['classes_name'] = $v['classes_name'];
                }
            }

            foreach ($school as $k => $v) {
                if ($value['school_id'] == $v['id']) {
                    $data[$key]['school_name'] = $v['school_name'];
                    $data[$key]['school_id'] = $v['id'];
                    
                }
            }

        }
        $students['data'] = $data;


        return $students;

    }


    public function addStudent($filter = array())
    {
        $studentModel = new SchoolStudentPostModel();
        $contactsModel = new SchoolStudentContactsModel();
        $studentContactsModel = new SchoolStudentContactsPostModel();

        $addData['student_number']    = isset($filter['student_number']) ? $filter['student_number'] : '';
        $addData['student_name']    = isset($filter['student_name']) ? $filter['student_name'] : '';
        $addData['sex']             = isset($filter['sex']) ? $filter['sex'] : 0;
        $addData['student_status']  = isset($filter['student_status']) ? $filter['student_status'] : 0;
        $addData['school_id']       = isset($filter['school_id']) ? $filter['school_id'] : 0;

        $classesId       = isset($filter['classes_id']) ? $filter['classes_id'] : 0;


        $addData['course_id']    = 2;
        


        $res = $studentModel->save($addData);
        $studentId = $studentModel->id;

        if ($classesId) {
            $SchoolClassesUserPostModel = new SchoolClassesUserPostModel();
            $SchoolClassesPostModel = new SchoolClassesPostModel();
            $SchoolClassesUserPostModel
                ->save([
                    'user_id'=>$studentId,
                    'classes_id'=>$classesId,
                    'user_type'=>2,
                    'user_duty'=>''
                ]);

            $count = $SchoolClassesUserPostModel
                ->where([
                    'classes_id'=>$classesId,
                    'user_type'=>2
                ])
                ->count();
            $SchoolClassesPostModel->save([
                'student_num'=>$count
            ],[
                'id'=>$classesId
            ]);
        }

        $userData = [
            'user_type' => 2,
            'sex' => $addData['sex'],
            'user_nickname' => $addData['student_name'],
            'user_login' => $addData['student_number'],
            'user_pass' => password(getOption('site_defaultValue','overall')['pass']),
            'avatar' => 'avatar/default/avatar_0.png',
            'mobile' => $filter['phone'][0],
        ];

        $userId = Db::name('user')->insertGetId($userData);

        $courseData[] = [
            'create_user_id'=>getUserId(),
            'create_time'=>time(),
            'update_time'=>time(),
            'status'=>1,
            'student_id'=>$studentId,
            'course_id'=>1
        ];
        $courseData[] = [
            'create_user_id'=>getUserId(),
            'create_time'=>time(),
            'update_time'=>time(),
            'status'=>1,
            'student_id'=>$studentId,
            'course_id'=>2
        ];

        Db::name('scratch_student_course')->insertAll($courseData);

        $studentModel->save([
                'user_id'=>$userId
            ],[
                'id'=>$studentId
            ]);

        if (isset($filter['phone'])) {
            foreach ($filter['phone'] as $key => $value) {
                if ($value != null) {
                    $contactsRes = $contactsModel::create([
                            'mobile'  =>  $value
                        ]);
                    $contactsId = $contactsRes->id;

                    $studentContacts['contacts_id']     = $contactsId;
                    $studentContacts['student_id']      = $studentId;
                    $studentContacts['relation_type']   = $filter['type'][$key];

                    $contactsRes = $studentContactsModel::create([
                            'contacts_id'  =>  $contactsId,
                            'student_id'  =>  $studentId,
                            'relation_type'  =>  $filter['type'][$key],
                        ]);

                } 
                
            }
        }


        return $res;

    }



    public function editStudent($filter = array())
    {

        $studentModel = new SchoolStudentPostModel();

        $id                         = isset($filter['id']) ? $filter['id'] : 0;

        $editData['student_name']   = isset($filter['student_name']) ? $filter['student_name'] : '';
        $editData['sex']            = isset($filter['sex']) ? $filter['sex'] : 0;
        $editData['student_status'] = isset($filter['student_status']) ? $filter['student_status'] : 0;
        $editData['school_id']      = isset($filter['school_id']) ? $filter['school_id'] : 0;

        $classesId       = isset($filter['classes_id']) ? $filter['classes_id'] : 0;

        if ($classesId) {
            $SchoolClassesUserPostModel = new SchoolClassesUserPostModel();
            $SchoolClassesPostModel = new SchoolClassesPostModel();

            $find = $SchoolClassesUserPostModel
                ->where([
                    'user_id'=>$id,
                    'user_type'=>2
                ])
                ->find();
            if ($find) {
                $SchoolClassesUserPostModel
                ->save([
                    'classes_id'=>$classesId
                ],[
                    'user_id'=>$id,
                    'user_type'=>2
                ]);
            } else {
                $SchoolClassesUserPostModel
                    ->save([
                        'user_id'=>$id,
                        'classes_id'=>$classesId,
                        'user_type'=>2,
                        'user_duty'=>''
                    ]);
            }

            $count = $SchoolClassesUserPostModel
                ->where([
                    'classes_id'=>$classesId,
                    'user_type'=>2
                ])
                ->count();
            $SchoolClassesPostModel->save([
                'student_num'=>$count
            ],[
                'id'=>$classesId
            ]);
            


            
        }

        return $studentModel->save($editData,['id' => $id]);

    }



    public function delStudent($filter = array())
    {

        $studentModel = new SchoolStudentPostModel();

        $id                         = isset($filter['id'])?$filter['id']:0;


        return $studentModel->destroy($id);

    }



    public function resetPassword($filter = array())
    {

        $studentModel = new SchoolStudentPostModel();

        $id           = isset($filter['id'])?$filter['id']:0;

        $find = $studentModel
                    ->where('id',$id)
                    ->find();
        $res = Db::name('user')
                    ->where('id',$find['user_id'])
                    ->update([
                        'user_pass'=>password(getOption('site_defaultValue','overall')['pass'])
                    ]);



        return $res;

    }

}