<?php

namespace app\teacher\service;
use think\db;
use app\teacher\model\UserModel;
use app\teacher\model\SchoolStudentPostModel;

use app\teacher\service\DeptService;
use app\teacher\service\PositionService;

class StaffService
{
    /**
     * 员工查询
     * @param      $filter
     * @param bool $isPage
     * @return \think\Paginator
     * @throws \think\exception\DbException
     */
    // 二次查询。第一次查询主表，然后使用in 一次性查询相关的表详情，并组装出来。
    public function getStaff($filter = array())
    {
  
        $pageNo = 1;
        $pageSize = 20;

        $where = [];

        if (!empty($filter['search'])) {
            $where['user_nickname'] = $filter['search'];
        }

        if (!empty($filter['sex']) && $filter['sex'] != 0) {
            $where['sex'] = $filter['sex'];
        }

        $deptWhere = [];
        
        $DeptService = new DeptService();

        if (!empty($filter['dept_id']) && $filter['dept_id'] != 0) {

            $dept_id = $filter['dept_id'];

            $deptArr = $DeptService->getDept();

            $dept_ids = getRecursionAllChildids($deptArr,$dept_id);

            $dept_ids[] = $dept_id;

            $deptWhere[] = ['dept_id', 'in', $dept_ids];
        }

        if (!empty($filter['student_status']) && $filter['student_status'] != 0) {
            $where['student_status'] = $filter['student_status'];
        }

        if (!empty($filter['pageNo']) && $filter['pageNo'] != 0 && is_int($filter['pageNo'])) {
            $pageNo = $filter['pageNo'];
        }

        if (!empty($filter['pageSize']) && $filter['pageSize'] != 0 && $filter['pageSize'] <= 100) {
            $pageSize = $filter['pageSize'];
        }

        $field = '*';

        $UserModel = new UserModel();

        // 查询员工列表
        $data      = $UserModel
            ->where('create_time', '>=', 0)
            ->where('delete_time', 0)
            ->order('update_time', 'DESC')
            ->where('status', 1)
            ->where('user_type', 1)
            ->where($where)
            ->where($deptWhere)
            ->field($field)
            ->paginate($pageSize)
            ->append(['status_text','sex_text'])
            ->toArray();
		//根据部门ID追加部门信息到输出
		$deptIds = [];
		$positionIds = [];
		foreach ($data['data'] as $key=>$value){
			$deptIds[] = $value['dept_id'];
			$positionIds[] = $value['position_id'];
		}
        
        $dept = $DeptService->getDeptById($deptIds);
        $PositionService = new PositionService();
		$position = $PositionService->getPositionById($positionIds);
		
		foreach ($data['data'] as $key=>$value){
			foreach ($dept as $k=>$v){
				if($value['dept_id'] == $v['id']){
					$data['data'][$key]['dept_name'] = $v['dept_name'];	//$v['dept_name']
				}
			}
			foreach ($position as $k=>$v){
				if($value['position_id'] == $v['id']){
					$data['data'][$key]['position_name'] = $v['position_name'];	//$v['position_name']
				}
			}
		}

        return $data;
    }



    public function addStaff($filter = array())
    {
        $UserModel = new UserModel();
        //手机号和登录账号判重
		if (!isset($filter['user_login']) || !isset($filter['mobile'])) {
			return ['code'=>0,'msg'=>'手机号或登录账号不能为空！'];
		}	
		$res1 = Db::name("user")->where('mobile', $filter['mobile'])->find();
		$res2 = Db::name("user")->where('user_login', $filter['user_login'])->find();
		if ($res1 ||$res2) {
    		return ['code'=>0,'msg'=>'手机号或登录账号已存在！'];
		}
        $addData['user_nickname']   = isset($filter['user_nickname']) ? $filter['user_nickname'] : '';
        $addData['user_login']            = isset($filter['user_login']) ? $filter['user_login'] : '';
        $addData['mobile']       = isset($filter['mobile']) ? $filter['mobile'] : '';
        $addData['position_id']            = isset($filter['position_id']) ? $filter['position_id'] : 0;
        $addData['user_pass']            = password(getOption('site_defaultvalue','overall')['pass']);
        $addData['user_status'] = isset($filter['user_status']) ? $filter['user_status'] : 0;
        $addData['dept_id'] = isset($filter['dept_id']) ? $filter['dept_id'] : 0;

        $res = $UserModel->save($addData);
        
        if ($res) {
			return ['code'=>1,'msg'=>'添加成功！'];
		} else {
			return ['code'=>0,'msg'=>'添加失败！'];
		}
        
        
    }
    //创建员工的学生登录账号
    public function addStaffStudentAcount($filter = array())
    {
        $StudentModel = new SchoolStudentPostModel();
        //手机号和登录账号判重
		if (!isset($filter['student_number']) || !isset($filter['student_name'])) {
			return ['code'=>0,'msg'=>'登录账号和姓名不能为空！'];
		}	
		$res = Db::name("school_student_post")->where('student_number', $filter['student_number'])->find();
		if ($res) {
    		return ['code'=>0,'msg'=>'登录账号已存在！'];
		}
        $addData['user_id']   = isset($filter['user_id']) ? $filter['user_id'] : 0;
        $addData['student_number']            = isset($filter['student_number']) ? $filter['student_number'] : '';
        $addData['student_name']       = isset($filter['student_name']) ? $filter['student_name'] : '';

        $res = $StudentModel->save($addData);
        
        if ($res) {
			return ['code'=>1,'msg'=>'添加成功！'];
		} else {
			return ['code'=>0,'msg'=>'添加失败！'];
		}
        
        
    }

    public function editStaff($filter = array())
    {

        $UserModel = new UserModel();
        $id                         = isset($filter['id']) ? $filter['id'] : 0;
        
       //手机号和登录账号判重
		if (!isset($filter['user_login']) || !isset($filter['mobile'])) {
			return ['code'=>0,'msg'=>'手机号或登录账号不能为空！'];
		}	
		$res1 = Db::name("user")->where('mobile', $filter['mobile'])->where('id','<>', $filter['id'])->find();
		$res2 = Db::name("user")->where('user_login', $filter['user_login'])->where('id','<>', $filter['id'])->find();
		if ($res1 ||$res2) {
    		return ['code'=>0,'msg'=>'手机号或登录账号已存在！'];
		}		

        $editData['user_nickname']   = isset($filter['user_nickname']) ? $filter['user_nickname'] : '';
        $editData['user_login']            = isset($filter['user_login']) ? $filter['user_login'] : '';
        $editData['mobile']            = isset($filter['mobile']) ? $filter['mobile'] : '';
        $editData['position_id']            = isset($filter['position_id']) ? $filter['position_id'] : 0;
        $editData['user_status'] = isset($filter['user_status']) ? $filter['user_status'] : 0;

        $res = $UserModel->save($editData,['id' => $id]);
        if ($res) {
			return ['code'=>1,'msg'=>'更新成功！'];
		} else {
			return ['code'=>0,'msg'=>'更新失败！'];
		} 

    }
    
    //删除员工
    public function deleteStaff($filter = array())
    {
        $UserModel = new UserModel();
        $id                         = isset($filter['id'])?$filter['id']:0;
        return $UserModel->destroy($id);
    }
    
    //员工重置密码
    public function resetPassword($filter = array())
    {

        $id           = isset($filter['id'])?$filter['id']:0;

        $res = Db::name('user')
                    ->where('id',$id)
                    ->update([
                        'user_pass'=>password(getOption('site_defaultvalue','overall')['pass'])
                    ]);

        return $res;
    }
    
    public function editStaffDept($filter = array())
    {
        $UserModel = new UserModel();

        $id                         = isset($filter['id']) ? $filter['id'] : 0;

        $editData['dept_id'] = isset($filter['dept_id']) ? $filter['dept_id'] : 0;


        return $UserModel->save($editData,['id' => $id]);
    }

}