<?php
/*
 * Copyright (c) 2017-2018 THL A29 Limited, a Tencent company. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
namespace TencentCloud\Sms\V20190711\Models;
use TencentCloud\Common\AbstractModel;

/**
 * DescribeSmsTemplateList返回参数结构体
 *
 * @method array getDescribeTemplateStatusSet() 获取获取短信签名信息响应
 * @method void setDescribeTemplateStatusSet(array $DescribeTemplateStatusSet) 设置获取短信签名信息响应
 * @method string getRequestId() 获取唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
 * @method void setRequestId(string $RequestId) 设置唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
 */
class DescribeSmsTemplateListResponse extends AbstractModel
{
    /**
     * @var array 获取短信签名信息响应
     */
    public $DescribeTemplateStatusSet;

    /**
     * @var string 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
     */
    public $RequestId;

    /**
     * @param array $DescribeTemplateStatusSet 获取短信签名信息响应
     * @param string $RequestId 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
     */
    function __construct()
    {

    }

    /**
     * For internal only. DO NOT USE IT.
     */
    public function deserialize($param)
    {
        if ($param === null) {
            return;
        }
        if (array_key_exists("DescribeTemplateStatusSet",$param) and $param["DescribeTemplateStatusSet"] !== null) {
            $this->DescribeTemplateStatusSet = [];
            foreach ($param["DescribeTemplateStatusSet"] as $key => $value){
                $obj = new DescribeTemplateListStatus();
                $obj->deserialize($value);
                array_push($this->DescribeTemplateStatusSet, $obj);
            }
        }

        if (array_key_exists("RequestId",$param) and $param["RequestId"] !== null) {
            $this->RequestId = $param["RequestId"];
        }
    }
}
