DROP TABLE IF EXISTS qb_sort;
CREATE TABLE `qb_sort` (
  `fid` mediumint(7) unsigned NOT NULL auto_increment,
  `fup` mediumint(7) unsigned NOT NULL default '0',
  `fmid` mediumint(5) NOT NULL default '0',
  `name` varchar(50) NOT NULL default '',
  `class` smallint(4) NOT NULL default '0',
  `sons` smallint(4) NOT NULL default '0',
  `type` tinyint(1) NOT NULL default '0',
  `admin` varchar(100) NOT NULL default '',
  `list` int(10) NOT NULL default '0',
  `listorder` tinyint(2) NOT NULL default '0',
  `passwd` varchar(32) NOT NULL default '',
  `logo` varchar(150) NOT NULL default '',
  `descrip` text NOT NULL,
  `style` varchar(50) NOT NULL default '',
  `template` text NOT NULL,
  `jumpurl` varchar(150) NOT NULL default '',
  `maxperpage` tinyint(3) NOT NULL default '0',
  `metakeywords` varchar(255) NOT NULL default '',
  `metadescription` varchar(255) NOT NULL default '',
  `allowcomment` tinyint(1) NOT NULL default '0',
  `allowpost` varchar(150) NOT NULL default '',
  `allowviewtitle` varchar(150) NOT NULL default '',
  `allowviewcontent` varchar(150) NOT NULL default '',
  `allowdownload` varchar(150) NOT NULL default '',
  `forbidshow` tinyint(1) NOT NULL default '0',
  `config` text NOT NULL,
  `list_html` varchar(255) NOT NULL default '',
  `bencandy_html` varchar(255) NOT NULL default '',
  `domain` varchar(150) NOT NULL default '',
  `domain_dir` varchar(100) NOT NULL default '',
  PRIMARY KEY  (`fid`),
  KEY `fup` (`fup`),
  KEY `fmid` (`fmid`)
) ENGINE=MyISAM AUTO_INCREMENT=43 DEFAULT CHARSET=gbk;


DROP TABLE IF EXISTS qb_article_db;
CREATE TABLE `qb_article_db` (
  `aid` int(10) NOT NULL auto_increment,
  PRIMARY KEY  (`aid`)
) ENGINE=MyISAM AUTO_INCREMENT=887 DEFAULT CHARSET=gbk;


DROP TABLE IF EXISTS qb_article;
CREATE TABLE `qb_article` (
  `aid` mediumint(7) unsigned NOT NULL auto_increment,
  `title` varchar(150) NOT NULL default '',
  `smalltitle` varchar(100) NOT NULL default '',
  `fid` mediumint(7) unsigned NOT NULL default '0',
  `mid` mediumint(5) NOT NULL default '0',
  `fname` varchar(50) NOT NULL default '',
  `hits` mediumint(7) NOT NULL default '0',
  `pages` smallint(4) NOT NULL default '0',
  `comments` mediumint(7) NOT NULL default '0',
  `posttime` int(10) NOT NULL default '0',
  `list` int(10) NOT NULL default '0',
  `uid` mediumint(7) NOT NULL default '0',
  `username` varchar(30) NOT NULL default '',
  `author` varchar(30) NOT NULL default '',
  `copyfrom` varchar(100) NOT NULL default '',
  `copyfromurl` varchar(150) NOT NULL default '',
  `titlecolor` varchar(15) NOT NULL default '',
  `fonttype` tinyint(1) NOT NULL default '0',
  `picurl` varchar(150) NOT NULL default '0',
  `ispic` tinyint(1) NOT NULL default '0',
  `yz` tinyint(1) NOT NULL default '0',
  `yzer` varchar(30) NOT NULL default '',
  `yztime` int(10) NOT NULL default '0',
  `levels` tinyint(2) NOT NULL default '0',
  `levelstime` int(10) NOT NULL default '0',
  `keywords` varchar(100) NOT NULL default '',
  `jumpurl` varchar(150) NOT NULL default '',
  `iframeurl` varchar(150) NOT NULL default '',
  `style` varchar(15) NOT NULL default '',
  `template` varchar(255) NOT NULL default '',
  `target` tinyint(1) NOT NULL default '0',
  `ip` varchar(15) NOT NULL default '',
  `lastfid` mediumint(7) NOT NULL default '0',
  `money` mediumint(7) NOT NULL default '0',
  `buyuser` text NOT NULL,
  `passwd` varchar(32) NOT NULL default '',
  `allowdown` varchar(150) NOT NULL default '',
  `allowview` varchar(150) NOT NULL default '',
  `editer` varchar(30) NOT NULL default '',
  `edittime` int(10) NOT NULL default '0',
  `begintime` int(10) NOT NULL default '0',
  `endtime` int(10) NOT NULL default '0',
  `description` text NOT NULL,
  `lastview` int(10) NOT NULL default '0',
  `digg_num` mediumint(7) NOT NULL default '0',
  `digg_time` int(10) NOT NULL default '0',
  `forbidcomment` tinyint(1) NOT NULL default '0',
  `ifvote` tinyint(1) NOT NULL default '0',
  `heart` varchar(255) NOT NULL default '',
  `htmlname` varchar(100) NOT NULL default '',
  PRIMARY KEY  (`aid`),
  KEY `fid` (`fid`),
  KEY `hits` (`hits`,`yz`,`fid`,`ispic`),
  KEY `lastview` (`yz`,`lastview`,`fid`,`ispic`),
  KEY `list` (`list`,`yz`,`fid`,`ispic`),
  KEY `ispic` (`ispic`),
  KEY `uid` (`uid`),
  KEY `levels` (`levels`),
  KEY `digg_num` (`digg_num`),
  KEY `digg_time` (`digg_time`),
  KEY `mid` (`mid`)
) ENGINE=MyISAM AUTO_INCREMENT=887 DEFAULT CHARSET=gbk;


DROP TABLE IF EXISTS qb_reply;
CREATE TABLE `qb_reply` (
  `rid` mediumint(7) NOT NULL auto_increment,
  `subhead` varchar(150) NOT NULL default '',
  `postdate` int(10) NOT NULL default '0',
  `aid` mediumint(7) NOT NULL default '0',
  `fid` mediumint(7) NOT NULL default '0',
  `uid` mediumint(7) NOT NULL default '0',
  `topic` tinyint(1) NOT NULL default '0',
  `content` mediumtext NOT NULL,
  `orderid` mediumint(7) NOT NULL default '0',
  PRIMARY KEY  (`rid`),
  KEY `aid` (`aid`,`topic`)
) ENGINE=MyISAM AUTO_INCREMENT=868 DEFAULT CHARSET=gbk;


DROP TABLE IF EXISTS qb_article_content_100;
CREATE TABLE `qb_article_content_100` (
  `id` mediumint(7) NOT NULL auto_increment,
  `aid` mediumint(7) NOT NULL default '0',
  `rid` mediumint(7) NOT NULL default '0',
  `fid` mediumint(7) NOT NULL default '0',
  `uid` mediumint(7) NOT NULL default '0',
  `photourl` mediumtext NOT NULL,
  PRIMARY KEY  (`id`),
  KEY `fid` (`fid`),
  KEY `uid` (`uid`),
  KEY `aid` (`aid`)
) ENGINE=MyISAM AUTO_INCREMENT=17 DEFAULT CHARSET=gbk;


DROP TABLE IF EXISTS qb_article_content_101;
CREATE TABLE `qb_article_content_101` (
  `id` mediumint(7) NOT NULL auto_increment,
  `aid` mediumint(7) NOT NULL default '0',
  `rid` mediumint(7) NOT NULL default '0',
  `fid` mediumint(7) NOT NULL default '0',
  `uid` mediumint(7) NOT NULL default '0',
  `day_hits` mediumint(7) NOT NULL default '0',
  `week_hits` mediumint(7) NOT NULL default '0',
  `month_hits` mediumint(7) NOT NULL default '0',
  `total_hits` mediumint(7) NOT NULL default '0',
  `hits_time` int(10) NOT NULL default '0',
  `hits_user` text NOT NULL,
  `my_author` varchar(30) NOT NULL default '',
  `my_copyfromurl` varchar(150) NOT NULL default '',
  `my_demo` varchar(150) NOT NULL default '',
  `operatingsystem` varchar(150) NOT NULL default '',
  `softlanguage` varchar(30) NOT NULL default '',
  `copyright` varchar(30) NOT NULL default '',
  `softsize` varchar(20) NOT NULL default '',
  `softurl` mediumtext NOT NULL,
  PRIMARY KEY  (`id`),
  KEY `fid` (`fid`),
  KEY `uid` (`uid`),
  KEY `aid` (`aid`)
) ENGINE=MyISAM AUTO_INCREMENT=35 DEFAULT CHARSET=gbk;


DROP TABLE IF EXISTS qb_article_content_102;
CREATE TABLE `qb_article_content_102` (
  `id` mediumint(7) NOT NULL auto_increment,
  `aid` mediumint(7) NOT NULL default '0',
  `rid` mediumint(7) NOT NULL default '0',
  `fid` mediumint(7) NOT NULL default '0',
  `uid` mediumint(7) NOT NULL default '0',
  `day_hits` mediumint(7) NOT NULL default '0',
  `week_hits` mediumint(7) NOT NULL default '0',
  `month_hits` mediumint(7) NOT NULL default '0',
  `total_hits` mediumint(7) NOT NULL default '0',
  `hits_time` int(10) NOT NULL default '0',
  `hits_user` text NOT NULL,
  `mvurl` mediumtext NOT NULL,
  `my_role` varchar(100) NOT NULL default '',
  `my_lang` varchar(20) NOT NULL default '',
  PRIMARY KEY  (`id`),
  KEY `fid` (`fid`),
  KEY `uid` (`uid`),
  KEY `aid` (`aid`)
) ENGINE=MyISAM AUTO_INCREMENT=29 DEFAULT CHARSET=gbk;


DROP TABLE IF EXISTS qb_article_module;
CREATE TABLE `qb_article_module` (
  `id` smallint(4) NOT NULL auto_increment,
  `name` varchar(50) NOT NULL default '',
  `alias` varchar(30) NOT NULL default '',
  `list` smallint(4) NOT NULL default '0',
  `allowpost` varchar(255) NOT NULL default '',
  `style` varchar(30) NOT NULL default '',
  `template` varchar(255) NOT NULL default '',
  `config` mediumtext NOT NULL,
  `keywords` varchar(30) NOT NULL default '',
  `ifclose` tinyint(1) NOT NULL default '0',
  `iftable` mediumint(4) NOT NULL default '0',
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=106 DEFAULT CHARSET=gbk;


DROP TABLE IF EXISTS qb_members;
CREATE TABLE `qb_members` (
  `uid` mediumint(7) unsigned NOT NULL auto_increment,
  `username` varchar(30) NOT NULL default '',
  `password` varchar(32) NOT NULL default '',
  PRIMARY KEY  (`uid`),
  KEY `username` (`username`)
) ENGINE=MyISAM AUTO_INCREMENT=39 DEFAULT CHARSET=gbk;


DROP TABLE IF EXISTS qb_memberdata;
CREATE TABLE `qb_memberdata` (
  `uid` mediumint(7) unsigned NOT NULL default '0',
  `username` varchar(50) NOT NULL default '',
  `qq_api` varchar(32) NOT NULL default '',
  `weixin_api` varchar(32) NOT NULL default '',
  `question` varchar(32) NOT NULL default '',
  `groupid` smallint(4) NOT NULL default '0',
  `grouptype` tinyint(1) NOT NULL default '0',
  `groups` varchar(255) NOT NULL default '',
  `yz` tinyint(1) NOT NULL default '0',
  `newpm` tinyint(1) NOT NULL default '0',
  `medals` varchar(255) NOT NULL default '',
  `money` mediumint(7) unsigned NOT NULL default '0',
  `totalspace` bigint(13) NOT NULL default '0',
  `usespace` bigint(13) NOT NULL default '0',
  `oltime` int(10) NOT NULL default '0',
  `lastvist` int(10) NOT NULL default '0',
  `lastip` varchar(15) NOT NULL default '',
  `regdate` int(10) NOT NULL default '0',
  `regip` varchar(15) NOT NULL default '',
  `sex` tinyint(1) NOT NULL default '0',
  `bday` date NOT NULL default '0000-00-00',
  `icon` varchar(150) NOT NULL default '',
  `introduce` text NOT NULL,
  `hits` int(7) NOT NULL default '0',
  `lastview` int(10) NOT NULL default '0',
  `oicq` varchar(11) NOT NULL default '',
  `msn` varchar(50) NOT NULL default '',
  `homepage` varchar(150) NOT NULL default '',
  `email` varchar(50) NOT NULL default '',
  `provinceid` mediumint(6) NOT NULL default '0',
  `cityid` mediumint(7) NOT NULL default '0',
  `address` varchar(255) NOT NULL default '',
  `postalcode` varchar(6) NOT NULL default '',
  `mobphone` varchar(12) NOT NULL default '',
  `telephone` varchar(25) NOT NULL default '',
  `idcard` varchar(20) NOT NULL default '',
  `truename` varchar(20) NOT NULL default '',
  `config` text NOT NULL,
  `moneycard` mediumint(7) unsigned NOT NULL default '0',
  `email_yz` tinyint(1) NOT NULL default '0',
  `mob_yz` tinyint(1) NOT NULL default '0',
  `idcard_yz` tinyint(1) NOT NULL default '0',
  `rmb` decimal(10,2) NOT NULL default '0.00',
  `rmb_freeze` decimal(10,2) NOT NULL default '0.00',
  `rmb_pwd` varchar(32) NOT NULL default '',
  `sendmsg` text NOT NULL,
  `wx_attention` tinyint(1) NOT NULL,
  PRIMARY KEY  (`uid`),
  KEY `groups` (`groups`),
  KEY `sex` (`sex`,`bday`,`cityid`),
  KEY `qq_api` (`qq_api`),
  KEY `username` (`username`)
) ENGINE=MyISAM DEFAULT CHARSET=gbk;


DROP TABLE IF EXISTS qb_group;
CREATE TABLE `qb_group` (
  `gid` smallint(4) NOT NULL auto_increment,
  `gptype` tinyint(1) NOT NULL default '0',
  `grouptitle` varchar(50) NOT NULL default '',
  `levelnum` mediumint(7) NOT NULL default '0',
  `totalspace` int(10) NOT NULL default '0',
  `allowsearch` tinyint(1) NOT NULL default '0',
  `powerdb` text NOT NULL,
  `allowadmin` tinyint(1) NOT NULL default '0',
  `allowadmindb` text,
  PRIMARY KEY  (`gid`)
) ENGINE=MyISAM AUTO_INCREMENT=11 DEFAULT CHARSET=gbk;


DROP TABLE IF EXISTS qb_menu;
CREATE TABLE `qb_menu` (
  `id` mediumint(5) NOT NULL auto_increment,
  `fid` mediumint(5) NOT NULL default '0',
  `name` varchar(80) NOT NULL default '',
  `linkurl` varchar(150) NOT NULL default '',
  `color` varchar(15) NOT NULL default '',
  `target` tinyint(1) NOT NULL default '0',
  `moduleid` tinyint(2) NOT NULL default '0',
  `type` tinyint(2) NOT NULL default '0',
  `hide` tinyint(1) NOT NULL default '0',
  `list` smallint(4) NOT NULL default '0',
  `extend` varchar(30) NOT NULL default '',
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=93 DEFAULT CHARSET=gbk;


DROP TABLE IF EXISTS qb_admin_menu;
CREATE TABLE `qb_admin_menu` (
  `id` mediumint(5) NOT NULL auto_increment,
  `fid` mediumint(5) NOT NULL default '0',
  `name` text NOT NULL,
  `linkurl` varchar(150) NOT NULL default '',
  `color` varchar(15) NOT NULL default '',
  `target` tinyint(1) NOT NULL default '0',
  `list` smallint(4) NOT NULL default '0',
  `groupid` mediumint(5) NOT NULL default '0',
  `iftier` tinyint(1) NOT NULL default '0',
  `ifcompany` tinyint(1) NOT NULL default '0',
  PRIMARY KEY  (`id`),
  KEY `groupid` (`groupid`)
) ENGINE=MyISAM AUTO_INCREMENT=175 DEFAULT CHARSET=gbk;


DROP TABLE IF EXISTS qb_module;
CREATE TABLE `qb_module` (
  `id` mediumint(5) NOT NULL auto_increment,
  `type` tinyint(1) NOT NULL default '0',
  `name` varchar(30) NOT NULL default '',
  `pre` varchar(20) NOT NULL default '',
  `dirname` varchar(30) NOT NULL default '',
  `domain` varchar(100) NOT NULL default '',
  `admindir` varchar(20) NOT NULL default '',
  `config` text NOT NULL,
  `list` mediumint(5) NOT NULL default '0',
  `admingroup` varchar(150) NOT NULL default '',
  `adminmember` text NOT NULL,
  `ifclose` tinyint(1) NOT NULL default '0',
  `ifsys` tinyint(1) NOT NULL default '0',
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=57 DEFAULT CHARSET=gbk;


DROP TABLE IF EXISTS qb_fu_article;
CREATE TABLE `qb_fu_article` (
  `fid` int(7) NOT NULL default '0',
  `aid` int(10) NOT NULL default '0',
  KEY `fid` (`fid`),
  KEY `aid` (`aid`)
) ENGINE=MyISAM DEFAULT CHARSET=gbk;


DROP TABLE IF EXISTS qb_fu_sort;
CREATE TABLE `qb_fu_sort` (
  `fid` mediumint(7) unsigned NOT NULL auto_increment,
  `fup` mediumint(7) unsigned NOT NULL default '0',
  `fmid` mediumint(5) NOT NULL default '0',
  `name` varchar(50) NOT NULL default '',
  `class` smallint(4) NOT NULL default '0',
  `sons` smallint(4) NOT NULL default '0',
  `type` tinyint(1) NOT NULL default '0',
  `admin` varchar(100) NOT NULL default '',
  `list` int(10) NOT NULL default '0',
  `listorder` tinyint(2) NOT NULL default '0',
  `passwd` varchar(32) NOT NULL default '',
  `logo` varchar(150) NOT NULL default '',
  `descrip` text NOT NULL,
  `style` varchar(50) NOT NULL default '',
  `template` text NOT NULL,
  `jumpurl` varchar(150) NOT NULL default '',
  `maxperpage` tinyint(3) NOT NULL default '0',
  `metakeywords` varchar(255) NOT NULL default '',
  `metadescription` varchar(255) NOT NULL default '',
  `allowcomment` tinyint(1) NOT NULL default '0',
  `allowpost` varchar(150) NOT NULL default '',
  `allowviewtitle` varchar(150) NOT NULL default '',
  `allowviewcontent` varchar(150) NOT NULL default '',
  `allowdownload` varchar(150) NOT NULL default '',
  `forbidshow` tinyint(1) NOT NULL default '0',
  `config` text NOT NULL,
  `list_html` varchar(255) NOT NULL default '',
  `bencandy_html` varchar(255) NOT NULL default '',
  `domain` varchar(150) NOT NULL default '',
  `domain_dir` varchar(100) NOT NULL default '',
  PRIMARY KEY  (`fid`),
  KEY `fup` (`fup`),
  KEY `fmid` (`fmid`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=gbk;


DROP TABLE IF EXISTS qb_special;
CREATE TABLE `qb_special` (
  `id` mediumint(7) NOT NULL auto_increment,
  `fid` mediumint(7) NOT NULL default '0',
  `title` varchar(150) NOT NULL default '',
  `titlecolor` varchar(15) NOT NULL default '',
  `keywords` varchar(100) NOT NULL default '',
  `style` varchar(25) NOT NULL default '',
  `template` varchar(255) NOT NULL default '',
  `picurl` varchar(150) NOT NULL default '',
  `content` mediumtext NOT NULL,
  `aids` text NOT NULL,
  `tids` text NOT NULL,
  `jumpurl` varchar(150) NOT NULL default '',
  `target` tinyint(1) NOT NULL default '0',
  `uid` mediumint(7) NOT NULL default '0',
  `username` varchar(50) NOT NULL default '',
  `posttime` int(10) NOT NULL default '0',
  `list` int(10) NOT NULL default '0',
  `hits` mediumint(7) NOT NULL default '0',
  `lastview` int(10) NOT NULL default '0',
  `levels` tinyint(1) NOT NULL default '0',
  `levelstime` int(10) NOT NULL default '0',
  `htmlfile` varchar(50) NOT NULL default '',
  `banner` varchar(150) NOT NULL default '',
  `allowpost` varchar(255) NOT NULL default '',
  `ifbase` tinyint(1) NOT NULL default '0',
  `htmlname` varchar(80) NOT NULL default '',
  `yz` tinyint(1) NOT NULL default '0',
  PRIMARY KEY  (`id`),
  KEY `fid` (`fid`),
  KEY `ifbase` (`ifbase`),
  KEY `yz` (`yz`)
) ENGINE=MyISAM AUTO_INCREMENT=25 DEFAULT CHARSET=gbk;


DROP TABLE IF EXISTS qb_special_comment;
CREATE TABLE `qb_special_comment` (
  `id` mediumint(7) unsigned NOT NULL auto_increment,
  `cid` mediumint(7) unsigned NOT NULL default '0',
  `vid` mediumint(7) NOT NULL default '0',
  `uid` mediumint(7) unsigned NOT NULL default '0',
  `username` varchar(30) NOT NULL default '',
  `posttime` int(10) NOT NULL default '0',
  `content` text NOT NULL,
  `ip` varchar(15) NOT NULL default '',
  `icon` tinyint(3) NOT NULL default '0',
  `yz` tinyint(1) NOT NULL default '0',
  PRIMARY KEY  (`id`),
  KEY `aid` (`cid`),
  KEY `uid` (`uid`)
) ENGINE=MyISAM DEFAULT CHARSET=gbk;


DROP TABLE IF EXISTS qb_spsort;
CREATE TABLE `qb_spsort` (
  `fid` mediumint(7) unsigned NOT NULL auto_increment,
  `fup` mediumint(7) unsigned NOT NULL default '0',
  `name` varchar(200) NOT NULL default '',
  `class` smallint(4) NOT NULL default '0',
  `sons` smallint(4) NOT NULL default '0',
  `type` tinyint(1) NOT NULL default '0',
  `admin` varchar(100) NOT NULL default '',
  `list` int(10) NOT NULL default '0',
  `listorder` tinyint(2) NOT NULL default '0',
  `passwd` varchar(32) NOT NULL default '',
  `logo` varchar(150) NOT NULL default '',
  `descrip` text NOT NULL,
  `style` varchar(50) NOT NULL default '',
  `template` text NOT NULL,
  `jumpurl` varchar(150) NOT NULL default '',
  `maxperpage` tinyint(3) NOT NULL default '0',
  `metakeywords` varchar(255) NOT NULL default '',
  `metadescription` varchar(255) NOT NULL default '',
  `allowcomment` tinyint(1) NOT NULL default '0',
  `allowpost` varchar(150) NOT NULL default '',
  `allowviewtitle` varchar(150) NOT NULL default '',
  `allowviewcontent` varchar(150) NOT NULL default '',
  `allowdownload` varchar(150) NOT NULL default '',
  `forbidshow` tinyint(1) NOT NULL default '0',
  `config` text NOT NULL,
  `list_html` varchar(255) NOT NULL default '',
  `bencandy_html` varchar(255) NOT NULL default '',
  PRIMARY KEY  (`fid`),
  KEY `fup` (`fup`)
) ENGINE=MyISAM AUTO_INCREMENT=4 DEFAULT CHARSET=gbk;


DROP TABLE IF EXISTS qb_alonepage;
CREATE TABLE `qb_alonepage` (
  `id` mediumint(5) NOT NULL auto_increment,
  `fid` mediumint(5) NOT NULL default '0',
  `name` varchar(100) NOT NULL default '',
  `title` varchar(100) NOT NULL default '',
  `posttime` int(10) NOT NULL default '0',
  `uid` mediumint(7) NOT NULL default '0',
  `username` varchar(30) NOT NULL default '',
  `style` varchar(15) NOT NULL default '',
  `tpl_head` varchar(50) NOT NULL default '',
  `tpl_main` varchar(50) NOT NULL default '',
  `tpl_foot` varchar(50) NOT NULL default '',
  `filename` varchar(100) default NULL,
  `filepath` varchar(30) NOT NULL default '',
  `descrip` text NOT NULL,
  `keywords` varchar(255) NOT NULL default '',
  `content` text NOT NULL,
  `hits` int(7) NOT NULL default '0',
  `ishtml` tinyint(1) NOT NULL default '0',
  `ifclose` tinyint(1) NOT NULL default '0',
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=9 DEFAULT CHARSET=gbk;


DROP TABLE IF EXISTS qb_channel;
CREATE TABLE `qb_channel` (
  `id` smallint(4) NOT NULL auto_increment,
  `type` tinyint(2) NOT NULL default '0',
  `sort` smallint(4) NOT NULL default '0',
  `name` varchar(30) NOT NULL default '',
  `path` varchar(30) NOT NULL default '',
  `phpname` varchar(255) NOT NULL default '',
  `htmlname` varchar(255) NOT NULL default '',
  `fids` varchar(255) NOT NULL default '',
  `showfid` varchar(150) NOT NULL default '',
  `style` varchar(15) NOT NULL default '',
  `head_tpl` varchar(255) NOT NULL default '',
  `main_tpl` varchar(255) NOT NULL default '',
  `foot_tpl` varchar(255) NOT NULL default '',
  `url` varchar(150) NOT NULL default '',
  `logo` varchar(150) NOT NULL default '',
  `descrip` text NOT NULL,
  `admin` varchar(150) NOT NULL default '',
  `list` int(10) NOT NULL default '0',
  `config` text NOT NULL,
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=gbk;


DROP TABLE IF EXISTS qb_collection;
CREATE TABLE `qb_collection` (
  `id` mediumint(7) NOT NULL auto_increment,
  `aid` int(10) NOT NULL default '0',
  `uid` mediumint(7) NOT NULL default '0',
  `posttime` int(10) NOT NULL default '0',
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=gbk;


DROP TABLE IF EXISTS qb_comment;
CREATE TABLE `qb_comment` (
  `cid` mediumint(7) unsigned NOT NULL auto_increment,
  `aid` int(10) unsigned NOT NULL default '0',
  `fid` mediumint(7) unsigned NOT NULL default '0',
  `authorid` mediumint(7) NOT NULL default '0',
  `uid` mediumint(7) unsigned NOT NULL default '0',
  `username` varchar(30) NOT NULL default '',
  `posttime` int(10) NOT NULL default '0',
  `content` text NOT NULL,
  `ip` varchar(15) NOT NULL default '',
  `icon` tinyint(3) NOT NULL default '0',
  `yz` tinyint(1) NOT NULL default '0',
  `ifcom` tinyint(1) NOT NULL default '0',
  `agree` mediumint(5) NOT NULL default '0',
  `disagree` mediumint(5) NOT NULL default '0',
  `quoteid` int(10) NOT NULL,
  PRIMARY KEY  (`cid`),
  KEY `aid` (`aid`),
  KEY `fid` (`fid`),
  KEY `uid` (`uid`),
  KEY `ifcom` (`ifcom`)
) ENGINE=MyISAM AUTO_INCREMENT=4 DEFAULT CHARSET=gbk;


DROP TABLE IF EXISTS qb_config;
CREATE TABLE `qb_config` (
  `c_key` varchar(50) NOT NULL default '',
  `c_value` text NOT NULL,
  `c_descrip` text NOT NULL,
  PRIMARY KEY  (`c_key`)
) ENGINE=MyISAM DEFAULT CHARSET=gbk;


DROP TABLE IF EXISTS qb_copyfrom;
CREATE TABLE `qb_copyfrom` (
  `id` mediumint(5) NOT NULL auto_increment,
  `name` varchar(40) NOT NULL default '',
  `list` int(10) NOT NULL default '0',
  `uid` mediumint(7) NOT NULL default '0',
  PRIMARY KEY  (`id`),
  KEY `keywords` (`name`)
) ENGINE=MyISAM DEFAULT CHARSET=gbk;


DROP TABLE IF EXISTS qb_hack;
CREATE TABLE `qb_hack` (
  `keywords` varchar(30) NOT NULL default '',
  `name` varchar(30) NOT NULL default '',
  `isclose` tinyint(1) NOT NULL default '0',
  `author` varchar(30) NOT NULL default '',
  `config` text NOT NULL,
  `htmlcode` text NOT NULL,
  `hackfile` text NOT NULL,
  `hacksqltable` text NOT NULL,
  `adminurl` varchar(150) NOT NULL default '',
  `about` text NOT NULL,
  `class1` varchar(30) NOT NULL default '',
  `class2` varchar(30) NOT NULL default '',
  `list` int(10) NOT NULL default '0',
  `linkname` text NOT NULL,
  `isbiz` tinyint(1) NOT NULL default '0',
  UNIQUE KEY `keywords` (`keywords`)
) ENGINE=MyISAM DEFAULT CHARSET=gbk;


DROP TABLE IF EXISTS qb_label;
CREATE TABLE `qb_label` (
  `lid` int(10) NOT NULL auto_increment,
  `name` varchar(100) NOT NULL default '',
  `ch` smallint(4) NOT NULL default '0',
  `chtype` tinyint(2) NOT NULL default '0',
  `tag` varchar(255) NOT NULL default '',
  `type` varchar(30) NOT NULL default '',
  `typesystem` tinyint(1) NOT NULL default '0',
  `code` text NOT NULL,
  `divcode` text,
  `hide` tinyint(1) NOT NULL default '0',
  `js_time` int(10) NOT NULL default '0',
  `uid` mediumint(7) NOT NULL default '0',
  `username` varchar(30) NOT NULL default '',
  `posttime` int(10) NOT NULL default '0',
  `pagetype` tinyint(3) NOT NULL default '0',
  `module` mediumint(6) NOT NULL default '0',
  `fid` mediumint(7) NOT NULL default '0',
  `if_js` tinyint(1) NOT NULL default '0',
  `style` varchar(40) NOT NULL default '',
  PRIMARY KEY  (`lid`),
  KEY `ch` (`ch`,`pagetype`,`module`,`fid`,`chtype`),
  KEY `tag` (`tag`)
) ENGINE=MyISAM AUTO_INCREMENT=180 DEFAULT CHARSET=gbk;


DROP TABLE IF EXISTS qb_form_config;
CREATE TABLE `qb_form_config` (
  `c_key` varchar(50) NOT NULL default '',
  `c_value` text NOT NULL,
  `c_descrip` text NOT NULL,
  PRIMARY KEY  (`c_key`)
) ENGINE=MyISAM DEFAULT CHARSET=gbk;


DROP TABLE IF EXISTS qb_form_content;
CREATE TABLE `qb_form_content` (
  `id` mediumint(7) NOT NULL auto_increment,
  `title` varchar(100) NOT NULL default '',
  `mid` smallint(4) NOT NULL default '0',
  `hits` mediumint(7) NOT NULL default '0',
  `posttime` int(10) NOT NULL default '0',
  `list` varchar(10) NOT NULL default '',
  `uid` mediumint(7) NOT NULL default '0',
  `username` varchar(30) NOT NULL default '',
  `titlecolor` varchar(15) NOT NULL default '',
  `yz` tinyint(1) NOT NULL default '0',
  `ip` varchar(15) NOT NULL default '',
  PRIMARY KEY  (`id`),
  KEY `hits` (`hits`,`yz`),
  KEY `list` (`list`,`yz`)
) ENGINE=MyISAM AUTO_INCREMENT=32 DEFAULT CHARSET=gbk;


DROP TABLE IF EXISTS qb_form_content_1;
CREATE TABLE `qb_form_content_1` (
  `id` mediumint(7) unsigned NOT NULL default '0',
  `uid` mediumint(7) NOT NULL default '0',
  `truename` varchar(20) NOT NULL default '',
  `sex` int(1) NOT NULL default '0',
  `oicq` varchar(10) NOT NULL default '',
  `mobphone` varchar(11) NOT NULL default '',
  `interest` mediumtext NOT NULL,
  `introduce` mediumtext NOT NULL,
  `sortname` varchar(40) NOT NULL default '',
  `webtime` int(10) NOT NULL default '0',
  PRIMARY KEY  (`id`),
  KEY `uid` (`uid`)
) ENGINE=MyISAM DEFAULT CHARSET=gbk;


DROP TABLE IF EXISTS qb_form_content_2;
CREATE TABLE `qb_form_content_2` (
  `id` mediumint(7) NOT NULL auto_increment,
  `uid` mediumint(7) NOT NULL default '0',
  `workplace` varchar(100) NOT NULL default '',
  `nums` varchar(10) NOT NULL default '',
  `jobrequire` mediumtext NOT NULL,
  `workwhere` varchar(50) NOT NULL default '',
  `wage` varchar(30) NOT NULL default '',
  `asksex` int(1) NOT NULL default '0',
  `schoo_age` varchar(20) NOT NULL default '',
  `wageyear` varchar(12) NOT NULL default '',
  PRIMARY KEY  (`id`),
  KEY `uid` (`uid`)
) ENGINE=MyISAM AUTO_INCREMENT=32 DEFAULT CHARSET=gbk;


DROP TABLE IF EXISTS qb_form_content_3;
CREATE TABLE `qb_form_content_3` (
  `id` mediumint(7) NOT NULL auto_increment,
  `uid` mediumint(7) NOT NULL default '0',
  `advicetype` varchar(30) NOT NULL default '',
  `content` mediumtext NOT NULL,
  `truename` varchar(15) NOT NULL default '',
  `email` varchar(50) NOT NULL default '',
  `mobphone` varchar(25) NOT NULL default '',
  PRIMARY KEY  (`id`),
  KEY `uid` (`uid`)
) ENGINE=MyISAM AUTO_INCREMENT=28 DEFAULT CHARSET=gbk;


DROP TABLE IF EXISTS qb_form_content_4;
CREATE TABLE `qb_form_content_4` (
  `id` mediumint(7) NOT NULL auto_increment,
  `uid` mediumint(7) NOT NULL default '0',
  `truename` varchar(15) NOT NULL default '',
  `sex` int(1) NOT NULL default '0',
  `age` int(2) NOT NULL default '0',
  `mobphone` varchar(25) NOT NULL default '',
  `metier` varchar(30) NOT NULL default '',
  `my_song` varchar(50) NOT NULL default '',
  PRIMARY KEY  (`id`),
  KEY `uid` (`uid`)
) ENGINE=MyISAM DEFAULT CHARSET=gbk;


DROP TABLE IF EXISTS qb_form_content_5;
CREATE TABLE `qb_form_content_5` (
  `id` mediumint(7) NOT NULL auto_increment,
  `uid` mediumint(7) NOT NULL default '0',
  `content` mediumtext NOT NULL,
  `bday` varchar(25) NOT NULL default '',
  `school_age` varchar(20) NOT NULL default '',
  `native` varchar(30) NOT NULL default '',
  `specialty` varchar(40) NOT NULL default '',
  `skill` varchar(50) NOT NULL default '',
  `sport` varchar(80) NOT NULL default '',
  `height` int(3) NOT NULL default '0',
  `truename` varchar(15) NOT NULL default '',
  `oicq` varchar(10) NOT NULL default '',
  `email` varchar(50) NOT NULL default '',
  `mobphone` varchar(11) NOT NULL default '',
  `address` varchar(150) NOT NULL default '',
  `telephone` varchar(15) NOT NULL default '',
  `idcard` varchar(18) NOT NULL default '',
  `cp_title` varchar(50) NOT NULL default '',
  PRIMARY KEY  (`id`),
  KEY `uid` (`uid`)
) ENGINE=MyISAM AUTO_INCREMENT=20 DEFAULT CHARSET=gbk;


DROP TABLE IF EXISTS qb_form_content_6;
CREATE TABLE `qb_form_content_6` (
  `id` mediumint(7) NOT NULL auto_increment,
  `uid` mediumint(7) NOT NULL default '0',
  `workposition` varchar(50) NOT NULL default '',
  `experience` mediumtext NOT NULL,
  `workyear` int(2) NOT NULL default '0',
  `truename` varchar(15) NOT NULL default '',
  `schoo_age` varchar(15) NOT NULL default '',
  `myage` int(2) NOT NULL default '0',
  `graduateschool` varchar(40) NOT NULL default '',
  `specialty` varchar(50) NOT NULL default '',
  `skill` varchar(50) NOT NULL default '',
  `sex` int(1) NOT NULL default '0',
  `telephone` varchar(25) NOT NULL default '',
  `wage` varchar(20) NOT NULL default '',
  `address` varchar(255) NOT NULL default '',
  `email` varchar(50) NOT NULL default '',
  `oicq` varchar(11) NOT NULL default '',
  `worktime` varchar(15) NOT NULL default '',
  PRIMARY KEY  (`id`),
  KEY `uid` (`uid`)
) ENGINE=MyISAM AUTO_INCREMENT=27 DEFAULT CHARSET=gbk;


DROP TABLE IF EXISTS qb_form_content_7;
CREATE TABLE `qb_form_content_7` (
  `id` mediumint(7) NOT NULL auto_increment,
  `uid` mediumint(7) NOT NULL default '0',
  `product` varchar(50) NOT NULL default '',
  `paymoney` varchar(15) NOT NULL default '',
  `paytime` varchar(15) NOT NULL default '',
  `paytype` varchar(25) NOT NULL default '',
  `sendbank` varchar(30) NOT NULL default '',
  `receivebank` varchar(30) NOT NULL default '',
  `truename` varchar(15) NOT NULL default '',
  `oicq` varchar(11) NOT NULL default '',
  `telephone` varchar(30) NOT NULL default '',
  `mobphone` varchar(11) NOT NULL default '',
  `address` varchar(150) NOT NULL default '',
  PRIMARY KEY  (`id`),
  KEY `uid` (`uid`)
) ENGINE=MyISAM AUTO_INCREMENT=24 DEFAULT CHARSET=gbk;


DROP TABLE IF EXISTS qb_form_content_8;
CREATE TABLE `qb_form_content_8` (
  `id` mediumint(7) NOT NULL auto_increment,
  `uid` mediumint(7) NOT NULL default '0',
  `roomtype` varchar(30) NOT NULL default '',
  `roomnum` int(3) NOT NULL default '0',
  `numday` int(3) NOT NULL default '0',
  `intotime` varchar(30) NOT NULL default '',
  `truename` varchar(30) NOT NULL default '',
  `telephone` varchar(20) NOT NULL default '',
  PRIMARY KEY  (`id`),
  KEY `uid` (`uid`)
) ENGINE=MyISAM DEFAULT CHARSET=gbk;


DROP TABLE IF EXISTS qb_form_module;
CREATE TABLE `qb_form_module` (
  `id` smallint(4) NOT NULL auto_increment,
  `name` varchar(50) NOT NULL default '',
  `list` smallint(4) NOT NULL default '0',
  `style` varchar(50) NOT NULL default '',
  `config` mediumtext NOT NULL,
  `allowpost` varchar(255) NOT NULL default '',
  `endtime` int(10) NOT NULL default '0',
  `about` text NOT NULL,
  `usetitle` tinyint(1) NOT NULL default '0',
  `repeatpost` tinyint(1) NOT NULL default '0',
  `statename` varchar(30) NOT NULL default '',
  `allowview` varchar(255) NOT NULL default '',
  `use_yzimg` tinyint(1) NOT NULL,
  `template` varchar(255) NOT NULL,
  `email` varchar(255) NOT NULL,
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=9 DEFAULT CHARSET=gbk;


DROP TABLE IF EXISTS qb_form_reply;
CREATE TABLE `qb_form_reply` (
  `rid` mediumint(7) NOT NULL auto_increment,
  `id` mediumint(7) NOT NULL default '0',
  `mid` mediumint(7) NOT NULL default '0',
  `posttime` int(10) NOT NULL default '0',
  `uid` mediumint(7) NOT NULL default '0',
  `username` varchar(30) NOT NULL default '',
  `content` text NOT NULL,
  `ip` varchar(15) NOT NULL default '',
  PRIMARY KEY  (`rid`)
) ENGINE=MyISAM AUTO_INCREMENT=11 DEFAULT CHARSET=gbk;


DROP TABLE IF EXISTS qb_friendlink;
CREATE TABLE `qb_friendlink` (
  `id` mediumint(5) NOT NULL auto_increment,
  `name` varchar(30) NOT NULL default '',
  `url` varchar(150) NOT NULL default '',
  `logo` varchar(150) NOT NULL default '',
  `descrip` varchar(255) NOT NULL default '',
  `list` int(10) NOT NULL default '0',
  `ifhide` tinyint(1) NOT NULL default '0',
  `iswordlink` tinyint(1) default '0',
  `hits` tinyint(7) NOT NULL default '0',
  `posttime` int(10) NOT NULL default '0',
  `uid` int(7) NOT NULL default '0',
  `username` varchar(30) NOT NULL default '',
  `yz` tinyint(1) NOT NULL default '1',
  `endtime` int(10) NOT NULL default '0',
  `city_id` mediumint(7) NOT NULL default '0',
  `fid` mediumint(7) NOT NULL default '0',
  PRIMARY KEY  (`id`),
  KEY `yz` (`yz`,`endtime`,`ifhide`),
  KEY `city_id` (`city_id`)
) ENGINE=MyISAM AUTO_INCREMENT=37 DEFAULT CHARSET=gbk;


DROP TABLE IF EXISTS qb_friendlink_sort;
CREATE TABLE `qb_friendlink_sort` (
  `fid` mediumint(7) NOT NULL auto_increment,
  `name` varchar(30) NOT NULL default '',
  `list` int(10) NOT NULL default '0',
  PRIMARY KEY  (`fid`)
) ENGINE=MyISAM AUTO_INCREMENT=5 DEFAULT CHARSET=gbk;


DROP TABLE IF EXISTS qb_gather_rule;
CREATE TABLE `qb_gather_rule` (
  `id` mediumint(7) NOT NULL auto_increment,
  `fid` mediumint(7) NOT NULL default '0',
  `type` varchar(15) NOT NULL default '0',
  `fixsystem` varchar(30) NOT NULL default '',
  `filetype` varchar(50) NOT NULL default '',
  `webname` varchar(150) NOT NULL default '',
  `listurl` varchar(150) NOT NULL default '',
  `firstpage` varchar(150) NOT NULL default '',
  `page_begin` int(10) NOT NULL default '0',
  `page_end` int(10) NOT NULL default '0',
  `page_step` int(10) NOT NULL default '0',
  `title_minleng` smallint(5) NOT NULL default '0',
  `listmoreurl` text NOT NULL,
  `link_include_word` text NOT NULL,
  `link_noinclude_word` text NOT NULL,
  `link_replace_word` text NOT NULL,
  `title_replace_word` text NOT NULL,
  `list_begin_code` text NOT NULL,
  `list_end_code` text NOT NULL,
  `list_begin_preg` text NOT NULL,
  `list_end_preg` text NOT NULL,
  `gatherthesame` tinyint(1) NOT NULL default '0',
  `show_begin_preg` text NOT NULL,
  `show_end_preg` text NOT NULL,
  `show_endfile_preg` text NOT NULL,
  `show_begin_code` text NOT NULL,
  `show_end_code` text NOT NULL,
  `show_replace_word` text NOT NULL,
  `show_morepage` varchar(100) NOT NULL default '',
  `show_firstpage` varchar(100) NOT NULL default '',
  `show_spe2page` tinyint(1) NOT NULL default '0',
  `posttime` int(10) NOT NULL default '0',
  `list` int(10) NOT NULL default '0',
  `copypic` tinyint(1) NOT NULL default '0',
  `sort` smallint(4) NOT NULL default '0',
  `file_type` varchar(50) NOT NULL default '',
  `file_minleng` mediumint(6) NOT NULL default '0',
  `file_minsize` int(9) NOT NULL default '0',
  `file_includeword` text NOT NULL,
  `file_noincludeword` text NOT NULL,
  `file_explode` text NOT NULL,
  `file_picwidth` int(8) NOT NULL default '0',
  `file_star_string` varchar(150) NOT NULL default '',
  `title_rule` text NOT NULL,
  `content_rule` text NOT NULL,
  `title_morepage_rull` text NOT NULL,
  `content_morepage_rull` text NOT NULL,
  `charset_type` tinyint(1) NOT NULL default '0',
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=4 DEFAULT CHARSET=gbk;


DROP TABLE IF EXISTS qb_gather_sort;
CREATE TABLE `qb_gather_sort` (
  `fid` mediumint(6) NOT NULL auto_increment,
  `name` varchar(80) NOT NULL default '',
  `fup` mediumint(6) NOT NULL default '0',
  `class` smallint(4) NOT NULL default '0',
  `type` tinyint(1) NOT NULL default '0',
  `list` mediumint(5) NOT NULL default '0',
  `allowpost` varchar(255) NOT NULL default '',
  `sons` smallint(4) NOT NULL default '0',
  PRIMARY KEY  (`fid`)
) ENGINE=MyISAM DEFAULT CHARSET=gbk;


DROP TABLE IF EXISTS qb_pm;
CREATE TABLE `qb_pm` (
  `mid` int(10) unsigned NOT NULL auto_increment,
  `touid` mediumint(8) unsigned NOT NULL default '0',
  `togroups` varchar(80) NOT NULL default '',
  `fromuid` mediumint(8) unsigned NOT NULL default '0',
  `username` varchar(15) NOT NULL default '',
  `type` enum('rebox','sebox','public') NOT NULL default 'rebox',
  `ifnew` tinyint(1) NOT NULL default '0',
  `title` varchar(130) NOT NULL default '',
  `mdate` int(10) unsigned NOT NULL default '0',
  `content` text NOT NULL,
  PRIMARY KEY  (`mid`),
  KEY `touid` (`touid`),
  KEY `fromuid` (`fromuid`),
  KEY `type` (`type`)
) ENGINE=MyISAM AUTO_INCREMENT=50 DEFAULT CHARSET=gbk;


DROP TABLE IF EXISTS qb_guestbook_content;
CREATE TABLE `qb_guestbook_content` (
  `id` int(7) NOT NULL auto_increment,
  `fid` mediumint(7) NOT NULL default '0',
  `ico` tinyint(2) NOT NULL default '0',
  `email` varchar(50) NOT NULL default '',
  `oicq` varchar(11) default NULL,
  `weburl` varchar(150) NOT NULL default '',
  `blogurl` varchar(150) NOT NULL default '',
  `uid` int(7) NOT NULL default '0',
  `username` varchar(30) NOT NULL default '',
  `ip` varchar(15) NOT NULL default '',
  `content` text NOT NULL,
  `yz` tinyint(1) NOT NULL default '0',
  `posttime` int(10) NOT NULL default '0',
  `list` int(10) NOT NULL default '0',
  `reply` text NOT NULL,
  `mobphone` varchar(12) NOT NULL default '',
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=24 DEFAULT CHARSET=gbk;


DROP TABLE IF EXISTS qb_guestbook_sort;
CREATE TABLE `qb_guestbook_sort` (
  `fid` mediumint(7) unsigned NOT NULL auto_increment,
  `fup` mediumint(7) unsigned NOT NULL default '0',
  `name` varchar(50) NOT NULL default '',
  `mid` smallint(4) NOT NULL default '0',
  `class` smallint(4) NOT NULL default '0',
  `sons` smallint(4) NOT NULL default '0',
  `type` tinyint(1) NOT NULL default '0',
  `admin` varchar(100) NOT NULL default '',
  `list` int(10) NOT NULL default '0',
  `listorder` tinyint(2) NOT NULL default '0',
  `passwd` varchar(32) NOT NULL default '',
  `logo` varchar(150) NOT NULL default '',
  `descrip` text NOT NULL,
  `style` varchar(50) NOT NULL default '',
  `template` text NOT NULL,
  `jumpurl` varchar(150) NOT NULL default '',
  `maxperpage` tinyint(3) NOT NULL default '0',
  `metatitle` varchar(250) NOT NULL default '',
  `metakeywords` varchar(255) NOT NULL default '',
  `metadescription` varchar(255) NOT NULL default '',
  `allowcomment` tinyint(1) NOT NULL default '0',
  `allowpost` varchar(150) NOT NULL default '',
  `allowviewtitle` varchar(150) NOT NULL default '',
  `allowviewcontent` varchar(150) NOT NULL default '',
  `allowdownload` varchar(150) NOT NULL default '',
  `forbidshow` tinyint(1) NOT NULL default '0',
  `config` mediumtext NOT NULL,
  `index_show` tinyint(1) NOT NULL default '0',
  `contents` mediumint(4) NOT NULL default '0',
  `tableid` varchar(30) NOT NULL default '',
  `dir_name` varchar(50) NOT NULL default '',
  `ifcolor` tinyint(1) NOT NULL default '0',
  PRIMARY KEY  (`fid`)
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=gbk;


DROP TABLE IF EXISTS qb_guestbook_config;
CREATE TABLE `qb_guestbook_config` (
  `c_key` varchar(50) NOT NULL default '',
  `c_value` text NOT NULL,
  `c_descrip` text NOT NULL,
  PRIMARY KEY  (`c_key`)
) ENGINE=MyISAM DEFAULT CHARSET=gbk;


DROP TABLE IF EXISTS qb_keyword;
CREATE TABLE `qb_keyword` (
  `id` mediumint(5) NOT NULL auto_increment,
  `keywords` varchar(30) NOT NULL default '',
  `list` int(10) NOT NULL default '0',
  `uid` mediumint(7) NOT NULL default '0',
  `ifhide` tinyint(1) NOT NULL default '0',
  `url` varchar(150) NOT NULL default '',
  `num` smallint(4) unsigned NOT NULL default '0',
  PRIMARY KEY  (`id`),
  KEY `keywords` (`keywords`),
  KEY `num` (`num`)
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=gbk;


DROP TABLE IF EXISTS qb_keywordid;
CREATE TABLE `qb_keywordid` (
  `id` mediumint(7) NOT NULL default '0',
  `aid` mediumint(7) NOT NULL default '0',
  KEY `id` (`id`),
  KEY `aid` (`aid`)
) ENGINE=MyISAM DEFAULT CHARSET=gbk;


DROP TABLE IF EXISTS qb_limitword;
CREATE TABLE `qb_limitword` (
  `id` int(5) NOT NULL auto_increment,
  `oldword` varchar(50) NOT NULL default '',
  `newword` varchar(50) NOT NULL default '',
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=4 DEFAULT CHARSET=gbk;


DROP TABLE IF EXISTS qb_upfile;
CREATE TABLE `qb_upfile` (
  `up_id` mediumint(7) NOT NULL auto_increment,
  `module_id` smallint(4) NOT NULL default '0',
  `ids` varchar(255) NOT NULL default '0',
  `fid` mediumint(7) NOT NULL default '0',
  `uid` mediumint(7) NOT NULL default '0',
  `posttime` int(10) NOT NULL default '0',
  `url` varchar(150) NOT NULL default '',
  `filename` varchar(100) NOT NULL default '',
  `num` smallint(5) NOT NULL default '0',
  `if_tmp` tinyint(1) NOT NULL default '0',
  PRIMARY KEY  (`up_id`),
  KEY `filename` (`filename`),
  KEY `if_tmp` (`if_tmp`),
  KEY `posttime` (`posttime`)
) ENGINE=MyISAM AUTO_INCREMENT=189 DEFAULT CHARSET=gbk;


DROP TABLE IF EXISTS qb_vote_element;
CREATE TABLE `qb_vote_element` (
  `id` int(7) NOT NULL auto_increment,
  `cid` int(7) NOT NULL default '0',
  `title` varchar(50) NOT NULL default '',
  `votenum` int(7) NOT NULL default '0',
  `list` int(10) NOT NULL default '0',
  `img` varchar(100) NOT NULL default '',
  `describes` varchar(255) NOT NULL default '',
  `url` varchar(100) NOT NULL default '',
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=82 DEFAULT CHARSET=gbk;


DROP TABLE IF EXISTS qb_vote_comment;
CREATE TABLE `qb_vote_comment` (
  `id` mediumint(7) unsigned NOT NULL auto_increment,
  `cid` mediumint(7) unsigned NOT NULL default '0',
  `vid` mediumint(7) NOT NULL default '0',
  `uid` mediumint(7) unsigned NOT NULL default '0',
  `username` varchar(30) NOT NULL default '',
  `posttime` int(10) NOT NULL default '0',
  `content` text NOT NULL,
  `ip` varchar(15) NOT NULL default '',
  `icon` tinyint(3) NOT NULL default '0',
  `yz` tinyint(1) NOT NULL default '0',
  PRIMARY KEY  (`id`),
  KEY `aid` (`cid`),
  KEY `uid` (`uid`)
) ENGINE=MyISAM AUTO_INCREMENT=23 DEFAULT CHARSET=gbk;


DROP TABLE IF EXISTS qb_vote_topic;
CREATE TABLE `qb_vote_topic` (
  `cid` int(7) NOT NULL auto_increment,
  `name` varchar(50) NOT NULL default '',
  `about` text NOT NULL,
  `type` tinyint(4) NOT NULL default '0',
  `limittime` int(10) NOT NULL default '0',
  `limitip` tinyint(1) NOT NULL default '0',
  `ip` text NOT NULL,
  `posttime` int(10) NOT NULL default '0',
  `user` text NOT NULL,
  `begintime` int(10) NOT NULL default '0',
  `endtime` int(10) NOT NULL default '0',
  `forbidguestvote` tinyint(1) NOT NULL default '0',
  `ifcomment` tinyint(1) NOT NULL default '0',
  `tplcode` text NOT NULL,
  `votetype` tinyint(2) NOT NULL default '0',
  `aid` mediumint(7) NOT NULL default '0',
  `uid` mediumint(7) NOT NULL default '0',
  PRIMARY KEY  (`cid`)
) ENGINE=MyISAM AUTO_INCREMENT=12 DEFAULT CHARSET=gbk;


DROP TABLE IF EXISTS qb_vote_config;
CREATE TABLE `qb_vote_config` (
  `c_key` varchar(50) NOT NULL default '',
  `c_value` text NOT NULL,
  `c_descrip` text NOT NULL,
  PRIMARY KEY  (`c_key`)
) ENGINE=MyISAM DEFAULT CHARSET=gbk;


DROP TABLE IF EXISTS qb_area;
CREATE TABLE `qb_area` (
  `fid` mediumint(7) unsigned NOT NULL auto_increment,
  `fup` mediumint(7) unsigned NOT NULL default '0',
  `name` varchar(200) NOT NULL default '',
  `class` smallint(4) NOT NULL default '0',
  `sons` smallint(4) NOT NULL default '0',
  `type` tinyint(1) NOT NULL default '0',
  `admin` varchar(100) NOT NULL default '',
  `list` int(10) NOT NULL default '0',
  `listorder` tinyint(2) NOT NULL default '0',
  `passwd` varchar(32) NOT NULL default '',
  `logo` varchar(150) NOT NULL default '',
  `descrip` text NOT NULL,
  `style` varchar(50) NOT NULL default '',
  `template` text NOT NULL,
  `jumpurl` varchar(150) NOT NULL default '',
  `maxperpage` tinyint(3) NOT NULL default '0',
  `metakeywords` varchar(255) NOT NULL default '',
  `metadescription` varchar(255) NOT NULL default '',
  `allowcomment` tinyint(1) NOT NULL default '0',
  `allowpost` varchar(150) NOT NULL default '',
  `allowviewtitle` varchar(150) NOT NULL default '',
  `allowviewcontent` varchar(150) NOT NULL default '',
  `allowdownload` varchar(150) NOT NULL default '',
  `forbidshow` tinyint(1) NOT NULL default '0',
  `config` text NOT NULL,
  `dirname` varchar(150) NOT NULL default '',
  `hits` mediumint(7) NOT NULL default '0',
  PRIMARY KEY  (`fid`),
  KEY `fup` (`fup`)
) ENGINE=MyISAM AUTO_INCREMENT=29 DEFAULT CHARSET=gbk;


DROP TABLE IF EXISTS qb_jfabout;
CREATE TABLE `qb_jfabout` (
  `id` mediumint(7) NOT NULL auto_increment,
  `fid` mediumint(5) NOT NULL default '0',
  `title` varchar(150) NOT NULL default '',
  `content` text NOT NULL,
  `list` int(10) NOT NULL default '0',
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=10 DEFAULT CHARSET=gbk;


DROP TABLE IF EXISTS qb_jfsort;
CREATE TABLE `qb_jfsort` (
  `fid` mediumint(5) NOT NULL auto_increment,
  `name` varchar(50) NOT NULL default '',
  `list` int(10) NOT NULL default '0',
  PRIMARY KEY  (`fid`)
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=gbk;


DROP TABLE IF EXISTS qb_moneycard;
CREATE TABLE `qb_moneycard` (
  `id` mediumint(7) NOT NULL auto_increment,
  `passwd` varchar(32) NOT NULL default '',
  `moneyrmb` int(7) NOT NULL default '0',
  `moneycard` int(7) NOT NULL default '0',
  `ifsell` tinyint(1) NOT NULL default '0',
  `uid` mediumint(7) NOT NULL default '0',
  `username` varchar(32) NOT NULL default '',
  `posttime` int(10) NOT NULL default '0',
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=7 DEFAULT CHARSET=gbk;


DROP TABLE IF EXISTS qb_olpay;
CREATE TABLE `qb_olpay` (
  `id` mediumint(7) NOT NULL auto_increment,
  `orderid` int(10) NOT NULL default '0',
  `numcode` varchar(32) NOT NULL default '',
  `money` varchar(15) NOT NULL default '0',
  `ifpay` tinyint(1) NOT NULL default '0',
  `posttime` int(10) NOT NULL default '0',
  `uid` mediumint(7) NOT NULL default '0',
  `username` varchar(32) NOT NULL default '',
  `paytype` tinyint(3) NOT NULL default '0',
  `moduleid` mediumint(5) NOT NULL default '0',
  `formid` mediumint(5) NOT NULL default '0',
  `banktype` varchar(15) NOT NULL default '',
  `articleid` int(10) NOT NULL default '0',
  PRIMARY KEY  (`id`),
  KEY `numcode` (`numcode`),
  KEY `paytype` (`paytype`),
  KEY `formid` (`formid`),
  KEY `articleid` (`articleid`),
  KEY `moduleid` (`moduleid`)
) ENGINE=MyISAM AUTO_INCREMENT=73 DEFAULT CHARSET=gbk;


DROP TABLE IF EXISTS qb_propagandize;
CREATE TABLE `qb_propagandize` (
  `id` int(10) NOT NULL auto_increment,
  `newuid` mediumint(7) NOT NULL default '0',
  `uid` mediumint(7) NOT NULL default '0',
  `ip` bigint(11) NOT NULL default '0',
  `day` smallint(3) NOT NULL default '0',
  `posttime` int(10) NOT NULL default '0',
  `fromurl` varchar(150) NOT NULL default '',
  PRIMARY KEY  (`id`),
  KEY `day` (`day`,`uid`,`ip`),
  KEY `newuid` (`newuid`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=gbk;


DROP TABLE IF EXISTS qb_report;
CREATE TABLE `qb_report` (
  `id` mediumint(7) NOT NULL auto_increment,
  `aid` int(10) NOT NULL default '0',
  `type` varchar(50) NOT NULL default '',
  `uid` mediumint(7) NOT NULL default '0',
  `name` varchar(30) NOT NULL default '',
  `content` text NOT NULL,
  `posttime` int(10) NOT NULL default '0',
  `ip` varchar(15) NOT NULL default '',
  `yz` tinyint(1) NOT NULL default '0',
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=gbk;


DROP TABLE IF EXISTS qb_template;
CREATE TABLE `qb_template` (
  `id` mediumint(5) NOT NULL auto_increment,
  `name` varchar(50) NOT NULL default '',
  `type` smallint(4) NOT NULL default '0',
  `filepath` varchar(100) NOT NULL default '',
  `descrip` text NOT NULL,
  `list` int(10) NOT NULL default '0',
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=30 DEFAULT CHARSET=gbk;


DROP TABLE IF EXISTS qb_template_bak;
CREATE TABLE `qb_template_bak` (
  `bid` int(7) NOT NULL auto_increment,
  `id` int(7) NOT NULL default '0',
  `posttime` int(10) NOT NULL default '0',
  `code` text NOT NULL,
  PRIMARY KEY  (`bid`),
  KEY `id` (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=gbk;


DROP TABLE IF EXISTS qb_crontab;
CREATE TABLE `qb_crontab` (
  `id` mediumint(7) NOT NULL auto_increment,
  `title` varchar(100) NOT NULL default '',
  `minutetime` mediumint(4) NOT NULL default '0',
  `daytime` varchar(4) NOT NULL default '0',
  `whiletime` int(10) NOT NULL default '0',
  `lasttime` int(10) NOT NULL default '0',
  `filepath` varchar(50) NOT NULL default '',
  `about` text NOT NULL,
  `ifstop` tinyint(1) NOT NULL default '0',
  PRIMARY KEY  (`id`),
  KEY `ifstop` (`ifstop`)
) ENGINE=MyISAM AUTO_INCREMENT=5 DEFAULT CHARSET=gbk;


DROP TABLE IF EXISTS qb_moneylog;
CREATE TABLE `qb_moneylog` (
  `id` mediumint(7) NOT NULL auto_increment,
  `uid` mediumint(7) NOT NULL default '0',
  `money` mediumint(7) NOT NULL default '0',
  `about` varchar(255) NOT NULL default '',
  `posttime` int(10) NOT NULL default '0',
  `city_id` mediumint(7) NOT NULL default '0',
  PRIMARY KEY  (`id`),
  KEY `uid` (`uid`),
  KEY `city_id` (`city_id`)
) ENGINE=MyISAM AUTO_INCREMENT=37 DEFAULT CHARSET=gbk;


DROP TABLE IF EXISTS qb_yzimg;
CREATE TABLE `qb_yzimg` (
  `sid` varchar(8) NOT NULL default '',
  `imgnum` varchar(6) NOT NULL default '',
  `posttime` int(10) NOT NULL default '0',
  UNIQUE KEY `sid` (`sid`),
  KEY `posttime` (`imgnum`,`posttime`)
) ENGINE=MEMORY DEFAULT CHARSET=latin1;


DROP TABLE IF EXISTS qb_article_pic;
CREATE TABLE `qb_article_pic` (
  `pid` mediumint(7) NOT NULL auto_increment,
  `id` mediumint(10) NOT NULL default '0',
  `fid` mediumint(7) NOT NULL default '0',
  `mid` smallint(4) NOT NULL default '0',
  `uid` mediumint(7) NOT NULL default '0',
  `type` tinyint(1) NOT NULL default '0',
  `imgurl` varchar(150) NOT NULL default '',
  `name` varchar(100) NOT NULL default '',
  PRIMARY KEY  (`pid`),
  KEY `id` (`id`),
  KEY `fid` (`fid`)
) ENGINE=MyISAM AUTO_INCREMENT=5 DEFAULT CHARSET=gbk;


DROP TABLE IF EXISTS qb_city;
CREATE TABLE `qb_city` (
  `fid` mediumint(7) unsigned NOT NULL auto_increment,
  `fup` mediumint(7) unsigned NOT NULL default '0',
  `name` varchar(200) NOT NULL default '',
  `class` smallint(4) NOT NULL default '0',
  `sons` smallint(4) NOT NULL default '0',
  `type` tinyint(1) NOT NULL default '0',
  `admin` varchar(100) NOT NULL default '',
  `list` int(10) NOT NULL default '0',
  `listorder` tinyint(2) NOT NULL default '0',
  `passwd` varchar(32) NOT NULL default '',
  `logo` varchar(150) NOT NULL default '',
  `descrip` text NOT NULL,
  `style` varchar(50) NOT NULL default '',
  `template` text NOT NULL,
  `jumpurl` varchar(150) NOT NULL default '',
  `maxperpage` tinyint(3) NOT NULL default '0',
  `metakeywords` varchar(255) NOT NULL default '',
  `metadescription` varchar(255) NOT NULL default '',
  `allowcomment` tinyint(1) NOT NULL default '0',
  `allowpost` varchar(150) NOT NULL default '',
  `allowviewtitle` varchar(150) NOT NULL default '',
  `allowviewcontent` varchar(150) NOT NULL default '',
  `allowdownload` varchar(150) NOT NULL default '',
  `forbidshow` tinyint(1) NOT NULL default '0',
  `config` text NOT NULL,
  `hits` mediumint(7) NOT NULL default '0',
  `letter` varchar(5) NOT NULL default '',
  `domain` varchar(150) NOT NULL default '',
  `dirname` varchar(50) NOT NULL default '',
  `copyright` text NOT NULL,
  `maps` varchar(50) NOT NULL default '',
  PRIMARY KEY  (`fid`),
  KEY `fup` (`fup`),
  KEY `letter` (`letter`),
  KEY `list` (`list`)
) ENGINE=MyISAM AUTO_INCREMENT=339 DEFAULT CHARSET=gbk;


DROP TABLE IF EXISTS qb_hy_company;
CREATE TABLE `qb_hy_company` (
  `rid` mediumint(7) NOT NULL auto_increment,
  `title` varchar(200) NOT NULL default '',
  `host` varchar(100) NOT NULL default '',
  `fname` varchar(100) NOT NULL default '',
  `uid` mediumint(7) NOT NULL default '0',
  `username` varchar(32) NOT NULL default '',
  `renzheng` tinyint(1) NOT NULL default '0',
  `is_agent` tinyint(1) NOT NULL default '0',
  `is_vip` tinyint(1) NOT NULL default '0',
  `posttime` int(10) NOT NULL default '0',
  `list` int(10) NOT NULL default '0',
  `listorder` int(10) NOT NULL default '0',
  `picurl` varchar(255) NOT NULL default '',
  `gz` varchar(248) NOT NULL default '',
  `yz` tinyint(1) NOT NULL default '0',
  `yzer` varchar(32) NOT NULL default '',
  `yztime` int(10) NOT NULL default '0',
  `hits` int(10) NOT NULL default '0',
  `levels` tinyint(2) NOT NULL default '0',
  `levelstime` int(10) NOT NULL default '0',
  `lastview` int(10) NOT NULL default '0',
  `content` text NOT NULL,
  `province_id` mediumint(7) NOT NULL default '0',
  `city_id` mediumint(7) NOT NULL default '0',
  `zone_id` mediumint(7) NOT NULL default '0',
  `street_id` mediumint(7) NOT NULL default '0',
  `qy_cate` varchar(32) NOT NULL default '',
  `qy_saletype` varchar(48) NOT NULL default '',
  `qy_regmoney` int(10) NOT NULL default '0',
  `qy_createtime` varchar(64) NOT NULL default '',
  `qy_regplace` varchar(128) NOT NULL default '',
  `qy_address` varchar(248) NOT NULL default '',
  `qy_postnum` varchar(8) NOT NULL default '',
  `qy_pro_ser` varchar(248) NOT NULL default '',
  `my_buy` varchar(248) NOT NULL default '',
  `my_trade` varchar(32) NOT NULL default '',
  `qy_contact` varchar(16) NOT NULL default '',
  `qy_contact_zhiwei` varchar(16) NOT NULL default '',
  `qy_contact_sex` int(1) NOT NULL default '1',
  `qy_contact_tel` varchar(248) NOT NULL default '',
  `qy_contact_mobile` varchar(248) NOT NULL default '',
  `qy_contact_fax` varchar(248) NOT NULL default '',
  `qy_contact_email` varchar(248) NOT NULL default '',
  `qy_website` varchar(248) NOT NULL default '',
  `qq` varchar(248) NOT NULL default '',
  `msn` varchar(248) NOT NULL default '',
  `skype` varchar(248) NOT NULL default '',
  `ww` varchar(248) NOT NULL default '',
  `bd_pics` varchar(248) NOT NULL default '',
  `toptime` int(10) NOT NULL default '0',
  `if_homepage` tinyint(4) NOT NULL default '0',
  `permit_pic` varchar(100) NOT NULL default '',
  `guo_tax_pic` varchar(100) NOT NULL default '',
  `di_tax_pic` varchar(100) NOT NULL default '',
  `organization_pic` varchar(100) NOT NULL default '',
  `idcard_pic` varchar(100) NOT NULL default '',
  `gg_maps` varchar(50) NOT NULL default '',
  `dianping` mediumint(7) unsigned NOT NULL default '0',
  `dianpingtime` int(10) NOT NULL default '0',
  `webstyle` varchar(30) NOT NULL default '',
  `wapstyle` varchar(30) NOT NULL default '',
  `voucher_join` mediumint(7) NOT NULL default '0',
  `voucher_qd` mediumint(7) NOT NULL default '0',
  `voucher_bl` tinyint(2) NOT NULL default '0',
  `wxpaycode` varchar(100) NOT NULL default '',
  `alipaycode` varchar(100) NOT NULL default '',
  PRIMARY KEY  (`rid`),
  KEY `uid` (`uid`),
  KEY `levels` (`levels`,`posttime`),
  KEY `yz` (`yz`,`posttime`),
  KEY `toptime` (`toptime`),
  KEY `city_id` (`city_id`,`levels`,`levelstime`),
  KEY `renzheng` (`renzheng`),
  KEY `host` (`host`)
) ENGINE=MyISAM AUTO_INCREMENT=33 DEFAULT CHARSET=gbk;


DROP TABLE IF EXISTS qb_hy_company_fid;
CREATE TABLE `qb_hy_company_fid` (
  `uid` mediumint(7) unsigned NOT NULL default '0',
  `fid` mediumint(7) unsigned NOT NULL default '0',
  PRIMARY KEY  (`uid`,`fid`)
) ENGINE=MyISAM DEFAULT CHARSET=gbk;


DROP TABLE IF EXISTS qb_hy_config;
CREATE TABLE `qb_hy_config` (
  `c_key` varchar(50) NOT NULL default '',
  `c_value` text NOT NULL,
  `c_descrip` text NOT NULL,
  PRIMARY KEY  (`c_key`)
) ENGINE=MyISAM DEFAULT CHARSET=gbk;


DROP TABLE IF EXISTS qb_hy_dianping;
CREATE TABLE `qb_hy_dianping` (
  `cid` mediumint(7) unsigned NOT NULL auto_increment,
  `cuid` int(7) NOT NULL default '0',
  `type` tinyint(2) NOT NULL default '0',
  `id` mediumint(7) unsigned NOT NULL default '0',
  `fid` mediumint(7) unsigned NOT NULL default '0',
  `uid` mediumint(7) unsigned NOT NULL default '0',
  `username` varchar(30) NOT NULL default '',
  `posttime` int(10) NOT NULL default '0',
  `content` text NOT NULL,
  `ip` varchar(15) NOT NULL default '',
  `icon` tinyint(3) NOT NULL default '0',
  `yz` tinyint(1) NOT NULL default '0',
  `fen1` smallint(4) NOT NULL default '0',
  `fen2` smallint(4) NOT NULL default '0',
  `fen3` smallint(4) NOT NULL default '0',
  `fen4` smallint(4) NOT NULL default '0',
  `fen5` smallint(4) NOT NULL default '0',
  `flowers` smallint(4) NOT NULL default '0',
  `egg` smallint(4) NOT NULL default '0',
  `price` mediumint(5) NOT NULL default '0',
  `keywords` varchar(100) NOT NULL default '',
  `keywords2` varchar(100) NOT NULL default '',
  `fen6` varchar(150) NOT NULL default '',
  PRIMARY KEY  (`cid`),
  KEY `type` (`type`)
) ENGINE=MyISAM AUTO_INCREMENT=9 DEFAULT CHARSET=gbk;


DROP TABLE IF EXISTS qb_hy_friendlink;
CREATE TABLE `qb_hy_friendlink` (
  `ck_id` int(10) unsigned NOT NULL auto_increment,
  `uid` mediumint(7) unsigned NOT NULL default '0',
  `username` varchar(16) NOT NULL default '',
  `companyName` varchar(64) NOT NULL default '',
  `title` varchar(128) NOT NULL default '',
  `url` varchar(248) NOT NULL default '',
  `description` text NOT NULL,
  `yz` tinyint(1) NOT NULL default '0',
  PRIMARY KEY  (`ck_id`),
  KEY `uid` (`uid`)
) ENGINE=MyISAM DEFAULT CHARSET=gbk;


DROP TABLE IF EXISTS qb_hy_guestbook;
CREATE TABLE `qb_hy_guestbook` (
  `id` int(7) NOT NULL auto_increment,
  `cuid` mediumint(7) NOT NULL default '0',
  `uid` int(7) NOT NULL default '0',
  `username` varchar(30) NOT NULL default '',
  `ip` varchar(15) NOT NULL default '',
  `content` text NOT NULL,
  `yz` tinyint(1) NOT NULL default '0',
  `posttime` int(16) NOT NULL default '0',
  `list` int(10) NOT NULL default '0',
  PRIMARY KEY  (`id`),
  KEY `cuid` (`cuid`),
  KEY `uid` (`uid`)
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=gbk;


DROP TABLE IF EXISTS qb_hy_home;
CREATE TABLE `qb_hy_home` (
  `uid` mediumint(7) unsigned NOT NULL default '0',
  `username` varchar(32) NOT NULL default '',
  `style` varchar(32) NOT NULL default '',
  `index_left` varchar(248) NOT NULL default '',
  `index_right` varchar(248) NOT NULL default '',
  `listnum` text NOT NULL,
  `banner` varchar(248) NOT NULL default '',
  `bodytpl` varchar(8) NOT NULL default 'left',
  `renzheng_show` tinyint(1) NOT NULL default '0',
  `visitor` text NOT NULL,
  `hits` mediumint(7) NOT NULL default '0',
  `head_menu` text NOT NULL,
  `metatitle` varchar(255) NOT NULL default '',
  `metakeywords` varchar(255) NOT NULL default '',
  `metadescription` varchar(255) NOT NULL default '',
  `page_title` varchar(100) NOT NULL default '',
  `page_content` text NOT NULL,
  UNIQUE KEY `uid` (`uid`)
) ENGINE=MyISAM DEFAULT CHARSET=gbk;


DROP TABLE IF EXISTS qb_hy_mymember;
CREATE TABLE `qb_hy_mymember` (
  `mid` int(10) unsigned NOT NULL auto_increment,
  `uid` mediumint(10) NOT NULL default '0',
  `pid` mediumint(10) NOT NULL default '0',
  `jointime` int(10) NOT NULL default '0',
  `voucher` double NOT NULL default '0',
  `lastvist` int(10) NOT NULL default '0',
  PRIMARY KEY  (`mid`),
  KEY `uid` (`uid`),
  KEY `pid` (`pid`)
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=gbk;


DROP TABLE IF EXISTS qb_hy_qd;
CREATE TABLE `qb_hy_qd` (
  `qid` int(10) unsigned NOT NULL auto_increment,
  `uid` mediumint(10) NOT NULL default '0',
  `pid` mediumint(10) NOT NULL default '0',
  `qdtime` int(10) NOT NULL default '0',
  PRIMARY KEY  (`qid`),
  KEY `uid` (`uid`),
  KEY `pid` (`pid`)
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=gbk;


DROP TABLE IF EXISTS qb_hy_sort;
CREATE TABLE `qb_hy_sort` (
  `fid` mediumint(7) unsigned NOT NULL auto_increment,
  `fup` mediumint(7) unsigned NOT NULL default '0',
  `name` varchar(50) NOT NULL default '',
  `mid` smallint(4) NOT NULL default '0',
  `class` smallint(4) NOT NULL default '0',
  `sons` smallint(4) NOT NULL default '0',
  `type` tinyint(1) NOT NULL default '0',
  `admin` varchar(100) NOT NULL default '',
  `list` int(10) NOT NULL default '0',
  `listorder` tinyint(2) NOT NULL default '0',
  `passwd` varchar(32) NOT NULL default '',
  `logo` varchar(150) NOT NULL default '',
  `descrip` text NOT NULL,
  `style` varchar(50) NOT NULL default '',
  `template` text NOT NULL,
  `jumpurl` varchar(150) NOT NULL default '',
  `maxperpage` tinyint(3) NOT NULL default '0',
  `metatitle` varchar(250) NOT NULL default '',
  `metakeywords` varchar(255) NOT NULL default '',
  `metadescription` varchar(255) NOT NULL default '',
  `allowcomment` tinyint(1) NOT NULL default '0',
  `allowpost` varchar(150) NOT NULL default '',
  `allowviewtitle` varchar(150) NOT NULL default '',
  `allowviewcontent` varchar(150) NOT NULL default '',
  `allowdownload` varchar(150) NOT NULL default '',
  `forbidshow` tinyint(1) NOT NULL default '0',
  `config` mediumtext NOT NULL,
  `index_show` tinyint(1) NOT NULL default '0',
  `contents` mediumint(4) NOT NULL default '0',
  `tableid` varchar(30) NOT NULL default '',
  `dir_name` varchar(50) NOT NULL default '',
  `ifcolor` tinyint(1) NOT NULL default '0',
  PRIMARY KEY  (`fid`)
) ENGINE=MyISAM AUTO_INCREMENT=73 DEFAULT CHARSET=gbk;


DROP TABLE IF EXISTS qb_hy_style;
CREATE TABLE `qb_hy_style` (
  `sid` int(10) unsigned NOT NULL auto_increment,
  `uid` mediumint(10) NOT NULL default '0',
  `type` tinyint(1) NOT NULL default '0',
  `stylename` varchar(30) NOT NULL default '',
  `config` mediumtext NOT NULL,
  `pid` int(10) NOT NULL default '0',
  PRIMARY KEY  (`sid`),
  KEY `uid` (`uid`)
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=gbk;


DROP TABLE IF EXISTS qb_log;
CREATE TABLE `qb_log` (
  `lid` int(10) NOT NULL auto_increment,
  `systype` varchar(30) NOT NULL default '',
  `type` tinyint(4) NOT NULL default '0',
  `tag` varchar(50) NOT NULL default '',
  `uid` int(10) NOT NULL default '0',
  `username` varchar(32) NOT NULL default '',
  `ip` varchar(15) NOT NULL default '',
  `port` int(8) NOT NULL default '0',
  `posttime` int(10) NOT NULL default '0',
  `id` int(10) NOT NULL default '0',
  `fid` int(10) NOT NULL default '0',
  `cid` int(10) NOT NULL default '0',
  `about` text NOT NULL,
  PRIMARY KEY  (`lid`),
  KEY `uid` (`uid`),
  KEY `id` (`id`),
  KEY `posttime` (`posttime`),
  KEY `systype` (`systype`)
) ENGINE=MyISAM DEFAULT CHARSET=gbk;


DROP TABLE IF EXISTS qb_login_check;
CREATE TABLE `qb_login_check` (
  `usr` varchar(32) NOT NULL default '',
  `uid` int(10) NOT NULL default '0',
  `posttime` int(10) NOT NULL default '0',
  UNIQUE KEY `usr` (`usr`)
) ENGINE=MEMORY DEFAULT CHARSET=latin1 COMMENT='????????????????';


DROP TABLE IF EXISTS qb_news_comments;
CREATE TABLE `qb_news_comments` (
  `cid` mediumint(7) unsigned NOT NULL auto_increment,
  `id` int(10) unsigned NOT NULL default '0',
  `fid` mediumint(7) unsigned NOT NULL default '0',
  `cids` int(10) NOT NULL,
  `cuid` mediumint(7) NOT NULL default '0',
  `uid` mediumint(7) unsigned NOT NULL default '0',
  `username` varchar(30) NOT NULL default '',
  `posttime` int(10) NOT NULL default '0',
  `content` text NOT NULL,
  `ip` varchar(15) NOT NULL default '',
  `icon` tinyint(3) NOT NULL default '0',
  `yz` tinyint(1) NOT NULL default '0',
  `ifcom` tinyint(1) NOT NULL default '0',
  `agree` mediumint(5) NOT NULL default '0',
  `disagree` mediumint(5) NOT NULL default '0',
  `quoteid` int(10) NOT NULL default '0',
  PRIMARY KEY  (`cid`),
  KEY `aid` (`id`),
  KEY `fid` (`fid`),
  KEY `uid` (`uid`),
  KEY `ifcom` (`ifcom`)
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=gbk;


DROP TABLE IF EXISTS qb_news_config;
CREATE TABLE `qb_news_config` (
  `c_key` varchar(50) NOT NULL default '',
  `c_value` text NOT NULL,
  `c_descrip` text NOT NULL,
  PRIMARY KEY  (`c_key`)
) ENGINE=MyISAM DEFAULT CHARSET=gbk;


DROP TABLE IF EXISTS qb_news_content;
CREATE TABLE `qb_news_content` (
  `id` mediumint(7) unsigned NOT NULL auto_increment,
  `title` varchar(150) NOT NULL default '',
  `smalltitle` varchar(100) NOT NULL default '',
  `fid` mediumint(7) unsigned NOT NULL default '0',
  `mid` mediumint(5) NOT NULL default '0',
  `fname` varchar(50) NOT NULL default '',
  `hits` mediumint(7) NOT NULL default '0',
  `pages` smallint(4) NOT NULL default '0',
  `comments` mediumint(7) NOT NULL default '0',
  `posttime` int(10) NOT NULL default '0',
  `list` int(10) NOT NULL default '0',
  `uid` mediumint(7) NOT NULL default '0',
  `username` varchar(30) NOT NULL default '',
  `author` varchar(30) NOT NULL default '',
  `copyfrom` varchar(100) NOT NULL default '',
  `copyfromurl` varchar(150) NOT NULL default '',
  `titlecolor` varchar(15) NOT NULL default '',
  `fonttype` tinyint(1) NOT NULL default '0',
  `picurl` varchar(150) NOT NULL default '0',
  `ispic` tinyint(1) NOT NULL default '0',
  `yz` tinyint(1) NOT NULL default '0',
  `yzer` varchar(30) NOT NULL default '',
  `yztime` int(10) NOT NULL default '0',
  `levels` tinyint(2) NOT NULL default '0',
  `levelstime` int(10) NOT NULL default '0',
  `keywords` varchar(100) NOT NULL default '',
  `jumpurl` varchar(150) NOT NULL default '',
  `iframeurl` varchar(150) NOT NULL default '',
  `style` varchar(15) NOT NULL default '',
  `template` varchar(255) NOT NULL default '',
  `target` tinyint(1) NOT NULL default '0',
  `ip` varchar(15) NOT NULL default '',
  `lastfid` mediumint(7) NOT NULL default '0',
  `money` mediumint(7) NOT NULL default '0',
  `buyuser` text NOT NULL,
  `passwd` varchar(32) NOT NULL default '',
  `allowdown` varchar(150) NOT NULL default '',
  `allowview` varchar(150) NOT NULL default '',
  `editer` varchar(30) NOT NULL default '',
  `edittime` int(10) NOT NULL default '0',
  `begintime` int(10) NOT NULL default '0',
  `endtime` int(10) NOT NULL default '0',
  `description` text NOT NULL,
  `lastview` int(10) NOT NULL default '0',
  `digg_num` mediumint(7) NOT NULL default '0',
  `digg_time` int(10) NOT NULL default '0',
  `forbidcomment` tinyint(1) NOT NULL default '0',
  `ifvote` tinyint(1) NOT NULL default '0',
  `heart` varchar(255) NOT NULL default '',
  `htmlname` varchar(100) NOT NULL default '',
  `city_id` mediumint(7) NOT NULL default '0',
  `province_id` smallint(4) NOT NULL default '0',
  `zone_id` smallint(4) NOT NULL default '0',
  `street_id` smallint(4) NOT NULL default '0',
  `contentpic` text NOT NULL,
  PRIMARY KEY  (`id`),
  KEY `fid` (`fid`),
  KEY `hits` (`hits`,`yz`,`fid`,`ispic`),
  KEY `list` (`list`,`yz`,`fid`,`ispic`),
  KEY `ispic` (`ispic`),
  KEY `uid` (`uid`),
  KEY `levels` (`levels`),
  KEY `digg_num` (`digg_num`),
  KEY `digg_time` (`digg_time`),
  KEY `mid` (`mid`),
  KEY `city_id` (`city_id`),
  KEY `posttime` (`yz`,`posttime`,`fid`,`ispic`)
) ENGINE=MyISAM AUTO_INCREMENT=969 DEFAULT CHARSET=gbk;


DROP TABLE IF EXISTS qb_news_content_1;
CREATE TABLE `qb_news_content_1` (
  `rid` mediumint(7) NOT NULL auto_increment,
  `subhead` varchar(150) NOT NULL default '',
  `id` mediumint(7) NOT NULL default '0',
  `fid` mediumint(7) NOT NULL default '0',
  `uid` mediumint(7) NOT NULL default '0',
  `topic` tinyint(1) NOT NULL default '0',
  `content` mediumtext NOT NULL,
  `orderid` mediumint(7) NOT NULL default '0',
  PRIMARY KEY  (`rid`),
  KEY `orderid` (`orderid`),
  KEY `topic` (`topic`),
  KEY `id` (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=964 DEFAULT CHARSET=gbk;


DROP TABLE IF EXISTS qb_news_digguser;
CREATE TABLE `qb_news_digguser` (
  `did` int(10) NOT NULL auto_increment,
  `id` int(10) NOT NULL,
  `uid` int(10) NOT NULL,
  `posttime` int(10) NOT NULL,
  PRIMARY KEY  (`did`),
  KEY `id` (`id`),
  KEY `uid` (`uid`)
) ENGINE=MyISAM AUTO_INCREMENT=16 DEFAULT CHARSET=gbk;


DROP TABLE IF EXISTS qb_news_keyword;
CREATE TABLE `qb_news_keyword` (
  `id` mediumint(5) NOT NULL auto_increment,
  `keywords` varchar(30) NOT NULL default '',
  `list` int(10) NOT NULL default '0',
  `uid` mediumint(7) NOT NULL default '0',
  `ifhide` tinyint(1) NOT NULL default '0',
  `url` varchar(150) NOT NULL default '',
  `num` smallint(4) unsigned NOT NULL default '0',
  PRIMARY KEY  (`id`),
  KEY `keywords` (`keywords`),
  KEY `num` (`num`)
) ENGINE=MyISAM DEFAULT CHARSET=gbk;


DROP TABLE IF EXISTS qb_news_keywordid;
CREATE TABLE `qb_news_keywordid` (
  `id` mediumint(7) NOT NULL default '0',
  `aid` mediumint(7) NOT NULL default '0',
  KEY `id` (`id`),
  KEY `aid` (`aid`)
) ENGINE=MyISAM DEFAULT CHARSET=gbk;


DROP TABLE IF EXISTS qb_news_sort;
CREATE TABLE `qb_news_sort` (
  `fid` mediumint(7) unsigned NOT NULL auto_increment,
  `fup` mediumint(7) unsigned NOT NULL default '0',
  `mid` mediumint(5) NOT NULL default '0',
  `name` varchar(50) NOT NULL default '',
  `class` smallint(4) NOT NULL default '0',
  `sons` smallint(4) NOT NULL default '0',
  `type` tinyint(1) NOT NULL default '0',
  `admin` varchar(100) NOT NULL default '',
  `list` int(10) NOT NULL default '0',
  `listorder` tinyint(2) NOT NULL default '0',
  `passwd` varchar(32) NOT NULL default '',
  `logo` varchar(150) NOT NULL default '',
  `descrip` text NOT NULL,
  `style` varchar(50) NOT NULL default '',
  `template` text NOT NULL,
  `jumpurl` varchar(150) NOT NULL default '',
  `maxperpage` tinyint(3) NOT NULL default '0',
  `metatitle` varchar(255) NOT NULL default '',
  `metakeywords` varchar(255) NOT NULL default '',
  `metadescription` varchar(255) NOT NULL default '',
  `allowcomment` tinyint(1) NOT NULL default '0',
  `allowpost` varchar(150) NOT NULL default '',
  `allowviewtitle` varchar(150) NOT NULL default '',
  `allowviewcontent` varchar(150) NOT NULL default '',
  `allowdownload` varchar(150) NOT NULL default '',
  `forbidshow` tinyint(1) NOT NULL default '0',
  `config` text NOT NULL,
  `list_html` varchar(255) NOT NULL default '',
  `bencandy_html` varchar(255) NOT NULL default '',
  `domain` varchar(150) NOT NULL default '',
  `domain_dir` varchar(100) NOT NULL default '',
  PRIMARY KEY  (`fid`),
  KEY `fup` (`fup`),
  KEY `fmid` (`mid`),
  KEY `mid` (`mid`),
  KEY `fup_2` (`fup`,`list`)
) ENGINE=MyISAM AUTO_INCREMENT=46 DEFAULT CHARSET=gbk;


DROP TABLE IF EXISTS qb_picmsg_comments;
CREATE TABLE `qb_picmsg_comments` (
  `cid` mediumint(7) unsigned NOT NULL auto_increment,
  `id` int(10) unsigned NOT NULL default '0',
  `fid` mediumint(7) unsigned NOT NULL default '0',
  `cids` int(10) NOT NULL,
  `cuid` mediumint(7) NOT NULL default '0',
  `uid` mediumint(7) unsigned NOT NULL default '0',
  `username` varchar(30) NOT NULL default '',
  `posttime` int(10) NOT NULL default '0',
  `content` text NOT NULL,
  `ip` varchar(15) NOT NULL default '',
  `icon` tinyint(3) NOT NULL default '0',
  `yz` tinyint(1) NOT NULL default '0',
  `ifcom` tinyint(1) NOT NULL default '0',
  `agree` mediumint(5) NOT NULL default '0',
  `disagree` mediumint(5) NOT NULL default '0',
  PRIMARY KEY  (`cid`),
  KEY `aid` (`id`),
  KEY `fid` (`fid`),
  KEY `uid` (`uid`),
  KEY `ifcom` (`ifcom`)
) ENGINE=MyISAM DEFAULT CHARSET=gbk;


DROP TABLE IF EXISTS qb_picmsg_config;
CREATE TABLE `qb_picmsg_config` (
  `c_key` varchar(50) NOT NULL default '',
  `c_value` text NOT NULL,
  `c_descrip` text NOT NULL,
  PRIMARY KEY  (`c_key`)
) ENGINE=MyISAM DEFAULT CHARSET=gbk;


DROP TABLE IF EXISTS qb_picmsg_content;
CREATE TABLE `qb_picmsg_content` (
  `id` mediumint(7) unsigned NOT NULL auto_increment,
  `title` varchar(150) NOT NULL default '',
  `smalltitle` varchar(100) NOT NULL default '',
  `fid` mediumint(7) unsigned NOT NULL default '0',
  `mid` mediumint(5) NOT NULL default '0',
  `fname` varchar(50) NOT NULL default '',
  `hits` mediumint(7) NOT NULL default '0',
  `pages` smallint(4) NOT NULL default '0',
  `comments` mediumint(7) NOT NULL default '0',
  `posttime` int(10) NOT NULL default '0',
  `list` int(10) NOT NULL default '0',
  `uid` mediumint(7) NOT NULL default '0',
  `username` varchar(30) NOT NULL default '',
  `author` varchar(30) NOT NULL default '',
  `copyfrom` varchar(100) NOT NULL default '',
  `copyfromurl` varchar(150) NOT NULL default '',
  `titlecolor` varchar(15) NOT NULL default '',
  `fonttype` tinyint(1) NOT NULL default '0',
  `picurl` varchar(150) NOT NULL default '0',
  `ispic` tinyint(1) NOT NULL default '0',
  `yz` tinyint(1) NOT NULL default '0',
  `yzer` varchar(30) NOT NULL default '',
  `yztime` int(10) NOT NULL default '0',
  `levels` tinyint(2) NOT NULL default '0',
  `levelstime` int(10) NOT NULL default '0',
  `keywords` varchar(100) NOT NULL default '',
  `jumpurl` varchar(150) NOT NULL default '',
  `iframeurl` varchar(150) NOT NULL default '',
  `style` varchar(15) NOT NULL default '',
  `template` varchar(255) NOT NULL default '',
  `target` tinyint(1) NOT NULL default '0',
  `ip` varchar(15) NOT NULL default '',
  `lastfid` mediumint(7) NOT NULL default '0',
  `money` mediumint(7) NOT NULL default '0',
  `buyuser` text NOT NULL,
  `passwd` varchar(32) NOT NULL default '',
  `allowdown` varchar(150) NOT NULL default '',
  `allowview` varchar(150) NOT NULL default '',
  `editer` varchar(30) NOT NULL default '',
  `edittime` int(10) NOT NULL default '0',
  `begintime` int(10) NOT NULL default '0',
  `endtime` int(10) NOT NULL default '0',
  `description` text NOT NULL,
  `lastview` int(10) NOT NULL default '0',
  `digg_num` mediumint(7) NOT NULL default '0',
  `digg_time` int(10) NOT NULL default '0',
  `forbidcomment` tinyint(1) NOT NULL default '0',
  `ifvote` tinyint(1) NOT NULL default '0',
  `heart` varchar(255) NOT NULL default '',
  `htmlname` varchar(100) NOT NULL default '',
  `city_id` mediumint(7) NOT NULL default '0',
  `province_id` smallint(4) NOT NULL default '0',
  `zone_id` smallint(4) NOT NULL default '0',
  `street_id` smallint(4) NOT NULL default '0',
  `contentpic` text NOT NULL,
  `myfid` smallint(4) NOT NULL default '0',
  PRIMARY KEY  (`id`),
  KEY `fid` (`fid`),
  KEY `hits` (`hits`,`yz`,`fid`,`ispic`),
  KEY `list` (`list`,`yz`,`fid`,`ispic`),
  KEY `ispic` (`ispic`),
  KEY `uid` (`uid`),
  KEY `levels` (`levels`),
  KEY `digg_num` (`digg_num`),
  KEY `digg_time` (`digg_time`),
  KEY `mid` (`mid`),
  KEY `city_id` (`city_id`),
  KEY `posttime` (`yz`,`posttime`,`fid`,`ispic`)
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=gbk;


DROP TABLE IF EXISTS qb_picmsg_content_1;
CREATE TABLE `qb_picmsg_content_1` (
  `rid` mediumint(7) NOT NULL auto_increment,
  `subhead` varchar(150) NOT NULL default '',
  `id` mediumint(7) NOT NULL default '0',
  `fid` mediumint(7) NOT NULL default '0',
  `uid` mediumint(7) NOT NULL default '0',
  `topic` tinyint(1) NOT NULL default '0',
  `content` mediumtext NOT NULL,
  `orderid` mediumint(7) NOT NULL default '0',
  PRIMARY KEY  (`rid`),
  KEY `aid` (`id`,`topic`)
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=gbk;


DROP TABLE IF EXISTS qb_picmsg_digguser;
CREATE TABLE `qb_picmsg_digguser` (
  `did` int(10) NOT NULL auto_increment,
  `id` int(10) NOT NULL,
  `uid` int(10) NOT NULL,
  `posttime` int(10) NOT NULL,
  PRIMARY KEY  (`did`),
  KEY `id` (`id`),
  KEY `uid` (`uid`)
) ENGINE=MyISAM AUTO_INCREMENT=15 DEFAULT CHARSET=gbk;


DROP TABLE IF EXISTS qb_picmsg_keyword;
CREATE TABLE `qb_picmsg_keyword` (
  `id` mediumint(5) NOT NULL auto_increment,
  `keywords` varchar(30) NOT NULL default '',
  `list` int(10) NOT NULL default '0',
  `uid` mediumint(7) NOT NULL default '0',
  `ifhide` tinyint(1) NOT NULL default '0',
  `url` varchar(150) NOT NULL default '',
  `num` smallint(4) unsigned NOT NULL default '0',
  PRIMARY KEY  (`id`),
  KEY `keywords` (`keywords`),
  KEY `num` (`num`)
) ENGINE=MyISAM DEFAULT CHARSET=gbk;


DROP TABLE IF EXISTS qb_picmsg_keywordid;
CREATE TABLE `qb_picmsg_keywordid` (
  `id` mediumint(7) NOT NULL default '0',
  `aid` mediumint(7) NOT NULL default '0',
  KEY `id` (`id`),
  KEY `aid` (`aid`)
) ENGINE=MyISAM DEFAULT CHARSET=gbk;


DROP TABLE IF EXISTS qb_picmsg_mysort;
CREATE TABLE `qb_picmsg_mysort` (
  `fid` int(10) unsigned NOT NULL auto_increment,
  `name` varchar(60) NOT NULL default '',
  `uid` mediumint(10) NOT NULL default '0',
  `config` mediumtext NOT NULL,
  `list` tinyint(1) NOT NULL default '0',
  PRIMARY KEY  (`fid`),
  KEY `uid` (`uid`)
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=gbk;


DROP TABLE IF EXISTS qb_picmsg_ping;
CREATE TABLE `qb_picmsg_ping` (
  `zid` int(9) NOT NULL auto_increment,
  `cid` int(9) NOT NULL,
  `uid` int(9) NOT NULL,
  `content` mediumtext NOT NULL,
  PRIMARY KEY  (`zid`),
  KEY `cid` (`cid`)
) ENGINE=MyISAM DEFAULT CHARSET=gbk;


DROP TABLE IF EXISTS qb_picmsg_sort;
CREATE TABLE `qb_picmsg_sort` (
  `fid` mediumint(7) unsigned NOT NULL auto_increment,
  `fup` mediumint(7) unsigned NOT NULL default '0',
  `mid` mediumint(5) NOT NULL default '0',
  `name` varchar(50) NOT NULL default '',
  `class` smallint(4) NOT NULL default '0',
  `sons` smallint(4) NOT NULL default '0',
  `type` tinyint(1) NOT NULL default '0',
  `admin` varchar(100) NOT NULL default '',
  `list` int(10) NOT NULL default '0',
  `listorder` tinyint(2) NOT NULL default '0',
  `passwd` varchar(32) NOT NULL default '',
  `logo` varchar(150) NOT NULL default '',
  `descrip` text NOT NULL,
  `style` varchar(50) NOT NULL default '',
  `template` text NOT NULL,
  `jumpurl` varchar(150) NOT NULL default '',
  `maxperpage` tinyint(3) NOT NULL default '0',
  `metatitle` varchar(255) NOT NULL,
  `metakeywords` varchar(255) NOT NULL default '',
  `metadescription` varchar(255) NOT NULL default '',
  `allowcomment` tinyint(1) NOT NULL default '0',
  `allowpost` varchar(150) NOT NULL default '',
  `allowviewtitle` varchar(150) NOT NULL default '',
  `allowviewcontent` varchar(150) NOT NULL default '',
  `allowdownload` varchar(150) NOT NULL default '',
  `forbidshow` tinyint(1) NOT NULL default '0',
  `config` text NOT NULL,
  `list_html` varchar(255) NOT NULL default '',
  `bencandy_html` varchar(255) NOT NULL default '',
  `domain` varchar(150) NOT NULL default '',
  `domain_dir` varchar(100) NOT NULL default '',
  PRIMARY KEY  (`fid`),
  KEY `fup` (`fup`),
  KEY `fmid` (`mid`)
) ENGINE=MyISAM AUTO_INCREMENT=4 DEFAULT CHARSET=gbk;


DROP TABLE IF EXISTS qb_picmsg_zan;
CREATE TABLE `qb_picmsg_zan` (
  `zid` int(9) NOT NULL auto_increment,
  `cid` int(9) NOT NULL,
  `uid` int(9) NOT NULL,
  PRIMARY KEY  (`zid`),
  KEY `cid` (`cid`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=gbk;


DROP TABLE IF EXISTS qb_purse;
CREATE TABLE `qb_purse` (
  `uid` mediumint(7) NOT NULL default '0',
  `config` text NOT NULL,
  UNIQUE KEY `uid` (`uid`)
) ENGINE=MyISAM DEFAULT CHARSET=gbk;


DROP TABLE IF EXISTS qb_regnum;
CREATE TABLE `qb_regnum` (
  `sid` varchar(8) NOT NULL default '',
  `num` varchar(6) NOT NULL default '',
  `posttime` int(10) NOT NULL default '0',
  UNIQUE KEY `sid` (`sid`),
  KEY `posttime` (`num`,`posttime`)
) ENGINE=MEMORY DEFAULT CHARSET=latin1;


DROP TABLE IF EXISTS qb_rmb_consume;
CREATE TABLE `qb_rmb_consume` (
  `id` mediumint(7) NOT NULL auto_increment,
  `uid` mediumint(7) NOT NULL default '0',
  `money` float NOT NULL default '0',
  `about` varchar(255) NOT NULL default '',
  `posttime` int(10) NOT NULL default '0',
  `freeze` tinyint(1) NOT NULL default '0',
  PRIMARY KEY  (`id`),
  KEY `uid` (`uid`)
) ENGINE=MyISAM AUTO_INCREMENT=5 DEFAULT CHARSET=gbk;


DROP TABLE IF EXISTS qb_rmb_getout;
CREATE TABLE `qb_rmb_getout` (
  `id` mediumint(7) NOT NULL auto_increment,
  `uid` mediumint(7) NOT NULL default '0',
  `username` varchar(30) NOT NULL default '',
  `money` float NOT NULL default '0',
  `posttime` int(10) NOT NULL default '0',
  `banktype` varchar(20) NOT NULL default '',
  `bankname` varchar(100) NOT NULL default '',
  `ifpay` tinyint(1) NOT NULL default '0',
  `why` varchar(255) NOT NULL default '',
  `truename` varchar(30) NOT NULL default '',
  `tel` varchar(20) NOT NULL default '',
  `quitabout` text NOT NULL,
  `admin` varchar(30) NOT NULL default '',
  `replytime` int(10) NOT NULL default '0',
  PRIMARY KEY  (`id`),
  KEY `uid` (`uid`),
  KEY `ifpay` (`ifpay`)
) ENGINE=MyISAM DEFAULT CHARSET=gbk;


DROP TABLE IF EXISTS qb_rmb_infull;
CREATE TABLE `qb_rmb_infull` (
  `id` mediumint(7) NOT NULL auto_increment,
  `numcode` varchar(32) NOT NULL default '',
  `money` float NOT NULL default '0',
  `ifpay` tinyint(1) NOT NULL default '0',
  `posttime` int(10) NOT NULL default '0',
  `uid` mediumint(7) NOT NULL default '0',
  `username` varchar(32) NOT NULL default '',
  `banktype` varchar(15) NOT NULL default '',
  `bank1` varchar(100) NOT NULL default '',
  `bank2` varchar(100) NOT NULL default '',
  `ifatm` tinyint(1) NOT NULL default '0',
  `paytime` varchar(20) NOT NULL default '',
  PRIMARY KEY  (`id`),
  KEY `numcode` (`numcode`)
) ENGINE=MyISAM AUTO_INCREMENT=14 DEFAULT CHARSET=gbk;


DROP TABLE IF EXISTS qb_sell_telephone;
CREATE TABLE `qb_sell_telephone` (
  `id` mediumint(7) NOT NULL auto_increment,
  `uid` mediumint(7) NOT NULL default '0',
  `username` varchar(30) NOT NULL default '',
  `posttime` int(10) NOT NULL default '0',
  `begintime` int(10) NOT NULL default '0',
  `endtime` int(10) NOT NULL default '0',
  `money` int(7) NOT NULL default '0',
  `city_id` int(7) NOT NULL default '0',
  `yz` tinyint(1) NOT NULL default '1',
  `telephone` varchar(20) NOT NULL default '',
  `title` varchar(50) NOT NULL default '',
  `about` varchar(255) NOT NULL default '',
  PRIMARY KEY  (`id`),
  KEY `uid` (`uid`),
  KEY `yz` (`yz`),
  KEY `city_id` (`city_id`,`endtime`)
) ENGINE=MyISAM AUTO_INCREMENT=13 DEFAULT CHARSET=gbk;


DROP TABLE IF EXISTS qb_shop_address;
CREATE TABLE `qb_shop_address` (
  `rid` mediumint(7) NOT NULL auto_increment,
  `uid` mediumint(7) NOT NULL default '0',
  `order_username` varchar(20) NOT NULL default '',
  `order_phone` varchar(20) NOT NULL default '',
  `order_mobphone` varchar(15) NOT NULL default '',
  `order_email` varchar(50) NOT NULL default '',
  `order_qq` varchar(11) NOT NULL default '',
  `order_postcode` varchar(6) NOT NULL default '',
  `order_address` varchar(100) NOT NULL default '',
  PRIMARY KEY  (`rid`),
  KEY `uid` (`uid`)
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=gbk;


DROP TABLE IF EXISTS qb_shop_car;
CREATE TABLE `qb_shop_car` (
  `id` mediumint(7) NOT NULL auto_increment,
  `cid` mediumint(10) NOT NULL default '0',
  `joins` mediumint(7) NOT NULL default '0',
  `uid` mediumint(7) NOT NULL default '0',
  `type` tinyint(1) NOT NULL default '0',
  PRIMARY KEY  (`id`),
  KEY `cid` (`cid`),
  KEY `uid` (`uid`)
) ENGINE=MyISAM AUTO_INCREMENT=20 DEFAULT CHARSET=gbk;


DROP TABLE IF EXISTS qb_shop_class;
CREATE TABLE `qb_shop_class` (
  `fid` int(7) NOT NULL auto_increment,
  `fup` int(7) NOT NULL default '0',
  `name` varchar(60) NOT NULL default '',
  `list` int(10) NOT NULL default '0',
  PRIMARY KEY  (`fid`),
  KEY `fup` (`fup`)
) ENGINE=MyISAM AUTO_INCREMENT=43 DEFAULT CHARSET=gbk;


DROP TABLE IF EXISTS qb_shop_collection;
CREATE TABLE `qb_shop_collection` (
  `cid` mediumint(7) NOT NULL auto_increment,
  `id` mediumint(7) NOT NULL default '0',
  `uid` mediumint(7) NOT NULL default '0',
  `posttime` int(10) NOT NULL default '0',
  PRIMARY KEY  (`cid`),
  KEY `id` (`id`),
  KEY `uid` (`uid`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=gbk;


DROP TABLE IF EXISTS qb_shop_comments;
CREATE TABLE `qb_shop_comments` (
  `cid` mediumint(7) unsigned NOT NULL auto_increment,
  `cuid` int(7) NOT NULL default '0',
  `type` tinyint(2) NOT NULL default '0',
  `id` int(10) unsigned NOT NULL default '0',
  `fid` mediumint(7) unsigned NOT NULL default '0',
  `uid` mediumint(7) unsigned NOT NULL default '0',
  `username` varchar(30) NOT NULL default '',
  `posttime` int(10) NOT NULL default '0',
  `content` text NOT NULL,
  `ip` varchar(15) NOT NULL default '',
  `icon` tinyint(3) NOT NULL default '0',
  `yz` tinyint(1) NOT NULL default '0',
  `flowers` smallint(4) NOT NULL default '0',
  `egg` smallint(4) NOT NULL default '0',
  `oid` mediumint(7) NOT NULL default '0',
  `commentpic` text NOT NULL,
  PRIMARY KEY  (`cid`),
  KEY `type` (`type`)
) ENGINE=MyISAM DEFAULT CHARSET=gbk;


DROP TABLE IF EXISTS qb_shop_config;
CREATE TABLE `qb_shop_config` (
  `c_key` varchar(50) NOT NULL default '',
  `c_value` text NOT NULL,
  `c_descrip` text NOT NULL,
  PRIMARY KEY  (`c_key`)
) ENGINE=MyISAM DEFAULT CHARSET=gbk;


DROP TABLE IF EXISTS qb_shop_content;
CREATE TABLE `qb_shop_content` (
  `id` int(10) NOT NULL auto_increment,
  `title` varchar(100) NOT NULL default '',
  `mid` smallint(4) NOT NULL default '0',
  `fid` mediumint(7) NOT NULL default '0',
  `fname` varchar(50) NOT NULL default '',
  `hits` mediumint(7) NOT NULL default '0',
  `comments` mediumint(7) NOT NULL default '0',
  `posttime` int(10) NOT NULL default '0',
  `list` varchar(10) NOT NULL default '',
  `uid` mediumint(7) NOT NULL default '0',
  `username` varchar(30) NOT NULL default '',
  `titlecolor` varchar(15) NOT NULL default '',
  `picurl` varchar(150) NOT NULL default '',
  `ispic` tinyint(1) NOT NULL default '0',
  `yz` tinyint(1) NOT NULL default '0',
  `levels` tinyint(2) NOT NULL default '0',
  `levelstime` int(10) NOT NULL default '0',
  `keywords` varchar(100) NOT NULL default '',
  `ip` varchar(15) NOT NULL default '',
  `lastfid` mediumint(7) NOT NULL default '0',
  `money` mediumint(7) NOT NULL default '0',
  `passwd` varchar(32) NOT NULL default '',
  `begintime` int(10) NOT NULL default '0',
  `endtime` int(10) NOT NULL default '0',
  `lastview` int(10) NOT NULL default '0',
  `city_id` mediumint(7) NOT NULL default '0',
  `picnum` smallint(4) NOT NULL default '0',
  `price` double NOT NULL default '0',
  `sellnum` mediumint(7) NOT NULL default '0',
  `myfid` int(10) NOT NULL default '0',
  `shoptypes` text NOT NULL,
  `province_id` smallint(4) NOT NULL default '0',
  `zone_id` smallint(4) NOT NULL default '0',
  `street_id` smallint(4) NOT NULL default '0',
  `contentpic` text NOT NULL,
  PRIMARY KEY  (`id`),
  KEY `fid` (`fid`),
  KEY `ispic` (`ispic`),
  KEY `city_id` (`city_id`),
  KEY `list` (`list`,`fid`,`city_id`,`yz`),
  KEY `hits` (`hits`),
  KEY `myfid` (`myfid`)
) ENGINE=MyISAM AUTO_INCREMENT=11 DEFAULT CHARSET=gbk;


DROP TABLE IF EXISTS qb_shop_content_1;
CREATE TABLE `qb_shop_content_1` (
  `rid` mediumint(7) NOT NULL auto_increment,
  `id` mediumint(7) NOT NULL default '0',
  `fid` mediumint(7) NOT NULL default '0',
  `uid` mediumint(7) NOT NULL default '0',
  `content` mediumtext NOT NULL,
  `market_price` varchar(10) NOT NULL default '',
  `shoptype` varchar(50) NOT NULL default '',
  `storage` int(7) NOT NULL default '0',
  PRIMARY KEY  (`rid`),
  KEY `fid` (`fid`),
  KEY `id` (`id`),
  KEY `uid` (`uid`)
) ENGINE=MyISAM AUTO_INCREMENT=11 DEFAULT CHARSET=gbk;


DROP TABLE IF EXISTS qb_shop_content_2;
CREATE TABLE `qb_shop_content_2` (
  `rid` mediumint(7) NOT NULL auto_increment,
  `id` int(10) NOT NULL default '0',
  `fid` mediumint(7) NOT NULL default '0',
  `uid` mediumint(7) NOT NULL default '0',
  `content` mediumtext NOT NULL,
  `order_username` varchar(20) NOT NULL default '',
  `order_phone` varchar(20) NOT NULL default '',
  `order_mobphone` varchar(15) NOT NULL default '',
  `order_email` varchar(50) NOT NULL default '',
  `order_qq` varchar(11) NOT NULL default '',
  `order_postcode` varchar(6) NOT NULL default '',
  `order_sendtype` tinyint(1) NOT NULL,
  `order_paytype` tinyint(1) NOT NULL,
  `order_address` varchar(100) NOT NULL default '',
  PRIMARY KEY  (`rid`),
  KEY `fid` (`fid`),
  KEY `id` (`id`),
  KEY `uid` (`uid`)
) ENGINE=MyISAM AUTO_INCREMENT=14 DEFAULT CHARSET=gbk;


DROP TABLE IF EXISTS qb_shop_field;
CREATE TABLE `qb_shop_field` (
  `id` mediumint(7) NOT NULL auto_increment,
  `mid` mediumint(5) NOT NULL default '0',
  `title` varchar(50) NOT NULL default '',
  `field_name` varchar(30) NOT NULL default '',
  `field_type` varchar(15) NOT NULL default '',
  `field_leng` smallint(3) NOT NULL default '0',
  `orderlist` int(10) NOT NULL default '0',
  `form_type` varchar(15) NOT NULL default '',
  `field_inputwidth` smallint(3) default NULL,
  `field_inputheight` smallint(3) NOT NULL default '0',
  `form_set` text NOT NULL,
  `form_value` text NOT NULL,
  `form_units` varchar(30) NOT NULL default '',
  `form_title` text NOT NULL,
  `mustfill` tinyint(1) NOT NULL default '0',
  `listshow` tinyint(1) NOT NULL default '0',
  `listfilter` tinyint(1) default NULL,
  `search` tinyint(1) NOT NULL default '0',
  `allowview` varchar(255) NOT NULL default '',
  `allowpost` varchar(255) NOT NULL default '',
  `js_check` text NOT NULL,
  `js_checkmsg` varchar(255) NOT NULL default '',
  `classid` mediumint(7) NOT NULL default '0',
  `form_js` text NOT NULL,
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=154 DEFAULT CHARSET=gbk;


DROP TABLE IF EXISTS qb_shop_join;
CREATE TABLE `qb_shop_join` (
  `id` mediumint(7) NOT NULL auto_increment,
  `mid` smallint(4) NOT NULL default '0',
  `cid` mediumint(7) NOT NULL default '0',
  `cuid` mediumint(7) NOT NULL default '0',
  `fid` mediumint(7) NOT NULL default '0',
  `posttime` int(10) NOT NULL default '0',
  `uid` mediumint(7) NOT NULL default '0',
  `username` varchar(30) NOT NULL default '',
  `yz` tinyint(1) NOT NULL default '0',
  `ip` varchar(15) NOT NULL default '',
  `shopnum` mediumint(7) NOT NULL default '0',
  `ifpay` tinyint(1) NOT NULL default '0',
  `ifsend` tinyint(1) NOT NULL default '0',
  `totalmoney` float NOT NULL default '0',
  `banktype` varchar(15) NOT NULL default '',
  `emscode` varchar(32) NOT NULL default '',
  `products` text NOT NULL,
  `rmb` float NOT NULL default '0',
  `receive` tinyint(1) NOT NULL default '0',
  `ifcomment` tinyint(1) NOT NULL default '0',
  `numcode` varchar(32) NOT NULL,
  PRIMARY KEY  (`id`),
  KEY `mid` (`mid`),
  KEY `yz` (`yz`,`fid`,`mid`,`cid`),
  KEY `cuid` (`cuid`),
  KEY `cid` (`cid`)
) ENGINE=MyISAM AUTO_INCREMENT=14 DEFAULT CHARSET=gbk;


DROP TABLE IF EXISTS qb_shop_module;
CREATE TABLE `qb_shop_module` (
  `id` smallint(4) NOT NULL auto_increment,
  `sort_id` mediumint(5) NOT NULL default '0',
  `name` varchar(50) NOT NULL default '',
  `list` smallint(4) NOT NULL default '0',
  `style` varchar(50) NOT NULL default '',
  `config` text NOT NULL,
  `config2` text NOT NULL,
  `comment_type` tinyint(1) NOT NULL default '0',
  `ifdp` tinyint(1) NOT NULL default '0',
  `template` text NOT NULL,
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=gbk;


DROP TABLE IF EXISTS qb_shop_mysort;
CREATE TABLE `qb_shop_mysort` (
  `fid` int(10) NOT NULL auto_increment,
  `fup` int(10) NOT NULL default '0',
  `type` tinyint(1) NOT NULL default '0',
  `name` varchar(100) NOT NULL default '',
  `uid` int(10) NOT NULL default '0',
  `list` int(10) NOT NULL default '0',
  PRIMARY KEY  (`fid`)
) ENGINE=MyISAM AUTO_INCREMENT=6 DEFAULT CHARSET=gbk;


DROP TABLE IF EXISTS qb_shop_pic;
CREATE TABLE `qb_shop_pic` (
  `pid` mediumint(7) NOT NULL auto_increment,
  `id` mediumint(10) NOT NULL default '0',
  `fid` mediumint(7) NOT NULL default '0',
  `mid` smallint(4) NOT NULL default '0',
  `uid` mediumint(7) NOT NULL default '0',
  `type` tinyint(1) NOT NULL default '0',
  `imgurl` varchar(150) NOT NULL default '',
  `name` varchar(100) NOT NULL default '',
  `list` smallint(3) NOT NULL default '0',
  PRIMARY KEY  (`pid`),
  KEY `id` (`id`),
  KEY `fid` (`fid`)
) ENGINE=MyISAM AUTO_INCREMENT=31 DEFAULT CHARSET=gbk;


DROP TABLE IF EXISTS qb_shop_report;
CREATE TABLE `qb_shop_report` (
  `rid` mediumint(7) NOT NULL auto_increment,
  `id` mediumint(7) NOT NULL default '0',
  `fid` mediumint(7) NOT NULL default '0',
  `uid` mediumint(7) NOT NULL default '0',
  `username` varchar(30) NOT NULL default '',
  `posttime` int(10) NOT NULL default '0',
  `onlineip` varchar(15) NOT NULL default '',
  `type` tinyint(2) NOT NULL default '0',
  `content` text NOT NULL,
  `iftrue` tinyint(1) NOT NULL default '0',
  PRIMARY KEY  (`rid`)
) ENGINE=MyISAM DEFAULT CHARSET=gbk;


DROP TABLE IF EXISTS qb_shop_sort;
CREATE TABLE `qb_shop_sort` (
  `fid` mediumint(7) unsigned NOT NULL auto_increment,
  `fup` mediumint(7) unsigned NOT NULL default '0',
  `name` varchar(50) NOT NULL default '',
  `mid` smallint(4) NOT NULL default '0',
  `class` smallint(4) NOT NULL default '0',
  `sons` smallint(4) NOT NULL default '0',
  `type` tinyint(1) NOT NULL default '0',
  `admin` varchar(100) NOT NULL default '',
  `list` int(10) NOT NULL default '0',
  `listorder` tinyint(2) NOT NULL default '0',
  `passwd` varchar(32) NOT NULL default '',
  `logo` varchar(150) NOT NULL default '',
  `descrip` text NOT NULL,
  `style` varchar(50) NOT NULL default '',
  `template` text NOT NULL,
  `jumpurl` varchar(150) NOT NULL default '',
  `maxperpage` tinyint(3) NOT NULL default '0',
  `metatitle` varchar(250) NOT NULL default '',
  `metakeywords` varchar(255) NOT NULL default '',
  `metadescription` varchar(255) NOT NULL default '',
  `allowcomment` tinyint(1) NOT NULL default '0',
  `allowpost` varchar(150) NOT NULL default '',
  `allowviewtitle` varchar(150) NOT NULL default '',
  `allowviewcontent` varchar(150) NOT NULL default '',
  `allowdownload` varchar(150) NOT NULL default '',
  `forbidshow` tinyint(1) NOT NULL default '0',
  `config` mediumtext NOT NULL,
  `index_show` tinyint(1) NOT NULL default '0',
  `contents` mediumint(4) NOT NULL default '0',
  `tableid` varchar(30) NOT NULL default '',
  `dir_name` varchar(50) NOT NULL default '',
  `ifcolor` tinyint(4) NOT NULL default '0',
  PRIMARY KEY  (`fid`),
  KEY `mid` (`mid`),
  KEY `fup` (`fup`,`list`)
) ENGINE=MyISAM AUTO_INCREMENT=81 DEFAULT CHARSET=gbk;


DROP TABLE IF EXISTS qb_street;
CREATE TABLE `qb_street` (
  `fid` mediumint(7) unsigned NOT NULL auto_increment,
  `fup` mediumint(7) unsigned NOT NULL default '0',
  `name` varchar(200) NOT NULL default '',
  `class` smallint(4) NOT NULL default '0',
  `sons` smallint(4) NOT NULL default '0',
  `type` tinyint(1) NOT NULL default '0',
  `admin` varchar(100) NOT NULL default '',
  `list` int(10) NOT NULL default '0',
  `listorder` tinyint(2) NOT NULL default '0',
  `passwd` varchar(32) NOT NULL default '',
  `logo` varchar(150) NOT NULL default '',
  `descrip` text NOT NULL,
  `style` varchar(50) NOT NULL default '',
  `template` text NOT NULL,
  `jumpurl` varchar(150) NOT NULL default '',
  `maxperpage` tinyint(3) NOT NULL default '0',
  `metakeywords` varchar(255) NOT NULL default '',
  `metadescription` varchar(255) NOT NULL default '',
  `allowcomment` tinyint(1) NOT NULL default '0',
  `allowpost` varchar(150) NOT NULL default '',
  `allowviewtitle` varchar(150) NOT NULL default '',
  `allowviewcontent` varchar(150) NOT NULL default '',
  `allowdownload` varchar(150) NOT NULL default '',
  `forbidshow` tinyint(1) NOT NULL default '0',
  `config` text NOT NULL,
  `dirname` varchar(150) NOT NULL default '',
  PRIMARY KEY  (`fid`),
  KEY `fup` (`fup`)
) ENGINE=MyISAM AUTO_INCREMENT=129 DEFAULT CHARSET=gbk;


DROP TABLE IF EXISTS qb_weixinmenu;
CREATE TABLE `qb_weixinmenu` (
  `id` mediumint(5) NOT NULL auto_increment,
  `uid` int(7) NOT NULL default '0',
  `fid` mediumint(5) NOT NULL default '0',
  `name` varchar(80) NOT NULL default '',
  `keyword` varchar(255) NOT NULL default '',
  `linkurl` varchar(150) NOT NULL default '',
  `type` tinyint(2) NOT NULL default '0',
  `hide` tinyint(1) NOT NULL default '0',
  `list` smallint(4) NOT NULL default '0',
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=7 DEFAULT CHARSET=gbk;


DROP TABLE IF EXISTS qb_weixinmsg;
CREATE TABLE `qb_weixinmsg` (
  `id` int(10) NOT NULL auto_increment,
  `fid` int(10) NOT NULL default '0',
  `appid` varchar(32) NOT NULL default '',
  `uid` int(7) NOT NULL default '0',
  `username` varchar(50) NOT NULL default '',
  `posttime` int(10) NOT NULL default '0',
  `content` text NOT NULL,
  `type` tinyint(1) NOT NULL default '0',
  `url` varchar(100) NOT NULL default '',
  PRIMARY KEY  (`id`),
  KEY `uid` (`uid`)
) ENGINE=MyISAM DEFAULT CHARSET=gbk;


DROP TABLE IF EXISTS qb_weixinword;
CREATE TABLE `qb_weixinword` (
  `id` int(10) NOT NULL auto_increment,
  `ask` varchar(150) NOT NULL default '',
  `answer` text NOT NULL,
  `list` int(10) NOT NULL default '0',
  `type` tinyint(1) NOT NULL,
  PRIMARY KEY  (`id`),
  KEY `list` (`list`)
) ENGINE=MyISAM AUTO_INCREMENT=5 DEFAULT CHARSET=gbk;


DROP TABLE IF EXISTS qb_weixinyznum;
CREATE TABLE `qb_weixinyznum` (
  `sid` varchar(16) NOT NULL default '',
  `username` varchar(50) NOT NULL default '',
  `num` varchar(6) NOT NULL default '',
  `posttime` int(10) NOT NULL default '0',
  `wx_id` varchar(50) NOT NULL default '',
  UNIQUE KEY `sid` (`sid`),
  KEY `username` (`username`,`num`)
) ENGINE=MEMORY DEFAULT CHARSET=latin1;


DROP TABLE IF EXISTS qb_wxlogin;
CREATE TABLE `qb_wxlogin` (
  `usrid` varchar(15) NOT NULL,
  `sid` varchar(15) NOT NULL,
  `usrinfo` text NOT NULL,
  `posttime` int(10) NOT NULL,
  UNIQUE KEY `usrid` (`usrid`),
  KEY `sid` (`sid`)
) ENGINE=MyISAM DEFAULT CHARSET=gbk COMMENT='??????????????';


DROP TABLE IF EXISTS qb_zone;
CREATE TABLE `qb_zone` (
  `fid` mediumint(7) unsigned NOT NULL auto_increment,
  `fup` mediumint(7) unsigned NOT NULL default '0',
  `name` varchar(200) NOT NULL default '',
  `class` smallint(4) NOT NULL default '0',
  `sons` smallint(4) NOT NULL default '0',
  `type` tinyint(1) NOT NULL default '0',
  `admin` varchar(100) NOT NULL default '',
  `list` int(10) NOT NULL default '0',
  `listorder` tinyint(2) NOT NULL default '0',
  `passwd` varchar(32) NOT NULL default '',
  `logo` varchar(150) NOT NULL default '',
  `descrip` text NOT NULL,
  `style` varchar(50) NOT NULL default '',
  `template` text NOT NULL,
  `jumpurl` varchar(150) NOT NULL default '',
  `maxperpage` tinyint(3) NOT NULL default '0',
  `metakeywords` varchar(255) NOT NULL default '',
  `metadescription` varchar(255) NOT NULL default '',
  `allowcomment` tinyint(1) NOT NULL default '0',
  `allowpost` varchar(150) NOT NULL default '',
  `allowviewtitle` varchar(150) NOT NULL default '',
  `allowviewcontent` varchar(150) NOT NULL default '',
  `allowdownload` varchar(150) NOT NULL default '',
  `forbidshow` tinyint(1) NOT NULL default '0',
  `config` text NOT NULL,
  `dirname` varchar(150) NOT NULL default '',
  PRIMARY KEY  (`fid`),
  KEY `fup` (`fup`)
) ENGINE=MyISAM AUTO_INCREMENT=190 DEFAULT CHARSET=gbk;


INSERT INTO `qb_sort` VALUES ('34','1','0','ȵ¼','2','0','0','','0','0','','','','','a:4:{s:4:\"head\";s:0:\"\";s:4:\"foot\";s:0:\"\";s:4:\"list\";s:0:\"\";s:8:\"bencandy\";s:0:\"\";}','','0','','','1','','','','','0','a:7:{s:11:\"sonTitleRow\";N;s:12:\"sonTitleLeng\";N;s:9:\"cachetime\";N;s:12:\"sonListorder\";N;s:14:\"listContentNum\";s:0:\"\";s:12:\"ListShowType\";s:10:\"list_tpl/2\";s:15:\"ListShowBigType\";N;}','','','','');
INSERT INTO `qb_sort` VALUES ('1','0','0','','1','5','1','','0','0','','','','','a:3:{s:4:\"head\";s:0:\"\";s:4:\"foot\";s:0:\"\";s:4:\"list\";s:0:\"\";}','','0','','','0','','','','','0','a:11:{s:11:\"sonTitleRow\";s:0:\"\";s:12:\"sonTitleLeng\";s:0:\"\";s:9:\"cachetime\";N;s:12:\"sonListorder\";s:1:\"0\";s:14:\"listContentNum\";N;s:12:\"ListShowType\";N;s:14:\"label_bencandy\";s:0:\"\";s:10:\"channelDir\";s:4:\"nnew\";s:13:\"channelDomain\";s:0:\"\";s:10:\"label_list\";s:0:\"\";s:15:\"ListShowBigType\";s:13:\"bigsort_tpl/0\";}','','','','');
INSERT INTO `qb_sort` VALUES ('3','1','0','','2','0','0','','0','0','','','','','a:4:{s:4:\"head\";s:0:\"\";s:4:\"foot\";s:0:\"\";s:4:\"list\";s:0:\"\";s:8:\"bencandy\";s:0:\"\";}','','0','','','1','','','','','0','a:9:{s:11:\"sonTitleRow\";N;s:12:\"sonTitleLeng\";N;s:9:\"cachetime\";N;s:12:\"sonListorder\";N;s:14:\"listContentNum\";s:0:\"\";s:12:\"ListShowType\";s:10:\"list_tpl/6\";s:15:\"ListShowBigType\";N;s:10:\"label_list\";s:0:\"\";s:14:\"label_bencandy\";s:0:\"\";}','','','','');
INSERT INTO `qb_sort` VALUES ('39','1','0','web','2','0','0','','0','0','','','','','a:4:{s:4:\"head\";s:0:\"\";s:4:\"foot\";s:0:\"\";s:4:\"list\";s:0:\"\";s:8:\"bencandy\";s:0:\"\";}','','0','','','1','','','','','0','a:7:{s:11:\"sonTitleRow\";N;s:12:\"sonTitleLeng\";N;s:9:\"cachetime\";N;s:12:\"sonListorder\";N;s:14:\"listContentNum\";s:0:\"\";s:12:\"ListShowType\";s:10:\"list_tpl/8\";s:15:\"ListShowBigType\";N;}','','','','');
INSERT INTO `qb_sort` VALUES ('4','1','0','ITҵ','2','0','0','','0','0','','','','','a:4:{s:4:\"head\";s:0:\"\";s:4:\"foot\";s:0:\"\";s:4:\"list\";s:0:\"\";s:8:\"bencandy\";s:0:\"\";}','','31','','','1','3','','','','0','a:7:{s:11:\"sonTitleRow\";N;s:12:\"sonTitleLeng\";N;s:9:\"cachetime\";N;s:12:\"sonListorder\";N;s:14:\"listContentNum\";s:0:\"\";s:12:\"ListShowType\";s:11:\"list_tpl/10\";s:15:\"ListShowBigType\";N;}','','','','');
INSERT INTO `qb_sort` VALUES ('9','0','100','ͼƬ','1','1','1','','0','0','','','','','a:3:{s:4:\"head\";s:0:\"\";s:4:\"foot\";s:0:\"\";s:4:\"list\";s:0:\"\";}','','0','','','0','','','','','0','a:8:{s:11:\"sonTitleRow\";s:0:\"\";s:12:\"sonTitleLeng\";s:0:\"\";s:9:\"cachetime\";N;s:12:\"sonListorder\";s:1:\"0\";s:14:\"listContentNum\";N;s:12:\"ListShowType\";N;s:15:\"ListShowBigType\";s:1:\"0\";s:10:\"label_list\";s:0:\"\";}','','','','');
INSERT INTO `qb_sort` VALUES ('10','9','100','Ů','2','0','0','','0','0','','','22','','a:4:{s:4:\"head\";s:0:\"\";s:4:\"foot\";s:0:\"\";s:4:\"list\";s:0:\"\";s:8:\"bencandy\";s:0:\"\";}','','0','11','','1','8','','','','0','a:7:{s:11:\"sonTitleRow\";N;s:12:\"sonTitleLeng\";N;s:9:\"cachetime\";N;s:12:\"sonListorder\";N;s:14:\"listContentNum\";s:0:\"\";s:12:\"ListShowType\";s:1:\"0\";s:15:\"ListShowBigType\";N;}','','','','');
INSERT INTO `qb_sort` VALUES ('12','0','101','վ','1','0','0','','0','0','','','','','a:4:{s:4:\"head\";s:0:\"\";s:4:\"foot\";s:0:\"\";s:4:\"list\";s:0:\"\";s:8:\"bencandy\";s:0:\"\";}','','0','','','1','','','','','0','a:7:{s:11:\"sonTitleRow\";N;s:12:\"sonTitleLeng\";N;s:9:\"cachetime\";N;s:12:\"sonListorder\";N;s:14:\"listContentNum\";s:0:\"\";s:12:\"ListShowType\";s:1:\"0\";s:15:\"ListShowBigType\";N;}','','','','');
INSERT INTO `qb_sort` VALUES ('14','0','102','Ƶ','1','0','0','','0','0','','','','','a:4:{s:4:\"head\";s:0:\"\";s:4:\"foot\";s:0:\"\";s:4:\"list\";s:0:\"\";s:8:\"bencandy\";s:0:\"\";}','','0','','','1','','','','','0','a:8:{s:11:\"sonTitleRow\";N;s:12:\"sonTitleLeng\";N;s:9:\"cachetime\";N;s:12:\"sonListorder\";N;s:14:\"listContentNum\";s:0:\"\";s:12:\"ListShowType\";s:1:\"0\";s:14:\"label_bencandy\";s:0:\"\";s:15:\"ListShowBigType\";N;}','','','','');
INSERT INTO `qb_sort` VALUES ('32','1','0','Ƽ','2','0','0','','0','0','','','','','a:4:{s:4:\"head\";s:0:\"\";s:4:\"foot\";s:0:\"\";s:4:\"list\";s:0:\"\";s:8:\"bencandy\";s:0:\"\";}','','0','','','1','','','','','1','a:7:{s:11:\"sonTitleRow\";N;s:12:\"sonTitleLeng\";N;s:9:\"cachetime\";N;s:12:\"sonListorder\";N;s:14:\"listContentNum\";s:0:\"\";s:12:\"ListShowType\";s:0:\"\";s:15:\"ListShowBigType\";N;}','','','','');
INSERT INTO `qb_article_db` VALUES ('531');
INSERT INTO `qb_article_db` VALUES ('532');
INSERT INTO `qb_article_db` VALUES ('535');
INSERT INTO `qb_article_db` VALUES ('536');
INSERT INTO `qb_article_db` VALUES ('537');
INSERT INTO `qb_article_db` VALUES ('538');
INSERT INTO `qb_article_db` VALUES ('539');
INSERT INTO `qb_article_db` VALUES ('540');
INSERT INTO `qb_article_db` VALUES ('541');
INSERT INTO `qb_article_db` VALUES ('542');
INSERT INTO `qb_article_db` VALUES ('546');
INSERT INTO `qb_article_db` VALUES ('547');
INSERT INTO `qb_article_db` VALUES ('548');
INSERT INTO `qb_article_db` VALUES ('549');
INSERT INTO `qb_article_db` VALUES ('550');
INSERT INTO `qb_article_db` VALUES ('551');
INSERT INTO `qb_article_db` VALUES ('552');
INSERT INTO `qb_article_db` VALUES ('553');
INSERT INTO `qb_article_db` VALUES ('554');
INSERT INTO `qb_article_db` VALUES ('555');
INSERT INTO `qb_article_db` VALUES ('556');
INSERT INTO `qb_article_db` VALUES ('557');
INSERT INTO `qb_article_db` VALUES ('558');
INSERT INTO `qb_article_db` VALUES ('559');
INSERT INTO `qb_article_db` VALUES ('560');
INSERT INTO `qb_article_db` VALUES ('565');
INSERT INTO `qb_article_db` VALUES ('566');
INSERT INTO `qb_article_db` VALUES ('567');
INSERT INTO `qb_article_db` VALUES ('568');
INSERT INTO `qb_article_db` VALUES ('569');
INSERT INTO `qb_article_db` VALUES ('570');
INSERT INTO `qb_article_db` VALUES ('571');
INSERT INTO `qb_article_db` VALUES ('572');
INSERT INTO `qb_article_db` VALUES ('573');
INSERT INTO `qb_article_db` VALUES ('574');
INSERT INTO `qb_article_db` VALUES ('575');
INSERT INTO `qb_article_db` VALUES ('576');
INSERT INTO `qb_article_db` VALUES ('577');
INSERT INTO `qb_article_db` VALUES ('578');
INSERT INTO `qb_article_db` VALUES ('579');
INSERT INTO `qb_article_db` VALUES ('580');
INSERT INTO `qb_article_db` VALUES ('581');
INSERT INTO `qb_article_db` VALUES ('582');
INSERT INTO `qb_article_db` VALUES ('583');
INSERT INTO `qb_article_db` VALUES ('593');
INSERT INTO `qb_article_db` VALUES ('594');
INSERT INTO `qb_article_db` VALUES ('595');
INSERT INTO `qb_article_db` VALUES ('598');
INSERT INTO `qb_article_db` VALUES ('599');
INSERT INTO `qb_article_db` VALUES ('601');
INSERT INTO `qb_article_db` VALUES ('603');
INSERT INTO `qb_article_db` VALUES ('604');
INSERT INTO `qb_article_db` VALUES ('605');
INSERT INTO `qb_article_db` VALUES ('606');
INSERT INTO `qb_article_db` VALUES ('607');
INSERT INTO `qb_article_db` VALUES ('608');
INSERT INTO `qb_article_db` VALUES ('609');
INSERT INTO `qb_article_db` VALUES ('610');
INSERT INTO `qb_article_db` VALUES ('611');
INSERT INTO `qb_article_db` VALUES ('612');
INSERT INTO `qb_article_db` VALUES ('613');
INSERT INTO `qb_article_db` VALUES ('614');
INSERT INTO `qb_article_db` VALUES ('615');
INSERT INTO `qb_article_db` VALUES ('616');
INSERT INTO `qb_article_db` VALUES ('617');
INSERT INTO `qb_article_db` VALUES ('618');
INSERT INTO `qb_article_db` VALUES ('619');
INSERT INTO `qb_article_db` VALUES ('620');
INSERT INTO `qb_article_db` VALUES ('621');
INSERT INTO `qb_article_db` VALUES ('622');
INSERT INTO `qb_article_db` VALUES ('623');
INSERT INTO `qb_article_db` VALUES ('624');
INSERT INTO `qb_article_db` VALUES ('625');
INSERT INTO `qb_article_db` VALUES ('626');
INSERT INTO `qb_article_db` VALUES ('627');
INSERT INTO `qb_article_db` VALUES ('628');
INSERT INTO `qb_article_db` VALUES ('629');
INSERT INTO `qb_article_db` VALUES ('630');
INSERT INTO `qb_article_db` VALUES ('631');
INSERT INTO `qb_article_db` VALUES ('637');
INSERT INTO `qb_article_db` VALUES ('638');
INSERT INTO `qb_article_db` VALUES ('640');
INSERT INTO `qb_article_db` VALUES ('641');
INSERT INTO `qb_article_db` VALUES ('642');
INSERT INTO `qb_article_db` VALUES ('643');
INSERT INTO `qb_article_db` VALUES ('644');
INSERT INTO `qb_article_db` VALUES ('645');
INSERT INTO `qb_article_db` VALUES ('646');
INSERT INTO `qb_article_db` VALUES ('647');
INSERT INTO `qb_article_db` VALUES ('648');
INSERT INTO `qb_article_db` VALUES ('649');
INSERT INTO `qb_article_db` VALUES ('650');
INSERT INTO `qb_article_db` VALUES ('651');
INSERT INTO `qb_article_db` VALUES ('652');
INSERT INTO `qb_article_db` VALUES ('653');
INSERT INTO `qb_article_db` VALUES ('654');
INSERT INTO `qb_article_db` VALUES ('655');
INSERT INTO `qb_article_db` VALUES ('656');
INSERT INTO `qb_article_db` VALUES ('657');
INSERT INTO `qb_article_db` VALUES ('658');
INSERT INTO `qb_article_db` VALUES ('659');
INSERT INTO `qb_article_db` VALUES ('660');
INSERT INTO `qb_article_db` VALUES ('661');
INSERT INTO `qb_article_db` VALUES ('662');
INSERT INTO `qb_article_db` VALUES ('663');
INSERT INTO `qb_article_db` VALUES ('664');
INSERT INTO `qb_article_db` VALUES ('665');
INSERT INTO `qb_article_db` VALUES ('883');
INSERT INTO `qb_article_db` VALUES ('884');
INSERT INTO `qb_article_db` VALUES ('885');
INSERT INTO `qb_article_db` VALUES ('886');
INSERT INTO `qb_article` VALUES ('576','ɶͶʡ߻رվ ƭ64Ԫ','','4','0','ITҵ','2','1','1','1240127373','1240127373','1','admin','','','','','0','','0','1','','0','0','0','ɶ  Ͷ ر վ ƭ 64Ԫ','','','','a:3:{s:4:\"head\";s:0:\"\";s:4:\"foot\";s:0:\"\";s:8:\"bencandy\";s:0:\"\";}','0','','0','0','','','','','','0','0','0','','1240202342','0','0','0','0','','');
INSERT INTO `qb_article` VALUES ('557','V6V7ʹ','','34','0','ȵ¼','1','1','0','1240060838','1240060838','1','admin','','','','','0','','0','1','','0','1','1240060860','','','','','a:3:{s:4:\"head\";s:0:\"\";s:4:\"foot\";s:0:\"\";s:8:\"bencandy\";s:0:\"\";}','0','','0','0','','','','','','1292640605','0','0','','1240142881','0','0','0','0','','');
INSERT INTO `qb_article` VALUES ('560','chinazƷչ װȥ','','34','0','ȵ¼','5','1','0','1240062925','1240062925','1','admin','','','','','0','article/34/1_20090420110424_5lRC8.jpg','1','1','','0','1','0',' Ʒ  װ ','','','','a:3:{s:4:\"head\";s:0:\"\";s:4:\"foot\";s:0:\"\";s:8:\"bencandy\";s:0:\"\";}','0','','0','0','','','','','','1240196570','0','0','','1240211417','0','0','0','0','','');
INSERT INTO `qb_article` VALUES ('565','ѧˮУ԰ӹע','','39','0','web','2','1','0','1240126531','1240126531','1','admin','','','','','0','','0','1','','0','0','0','ѧ У԰    ע','','','','a:3:{s:4:\"head\";s:0:\"\";s:4:\"foot\";s:0:\"\";s:8:\"bencandy\";s:0:\"\";}','0','','0','0','','','','','','0','0','0','','1292492249','0','0','0','0','','');
INSERT INTO `qb_article` VALUES ('577','ƶOPhoneֻ5½жԿiPhone','','4','0','ITҵ','0','1','0','1240127449','1240127449','1','admin','','','','','0','','0','1','','0','0','0','ƶ OPhoneֻ 5  Կ iPhone','','','','a:3:{s:4:\"head\";s:0:\"\";s:4:\"foot\";s:0:\"\";s:8:\"bencandy\";s:0:\"\";}','0','','0','0','','','','','','0','0','0','','0','0','0','0','0','','');
INSERT INTO `qb_article` VALUES ('558','ݹؼͻʾ,ͼƬʱBUG','','34','0','ȵ¼','2','1','0','1240061182','1240061182','1','admin','','','','','0','','0','1','','0','1','0','','','','','a:3:{s:4:\"head\";s:0:\"\";s:4:\"foot\";s:0:\"\";s:8:\"bencandy\";s:0:\"\";}','0','','0','0','','','','','','1292640555','0','0','','1240209066','0','0','0','0','','');
INSERT INTO `qb_article` VALUES ('601','»1996ݳ','','14','102','Ƶ','8','1','0','1240193993','1240193993','1','admin','','','','','0','article/14/1_20090420100416_nC0fV.jpg','1','1','','0','0','0','»','','','','a:3:{s:4:\"head\";s:0:\"\";s:4:\"foot\";s:0:\"\";s:8:\"bencandy\";s:0:\"\";}','0','','0','0','','','','','','1240195173','0','0','','1290047383','0','0','0','0','','');
INSERT INTO `qb_article` VALUES ('578','־һҵ˱','','39','0','web','5','1','0','1240127959','1240127959','1','admin','','','','','0','article/39/1_20090419150430_a2XoC.jpg','1','1','','0','0','0','־ һ ҵ  ','','','','a:3:{s:4:\"head\";s:0:\"\";s:4:\"foot\";s:0:\"\";s:8:\"bencandy\";s:0:\"\";}','0','','0','0','','','','','','1240128030','0','0','','1290153075','0','0','0','0','','');
INSERT INTO `qb_article` VALUES ('559','йƶ3G ӭ͡ʱ','','34','0','ȵ¼','0','1','0','1240061760','1240061760','1','admin','','','','','0','article/34/1_20090418210444_jnTex.jpg','1','1','','0','1','1240061785','йƶ  ӭ  ʱ','','','','a:3:{s:4:\"head\";s:0:\"\";s:4:\"foot\";s:0:\"\";s:8:\"bencandy\";s:0:\"\";}','0','','0','0','','','','','','0','0','0','','0','0','0','0','0','','');
INSERT INTO `qb_article` VALUES ('603','벩V7¾̬,ȡ÷Ծͻ,ʱȫվ̬+˼ؾ̬','','39','0','web','4','1','0','1240201330','1240201330','1','admin','','','','','0','','0','1','','0','0','0','','','','','a:3:{s:4:\"head\";s:0:\"\";s:4:\"foot\";s:0:\"\";s:8:\"bencandy\";s:0:\"\";}','0','','0','0','','','','','','1292638888','0','0','','1292638889','1','1289289867','0','0','','');
INSERT INTO `qb_article` VALUES ('566','վ֪50⣬˳Ϊݸվ','','39','0','web','20','3','1','1240126684','1240126684','1','admin','','','','','0','','0','1','','0','0','0',' վ  ֪ ','','','','a:3:{s:4:\"head\";s:0:\"\";s:4:\"foot\";s:0:\"\";s:8:\"bencandy\";s:0:\"\";}','0','','0','0','','','','','','1240138830','0','0','','1289286094','3','1240210732','0','0','Ц|1~~|','');
INSERT INTO `qb_article` VALUES ('579','ѩųǻڲԭ ÿ9000','','4','0','ITҵ','4','1','1','1240128462','1240128462','1','admin','','','','','0','','0','1','','0','0','0','ѩ   ԭ  ÿ 9000','','','','a:3:{s:4:\"head\";s:0:\"\";s:4:\"foot\";s:0:\"\";s:8:\"bencandy\";s:0:\"\";}','0','','0','0','','','','','','0','0','0','','1240227601','0','0','0','0','','');
INSERT INTO `qb_article` VALUES ('604','V7ӭשУҩڣڲ','','39','0','web','21','1','0','1240209505','1240209505','1','admin','','','','','0','','0','1','','0','0','0','','','','','a:3:{s:4:\"head\";s:0:\"\";s:4:\"foot\";s:0:\"\";s:8:\"bencandy\";s:0:\"\";}','0','','0','0','','','','','','1292638835','0','0','','1291860644','1','1289289808','0','0','','');
INSERT INTO `qb_article` VALUES ('580','һй1620 Ѵ3.16','','4','0','ITҵ','4','1','0','1240128514','1240128514','1','admin','','','','','0','','0','1','','0','0','0','һ й   1620  3.16','','','','a:3:{s:4:\"head\";s:0:\"\";s:4:\"foot\";s:0:\"\";s:8:\"bencandy\";s:0:\"\";}','0','','0','0','','','','','','0','0','0','','1240212764','0','0','0','0','','');
INSERT INTO `qb_article` VALUES ('567','ɹĴҪأҪȥ','','39','0','web','2','1','1','1240126775','1240126775','1','admin','','','','','0','','0','1','','0','0','0',' ɹ  Ĵ Ҫ','','','','a:3:{s:4:\"head\";s:0:\"\";s:4:\"foot\";s:0:\"\";s:8:\"bencandy\";s:0:\"\";}','0','','0','0','','','','','','1240138868','0','0','','1289286122','0','0','0','0','','');
INSERT INTO `qb_article` VALUES ('581','֥˾ʷ󾻿 Լ35Ԫ','','4','0','ITҵ','1','1','0','1240128552','1240128552','1','admin','','','','','0','','0','1','','0','0','0','֥  ˾ ʷ   Լ 35Ԫ','','','','a:3:{s:4:\"head\";s:0:\"\";s:4:\"foot\";s:0:\"\";s:8:\"bencandy\";s:0:\"\";}','0','','0','0','','','','','','0','0','0','','1490415882','0','0','0','0','','');
INSERT INTO `qb_article` VALUES ('568','ɹվʢΪοβ','','39','0','web','1','1','0','1240126816','1240126816','1','admin','','','','','0','','0','1','','0','0','0',' վ Ϊ  ο','','','','a:3:{s:4:\"head\";s:0:\"\";s:4:\"foot\";s:0:\"\";s:8:\"bencandy\";s:0:\"\";}','0','','0','0','','','','','','1240138934','0','0','','1292492256','0','0','0','0','','');
INSERT INTO `qb_article` VALUES ('605','лģر','','10','100','Ů','2','1','0','1289371004','1289371004','1','admin','','','','','0','photo/10/1_20101110141136_wdd4w.jpg','1','1','','0','0','0','','','','','a:3:{s:4:\"head\";s:0:\"\";s:4:\"foot\";s:0:\"\";s:8:\"bencandy\";s:0:\"\";}','0','','0','0','','','','','','1494653660','0','0','','1494655495','0','0','0','0','','');
INSERT INTO `qb_article` VALUES ('582','վ߳ŻӰ','','4','0','ITҵ','1','1','0','1240128654','1240128654','1','admin','','','','','0','','0','1','','0','0','0',' վ ߳ Ż Ӱ','','','','a:3:{s:4:\"head\";s:0:\"\";s:4:\"foot\";s:0:\"\";s:8:\"bencandy\";s:0:\"\";}','0','','0','0','','','','','','0','0','0','','1240202171','0','0','0','0','','');
INSERT INTO `qb_article` VALUES ('569','ŻͷϷ гǰ޴','','39','0','web','0','1','0','1240126852','1240126852','1','admin','','','','','0','','0','1','','0','0','0',' Ż  ͷ Ϸ  г ǰ ޴','','','','a:3:{s:4:\"head\";s:0:\"\";s:4:\"foot\";s:0:\"\";s:8:\"bencandy\";s:0:\"\";}','0','','0','0','','','','','','0','0','0','','0','0','0','0','0','','');
INSERT INTO `qb_article` VALUES ('583','Ʒǰʱְҵ滮һˣ','','4','0','ITҵ','13','1','0','1240128744','1240128744','1','admin','','','','','0','article/4/1_20170513100506_w3ytf.jpg','1','1','','0','0','0','Ʒ   ְҵ滮','','','','a:3:{s:4:\"head\";s:0:\"\";s:4:\"foot\";s:0:\"\";s:8:\"bencandy\";s:0:\"\";}','0','','0','0','','','','','','1494644425','0','0','','1494644400','0','0','0','0','','');
INSERT INTO `qb_article` VALUES ('606','㶫ȫ˻ŮӪ','','10','100','Ů','1','1','0','1289371066','1289371066','1','admin','','','','','0','photo/10/1_20101110141139_i1ypy.jpg','1','1','','0','0','0','','','','','a:3:{s:4:\"head\";s:0:\"\";s:4:\"foot\";s:0:\"\";s:8:\"bencandy\";s:0:\"\";}','0','','0','0','','','','','','1494653669','0','0','','1289371068','0','0','0','0','','');
INSERT INTO `qb_article` VALUES ('570','1219,Ҳ콫V7','','34','0','ȵ¼','1','1','0','1240126932','1240126932','1','admin','','','','','0','','0','1','','0','0','0','','','','','a:3:{s:4:\"head\";s:0:\"\";s:4:\"foot\";s:0:\"\";s:8:\"bencandy\";s:0:\"\";}','0','','38','0','','','','','','1292639697','0','0','','1240212806','0','0','0','0','','');
INSERT INTO `qb_article` VALUES ('664','ٷΪ벩CMSע','','3','0','','2','1','0','1291865005','1291865005','1','admin','','','','','0','','0','1','','0','0','0','','','','','a:3:{s:4:\"head\";s:0:\"\";s:4:\"foot\";s:0:\"\";s:8:\"bencandy\";s:0:\"\";}','0','','0','0','','','','','','0','0','0','','1292638787','0','0','0','0','','');
INSERT INTO `qb_article` VALUES ('571','ع˹ȥչδ飡','','34','0','ȵ¼','2','1','0','1240127012','1240127012','1','admin','','','','','0','','0','1','','0','0','0','','','','','a:3:{s:4:\"head\";s:0:\"\";s:4:\"foot\";s:0:\"\";s:8:\"bencandy\";s:0:\"\";}','0','','38','0','','','','','','1292639905','0','0','','1292639906','0','0','0','0','','');
INSERT INTO `qb_article` VALUES ('607','','','10','100','Ů','1','1','0','1289371116','1289371116','1','admin','','','','','0','photo/10/1_20101110141134_qxblz.jpg','1','1','','0','0','0','','','','','a:3:{s:4:\"head\";s:0:\"\";s:4:\"foot\";s:0:\"\";s:8:\"bencandy\";s:0:\"\";}','0','','0','0','','','','','','1494653642','0','0','','1289371118','0','0','0','0','','');
INSERT INTO `qb_article` VALUES ('572','ԭPHP168ƷеVϵSϵУȫֿͬĹ˾Ӫ','','34','0','ȵ¼','0','1','0','1240127172','1240127172','1','admin','','','','','0','','0','1','','0','0','0','','','','','a:3:{s:4:\"head\";s:0:\"\";s:4:\"foot\";s:0:\"\";s:8:\"bencandy\";s:0:\"\";}','0','','38','0','','','','','','1292639985','0','0','','0','0','0','0','0','','');
INSERT INTO `qb_article` VALUES ('665','ٷڸƷƵͬʱ','','3','0','','10','1','0','1291865035','1291865035','1','admin','','','','','0','','0','1','','0','0','0','','','','','a:3:{s:4:\"head\";s:0:\"\";s:4:\"foot\";s:0:\"\";s:8:\"bencandy\";s:0:\"\";}','0','','0','0','','','','','','0','0','0','','1494646938','0','0','0','0','','');
INSERT INTO `qb_article` VALUES ('573','Ҫ棡Vϵн12·̳Ϊ벩cms','','34','0','ȵ¼','0','1','0','1240127229','1240127229','1','admin','','','','','0','','0','1','','0','0','0','','','','','a:3:{s:4:\"head\";s:0:\"\";s:4:\"foot\";s:0:\"\";s:8:\"bencandy\";s:0:\"\";}','0','','38','0','','','','','','1292640029','0','0','','0','0','0','0','0','','');
INSERT INTO `qb_article` VALUES ('593','Ϊ벩CMS,ܸýע!!','','3','0','','6','1','0','1240129686','1240129686','1','admin','','','','','0','article/3/1_20170513100509_icto0.jpg','1','1','','0','0','0','','','','','a:3:{s:4:\"head\";s:0:\"\";s:4:\"foot\";s:0:\"\";s:8:\"bencandy\";s:0:\"\";}','0','','0','0','','','','','','1494643875','0','0','','1494643844','0','0','0','0','Ц|1~~|','');
INSERT INTO `qb_article` VALUES ('608','ŮͼƬ','','10','100','Ů','1','1','0','1289371162','1289371162','1','admin','','','','','0','photo/10/1_20101110141120_fpwhq.jpg','1','1','','0','0','0','','','','','a:3:{s:4:\"head\";s:0:\"\";s:4:\"foot\";s:0:\"\";s:8:\"bencandy\";s:0:\"\";}','0','','0','0','','','','','','1494653586','0','0','','1289371164','0','0','0','0','','');
INSERT INTO `qb_article` VALUES ('574','eBayؽGmarket طйг','','4','0','ITҵ','0','1','0','1240127281','1240127281','1','admin','','','','','0','','0','1','','0','0','0','eBay ؽ Gmarket  ط й  г','','','','a:3:{s:4:\"head\";s:0:\"\";s:4:\"foot\";s:0:\"\";s:8:\"bencandy\";s:0:\"\";}','0','','0','0','','','','','','0','0','0','','0','0','0','0','0','','');
INSERT INTO `qb_article` VALUES ('594','ݱV7ͻ,ں̨ɶģɸ,ЭҶο.ԼҪ','','34','0','ȵ¼','10','1','0','1240129723','1585020644','1','admin','','','','','0','','0','1','','0','0','0','','','','','a:3:{s:4:\"head\";s:0:\"\";s:4:\"foot\";s:0:\"\";s:8:\"bencandy\";s:0:\"\";}','0','','3','0','','','','','','1292639096','0','0','','1490422479','0','0','0','0','','');
INSERT INTO `qb_article` VALUES ('609','У԰崿Ůд漯','','10','100','Ů','2','1','0','1289371211','1289371211','1','admin','','','','','0','photo/10/1_20101110141109_hsvcz.jpg','1','1','','0','0','0','','','','','a:3:{s:4:\"head\";s:0:\"\";s:4:\"foot\";s:0:\"\";s:8:\"bencandy\";s:0:\"\";}','0','','0','0','','','','','','1494653573','0','0','','1289374136','0','0','0','0','','');
INSERT INTO `qb_article` VALUES ('575','ͨŹ֣վΥ 򽫱','','4','0','ITҵ','1','1','0','1240127308','1240127308','1','admin','','','','','0','','0','1','','0','0','0','ͨ   վ  Υ','','','','a:3:{s:4:\"head\";s:0:\"\";s:4:\"foot\";s:0:\"\";s:8:\"bencandy\";s:0:\"\";}','0','','0','0','','','','','','0','0','0','','1289291749','0','0','0','0','','');
INSERT INTO `qb_article` VALUES ('595','V7Ӷʱ ,ʱݿ⹦','','34','0','ȵ¼','5','1','0','1240129752','1585020644','1','admin','','','','','0','','0','1','','0','0','0','','','','','a:3:{s:4:\"head\";s:0:\"\";s:4:\"foot\";s:0:\"\";s:8:\"bencandy\";s:0:\"\";}','0','','3','0','','','','','','1292639054','0','0','','1490421442','0','0','0','0','','');
INSERT INTO `qb_article` VALUES ('610','ĳĳѧУУչ','','10','100','Ů','3','1','0','1289371256','1289371256','1','admin','','','','','0','photo/10/1_20101110141153_lisq8.jpg','1','1','','0','0','0','','','','','a:3:{s:4:\"head\";s:0:\"\";s:4:\"foot\";s:0:\"\";s:8:\"bencandy\";s:0:\"\";}','0','','0','0','','','','','','1494653561','0','0','','1494653548','0','0','0','0','','');
INSERT INTO `qb_article` VALUES ('598','ӦҪ,V7ckeditor༭','','34','0','ȵ¼','4','1','0','1240129958','1585020644','1','admin','','','','','0','','0','1','','0','0','0','','','','','a:3:{s:4:\"head\";s:0:\"\";s:4:\"foot\";s:0:\"\";s:8:\"bencandy\";s:0:\"\";}','0','','3','0','','','','','','1292639000','0','0','','1292492079','0','0','0','0','','');
INSERT INTO `qb_article` VALUES ('611','ˮ֮ܽŮƪ','','10','100','Ů','0','1','0','1289371328','1289371328','1','admin','','','','','0','article/10/1_20101110141106_ipncy.jpg.jpg','1','1','','0','0','0','','','','','a:3:{s:4:\"head\";s:0:\"\";s:4:\"foot\";s:0:\"\";s:8:\"bencandy\";s:0:\"\";}','0','','0','0','','','','','','0','0','0','','0','0','0','0','0','','');
INSERT INTO `qb_article` VALUES ('599','벩̨벩CMSһڿʼƷ񣬻ӭ룡','','3','0','','32','1','2','1240130011','1240130011','1','admin','','','','','0','','0','1','','0','0','0','','','','','a:3:{s:4:\"head\";s:0:\"\";s:4:\"foot\";s:0:\"\";s:8:\"bencandy\";s:0:\"\";}','0','','0','0','','','','','','1292638965','0','0','','1494644822','5','1241074117','0','0','Ц|1~~|1~~|','');
INSERT INTO `qb_article` VALUES ('612','ʱпŵйŮ','','10','100','Ů','1','1','0','1289371376','1289371376','1','admin','','','','','0','photo/10/1_20101110141155_s3htx.jpg','1','1','','0','0','0','','','','','a:3:{s:4:\"head\";s:0:\"\";s:4:\"foot\";s:0:\"\";s:8:\"bencandy\";s:0:\"\";}','0','','0','0','','','','','','1494653538','0','0','','1494653492','0','0','0','0','','');
INSERT INTO `qb_article` VALUES ('613','Ů󼯺','','10','100','Ů','3','1','0','1289372452','1289372452','1','admin','','','','','0','photo/10/1_20101110151145_1aiuz.jpg','1','1','','0','0','0','','','','','a:3:{s:4:\"head\";s:0:\"\";s:4:\"foot\";s:0:\"\";s:8:\"bencandy\";s:0:\"\";}','0','','0','0','','','','','','1494653523','0','0','','1494653489','0','0','0','0','','');
INSERT INTO `qb_article` VALUES ('614','ѧУŶ','','10','100','Ů','2','1','0','1289372494','1289372494','1','admin','','','','','0','photo/10/1_20101110151129_l9jnr.jpg','1','1','','0','0','0','','','','','a:3:{s:4:\"head\";s:0:\"\";s:4:\"foot\";s:0:\"\";s:8:\"bencandy\";s:0:\"\";}','0','','0','0','','','','','','1494653511','0','0','','1494653487','0','0','0','0','','');
INSERT INTO `qb_article` VALUES ('615','ŮŶ','','10','100','Ů','3','1','0','1289372531','1289372531','1','admin','','','','','0','photo/10/1_20101110151151_yggdp.jpg','1','1','','0','0','0','','','','','a:3:{s:4:\"head\";s:0:\"\";s:4:\"foot\";s:0:\"\";s:8:\"bencandy\";s:0:\"\";}','0','','0','0','','','','','','1494653413','0','0','','1494653394','0','0','0','0','','');
INSERT INTO `qb_article` VALUES ('542','䡿ȶǴģڹѧҵϵݽǿƼĻ','','14','102','Ƶ','49','1','0','1239789196','1239789196','1','admin','','','','','0','article/14/1_20090420100452_yuW0C.jpg','1','1','','0','0','0','Ǵ','','','','a:3:{s:4:\"head\";s:0:\"\";s:4:\"foot\";s:0:\"\";s:8:\"bencandy\";s:0:\"\";}','0','','0','0','','','','','','1240287737','0','0','','1289443055','0','0','0','0','','');
INSERT INTO `qb_article` VALUES ('616','ˮ֮ܽٸƪ','','10','100','Ů','3','1','0','1289372572','1289372572','1','admin','','','','','0','photo/10/1_20101110151138_sobq7.jpg','1','1','','0','0','0','','','','','a:3:{s:4:\"head\";s:0:\"\";s:4:\"foot\";s:0:\"\";s:8:\"bencandy\";s:0:\"\";}','0','','0','0','','','','','','1494653387','0','0','','1494653361','0','0','0','0','','');
INSERT INTO `qb_article` VALUES ('617','ԸеУ԰Ůǰ','','10','100','Ů','7','1','0','1289372655','1289372655','1','admin','','','','','0','photo/10/1_20101110151153_b8cy7.jpg','1','1','','0','0','0','','','','','a:3:{s:4:\"head\";s:0:\"\";s:4:\"foot\";s:0:\"\";s:8:\"bencandy\";s:0:\"\";}','0','','0','0','','','','','','1494653353','0','0','','1494653310','0','0','0','0','','');
INSERT INTO `qb_article` VALUES ('618','һ֮пѰҵŮ?','','10','100','Ů','6','1','0','1289372720','1289372720','1','admin','','','','','0','photo/10/1_20101110151101_2kjyw.jpg','1','1','','0','0','0','','','','','a:3:{s:4:\"head\";s:0:\"\";s:4:\"foot\";s:0:\"\";s:8:\"bencandy\";s:0:\"\";}','0','','0','0','','','','','','1494653278','0','0','','1494656115','0','0','0','0','','');
INSERT INTO `qb_article` VALUES ('532','ƯŮ','','10','100','Ů','4','1','0','1239786083','1239786083','1','admin','','','','','0','article/10/1_20090415170437_jCYhW.jpg','1','1','','0','0','0','Ư Ů','','','','a:3:{s:4:\"head\";s:0:\"\";s:4:\"foot\";s:0:\"\";s:8:\"bencandy\";s:0:\"\";}','0','','0','0','','','','','','0','0','0','','1289370913','0','0','0','0','','');
INSERT INTO `qb_article` VALUES ('619','','','14','102','Ƶ','1','1','0','1289443544','1289443544','1','admin','','','','','0','article/14/1_20101111101118_fwotb.jpg','1','1','','0','0','0','','','','','a:3:{s:4:\"head\";s:0:\"\";s:4:\"foot\";s:0:\"\";s:8:\"bencandy\";s:0:\"\";}','0','','0','0','','','','','','0','0','0','','1289443547','0','0','0','0','','');
INSERT INTO `qb_article` VALUES ('620','ɽ֮','','14','102','Ƶ','1','1','0','1289443732','1289443732','1','admin','','','','','0','article/14/1_20101111101151_3mcxo.jpg','1','1','','0','0','0','','','','','a:3:{s:4:\"head\";s:0:\"\";s:4:\"foot\";s:0:\"\";s:8:\"bencandy\";s:0:\"\";}','0','','0','0','','','','','','0','0','0','','1289443736','0','0','0','0','','');
INSERT INTO `qb_article` VALUES ('621','滨','','14','102','Ƶ','1','1','0','1289444013','1289444013','1','admin','','','','','0','article/14/1_20101111101131_qzlz6.jpg','1','1','','0','0','0','','','','','a:3:{s:4:\"head\";s:0:\"\";s:4:\"foot\";s:0:\"\";s:8:\"bencandy\";s:0:\"\";}','0','','0','0','','','','','','0','0','0','','1289444016','0','0','0','0','','');
INSERT INTO `qb_article` VALUES ('622','Ͼ','','14','102','Ƶ','1','1','0','1289444184','1289444184','1','admin','','','','','0','article/14/1_20101111101155_qokvd.jpg','1','1','','0','0','0','','','','','a:3:{s:4:\"head\";s:0:\"\";s:4:\"foot\";s:0:\"\";s:8:\"bencandy\";s:0:\"\";}','0','','0','0','','','','','','0','0','0','','1289444186','0','0','0','0','','');
INSERT INTO `qb_article` VALUES ('538','ϵͳ','','12','101','վ','3','1','0','1239788484','1239788484','1','admin','','','','','0','','0','1','','0','0','0','  ϵͳ','','','','a:3:{s:4:\"head\";s:0:\"\";s:4:\"foot\";s:0:\"\";s:8:\"bencandy\";s:0:\"\";}','0','','0','0','','','','','','0','0','0','','1494642248','0','0','0','0','','');
INSERT INTO `qb_article` VALUES ('623','׼','','14','102','Ƶ','1','1','0','1289444331','1289444331','1','admin','','','','','0','article/14/1_20101111101146_5gseq.jpg','1','1','','0','0','0','','','','','a:3:{s:4:\"head\";s:0:\"\";s:4:\"foot\";s:0:\"\";s:8:\"bencandy\";s:0:\"\";}','0','','0','0','','','','','','0','0','0','','1289444333','0','0','0','0','','');
INSERT INTO `qb_article` VALUES ('539','qibosoftϢϵͳ','','12','101','վ','2','1','0','1239788649','1239788649','1','admin','','','','','0','','0','1','','0','0','0','qibosoft  Ϣϵͳ','','','','a:3:{s:4:\"head\";s:0:\"\";s:4:\"foot\";s:0:\"\";s:8:\"bencandy\";s:0:\"\";}','0','','0','0','','','','','','0','0','0','','1240209778','0','0','0','0','','');
INSERT INTO `qb_article` VALUES ('624','ʦظ','','14','102','Ƶ','0','1','0','1289444474','1289444474','1','admin','','','','','0','article/14/1_20101111111112_5gxkh.jpg','1','1','','0','0','0','','','','','a:3:{s:4:\"head\";s:0:\"\";s:4:\"foot\";s:0:\"\";s:8:\"bencandy\";s:0:\"\";}','0','','0','0','','','','','','0','0','0','','0','0','0','0','0','','');
INSERT INTO `qb_article` VALUES ('540','qibosoftϵͳ','','12','101','վ','1','1','0','1239788777','1239788777','1','admin','','','','','0','','0','1','','0','0','0','qibosoft  ϵͳ','','','','a:3:{s:4:\"head\";s:0:\"\";s:4:\"foot\";s:0:\"\";s:8:\"bencandy\";s:0:\"\";}','0','','0','0','','','','','','0','0','0','','1240192777','0','0','0','0','','');
INSERT INTO `qb_article` VALUES ('625','','','14','102','Ƶ','0','1','0','1289444586','1289444586','1','admin','','','','','0','article/14/1_20101111111151_g9bji.jpg','1','1','','0','0','0','','','','','a:3:{s:4:\"head\";s:0:\"\";s:4:\"foot\";s:0:\"\";s:8:\"bencandy\";s:0:\"\";}','0','','0','0','','','','','','0','0','0','','0','0','0','0','0','','');
INSERT INTO `qb_article` VALUES ('541','qibosoft֪ϵͳ','','12','101','վ','4','1','0','1239788863','1239788863','1','admin','','','','','0','','0','1','','0','0','0','qibosoft ֪ ϵͳ','','','','a:3:{s:4:\"head\";s:0:\"\";s:4:\"foot\";s:0:\"\";s:8:\"bencandy\";s:0:\"\";}','0','','0','0','','','','','','0','0','0','','1494642255','0','0','0','0','','');
INSERT INTO `qb_article` VALUES ('626','Ǳ','','14','102','Ƶ','1','1','0','1289444719','1289444719','1','admin','','','','','0','article/14/1_20101111111104_b7seu.jpg','1','1','','0','0','0','','','','','a:3:{s:4:\"head\";s:0:\"\";s:4:\"foot\";s:0:\"\";s:8:\"bencandy\";s:0:\"\";}','0','','0','0','','','','','','0','0','0','','1289444723','0','0','0','0','','');
INSERT INTO `qb_article` VALUES ('627','','','14','102','Ƶ','0','1','0','1289444990','1289444990','1','admin','','','','','0','article/14/1_20101111111136_av34e.jpg','1','1','','0','0','0','','','','','a:3:{s:4:\"head\";s:0:\"\";s:4:\"foot\";s:0:\"\";s:8:\"bencandy\";s:0:\"\";}','0','','0','0','','','','','','0','0','0','','0','0','0','0','0','','');
INSERT INTO `qb_article` VALUES ('628','Ͻ˷˼','','14','102','Ƶ','0','1','0','1289445159','1289445159','1','admin','','','','','0','article/14/1_20101111111127_oejya.jpg','1','1','','0','0','0','','','','','a:3:{s:4:\"head\";s:0:\"\";s:4:\"foot\";s:0:\"\";s:8:\"bencandy\";s:0:\"\";}','0','','0','0','','','','','','0','0','0','','0','0','0','0','0','','');
INSERT INTO `qb_article` VALUES ('629','ǳ2','','14','102','Ƶ','2','1','0','1289445315','1289445315','1','admin','','','','','0','article/14/1_20101111111112_vxacq.jpg','1','1','','0','0','0','','','','','a:3:{s:4:\"head\";s:0:\"\";s:4:\"foot\";s:0:\"\";s:8:\"bencandy\";s:0:\"\";}','0','','0','0','','','','','','0','0','0','','1289449940','0','0','0','0','','');
INSERT INTO `qb_article` VALUES ('531','˼伫ƷŮ2ŹҲ','','10','100','Ů','2','1','0','1239785963','1239785963','1','admin','','','','','0','photo/10/1_20090415160401_XMXbb.jpg','1','1','','0','0','0','˼ ƷŮ Ź   ','','','','a:3:{s:4:\"head\";s:0:\"\";s:4:\"foot\";s:0:\"\";s:8:\"bencandy\";s:0:\"\";}','0','','0','0','','','','','','1494653651','0','0','','1239786007','0','0','0','0','','');
INSERT INTO `qb_article` VALUES ('630','÷','','14','102','Ƶ','2','1','0','1289445578','1289445578','1','admin','','','','','0','article/14/1_20101111111102_0wmfj.jpg','1','1','','0','0','0','','','','','a:3:{s:4:\"head\";s:0:\"\";s:4:\"foot\";s:0:\"\";s:8:\"bencandy\";s:0:\"\";}','0','','0','0','','','','','','0','0','0','','1494648381','0','0','0','0','','');
INSERT INTO `qb_article` VALUES ('631','Ů˲','','14','102','Ƶ','2','1','0','1289445777','1289445777','1','admin','','','','','0','article/14/1_20101111111151_pmvxo.jpg','1','1','','0','0','0','','','','','a:3:{s:4:\"head\";s:0:\"\";s:4:\"foot\";s:0:\"\";s:8:\"bencandy\";s:0:\"\";}','0','','0','0','','','','','','0','0','0','','1494648336','0','0','0','0','','');
INSERT INTO `qb_article` VALUES ('884','塷벻ʵ֣','','34','0','ȵ¼','2','1','0','1494643081','1494643081','1','admin','','','','','0','article/34/1_20170513100535_hv8q4.jpg.jpg','1','1','','0','0','0','','','','','a:3:{s:4:\"head\";s:0:\"\";s:4:\"foot\";s:0:\"\";s:8:\"bencandy\";s:0:\"\";}','0','127.0.0.1','0','0','','','','','','0','0','0','','1494655795','0','0','0','0','','');
INSERT INTO `qb_article` VALUES ('885','14ǰ˫̥ûŮʮ˱','','34','0','ȵ¼','4','1','0','1494643199','1494643199','1','admin','','','','','0','article/34/1_20170513100556_qkigh.jpg.jpg','1','1','','0','0','0','','','','','a:3:{s:4:\"head\";s:0:\"\";s:4:\"foot\";s:0:\"\";s:8:\"bencandy\";s:0:\"\";}','0','127.0.0.1','0','0','','','','','','0','0','0','','1494655792','0','0','0','0','','');
INSERT INTO `qb_article` VALUES ('546','qibosoftPhpwindǿ ƽ','','32','0','Ƽ','4','1','0','1240050071','1240050071','1','admin','','','','#5555AA','0','','0','1','','0','1','1240058149','qibosoft Phpwind ǿ   ƽ ','','','','a:3:{s:4:\"head\";s:0:\"\";s:4:\"foot\";s:0:\"\";s:8:\"bencandy\";s:0:\"\";}','0','','0','0','','','','','','0','0','0','','1240210097','4','1240995136','0','0','Ц|1~~|','');
INSERT INTO `qb_article` VALUES ('547','v7ϵͳһǿ,ʵǰ̨鿴Խ','','32','0','Ƽ','2','1','0','1240050179','1240050179','1','admin','','','','','0','','0','1','','0','1','1240058148','','','','','a:3:{s:4:\"head\";s:0:\"\";s:4:\"foot\";s:0:\"\";s:8:\"bencandy\";s:0:\"\";}','0','','0','0','','','','','','1292640191','0','0','','1240146817','0','0','0','0','','');
INSERT INTO `qb_article` VALUES ('548','v7ϵͳ֧뿼ʱƹ','','32','0','Ƽ','2','1','0','1240050522','1240050522','1','admin','','','','','0','','0','1','','0','1','1240058146','','','','','a:3:{s:4:\"head\";s:0:\"\";s:4:\"foot\";s:0:\"\";s:8:\"bencandy\";s:0:\"\";}','0','','0','0','','','','','','1292640138','0','0','','1240058225','0','0','0','0','','');
INSERT INTO `qb_article` VALUES ('549','͸¶һV7Ľչ,ǿԱ׬ȡ¼','','32','0','Ƽ','1','1','0','1240050670','1240050670','1','admin','','','','#0033FF','0','','0','1','','0','1','1240058139','','','','','a:3:{s:4:\"head\";s:0:\"\";s:4:\"foot\";s:0:\"\";s:8:\"bencandy\";s:0:\"\";}','0','','0','0','','','','','','1292640243','0','0','','1240142450','0','0','0','0','','');
INSERT INTO `qb_article` VALUES ('550','ƶ˵ϵ»չKFC¸ʲô','','32','0','Ƽ','18','1','0','1240051050','1240051050','1','admin','','','','#B50707','1','article/32/1_20170513100550_rdqnu.jpg.jpg','1','1','','0','1','1240058150','','','','','a:3:{s:4:\"head\";s:0:\"\";s:4:\"foot\";s:0:\"\";s:8:\"bencandy\";s:0:\"\";}','0','','0','0','','','','','','1494643721','0','0','','1494643693','1','1240210632','0','0','','');
INSERT INTO `qb_article` VALUES ('637','phpwind v8.0  GBK','','12','101','վ','1','1','0','1289475859','1289475859','1','admin','','','','','0','','0','1','','0','0','0','','','','','a:3:{s:4:\"head\";s:0:\"\";s:4:\"foot\";s:0:\"\";s:8:\"bencandy\";s:0:\"\";}','0','','0','0','','','','','','1289475883','0','0','','1289475861','0','0','0','0','','');
INSERT INTO `qb_article` VALUES ('551','Ҵƹܵģ,ģ͸ƹ','','39','0','web','6','1','0','1240051810','1240051810','1','admin','','','','','0','','0','1','','0','1','1240056324','','','','','a:3:{s:4:\"head\";s:0:\"\";s:4:\"foot\";s:0:\"\";s:8:\"bencandy\";s:0:\"\";}','0','','33','0','','','','','','1292640365','0','0','','1240199085','0','0','0','0','','');
INSERT INTO `qb_article` VALUES ('638','Discuz! X1.5 ʽ','','12','101','վ','1','1','0','1289476013','1289476013','1','admin','','','','','0','','0','1','','0','0','0','','','','','a:3:{s:4:\"head\";s:0:\"\";s:4:\"foot\";s:0:\"\";s:8:\"bencandy\";s:0:\"\";}','0','','0','0','','','','','','0','0','0','','1289476015','0','0','0','0','','');
INSERT INTO `qb_article` VALUES ('552','ȸйгݶһ','','39','0','web','0','1','0','1240052014','1240052014','1','admin','','','','','0','article/33/1_20090418180438_vPiyT.jpg','1','1','','0','1','1240056321',' ȸ й г ݶ  ','','','','a:3:{s:4:\"head\";s:0:\"\";s:4:\"foot\";s:0:\"\";s:8:\"bencandy\";s:0:\"\";}','0','','33','0','','','','','','1240052093','0','0','','0','0','0','0','0','','');
INSERT INTO `qb_article` VALUES ('641','qibosoftվV6.0İ','','12','101','վ','2','1','0','1289476573','1289476573','1','admin','','','','','0','','0','1','','0','0','0','','','','','a:3:{s:4:\"head\";s:0:\"\";s:4:\"foot\";s:0:\"\";s:8:\"bencandy\";s:0:\"\";}','0','','0','0','','','','','','0','0','0','','1494648327','0','0','0','0','','');
INSERT INTO `qb_article` VALUES ('553','ӣPHPWINDϾվ---ӢΪйչ׼Ʋ','','39','0','web','13','1','0','1240052409','1240052409','1','admin','','','','','0','article/33/1_20090418190453_qabKt.jpg','1','1','','0','1','1240056320',' PHPWIND Ͼ վ  ---  Ӣ й չ Ʋ','','','','a:3:{s:4:\"head\";s:0:\"\";s:4:\"foot\";s:0:\"\";s:8:\"bencandy\";s:0:\"\";}','0','','33','0','','','','','','1240108730','0','0','','1494649274','0','0','0','0','','');
INSERT INTO `qb_article` VALUES ('640','qibosoftҵB2BϵͳV3.0','','12','101','վ','1','1','0','1289476488','1289476488','1','admin','','','','','0','','0','1','','0','0','0','','','','','a:3:{s:4:\"head\";s:0:\"\";s:4:\"foot\";s:0:\"\";s:8:\"bencandy\";s:0:\"\";}','0','','0','0','','','','','','0','0','0','','1494646899','0','0','0','0','','');
INSERT INTO `qb_article` VALUES ('554','ٶȰٿƣadmin5ͼ','','39','0','web','6','1','0','1240057138','1240057138','1','admin','','','','','0','article/33/1_20090418200432_5ZUc2.jpg','1','1','','0','1','1240057560','ٶȰٿ admin5 ͼ','','','','a:3:{s:4:\"head\";s:0:\"\";s:4:\"foot\";s:0:\"\";s:8:\"bencandy\";s:0:\"\";}','0','','33','0','','','','','','0','0','0','','1240212754','0','0','0','0','','');
INSERT INTO `qb_article` VALUES ('555','ɵĲƸ֮Chinaz.com','','39','0','web','6','1','0','1240057438','1240057438','1','admin','','','','','0','article/33/1_20090418200416_Fs7xV.gif','1','1','','0','1','1240057559','Chinaz.com  Ƹ ֮','','','','a:3:{s:4:\"head\";s:0:\"\";s:4:\"foot\";s:0:\"\";s:8:\"bencandy\";s:0:\"\";}','0','','33','0','','','','','','1240057762','0','0','','1240213566','0','0','0','0','','');
INSERT INTO `qb_article` VALUES ('556','룺õǮ','','39','0','web','4','2','0','1240059129','1240059129','1','admin','','','','','0','article/33/1_20090418200441_Zm9oq.jpg','1','1','','0','1','1240059153','  õ','','','','a:3:{s:4:\"head\";s:0:\"\";s:4:\"foot\";s:0:\"\";s:8:\"bencandy\";s:0:\"\";}','0','','33','0','','','','','','0','0','0','','1490422111','0','0','0','0','','');
INSERT INTO `qb_article` VALUES ('886','˼ôߵƶΪʲô˵ĵ͵','','4','0','ITҵ','8','1','0','1494643427','1494643427','1','admin','','','','','0','article/4/1_20170513100545_pfowb.jpg.jpg','1','1','','0','0','0','','','','','a:3:{s:4:\"head\";s:0:\"\";s:4:\"foot\";s:0:\"\";s:8:\"bencandy\";s:0:\"\";}','0','127.0.0.1','0','0','','','','','','1494644383','0','0','','1494651789','0','0','0','0','','');
INSERT INTO `qb_article` VALUES ('663','леƼΪ벩','','3','0','','7','1','0','1289526733','1386472967','1','admin','','','','','0','','0','1','','0','0','0','','','','','a:3:{s:4:\"head\";s:0:\"\";s:4:\"foot\";s:0:\"\";s:8:\"bencandy\";s:0:\"\";}','0','','0','0','','','','','','1291864893','0','0','','1291864905','0','0','0','0','','');
INSERT INTO `qb_article` VALUES ('883','ӾϣƤֻ2ս ̹ɱؼ','','34','0','ȵ¼','2','1','0','1490432098','1490432098','1','admin','','','','','0','','0','1','','0','0','0','','','','','a:3:{s:4:\"head\";s:0:\"\";s:4:\"foot\";s:0:\"\";s:8:\"bencandy\";s:0:\"\";}','0','127.0.0.1','0','0','','','','','','1490432167','0','0','','1490432148','0','0','0','0','','');
INSERT INTO `qb_reply` VALUES ('528','','1240051050','550','32','1','1','<p> &nbsp;ȻǸЦְȷʵкཻܶѣܶ๫˾ϴ´ã˹˾ʧȷ˾˼˾׼ȷĴ˼֮⣬㾭</p><p><br /></p><p><br /></p><p><span style=\"color:#333333;font-family:&#39;pingfang sc&#39;, &#39;hiragino sans gb&#39;, &#39;microsoft yahei&#39;, &#39;wenquanyi micro hei&#39;, &#39;helvetica neue&#39;, arial, sans-serif;line-height:28px;background-color:#ffffff;\"> &nbsp; &nbsp;G20翪Ϣˣƶ˵: ϵ»30Ӻ˵ˣһ4.6Ԫֽ֧üͷһ壬˵ϽС׷ҸȥϺˡ:̣̣̣</span><br /></p>','0');
INSERT INTO `qb_reply` VALUES ('535','','1240059129','556','39','1','0','Ľġ˳˹ͬĿ⣬ֻǷͶʣҪӦ</p>\r\n<p><table border=\"0\" cellspacing=\"0\" cellpadding=\"0\" width=\"100%\"><tbody><tr><td style=\"color:#666;font-size:14px;\">Ҹע ѶԴ֮Ʒ֡ͼƬͼ δѶȨκý͸˲ȫ߲תءתأ 010-85650997 ϵɺתעԴӣΥ߱׷Ρ</td></tr></tbody></table>\r\n</p>\r\n','0');
INSERT INTO `qb_reply` VALUES ('73','','0','0','0','0','0','<p>&nbsp;&nbsp; λվҵûעqibosoftͬѣ <br />\r\n&nbsp;&nbsp; ӭʹqibosoftվϵͳ,ĿǰĬϰװϵͳ,Ȼⲻһ.ݶһ.ʾݶ,벻Ҫϵͳ⡣</p>\r\n','0');
INSERT INTO `qb_reply` VALUES ('529','','1240051810','551','39','1','1','<div>ʾ.ǵЩģƵ.ظȽӰЧ.ģ͵ĸƹ.</div>\r\n','0');
INSERT INTO `qb_reply` VALUES ('536','','1240060838','557','34','1','1','<p>޸һԭPHP168Ŀ¼ΪdataĿ¼ɽ</p>\r\n','0');
INSERT INTO `qb_reply` VALUES ('517','','1239788649','539','12','1','1','ǳõķϢϵͳ','0');
INSERT INTO `qb_reply` VALUES ('518','','1239788777','540','12','1','1','ƯĲͳ','0');
INSERT INTO `qb_reply` VALUES ('866','','0','885','34','1','1','<p style=\"padding:0px;color:#222222;font-family:&#39;pingfang sc&#39;, &#39;hiragino sans gb&#39;, &#39;microsoft yahei&#39;, &#39;wenquanyi micro hei&#39;, &#39;helvetica neue&#39;, arial, sans-serif;line-height:28px;background-color:#ffffff;margin-top:16px;margin-bottom:16px;\"><span id=\"_baidu_bookmark_start_1\" style=\"display:none;line-height:0px;\"></span><span id=\"_baidu_bookmark_start_3\" style=\"display:none;line-height:0px;\"></span>14ǰҲ2003꣬ͻȻںһ˫̥ûʹЦݣӳΪְĶ󣬳ΪIDͷѡǩѡڽ죬׵ȫеı˫̥һܫ]ϣһܫ]꣬ǲ</p><p><img src=\"http://p3.pstatp.com/large/19f30004504acd7acd5b\" img_width=\"602\" img_height=\"452\" alt=\"14ǰ˫̥ûŮʮ˱\" inline=\"0\" style=\"border:0px;max-width:100%;display:block;margin:10px auto;\" /></p><p style=\"padding:0px;color:#222222;font-family:&#39;pingfang sc&#39;, &#39;hiragino sans gb&#39;, &#39;microsoft yahei&#39;, &#39;wenquanyi micro hei&#39;, &#39;helvetica neue&#39;, arial, sans-serif;line-height:28px;background-color:#ffffff;margin-top:16px;margin-bottom:16px;\"><img src=\"http://p3.pstatp.com/large/19ec00046aa816d3a0fd\" img_width=\"800\" img_height=\"507\" alt=\"14ǰ˫̥ûŮʮ˱\" inline=\"0\" style=\"border:0px;max-width:100%;display:block;margin:10px auto;\" /></p><p style=\"padding:0px;color:#222222;font-family:&#39;pingfang sc&#39;, &#39;hiragino sans gb&#39;, &#39;microsoft yahei&#39;, &#39;wenquanyi micro hei&#39;, &#39;helvetica neue&#39;, arial, sans-serif;line-height:28px;background-color:#ffffff;margin-top:16px;margin-bottom:16px;\">̨壬꣬ܫ]ϣܫ]ƬŵϣܿѵķתѵǱ޸ȻˣںѶڹע˫̥ĳɳ̬һСľ͹ȥ14</p><p style=\"padding:0px;color:#222222;font-family:&#39;pingfang sc&#39;, &#39;hiragino sans gb&#39;, &#39;microsoft yahei&#39;, &#39;wenquanyi micro hei&#39;, &#39;helvetica neue&#39;, arial, sans-serif;line-height:28px;background-color:#ffffff;margin-top:16px;margin-bottom:16px;\"><img src=\"http://p1.pstatp.com/large/19f000044cc1c5a48318\" img_width=\"455\" img_height=\"398\" alt=\"14ǰ˫̥ûŮʮ˱\" inline=\"0\" style=\"border:0px;max-width:100%;display:block;margin:10px auto;\" /></p><p style=\"padding:0px;color:#222222;font-family:&#39;pingfang sc&#39;, &#39;hiragino sans gb&#39;, &#39;microsoft yahei&#39;, &#39;wenquanyi micro hei&#39;, &#39;helvetica neue&#39;, arial, sans-serif;line-height:28px;background-color:#ffffff;margin-top:16px;margin-bottom:16px;\"><img src=\"http://p3.pstatp.com/large/19f30004526c37fe70cf\" img_width=\"500\" img_height=\"667\" alt=\"14ǰ˫̥ûŮʮ˱\" inline=\"0\" style=\"border:0px;max-width:100%;display:block;margin:10px auto;\" /></p><p style=\"padding:0px;color:#222222;font-family:&#39;pingfang sc&#39;, &#39;hiragino sans gb&#39;, &#39;microsoft yahei&#39;, &#39;wenquanyi micro hei&#39;, &#39;helvetica neue&#39;, arial, sans-serif;line-height:28px;background-color:#ffffff;margin-top:16px;margin-bottom:16px;\">ǿҪʮˣ˻ŮҲɹƬѾֲ</p><p style=\"padding:0px;color:#222222;font-family:&#39;pingfang sc&#39;, &#39;hiragino sans gb&#39;, &#39;microsoft yahei&#39;, &#39;wenquanyi micro hei&#39;, &#39;helvetica neue&#39;, arial, sans-serif;line-height:28px;background-color:#ffffff;margin-top:16px;margin-bottom:16px;\"><img src=\"http://p1.pstatp.com/large/19f3000452b2035dda0f\" img_width=\"600\" img_height=\"827\" alt=\"14ǰ˫̥ûŮʮ˱\" inline=\"0\" style=\"border:0px;max-width:100%;display:block;margin:10px auto;\" /></p><p style=\"padding:0px;color:#222222;font-family:&#39;pingfang sc&#39;, &#39;hiragino sans gb&#39;, &#39;microsoft yahei&#39;, &#39;wenquanyi micro hei&#39;, &#39;helvetica neue&#39;, arial, sans-serif;line-height:28px;background-color:#ffffff;margin-top:16px;margin-bottom:16px;\">е˵ǳˣûСʱôɰˣҾóҲ󰡣ͨŮƯܶ౶</p><p style=\"padding:0px;color:#222222;font-family:&#39;pingfang sc&#39;, &#39;hiragino sans gb&#39;, &#39;microsoft yahei&#39;, &#39;wenquanyi micro hei&#39;, &#39;helvetica neue&#39;, arial, sans-serif;line-height:28px;background-color:#ffffff;margin-top:16px;margin-bottom:16px;\"><img src=\"http://p1.pstatp.com/large/19ef00046105636dc841\" img_width=\"690\" img_height=\"920\" alt=\"14ǰ˫̥ûŮʮ˱\" inline=\"0\" style=\"border:0px;max-width:100%;display:block;margin:10px auto;\" /></p><p style=\"padding:0px;color:#222222;font-family:&#39;pingfang sc&#39;, &#39;hiragino sans gb&#39;, &#39;microsoft yahei&#39;, &#39;wenquanyi micro hei&#39;, &#39;helvetica neue&#39;, arial, sans-serif;line-height:28px;background-color:#ffffff;margin-top:16px;margin-bottom:16px;\"><img src=\"http://p1.pstatp.com/large/19f000044bc3c760a0af\" img_width=\"690\" img_height=\"893\" alt=\"14ǰ˫̥ûŮʮ˱\" inline=\"0\" style=\"border:0px;max-width:100%;display:block;margin:10px auto;\" /></p><p style=\"padding:0px;color:#222222;font-family:&#39;pingfang sc&#39;, &#39;hiragino sans gb&#39;, &#39;microsoft yahei&#39;, &#39;wenquanyi micro hei&#39;, &#39;helvetica neue&#39;, arial, sans-serif;line-height:28px;background-color:#ffffff;margin-top:16px;margin-bottom:16px;\">Ǻϲ裬ɹƬ˵δнȦĴ㣬һby2Ҫ</p><p style=\"padding:0px;color:#222222;font-family:&#39;pingfang sc&#39;, &#39;hiragino sans gb&#39;, &#39;microsoft yahei&#39;, &#39;wenquanyi micro hei&#39;, &#39;helvetica neue&#39;, arial, sans-serif;line-height:28px;background-color:#ffffff;margin-top:16px;margin-bottom:16px;\"><img src=\"http://p3.pstatp.com/large/19ef0004613885713098\" img_width=\"650\" img_height=\"866\" alt=\"14ǰ˫̥ûŮʮ˱\" inline=\"0\" style=\"border:0px;max-width:100%;display:block;margin:10px auto;\" /></p><p style=\"padding:0px;color:#222222;font-family:&#39;pingfang sc&#39;, &#39;hiragino sans gb&#39;, &#39;microsoft yahei&#39;, &#39;wenquanyi micro hei&#39;, &#39;helvetica neue&#39;, arial, sans-serif;line-height:28px;background-color:#ffffff;margin-top:16px;margin-bottom:16px;\">ȦǷ֮أҵϣԶ룬ϾǴŮȦǸȾף</p><p><br /><span id=\"_baidu_bookmark_end_4\" style=\"display:none;line-height:0px;\"></span><span id=\"_baidu_bookmark_end_2\" style=\"display:none;line-height:0px;\"></span></p>','0');
INSERT INTO `qb_reply` VALUES ('537','','1240061182','558','34','1','1','<div>ں̨ݹؼͻʾʱ,ͼƬ.ͼƬʱ.ְйؼʱ.ᵼͼƬ޷ʾ.<br />\r\n<br />\r\n.޸ļ<br />\r\n/inc/article_function.php<br />\r\n<br />\r\nrequire_once(ROOT_PATH.\"data/keyword.php\");<br />\r\nһ´<br />\r\n$content=preg_replace(\"/ alt=([^ ]+) /is\",\"\",$content);</div>\r\n','0');
INSERT INTO `qb_reply` VALUES ('530','','1240052014','552','39','1','1','418Ϣȸлܲ<a href=\"http://go.tech.163.com/renwu/data/6.html\"><font color=\"#1e50a2\"></font></a>ϣȸйгݶܹõϣҲϳԽ<a href=\"http://go.tech.163.com/info/detail.jsp?id=5\"><font color=\"#1e50a2\">ٶ</font></a><a href=\"http://go.tech.163.com/info/detail.jsp?id=5\"><font color=\"#1e50a2\"><img onload=\'if(this.width>600)makesmallpic(this,600,1800);\' src=\"http://cimg20.163.com/tech/2008/3/31/20080331145327d1893.png\" width=\"18\" height=\"18\" border=\"0\" /></font></a>죬ڲ̳<a href=\"http://go.tech.163.com/info/web/2.html\" target=\"_blank\"><font color=\"#1e50a2\"><img onload=\'if(this.width>600)makesmallpic(this,600,1800);\' src=\"http://cimg20.163.com/tech/2008/3/31/20080331145327d1893.png\" width=\"18\" height=\"18\" /></font></a>ƼרʱʾȥȸйгݶѾһԻƳ²Ʒʹùȸ档<p><strong>ҵԴɹӮ</strong></p>\r\n<p>ͳҵýǿʼָȸ޳ӶǻǮɷõţѻŵϰߡȸлܲΪʱĽʹı仯ȸѾܶഫͳýվַǳõĹϵͨߵĹȸϵͳҲȡ˺ܺõĺһֹӮĹϵ</p>\r\n<p><strong>гݶһ һ</strong></p>\r\n<p>ΪȸйѾǾԵĵһȥǵгݶһԿǵڳɳ</p>\r\n<p>ڹȸĵʾӹȸڲȸĿǰѾǵһˮƽ</p>\r\n<p>ʾжϽǶ˵жϱ׼ĵ㣬ǵһҳĽ˭Խ࣬׵վǷܹ뵽棬ǷǷ¡</p>\r\n<p>ĸָ棬ʾ¶࣬棬ȸԶ֡</p>\r\n<p>ǹȸйгݶڰٶȣ˵Ϊܶ˲⣬֪ŹȸѾãϣһ¡һԭǴҵϰߣΪΪ࣬ԲԸ档</p>\r\n<p><strong>Ψһһ</strong></p>\r\n<p>Ͱٶй½гľܳʱ䶼ҪһֱԵһ⡣</p>\r\n<p>ڹȸ½ƳΪȸ½ƳйΨһһҡͳƬ˾ѽиõ顣ȸһģʽĲƷѵģ͸ģҪдµĹܡȨй½</p>\r\n<p>Ϊ滯ʵǹȸƣսȸĺ飬˵ȸȽһ£ʾĽӦԽԽãԽԽáһõͿû⡣淴Чãй½гƹ㡣</p>\r\n<p>ȸƳ֮ٱҵΪǽڻְٶǿƵMP3ٶչֱӾٶȴǰһЩͳƬ˾ǷȨ˷磬ٶϯִй<a href=\"http://go.tech.163.com/renwu/data/45.html\"><font color=\"#1e50a2\"></font></a>׿ƼרʱʾڰȨ⣬ٶȷǳӣκȨϢɾߣͬʱٶҲϣΪݵṩߡ</p>\r\n<p><img onload=\'if(this.width>600)makesmallpic(this,600,1800);\' src=\"http://www_qibosoft_com/Tmp_updir/article/33/1_20090418180432_EwElB.jpg\" width=\"500\" height=\"381\" border=\"0\" alt=\"2.jpg\" title=\"2.jpg\" /></p>\r\n<p><strong>²Ʒû</strong></p>\r\n<p>ʾϣ²Ʒû</p>\r\n<p>ʾͶֵĲ໹ҪһGoogleҪ֮⣬ͿԿơȸ˵ͼҳƬƵ<a href=\"http://tech.163.com/special/00092FUU/blog_tech.html\" target=\"_blank\"><font color=\"#1e50a2\"></font></a>֣κһʣǳؼʻǳβؼʣڹȸõЧ</p>\r\n<p>˼ǿ⣬һЩûϲʴȸҲĽ˺ȸĸҳigoogleƶ͵ͼҲǹȸصǿ򣬡ϰλȸ蹤ʦרעһһЩܺõĲƷ֡</p>\r\n<p><strong>3Gг߻</strong> </p>\r\n<p><strong>3Gƶгȸ˺ܶ׼</strong></p>\r\n<p>ȸոպйƶǩƶЭ飬<a href=\"http://go.tech.163.com/renwu/data/1.html\"><font color=\"#1e50a2\"></font></a>ҲһΪйµ3G棬̹ԣܹȸ豣ֿ̬ԸеĵӪ߻Ϻ˫ޡޣųЩ̻ѡ̡</p>\r\n<p>Ϊ3Gһ߻ùȥķúܿ죬շѵ½3Gռȫȸ費μӸĲƷãֻҲһܱҪ⣬רעĲƷ͵ͼﵽǲƳӲƷ</p>\r\n<p>ȸAndroidֻƽ̨һ⣬ʾȸûӵһѿԴֻϵͳûӵһܺõʹ飬κֻֻ̿</p>\r\n<p>˵йֻ̺͵Ӫ˵ܶϵͳҪֻϵͳÿζҪҪ֧֣ûԴ룬޸Ļǳ鷳ԹȸֻϵͳǽһõĲϵͳѵ͸ƶӪ̺йֻ̡</p>\r\n<p><strong>ҵȹΣ</strong></p>\r\n<p>ӰȫľΣΪҵԽģϣܹйҵ˴ξΣõûԴиõƹ㣬ϷǱȽϿõҵƷƹ½ģû½ôء</p>\r\n<p>ΪǰҵҪͳɱսܹƽĶȹҲڴůʱڸյʱ򣬵õܺõĳɳ</p>\r\n<p>ڽΣӰ죬ʾӹȸͻͳݿӰϴǳҵȸȫɳ6%йɳԶȫ򣬡ȸȥļرĺãǵĳɳԶԶҵͬСһԤƻᱣֺҵһõ֮йҲڱֺܺõ</p>\r\n<p>ƸƻʾȸȫԱܻԻһЩάȶˮƽû½й򱣳һľ</p>\r\n','0');
INSERT INTO `qb_reply` VALUES ('519','','1239788863','541','12','1','1','ܷǳǿ.ưٶ֪','0');
INSERT INTO `qb_reply` VALUES ('538','','1240061760','559','34','1','1','<p><img onload=\'if(this.width>600)makesmallpic(this,600,1800);\' src=\"http://www_qibosoft_com/Tmp_updir/article/34/1_20090418210411_MAuzU.jpg\" width=\"500\" height=\"333\" border=\"0\" alt=\"1.jpg\" title=\"1.jpg\" /></p>\r\n<p>йƶG3ʼǱߺʽڱСйƶʽ롢ա廪ͬ17ҹPC̿չȺƳ29йƶG3ʼǱ˾ٿ˹ӪPC̴ģȺӣ־3GTD-SCDMAҵչȡشչû˵ѾʼֻչԤ滰ѻֻҲġ͡ʼǱ<br />\r\n<br />\r\n<img onload=\'if(this.width>600)makesmallpic(this,600,1800);\' src=\"http://www_qibosoft_com/Tmp_updir/article/34/1_20090418210415_iM0Xb.jpg\" width=\"500\" height=\"333\" border=\"0\" alt=\"1.jpg\" title=\"1.jpg\" /><br />\r\n<br />\r\n<br />\r\nйƶܲ³򶫣У17Һٱ<br />\r\n<br />\r\n&nbsp; &nbsp; йƶΪηĶ17Һĸ߲쵼ϯֹPC̸߲Ƽĳ漴ӢضĳҲѵһл˹ܲ ܡйϢƷ(PSG)ܲüܾ ȫܲáлҵܾ ̨´ǡ3GĵһѾڹPCп˻<br />\r\n<br />\r\n</p>\r\n','0');
INSERT INTO `qb_reply` VALUES ('531','','1240052409','553','39','1','1','<p><span>Ϣ ϢҵйٷչһЩҵʵ˿ٳɳڵǰΣӰ£ҲҪ˼·͵ӢվٿòĻӢϾΪйĻɳ׼ײߡ<br />\r\n&nbsp;&nbsp;&nbsp; <p align=\"center\">&nbsp;</p>\r\n</span></p>\r\n<p align=\"center\">&nbsp;</p>\r\n<p>&nbsp;</p>\r\n<p align=\"center\">&nbsp;</p>\r\n<p>&nbsp;</p>\r\n<p align=\"center\"><img onload=\'if(this.width>600)makesmallpic(this,600,1800);\' src=\"http://www_qibosoft_com/Tmp_updir/article/33/1_20090418190417_93pys.jpg\" width=\"546\" height=\"372\" border=\"0\" alt=\"4.jpg\" title=\"4.jpg\" /></p>\r\n<p>&nbsp;</p>\r\n<p align=\"center\">&nbsp;</p>\r\n<p align=\"center\">&nbsp;</p>\r\n<p align=\"center\"><span><img onload=\'if(this.width>600)makesmallpic(this,600,1800);\' src=\"http://www_qibosoft_com/Tmp_updir/article/33/1_20090418190427_FSk2e.jpg\" width=\"548\" height=\"323\" border=\"0\" alt=\"5.jpg\" title=\"5.jpg\" /><p><br />\r\n&nbsp;&nbsp;&nbsp; գȫصĽ200λվվͻӢϾδչӯȽ㻰֣̽ڶվǷԼĴҵԼվĶᡣδȫйչǰհԹ۵ҵʦӦԴɳչҵģʽ߹ƽ̨ҵģʽԼҵչ򡢾ӪվȻۺͷ </p>\r\n</span></p>\r\n<p><br />\r\n&nbsp;&nbsp;&nbsp; գȫصĽ200λվվͻӢϾδչӯȽ㻰֣̽ڶվǷԼĴҵԼվĶᡣδȫйչǰհԹ۵ҵʦӦԴɳչҵģʽ߹ƽ̨ҵģʽԼҵչ򡢾ӪվȻۺͷ </p>\r\n<p>&nbsp;</p>\r\n<p><br />\r\n&nbsp;&nbsp;</p>\r\n<h1><font size=\"4\">CHINAZ:רPHPWind ѧʵһԱ</font></h1><p>611գĺ磬PHPWind Forums v6.3LXBlog v6.0ʽ淢ǰеݵѧϵСɲһ裬º˷۾еһСڲ裬һԸ¶֮ŵԽܲɷõϰߣٲȻҡΪһԱ</p>\r\n<p>ѧ1998һص80㿪ʼʩչԼȤͰáһͶԻ֮кͱע2002ѧϴѧͬʱһѾһְԱˡһʱļѧԼĲƷ2003꽫ص̳ϡĿٷչļѧļзŶһ̼ǿԼƷгǰ2004PHPWindʽΪһ̳ͨĿ2005꣬ҵûоѧԼĲƷͶˣõһǮŶĸУԱߴԼļ˾ͬʱɳԱΪCEO</p>\r\n<p>ѧ̹ڳΪ֮㲻ٲƷзˡԭǹ˾Ա40ˣ80%ǸƷļԱȻǲƷĴʼ֮һԼCEOݼĿԱڲƷ͹˾ķչһֱԼƷĵһߣԼȵû֮зԱĵãԱֲƷûʡ</p>\r\n<p≯ƷѧʾPHPWindṩĽվѾǳ죬ʹվûκμ򱳾£һվͬҲǼ򵥲ҲʧԻPHPWindṩһϵнվ͡SNSϵͳȣվ߿ԸԼ󽫲ͬϴﵽԼĸԻĿǰPHPרעڸΧڵվ֧֣Ϊվṩһֵ񣬰ռ䣬ʹСվվķȡ</p>\r\n<p>ѧΪ̳ΪƷ벩ȽǿгԾ߱չǱ˹˾ĿǰǼḻƲƷҪӭûͳĲϱ仯ڴ˻֮Ϊ߼ûṩ߱ԳɳԵĲƷڴЦƷƴľڹûΪͬѡ</p>\r\n<p>ڻ乫˾չʱѧԼһǲӦ뻯̳ĿóȻڱֹ˾ѧʾʹ˾չЩðˣҲԴûĸѧΪûŵĶһ£̸ֽҪãר·ҲùPHPWindĽơ</p>\r\n<p>̣ڱʵοʱѧ̫༤ÿõĲƷдڵɣںõгϷչҪһ֣ûоûнԼĲƷãͲڵһ͵ڶλ档ڶֵĲѧʾһԴ</p>\r\n<p>֮ǰдԳưͰƷư5000ҵļ۸PHPWindչһ£ѧٴҹ˾ֻ̳Ʒҵû漰κʱסΪ֮ѡPHPWind̳ƷΪPHPWind̳ƷרעͲƷİȫ߸غеĸ١ѧͬʱʾΪ˾ԲƷûĹעʹPHPWindƵƵעһ˳µ¡</p>\r\n<p>ѧڻ뷢չʱЩпPHPWindûĿڱܹȡһЩɼܲףҲûPHPWindϵвƷͬͿ϶רעǷ֮ûа׷ѡ</p>\r\n<p>200611£PHPWindڶ̶̵겻ʱעԱﵽ100</p>\r\n<p>2007վѡ07ʮվѧС</p>\r\n<p>2008612,PHPWind Forums v6.0Ѿ߸ʱ䣬ѧŶһζ˳ŵ</p>\r\n<p>ѧΪȡóɹżȻҲǱȻԼĳԸͲΪӮΪȤڽһмֵĲƷӮȤ˽ԲƷ׷ܻûҳϡ</p>\r\n<p≯ɫĹȣѧΪԼλǱ仯رȽȻùͼڲֵȻѧΪԼȫΪϰ壬һ̸ԼҲƷʱϰ̬ȻʧƵһ¾ͱרҵĿǺ߼˼ά˼Ե쵼ŶӵĹߺͶʷľˡû취˿ֻܹѧӵʣԱеĶԲƷרע꣩</p>\r\n<p><strong>PHPWind</strong></p>\r\n<p>PHPWind2002꣬ڹȥ6ʱPHPWindһֱΪڽվṩֵΪվṩ㡢ЧɳĽվ˾ĲƷ̳ϵͳһ׿ԴϵͳͬʱPHPWindӵڶԭĺļģϵݿĶɢļü㷨ļдȶ㷨ݿؾ㷨ذȫϵȣĿǰѾΪӦù㷺̳֮һ </p>\r\n','0');
INSERT INTO `qb_reply` VALUES ('539','','1240062925','560','34','1','1','<p>װ׹--רҵIDCվCNIDCƳƷաܣû˽Ʒ̬Ϣ</p>\r\n<p><strong>йվվchinaz.com413Ϣ</strong>Ϊһֶҳʷݵı棬ǶԡҳաϤҳжʹһܡóʵĳ֡աܣǷԸȫ˽һƷĶ̬Ϣأڣ<a href=\"http://www.cnidc.com/\">www.cnidc.com</a>Ƴһܡ</p>\r\n<p>ƳһʷݵĹܽСƷաԭϺġҳաƣֻǰһ뵽Ʒ׵С</p>\r\n<p>һרҵIDCƽ̨֪վռ䣩ǵָϢ࣬һָĸı䣬ͻʹԼ۱ȴྶֽ֧ͥűĲͬASPASP.NETPHP ݿͣACCESSMSSQLMySQLIISơ·Ƿȣʱһָı仯ͻʹϵµʹûһֱľ档</p>\r\n<p align=\"center\"><img onload=\'if(this.width>600)makesmallpic(this,600,1800);\' src=\"http://www_qibosoft_com/Tmp_updir/article/34/1_20090418210456_2Vexh.gif\" width=\"448\" height=\"364\" border=\"0\" alt=\"1.gif\" title=\"1.gif\" /></p>\r\n<p align=\"center\">&nbsp;<strong>ͼϢб仯һƷ</strong></p>\r\n<p align=\"center\"><strong></strong><p align=\"center\"><strong><img onload=\'if(this.width>600)makesmallpic(this,600,1800);\' src=\"http://www_qibosoft_com/Tmp_updir/article/34/1_20090418210410_CH9Ep.gif\" width=\"417\" height=\"366\" border=\"0\" alt=\"9.gif\" title=\"9.gif\" /><p align=\"center\">&nbsp;ͼƷϢ</p>\r\n</strong></p>\r\n<p align=\"center\">&nbsp;ͼƷϢ</p>\r\n<p>&nbsp;</p>\r\n<p align=\"center\">&nbsp;ͼƷϢ</p>\r\n<p>&nbsp;</p>\r\n<p align=\"center\">&nbsp;ͼƷϢ</p>\r\n<p>&nbsp;</p>\r\n<p align=\"center\">&nbsp;ͼƷϢ</p>\r\n<p>ûͨѽܶûڲοϢܾ֮òŹʱ̣IDCͻĳƷָһı䶯ƳġƷաܣȫžһķûȫ˽Ʒʷݣװ׹</p>\r\n<p align=\"center\">&nbsp;</p>\r\n<p align=\"center\"><strong>&nbsp;ͼϢ仯һƷ</strong></p>\r\n<p>˽⣬ƷաڹϽҵڶܣƷָϸӸӣ֮ȫ˽ܾһļѶȣûݵ˽һƷϢȡϾһƣҳաɴ󻺽һìܡ</p>\r\n<p>ΪһרҵIDCƽ̨һֱάûȨϾ󾫣߱ϼƻCNIDC֤̼ңԼ7˿ȴʩ˷ƳƷաܣȫλάȨһϤľٴ롣</p>\r\n<p><strong></strong>CNIDC.comһIDCƽ̨Ҳй½׼רҵƽ̨2009323ߡ</p>\r\n<p>IDCҵB2CףBIDC̣Cվҵȿͻйվվchinaz.com7վҵƣIDC̼ҡվҵûIDCնȺ壬޷϶Խӣ֤˫ȫףڴйרҵƽ̨</p>\r\n<p>ΪһIDCҵB2Cƽ̨йܡá⡢VPSϸվռʹõĲͬҪͬʱṩIDCҵѶԼIDCصļ̵̳ȡվַ<a href=\"http://www.cnidc.com/\">www.cnidc.com</a>&nbsp;</p>\r\n<p>&nbsp;</p>\r\n<p>&nbsp;</p>\r\n<p>&nbsp;</p>\r\n</p>\r\n','0');
INSERT INTO `qb_reply` VALUES ('547','','1240126739','566','39','1','0','˽һͬһ̨վ<br />\r\n&nbsp; &nbsp; 4վռļ۸ṩվռķ̺ܶ࣬ͷҲǧ𣬼۸ͬкܴ죬һ˵Ĵͷ̵Ʒ۸ҪһЩһЩС͹˾ܼ۸ȽϱˣɸվҪ̶ѡֲεṩ̡ѡСл񹲺͹ֵҵӪ֤ķ̸.<br />\r\n<br />\r\n9 ʲô <br />\r\n<br />\r\nϿٳһĴ̿ռ乩ûվļݣܰwebʺļ书ܡ&nbsp;&nbsp;<br />\r\n<br />\r\nνҲСվռ䡱ǰһ̨ڻϵķֳɶ⡱ķÿһжInternet֧WWWFTPE-mailȣܡһ̨ϵĲͬǸԶģûйһֻ̨ܹ֧һʱûеܼ½<br />\r\n<br />\r\nǻõĽʡӲɱļҪӦHTTP񣬽һ̨ĳȫ߼ΪλΪӶ÷ӲԴϵͳģΪ<br />\r\n<br />\r\n<br />\r\n10ʲôHTML<br />\r\n<br />\r\nHTMLHyperTextMark-upLanguageıԣWWWԡHTMLԵĿΪܰѴһ̨еıͼһ̨еıͼηϵһγл壬ǲÿǾϢڵǰϻϡֻʹĳһĵеȡһͼ꣬InternetͻתͼصȥЩϢܴһ̨С HTMLıHTMLɵıHTML˵֡ͼΡӵȡHTMLĽṹͷHead壨Body󲿷֣ͷϢҪ˵ľݡ:<a href=\"http://tool.admin5.com/shouce/html/\" target=\"_blank\"><font color=\"#0000ff\">http://tool.admin5.com/shouce/html/</font></a><br />\r\n<br />\r\n11 ʲôASP<br />\r\n<br />\r\nASPActive Server PageдΪҳASP΢˾ĴCGIűһӦ,ݿнһּ򵥡ı̹ߡASPҳļĸʽ.aspڳڸֶ̬վС ASPһַ˽űдж̬ҳWebӦóASPҳ԰HTMLǡͨıűԼCOMȡASPҳӽʽݣ߱ҲԴʹHTMLҳΪûwebӦó HTMLȣASPҳص㣺 <br />\r\n<br />\r\n1ASPʵͻƾ̬ҳһЩƣʵֶ̬ҳ <br />\r\n<br />\r\n2ASPļǰHTMLɵļеģ޸ĺͲԣ <br />\r\n<br />\r\n3ϵASPͳڷƶASP򣬲HTMLʽ͵ͻϣʹøASPҳ <br />\r\n<br />\r\n4ASPṩһЩöʹЩʹ˽űܸǿԴwebлȡûͨHTMLύϢڽűжЩϢдȻwebϢ <br />\r\n<br />\r\n5ASPʹ÷ActiveXִиָȡݿ⡢ŶǸEmailļϵͳȡ <br />\r\n<br />\r\n6ڷǽASPִеĽHTMLʽؿͻʹ߲ῴASPдԭʼ룬ɷֹASP뱻ȡ<br />\r\n<br />\r\n12 ʲôphp<br />\r\n<br />\r\nPHPһڷ̬վĽűԣPHPHTMLվҳһߴҳʱ˱ִPHPִнߵУASPCoildFusionȻPHPǲ֮ͬPHPԴͿԽƽ̨PHPWINDOWS NTͶְ汾UNIXϡҪκԤȴٷҲҪmod_perlĵʹķڴӳСPHPĵԴ٣PHPΪApache Webһʱд벻ҪⲿƳ򣬷Ҫеκζĸ <br />\r\n<br />\r\nܹҳ⣬PHPܷHIIPı⡣cookie,ǩضûṩ˼õͨ</p>\r\n</td></tr></tbody></table>\r\n','0');
INSERT INTO `qb_reply` VALUES ('532','','1240057138','554','39','1','1','<p><a href=\"http://192.168.0.99/view/762692.htm\" target=\"_blank\"><font color=\"#3366cc\"></font></a>˳ͼĸվվܶվΪϴȻûзչһվȴСվɳ <br />\r\n</p>\r\n<div>&nbsp;</div>\r\nйվͼһܡ<img onload=\'if(this.width>600)makesmallpic(this,600,1800);\' src=\"http://www_qibosoft_com/Tmp_updir/article/33/1_20090418200452_bsk1Z.jpg\" width=\"300\" height=\"450\" border=\"0\" alt=\"6.jpg\" title=\"6.jpg\" />ͼȺͼĿǰйվȦٲȻһƷƣ֪վۻᶼٲͼĲ룬ͼվзǳءվǶͼԴͼ˵ƷǳáйҵվѾΪһɲСվÿǧٶȿٵƻڼӴ󡣸վ֮࣬ܶСվվǳҪվǰİæͼУǰ˽׵Ľɫ <br />\r\n<div>&nbsp;</div>\r\nƺܶվֻ֪ͼ֣в֪ģܶѶ֪ͼֵͼ֮ԽͼʵΪһվ88gg.comһͼƬվʱǸk6k666վ̳֪ܶվվվɵ˶ǳ̳֮ģʱվǳҲȽģͼƬҲԺովһ㾭飬ʼվһվһ£ѧһ㾭飬࿪һҰһЩʱ䣩ʱֱӵͼƬվ٣У̳ͼͼƬر࣬ͼѸ㵽һproץ̳ͼƬɵĴֱһ̳һ̳ץȡ <br />\r\n<div>&nbsp;</div>\r\nһץͼƬģȻacdsee΢ϴͼܳտִ˲ˣȫֹվһ꣬ϰͼƬֹ˽50ͼƬվʱûзվͼƬһڵһҳһ붼ͼģ50վȻÿվ󣬼ǧipȫͣͼqq֣˶Ǹʱͼʶ˺ܴһ͵վ໥ͨѧϰ֪޲˵ܶδıվγϵ飬ͼĹϵرڶԺ󣬳Ϊÿ˵ĻԾӡһվһվˣ˺2꣬ͼҲ2ѣ ͼ̫ѣҲϵԹ2δڸk6ֹͣԺһֱϺһ齨ˣ˺ܶվȥʧʮgͼƬݷҲûˡһθһѺƹոˡ֧ԺҲʧҺýͼԼ渶ˡӴҲûȥ˵ĳʮ˾Ȼܾ04ϴϴǰͼĽʮͼƬվͼֵۡһУоseoҲд㶫ʲôģÿ̳ǵʺܸߵģҲѽվ棬ƹ㷽棬ô桢ô˹淽ָͼʢˡ <br />\r\n<div>&nbsp;</div>\r\nͼĺܶվܶͨ׬Ǯ߰ԼվҲúܴа֪վݾӡ03׵ʱ<a href=\"http://192.168.0.99/view/2178514.htm\" target=\"_blank\"><font color=\"#3366cc\">gjj</font></a>ʶͼͼݾԼվ棬ȻŪȣݾȻԼоݾڲϷչɾgjjҲɾ͹ݾվƺܶվĳɹ벻ͼİæ <br />\r\n<div>&nbsp;</div>\r\nʵҸʶͼǱȽģʱҶˣ05ꡣ֮ǰһֱվվҲõͼָ㡣ȻҺͼĴҲǺܶ࣬һû鲻ΪԼҲܶ࣬Ҫվͨվѣ˽⵽ͼйվֺôҲƶйķչЩǷǳֵġ <br />\r\n<div>&nbsp;</div>\r\nÿ쿴ͼqqߣqqҲһֱִ˲ˣһվѶwww.2D29.CNϣѸһ㣬վһһЩ·ȡóɹ <br />\r\n<div>&nbsp;</div>\r\nҺеõͼѣͼʾĸлҲϣͼԺҵȡøĳɹ HEHE<br />\r\n','0');
INSERT INTO `qb_reply` VALUES ('533','','1240057438','555','39','1','1','<p>ɣԭҦйվվʼˡ1982ˡĿǰǧ </p>\r\n<p align=\"center\"><img onload=\'if(this.width>600)makesmallpic(this,600,1800);\' src=\"http://www_qibosoft_com/Tmp_updir/article/33/1_20090418200404_25EwL.gif\" width=\"400\" height=\"316\" border=\"0\" alt=\"9.gif\" title=\"9.gif\" /></p>\r\n<p align=\"center\"><strong>йվվʼˡ</strong></p>\r\n<p><strong>ǳɹ</strong></p>\r\n<p><strong>ǳɹģ۴һרݣǧ۵Ḷ́Ǵ2002꽨йվվ2003йվվͳڸַվҳվƼ</strong></p>\r\n<p><strong>Ŀǰйվվӯÿ¶ǣʵÿ¶ӯ漣ÿֵɺ˵20</strong></p>\r\n<p><strong>רһ</strong></p>\r\n<p><strong>ڻĴֻѡΪվվңֻѡˣԴһҵӯǹ档</strong></p>\r\n<p><strong>רעͶ룬ΪЧ˴ҵ֮ȱԴÿһϸڵ</strong></p>\r\n<p><strong>йվվӵнʮԱҪǼԱйվվĿǰΪҵվҪӯһ档йվվչѾȹ̳죬ǰչȻǣΪվйվԽԽ࣬վĹ˾ҲԽԽ࣬վйĵλԽߣƺעˣרһĸõɡ</strong></p>\r\n<p><strong>ǵ</strong></p>\r\n<p><strong>ɵǣΪȡСҲӪ磬ԴѹйվվtxtļʿݷʽΪץסվ𵽷ǳãĺܶԴվҲ׷ģ°ɵ</strong></p>\r\n<p><strong>ǣ켣k666̳ʱ򣬷̳Ĺ棬ʲôվҪ̻</strong></p>\r\n<p><strong>ҲäĿ</strong></p>\r\n<p><strong>2000꣬ʱҲҳȻһƺܴվҰʵվֻнϷĿȽʱߵĴм˰ɣÿҲй̶롣˺ܶʱվĿϣЩĿȴû취׻˺ܴ߹·ҲΪӵһ̨Ϸ˱ˣȻȥŻվվֱ˲࣬󲻵òص</strong></p>\r\n<p><strong>ҲǴ</strong></p>\r\n<p>ǿ˵ĳɹĳȣҵļ鲨ӿʵÿһ˵ĳɹסɹĲףƺֵþѹע</p>\r\n<p>йվվɳ·ϣҲأмβһ͹ص20023½վ󣬲õ7·ݣΪ^**ݱذ˷Ϊȫ棬վһ¡ʱɽֻɽȥҹá˿ǰѷûˣվ¿š</p>\r\n<p>2004ɵķDDOS˰£Ϊйվվǵķǽʱ䣬ɲûİվȥˡջΪѵİŽ⣬վؿ</p>\r\n<p>ʵУ⣬µİվͷ</p>\r\n<p>Ҳй˳ʮչйվվĶ</p>\r\n<p><strong>ɸߴң</strong></p>\r\n<p>1. ʲô£ˣԼܽᲢ׶ԵһЩ顣</p>\r\n<p>2. ΪȡСһʼҪȫվۣҲô÷չһ˵Ǻ޵ģȫվϻǾϵͶ붼Ǿ޴ģվмС</p>\r\n<p>3. վǸʵʵվòûñȽϳɹĸվⶼȽϵһⵥһζݵһһ⣬λȷͬʱҲ׸ھվСϡֻǿƤë</p>\r\n<p>4. һõվõ+Ҳվչľڡ</p>\r\n<p>5. Ҫ۹⿴Զһ㡣κ鶼ҪȷĿϸеļƻҪи˵ԸмƻĿʵʶ֣ôƻԶͣڱʼǱϵļƻֻ˫ʵ</p>\r\n<p>ֻǣΪʲôֻ֧ܳƽ</p>\r\n<p><strong>ɴҵĹ</strong></p>\r\n<p>2000꣬1982˰רҵˡҵʧҵһֱڼдѵʱġûǮˣƺǸѡʱϷ͸ҳΪ飬ǰ;һƬã</p>\r\n<p>ÿµѴһǧ£ǮĺӣһǸĸͷ֮ޡ20007£Ṉ̀ƵӣɵĸҳȻ׬8848ȤĹٶԪɵһΣ鵽˴׬Ǯĸо</p>\r\n<p>20008£һó˰ɲű߼ʵĺΰġҰˡҰʵվֻнϷĿȽʱߵĴм˰ɣÿҲй̶롣ɻ˺ܶʱվĿϣֻЩĿû취׻˺ܴ</p>\r\n<p>20001025գɽŴѧͶϢרҵܿ췢֣ѧѧҪĶܶ۵ĶҲûа취õʵӦרҵİɱͬѧӴԣܶͬѧ̵Ե顣ңͬѧ˵ʱй̶İɣǸĽӦøоŶԣǣ޶ֵͻȻãǸѧҵ֤˵ûʲô塣</p>\r\n<p>20016£ѧؼңרĽ֮·ԷѧѧҵǷڡúܸɴ࣬ᡣңûΪйĽʧܵģĹ˾ˣкܶڴѧȣᣬȴʲôᡣȫãȺеһû˷ʱ䡣</p>\r\n<p>ڼ䣬ɽ(Ұû)һ̨ΪҪ̨ʱվĲĽĿɽӪҲǡĿ½ΪʱѾؼǵãʼʯʱɷҰûʲôչΪվʲôݶУһɫûУվǸˡһӴվߵİɣ˵ۿҲ˵ǳأ20019£رҰ</p>\r\n<p>Ȼ󰢷ɣͼطŻҲվﳤܰѰɴĶ塣</p>\r\n<p>Щ꣬ΪվҪɳһЩվۼĵطK666Yuzi2002ĻվѾk666һվ̳ܲһЩԴأҲġyuziһṩ̳ȽվģҲһȺվ档ǰɷվòãң룺ԽԽ࣬վҲԽԽ࣬һվվӦûǰ</p>\r\n<p>2001ףɷĽվƻǴԴ֣ʱվСվվܶ඼ֳɵԴ룬ÿվ˵ﶼŸָԴ(Ҳͬ)ǰɰԼռ˺ܾõԴóһʵرۣҿãQQϵһʯæ</p>\r\n<p>ʯʱϰ࣬кܶʱ䣬ɸҪĶϣʯܰһվʯӦˣ򰢷ɱʾֻǰﰢɡʯܲվﲢûеסһֱ˵</p>\r\n<p>һϵͳ޸ĳԼҪģԼҳԴʯ£ɸ޸ġҳվЩ顣ɺʯûûҹŻһʱ䣬еԴ023³ƳվʱվʵֻһԴĿ</p>\r\n<p>йվվҲ˷ǳãһѡ2001עchinazzz.netйվվ˼ʱûǮ򵽸õ20021עchinazzz.comٺƼ˵cnzzz.comüǣǻcnzzz.comվʱõʵcnzzz.comһֱעchinaz.com</p>\r\n<p>վ滮ȴԴ֣Ȼվ̳չʱվռ䣬Ҳͬʱɷ֣ҪվȶǷǳҪġΪһ̨ԼķɽҰĽϷӪȨøɽˣȻдһݼƻ飬ϰҪһǮһ̨</p>\r\n<p>йվվһº󣬾һŵҪͶŹ档һʺ100Ǯĸ档Ӫģʽڴ֮ˣ棬ֱЩˡֻû뵽ô졣һֱڣչٶȱȰԼĿܶ࣬û뵽йվôӵôࡣ</p>\r\n<p>2003꣬йվվѾʮڸվѾһ֪ȣѾڰhao123ڵĸַվҳվƼ̶ܶԶҪͶŹ档</p>\r\n<p>2005°꣬ɵĹ˾ʽĿǰģнʮˣӯÿ¶ǣʵÿ¶ӯ漣</p>\r\n<p>&nbsp;</p>\r\n','0');
INSERT INTO `qb_reply` VALUES ('548','','1240126775','567','39','1','1','<p>繺ﻷս죬ԽԽ߿ʼϹҵ׻ͻ̼ҴͳӪģʽʱĽµӪģʽ</p>\r\n<p>úã̼/ҵƷ۵ƽ̨Ϊ̼/ۺĹͨƽ̨ʱгߺϢĹƽ̨γҵһ廯ҵֵƽ̨˾ܳûͿɴ󽵵ҵгɱЧʣͬʱҲܴƽƽ̨ϵõݸЧķӦڶ೧/˾Ӫչһʱ仯жҪ򣬾Ҫʱ̭Ƕն˲Ʒ/ҵ/˾Ҫ</p>\r\n<p>һ˾ҪѵɹĴҪظ㹻ӣֹӪ˲򣬲äĿͶǷ˼·ʹ󣬲Ҫ죬󲻵òʧܸա</p>\r\n<p>ҪһԽƽ̨Ҫ</p>\r\n<p>ܶ๫˾ʵڻڵתƣΪͰ͡۴ҵƽ̨ϷҵϢչǿչ˵ʵΪȱ£ĵԶקڱ˵ЩϢҵƽֻ̨Ϊƹ绷ѡ</p>\r\n<p>ҪԼĵԼ˾ҪԼգ뽨Լĵƽ̨ƽ̨Խ罨ԽãΪƽ̨ҲҪʱ۵ģ罨棬漤Խ࣬㹫˾ķչԽ</p>\r\n<p>Ҫضƽ̨Ӧѭѭɳչƽ</p>\r\n<p>1ⱻۿ̸</p>\r\n<p>ͨԶҿչĹ˾й۲췢֣ܶһʼߵ룬ͶʵĹ˾û?ڲһʼû侲äĿͶɣһʼ̬⣬ ƭϰ壬ƭͶߣɱ深ټ󣬽УȦǮһк³ĭˣԼһ֮ʵЩǲȱ飬ûʵʵҵ̬װƻ</p>\r\n<p>2</p>\r\n<p>Ҫѵɹץס˾ģ Ʒ + ƽ̨ + г չһƷƣгĹ˾˵˵ЩһʼûƷƣûгͻʲôհ׵Ĺ˾˵Ҫʱ֤ϾҲһͳɱ𲽵ĲκҪӻģһڶͣ档</p>\r\n<p>3ƽ̨ѭʽɳչ</p>\r\n<p>Խƽ̨ʱһһͶ뼸Ǳġ߸ݶľ飬ֽһĵƽ̨Щ̨Ժϡ𲽿죬Լʱ;ֿɱ˷ѲҪĳɱͶ롣ץۡƹ㣬ںܶȱʵʲһʼǿ̨ҪδǿʵһʼòϣԶҲòϣʵʡѭʽɳչϲߣƽ߶ܽܣɹĸʺܸߡ</p>\r\n<p>Ҫ˾ŶӶԵĸ߶ͬ</p>\r\n<p>Ͼǽ귢չܶ๫˾ϰ塢оȨĸ߲ⷽʵûʲôʶеĿ˵ⷽ湫˾Ŷûи߶ȵͬӣڹ˾ڲáչ棬ͿܴһԽĺ蹵ǿŶӣһˡ</p>\r\n<p>һ˵߶ӵĹ˾ӴͶ룬ȫ֧֣Ĺ˾չͿ죬ЧҲ;֮ͻԭ̤СнƿǿӾҲҪȵͬ;ߴ̼һ£Żһѣжжһ֪Թ˾ŶӶԵĸ߶ӣҲǵɹĹؼҪء</p>\r\n<p>ҪģҪпɿĵͷ</p>\r\n<p>˾ҪҵһʵսĴͷˣۿ̸ңṩԹ˾Ը˶Ŀռ䷢չƽ̨ʽչ˾ĵſɳչȥһһ˼·˾˳չɲҪʱ䡢˷ѡȻѡһʵҲȷʵףοһרҲࡣ</p>\r\n<p>õչ͡Ӫ͡͹˾/ҵֻҪĵҪõͿ޶ȵرڵǰΣ£Եͳɱĵģʽʵذѹ˾չٷչĻʱһҵǰ;Ⱦ֣̻;߳</p>\r\n<p><br />\r\n: վ(<a href=\"http://www.admin5.com/\">www.admin5.com</a>) Ĳο<a href=\"http://www.admin5.com/article/20090408/141109.shtml\">http://www.admin5.com/article/20090408/141109.shtml</a></p>\r\n','0');
INSERT INTO `qb_reply` VALUES ('546','','1240126684','566','39','1','0','ݿ⣨DBCɸⲿPDFĵXMLκ顣 <br />\r\n<br />\r\nPHPĿIDE&lt;php ΪĿʼ &gt;ΪPHPĽȻҲô &lt;% %&gt;ı&lt;script LANGUAGE=php&gt;&lt;/script&gt;ASPĸʽ PHPPHPЩ־䴦е顣 <br />\r\n<br />\r\nPHPıCPerlʹ֮ǰûҪκαҽHashǺܼ򵥵顣PHPһЩΪ֯ʹĴṩܺõİ <br />\r\n<br />\r\nȻPHPApacheܿУPHPվһЩMicrosoft IIS  Netscape Enterprise Serer޷ϵָûcopy PHPĻ http: //www.php.com أҲʹòֲᣬ߰еĹPHPĹܺԵ˵<br />\r\n<br />\r\n13ʲôprֵ <br />\r\n<br />\r\nʲôpr PRֵȫΪPageRankPageRank(ҳ)GoogleһҳҪԡһַTitleʶKeywordsʶ֮GoogleͨPageRankʹЩߡҪԡҳվӶԺ <br />\r\nPRֵΪ10һPRֵﵽ4һվˡ <br />\r\nPRֵPageRankҳļȡGoogleĴʼLarry PageGoogle㷨ʽһ֣ʶҳĵȼ/Ҫԡ11010Ϊ֡PRֵԽ˵ҳԽܻӭԽҪ磺һPRֵΪ1վվ̫жȣPRֵΪ710վǳܻӭ˵Ҫ <br />\r\nǿ˵һվⲿԽPRֵԽߣⲿվļԽߣMacromediaվվϣվPRֵԽߡ磺ABC.COMվһXYZ.COMվӣΪABC.COMվṩһЩϺõվݣӶGoogleXYZ.COMΪABC.COMվͶһƱغͰװGoogleվPRֵ ʾ1. <a href=\"http://www.abc.com/\" target=\"_blank\"><font color=\"#0000ff\">www.abc.com</font></a> abc.com prֵǲͬʵġ [url=http://www.abc.com<a href=\"http://www.abc.com/a.htm\" target=\"_blank\"><font color=\"#0000ff\">www.abc.com/a.htm</font></a>]<font color=\"#0000ff\">www.abc.com</font><a href=\"http://www.abc.com/a.htm\" target=\"_blank\"><font color=\"#0000ff\">www.abc.com/a.htm</font></a>[/url] Ҳǲͬ 2. prߣҳЧͺã prߣӣҳǰ Ժܶ౾prߣкܶprߵӣؼǰ 3.pr һ3¸һΣмֵ prվӣӳȥĵվͱͷվprߡ <br />\r\n<br />\r\n14 βѯһվPRֵ&nbsp;&nbsp;<br />\r\n<br />\r\nܼ򵥣ԵgoogleĹٷվȥװһ google toolbar ȻڷҳʱĲ˵ֻһprֵʾȻҲкܶվṩ߲ѯprֵĹ, <a href=\"http://tool.admin5.com/\" target=\"_blank\"><font color=\"#0000ff\">http://tool.admin5.com/</font></a><br />\r\n<br />\r\n15 ʲôFTP<br />\r\n<br />\r\nFTP(File Transfer ProtocolļЭInternetʹ÷ǳ㷺һͨѶЭ飬ΪInternetûļ(ļϴ)ƶġҪʵFTPļ䣬˶װ֧FTPЭװĵϵĽFTPͻװһ˷ϵĽFTP <br />\r\n<br />\r\nͻFTPʹ÷ܼ򵥣ҪԶӣȻԶԶյ͸ӦִȷĿǰWindowsϵͳõFTPCUTEFTPFTPһƣǾǣûĳûעȨûûͿͲļ䡣FTP⣬ûanonymousΪûEmailַ¼ӶʹûԴ<br />\r\n<br />\r\n<br />\r\n16 ôϴԼݵռ <br />\r\n<br />\r\nFTPߣļ乤ߣcuteftpҳϴWEBָĿ¼ <br />\r\ncuteftpϴ岽裺 <br />\r\nCuteFTPĴĸ֣ǱļұǷϵļϴص <br />\r\nCuteFTPĲ˵ļվղվǩFTPַ<a href=\"ftp://yue.hhh.net/\" target=\"_blank\"><font color=\"#0000ff\">ftp://YUE.HHH.NET</font></a>ûӾͿˣһͻʾӳɹȻѡ񱾵صõҳڵļоͿԿʼϴˣ <br />\r\n<br />\r\n<br />\r\n<br />\r\n17 ʲôCMS<br />\r\n<br />\r\nCMSContent Management SystemдΪݹϵͳ <br />\r\nCMSģƣԼӿվٶȺͼٿĳɱ <br />\r\nCMSĹֻܲıҲԴͼƬFlashͼʼ <br />\r\nCMSʵһܹ㷺ĳƺһĲͳŷ򣬵ۺԵվ򶼿ԱΪݹϵͳ<br />\r\n<br />\r\n18 ʲôIIs<br />\r\n<br />\r\n&nbsp;&nbsp;InternetϢInternet Information Services¼IIS΢˾ṩĻMicrosoft WindowsWindows NT汾ĿѡWindows 2000Windows XP ProfessionalWindows Server 2003һУֵעǣձʹõWindows XP home汾ϲûIIS<br />\r\n<br />\r\n19 ʲôз<br />\r\n<br />\r\nһ̨ͬľҪԴġ˵ftpļϴأһ̨ΪFtp֮ļͿͨIPַзˣϴضWEBҲһֻվģûͨIPַʡ<br />\r\n<br />\r\n20 ʲôSEO<br />\r\n<br />\r\nUse some technics to make your website in the top places in Search Engine when somebody is using Search Engine to find somethingӢһɼΪŻ֮ص֪ʶSearch Engine Marketing(ӪSearch Engine Positioning涨λSearch Engine Ranking<br />\r\n<br />\r\nSEOҪͨ˽ץȡҳ桢νԼȷĳһضؼʵȼҳصŻʹӶվվļ <br />\r\n<br />\r\nŻôһּѭѧȫۻƣվṹҳԺվĻ⽻ԵȽк滮վǱʹонǿȻƣӶԴٽҵۺǿƷá<br />\r\n<br />\r\n򵥵˵SEOһվڰٶȣȸ裬ŻýϺõӶӮøǱڿͻһֵӪʽҲSEM(Ӫһַʽ<br />\r\n<br />\r\n21 ʲôB2B<br />\r\n<br />\r\nB2Bǣbusiness to bussinessдҵҵ֮ͨвƷϢĽ. B2Bҵҵ֮ͨвƷϢĽ B2Bҵʵֵƶҵҵչһ㣬ҵֱӵǽͳɱЧʣӳԶҲܴ޶ĻرǰȣҵսԽԽϢĽϡ˾CEOʶΪܱҵľϢҵأµϢͶǿҵʵڸҵճ<br />\r\n<br />\r\n22 ʲôC2C<br />\r\n<br />\r\nC2Cconsumer to consumerҲнClient to ClientҲûûĵԱûûȡѵĵվC2Cվ.<br />\r\n<br />\r\n23 ʲôweb2.0<br />\r\n<br />\r\nWeb2.0Web1.02003ǰĻģʽµһ໥ӦõͳƣһδӺݵⲿӦõĸWeb1.0ͨhtmlҳģʽݸḻϵԸǿԸǿWeb2.0ģʽķչѾΪµķչơ <br />\r\nWeb1.0Web2.0ת䣬˵ģʽǵġдͬ衱չɱؽջϢ컥ϢӻɵԪϣɡҳ򡰷/¼Ϣչӹϣɻ.<br />\r\n<br />\r\n24 ʲôdiv+css<br />\r\n<br />\r\ndivǲ cssʽ ˵ҳĺ ,˵ĳЩҳϵƯdiv,Ƿw3c׼ҳַdiv+css׼ᳫһַǣxhtml<br />\r\n<br />\r\n<br />\r\n25 ʲôݿ<br />\r\n<br />\r\nݿ\"ݽṹ֯洢͹ݵĲֿ\",ھùճУҪĳЩصݷŽ\"ֿ\"ݹҪӦĴ磬һЩλҪְĻ(Ա䡢ʡ״)ڱУűͿԿһݿ⣬ͨͿԸҪʱѯĳְĻҲԲѯĳڵְȵȡЩڼԶУǵ¹ͿԴﵽߵˮƽ⣬ڲֿȹҵҲҪڶ\"ݿ\"ʹüʵֲ񡢲ֿ⡢Զ <br />\r\n˵ˣݿǰ˳еĺܿѧݼϡʱĳ˳򣨻лУӣʱʱ԰һ˳ȡݣʮַ㡣<br />\r\n<br />\r\n26 MYSQLݿôݻָ<br />\r\n<br />\r\nݿabcd <br />\r\nlinuxϵУݿ·/var/lib/mysql/abcd <br />\r\nwindowsϵУݿ·ǣ...\\mysql\\data\\abcd <br />\r\n<br />\r\nŷݣһֱӱļУһǱݡ <br />\r\nֱӱļбȽϷͰȫҪȰݿͣˣ <br />\r\nһֱmysqldumpݣҪݿӦ÷ͣ.<br />\r\n<br />\r\n27 mssqlݿԶ̸<br />\r\n<br />\r\nSQL ServerݿⱸַʽһʹBACKUP DATABASEݿļݳȥһ־ֱӿݿļmdf־ļldfķʽҽʹõڶַʽıָ</p>\r\n<p>&nbsp;</p>\r\n</td></tr></tbody></table>\r\n','0');
INSERT INTO `qb_reply` VALUES ('534','','1240059129','556','39','1','1','<strong>飺</strong> <p>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<img onload=\'if(this.width>600)makesmallpic(this,600,1800);\' src=\"http://www_qibosoft_com/Tmp_updir/article/33/1_20090418200406_BlSMk.jpg\" width=\"800\" height=\"532\" border=\"0\" alt=\"9.jpg\" title=\"9.jpg\" /></p>\r\n<p>&nbsp;Ϊй߿ƼҵջĵһˡйϢʹߡں̶У4 繤1981ҵںϴѧϵ1984꣬ڻ粿ηӢʦȫͳֵܷĳɼ¼ȡΪйԺоԺŹӢдרҵо1986죬»ʲʱʿٴѧȫѧѧ1987ףôڴѧ˶ʿѧλ󣬽⽻ѧԺʾʿѧλʿѧλڼ䣬ȫĳ˹˾ˡӵްα༭1991ٻӰЭᡰ99űܳ͡ꡱƺš1993꣬ IDGͶ2000ԪϺίйһҺʼչ˾ظԵܾͬ꣬㶫кһҼʹ˾1998꣬ IDGŲ߻ҿƼƼͶʻڽйļҵṩʮԪĴҵ</p>\r\n<p>ȥһһҼ͹˾кͶʡѡ㡱ĿӮйȲ÷ͶʣлͶʳΪڶ˵롣</p>\r\n<p>Ϥһ˵ľ͸֪ȡᡣ</p>\r\n<p><strong>77ѧ</strong></p>\r\n<p>ںʡ̶С</p>\r\n<p>ʱǡĸĸ״Ӳתҵڵظֳθɲ׵İţ1973꣬뵽һ繤</p>\r\n<p>1977ָ߿һֱѧе˳ϺϴѧǵʱΪŵĹҵԿרҵʱѧУļһԻѧԳӢרҵ뱻ѡϡ</p>\r\n<p>77߿ȡ4.8%ºܽᣬζ㰲һݺù1981꣬ѧҵһαоûͨ󱻷䵽粿ηӢʦ</p>\r\n<p>ںϴѧѧڼ䣬һƪڡձͷ淢Ϊ̽ѧϰӢģ⼤Լ߹Ȥ1984꣬ȫͳֵܷĳɼ¼ȡΪйԺоԺϵӢɱרҵо</p>\r\n<p>ʱͶ»ʣĿľڶߡΪǾ˵ĸ׵Ӱ죬һϣΪһսؼߡ1986꣬ϰ꣬붼»жʵϰ</p>\r\n<p>ھͶоڼ䣬ѧУദǢһԸױǴѧ̽ȥѧϰšΪйŴҵԱȻҪѧϰĵطЩԥȻְҵѾΪȷŶ˽ӣ󡰶򡱣ʦ顣</p>\r\n<p>Ǹ˸ѧĺʱ䣬ṩʦƼţʮƪڡйձӢ֮󣬺ܿͻòʿٴѧϵ¼ȡ֪ͨ飬Ҵѧṩȫѧ</p>\r\n<p>Ϊһʱ벢֪ѧҪиͲܻøǩ֤ȻӢרҵʿ˵ʲô⣬׼ܣ617֣˳ͨ</p>\r\n<p>ڱĲƲһŷĻƱһЩΪõŵƷʱǵ뻹ߣԪȴĲˣͬڸйѧһæһЩֻ֮ʣ38Ԫˡ</p>\r\n<p>ڸ׵Ļͱ£ԭѾȶй˴38Ԫ</p>\r\n<p><strong>һ</strong></p>\r\n<p>̵ͷ죬ڵִ֮ĵˣҲλױǴѧʦ͵ѧУʱᣬΪ֧ϼ44Ԫ֮100Ԫ룬˵ĸǮ</p>\r\n<p>ڶ죬ȥѧУҵһ̵Ĺÿ¿׬375ԪȻҵһ˺ķӣÿֻҪ100ԪҵʱҵһװгĹ˴绰ҪΪ֧˵ˣ˵ȫҶΪ㽾!</p>\r\n<p>ϵѹȻڣȻʿٴѧϵĿγΪֻ꣬һĽѧ𡣳˼ӱѧҵ֮⣬뻹Ҫϴ򹤻һЩ롣ð˸µʱеѧ֣׫дģ˶ʿѧλºܽ᣺˿ܾһ飬ֻǾѹ</p>\r\n<p>˶ʿҵ󣬲ʿٴѧ빥ʿĽѧ𡣵յ˸⽻ѧԺĽѧ𣬸ѧԺΪĴѧѧϰ죬תѧѧԺʾʿѧλ</p>\r\n<p>ְ֮ҵܵ˲ʿٴѧѧԺĿ϶1998꣬ѧԺ롰ܳУѡƺšųڵĳɾͣרҵڵһλܳĴһͬ񽱵Ļ007ϵӰƬյ۹ľ˲³˹-Ѷ˹̹ߵHBǪܲ-</p>\r\n<p>ڹʿڼ䣬䵼ʦѴһйĵ࿯ҪһȶֶŵˣȥӦ˳˹Ƹáǿְڡӵһɾ͸ꡣΪ빤һֱûɲʿġ</p>\r\n<p>ڡӵڼ䣬ǡʱżŶ³ʷڸ⽻ѧԺݽӵ̡˺ܶҵʿIDGġ</p>\r\n<p>ϯĶ̸ġ硷һ£ʶԺϰġ</p>\r\n<p><strong>[IDG]</strong></p>\r\n<p>ٷչϢҵڴƻ΢ҵͷͬʱҵҲ˶гѶĴ</p>\r\n<p>19645000ԪһҼго˾ݹ˾IDC󣬹ݼŹ˾IDG</p>\r\n<p>Ķйгжԡǵһλй½ҵˡ1980Ļеҵĵӹҵʳй˾ˡ硷ܱ</p>\r\n<p>2000228գĸУʡѧԺ3.5ԪҲʷϸѧṩһʾӦ˾߲쵼аݷйҵҡǰã102йĵѡΪ2007й</p>\r\n<p>1991꣬̿ʱڵġӵѾͣ˹žûڵʱĻйչȽѣϣۺ̨幤Ȼϣͬиϵͳϵġ</p>\r\n<p>һ̸֮£ΪͶԵ116ţʽְIDGְĵһݹǰѹڵʱġʵӱϲ硷Ķİ·ʽΪ⣬ʱڿ̫гͬ졣</p>\r\n<p>һ·У˽˸ԶгĿʱIDG̫ҵֱλ˴һˣפۣ¼¡ǵȵأһˣפ̨壬̫˹ͬóһݱ档</p>\r\n<p>ǡĩʥǰϦλ˶ȥȼˣŬݱ档ľΪ̫ΣΪ̫ܲá</p>\r\n<p>һϷԵľºڽ˷̸ʱ䣺һ룬˵Ȼҵıˣ뿴˼ҵģ˵ıҿ˵û˵Ҫȥȼ٣æɣⰲŹԺפ̨ĵطҲȥˣҲ뿪˾ˣһ۵ܾ񵽼ôȥˣûô˵ҲãΪǴҲûʲô취ΪһᣬдǾͲܹҡ</p>\r\n<p>&nbsp;</p>\r\n<p><strong>IdgVC֮Ӯй</strong></p>\r\n<p>1993꣬IDGͶ2000ԪϺίйһҺʼչ˾̫ƽͶʣй𡱣ΪIDGҵͶʻ𡱣ܾ</p>\r\n<p><font color=\"#666666\">Ҹע ѶԴ֮Ʒ(֡ͼƬͼƵ)δѶȨκý͸˲ȫ߲תءתأѶ(010-85650997)ϵɺתעΥ߱׷</font><br />\r\n19981027IDGƼǩ¼ƻδ7ʱйӪһʷͶʻԷСƼҵºڽܡܿĲɷʱ˵˵lDGںһͶʣ˵ҵһע</p>\r\n<p>ʱڶԷͶȱ˽⣬һʱڣԹ㹻Ŀ⡣һ棬طϣͶʾض򣬻ضͲṩӦŻݴʩҵֻⷽռɳ25%ſܵŻݡIDGͬطģҷͶСռɣպںҵӵг25%Ĺɷݡ</p>\r\n<p>һΪؼǣ뱾˲ûд¹ͶҵԷͶʵʶԴ¼ڼʿĲɷá20072ڽܡʱɷʱ˵оǸ׵顣</p>\r\n<p><strong>[ӳƴ]</strong></p>\r\n<p>뱾ṩ֣IDGĵһ֧Ǵ1993꿪ʼ2003ΪֹرΪ36%ڶ֧Ǵ1999꿪ʼرʳ40%</p>\r\n<p>IDGѾͶ200ҹ˾ںейУһϵĹ˾IDGڲͬ׶νIDGͶʹҵѶٶȡѺѷ3721ȤWeb2.0ĿУIDGͶѶסѡ</p>\r\n<p>νTMT򣬿Ψһи֪ȣIDGûнľǰͰˡºͣõ500ԪķͶɸʢǣͷڹöģʼͶʡʼԵ롣</p>\r\n<p>IDGйͶɹɺܼ򵥣Ļ˵ǣɽϻӳƴйҵṹһУ˺ܴı仯ȻڹʱIDGһǡôʱһ</p>\r\n<p>йûзͶʵʷȻIDGŶӴΪ·ңΪˣʱĻۣγһ׸гʵ׼һ棬IDGͶĿӣγˡģƣһĿ漰ҵIDGעʵĹ˾һѶΪ֣һIDGԴǣߴƶҵչ</p>\r\n<p>йгãͶҡIDGʼĻת̨ǰȲĴҵѡĿӮйΪ3000ԪҺֵIDGṩ1000Ԫ뿪ʼΪ֪</p>\r\n<p><strong>õǵǮ</strong></p>\r\n<p>վԿһʱڡӮйеı֣һЩڲӦԼĲдʱꡢ̱شѡֵĻشܲ˵б˵Ŀ⡣</p>\r\n<p>һ⣬ȡͶĿĹؼʲô</p>\r\n<p>ʵйͶʵĳɹʷǳ֮ߣߵܶӦͶʡʡӡϣͶʿͶ10Ŀܹɹ1йҪߵö࣬Ϊ־IDG˵෴ҲͶ10Ŀ5ɹˣΪIDGֻ12%Ŀʧܡ</p>\r\n<p>ҵʿΪйгģ졢ɱ͡ΪTMTҵҪʱһ飬ĿǰϺʦнȻֻйȵ1/10</p>\r\n<p>&nbsp;</p>\r\n<p>ԭ֮⣬Ҫһ㣬й˺ƣҵģʽڳгõ˺ܺõļ飬ӦйҵڿĻᡣÿһйҵ亣ԭͣٶȸ衢ѺŻѷ˵Web2.0ҵˡ</p>\r\n<p>ͰµĲƷҲԭ͵ģֻǴİһЩйӦʵչƹ񣬻Դں֮ǰṩƷ񣬶ͨһҲǽeBayC2Cϵ</p>\r\n<p><font color=\"#666666\">Ҹע ѶԴ֮Ʒ(֡ͼƬͼƵ)δѶȨκý͸˲ȫ߲תءתأѶ(010-85650997)ϵɺתעΥ߱׷</font><br />\r\n˶ӦڵķͶ̻ڿ͵ҵ񣬶ǻڱгҵ¡ȻҲ⣬ڴýûܵʱĹ</p>\r\n<p><strong>[νִ]</strong></p>\r\n<p>͸˵ͶҪԶʱڻø߶رʷʽ</p>\r\n<p>Ͷ̻濼⣺ִ˵ıζƶԴһǴĿĿɲۡ</p>\r\n<p>IDGǡʱСĺ飬ýйȻǸ߱ݵҵ٣ÿŷǳѡʱСͨŬܲŹξֵ֧֣ܲŲʱ֧졶ʱС2000ѡⷹ꡷͡йεתɡʱС־졣ⷹ꡷ΪʱмҾӡ³棬йεΪʱн</p>\r\n<p>IDGͶʵѷ䴴Īȫ֮ǰι˹Teleres޼йܾ˹TeleresĻزѶ̣ʵĪȫ˹Teleresչ׶Ρ</p>\r\n<p>һ棬µҵԽֱۣԽԽãζɲԡѷҵģʽܼ򵥣㹻ƶ߹йزҵںܳһʱ䶼Կá߻һǶȣ͡ʱСԣҵԱҪ㹻ļܣǲƾôѡ</p>\r\n<p>ΪʲôһʱվڡֻܲվʶֵͶߵҪַҵģʽܼ򵥣ԱûҪƶ߹Ȼ߹гһֱͷȻǣ̫뵽һȥˡ</p>\r\n<p>ɻһģĿ꣬һҵƶò˳ôͶٻѡһĽͶʴӡ</p>\r\n<p>šӮйĿﵽΨһίھͷǰ磬ǺѡʽɸѡƣǷܹѰٵʵͶʻᣬȻд֤</p>\r\n<p><strong>ʱ</strong></p>\r\n<p>2006930գôƵ꣬ڵĽ조BazaarǴҹֳ99999ԪFendi BִһһŮִ֪ºδ</p>\r\n<p>2007128գ100Ԫңɶèо2006һ˫̥èΪɽ͡ˮӦöΪһΪҲŨŨʱζ</p>\r\n<p>֪IDGǡʱСĺ飬1997IDG͡ʱСʳʱ֮й湫˾IDGûʱýԴIDGĽܣʱС˹س漯µCosmopolitanEsquireİȨ</p>\r\n<p>ԡʱСȤǿ20068£IDG֡ʱСƳʱվYoka..comԵҹ˾Ķ³վϻ㼯ˡʱСڶ࿯ĵӰ棬ֻʱ΢ͺһЩ</p>\r\n<p>ͣйõķչͻڸ߶ʱƷ׷ǿҡYoka..comרעΪ߶Ʒơ߶Ⱥṩ˵ǰ׷ʱеƣӦ˹һƷƶй͸</p>\r\n<p>Ȥԭ򣬵ĳҲ˵Ƶ⣬йѸٵвӮйгĹؼʼڼ۸ڷı䡣ͬͲƷͬƷγɵƫܹʵֳڵۡ</p>\r\n<p><strong></strong></p>\r\n<p>ʱȻоı仯ʵǹѸ٣ҪŬܸķչڹȥ30ʱͨŬ','0');
INSERT INTO `qb_reply` VALUES ('544','','1240126531','565','39','1','1','<p>30УѧǵĿǰΪֹûбȽϳ졢רԸݴѧĵվ3ԭʶĸũִѧѧΪ˿У԰վƷߵһǵĴҵӵĹע</p>\r\n<p>ûӮ ׼־ս</p>\r\n<p>3ѧ66У԰(<a href=\"http://www.66xiaoyuan.com\">www.66xiaoyuan.com</a>)ݰУ԰̳ǡУ԰רҵҵĻýȸ棬۵ƷԴסи档ռũִѧһ¥ײֿ⣬ڷż̨ԺһЩ׼Ҿߡ66У԰ҵŶӵİ칫ص㡣</p>\r\n<p>ܼª˼˵ǸũִѧͨŹרҵ2008ҵվӪˡ</p>\r\n<p>߼ߣ20083£66У԰ҵŶ12£վʼӪũִѧרҵ2009ҵȺԸƷɹֲﱣרҵ2008ҵսվļά</p>\r\n<p>30УѧһܴгǵĿǰΪֹûһȽϳ졢רԸݴѧĵվȺ˵Ȼҵ66վûʵӮǿ׼гȥ</p>\r\n<p>ǰʵӮϣڽ°ꡣҪһù˿ͽܵḶ́Ҫʶվվá˵ȡִʩڸݸУƹվƷơ</p>\r\n<p>ơ ɴҵŶ</p>\r\n<p>ڴҵ֮ǰǲʶǹͬ־ߵһ20078£ű1ԪǮĳѵųǸУƹҵ䣬ڸũִѧٰһԽǮμѵֻ2ˣоͰȺԡ</p>\r\n<p>ǱơġȺЦ˵֮ԲμѵΪҲдҵ롣ʶܺҾһµˡ</p>\r\n<p>2007ףȺԶƵġͰ֮͡3ϣ˯ž룬ʲôʱԼһڵ</p>\r\n<p>ͨУ԰̳Ⱥҵ̳ս̸ˣû뵽һļϡ˾ߵһ</p>\r\n<p>ʼʱܶ⣬ҲԽľ飬ֻܿԼȺ˵ԽűҵĳȺԣѾҵܺսѹԵôˣǡÿ˽ͻʱϣ</p>\r\n<p>ֻҪһ˿ͣҲҪá2µףǵĴҵ̨ĹעȺڽӼ߲ɷʱʾֻҪڣͻվȥ</p>\r\n<p><br />\r\n: վ(<a href=\"http://www.admin5.com\">www.admin5.com</a>) Ĳο<a href=\"http://www.admin5.com/article/20090417/143322.shtml\">http://www.admin5.com/article/20090417/143322.shtml</a></p>\r\n','0');
INSERT INTO `qb_reply` VALUES ('549','','1240126816','568','39','1','1','<p>Ը⽫ԼĹʡ֮ڡ?Ҫ֪ѾԽԽġ̨϶ԼĹʡɹɹ롰һɹɹʰɡнṩɹʵרվְܿͬҵͬȺɹĹʵ</p>\r\n<p>ԹݵYAMO5ĸ߼ʦڡһɹϸԼн(˰ǰ)8Ԫʣ1406Ԫ;λ2858Ԫ</p>\r\n<p>YAMOһɹʣǻԡɹĹۣҷԼĹοĵáڡнϣbkhɹʣ롢ƱȸԼ΢Ĺʵó21ĴһЩɹʡվϣ˽⵽ҵĹаͨվṩԼְλȣһݡнʱȽϱ桱</p>\r\n<p>ܽ ɹʡĴֱǡ主йʱȡ֡ɹվǶʾᳫѡС˵Ҷɹһɹʣοһ£ܹΪԼĲο ν</p>\r\n<p><br />\r\n</p>\r\n','0');
INSERT INTO `qb_reply` VALUES ('550','','1240126852','569','39','1','1','<p>λɴ</p>\r\n<p>ĻɴҪѧҦҶѡҪɽˮʮеһ仰һֽκͻɴӰһηʽʼȫһʱѡһ߳УһɴգԸԻķʽ¼Ҫʱ̡</p>\r\n<p>羰˲</p>\r\n<p>ͳĻɴӰӰ¥ӰǾͽĹ԰·ĳƬˮҵ˵Ŀζ</p>\r\n<p>ֽκͻɴӰһ·ϵȻ羰ΪӰƷһ޶˻ɴ㷽ʽԽԽʱеˡ</p>\r\n<p>ҦЧӦλɴӰ硢Ӱ¥ȻŹ̻ݽܣҦҶĻɴ̫ԴĴĹɽկĺǵȷ羰صʤأ˺ܶĻɴѡĵط</p>\r\n<p>רҵʿλɴӰͻεһԪءӰĴ£Ŀǰҵ߶ˡϸַչλɴӰΪһҪβƷ</p>\r\n<p>λɴĸļӴ󣬿ʡȵ𲽷Ŵôβ˽⵽ػɴӰ¥ӰҵϸŻϢ?ܼ򵥡硱ڽϳ˴ȫԡԻɴӰվżġʤ̭ĿǰѾ˻ɴӰŻϷµľҲΪȫѡӰ¥ӰҵȨƽ̨ŻþýйɴӰҸɫΪṩȫķƽ̨</p>\r\n<p>ɴӰһŻ йɴӰ <a href=\"http://www.wed114.cn\">http://www.wed114.cn</a></p>\r\n<p>йɴӰרעڻɴӰҵй󲿷ֳеӰ¥ӰңĿǰѾͨдﵽ14015000Ӱ¥Ӱʽפ̣ͨйĻɴӰվߵϸ̼Ϣ̼һϢѡƷչʾŻȯֵעṩ̼ҵԷŻݻŹϢȡ</p>\r\n<p>ͨǶ100̼ҵĲãձΪйɴӰڹ״ˡɴӰšƣˡҵˡԱöȣͨ͹۵ķʽΪṩȨĽָ꣬ͨûֻƣ׼ǿ˽Ѷ̼ҵĿ͹ۣҲи̼ҷӦЩƺǾֶۣϣйɴӰԵļȼӴſγɸ͹۵ûơ</p>\r\n<p>ĿǰйɴӰƵȫӰ¥Ϣ⣬зǳḻںйɴдͼ(йɴдͼ)йӰȦ(˵Ѿн3ӰʦפУ˽ӦSNSƽ̨)й(רҵĽģϢܿ)йɴӰ̳(Ҫ漰ɴӰ)йӰ¥˲(ͨ˽⣬ո߲ãѾк̼ܶ淢ƸϢҲкܶӰʦױʦȽ룬γרҵӰ¥Ƹְ)</p>\r\n<p>༭С᣺༭ͨ෽˽⣬ΪйɴӰӪȷΪȫ׼ṩѡӰ¥ӰȨķƽ̨̼ͨй߷Եһʱ˽̼á»ŹϢϢߺ̼ҵõʵݡ˼⣺ȻȫݷḻϢЧʺܸߣȫվᴩԻߣر̳֯滹´󹦷</p>\r\n<p>޵һŻ þý <a href=\"http://www.99wed.com\">http://www.99wed.com</a></p>\r\n<p>þýĿǰȫ¸Ļ񼰻Ʒȫչʾƽ̨þû㼯˱Ϻڶ̼ҵѶϢ̼ϵȫλƽ׼ѵϣͨõļʱ̼Ҿʷ׳ʵŻݻϣʵѯǢ̸ףΪ׼˺̼ṩһЧݵһվʽƽ̨</p>\r\n<p>þýҪΪͨйĻͨȫ˽ԳP150򣬶IP5վ̼һԱפ500ҡͨþý90%ϵķԴ˾þýĽΪйһþýҪƵѶ֪ļ̼(ɴӰ졢ǵȵ)</p>\r\n<p>ͨ˽⣬þý2009꣬չģʽ͸й70%ϵгͬʱҲӴ»չģҵ־̽ӰĿܹҵý壬γйҵýƸߵ㡣</p>\r\n<p>༭С᣺þýй漰ҵվ֮һͨƵѸٷչ񣬾þý˻ҵȫ֪ƷƣΪ̼ܣþýͨרע¡顢롱صӪģʽ˴̼ҼʵͻȺ༭ͨ˽ͷ־þýĿǰȻû߳͵ģʽҪȻۼ׼ռǺܸߣȻþýкܸߵ֪ȣ̼ʵд˼</p>\r\n<p>һŻ Ҹ <a href=\"http://www.xfwed.com\">http://www.xfwed.com</a></p>\r\n<p>ҸרעڱҵڱܱҸ൱֪ȣԴһֱΪѺͱ޷ҵṩ񣬶ԱҵԴݺѯлϣѼʱϢڻҵڽϢƣĿǰҸѳΪڻȵҵŻվѸ١ʱṩػ޷չ򣬻³г̬ȫҵϢΪṩרҵĻָҵƼ»ƷȷȫµĻ</p>\r\n<p>ͬڱ߳ƵĻվ˭뵽޷ıжٵᣬҸʼСĻ˵ΪҵеҵṩһչʾƷƹ̨;Ϊ̤ϻõ׼ṩһ齻ɹƽ̨Ϊʵ룬Ҹ˺ܶ࣬еѶܼ֤ġҸ¶̬ŹΪΪ̳Щۼֻͨϸ</p>\r\n<p>༭С᣺Ҹй漰ҵվ֮һͨŹۼͨԱػгȫλھҸȻΪƽ̨׶ĻģҸרעڱڽҸԷչĸá˼⣺ڱҪǱг̼ޣ׼ޣҸչƿͻƿԱгھ͸µҵչҸӦÿǵ⡣ȹ̳ıҲǺϾ⡣</p>\r\n<p>վҵϡƶãǶڱվ˵гж?</p>\r\n<p>˵⡣ݡйҵչ鱨桷ʾҹ5ƽǼǽΪ811ԣгռ41%»ѷ棬 88.40%Ҫɴ;49.14%˼ƻ칫˾Ϊǳ;78.74%׼¥ٰ;36.83%ҪΪﹺɴ;67.66%˽Ρÿ˵ļȨƽѽﵽ12.58Ԫ˼㣬йȺһܶΪ4183Ԫ(811Ԫ41%12.58Ԫ)</p>\r\n<p>༭ĻоվʾվѾ¢ȫгֻΪǸɫչáȫطдСͬĻվҲ֮纼ݡ人ɶȵضвĵطҲƫȫ</p>\r\n<p><a href=\"http://www.admin5.com/article/20090417/143375.shtml\"></a></p>\r\n','0');
INSERT INTO `qb_reply` VALUES ('551','','1240126932','570','34','1','1',',ʱڽվ,뽨վĻ,ȴ25շRC.RCɽվʹ,ʽĻ,Ҫں,ſɷ.<br />\r\nĿǰƵĹܴ:<br />\r\n<br />\r\n<br />\r\nѼ¼<br />\r\n<br />\r\nԱ<br />\r\n<br />\r\nϵͳģɰװ,ɾ޺<br />\r\n<br />\r\nǩŻ<br />\r\n<br />\r\n֤ǿ<br />\r\n<br />\r\nԱӿѡ<br />\r\n<br />\r\n,бҳ,,,ȡJSʾ<br />\r\n<br />\r\n<br />\r\n̨п,շ,Ƿȫ,ֻ<br />\r\n<br />\r\nԹȥаȫ.<br />\r\n<br />\r\n,һŻ.Ըǿ<br />\r\n<br />\r\nͶƱĽһǿ<br />\r\nؼֹ <br />\r\nһվ̨ͼ<br />\r\n<br />\r\nŻһͼƬˮӡ<br />\r\n<br />\r\nCK༭<br />\r\n<br />\r\nӶʱ<br />\r\n<br />\r\nʱݿ<br />\r\nʱ<br />\r\n<br />\r\nбҳñǩӦĿFIDĿݡ<br />\r\n<br />\r\n<br />\r\n¾̬,ȡ÷Ծͻ,ʱȫվ̬+˼ؾ̬<br />\r\n<br />\r\nŻɻơбݹ࣬תȴʱдŻ<br />\r\n<br />\r\n˫ҳɽбǩ޸<br />\r\n<br />\r\nȵ<br />\r\n','0');
INSERT INTO `qb_reply` VALUES ('520','','1239789196','542','14','1','1','&nbsp;&nbsp; ȶǴ2008627ˣ<font color=\"#3366cc\">΢</font>ͬµĿһʲôأһִͬ΢28֮õ<font color=\"#3366cc\">CEO</font>ĬлȨˡһȽСӣ̫˵ϳ˻һϾͻԾʱǣʱ׼˯Ĭܡ<font color=\"#3366cc\">ձ</font>ɷʱݱȶǴġĬ˵ĶԣҲֻлǳɹؼأǱȶǴõ','0');
INSERT INTO `qb_reply` VALUES ('509','','1239785963','531','10','1','1','<p>sfdsfd</p>','0');
INSERT INTO `qb_reply` VALUES ('552','','1240127012','571','34','1','1','<p>-----20041011գݼݼϵͳ1.0淢 </p>\r\n<p>-----20041123գݼݼվ1.5淢 </p>\r\n<p>-----2005127գݼݼվ1.6淢 </p>\r\n<p>-----200534գݼݼվ1.61淢 </p>\r\n<p>-----2005211գݼݼվ1.8淢 </p>\r\n<p>-----2005328գݼݼվ2.0淢 </p>\r\n<p>-----2005420գ168վϵͳ3.0淢(ͬʱݼݼվΪ168վϵͳ) </p>\r\n<p>-----2005514գ168վϵͳ3.1淢 </p>\r\n<p>-----2005106գ168վϵͳ3.5淢 </p>\r\n<p>-----200711գPHP168վϵͳ4.0BETA淢(ͬʱ168վϵͳΪPHP168վϵͳ) </p>\r\n<p>-----2007320գPHP168վϵͳ4.0ʽ淢 </p>\r\n<p>-----200746-26,26չ(ӶԻƴ·140žC31008) </p>\r\n<p>-----2007426-610ƳVIPԱ </p>\r\n<p>-----200768գPHP168վϵͳ4.0SP淢 </p>\r\n<p>-----2007627գƳȨʽ </p>\r\n<p>-----2007726,Ѹ˽ɺϵ </p>\r\n<p>-----200784գPHP168վV4.0SP2ȫܰ淢 </p>\r\n<p>-----2007815,PHPWINDɺϵ </p>\r\n<p>-----2007818,Ȧϵͳ </p>\r\n<p>-----20070922, PHP168վV4.0SP3 ȫܰ淢 </p>\r\n<p>-----20071023,쳵˽ɺϵ </p>\r\n<p>-----20071025,붯PHPɺϵ </p>\r\n<p>-----20071102,עԾƼ޹˾(ӶԻƴ·140žC31008) </p>\r\n<p>-----200811,Ϣϵͳ롶ϵͳ </p>\r\n<p>-----2008110,벥CCɺϵ </p>\r\n<p>-----2008118,CNZZйվ˽ɺϵ </p>\r\n<p>-----2008409,PHP168վ2008վȨʽƳ </p>\r\n<p>-----2008601,PHP168վ2008ѰʽƳ </p>\r\n<p>-----2008814,2008ȫܰվϵͳʽƳ </p>\r\n<p>-----2008902,php168֪ϵͳѰʽƳ </p>\r\n<p>-----20081015,php168phpwindִϰϵͳ </p>\r\n<p>-----20081027,2008Ϣϵͳ </p>\r\n<p>-----2008121,˾ΪЭƼ޹˾Իƴ2ſҵҵ701 </p>\r\n<p>-----2009415,PHP168վV6֮BETA2ڲ԰ʽ </p>\r\n<p>-----2009420,PHP168վV6԰ʽ </p>\r\n<p>-----2009420,PHP168վV6.0վϵͳʽ </p>\r\n<p>-----2009523,PHP168ϢϵͳV6(ϰ) </p>\r\n<p>-----2009523,PHP168ϢϵͳV6() </p>\r\n<p>-----2009531,PHP168V6վϵͳUTF8淢 </p>\r\n<p>-----200971,PHP168վV6.02վϵͳʽ </p>\r\n<p>-----20091022,PHP168վV6Ϣǿ </p>\r\n<p>-----20091127,PHP168վV6ǿ淢 </p>\r\n<p>-----2010121,PHP168ʽ¹̳PHP168Ϊ벩Ϊ<a href=\"http://www.qibosoft.com\">http://www.qibosoft.com</a> <br />\r\n&nbsp;&nbsp;&nbsp;&nbsp; 벩Ϊ<a href=\"http://bbs.qibosoft.com\">http://bbs.qibosoft.com</a>,ͬʱԭֹͣʹ</p>\r\n','0');
INSERT INTO `qb_reply` VALUES ('510','','1239786083','532','10','1','1','ff','0');
INSERT INTO `qb_reply` VALUES ('553','','1240127172','572','34','1','1','û¹ <br />\r\n<br />\r\nԭPHP168ƷеVϵSϵУȫֿͬĹ˾Ӫҹ˾ûκϵ <br />\r\n<br />\r\n֮ǰPHP168ƷVϵеĲƷ6.02վ汾B2BϵͳϵͳطŻϵͳȵȣVϵкĿģVϵжƿĲƷۺ˾ <br />\r\n<br />\r\n֮ǰPHP168ƷSϵеĲƷԼSϵжƿĲƷۺȵȣϵSϵйٷ <br />\r\n<br />\r\n˾ԭPHP168ƷеSϵУۣҲҲṩۺ֧֡','0');
INSERT INTO `qb_reply` VALUES ('516','','1239788484','538','12','1','1','൱ģ!','0');
INSERT INTO `qb_reply` VALUES ('554','','1240127229','573','34','1','1','<p>ݴѷVϵSϵйһ̳ڻҡٷؿǣ12·̳ <br />\r\n<a href=\"http://bbs.qibosoft.com\">http://bbs.qibosoft.com</a> <br />\r\nΪVϵеĹٷ̳ </p>\r\n<p>⣬ôȻһΪҪӹ죬ʹʱеӢPHP168CMS&nbsp; VϵһֱûΪģʹԣôܺأԼĸأˣٷݶΪVϵȡΪ벩CMS벩طϵͳ벩B2BҵŻϵͳ벩ϵͳ </p>\r\n<p>벩Ϊٷͷɰٴڳͬչ <br />\r\nVϵн <br />\r\n<a href=\"http://www.qibosoft.com\">http://www.qibosoft.com</a> </p>\r\n<p>&nbsp;</p>\r\n<p><br />\r\nעΪʲôȡsoftβȡCMSβأΪSOFT,Ҫǲ<a href=\"http://www.microsoft.com\">www.microsoft.com</a></p>\r\n','0');
INSERT INTO `qb_reply` VALUES ('545','','1240126684','566','39','1','1','վ֪50&nbsp; &nbsp;&nbsp; &nbsp;&nbsp; &nbsp;&nbsp;&nbsp;ҾĺõĻһҪ <table cellspacing=\"0\"><tbody><tr><td><p>1 վĲʲô<br />\r\n<br />\r\n1һռռ <br />\r\n2Լ<br />\r\n3Լվ <br />\r\n4 ϴԼݵռ <br />\r\n5ƹԼվ<br />\r\n<br />\r\n<br />\r\n2&nbsp;&nbsp;վҪЩ<br />\r\n<br />\r\nƼҳͣFLASH+DREAMWEAVER+FIREWORKS <br />\r\nFLASHԴСٶȿҳ <br />\r\nFIREWORKSƸλͼʸͼΣͣťָͼƬ <br />\r\nDREAMWEAVERۺϹǿվܡ <br />\r\nFRONTPAGEãÿЧ <br />\r\n<br />\r\n<br />\r\n3 ʲô<br />\r\n<br />\r\nӼǶInternetڽIPַӦһַһɶϲɣ֮Ӣĵľ\".\"ָһ\".\"ұֳ߲ΪTLDҲΪһһ\".\"ֳ߲ΪSLDֳ߲ΪԴƣÿһһķ䡣 <br />\r\nƵICANNͷ䣬Ϊͨö(gTLD, General Top Level DomainҲΪ)͹Ҵ붥(ccTLD, Country Code Top Level Domain) <br />\r\nͨöûŵֻ.com.net.orgͨöInterNICĿǰICANNίNetwork Solutions˾еInterNICк͹Ҵ붥240ɶĸдʾֱͬĹң.cnйĹҴ붥CNNICĿǰйίйѧԺϢĳеCNNICк͹ <br />\r\nҵǶ\"ҵ̱\"ҵǳԼ̱꣬Ϊ̱ҪԺֵҲѱȫҵʶ̱궼ڸԵķھΨһԣInternetķչҵĽǶȿ̱ǱĬϵԣ̱һĹͬص㡣ҵѡʱϣúԼҵ̱һµǣ̱־иǿΨһԡ <br />\r\nֵǶǻĶҲһϡеȫԴICP͵񣬻ϿչҪʼһ˳ƹǻҵվɹĵһ<br />\r\n<br />\r\n4 ν<br />\r\n<br />\r\nIPַת̡IPַ·ϱʶվֵַΪ˼򵥺üǣipַʶվַĽDNSɡ <br />\r\n <br />\r\n<br />\r\nɰµĲ <br />\r\n1ͨƽ̨ <br />\r\n1<a href=\"http://idc.admin5.com/---\" target=\"_blank\"><font color=\"#0000ff\">http://idc.admin5.com/---</font></a>ͨIDӦ¼ͻϵͳ---------Ҫ---&gt;---дIPַ---趨ϵͳԶ---Ч <br />\r\n<br />\r\nA.ԭ¼ý30ȫDNSЧ <br />\r\n<br />\r\nB.Ѵڵ¼IPַ޸ģڹƽ̨DNS30ЧȫDNSһ6-12СʱЧ <br />\r\n<br />\r\n5 βѯһǷע <br />\r\n<br />\r\nʹWHOISѯ WHOISһѯѾעϸϢݿ⣨ˡע̡עں͹ڵȣͨWHOISʵֶעϢѯWHOIS Database WHOISѯϵͳֹ֧WHOISѯWHOISѯӢWHOISѯWHOIS ѯҲԵ<a href=\"http://tool.admin5.com/\" target=\"_blank\"><font color=\"#0000ff\">http://tool.admin5.com/</font></a>ѯϢ<br />\r\n<br />\r\n6&nbsp;&nbsp;ʲôطע<br />\r\n<br />\r\nƼע<br />\r\n<br />\r\nйƵ&nbsp;&nbsp;<a href=\"http://www.35.com/\" target=\"_blank\"><font color=\"#0000ff\">www.35.com</font></a><br />\r\nй&nbsp;&nbsp;<a href=\"http://www.net.cn/\" target=\"_blank\"><font color=\"#0000ff\">www.net.cn</font></a><br />\r\nй&nbsp;&nbsp;<a href=\"http://www.paycenter.com.cn/\" target=\"_blank\"><font color=\"#0000ff\">www.paycenter.com.cn</font></a><br />\r\n&nbsp;&nbsp;mgt.dns.com.cn<br />\r\nй&nbsp;&nbsp;<a href=\"http://www.bizcn.com/\" target=\"_blank\"><font color=\"#0000ff\">www.bizcn.com</font></a><br />\r\nй&nbsp;&nbsp;<a href=\"http://www.ename.cn/\" target=\"_blank\"><font color=\"#0000ff\">www.ename.cn</font></a><br />\r\n<br />\r\nidc.admin5.com б˵1ǮCN㲻Ͷ̫ʽĻûȥעᡣ<br />\r\n<br />\r\n<br />\r\n7 ʲôվռ<br />\r\n<br />\r\nվռ䣬򵥵ؽǴվݵĿռ䣬ʱͨͿԷʵԷվݣȻ󿴶Էվ£֡Ӱʲôġ<br />\r\n&nbsp; &nbsp;&nbsp; &nbsp; վռԲר÷վǲר÷?ҪվԤڷչ״ۺϿǡվ<a href=\"http://www.admin5.com/\" target=\"_blank\"><font color=\"#0000ff\">www.admin5.com</font></a>һ㽨ǣһСҵվݱȽ٣ܼ򵥣Ҳ󣬲ɣ޷վӪվĳЩ⹦ܣӦǲר÷ķʽ90%ϵվǲ.һ˵ҵվĿռСͿ,ʵվҪһ,طֵӰȴվҪԼ齨WEB.<br />\r\n<br />\r\n8 ѡվռ <br />\r\n<br />\r\nվ֮ҪһվռܷվݣѡվռվռʱҪӦǵذվռĴСϵͳһЩ⹦ݿ֧֣վռȶԺٶȣվռ̵רҵˮƽȡһЩͨҪǵݣ<br />\r\n&nbsp; &nbsp; 1վռ̵רҵˮƽͷѡվռĵһҪأѡȽϵµĿռ̣ܻܿվӪ⣬վ޷ʵʱѵõʱĽӰӪĿչ<br />\r\n&nbsp; &nbsp; 2ռСϵͳһЩ⹦ݿǷ֧֡ɸվռõĿռ䣬ԼԤԺӪӵĿռѡĿռСӦ㹻ӰվСһ˵ռԽ۸ҲӦϸߣһΧȨ⣬ҲûбҪĿռ䡣жֲͬãϵͳݿõȣҪԼվĹѡܣվ֮ǰ˽һƷվ֮Ҳʵṩ̡<br />\r\n&nbsp; &nbsp; 3վռȶԺٶȵȡЩضӰվҪһ˽⣬ܣʽ֮ǰ</p>\r\n</td></tr></tbody></table>\r\n','0');
INSERT INTO `qb_reply` VALUES ('555','','1240127281','574','4','1','1','˿ƼѶ ʱ418Ϣݹý屨Ͷʵл˹̹й˾(Bernstein Research)ʦܸֵ(Jeffrey Lindsay)ʾeBayչGmarketּطйձг<p>ܣeBayƵֲSkypeȻÿ24Ԫļ۸չGmarketͨɺADSչ۸ԼΪ12ԪԴˣֵΪeBayһشսԵ»عĵĵҵ</p>\r\n<p>ֵƣeBayGmarketƽ̨طйձгǰCEO÷񡤻(Meg Whitman)ʱeBayгıֲ⣬CEOԼɻ(John Donahoe)쵼£eBayϣطг</p>\r\n<p>2007꣬eBayĻһֱǺȵĵӦ̡GmarketռeBayķͷֵƣչGmarket֮eBayΧGmarketƶޣйгҵսԡ</p>\r\n<p>GmarketֵΪeBayһչ˾MercadoLibreŷ޵˾TradusƱ˾StubHubͷ湫˾Craig\'s Listȡ()</p>\r\n','0');
INSERT INTO `qb_reply` VALUES ('556','','1240127308','575','4','1','1','רҵٶȳ죬һӸ㶨һЩ̳͵վϣ˰˿վӡЩ߾ƣڡϢҵߵһվͨԼȴ԰վɹ༸Ӿܸ㶨ԴˣϺͨŹʿʾվȻͨѸվǧͼʡ¶Լº󻼡<p><strong>վҲһ</strong></p>\r\n<p>ϣ߿һΪܶƹҡңѡվ/ٱ/һӱһƷϸ˵˽׵վûбվӸ㶨20Ԫһվ;ûѾύûбɹվΪվҪʮӣ۸Ҳ50ԪվȽϷҪ10ʱͨ50ԪһվֻҪṩվơվʡơɡ</p>\r\n<p>2005Ų(ΪŲ)ġϢ취(¼ơ취)涨ڹڷϷõվ뱸ҰʱڶʮڡôЩṩһӿٱôٳɵ?</p>\r\n<p>ϺͨŹʿܣȥ꿪ʼֺܾͨ͹Ų㷢˴⣬ԭǵʱϵͳվһ©ͬһͬһſͬʱӦڲͬվνһӱɹʵϱһ©֮󣬹Ųܿ콫޸ֻҪ޸ʾδˡ״̬˵Ҳõһλṩٱ񡱿ͷĳϣ߼ߣѾ1ӱɹˣҲҪһ죬ںšһӱʵֻǸͷѡ</p>\r\n<p><strong>ʹôܻᱻ</strong></p>\r\n<p>ܾͨʿѼߣĿǰЩν챸ķʵΥݡ취ʱύ쵥λơʡЧ֤롢ܵĵλվ˻ϢõصȶϢ챸ߡ뷽ҪôϢһʹ뷽ڿʼɹһַܾͨϢ䱸Žϱע֪ͨISP뷽ʱǡˮһա</p>\r\n<p>ڡվ롱˵Ϊҥԡ3·ݣϺֱܾͨͨ1.5վһСʱһҲ˳ɹˣֻҪϢʵûһҲͨġ</p>\r\n','0');
INSERT INTO `qb_reply` VALUES ('865','','0','884','34','1','1','<p style=\"padding:0px;color:#222222;font-family:&#39;pingfang sc&#39;, &#39;hiragino sans gb&#39;, &#39;microsoft yahei&#39;, &#39;wenquanyi micro hei&#39;, &#39;helvetica neue&#39;, arial, sans-serif;line-height:28px;background-color:#ffffff;margin-top:16px;margin-bottom:16px;\"><span id=\"_baidu_bookmark_start_1\" style=\"display:none;line-height:0px;\"></span><span id=\"_baidu_bookmark_start_3\" style=\"display:none;line-height:0px;\"></span>ػġ塷ӭ˴֡ΪľʵֵĻǣͼͼɭ~~~ С㿴һʵֵģ</p><p>ʵ֣</p><p style=\"padding:0px;color:#222222;font-family:&#39;pingfang sc&#39;, &#39;hiragino sans gb&#39;, &#39;microsoft yahei&#39;, &#39;wenquanyi micro hei&#39;, &#39;helvetica neue&#39;, arial, sans-serif;line-height:28px;background-color:#ffffff;margin-top:16px;margin-bottom:16px;\"><img src=\"http://www_qibosoft_com/Tmp_updir/article/34/1_im2ia__0.jpg\" img_width=\"720\" img_height=\"899\" alt=\"塷벻ʵ֣\" inline=\"0\" style=\"border:0px;max-width:100%;display:block;margin:10px auto;\" /></p><p class=\"pgc-img-caption\" style=\"padding:0px;text-align:center;font-size:12px;color:#777777;line-height:16px;font-family:&#39;pingfang sc&#39;, &#39;hiragino sans gb&#39;, &#39;microsoft yahei&#39;, &#39;wenquanyi micro hei&#39;, &#39;helvetica neue&#39;, arial, sans-serif;background-color:#ffffff;margin-top:0px;margin-bottom:16px;\">ƽûֵܵסǮջˣס˺լ˺</p><p style=\"padding:0px;color:#222222;font-family:&#39;pingfang sc&#39;, &#39;hiragino sans gb&#39;, &#39;microsoft yahei&#39;, &#39;wenquanyi micro hei&#39;, &#39;helvetica neue&#39;, arial, sans-serif;line-height:28px;background-color:#ffffff;margin-top:16px;margin-bottom:16px;\"><img src=\"http://www_qibosoft_com/Tmp_updir/article/34/1_0ojy6__0.jpg\" img_width=\"640\" img_height=\"817\" alt=\"塷벻ʵ֣\" inline=\"0\" style=\"border:0px;max-width:100%;display:block;margin:10px auto;\" /></p><p class=\"pgc-img-caption\" style=\"padding:0px;text-align:center;font-size:12px;color:#777777;line-height:16px;font-family:&#39;pingfang sc&#39;, &#39;hiragino sans gb&#39;, &#39;microsoft yahei&#39;, &#39;wenquanyi micro hei&#39;, &#39;helvetica neue&#39;, arial, sans-serif;background-color:#ffffff;margin-top:0px;margin-bottom:16px;\">￵ְͨϰգ˼Сӹû</p><p style=\"padding:0px;color:#222222;font-family:&#39;pingfang sc&#39;, &#39;hiragino sans gb&#39;, &#39;microsoft yahei&#39;, &#39;wenquanyi micro hei&#39;, &#39;helvetica neue&#39;, arial, sans-serif;line-height:28px;background-color:#ffffff;margin-top:16px;margin-bottom:16px;\"><img src=\"http://www_qibosoft_com/Tmp_updir/article/34/1_k1kfv__0.jpg\" img_width=\"392\" img_height=\"580\" alt=\"塷벻ʵ֣\" inline=\"0\" style=\"border:0px;max-width:100%;display:block;margin:10px auto;\" /></p><p class=\"pgc-img-caption\" style=\"padding:0px;text-align:center;font-size:12px;color:#777777;line-height:16px;font-family:&#39;pingfang sc&#39;, &#39;hiragino sans gb&#39;, &#39;microsoft yahei&#39;, &#39;wenquanyi micro hei&#39;, &#39;helvetica neue&#39;, arial, sans-serif;background-color:#ffffff;margin-top:0px;margin-bottom:16px;\">쳤Ϊⶾʧ촩һЩװֹ٬</p><p style=\"padding:0px;color:#222222;font-family:&#39;pingfang sc&#39;, &#39;hiragino sans gb&#39;, &#39;microsoft yahei&#39;, &#39;wenquanyi micro hei&#39;, &#39;helvetica neue&#39;, arial, sans-serif;line-height:28px;background-color:#ffffff;margin-top:16px;margin-bottom:16px;\"><img src=\"http://www_qibosoft_com/Tmp_updir/article/34/1_b43vu__0.jpg\" img_width=\"440\" img_height=\"500\" alt=\"塷벻ʵ֣\" inline=\"0\" style=\"border:0px;max-width:100%;display:block;margin:10px auto;\" /></p><p style=\"padding:0px;color:#222222;font-family:&#39;pingfang sc&#39;, &#39;hiragino sans gb&#39;, &#39;microsoft yahei&#39;, &#39;wenquanyi micro hei&#39;, &#39;helvetica neue&#39;, arial, sans-serif;line-height:28px;background-color:#ffffff;margin-top:16px;margin-bottom:16px;\"><img src=\"http://www_qibosoft_com/Tmp_updir/article/34/1_vu9d6__0.jpg\" img_width=\"720\" img_height=\"690\" alt=\"塷벻ʵ֣\" inline=\"0\" style=\"border:0px;max-width:100%;display:block;margin:10px auto;\" /></p><p class=\"pgc-img-caption\" style=\"padding:0px;text-align:center;font-size:12px;color:#777777;line-height:16px;font-family:&#39;pingfang sc&#39;, &#39;hiragino sans gb&#39;, &#39;microsoft yahei&#39;, &#39;wenquanyi micro hei&#39;, &#39;helvetica neue&#39;, arial, sans-serif;background-color:#ffffff;margin-top:0px;margin-bottom:16px;\">֣ʤʧҵĴѰҹڶӡı˷ݲ</p><p style=\"padding:0px;color:#222222;font-family:&#39;pingfang sc&#39;, &#39;hiragino sans gb&#39;, &#39;microsoft yahei&#39;, &#39;wenquanyi micro hei&#39;, &#39;helvetica neue&#39;, arial, sans-serif;line-height:28px;background-color:#ffffff;margin-top:16px;margin-bottom:16px;\"><img src=\"http://www_qibosoft_com/Tmp_updir/article/34/1_f8w6v__0.jpg\" img_width=\"380\" img_height=\"368\" alt=\"塷벻ʵ֣\" inline=\"0\" style=\"border:0px;max-width:100%;display:block;margin:10px auto;\" /></p><p class=\"pgc-img-caption\" style=\"padding:0px;text-align:center;font-size:12px;color:#777777;line-height:16px;font-family:&#39;pingfang sc&#39;, &#39;hiragino sans gb&#39;, &#39;microsoft yahei&#39;, &#39;wenquanyi micro hei&#39;, &#39;helvetica neue&#39;, arial, sans-serif;background-color:#ffffff;margin-top:0px;margin-bottom:16px;\">ǵںͶ˽ȥũ嶨<br /></p><p style=\"padding:0px;color:#222222;font-family:&#39;pingfang sc&#39;, &#39;hiragino sans gb&#39;, &#39;microsoft yahei&#39;, &#39;wenquanyi micro hei&#39;, &#39;helvetica neue&#39;, arial, sans-serif;line-height:28px;background-color:#ffffff;margin-top:16px;margin-bottom:16px;\"><img src=\"http://www_qibosoft_com/Tmp_updir/article/34/1_asx0w__0.jpg\" img_width=\"500\" img_height=\"301\" alt=\"塷벻ʵ֣\" inline=\"0\" style=\"border:0px;max-width:100%;display:block;margin:10px auto;\" /></p><p class=\"pgc-img-caption\" style=\"padding:0px;text-align:center;font-size:12px;color:#777777;line-height:16px;font-family:&#39;pingfang sc&#39;, &#39;hiragino sans gb&#39;, &#39;microsoft yahei&#39;, &#39;wenquanyi micro hei&#39;, &#39;helvetica neue&#39;, arial, sans-serif;background-color:#ffffff;margin-top:0px;margin-bottom:16px;\">ʢһʱɽˮűƲˮ</p><p style=\"padding:0px;color:#222222;font-family:&#39;pingfang sc&#39;, &#39;hiragino sans gb&#39;, &#39;microsoft yahei&#39;, &#39;wenquanyi micro hei&#39;, &#39;helvetica neue&#39;, arial, sans-serif;line-height:28px;background-color:#ffffff;margin-top:16px;margin-bottom:16px;\"><img src=\"http://www_qibosoft_com/Tmp_updir/article/34/1_uysvl__0.jpg\" img_width=\"551\" img_height=\"353\" alt=\"塷벻ʵ֣\" inline=\"0\" style=\"border:0px;max-width:100%;display:block;margin:10px auto;\" /></p><p class=\"pgc-img-caption\" style=\"padding:0px;text-align:center;font-size:12px;color:#777777;line-height:16px;font-family:&#39;pingfang sc&#39;, &#39;hiragino sans gb&#39;, &#39;microsoft yahei&#39;, &#39;wenquanyi micro hei&#39;, &#39;helvetica neue&#39;, arial, sans-serif;background-color:#ffffff;margin-top:0px;margin-bottom:16px;\">˻ɳǣΪٳĹĶǣƺ쳾³...</p><p style=\"padding:0px;color:#222222;font-family:&#39;pingfang sc&#39;, &#39;hiragino sans gb&#39;, &#39;microsoft yahei&#39;, &#39;wenquanyi micro hei&#39;, &#39;helvetica neue&#39;, arial, sans-serif;line-height:28px;background-color:#ffffff;margin-top:16px;margin-bottom:16px;\">ôִһ</p><p style=\"padding:0px;color:#222222;font-family:&#39;pingfang sc&#39;, &#39;hiragino sans gb&#39;, &#39;microsoft yahei&#39;, &#39;wenquanyi micro hei&#39;, &#39;helvetica neue&#39;, arial, sans-serif;line-height:28px;background-color:#ffffff;margin-top:16px;margin-bottom:16px;\">ݴ鹹һ¾ͺ~~~</p><p><br /><span id=\"_baidu_bookmark_end_4\" style=\"display:none;line-height:0px;\"></span><span id=\"_baidu_bookmark_end_2\" style=\"display:none;line-height:0px;\"></span></p>','0');
INSERT INTO `qb_reply` VALUES ('557','','1240127373','576','4','1','1','1000ԪһվվϷٵͶϢԸ߻رŵ˿͡һй˿ţȰͶʣһġӯΪرյʽ󣬾;Ǯߡӽ2½ֹʱ()ʯ()ʽΡܺУһԳɶ򸾱ƭ߽64ԪգɶԺթƭｫ桢ʯͬȻӡ<p><strong>վͶʱƭ60</strong></p>\r\n<p>211գɶ()ͨҵһΪĳ֤ȯͶ޹˾վҳϽܣڸù˾Ͷʻرܸߡµù˾ǽˡ߻رͶʡںɷ򶭻()µù˾ѯ˾ǮͶʡ</p>\r\n<p>212գ˾ָ˻ϻ38000Ԫڶ죬˾ͷ1900Ԫġӯ˵˾̲Ͷʵʱ죬ִ21Ԫ˺Ҳٴյˡ½40ԪͶʹ˾˻</p>\r\n<p>220գ˾绰Ҫ׷Ͷʣʱûʽ׼˳Ҫ˾ӯһ𻹣ԷظҪһڵʱ䡣</p>\r\n<p>ϣϲҸù˾ȴҳѾʧ绰Ҳû˽ӡʱù˾71Ԫڼ䷵7Ԫġӯн64Ԫ֪ȥ221ϣ˷ɻǰָù˾Ͳڣæ</p>\r\n<p><strong>վ</strong></p>\r\n<p>ӱ󣬾չ顣311գͳʯ뷨</p>\r\n<p>潻Ǹˣ25գͳʯ˴Ӹǰڣ1000ԪһվϷ˸߻رͶϢϵʽ˵򸾵60ԪƭֺǾ͹صվǮߡӻ־ݳʯ֮ǰҲ編ƣ45ΡͶʡƭõĽ5¡</p>\r\n','0');
INSERT INTO `qb_reply` VALUES ('524','','1240050071','546','32','1','1','<p>Ϊйƽ̨֧Ŷ֮һqibosoftPHPwind˴ٶЯ֣qibosoft V5.0PHPWIND 7.0ϺV6PW7.0ٴǿϡCMSBBSں⣬ CMS+BBSƽѾγɡ</p>\r\n<p><strong>qibosoft V6PW7.0ϰ潫¼㣺</strong></p>\r\n<p>ԱPWݣûӵ׷١޸ġ鿴V6ԱĽСV6ԱĽΪqibosoftϵ֮һ</p>\r\n<p>ͼƬʵ޷͡PW̳ͼƬǳ͵CMSϵ</p>\r\n<p>qibosoft PWʵĿ»ţͬʱʵ־̬</p>\r\n<p>V6רͼƬʵCMS+BBSšͬĿпɻϵͼƬ</p>\r\n<p>qibosoft PHPwindܽԭԴŻϣƽ̨ϵøи</p>\r\n<p><strong>qibosoft V5.0PW7.0ϰй£</strong></p>\r\n<p>һϢͬ</p>\r\n<p>̳ӿƼqibosoftվϵͳʾ</p>\r\n<p>qibosoftϵͳ̳ϵݶܲվ</p>\r\n<p>ġͬע ¼˳</p>\r\n<p>塢qibosoftphpwindͬ</p>\r\n<p>վҳԵʾ̳ĸͳϢ</p>\r\n<p>ߡվͨǩɵʾ̳ĸĿ</p>\r\n<p>ˡվϵͳĲɼܿԲɼݵ̳Ŀٳʵḻ̳</p>\r\n<p>ƽ̨ںϣʹûлͬʱרҵŶӿĲƷûĿڼиǿչԡ</p>\r\n','0');
INSERT INTO `qb_reply` VALUES ('558','','1240127449','577','4','1','1','˿ƼѶ 417Ϣ֪ʿ416͸¶йƶOPhoneֻɻзСΧԣЧá<p>Ϥ5³EDGE汾OPhoneֻУTD-SCDMA׼ֻҲڵļС</p>\r\n<p>OPhoneֻйƶOMSֻϵͳƽ̨ΪзһֻֻOMSйƶԹȸAndroidΪ</p>\r\n<p>봫ͳֻȣoPhoneֻڻֻɱ⣬oPhone֧ƶͨoPhoneҲԺʵ HttpݣˣoPhoneֻiPhoneֻ࿹⡣() <br />\r\n</p>\r\n','0');
INSERT INTO `qb_reply` VALUES ('525','','1240050179','547','32','1','1','<div>ʾ,֧ϴͼƬ,WORD,Ƶ,Ƶ.</div>\r\n<p>&nbsp;</p>\r\n','0');
INSERT INTO `qb_reply` VALUES ('526','','1240050522','548','32','1','1','<p>ʾʵ</p>\r\n','0');
INSERT INTO `qb_reply` VALUES ('559','','1240127959','578','39','1','1','<p>&nbsp;</p>\r\n<p><strong>˿Ƽ<a href=\"http://tech.sina.com.cn/talk/silverage/index.html\" target=\"_blank\">ʱϵз̸</a>һ</strong>ʱ˿ƼƵƳһǿĿȱдۡ顢ͼ̸ȶʽչһٳɳĴҵ͸߿Ƽҵķ档ڣ˿ƼҲ½ܹעĴҵҵʼˣѽн</p>\r\n<p><strong>Ϊ־ʵ¼</strong> </p>\r\n<p><strong>ʹ۵㣺</strong></p>\r\n<p><font face=\"_GB2312\">- ֮ǰӯѹ⣬ÿС˾⣬ǲȡһѡһշѵĲ</font></p>\r\n<p><font face=\"_GB2312\">- ϣ㲻ֻҪûʹþļֵԼĺľ</font></p>\r\n<p><font face=\"_GB2312\">- ʼΪҹкܶãԺҾͳԺҿһݺõĹҲоѧһĳ</font></p>\r\n<p><font face=\"_GB2312\">- ҼһŵڣһֱϣܹоʿѧҳԹʺôҲôִһ˵ԼҵԼ</font></p>\r\n<p><font face=\"_GB2312\">- ǶԷͶԼ⣬ǲǿĹ˾ڶԼҲҪͶ˸</font></p>\r\n<p><font face=\"_GB2312\">- Ҫ꣬㲻ҪҪȥڶʣ׬ٴǮȵȡҪм򵥡ӵ룬Ϊһ׵ҵһʼʲôûУûмҲûܴ飬ɹĸʻܵͣȻҪ׬Ǯӯʣ㲻ϵʧҵĻ<p align=\"center\">&nbsp;</p>\r\n<p align=\"center\">ͼΪDiscuzCEO־</p>\r\n</font></p>\r\n<p align=\"center\">&nbsp;</p>\r\n<p align=\"center\">ͼΪDiscuzCEO־</p>\r\n<p>&nbsp;</p>\r\n<p align=\"center\">&nbsp;</p>\r\n<p align=\"center\">ͼΪDiscuzCEO־</p>\r\n<p><strong>ˣ </strong>λãӭһڵ˿Ƽʱϵз̸<strong>ǽˣһƾձǿ</strong>뵽ļαDiscuzCEO־Ǵϴѧ30򵽱˾ġ򵥽һԼ</p>\r\n<p><strong>־</strong> λѴҺãܸлҽһЩҵɳľ;Щ;δغܳȷһĿռ䣬Դ˵ǶԼ˵һǳõĻᡣ</p>\r\n<p><strong>ˣ </strong>һѵ⡣</p>\r\n<p><strong>ѣ</strong>24꣬ǲѧУŴҵô̳</p>\r\n<p><strong>־</strong> ҿ϶ѧУ봴ҵ飬˴ѧôѧԤڵĲһҺһЩԼ飬ѧ̵ĶҵȤƫڴѧһ꣬Ϳʼ顣̳֮Ǻܼ򵥣һкܶѽкܶûûӵʹͨܶþһ顣</p>\r\n<p><strong>ˣ </strong>˵ڴѧʱ׬˺ܶǮȻ󵽱Discuz˾</p>\r\n<p><strong>־</strong> ʱܼ򵥣һֱáȻʱҵǰӯռ䣬һҪԵԼĸԼ֮ǰ뷨ҾôҵͿ˾ʽϵ⣬һ˳µġ</p>\r\n<p><strong>ˣ </strong>Ĺ˾0405귢չǳõ£DiscuzȫѣǻʲôĿǣ</p>\r\n<p><strong>־</strong> ĳúܹܶӰܶ໥ûʹϰߣ֮ǰӯѹ⣬ÿС˾⣬ǲȡһֵѡһշѵĲԣշѵżԽԽߣǺܶǮܶ඼Ǹ˵վҸ˵վǻһʱǿ϶Ѹʹãͻǵ롣</p>\r\n<p><strong>ˣ </strong>ںܶѶDiscuzǺʲôģʲôص㣿</p>\r\n<p><strong>־</strong> DiscuzBBS˵̳ճBBSвͬʽÿһвͬʽBBSʽDiscuzСվվͨʹɵعԼϵͳǱڰȫϡŻܵƷ涼ûΪ</p>\r\n<p>Ŀʼʱ䲻Ǻܳ34ʱ䣬ȡһΪԼһĳɼ</p>\r\n<p><strong>ˣ </strong>Ǵʲôʱʼ뵽ѵģ</p>\r\n<p><strong>־</strong> 053·ݡ</p>\r\n<p><strong>ˣ </strong>053·ݵ׵12µף֮һܳḶ́</p>\r\n<p><strong>־</strong> ̾ǲϵ˼붷ϵ˼ʲôʱʲôʱʺ</p>\r\n<p><strong>ˣ </strong>0512·ݾʺϣ</p>\r\n<p><strong>־</strong> ԣҪģһ˾Ҫ棬ҪάֽķչԵʱã֮ǰΪ̳۶05׶γɳıȽѸ֮ͣͻȻ͸оƺ̫ҪѹҪô鷢չ׳</p>\r\n<p>ԣ0512һȽϺõʱҪԭﵽҪ</p>\r\n<p align=\"center\">&nbsp;</p>\r\n<p align=\"center\">ͼΪDiscuzCEO־</p>\r\n<p><strong>ˣ </strong>ǹģռ̳70%ңҲ֪Ժûµӯģʽ</p>\r\n<p><strong>־</strong> ӯģʽ˾ûΪģҪ˾صĶʵԼֵĹ˾Ҿûϣ㲻ֻҪûʹþļֵһûʹ벻ԼĺľҾֻҪʹþͻļֵ</p>\r\n<p><strong>ˣ </strong>ӯģʽûȶԺȥǵ⣿</p>\r\n<p><strong>־</strong> Ӧ˵</p>\r\n<p><strong>ˣ </strong>ԺԴûˣôȥ</p>\r\n<p><strong>־</strong> ûУ֮ǰҵļ֧֡صķṩȶľԴЩǻù֧ǵ</p>\r\n<p><strong>ˣ </strong>ǹ˾жˣ</p>\r\n<p><strong>־</strong> 1617ˡ</p>\r\n<p><strong>ˣ </strong>гıǲһģ</p>\r\n<p><strong>־</strong> ֻǷǼԱҪôǼֵ֧ȵȡ</p>\r\n<p><strong>ˣ </strong>ǹ˾λǼ͵ģǷ͵ģ</p>\r\n<p><strong>־</strong> ԼǸ㼼ģұȽϳеǼ͹˾</p>\r\n<p><strong>ˣ </strong≯һ¹ڹ˾⡣ƽڹ˾ԱĽӦûôϵ</p>\r\n<p><strong>־</strong> 䲻⣬Ҷͬ־ͬ롣ڿʼƸʱ˿ÿɲڿʼƸʱѹǱȽϵһֱѰйͬ롢ͬ־뵽TeamУǲṩߵнͼ߾ĸṩһ룬ͬ룬벢Ŭʵִҹͬļֵ</p>\r\n<p>Ȼкܶͬµ䶼Ҵ󣬵ȻйͬԣΪĿΪֵ߳ģһʼҴ졢ɵģͬУҲǱ̬ұŴһȵȣȻ⣬ͬʵĿ꣬Թⲻ</p>\r\n<p><strong>ˣ </strong>Ĺ˾ԺԭҪĹڵĹת</p>\r\n<p><strong>־</strong> ڼĹļˣҪӣԭĴ룬ӸˣһǽѧѵÿܶµĳԱָͽ⣬ж˾ķչ򡢺ȵȷҲв뵽</p>\r\n<p><strong>ˣ </strong>Ҳ֪ϲʲôԱеϲԱģ</p>\r\n<p><strong>־</strong> Ҿ˺֮ĸоҪʵҶЩһһʵĸоºܳʱ䲻йͬĸȤĻ⣬۾ͻðͬĹ⵫Ƹʱ˲ࡣһԼļˣ룬鲻ͶʱļȾŬģ˲</p>\r\n<p>ΪСļҵ˾Ϊ׬ǮΪһݰȵĹ˲ʺŶӡ</p>\r\n<p><strong>ѣ</strong≯̸ҵʼ뷨ʲô</p>\r\n<p><strong>־</strong> һֱܼ򵥣ʼΪҹкܶãԺҾͳԺҿһݺõĹҲоѧһĳԡһĲƷ顢һļʵĶãͻкõĹᡣ</p>\r\n<p>ǰ֮ǰһѪжϵúܲģöԲǰΪʱ䡢͸顣ԼԺ󣬷ҵƷСŶӣϵ׳ܷһθлʹаá</p>\r\n<p>ĿǰҵСŶӱȽ϶࣬ʵҾǵĴҵĿĺܵܵһһʼΪҹ֮ΪһʹкθУٽΪʵԼļֵʵֲƷļֵʵŶӵļֵĿܶ</p>\r\n<p><strong>ˣ </strong>04ҵһѧתΪ˾ĹߵĹУԼѧʲô</p>\r\n<p><strong>־</strong> ѧ̫ණЩ㲻ȥʵ޷ᵽġѧõô˽Ρ˽Ḷ́Ҫġ</p>\r\n<p><strong>ˣ </strong>ڴҵĹоһЩѯһЩ⣬㲻Ķ</p>\r\n<p><strong>־</strong> ѯʵķʽ٣Ǿύ죬˵Ҳ߲֪Ķһϸһ¡ITȽϺãһѡΧһⷽ顣</p>\r\n<p>&nbsp;</p>\r\n','0');
INSERT INTO `qb_reply` VALUES ('527','','1240050670','549','32','1','1','ʾ,ֻҪĽ,ʵõ,Ҫ,ٷһһ.<br />\r\n<br />\r\nȻǿƵԶԶֹ,Щһһұչ.<br />\r\n<br />\r\n<p>&nbsp;</p>\r\n','0');
INSERT INTO `qb_reply` VALUES ('560','','1240128462','579','4','1','1','TechWeb417Ϣݹý屨ӱѩ(Activision-Blizzard) ħ硷йӪ̾ųǣħ硷ӪȨ׹˾ΪꡣΪ˾Ҫǻڲԭ&nbsp;&nbsp;&nbsp;<br />\r\n<br />\r\nѩֺ;ųĺͬ6·ݵڣѩ֤ʵ֮ǰĴţͬųԼħ硷ľӪȨųǾ֮֡Աѩֶԣײİ֮ǰǾ͡ħIIIǼIIսйµĺͬ2010졣<br />\r\n<br />\r\nһٴؽش˾ųǣھųǻáħ硷Ȩһ꣬һųǷıʾħڲӣ2·ݡħ硷ͬʱʷ߼¼<br />\r\n&nbsp;<br />\r\nWedbush MorganʦMichael PachterΪѩֹ˾֮ѡȡųҪǻڲԭں;ųǺڼ䣬ݹƱѩֹ˾Ի22%Ȩʹ÷ѣҲÿܻ50005500Ԫ롣ʦԤͬ׺ѩֹ˾ٿԻ55%ȨɷѣĻɴ1.4ԪһȽϣͿԿͬ׺ҪͬųǺÿ׬9000Ԫ<br />\r\n<br />\r\nͬʱӱѩ˾ıʾԤƸù˾һ볬ԤڣΪʹٻӢۡԼħ硷ǿ8.6ԪľĿʵ֡<br />\r\n','0');
INSERT INTO `qb_reply` VALUES ('561','','1240128514','580','4','1','1','»()418յ (߶Ӻݡܻ) ҵϢɹ18˵2009һй1620ˣﵽ3.16ˡ<p>ɹڴ˼еĲ̳2009ʾġ</p>\r\n<p>ɹ˵ڹʽΣʵ徭ôش£չͷȻƸԣģռ90%ϡIPv4ַԴѸ٣2008ﵽ1.8ڸﵽ1600йվﵽ287.8</p>\r\n<p>ɹʾڻҵϷռҪλݹƣ2008йгģԼΪ3Ԫͬ41.7%гģԼΪ120Ԫͬ55.8%;Ϸгģ190Ԫ200Ԫͬ50%ҡ</p>\r\n<p>⣬ɹܣ20093£й绰ûﵽ10.06ڻƶ绰ûﵽ6.7ڻڵ绰ûеıشﵽ66.1%</p>\r\n','0');
INSERT INTO `qb_reply` VALUES ('562','','1240128552','581','4','1','1','ѺITϢʱ417Ϣݹý屨ձ뵼ҵ֥˾͸¶ϸ(ֹ331)ȫ꾻3500Ԫ(Լ35Ԫ)Ǹù˾ʷľͬʱ֥ʾǰձԱ3900ͬԱ<p>Ϥĩ֥˾Ѿõ4500ʱԱ⣬ù˾ѾӳٻȡͶ¹ļƻ</p>\r\n<p>ǰ֥ƿ2800Ԫʵʳ֡ù˾ԭ򲿷ֹһ850Ԫĵ˰ƻ</p>\r\n<p>1£֥ƻּһڽԼ̶֧3000ԪзʦΪ֥ԽԼ֧ԤڹֹۡʦԶ֥ծʾǣŴѵ¡</p>\r\n<p>£֥˾Ĺ㷢һЩ仯ϯִй(Atsutoshi Nishida)6̨ȡ֮ǹ˾ʩľ(Norio Sasaki)</p>\r\n<p>65ϵCEO4꣬ڼ䣬Զ֥˴Χţ2006Ͷ37Ԫչݹ˾(Westinghouse)ɷԼǿԺԴҵĿơ⣬ͶʽоƬĲ</p>\r\n<p>2007֥꣬10ԪһṤΪPS32£֥ʾ͸ʿͨЭ飬׼Ӳҵ񣬲δչ۸һ¡ڽչ֮󣬶֥ΪıʼǱӲ̡</p>\r\n<p>Ӫʦʾϵչսȫ򾭼ΣӰ콫ûʵ֣½оƬ۸½Ϲɼµʹ֥ϽƻŴپ޴ѹ(¿±)</p>\r\n','0');
INSERT INTO `qb_reply` VALUES ('563','','1240128654','582','4','1','1','<div><span style=\"color:#525252;font-size:9pt;\">Ĺվڲ̳ˣѾϢ۸Ƚϵȡе</span><span style=\"color:#525252;font-size:9pt;\">C2C</span><span style=\"color:#525252;font-size:9pt;\">վϷӰһЩֻŻվŻᾭõķټֱӷʹվӣСѡŻվرǡ</span><span style=\"color:#525252;font-size:9pt;\">naver</span><span style=\"color:#525252;font-size:9pt;\">ͼΪЩվĿǰ</span><span style=\"color:#525252;font-size:9pt;\">Naver</span><span style=\"color:#525252;font-size:9pt;\">Ͷ˴Ĺ棬Ҫ֧ɽѣЩ֧ıǺܴġ</span></div>\r\n<div><span style=\"color:#525252;font-size:9pt;\"><br />\r\n</span><span style=\"color:#525252;font-size:9pt;\"></span><span style=\"color:#525252;font-size:9pt;\">Rankey.com</span><span style=\"color:#525252;font-size:9pt;\">ͺ</span><span style=\"color:#525252;font-size:9pt;\">Naver</span><span style=\"color:#525252;font-size:9pt;\"></span><span style=\"color:#525252;font-size:9pt;\">Gmarket</span><span style=\"color:#525252;font-size:9pt;\">ķÿѾ</span><span style=\"color:#525252;font-size:9pt;\">2006</span><span style=\"color:#525252;font-size:9pt;\"></span><span style=\"color:#525252;font-size:9pt;\">39%</span><span style=\"color:#525252;font-size:9pt;\">͵ȥ</span><span style=\"color:#525252;font-size:9pt;\">26%</span><span style=\"color:#525252;font-size:9pt;\">⣬ṹվҲͬŻվ</span><span style=\"color:#525252;font-size:9pt;\">2005</span><span style=\"color:#525252;font-size:9pt;\">깺վĹռش</span><span style=\"color:#525252;font-size:9pt;\">2005</span><span style=\"color:#525252;font-size:9pt;\"></span><span style=\"color:#525252;font-size:9pt;\">19%</span><span style=\"color:#525252;font-size:9pt;\">ȥ</span><span style=\"color:#525252;font-size:9pt;\">45%</span><span style=\"color:#525252;font-size:9pt;\"></span><span style=\"color:#525252;font-size:9pt;\"><br />\r\n<br />\r\n</span><span style=\"color:#525252;font-size:9pt;\">ҵʿʾ</span><span style=\"color:#525252;font-size:9pt;\">Gmarket</span><span style=\"color:#525252;font-size:9pt;\">ĹЧŻվԱΪ</span><span style=\"color:#525252;font-size:9pt;\">1570</span><span style=\"color:#525252;font-size:9pt;\">ÿƽ</span><span style=\"color:#525252;font-size:9pt;\">1810</span><span style=\"color:#525252;font-size:9pt;\">ˣԹ̲ѡ</span><span style=\"color:#525252;font-size:9pt;\"><br />\r\n<br />\r\n</span><span style=\"color:#525252;font-size:9pt;\">Ŀǰܶ๫˾ȿֺͨŻͷҲ˹վŻվչĽ̡</span><span style=\"color:#525252;font-size:9pt;\">Interpark</span><span style=\"color:#525252;font-size:9pt;\">ڿͨ</span><span style=\"color:#525252;font-size:9pt;\">Naver</span><span style=\"color:#525252;font-size:9pt;\">֪ʶƵļ۸ȽϷ</span><span style=\"color:#525252;font-size:9pt;\">e</span><span style=\"color:#525252;font-size:9pt;\">ͼۡ󣬺ܻӭվ</span><span style=\"color:#525252;font-size:9pt;\">15</span><span style=\"color:#525252;font-size:9pt;\">ƵڵʹʱȽϸߡ</span><span style=\"color:#525252;font-size:9pt;\">D&amp;shop</span><span style=\"color:#525252;font-size:9pt;\">Ҳͨ</span><span style=\"color:#525252;font-size:9pt;\">3</span><span style=\"color:#525252;font-size:9pt;\">ƷȽϡ񣬷ӦҲ</span></div>\r\n<div>&nbsp;</div>\r\n<div><span style=\"color:#525252;font-size:9pt;\">⹺վҲǿŻϢݡ</span><span style=\"color:#525252;font-size:9pt;\">Lotte.com</span><span style=\"color:#525252;font-size:9pt;\">еʱ־ġ</span><span style=\"color:#525252;font-size:9pt;\">Fashion &amp; The City</span><span style=\"color:#525252;font-size:9pt;\">ÿҲ</span><span style=\"color:#525252;font-size:9pt;\">200</span><span style=\"color:#525252;font-size:9pt;\">ϣ</span><span style=\"color:#525252;font-size:9pt;\">istyle24</span><span style=\"color:#525252;font-size:9pt;\"></span><span style=\"color:#525252;font-size:9pt;\">2006</span><span style=\"color:#525252;font-size:9pt;\">꿪ͨʱ־ƵԺѾӵ</span><span style=\"color:#525252;font-size:9pt;\">3000</span><span style=\"color:#525252;font-size:9pt;\">ʱоݣ</span><span style=\"color:#525252;font-size:9pt;\">Hmall</span><span style=\"color:#525252;font-size:9pt;\">־</span><span style=\"color:#525252;font-size:9pt;\">HMall</span><span style=\"color:#525252;font-size:9pt;\">־ҲĶ</span><span style=\"color:#525252;font-size:9pt;\"><br />\r\n<br />\r\n</span></div>\r\n<div><p><span style=\"color:#525252;font-size:9pt;\">Gmarket</span><span style=\"color:#525252;font-size:9pt;\">ҵ˵Ϣṩ۸ȽϡЩŻվķؿ˹վķΧͨ컯ûȣôվŻվӰ߳</span><span style=\"color:#525252;font-size:9pt;\"><br />\r\n</span></p>\r\n</div>\r\n','0');
INSERT INTO `qb_reply` VALUES ('564','','1240128744','583','4','1','1','<p><img onload=\"if(this.width&gt;600)makesmallpic(this,600,1800);\" src=\"http://www_qibosoft_com/Tmp_updir/article/4/1_20090419160422_PjOh8.jpg\" width=\"583\" height=\"370\" border=\"0\" alt=\"23.jpg\" title=\"23.jpg\" /></p><p>Ҹ˶ԻƷ¼PM⣬ͼＸݣ</p><p>1ɫͷָPMڹҪӴĶ<br />2ɫͷPMΪģָΧĸţ˵ڹͨЭаĽɫ<br />3ɫͷҵУPMЩת<br />4ͼ˵״ͷұۡ˫šࡣ</p><p>ͼֻ˵дԣձԣΪҵͬ֯ͬģʽͬPMڹв졣ֻϣͼʹһPMְҵе㡢֧㡢㡣</p><p><strong>һƷ</strong></p><p>ͼɫߣֱָPM˵Ż˵๤ܷչΪPMǷֱǸƷӪĲšƷӪĲšƷʵֵĲš</p><p>ƷӪĲźгӴ࣬гҲ𽥵ĸ˽⣬һƷгֻҪܰгòƷʵֵĲżʵʩѾPMˡгתPMԺͨǿǿӦǿϾڹɽ׶ΣҪѧϰķǲƷĹ;ӪƲƷܲƷԭͣƷ߼ȵȡ</p><p>ƷӪĲſ˵ŷḻҵԴӵBDPRͷȵȹ֡˽ҵͬƷʷ״ССĸĶ֪Ϸҵʢһ͵ϷӪ̣ҲǸҪԼϷֻҪѱõϷƷУһǾҪԼһϷʱͿԺܿʵʩΪӪƷͬʱ˴ĲƷг顣µĹҲǺתΪPMġ</p><p>ƷʵֵĲţPMĻҾУ˵80%PMǴ߳ġ˽ƷĹܡʹ߼ݽṹϢṹȵȡŲƷġΡټںö๫˾𿪷ĿƷdemoĲƷƶΪPM</p><p>һ󣬾ǺöҵϰCEOڼPMְ顣</p><p>λ٣ҵεĹǷϼ֮أǣôPMչŶ</p><p><strong>Ʒ֧</strong></p><p>PMչھѾĽPMɫôҪ߱Щ֧֧PMְλķչأ</p><p>1ƤҪ</p><p>¿ʼǸͼֵǣɫͷPMΪģָͬĲš˵ڹͨЭаĽɫ</p><p>λʿ׷Ůɣǰ᲻ƤôԼ֮ǰҪǱܾ˸öඪԼԷ᲻öԷǶԷǲǸͲԼԼԼˣ</p><p>PMڹҲһкܶƻ飬ҳ桢ӭгҪʱרȵȡκ鶼ڸŵļƻ֮ڣôڱ˵֮飬PMʵʩأ쵼Э¶ҪPMʲôǾƤ㣬һЩиĶûʲôЭ˵ġСǾ鷳ˡ</p><p>⣬PMڲƷӪУܶʱԵĹͨұ֤ÿιͨPMܹ⣬ܹסҪPMʶ˽⣬PM̬ߣôܿΪӶ⡣</p><p>֧˵PMӦþ߱ļܣƪ˵úȫ棬ͨȨ쵼ѧϰҵжȡȰƷעϸڡճƷȵȣƼҿ<a href=\"http://hi.baidu.com/myey8/blog/item/a24a87640d2514f8f636547d.html\" target=\"_blank\"><span style=\"color:#0033cc;\">ƷӦ߱</span></a></p><p>ΪһɹPM˾߱Щ֮⣬һ֧㣬Ǿ̬1-5Ƕһ˵5-10ľڶ̬Ժרźʹۡ</p><p><strong>Ʒ</strong></p><p>PMʱıְλԣ˵PMѾһݹһʽȻҲʱ䳤˻֡ƣ͡⣬Ҳ룬PMá﷢չһֱȥ</p><p>ȣPMһҵΪӴ㣬ҪѧϰĶҲҪ࣬ҪΪרţҲǸͨšPMǸϻ۵ְҵʹһʧȥְλô۵Ķòߵġ</p><p>Σ˵PMʵƷCEOôPM֮ԼҵٿԱȽϿĽ״̬һЩ·</p><p>PMȻǺͲƷһģôƷгӦҲǺPMйϵģƷҵĺûҲҪΪPM˵һ֣ƷúãPMõнˮ࣬ûдﵽгԤھͿPMнˮôPMʵǸнְλ</p><p>ģۻҵǴͳҵPMͨģҵѡ</p><p>ȵȵȵ???</p>','0');
INSERT INTO `qb_reply` VALUES ('646','','0','665','3','1','1','ַ<a href=\"http://www.qibosoft.com\">www.qibosoft.com</a>','0');
INSERT INTO `qb_reply` VALUES ('574','','1240129686','593','3','1','1','<div>һ·,лһ֧! <br />ͬʱ,ҲܹýĹע: <br />ýر: <br /><br /><img onload=\"if(this.width&gt;600)makesmallpic(this,600,1800);\" src=\"http://i3.sinaimg.cn/home/deco/2009/0330/con_logo_tech_news.gif\" width=\"110\" height=\"27\" border=\"0\" /><a href=\"http://tech.sina.com.cn/i/2010-12-02/17214935910.shtml\" target=\"_blank\"><span style=\"color:#0070af;\">http://tech.sina.com.cn/i/2010-12-02/17214935910.shtml</span></a> <br /><br /><img onload=\"if(this.width&gt;600)makesmallpic(this,600,1800);\" src=\"http://cn.yimg.com/ycn/head/img/yahoologocontent.gif\" width=\"118\" height=\"32\" border=\"0\" /><a href=\"http://tech.cn.yahoo.com/yxk/20101202/4yh9.html\" target=\"_blank\"><span style=\"color:#0070af;\">http://tech.cn.yahoo.com/yxk/20101202/4yh9.html</span></a> <br /><br /><img onload=\"if(this.width&gt;600)makesmallpic(this,600,1800);\" src=\"http://bbs.qibosoft.com/images/ifeng_logo2.gif\" width=\"118\" height=\"45\" border=\"0\" /><a href=\"http://tech.ifeng.com/internet/detail_2010_12/01/3295860_0.shtml\" target=\"_blank\"><span style=\"color:#0070af;\">http://tech.ifeng.com/internet/detail_2010_12/01/3295860_0.shtml</span></a> <br /><img onload=\"if(this.width&gt;600)makesmallpic(this,600,1800);\" src=\"http://www.techweb.com.cn/img/images/logo_s.gif\" width=\"77\" height=\"28\" border=\"0\" /> <br /><a href=\"http://www.techweb.com.cn/internet/2010-12-02/723633.shtml\" target=\"_blank\"><span style=\"color:#0070af;\">http://www.techweb.com.cn/internet/2010-12-02/723633.shtml</span></a> <br /><a href=\"http://www.techweb.com.cn/news/2010-12-01/723350.shtml\" target=\"_blank\"><span style=\"color:#0070af;\">http://www.techweb.com.cn/news/2010-12-01/723350.shtml</span></a> <br /><br /><img onload=\"if(this.width&gt;600)makesmallpic(this,600,1800);\" src=\"http://www.admin5.com/images/2008a/logodongtian.gif\" width=\"122\" height=\"60\" border=\"0\" /><a href=\"http://www.admin5.com/plus/view.php?aid=291514\" target=\"_blank\"><span style=\"color:#0070af;\">http://www.admin5.com/plus/view.php?aid=291514</span></a> <br /><img onload=\"if(this.width&gt;600)makesmallpic(this,600,1800);\" src=\"http://www.chinaz.com/images/logo.gif\" width=\"165\" height=\"60\" border=\"0\" /><a href=\"http://www.chinaz.com/Webmaster/report/12011464202010.html\" target=\"_blank\"><span style=\"color:#0070af;\">http://www.chinaz.com/Webmaster/report/12011464202010.html</span></a> <br /><img onload=\"if(this.width&gt;600)makesmallpic(this,600,1800);\" src=\"http://www.cncms.com/templates/cncms/skins/default/images/logo.jpg\" width=\"157\" height=\"51\" border=\"0\" /><a href=\"http://news.cncms.com/2010/1202/4504.html\" target=\"_blank\"><span style=\"color:#0070af;\">http://news.cncms.com/2010/1202/4504.html</span></a> <br /><img onload=\"if(this.width&gt;600)makesmallpic(this,600,1800);\" src=\"http://bbs.qibosoft.com/images/mop.jpg\" width=\"102\" height=\"43\" border=\"0\" /><a href=\"http://tech.mop.com/net/2010/1202/1735542633.shtml\" target=\"_blank\"><span style=\"color:#0070af;\">http://tech.mop.com/net/2010/1202/1735542633.shtml</span></a> <br /><br /><img onload=\"if(this.width&gt;600)makesmallpic(this,600,1800);\" src=\"http://sudu.cn/images/head/newlogo.gif\" width=\"175\" height=\"60\" border=\"0\" /><a href=\"http://sudu.cn/service/detail.php?id=11689\" target=\"_blank\"><span style=\"color:#0070af;\">http://sudu.cn/service/detail.php?id=11689</span></a> <br /><img onload=\"if(this.width&gt;600)makesmallpic(this,600,1800);\" src=\"http://www.eastadmin.com/templets/index_img/logo.gif\" width=\"200\" height=\"45\" border=\"0\" /><a href=\"http://www.eastadmin.com/plus/view.php?aid=4277\" target=\"_blank\"><span style=\"color:#0070af;\">http://www.eastadmin.com/plus/view.php?aid=4277</span></a> <br /><img onload=\"if(this.width&gt;600)makesmallpic(this,600,1800);\" src=\"http://www.phpchina.com/templates/phpchina/images/logo.gif\" width=\"188\" height=\"45\" border=\"0\" /><a href=\"http://www.phpchina.com/index.php?action-viewnews-itemid-37657-php-1\" target=\"_blank\"><span style=\"color:#0070af;\">http://www.phpchina.com/index.php?action-viewnews-itemid-37657-php-1</span></a> <br /><br /><img onload=\"if(this.width&gt;600)makesmallpic(this,600,1800);\" src=\"http://www.im286.cn/templets/im2862/images/logo.png\" width=\"162\" height=\"44\" border=\"0\" /><a href=\"http://www.im286.cn/plus/view.php?aid=26387\" target=\"_blank\"><span style=\"color:#0070af;\">http://www.im286.cn/plus/view.php?aid=26387</span></a> <br /><img onload=\"if(this.width&gt;600)makesmallpic(this,600,1800);\" src=\"http://news.cnzz.cn/Skin/new_cn/Images/logo.jpg\" width=\"140\" height=\"70\" border=\"0\" /><a href=\"http://news.cnzz.cn/NewsInfo/22214.aspx\" target=\"_blank\"><span style=\"color:#0070af;\">http://news.cnzz.cn/NewsInfo/22214.aspx</span></a> <br /><img onload=\"if(this.width&gt;600)makesmallpic(this,600,1800);\" src=\"http://www.donews.com//images/indx_tmp/bg_04.gif\" width=\"178\" height=\"73\" border=\"0\" /><a href=\"http://www.donews.com/net/201011/284543.shtm\" target=\"_blank\"><span style=\"color:#0070af;\">http://www.donews.com/net/201011/284543.shtm</span></a> <br /><img onload=\"if(this.width&gt;600)makesmallpic(this,600,1800);\" src=\"http://soft.yesky.com/TLimages2009/yesky/images/logo/c_newlogo.gif\" width=\"91\" height=\"36\" border=\"0\" /><a href=\"http://soft.yesky.com/news/22/11672522.shtml\" target=\"_blank\"><span style=\"color:#0070af;\">http://soft.yesky.com/news/22/11672522.shtml</span></a> <br /><br /><img onload=\"if(this.width&gt;600)makesmallpic(this,600,1800);\" src=\"http://www.cnii.com.cn/iframe/tplimg/53.files/images/logo.gif\" width=\"150\" height=\"70\" border=\"0\" /><a href=\"http://www.cnii.com.cn/internet/content/2010-12/03/content_816067.htm\" target=\"_blank\"><span style=\"color:#0070af;\">http://www.cnii.com.cn/internet/content/2010-12/03/content_816067.htm</span></a> <br /><br /><br /><img onload=\"if(this.width&gt;600)makesmallpic(this,600,1800);\" src=\"http://tech.ddvip.com/2010/images/logo.gif\" width=\"191\" height=\"60\" border=\"0\" /><a href=\"http://tech.ddvip.com/2010-12/1291174067163689.html\" target=\"_blank\"><span style=\"color:#0070af;\">http://tech.ddvip.com/2010-12/1291174067163689.html</span></a> <br /><br /><img onload=\"if(this.width&gt;600)makesmallpic(this,600,1800);\" src=\"http://www.gdwest.com/images/west/logo.png\" width=\"163\" height=\"52\" border=\"0\" /><a href=\"http://www.gdwest.com/news/96/12620.htm\" target=\"_blank\"><span style=\"color:#0070af;\">http://www.gdwest.com/news/96/12620.htm</span></a> <br /><br /><img onload=\"if(this.width&gt;600)makesmallpic(this,600,1800);\" src=\"http://www.itbear.com.cn/images/show_logo.gif\" width=\"127\" height=\"24\" border=\"0\" /><a href=\"http://www.itbear.com.cn/ZiXun/2010-11/29998.html\" target=\"_blank\"><span style=\"color:#0070af;\">http://www.itbear.com.cn/ZiXun/2010-11/29998.html</span></a> <br /><img onload=\"if(this.width&gt;600)makesmallpic(this,600,1800);\" src=\"http://bbs.flashget.com/images/Zentendo_03/logo.gif\" width=\"330\" height=\"120\" border=\"0\" /><a href=\"http://bbs.flashget.com/viewthread.php?tid=32508&amp;extra=page%3D1\" target=\"_blank\"><span style=\"color:#0070af;\">http://bbs.flashget.com/viewthread.php?tid=32508&amp;extra=page%3D1</span></a> <br /><img onload=\"if(this.width&gt;600)makesmallpic(this,600,1800);\" src=\"http://www.php100.com/templets/images/logo.png\" width=\"139\" height=\"69\" border=\"0\" /><a href=\"http://www.php100.com/html/phpnews/PHPxinwen/2010/1121/6867.html\" target=\"_blank\"><span style=\"color:#0070af;\">http://www.php100.com/html/phpnews/PHPxinwen/2010/1121/6867.html</span></a> <br /><br /><img onload=\"if(this.width&gt;600)makesmallpic(this,600,1800);\" src=\"http://www.qibosoft.com/upload_files_p888/friendlink/40001_20100228160200_idba9.gif\" width=\"88\" height=\"31\" border=\"0\" /><a href=\"http://www.chinaccnet.com/content.php?module=content_newsdetail&amp;news_id=29\" target=\"_blank\"><span style=\"color:#0070af;\">http://www.chinaccnet.com/content.php?module=content_newsdetail&amp;news_id=29</span></a> <br /><br /><img onload=\"if(this.width&gt;600)makesmallpic(this,600,1800);\" src=\"http://www.west263.com/info/templets/images/Default_11.gif\" width=\"156\" height=\"47\" border=\"0\" /><a href=\"http://www.west263.com/info/html/xingyezixun/yejiedongtai/20101122/1930518.html\" target=\"_blank\"><span style=\"color:#0070af;\">http://www.west263.com/info/html/xingyezixun/yejiedongtai/20101122/1930518.html</span></a> <br /><img onload=\"if(this.width&gt;600)makesmallpic(this,600,1800);\" src=\"http://www.ndiis.com/new/logo.gif\" width=\"220\" height=\"80\" border=\"0\" /><a href=\"http://www.ndiis.com/news/nws_dtl.asp?nid=10000026\" target=\"_blank\"><span style=\"color:#0070af;\">http://www.ndiis.com/news/nws_dtl.asp?nid=10000026</span></a> <br /><img onload=\"if(this.width&gt;600)makesmallpic(this,600,1800);\" src=\"http://www.ifengwo.com/images/logo.gif\" width=\"207\" height=\"70\" border=\"0\" /><a href=\"http://www.ifengwo.com/zuozhewenzhang/201011/20-182606.html\" target=\"_blank\"><span style=\"color:#0070af;\">http://www.ifengwo.com/zuozhewenzhang/201011/20-182606.html</span></a> <br /><img onload=\"if(this.width&gt;600)makesmallpic(this,600,1800);\" src=\"http://www.jz123.cn/image/logo.png\" width=\"210\" height=\"60\" border=\"0\" /><a href=\"http://www.jz123.cn/plus/view.php?aid=35318\" target=\"_blank\"><span style=\"color:#0070af;\">http://www.jz123.cn/plus/view.php?aid=35318</span></a> <br /><img onload=\"if(this.width&gt;600)makesmallpic(this,600,1800);\" src=\"http://www.bbscode.com/templets/index_img/logo.gif\" width=\"180\" height=\"60\" border=\"0\" /><a href=\"http://www.bbscode.com/text/news/2010/1123/59092.html\" target=\"_blank\"><span style=\"color:#0070af;\">http://www.bbscode.com/text/news/2010/1123/59092.html</span></a> <br /><img onload=\"if(this.width&gt;600)makesmallpic(this,600,1800);\" src=\"http://www.pd.sd.cn/tp/image/logo.gif\" width=\"180\" height=\"60\" border=\"0\" /><a href=\"http://www.pd.sd.cn/html/2010/11/22093130206.htm\" target=\"_blank\"><span style=\"color:#0070af;\">http://www.pd.sd.cn/html/2010/11/22093130206.htm</span></a> <br /><br /><img onload=\"if(this.width&gt;600)makesmallpic(this,600,1800);\" src=\"http://www.txwb.com/Skin/txwb/logo.gif\" width=\"219\" height=\"60\" border=\"0\" /><a href=\"http://www.txwb.com/Article/hyzx/wlzz/201011/85119.html\" target=\"_blank\"><span style=\"color:#0070af;\">http://www.txwb.com/Article/hyzx/wlzz/201011/85119.html</span></a> <br /><br /><img onload=\"if(this.width&gt;600)makesmallpic(this,600,1800);\" src=\"http://www.cn37.cn/cn37/cn37_logo.gif\" width=\"168\" height=\"60\" border=\"0\" /><a href=\"http://www.cn37.cn/article/2714.html\" target=\"_blank\"><span style=\"color:#0070af;\">http://www.cn37.cn/article/2714.html</span></a> <br /><a href=\"http://news.ename.cn/yuming_xinwen_2010_12_01_25820.html\" target=\"_blank\"><span style=\"color:#0070af;\">http://news.ename.cn/yuming_xinwen_2010_12_01_25820.html</span></a> <br /><br /><a href=\"http://news.syd.com.cn/content/2010-12/02/content_25176700.htm\" target=\"_blank\"><span style=\"color:#0070af;\">http://news.syd.com.cn/content/2010-12/02/content_25176700.htm</span></a> <br /><br /><a href=\"http://www.jiaonan.com/html/2010/11/22093115441.htm\" target=\"_blank\"><span style=\"color:#0070af;\">http://www.jiaonan.com/html/2010/11/22093115441.htm</span></a> <br /><br /><a href=\"http://www.gdwest.com/news/96/12620.htm\" target=\"_blank\"><span style=\"color:#0070af;\">http://www.gdwest.com/news/96/12620.htm</span></a> <br /><br /><br /><a href=\"http://edu.codepub.com/2010/1123/27371.php\" target=\"_blank\"><span style=\"color:#0070af;\">http://edu.codepub.com/2010/1123/27371.php</span></a> <br /><a href=\"http://www.xinfengit.com/201011/23115011.html\" target=\"_blank\"><span style=\"color:#0070af;\">http://www.xinfengit.com/201011/23115011.html</span></a> <br /><a href=\"http://236z.com/plus/view.php?aid=127792\" target=\"_blank\"><span style=\"color:#0070af;\">http://236z.com/plus/view.php?aid=127792</span></a> &nbsp; <br /><a href=\"http://www.qq050.com/article.asp?id=3772\" target=\"_blank\"><span style=\"color:#0070af;\">http://www.qq050.com/article.asp?id=3772</span></a> <br /><a href=\"http://www.webjx.com/news/focus-27784.html\" target=\"_blank\"><span style=\"color:#0070af;\">http://www.webjx.com/news/focus-27784.html</span></a> <br /><a href=\"http://www.55175.cn/Comments.asp?ArticleID=4733\" target=\"_blank\"><span style=\"color:#0070af;\">http://www.55175.cn/Comments.asp?ArticleID=4733</span></a> <br /><a href=\"http://www.zz360.net/plus/view-3492-1.html\" target=\"_blank\"><span style=\"color:#0070af;\">http://www.zz360.net/plus/view-3492-1.html</span></a> <br /><a href=\"http://www.ok.net.cn/html/24/n-21324.html\" target=\"_blank\"><span style=\"color:#0070af;\">http://www.ok.net.cn/html/24/n-21324.html</span></a> <br /><a href=\"http://www.91papa.com/html/56-3/3033.htm\" target=\"_blank\"><span style=\"color:#0070af;\">http://www.91papa.com/html/56-3/3033.htm</span></a> <br /><a href=\"http://www.jzc8.com/article/1972/96929_1.html\" target=\"_blank\"><span style=\"color:#0070af;\">http://www.jzc8.com/article/1972/96929_1.html</span></a> <br /><a href=\"http://www.idczhuji.com/idczhuji/news/zhujinews/2010/1125/8183.html\" target=\"_blank\"><span style=\"color:#0070af;\">http://www.idczhuji.com/idczhuji/news/zhujinews/2010/1125/8183.html</span></a> <br /><a href=\"http://www.news365.com.cn/gdxww/170900.htm\" target=\"_blank\"><span style=\"color:#0070af;\">http://www.news365.com.cn/gdxww/170900.htm</span></a> <br /><a href=\"http://www.qq050.com/article.asp?id=3772\" target=\"_blank\"><span style=\"color:#0070af;\">http://www.qq050.com/article.asp?id=3772</span></a> <br /><a href=\"http://www.zz360.net/plus/view-3492-1.html\" target=\"_blank\"><span style=\"color:#0070af;\">http://www.zz360.net/plus/view-3492-1.html</span></a> <br /><a href=\"http://www.cn37.cn/article/2714.html\" target=\"_blank\"><span style=\"color:#0070af;\">http://www.cn37.cn/article/2714.html</span></a> <br /><a href=\"http://www.txwb.com/Article/hyzx/wlzz/201011/85119.html\" target=\"_blank\"><span style=\"color:#0070af;\">http://www.txwb.com/Article/hyzx/wlzz/201011/85119.html</span></a> <br /><a href=\"http://www.ok.net.cn/html/24/n-21324.html\" target=\"_blank\"><span style=\"color:#0070af;\">http://www.ok.net.cn/html/24/n-21324.html</span></a> <br /><a href=\"http://www.zunmi.com/news/201012/15350.html\" target=\"_blank\"><span style=\"color:#0070af;\">http://www.zunmi.com/news/201012/15350.html</span></a> <br /><a href=\"http://www.hackbase.com/news/2010-12-03/39856.html\" target=\"_blank\"><span style=\"color:#0070af;\">http://www.hackbase.com/news/2010-12-03/39856.html</span></a> <br /><a href=\"http://www.china-code.net/al-ccmmVYSLlN-374521.html\" target=\"_blank\"><span style=\"color:#0070af;\">http://www.china-code.net/al-ccmmVYSLlN-374521.html</span></a> <br /><a href=\"http://www.sootoo.com/content/71993.shtml\" target=\"_blank\"><span style=\"color:#0070af;\">http://www.sootoo.com/content/71993.shtml</span></a> <br /><a href=\"http://www.5b.com.cn/hulianwangxun/2010/12/01/5b129117823411188.shtml\" target=\"_blank\"><span style=\"color:#0070af;\">http://www.5b.com.cn/hulianwangxun/2010/12/01/5b129117823411188.shtml</span></a> <br /><a href=\"http://www.jzc8.com/article/1972/96929_1.html\" target=\"_blank\"><span style=\"color:#0070af;\">http://www.jzc8.com/article/1972/96929_1.html</span></a> <br /><a href=\"http://www.bbscode.com/text/news/2010/1123/59092.html\" target=\"_blank\"><span style=\"color:#0070af;\">http://www.bbscode.com/text/news/2010/1123/59092.html</span></a> <br /><a href=\"http://www.phoer.net/?action-viewnews-itemid-199237\" target=\"_blank\"><span style=\"color:#0070af;\">http://www.phoer.net/?action-viewnews-itemid-199237</span></a> <br /><a href=\"http://news.xilele.com/keji/266664.htm\" target=\"_blank\"><span style=\"color:#0070af;\">http://news.xilele.com/keji/266664.htm</span></a> <br /><a href=\"http://news.xinmin.cn/rollnews/2010/12/02/8075967.html\" target=\"_blank\"><span style=\"color:#0070af;\">http://news.xinmin.cn/rollnews/2010/12/02/8075967.html</span></a> <br /><a href=\"http://flash.longonline.net/article/240/sort02047/2010/20101125133367.asp\" target=\"_blank\"><span style=\"color:#0070af;\">http://flash.longonline.net/article/240/sort02047/2010/20101125133367.asp</span></a> <br /><a href=\"http://www.zhanzhang.com/news/trend/20101204/29250.html\" target=\"_blank\"><span style=\"color:#0070af;\">http://www.zhanzhang.com/news/trend/20101204/29250.html</span></a> <br /><a href=\"http://www.pd.sd.cn/html/2010/11/22093130206.htm\" target=\"_blank\"><span style=\"color:#0070af;\">http://www.pd.sd.cn/html/2010/11/22093130206.htm</span></a> <br /><a href=\"http://www.5b.com.cn/hulianwangxun/2010/12/01/5b129117823411188.shtml\" target=\"_blank\"><span style=\"color:#0070af;\">http://www.5b.com.cn/hulianwangxun/2010/12/01/5b129117823411188.shtml</span></a></div>','0');
INSERT INTO `qb_reply` VALUES ('575','','1240129723','594','34','1','1','Ϊο,ʵֿں̨ɸƳͬģ,ܾǰ¿װһ. <br />\r\n<br />\r\n,ٷĬṩĿϵͳ,ж;,ȫһ,һĿ,һƽʱϰ,һѧ,һСѧ,㲻һ.ôں̨һ,Ϳ, <br />\r\n<br />\r\nƺ,ԶԷиԻ޸,Ļ,Խиһ޸. <br />\r\n<br />\r\nȻµĹܾ͸,ŮƵ,ƼƵ,Ҫ,һ. <br />\r\n<br />\r\nЩ,ֻں̨һͿʵ. <br />\r\n<br />\r\nҪҲݿ,޸κγ.û,ֵĻ,һĶο,Կʹ.ⵥ.ȵ. <br />\r\n<br />\r\n<br />\r\n벩Ҫ׷,ʵ <br />\r\n','0');
INSERT INTO `qb_reply` VALUES ('576','','1240129752','595','34','1','1','ʱִ,һҳ̬,<br />\r\n<br />\r\nÿĳʱִһ.<br />\r\n<br />\r\n<br />\r\nδĳʱִһ<br />\r\n<br />\r\n,һ,ִһ,ڶ,ÿĳʱִһ,,δĳʱ,ִֻһ.<br />\r\n<br />\r\n<br />\r\n<br />\r\nʱݿĹҲʵ,<br />\r\n,ҿÿʲôʱԶݿ.Ƽ賿,ʱ,ѹС,Ӱ첻.<br />\r\n<br />\r\n,ÿԶһ,ҾͲվֲϵĺ,رǶû˵,ǵñݿ.<br />\r\n','0');
INSERT INTO `qb_reply` VALUES ('579','','1240129958','598','34','1','1','ҵĿ֮˸, ckeditor༭.<br />\r\n','0');
INSERT INTO `qb_reply` VALUES ('580','','1240130011','599','3','1','1','<div>벩CMS֮V7棬ҽҿɴ汾˵ųǰ̱ãڹϣڱV6йܵĻϣ൱ʵùģһЩɫܡҲͬ <br />\r\nڷ棬ÿ˵۲һȻ󲿷˺Ͽɵǰķ񣬵Ҳв˲̫Ͽɵǰķ <br />\r\nˣ£ǶһŸжģΪлһǵ֧֡Ǿܵ跨ȥҵ <br />\r\nΪ˹ٷʽٰ״ģϣͨδԳྫģ壬 <br />\r\n<br />\r\nƷ£ <br />\r\nһȽ1000Ԫֽ + CMSվطŻB2Bϵͳϵͳѡһ+ͭ1000 <br />\r\nȽ500Ԫֽ + CMSվطŻB2Bϵͳϵͳѡһ+ͭ500 <br />\r\nȵȣ300Ԫֽ + CMSվطŻB2Bϵͳϵͳѡһ+ͭ300 <br />\r\n100Ԫֽ + CMSվطŻB2Bϵͳϵͳѡһ+ͭ100 <br />\r\n<br />\r\nǻûǽṩһչʾƽ̨Ҳǻ¿һ֤ôҪģҵ㡣 <br />\r\n<br />\r\n<br />\r\nֹڴӲƷ <br />\r\n<br />\r\nѡʽɹٷѡΪͶƱΪ <br />\r\n<br />\r\nֻҪṩҳPSͼģ˲鲻ǵˣȥģǰõV7԰棬ڱԵԷʹá <br />\r\n<br />\r\nע:V6Ļһ <br />\r\n<br />\r\n⣬ӭҼV7שǷǹܷ棬ֻǲŻƺóôҾV7档</div>\r\n','0');
INSERT INTO `qb_reply` VALUES ('582','','1240193993','601','14','1','1','&nbsp;&nbsp; »½̩壬ڼеġ<br />\r\n<div>&nbsp;</div>\r\n梡һܵܺһáڳڴ塣»ڻƴСѧҵѧʱĲμУѧУıݣĻ硣<br />\r\n<div>&nbsp;</div>\r\nйϷ緽֪ʶʦĄ̊́Ź<br />\r\n<div>&nbsp;</div>\r\nѧں󣬵۵ӹ㲥޹˾(TVB)Աѵѵ1981ڵӾ硶ͧСӢۡ״ࡣ','0');
INSERT INTO `qb_reply` VALUES ('584','','1240201330','603','39','1','1','벩V7¾̬,ڽ,ȡ÷Ծͻ,ʱȫվ̬+˼ؾ̬<br />\r\nʱȫվָ̬,Կʱ,ÿ賿˷,ѹСʱ,Զȫվ̬һ,Է㲹ȫһЩ©ľ̬ҳ.<br />\r\n<br />\r\n<br />\r\n˼ؾָ̬,һȫվ̬,ɹرҳ,ں̨ĵ.Ҫ㿪,ĵȴСʱ,ƪ,һֱΪֹ.ʱ,ٱ,.ֵΪˢһ¼һ<br />\r\n<br />\r\nҲڶCMSһֱڵ,صŴҲþ̬.<br />\r\n<br />\r\n,벩CMSѾһֱΪŴҵ.<br />\r\n<br />\r\nҲѽ,бҳϰҳ,Ҫȴþòת꾲̬.','0');
INSERT INTO `qb_reply` VALUES ('585','','1240209505','604','39','1','1','ӭҶڵV7棬йϲĽ飬ϸòλǺ治ͬ <br />\r\n<br />\r\nֻдڰָǲſԸƺϵͳôյʹá <br />\r\n<br />\r\n֮˵˲̫ĳޣͻɱԼ˫ۣڡͻᵼòϵͳòõƣҲӰ쵽ڽʹá','0');
INSERT INTO `qb_reply` VALUES ('586','','0','605','10','1','1','<p>û</p>','0');
INSERT INTO `qb_reply` VALUES ('587','','0','606','10','1','1','<p></p>','0');
INSERT INTO `qb_reply` VALUES ('588','','0','607','10','1','1','<p></p>','0');
INSERT INTO `qb_reply` VALUES ('589','','0','608','10','1','1','<p></p>','0');
INSERT INTO `qb_reply` VALUES ('590','','0','609','10','1','1','<p></p>','0');
INSERT INTO `qb_reply` VALUES ('591','','0','610','10','1','1','<p></p>','0');
INSERT INTO `qb_reply` VALUES ('592','','0','611','10','1','1','','0');
INSERT INTO `qb_reply` VALUES ('593','','0','612','10','1','1','<p></p>','0');
INSERT INTO `qb_reply` VALUES ('594','','0','613','10','1','1','<p></p>','0');
INSERT INTO `qb_reply` VALUES ('595','','0','614','10','1','1','<p></p>','0');
INSERT INTO `qb_reply` VALUES ('596','','0','615','10','1','1','<p></p>','0');
INSERT INTO `qb_reply` VALUES ('597','','0','616','10','1','1','<p></p>','0');
INSERT INTO `qb_reply` VALUES ('598','','0','617','10','1','1','<p></p>','0');
INSERT INTO `qb_reply` VALUES ('599','','0','618','10','1','1','<p></p>','0');
INSERT INTO `qb_reply` VALUES ('600','','0','619','14','1','1','<p>: ΰǿ</p>\r\n<p>: ӵ俻Ʋ˼ľ</p>\r\n<p>Ƭ/: й</p>\r\n<p>: </p>\r\n<p>: </p>\r\n<p>Ƭ: 110</p>\r\n<p>汾: DVD</p>\r\n<p>ṩ: </p>\r\n<p>ӳ: 2010-09-21 й<br />\r\n</p>\r\n','0');
INSERT INTO `qb_reply` VALUES ('601','','0','620','14','1','1','<p>: ı</p>\r\n<p>: ܶ²ѩƼﺣӢ̩</p>\r\n<p>Ƭ/: йڵ</p>\r\n<p>: 鰮</p>\r\n<p>: </p>\r\n<p>Ƭ: 115</p>\r\n<p>汾: </p>\r\n<p>ṩ: Ѹ</p>\r\n<p>ӳ: 2010-09-15 й<br />\r\n</p>\r\n','0');
INSERT INTO `qb_reply` VALUES ('602','','0','621','14','1','1','<p>: </p>\r\n<p>: Ρٻʷ</p>\r\n<p>Ƭ/: йڵ</p>\r\n<p>: װ</p>\r\n<p>: </p>\r\n<p>Ƭ: 45</p>\r\n<p>汾: 43ȫ</p>\r\n<p>ṩ: </p>\r\n<p>ӳ: 2010 <br />\r\n</p>\r\n','0');
INSERT INTO `qb_reply` VALUES ('603','','0','622','14','1','1','<p>: |</p>\r\n<p>: żºƽ÷</p>\r\n<p>Ƭ/: йڵ</p>\r\n<p>: </p>\r\n<p>: </p>\r\n<p>Ƭ: 45</p>\r\n<p>汾: 33ȫ</p>\r\n<p>ṩ: </p>\r\n<p>ӳ: 2008 <br />\r\n</p>\r\n','0');
INSERT INTO `qb_reply` VALUES ('604','','0','623','14','1','1','<p>: </p>\r\n<p>: ־ӱƷС֣</p>\r\n<p>Ƭ/: йڵ</p>\r\n<p>: ż</p>\r\n<p>: </p>\r\n<p>Ƭ: 45</p>\r\n<p>汾: 30ȫ</p>\r\n<p>ṩ: Ѹ</p>\r\n<p>ӳ: 2010 </p>\r\n','0');
INSERT INTO `qb_reply` VALUES ('605','','0','624','14','1','1','<p>: Ľ</p>\r\n<p>: ŷ𻪷ܷǻ˼</p>\r\n<p>Ƭ/: й</p>\r\n<p>: װ</p>\r\n<p>: </p>\r\n<p>Ƭ: 45</p>\r\n<p>汾: 40ȫ</p>\r\n<p>ṩ: ʢ</p>\r\n<p>ӳ: 2010 </p>\r\n<p>&nbsp;</p>\r\n','0');
INSERT INTO `qb_reply` VALUES ('606','','0','625','14','1','1','<p>: ˮл</p>\r\n<p>: ķ˳Ⱥδ</p>\r\n<p>Ƭ/: ¼</p>\r\n<p>: װ</p>\r\n<p>: </p>\r\n<p>Ƭ: 45</p>\r\n<p>汾: 48ȫ</p>\r\n<p>ṩ: Ѹ</p>\r\n<p>ӳ: 2010 <br />\r\n</p>\r\n','0');
INSERT INTO `qb_reply` VALUES ('607','','0','626','14','1','1','<p>: ΰ</p>\r\n<p>: ս</p>\r\n<p>Ƭ/: йڵ</p>\r\n<p>: 鶼</p>\r\n<p>: </p>\r\n<p>Ƭ: 45</p>\r\n<p>汾: 24ȫ</p>\r\n<p>ṩ: Ѹ</p>\r\n<p>ӳ: 2010 <br />\r\n</p>\r\n','0');
INSERT INTO `qb_reply` VALUES ('608','','0','627','14','1','1','<p>: ϣϣ</p>\r\n<p>: ½½άԶºԿںΰٹ</p>\r\n<p>Ƭ/: йڵ</p>\r\n<p>: ʷս</p>\r\n<p>: </p>\r\n<p>Ƭ: 45</p>\r\n<p>汾: 95ȫ</p>\r\n<p>ṩ: Ѹ</p>\r\n<p>ӳ: 2010 <br />\r\n</p>\r\n','0');
INSERT INTO `qb_reply` VALUES ('609','','0','628','14','1','1','<p>&nbsp;<br />\r\n: </p>\r\n<p>: 꽯־κ</p>\r\n<p>Ƭ/: йڵ</p>\r\n<p>: ս</p>\r\n<p>: </p>\r\n<p>Ƭ: 45</p>\r\n<p>汾: 40ȫ</p>\r\n<p>ṩ: Ѹ</p>\r\n<p>ӳ: 2010 <br />\r\n</p>\r\n','0');
INSERT INTO `qb_reply` VALUES ('610','','0','629','14','1','1','<p><br />\r\n: С</p>\r\n<p>: Ҧ</p>\r\n<p>Ƭ/: йڵ</p>\r\n<p>: </p>\r\n<p>: </p>\r\n<p>Ƭ: 90</p>\r\n<p>汾: ԤƬ</p>\r\n<p>ṩ: Ѹ</p>\r\n<p>ӳ: 2010 </p>\r\n','0');
INSERT INTO `qb_reply` VALUES ('611','','0','630','14','1','1','<p>: ¿</p>\r\n<p>: ׳ºʤȺѧӢ</p>\r\n<p>Ƭ/: йڵ</p>\r\n<p>: Ǿʷ</p>\r\n<p>: </p>\r\n<p>Ƭ: 100</p>\r\n<p>汾: </p>\r\n<p>ṩ: ý</p>\r\n<p>ӳ: 2008-12-05 й</p>\r\n<p>&nbsp;</p>\r\n','0');
INSERT INTO `qb_reply` VALUES ('612','','0','631','14','1','1','<p><br />\r\n: </p>\r\n<p>: Ѹþ粷̷</p>\r\n<p>Ƭ/: йڵ</p>\r\n<p>: ϲ</p>\r\n<p>: </p>\r\n<p>Ƭ: 120</p>\r\n<p>汾: </p>\r\n<p>ṩ: ý</p>\r\n<p>ӳ: 2008-10-16 ¼<br />\r\n</p>\r\n','0');
INSERT INTO `qb_reply` VALUES ('867','','0','886','4','1','1','<p><span id=\"_baidu_bookmark_start_13\" style=\"display:none;line-height:0px;\"></span><span id=\"_baidu_bookmark_start_15\" style=\"display:none;line-height:0px;\"></span></p><p style=\"text-align:left;\"><span id=\"_baidu_bookmark_start_1\" style=\"display:none;line-height:0px;\"></span><span id=\"_baidu_bookmark_start_3\" style=\"display:none;line-height:0px;\"></span>֮ͬ˼ϵĸߵ磬֮ӵĸϢһֱصúܺöҲڹ¶档ϤԪ(JerryMa)1992֮ǰ¸绪ʥѧѧ(</p><p style=\"text-align:left;\"></p><p><span style=\"color:#333333;font-family:&#39;pingfang sc&#39;, &#39;hiragino sans gb&#39;, &#39;microsoft yahei&#39;, &#39;wenquanyi micro hei&#39;, &#39;helvetica neue&#39;, arial, sans-serif;line-height:18.24px;background-color:#ffffff;\">ϼӣлȵ)ڶڼݴѧУѧ</span></p><p style=\"padding:0px;line-height:28px;word-wrap:break-word;color:#333333;font-family:&#39;pingfang sc&#39;, &#39;hiragino sans gb&#39;, &#39;microsoft yahei&#39;, &#39;wenquanyi micro hei&#39;, &#39;helvetica neue&#39;, arial, sans-serif;background-color:#ffffff;margin-top:0px;margin-bottom:20px;\"><br /></p><div style=\"margin:0px 0px 20px;padding:0px;line-height:28px;color:#333333;font-family:&#39;pingfang sc&#39;, &#39;hiragino sans gb&#39;, &#39;microsoft yahei&#39;, &#39;wenquanyi micro hei&#39;, &#39;helvetica neue&#39;, arial, sans-serif;text-align:left;background-color:#ffffff;\"><p style=\"text-align:center\"><img src=\"http://www_qibosoft_com/Tmp_updir/article/4/1_vtqr3__0.jpg\" img_width=\"489\" img_height=\"444\" style=\"border:0px;display:block;max-width:100%;margin-bottom:10px;margin-top:10px;\" /></p></div><p style=\"padding:0px;line-height:28px;word-wrap:break-word;color:#333333;font-family:&#39;pingfang sc&#39;, &#39;hiragino sans gb&#39;, &#39;microsoft yahei&#39;, &#39;wenquanyi micro hei&#39;, &#39;helvetica neue&#39;, arial, sans-serif;text-align:left;background-color:#ffffff;margin-top:0px;margin-bottom:20px;\"></p><p style=\"padding:0px;line-height:28px;word-wrap:break-word;color:#333333;font-family:&#39;pingfang sc&#39;, &#39;hiragino sans gb&#39;, &#39;microsoft yahei&#39;, &#39;wenquanyi micro hei&#39;, &#39;helvetica neue&#39;, arial, sans-serif;text-align:left;background-color:#ffffff;margin-top:0px;margin-bottom:20px;\"></p><p><span style=\"color:#333333;font-family:&#39;pingfang sc&#39;, &#39;hiragino sans gb&#39;, &#39;microsoft yahei&#39;, &#39;wenquanyi micro hei&#39;, &#39;helvetica neue&#39;, arial, sans-serif;line-height:18.24px;background-color:#ffffff;\">ӦƴҵƷ1992ǵҵͬ䡣ʱǼһ30˿ᣬңӹڷﲻܳԷʱһԹͣһӾͳԽԽְ֣</span></p><p style=\"padding:0px;line-height:28px;word-wrap:break-word;color:#333333;font-family:&#39;pingfang sc&#39;, &#39;hiragino sans gb&#39;, &#39;microsoft yahei&#39;, &#39;wenquanyi micro hei&#39;, &#39;helvetica neue&#39;, arial, sans-serif;text-align:left;background-color:#ffffff;margin-top:0px;margin-bottom:20px;\">ݹ</p><p><span style=\"color:#333333;font-family:&#39;pingfang sc&#39;, &#39;hiragino sans gb&#39;, &#39;microsoft yahei&#39;, &#39;wenquanyi micro hei&#39;, &#39;helvetica neue&#39;, arial, sans-serif;line-height:18.24px;background-color:#ffffff;\">֧һԴԽԽæ4УһӾ5죬ĩŽӻؼƺһֱæڴҵ˶ӵĽɳһȵӳ磬治á</span></p><p style=\"padding:0px;line-height:28px;word-wrap:break-word;color:#333333;font-family:&#39;pingfang sc&#39;, &#39;hiragino sans gb&#39;, &#39;microsoft yahei&#39;, &#39;wenquanyi micro hei&#39;, &#39;helvetica neue&#39;, arial, sans-serif;background-color:#ffffff;margin-top:0px;margin-bottom:20px;\"><br /></p><p style=\"text-align:center\"><img src=\"http://www_qibosoft_com/Tmp_updir/article/4/1_nnn0t__0.jpg\" img_width=\"400\" img_height=\"266\" style=\"border:0px;display:block;max-width:100%;margin-bottom:10px;\" /></p><p style=\"padding:0px;line-height:28px;word-wrap:break-word;color:#333333;font-family:&#39;pingfang sc&#39;, &#39;hiragino sans gb&#39;, &#39;microsoft yahei&#39;, &#39;wenquanyi micro hei&#39;, &#39;helvetica neue&#39;, arial, sans-serif;text-align:left;background-color:#ffffff;margin-top:0px;margin-bottom:20px;\"><br />ǰϢƶΪ<br /></p><p style=\"padding:0px;line-height:28px;word-wrap:break-word;color:#333333;font-family:&#39;pingfang sc&#39;, &#39;hiragino sans gb&#39;, &#39;microsoft yahei&#39;, &#39;wenquanyi micro hei&#39;, &#39;helvetica neue&#39;, arial, sans-serif;text-align:left;background-color:#ffffff;margin-top:0px;margin-bottom:20px;\">԰</p><p><span style=\"color:#333333;font-family:&#39;pingfang sc&#39;, &#39;hiragino sans gb&#39;, &#39;microsoft yahei&#39;, &#39;wenquanyi micro hei&#39;, &#39;helvetica neue&#39;, arial, sans-serif;line-height:18.24px;background-color:#ffffff;\">Ⲣδõ֤ʵ</span></p><p style=\"padding:0px;line-height:28px;word-wrap:break-word;color:#333333;font-family:&#39;pingfang sc&#39;, &#39;hiragino sans gb&#39;, &#39;microsoft yahei&#39;, &#39;wenquanyi micro hei&#39;, &#39;helvetica neue&#39;, arial, sans-serif;background-color:#ffffff;margin-top:0px;margin-bottom:20px;\"><br /></p><p style=\"padding:0px;line-height:28px;word-wrap:break-word;color:#333333;font-family:&#39;pingfang sc&#39;, &#39;hiragino sans gb&#39;, &#39;microsoft yahei&#39;, &#39;wenquanyi micro hei&#39;, &#39;helvetica neue&#39;, arial, sans-serif;text-align:left;background-color:#ffffff;margin-top:0px;margin-bottom:20px;\">෴֮ܲ˼ϣα˼Ͷ޹˾³IGӾֲʼˡＯŶ¡Ϊйڵ׸֮Ӻ</p><p style=\"padding:0px;line-height:28px;word-wrap:break-word;color:#333333;font-family:&#39;pingfang sc&#39;, &#39;hiragino sans gb&#39;, &#39;microsoft yahei&#39;, &#39;wenquanyi micro hei&#39;, &#39;helvetica neue&#39;, arial, sans-serif;text-align:left;background-color:#ffffff;margin-top:0px;margin-bottom:20px;\">Ｏ</p><p><span style=\"color:#333333;font-family:&#39;pingfang sc&#39;, &#39;hiragino sans gb&#39;, &#39;microsoft yahei&#39;, &#39;wenquanyi micro hei&#39;, &#39;helvetica neue&#39;, arial, sans-serif;line-height:18.24px;background-color:#ffffff;\">ٶң˼ϵ΢ȴйغгݣģЦԷԡ񡢿ƺŬΪһעʱᷢչſ</span></p><p style=\"padding:0px;line-height:28px;word-wrap:break-word;color:#333333;font-family:&#39;pingfang sc&#39;, &#39;hiragino sans gb&#39;, &#39;microsoft yahei&#39;, &#39;wenquanyi micro hei&#39;, &#39;helvetica neue&#39;, arial, sans-serif;background-color:#ffffff;margin-top:0px;margin-bottom:20px;\"><br /></p><p style=\"text-align:center\"><img src=\"http://www_qibosoft_com/Tmp_updir/article/4/1_qkxa8__0.jpg\" img_width=\"500\" img_height=\"319\" style=\"border:0px;display:block;max-width:100%;margin-bottom:10px;\" /></p><p style=\"padding:0px;line-height:28px;word-wrap:break-word;color:#333333;font-family:&#39;pingfang sc&#39;, &#39;hiragino sans gb&#39;, &#39;microsoft yahei&#39;, &#39;wenquanyi micro hei&#39;, &#39;helvetica neue&#39;, arial, sans-serif;text-align:left;background-color:#ffffff;margin-top:0px;margin-bottom:20px;\"><br />ҲѳƣΪ<br /></p><p style=\"padding:0px;line-height:28px;word-wrap:break-word;color:#333333;font-family:&#39;pingfang sc&#39;, &#39;hiragino sans gb&#39;, &#39;microsoft yahei&#39;, &#39;wenquanyi micro hei&#39;, &#39;helvetica neue&#39;, arial, sans-serif;text-align:left;background-color:#ffffff;margin-top:0px;margin-bottom:20px;\"></p><p><span style=\"color:#333333;font-family:&#39;pingfang sc&#39;, &#39;hiragino sans gb&#39;, &#39;microsoft yahei&#39;, &#39;wenquanyi micro hei&#39;, &#39;helvetica neue&#39;, arial, sans-serif;line-height:18.24px;background-color:#ffffff;\">ͰҪԼĶӣͰ͵⣬бڰбš빫ӽ﹤ȣΪƾʱδ죬ܹӽλٸɸʮ궼ʱҪ죬ĽӶΪƸˣӾ͸ˣƵĶôûй¶Ҳûӡ</span></p><p style=\"padding:0px;line-height:28px;word-wrap:break-word;color:#333333;font-family:&#39;pingfang sc&#39;, &#39;hiragino sans gb&#39;, &#39;microsoft yahei&#39;, &#39;wenquanyi micro hei&#39;, &#39;helvetica neue&#39;, arial, sans-serif;background-color:#ffffff;margin-top:0px;margin-bottom:20px;\"><br /></p><p style=\"padding:0px;line-height:28px;word-wrap:break-word;color:#333333;font-family:&#39;pingfang sc&#39;, &#39;hiragino sans gb&#39;, &#39;microsoft yahei&#39;, &#39;wenquanyi micro hei&#39;, &#39;helvetica neue&#39;, arial, sans-serif;text-align:left;background-color:#ffffff;margin-top:0px;margin-bottom:20px;\">ԭ򣬹ҲֻƲ˵ף</p><p style=\"text-align:left;\"><br /><span id=\"_baidu_bookmark_end_4\" style=\"display:none;line-height:0px;\"></span><span id=\"_baidu_bookmark_end_2\" style=\"display:none;line-height:0px;\"></span></p><p><span id=\"_baidu_bookmark_end_16\" style=\"display:none;line-height:0px;\"></span><span id=\"_baidu_bookmark_end_14\" style=\"display:none;line-height:0px;\"></span></p>','0');
INSERT INTO `qb_reply` VALUES ('618','','0','637','12','1','1','<p>ѿԴBBS</p>\r\n','0');
INSERT INTO `qb_reply` VALUES ('619','','0','638','12','1','1','<p>ѿԴBBS</p>\r\n','0');
INSERT INTO `qb_reply` VALUES ('622','','0','641','12','1','1','qibosoft CMSPHPǰǿĿԴϵͳȫֲá+ģ+ϵͳ+ģʽ ȫ Դɼ䷽Ľжοйģɰװɾûȫʹá','0');
INSERT INTO `qb_reply` VALUES ('621','','0','640','12','1','1','qibosoftҵB2BΪûṩҵƽ̨Ҳֽ׶ιPHPΨһһƷƵB2B<br />\r\n','0');
INSERT INTO `qb_reply` VALUES ('644','','0','663','3','1','1','еƼ<a href=\"http://www.chinaccnet.com\">www.chinaccnet.com</a> һӵл񹲺͹ֵҵӪ֤׼ӪҵIDCҵISPƶĶԪֵӪ̡˾ӪԽͻΪͬʱ缼תãʵҵͶʣͶʹΪ̵ĶԪ˾ <br />\r\n˾δľӪͻϣ·񡱵ķ۶ԴСͻǶʼձгŵĺ̬ȡ˾ʼȽļֶμϵͳܹ·ȫмءƵĹܺרҵļ֧֣ȷΪÿûṩȫɿƷʵĶ绷 <br />\r\n','0');
INSERT INTO `qb_reply` VALUES ('645','','0','664','3','1','1','һΪ˷չҪ','0');
INSERT INTO `qb_reply` VALUES ('864','','0','883','34','1','1','<p style=\"padding:0px;word-wrap:break-word;font-family:&#39;microsoft yahei&#39;, helvetica, sans-serif;line-height:28px;text-indent:2em;background-color:#ffffff;margin-top:0px;margin-bottom:28px;\">Ѷ325 սء<a class=\"a-tips-Article-QQ\" href=\"http://soccer.stats.qq.com/player.htm?type=zhongchao&amp;t1=46546\" target=\"_blank\" style=\"text-decoration:none;outline:0px;color:#000000;border-bottom-width:1px;border-bottom-style:dotted;border-bottom-color:#536da6;\">ڴ</a>1-0ʤ12ǿ6к֮սĹؼʣԺ<a class=\"a-tips-Article-QQ\" href=\"http://sports.qq.com/csocce/cft/\" target=\"_blank\" style=\"text-decoration:none;outline:0px;color:#000000;border-bottom-width:1px;border-bottom-style:dotted;border-bottom-color:#536da6;\"></a>õʤǽҡƤӺɱ䣬2Ѿԭԣеġ漣ⳡ֮µȼԵ顣Ȼﳤ˵һͺһսĽݺѷɫڶ֣һ̱ʤϣ</p><p style=\"padding:0px;word-wrap:break-word;font-family:&#39;microsoft yahei&#39;, helvetica, sans-serif;line-height:28px;text-indent:2em;background-color:#ffffff;margin-top:0px;margin-bottom:28px;\"><strong>ɱ䣡Ҳ</strong></p><p style=\"padding:0px;word-wrap:break-word;font-family:&#39;microsoft yahei&#39;, helvetica, sans-serif;line-height:28px;text-indent:2em;background-color:#ffffff;margin-top:0px;margin-bottom:28px;\">ߺ鲨ʱڵ412ǿ0-3ں£㡰֮ض˳ˮķˣȡ2⣬3ı̫һ֧ӡʣ䱣ؾõһƽֵ´ƣǣ4ǰ<a class=\"a-tips-Article-QQ\" href=\"http://soccer.stats.qq.com/player.htm?type=zhongchao&amp;t1=116730\" target=\"_blank\" style=\"text-decoration:none;outline:0px;color:#000000;border-bottom-width:1px;border-bottom-style:dotted;border-bottom-color:#536da6;\"></a><a class=\"a-tips-Article-QQ\" href=\"http://soccer.stats.qq.com/player.htm?type=zhongchao&amp;t1=37441\" target=\"_blank\" style=\"text-decoration:none;outline:0px;color:#000000;border-bottom-width:1px;border-bottom-style:dotted;border-bottom-color:#536da6;\">۬</a>ַȴöֳǳغް취Ϊߵһʧ󣬵0-1ܡǰ󣬸ߺ鲨ǿһ仰Ե12ĳɼ12ǿ׶ûã</p><p style=\"padding:0px;word-wrap:break-word;font-family:&#39;microsoft yahei&#39;, helvetica, sans-serif;line-height:28px;text-indent:2em;background-color:#ffffff;margin-top:0px;margin-bottom:28px;\">ͳȱ˹̹ıǲҲ̶ãſæµĺܿܲ0-2ʧ©ٳñͷԡָ𣬸ߺ鲨ѡ˹ӡȥȴһ̯ӡ2000ŷԪнƤȻΪھͷȴп˹ġ漣֮á</p><p style=\"padding:0px;word-wrap:break-word;font-family:&#39;microsoft yahei&#39;, helvetica, sans-serif;line-height:28px;text-indent:2em;background-color:#ffffff;margin-top:0px;margin-bottom:28px;\">뿨ı㾡Χ֣ԱһǷѣùһսֻ0-0İ׾ճɣùںͺӵսаԼˣƤĴǣȻжŷԱѹ󣬵ҲҪýȡϣļͳȻڿȫ·磬12-12Ŵ4-5֤ڽ治ѷɫڶ֣Чʸߡ</p><p style=\"padding:0px;word-wrap:break-word;font-family:&#39;microsoft yahei&#39;, helvetica, sans-serif;line-height:28px;text-indent:2em;background-color:#ffffff;margin-top:0px;margin-bottom:28px;\">ҲԽпսкս֮ɱ䡣֮ǰıȣһιչʾԼĽϣĿʼ</p><p style=\"padding:0px;word-wrap:break-word;font-family:&#39;microsoft yahei&#39;, helvetica, sans-serif;line-height:28px;text-indent:2em;background-color:#ffffff;margin-top:0px;margin-bottom:28px;\"><strong>дʷֺ֢ɢȥ</strong></p><p style=\"padding:0px;word-wrap:break-word;font-family:&#39;microsoft yahei&#39;, helvetica, sans-serif;line-height:28px;text-indent:2em;background-color:#ffffff;margin-top:0px;margin-bottom:28px;\">кʷڹ˵ǡһѪʷǰ38ĹA½У2010ĶǱ3-0սʤ֡Ҫ֪սǱձһϲŷԱǳ3-0ҲΪкʷϹΨһõóֵıһսʤùӴ˿ԽرʾǲٿֺԤ׶ΣޱҪҪⳡڹ˵һս</p><p style=\"padding:0px;word-wrap:break-word;font-family:&#39;microsoft yahei&#39;, helvetica, sans-serif;line-height:28px;text-indent:2em;background-color:#ffffff;margin-top:0px;margin-bottom:28px;\">ѹתΪʤĶ¡ʽǱ̫ĵһʤڳɳʷȻ׿ԤսЩԪ⣬ⲿĴ󻷾ǰѾù·ˣⳡʤйüԺýǰĽ1-0ʤõĻػҪ֪ⳡʤ㻹ǽ¡</p><p style=\"padding:0px;word-wrap:break-word;font-family:&#39;microsoft yahei&#39;, helvetica, sans-serif;line-height:28px;text-indent:2em;background-color:#ffffff;margin-top:0px;margin-bottom:28px;\">Ȼøлءɳڴ󱦣ڤڤ֮һжѾעű棬ƤڽػعҶӵŽ׷ݣ볡󼴻ڣ59á׼ˡ販꣬ÿһαп¶ǰûв²⵽ġÿһαжȡ˳ɹٴӽչʾԼĹõ12ǿʤͬʱҲ˳ɳصĳƺţú״й</p><p style=\"padding:0px;word-wrap:break-word;font-family:&#39;microsoft yahei&#39;, helvetica, sans-serif;line-height:28px;text-indent:2em;background-color:#ffffff;margin-top:0px;margin-bottom:28px;\"><strong>ϣֻ2</strong></p><p style=\"padding:0px;word-wrap:break-word;font-family:&#39;microsoft yahei&#39;, helvetica, sans-serif;line-height:28px;text-indent:2em;background-color:#ffffff;margin-top:0px;margin-bottom:28px;\">һսƽ֮пΪβƤЩĻⳡ1-0սʤıֺ֮ǰ41ƽ3Ƥһõһƽֺ󣬹5սֻ2֣3ȱ˹̹7ֵĲࡣ֮ͬ40ǿһһԼ¿ͬʱɱܳʰ㡰12ǿһ</p><p style=\"padding:0px;word-wrap:break-word;font-family:&#39;microsoft yahei&#39;, helvetica, sans-serif;line-height:28px;text-indent:2em;background-color:#ffffff;margin-top:0px;margin-bottom:28px;\">ºͬʱǺȱ˹̹ɱסǰĽŲǹ㡣ͳ֮󣬹ͻڽ2ֱзֱǺȱ˹̹Ҳԭľ񿴵һ˿ϣȻܷ֮𻯳ԭ֮Ҫý˵ʤ˵2ģϣȼ</p><p><br /></p>','0');
INSERT INTO `qb_article_content_100` VALUES ('4','606','587','10','1','photo/10/1_20101110141139_i1ypy.jpg@@@2a5570c2-a7b4-400d-8b13-c64a4a0613e8@@@');
INSERT INTO `qb_article_content_100` VALUES ('1','531','509','10','1','photo/10/1_20090415160401_XMXbb.jpg@@@06C84C97B8F24A26A6C05B4BC5BE4794200608021752@@@\nphoto/10/1_20090415160416_qs6Mj.jpg@@@839-45-5@@@');
INSERT INTO `qb_article_content_100` VALUES ('5','607','588','10','1','photo/10/1_20101110141134_qxblz.jpg@@@4b5766f9-199a-49f2-a549-8a200dc0b419@@@');
INSERT INTO `qb_article_content_100` VALUES ('2','532','510','10','1','photo/10/1_20090415170406_X57YC.jpg@@@2006_11_06_22_15_11_258@@@\nphoto/10/1_20090415170419_IxNF1.jpg@@@200808%5C1722073@@@');
INSERT INTO `qb_article_content_100` VALUES ('3','605','586','10','1','photo/10/1_20101110141136_wdd4w.jpg@@@0d7d09f1-f0f3-4276-ae37-5e019675a4fe@@@');
INSERT INTO `qb_article_content_100` VALUES ('6','608','589','10','1','photo/10/1_20101110141120_fpwhq.jpg@@@40777b29-81ba-48b1-85d2-e11b9a9148aa@@@');
INSERT INTO `qb_article_content_100` VALUES ('7','609','590','10','1','photo/10/1_20101110141109_hsvcz.jpg@@@331c7842-904f-48d6-b072-04490709bb84@@@');
INSERT INTO `qb_article_content_100` VALUES ('8','610','591','10','1','photo/10/1_20101110141153_lisq8.jpg@@@5cf208d3-ad7b-4d29-85e0-56d58501039f@@@');
INSERT INTO `qb_article_content_100` VALUES ('9','611','592','10','1','photo/10/1_20101110141106_ipncy.jpg@@@6df8e2ed-1721-4849-9489-cacbd33aaea2@@@');
INSERT INTO `qb_article_content_100` VALUES ('10','612','593','10','1','photo/10/1_20101110141155_s3htx.jpg@@@98a8a42d-9ff8-4482-bb68-49bd7db89d80@@@');
INSERT INTO `qb_article_content_100` VALUES ('11','613','594','10','1','photo/10/1_20101110151145_1aiuz.jpg@@@26d75a2c-70a8-4be5-b519-935c4f0c4855@@@');
INSERT INTO `qb_article_content_100` VALUES ('12','614','595','10','1','photo/10/1_20101110151129_l9jnr.jpg@@@2e9d868f-d1ea-4d4b-a4b2-e26d9a688b63@@@');
INSERT INTO `qb_article_content_100` VALUES ('13','615','596','10','1','photo/10/1_20101110151151_yggdp.jpg@@@0d95b391-ad47-414d-a062-0fe205ca809a@@@');
INSERT INTO `qb_article_content_100` VALUES ('14','616','597','10','1','photo/10/1_20101110151138_sobq7.jpg@@@81b4e9ce-2fb2-4ff1-836a-024a71be2abc@@@');
INSERT INTO `qb_article_content_100` VALUES ('15','617','598','10','1','photo/10/1_20101110151153_b8cy7.jpg@@@16d72801-bd43-455d-beaf-d0b971485e63@@@');
INSERT INTO `qb_article_content_100` VALUES ('16','618','599','10','1','photo/10/1_20101110151101_2kjyw.jpg@@@2336d723-504f-4180-9f4d-78b13c598ce4@@@');
INSERT INTO `qb_article_content_101` VALUES ('5','538','516','12','1','1','1','1','1','1239788490','','qibosoft','http://www.qibosoft.com/','http://www.qibosoft.com/','PHP','','Ѱ','1.11','http://down.qibosoft.com/module/wnarticle.rar@@@@@@');
INSERT INTO `qb_article_content_101` VALUES ('2','535','513','26','1','24','24','24','24','1239787781','','Ѹ','http://www.xunlei.com/','http://www.xunlei.com/','XP/2003','','Ѱ','9.5','http://down.sandai.net/Thunder5.8.13.699.exe@@@@@@');
INSERT INTO `qb_article_content_101` VALUES ('6','539','517','12','1','2','2','2','2','1240192795','','qibosoft','http://www.qibosoft.com/','http://www.qibosoft.com/','PHP','','Ѱ','0.75','http://down.qibosoft.com/module/wnfenlei.rar@@@@@@');
INSERT INTO `qb_article_content_101` VALUES ('3','536','514','27','1','1','1','1','1','1239788031','','ɽ','http://www.kingsoft.com/','http://www.wps.cn/','Windows 2000/XP/Vista','','Ѱ','28.3','http://kad.www.wps.cn/wps/download/WPS2007.12012.exe@@@@@@');
INSERT INTO `qb_article_content_101` VALUES ('4','537','515','26','1','1','1','1','1','1239788257','','Ѷ','http://www.qq.com/','http://im.qq.com/','2000/2003/XP','','Ѱ','19.8','http://dl_dir.qq.com/qqfile/qq/QQ2009/QQ2009Beta2.exe@@@@@@');
INSERT INTO `qb_article_content_101` VALUES ('7','540','518','12','1','1','1','1','1','1240192781','','qibosoft','http://www.qibosoft.com/','http://www.qibosoft.com/','PHP','','Ѱ','3.13','http://down.qibosoft.com/module/blog.rar@@@@@@');
INSERT INTO `qb_article_content_101` VALUES ('8','541','519','12','1','0','0','0','0','0','','qibosoft','http://www.qibosoft.com/','http://www.qibosoft.com/','PHP','','Ѱ','3.31','http://down.qibosoft.com/module/zhidao.rar@@@@@@');
INSERT INTO `qb_article_content_101` VALUES ('9','637','618','12','1','0','0','0','0','0','','phpwind','phpwind','http://www.phpwind.net','Linux/2003/XP/PHP','','Ѱ','10','http://download.phpwind.net/index.php?m=download&a=do&did=477@@@@@@');
INSERT INTO `qb_article_content_101` VALUES ('10','638','619','12','1','0','0','0','0','0','','ʢ','http://www.comsenz.com/','http://www.discuz.net','Linux/2003/PHP','','Ѱ','7.11','http://download2.comsenz.com/DiscuzX/1.5/Discuz_X1.5_SC_GBK.zip@@@@@@');
INSERT INTO `qb_article_content_101` VALUES ('13','641','622','12','1','0','0','0','0','0','','qibosoft','http://www.qibosoft.com/','http://v6.qibosoft.com/','Linux/2003/PHP','','Ѱ','5','http://down.qibosoft.com/down.php?v=v6@@@@@@');
INSERT INTO `qb_article_content_101` VALUES ('12','640','621','12','1','0','0','0','0','0','','qibosoft','http://www.qibosoft.com/','http://www.gt115.com/','Linux/2003/PHP','','Ѱ','11','http://bbs.qibosoft.com/downV6business.php@@@@@@');
INSERT INTO `qb_article_content_101` VALUES ('14','642','623','26','1','0','0','0','0','0','','','http://www.rarlab.com/','','2003/XP','','Ѱ','3','http://down.it168.com/DownLoad.aspx?rsId=16060&dlType=gf@@@@@@');
INSERT INTO `qb_article_content_101` VALUES ('15','643','624','26','1','0','0','0','0','0','','','http://www.drivergenius.com/','','2003/Linux/XP','','Ѱ','25','http://down.it168.com/DownLoad.aspx?rsId=106848&dlType=gf@@@@@@');
INSERT INTO `qb_article_content_101` VALUES ('16','644','625','26','1','0','0','0','0','0','','ѹƼչ޹˾','http://pinyin.sogou.com/','','2003/XP','','Ѱ','6','http://down.it168.com/DownLoad.aspx?rsId=80927&dlType=gf@@@@@@');
INSERT INTO `qb_article_content_101` VALUES ('17','645','626','26','1','0','0','0','0','0','','ACD Systems','http://www.acdsystems.com/','','2003/XP','','Ѱ','5','http://down.it168.com/DownLoad.aspx?rsId=17460&dlType=gf@@@@@@');
INSERT INTO `qb_article_content_101` VALUES ('18','646','627','26','1','0','0','0','0','0','','verycd','http://www.verycd.com/','','2003/XP','','Ѱ','7','http://down.it168.com/DownLoad.aspx?rsId=7453&dlType=gf@@@@@@');
INSERT INTO `qb_article_content_101` VALUES ('19','647','628','26','1','0','0','0','0','0','','qianqian','http://ttplayer.qianqian.com/','','2003/XP','','Ѱ','9','http://down.it168.com/DownLoad.aspx?rsId=20769&dlType=gf@@@@@@');
INSERT INTO `qb_article_content_101` VALUES ('20','648','629','27','1','0','0','0','0','0','','ɽ','http://u.sl.iciba.com/union/download/index_pwlite.html?uid=3250&sid=&adid=1133&adtype=63','','2003/XP','','Ѱ','13','http://down.it168.com/DownLoad.aspx?rsId=80375&dlType=gf@@@@@@');
INSERT INTO `qb_article_content_101` VALUES ('21','649','630','27','1','0','0','0','0','0','','΢ǹ','http://www.microsword.net/','','2003/XP','','Ѱ','6','http://down.it168.com/DownLoad.aspx?rsId=81009&dlType=gf@@@@@@');
INSERT INTO `qb_article_content_101` VALUES ('22','650','631','27','1','0','0','0','0','0','','ǿԿƼ޹˾','http://www.wnwb.com/','','2003/XP','','Ѱ','8','http://down.it168.com/DownLoad.aspx?rsId=81025&dlType=gf@@@@@@');
INSERT INTO `qb_article_content_101` VALUES ('23','651','632','27','1','0','0','0','0','0','','Ѷ','http://im.qq.com/foxmail/download.shtml','','XP/2003','','Ѱ','9','http://down.it168.com/DownLoad.aspx?rsId=1840&dlType=gf@@@@@@');
INSERT INTO `qb_article_content_101` VALUES ('24','652','633','27','1','0','0','0','0','0','','΢Live','http://get.live.cn/','','2003/XP','','Ѱ','12','http://down.it168.com/DownLoad.aspx?rsId=1090&dlType=gf@@@@@@');
INSERT INTO `qb_article_content_101` VALUES ('25','653','634','27','1','0','0','0','0','0','','Ѷ','http://dl_dir.qq.com/','','XP/2003','','Ѱ','30','http://down.it168.com/DownLoad.aspx?rsId=6669&dlType=gf@@@@@@');
INSERT INTO `qb_article_content_101` VALUES ('26','654','635','27','1','0','0','0','0','0','',' 6','http://www.ku6.com/soft/speedku6.html','','2003/XP','','Ѱ','10','http://down.it168.com/DownLoad.aspx?rsId=109341&dlType=gf@@@@@@');
INSERT INTO `qb_article_content_101` VALUES ('27','655','636','40','1','0','0','0','0','0','','滢360','http://www.360.cn/down/soft_down2-3.html','','2003/XP','','Ѱ','9','http://down.it168.com/DownLoad.aspx?rsId=43634&dlType=gf@@@@@@');
INSERT INTO `qb_article_content_101` VALUES ('28','656','637','40','1','0','0','0','0','0','','ǿƼ','http://www.rising.com.cn/','','2003/XP','','Ѱ','10','http://down.it168.com/DownLoad.aspx?rsId=43505&dlType=gf@@@@@@');
INSERT INTO `qb_article_content_101` VALUES ('29','657','638','40','1','0','0','0','0','0','','˹ʵ','http://www.kaspersky.com.cn/','','2003/XP','','Ѱ','10','http://down.it168.com/DownLoad.aspx?rsId=107344&dlType=gf@@@@@@');
INSERT INTO `qb_article_content_101` VALUES ('30','658','639','40','1','0','0','0','0','0','','ɽ','http://www.duba.net/','','XP/2003','','Ѱ','15','http://cd001.www.duba.net/duba/install/2011/ever/KAV101109_DOWN_99_10.exe@@@@@@');
INSERT INTO `qb_article_content_101` VALUES ('31','659','640','40','1','0','0','0','0','0','','¿Ƽ޹˾','http://www.jiangmin.com/','','2003/XP','','Ѱ','13','http://down.it168.com/DownLoad.aspx?rsId=107323&dlType=gf@@@@@@');
INSERT INTO `qb_article_content_101` VALUES ('32','660','641','40','1','0','0','0','0','0','','˹˾','http://www.nt800.com/download/cbnav.htm','','2003/XP','','Ѱ','15','http://down.it168.com/DownLoad.aspx?rsId=15208&dlType=gf@@@@@@');
INSERT INTO `qb_article_content_101` VALUES ('33','661','642','40','1','0','0','0','0','0','','ɽ','http://www.duba.net/','','XP/2003','','Ѱ','15','http://down.it168.com/DownLoad.aspx?rsId=125258&dlType=gf@@@@@@');
INSERT INTO `qb_article_content_101` VALUES ('34','662','643','40','1','0','0','0','0','0','',' ¿Ƽ޹˾','http://www.jiangmin.com/','','2003/XP/XP','','Ѱ','5','http://down.it168.com/DownLoad.aspx?rsId=43469&dlType=gf@@@@@@');
INSERT INTO `qb_article_content_102` VALUES ('9','542','520','14','1','1','1','1','9','1289443058','','http://down.qibosoft.com/other/testv6/1.flv@@@1@@@@@@flv\nhttp://down.qibosoft.com/other/testv6/2.flv@@@2@@@@@@flv\nhttp://down.qibosoft.com/other/testv6/3.flv@@@3@@@@@@flv\nhttp://down.qibosoft.com/other/testv6/4.flv@@@4@@@@@@flv','ȶǴ','Ӣ');
INSERT INTO `qb_article_content_102` VALUES ('15','601','582','14','1','1','1','1','2','1289443027','','http://player.youku.com/player.php/sid/XODUxMTk5Mjg=/v.swf@@@NBA@@@@@@swf','»','');
INSERT INTO `qb_article_content_102` VALUES ('16','619','600','14','1','1','1','1','1','1289443554','','http://player.youku.com/player.php/sid/XMjEwMzEyMjM2/v.swf@@@@@@@@@swf','ӵ','');
INSERT INTO `qb_article_content_102` VALUES ('17','620','601','14','1','0','0','0','0','0','','http://player.youku.com/player.php/sid/XMjEyNzQzNDQw/v.swf@@@@@@@@@swf','ܶ','');
INSERT INTO `qb_article_content_102` VALUES ('18','621','602','14','1','0','0','0','0','0','','http://player.youku.com/player.php/sid/XMjE4MTMyOTM2/v.swf@@@@@@@@@swf','','');
INSERT INTO `qb_article_content_102` VALUES ('19','622','603','14','1','0','0','0','0','0','','http://player.youku.com/player.php/sid/XMTI1NzAyMjYw/v.swf@@@@@@@@@swf','','');
INSERT INTO `qb_article_content_102` VALUES ('20','623','604','14','1','0','0','0','0','0','','http://player.youku.com/player.php/sid/XMjA3MjMxNzQw/v.swf@@@@@@@@@swf','־ӱ','');
INSERT INTO `qb_article_content_102` VALUES ('21','624','605','14','1','0','0','0','0','0','','http://player.youku.com/player.php/sid/XMTkxODIzNDA0/v.swf@@@@@@@@@swf','ŷ','');
INSERT INTO `qb_article_content_102` VALUES ('22','625','606','14','1','0','0','0','0','0','','http://player.youku.com/player.php/sid/XMTE4NTk5NDky/v.swf@@@@@@@@@swf','','');
INSERT INTO `qb_article_content_102` VALUES ('23','626','607','14','1','0','0','0','0','0','','http://player.youku.com/player.php/sid/XMTI5NjYxODky/v.swf@@@@@@@@@swf','','');
INSERT INTO `qb_article_content_102` VALUES ('24','627','608','14','1','0','0','0','0','0','','http://player.youku.com/player.php/sid/XMjE0ODc0MTA4/v.swf@@@@@@@@@swf','½','');
INSERT INTO `qb_article_content_102` VALUES ('25','628','609','14','1','0','0','0','0','0','','http://player.youku.com/player.php/sid/XMjA1NTI1NzQw/v.swf@@@@@@@@@swf','','');
INSERT INTO `qb_article_content_102` VALUES ('26','629','610','14','1','0','0','0','0','0','','http://player.youku.com/player.php/sid/XNjA2ODU0OTY=/v.swf@@@@@@@@@swf','','');
INSERT INTO `qb_article_content_102` VALUES ('27','630','611','14','1','0','0','0','0','0','','http://player.youku.com/player.php/sid/XNTk5MjkyMjA=/v.swf@@@@@@@@@swf','','');
INSERT INTO `qb_article_content_102` VALUES ('28','631','612','14','1','0','0','0','0','0','','http://player.youku.com/player.php/sid/XMTU2MjI5NzA4/v.swf@@@@@@@@@swf','Ѹ','');
INSERT INTO `qb_article_module` VALUES ('100','ͼƬģ','ͼƬ','0','','','','a:3:{s:8:\"field_db\";a:1:{s:8:\"photourl\";a:15:{s:5:\"title\";s:8:\"ͼƬַ\";s:10:\"field_name\";s:8:\"photourl\";s:10:\"field_type\";s:10:\"mediumtext\";s:10:\"field_leng\";i:0;s:9:\"form_type\";s:9:\"upmorepic\";s:15:\"field_inputleng\";s:0:\"\";s:8:\"form_set\";s:0:\"\";s:10:\"form_value\";s:0:\"\";s:10:\"form_units\";s:0:\"\";s:10:\"form_title\";s:0:\"\";s:8:\"mustfill\";s:1:\"1\";s:6:\"search\";s:1:\"0\";s:10:\"IfListShow\";s:1:\"0\";s:9:\"orderlist\";s:1:\"0\";s:9:\"allowview\";N;}}s:7:\"is_html\";a:0:{}s:9:\"moduleSet\";a:11:{s:5:\"alias\";s:4:\"ͼƬ\";s:10:\"title_name\";s:8:\"ͼƬ\";s:12:\"content_name\";s:4:\"\";s:6:\"edit_w\";s:3:\"500\";s:6:\"edit_h\";s:3:\"200\";s:11:\"description\";s:1:\"1\";s:5:\"etype\";s:1:\"1\";s:8:\"morepage\";s:1:\"1\";s:9:\"no_author\";s:1:\"1\";s:7:\"no_from\";s:1:\"1\";s:10:\"no_fromurl\";s:1:\"1\";}}','photo','0','0');
INSERT INTO `qb_article_module` VALUES ('101','ģ','','0','','','','a:4:{s:8:\"field_db\";a:8:{s:9:\"my_author\";a:13:{s:5:\"title\";s:8:\"\";s:10:\"field_name\";s:9:\"my_author\";s:10:\"field_type\";s:7:\"varchar\";s:10:\"field_leng\";i:30;s:9:\"form_type\";s:4:\"text\";s:15:\"field_inputleng\";s:2:\"10\";s:8:\"form_set\";s:0:\"\";s:10:\"form_value\";s:0:\"\";s:10:\"form_units\";s:0:\"\";s:10:\"form_title\";s:0:\"\";s:6:\"search\";s:1:\"0\";s:9:\"orderlist\";i:8;s:9:\"allowview\";N;}s:14:\"my_copyfromurl\";a:14:{s:5:\"title\";s:8:\"ҳ\";s:10:\"field_name\";s:14:\"my_copyfromurl\";s:10:\"field_type\";s:7:\"varchar\";s:10:\"field_leng\";i:150;s:9:\"form_type\";s:4:\"text\";s:15:\"field_inputleng\";s:2:\"50\";s:8:\"form_set\";s:0:\"\";s:10:\"form_value\";s:0:\"\";s:10:\"form_units\";s:0:\"\";s:10:\"form_title\";s:0:\"\";s:8:\"mustfill\";s:1:\"0\";s:6:\"search\";s:1:\"0\";s:9:\"orderlist\";i:7;s:9:\"allowview\";N;}s:7:\"my_demo\";a:14:{s:5:\"title\";s:8:\"ʾַ\";s:10:\"field_name\";s:7:\"my_demo\";s:10:\"field_type\";s:7:\"varchar\";s:10:\"field_leng\";i:150;s:9:\"form_type\";s:4:\"text\";s:15:\"field_inputleng\";s:2:\"50\";s:8:\"form_set\";s:0:\"\";s:10:\"form_value\";s:0:\"\";s:10:\"form_units\";s:0:\"\";s:10:\"form_title\";s:0:\"\";s:8:\"mustfill\";s:1:\"0\";s:6:\"search\";s:1:\"0\";s:9:\"orderlist\";i:6;s:9:\"allowview\";N;}s:15:\"operatingsystem\";a:14:{s:5:\"title\";s:8:\"л\";s:10:\"field_name\";s:15:\"operatingsystem\";s:10:\"field_type\";s:7:\"varchar\";s:10:\"field_leng\";i:150;s:9:\"form_type\";s:4:\"text\";s:15:\"field_inputleng\";s:2:\"60\";s:8:\"form_set\";s:0:\"\";s:10:\"form_value\";s:0:\"\";s:10:\"form_units\";s:0:\"\";s:10:\"form_title\";s:902:\"<br>ƽ̨ѡ<a href=\\\"javascript:ToSystem(\\\'Linux\\\')\\\">Linux</a>/<a href=\\\"javascript:ToSystem(\\\'DOS\\\')\\\">DOS</a>/<a href=\\\"javascript:ToSystem(\\\'9x\\\')\\\">9x</a>/<a href=\\\"javascript:ToSystem(\\\'NT\\\')\\\">NT</a>/<a href=\\\"javascript:ToSystem(\\\'2000\\\')\\\">2000</a>/<a href=\\\"javascript:ToSystem(\\\'2003\\\')\\\">2003</a>/<a href=\\\"javascript:ToSystem(\\\'XP\\\')\\\">XP</a>/<a href=\\\"javascript:ToSystem(\\\'.NET\\\')\\\">.NET</a>/<a href=\\\"javascript:ToSystem(\\\'ASP\\\')\\\">ASP</a>/<a href=\\\"javascript:ToSystem(\\\'PHP\\\')\\\">PHP</a>/<a href=\\\"javascript:ToSystem(\\\'JSP\\\')\\\">JSP</a>/<a href=\\\"javascript:ToSystem(\\\'CGI\\\')\\\">CGI</a>\r\n\r\n<SCRIPT LANGUAGE=\\\"JavaScript\\\">\r\nfunction ToSystem(va){\r\n	cc=document.getElementById(\\\"atc_operatingsystem\\\").value\r\n	if(cc==\\\'\\\'){\r\n		document.getElementById(\\\"atc_operatingsystem\\\").value=va;\r\n	}else{\r\n		document.getElementById(\\\"atc_operatingsystem\\\").value+=\\\"/\\\"+va;\r\n	}\r\n	\r\n}\r\n</SCRIPT>\";s:8:\"mustfill\";s:1:\"0\";s:6:\"search\";s:1:\"0\";s:9:\"orderlist\";i:5;s:9:\"allowview\";N;}s:12:\"softlanguage\";a:14:{s:5:\"title\";s:8:\"\";s:10:\"field_name\";s:12:\"softlanguage\";s:10:\"field_type\";s:7:\"varchar\";s:10:\"field_leng\";i:30;s:9:\"form_type\";s:6:\"select\";s:15:\"field_inputleng\";s:0:\"\";s:8:\"form_set\";s:34:\"\r\n\r\nӢ\r\n\";s:10:\"form_value\";s:0:\"\";s:10:\"form_units\";s:0:\"\";s:10:\"form_title\";s:0:\"\";s:8:\"mustfill\";s:1:\"0\";s:6:\"search\";s:1:\"0\";s:9:\"orderlist\";i:4;s:9:\"allowview\";N;}s:9:\"copyright\";a:14:{s:5:\"title\";s:8:\"Ȩʽ\";s:10:\"field_name\";s:9:\"copyright\";s:10:\"field_type\";s:7:\"varchar\";s:10:\"field_leng\";i:30;s:9:\"form_type\";s:6:\"select\";s:15:\"field_inputleng\";s:0:\"\";s:8:\"form_set\";s:30:\"Ѱ\r\nð\r\nƽ\r\nҵ\";s:10:\"form_value\";s:0:\"\";s:10:\"form_units\";s:0:\"\";s:10:\"form_title\";s:0:\"\";s:8:\"mustfill\";s:1:\"0\";s:6:\"search\";s:1:\"0\";s:9:\"orderlist\";i:3;s:9:\"allowview\";N;}s:8:\"softsize\";a:14:{s:5:\"title\";s:8:\"ļС\";s:10:\"field_name\";s:8:\"softsize\";s:10:\"field_type\";s:7:\"varchar\";s:10:\"field_leng\";i:20;s:9:\"form_type\";s:4:\"text\";s:15:\"field_inputleng\";s:0:\"\";s:8:\"form_set\";s:0:\"\";s:10:\"form_value\";s:0:\"\";s:10:\"form_units\";s:1:\"M\";s:10:\"form_title\";s:0:\"\";s:8:\"mustfill\";s:1:\"0\";s:6:\"search\";s:1:\"0\";s:9:\"orderlist\";i:2;s:9:\"allowview\";N;}s:7:\"softurl\";a:15:{s:5:\"title\";s:8:\"ַ\";s:10:\"field_name\";s:7:\"softurl\";s:10:\"field_type\";s:10:\"mediumtext\";s:10:\"field_leng\";i:0;s:9:\"form_type\";s:10:\"upmorefile\";s:15:\"field_inputleng\";s:0:\"\";s:8:\"form_set\";s:0:\"\";s:10:\"form_value\";s:0:\"\";s:10:\"form_units\";s:0:\"\";s:10:\"form_title\";s:0:\"\";s:8:\"mustfill\";s:1:\"1\";s:6:\"search\";s:1:\"0\";s:10:\"IfListShow\";s:1:\"0\";s:9:\"orderlist\";s:1:\"1\";s:9:\"allowview\";N;}}s:7:\"is_html\";a:0:{}s:9:\"moduleSet\";a:11:{s:5:\"alias\";s:4:\"\";s:10:\"title_name\";s:8:\"\";s:12:\"content_name\";s:8:\"\";s:6:\"edit_w\";s:3:\"600\";s:6:\"edit_h\";s:3:\"300\";s:11:\"description\";s:1:\"1\";s:5:\"etype\";s:1:\"0\";s:8:\"morepage\";s:1:\"1\";s:9:\"no_author\";s:1:\"1\";s:7:\"no_from\";s:1:\"1\";s:10:\"no_fromurl\";s:1:\"1\";}s:5:\"tpldb\";a:5:{s:4:\"post\";s:0:\"\";s:9:\"adminpost\";s:0:\"\";s:4:\"list\";s:0:\"\";s:4:\"show\";s:0:\"\";s:6:\"search\";s:0:\"\";}}','download','0','0');
INSERT INTO `qb_article_module` VALUES ('102','Ƶģ','Ƶ','0','','','','a:4:{s:8:\"field_db\";a:3:{s:5:\"mvurl\";a:15:{s:5:\"title\";s:8:\"߹ۿ\";s:10:\"field_name\";s:5:\"mvurl\";s:10:\"field_type\";s:10:\"mediumtext\";s:10:\"field_leng\";i:0;s:9:\"form_type\";s:8:\"upmoremv\";s:15:\"field_inputleng\";s:0:\"\";s:8:\"form_set\";s:0:\"\";s:10:\"form_value\";s:0:\"\";s:10:\"form_units\";s:0:\"\";s:10:\"form_title\";s:0:\"\";s:8:\"mustfill\";s:1:\"1\";s:6:\"search\";s:1:\"0\";s:10:\"IfListShow\";s:1:\"0\";s:9:\"orderlist\";s:1:\"3\";s:9:\"allowview\";N;}s:7:\"my_role\";a:14:{s:5:\"title\";s:8:\"\";s:10:\"field_name\";s:7:\"my_role\";s:10:\"field_type\";s:7:\"varchar\";s:10:\"field_leng\";i:100;s:9:\"form_type\";s:4:\"text\";s:15:\"field_inputleng\";s:2:\"20\";s:8:\"form_set\";s:0:\"\";s:10:\"form_value\";s:0:\"\";s:10:\"form_units\";s:0:\"\";s:10:\"form_title\";s:0:\"\";s:8:\"mustfill\";s:1:\"0\";s:6:\"search\";s:1:\"0\";s:9:\"orderlist\";i:2;s:9:\"allowview\";N;}s:7:\"my_lang\";a:14:{s:5:\"title\";s:4:\"\";s:10:\"field_name\";s:7:\"my_lang\";s:10:\"field_type\";s:7:\"varchar\";s:10:\"field_leng\";i:20;s:9:\"form_type\";s:6:\"select\";s:15:\"field_inputleng\";s:0:\"\";s:8:\"form_set\";s:26:\"\r\n\r\nӢ\r\n\";s:10:\"form_value\";s:0:\"\";s:10:\"form_units\";s:0:\"\";s:10:\"form_title\";s:0:\"\";s:8:\"mustfill\";s:1:\"0\";s:6:\"search\";s:1:\"0\";s:9:\"orderlist\";i:1;s:9:\"allowview\";N;}}s:7:\"is_html\";a:0:{}s:9:\"moduleSet\";a:11:{s:5:\"alias\";s:4:\"Ƶ\";s:10:\"title_name\";s:8:\"Ƶ\";s:12:\"content_name\";s:8:\"Ƶ\";s:6:\"edit_w\";s:3:\"500\";s:6:\"edit_h\";s:3:\"300\";s:11:\"description\";s:1:\"1\";s:5:\"etype\";s:1:\"0\";s:8:\"morepage\";s:1:\"1\";s:9:\"no_author\";s:1:\"1\";s:7:\"no_from\";s:1:\"1\";s:10:\"no_fromurl\";s:1:\"1\";}s:5:\"tpldb\";a:5:{s:4:\"post\";s:0:\"\";s:9:\"adminpost\";s:0:\"\";s:4:\"list\";s:0:\"\";s:4:\"show\";s:0:\"\";s:6:\"search\";s:0:\"\";}}','mv','0','0');
INSERT INTO `qb_members` VALUES ('1','admin','21232f297a57a5a743894a0e4a801fc3');
INSERT INTO `qb_members` VALUES ('27','test1','e10adc3949ba59abbe56e057f20f883e');
INSERT INTO `qb_members` VALUES ('28','test2','e10adc3949ba59abbe56e057f20f883e');
INSERT INTO `qb_members` VALUES ('29','test3','e10adc3949ba59abbe56e057f20f883e');
INSERT INTO `qb_members` VALUES ('30','test4','e10adc3949ba59abbe56e057f20f883e');
INSERT INTO `qb_members` VALUES ('31','test5','e10adc3949ba59abbe56e057f20f883e');
INSERT INTO `qb_members` VALUES ('32','test6','e10adc3949ba59abbe56e057f20f883e');
INSERT INTO `qb_members` VALUES ('33','test7','e10adc3949ba59abbe56e057f20f883e');
INSERT INTO `qb_members` VALUES ('34','test8','e10adc3949ba59abbe56e057f20f883e');
INSERT INTO `qb_members` VALUES ('35','test9','e10adc3949ba59abbe56e057f20f883e');
INSERT INTO `qb_members` VALUES ('36','test10','e10adc3949ba59abbe56e057f20f883e');
INSERT INTO `qb_members` VALUES ('37','test11','e10adc3949ba59abbe56e057f20f883e');
INSERT INTO `qb_members` VALUES ('38','С','e10adc3949ba59abbe56e057f20f883e');
INSERT INTO `qb_memberdata` VALUES ('1','admin','','','','3','1','','1','0','','3143','0','439529840','7628227','1494656716','127.0.0.1','1253678332','127.0.0.1','1','1890-00-00','http://down.qibosoft.com/other/testv6/upload_files/icon/1.jpg','ҽҽҽ\r\nҽ\r\nҽҽҽҽҽҽҽҽ\r\nҽҽҽҽҽҽҽҽҽҽҽҽҽҽ\r\nҽҽ','337','1490429175','888888','','','qibobb@126.com','0','1','cvbnmmm','510660','13399999999','02028349635','','ѧ','a:1:{s:7:\"endtime\";s:0:\"\";}','7','0','0','0','8.00','301.00','e10adc3949ba59abbe56e057f20f883e','','0');
INSERT INTO `qb_memberdata` VALUES ('37','test11','','','','8','1','','1','0','','5','0','10658','333','1482130156','127.0.0.1','1288663688','127.0.0.1','0','0000-00-00','','','0','0','','','','test11@dew.cn','0','0','','','','','','','a:1:{s:7:\"endtime\";s:0:\"\";}','0','0','0','0','0.00','0.00','','','0');
INSERT INTO `qb_memberdata` VALUES ('36','test10','','','','8','1','','1','0','','5','0','14283','0','1288663488','127.0.0.1','1288663488','127.0.0.1','0','0000-00-00','','','0','0','','','','test10@dsa.cn','0','0','','','','','','','a:1:{s:7:\"endtime\";s:0:\"\";}','0','0','0','0','0.00','0.00','','','0');
INSERT INTO `qb_memberdata` VALUES ('35','test9','','','','8','1','','1','0','','5','0','13302','31','1482130078','127.0.0.1','1288663331','127.0.0.1','0','0000-00-00','','','0','0','','','','test9@dsa.cn','0','0','','','','','','','a:1:{s:7:\"endtime\";s:0:\"\";}','0','0','0','0','0.00','0.00','','','0');
INSERT INTO `qb_memberdata` VALUES ('34','test8','','','','8','1','','1','0','','5','0','10725','83','1482130038','127.0.0.1','1288663154','127.0.0.1','0','0000-00-00','','','0','0','','','','test8@dsa.cm','0','0','','','','','','','a:1:{s:7:\"endtime\";s:0:\"\";}','0','0','0','0','0.00','0.00','','','0');
INSERT INTO `qb_memberdata` VALUES ('33','test7','','','','8','1','','1','0','','5','0','12667','170','1482129946','127.0.0.1','1288663028','127.0.0.1','0','0000-00-00','','','0','0','','','','test7@es.cm','0','0','','','','','','','a:1:{s:7:\"endtime\";s:0:\"\";}','0','0','0','0','0.00','0.00','','','0');
INSERT INTO `qb_memberdata` VALUES ('32','test6','','','','8','1','','1','0','','5','0','144578','284','1482129768','127.0.0.1','1288662836','127.0.0.1','0','0000-00-00','','','0','0','','','','test6@dsa.cn','0','0','','','','','','','a:1:{s:7:\"endtime\";s:0:\"\";}','0','0','0','0','0.00','0.00','','','0');
INSERT INTO `qb_memberdata` VALUES ('31','test5','','','','8','1','','1','0','','5','0','123662','533','1482129726','127.0.0.1','1288662633','127.0.0.1','0','0000-00-00','','','1','1318476018','','','','test5@ds.cn','0','0','','','','','','','a:1:{s:7:\"endtime\";s:0:\"\";}','0','0','0','0','0.00','0.00','','','0');
INSERT INTO `qb_memberdata` VALUES ('30','test4','','','','8','1','','1','0','','5','0','17044','437','1482129391','127.0.0.1','1288662370','127.0.0.1','0','0000-00-00','','','0','0','','','','test4@qq.cn','0','0','','','','','','','a:1:{s:7:\"endtime\";s:0:\"\";}','0','0','0','0','0.00','0.00','','','0');
INSERT INTO `qb_memberdata` VALUES ('29','test3','','','','8','1','','1','0','','5','0','160010','227','1482128863','127.0.0.1','1288662223','127.0.0.1','0','0000-00-00','','','0','0','','','','test3@qq.cn','0','0','','','','','','','a:1:{s:7:\"endtime\";s:0:\"\";}','0','0','0','0','0.00','0.00','','','0');
INSERT INTO `qb_memberdata` VALUES ('28','test2','','','','8','1','','1','0','','5','0','80741','1536','1348795872','127.0.0.1','1288661813','127.0.0.1','0','0000-00-00','','','0','0','','','','test2@qq.cn','0','0','','','','','','','a:1:{s:7:\"endtime\";s:0:\"\";}','0','0','0','0','0.00','0.00','','','0');
INSERT INTO `qb_memberdata` VALUES ('27','test1','','','','8','1','','1','0','','5','0','106781','27050','1482128691','127.0.0.1','1288661559','127.0.0.1','0','0000-00-00','','','3','1340940955','','','','test1@qq.com','0','0','','','','','','','a:1:{s:7:\"endtime\";s:0:\"\";}','0','0','0','0','0.00','0.00','343d9040a671c45832ee5381860e2996','','0');
INSERT INTO `qb_memberdata` VALUES ('38','С','','','','8','0','','1','0','','5','0','0','4777','1462347357','192.168.0.129','1462238368','192.168.0.129','0','0000-00-00','','','1','1462261801','','','','202152752@qq.com','0','0','','','','','','','','0','0','0','0','0.00','0.00','','','0');
INSERT INTO `qb_group` VALUES ('2','1','ο','0','0','0','a:54:{s:10:\"upfileType\";s:0:\"\";s:13:\"upfileMaxSize\";s:0:\"\";s:14:\"PassContribute\";s:1:\"1\";s:17:\"SearchArticleType\";s:1:\"1\";s:16:\"PostArticleYzImg\";s:1:\"1\";s:13:\"EditPassPower\";s:1:\"0\";s:12:\"SetTileColor\";s:1:\"0\";s:14:\"SetSellArticle\";s:1:\"0\";s:17:\"SetSpecialArticle\";s:1:\"0\";s:17:\"SetArticleKeyword\";s:1:\"0\";s:20:\"AddArticleKeywordNum\";s:0:\"\";s:21:\"AddArticleCopyfromNum\";s:0:\"\";s:18:\"SelectArticleStyle\";s:1:\"0\";s:16:\"SelectArticleTpl\";s:1:\"0\";s:13:\"SetArticleTpl\";s:1:\"0\";s:18:\"SetArticlePosttime\";s:1:\"0\";s:18:\"SetArticleViewtime\";s:1:\"0\";s:16:\"SetArticleHitNum\";s:1:\"0\";s:18:\"SetArticlePassword\";s:1:\"0\";s:19:\"SetArticleDownGroup\";s:1:\"0\";s:19:\"SetArticleViewGroup\";s:1:\"0\";s:17:\"SetArticleJumpurl\";s:1:\"0\";s:19:\"SetArticleIframeurl\";s:1:\"0\";s:21:\"SetArticleDescription\";s:1:\"0\";s:16:\"SetArticleTopCom\";s:1:\"0\";s:13:\"SetSmallTitle\";s:1:\"0\";s:19:\"CommentArticleYzImg\";s:1:\"1\";s:17:\"CollectArticleNum\";s:0:\"\";s:15:\"CreatSpecialNum\";s:0:\"\";s:13:\"PostNoDelCode\";s:1:\"0\";s:7:\"SetVote\";s:1:\"0\";s:11:\"SetHtmlName\";s:1:\"0\";s:16:\"PassContributeSP\";s:1:\"0\";s:14:\"AllowUploadMax\";s:1:\"0\";s:11:\"comment_num\";s:2:\"10\";s:10:\"comment_yz\";s:1:\"1\";s:11:\"comment_img\";s:1:\"0\";s:16:\"sell_postauto_yz\";s:1:\"0\";s:15:\"buy_postauto_yz\";s:1:\"0\";s:15:\"post_pingpai_yz\";s:1:\"0\";s:10:\"use2domain\";s:1:\"0\";s:16:\"useHomepageStyle\";s:1:\"0\";s:21:\"view_buy_view_contact\";s:1:\"0\";s:13:\"post_sell_num\";s:0:\"\";s:12:\"post_buy_num\";s:0:\"\";s:13:\"post_news_num\";s:0:\"\";s:14:\"post_photo_num\";s:0:\"\";s:11:\"post_hr_num\";s:0:\"\";s:17:\"post_zhanghui_num\";s:0:\"\";s:12:\"post_ZLG_num\";s:0:\"\";s:16:\"post_pingpai_num\";s:0:\"\";s:19:\"post_baojiadian_num\";s:0:\"\";s:19:\"post_xunjiadian_num\";s:0:\"\";s:24:\"post_info_collection_num\";s:0:\"\";}','0','');
INSERT INTO `qb_group` VALUES ('3','1','Ա','0','0','0','a:43:{s:10:\"upfileType\";s:0:\"\";s:13:\"upfileMaxSize\";s:0:\"\";s:14:\"PassContribute\";s:1:\"1\";s:13:\"EditPassPower\";s:1:\"0\";s:14:\"AllowUploadMax\";s:1:\"1\";s:11:\"comment_num\";s:3:\"999\";s:10:\"comment_yz\";s:1:\"1\";s:11:\"comment_img\";s:1:\"1\";s:16:\"sell_postauto_yz\";s:1:\"0\";s:15:\"buy_postauto_yz\";s:1:\"0\";s:15:\"post_pingpai_yz\";s:1:\"0\";s:10:\"use2domain\";s:1:\"1\";s:16:\"useHomepageStyle\";s:1:\"1\";s:21:\"view_buy_view_contact\";s:1:\"0\";s:13:\"post_sell_num\";s:0:\"\";s:12:\"post_buy_num\";s:0:\"\";s:13:\"post_news_num\";s:3:\"999\";s:14:\"post_photo_num\";s:3:\"999\";s:11:\"post_hr_num\";s:3:\"999\";s:17:\"post_zhanghui_num\";s:0:\"\";s:12:\"post_ZLG_num\";s:0:\"\";s:16:\"post_pingpai_num\";s:0:\"\";s:19:\"post_baojiadian_num\";s:0:\"\";s:19:\"post_xunjiadian_num\";s:0:\"\";s:24:\"post_info_collection_num\";s:3:\"999\";s:18:\"allow_get_homepage\";s:1:\"1\";s:18:\"shoptg_postauto_yz\";s:1:\"1\";s:16:\"shop_postauto_yz\";s:1:\"1\";s:14:\"tg_postauto_yz\";s:1:\"1\";s:14:\"post_coupon_yz\";s:1:\"1\";s:15:\"post_shoptg_num\";s:3:\"999\";s:13:\"post_shop_num\";s:3:\"999\";s:11:\"post_tg_num\";s:3:\"999\";s:15:\"post_coupon_num\";s:3:\"999\";s:13:\"post_gift_num\";s:3:\"999\";s:13:\"postNewsYzImg\";s:1:\"0\";s:13:\"postShopYzImg\";s:1:\"0\";s:11:\"postTgYzImg\";s:1:\"0\";s:15:\"postShopTgYzImg\";s:1:\"0\";s:11:\"postHrYzImg\";s:1:\"0\";s:15:\"postCouponYzImg\";s:1:\"0\";s:13:\"view_hy_money\";s:0:\"\";s:10:\"post_hr_yz\";s:1:\"1\";}','1','a:72:{s:13:\"center_config\";s:1:\"1\";s:17:\"set_comsort_index\";s:1:\"1\";s:8:\"user_reg\";s:1:\"1\";s:12:\"center_cache\";s:1:\"1\";s:19:\"article_more_config\";s:1:\"1\";s:11:\"cache_cache\";s:1:\"1\";s:11:\"comment_set\";s:1:\"1\";s:18:\"setmakeALLhtml_set\";s:1:\"1\";s:11:\"module_list\";s:1:\"1\";s:14:\"article_module\";s:1:\"1\";s:9:\"hack_list\";s:1:\"1\";s:9:\"blend_set\";s:1:\"1\";s:10:\"weixin_api\";s:1:\"1\";s:7:\"appmenu\";s:1:\"1\";s:17:\"weixin_FirstReply\";s:1:\"1\";s:16:\"weixin_autoreply\";s:1:\"1\";s:11:\"weixin_kefu\";s:1:\"1\";s:10:\"weixin_msg\";s:1:\"1\";s:14:\"friendlink_mod\";s:1:\"1\";s:14:\"alonepage_list\";s:1:\"1\";s:12:\"channel_list\";s:1:\"1\";s:9:\"mysql_out\";s:1:\"1\";s:10:\"mysql_into\";s:1:\"1\";s:9:\"mysql_del\";s:1:\"1\";s:9:\"mysql_sql\";s:1:\"1\";s:9:\"menu_list\";s:1:\"1\";s:14:\"adminmenu_list\";s:1:\"1\";s:15:\"membermenu_list\";s:1:\"1\";s:13:\"sort_listsort\";s:1:\"1\";s:15:\"artic_listartic\";s:1:\"1\";s:12:\"comment_list\";s:1:\"1\";s:13:\"artic_postnew\";s:1:\"1\";s:12:\"artic_addpic\";s:1:\"1\";s:18:\"makeindexhtml_make\";s:1:\"1\";s:13:\"makehtml_make\";s:1:\"1\";s:15:\"spmakehtml_make\";s:1:\"1\";s:15:\"setmakehtml_set\";s:1:\"1\";s:11:\"index_label\";s:1:\"1\";s:10:\"s_list_fid\";s:1:\"1\";s:13:\"up_splist_fid\";s:1:\"1\";s:12:\"special_list\";s:1:\"1\";s:15:\"spsort_listsort\";s:1:\"1\";s:13:\"fu_sort_power\";s:1:\"1\";s:14:\"fu_artic_power\";s:1:\"1\";s:11:\"member_list\";s:1:\"1\";s:8:\"regfield\";s:1:\"1\";s:16:\"member_addmember\";s:1:\"1\";s:20:\"article_group_config\";s:1:\"1\";s:10:\"group_list\";s:1:\"1\";s:16:\"group_list_admin\";s:1:\"1\";s:9:\"group_add\";s:1:\"1\";s:10:\"rmb_infull\";s:1:\"1\";s:10:\"rmb_getout\";s:1:\"1\";s:11:\"rmb_consume\";s:1:\"1\";s:10:\"alipay_set\";s:1:\"1\";s:8:\"moneylog\";s:1:\"1\";s:14:\"limitword_list\";s:1:\"1\";s:15:\"attachment_list\";s:1:\"1\";s:14:\"sell_telephone\";s:1:\"1\";s:12:\"message_send\";s:1:\"1\";s:9:\"mail_send\";s:1:\"1\";s:8:\"cnzz_set\";s:1:\"1\";s:13:\"baidu_sitemap\";s:1:\"1\";s:15:\"logs_login_logs\";s:1:\"1\";s:18:\"logs_admin_do_logs\";s:1:\"1\";s:23:\"Module_guestbook_center\";s:1:\"1\";s:21:\"Module_guestbook_sort\";s:1:\"1\";s:24:\"Module_guestbook_content\";s:1:\"1\";s:18:\"Module_form_center\";s:1:\"1\";s:23:\"Module_form_form_module\";s:1:\"1\";s:24:\"Module_form_form_content\";s:1:\"1\";s:6:\"mymenu\";N;}');
INSERT INTO `qb_group` VALUES ('8','0','ͨԱ','0','50','0','a:72:{s:10:\"upfileType\";s:0:\"\";s:13:\"upfileMaxSize\";s:0:\"\";s:14:\"PassContribute\";s:1:\"1\";s:13:\"EditPassPower\";s:1:\"0\";s:17:\"SearchArticleType\";s:1:\"1\";s:12:\"SetTileColor\";s:1:\"0\";s:14:\"SetSellArticle\";s:1:\"0\";s:13:\"SetSmallTitle\";s:1:\"0\";s:17:\"SetSpecialArticle\";s:1:\"1\";s:17:\"SetArticleKeyword\";s:1:\"1\";s:20:\"AddArticleKeywordNum\";s:1:\"0\";s:16:\"PostArticleYzImg\";s:1:\"0\";s:21:\"AddArticleCopyfromNum\";s:1:\"0\";s:16:\"SelectArticleTpl\";s:1:\"0\";s:13:\"SetArticleTpl\";s:1:\"0\";s:18:\"SelectArticleStyle\";s:1:\"0\";s:18:\"SetArticlePosttime\";s:1:\"0\";s:18:\"SetArticleViewtime\";s:1:\"0\";s:16:\"SetArticleHitNum\";s:1:\"0\";s:18:\"SetArticlePassword\";s:1:\"0\";s:19:\"SetArticleDownGroup\";s:1:\"0\";s:19:\"SetArticleViewGroup\";s:1:\"0\";s:17:\"SetArticleJumpurl\";s:1:\"0\";s:19:\"SetArticleIframeurl\";s:1:\"0\";s:21:\"SetArticleDescription\";s:1:\"0\";s:16:\"SetArticleTopCom\";s:1:\"0\";s:17:\"CollectArticleNum\";s:2:\"30\";s:15:\"CreatSpecialNum\";s:1:\"7\";s:19:\"CommentArticleYzImg\";s:1:\"1\";s:11:\"SetHtmlName\";s:1:\"0\";s:7:\"SetVote\";s:1:\"1\";s:16:\"PassContributeSP\";s:1:\"0\";s:13:\"PostNoDelCode\";s:1:\"0\";s:14:\"AllowUploadMax\";s:1:\"0\";s:11:\"comment_num\";s:0:\"\";s:10:\"comment_yz\";s:1:\"0\";s:11:\"comment_img\";s:1:\"0\";s:16:\"sell_postauto_yz\";s:1:\"1\";s:15:\"buy_postauto_yz\";s:1:\"1\";s:15:\"post_pingpai_yz\";s:1:\"1\";s:10:\"use2domain\";s:1:\"0\";s:16:\"useHomepageStyle\";s:1:\"1\";s:21:\"view_buy_view_contact\";s:1:\"0\";s:13:\"post_sell_num\";s:1:\"5\";s:12:\"post_buy_num\";s:1:\"5\";s:13:\"post_news_num\";s:1:\"5\";s:14:\"post_photo_num\";s:2:\"10\";s:11:\"post_hr_num\";s:1:\"5\";s:17:\"post_zhanghui_num\";s:1:\"5\";s:12:\"post_ZLG_num\";s:1:\"0\";s:16:\"post_pingpai_num\";s:1:\"5\";s:19:\"post_baojiadian_num\";s:1:\"5\";s:19:\"post_xunjiadian_num\";s:1:\"5\";s:24:\"post_info_collection_num\";s:2:\"30\";s:18:\"allow_get_homepage\";s:1:\"1\";s:16:\"shop_postauto_yz\";s:1:\"1\";s:14:\"tg_postauto_yz\";s:1:\"1\";s:14:\"post_coupon_yz\";s:1:\"1\";s:13:\"post_shop_num\";s:1:\"5\";s:11:\"post_tg_num\";s:1:\"3\";s:15:\"post_coupon_num\";s:1:\"3\";s:13:\"post_gift_num\";s:1:\"0\";s:18:\"shoptg_postauto_yz\";s:1:\"0\";s:15:\"post_shoptg_num\";s:0:\"\";s:13:\"postNewsYzImg\";s:1:\"1\";s:13:\"view_hy_money\";s:0:\"\";s:13:\"postShopYzImg\";s:1:\"1\";s:11:\"postTgYzImg\";s:1:\"1\";s:15:\"postShopTgYzImg\";s:1:\"1\";s:11:\"postHrYzImg\";s:1:\"1\";s:15:\"postCouponYzImg\";s:1:\"1\";s:10:\"post_hr_yz\";s:1:\"1\";}','0','');
INSERT INTO `qb_group` VALUES ('9','0','VIPԱ','10000','0','0','a:71:{s:17:\"SearchArticleType\";s:1:\"0\";s:16:\"PostArticleYzImg\";s:1:\"0\";s:14:\"PassContribute\";s:1:\"1\";s:13:\"EditPassPower\";s:1:\"0\";s:12:\"SetTileColor\";s:1:\"0\";s:14:\"SetSellArticle\";s:1:\"0\";s:17:\"SetSpecialArticle\";s:1:\"0\";s:17:\"SetArticleKeyword\";s:1:\"0\";s:20:\"AddArticleKeywordNum\";s:0:\"\";s:21:\"AddArticleCopyfromNum\";s:0:\"\";s:18:\"SelectArticleStyle\";s:1:\"0\";s:16:\"SelectArticleTpl\";s:1:\"0\";s:13:\"SetArticleTpl\";s:1:\"0\";s:18:\"SetArticlePosttime\";s:1:\"0\";s:18:\"SetArticleViewtime\";s:1:\"0\";s:16:\"SetArticleHitNum\";s:1:\"0\";s:18:\"SetArticlePassword\";s:1:\"0\";s:19:\"SetArticleDownGroup\";s:1:\"0\";s:19:\"SetArticleViewGroup\";s:1:\"0\";s:17:\"SetArticleJumpurl\";s:1:\"0\";s:19:\"SetArticleIframeurl\";s:1:\"0\";s:21:\"SetArticleDescription\";s:1:\"0\";s:16:\"SetArticleTopCom\";s:1:\"0\";s:13:\"SetSmallTitle\";s:1:\"0\";s:19:\"CommentArticleYzImg\";s:1:\"0\";s:17:\"CollectArticleNum\";s:0:\"\";s:15:\"CreatSpecialNum\";s:0:\"\";s:14:\"AllowUploadMax\";s:1:\"0\";s:10:\"upfileType\";s:0:\"\";s:13:\"upfileMaxSize\";s:0:\"\";s:11:\"comment_num\";s:2:\"30\";s:10:\"comment_yz\";s:1:\"0\";s:11:\"comment_img\";s:1:\"1\";s:16:\"sell_postauto_yz\";s:1:\"1\";s:15:\"buy_postauto_yz\";s:1:\"1\";s:15:\"post_pingpai_yz\";s:1:\"1\";s:10:\"use2domain\";s:1:\"1\";s:16:\"useHomepageStyle\";s:1:\"1\";s:21:\"view_buy_view_contact\";s:1:\"1\";s:9:\"topmyinfo\";s:0:\"\";s:12:\"topmyinfoday\";s:0:\"\";s:13:\"topcompanyday\";s:0:\"\";s:13:\"post_sell_num\";s:2:\"50\";s:12:\"post_buy_num\";s:2:\"50\";s:13:\"post_news_num\";s:2:\"50\";s:14:\"post_photo_num\";s:3:\"100\";s:11:\"post_hr_num\";s:2:\"20\";s:17:\"post_zhanghui_num\";s:2:\"20\";s:12:\"post_ZLG_num\";s:1:\"5\";s:19:\"post_baojiadian_num\";s:2:\"50\";s:19:\"post_xunjiadian_num\";s:2:\"50\";s:16:\"post_pingpai_num\";s:2:\"10\";s:24:\"post_info_collection_num\";s:3:\"100\";s:18:\"allow_get_homepage\";s:1:\"1\";s:16:\"shop_postauto_yz\";s:1:\"1\";s:14:\"tg_postauto_yz\";s:1:\"1\";s:14:\"post_coupon_yz\";s:1:\"1\";s:13:\"post_shop_num\";s:3:\"100\";s:11:\"post_tg_num\";s:2:\"50\";s:15:\"post_coupon_num\";s:2:\"50\";s:13:\"post_gift_num\";s:1:\"0\";s:13:\"postNewsYzImg\";s:1:\"0\";s:13:\"postShopYzImg\";s:1:\"0\";s:11:\"postTgYzImg\";s:1:\"0\";s:15:\"postShopTgYzImg\";s:1:\"0\";s:11:\"postHrYzImg\";s:1:\"0\";s:15:\"postCouponYzImg\";s:1:\"0\";s:18:\"shoptg_postauto_yz\";s:1:\"1\";s:15:\"post_shoptg_num\";s:0:\"\";s:13:\"view_hy_money\";s:0:\"\";s:10:\"post_hr_yz\";s:1:\"1\";}','0','');
INSERT INTO `qb_group` VALUES ('10','0','ʯԱ','30000','0','0','a:67:{s:17:\"SearchArticleType\";s:1:\"0\";s:19:\"CommentArticleYzImg\";s:1:\"0\";s:17:\"CollectArticleNum\";s:0:\"\";s:15:\"CreatSpecialNum\";s:0:\"\";s:16:\"PassContributeSP\";s:1:\"0\";s:16:\"PostArticleYzImg\";s:1:\"0\";s:14:\"PassContribute\";s:1:\"1\";s:13:\"EditPassPower\";s:1:\"0\";s:13:\"PostNoDelCode\";s:1:\"0\";s:7:\"SetVote\";s:1:\"0\";s:12:\"SetTileColor\";s:1:\"0\";s:14:\"SetSellArticle\";s:1:\"0\";s:18:\"SelectArticleStyle\";s:1:\"0\";s:16:\"SelectArticleTpl\";s:1:\"0\";s:13:\"SetArticleTpl\";s:1:\"0\";s:18:\"SetArticlePosttime\";s:1:\"0\";s:18:\"SetArticleViewtime\";s:1:\"0\";s:16:\"SetArticleHitNum\";s:1:\"0\";s:18:\"SetArticlePassword\";s:1:\"0\";s:19:\"SetArticleDownGroup\";s:1:\"0\";s:19:\"SetArticleViewGroup\";s:1:\"0\";s:17:\"SetArticleJumpurl\";s:1:\"0\";s:19:\"SetArticleIframeurl\";s:1:\"0\";s:21:\"SetArticleDescription\";s:1:\"0\";s:16:\"SetArticleTopCom\";s:1:\"0\";s:11:\"SetHtmlName\";s:1:\"0\";s:14:\"AllowUploadMax\";s:1:\"0\";s:10:\"upfileType\";s:0:\"\";s:13:\"upfileMaxSize\";s:0:\"\";s:11:\"comment_num\";s:0:\"\";s:10:\"comment_yz\";s:1:\"1\";s:11:\"comment_img\";s:1:\"1\";s:16:\"sell_postauto_yz\";s:1:\"1\";s:15:\"buy_postauto_yz\";s:1:\"1\";s:15:\"post_pingpai_yz\";s:1:\"1\";s:10:\"use2domain\";s:1:\"1\";s:16:\"useHomepageStyle\";s:1:\"1\";s:21:\"view_buy_view_contact\";s:1:\"1\";s:13:\"post_sell_num\";s:3:\"100\";s:12:\"post_buy_num\";s:3:\"100\";s:13:\"post_news_num\";s:3:\"100\";s:14:\"post_photo_num\";s:3:\"100\";s:11:\"post_hr_num\";s:3:\"100\";s:17:\"post_zhanghui_num\";s:3:\"100\";s:12:\"post_ZLG_num\";s:2:\"10\";s:16:\"post_pingpai_num\";s:2:\"10\";s:19:\"post_baojiadian_num\";s:3:\"100\";s:19:\"post_xunjiadian_num\";s:3:\"100\";s:24:\"post_info_collection_num\";s:3:\"300\";s:18:\"allow_get_homepage\";s:1:\"1\";s:16:\"shop_postauto_yz\";s:1:\"1\";s:14:\"tg_postauto_yz\";s:1:\"1\";s:14:\"post_coupon_yz\";s:1:\"1\";s:13:\"post_shop_num\";s:3:\"200\";s:11:\"post_tg_num\";s:3:\"100\";s:15:\"post_coupon_num\";s:2:\"50\";s:13:\"post_gift_num\";s:1:\"1\";s:13:\"postNewsYzImg\";s:1:\"0\";s:13:\"postShopYzImg\";s:1:\"0\";s:11:\"postTgYzImg\";s:1:\"0\";s:15:\"postShopTgYzImg\";s:1:\"0\";s:11:\"postHrYzImg\";s:1:\"0\";s:15:\"postCouponYzImg\";s:1:\"0\";s:18:\"shoptg_postauto_yz\";s:1:\"0\";s:10:\"post_hr_yz\";s:1:\"1\";s:15:\"post_shoptg_num\";s:0:\"\";s:13:\"view_hy_money\";s:0:\"\";}','0','');
INSERT INTO `qb_menu` VALUES ('9','0','','/list.php?fid=1','','0','0','0','0','18','');
INSERT INTO `qb_menu` VALUES ('10','0','ͼƬ','/list.php?fid=9','','0','0','0','0','16','');
INSERT INTO `qb_menu` VALUES ('11','0','ר','/do/listsp.php?fid=1','','0','0','0','0','14','');
INSERT INTO `qb_menu` VALUES ('12','0','','/list.php?fid=12','','0','0','0','0','12','');
INSERT INTO `qb_menu` VALUES ('51','0','ҳ','/','','0','0','0','0','20','');
INSERT INTO `qb_menu` VALUES ('90','0','Ƶ','/list.php?fid=14','','0','0','0','0','0','');
INSERT INTO `qb_menu` VALUES ('91','0','ÿ','/guestbook/','','0','0','0','0','0','');
INSERT INTO `qb_menu` VALUES ('92','0','վ','/do/friendlink.php','','0','0','0','0','0','');
INSERT INTO `qb_admin_menu` VALUES ('12','0','ݹ','','','0','8','3','0','0');
INSERT INTO `qb_admin_menu` VALUES ('83','0','ǩ/ģ/̬ҳ','','','0','9','3','0','0');
INSERT INTO `qb_admin_menu` VALUES ('84','83','</a>\r\n<font color=\"#FF0000\">ҳ</font><img src=../images/default/article_elite.gif> <a href=\"../index.php?&ch=1&chtype=0&jobs=show\" target=\"main\">ǩ</a> <A HREF=\'../index.php?&ch=1&MakeIndex=1\' target=\'_blank\' onclick=\"return confirm(\'ȷʵҪҳɾ̬?ɾ̬,и,Ҫµһξ̬.ſԿЧ.\');\">̬</a> <a href=\"index.php?lfj=channel&job=list_fid&onlyshow=style\" target=\"main\"></a><a> ','#','','0','4','3','0','0');
INSERT INTO `qb_admin_menu` VALUES ('85','83','</a>\r\n<a href=\'index.php?lfj=channel&job=list_fid&onlyshow=label\' target=\'main\'><font color=\"#FF0000\"><u>Ŀ</u></font></a><img src=../images/default/article_elite.gif> <a href=\"../do/job.php?job=jump&pagetype=list_label\" target=\"main\">ǩ</a> <A HREF=\'index.php?lfj=html&job=list\' target=\"main\">̬</a> <a href=\"index.php?lfj=channel&job=list_fid&onlyshow=style\" target=\"main\"></a><a> ','#','','0','3','3','0','0');
INSERT INTO `qb_admin_menu` VALUES ('86','83','</a>\r\n<font color=\"#FF0000\">ר</font><img src=../images/default/article_elite.gif> <a href=\"index.php?lfj=special&job=list&onlyshow=label\" target=\"main\">ǩ</a> <A HREF=\'index.php?lfj=html&job=listsp\' target=\"main\">̬</a> <a href=\"index.php?lfj=special&job=list&onlyshow=style\" target=\"main\"></a><a> ','#','','0','1','3','0','0');
INSERT INTO `qb_admin_menu` VALUES ('87','0','Աع','','','0','7','3','0','0');
INSERT INTO `qb_admin_menu` VALUES ('88','87','ԱϹ','index.php?lfj=member&job=list','','0','0','3','0','0');
INSERT INTO `qb_admin_menu` VALUES ('89','87','Ȩ','index.php?lfj=article_group&job=list','','0','0','3','0','0');
INSERT INTO `qb_admin_menu` VALUES ('90','87','Ȩ','index.php?lfj=group&job=list','','0','0','3','1','0');
INSERT INTO `qb_admin_menu` VALUES ('91','87','Ա̨Ȩ','index.php?lfj=group&job=list_admin','','0','0','3','0','0');
INSERT INTO `qb_admin_menu` VALUES ('73','12','ר','index.php?lfj=special&job=list','','0','13','3','0','0');
INSERT INTO `qb_admin_menu` VALUES ('74','12','۹','index.php?lfj=comment&job=list','','0','12','3','1','0');
INSERT INTO `qb_admin_menu` VALUES ('75','12','</a>\r\n<font color=\"#FF0000\"></font><img src=../images/default/article_elite.gif> <a href=\"index.php?lfj=post&job=postnew&only=1&mid=0\" target=\"main\"></a> <a href=\"index.php?lfj=artic&job=listartic&mid=0&only=1\" target=\"main\"></a> <a href=\"index.php?lfj=sort&job=listsort&mid=0&only=1\" target=\"main\">Ŀ</a><a> ','#','','0','20','3','0','0');
INSERT INTO `qb_admin_menu` VALUES ('76','12','</a>\r\n<font color=\"#FF0000\">ͼƬ</font><img src=../images/default/article_elite.gif> <a href=\"index.php?lfj=post&job=postnew&only=1&mid=100\" target=\"main\"></a> <a href=\"index.php?lfj=artic&job=listartic&mid=100&only=1\" target=\"main\"></a> <a href=\"index.php?lfj=sort&job=listsort&mid=100&only=1\" target=\"main\">Ŀ</a><a> ','#','','0','19','3','0','0');
INSERT INTO `qb_admin_menu` VALUES ('77','12','</a>\r\n<font color=\"#FF0000\"></font><img src=../images/default/article_elite.gif> <a href=\"index.php?lfj=post&job=postnew&only=1&mid=101\" target=\"main\"></a> <a href=\"index.php?lfj=artic&job=listartic&mid=101&only=1\" target=\"main\"></a> <a href=\"index.php?lfj=sort&job=listsort&mid=101&only=1\" target=\"main\">Ŀ</a><a> ','#','','0','18','3','0','0');
INSERT INTO `qb_admin_menu` VALUES ('78','12','</a>\r\n<font color=\"#FF0000\">Ƶ</font><img src=../images/default/article_elite.gif> <a href=\"index.php?lfj=post&job=postnew&only=1&mid=102\" target=\"main\"></a> <a href=\"index.php?lfj=artic&job=listartic&mid=102&only=1\" target=\"main\"></a> <a href=\"index.php?lfj=sort&job=listsort&mid=102&only=1\" target=\"main\">Ŀ</a><a> ','#','','0','17','3','0','0');
INSERT INTO `qb_admin_menu` VALUES ('92','0','ϵͳ','','','0','6','3','0','0');
INSERT INTO `qb_admin_menu` VALUES ('93','92','ȫֲ','index.php?lfj=center&job=config','','0','0','3','0','0');
INSERT INTO `qb_admin_menu` VALUES ('94','92','վ˵','index.php?lfj=guidemenu&job=list','','0','0','3','0','0');
INSERT INTO `qb_admin_menu` VALUES ('95','92','վģ͹','index.php?lfj=article_module&job=list','','0','0','3','0','0');
INSERT INTO `qb_admin_menu` VALUES ('96','92','ӹ','index.php?lfj=friendlink&job=list','','0','0','3','0','0');
INSERT INTO `qb_admin_menu` VALUES ('97','92','ҳ','index.php?lfj=alonepage&job=list','','0','0','3','0','0');
INSERT INTO `qb_admin_menu` VALUES ('98','92','վݿ','index.php?lfj=mysql&job=out','','0','0','3','0','0');
INSERT INTO `qb_admin_menu` VALUES ('100','92','¹Ҫ','index.php?lfj=article_more&job=config','','0','0','3','0','0');
INSERT INTO `qb_admin_menu` VALUES ('101','83','</a>\r\n<font color=\"#FF0000\"></font><img src=../images/default/article_elite.gif> <a href=\"../do/job.php?job=jump&pagetype=bencandy_label\" target=\"main\">ҳǩ</a>\r\n<a> ','#','','0','2','3','0','0');
INSERT INTO `qb_admin_menu` VALUES ('102','0','˵','','','0','0','-3','0','0');
INSERT INTO `qb_module` VALUES ('16','2','ҳ','hy_','hy','','','a:7:{s:12:\"list_PhpName\";s:18:\"list.php?&fid=$fid\";s:12:\"show_PhpName\";s:29:\"bencandy.php?&fid=$fid&id=$id\";s:8:\"MakeHtml\";N;s:14:\"list_HtmlName1\";N;s:14:\"show_HtmlName1\";N;s:14:\"list_HtmlName2\";N;s:14:\"show_HtmlName2\";N;}','100','','','1','1');
INSERT INTO `qb_module` VALUES ('29','2','̳ϵͳ','shop_','shop','','','a:7:{s:12:\"list_PhpName\";s:18:\"list.php?&fid=$fid\";s:12:\"show_PhpName\";s:29:\"bencandy.php?&fid=$fid&id=$id\";s:8:\"MakeHtml\";N;s:14:\"list_HtmlName1\";N;s:14:\"show_HtmlName1\";N;s:14:\"list_HtmlName2\";N;s:14:\"show_HtmlName2\";N;}','99','','','1','1');
INSERT INTO `qb_module` VALUES ('20','2','Ѷ','news_','news','','','a:7:{s:12:\"list_PhpName\";s:18:\"list.php?&fid=$fid\";s:12:\"show_PhpName\";s:29:\"bencandy.php?&fid=$fid&id=$id\";s:8:\"MakeHtml\";N;s:14:\"list_HtmlName1\";N;s:14:\"show_HtmlName1\";N;s:14:\"list_HtmlName2\";N;s:14:\"show_HtmlName2\";N;}','98','','','1','1');
INSERT INTO `qb_module` VALUES ('21','2','̼Ҷ̬','picmsg_','picmsg','','','a:7:{s:12:\"list_PhpName\";s:18:\"list.php?&fid=$fid\";s:12:\"show_PhpName\";s:29:\"bencandy.php?&fid=$fid&id=$id\";s:8:\"MakeHtml\";N;s:14:\"list_HtmlName1\";N;s:14:\"show_HtmlName1\";N;s:14:\"list_HtmlName2\";N;s:14:\"show_HtmlName2\";N;}','102','','','1','1');
INSERT INTO `qb_module` VALUES ('18','2','Ա','guestbook_','guestbook','','','','0','','','0','0');
INSERT INTO `qb_module` VALUES ('30','2','ܱ','form_','form','','','','0','','','0','0');
INSERT INTO `qb_fu_sort` VALUES ('1','0','0','444','1','0','1','','0','0','','','','','','','0','','','1','','','','','0','','','','','');
INSERT INTO `qb_special` VALUES ('10','1','ҳõƬ','','','','a:3:{s:4:\"head\";s:0:\"\";s:4:\"foot\";s:0:\"\";s:8:\"bencandy\";s:0:\"\";}','','','7,142,184,248,250,249','3,8,9,10,11,6,12,14,13,5,7,4','','0','1','admin','1237382603','1237382603','25','1290130070','0','0','','','3,4','1','','1');
INSERT INTO `qb_special` VALUES ('11','1','ҳͷ','',' ʱ','','a:3:{s:4:\"head\";s:0:\"\";s:4:\"foot\";s:0:\"\";s:8:\"bencandy\";s:0:\"\";}','','','7,142,184,248,250,249','3,8,9,10,11,6,12,14,13,5,7,4','','0','1','admin','1237382706','1237382706','103','1290130075','0','1238675329','','','3,4','1','','1');
INSERT INTO `qb_special` VALUES ('19','1','ϣ˹ź¶','','','','a:3:{s:4:\"head\";s:25:\"template/default/none.htm\";s:4:\"foot\";s:25:\"template/default/none.htm\";s:8:\"bencandy\";s:34:\"template/special/special_sport.htm\";}','special/1_20101119091108_agkc8.jpg','˹ŵϣ˹Ӷһչյнϣ˹ûбΪ򡱣ֻ6²11·ط̳ϣ˹Υֶ̽ΪԼδܼʱϱĹʧ75000Ӣԭ-Զֹμ˹ŵ\r\n','561,562,563,564','','','0','1','admin','1240114393','1240124310','265','1494644518','1','1240116319','','','','0','','1');
INSERT INTO `qb_special` VALUES ('20','1','Ӣ࿨÷2010û','','','','a:3:{s:4:\"head\";s:25:\"template/default/none.htm\";s:4:\"foot\";s:25:\"template/default/none.htm\";s:8:\"bencandy\";s:24:\"template/special/sp1.htm\";}','special/1_20101122161134_u6aeu.jpg','磬Ӣά÷һзʱ󣬲ڱѧ칫¥÷ݽǿйҵķչвһֻӢҪڸǿ\r\n\r\nά÷43굱ѡӢ53࣬Ӣ1812ࡣѧǴά÷κ״ηû48СʱгеҪһվ\r\n','595,596,597,598,599,600,601','23,25,26,27,28,29,30,31','','0','1','admin','1240116689','1240116689','306','1494644509','1','1240117139','','','','0','','1');
INSERT INTO `qb_special` VALUES ('21','1','۽ʸĸٽƽó׷','','','','a:3:{s:4:\"head\";s:25:\"template/default/none.htm\";s:4:\"foot\";s:25:\"template/default/none.htm\";s:8:\"bencandy\";s:36:\"template/special/special_finance.htm\";}','special/1_20101122151126_wvvvp.jpg','Ժ2934879ͶƱͨʸĸٽƽó׷ּڶν͹һʵĹر˰һΪǽóױµ֡','587,590,591,593,594,595,596,598','23,24,25,26,28,29,27,30,31','','0','1','admin','1240120502','1240120502','285','1494644513','1','1240121484','','','','0','','1');
INSERT INTO `qb_special` VALUES ('22','1','µA3 Ŀͬڳ͵','','','','a:3:{s:4:\"head\";s:25:\"template/default/none.htm\";s:4:\"foot\";s:25:\"template/default/none.htm\";s:8:\"bencandy\";s:32:\"template/special/special_car.htm\";}','special/1_20101119161104_fdxqf.jpg','   µA3 SportbackѾʽУͬгУͬΪڳ͵ı1ϵԼڵпĿͲʵڼ۸ϻǳ϶ǰµA3ľ\r\n','597,595','31,30,29,28,20,21,22,23,27,26,25,24','','0','1','admin','1240121828','1240121828','335','1494644474','1','1240122051','','','','0','','1');
INSERT INTO `qb_special` VALUES ('24','1','ɳкͳɹйCEO','','','','a:3:{s:4:\"head\";s:0:\"\";s:4:\"foot\";s:0:\"\";s:8:\"bencandy\";s:28:\"template/default/showsp2.htm\";}','special/1_20090419140403_B36H1.jpg','̫ĹºֵЩûɹʿο\r\nǻѾɹЩڳɳУ죬ǶѾӢۡ','583,584,585,586,594,595,597,598,600,601','17,19,28,29,31,30,20,21,22,23,24,27,26,25','','0','1','admin','1240124312','1240124312','338','1494648274','1','1240125051','','special/1_20090419150403_aMUbN.jpg','','0','','1');
INSERT INTO `qb_special` VALUES ('23','1','й۵ο','','','','a:3:{s:4:\"head\";s:25:\"template/default/none.htm\";s:4:\"foot\";s:25:\"template/default/none.htm\";s:8:\"bencandy\";s:28:\"template/special/showsp2.htm\";}','special/1_20090419140451_9nuT0.jpg','Ǵҵȳӿ죬ǽΣȻĽ죬\r\nõļӦʼǲҵչ֮ءֻڶõĻشҲڲͣ任\r\nΪһţǻθıǵCEOǿĲҵδеʲôһ\r\n20092ѶƼƻ߷ðλITCEOCTOǵĴһһΪѳ','597,598','17,19,18,23,20,21,22,27,28,26,25,24','','0','1','admin','1240122281','1240122281','33','1494644467','1','1240122359','','special/1_20090419150453_IGx32.jpg','','0','','1');
INSERT INTO `qb_spsort` VALUES ('1','0','ʱר','1','0','1','','0','0','','','','','a:4:{s:4:\"head\";s:0:\"\";s:4:\"foot\";s:0:\"\";s:4:\"list\";s:0:\"\";s:8:\"bencandy\";s:0:\"\";}','','0','','','0','','','','','0','a:4:{s:11:\"sonTitleRow\";N;s:12:\"sonTitleLeng\";N;s:9:\"cachetime\";N;s:12:\"sonListorder\";N;}','','');
INSERT INTO `qb_spsort` VALUES ('2','0','ר','1','0','1','','0','0','','','fff','','a:4:{s:4:\"head\";s:0:\"\";s:4:\"foot\";s:0:\"\";s:4:\"list\";s:0:\"\";s:8:\"bencandy\";s:0:\"\";}','','0','33','','0','','','','','0','a:4:{s:11:\"sonTitleRow\";N;s:12:\"sonTitleLeng\";N;s:9:\"cachetime\";N;s:12:\"sonListorder\";N;}','','');
INSERT INTO `qb_spsort` VALUES ('3','0','2008̵','1','0','1','','0','0','','','','','','','0','','','1','','','','','0','','','');
INSERT INTO `qb_alonepage` VALUES ('1','0','','','1322183267','0','','','','','','friendlink.htm','','ӭҼ','¼','<table cellSpacing=4 cellPadding=4 width=\"100%\" border=0>\r\n<tbody>\r\n<tr>\r\n<td width=\"20%\"><a href=\"http://www.mmcbbs.com/\" target=_blank>ݼݼ̳</a></td>\r\n<td width=\"20%\"><a href=\"http://www.liuv.net/\" target=_blank>ˮ</a></td>\r\n<td width=\"20%\"><a href=\"http://pic.goodod.com/\" target=_blank>ŷֻͼƬ</a></td>\r\n<td width=\"20%\"><a href=\"http://www.tianyakezhan.com/\" target=_blank>Ŀջ</a></td>\r\n<td width=\"20%\"><a href=\"http://www.czin.cn/\" target=_blank></a></td></tr>\r\n<tr>\r\n<td width=\"20%\"><a href=\"http://www.jneg.com.cn/\" target=_blank>ܼ԰</a></td>\r\n<td width=\"20%\"><a href=\"http://www.wyrj.com/\" target=_blank>˼</a></td>\r\n<td width=\"20%\"><a href=\"http://www.nenbei.com/\" target=_blank>۱</a></td>\r\n<td width=\"20%\"><a href=\"http://www.photosbar.com/\" target=_blank>ͼ</a></td>\r\n<td width=\"20%\"><a href=\"http://www.ok586.cn/\" target=_blank></a></td></tr>\r\n<tr>\r\n<td width=\"20%\"><a href=\"http://www.51solo.net/\" target=_blank>Ұ</a></td>\r\n<td width=\"20%\"><a href=\"http://www.toopd.com/\" target=_blank></a></td>\r\n<td width=\"20%\"><a href=\"http://www.qiqig.com/\" target=_blank></a></td>\r\n<td width=\"20%\"><a href=\"http://www.jxsrjys.com.cn/\" target=_blank>Ľ</a></td>\r\n<td width=\"20%\"><a href=\"http://www.unok.net/\" target=_blank></a></td></tr>\r\n<tr>\r\n<td width=\"20%\"><a href=\"http://mmm.pudou.com/\" target=_blank>˶й</a></td>\r\n<td width=\"20%\"><a href=\"http://www.itzhan.com/\" target=_blank>IT</a></td>\r\n<td width=\"20%\"><a href=\"http://www.hkwtv.com/\" target=_blank></a></td>\r\n<td width=\"20%\">&nbsp;</td>\r\n<td width=\"20%\">&nbsp;</td></tr></tbody></table>','198','0','0');
INSERT INTO `qb_channel` VALUES ('1','0','0','վҳ','./','','index.htm','35,4,3,39','','','','','','','','','','0','a:5:{s:4:\"line\";s:1:\"3\";s:4:\"rows\";s:1:\"8\";s:4:\"leng\";s:2:\"34\";s:5:\"order\";s:4:\"list\";s:8:\"fid_list\";N;}');
INSERT INTO `qb_collection` VALUES ('1','583','1','1490428786');
INSERT INTO `qb_comment` VALUES ('2','566','39','1','1','admin','1289286118','̷ܽǳ.ҶҪ,ڵѽ\\','127.0.0.1','1','1','0','0','0','0');
INSERT INTO `qb_comment` VALUES ('3','567','39','1','1','admin','1289286144','Ҫڵɹ,ʵսҪ!','127.0.0.1','1','1','0','0','0','0');
INSERT INTO `qb_config` VALUES ('yzImgComment','0','');
INSERT INTO `qb_config` VALUES ('flashtime','0','');
INSERT INTO `qb_config` VALUES ('showComment','1','');
INSERT INTO `qb_config` VALUES ('forbidComment','0','');
INSERT INTO `qb_config` VALUES ('showCommentRows','8','');
INSERT INTO `qb_config` VALUES ('viewNoPassGuestBook','1','');
INSERT INTO `qb_config` VALUES ('yzImgContribute','0','');
INSERT INTO `qb_config` VALUES ('groupPassContribute','3','');
INSERT INTO `qb_config` VALUES ('MaxOnlineUser','1000','');
INSERT INTO `qb_config` VALUES ('groupPassShopYz','3,4','');
INSERT INTO `qb_config` VALUES ('groupPassPassGuestBook','3','');
INSERT INTO `qb_config` VALUES ('ifOpenGuestBook','1','');
INSERT INTO `qb_config` VALUES ('yzImgGuestBook','1','');
INSERT INTO `qb_config` VALUES ('ContributeFid','2','');
INSERT INTO `qb_config` VALUES ('groupPassLogYz','3,4','');
INSERT INTO `qb_config` VALUES ('PostSortStep','2','');
INSERT INTO `qb_config` VALUES ('ListSonline','2','');
INSERT INTO `qb_config` VALUES ('_Notice','29weSgiaHR0cDovL3d3dy5xaWJvc29mdC5jb20vTm90aWNlLz91cmw9JHdlYmRiW3d3d191cmxdIixQSFAxNjhfUEFUSC4iY2FjaGUvTm90aWNlLnBocCIpOw==','');
INSERT INTO `qb_config` VALUES ('CommentTime','5','');
INSERT INTO `qb_config` VALUES ('weburl','/','');
INSERT INTO `qb_config` VALUES ('MailType','smtp','');
INSERT INTO `qb_config` VALUES ('sms_wi_pwd','3','');
INSERT INTO `qb_config` VALUES ('tenpay_id','','');
INSERT INTO `qb_config` VALUES ('allowMemberCommentPass','1','');
INSERT INTO `qb_config` VALUES ('AvoidGatherPre','','');
INSERT INTO `qb_config` VALUES ('AvoidCopy','0','');
INSERT INTO `qb_config` VALUES ('AvoidGather','0','');
INSERT INTO `qb_config` VALUES ('AvoidSave','0','');
INSERT INTO `qb_config` VALUES ('waterAlpha','80','');
INSERT INTO `qb_config` VALUES ('adminPostEditType','html','');
INSERT INTO `qb_config` VALUES ('article_show_step','0','');
INSERT INTO `qb_config` VALUES ('ifContribute','1','');
INSERT INTO `qb_config` VALUES ('allowGuestSearch','0','');
INSERT INTO `qb_config` VALUES ('kill_badword','0','');
INSERT INTO `qb_config` VALUES ('ShowKeywordColor','#F70968','');
INSERT INTO `qb_config` VALUES ('ifShowKeyword','1','');
INSERT INTO `qb_config` VALUES ('UseFtp','0','');
INSERT INTO `qb_config` VALUES ('FtpWeb','','');
INSERT INTO `qb_config` VALUES ('FtpDir','111','');
INSERT INTO `qb_config` VALUES ('groupTime','180','');
INSERT INTO `qb_config` VALUES ('allowGuestCommentPass','1','');
INSERT INTO `qb_config` VALUES ('ShowMenu','0','');
INSERT INTO `qb_config` VALUES ('GuestBookNum','8','');
INSERT INTO `qb_config` VALUES ('ShopNormalSend','8','');
INSERT INTO `qb_config` VALUES ('ShopEmsSend','25','');
INSERT INTO `qb_config` VALUES ('groupUpType','1','');
INSERT INTO `qb_config` VALUES ('HideNopowerPost','1','');
INSERT INTO `qb_config` VALUES ('allowGuestComment','1','');
INSERT INTO `qb_config` VALUES ('ListSonLeng','34','');
INSERT INTO `qb_config` VALUES ('Listsortnameline','2','');
INSERT INTO `qb_config` VALUES ('ListLeng','70','');
INSERT INTO `qb_config` VALUES ('showsortlogo','0','');
INSERT INTO `qb_config` VALUES ('PostNotice','<font face=SimSun>\r\n<p><font face=SimSun>1תݣдԴַ<br />2İȨ뷨ɷ߳е</font></p></font>','');
INSERT INTO `qb_config` VALUES ('propagandize_Money','2','');
INSERT INTO `qb_config` VALUES ('propagandize_LogDay','5','');
INSERT INTO `qb_config` VALUES ('propagandize_close','0','');
INSERT INTO `qb_config` VALUES ('EditYzMob','0','');
INSERT INTO `qb_config` VALUES ('EditYzIdcard','0','');
INSERT INTO `qb_config` VALUES ('EditYzEmail','0','');
INSERT INTO `qb_config` VALUES ('sms_wi_id','2','');
INSERT INTO `qb_config` VALUES ('SPlist_filename','html/4special{$fid}/list{$page}.htm','');
INSERT INTO `qb_config` VALUES ('SPbencandy_filename','html/5special{$fid}/show{$id}.htm','');
INSERT INTO `qb_config` VALUES ('RegPropagandizeMan','1','');
INSERT INTO `qb_config` VALUES ('close_count','0','');
INSERT INTO `qb_config` VALUES ('passport_TogetherLogin','1','');
INSERT INTO `qb_config` VALUES ('ListSonRows','9','');
INSERT INTO `qb_config` VALUES ('cache_time_js','-1','');
INSERT INTO `qb_config` VALUES ('SideTitleStyle','side_tpl/2','');
INSERT INTO `qb_config` VALUES ('JsListRows','5','');
INSERT INTO `qb_config` VALUES ('list_filename','html/{$fid}/{$page}.htm','');
INSERT INTO `qb_config` VALUES ('bencandy_filename','html/{$fid}-{$dirid}/{$id}-{$page}.htm','');
INSERT INTO `qb_config` VALUES ('cache_time_com','-1','');
INSERT INTO `qb_config` VALUES ('JsListLeng','36','');
INSERT INTO `qb_config` VALUES ('SideSortStyle','side_sort/2','');
INSERT INTO `qb_config` VALUES ('sortNUM','16','');
INSERT INTO `qb_config` VALUES ('FtpPort','21','');
INSERT INTO `qb_config` VALUES ('articleNUM','85','');
INSERT INTO `qb_config` VALUES ('cache_time_like','-1','');
INSERT INTO `qb_config` VALUES ('cache_time_new','-1','');
INSERT INTO `qb_config` VALUES ('waterimg','images/default/water.gif','');
INSERT INTO `qb_config` VALUES ('passport_path','bbs','');
INSERT INTO `qb_config` VALUES ('Del_MoreUpfile','1','');
INSERT INTO `qb_config` VALUES ('passport_pre','`bbs`.pw_','');
INSERT INTO `qb_config` VALUES ('passport_type','','');
INSERT INTO `qb_config` VALUES ('cache_time_pic','-1','');
INSERT INTO `qb_config` VALUES ('list_cache_time','0','');
INSERT INTO `qb_config` VALUES ('bencandy_cache_time','0','');
INSERT INTO `qb_config` VALUES ('showsp_cache_time','0','');
INSERT INTO `qb_config` VALUES ('cache_time_hot','-1','');
INSERT INTO `qb_config` VALUES ('pay99_id','','');
INSERT INTO `qb_config` VALUES ('MoneyRatio','100','');
INSERT INTO `qb_config` VALUES ('Money2card','0','');
INSERT INTO `qb_config` VALUES ('set_user_log_day','30','');
INSERT INTO `qb_config` VALUES ('is_waterimg','1','');
INSERT INTO `qb_config` VALUES ('RegCompany','1','');
INSERT INTO `qb_config` VALUES ('DefaultIndexHtml','0','');
INSERT INTO `qb_config` VALUES ('AutoPassCompany','1','');
INSERT INTO `qb_config` VALUES ('ArticleHeart','Ƿ|1.gif\r\n֧|2.gif\r\nܰ|3.gif\r\n|4.gif\r\nЦ|5.gif\r\n|6.gif\r\n|7.gif\r\nԾ|8.gif','');
INSERT INTO `qb_config` VALUES ('heart_time','30','');
INSERT INTO `qb_config` VALUES ('heart_noRecord','1','');
INSERT INTO `qb_config` VALUES ('UseArticleHeart','1','');
INSERT INTO `qb_config` VALUES ('UseArticleDigg','0','');
INSERT INTO `qb_config` VALUES ('ForceDel','0','');
INSERT INTO `qb_config` VALUES ('AutoTitleNum','1','');
INSERT INTO `qb_config` VALUES ('deleteArticleMoney','-1','');
INSERT INTO `qb_config` VALUES ('postArticleMoney','1','');
INSERT INTO `qb_config` VALUES ('comArticleMoney','3','');
INSERT INTO `qb_config` VALUES ('hotArticleNum','100','');
INSERT INTO `qb_config` VALUES ('newArticleTime','24','');
INSERT INTO `qb_config` VALUES ('ListShowIcon','0','');
INSERT INTO `qb_config` VALUES ('autoGetKeyword','0','');
INSERT INTO `qb_config` VALUES ('autoGetSmallPic','1','');
INSERT INTO `qb_config` VALUES ('KeepTodayCount','1','');
INSERT INTO `qb_config` VALUES ('ShopOtherSend','18','');
INSERT INTO `qb_config` VALUES ('ForbidShowPhpPage','0','');
INSERT INTO `qb_config` VALUES ('bencandy_filename2','bencandy.php?fid-{$fid}-id-{$id}-page-{$page}.htm','');
INSERT INTO `qb_config` VALUES ('pay99_key','','');
INSERT INTO `qb_config` VALUES ('list_filename2','list.php?fid-{$fid}-page-{$page}.htm','');
INSERT INTO `qb_config` VALUES ('MAX_sell_telephone','10','');
INSERT INTO `qb_config` VALUES ('money_sell_telephone','50','');
INSERT INTO `qb_config` VALUES ('sell_telephone_titleNUM','12','');
INSERT INTO `qb_config` VALUES ('sell_telephone_telNUM','13','');
INSERT INTO `qb_config` VALUES ('path','','');
INSERT INTO `qb_config` VALUES ('viewNoPassArticle','0','');
INSERT INTO `qb_config` VALUES ('ForbidRepeatTitle','1','');
INSERT INTO `qb_config` VALUES ('autoCutSmallPic','1','');
INSERT INTO `qb_config` VALUES ('waterpos','7','');
INSERT INTO `qb_config` VALUES ('if_gdimg','1','');
INSERT INTO `qb_config` VALUES ('ArticleDownloadDirTime','0','');
INSERT INTO `qb_config` VALUES ('ArticleDownloadUseFtp','0','');
INSERT INTO `qb_config` VALUES ('SortUseOtherModule','0','');
INSERT INTO `qb_config` VALUES ('photoShowType','0','');
INSERT INTO `qb_config` VALUES ('allowDownMv','0','');
INSERT INTO `qb_config` VALUES ('autoPlayFirstMv','1','');
INSERT INTO `qb_config` VALUES ('EditSystem','0','');
INSERT INTO `qb_config` VALUES ('XunLei_ID','08311','');
INSERT INTO `qb_config` VALUES ('FlashGet_ID','6370','');
INSERT INTO `qb_config` VALUES ('ListPageTitle_nojs','0','');
INSERT INTO `qb_config` VALUES ('view_sell_article','0','');
INSERT INTO `qb_config` VALUES ('sms_es_key','abc888','');
INSERT INTO `qb_config` VALUES ('TheSameMakeIndexHtml','0','');
INSERT INTO `qb_config` VALUES ('SPlist_filename2','listsp.php?fid-{$fid}-page-{$page}.htm','');
INSERT INTO `qb_config` VALUES ('SPbencandy_filename2','showsp.php?fid-{$fid}-id-{$id}-page-{$page}.htm','');
INSERT INTO `qb_config` VALUES ('RegQyNoNeedFull','1','');
INSERT INTO `qb_config` VALUES ('ArticlePicWidth','800','');
INSERT INTO `qb_config` VALUES ('ArticlePicHeight','600','');
INSERT INTO `qb_config` VALUES ('QQ_appid','','');
INSERT INTO `qb_config` VALUES ('sms_ccell_id','88458','');
INSERT INTO `qb_config` VALUES ('sms_type','eshang8','');
INSERT INTO `qb_config` VALUES ('hyGroupid','8','');
INSERT INTO `qb_config` VALUES ('FtpHost','127.0.0.1','');
INSERT INTO `qb_config` VALUES ('FtpName','admin','');
INSERT INTO `qb_config` VALUES ('FtpPwd','admin','');
INSERT INTO `qb_config` VALUES ('passport_url','http://wz.net/bbs','');
INSERT INTO `qb_config` VALUES ('ForbidIp','','');
INSERT INTO `qb_config` VALUES ('AllowVisitIp','','');
INSERT INTO `qb_config` VALUES ('AdminIp','','');
INSERT INTO `qb_config` VALUES ('guide_word_55','','');
INSERT INTO `qb_config` VALUES ('YzImg_difficult','0','');
INSERT INTO `qb_config` VALUES ('YzImg_letter_differ','0','');
INSERT INTO `qb_config` VALUES ('wei_cache_time','0','');
INSERT INTO `qb_config` VALUES ('qq_auto_bind','0','');
INSERT INTO `qb_config` VALUES ('wxpay_ApiKey','','');
INSERT INTO `qb_config` VALUES ('yeepay_key','','');
INSERT INTO `qb_config` VALUES ('rand_reg_num_mktime','0','');
INSERT INTO `qb_config` VALUES ('dzbbs_pre','','');
INSERT INTO `qb_config` VALUES ('dzbbs_showurl','','');
INSERT INTO `qb_config` VALUES ('dzbbs_listurl','','');
INSERT INTO `qb_config` VALUES ('yzImgAdminLogin','0','');
INSERT INTO `qb_config` VALUES ('guide_word_67','','');
INSERT INTO `qb_config` VALUES ('tenpay_key','','');
INSERT INTO `qb_config` VALUES ('guide_word_59','','');
INSERT INTO `qb_config` VALUES ('guide_word_52','','');
INSERT INTO `qb_config` VALUES ('guide_word_62','','');
INSERT INTO `qb_config` VALUES ('RegQyYzSendMail','0','');
INSERT INTO `qb_config` VALUES ('RegQyGroupid','9','');
INSERT INTO `qb_config` VALUES ('RegQyNeedCheck','0','');
INSERT INTO `qb_config` VALUES ('RegQySendMail','0','');
INSERT INTO `qb_config` VALUES ('QQ_login','0','');
INSERT INTO `qb_config` VALUES ('is_MathYZ','0','');
INSERT INTO `qb_config` VALUES ('Reg_Field','a:1:{s:8:\\\"field_db\\\";a:0:{}}','');
INSERT INTO `qb_config` VALUES ('is_chineseIMG','0','');
INSERT INTO `qb_config` VALUES ('sms_es_name','cf_test','');
INSERT INTO `qb_config` VALUES ('YzImg_string','','');
INSERT INTO `qb_config` VALUES ('MailId','2748810446@qq.com','');
INSERT INTO `qb_config` VALUES ('weixin_welcome','лע벩㽫Եһʱյٷ°ȫѣ','');
INSERT INTO `qb_config` VALUES ('QQ_appkey','','');
INSERT INTO `qb_config` VALUES ('QQ_QBappid','1','');
INSERT INTO `qb_config` VALUES ('propagandize_Reg_Money','10','');
INSERT INTO `qb_config` VALUES ('propagandize_jumpto','/','');
INSERT INTO `qb_config` VALUES ('YZ_WeixinMoney','30','');
INSERT INTO `qb_config` VALUES ('QQ_QBappkey','d12100d9366fbd6d92c9','');
INSERT INTO `qb_config` VALUES ('bokecc_id','','');
INSERT INTO `qb_config` VALUES ('YZ_EmailMoney','10','');
INSERT INTO `qb_config` VALUES ('YZ_MobMoney','15','');
INSERT INTO `qb_config` VALUES ('YZ_IdcardMoney','20','');
INSERT INTO `qb_config` VALUES ('MailServer','smtp.qq.com','');
INSERT INTO `qb_config` VALUES ('wap_url','http://life.net/wap','');
INSERT INTO `qb_config` VALUES ('guide_word_64','','');
INSERT INTO `qb_config` VALUES ('guide_word_58','Ʒ|/shop/all.php|0||75|\r\nƷ|/shop/all.php?show_type=2|0||76|','');
INSERT INTO `qb_config` VALUES ('guide_word_60','','');
INSERT INTO `qb_config` VALUES ('MailPort','465','');
INSERT INTO `qb_config` VALUES ('MailTransfer','0','');
INSERT INTO `qb_config` VALUES ('guide_word_61','','');
INSERT INTO `qb_config` VALUES ('QQ_logintime','','');
INSERT INTO `qb_config` VALUES ('forbidRegIp','','');
INSERT INTO `qb_config` VALUES ('forbidRegName','','');
INSERT INTO `qb_config` VALUES ('forbidRegHour','','');
INSERT INTO `qb_config` VALUES ('regmoney','5','');
INSERT INTO `qb_config` VALUES ('RegYz','1','');
INSERT INTO `qb_config` VALUES ('emailOnly','1','');
INSERT INTO `qb_config` VALUES ('rand_reg_num','1361937373','');
INSERT INTO `qb_config` VALUES ('rand_reg_num_inputname','LCKU','');
INSERT INTO `qb_config` VALUES ('sms_ccell_pwd','Ad43534556','');
INSERT INTO `qb_config` VALUES ('zhuangxiu_cache_time','0','');
INSERT INTO `qb_config` VALUES ('house_cache_time','0','');
INSERT INTO `qb_config` VALUES ('dianping_cache_time','0','');
INSERT INTO `qb_config` VALUES ('ershou_cache_time','0','');
INSERT INTO `qb_config` VALUES ('news_cache_time','0','');
INSERT INTO `qb_config` VALUES ('fenlei_cache_time','0','');
INSERT INTO `qb_config` VALUES ('shop_cache_time','0','');
INSERT INTO `qb_config` VALUES ('hy_cache_time','0','');
INSERT INTO `qb_config` VALUES ('tg_cache_time','0','');
INSERT INTO `qb_config` VALUES ('coupon_cache_time','0','');
INSERT INTO `qb_config` VALUES ('hr_cache_time','0','');
INSERT INTO `qb_config` VALUES ('shoptg_cache_time','0','');
INSERT INTO `qb_config` VALUES ('index_cache_time','0','');
INSERT INTO `qb_config` VALUES ('if_set_user_log','0','');
INSERT INTO `qb_config` VALUES ('weixin_welcome_title','','');
INSERT INTO `qb_config` VALUES ('weixin_welcome_desc','','');
INSERT INTO `qb_config` VALUES ('weixin_welcome_pic','','');
INSERT INTO `qb_config` VALUES ('rand_admin_pwd_num','2','');
INSERT INTO `qb_config` VALUES ('rand_adminpwd','0','');
INSERT INTO `qb_config` VALUES ('rand_admin_pwd_pre','abc','');
INSERT INTO `qb_config` VALUES ('rand_admin_pwd_type','1','');
INSERT INTO `qb_config` VALUES ('pc_path','../','');
INSERT INTO `qb_config` VALUES ('chinabank_id','1001','');
INSERT INTO `qb_config` VALUES ('alipay_scale','100','');
INSERT INTO `qb_config` VALUES ('yeepay_id','','');
INSERT INTO `qb_config` VALUES ('chinabank_key','test','');
INSERT INTO `qb_config` VALUES ('wxpay_AppSecret','fdsa','');
INSERT INTO `qb_config` VALUES ('paypal_key','VSILuuKuBqmr_sQSCaztA3lSXAwBAJcHnelancWqyQ9qMWASqwiPp3hXHO8','');
INSERT INTO `qb_config` VALUES ('paypal_type','0','');
INSERT INTO `qb_config` VALUES ('wxpay_AppID','fdsa','');
INSERT INTO `qb_config` VALUES ('weixin_welcome_link','','');
INSERT INTO `qb_config` VALUES ('weixin_problem','ܱǸ벩ʱܽ⣬ܻڽһĿУʱһʱ֪ͨң','');
INSERT INTO `qb_config` VALUES ('guide_word_56','','');
INSERT INTO `qb_config` VALUES ('guide_word_88','','');
INSERT INTO `qb_config` VALUES ('guide_word_65','','');
INSERT INTO `qb_config` VALUES ('guide_word_57','','');
INSERT INTO `qb_config` VALUES ('reg_group','8','');
INSERT INTO `qb_config` VALUES ('yzNumReg','0','');
INSERT INTO `qb_config` VALUES ('forbidReg','0','');
INSERT INTO `qb_config` VALUES ('limitRegTime','','');
INSERT INTO `qb_config` VALUES ('weixin_getnum','0','');
INSERT INTO `qb_config` VALUES ('weixin_moreid','0','');
INSERT INTO `qb_config` VALUES ('yzImgReg','1','');
INSERT INTO `qb_config` VALUES ('YzImg_voice','0','');
INSERT INTO `qb_config` VALUES ('weixin_Token','','');
INSERT INTO `qb_config` VALUES ('MailPw','nhhuamqrstmxdhab','');
INSERT INTO `qb_config` VALUES ('guide_word_87','','');
INSERT INTO `qb_config` VALUES ('guide_word_63','','');
INSERT INTO `qb_config` VALUES ('paypal_id','lfj846@163.com','');
INSERT INTO `qb_config` VALUES ('alipay_id','3452926615@qq.com','');
INSERT INTO `qb_config` VALUES ('alipay_key','bt8imp5te7chtm2kd1mn8z63220i7n81','');
INSERT INTO `qb_config` VALUES ('alipay_partner','2088421505494862','');
INSERT INTO `qb_config` VALUES ('alipay_service','create_direct_pay_by_user','');
INSERT INTO `qb_config` VALUES ('alipay_transport','https','');
INSERT INTO `qb_config` VALUES ('sms_api_url','http://sms.106jiekou.com/gbk/sms.aspx?account=zy800002&password=zxmxr88&mobile=$mob&content=Ķ룺$contentϵͷ','');
INSERT INTO `qb_config` VALUES ('sms_api_code','100','');
INSERT INTO `qb_config` VALUES ('sms_must_utf8','0','');
INSERT INTO `qb_config` VALUES ('ForbidDoHy','0','');
INSERT INTO `qb_config` VALUES ('ForbidUpHy','0','');
INSERT INTO `qb_config` VALUES ('companyTrade','еҵ豸\r\nͨе\r\nͨ㲿\r\n\r\n\r\n綯\r\nԪ\r\n\r\n\r\nȫ豸\r\nװ\r\nֽֽƷ\r\n繤\r\n繤\r\nͨǱ\r\nרǱ\r\nͨ豸㲿\r\n칫ĽƷ\r\n롢Լ\r\nճҾƷ\r\nľġľƷ\r\nҾ\r\nõ\r\nƷƷ\r\nʳƷ\r\nͨŲƷ\r\n\r\nӡˢ豸\r\n˶СƷ\r\nЬñ\r\nװ\r\nûѧƷ\r\nũûѧƷ\r\nճ\r\nȾϡϡͿϺī\r\n߻\r\n澫ϸѧƷ\r\nʳƷӼ\r\n\r\nƷ\r\n豸\r\n\r\nԴ\r\n͡ũƷ\r\n\r\nҽҩҽ豸\r\n֯\r\nƤ\r\núƷ\r\nճ\r\n\r\nѵ\r\n֤\r\n\r\n\r\nڴ\r\nά޼װ\r\n桢չ\r\nרҵ¼豸\r\nѧӰ\r\n༭豸\r\nǰ豸\r\nװҵ\r\nز\r\nװ\r\nʵͨ\r\n֤\r\nᡢ\r\nҵ\r\nڡ\r\nʵҵ˾ҵó\r\n¼\r\nг','');
INSERT INTO `qb_config` VALUES ('WXlogin_API','2','');
INSERT INTO `qb_config` VALUES ('weixin_code_img','http://www.wxyxpt.com/upload_files/web1/wenxin_center/49b_1_20160923120948_nu45d.jpg','');
INSERT INTO `qb_config` VALUES ('if_baidu_map','1','');
INSERT INTO `qb_config` VALUES ('baidu_map_key','','');
INSERT INTO `qb_config` VALUES ('Info_NoPostKeyword','','');
INSERT INTO `qb_config` VALUES ('mob_goto_3g','0','');
INSERT INTO `qb_config` VALUES ('DelMoneyLog','0','');
INSERT INTO `qb_config` VALUES ('ComebackDate','0','');
INSERT INTO `qb_config` VALUES ('googleMapDomain','0','');
INSERT INTO `qb_config` VALUES ('baidu_share_uid','','');
INSERT INTO `qb_config` VALUES ('Main_openAd','0','');
INSERT INTO `qb_config` VALUES ('ForbidOtherDomainVisit','0','');
INSERT INTO `qb_config` VALUES ('yzImgLogin','0','');
INSERT INTO `qb_config` VALUES ('jump_city','0','');
INSERT INTO `qb_config` VALUES ('Info_allcityType','0','');
INSERT INTO `qb_config` VALUES ('memberNotice','ӭӻԾͶ,Ͷɵûֽ!!','');
INSERT INTO `qb_config` VALUES ('member_contact',' <div class=t>020-88888888</div>\r\n            <div class=t>020-88888888</div>\r\n            <div class=q>qq:123456</div>','');
INSERT INTO `qb_config` VALUES ('AutoCutFace','0','');
INSERT INTO `qb_config` VALUES ('DownLoad_readfile','1','');
INSERT INTO `qb_config` VALUES ('alipay_give_scale','5','');
INSERT INTO `qb_config` VALUES ('wapAlipay_id','18653310270','');
INSERT INTO `qb_config` VALUES ('wapAlipay_partner','2088502462059458','');
INSERT INTO `qb_config` VALUES ('Ali_Private_Key','','');
INSERT INTO `qb_config` VALUES ('Ali_Public_Key','MIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKBgQDR8tNTAFVoV9KBiwBlena953NHogMQ1ue6+xE1D9wo8n87/lT60afbzrtQu+sW6nEnvYEgxya0ncD7+S6F+ERxaxP2BQJlqhHFKiBXqZd/kjn0cYDKrdgbl/q2vODwXPMFCQ85Iogbk7e8uxuEIRy178PEaPxkH/unzYod1Zt8CQIDAQAB','');
INSERT INTO `qb_config` VALUES ('wxpay_ID','','');
INSERT INTO `qb_config` VALUES ('weixinTotalMoney','','');
INSERT INTO `qb_config` VALUES ('guide_word_89','','');
INSERT INTO `qb_config` VALUES ('guide_word_66','','');
INSERT INTO `qb_config` VALUES ('guide_word_12','','');
INSERT INTO `qb_config` VALUES ('guide_word_90','','');
INSERT INTO `qb_config` VALUES ('guide_word_91','','');
INSERT INTO `qb_config` VALUES ('guide_word_13','','');
INSERT INTO `qb_config` VALUES ('labelsort_show_step','3','');
INSERT INTO `qb_config` VALUES ('RewriteUrl','0','');
INSERT INTO `qb_config` VALUES ('label_cache_time','-1','');
INSERT INTO `qb_config` VALUES ('mymd5','k61gjcr1xu','');
INSERT INTO `qb_config` VALUES ('copyright','','');
INSERT INTO `qb_config` VALUES ('miibeian_gov_cn','ICP050453','');
INSERT INTO `qb_config` VALUES ('cookiePre','','');
INSERT INTO `qb_config` VALUES ('cookieDomain','','');
INSERT INTO `qb_config` VALUES ('forbid_show_bug','1','');
INSERT INTO `qb_config` VALUES ('mirror','http://down.qibosoft.com/other/testv6/upload_files/','');
INSERT INTO `qb_config` VALUES ('updir','upload_files','');
INSERT INTO `qb_config` VALUES ('upfileType','.rar .txt .jpg .gif .bmp .png .zip .mp3 .wma .wmv .mpeg .mpg .rm .ram .htm .doc .swf .avi .flv .sql .doc .ppt .xls .chm .pdf','');
INSERT INTO `qb_config` VALUES ('upfileMaxSize','','');
INSERT INTO `qb_config` VALUES ('guide_word_92','','');
INSERT INTO `qb_config` VALUES ('guide_word_11','','');
INSERT INTO `qb_config` VALUES ('guide_word_9','','');
INSERT INTO `qb_config` VALUES ('guide_word_10','','');
INSERT INTO `qb_config` VALUES ('totalSpace','100','');
INSERT INTO `qb_config` VALUES ('time','0','');
INSERT INTO `qb_config` VALUES ('NewsMakeHtml','0','');
INSERT INTO `qb_config` VALUES ('MakeIndexHtmlTime','0','');
INSERT INTO `qb_config` VALUES ('admin_url','admin','');
INSERT INTO `qb_config` VALUES ('www_url','http://cms.net','');
INSERT INTO `qb_config` VALUES ('style_member','','');
INSERT INTO `qb_config` VALUES ('close_why','վά,\r\nͣ.\r\n','');
INSERT INTO `qb_config` VALUES ('style','','');
INSERT INTO `qb_config` VALUES ('web_open','1','');
INSERT INTO `qb_config` VALUES ('MoneyDW','','');
INSERT INTO `qb_config` VALUES ('MoneyName','','');
INSERT INTO `qb_config` VALUES ('UserEmailAutoPass','1','');
INSERT INTO `qb_config` VALUES ('BuySpacesizeMoney','50','');
INSERT INTO `qb_config` VALUES ('UseMoneyType','cms','');
INSERT INTO `qb_config` VALUES ('description','õĿԴ΢ŵƽ̨ ƶCMS΢վϵͳ','');
INSERT INTO `qb_config` VALUES ('webmail','admin@admin.com','');
INSERT INTO `qb_config` VALUES ('metakeywords','Դ΢ŵƽ̨ ƶCMS΢վϵͳ ̳ϵͳ','');
INSERT INTO `qb_config` VALUES ('guide_word','ҳ|/|0||51|\r\n|/list.php?fid=1|0||9|\r\nͼƬ|/list.php?fid=9|0||10|\r\nר|/do/listsp.php?fid=1|0||11|\r\n|/list.php?fid=12|0||12|\r\nƵ|/list.php?fid=14|0||90|\r\nÿ|/guestbook/|0||91|\r\nվ|/do/friendlink.php|0||92|','');
INSERT INTO `qb_config` VALUES ('guide_word_51','','');
INSERT INTO `qb_config` VALUES ('SeoTitle','벩CMSվϵͳ','');
INSERT INTO `qb_config` VALUES ('webname','벩CMSվϵͳ','');
INSERT INTO `qb_config` VALUES ('wap_guide_word','','');
INSERT INTO `qb_config` VALUES ('weixin_attention_url','','');
INSERT INTO `qb_config` VALUES ('hideFid','','');
INSERT INTO `qb_hack` VALUES ('login','û¼','0','','a:3:{s:10:\"systemType\";s:6:\"벩CMS\";s:9:\"guestcode\";s:0:\"\";}','','','','index.php?lfj=hack&hack=login&job=list','','','','0','','0');
INSERT INTO `qb_hack` VALUES ('adminmap','̨˵','0','','','','','','index.php?lfj=adminmap&job=list','','other','ȫ','0','','0');
INSERT INTO `qb_hack` VALUES ('moneylog','ԱѼ¼','0','','','','','','index.php?lfj=moneylog&job=list','','other','','0','','0');
INSERT INTO `qb_hack` VALUES ('alipay_set','ֵ֧߳','0','','','','','','index.php?lfj=alipay&job=list','','other','','9','','0');
INSERT INTO `qb_hack` VALUES ('template_list','ģ','0','','','','','','index.php?lfj=template&job=list','','other','/ģ','1','','0');
INSERT INTO `qb_hack` VALUES ('style_editstyle','','0','','','','','','index.php?lfj=style&job=edittpl','','other','/ģ','2','','0');
INSERT INTO `qb_hack` VALUES ('propagandize','ƹ׬ȡֹ','0','','','','','','index.php?lfj=propagandize&job=list','','other','','8','','0');
INSERT INTO `qb_hack` VALUES ('jfadmin_mod','ֽܹ','0','','','','','','index.php?lfj=jfadmin&job=listjf','','other','','7','','0');
INSERT INTO `qb_hack` VALUES ('attachment_list','','0','','','','','','index.php?lfj=attachment&job=list','','other','','6','','0');
INSERT INTO `qb_hack` VALUES ('upgrade_ol','ϵͳ','0','','','','','','index.php?lfj=upgrade&job=get','','other','','4','','0');
INSERT INTO `qb_hack` VALUES ('mail_send','ʼȺ','0','','','','','','index.php?lfj=mail&job=send','','other','Ϣ/ʼȺ','2','','0');
INSERT INTO `qb_hack` VALUES ('message_send','վϢȺ','0','','','','','','index.php?lfj=message&job=send','','other','Ϣ/ʼȺ','3','','0');
INSERT INTO `qb_hack` VALUES ('sms_send','ֻȺ','0','','','','','','index.php?lfj=sms&job=send','','other','Ϣ/ʼȺ','1','','0');
INSERT INTO `qb_hack` VALUES ('cnzz_set','CNZZͳ','0','','','','','','index.php?lfj=cnzz&job=ask','','other','ȫ','3','','0');
INSERT INTO `qb_hack` VALUES ('limitword_list','','0','','','','','','index.php?lfj=limitword&job=list','','other','','9','','0');
INSERT INTO `qb_hack` VALUES ('moneycard_make','㿨ֵ','0','','','','','','index.php?lfj=moneycard&job=make','','other','','7','','1');
INSERT INTO `qb_hack` VALUES ('logs_login_logs','̨¼־','0','','','','','','index.php?lfj=logs&job=login_logs','','other','־','2','','0');
INSERT INTO `qb_hack` VALUES ('logs_admin_do_logs','̨־','0','','','','','','index.php?lfj=logs&job=admin_logs','','other','־','1','','0');
INSERT INTO `qb_hack` VALUES ('sell_telephone','绰','0','','','','','','index.php?lfj=sell_telephone&job=list','','other','','0','','0');
INSERT INTO `qb_hack` VALUES ('crontab','ʱ','0','','','','','','index.php?lfj=crontab&job=list','','other','ȫ','0','','0');
INSERT INTO `qb_hack` VALUES ('labelstyle','ǩݵ뵼','0','','','','','','index.php?lfj=labelstyle&job=label','','other','/ģ','2','','0');
INSERT INTO `qb_hack` VALUES ('js_list','JSݵ','0','','','','','','index.php?lfj=js&job=list','','other','','9','','0');
INSERT INTO `qb_hack` VALUES ('rmb_consume','/ֵ¼','0','','','','','','index.php?lfj=rmb_consume&job=list','','other','','18','','0');
INSERT INTO `qb_hack` VALUES ('rmb_getout','ֹ','0','','','','','','index.php?lfj=rmb_getout&job=list','','other','','19','','0');
INSERT INTO `qb_hack` VALUES ('rmb_infull','ҳֵ','0','','','','','','index.php?lfj=rmb_infull&job=list','','other','','20','','0');
INSERT INTO `qb_hack` VALUES ('baidu_sitemap','ٶȵͼ','0','','','','','','index.php?lfj=baidu_sitemap&job=make','','other','ȫ','1','','0');
INSERT INTO `qb_hack` VALUES ('user_log','ûip˿ڼ¼','0','','','','','','index.php?lfj=user_log&job=list','','other','','8','','0');
INSERT INTO `qb_hack` VALUES ('weixin','΢Զ','0','','','','','','index.php?lfj=weixin&job=list','','other','','9','','0');
INSERT INTO `qb_hack` VALUES ('gather_list','ɼ','0','','','','','','index.php?lfj=gather&job=list','','other','ݲɼ','2','','0');
INSERT INTO `qb_hack` VALUES ('gather_list_sort','ɼ','0','','','','','','index.php?lfj=gather&job=listsort','','other','ݲɼ','1','','0');
INSERT INTO `qb_label` VALUES ('1','','0','0','wz_index_flash','rollpic','0','a:8:{s:13:\"tplpart_1code\";s:4449:\"<script type=\"text/javascript\">\r\n//޷ԶȡӦĻõƬͼƬ߶ʱ²ΪĬϵĻõƬͼƬ߶ֵʵ޸\r\nvar defaultH=400;\r\n</script>\r\n<div class=\"MainSlides\">\r\n	<ul class=\"listImgs\">\r\n<!--\r\nEOT;\r\nforeach($listdb AS $key=>$rs){@extract($rs);\r\nprint <<<EOT\r\n-->\r\n<li><a href=\"$rs[picurl]\" title=\"$rs[title]\"><span>$rs[title]</span><img src=\"$rs[picurl]\"/></a></li>\r\n<!--\r\nEOT;\r\n}\r\nprint <<<EOT\r\n-->\r\n	</ul>\r\n</div>\r\n<style>\r\n.MainSlides{\r\n	width:100%;\r\n	position:relative;\r\n	overflow:hidden;\r\n}\r\n.MainSlides .listImgs{\r\n	width:100%;\r\n	height:100%;\r\n	position:absolute;\r\n	left:0;\r\n	top:0;\r\n}\r\n.MainSlides .listImgs li{\r\n	width:100%;\r\n	height:100%;\r\n	position:absolute;\r\n	left:0;\r\n	top:0;\r\n	overflow:hidden;\r\n}\r\n.MainSlides .listImgs li a{\r\n	display:block;\r\n	padding-top:110%;\r\n}\r\n.MainSlides .listnum{\r\n	width:100%;\r\n	height:20px;\r\n	overflow:hidden;\r\n	position:absolute;\r\n	left:0;\r\n	bottom:18px;\r\n	text-align:center;\r\n	z-index:100;\r\n}\r\n.MainSlides .listnum li{\r\n	display:inline-block;\r\n	width:60px;\r\n	height:5px;\r\n	overflow:hidden;\r\n	background:#FFF;\r\n	margin-right:10px;\r\n	line-height:30px;\r\n}\r\n.MainSlides .listnum li.ck{\r\n	background:#00A2FF;\r\n}\r\n.MainSlides .prev,.MainSlides .next{\r\n	width:30px;\r\n	height:30px;	\r\n	position:absolute;\r\n	z-index:1000;\r\n	top:48%;\r\n	border-radius:15px;\r\n	overflow:hidden;\r\n	background:#000;\r\n	filter:alpha(opacity=60); \r\n	-moz-opacity:0.6; \r\n	opacity:0.6;\r\n	display:none;	\r\n}\r\n.MainSlides .next{\r\n	right:10%;\r\n}\r\n.MainSlides .prev{\r\n	left:10%;\r\n}\r\n.MainSlides .prev:before,.MainSlides .next:before{\r\n	content:\'\';\r\n	display:block;\r\n	width:0;\r\n	height:0;\r\n	border:8px solid transparent;\r\n	border-left: 8px solid #FFF;\r\n	border-right:0;\r\n	margin:5px auto 0 auto;	\r\n}\r\n.MainSlides .prev:before{\r\n	border-right: 8px solid #FFF;\r\n	border-left:0;\r\n}\r\n.MainSlides:hover .prev,.MainSlides:hover .next{\r\n	display:block;\r\n}\r\n</style>\r\n\r\n<script type=\"text/javascript\">\r\nvar slideimgnum=0,slideHeight=0;\r\nvar list_slideNum=\'<ul class=\"listnum\">\';\r\n$(\'.MainSlides .listImgs img\').each(function(){	\r\n	slideimgnum++;\r\n	var this_imgHeight=$(this).height();\r\n	if(slideHeight==0){\r\n		slideHeight=this_imgHeight;\r\n	}\r\n	if(slideHeight>this_imgHeight){\r\n		slideHeight=this_imgHeight;\r\n	}\r\n	list_slideNum+=\'<li>\'+slideimgnum+\'</li>\';\r\n	var this_li=$(this).parent().parent();\r\n	var thisimgurl=$(this).attr(\"src\");\r\n	this_li.css({\'background\':\'url(\'+thisimgurl+\') center center no-repeat\'});\r\n});\r\nlist_slideNum+=\'</ul><div class=\"prev\"></div><div class=\"next\"></div>\'; \r\n$(\'.MainSlides\').append(list_slideNum);\r\nif(slideHeight<50){\r\n	slideHeight=defaultH;\r\n}\r\n$(\'.MainSlides\').css({\'height\':slideHeight+\'px\'});\r\n//$(\'.MainSlides\').css({\'height\':\'364px\'});	//õƬ߶\r\nvar nowSlideList=0;\r\nfunction change_slide(num){\r\n	$(\'.MainSlides .listImgs li\').css({\'left\':\'110%\',\'z-index\':\'1\'});\r\n	var prev_num=num-1;\r\n	if(prev_num<0){\r\n		prev_num=slideimgnum-1;\r\n	}\r\n	$(\'.MainSlides .listImgs li\').eq(prev_num).css({\'left\':\'0px\'});\r\n	$(\'.MainSlides .listImgs li\').eq(num).css({\'z-index\':\'2\'});\r\n	$(\'.MainSlides .listImgs li\').eq(num).animate({\'left\':\'0px\',\'z-index\':\'2\'},1000);\r\n	$(\'.MainSlides .listnum li\').removeClass(\'ck\');\r\n	$(\'.MainSlides .listnum li\').eq(num).addClass(\'ck\');\r\n}\r\nchange_slide(0);\r\nfunction prev_slide(){\r\n	nowSlideList--;\r\n	if(nowSlideList<0){\r\n		nowSlideList=slideimgnum-1;\r\n	}\r\n	$(\'.MainSlides .listImgs li\').css({\'left\':\'-110%\',\'z-index\':\'1\'});\r\n	var prev_num=nowSlideList+1;\r\n	if(prev_num>=slideimgnum){\r\n		prev_num=0;\r\n	}\r\n	$(\'.MainSlides .listImgs li\').eq(prev_num).css({\'left\':\'0px\'});\r\n	$(\'.MainSlides .listImgs li\').eq(nowSlideList).css({\'z-index\':\'2\'});\r\n	$(\'.MainSlides .listImgs li\').eq(nowSlideList).animate({\'left\':\'0px\',\'z-index\':\'2\'},1000);\r\n	$(\'.MainSlides .listnum li\').removeClass(\'ck\');\r\n	$(\'.MainSlides .listnum li\').eq(nowSlideList).addClass(\'ck\');\r\n}\r\nfunction next_slide(){\r\n	nowSlideList++;\r\n	if(nowSlideList>=slideimgnum){\r\n		nowSlideList=0;\r\n	}\r\n	change_slide(nowSlideList);\r\n}\r\nvar timers;\r\nfunction autoPlays(){\r\n	timers = setInterval(\"next_slide()\",3000);\r\n}\r\nfunction stopPlays() {\r\n	clearInterval(timers);\r\n}\r\nautoPlays();\r\n$(\'.MainSlides\').hover(\r\n	function(){\r\n		stopPlays();\r\n	},\r\n	function(){\r\n		autoPlays();\r\n	}\r\n);\r\n$(\'.MainSlides .listnum li\').click(function(){\r\n	nowSlideList=$(this).index();\r\n	change_slide(nowSlideList);\r\n});\r\n$(\'.MainSlides .prev\').click(function(){\r\n	prev_slide();\r\n});\r\n$(\'.MainSlides .next\').click(function(){\r\n	next_slide();\r\n});\r\n</script>\";s:8:\"rolltype\";s:1:\"2\";s:5:\"width\";s:0:\"\";s:6:\"height\";s:0:\"\";s:6:\"picurl\";a:4:{i:1;s:28:\"../images/default/main/1.jpg\";i:2;s:28:\"../images/default/main/2.jpg\";i:3;s:28:\"../images/default/main/3.jpg\";i:4;s:28:\"../images/default/main/4.jpg\";}s:7:\"piclink\";a:4:{i:1;s:1:\"#\";i:2;s:1:\"#\";i:3;s:1:\"#\";i:4;s:1:\"#\";}s:6:\"picalt\";a:4:{i:1;s:0:\"\";i:2;s:0:\"\";i:3;s:0:\"\";i:4;s:0:\"\";}s:11:\"pic_city_id\";i:0;}','a:3:{s:5:\"div_w\";s:2:\"50\";s:5:\"div_h\";s:2:\"21\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','1482473669','8','0','0','0','default');
INSERT INTO `qb_label` VALUES ('2','','0','0','wz_index_ad1','pic','0','a:5:{s:6:\"imgurl\";s:30:\"../images/default/main/ad1.png\";s:7:\"imglink\";s:1:\"#\";s:5:\"width\";s:4:\"1200\";s:6:\"height\";s:3:\"150\";s:11:\"pic_city_id\";i:0;}','a:3:{s:5:\"div_w\";s:0:\"\";s:5:\"div_h\";s:0:\"\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','0','8','0','0','0','default');
INSERT INTO `qb_label` VALUES ('3','','0','0','wz_index_shopsort','code','0','<li><a href=\"#\">ʳ</a></li>\r\n<li><a href=\"#\"></a></li>\r\n<li><a href=\"#\">н</a></li>\r\n<li><a href=\"#\">ѵ</a></li>\r\n<li><a href=\"#\">ά</a></li>\r\n<li><a href=\"#\"></a></li>','a:4:{s:9:\"html_edit\";N;s:5:\"div_w\";s:0:\"\";s:5:\"div_h\";s:0:\"\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','0','8','0','0','0','default');
INSERT INTO `qb_label` VALUES ('4','','0','0','wz_index_shopcont','Info_shop_','1','a:31:{s:7:\"allcity\";s:1:\"0\";s:13:\"tplpart_1code\";s:815:\"<!--\r\nEOT;\r\nforeach($listdb AS $key=>$rs){@extract($rs);\r\n$rs[url]=\"$webdb[www_url]/shop/bencandy.php?fid=$rs[fid]&id=$rs[id]\";\r\n$codeurl=urlencode(\"$webdb[www_url]/shop/wapbencandy.php?fid=$rs[fid]&id=$rs[id]\");\r\n$rs[codeimg] = \"$webdb[www_url]/do/2codeimg.php?url=$codeurl\";\r\nprint <<<EOT\r\n-->\r\n<dl>\r\n	<dt>\r\n		<a href=\"$rs[url]\">\r\n			<img src=\"$webdb[www_url]/do/minpic.php?wh=220:165&url=$rs[picurl]\" />\r\n			<div class=\"code_pic\" onclick=\"window.open(\'$webdb[www_url]/shop/bencandy.php?fid=$rs[fid]&id=$rs[id]\')\"><p>ɨһɨֻ鿴</p><span><img src=\"$rs[codeimg]\" onerror=\"this.src=\'$webdb[www_url]/images/default/nopic.jpg\'\" alt=\"$rs[title]\" width=\"120\" height=\"120\"></span></div>\r\n		</a>\r\n	</dt>\r\n	<dd><a href=\"$rs[url]\">$rs[title]</a><span>{$rs[price]}Ԫ</span></dd>\r\n</dl>\r\n<!--\r\nEOT;\r\n}\r\nprint <<<EOT\r\n-->\";s:13:\"tplpart_2code\";s:0:\"\";s:3:\"SYS\";s:2:\"wn\";s:6:\"wninfo\";s:5:\"shop_\";s:6:\"cityId\";N;s:5:\"width\";s:3:\"250\";s:6:\"height\";s:3:\"187\";s:8:\"rolltype\";s:10:\"scrollLeft\";s:8:\"rolltime\";s:1:\"3\";s:11:\"roll_height\";s:2:\"50\";s:11:\"content_num\";s:2:\"80\";s:7:\"newhour\";s:2:\"24\";s:7:\"hothits\";s:2:\"30\";s:7:\"tplpath\";s:0:\"\";s:6:\"DivTpl\";i:1;s:5:\"fiddb\";N;s:8:\"moduleid\";N;s:5:\"stype\";s:1:\"4\";s:2:\"yz\";s:3:\"all\";s:10:\"timeformat\";s:11:\"Y-m-d H:i:s\";s:5:\"order\";s:4:\"list\";s:3:\"asc\";s:4:\"DESC\";s:6:\"levels\";s:3:\"all\";s:7:\"rowspan\";s:1:\"8\";s:3:\"sql\";s:95:\"SELECT * FROM qb_shop_content  WHERE city_id=\'$GLOBALS[city_id]\'  ORDER BY list DESC LIMIT 0,8 \";s:7:\"colspan\";s:1:\"1\";s:8:\"titlenum\";s:2:\"20\";s:10:\"titleflood\";s:1:\"0\";s:9:\"start_num\";s:1:\"1\";s:10:\"c_rolltype\";s:1:\"0\";}','a:3:{s:5:\"div_w\";s:2:\"50\";s:5:\"div_h\";s:2:\"30\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','1484980888','8','0','0','0','default');
INSERT INTO `qb_label` VALUES ('5','','0','0','wz_index_ad2','pic','0','a:5:{s:6:\"imgurl\";s:31:\"../images/default/main/pic4.png\";s:7:\"imglink\";s:1:\"#\";s:5:\"width\";s:3:\"220\";s:6:\"height\";s:3:\"260\";s:11:\"pic_city_id\";i:0;}','a:3:{s:5:\"div_w\";s:0:\"\";s:5:\"div_h\";s:0:\"\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','0','8','0','0','0','default');
INSERT INTO `qb_label` VALUES ('6','','0','0','wz_index_ad3','pic','0','a:5:{s:6:\"imgurl\";s:30:\"../images/default/main/ad2.png\";s:7:\"imglink\";s:1:\"#\";s:5:\"width\";s:4:\"1200\";s:6:\"height\";s:3:\"150\";s:11:\"pic_city_id\";i:0;}','a:3:{s:5:\"div_w\";s:0:\"\";s:5:\"div_h\";s:0:\"\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','0','8','0','0','0','default');
INSERT INTO `qb_label` VALUES ('7','','0','0','wz_index_footer','code','0','<dl>\r\n	<dt></dt>\r\n	<dd><a href=\"#\">Ҫʱ</a></dd>\r\n</dl>\r\n<dl>\r\n	<dt></dt>\r\n	<dd><a href=\"#\">ⵥ</a></dd>\r\n</dl>\r\n<dl>\r\n	<dt>ʡ</dt>\r\n	<dd><a href=\"#\">˿</a></dd>\r\n</dl>\r\n<dl>\r\n	<dt></dt>\r\n	<dd><a href=\"#\">7X24Сʱ</a></dd>\r\n</dl>','a:4:{s:9:\"html_edit\";N;s:5:\"div_w\";s:0:\"\";s:5:\"div_h\";s:0:\"\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','0','8','0','0','0','default');
INSERT INTO `qb_label` VALUES ('8','','0','99','o2o_index_foot','code','0','<div class=\"partnerlist\">\r\n	<h2>ϵ</h2>\r\n	<ul>\r\n		<li><a href=\"#\">ͷ绰:020-88888888</a></li>\r\n		<li><a href=\"#\">ѳ;</a></li>\r\n		<li><a href=\"#\">߿ͷ</a></li>\r\n		<li><a href=\"#\">߿ͷ</a></li>						\r\n	</ul>\r\n</div>\r\n<div class=\"partnerlist\">\r\n	<h2>˾Ϣ</h2>\r\n	<ul>\r\n		<li><a href=\"#\"></a></li>\r\n		<li><a href=\"#\">ϵ</a></li>\r\n		<li><a href=\"#\">˲Ƹ</a></li>\r\n		<li><a href=\"#\"></a></li>						\r\n	</ul>\r\n</div>\r\n<div class=\"partnerlist\">\r\n	<h2>̼Һ</h2>\r\n	<ul>\r\n		<li><a href=\"#\">̼פ</a></li>\r\n		<li><a href=\"#\"></a></li>\r\n		<li><a href=\"#\">̼Һ̨</a></li>\r\n	</ul>\r\n</div>\r\n<div class=\"partnerlist\">\r\n	<h2>û</h2>\r\n	<ul>\r\n		<li><a href=\"#\">Э</a></li>\r\n		<li><a href=\"#\">ƿŵ</a></li>\r\n		<li><a href=\"#\">̼Һ̨</a></li>\r\n	</ul>\r\n</div>','a:4:{s:9:\"html_edit\";N;s:5:\"div_w\";s:2:\"50\";s:5:\"div_h\";s:2:\"21\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','1481853554','8','0','0','0','default');
INSERT INTO `qb_label` VALUES ('9','','0','0','wz_shop_indexbanner1','pic','0','a:5:{s:6:\"imgurl\";s:33:\"../shop/images/default/banner.png\";s:7:\"imglink\";s:1:\"#\";s:5:\"width\";s:4:\"1200\";s:6:\"height\";s:3:\"100\";s:11:\"pic_city_id\";i:0;}','a:3:{s:5:\"div_w\";s:0:\"\";s:5:\"div_h\";s:0:\"\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','1481686188','0','29','0','0','default');
INSERT INTO `qb_label` VALUES ('26','','0','0','wz_hy_banner','pic','0','a:5:{s:6:\"imgurl\";s:31:\"../hy/images/default/banner.png\";s:7:\"imglink\";s:1:\"#\";s:5:\"width\";s:4:\"1200\";s:6:\"height\";s:3:\"320\";s:11:\"pic_city_id\";i:0;}','a:3:{s:5:\"div_w\";s:0:\"\";s:5:\"div_h\";s:0:\"\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','0','0','16','0','0','default');
INSERT INTO `qb_label` VALUES ('11','','0','0','wz_shop_indexfalsh','rollpic','0','a:8:{s:13:\"tplpart_1code\";s:528:\"<ul>\r\n<!--\r\nEOT; \r\nforeach($listdb AS $key=>$rs){@extract($rs);\r\nif(!$rs[title]){\r\n$show = \"style=\'display:none;\'\";\r\n}else{\r\n$show = \"\";\r\n}\r\nprint <<<EOT\r\n-->\r\n  <li><a href=\"$rs[url]\"><img src=\"$rs[picurl]\"></a><a href=\"$rs[url]\" class=\"TitleFlash\" $show>$rs[title]</a></li>\r\n<!--\r\nEOT;\r\n}\r\nprint <<<EOT\r\n-->\r\n</ul>\r\n<ol>\r\n<!--\r\nEOT; \r\n$i=0;\r\nforeach($listdb AS $key=>$rs){@extract($rs);\r\n$i++;\r\n$showcss = ($i ==1)? \"class=\'actionNum\'\":\"\";\r\nprint <<<EOT\r\n-->\r\n   <li {$showcss}>$i</li>\r\n<!--\r\nEOT;\r\n}\r\nprint <<<EOT\r\n-->\r\n</ol>\";s:8:\"rolltype\";s:1:\"2\";s:5:\"width\";s:0:\"\";s:6:\"height\";s:0:\"\";s:6:\"picurl\";a:2:{i:1;s:33:\"../shop/images/default/nav_bg.png\";i:2;s:34:\"../shop/images/default/nav_bg1.png\";}s:7:\"piclink\";a:2:{i:1;s:1:\"#\";i:2;s:1:\"#\";}s:6:\"picalt\";a:2:{i:1;s:5:\"ͼƬ1\";i:2;s:5:\"ͼƬ2\";}s:11:\"pic_city_id\";i:0;}','a:3:{s:5:\"div_w\";s:0:\"\";s:5:\"div_h\";s:0:\"\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','0','0','29','0','0','default');
INSERT INTO `qb_label` VALUES ('12','','0','0','wz_shop_index3','Info_news_','1','a:37:{s:7:\"allcity\";s:1:\"0\";s:13:\"tplpart_1code\";s:36:\"<li><a href=\"$url\">{$title}</a></li>\";s:13:\"tplpart_2code\";s:0:\"\";s:3:\"SYS\";s:2:\"wn\";s:6:\"wninfo\";s:5:\"news_\";s:9:\"noReadMid\";s:0:\"\";s:13:\"RollStyleType\";s:0:\"\";s:7:\"fidtype\";s:1:\"0\";s:8:\"rolltype\";s:10:\"scrollLeft\";s:8:\"rolltime\";s:1:\"3\";s:11:\"roll_height\";s:2:\"50\";s:5:\"width\";s:3:\"250\";s:6:\"height\";s:3:\"187\";s:7:\"newhour\";s:2:\"24\";s:7:\"hothits\";s:3:\"100\";s:7:\"amodule\";N;s:7:\"tplpath\";s:0:\"\";s:6:\"DivTpl\";i:1;s:5:\"fiddb\";N;s:5:\"stype\";s:1:\"4\";s:2:\"yz\";s:1:\"1\";s:7:\"hidefid\";N;s:10:\"timeformat\";s:11:\"Y-m-d H:i:s\";s:5:\"order\";s:6:\"A.list\";s:3:\"asc\";s:4:\"DESC\";s:6:\"levels\";s:3:\"all\";s:7:\"rowspan\";s:1:\"4\";s:3:\"sql\";s:117:\" SELECT A.* FROM qb_news_content A  WHERE A.city_id=\'$GLOBALS[city_id]\'  AND A.yz=1   ORDER BY A.list DESC LIMIT 0,4 \";s:4:\"sql2\";N;s:7:\"colspan\";s:1:\"1\";s:11:\"content_num\";s:2:\"80\";s:12:\"content_num2\";s:3:\"120\";s:8:\"titlenum\";s:2:\"40\";s:9:\"titlenum2\";s:2:\"40\";s:10:\"titleflood\";s:1:\"0\";s:9:\"start_num\";s:1:\"1\";s:10:\"c_rolltype\";s:1:\"0\";}','a:3:{s:5:\"div_w\";s:2:\"50\";s:5:\"div_h\";s:2:\"30\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','1481695483','0','29','0','0','default');
INSERT INTO `qb_label` VALUES ('13','','0','0','wz_shop_indexbanner6','pic','0','a:5:{s:6:\"imgurl\";s:34:\"../shop/images/default/sidead1.png\";s:7:\"imglink\";s:1:\"#\";s:5:\"width\";s:3:\"250\";s:6:\"height\";s:3:\"104\";s:11:\"pic_city_id\";i:0;}','a:3:{s:5:\"div_w\";s:0:\"\";s:5:\"div_h\";s:0:\"\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','1481686397','0','29','0','0','default');
INSERT INTO `qb_label` VALUES ('14','','0','0','wz_shop_indexbanner7','pic','0','a:5:{s:6:\"imgurl\";s:34:\"../shop/images/default/sidead2.png\";s:7:\"imglink\";s:1:\"#\";s:5:\"width\";s:3:\"250\";s:6:\"height\";s:3:\"106\";s:11:\"pic_city_id\";i:0;}','a:3:{s:5:\"div_w\";s:0:\"\";s:5:\"div_h\";s:0:\"\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','0','0','29','0','0','default');
INSERT INTO `qb_label` VALUES ('15','','0','0','wz_shop_index4','Info_news_','1','a:37:{s:7:\"allcity\";s:1:\"0\";s:13:\"tplpart_1code\";s:38:\"<li><a href=\"{$url}\">{$title}</a></li>\";s:13:\"tplpart_2code\";s:0:\"\";s:3:\"SYS\";s:2:\"wn\";s:6:\"wninfo\";s:5:\"news_\";s:9:\"noReadMid\";s:0:\"\";s:13:\"RollStyleType\";s:0:\"\";s:7:\"fidtype\";s:1:\"0\";s:8:\"rolltype\";s:10:\"scrollLeft\";s:8:\"rolltime\";s:1:\"3\";s:11:\"roll_height\";s:2:\"50\";s:5:\"width\";s:3:\"250\";s:6:\"height\";s:3:\"187\";s:7:\"newhour\";s:2:\"24\";s:7:\"hothits\";s:3:\"100\";s:7:\"amodule\";N;s:7:\"tplpath\";s:0:\"\";s:6:\"DivTpl\";i:1;s:5:\"fiddb\";s:5:\"45,44\";s:5:\"stype\";s:1:\"4\";s:2:\"yz\";s:1:\"1\";s:7:\"hidefid\";N;s:10:\"timeformat\";s:11:\"Y-m-d H:i:s\";s:5:\"order\";s:6:\"A.list\";s:3:\"asc\";s:4:\"DESC\";s:6:\"levels\";s:3:\"all\";s:7:\"rowspan\";s:1:\"4\";s:3:\"sql\";s:139:\" SELECT A.* FROM qb_news_content A  WHERE A.city_id=\'$GLOBALS[city_id]\'  AND A.yz=1  AND A.fid IN (45,44)   ORDER BY A.list DESC LIMIT 0,4 \";s:4:\"sql2\";N;s:7:\"colspan\";s:1:\"1\";s:11:\"content_num\";s:2:\"80\";s:12:\"content_num2\";s:3:\"120\";s:8:\"titlenum\";s:2:\"40\";s:9:\"titlenum2\";s:2:\"40\";s:10:\"titleflood\";s:1:\"0\";s:9:\"start_num\";s:1:\"1\";s:10:\"c_rolltype\";s:1:\"0\";}','a:3:{s:5:\"div_w\";s:2:\"50\";s:5:\"div_h\";s:2:\"30\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','1481695492','0','29','0','0','default');
INSERT INTO `qb_label` VALUES ('16','','0','0','wz_shop_indexbanner8','pic','0','a:5:{s:6:\"imgurl\";s:34:\"../shop/images/default/sidead2.png\";s:7:\"imglink\";s:1:\"#\";s:5:\"width\";s:3:\"250\";s:6:\"height\";s:3:\"104\";s:11:\"pic_city_id\";i:0;}','a:3:{s:5:\"div_w\";s:0:\"\";s:5:\"div_h\";s:0:\"\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','0','0','29','0','0','default');
INSERT INTO `qb_label` VALUES ('17','','0','0','wz_shop_indexbanner9','pic','0','a:5:{s:6:\"imgurl\";s:34:\"../shop/images/default/sidead1.png\";s:7:\"imglink\";s:1:\"#\";s:5:\"width\";s:3:\"250\";s:6:\"height\";s:3:\"106\";s:11:\"pic_city_id\";i:0;}','a:3:{s:5:\"div_w\";s:0:\"\";s:5:\"div_h\";s:0:\"\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','0','0','29','0','0','default');
INSERT INTO `qb_label` VALUES ('18','','0','0','wz_shop_indexhead2','code','0','<div class=\"tag\"><span>Ʒ</span><i>/Promotion goods</i></div>\r\n<div class=\"more\"><a href=\"./all.php?show_type=1\">MORE</a></div>','a:4:{s:9:\"html_edit\";N;s:5:\"div_w\";s:2:\"50\";s:5:\"div_h\";s:2:\"21\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','1481694752','0','29','0','0','default');
INSERT INTO `qb_label` VALUES ('19','','0','0','wz_shop_index1','Info_shop_','1','a:31:{s:7:\"allcity\";s:1:\"0\";s:13:\"tplpart_1code\";s:985:\"<!--\r\nEOT;\r\nforeach($listdb AS $key=>$rs){@extract($rs);\r\n$codeurl=urlencode(\"$webdb[www_url]/shop/wapbencandy.php?fid=$fid&id=$id\");\r\n$codeimg=\"$webdb[www_url]/do/2codeimg.php?url=$codeurl\";\r\nprint <<<EOT\r\n-->\r\n<dl>\r\n	<dt><a href=\"{$url}\"><img src=\"$webdb[www_url]/do/minpic.php?wh=283:283&url=$picurl\" onerror=\"this.src=\'$webdb[www_url]/images/default/nopic.jpg\'\" /></a></dt>\r\n	<dd>\r\n		<h3><a href=\"{$url}\">{$title}</a></h3>\r\n		<div class=\"info\">\r\n			<div class=\"price\">\r\n				<span style=\"color:#999999;\">ԭۣ<del>{$market_price}</del></span>\r\n				<span style=\"color:#333333;\">ּۣ<em  style=\"color:#ff0000;\">{$price}</em></span>\r\n			</div>\r\n			<div class=\"buy\">\r\n				<a href=\"{$url}\">鿴</a>\r\n			</div>\r\n			\r\n		</div>\r\n		<div class=\"scan_code\" onclick=\"window.open(\'$webdb[www_url]/shop/bencandy.php?fid=$fid&id=$id\')\">\r\n			<h3>ֻɨµ</h3>\r\n			<span><img src=\"$codeimg\" width=\"140\" height=\"140\" /></span>\r\n		</div>\r\n	</dd>\r\n</dl>\r\n<!--\r\nEOT;\r\n}\r\nprint <<<EOT\r\n-->\";s:13:\"tplpart_2code\";s:0:\"\";s:3:\"SYS\";s:2:\"wn\";s:6:\"wninfo\";s:5:\"shop_\";s:6:\"cityId\";N;s:5:\"width\";s:3:\"250\";s:6:\"height\";s:3:\"187\";s:8:\"rolltype\";s:10:\"scrollLeft\";s:8:\"rolltime\";s:1:\"3\";s:11:\"roll_height\";s:2:\"50\";s:11:\"content_num\";s:2:\"80\";s:7:\"newhour\";s:2:\"24\";s:7:\"hothits\";s:2:\"30\";s:7:\"tplpath\";s:0:\"\";s:6:\"DivTpl\";i:1;s:5:\"fiddb\";N;s:8:\"moduleid\";N;s:5:\"stype\";s:1:\"p\";s:2:\"yz\";s:3:\"all\";s:10:\"timeformat\";s:11:\"Y-m-d H:i:s\";s:5:\"order\";s:4:\"list\";s:3:\"asc\";s:4:\"DESC\";s:6:\"levels\";s:3:\"all\";s:7:\"rowspan\";s:1:\"4\";s:3:\"sql\";s:108:\"SELECT * FROM qb_shop_content  WHERE city_id=\'$GLOBALS[city_id]\'  AND ispic=1  ORDER BY list DESC LIMIT 0,4 \";s:7:\"colspan\";s:1:\"1\";s:8:\"titlenum\";s:2:\"20\";s:10:\"titleflood\";s:1:\"0\";s:9:\"start_num\";s:1:\"1\";s:10:\"c_rolltype\";s:1:\"0\";}','a:3:{s:5:\"div_w\";s:2:\"50\";s:5:\"div_h\";s:2:\"30\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','1484809277','0','29','0','0','default');
INSERT INTO `qb_label` VALUES ('20','','0','0','wz_shop_indexbanner2','pic','0','a:5:{s:6:\"imgurl\";s:31:\"../shop/images/default/mad1.png\";s:7:\"imglink\";s:1:\"#\";s:5:\"width\";s:4:\"1200\";s:6:\"height\";s:3:\"100\";s:11:\"pic_city_id\";i:0;}','a:3:{s:5:\"div_w\";s:0:\"\";s:5:\"div_h\";s:0:\"\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','0','0','29','0','0','default');
INSERT INTO `qb_label` VALUES ('21','','0','0','wz_shop_indexhead3','code','0','<div class=\"tag\"><span>Ʒ</span><i>/Promotion goods</i></div>\r\n<div class=\"more\"><a href=\"./all.php?show_type=2\">MORE</a></div>','a:4:{s:9:\"html_edit\";N;s:5:\"div_w\";s:2:\"50\";s:5:\"div_h\";s:2:\"21\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','1481694574','0','29','0','0','default');
INSERT INTO `qb_label` VALUES ('22','','0','0','wz_shop_indexbanner3','pic','0','a:5:{s:6:\"imgurl\";s:32:\"../shop/images/default/npic1.png\";s:7:\"imglink\";s:1:\"#\";s:5:\"width\";s:3:\"282\";s:6:\"height\";s:3:\"499\";s:11:\"pic_city_id\";i:0;}','a:3:{s:5:\"div_w\";s:0:\"\";s:5:\"div_h\";s:0:\"\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','1481686762','0','29','0','0','default');
INSERT INTO `qb_label` VALUES ('23','','0','0','wz_shop_indexbanner4','pic','0','a:5:{s:6:\"imgurl\";s:32:\"../shop/images/default/npic5.png\";s:7:\"imglink\";s:1:\"#\";s:5:\"width\";s:3:\"282\";s:6:\"height\";s:3:\"213\";s:11:\"pic_city_id\";i:0;}','a:3:{s:5:\"div_w\";s:0:\"\";s:5:\"div_h\";s:0:\"\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','0','0','29','0','0','default');
INSERT INTO `qb_label` VALUES ('24','','0','0','wz_shop_index2','Info_shop_','1','a:31:{s:7:\"allcity\";s:1:\"0\";s:13:\"tplpart_1code\";s:776:\"<!--\r\nEOT;\r\nforeach($listdb AS $key=>$rs){@extract($rs);\r\n$codeurl=urlencode(\"$webdb[www_url]/shop/wapbencandy.php?fid=$fid&id=$id\");\r\n$codeimg=\"$webdb[www_url]/do/2codeimg.php?url=$codeurl\";\r\nprint <<<EOT\r\n-->\r\n<div class=\"piclist\">\r\n	<div class=\"img\"><a href=\"{$url}\"><img src=\"$webdb[www_url]/do/minpic.php?wh=280:215&url=$picurl\" /></a></div>\r\n	<div class=\"word\">\r\n		<h3><a href=\"{$url}\">{$title}</a></h3>\r\n		<div class=\"buy\">\r\n			<div><span>{$price}</span></div>\r\n			<div><a href=\"{$url}\"></a></div>\r\n		</div>\r\n	</div>\r\n	<div class=\"scan_code\" onclick=\"window.open(\'$webdb[www_url]/shop/bencandy.php?fid=$fid&id=$id\')\">\r\n		<h3>ֻɨµ</h3>\r\n		<span><img src=\"{$codeimg}\" width=\"120\" height=\"120\" /></span>\r\n	</div>\r\n</div>\r\n<!--\r\nEOT;\r\n}\r\nprint <<<EOT\r\n-->\";s:13:\"tplpart_2code\";s:0:\"\";s:3:\"SYS\";s:2:\"wn\";s:6:\"wninfo\";s:5:\"shop_\";s:6:\"cityId\";N;s:5:\"width\";s:3:\"250\";s:6:\"height\";s:3:\"187\";s:8:\"rolltype\";s:10:\"scrollLeft\";s:8:\"rolltime\";s:1:\"3\";s:11:\"roll_height\";s:2:\"50\";s:11:\"content_num\";s:2:\"80\";s:7:\"newhour\";s:2:\"24\";s:7:\"hothits\";s:2:\"30\";s:7:\"tplpath\";s:0:\"\";s:6:\"DivTpl\";i:1;s:5:\"fiddb\";N;s:8:\"moduleid\";N;s:5:\"stype\";s:1:\"p\";s:2:\"yz\";s:3:\"all\";s:10:\"timeformat\";s:11:\"Y-m-d H:i:s\";s:5:\"order\";s:8:\"lastview\";s:3:\"asc\";s:4:\"DESC\";s:6:\"levels\";s:3:\"all\";s:7:\"rowspan\";s:1:\"6\";s:3:\"sql\";s:112:\"SELECT * FROM qb_shop_content  WHERE city_id=\'$GLOBALS[city_id]\'  AND ispic=1  ORDER BY lastview DESC LIMIT 0,6 \";s:7:\"colspan\";s:1:\"1\";s:8:\"titlenum\";s:2:\"20\";s:10:\"titleflood\";s:1:\"0\";s:9:\"start_num\";s:1:\"1\";s:10:\"c_rolltype\";s:1:\"0\";}','a:3:{s:5:\"div_w\";s:2:\"50\";s:5:\"div_h\";s:2:\"30\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','1484809260','0','29','0','0','default');
INSERT INTO `qb_label` VALUES ('25','','0','0','wz_shop_indexbanner5','pic','0','a:5:{s:6:\"imgurl\";s:31:\"../shop/images/default/mad2.png\";s:7:\"imglink\";s:1:\"#\";s:5:\"width\";s:4:\"1200\";s:6:\"height\";s:3:\"100\";s:11:\"pic_city_id\";i:0;}','a:3:{s:5:\"div_w\";s:0:\"\";s:5:\"div_h\";s:0:\"\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','0','0','29','0','0','default');
INSERT INTO `qb_label` VALUES ('27','','0','0','wz_hy_head','code','0','<a href=\"http://www_qibosoft_com/member/index.php?main=http://www_qibosoft_com/hy/member/post_company.php\">Ѽҳ</a>','a:4:{s:9:\"html_edit\";N;s:5:\"div_w\";s:2:\"50\";s:5:\"div_h\";s:2:\"21\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','1482481766','0','16','0','0','default');
INSERT INTO `qb_label` VALUES ('28','','0','0','wz_hy_head','code','0','<a href=\"http://life.net/member/index.php?main=http://life.net/hy/member/post_company.php\">Ѽҳ</a>','a:4:{s:9:\"html_edit\";N;s:5:\"div_w\";s:0:\"\";s:5:\"div_h\";s:0:\"\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','0','2','16','0','0','default');
INSERT INTO `qb_label` VALUES ('29','','0','0','wz_news_slide','rollpic','0','a:8:{s:13:\"tplpart_1code\";s:312:\"<div class=\"SlideContThe1\">\r\n	<ul>\r\n<!--\r\nEOT;\r\nforeach($listdb AS $rs){extract($rs);\r\nprint <<<EOT\r\n-->\r\n		<li><a href=\"$url\" title=\"$title\"><img src=\"$picurl\" name=\"$picurl\"/></a></li>\r\n<!--\r\nEOT;\r\n}\r\nprint <<<EOT\r\n-->		\r\n	</ul>\r\n</div>\r\n<script type=\"text/javascript\" src=\"./images/pc/slidecont1.js\"></script>\";s:8:\"rolltype\";s:1:\"2\";s:5:\"width\";s:0:\"\";s:6:\"height\";s:0:\"\";s:6:\"picurl\";a:9:{i:1;s:23:\"../news/images/pc/9.jpg\";i:2;s:23:\"../news/images/pc/1.jpg\";i:3;s:23:\"../news/images/pc/2.jpg\";i:4;s:23:\"../news/images/pc/3.jpg\";i:5;s:23:\"../news/images/pc/4.jpg\";i:6;s:23:\"../news/images/pc/5.jpg\";i:7;s:23:\"../news/images/pc/6.jpg\";i:8;s:23:\"../news/images/pc/7.jpg\";i:9;s:23:\"../news/images/pc/8.jpg\";}s:7:\"piclink\";a:9:{i:1;s:1:\"#\";i:2;s:1:\"#\";i:3;s:1:\"#\";i:4;s:1:\"#\";i:5;s:1:\"#\";i:6;s:1:\"#\";i:7;s:1:\"#\";i:8;s:1:\"#\";i:9;s:1:\"#\";}s:6:\"picalt\";a:9:{i:1;s:13:\"ʾͼƬ1\";i:2;s:13:\"ʾͼƬ2\";i:3;s:13:\"ʾͼƬ3\";i:4;s:13:\"ʾͼƬ4\";i:5;s:13:\"ʾͼƬ5\";i:6;s:13:\"ʾͼƬ6\";i:7;s:13:\"ʾͼƬ7\";i:8;s:13:\"ʾͼƬ8\";i:9;s:13:\"ʾͼƬ9\";}s:11:\"pic_city_id\";i:0;}','a:3:{s:5:\"div_w\";s:2:\"50\";s:5:\"div_h\";s:2:\"21\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','1481774270','0','20','0','0','default');
INSERT INTO `qb_label` VALUES ('30','','0','0','wz_news_pc1','code','0','<span>Ѷ</span><a href=\"list.php?fid=1\">&gt;&gt;</a>','a:4:{s:9:\"html_edit\";N;s:5:\"div_w\";s:2:\"50\";s:5:\"div_h\";s:2:\"30\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','1481774459','0','20','0','0','default');
INSERT INTO `qb_label` VALUES ('32','','0','0','wz_news_pc3','Info_news_','1','a:37:{s:7:\"allcity\";s:1:\"0\";s:13:\"tplpart_1code\";s:36:\"<li><a href=\"$url\">$title</a></li>\";s:13:\"tplpart_2code\";s:0:\"\";s:3:\"SYS\";s:2:\"wn\";s:6:\"wninfo\";s:5:\"news_\";s:9:\"noReadMid\";s:0:\"\";s:13:\"RollStyleType\";s:0:\"\";s:7:\"fidtype\";s:1:\"0\";s:8:\"rolltype\";s:10:\"scrollLeft\";s:8:\"rolltime\";s:1:\"3\";s:11:\"roll_height\";s:2:\"50\";s:5:\"width\";s:3:\"250\";s:6:\"height\";s:3:\"187\";s:7:\"newhour\";s:2:\"24\";s:7:\"hothits\";s:3:\"100\";s:7:\"amodule\";N;s:7:\"tplpath\";s:0:\"\";s:6:\"DivTpl\";i:1;s:5:\"fiddb\";N;s:5:\"stype\";s:1:\"4\";s:2:\"yz\";s:1:\"1\";s:7:\"hidefid\";N;s:10:\"timeformat\";s:11:\"Y-m-d H:i:s\";s:5:\"order\";s:6:\"A.list\";s:3:\"asc\";s:4:\"DESC\";s:6:\"levels\";s:3:\"all\";s:7:\"rowspan\";s:1:\"6\";s:3:\"sql\";s:117:\" SELECT A.* FROM qb_news_content A  WHERE A.city_id=\'$GLOBALS[city_id]\'  AND A.yz=1   ORDER BY A.list DESC LIMIT 0,6 \";s:4:\"sql2\";N;s:7:\"colspan\";s:1:\"1\";s:11:\"content_num\";s:2:\"80\";s:12:\"content_num2\";s:3:\"120\";s:8:\"titlenum\";s:2:\"60\";s:9:\"titlenum2\";s:2:\"40\";s:10:\"titleflood\";s:1:\"0\";s:9:\"start_num\";s:1:\"1\";s:10:\"c_rolltype\";s:1:\"0\";}','a:3:{s:5:\"div_w\";s:2:\"50\";s:5:\"div_h\";s:2:\"30\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','1481778847','0','20','0','0','default');
INSERT INTO `qb_label` VALUES ('33','','0','0','wz_news_pc4','code','0','<span>ʳѶ</span><a href=\"list.php?fid=2\">&gt;&gt;</a>','a:4:{s:9:\"html_edit\";N;s:5:\"div_w\";s:2:\"50\";s:5:\"div_h\";s:2:\"30\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','1481778907','0','20','0','0','default');
INSERT INTO `qb_label` VALUES ('31','','0','0','wz_news_pc2','Info_news_','1','a:37:{s:7:\"allcity\";s:1:\"0\";s:13:\"tplpart_1code\";s:784:\"<!--\r\nEOT;\r\nforeach($listdb AS $rs){extract($rs);\r\n$codeurl=urlencode(\"$webdb[www_url]/news/bencandy.php?fid=$rs[fid]&id=$rs[id]\");\r\n$rs[codeimg] = \"$webdb[www_url]/do/2codeimg.php?url=$codeurl\";\r\n$showpics=$picurl?\"<dt><a href=\\\"$url\\\"><img src=\\\"$webdb[www_url]/do/minpic.php?wh=260:200&url=$picurl\\\" onerror=\\\"this.src=\'/images/default/nopic.jpg\'\\\"/></a></dt>\":\"\";\r\nprint <<<EOT\r\n-->\r\n<li>\r\n	<dl>\r\n		$showpics\r\n		<dd>\r\n			<h4><a href=\"$url\">$title</a></h4>\r\n			<p>$content</p>\r\n			<div><span>:$hits</span> <em>ʱ:$posttime</em></div>\r\n		</dd>\r\n		<dd class=\"img_code\" onclick=\"window.open(\'$webdb[www_url]/news/bencandy.php?fid=$rs[fid]&id=$rs[id]\')\"><span>ɨһɨֻ鿴</span><span><img src=\"$rs[codeimg]\"/></span></dd>\r\n	</dl>\r\n</li>\r\n<!--\r\nEOT;\r\n}\r\nprint <<<EOT\r\n-->\";s:13:\"tplpart_2code\";s:0:\"\";s:3:\"SYS\";s:2:\"wn\";s:6:\"wninfo\";s:5:\"news_\";s:9:\"noReadMid\";s:0:\"\";s:13:\"RollStyleType\";s:0:\"\";s:7:\"fidtype\";s:1:\"0\";s:8:\"rolltype\";s:10:\"scrollLeft\";s:8:\"rolltime\";s:1:\"3\";s:11:\"roll_height\";s:2:\"50\";s:5:\"width\";s:3:\"250\";s:6:\"height\";s:3:\"187\";s:7:\"newhour\";s:2:\"24\";s:7:\"hothits\";s:3:\"100\";s:7:\"amodule\";N;s:7:\"tplpath\";s:0:\"\";s:6:\"DivTpl\";i:1;s:5:\"fiddb\";N;s:5:\"stype\";s:2:\"cp\";s:2:\"yz\";s:1:\"1\";s:7:\"hidefid\";N;s:10:\"timeformat\";s:11:\"Y-m-d H:i:s\";s:5:\"order\";s:6:\"A.list\";s:3:\"asc\";s:4:\"DESC\";s:6:\"levels\";s:3:\"all\";s:7:\"rowspan\";s:1:\"4\";s:3:\"sql\";s:215:\" SELECT A.*,R.content FROM qb_news_content A LEFT JOIN qb_news_content_1 R ON A.id=R.id  WHERE A.city_id=\'$GLOBALS[city_id]\'  AND A.yz=1  AND A.ispic=1   AND R.topic=1  AND A.ispic=1  ORDER BY A.list DESC LIMIT 0,4 \";s:4:\"sql2\";N;s:7:\"colspan\";s:1:\"1\";s:11:\"content_num\";s:3:\"200\";s:12:\"content_num2\";s:3:\"120\";s:8:\"titlenum\";s:2:\"60\";s:9:\"titlenum2\";s:2:\"40\";s:10:\"titleflood\";s:1:\"0\";s:9:\"start_num\";s:1:\"1\";s:10:\"c_rolltype\";s:1:\"0\";}','a:3:{s:5:\"div_w\";s:2:\"50\";s:5:\"div_h\";s:2:\"30\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','1484808516','0','20','0','0','default');
INSERT INTO `qb_label` VALUES ('34','','0','0','wz_news_pc5','Info_news_','1','a:37:{s:7:\"allcity\";s:1:\"0\";s:13:\"tplpart_1code\";s:784:\"<!--\r\nEOT;\r\nforeach($listdb AS $rs){extract($rs);\r\n$codeurl=urlencode(\"$webdb[www_url]/news/bencandy.php?fid=$rs[fid]&id=$rs[id]\");\r\n$rs[codeimg] = \"$webdb[www_url]/do/2codeimg.php?url=$codeurl\";\r\n$showpics=$picurl?\"<dt><a href=\\\"$url\\\"><img src=\\\"$webdb[www_url]/do/minpic.php?wh=260:200&url=$picurl\\\" onerror=\\\"this.src=\'/images/default/nopic.jpg\'\\\"/></a></dt>\":\"\";\r\nprint <<<EOT\r\n-->\r\n<li>\r\n	<dl>\r\n		$showpics\r\n		<dd>\r\n			<h4><a href=\"$url\">$title</a></h4>\r\n			<p>$content</p>\r\n			<div><span>:$hits</span> <em>ʱ:$posttime</em></div>\r\n		</dd>\r\n		<dd class=\"img_code\" onclick=\"window.open(\'$webdb[www_url]/news/bencandy.php?fid=$rs[fid]&id=$rs[id]\')\"><span>ɨһɨֻ鿴</span><span><img src=\"$rs[codeimg]\"/></span></dd>\r\n	</dl>\r\n</li>\r\n<!--\r\nEOT;\r\n}\r\nprint <<<EOT\r\n-->\";s:13:\"tplpart_2code\";s:0:\"\";s:3:\"SYS\";s:2:\"wn\";s:6:\"wninfo\";s:5:\"news_\";s:9:\"noReadMid\";s:0:\"\";s:13:\"RollStyleType\";s:0:\"\";s:7:\"fidtype\";s:1:\"0\";s:8:\"rolltype\";s:10:\"scrollLeft\";s:8:\"rolltime\";s:1:\"3\";s:11:\"roll_height\";s:2:\"50\";s:5:\"width\";s:3:\"250\";s:6:\"height\";s:3:\"187\";s:7:\"newhour\";s:2:\"24\";s:7:\"hothits\";s:3:\"100\";s:7:\"amodule\";N;s:7:\"tplpath\";s:0:\"\";s:6:\"DivTpl\";i:1;s:5:\"fiddb\";N;s:5:\"stype\";s:2:\"cp\";s:2:\"yz\";s:1:\"1\";s:7:\"hidefid\";N;s:10:\"timeformat\";s:11:\"Y-m-d H:i:s\";s:5:\"order\";s:6:\"A.list\";s:3:\"asc\";s:4:\"DESC\";s:6:\"levels\";s:3:\"all\";s:7:\"rowspan\";s:1:\"2\";s:3:\"sql\";s:215:\" SELECT A.*,R.content FROM qb_news_content A LEFT JOIN qb_news_content_1 R ON A.id=R.id  WHERE A.city_id=\'$GLOBALS[city_id]\'  AND A.yz=1  AND A.ispic=1   AND R.topic=1  AND A.ispic=1  ORDER BY A.list DESC LIMIT 0,2 \";s:4:\"sql2\";N;s:7:\"colspan\";s:1:\"1\";s:11:\"content_num\";s:3:\"200\";s:12:\"content_num2\";s:3:\"120\";s:8:\"titlenum\";s:2:\"60\";s:9:\"titlenum2\";s:2:\"40\";s:10:\"titleflood\";s:1:\"0\";s:9:\"start_num\";s:1:\"1\";s:10:\"c_rolltype\";s:1:\"0\";}','a:3:{s:5:\"div_w\";s:2:\"50\";s:5:\"div_h\";s:2:\"30\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','1484808697','0','20','0','0','default');
INSERT INTO `qb_label` VALUES ('35','','0','0','wz_news_pc7','code','0','<span></span><a href=\"list.php?fid=3\">&gt;&gt;</a>','a:4:{s:9:\"html_edit\";N;s:5:\"div_w\";s:0:\"\";s:5:\"div_h\";s:0:\"\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','0','0','20','0','0','default');
INSERT INTO `qb_label` VALUES ('36','','0','0','wz_news_pc8','Info_news_','1','a:37:{s:7:\"allcity\";s:1:\"0\";s:13:\"tplpart_1code\";s:49:\"<li><span></span><a href=\"$url\">$title</a></li>\";s:13:\"tplpart_2code\";s:0:\"\";s:3:\"SYS\";s:2:\"wn\";s:6:\"wninfo\";s:5:\"news_\";s:9:\"noReadMid\";s:0:\"\";s:13:\"RollStyleType\";s:0:\"\";s:7:\"fidtype\";s:1:\"0\";s:8:\"rolltype\";s:10:\"scrollLeft\";s:8:\"rolltime\";s:1:\"3\";s:11:\"roll_height\";s:2:\"50\";s:5:\"width\";s:3:\"250\";s:6:\"height\";s:3:\"187\";s:7:\"newhour\";s:2:\"24\";s:7:\"hothits\";s:3:\"100\";s:7:\"amodule\";N;s:7:\"tplpath\";s:0:\"\";s:6:\"DivTpl\";i:1;s:5:\"fiddb\";N;s:5:\"stype\";s:1:\"4\";s:2:\"yz\";s:1:\"1\";s:7:\"hidefid\";N;s:10:\"timeformat\";s:11:\"Y-m-d H:i:s\";s:5:\"order\";s:6:\"A.list\";s:3:\"asc\";s:4:\"DESC\";s:6:\"levels\";s:3:\"all\";s:7:\"rowspan\";s:2:\"12\";s:3:\"sql\";s:118:\" SELECT A.* FROM qb_news_content A  WHERE A.city_id=\'$GLOBALS[city_id]\'  AND A.yz=1   ORDER BY A.list DESC LIMIT 0,12 \";s:4:\"sql2\";N;s:7:\"colspan\";s:1:\"1\";s:11:\"content_num\";s:2:\"80\";s:12:\"content_num2\";s:3:\"120\";s:8:\"titlenum\";s:2:\"60\";s:9:\"titlenum2\";s:2:\"40\";s:10:\"titleflood\";s:1:\"0\";s:9:\"start_num\";s:1:\"1\";s:10:\"c_rolltype\";s:1:\"0\";}','a:3:{s:5:\"div_w\";s:2:\"50\";s:5:\"div_h\";s:2:\"30\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','0','0','20','0','0','default');
INSERT INTO `qb_label` VALUES ('37','','0','0','wz_news_pc9','code','0','<span>ͼƬ</span><a href=\"list.php?fid=3\">&gt;&gt;</a>','a:4:{s:9:\"html_edit\";N;s:5:\"div_w\";s:0:\"\";s:5:\"div_h\";s:0:\"\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','0','0','20','0','0','default');
INSERT INTO `qb_label` VALUES ('38','','0','0','wz_news_pc10','Info_news_','1','a:37:{s:7:\"allcity\";s:1:\"0\";s:13:\"tplpart_1code\";s:208:\"<li>\r\n	<dl>\r\n		<dt><a href=\"$url\"><img src=\"$webdb[www_url]/do/minpic.php?wh=320:240&url=$picurl\" onerror=\"this.src=\'/images/default/nopic.jpg\'\"/></a></dt>\r\n		<dd><a href=\"$url\">$title</a></dd>\r\n	</dl>\r\n</li>\";s:13:\"tplpart_2code\";s:0:\"\";s:3:\"SYS\";s:2:\"wn\";s:6:\"wninfo\";s:5:\"news_\";s:9:\"noReadMid\";s:0:\"\";s:13:\"RollStyleType\";s:0:\"\";s:7:\"fidtype\";s:1:\"0\";s:8:\"rolltype\";s:10:\"scrollLeft\";s:8:\"rolltime\";s:1:\"3\";s:11:\"roll_height\";s:2:\"50\";s:5:\"width\";s:3:\"250\";s:6:\"height\";s:3:\"187\";s:7:\"newhour\";s:2:\"24\";s:7:\"hothits\";s:3:\"100\";s:7:\"amodule\";N;s:7:\"tplpath\";s:0:\"\";s:6:\"DivTpl\";i:1;s:5:\"fiddb\";N;s:5:\"stype\";s:1:\"p\";s:2:\"yz\";s:1:\"1\";s:7:\"hidefid\";N;s:10:\"timeformat\";s:11:\"Y-m-d H:i:s\";s:5:\"order\";s:6:\"A.list\";s:3:\"asc\";s:4:\"DESC\";s:6:\"levels\";s:3:\"all\";s:7:\"rowspan\";s:1:\"3\";s:3:\"sql\";s:147:\" SELECT A.* FROM qb_news_content A  WHERE A.city_id=\'$GLOBALS[city_id]\'  AND A.yz=1  AND A.ispic=1   AND A.ispic=1  ORDER BY A.list DESC LIMIT 0,3 \";s:4:\"sql2\";N;s:7:\"colspan\";s:1:\"1\";s:11:\"content_num\";s:2:\"80\";s:12:\"content_num2\";s:3:\"120\";s:8:\"titlenum\";s:2:\"60\";s:9:\"titlenum2\";s:2:\"40\";s:10:\"titleflood\";s:1:\"0\";s:9:\"start_num\";s:1:\"1\";s:10:\"c_rolltype\";s:1:\"0\";}','a:3:{s:5:\"div_w\";s:2:\"50\";s:5:\"div_h\";s:2:\"30\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','1484808595','0','20','0','0','default');
INSERT INTO `qb_label` VALUES ('39','','0','0','wz_news_pc11','code','0','<span>ɹ</span><a href=\"list.php?fid=3\">&gt;&gt;</a>','a:4:{s:9:\"html_edit\";N;s:5:\"div_w\";s:0:\"\";s:5:\"div_h\";s:0:\"\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','0','0','20','0','0','default');
INSERT INTO `qb_label` VALUES ('40','','0','0','wz_news_pc12','Info_news_','1','a:37:{s:7:\"allcity\";s:1:\"0\";s:13:\"tplpart_1code\";s:289:\"<li>\r\n	<dl>\r\n		<dt><a href=\"$url\"><img src=\"$webdb[www_url]/do/minpic.php?wh=320:240&url=$picurl\" onerror=\"this.src=\'/images/default/nopic.jpg\'\"/></a></dt>\r\n		<dd>\r\n			<h4><a href=\"$url\">$title</a></h4>\r\n			<p>$content</p>\r\n			<div><a href=\"$url\">鿴</a></div>\r\n		</dd>\r\n	</dl>\r\n</li>\";s:13:\"tplpart_2code\";s:0:\"\";s:3:\"SYS\";s:2:\"wn\";s:6:\"wninfo\";s:5:\"news_\";s:9:\"noReadMid\";s:0:\"\";s:13:\"RollStyleType\";s:0:\"\";s:7:\"fidtype\";s:1:\"0\";s:8:\"rolltype\";s:10:\"scrollLeft\";s:8:\"rolltime\";s:1:\"3\";s:11:\"roll_height\";s:2:\"50\";s:5:\"width\";s:3:\"250\";s:6:\"height\";s:3:\"187\";s:7:\"newhour\";s:2:\"24\";s:7:\"hothits\";s:3:\"100\";s:7:\"amodule\";N;s:7:\"tplpath\";s:0:\"\";s:6:\"DivTpl\";i:1;s:5:\"fiddb\";N;s:5:\"stype\";s:2:\"cp\";s:2:\"yz\";s:1:\"1\";s:7:\"hidefid\";N;s:10:\"timeformat\";s:11:\"Y-m-d H:i:s\";s:5:\"order\";s:6:\"A.list\";s:3:\"asc\";s:4:\"DESC\";s:6:\"levels\";s:3:\"all\";s:7:\"rowspan\";s:1:\"2\";s:3:\"sql\";s:215:\" SELECT A.*,R.content FROM qb_news_content A LEFT JOIN qb_news_content_1 R ON A.id=R.id  WHERE A.city_id=\'$GLOBALS[city_id]\'  AND A.yz=1  AND A.ispic=1   AND R.topic=1  AND A.ispic=1  ORDER BY A.list DESC LIMIT 0,2 \";s:4:\"sql2\";N;s:7:\"colspan\";s:1:\"1\";s:11:\"content_num\";s:3:\"300\";s:12:\"content_num2\";s:3:\"120\";s:8:\"titlenum\";s:2:\"60\";s:9:\"titlenum2\";s:2:\"40\";s:10:\"titleflood\";s:1:\"0\";s:9:\"start_num\";s:1:\"1\";s:10:\"c_rolltype\";s:1:\"0\";}','a:3:{s:5:\"div_w\";s:2:\"50\";s:5:\"div_h\";s:2:\"30\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','1484808659','0','20','0','0','default');
INSERT INTO `qb_label` VALUES ('41','','0','0','wz_news_pc13','code','0','<span>ͼƬ</span><a href=\"list.php?fid=2\">&gt;&gt;</a>','a:4:{s:9:\"html_edit\";N;s:5:\"div_w\";s:0:\"\";s:5:\"div_h\";s:0:\"\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','0','0','20','0','0','default');
INSERT INTO `qb_label` VALUES ('42','','0','0','wz_news_pc14','Info_news_','1','a:37:{s:7:\"allcity\";s:1:\"0\";s:13:\"tplpart_1code\";s:191:\"<dl>\r\n	<dt><a href=\"$url\"><img src=\"$webdb[www_url]/do/minpic.php?wh=395:250&url=$picurl\" onerror=\"this.src=\'/images/default/nopic.jpg\'\"/></a></dt>\r\n	<dd><a href=\"$url\">$title</a></dd>\r\n</dl>\";s:13:\"tplpart_2code\";s:0:\"\";s:3:\"SYS\";s:2:\"wn\";s:6:\"wninfo\";s:5:\"news_\";s:9:\"noReadMid\";s:0:\"\";s:13:\"RollStyleType\";s:0:\"\";s:7:\"fidtype\";s:1:\"0\";s:8:\"rolltype\";s:10:\"scrollLeft\";s:8:\"rolltime\";s:1:\"3\";s:11:\"roll_height\";s:2:\"50\";s:5:\"width\";s:3:\"250\";s:6:\"height\";s:3:\"187\";s:7:\"newhour\";s:2:\"24\";s:7:\"hothits\";s:3:\"100\";s:7:\"amodule\";N;s:7:\"tplpath\";s:0:\"\";s:6:\"DivTpl\";i:1;s:5:\"fiddb\";N;s:5:\"stype\";s:1:\"p\";s:2:\"yz\";s:1:\"1\";s:7:\"hidefid\";N;s:10:\"timeformat\";s:11:\"Y-m-d H:i:s\";s:5:\"order\";s:6:\"A.list\";s:3:\"asc\";s:4:\"DESC\";s:6:\"levels\";s:3:\"all\";s:7:\"rowspan\";s:1:\"3\";s:3:\"sql\";s:147:\" SELECT A.* FROM qb_news_content A  WHERE A.city_id=\'$GLOBALS[city_id]\'  AND A.yz=1  AND A.ispic=1   AND A.ispic=1  ORDER BY A.list DESC LIMIT 0,3 \";s:4:\"sql2\";N;s:7:\"colspan\";s:1:\"1\";s:11:\"content_num\";s:2:\"80\";s:12:\"content_num2\";s:3:\"120\";s:8:\"titlenum\";s:2:\"60\";s:9:\"titlenum2\";s:2:\"40\";s:10:\"titleflood\";s:1:\"0\";s:9:\"start_num\";s:1:\"1\";s:10:\"c_rolltype\";s:1:\"0\";}','a:3:{s:5:\"div_w\";s:2:\"50\";s:5:\"div_h\";s:2:\"30\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','1484808769','0','20','0','0','default');
INSERT INTO `qb_label` VALUES ('43','','0','0','wz_news_pc15','Info_news_','1','a:37:{s:7:\"allcity\";s:1:\"0\";s:13:\"tplpart_1code\";s:191:\"<dl>\r\n	<dt><a href=\"$url\"><img src=\"$webdb[www_url]/do/minpic.php?wh=295:350&url=$picurl\" onerror=\"this.src=\'/images/default/nopic.jpg\'\"/></a></dt>\r\n	<dd><a href=\"$url\">$title</a></dd>\r\n</dl>\";s:13:\"tplpart_2code\";s:0:\"\";s:3:\"SYS\";s:2:\"wn\";s:6:\"wninfo\";s:5:\"news_\";s:9:\"noReadMid\";s:0:\"\";s:13:\"RollStyleType\";s:0:\"\";s:7:\"fidtype\";s:1:\"0\";s:8:\"rolltype\";s:10:\"scrollLeft\";s:8:\"rolltime\";s:1:\"3\";s:11:\"roll_height\";s:2:\"50\";s:5:\"width\";s:3:\"250\";s:6:\"height\";s:3:\"187\";s:7:\"newhour\";s:2:\"24\";s:7:\"hothits\";s:3:\"100\";s:7:\"amodule\";N;s:7:\"tplpath\";s:0:\"\";s:6:\"DivTpl\";i:1;s:5:\"fiddb\";N;s:5:\"stype\";s:1:\"p\";s:2:\"yz\";s:1:\"1\";s:7:\"hidefid\";N;s:10:\"timeformat\";s:11:\"Y-m-d H:i:s\";s:5:\"order\";s:6:\"A.hits\";s:3:\"asc\";s:4:\"DESC\";s:6:\"levels\";s:3:\"all\";s:7:\"rowspan\";s:1:\"4\";s:3:\"sql\";s:147:\" SELECT A.* FROM qb_news_content A  WHERE A.city_id=\'$GLOBALS[city_id]\'  AND A.yz=1  AND A.ispic=1   AND A.ispic=1  ORDER BY A.hits DESC LIMIT 0,4 \";s:4:\"sql2\";N;s:7:\"colspan\";s:1:\"1\";s:11:\"content_num\";s:2:\"80\";s:12:\"content_num2\";s:3:\"120\";s:8:\"titlenum\";s:2:\"60\";s:9:\"titlenum2\";s:2:\"40\";s:10:\"titleflood\";s:1:\"0\";s:9:\"start_num\";s:1:\"1\";s:10:\"c_rolltype\";s:1:\"0\";}','a:3:{s:5:\"div_w\";s:2:\"50\";s:5:\"div_h\";s:2:\"30\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','1484808968','0','20','0','0','default');
INSERT INTO `qb_label` VALUES ('44','','0','0','wz_news_pc6','Info_news_','1','a:37:{s:7:\"allcity\";s:1:\"0\";s:13:\"tplpart_1code\";s:36:\"<li><a href=\"$url\">$title</a></li>\";s:13:\"tplpart_2code\";s:0:\"\";s:3:\"SYS\";s:2:\"wn\";s:6:\"wninfo\";s:5:\"news_\";s:9:\"noReadMid\";s:0:\"\";s:13:\"RollStyleType\";s:0:\"\";s:7:\"fidtype\";s:1:\"0\";s:8:\"rolltype\";s:10:\"scrollLeft\";s:8:\"rolltime\";s:1:\"3\";s:11:\"roll_height\";s:2:\"50\";s:5:\"width\";s:3:\"250\";s:6:\"height\";s:3:\"187\";s:7:\"newhour\";s:2:\"24\";s:7:\"hothits\";s:3:\"100\";s:7:\"amodule\";N;s:7:\"tplpath\";s:0:\"\";s:6:\"DivTpl\";i:1;s:5:\"fiddb\";N;s:5:\"stype\";s:1:\"4\";s:2:\"yz\";s:1:\"1\";s:7:\"hidefid\";N;s:10:\"timeformat\";s:11:\"Y-m-d H:i:s\";s:5:\"order\";s:6:\"A.list\";s:3:\"asc\";s:4:\"DESC\";s:6:\"levels\";s:3:\"all\";s:7:\"rowspan\";s:1:\"6\";s:3:\"sql\";s:117:\" SELECT A.* FROM qb_news_content A  WHERE A.city_id=\'$GLOBALS[city_id]\'  AND A.yz=1   ORDER BY A.list DESC LIMIT 0,6 \";s:4:\"sql2\";N;s:7:\"colspan\";s:1:\"1\";s:11:\"content_num\";s:2:\"80\";s:12:\"content_num2\";s:3:\"120\";s:8:\"titlenum\";s:2:\"60\";s:9:\"titlenum2\";s:2:\"40\";s:10:\"titleflood\";s:1:\"0\";s:9:\"start_num\";s:1:\"1\";s:10:\"c_rolltype\";s:1:\"0\";}','a:3:{s:5:\"div_w\";s:2:\"50\";s:5:\"div_h\";s:2:\"30\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','0','0','20','0','0','default');
INSERT INTO `qb_label` VALUES ('96','','0','0','wapindex_flash','rollpic','0','a:8:{s:13:\"tplpart_1code\";s:2566:\"<style>\r\nbody{max-width:640px; margin:auto;}\r\n.ShowSlide{\r\n	width:100%;\r\n	border-top:#DDD solid 1px;\r\n	border-bottom:#DDD solid 1px;\r\n	margin:10px auto;\r\n	background:#FFF;\r\n	position:relative;\r\n}\r\n#slide,#slide .cell,#slide .cell img { \r\n	height:auto;\r\n}\r\n#slide{ \r\n	position:static; \r\n	z-index:2; \r\n	background-color:#f3f3f3;\r\n	margin:auto; \r\n	width:100%; \r\n	overflow: hidden; \r\n	-webkit-user-select:none; \r\n	-moz-user-select:none; \r\n	-ms-user-select:none; \r\n	-o-user-select:none; \r\n	user-select:none;\r\n}\r\n#slide .cell{ \r\n	position:relative; \r\n	z-index:2; \r\n	width:100%;\r\n	vertical-align:middle;\r\n	display:table-cell;\r\n}\r\n#slide .cell .title { \r\n	display:none;\r\n}\r\n#slide .cell img { \r\n	vertical-align:top; \r\n	width:100%; \r\n	height:auto; \r\n	display:block;\r\n	cursor:pointer;\r\n}\r\n#indicator { \r\n	position:absolute; \r\n	width:100%;\r\n	bottom:0;\r\n	left:0;\r\n	text-align:center;\r\n}\r\n#indicator li {\r\n	color:#fff; \r\n	margin:0 4px; \r\n	text-indent:-999em;  \r\n	width:8px; \r\n	height:8px; \r\n	border-radius:8px;  \r\n	display:inline-block;\r\n	overflow:hidden;\r\n	background-color:#ccc;\r\n}\r\n#indicator .active { \r\n	background-color:#f50;\r\n}\r\n</style>\r\n<div class=\"ShowSlide\">\r\n<script src=\"/shop/images/wap/slide.js\"></script>\r\n<div id=\"slide\" class=\"clearfix\" style=\"display:none\">\r\n	<div id=\"content\">\r\n<!--\r\nEOT;\r\nforeach($listdb AS $rs){extract($rs);\r\nprint <<<EOT\r\n-->\r\n		<li class=\'cell\'><a href=\"$url\" title=\"$title\"><img src=\"$picurl\" name=\"$picurl\"/><span class=\'title\'>$title</span></a></li>\r\n<!--\r\nEOT;\r\n}\r\nprint <<<EOT\r\n-->\r\n	</div>\r\n	<ul id=\"indicator\"></ul>\r\n	<span class=\"prev\" id=\"slide_prev\" style=\"display:none\">һ</span><span class=\"next\" id=\"slide_next\" style=\"display:none\">һ</span>\r\n</div>\r\n<script>\r\n(function($){\r\n	var list = $(\'#content\').find(\'.cell\');\r\n	if(list.length > 0){\r\n		$(\'#slide\').show();\r\n		var txt = \'\';\r\n		$(\'#content\').find(\'.cell\').each(function(i){\r\n			if(i === 0){\r\n				txt += \'<li class=\"active\">1</li>\';\r\n			}else{\r\n				txt += \'<li>\'+(i+1)+\'</li>\';\r\n			}\r\n		});\r\n		$(\'#indicator\').html(txt);\r\n		setTimeout(function(){new C_Scroll({container:\'slide\',content:\'content\',ct:\'indicator\',size:\'400\',intervalTime:5000,lazyIMG:!!0});},200);\r\n	}\r\n	/*$(\'#content img\').click(function(){\r\n		var pics=$(this).attr(\"src\");\r\n		var picdbs=new Array();\r\n		var i=0;\r\n		$(\'#content img\').each(function(){\r\n			var thisurl=$(this).attr(\"src\");\r\n			picdbs[i]=thisurl;\r\n			i++;\r\n		});\r\n		view_pic1(pics,picdbs);\r\n	});*/\r\n})(jQuery);\r\n/*function view_pic1(pic,picdbs) {	\r\n	wx.previewImage({\r\n	  current: pic,\r\n	  urls:picdbs\r\n	});\r\n}*/\r\n</script>\r\n</div>\";s:8:\"rolltype\";s:1:\"2\";s:5:\"width\";s:0:\"\";s:6:\"height\";s:0:\"\";s:6:\"picurl\";a:3:{i:1;s:23:\"../images/wap/flash.png\";i:2;s:24:\"../images/wap/flash1.png\";i:3;s:24:\"../images/wap/flash2.png\";}s:7:\"piclink\";a:3:{i:1;s:1:\"#\";i:2;s:1:\"#\";i:3;s:1:\"#\";}s:6:\"picalt\";a:3:{i:1;s:0:\"\";i:2;s:0:\"\";i:3;s:0:\"\";}s:11:\"pic_city_id\";i:0;}','a:3:{s:5:\"div_w\";s:2:\"50\";s:5:\"div_h\";s:2:\"21\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','1482123030','8','0','0','0','default');
INSERT INTO `qb_label` VALUES ('97','','0','0','wapindex_banner1','pic','0','a:5:{s:6:\"imgurl\";s:35:\"../images/style7.0/index/banner.png\";s:7:\"imglink\";s:1:\"#\";s:5:\"width\";s:0:\"\";s:6:\"height\";s:0:\"\";s:11:\"pic_city_id\";i:0;}','a:3:{s:5:\"div_w\";s:0:\"\";s:5:\"div_h\";s:0:\"\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','0','8','0','0','0','default');
INSERT INTO `qb_label` VALUES ('98','','0','0','wapindex_likes','Info_shop_','1','a:31:{s:7:\"allcity\";s:1:\"0\";s:13:\"tplpart_1code\";s:513:\"<dl class=\"Showbox\">\r\n  	\r\n      <dd class=\"pic\"><p><span><a href=\"$webdb[www_url]/shop/wapbencandy.php?fid=$fid&id=$id\"><img src=\"$webdb[www_url]/do/minpic.php?wh=400:300&url=$picurl\" onerror=\"this.src=\'$webdb[www_url]/images/default/nopic.jpg\'\"/></a></p></span></dd>\r\n      <dt><a href=\"$webdb[www_url]/shop/wapbencandy.php?fid=$fid&id=$id\">$title</a></dt>\r\n<dd class=\"jg\">\r\n  <em>{$market_price}</em>\r\n  <span>{$price}</span><a href=\"$webdb[www_url]/shop/wapbencandy.php?fid=$fid&id=$id\"></a>\r\n</dd>\r\n</dl>\";s:13:\"tplpart_2code\";s:0:\"\";s:3:\"SYS\";s:2:\"wn\";s:6:\"wninfo\";s:5:\"shop_\";s:6:\"cityId\";N;s:5:\"width\";s:3:\"250\";s:6:\"height\";s:3:\"187\";s:8:\"rolltype\";s:10:\"scrollLeft\";s:8:\"rolltime\";s:1:\"3\";s:11:\"roll_height\";s:2:\"50\";s:11:\"content_num\";s:2:\"80\";s:7:\"newhour\";s:2:\"24\";s:7:\"hothits\";s:2:\"30\";s:7:\"tplpath\";s:0:\"\";s:6:\"DivTpl\";i:1;s:5:\"fiddb\";N;s:8:\"moduleid\";N;s:5:\"stype\";s:1:\"p\";s:2:\"yz\";s:3:\"all\";s:10:\"timeformat\";s:11:\"Y-m-d H:i:s\";s:5:\"order\";s:4:\"list\";s:3:\"asc\";s:4:\"DESC\";s:6:\"levels\";s:3:\"all\";s:7:\"rowspan\";s:1:\"4\";s:3:\"sql\";s:108:\"SELECT * FROM qb_shop_content  WHERE city_id=\'$GLOBALS[city_id]\'  AND ispic=1  ORDER BY list DESC LIMIT 0,4 \";s:7:\"colspan\";s:1:\"1\";s:8:\"titlenum\";s:2:\"50\";s:10:\"titleflood\";s:1:\"0\";s:9:\"start_num\";s:1:\"1\";s:10:\"c_rolltype\";s:1:\"0\";}','a:3:{s:5:\"div_w\";s:2:\"50\";s:5:\"div_h\";s:2:\"30\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','1484986782','8','0','0','0','default');
INSERT INTO `qb_label` VALUES ('99','','0','0','wapindex_banner2','pic','0','a:5:{s:6:\"imgurl\";s:31:\"../images/wap/server_banner.png\";s:7:\"imglink\";s:0:\"\";s:5:\"width\";s:0:\"\";s:6:\"height\";s:0:\"\";s:11:\"pic_city_id\";i:0;}','a:3:{s:5:\"div_w\";s:0:\"\";s:5:\"div_h\";s:0:\"\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','0','8','0','0','0','default');
INSERT INTO `qb_label` VALUES ('100','','0','0','wapindex_newt1','code','0','<li><a href=\"../news/waplist.php?fid=1\">Ѷ</a></li>\r\n<li><a href=\"../news/waplist.php?fid=36\">ʳѶ</a></li>\r\n<li><a href=\"../news/waplist.php?fid=32\">ͼƬ</a></li>\r\n<li><a href=\"../news/waplist.php?fid=43\"></a></li>','a:4:{s:9:\"html_edit\";N;s:5:\"div_w\";s:0:\"\";s:5:\"div_h\";s:0:\"\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','0','8','0','0','0','default');
INSERT INTO `qb_label` VALUES ('101','','0','0','wapindex_newc1','Info_news_','1','a:37:{s:7:\"allcity\";s:1:\"0\";s:13:\"tplpart_1code\";s:402:\"<dl class=\"NewsList\">\r\n	<dt><a href=\"$webdb[www_url]/news/wapbencandy.php?fid=$fid&id=$id\"><img src=\"$webdb[www_url]/do/minpic.php?wh=127:95&url=$picurl\" onerror=\"src=\'$webdb[www_url]/images/wap/newspic.png\'\"/></a></dt>\r\n    <dd>\r\n    	<p><a href=\"$webdb[www_url]/news/wapbencandy.php?fid=$fid&id=$id\">{$title}</a></p>\r\n    	<div><span>{$username}</span><span>{$posttime}</span></div>\r\n    </dd>\r\n</dl>\";s:13:\"tplpart_2code\";s:0:\"\";s:3:\"SYS\";s:2:\"wn\";s:6:\"wninfo\";s:5:\"news_\";s:9:\"noReadMid\";s:0:\"\";s:13:\"RollStyleType\";s:0:\"\";s:7:\"fidtype\";s:1:\"0\";s:8:\"rolltype\";s:10:\"scrollLeft\";s:8:\"rolltime\";s:1:\"3\";s:11:\"roll_height\";s:2:\"50\";s:5:\"width\";s:3:\"250\";s:6:\"height\";s:3:\"187\";s:7:\"newhour\";s:2:\"24\";s:7:\"hothits\";s:3:\"100\";s:7:\"amodule\";N;s:7:\"tplpath\";s:0:\"\";s:6:\"DivTpl\";i:1;s:5:\"fiddb\";N;s:5:\"stype\";s:1:\"p\";s:2:\"yz\";s:1:\"1\";s:7:\"hidefid\";N;s:10:\"timeformat\";s:11:\"Y-m-d H:i:s\";s:5:\"order\";s:6:\"A.list\";s:3:\"asc\";s:4:\"DESC\";s:6:\"levels\";s:3:\"all\";s:7:\"rowspan\";s:1:\"3\";s:3:\"sql\";s:147:\" SELECT A.* FROM qb_news_content A  WHERE A.city_id=\'$GLOBALS[city_id]\'  AND A.yz=1  AND A.ispic=1   AND A.ispic=1  ORDER BY A.list DESC LIMIT 0,3 \";s:4:\"sql2\";N;s:7:\"colspan\";s:1:\"1\";s:11:\"content_num\";s:2:\"80\";s:12:\"content_num2\";s:3:\"120\";s:8:\"titlenum\";s:2:\"50\";s:9:\"titlenum2\";s:2:\"40\";s:10:\"titleflood\";s:1:\"0\";s:9:\"start_num\";s:1:\"1\";s:10:\"c_rolltype\";s:1:\"0\";}','a:3:{s:5:\"div_w\";s:2:\"50\";s:5:\"div_h\";s:2:\"30\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','1487724850','8','0','0','0','default');
INSERT INTO `qb_label` VALUES ('102','','0','0','wapindex_banner','pic','0','a:5:{s:6:\"imgurl\";s:24:\"../images/wap/banner.png\";s:7:\"imglink\";s:0:\"\";s:5:\"width\";s:0:\"\";s:6:\"height\";s:0:\"\";s:11:\"pic_city_id\";i:0;}','a:3:{s:5:\"div_w\";s:0:\"\";s:5:\"div_h\";s:0:\"\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','0','8','0','0','0','default');
INSERT INTO `qb_label` VALUES ('103','','0','0','wapindex_modleNav','code','0','ҳ','a:4:{s:9:\"html_edit\";N;s:5:\"div_w\";s:0:\"\";s:5:\"div_h\";s:0:\"\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','0','8','0','0','0','default');
INSERT INTO `qb_label` VALUES ('104','','0','0','wapindex_allCont','Info_hy_','1','a:32:{s:7:\"allcity\";s:1:\"0\";s:13:\"tplpart_1code\";s:496:\"<dl>\r\n  <dt><p><span><em><a href=\"$webdb[www_url]/hy/waphomepage.php?uid=$uid\"><img src=\"$webdb[www_url]/do/minpic.php?wh=300:300&url=$picurl\" onerror=\"src=\'$webdb[www_url]/images/wap/shoptgpic.png\'\"/></a></em></span></p></dt>\r\n  <dd>\r\n   <p onclick=\"window.location.href=\'$webdb[www_url]/hy/waphomepage.php?uid=$uid\'\">$title</p>\r\n   <time>פڣ{$time_Y}-{$time_m}-{$time_d}</time>\r\n   <span>{$hits}</span>\r\n   <a href=\"$webdb[www_url]/hy/waphomepage.php?uid=$uid\"></a>\r\n  </dd>\r\n</dl>\r\n\";s:13:\"tplpart_2code\";s:0:\"\";s:3:\"SYS\";s:7:\"company\";s:7:\"typefid\";N;s:5:\"ctype\";s:4:\"home\";s:5:\"width\";s:3:\"250\";s:6:\"height\";s:3:\"187\";s:8:\"rolltype\";s:10:\"scrollLeft\";s:8:\"rolltime\";s:1:\"3\";s:11:\"roll_height\";s:2:\"50\";s:11:\"content_num\";s:2:\"80\";s:7:\"newhour\";s:2:\"24\";s:7:\"hothits\";s:2:\"30\";s:7:\"tplpath\";s:0:\"\";s:6:\"DivTpl\";i:1;s:5:\"fiddb\";N;s:8:\"moduleid\";N;s:5:\"stype\";s:1:\"p\";s:2:\"yz\";s:3:\"all\";s:8:\"renzheng\";N;s:10:\"timeformat\";s:11:\"Y-m-d H:i:s\";s:5:\"order\";s:4:\"list\";s:3:\"asc\";s:4:\"DESC\";s:6:\"levels\";s:3:\"all\";s:7:\"rowspan\";s:1:\"4\";s:3:\"sql\";s:130:\"SELECT DISTINCT A.* FROM qb_hy_company A   WHERE A.if_homepage=1  AND A.city_id=\'$GLOBALS[city_id]\'  ORDER BY list DESC LIMIT 0,4 \";s:7:\"colspan\";s:1:\"1\";s:8:\"titlenum\";s:2:\"50\";s:10:\"titleflood\";s:1:\"0\";s:9:\"start_num\";s:1:\"1\";s:10:\"c_rolltype\";s:1:\"0\";}','a:3:{s:5:\"div_w\";s:2:\"50\";s:5:\"div_h\";s:2:\"30\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','1484986975','8','0','0','0','default');
INSERT INTO `qb_label` VALUES ('105','','0','0','wap_newsindex_flash','Info_news_','1','a:37:{s:7:\"allcity\";s:1:\"0\";s:13:\"tplpart_1code\";s:2602:\"<style>\r\nbody{max-width:640px; margin:auto;}\r\n.ShowSlide{\r\n	width:100%;\r\n	border-top:#DDD solid 1px;\r\n	border-bottom:#DDD solid 1px;\r\n	margin:0 auto;\r\n	background:#FFF;\r\n	position:relative;\r\n}\r\n#slide,#slide .cell,#slide .cell img { \r\n	height:auto;\r\n}\r\n#slide{ \r\n	position:static; \r\n	z-index:2; \r\n	background-color:#f3f3f3;\r\n	margin:auto; \r\n	width:100%; \r\n	overflow: hidden; \r\n	-webkit-user-select:none; \r\n	-moz-user-select:none; \r\n	-ms-user-select:none; \r\n	-o-user-select:none; \r\n	user-select:none;\r\n}\r\n#slide .cell{ \r\n	position:relative; \r\n	z-index:2; \r\n	width:100%;\r\n	vertical-align:middle;\r\n	display:table-cell;\r\n}\r\n#slide .cell .title { \r\n	display:none;\r\n}\r\n#slide .cell img { \r\n	vertical-align:top; \r\n	width:100%; \r\n	height:auto; \r\n	display:block;\r\n	cursor:pointer;\r\n}\r\n#indicator { \r\n	position:absolute; \r\n	width:100%;\r\n	bottom:0;\r\n	left:0;\r\n	text-align:center;\r\n}\r\n#indicator li {\r\n	color:#fff; \r\n	margin:0 4px; \r\n	text-indent:-999em;  \r\n	width:8px; \r\n	height:8px; \r\n	border-radius:8px;  \r\n	display:inline-block;\r\n	overflow:hidden;\r\n	background-color:#ccc;\r\n}\r\n#indicator .active { \r\n	background-color:#f50;\r\n}\r\n</style>\r\n<div class=\"ShowSlide\">\r\n<script src=\"$webdb[www_url]/shop/images/wap/slide.js\"></script>\r\n<div id=\"slide\" class=\"clearfix\" style=\"display:none\">\r\n	<div id=\"content\">\r\n<!--\r\nEOT;\r\nforeach($listdb AS $rs){\r\nextract($rs);\r\n$picurl=tempdir($picurl,\'400:300\');\r\nprint <<<EOT\r\n-->\r\n		<li class=\'cell\'><a href=\"$url\" title=\"$title\"><img src=\"$picurl\"/><span class=\'title\'>$title</span></a></li>\r\n<!--\r\nEOT;\r\n}\r\nprint <<<EOT\r\n-->\r\n	</div>\r\n	<ul id=\"indicator\"></ul>\r\n	<span class=\"prev\" id=\"slide_prev\" style=\"display:none\">һ</span><span class=\"next\" id=\"slide_next\" style=\"display:none\">һ</span>\r\n</div>\r\n<script>\r\n(function($){\r\n	var list = $(\'#content\').find(\'.cell\');\r\n	if(list.length > 0){\r\n		$(\'#slide\').show();\r\n		var txt = \'\';\r\n		$(\'#content\').find(\'.cell\').each(function(i){\r\n			if(i === 0){\r\n				txt += \'<li class=\"active\">1</li>\';\r\n			}else{\r\n				txt += \'<li>\'+(i+1)+\'</li>\';\r\n			}\r\n		});\r\n		$(\'#indicator\').html(txt);\r\n		setTimeout(function(){new C_Scroll({container:\'slide\',content:\'content\',ct:\'indicator\',size:\'400\',intervalTime:5000,lazyIMG:!!0});},200);\r\n	}\r\n	/*$(\'#content img\').click(function(){\r\n		var pics=$(this).attr(\"src\");\r\n		var picdbs=new Array();\r\n		var i=0;\r\n		$(\'#content img\').each(function(){\r\n			var thisurl=$(this).attr(\"src\");\r\n			picdbs[i]=thisurl;\r\n			i++;\r\n		});\r\n		view_pic1(pics,picdbs);\r\n	});*/\r\n})(jQuery);\r\n/*function view_pic1(pic,picdbs) {	\r\n	wx.previewImage({\r\n	  current: pic,\r\n	  urls:picdbs\r\n	});\r\n}*/\r\n</script>\r\n</div>\";s:13:\"tplpart_2code\";s:0:\"\";s:3:\"SYS\";s:2:\"wn\";s:6:\"wninfo\";s:5:\"news_\";s:9:\"noReadMid\";s:0:\"\";s:13:\"RollStyleType\";s:0:\"\";s:7:\"fidtype\";s:1:\"0\";s:8:\"rolltype\";s:10:\"scrollLeft\";s:8:\"rolltime\";s:1:\"3\";s:11:\"roll_height\";s:2:\"50\";s:5:\"width\";s:3:\"250\";s:6:\"height\";s:3:\"187\";s:7:\"newhour\";s:2:\"24\";s:7:\"hothits\";s:3:\"100\";s:7:\"amodule\";N;s:7:\"tplpath\";s:0:\"\";s:6:\"DivTpl\";i:1;s:5:\"fiddb\";N;s:5:\"stype\";s:1:\"p\";s:2:\"yz\";s:1:\"1\";s:7:\"hidefid\";N;s:10:\"timeformat\";s:11:\"Y-m-d H:i:s\";s:5:\"order\";s:6:\"A.list\";s:3:\"asc\";s:4:\"DESC\";s:6:\"levels\";s:3:\"all\";s:7:\"rowspan\";s:1:\"5\";s:3:\"sql\";s:147:\" SELECT A.* FROM qb_news_content A  WHERE A.city_id=\'$GLOBALS[city_id]\'  AND A.yz=1  AND A.ispic=1   AND A.ispic=1  ORDER BY A.list DESC LIMIT 0,5 \";s:4:\"sql2\";N;s:7:\"colspan\";s:1:\"1\";s:11:\"content_num\";s:2:\"80\";s:12:\"content_num2\";s:3:\"120\";s:8:\"titlenum\";s:2:\"20\";s:9:\"titlenum2\";s:2:\"40\";s:10:\"titleflood\";s:1:\"0\";s:9:\"start_num\";s:1:\"1\";s:10:\"c_rolltype\";s:1:\"0\";}','a:3:{s:5:\"div_w\";s:2:\"50\";s:5:\"div_h\";s:2:\"30\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','1484986166','0','20','0','0','default');
INSERT INTO `qb_label` VALUES ('106','','0','0','wap_shopindex_flash','Info_shop_','1','a:31:{s:7:\"allcity\";s:1:\"0\";s:13:\"tplpart_1code\";s:2602:\"<style>\r\nbody{max-width:640px; margin:auto;}\r\n.ShowSlide{\r\n	width:100%;\r\n	border-top:#DDD solid 1px;\r\n	border-bottom:#DDD solid 1px;\r\n	margin:0 auto;\r\n	background:#FFF;\r\n	position:relative;\r\n}\r\n#slide,#slide .cell,#slide .cell img { \r\n	height:auto;\r\n}\r\n#slide{ \r\n	position:static; \r\n	z-index:2; \r\n	background-color:#f3f3f3;\r\n	margin:auto; \r\n	width:100%; \r\n	overflow: hidden; \r\n	-webkit-user-select:none; \r\n	-moz-user-select:none; \r\n	-ms-user-select:none; \r\n	-o-user-select:none; \r\n	user-select:none;\r\n}\r\n#slide .cell{ \r\n	position:relative; \r\n	z-index:2; \r\n	width:100%;\r\n	vertical-align:middle;\r\n	display:table-cell;\r\n}\r\n#slide .cell .title { \r\n	display:none;\r\n}\r\n#slide .cell img { \r\n	vertical-align:top; \r\n	width:100%; \r\n	height:auto; \r\n	display:block;\r\n	cursor:pointer;\r\n}\r\n#indicator { \r\n	position:absolute; \r\n	width:100%;\r\n	bottom:0;\r\n	left:0;\r\n	text-align:center;\r\n}\r\n#indicator li {\r\n	color:#fff; \r\n	margin:0 4px; \r\n	text-indent:-999em;  \r\n	width:8px; \r\n	height:8px; \r\n	border-radius:8px;  \r\n	display:inline-block;\r\n	overflow:hidden;\r\n	background-color:#ccc;\r\n}\r\n#indicator .active { \r\n	background-color:#f50;\r\n}\r\n</style>\r\n<div class=\"ShowSlide\">\r\n<script src=\"$webdb[www_url]/shop/images/wap/slide.js\"></script>\r\n<div id=\"slide\" class=\"clearfix\" style=\"display:none\">\r\n	<div id=\"content\">\r\n<!--\r\nEOT;\r\nforeach($listdb AS $rs){\r\nextract($rs);\r\n$picurl=tempdir($picurl,\'800:600\');\r\nprint <<<EOT\r\n-->\r\n		<li class=\'cell\'><a href=\"$url\" title=\"$title\"><img src=\"$picurl\"/><span class=\'title\'>$title</span></a></li>\r\n<!--\r\nEOT;\r\n}\r\nprint <<<EOT\r\n-->\r\n	</div>\r\n	<ul id=\"indicator\"></ul>\r\n	<span class=\"prev\" id=\"slide_prev\" style=\"display:none\">һ</span><span class=\"next\" id=\"slide_next\" style=\"display:none\">һ</span>\r\n</div>\r\n<script>\r\n(function($){\r\n	var list = $(\'#content\').find(\'.cell\');\r\n	if(list.length > 0){\r\n		$(\'#slide\').show();\r\n		var txt = \'\';\r\n		$(\'#content\').find(\'.cell\').each(function(i){\r\n			if(i === 0){\r\n				txt += \'<li class=\"active\">1</li>\';\r\n			}else{\r\n				txt += \'<li>\'+(i+1)+\'</li>\';\r\n			}\r\n		});\r\n		$(\'#indicator\').html(txt);\r\n		setTimeout(function(){new C_Scroll({container:\'slide\',content:\'content\',ct:\'indicator\',size:\'400\',intervalTime:5000,lazyIMG:!!0});},200);\r\n	}\r\n	/*$(\'#content img\').click(function(){\r\n		var pics=$(this).attr(\"src\");\r\n		var picdbs=new Array();\r\n		var i=0;\r\n		$(\'#content img\').each(function(){\r\n			var thisurl=$(this).attr(\"src\");\r\n			picdbs[i]=thisurl;\r\n			i++;\r\n		});\r\n		view_pic1(pics,picdbs);\r\n	});*/\r\n})(jQuery);\r\n/*function view_pic1(pic,picdbs) {	\r\n	wx.previewImage({\r\n	  current: pic,\r\n	  urls:picdbs\r\n	});\r\n}*/\r\n</script>\r\n</div>\";s:13:\"tplpart_2code\";s:0:\"\";s:3:\"SYS\";s:2:\"wn\";s:6:\"wninfo\";s:5:\"shop_\";s:6:\"cityId\";N;s:5:\"width\";s:3:\"250\";s:6:\"height\";s:3:\"187\";s:8:\"rolltype\";s:10:\"scrollLeft\";s:8:\"rolltime\";s:1:\"3\";s:11:\"roll_height\";s:2:\"50\";s:11:\"content_num\";s:2:\"80\";s:7:\"newhour\";s:2:\"24\";s:7:\"hothits\";s:2:\"30\";s:7:\"tplpath\";s:0:\"\";s:6:\"DivTpl\";i:1;s:5:\"fiddb\";N;s:8:\"moduleid\";N;s:5:\"stype\";s:1:\"p\";s:2:\"yz\";s:3:\"all\";s:10:\"timeformat\";s:11:\"Y-m-d H:i:s\";s:5:\"order\";s:4:\"list\";s:3:\"asc\";s:4:\"DESC\";s:6:\"levels\";s:3:\"all\";s:7:\"rowspan\";s:1:\"5\";s:3:\"sql\";s:108:\"SELECT * FROM qb_shop_content  WHERE city_id=\'$GLOBALS[city_id]\'  AND ispic=1  ORDER BY list DESC LIMIT 0,5 \";s:7:\"colspan\";s:1:\"1\";s:8:\"titlenum\";s:2:\"20\";s:10:\"titleflood\";s:1:\"0\";s:9:\"start_num\";s:1:\"1\";s:10:\"c_rolltype\";s:1:\"0\";}','a:3:{s:5:\"div_w\";s:2:\"50\";s:5:\"div_h\";s:2:\"30\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','0','0','29','0','0','default');
INSERT INTO `qb_label` VALUES ('107','','0','99','index_head_server','code','0','<li class=\'consult\'><a target=\"_blank\" href=\"http://wpa.qq.com/msgrd?v=3&uin=27781017&site=$webdb[www_url]&menu=yes\">ѯ</a></li>\r\n<li class=\'phone\'>24Сʱͷ<span>020-28998648</span></li>','a:4:{s:9:\"html_edit\";N;s:5:\"div_w\";s:0:\"\";s:5:\"div_h\";s:0:\"\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','0','8','0','0','0','default');
INSERT INTO `qb_label` VALUES ('108','','0','0','wz_index_news','Info_news_','1','a:37:{s:7:\"allcity\";s:1:\"0\";s:13:\"tplpart_1code\";s:51:\"<a href=\"{$url}\" title=\"{$full_title}\">{$title}</a>\";s:13:\"tplpart_2code\";s:0:\"\";s:3:\"SYS\";s:2:\"wn\";s:6:\"wninfo\";s:5:\"news_\";s:9:\"noReadMid\";s:0:\"\";s:13:\"RollStyleType\";s:0:\"\";s:7:\"fidtype\";s:1:\"0\";s:8:\"rolltype\";s:10:\"scrollLeft\";s:8:\"rolltime\";s:1:\"3\";s:11:\"roll_height\";s:2:\"50\";s:5:\"width\";s:3:\"250\";s:6:\"height\";s:3:\"187\";s:7:\"newhour\";s:2:\"24\";s:7:\"hothits\";s:3:\"100\";s:7:\"amodule\";N;s:7:\"tplpath\";s:0:\"\";s:6:\"DivTpl\";i:1;s:5:\"fiddb\";N;s:5:\"stype\";s:1:\"4\";s:2:\"yz\";s:1:\"1\";s:7:\"hidefid\";N;s:10:\"timeformat\";s:11:\"Y-m-d H:i:s\";s:5:\"order\";s:6:\"A.list\";s:3:\"asc\";s:4:\"DESC\";s:6:\"levels\";s:3:\"all\";s:7:\"rowspan\";s:1:\"5\";s:3:\"sql\";s:117:\" SELECT A.* FROM qb_news_content A  WHERE A.city_id=\'$GLOBALS[city_id]\'  AND A.yz=1   ORDER BY A.list DESC LIMIT 0,5 \";s:4:\"sql2\";N;s:7:\"colspan\";s:1:\"1\";s:11:\"content_num\";s:2:\"80\";s:12:\"content_num2\";s:3:\"120\";s:8:\"titlenum\";s:3:\"120\";s:9:\"titlenum2\";s:2:\"40\";s:10:\"titleflood\";s:1:\"0\";s:9:\"start_num\";s:1:\"1\";s:10:\"c_rolltype\";s:1:\"0\";}','a:3:{s:5:\"div_w\";s:2:\"50\";s:5:\"div_h\";s:2:\"30\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','1487064510','8','0','0','0','default');
INSERT INTO `qb_label` VALUES ('109','','0','0','wz_index_ad4','pic','0','a:5:{s:6:\"imgurl\";s:30:\"../images/default/main/ad3.png\";s:7:\"imglink\";s:1:\"#\";s:5:\"width\";s:3:\"320\";s:6:\"height\";s:3:\"158\";s:11:\"pic_city_id\";i:0;}','a:3:{s:5:\"div_w\";s:2:\"50\";s:5:\"div_h\";s:2:\"21\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','1487063810','8','0','0','0','default');
INSERT INTO `qb_label` VALUES ('110','','0','0','wz_index_ad6','pic','0','a:5:{s:6:\"imgurl\";s:30:\"../images/default/main/ad5.png\";s:7:\"imglink\";s:1:\"#\";s:5:\"width\";s:4:\"1200\";s:6:\"height\";s:3:\"145\";s:11:\"pic_city_id\";i:0;}','a:3:{s:5:\"div_w\";s:2:\"50\";s:5:\"div_h\";s:2:\"21\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','1487122313','8','0','0','0','default');
INSERT INTO `qb_label` VALUES ('111','','0','0','wz_index_contact','code','0','<dl>\r\n	<dt><img src=\"../images/default/main/img11.png\" /></dt>\r\n	<dd><span class=\"blue\">020-28998648</span><span>һ 09:00-17:30</span></dd>\r\n</dl>\r\n<div>\r\n	<a href=\"http://wpa.qq.com/msgrd?v=3&uin=27781017&site=http://www.qibosoft.com&menu=yes\"><img src=\"../images/default/main/img12.png\" />߿ͷ</a>\r\n	<a href=\"http://wpa.qq.com/msgrd?v=3&uin=27781017&site=http://www.qibosoft.com&menu=yes\"><img src=\"../images/default/main/img12.png\" />߿ͷ</a>\r\n</div>','a:4:{s:9:\"html_edit\";N;s:5:\"div_w\";s:0:\"\";s:5:\"div_h\";s:0:\"\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','0','8','0','0','0','default');
INSERT INTO `qb_label` VALUES ('112','','0','0','wz_index_ad5','pic','0','a:5:{s:6:\"imgurl\";s:30:\"../images/default/main/ad4.png\";s:7:\"imglink\";s:1:\"#\";s:5:\"width\";s:0:\"\";s:6:\"height\";s:0:\"\";s:11:\"pic_city_id\";i:0;}','a:3:{s:5:\"div_w\";s:0:\"\";s:5:\"div_h\";s:0:\"\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','0','8','0','0','0','default');
INSERT INTO `qb_label` VALUES ('113','','0','99','blue_topad','pic','0','a:5:{s:6:\"imgurl\";s:22:\"../images/blue/ad1.gif\";s:7:\"imglink\";s:23:\"http://www.qibosoft.com\";s:5:\"width\";s:3:\"525\";s:6:\"height\";s:2:\"60\";s:11:\"pic_city_id\";i:0;}','a:3:{s:5:\"div_w\";s:3:\"302\";s:5:\"div_h\";s:2:\"53\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','1490414007','0','0','0','0','default');
INSERT INTO `qb_label` VALUES ('114','','1','99','blue_topinfo','code','0','<a href=\"#\">uggs outlet</a>\r\n<a href=\"#\">˼С</a>\r\n<a href=\"#\">ٱӪ</a>\r\n<a href=\"#\">ԭ</a>\r\n<a href=\"#\">߲Ʒ</a>\r\n<a href=\"#\">Ա</a>','a:4:{s:9:\"html_edit\";N;s:5:\"div_w\";s:0:\"\";s:5:\"div_h\";s:0:\"\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','0','0','0','0','0','blue_abc');
INSERT INTO `qb_label` VALUES ('115','','0','0','blue_indext1','article','1','a:34:{s:13:\"tplpart_1code\";s:212:\"<div class=\"list\">\r\n	<div class=\"t\"><A HREF=\"$url\" target=\"_blank\">$title</A></div>\r\n    <div class=\"m\">{$time_y}-{$time_m}-{$time_d} :<span>{$hits}</span></div>\r\n    <div class=\"c\">$content</div>\r\n</div>\r\n\";s:13:\"tplpart_2code\";s:0:\"\";s:3:\"SYS\";s:7:\"artcile\";s:13:\"RollStyleType\";s:0:\"\";s:7:\"fidtype\";s:1:\"0\";s:8:\"rolltype\";s:10:\"scrollLeft\";s:8:\"rolltime\";s:1:\"3\";s:11:\"roll_height\";s:2:\"50\";s:5:\"width\";s:3:\"250\";s:6:\"height\";s:3:\"187\";s:7:\"newhour\";s:2:\"24\";s:7:\"hothits\";s:3:\"100\";s:7:\"amodule\";s:1:\"0\";s:7:\"tplpath\";s:29:\"/common_content/content_1.jpg\";s:6:\"DivTpl\";i:1;s:5:\"fiddb\";s:1:\"4\";s:5:\"stype\";s:1:\"c\";s:2:\"yz\";s:1:\"1\";s:7:\"hidefid\";N;s:10:\"timeformat\";s:11:\"Y-m-d H:i:s\";s:5:\"order\";s:6:\"A.list\";s:3:\"asc\";s:4:\"DESC\";s:6:\"levels\";s:3:\"all\";s:7:\"rowspan\";s:1:\"4\";s:3:\"sql\";s:168:\" SELECT A.*,A.aid AS id,R.content FROM qb_article A LEFT JOIN qb_reply R ON A.aid=R.aid   WHERE A.yz=1  AND A.fid IN (4)   AND R.topic=1 ORDER BY A.list DESC LIMIT 0,4 \";s:4:\"sql2\";N;s:7:\"colspan\";s:1:\"1\";s:11:\"content_num\";s:3:\"100\";s:12:\"content_num2\";s:3:\"120\";s:8:\"titlenum\";s:2:\"54\";s:9:\"titlenum2\";s:2:\"40\";s:10:\"titleflood\";s:1:\"1\";s:9:\"start_num\";s:1:\"1\";s:10:\"c_rolltype\";s:1:\"0\";}','a:3:{s:5:\"div_w\";s:2:\"50\";s:5:\"div_h\";s:2:\"30\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','1494644453','0','0','0','0','default');
INSERT INTO `qb_label` VALUES ('116','','0','0','blue_slidepic','article','1','a:34:{s:13:\"tplpart_1code\";s:1025:\"<div id=\"ifocus_pic\">\r\n    <div id=\"ifocus_piclist\">\r\n        <ul>\r\n<!--\r\nEOT;\r\nforeach($listdb AS $key=>$rs){@extract($rs);$key++;\r\n$rs[picurl]=tempdir($rs[picurl],\'372:240\');\r\nprint <<<EOT\r\n-->\r\n            <li><a href=\"$url\" target=\"_blank\"><img src=\"$rs[picurl]\" alt=\"$title\" width=\"320\"></a></li>\r\n<!--\r\nEOT;\r\n}\r\nprint <<<EOT\r\n-->\r\n        </ul>\r\n    </div>\r\n    <div id=\"ifocus_opdiv\"></div>\r\n    <div id=\"ifocus_tx\">\r\n        <ul>\r\n<!--\r\nEOT;\r\nforeach($listdb AS $key=>$rs){@extract($rs);\r\n$class=$key==0?\'current\':\'normal\';\r\nprint <<<EOT\r\n-->\r\n            <li class=\"$class\"><a href=\"$url\" target=\"_blank\">$title</a></li>\r\n<!--\r\nEOT;\r\n}\r\nprint <<<EOT\r\n-->\r\n        </ul>\r\n    </div>\r\n</div>\r\n<div id=\"ifocus_btn\">\r\n    <ul>\r\n<!--\r\nEOT;\r\nforeach($listdb AS $key=>$rs){@extract($rs);\r\n$class=$key==0?\'current\':\'normal\';\r\nprint <<<EOT\r\n-->\r\n        <li class=\"$class\"><a href=\"$url\" target=\"_blank\"><img src=\"$rs[picurl]\" alt=\"$title\" width=\"64\" height=\"44\"></a></li>\r\n<!--\r\nEOT;\r\n}\r\nprint <<<EOT\r\n-->\r\n    </ul>\r\n</div>\";s:13:\"tplpart_2code\";s:0:\"\";s:3:\"SYS\";s:7:\"artcile\";s:13:\"RollStyleType\";s:0:\"\";s:7:\"fidtype\";s:1:\"0\";s:8:\"rolltype\";s:10:\"scrollLeft\";s:8:\"rolltime\";s:1:\"3\";s:11:\"roll_height\";s:2:\"50\";s:5:\"width\";s:3:\"250\";s:6:\"height\";s:3:\"187\";s:7:\"newhour\";s:2:\"24\";s:7:\"hothits\";s:3:\"100\";s:7:\"amodule\";s:3:\"100\";s:7:\"tplpath\";s:24:\"/common_pic/img_div1.jpg\";s:6:\"DivTpl\";i:1;s:5:\"fiddb\";N;s:5:\"stype\";s:1:\"p\";s:2:\"yz\";s:1:\"1\";s:7:\"hidefid\";N;s:10:\"timeformat\";s:11:\"Y-m-d H:i:s\";s:5:\"order\";s:6:\"A.list\";s:3:\"asc\";s:4:\"DESC\";s:6:\"levels\";s:3:\"all\";s:7:\"rowspan\";s:1:\"4\";s:3:\"sql\";s:106:\" SELECT A.*,A.aid AS id FROM qb_article A  WHERE A.yz=1  AND A.mid=\'100\'   ORDER BY A.list DESC LIMIT 0,4 \";s:4:\"sql2\";N;s:7:\"colspan\";s:1:\"1\";s:11:\"content_num\";s:2:\"80\";s:12:\"content_num2\";s:3:\"120\";s:8:\"titlenum\";s:2:\"30\";s:9:\"titlenum2\";s:2:\"40\";s:10:\"titleflood\";s:1:\"0\";s:9:\"start_num\";s:1:\"1\";s:10:\"c_rolltype\";s:1:\"0\";}','a:3:{s:5:\"div_w\";s:2:\"50\";s:5:\"div_h\";s:2:\"30\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','1494652667','0','0','0','0','default');
INSERT INTO `qb_label` VALUES ('117','','1','0','blue_indexad1','pic','0','a:4:{s:6:\"imgurl\";s:22:\"../images/blue/ad2.gif\";s:7:\"imglink\";s:1:\"#\";s:5:\"width\";s:3:\"310\";s:6:\"height\";s:2:\"50\";}','a:3:{s:5:\"div_w\";s:2:\"50\";s:5:\"div_h\";s:2:\"21\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','1308204495','0','0','0','0','blue_abc');
INSERT INTO `qb_label` VALUES ('118','','0','0','blue_indext2','article','1','a:34:{s:13:\"tplpart_1code\";s:117:\"<div class=\"list\"><A HREF=\"{$list_url}\" target=\"_blank\">[{$fname}]</A><A HREF=\"$url\" target=\"_blank\">$title</A></div>\";s:13:\"tplpart_2code\";s:0:\"\";s:3:\"SYS\";s:7:\"artcile\";s:13:\"RollStyleType\";s:0:\"\";s:7:\"fidtype\";s:1:\"0\";s:8:\"rolltype\";s:10:\"scrollLeft\";s:8:\"rolltime\";s:1:\"3\";s:11:\"roll_height\";s:2:\"50\";s:5:\"width\";s:3:\"250\";s:6:\"height\";s:3:\"187\";s:7:\"newhour\";s:2:\"24\";s:7:\"hothits\";s:3:\"100\";s:7:\"amodule\";s:1:\"0\";s:7:\"tplpath\";s:0:\"\";s:6:\"DivTpl\";i:1;s:5:\"fiddb\";N;s:5:\"stype\";s:1:\"4\";s:2:\"yz\";s:1:\"1\";s:7:\"hidefid\";N;s:10:\"timeformat\";s:11:\"Y-m-d H:i:s\";s:5:\"order\";s:6:\"A.list\";s:3:\"asc\";s:4:\"DESC\";s:6:\"levels\";s:3:\"all\";s:7:\"rowspan\";s:1:\"2\";s:3:\"sql\";s:104:\" SELECT A.*,A.aid AS id FROM qb_article A  WHERE A.yz=1  AND A.mid=\'0\'   ORDER BY A.list DESC LIMIT 0,2 \";s:4:\"sql2\";N;s:7:\"colspan\";s:1:\"1\";s:11:\"content_num\";s:2:\"80\";s:12:\"content_num2\";s:3:\"120\";s:8:\"titlenum\";s:2:\"48\";s:9:\"titlenum2\";s:2:\"40\";s:10:\"titleflood\";s:1:\"0\";s:9:\"start_num\";s:1:\"1\";s:10:\"c_rolltype\";s:1:\"0\";}','a:3:{s:5:\"div_w\";s:2:\"50\";s:5:\"div_h\";s:2:\"30\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','1494644652','0','0','0','0','default');
INSERT INTO `qb_label` VALUES ('119','','1','0','blue_indext3','article','1','a:34:{s:13:\"tplpart_1code\";s:120:\"<div class=\"list\"><A HREF=\"$url\" target=\"_blank\" class=\"f\">[{$fname}]</A><A HREF=\"$url\" target=\"_blank\">$title</A></div>\";s:13:\"tplpart_2code\";s:228:\"<div class=\"listpic\">\r\n	<div class=\"t\"><a href=\"{$list_url}\" target=\"_blank\">$title</a></div>\r\n	<div class=\"img\"><a href=\"$url\" target=\"_blank\"><img src=\"$picurl\" width=\"90\"/></a></div>\r\n    <div class=\"c\">$content</div>\r\n</div>\";s:3:\"SYS\";s:7:\"artcile\";s:13:\"RollStyleType\";s:0:\"\";s:7:\"fidtype\";s:1:\"0\";s:8:\"rolltype\";s:10:\"scrollLeft\";s:8:\"rolltime\";s:1:\"3\";s:11:\"roll_height\";s:2:\"50\";s:5:\"width\";s:3:\"250\";s:6:\"height\";s:3:\"187\";s:7:\"newhour\";s:2:\"24\";s:7:\"hothits\";s:3:\"100\";s:7:\"amodule\";s:1:\"0\";s:7:\"tplpath\";s:33:\"/common_zh_content/zh_content.jpg\";s:6:\"DivTpl\";i:1;s:5:\"fiddb\";N;s:5:\"stype\";s:1:\"t\";s:2:\"yz\";s:1:\"1\";s:7:\"hidefid\";N;s:10:\"timeformat\";s:11:\"Y-m-d H:i:s\";s:5:\"order\";s:6:\"A.list\";s:3:\"asc\";s:4:\"DESC\";s:6:\"levels\";s:3:\"all\";s:7:\"rowspan\";s:1:\"3\";s:3:\"sql\";s:165:\" SELECT A.*,A.aid AS id,R.content FROM qb_article A LEFT JOIN qb_reply R ON A.aid=R.aid   WHERE A.yz=1  AND A.mid=\'0\'   AND R.topic=1 ORDER BY A.list DESC LIMIT 0,4 \";s:4:\"sql2\";s:177:\" SELECT A.*,A.aid AS id,R.content FROM qb_article A LEFT JOIN qb_reply R ON A.aid=R.aid  WHERE A.yz=1  AND A.mid=\'0\'  AND A.ispic=1 AND R.topic=1 ORDER BY A.list DESC LIMIT 0,1 \";s:7:\"colspan\";s:1:\"1\";s:11:\"content_num\";s:2:\"80\";s:12:\"content_num2\";s:2:\"80\";s:8:\"titlenum\";s:2:\"40\";s:9:\"titlenum2\";s:2:\"40\";s:10:\"titleflood\";s:1:\"0\";s:9:\"start_num\";s:1:\"1\";s:10:\"c_rolltype\";s:1:\"0\";}','a:3:{s:5:\"div_w\";s:2:\"50\";s:5:\"div_h\";s:2:\"30\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','1308206359','0','0','0','0','blue_abc');
INSERT INTO `qb_label` VALUES ('120','','0','0','blue_indext4','article','1','a:34:{s:13:\"tplpart_1code\";s:157:\"<dl  id=branditem$i>\r\n<dt><a href=\"$url\" target=\"_blank\"><img src=\"$picurl\" width=\"150\"/></a></dt>\r\n<dd><A HREF=\"$url\" target=\"_blank\">$title</A></dd>\r\n</dl>\";s:13:\"tplpart_2code\";s:0:\"\";s:3:\"SYS\";s:7:\"artcile\";s:13:\"RollStyleType\";s:0:\"\";s:7:\"fidtype\";s:1:\"0\";s:8:\"rolltype\";s:10:\"scrollLeft\";s:8:\"rolltime\";s:1:\"3\";s:11:\"roll_height\";s:2:\"50\";s:5:\"width\";s:3:\"250\";s:6:\"height\";s:3:\"187\";s:7:\"newhour\";s:2:\"24\";s:7:\"hothits\";s:3:\"100\";s:7:\"amodule\";s:1:\"0\";s:7:\"tplpath\";s:0:\"\";s:6:\"DivTpl\";i:1;s:5:\"fiddb\";N;s:5:\"stype\";s:1:\"p\";s:2:\"yz\";s:1:\"1\";s:7:\"hidefid\";N;s:10:\"timeformat\";s:11:\"Y-m-d H:i:s\";s:5:\"order\";s:6:\"A.list\";s:3:\"asc\";s:4:\"DESC\";s:6:\"levels\";s:3:\"all\";s:7:\"rowspan\";s:2:\"10\";s:3:\"sql\";s:135:\" SELECT A.*,A.aid AS id FROM qb_article A  WHERE A.yz=1  AND A.mid=\'0\'  AND A.ispic=1   AND A.ispic=1  ORDER BY A.list DESC LIMIT 0,10 \";s:4:\"sql2\";N;s:7:\"colspan\";s:1:\"1\";s:11:\"content_num\";s:2:\"80\";s:12:\"content_num2\";s:3:\"120\";s:8:\"titlenum\";s:2:\"30\";s:9:\"titlenum2\";s:2:\"40\";s:10:\"titleflood\";s:1:\"0\";s:9:\"start_num\";s:1:\"1\";s:10:\"c_rolltype\";s:1:\"0\";}','a:3:{s:5:\"div_w\";s:2:\"50\";s:5:\"div_h\";s:2:\"30\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','1494645965','0','0','0','0','default');
INSERT INTO `qb_label` VALUES ('121','','0','0','blue_indext5','article','1','a:34:{s:13:\"tplpart_1code\";s:107:\"<div class=\"list\"><A HREF=\"$url\" target=\"_blank\">$title</A><span>{$time_y}-{$time_m}-{$time_d}</span></div>\";s:13:\"tplpart_2code\";s:202:\"<dl>\r\n<dt><a href=\"$url\" target=\"_blank\"><img src=\"$picurl\" width=\"105\"/></a></dt>\r\n<dd>\r\n	<div class=\"t\"><A HREF=\"$url\" target=\"_blank\">$title</A></div>\r\n    <div class=\"c\">$content</div>\r\n</dd>\r\n</dl>\";s:3:\"SYS\";s:7:\"artcile\";s:13:\"RollStyleType\";s:0:\"\";s:7:\"fidtype\";s:1:\"0\";s:8:\"rolltype\";s:10:\"scrollLeft\";s:8:\"rolltime\";s:1:\"3\";s:11:\"roll_height\";s:2:\"50\";s:5:\"width\";s:3:\"250\";s:6:\"height\";s:3:\"187\";s:7:\"newhour\";s:2:\"24\";s:7:\"hothits\";s:3:\"100\";s:7:\"amodule\";s:1:\"0\";s:7:\"tplpath\";s:33:\"/common_zh_content/zh_content.jpg\";s:6:\"DivTpl\";i:1;s:5:\"fiddb\";N;s:5:\"stype\";s:1:\"t\";s:2:\"yz\";s:1:\"1\";s:7:\"hidefid\";N;s:10:\"timeformat\";s:11:\"Y-m-d H:i:s\";s:5:\"order\";s:6:\"A.list\";s:3:\"asc\";s:4:\"DESC\";s:6:\"levels\";s:3:\"all\";s:7:\"rowspan\";s:1:\"6\";s:3:\"sql\";s:165:\" SELECT A.*,A.aid AS id,R.content FROM qb_article A LEFT JOIN qb_reply R ON A.aid=R.aid   WHERE A.yz=1  AND A.mid=\'0\'   AND R.topic=1 ORDER BY A.list DESC LIMIT 0,7 \";s:4:\"sql2\";s:177:\" SELECT A.*,A.aid AS id,R.content FROM qb_article A LEFT JOIN qb_reply R ON A.aid=R.aid  WHERE A.yz=1  AND A.mid=\'0\'  AND A.ispic=1 AND R.topic=1 ORDER BY A.list DESC LIMIT 0,1 \";s:7:\"colspan\";s:1:\"1\";s:11:\"content_num\";s:2:\"80\";s:12:\"content_num2\";s:3:\"100\";s:8:\"titlenum\";s:2:\"50\";s:9:\"titlenum2\";s:2:\"40\";s:10:\"titleflood\";s:1:\"1\";s:9:\"start_num\";s:1:\"1\";s:10:\"c_rolltype\";s:1:\"0\";}','a:3:{s:5:\"div_w\";s:2:\"50\";s:5:\"div_h\";s:2:\"30\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','1494644141','0','0','0','0','default');
INSERT INTO `qb_label` VALUES ('122','','0','0','blue_indext6','article','1','a:34:{s:13:\"tplpart_1code\";s:107:\"<div class=\"list\"><A HREF=\"$url\" target=\"_blank\">$title</A><span>{$time_y}-{$time_m}-{$time_d}</span></div>\";s:13:\"tplpart_2code\";s:202:\"<dl>\r\n<dt><a href=\"$url\" target=\"_blank\"><img src=\"$picurl\" width=\"105\"/></a></dt>\r\n<dd>\r\n	<div class=\"t\"><A HREF=\"$url\" target=\"_blank\">$title</A></div>\r\n    <div class=\"c\">$content</div>\r\n</dd>\r\n</dl>\";s:3:\"SYS\";s:7:\"artcile\";s:13:\"RollStyleType\";s:0:\"\";s:7:\"fidtype\";s:1:\"0\";s:8:\"rolltype\";s:10:\"scrollLeft\";s:8:\"rolltime\";s:1:\"3\";s:11:\"roll_height\";s:2:\"50\";s:5:\"width\";s:3:\"250\";s:6:\"height\";s:3:\"187\";s:7:\"newhour\";s:2:\"24\";s:7:\"hothits\";s:3:\"100\";s:7:\"amodule\";s:1:\"0\";s:7:\"tplpath\";s:33:\"/common_zh_content/zh_content.jpg\";s:6:\"DivTpl\";i:1;s:5:\"fiddb\";N;s:5:\"stype\";s:1:\"t\";s:2:\"yz\";s:1:\"1\";s:7:\"hidefid\";N;s:10:\"timeformat\";s:11:\"Y-m-d H:i:s\";s:5:\"order\";s:6:\"A.list\";s:3:\"asc\";s:3:\"ASC\";s:6:\"levels\";s:3:\"all\";s:7:\"rowspan\";s:1:\"6\";s:3:\"sql\";s:164:\" SELECT A.*,A.aid AS id,R.content FROM qb_article A LEFT JOIN qb_reply R ON A.aid=R.aid   WHERE A.yz=1  AND A.mid=\'0\'   AND R.topic=1 ORDER BY A.list ASC LIMIT 0,7 \";s:4:\"sql2\";s:176:\" SELECT A.*,A.aid AS id,R.content FROM qb_article A LEFT JOIN qb_reply R ON A.aid=R.aid  WHERE A.yz=1  AND A.mid=\'0\'  AND A.ispic=1 AND R.topic=1 ORDER BY A.list ASC LIMIT 0,1 \";s:7:\"colspan\";s:1:\"1\";s:11:\"content_num\";s:2:\"80\";s:12:\"content_num2\";s:3:\"100\";s:8:\"titlenum\";s:2:\"50\";s:9:\"titlenum2\";s:2:\"40\";s:10:\"titleflood\";s:1:\"1\";s:9:\"start_num\";s:1:\"1\";s:10:\"c_rolltype\";s:1:\"0\";}','a:3:{s:5:\"div_w\";s:2:\"50\";s:5:\"div_h\";s:2:\"30\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','1494644150','0','0','0','0','default');
INSERT INTO `qb_label` VALUES ('123','','0','0','blue_indext7','article','1','a:34:{s:13:\"tplpart_1code\";s:115:\"<div class=\"lista list$i\"><A HREF=\"$url\" target=\"_blank\">$title</A><span>{$time_y}-{$time_m}-{$time_d}</span></div>\";s:13:\"tplpart_2code\";s:0:\"\";s:3:\"SYS\";s:7:\"artcile\";s:13:\"RollStyleType\";s:0:\"\";s:7:\"fidtype\";s:1:\"0\";s:8:\"rolltype\";s:10:\"scrollLeft\";s:8:\"rolltime\";s:1:\"3\";s:11:\"roll_height\";s:2:\"50\";s:5:\"width\";s:3:\"250\";s:6:\"height\";s:3:\"187\";s:7:\"newhour\";s:2:\"24\";s:7:\"hothits\";s:3:\"100\";s:7:\"amodule\";s:1:\"0\";s:7:\"tplpath\";s:0:\"\";s:6:\"DivTpl\";i:1;s:5:\"fiddb\";N;s:5:\"stype\";s:1:\"4\";s:2:\"yz\";s:1:\"1\";s:7:\"hidefid\";N;s:10:\"timeformat\";s:11:\"Y-m-d H:i:s\";s:5:\"order\";s:6:\"A.hits\";s:3:\"asc\";s:4:\"DESC\";s:6:\"levels\";s:3:\"all\";s:7:\"rowspan\";s:1:\"8\";s:3:\"sql\";s:104:\" SELECT A.*,A.aid AS id FROM qb_article A  WHERE A.yz=1  AND A.mid=\'0\'   ORDER BY A.hits DESC LIMIT 0,8 \";s:4:\"sql2\";N;s:7:\"colspan\";s:1:\"1\";s:11:\"content_num\";s:2:\"80\";s:12:\"content_num2\";s:3:\"120\";s:8:\"titlenum\";s:2:\"44\";s:9:\"titlenum2\";s:2:\"40\";s:10:\"titleflood\";s:1:\"1\";s:9:\"start_num\";s:1:\"1\";s:10:\"c_rolltype\";s:1:\"0\";}','a:3:{s:5:\"div_w\";s:2:\"50\";s:5:\"div_h\";s:2:\"30\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','1494644185','0','0','0','0','default');
INSERT INTO `qb_label` VALUES ('124','','0','0','blue_indext8','article','1','a:34:{s:13:\"tplpart_1code\";s:115:\"<div class=\"lista list$i\"><A HREF=\"$url\" target=\"_blank\">$title</A><span>{$time_y}-{$time_m}-{$time_d}</span></div>\";s:13:\"tplpart_2code\";s:0:\"\";s:3:\"SYS\";s:7:\"artcile\";s:13:\"RollStyleType\";s:0:\"\";s:7:\"fidtype\";s:1:\"0\";s:8:\"rolltype\";s:10:\"scrollLeft\";s:8:\"rolltime\";s:1:\"3\";s:11:\"roll_height\";s:2:\"50\";s:5:\"width\";s:3:\"250\";s:6:\"height\";s:3:\"187\";s:7:\"newhour\";s:2:\"24\";s:7:\"hothits\";s:3:\"100\";s:7:\"amodule\";s:1:\"0\";s:7:\"tplpath\";s:0:\"\";s:6:\"DivTpl\";i:1;s:5:\"fiddb\";N;s:5:\"stype\";s:1:\"4\";s:2:\"yz\";s:1:\"1\";s:7:\"hidefid\";N;s:10:\"timeformat\";s:11:\"Y-m-d H:i:s\";s:5:\"order\";s:10:\"A.digg_num\";s:3:\"asc\";s:4:\"DESC\";s:6:\"levels\";s:3:\"all\";s:7:\"rowspan\";s:1:\"8\";s:3:\"sql\";s:108:\" SELECT A.*,A.aid AS id FROM qb_article A  WHERE A.yz=1  AND A.mid=\'0\'   ORDER BY A.digg_num DESC LIMIT 0,8 \";s:4:\"sql2\";N;s:7:\"colspan\";s:1:\"1\";s:11:\"content_num\";s:2:\"80\";s:12:\"content_num2\";s:3:\"120\";s:8:\"titlenum\";s:2:\"44\";s:9:\"titlenum2\";s:2:\"40\";s:10:\"titleflood\";s:1:\"1\";s:9:\"start_num\";s:1:\"1\";s:10:\"c_rolltype\";s:1:\"0\";}','a:3:{s:5:\"div_w\";s:2:\"50\";s:5:\"div_h\";s:2:\"30\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','1494644204','0','0','0','0','default');
INSERT INTO `qb_label` VALUES ('125','','1','0','blue_indext9','specialsort','1','a:36:{s:9:\"tplpart_1\";s:140:\"<dl>\r\n<dt><a href=\"$url\" target=\"_blank\"><img src=\"$picurl\" width=\"90\"/></a></dt>\r\n<dd><A HREF=\"$url\" target=\"_blank\">$title</A></dd>\r\n</dl>\";s:13:\"tplpart_1code\";s:222:\"<dl>\r\n<dt><a href=\"$webdb[www_url]/do/showsp.php?fid=$fid&id=$id\" target=\"_blank\"><img src=\"$picurl\" width=\"90\"/></a></dt>\r\n<dd><A HREF=\"$webdb[www_url]/do/showsp.php?fid=$fid&id=$id\" target=\"_blank\">$title</A></dd>\r\n</dl>\";s:13:\"tplpart_2code\";s:0:\"\";s:3:\"SYS\";s:11:\"specialsort\";s:13:\"RollStyleType\";s:0:\"\";s:11:\"roll_height\";s:2:\"50\";s:3:\"url\";s:45:\"$webdb[www_url]/do/showsp.php?fid=$fid&id=$id\";s:5:\"width\";s:3:\"250\";s:6:\"height\";s:3:\"187\";s:8:\"rolltype\";s:10:\"scrollLeft\";s:8:\"rolltime\";s:1:\"3\";s:3:\"fid\";s:0:\"\";s:7:\"newhour\";s:2:\"24\";s:7:\"hothits\";s:3:\"100\";s:7:\"amodule\";N;s:7:\"tplpath\";s:0:\"\";s:6:\"DivTpl\";i:1;s:5:\"fiddb\";N;s:5:\"stype\";s:1:\"p\";s:2:\"yz\";N;s:7:\"hidefid\";N;s:10:\"timeformat\";s:11:\"Y-m-d H:i:s\";s:5:\"order\";s:4:\"list\";s:3:\"asc\";s:4:\"DESC\";s:6:\"levels\";s:3:\"all\";s:7:\"rowspan\";s:1:\"2\";s:3:\"sql\";s:108:\" SELECT A.* FROM qb_special A  WHERE `ifbase`=0 AND yz=1  AND A.picurl!=\'\'   ORDER BY A.list DESC LIMIT 0,2 \";s:4:\"sql2\";s:0:\"\";s:7:\"colspan\";s:1:\"1\";s:11:\"content_num\";s:2:\"80\";s:12:\"content_num2\";s:3:\"120\";s:8:\"titlenum\";s:2:\"40\";s:9:\"titlenum2\";s:2:\"40\";s:10:\"titleflood\";s:1:\"0\";s:9:\"start_num\";s:1:\"1\";s:10:\"c_rolltype\";s:1:\"0\";}','a:3:{s:5:\"div_w\";s:2:\"50\";s:5:\"div_h\";s:2:\"30\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','1308219201','0','0','0','0','blue_abc');
INSERT INTO `qb_label` VALUES ('126','','0','0','blue_indext10','specialsort','1','a:36:{s:9:\"tplpart_1\";s:106:\"<div class=\"list\"><A HREF=\"$webdb[www_url]/do/showsp.php?fid=$fid&id=$id\" target=\"_blank\">$title</A></div>\";s:13:\"tplpart_1code\";s:106:\"<div class=\"list\"><A HREF=\"$webdb[www_url]/do/showsp.php?fid=$fid&id=$id\" target=\"_blank\">$title</A></div>\";s:13:\"tplpart_2code\";s:0:\"\";s:3:\"SYS\";s:11:\"specialsort\";s:13:\"RollStyleType\";s:0:\"\";s:11:\"roll_height\";s:2:\"50\";s:3:\"url\";s:45:\"$webdb[www_url]/do/showsp.php?fid=$fid&id=$id\";s:5:\"width\";s:3:\"250\";s:6:\"height\";s:3:\"187\";s:8:\"rolltype\";s:10:\"scrollLeft\";s:8:\"rolltime\";s:1:\"3\";s:3:\"fid\";i:0;s:7:\"newhour\";s:2:\"24\";s:7:\"hothits\";s:2:\"30\";s:7:\"amodule\";N;s:7:\"tplpath\";s:0:\"\";s:6:\"DivTpl\";i:1;s:5:\"fiddb\";N;s:5:\"stype\";s:1:\"4\";s:2:\"yz\";N;s:7:\"hidefid\";N;s:10:\"timeformat\";s:11:\"Y-m-d H:i:s\";s:5:\"order\";s:4:\"list\";s:3:\"asc\";s:4:\"DESC\";s:6:\"levels\";s:3:\"all\";s:7:\"rowspan\";s:1:\"5\";s:3:\"sql\";s:90:\" SELECT A.* FROM qb_special A  WHERE `ifbase`=0 AND yz=1   ORDER BY A.list DESC LIMIT 2,5 \";s:4:\"sql2\";s:0:\"\";s:7:\"colspan\";s:1:\"1\";s:11:\"content_num\";s:2:\"80\";s:12:\"content_num2\";s:0:\"\";s:8:\"titlenum\";s:2:\"48\";s:9:\"titlenum2\";s:0:\"\";s:10:\"titleflood\";s:1:\"0\";s:9:\"start_num\";s:1:\"3\";s:10:\"c_rolltype\";s:1:\"0\";}','a:3:{s:5:\"div_w\";s:2:\"50\";s:5:\"div_h\";s:2:\"30\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','1494644637','0','0','0','0','default');
INSERT INTO `qb_label` VALUES ('127','','0','0','blue_indext11','article','1','a:34:{s:13:\"tplpart_1code\";s:82:\"<div class=\"list$i\"><span>$i</span><A HREF=\"$url\" target=\"_blank\">$title</A></div>\";s:13:\"tplpart_2code\";s:0:\"\";s:3:\"SYS\";s:7:\"artcile\";s:13:\"RollStyleType\";s:0:\"\";s:7:\"fidtype\";s:1:\"0\";s:8:\"rolltype\";s:10:\"scrollLeft\";s:8:\"rolltime\";s:1:\"3\";s:11:\"roll_height\";s:2:\"50\";s:5:\"width\";s:3:\"250\";s:6:\"height\";s:3:\"187\";s:7:\"newhour\";s:2:\"24\";s:7:\"hothits\";s:3:\"100\";s:7:\"amodule\";s:1:\"0\";s:7:\"tplpath\";s:0:\"\";s:6:\"DivTpl\";i:1;s:5:\"fiddb\";N;s:5:\"stype\";s:1:\"4\";s:2:\"yz\";s:1:\"1\";s:7:\"hidefid\";N;s:10:\"timeformat\";s:11:\"Y-m-d H:i:s\";s:5:\"order\";s:6:\"A.list\";s:3:\"asc\";s:4:\"DESC\";s:6:\"levels\";s:3:\"all\";s:7:\"rowspan\";s:2:\"10\";s:3:\"sql\";s:105:\" SELECT A.*,A.aid AS id FROM qb_article A  WHERE A.yz=1  AND A.mid=\'0\'   ORDER BY A.list DESC LIMIT 0,10 \";s:4:\"sql2\";N;s:7:\"colspan\";s:1:\"1\";s:11:\"content_num\";s:2:\"80\";s:12:\"content_num2\";s:3:\"120\";s:8:\"titlenum\";s:2:\"48\";s:9:\"titlenum2\";s:2:\"40\";s:10:\"titleflood\";s:1:\"1\";s:9:\"start_num\";s:1:\"1\";s:10:\"c_rolltype\";s:1:\"0\";}','a:3:{s:5:\"div_w\";s:2:\"50\";s:5:\"div_h\";s:2:\"30\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','1494644595','0','0','0','0','default');
INSERT INTO `qb_label` VALUES ('128','','0','0','blue_indext12','article','1','a:34:{s:13:\"tplpart_1code\";s:82:\"<div class=\"list$i\"><span>$i</span><A HREF=\"$url\" target=\"_blank\">$title</A></div>\";s:13:\"tplpart_2code\";s:0:\"\";s:3:\"SYS\";s:7:\"artcile\";s:13:\"RollStyleType\";s:0:\"\";s:7:\"fidtype\";s:1:\"0\";s:8:\"rolltype\";s:10:\"scrollLeft\";s:8:\"rolltime\";s:1:\"3\";s:11:\"roll_height\";s:2:\"50\";s:5:\"width\";s:3:\"250\";s:6:\"height\";s:3:\"187\";s:7:\"newhour\";s:2:\"24\";s:7:\"hothits\";s:3:\"100\";s:7:\"amodule\";s:1:\"0\";s:7:\"tplpath\";s:0:\"\";s:6:\"DivTpl\";i:1;s:5:\"fiddb\";N;s:5:\"stype\";s:1:\"4\";s:2:\"yz\";s:1:\"1\";s:7:\"hidefid\";N;s:10:\"timeformat\";s:11:\"Y-m-d H:i:s\";s:5:\"order\";s:10:\"A.digg_num\";s:3:\"asc\";s:4:\"DESC\";s:6:\"levels\";s:3:\"all\";s:7:\"rowspan\";s:2:\"10\";s:3:\"sql\";s:109:\" SELECT A.*,A.aid AS id FROM qb_article A  WHERE A.yz=1  AND A.mid=\'0\'   ORDER BY A.digg_num DESC LIMIT 0,10 \";s:4:\"sql2\";N;s:7:\"colspan\";s:1:\"1\";s:11:\"content_num\";s:2:\"80\";s:12:\"content_num2\";s:3:\"120\";s:8:\"titlenum\";s:2:\"48\";s:9:\"titlenum2\";s:2:\"40\";s:10:\"titleflood\";s:1:\"1\";s:9:\"start_num\";s:1:\"1\";s:10:\"c_rolltype\";s:1:\"0\";}','a:3:{s:5:\"div_w\";s:2:\"50\";s:5:\"div_h\";s:2:\"30\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','1494644602','0','0','0','0','default');
INSERT INTO `qb_label` VALUES ('129','','0','0','blue_indext13','article','1','a:34:{s:13:\"tplpart_1code\";s:82:\"<div class=\"list$i\"><span>$i</span><A HREF=\"$url\" target=\"_blank\">$title</A></div>\";s:13:\"tplpart_2code\";s:0:\"\";s:3:\"SYS\";s:7:\"artcile\";s:13:\"RollStyleType\";s:0:\"\";s:7:\"fidtype\";s:1:\"0\";s:8:\"rolltype\";s:10:\"scrollLeft\";s:8:\"rolltime\";s:1:\"3\";s:11:\"roll_height\";s:2:\"50\";s:5:\"width\";s:3:\"250\";s:6:\"height\";s:3:\"187\";s:7:\"newhour\";s:2:\"24\";s:7:\"hothits\";s:3:\"100\";s:7:\"amodule\";s:1:\"0\";s:7:\"tplpath\";s:0:\"\";s:6:\"DivTpl\";i:1;s:5:\"fiddb\";N;s:5:\"stype\";s:1:\"4\";s:2:\"yz\";s:1:\"1\";s:7:\"hidefid\";N;s:10:\"timeformat\";s:11:\"Y-m-d H:i:s\";s:5:\"order\";s:6:\"A.hits\";s:3:\"asc\";s:4:\"DESC\";s:6:\"levels\";s:3:\"all\";s:7:\"rowspan\";s:2:\"10\";s:3:\"sql\";s:105:\" SELECT A.*,A.aid AS id FROM qb_article A  WHERE A.yz=1  AND A.mid=\'0\'   ORDER BY A.hits DESC LIMIT 0,10 \";s:4:\"sql2\";N;s:7:\"colspan\";s:1:\"1\";s:11:\"content_num\";s:2:\"80\";s:12:\"content_num2\";s:3:\"120\";s:8:\"titlenum\";s:2:\"48\";s:9:\"titlenum2\";s:2:\"40\";s:10:\"titleflood\";s:1:\"1\";s:9:\"start_num\";s:1:\"1\";s:10:\"c_rolltype\";s:1:\"0\";}','a:3:{s:5:\"div_w\";s:2:\"50\";s:5:\"div_h\";s:2:\"30\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','1494644609','0','0','0','0','default');
INSERT INTO `qb_label` VALUES ('130','','1','0','blue_indexad2','pic','0','a:4:{s:6:\"imgurl\";s:22:\"../images/blue/ad3.gif\";s:7:\"imglink\";s:1:\"#\";s:5:\"width\";s:3:\"240\";s:6:\"height\";s:2:\"90\";}','a:3:{s:5:\"div_w\";s:0:\"\";s:5:\"div_h\";s:0:\"\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','0','0','0','0','0','blue_abc');
INSERT INTO `qb_label` VALUES ('131','','0','0','blue_indext14','article','1','a:34:{s:13:\"tplpart_1code\";s:65:\"<div class=\"list\"><A HREF=\"$url\" target=\"_blank\">$title</A></div>\";s:13:\"tplpart_2code\";s:0:\"\";s:3:\"SYS\";s:7:\"artcile\";s:13:\"RollStyleType\";s:0:\"\";s:7:\"fidtype\";s:1:\"0\";s:8:\"rolltype\";s:10:\"scrollLeft\";s:8:\"rolltime\";s:1:\"3\";s:11:\"roll_height\";s:2:\"50\";s:5:\"width\";s:3:\"250\";s:6:\"height\";s:3:\"187\";s:7:\"newhour\";s:2:\"24\";s:7:\"hothits\";s:3:\"100\";s:7:\"amodule\";s:1:\"0\";s:7:\"tplpath\";s:0:\"\";s:6:\"DivTpl\";i:1;s:5:\"fiddb\";N;s:5:\"stype\";s:1:\"4\";s:2:\"yz\";s:1:\"1\";s:7:\"hidefid\";N;s:10:\"timeformat\";s:11:\"Y-m-d H:i:s\";s:5:\"order\";s:6:\"A.list\";s:3:\"asc\";s:4:\"DESC\";s:6:\"levels\";s:3:\"all\";s:7:\"rowspan\";s:1:\"8\";s:3:\"sql\";s:104:\" SELECT A.*,A.aid AS id FROM qb_article A  WHERE A.yz=1  AND A.mid=\'0\'   ORDER BY A.list DESC LIMIT 0,8 \";s:4:\"sql2\";N;s:7:\"colspan\";s:1:\"1\";s:11:\"content_num\";s:2:\"80\";s:12:\"content_num2\";s:3:\"120\";s:8:\"titlenum\";s:2:\"50\";s:9:\"titlenum2\";s:2:\"40\";s:10:\"titleflood\";s:1:\"1\";s:9:\"start_num\";s:1:\"1\";s:10:\"c_rolltype\";s:1:\"0\";}','a:3:{s:5:\"div_w\";s:2:\"50\";s:5:\"div_h\";s:2:\"30\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','1494644688','0','0','0','0','default');
INSERT INTO `qb_label` VALUES ('132','','1','0','blue_indexh1','code','0','ͼƬ','a:4:{s:9:\"html_edit\";N;s:5:\"div_w\";s:0:\"\";s:5:\"div_h\";s:0:\"\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','0','0','0','0','0','blue_abc');
INSERT INTO `qb_label` VALUES ('133','','1','0','blue_indexh2','code','0','<span class=\"tag\"></span><span class=\"more\"><a href=\"list.php?fid=1\" target=\"_blank\">&gt;&gt;</a></span>','a:4:{s:9:\"html_edit\";N;s:5:\"div_w\";s:0:\"\";s:5:\"div_h\";s:0:\"\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','0','0','0','0','0','blue_abc');
INSERT INTO `qb_label` VALUES ('134','','1','0','blue_indexh3','code','0','<span class=\"tag\">ͼƬ</span><span class=\"more\"><a href=\"list.php?fid=9\" target=\"_blank\">&gt;&gt;</a></span>','a:4:{s:9:\"html_edit\";N;s:5:\"div_w\";s:0:\"\";s:5:\"div_h\";s:0:\"\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','0','0','0','0','0','blue_abc');
INSERT INTO `qb_label` VALUES ('135','','0','0','blue_indexh4','code','0','<span class=\"tag\"></span><span class=\"more\"><a href=\"list.php?fid=3\" target=\"_blank\">&gt;&gt;</a>','a:4:{s:9:\"html_edit\";N;s:5:\"div_w\";s:2:\"50\";s:5:\"div_h\";s:2:\"21\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','1494644878','0','0','0','0','default');
INSERT INTO `qb_label` VALUES ('136','','0','0','blue_indexh5','code','0','<span class=\"tag\">Ƽ</span><span class=\"more\"><a href=\"bencandy.php?fid=4&id=886\" target=\"_blank\">&gt;&gt;</a></span>','a:4:{s:9:\"html_edit\";N;s:5:\"div_w\";s:2:\"50\";s:5:\"div_h\";s:2:\"21\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','1494644764','0','0','0','0','default');
INSERT INTO `qb_label` VALUES ('137','','1','0','blue_indexh6','code','0','ŵ','a:4:{s:9:\"html_edit\";N;s:5:\"div_w\";s:0:\"\";s:5:\"div_h\";s:0:\"\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','0','0','0','0','0','blue_abc');
INSERT INTO `qb_label` VALUES ('138','','0','0','blue_indexh7','code','0','<span class=\"tag\">ר</span><span class=\"more\"><a href=\"do/listsp.php?fid=1\" target=\"_blank\">&gt;&gt;</a></span>','a:4:{s:9:\"html_edit\";N;s:5:\"div_w\";s:2:\"50\";s:5:\"div_h\";s:2:\"21\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','1494646804','0','0','0','0','default');
INSERT INTO `qb_label` VALUES ('139','','1','0','blue_indexh8','code','0','а','a:4:{s:9:\"html_edit\";N;s:5:\"div_w\";s:0:\"\";s:5:\"div_h\";s:0:\"\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','0','0','0','0','0','blue_abc');
INSERT INTO `qb_label` VALUES ('140','','1','0','blue_indexh9','code','0','<span onmouseover=\"ShowTab(1,1,4)\" id=\"Span1\"></span>\r\n<span onmouseover=\"ShowTab(2,1,4)\" id=\"Span2\"></span>\r\n<span onmouseover=\"ShowTab(3,1,4)\" id=\"Span3\">ȵ</span>','a:4:{s:9:\"html_edit\";N;s:5:\"div_w\";s:0:\"\";s:5:\"div_h\";s:0:\"\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','1308280539','0','0','0','0','blue_abc');
INSERT INTO `qb_label` VALUES ('141','','1','0','blue_indexh10','code','0','<span class=\"tag\"></span><span class=\"more\"><a href=\"./do/friendlink.php?job=apply\" target=\"_blank\"></a></span>','a:4:{s:9:\"html_edit\";N;s:5:\"div_w\";s:0:\"\";s:5:\"div_h\";s:0:\"\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','0','0','0','0','0','blue_abc');
INSERT INTO `qb_label` VALUES ('142','','0','0','blue_listad1','pic','0','a:5:{s:6:\"imgurl\";s:22:\"../images/blue/ad4.gif\";s:7:\"imglink\";s:1:\"#\";s:5:\"width\";s:0:\"\";s:6:\"height\";s:0:\"\";s:11:\"pic_city_id\";i:0;}','a:3:{s:5:\"div_w\";s:2:\"50\";s:5:\"div_h\";s:2:\"21\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','1494656550','2','0','0','0','default');
INSERT INTO `qb_label` VALUES ('143','','0','0','blue_listh1','code','0','а','a:4:{s:9:\"html_edit\";N;s:5:\"div_w\";s:0:\"\";s:5:\"div_h\";s:0:\"\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','0','2','0','0','0','blue_abc');
INSERT INTO `qb_label` VALUES ('144','','0','0','blue_listh2','code','0','<span onmouseover=\"ShowTab(1,1,4)\" id=\"Span1\"></span>\r\n<span onmouseover=\"ShowTab(2,1,4)\" id=\"Span2\"></span>\r\n<span onmouseover=\"ShowTab(3,1,4)\" id=\"Span3\">ȵ</span>','a:4:{s:9:\"html_edit\";N;s:5:\"div_w\";s:0:\"\";s:5:\"div_h\";s:0:\"\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','0','2','0','0','0','blue_abc');
INSERT INTO `qb_label` VALUES ('145','','0','0','blue_listt3','article','1','a:34:{s:13:\"tplpart_1code\";s:82:\"<div class=\"list$i\"><span>$i</span><A HREF=\"$url\" target=\"_blank\">$title</A></div>\";s:13:\"tplpart_2code\";s:0:\"\";s:3:\"SYS\";s:7:\"artcile\";s:13:\"RollStyleType\";s:0:\"\";s:7:\"fidtype\";s:1:\"0\";s:8:\"rolltype\";s:10:\"scrollLeft\";s:8:\"rolltime\";s:1:\"3\";s:11:\"roll_height\";s:2:\"50\";s:5:\"width\";s:3:\"250\";s:6:\"height\";s:3:\"187\";s:7:\"newhour\";s:2:\"24\";s:7:\"hothits\";s:3:\"100\";s:7:\"amodule\";s:1:\"0\";s:7:\"tplpath\";s:0:\"\";s:6:\"DivTpl\";i:1;s:5:\"fiddb\";N;s:5:\"stype\";s:1:\"4\";s:2:\"yz\";s:1:\"1\";s:7:\"hidefid\";N;s:10:\"timeformat\";s:11:\"Y-m-d H:i:s\";s:5:\"order\";s:6:\"A.hits\";s:3:\"asc\";s:4:\"DESC\";s:6:\"levels\";s:3:\"all\";s:7:\"rowspan\";s:2:\"10\";s:3:\"sql\";s:105:\" SELECT A.*,A.aid AS id FROM qb_article A  WHERE A.yz=1  AND A.mid=\'0\'   ORDER BY A.hits DESC LIMIT 0,10 \";s:4:\"sql2\";N;s:7:\"colspan\";s:1:\"1\";s:11:\"content_num\";s:2:\"80\";s:12:\"content_num2\";s:3:\"120\";s:8:\"titlenum\";s:2:\"32\";s:9:\"titlenum2\";s:2:\"40\";s:10:\"titleflood\";s:1:\"0\";s:9:\"start_num\";s:1:\"1\";s:10:\"c_rolltype\";s:1:\"0\";}','a:3:{s:5:\"div_w\";s:2:\"50\";s:5:\"div_h\";s:2:\"30\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','0','2','0','0','0','blue_abc');
INSERT INTO `qb_label` VALUES ('146','','0','0','blue_listt2','article','1','a:34:{s:13:\"tplpart_1code\";s:82:\"<div class=\"list$i\"><span>$i</span><A HREF=\"$url\" target=\"_blank\">$title</A></div>\";s:13:\"tplpart_2code\";s:0:\"\";s:3:\"SYS\";s:7:\"artcile\";s:13:\"RollStyleType\";s:0:\"\";s:7:\"fidtype\";s:1:\"0\";s:8:\"rolltype\";s:10:\"scrollLeft\";s:8:\"rolltime\";s:1:\"3\";s:11:\"roll_height\";s:2:\"50\";s:5:\"width\";s:3:\"250\";s:6:\"height\";s:3:\"187\";s:7:\"newhour\";s:2:\"24\";s:7:\"hothits\";s:3:\"100\";s:7:\"amodule\";s:1:\"0\";s:7:\"tplpath\";s:0:\"\";s:6:\"DivTpl\";i:1;s:5:\"fiddb\";N;s:5:\"stype\";s:1:\"4\";s:2:\"yz\";s:1:\"1\";s:7:\"hidefid\";N;s:10:\"timeformat\";s:11:\"Y-m-d H:i:s\";s:5:\"order\";s:10:\"A.digg_num\";s:3:\"asc\";s:4:\"DESC\";s:6:\"levels\";s:3:\"all\";s:7:\"rowspan\";s:2:\"10\";s:3:\"sql\";s:109:\" SELECT A.*,A.aid AS id FROM qb_article A  WHERE A.yz=1  AND A.mid=\'0\'   ORDER BY A.digg_num DESC LIMIT 0,10 \";s:4:\"sql2\";N;s:7:\"colspan\";s:1:\"1\";s:11:\"content_num\";s:2:\"80\";s:12:\"content_num2\";s:3:\"120\";s:8:\"titlenum\";s:2:\"32\";s:9:\"titlenum2\";s:2:\"40\";s:10:\"titleflood\";s:1:\"0\";s:9:\"start_num\";s:1:\"1\";s:10:\"c_rolltype\";s:1:\"0\";}','a:3:{s:5:\"div_w\";s:2:\"50\";s:5:\"div_h\";s:2:\"30\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','0','2','0','0','0','blue_abc');
INSERT INTO `qb_label` VALUES ('147','','0','0','blue_listt1','article','1','a:34:{s:13:\"tplpart_1code\";s:82:\"<div class=\"list$i\"><span>$i</span><A HREF=\"$url\" target=\"_blank\">$title</A></div>\";s:13:\"tplpart_2code\";s:0:\"\";s:3:\"SYS\";s:7:\"artcile\";s:13:\"RollStyleType\";s:0:\"\";s:7:\"fidtype\";s:1:\"0\";s:8:\"rolltype\";s:10:\"scrollLeft\";s:8:\"rolltime\";s:1:\"3\";s:11:\"roll_height\";s:2:\"50\";s:5:\"width\";s:3:\"250\";s:6:\"height\";s:3:\"187\";s:7:\"newhour\";s:2:\"24\";s:7:\"hothits\";s:3:\"100\";s:7:\"amodule\";s:1:\"0\";s:7:\"tplpath\";s:0:\"\";s:6:\"DivTpl\";i:1;s:5:\"fiddb\";N;s:5:\"stype\";s:1:\"4\";s:2:\"yz\";s:1:\"1\";s:7:\"hidefid\";N;s:10:\"timeformat\";s:11:\"Y-m-d H:i:s\";s:5:\"order\";s:6:\"A.list\";s:3:\"asc\";s:4:\"DESC\";s:6:\"levels\";s:3:\"all\";s:7:\"rowspan\";s:2:\"10\";s:3:\"sql\";s:105:\" SELECT A.*,A.aid AS id FROM qb_article A  WHERE A.yz=1  AND A.mid=\'0\'   ORDER BY A.list DESC LIMIT 0,10 \";s:4:\"sql2\";N;s:7:\"colspan\";s:1:\"1\";s:11:\"content_num\";s:2:\"80\";s:12:\"content_num2\";s:3:\"120\";s:8:\"titlenum\";s:2:\"40\";s:9:\"titlenum2\";s:2:\"40\";s:10:\"titleflood\";s:1:\"1\";s:9:\"start_num\";s:1:\"1\";s:10:\"c_rolltype\";s:1:\"0\";}','a:3:{s:5:\"div_w\";s:2:\"50\";s:5:\"div_h\";s:2:\"30\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','1494656070','2','0','0','0','default');
INSERT INTO `qb_label` VALUES ('148','','0','0','blue_listh3','code','0','<span class=\"tag\">ר</span><span class=\"more\"><a href=\"listsp.php?fid=1\" target=\"_blank\">&gt;&gt;</a></span>','a:4:{s:9:\"html_edit\";N;s:5:\"div_w\";s:0:\"\";s:5:\"div_h\";s:0:\"\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','0','2','0','0','0','blue_abc');
INSERT INTO `qb_label` VALUES ('149','','0','0','blue_listt4','specialsort','1','a:36:{s:9:\"tplpart_1\";s:222:\"<dl>\r\n<dt><a href=\"$webdb[www_url]/do/showsp.php?fid=$fid&id=$id\" target=\"_blank\"><img src=\"$picurl\" width=\"90\"/></a></dt>\r\n<dd><A HREF=\"$webdb[www_url]/do/showsp.php?fid=$fid&id=$id\" target=\"_blank\">$title</A></dd>\r\n</dl>\";s:13:\"tplpart_1code\";s:222:\"<dl>\r\n<dt><a href=\"$webdb[www_url]/do/showsp.php?fid=$fid&id=$id\" target=\"_blank\"><img src=\"$picurl\" width=\"90\"/></a></dt>\r\n<dd><A HREF=\"$webdb[www_url]/do/showsp.php?fid=$fid&id=$id\" target=\"_blank\">$title</A></dd>\r\n</dl>\";s:13:\"tplpart_2code\";s:0:\"\";s:3:\"SYS\";s:11:\"specialsort\";s:13:\"RollStyleType\";s:0:\"\";s:11:\"roll_height\";s:2:\"50\";s:3:\"url\";s:45:\"$webdb[www_url]/do/showsp.php?fid=$fid&id=$id\";s:5:\"width\";s:3:\"250\";s:6:\"height\";s:3:\"187\";s:8:\"rolltype\";s:10:\"scrollLeft\";s:8:\"rolltime\";s:1:\"3\";s:3:\"fid\";s:0:\"\";s:7:\"newhour\";s:2:\"24\";s:7:\"hothits\";s:2:\"30\";s:7:\"amodule\";N;s:7:\"tplpath\";s:0:\"\";s:6:\"DivTpl\";i:1;s:5:\"fiddb\";N;s:5:\"stype\";s:1:\"4\";s:2:\"yz\";N;s:7:\"hidefid\";N;s:10:\"timeformat\";s:11:\"Y-m-d H:i:s\";s:5:\"order\";s:4:\"list\";s:3:\"asc\";s:4:\"DESC\";s:6:\"levels\";s:3:\"all\";s:7:\"rowspan\";s:1:\"2\";s:3:\"sql\";s:108:\" SELECT A.* FROM qb_special A  WHERE `ifbase`=0 AND yz=1  AND A.picurl!=\'\'   ORDER BY A.list DESC LIMIT 0,2 \";s:4:\"sql2\";s:0:\"\";s:7:\"colspan\";s:1:\"1\";s:11:\"content_num\";s:2:\"80\";s:12:\"content_num2\";s:0:\"\";s:8:\"titlenum\";s:2:\"40\";s:9:\"titlenum2\";s:0:\"\";s:10:\"titleflood\";s:1:\"0\";s:9:\"start_num\";s:1:\"1\";s:10:\"c_rolltype\";s:1:\"0\";}','a:3:{s:5:\"div_w\";s:2:\"50\";s:5:\"div_h\";s:2:\"30\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','0','2','0','0','0','blue_abc');
INSERT INTO `qb_label` VALUES ('150','','0','0','blue_listt5','specialsort','1','a:36:{s:9:\"tplpart_1\";s:106:\"<div class=\"list\"><A HREF=\"$webdb[www_url]/do/showsp.php?fid=$fid&id=$id\" target=\"_blank\">$title</A></div>\";s:13:\"tplpart_1code\";s:106:\"<div class=\"list\"><A HREF=\"$webdb[www_url]/do/showsp.php?fid=$fid&id=$id\" target=\"_blank\">$title</A></div>\";s:13:\"tplpart_2code\";s:0:\"\";s:3:\"SYS\";s:11:\"specialsort\";s:13:\"RollStyleType\";s:0:\"\";s:11:\"roll_height\";s:2:\"50\";s:3:\"url\";s:45:\"$webdb[www_url]/do/showsp.php?fid=$fid&id=$id\";s:5:\"width\";s:3:\"250\";s:6:\"height\";s:3:\"187\";s:8:\"rolltype\";s:10:\"scrollLeft\";s:8:\"rolltime\";s:1:\"3\";s:3:\"fid\";s:0:\"\";s:7:\"newhour\";s:2:\"24\";s:7:\"hothits\";s:2:\"30\";s:7:\"amodule\";N;s:7:\"tplpath\";s:0:\"\";s:6:\"DivTpl\";i:1;s:5:\"fiddb\";N;s:5:\"stype\";s:1:\"4\";s:2:\"yz\";N;s:7:\"hidefid\";N;s:10:\"timeformat\";s:11:\"Y-m-d H:i:s\";s:5:\"order\";s:4:\"list\";s:3:\"asc\";s:4:\"DESC\";s:6:\"levels\";s:3:\"all\";s:7:\"rowspan\";s:1:\"5\";s:3:\"sql\";s:90:\" SELECT A.* FROM qb_special A  WHERE `ifbase`=0 AND yz=1   ORDER BY A.list DESC LIMIT 2,5 \";s:4:\"sql2\";s:0:\"\";s:7:\"colspan\";s:1:\"1\";s:11:\"content_num\";s:2:\"80\";s:12:\"content_num2\";s:0:\"\";s:8:\"titlenum\";s:2:\"40\";s:9:\"titlenum2\";s:0:\"\";s:10:\"titleflood\";s:1:\"0\";s:9:\"start_num\";s:1:\"3\";s:10:\"c_rolltype\";s:1:\"0\";}','a:3:{s:5:\"div_w\";s:2:\"50\";s:5:\"div_h\";s:2:\"30\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','0','2','0','0','0','blue_abc');
INSERT INTO `qb_label` VALUES ('151','','0','0','blue_bencandyt1','article','1','a:34:{s:13:\"tplpart_1code\";s:201:\"<dl>\r\n<dt><a href=\"$url\" target=\"_blank\"><img src=\"$picurl\" width=\"95\"/></a></dt>\r\n<dd>\r\n	<div class=\"t\"><A HREF=\"$url\" target=\"_blank\">$title</A></div>\r\n    <div class=\"c\">$content</div>\r\n</dd>\r\n</dl>\";s:13:\"tplpart_2code\";s:0:\"\";s:3:\"SYS\";s:7:\"artcile\";s:13:\"RollStyleType\";s:0:\"\";s:7:\"fidtype\";s:1:\"0\";s:8:\"rolltype\";s:10:\"scrollLeft\";s:8:\"rolltime\";s:1:\"3\";s:11:\"roll_height\";s:2:\"50\";s:5:\"width\";s:3:\"250\";s:6:\"height\";s:3:\"187\";s:7:\"newhour\";s:2:\"24\";s:7:\"hothits\";s:3:\"100\";s:7:\"amodule\";s:1:\"0\";s:7:\"tplpath\";s:0:\"\";s:6:\"DivTpl\";i:1;s:5:\"fiddb\";N;s:5:\"stype\";s:2:\"cp\";s:2:\"yz\";s:1:\"1\";s:7:\"hidefid\";N;s:10:\"timeformat\";s:11:\"Y-m-d H:i:s\";s:5:\"order\";s:10:\"A.digg_num\";s:3:\"asc\";s:4:\"DESC\";s:6:\"levels\";s:3:\"all\";s:7:\"rowspan\";s:1:\"3\";s:3:\"sql\";s:199:\" SELECT A.*,A.aid AS id,R.content FROM qb_article A LEFT JOIN qb_reply R ON A.aid=R.aid   WHERE A.yz=1  AND A.mid=\'0\'  AND A.ispic=1   AND A.ispic=1  AND R.topic=1 ORDER BY A.digg_num DESC LIMIT 0,3 \";s:4:\"sql2\";N;s:7:\"colspan\";s:1:\"1\";s:11:\"content_num\";s:2:\"60\";s:12:\"content_num2\";s:3:\"120\";s:8:\"titlenum\";s:2:\"40\";s:9:\"titlenum2\";s:2:\"40\";s:10:\"titleflood\";s:1:\"0\";s:9:\"start_num\";s:1:\"1\";s:10:\"c_rolltype\";s:1:\"0\";}','a:3:{s:5:\"div_w\";s:3:\"896\";s:5:\"div_h\";s:2:\"61\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','1308296453','3','0','0','0','blue_abc');
INSERT INTO `qb_label` VALUES ('152','','0','0','blue_bencandyh1','code','0','а','a:4:{s:9:\"html_edit\";N;s:5:\"div_w\";s:0:\"\";s:5:\"div_h\";s:0:\"\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','0','3','0','0','0','blue_abc');
INSERT INTO `qb_label` VALUES ('153','','0','0','blue_bencandyh2','code','0','<span onmouseover=\"ShowTab(1,1,4)\" id=\"Span1\"></span>\r\n<span onmouseover=\"ShowTab(2,1,4)\" id=\"Span2\"></span>\r\n<span onmouseover=\"ShowTab(3,1,4)\" id=\"Span3\">ȵ</span>','a:4:{s:9:\"html_edit\";N;s:5:\"div_w\";s:0:\"\";s:5:\"div_h\";s:0:\"\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','0','3','0','0','0','blue_abc');
INSERT INTO `qb_label` VALUES ('154','','0','0','blue_bencandyt2','article','1','a:34:{s:13:\"tplpart_1code\";s:82:\"<div class=\"list$i\"><span>$i</span><A HREF=\"$url\" target=\"_blank\">$title</A></div>\";s:13:\"tplpart_2code\";s:0:\"\";s:3:\"SYS\";s:7:\"artcile\";s:13:\"RollStyleType\";s:0:\"\";s:7:\"fidtype\";s:1:\"0\";s:8:\"rolltype\";s:10:\"scrollLeft\";s:8:\"rolltime\";s:1:\"3\";s:11:\"roll_height\";s:2:\"50\";s:5:\"width\";s:3:\"250\";s:6:\"height\";s:3:\"187\";s:7:\"newhour\";s:2:\"24\";s:7:\"hothits\";s:3:\"100\";s:7:\"amodule\";s:1:\"0\";s:7:\"tplpath\";s:0:\"\";s:6:\"DivTpl\";i:1;s:5:\"fiddb\";N;s:5:\"stype\";s:1:\"4\";s:2:\"yz\";s:1:\"1\";s:7:\"hidefid\";N;s:10:\"timeformat\";s:11:\"Y-m-d H:i:s\";s:5:\"order\";s:10:\"A.digg_num\";s:3:\"asc\";s:4:\"DESC\";s:6:\"levels\";s:3:\"all\";s:7:\"rowspan\";s:2:\"10\";s:3:\"sql\";s:109:\" SELECT A.*,A.aid AS id FROM qb_article A  WHERE A.yz=1  AND A.mid=\'0\'   ORDER BY A.digg_num DESC LIMIT 0,10 \";s:4:\"sql2\";N;s:7:\"colspan\";s:1:\"1\";s:11:\"content_num\";s:2:\"80\";s:12:\"content_num2\";s:3:\"120\";s:8:\"titlenum\";s:2:\"32\";s:9:\"titlenum2\";s:2:\"40\";s:10:\"titleflood\";s:1:\"0\";s:9:\"start_num\";s:1:\"1\";s:10:\"c_rolltype\";s:1:\"0\";}','a:3:{s:5:\"div_w\";s:2:\"50\";s:5:\"div_h\";s:2:\"30\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','0','3','0','0','0','blue_abc');
INSERT INTO `qb_label` VALUES ('155','','0','0','blue_bencandyt01','article','1','a:34:{s:13:\"tplpart_1code\";s:82:\"<div class=\"list$i\"><span>$i</span><A HREF=\"$url\" target=\"_blank\">$title</A></div>\";s:13:\"tplpart_2code\";s:0:\"\";s:3:\"SYS\";s:7:\"artcile\";s:13:\"RollStyleType\";s:0:\"\";s:7:\"fidtype\";s:1:\"0\";s:8:\"rolltype\";s:10:\"scrollLeft\";s:8:\"rolltime\";s:1:\"3\";s:11:\"roll_height\";s:2:\"50\";s:5:\"width\";s:3:\"250\";s:6:\"height\";s:3:\"187\";s:7:\"newhour\";s:2:\"24\";s:7:\"hothits\";s:3:\"100\";s:7:\"amodule\";s:1:\"0\";s:7:\"tplpath\";s:0:\"\";s:6:\"DivTpl\";i:1;s:5:\"fiddb\";N;s:5:\"stype\";s:1:\"4\";s:2:\"yz\";s:1:\"1\";s:7:\"hidefid\";N;s:10:\"timeformat\";s:11:\"Y-m-d H:i:s\";s:5:\"order\";s:6:\"A.list\";s:3:\"asc\";s:4:\"DESC\";s:6:\"levels\";s:3:\"all\";s:7:\"rowspan\";s:2:\"10\";s:3:\"sql\";s:105:\" SELECT A.*,A.aid AS id FROM qb_article A  WHERE A.yz=1  AND A.mid=\'0\'   ORDER BY A.list DESC LIMIT 0,10 \";s:4:\"sql2\";N;s:7:\"colspan\";s:1:\"1\";s:11:\"content_num\";s:2:\"80\";s:12:\"content_num2\";s:3:\"120\";s:8:\"titlenum\";s:2:\"32\";s:9:\"titlenum2\";s:2:\"40\";s:10:\"titleflood\";s:1:\"0\";s:9:\"start_num\";s:1:\"1\";s:10:\"c_rolltype\";s:1:\"0\";}','a:3:{s:5:\"div_w\";s:2:\"50\";s:5:\"div_h\";s:2:\"30\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','0','3','0','0','0','blue_abc');
INSERT INTO `qb_label` VALUES ('156','','0','0','blue_bencandyt3','article','1','a:34:{s:13:\"tplpart_1code\";s:82:\"<div class=\"list$i\"><span>$i</span><A HREF=\"$url\" target=\"_blank\">$title</A></div>\";s:13:\"tplpart_2code\";s:0:\"\";s:3:\"SYS\";s:7:\"artcile\";s:13:\"RollStyleType\";s:0:\"\";s:7:\"fidtype\";s:1:\"0\";s:8:\"rolltype\";s:10:\"scrollLeft\";s:8:\"rolltime\";s:1:\"3\";s:11:\"roll_height\";s:2:\"50\";s:5:\"width\";s:3:\"250\";s:6:\"height\";s:3:\"187\";s:7:\"newhour\";s:2:\"24\";s:7:\"hothits\";s:3:\"100\";s:7:\"amodule\";s:1:\"0\";s:7:\"tplpath\";s:0:\"\";s:6:\"DivTpl\";i:1;s:5:\"fiddb\";N;s:5:\"stype\";s:1:\"4\";s:2:\"yz\";s:1:\"1\";s:7:\"hidefid\";N;s:10:\"timeformat\";s:11:\"Y-m-d H:i:s\";s:5:\"order\";s:6:\"A.hits\";s:3:\"asc\";s:4:\"DESC\";s:6:\"levels\";s:3:\"all\";s:7:\"rowspan\";s:2:\"10\";s:3:\"sql\";s:105:\" SELECT A.*,A.aid AS id FROM qb_article A  WHERE A.yz=1  AND A.mid=\'0\'   ORDER BY A.hits DESC LIMIT 0,10 \";s:4:\"sql2\";N;s:7:\"colspan\";s:1:\"1\";s:11:\"content_num\";s:2:\"80\";s:12:\"content_num2\";s:3:\"120\";s:8:\"titlenum\";s:2:\"32\";s:9:\"titlenum2\";s:2:\"40\";s:10:\"titleflood\";s:1:\"0\";s:9:\"start_num\";s:1:\"1\";s:10:\"c_rolltype\";s:1:\"0\";}','a:3:{s:5:\"div_w\";s:2:\"50\";s:5:\"div_h\";s:2:\"30\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','0','3','0','0','0','blue_abc');
INSERT INTO `qb_label` VALUES ('157','','0','0','blue_bencandyh3','code','0','<span class=\"tag\">ר</span><span class=\"more\"><a href=\"listsp.php?fid=1\" target=\"_blank\">&gt;&gt;</a></span>','a:4:{s:9:\"html_edit\";N;s:5:\"div_w\";s:0:\"\";s:5:\"div_h\";s:0:\"\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','0','3','0','0','0','blue_abc');
INSERT INTO `qb_label` VALUES ('158','','0','0','blue_bencandyt4','specialsort','1','a:36:{s:9:\"tplpart_1\";s:222:\"<dl>\r\n<dt><a href=\"$webdb[www_url]/do/showsp.php?fid=$fid&id=$id\" target=\"_blank\"><img src=\"$picurl\" width=\"90\"/></a></dt>\r\n<dd><A HREF=\"$webdb[www_url]/do/showsp.php?fid=$fid&id=$id\" target=\"_blank\">$title</A></dd>\r\n</dl>\";s:13:\"tplpart_1code\";s:222:\"<dl>\r\n<dt><a href=\"$webdb[www_url]/do/showsp.php?fid=$fid&id=$id\" target=\"_blank\"><img src=\"$picurl\" width=\"90\"/></a></dt>\r\n<dd><A HREF=\"$webdb[www_url]/do/showsp.php?fid=$fid&id=$id\" target=\"_blank\">$title</A></dd>\r\n</dl>\";s:13:\"tplpart_2code\";s:0:\"\";s:3:\"SYS\";s:11:\"specialsort\";s:13:\"RollStyleType\";s:0:\"\";s:11:\"roll_height\";s:2:\"50\";s:3:\"url\";s:45:\"$webdb[www_url]/do/showsp.php?fid=$fid&id=$id\";s:5:\"width\";s:3:\"250\";s:6:\"height\";s:3:\"187\";s:8:\"rolltype\";s:10:\"scrollLeft\";s:8:\"rolltime\";s:1:\"3\";s:3:\"fid\";s:0:\"\";s:7:\"newhour\";s:2:\"24\";s:7:\"hothits\";s:2:\"30\";s:7:\"amodule\";N;s:7:\"tplpath\";s:0:\"\";s:6:\"DivTpl\";i:1;s:5:\"fiddb\";N;s:5:\"stype\";s:1:\"4\";s:2:\"yz\";N;s:7:\"hidefid\";N;s:10:\"timeformat\";s:11:\"Y-m-d H:i:s\";s:5:\"order\";s:4:\"list\";s:3:\"asc\";s:4:\"DESC\";s:6:\"levels\";s:3:\"all\";s:7:\"rowspan\";s:1:\"2\";s:3:\"sql\";s:108:\" SELECT A.* FROM qb_special A  WHERE `ifbase`=0 AND yz=1  AND A.picurl!=\'\'   ORDER BY A.list DESC LIMIT 0,2 \";s:4:\"sql2\";s:0:\"\";s:7:\"colspan\";s:1:\"1\";s:11:\"content_num\";s:2:\"80\";s:12:\"content_num2\";s:0:\"\";s:8:\"titlenum\";s:2:\"40\";s:9:\"titlenum2\";s:0:\"\";s:10:\"titleflood\";s:1:\"0\";s:9:\"start_num\";s:1:\"1\";s:10:\"c_rolltype\";s:1:\"0\";}','a:3:{s:5:\"div_w\";s:2:\"50\";s:5:\"div_h\";s:2:\"30\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','0','3','0','0','0','blue_abc');
INSERT INTO `qb_label` VALUES ('159','','0','0','blue_bencandyt5','specialsort','1','a:36:{s:9:\"tplpart_1\";s:106:\"<div class=\"list\"><A HREF=\"$webdb[www_url]/do/showsp.php?fid=$fid&id=$id\" target=\"_blank\">$title</A></div>\";s:13:\"tplpart_1code\";s:106:\"<div class=\"list\"><A HREF=\"$webdb[www_url]/do/showsp.php?fid=$fid&id=$id\" target=\"_blank\">$title</A></div>\";s:13:\"tplpart_2code\";s:0:\"\";s:3:\"SYS\";s:11:\"specialsort\";s:13:\"RollStyleType\";s:0:\"\";s:11:\"roll_height\";s:2:\"50\";s:3:\"url\";s:45:\"$webdb[www_url]/do/showsp.php?fid=$fid&id=$id\";s:5:\"width\";s:3:\"250\";s:6:\"height\";s:3:\"187\";s:8:\"rolltype\";s:10:\"scrollLeft\";s:8:\"rolltime\";s:1:\"3\";s:3:\"fid\";s:0:\"\";s:7:\"newhour\";s:2:\"24\";s:7:\"hothits\";s:2:\"30\";s:7:\"amodule\";N;s:7:\"tplpath\";s:0:\"\";s:6:\"DivTpl\";i:1;s:5:\"fiddb\";N;s:5:\"stype\";s:1:\"4\";s:2:\"yz\";N;s:7:\"hidefid\";N;s:10:\"timeformat\";s:11:\"Y-m-d H:i:s\";s:5:\"order\";s:4:\"list\";s:3:\"asc\";s:4:\"DESC\";s:6:\"levels\";s:3:\"all\";s:7:\"rowspan\";s:1:\"5\";s:3:\"sql\";s:90:\" SELECT A.* FROM qb_special A  WHERE `ifbase`=0 AND yz=1   ORDER BY A.list DESC LIMIT 2,5 \";s:4:\"sql2\";s:0:\"\";s:7:\"colspan\";s:1:\"1\";s:11:\"content_num\";s:2:\"80\";s:12:\"content_num2\";s:0:\"\";s:8:\"titlenum\";s:2:\"40\";s:9:\"titlenum2\";s:0:\"\";s:10:\"titleflood\";s:1:\"0\";s:9:\"start_num\";s:1:\"3\";s:10:\"c_rolltype\";s:1:\"0\";}','a:3:{s:5:\"div_w\";s:2:\"50\";s:5:\"div_h\";s:2:\"30\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','0','3','0','0','0','blue_abc');
INSERT INTO `qb_label` VALUES ('160','','0','0','blue_bencandyad1','pic','0','a:4:{s:6:\"imgurl\";s:22:\"../images/blue/ad5.gif\";s:7:\"imglink\";s:1:\"#\";s:5:\"width\";s:3:\"240\";s:6:\"height\";s:3:\"150\";}','a:3:{s:5:\"div_w\";s:0:\"\";s:5:\"div_h\";s:0:\"\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','0','3','0','0','0','blue_abc');
INSERT INTO `qb_label` VALUES ('161','','0','0','news_wapindex_ad1','pic','0','a:5:{s:6:\"imgurl\";s:27:\"../images/wap/picmsg_ad.jpg\";s:7:\"imglink\";s:1:\"#\";s:5:\"width\";s:0:\"\";s:6:\"height\";s:0:\"\";s:11:\"pic_city_id\";i:0;}','a:3:{s:5:\"div_w\";s:0:\"\";s:5:\"div_h\";s:0:\"\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','0','8','0','0','0','news_style');
INSERT INTO `qb_label` VALUES ('162','','0','0','news_wapindex_ad2','pic','0','a:5:{s:6:\"imgurl\";s:24:\"../images/wap/new_ad.jpg\";s:7:\"imglink\";s:1:\"#\";s:5:\"width\";s:0:\"\";s:6:\"height\";s:0:\"\";s:11:\"pic_city_id\";i:0;}','a:3:{s:5:\"div_w\";s:0:\"\";s:5:\"div_h\";s:0:\"\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','0','8','0','0','0','news_style');
INSERT INTO `qb_label` VALUES ('163','','0','0','news_wapindex_ad3','pic','0','a:5:{s:6:\"imgurl\";s:27:\"../images/wap/wm_banner.png\";s:7:\"imglink\";s:1:\"#\";s:5:\"width\";s:0:\"\";s:6:\"height\";s:0:\"\";s:11:\"pic_city_id\";i:0;}','a:3:{s:5:\"div_w\";s:0:\"\";s:5:\"div_h\";s:0:\"\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','0','8','0','0','0','news_style');
INSERT INTO `qb_label` VALUES ('164','','0','0','news_wapindex_slide','rollpic','0','a:8:{s:13:\"tplpart_1code\";s:640:\"<!--\r\nEOT;\r\n$listslide=\"<link rel=\'stylesheet\' type=\'text/css\' href=\'$webdb[www_url]/images/news/slide.css\'>\\r\\n<div class=\'SlideBox\'>\\r\\n<div class=\'slideimgs\'>\\r\\n<ul>\\r\\n\";\r\nforeach($listdb AS $key=>$rs){@extract($rs);\r\n$listslide.=\"<li><img src=\'$rs[picurl]\' onError=\\\"this.src=\'$webdb[www_url]/images/default/nopic.jpg\'\\\" alt=\'$rs[url]\' title=\'$title\'/></li>\\r\\n\";\r\n}\r\n$listslide.=\"</ul>\\r\\n</div>\\r\\n</div>\\r\\n<script  type=\'text/javascript\' src=\'$webdb[www_url]/images/news/jquery.touchSwipe.min.js\'></script>\\r\\n<script type=\'text/javascript\' src=\'$webdb[www_url]/images/news/slide.js\'></script>\\r\\n\";\r\nprint <<<EOT\r\n-->\r\n$listslide\";s:8:\"rolltype\";s:3:\"100\";s:5:\"width\";s:0:\"\";s:6:\"height\";s:0:\"\";s:6:\"picurl\";a:3:{i:0;s:23:\"../images/wap/flash.png\";i:1;s:24:\"../images/wap/flash1.png\";i:2;s:24:\"../images/wap/flash2.png\";}s:7:\"piclink\";a:3:{i:0;s:2:\"#1\";i:1;s:2:\"#2\";i:2;s:2:\"#3\";}s:6:\"picalt\";a:3:{i:0;s:1:\"a\";i:1;s:1:\"b\";i:2;s:1:\"c\";}s:11:\"pic_city_id\";i:0;}','a:3:{s:5:\"div_w\";s:2:\"50\";s:5:\"div_h\";s:2:\"21\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','1494320992','8','0','0','0','news_style');
INSERT INTO `qb_label` VALUES ('165','','0','0','blue_indexad','pic','0','a:5:{s:6:\"imgurl\";s:21:\"../images/blue/ad.png\";s:7:\"imglink\";s:1:\"#\";s:5:\"width\";s:0:\"\";s:6:\"height\";s:0:\"\";s:11:\"pic_city_id\";i:0;}','a:3:{s:5:\"div_w\";s:0:\"\";s:5:\"div_h\";s:0:\"\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','0','0','0','0','0','default');
INSERT INTO `qb_label` VALUES ('166','','0','0','news_style_index1','rollpic','0','a:8:{s:13:\"tplpart_1code\";s:0:\"\";s:8:\"rolltype\";s:1:\"3\";s:5:\"width\";s:3:\"680\";s:6:\"height\";s:3:\"400\";s:6:\"picurl\";a:4:{i:0;s:35:\"rollpics/1_20170513080535_lh301.jpg\";i:1;s:35:\"rollpics/1_20170426090435_2djvz.jpg\";i:2;s:35:\"rollpics/1_20170426090452_ucyia.jpg\";i:3;s:35:\"rollpics/1_20170426090432_44xrf.png\";}s:7:\"piclink\";a:4:{i:0;s:25:\"bencandy.php?fid=9&id=582\";i:1;s:26:\"bencandy.php?fid=9&aid=469\";i:2;s:25:\"bencandy.php?fid=6&id=471\";i:3;s:27:\"bencandy.php?fid=13&aid=473\";}s:6:\"picalt\";a:4:{i:0;s:47:\"ռⳤƬ û÷\";i:1;s:47:\"ҹڶҺĸˮ ϯˮʽ´\";i:2;s:41:\"Ѷʼȫ沿¡ ͻ\";i:3;s:62:\"塷·ִ÷ɭĵ췴ĵӾ\";}s:11:\"pic_city_id\";i:0;}','a:3:{s:5:\"div_w\";s:2:\"50\";s:5:\"div_h\";s:2:\"21\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','1494636854','0','0','0','0','news_style');
INSERT INTO `qb_label` VALUES ('167','','0','0','news_style_index2','pic','0','a:5:{s:6:\"imgurl\";s:32:\"label/1_20170424110430_s0csd.png\";s:7:\"imglink\";s:38:\"http://www_qibosoft_com/list.php?fid=1\";s:5:\"width\";s:0:\"\";s:6:\"height\";s:0:\"\";s:11:\"pic_city_id\";i:0;}','a:3:{s:5:\"div_w\";s:2:\"50\";s:5:\"div_h\";s:2:\"21\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','1493004391','0','0','0','0','news');
INSERT INTO `qb_label` VALUES ('168','','0','0','news_style_index3','rollpic','0','a:8:{s:13:\"tplpart_1code\";s:0:\"\";s:8:\"rolltype\";s:1:\"1\";s:5:\"width\";s:3:\"320\";s:6:\"height\";s:3:\"200\";s:6:\"picurl\";a:3:{i:0;s:23:\"../images/rollpic/2.jpg\";i:1;s:35:\"rollpics/1_20170424100456_ht0o6.jpg\";i:2;s:35:\"rollpics/1_20170424100430_wtffg.jpg\";}s:7:\"piclink\";a:3:{i:0;s:26:\"/do/showsp.php?fid=1&id=27\";i:1;s:26:\"/do/showsp.php?fid=1&id=26\";i:2;s:26:\"/do/showsp.php?fid=1&id=28\";}s:6:\"picalt\";a:3:{i:0;s:32:\"in⣬ŵзʽ\";i:1;s:32:\"йý߷̳\";i:2;s:38:\"ҵķ˼ƽ̨ݳƷۻתӪ\";}s:11:\"pic_city_id\";i:0;}','a:3:{s:5:\"div_w\";s:2:\"50\";s:5:\"div_h\";s:2:\"21\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','1493174125','0','0','0','0','news_style');
INSERT INTO `qb_label` VALUES ('169','','0','0','news_style_index4','specialsort','1','a:36:{s:9:\"tplpart_1\";s:51:\"<div class=\'title\'><a HREF=\"$url\" >$title</a></div>\";s:13:\"tplpart_1code\";s:92:\"<div class=\'title\'><a HREF=\"$webdb[www_url]/do/showsp.php?fid=$fid&id=$id\" >$title</a></div>\";s:13:\"tplpart_2code\";s:0:\"\";s:3:\"SYS\";s:11:\"specialsort\";s:13:\"RollStyleType\";s:0:\"\";s:11:\"roll_height\";s:2:\"50\";s:3:\"url\";s:45:\"$webdb[www_url]/do/showsp.php?fid=$fid&id=$id\";s:5:\"width\";s:3:\"250\";s:6:\"height\";s:3:\"187\";s:8:\"rolltype\";s:10:\"scrollLeft\";s:8:\"rolltime\";s:1:\"3\";s:3:\"fid\";i:0;s:7:\"newhour\";s:2:\"24\";s:7:\"hothits\";s:3:\"100\";s:7:\"amodule\";N;s:7:\"tplpath\";s:24:\"/common_title/0title.jpg\";s:6:\"DivTpl\";i:1;s:5:\"fiddb\";N;s:5:\"stype\";s:1:\"t\";s:2:\"yz\";N;s:7:\"hidefid\";N;s:10:\"timeformat\";s:11:\"Y-m-d H:i:s\";s:5:\"order\";s:4:\"list\";s:3:\"asc\";s:4:\"DESC\";s:6:\"levels\";s:3:\"all\";s:7:\"rowspan\";s:1:\"5\";s:3:\"sql\";s:90:\" SELECT A.* FROM qb_special A  WHERE `ifbase`=0 AND yz=1   ORDER BY A.list DESC LIMIT 0,5 \";s:4:\"sql2\";s:0:\"\";s:7:\"colspan\";s:1:\"1\";s:11:\"content_num\";s:2:\"80\";s:12:\"content_num2\";s:3:\"120\";s:8:\"titlenum\";s:2:\"60\";s:9:\"titlenum2\";s:2:\"40\";s:10:\"titleflood\";s:1:\"0\";s:9:\"start_num\";s:1:\"1\";s:10:\"c_rolltype\";s:1:\"0\";}','a:3:{s:5:\"div_w\";s:2:\"50\";s:5:\"div_h\";s:2:\"30\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','1493000741','0','0','0','0','news');
INSERT INTO `qb_label` VALUES ('170','','0','0','news_style_index5','pic','0','a:5:{s:6:\"imgurl\";s:32:\"label/1_20170424110447_u0o4r.png\";s:7:\"imglink\";s:38:\"http://www_qibosoft_com/list.php?fid=1\";s:5:\"width\";s:0:\"\";s:6:\"height\";s:0:\"\";s:11:\"pic_city_id\";i:0;}','a:3:{s:5:\"div_w\";s:2:\"50\";s:5:\"div_h\";s:2:\"21\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','1493005428','0','0','0','0','news');
INSERT INTO `qb_label` VALUES ('171','','0','0','news_style_index6','article','1','a:34:{s:13:\"tplpart_1code\";s:133:\"<ul> \r\n<ol><a  href=\"$url\" target=\"_blank\"><img  src=\"$picurl\"/></a></ol>\r\n<li><a  href=\"$url\" target=\"_blank\">$title</a></li>\r\n</ul>\";s:13:\"tplpart_2code\";s:0:\"\";s:3:\"SYS\";s:7:\"artcile\";s:13:\"RollStyleType\";s:0:\"\";s:7:\"fidtype\";s:1:\"0\";s:8:\"rolltype\";s:10:\"scrollLeft\";s:8:\"rolltime\";s:1:\"3\";s:11:\"roll_height\";s:2:\"50\";s:5:\"width\";s:3:\"250\";s:6:\"height\";s:3:\"187\";s:7:\"newhour\";s:2:\"24\";s:7:\"hothits\";s:3:\"100\";s:7:\"amodule\";s:3:\"102\";s:7:\"tplpath\";s:24:\"/common_pic/img_div1.jpg\";s:6:\"DivTpl\";i:1;s:5:\"fiddb\";N;s:5:\"stype\";s:1:\"p\";s:2:\"yz\";s:1:\"1\";s:7:\"hidefid\";N;s:10:\"timeformat\";s:11:\"Y-m-d H:i:s\";s:5:\"order\";s:6:\"A.list\";s:3:\"asc\";s:4:\"DESC\";s:6:\"levels\";s:3:\"all\";s:7:\"rowspan\";s:1:\"4\";s:3:\"sql\";s:136:\" SELECT A.*,A.aid AS id FROM qb_article A  WHERE A.yz=1  AND A.mid=\'102\'  AND A.ispic=1   AND A.ispic=1  ORDER BY A.list DESC LIMIT 0,4 \";s:4:\"sql2\";N;s:7:\"colspan\";s:1:\"1\";s:11:\"content_num\";s:2:\"80\";s:12:\"content_num2\";s:3:\"120\";s:8:\"titlenum\";s:2:\"60\";s:9:\"titlenum2\";s:2:\"40\";s:10:\"titleflood\";s:1:\"0\";s:9:\"start_num\";s:1:\"1\";s:10:\"c_rolltype\";s:1:\"0\";}','a:3:{s:5:\"div_w\";s:2:\"50\";s:5:\"div_h\";s:2:\"30\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','1492766821','0','0','0','0','news');
INSERT INTO `qb_label` VALUES ('172','','0','0','news_style_index7','article','1','a:34:{s:13:\"tplpart_1code\";s:133:\"<ul> \r\n<ol><a  href=\"$url\" target=\"_blank\"><img  src=\"$picurl\"/></a></ol>\r\n<li><a  href=\"$url\" target=\"_blank\">$title</a></li>\r\n</ul>\";s:13:\"tplpart_2code\";s:0:\"\";s:3:\"SYS\";s:7:\"artcile\";s:13:\"RollStyleType\";s:0:\"\";s:7:\"fidtype\";s:1:\"0\";s:8:\"rolltype\";s:10:\"scrollLeft\";s:8:\"rolltime\";s:1:\"3\";s:11:\"roll_height\";s:2:\"50\";s:5:\"width\";s:3:\"250\";s:6:\"height\";s:3:\"187\";s:7:\"newhour\";s:2:\"24\";s:7:\"hothits\";s:3:\"100\";s:7:\"amodule\";s:3:\"100\";s:7:\"tplpath\";s:0:\"\";s:6:\"DivTpl\";i:1;s:5:\"fiddb\";N;s:5:\"stype\";s:1:\"p\";s:2:\"yz\";s:1:\"1\";s:7:\"hidefid\";N;s:10:\"timeformat\";s:11:\"Y-m-d H:i:s\";s:5:\"order\";s:6:\"A.list\";s:3:\"asc\";s:4:\"DESC\";s:6:\"levels\";s:3:\"all\";s:7:\"rowspan\";s:1:\"4\";s:3:\"sql\";s:136:\" SELECT A.*,A.aid AS id FROM qb_article A  WHERE A.yz=1  AND A.mid=\'100\'  AND A.ispic=1   AND A.ispic=1  ORDER BY A.list DESC LIMIT 0,4 \";s:4:\"sql2\";N;s:7:\"colspan\";s:1:\"1\";s:11:\"content_num\";s:2:\"80\";s:12:\"content_num2\";s:3:\"120\";s:8:\"titlenum\";s:2:\"60\";s:9:\"titlenum2\";s:2:\"40\";s:10:\"titleflood\";s:1:\"0\";s:9:\"start_num\";s:1:\"1\";s:10:\"c_rolltype\";s:1:\"0\";}','a:3:{s:5:\"div_w\";s:2:\"50\";s:5:\"div_h\";s:2:\"30\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','1492766778','0','0','0','0','news');
INSERT INTO `qb_label` VALUES ('173','','0','0','news_style_index8','article','1','a:34:{s:13:\"tplpart_1code\";s:133:\"<ul> \r\n<ol><a  href=\"$url\" target=\"_blank\"><img  src=\"$picurl\"/></a></ol>\r\n<li><a  href=\"$url\" target=\"_blank\">$title</a></li>\r\n</ul>\";s:13:\"tplpart_2code\";s:0:\"\";s:3:\"SYS\";s:7:\"artcile\";s:13:\"RollStyleType\";s:0:\"\";s:7:\"fidtype\";s:1:\"0\";s:8:\"rolltype\";s:10:\"scrollLeft\";s:8:\"rolltime\";s:1:\"3\";s:11:\"roll_height\";s:2:\"50\";s:5:\"width\";s:3:\"250\";s:6:\"height\";s:3:\"187\";s:7:\"newhour\";s:2:\"24\";s:7:\"hothits\";s:3:\"100\";s:7:\"amodule\";s:3:\"103\";s:7:\"tplpath\";s:0:\"\";s:6:\"DivTpl\";i:1;s:5:\"fiddb\";N;s:5:\"stype\";s:1:\"p\";s:2:\"yz\";s:1:\"1\";s:7:\"hidefid\";N;s:10:\"timeformat\";s:11:\"Y-m-d H:i:s\";s:5:\"order\";s:6:\"A.list\";s:3:\"asc\";s:4:\"DESC\";s:6:\"levels\";s:3:\"all\";s:7:\"rowspan\";s:1:\"4\";s:3:\"sql\";s:136:\" SELECT A.*,A.aid AS id FROM qb_article A  WHERE A.yz=1  AND A.mid=\'103\'  AND A.ispic=1   AND A.ispic=1  ORDER BY A.list DESC LIMIT 0,4 \";s:4:\"sql2\";N;s:7:\"colspan\";s:1:\"1\";s:11:\"content_num\";s:2:\"80\";s:12:\"content_num2\";s:3:\"120\";s:8:\"titlenum\";s:2:\"60\";s:9:\"titlenum2\";s:2:\"40\";s:10:\"titleflood\";s:1:\"0\";s:9:\"start_num\";s:1:\"1\";s:10:\"c_rolltype\";s:1:\"0\";}','a:3:{s:5:\"div_w\";s:2:\"50\";s:5:\"div_h\";s:2:\"30\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','1492766804','0','0','0','0','news');
INSERT INTO `qb_label` VALUES ('174','','0','0','news_style_indexh1','code','0','<span>»Ա</span>','a:4:{s:9:\"html_edit\";N;s:5:\"div_w\";s:0:\"\";s:5:\"div_h\";s:0:\"\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','0','0','0','0','0','news');
INSERT INTO `qb_label` VALUES ('175','','0','0','news_style_indexh1_2','code','0','<span><b>ר</b></span>','a:4:{s:9:\"html_edit\";N;s:5:\"div_w\";s:2:\"50\";s:5:\"div_h\";s:2:\"21\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','1493001150','0','0','0','0','news');
INSERT INTO `qb_label` VALUES ('176','','0','0','news_style_indexh2','code','0','<span>Ƶ</span><a href=\"list.php?fid=1\"></a>','a:4:{s:9:\"html_edit\";N;s:5:\"div_w\";s:0:\"\";s:5:\"div_h\";s:0:\"\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','0','0','0','0','0','news');
INSERT INTO `qb_label` VALUES ('177','','0','0','news_style_indexh3','code','0','<span>ͼƬ</span><a href=\"list.php?fid=2\"></a>','a:4:{s:9:\"html_edit\";N;s:5:\"div_w\";s:0:\"\";s:5:\"div_h\";s:0:\"\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','0','0','0','0','0','news');
INSERT INTO `qb_label` VALUES ('178','','0','0','news_style_indexh4','code','0','<span>ƼƷ</span><a href=\"list.php?fid=1\"></a>','a:4:{s:9:\"html_edit\";N;s:5:\"div_w\";s:0:\"\";s:5:\"div_h\";s:0:\"\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','0','0','0','0','0','news');
INSERT INTO `qb_label` VALUES ('179','','0','0','news_style_indexh5','code','0','<span></span>','a:4:{s:9:\"html_edit\";N;s:5:\"div_w\";s:0:\"\";s:5:\"div_h\";s:0:\"\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','0','0','0','0','0','news');
INSERT INTO `qb_form_config` VALUES ('module_id','30','');
INSERT INTO `qb_form_config` VALUES ('module_pre','form_','');
INSERT INTO `qb_form_config` VALUES ('Info_webOpen','1','');
INSERT INTO `qb_form_config` VALUES ('Info_webname','ܱ','');
INSERT INTO `qb_form_content` VALUES ('22','','7','0','1237208241','1237208241','1','admin','','0','192.168.0.99');
INSERT INTO `qb_form_content` VALUES ('26','','6','7','1237250809','1237250809','1','admin','','0','192.168.0.99');
INSERT INTO `qb_form_content` VALUES ('27','','3','1','1237260673','1237260673','1','admin','','1','192.168.0.99');
INSERT INTO `qb_form_content` VALUES ('30','','2','7','1237269830','1237269830','1','admin','','0','192.168.0.99');
INSERT INTO `qb_form_content` VALUES ('29','','2','2','1237268864','1237268864','1','admin','','0','192.168.0.99');
INSERT INTO `qb_form_content` VALUES ('25','','3','2','1237214289','1237214289','1','admin','','1','192.168.0.99');
INSERT INTO `qb_form_content` VALUES ('24','','6','3','1237213169','1237213169','1','admin','','0','192.168.0.99');
INSERT INTO `qb_form_content` VALUES ('31','','2','6','1239780761','1239780761','1','admin','','0','192.168.0.99');
INSERT INTO `qb_form_content` VALUES ('18','','3','0','1236936110','1236936110','1','admin','','0','192.168.0.99');
INSERT INTO `qb_form_content` VALUES ('19','','5','0','1236939584','1236939584','1','admin','','0','192.168.0.99');
INSERT INTO `qb_form_content` VALUES ('20','','6','0','1237174883','1237174883','1','admin','','0','192.168.0.99');
INSERT INTO `qb_form_content` VALUES ('23','','7','0','1237208253','1237208253','1','admin','','0','192.168.0.99');
INSERT INTO `qb_form_content_2` VALUES ('29','1','JAVAԱ','5','','','800Ԫ/','2','','');
INSERT INTO `qb_form_content_2` VALUES ('30','1','гܼ','2','Ʒ.','','8000Ԫ/','0','','');
INSERT INTO `qb_form_content_2` VALUES ('31','1','۾','8','ҹ˾ĲƷ.','','3000','0','ר','һ');
INSERT INTO `qb_form_content_3` VALUES ('18','1','ۺͷ','','222223','65223@qq.com','133444444443');
INSERT INTO `qb_form_content_3` VALUES ('25','1','ۺͷ','hhhhhhhhhhhhhhhhhh','222223','65223@qq.com','13377777777');
INSERT INTO `qb_form_content_3` VALUES ('27','1','ۺͷ','192.168.0.99/55 all righ\nts reserved \nICP05047353 \nPowered by PHP168','222223','65223@qq.com','13377777777');
INSERT INTO `qb_form_content_5` VALUES ('19','1','555555555555555','0000-00-00','ר','ʽ','','','','0','222223','444444','65223@qq.com','13355555555','3','һֱfgsgfd3','44444444444444443','');
INSERT INTO `qb_form_content_6` VALUES ('20','1','Ա','55555555555\nkkkkkkkkkkkkkkkkkkkkkk','5','222223','','56','','','','2','6767','','3','65223@qq.com','444444','');
INSERT INTO `qb_form_content_6` VALUES ('24','1','CԹʦ','4444444444444','4','222223','ר','4','','','','2','090-89766543','','3','65223@qq.com','444444','1');
INSERT INTO `qb_form_content_6` VALUES ('26','1','CԹʦ','rrrrrrrrrrrrrrrrrrrrrrrrrrr','4','222223','ר','4','','','','1','090-89766543','1000Ԫ-2000Ԫ','3','65223@qq.com','444444','1');
INSERT INTO `qb_form_content_7` VALUES ('6','1','վϵͳ(+)','6655','','ת','','','222223','444444','3333333','13333333333','3trewtre');
INSERT INTO `qb_form_content_7` VALUES ('7','1','վϵͳ(+)','23','2009-03-03','֧','fff','eee','222223','444444','333','13344444444','3');
INSERT INTO `qb_form_content_7` VALUES ('8','1','վϵͳ(+)','5','','֧','','','222223','444444','һֱfgsgfd3','13355555555','3');
INSERT INTO `qb_form_content_7` VALUES ('9','1','վϵͳ(+)','0.01','2009-03-13','֧','e','s','222223','444444','һֱfgsgfd3','13355555555','3');
INSERT INTO `qb_form_content_7` VALUES ('10','1','վϵͳ(+)','1','2009-03-13','֧','e','s','222223','444444','һֱfgsgfd3','13355555555','3');
INSERT INTO `qb_form_content_7` VALUES ('11','1','վϵͳ(+)','0.01','2009-03-13','olpay','e','s','222223','444444','һֱfgsgfd3','13355555555','3');
INSERT INTO `qb_form_content_7` VALUES ('12','1','վϵͳ(+)/Ϣϵͳ/̳ϵͳ','54','2009-03-03','ת','t','t','222223','444444','һֱfgsgfd3','13355555555','3');
INSERT INTO `qb_form_content_7` VALUES ('13','1','1/2/̳ϵͳ','4','','olpay','','','222223','444444','һֱfgsgfd3','13344444444','3');
INSERT INTO `qb_form_content_7` VALUES ('22','1','1','78','','olpay','','','222223','444444','һֱfgsgfd3','13377777777','3');
INSERT INTO `qb_form_content_7` VALUES ('23','1','1','78','','ת','','','222223','444444','һֱfgsgfd3','13377777777','3');
INSERT INTO `qb_form_module` VALUES ('1','','0','','a:3:{s:8:\"field_db\";a:8:{s:8:\"sortname\";a:14:{s:5:\"title\";s:18:\"ĸĿİ\";s:10:\"field_name\";s:8:\"sortname\";s:10:\"field_type\";s:7:\"varchar\";s:10:\"field_leng\";i:40;s:9:\"form_type\";s:8:\"checkbox\";s:15:\"field_inputleng\";s:0:\"\";s:8:\"form_set\";s:38:\"Ƶ\r\nƵ\r\nͼƬƵ\r\nƵƵ\";s:10:\"form_value\";s:0:\"\";s:10:\"form_units\";s:0:\"\";s:10:\"form_title\";s:0:\"\";s:8:\"mustfill\";s:1:\"1\";s:8:\"listshow\";s:1:\"0\";s:9:\"orderlist\";s:2:\"11\";s:9:\"allowview\";N;}s:7:\"webtime\";a:15:{s:5:\"title\";s:16:\"ÿСʱ\";s:10:\"field_name\";s:7:\"webtime\";s:10:\"field_type\";s:3:\"int\";s:10:\"field_leng\";i:10;s:9:\"form_type\";s:4:\"text\";s:15:\"field_inputleng\";s:1:\"4\";s:8:\"form_set\";s:0:\"\";s:10:\"form_value\";s:0:\"\";s:10:\"form_units\";s:4:\"Сʱ\";s:10:\"form_title\";s:0:\"\";s:8:\"mustfill\";s:1:\"0\";s:8:\"listshow\";s:1:\"0\";s:6:\"search\";s:1:\"0\";s:9:\"orderlist\";s:2:\"10\";s:9:\"allowview\";N;}s:8:\"truename\";a:15:{s:5:\"title\";s:8:\"ʵ\";s:10:\"field_name\";s:8:\"truename\";s:10:\"field_type\";s:7:\"varchar\";s:10:\"field_leng\";i:20;s:9:\"form_type\";s:4:\"text\";s:15:\"field_inputleng\";s:1:\"7\";s:8:\"form_set\";s:0:\"\";s:10:\"form_value\";s:0:\"\";s:10:\"form_units\";s:0:\"\";s:10:\"form_title\";s:0:\"\";s:8:\"mustfill\";s:1:\"1\";s:8:\"listshow\";s:1:\"1\";s:6:\"search\";s:1:\"0\";s:9:\"orderlist\";s:1:\"9\";s:9:\"allowview\";N;}s:3:\"sex\";a:15:{s:5:\"title\";s:4:\"Ա\";s:10:\"field_name\";s:3:\"sex\";s:10:\"field_type\";s:3:\"int\";s:10:\"field_leng\";i:1;s:9:\"form_type\";s:5:\"radio\";s:15:\"field_inputleng\";s:0:\"\";s:8:\"form_set\";s:18:\"1|\r\n2|Ů\r\n0|\";s:10:\"form_value\";s:0:\"\";s:10:\"form_units\";s:0:\"\";s:10:\"form_title\";s:0:\"\";s:8:\"mustfill\";s:1:\"1\";s:8:\"listshow\";s:1:\"1\";s:6:\"search\";s:1:\"0\";s:9:\"orderlist\";s:1:\"8\";s:9:\"allowview\";N;}s:4:\"oicq\";a:15:{s:5:\"title\";s:6:\"ϵQQ\";s:10:\"field_name\";s:4:\"oicq\";s:10:\"field_type\";s:7:\"varchar\";s:10:\"field_leng\";i:10;s:9:\"form_type\";s:4:\"text\";s:15:\"field_inputleng\";s:2:\"10\";s:8:\"form_set\";s:0:\"\";s:10:\"form_value\";s:0:\"\";s:10:\"form_units\";s:0:\"\";s:10:\"form_title\";s:0:\"\";s:8:\"mustfill\";s:1:\"1\";s:8:\"listshow\";s:1:\"0\";s:6:\"search\";s:1:\"0\";s:9:\"orderlist\";i:7;s:9:\"allowview\";N;}s:8:\"mobphone\";a:14:{s:5:\"title\";s:8:\"ֻ\";s:10:\"field_name\";s:8:\"mobphone\";s:10:\"field_type\";s:7:\"varchar\";s:10:\"field_leng\";i:11;s:9:\"form_type\";s:4:\"text\";s:15:\"field_inputleng\";s:2:\"11\";s:8:\"form_set\";s:0:\"\";s:10:\"form_value\";s:0:\"\";s:10:\"form_units\";s:0:\"\";s:10:\"form_title\";s:0:\"\";s:8:\"mustfill\";s:1:\"0\";s:6:\"search\";s:1:\"0\";s:9:\"orderlist\";i:6;s:9:\"allowview\";N;}s:8:\"interest\";a:14:{s:5:\"title\";s:8:\"Ȥ\";s:10:\"field_name\";s:8:\"interest\";s:10:\"field_type\";s:10:\"mediumtext\";s:10:\"field_leng\";i:0;s:9:\"form_type\";s:8:\"textarea\";s:15:\"field_inputleng\";s:0:\"\";s:8:\"form_set\";s:0:\"\";s:10:\"form_value\";s:0:\"\";s:10:\"form_units\";s:0:\"\";s:10:\"form_title\";s:0:\"\";s:8:\"mustfill\";s:1:\"0\";s:6:\"search\";s:1:\"0\";s:9:\"orderlist\";i:5;s:9:\"allowview\";N;}s:9:\"introduce\";a:14:{s:5:\"title\";s:8:\"ҽ\";s:10:\"field_name\";s:9:\"introduce\";s:10:\"field_type\";s:10:\"mediumtext\";s:10:\"field_leng\";i:0;s:9:\"form_type\";s:8:\"textarea\";s:15:\"field_inputleng\";s:0:\"\";s:8:\"form_set\";s:0:\"\";s:10:\"form_value\";s:0:\"\";s:10:\"form_units\";s:0:\"\";s:10:\"form_title\";s:0:\"\";s:8:\"mustfill\";s:1:\"0\";s:6:\"search\";s:1:\"0\";s:9:\"orderlist\";i:4;s:9:\"allowview\";N;}}s:7:\"is_html\";a:1:{s:7:\"content\";s:4:\"\";}s:11:\"listshow_db\";a:2:{s:8:\"truename\";s:8:\"ʵ\";s:3:\"sex\";s:4:\"Ա\";}}','3,4,8,9','0','<p><strong>м,,ǵİ!</strong></p>','0','0','','','0','','');
INSERT INTO `qb_form_module` VALUES ('2','Ƹ','0','','a:3:{s:8:\"field_db\";a:8:{s:9:\"workplace\";a:15:{s:5:\"title\";s:8:\"ְλ\";s:10:\"field_name\";s:9:\"workplace\";s:10:\"field_type\";s:7:\"varchar\";s:10:\"field_leng\";i:100;s:9:\"form_type\";s:4:\"text\";s:15:\"field_inputleng\";s:2:\"30\";s:8:\"form_set\";s:0:\"\";s:10:\"form_value\";s:0:\"\";s:10:\"form_units\";s:0:\"\";s:10:\"form_title\";s:0:\"\";s:8:\"mustfill\";s:1:\"0\";s:8:\"listshow\";s:1:\"1\";s:6:\"search\";s:1:\"0\";s:9:\"orderlist\";s:2:\"10\";s:9:\"allowview\";N;}s:4:\"nums\";a:15:{s:5:\"title\";s:8:\"Ƹ\";s:10:\"field_name\";s:4:\"nums\";s:10:\"field_type\";s:7:\"varchar\";s:10:\"field_leng\";i:10;s:9:\"form_type\";s:4:\"text\";s:15:\"field_inputleng\";s:1:\"4\";s:8:\"form_set\";s:0:\"\";s:10:\"form_value\";s:0:\"\";s:10:\"form_units\";s:2:\"\";s:10:\"form_title\";s:0:\"\";s:8:\"mustfill\";s:1:\"0\";s:8:\"listshow\";s:1:\"1\";s:6:\"search\";s:1:\"0\";s:9:\"orderlist\";s:1:\"9\";s:9:\"allowview\";N;}s:10:\"jobrequire\";a:15:{s:5:\"title\";s:14:\"ְλҪ\";s:10:\"field_name\";s:10:\"jobrequire\";s:10:\"field_type\";s:10:\"mediumtext\";s:10:\"field_leng\";i:0;s:9:\"form_type\";s:8:\"textarea\";s:15:\"field_inputleng\";s:0:\"\";s:8:\"form_set\";s:0:\"\";s:10:\"form_value\";s:0:\"\";s:10:\"form_units\";s:0:\"\";s:10:\"form_title\";s:0:\"\";s:8:\"mustfill\";s:1:\"0\";s:8:\"listshow\";s:1:\"0\";s:6:\"search\";s:1:\"0\";s:9:\"orderlist\";i:8;s:9:\"allowview\";N;}s:8:\"wageyear\";a:15:{s:5:\"title\";s:12:\"Ҫ\";s:10:\"field_name\";s:8:\"wageyear\";s:10:\"field_type\";s:7:\"varchar\";s:10:\"field_leng\";i:12;s:9:\"form_type\";s:5:\"radio\";s:15:\"field_inputleng\";s:0:\"\";s:8:\"form_set\";s:40:\"Ӧҵ\r\nһ\r\n\r\n\";s:10:\"form_value\";s:0:\"\";s:10:\"form_units\";s:0:\"\";s:10:\"form_title\";s:0:\"\";s:8:\"mustfill\";s:1:\"1\";s:8:\"listshow\";s:1:\"1\";s:6:\"search\";s:1:\"0\";s:9:\"orderlist\";i:7;s:9:\"allowview\";N;}s:9:\"workwhere\";a:15:{s:5:\"title\";s:8:\"ص\";s:10:\"field_name\";s:9:\"workwhere\";s:10:\"field_type\";s:7:\"varchar\";s:10:\"field_leng\";i:50;s:9:\"form_type\";s:4:\"text\";s:15:\"field_inputleng\";s:0:\"\";s:8:\"form_set\";s:0:\"\";s:10:\"form_value\";s:0:\"\";s:10:\"form_units\";s:0:\"\";s:10:\"form_title\";s:0:\"\";s:8:\"mustfill\";s:1:\"0\";s:8:\"listshow\";s:1:\"0\";s:6:\"search\";s:1:\"0\";s:9:\"orderlist\";i:6;s:9:\"allowview\";N;}s:4:\"wage\";a:15:{s:5:\"title\";s:8:\"нˮ\";s:10:\"field_name\";s:4:\"wage\";s:10:\"field_type\";s:7:\"varchar\";s:10:\"field_leng\";i:30;s:9:\"form_type\";s:4:\"text\";s:15:\"field_inputleng\";s:0:\"\";s:8:\"form_set\";s:0:\"\";s:10:\"form_value\";s:0:\"\";s:10:\"form_units\";s:0:\"\";s:10:\"form_title\";s:0:\"\";s:8:\"mustfill\";s:1:\"0\";s:8:\"listshow\";s:1:\"0\";s:6:\"search\";s:1:\"0\";s:9:\"orderlist\";i:5;s:9:\"allowview\";N;}s:6:\"asksex\";a:15:{s:5:\"title\";s:8:\"ԱҪ\";s:10:\"field_name\";s:6:\"asksex\";s:10:\"field_type\";s:3:\"int\";s:10:\"field_leng\";i:1;s:9:\"form_type\";s:5:\"radio\";s:15:\"field_inputleng\";s:1:\"1\";s:8:\"form_set\";s:18:\"1|\r\n2|Ů\r\n0|\";s:10:\"form_value\";s:1:\"0\";s:10:\"form_units\";s:0:\"\";s:10:\"form_title\";s:0:\"\";s:8:\"mustfill\";s:1:\"0\";s:8:\"listshow\";s:1:\"1\";s:6:\"search\";s:1:\"0\";s:9:\"orderlist\";s:1:\"4\";s:9:\"allowview\";N;}s:9:\"schoo_age\";a:15:{s:5:\"title\";s:8:\"ѧҪ\";s:10:\"field_name\";s:9:\"schoo_age\";s:10:\"field_type\";s:7:\"varchar\";s:10:\"field_leng\";i:20;s:9:\"form_type\";s:6:\"select\";s:15:\"field_inputleng\";s:0:\"\";s:8:\"form_set\";s:46:\"Сѧ\r\nѧ\r\nר\r\n\r\nר\r\n\r\n˶ʿ\r\nʿ\";s:10:\"form_value\";s:0:\"\";s:10:\"form_units\";s:4:\"\";s:10:\"form_title\";s:0:\"\";s:8:\"mustfill\";s:1:\"0\";s:8:\"listshow\";s:1:\"1\";s:6:\"search\";s:1:\"0\";s:9:\"orderlist\";s:1:\"3\";s:9:\"allowview\";N;}}s:7:\"is_html\";a:1:{s:7:\"content\";s:4:\"\";}s:11:\"listshow_db\";a:5:{s:8:\"wageyear\";s:12:\"Ҫ\";s:9:\"workplace\";s:8:\"ְλ\";s:4:\"nums\";s:8:\"Ƹ\";s:6:\"asksex\";s:8:\"ԱҪ\";s:9:\"schoo_age\";s:8:\"ѧҪ\";}}','','0','','0','1','','','0','','');
INSERT INTO `qb_form_module` VALUES ('3','Ͷ߽','0','','a:3:{s:8:\"field_db\";a:5:{s:10:\"advicetype\";a:15:{s:5:\"title\";s:8:\"Ͷ\";s:10:\"field_name\";s:10:\"advicetype\";s:10:\"field_type\";s:7:\"varchar\";s:10:\"field_leng\";i:30;s:9:\"form_type\";s:5:\"radio\";s:15:\"field_inputleng\";s:0:\"\";s:8:\"form_set\";s:34:\"ǰͷ\r\nۺͷ\r\nƷ\r\n\";s:10:\"form_value\";s:0:\"\";s:10:\"form_units\";s:0:\"\";s:10:\"form_title\";s:0:\"\";s:8:\"mustfill\";s:1:\"1\";s:8:\"listshow\";s:1:\"1\";s:6:\"search\";s:1:\"0\";s:9:\"orderlist\";s:2:\"10\";s:9:\"allowview\";N;}s:8:\"mobphone\";a:15:{s:5:\"title\";s:8:\"ĵ绰\";s:10:\"field_name\";s:8:\"mobphone\";s:10:\"field_type\";s:7:\"varchar\";s:10:\"field_leng\";i:25;s:9:\"form_type\";s:4:\"text\";s:15:\"field_inputleng\";s:2:\"15\";s:8:\"form_set\";s:0:\"\";s:10:\"form_value\";s:0:\"\";s:10:\"form_units\";s:0:\"\";s:10:\"form_title\";s:0:\"\";s:8:\"mustfill\";s:1:\"0\";s:8:\"listshow\";s:1:\"0\";s:6:\"search\";s:1:\"0\";s:9:\"orderlist\";s:1:\"8\";s:9:\"allowview\";N;}s:5:\"email\";a:14:{s:5:\"title\";s:8:\"\";s:10:\"field_name\";s:5:\"email\";s:10:\"field_type\";s:7:\"varchar\";s:10:\"field_leng\";i:50;s:9:\"form_type\";s:4:\"text\";s:15:\"field_inputleng\";s:2:\"15\";s:8:\"form_set\";s:0:\"\";s:10:\"form_value\";s:0:\"\";s:10:\"form_units\";s:0:\"\";s:10:\"form_title\";s:0:\"\";s:8:\"mustfill\";s:1:\"0\";s:6:\"search\";s:1:\"0\";s:9:\"orderlist\";i:7;s:9:\"allowview\";N;}s:7:\"content\";a:15:{s:5:\"title\";s:8:\"Ͷ\";s:10:\"field_name\";s:7:\"content\";s:10:\"field_type\";s:10:\"mediumtext\";s:10:\"field_leng\";i:0;s:9:\"form_type\";s:8:\"textarea\";s:15:\"field_inputleng\";s:0:\"\";s:8:\"form_set\";s:0:\"\";s:10:\"form_value\";s:0:\"\";s:10:\"form_units\";s:0:\"\";s:10:\"form_title\";s:0:\"\";s:8:\"mustfill\";s:1:\"1\";s:8:\"listshow\";s:1:\"0\";s:6:\"search\";s:1:\"0\";s:9:\"orderlist\";s:1:\"6\";s:9:\"allowview\";N;}s:8:\"truename\";a:15:{s:5:\"title\";s:8:\"ĳƺ\";s:10:\"field_name\";s:8:\"truename\";s:10:\"field_type\";s:7:\"varchar\";s:10:\"field_leng\";i:15;s:9:\"form_type\";s:4:\"text\";s:15:\"field_inputleng\";s:2:\"10\";s:8:\"form_set\";s:0:\"\";s:10:\"form_value\";s:0:\"\";s:10:\"form_units\";s:0:\"\";s:10:\"form_title\";s:0:\"\";s:8:\"mustfill\";s:1:\"1\";s:8:\"listshow\";s:1:\"1\";s:6:\"search\";s:1:\"0\";s:9:\"orderlist\";s:1:\"8\";s:9:\"allowview\";N;}}s:7:\"is_html\";a:0:{}s:11:\"listshow_db\";a:2:{s:10:\"advicetype\";s:8:\"Ͷ\";s:8:\"truename\";s:8:\"ĳƺ\";}}','','0','','0','1','','3,4','0','','');
INSERT INTO `qb_form_module` VALUES ('4','','0','','a:3:{s:8:\"field_db\";a:6:{s:8:\"truename\";a:15:{s:5:\"title\";s:4:\"\";s:10:\"field_name\";s:8:\"truename\";s:10:\"field_type\";s:7:\"varchar\";s:10:\"field_leng\";i:15;s:9:\"form_type\";s:4:\"text\";s:15:\"field_inputleng\";s:2:\"10\";s:8:\"form_set\";s:0:\"\";s:10:\"form_value\";s:0:\"\";s:10:\"form_units\";s:0:\"\";s:10:\"form_title\";s:0:\"\";s:8:\"mustfill\";s:1:\"1\";s:8:\"listshow\";s:1:\"1\";s:6:\"search\";s:1:\"0\";s:9:\"orderlist\";i:10;s:9:\"allowview\";N;}s:3:\"sex\";a:14:{s:5:\"title\";s:4:\"Ա\";s:10:\"field_name\";s:3:\"sex\";s:10:\"field_type\";s:3:\"int\";s:10:\"field_leng\";i:1;s:9:\"form_type\";s:5:\"radio\";s:15:\"field_inputleng\";s:0:\"\";s:8:\"form_set\";s:18:\"1|\r\n2|Ů\r\n0|\";s:10:\"form_value\";s:0:\"\";s:10:\"form_units\";s:0:\"\";s:10:\"form_title\";s:0:\"\";s:8:\"mustfill\";s:1:\"0\";s:6:\"search\";s:1:\"0\";s:9:\"orderlist\";i:9;s:9:\"allowview\";N;}s:3:\"age\";a:15:{s:5:\"title\";s:4:\"\";s:10:\"field_name\";s:3:\"age\";s:10:\"field_type\";s:3:\"int\";s:10:\"field_leng\";i:2;s:9:\"form_type\";s:4:\"text\";s:15:\"field_inputleng\";s:1:\"2\";s:8:\"form_set\";s:0:\"\";s:10:\"form_value\";s:0:\"\";s:10:\"form_units\";s:2:\"\";s:10:\"form_title\";s:0:\"\";s:8:\"mustfill\";s:1:\"1\";s:8:\"listshow\";s:1:\"1\";s:6:\"search\";s:1:\"0\";s:9:\"orderlist\";i:8;s:9:\"allowview\";N;}s:8:\"mobphone\";a:14:{s:5:\"title\";s:8:\"ϵ绰\";s:10:\"field_name\";s:8:\"mobphone\";s:10:\"field_type\";s:7:\"varchar\";s:10:\"field_leng\";i:25;s:9:\"form_type\";s:4:\"text\";s:15:\"field_inputleng\";s:2:\"12\";s:8:\"form_set\";s:0:\"\";s:10:\"form_value\";s:0:\"\";s:10:\"form_units\";s:0:\"\";s:10:\"form_title\";s:0:\"\";s:8:\"mustfill\";s:1:\"0\";s:6:\"search\";s:1:\"0\";s:9:\"orderlist\";i:7;s:9:\"allowview\";N;}s:7:\"my_song\";a:15:{s:5:\"title\";s:8:\"\";s:10:\"field_name\";s:7:\"my_song\";s:10:\"field_type\";s:7:\"varchar\";s:10:\"field_leng\";i:50;s:9:\"form_type\";s:4:\"text\";s:15:\"field_inputleng\";s:2:\"30\";s:8:\"form_set\";s:0:\"\";s:10:\"form_value\";s:0:\"\";s:10:\"form_units\";s:0:\"\";s:10:\"form_title\";s:0:\"\";s:8:\"mustfill\";s:1:\"1\";s:8:\"listshow\";s:1:\"1\";s:6:\"search\";s:1:\"0\";s:9:\"orderlist\";i:6;s:9:\"allowview\";N;}s:6:\"metier\";a:15:{s:5:\"title\";s:4:\"ְҵ\";s:10:\"field_name\";s:6:\"metier\";s:10:\"field_type\";s:7:\"varchar\";s:10:\"field_leng\";i:30;s:9:\"form_type\";s:6:\"select\";s:15:\"field_inputleng\";s:0:\"\";s:8:\"form_set\";s:32:\"Ա\r\n\r\nԱ\r\nʦ\r\n\";s:10:\"form_value\";s:0:\"\";s:10:\"form_units\";s:0:\"\";s:10:\"form_title\";s:0:\"\";s:8:\"mustfill\";s:1:\"0\";s:8:\"listshow\";s:1:\"1\";s:6:\"search\";s:1:\"0\";s:9:\"orderlist\";i:5;s:9:\"allowview\";N;}}s:7:\"is_html\";a:2:{s:7:\"content\";s:4:\"\";s:5:\"my_88\";s:13:\"ҵֶmy_88\";}s:11:\"listshow_db\";a:4:{s:8:\"truename\";s:4:\"\";s:3:\"age\";s:4:\"\";s:6:\"metier\";s:4:\"ְҵ\";s:7:\"my_song\";s:8:\"\";}}','','0','<p>&nbsp;&nbsp; ΪлԱԱվ֧֣صؾеһ質ӭӻԾμӡ£</p>\r\n<p><strong>ʱ䣺</strong>Ӽ𡪡94800ֹ</p>\r\n<p><strong>Ŀʱ䣺</strong>95ţһ8301100</p>\r\n<p><strong>Ҫ</strong>עԱ豸˵ڱ̳עֵ½.</p>\r\n<p><strong>Ŀ</strong>ѡ峪 ɴݳ</p>\r\n<p><strong>ί</strong>˳Ƽ˳ټίе    ߻ϼԱ</p>\r\n<p><strong>ѡʽ</strong>ڱлԱڴͶƱÿͶ2ƱͶƱʱ6죬ȴ951101911800ֹίͳƱѡƱǰ</p>\r\n<p><strong></strong>ڻǰĸ֣費̶ͬȵͻֽ</p>\r\n<p>ڱʱҪ󣬽ݴұ˳򣬺ʱ䣬Ϊݳ˳򣬽941000ǰڸͷ֪ͨʽμӴ˴αѡݳ˳</p>\r\n<p><strong>֣</strong> α</p>','0','1','','','0','','');
INSERT INTO `qb_form_module` VALUES ('5','ԱϵǼǱ','0','','a:3:{s:8:\"field_db\";a:16:{s:8:\"cp_title\";a:15:{s:5:\"title\";s:8:\"˾ְλ\";s:10:\"field_name\";s:8:\"cp_title\";s:10:\"field_type\";s:7:\"varchar\";s:10:\"field_leng\";i:50;s:9:\"form_type\";s:4:\"text\";s:15:\"field_inputleng\";s:2:\"15\";s:8:\"form_set\";s:0:\"\";s:10:\"form_value\";s:0:\"\";s:10:\"form_units\";s:0:\"\";s:10:\"form_title\";s:0:\"\";s:8:\"mustfill\";s:1:\"0\";s:8:\"listshow\";s:1:\"0\";s:6:\"search\";s:1:\"0\";s:9:\"orderlist\";i:20;s:9:\"allowview\";N;}s:8:\"truename\";a:15:{s:5:\"title\";s:4:\"\";s:10:\"field_name\";s:8:\"truename\";s:10:\"field_type\";s:7:\"varchar\";s:10:\"field_leng\";i:15;s:9:\"form_type\";s:4:\"text\";s:15:\"field_inputleng\";s:2:\"10\";s:8:\"form_set\";s:0:\"\";s:10:\"form_value\";s:0:\"\";s:10:\"form_units\";s:0:\"\";s:10:\"form_title\";s:0:\"\";s:8:\"mustfill\";s:1:\"1\";s:8:\"listshow\";s:1:\"1\";s:6:\"search\";s:1:\"0\";s:9:\"orderlist\";i:19;s:9:\"allowview\";N;}s:4:\"bday\";a:14:{s:5:\"title\";s:8:\"\";s:10:\"field_name\";s:4:\"bday\";s:10:\"field_type\";s:7:\"varchar\";s:10:\"field_leng\";i:25;s:9:\"form_type\";s:4:\"time\";s:15:\"field_inputleng\";s:0:\"\";s:8:\"form_set\";s:0:\"\";s:10:\"form_value\";s:0:\"\";s:10:\"form_units\";s:0:\"\";s:10:\"form_title\";s:0:\"\";s:8:\"mustfill\";s:1:\"0\";s:6:\"search\";s:1:\"0\";s:9:\"orderlist\";i:18;s:9:\"allowview\";N;}s:6:\"height\";a:15:{s:5:\"title\";s:4:\"\";s:10:\"field_name\";s:6:\"height\";s:10:\"field_type\";s:3:\"int\";s:10:\"field_leng\";i:3;s:9:\"form_type\";s:4:\"text\";s:15:\"field_inputleng\";s:1:\"3\";s:8:\"form_set\";s:0:\"\";s:10:\"form_value\";s:0:\"\";s:10:\"form_units\";s:2:\"CM\";s:10:\"form_title\";s:0:\"\";s:8:\"mustfill\";s:1:\"0\";s:8:\"listshow\";s:1:\"0\";s:6:\"search\";s:1:\"0\";s:9:\"orderlist\";i:17;s:9:\"allowview\";N;}s:6:\"native\";a:15:{s:5:\"title\";s:4:\"\";s:10:\"field_name\";s:6:\"native\";s:10:\"field_type\";s:7:\"varchar\";s:10:\"field_leng\";i:30;s:9:\"form_type\";s:4:\"text\";s:15:\"field_inputleng\";s:0:\"\";s:8:\"form_set\";s:0:\"\";s:10:\"form_value\";s:0:\"\";s:10:\"form_units\";s:0:\"\";s:10:\"form_title\";s:0:\"\";s:8:\"mustfill\";s:1:\"1\";s:8:\"listshow\";s:1:\"1\";s:6:\"search\";s:1:\"0\";s:9:\"orderlist\";i:16;s:9:\"allowview\";N;}s:10:\"school_age\";a:14:{s:5:\"title\";s:4:\"ѧ\";s:10:\"field_name\";s:10:\"school_age\";s:10:\"field_type\";s:7:\"varchar\";s:10:\"field_leng\";i:20;s:9:\"form_type\";s:6:\"select\";s:15:\"field_inputleng\";s:0:\"\";s:8:\"form_set\";s:45:\"\r\nר\r\n\r\nר\r\n\r\n˶ʿ\r\nʿ\r\nMBA\";s:10:\"form_value\";s:4:\"ר\";s:10:\"form_units\";s:0:\"\";s:10:\"form_title\";s:0:\"\";s:8:\"mustfill\";s:1:\"0\";s:6:\"search\";s:1:\"0\";s:9:\"orderlist\";i:15;s:9:\"allowview\";N;}s:9:\"specialty\";a:15:{s:5:\"title\";s:4:\"רҵ\";s:10:\"field_name\";s:9:\"specialty\";s:10:\"field_type\";s:7:\"varchar\";s:10:\"field_leng\";i:40;s:9:\"form_type\";s:4:\"text\";s:15:\"field_inputleng\";s:2:\"20\";s:8:\"form_set\";s:0:\"\";s:10:\"form_value\";s:0:\"\";s:10:\"form_units\";s:0:\"\";s:10:\"form_title\";s:0:\"\";s:8:\"mustfill\";s:1:\"0\";s:8:\"listshow\";s:1:\"0\";s:6:\"search\";s:1:\"0\";s:9:\"orderlist\";i:14;s:9:\"allowview\";N;}s:4:\"oicq\";a:15:{s:5:\"title\";s:6:\"QQ\";s:10:\"field_name\";s:4:\"oicq\";s:10:\"field_type\";s:7:\"varchar\";s:10:\"field_leng\";i:10;s:9:\"form_type\";s:4:\"text\";s:15:\"field_inputleng\";s:2:\"10\";s:8:\"form_set\";s:0:\"\";s:10:\"form_value\";s:0:\"\";s:10:\"form_units\";s:0:\"\";s:10:\"form_title\";s:0:\"\";s:8:\"mustfill\";s:1:\"0\";s:8:\"listshow\";s:1:\"0\";s:6:\"search\";s:1:\"0\";s:9:\"orderlist\";i:13;s:9:\"allowview\";N;}s:5:\"email\";a:15:{s:5:\"title\";s:4:\"\";s:10:\"field_name\";s:5:\"email\";s:10:\"field_type\";s:7:\"varchar\";s:10:\"field_leng\";i:50;s:9:\"form_type\";s:4:\"text\";s:15:\"field_inputleng\";s:2:\"15\";s:8:\"form_set\";s:0:\"\";s:10:\"form_value\";s:0:\"\";s:10:\"form_units\";s:0:\"\";s:10:\"form_title\";s:0:\"\";s:8:\"mustfill\";s:1:\"0\";s:8:\"listshow\";s:1:\"0\";s:6:\"search\";s:1:\"0\";s:9:\"orderlist\";i:12;s:9:\"allowview\";N;}s:8:\"mobphone\";a:15:{s:5:\"title\";s:8:\"ֻ\";s:10:\"field_name\";s:8:\"mobphone\";s:10:\"field_type\";s:7:\"varchar\";s:10:\"field_leng\";i:11;s:9:\"form_type\";s:4:\"text\";s:15:\"field_inputleng\";s:2:\"11\";s:8:\"form_set\";s:0:\"\";s:10:\"form_value\";s:0:\"\";s:10:\"form_units\";s:0:\"\";s:10:\"form_title\";s:0:\"\";s:8:\"mustfill\";s:1:\"1\";s:8:\"listshow\";s:1:\"0\";s:6:\"search\";s:1:\"0\";s:9:\"orderlist\";i:11;s:9:\"allowview\";N;}s:5:\"skill\";a:15:{s:5:\"title\";s:4:\"س\";s:10:\"field_name\";s:5:\"skill\";s:10:\"field_type\";s:7:\"varchar\";s:10:\"field_leng\";i:50;s:9:\"form_type\";s:4:\"text\";s:15:\"field_inputleng\";s:2:\"20\";s:8:\"form_set\";s:0:\"\";s:10:\"form_value\";s:0:\"\";s:10:\"form_units\";s:0:\"\";s:10:\"form_title\";s:0:\"\";s:8:\"mustfill\";s:1:\"0\";s:8:\"listshow\";s:1:\"0\";s:6:\"search\";s:1:\"0\";s:9:\"orderlist\";i:10;s:9:\"allowview\";N;}s:6:\"idcard\";a:15:{s:5:\"title\";s:10:\"֤\";s:10:\"field_name\";s:6:\"idcard\";s:10:\"field_type\";s:7:\"varchar\";s:10:\"field_leng\";i:18;s:9:\"form_type\";s:4:\"text\";s:15:\"field_inputleng\";s:2:\"18\";s:8:\"form_set\";s:0:\"\";s:10:\"form_value\";s:0:\"\";s:10:\"form_units\";s:0:\"\";s:10:\"form_title\";s:0:\"\";s:8:\"mustfill\";s:1:\"0\";s:8:\"listshow\";s:1:\"0\";s:6:\"search\";s:1:\"0\";s:9:\"orderlist\";i:9;s:9:\"allowview\";N;}s:5:\"sport\";a:15:{s:5:\"title\";s:8:\"\";s:10:\"field_name\";s:5:\"sport\";s:10:\"field_type\";s:7:\"varchar\";s:10:\"field_leng\";i:80;s:9:\"form_type\";s:4:\"text\";s:15:\"field_inputleng\";s:2:\"20\";s:8:\"form_set\";s:0:\"\";s:10:\"form_value\";s:0:\"\";s:10:\"form_units\";s:0:\"\";s:10:\"form_title\";s:0:\"\";s:8:\"mustfill\";s:1:\"0\";s:8:\"listshow\";s:1:\"0\";s:6:\"search\";s:1:\"0\";s:9:\"orderlist\";i:8;s:9:\"allowview\";N;}s:9:\"telephone\";a:15:{s:5:\"title\";s:8:\"ͥ绰\";s:10:\"field_name\";s:9:\"telephone\";s:10:\"field_type\";s:7:\"varchar\";s:10:\"field_leng\";i:15;s:9:\"form_type\";s:4:\"text\";s:15:\"field_inputleng\";s:2:\"12\";s:8:\"form_set\";s:0:\"\";s:10:\"form_value\";s:0:\"\";s:10:\"form_units\";s:0:\"\";s:10:\"form_title\";s:0:\"\";s:8:\"mustfill\";s:1:\"0\";s:8:\"listshow\";s:1:\"0\";s:6:\"search\";s:1:\"0\";s:9:\"orderlist\";i:7;s:9:\"allowview\";N;}s:7:\"address\";a:15:{s:5:\"title\";s:8:\"ַͥ\";s:10:\"field_name\";s:7:\"address\";s:10:\"field_type\";s:7:\"varchar\";s:10:\"field_leng\";i:150;s:9:\"form_type\";s:4:\"text\";s:15:\"field_inputleng\";s:2:\"30\";s:8:\"form_set\";s:0:\"\";s:10:\"form_value\";s:0:\"\";s:10:\"form_units\";s:0:\"\";s:10:\"form_title\";s:0:\"\";s:8:\"mustfill\";s:1:\"0\";s:8:\"listshow\";s:1:\"0\";s:6:\"search\";s:1:\"0\";s:9:\"orderlist\";i:6;s:9:\"allowview\";N;}s:7:\"content\";a:15:{s:5:\"title\";s:8:\"\";s:10:\"field_name\";s:7:\"content\";s:10:\"field_type\";s:10:\"mediumtext\";s:10:\"field_leng\";i:0;s:9:\"form_type\";s:8:\"textarea\";s:15:\"field_inputleng\";s:0:\"\";s:8:\"form_set\";s:0:\"\";s:10:\"form_value\";s:0:\"\";s:10:\"form_units\";s:0:\"\";s:10:\"form_title\";s:0:\"\";s:8:\"mustfill\";s:1:\"1\";s:8:\"listshow\";s:1:\"0\";s:6:\"search\";s:1:\"0\";s:9:\"orderlist\";i:5;s:9:\"allowview\";N;}}s:7:\"is_html\";a:0:{}s:11:\"listshow_db\";a:2:{s:6:\"native\";s:4:\"\";s:8:\"truename\";s:4:\"\";}}','','0','','0','0','','','0','','');
INSERT INTO `qb_form_module` VALUES ('6','ְ','0','','a:3:{s:8:\"field_db\";a:16:{s:12:\"workposition\";a:15:{s:5:\"title\";s:8:\"ְλ\";s:10:\"field_name\";s:12:\"workposition\";s:10:\"field_type\";s:7:\"varchar\";s:10:\"field_leng\";i:50;s:9:\"form_type\";s:4:\"text\";s:15:\"field_inputleng\";s:2:\"30\";s:8:\"form_set\";s:0:\"\";s:10:\"form_value\";s:0:\"\";s:10:\"form_units\";s:0:\"\";s:10:\"form_title\";s:0:\"\";s:8:\"mustfill\";s:1:\"1\";s:8:\"listshow\";s:1:\"1\";s:6:\"search\";s:1:\"0\";s:9:\"orderlist\";s:2:\"21\";s:9:\"allowview\";N;}s:8:\"truename\";a:15:{s:5:\"title\";s:4:\"\";s:10:\"field_name\";s:8:\"truename\";s:10:\"field_type\";s:7:\"varchar\";s:10:\"field_leng\";i:15;s:9:\"form_type\";s:4:\"text\";s:15:\"field_inputleng\";s:2:\"10\";s:8:\"form_set\";s:0:\"\";s:10:\"form_value\";s:0:\"\";s:10:\"form_units\";s:0:\"\";s:10:\"form_title\";s:0:\"\";s:8:\"mustfill\";s:1:\"1\";s:8:\"listshow\";s:1:\"1\";s:6:\"search\";s:1:\"0\";s:9:\"orderlist\";i:20;s:9:\"allowview\";N;}s:3:\"sex\";a:15:{s:5:\"title\";s:4:\"Ա\";s:10:\"field_name\";s:3:\"sex\";s:10:\"field_type\";s:3:\"int\";s:10:\"field_leng\";i:1;s:9:\"form_type\";s:5:\"radio\";s:15:\"field_inputleng\";s:0:\"\";s:8:\"form_set\";s:18:\"1|\r\n2|Ů\r\n0|\";s:10:\"form_value\";s:0:\"\";s:10:\"form_units\";s:0:\"\";s:10:\"form_title\";s:0:\"\";s:8:\"mustfill\";s:1:\"1\";s:8:\"listshow\";s:1:\"1\";s:6:\"search\";s:1:\"0\";s:9:\"orderlist\";i:19;s:9:\"allowview\";N;}s:5:\"myage\";a:15:{s:5:\"title\";s:4:\"\";s:10:\"field_name\";s:5:\"myage\";s:10:\"field_type\";s:3:\"int\";s:10:\"field_leng\";i:2;s:9:\"form_type\";s:4:\"text\";s:15:\"field_inputleng\";s:1:\"2\";s:8:\"form_set\";s:0:\"\";s:10:\"form_value\";s:0:\"\";s:10:\"form_units\";s:2:\"\";s:10:\"form_title\";s:0:\"\";s:8:\"mustfill\";s:1:\"1\";s:8:\"listshow\";s:1:\"1\";s:6:\"search\";s:1:\"0\";s:9:\"orderlist\";i:18;s:9:\"allowview\";N;}s:9:\"schoo_age\";a:15:{s:5:\"title\";s:4:\"ѧ\";s:10:\"field_name\";s:9:\"schoo_age\";s:10:\"field_type\";s:7:\"varchar\";s:10:\"field_leng\";i:15;s:9:\"form_type\";s:6:\"select\";s:15:\"field_inputleng\";s:0:\"\";s:8:\"form_set\";s:45:\"\r\nר\r\n\r\nר\r\n\r\n˶ʿ\r\nʿ\r\nMBA\";s:10:\"form_value\";s:4:\"ר\";s:10:\"form_units\";s:0:\"\";s:10:\"form_title\";s:0:\"\";s:8:\"mustfill\";s:1:\"0\";s:8:\"listshow\";s:1:\"0\";s:6:\"search\";s:1:\"0\";s:9:\"orderlist\";i:17;s:9:\"allowview\";N;}s:14:\"graduateschool\";a:15:{s:5:\"title\";s:8:\"ҵѧУ\";s:10:\"field_name\";s:14:\"graduateschool\";s:10:\"field_type\";s:7:\"varchar\";s:10:\"field_leng\";i:40;s:9:\"form_type\";s:4:\"text\";s:15:\"field_inputleng\";s:2:\"15\";s:8:\"form_set\";s:0:\"\";s:10:\"form_value\";s:0:\"\";s:10:\"form_units\";s:0:\"\";s:10:\"form_title\";s:0:\"\";s:8:\"mustfill\";s:1:\"0\";s:8:\"listshow\";s:1:\"0\";s:6:\"search\";s:1:\"0\";s:9:\"orderlist\";i:16;s:9:\"allowview\";N;}s:9:\"specialty\";a:15:{s:5:\"title\";s:4:\"רҵ\";s:10:\"field_name\";s:9:\"specialty\";s:10:\"field_type\";s:7:\"varchar\";s:10:\"field_leng\";i:50;s:9:\"form_type\";s:4:\"text\";s:15:\"field_inputleng\";s:2:\"20\";s:8:\"form_set\";s:0:\"\";s:10:\"form_value\";s:0:\"\";s:10:\"form_units\";s:0:\"\";s:10:\"form_title\";s:0:\"\";s:8:\"mustfill\";s:1:\"0\";s:8:\"listshow\";s:1:\"0\";s:6:\"search\";s:1:\"0\";s:9:\"orderlist\";i:15;s:9:\"allowview\";N;}s:5:\"skill\";a:15:{s:5:\"title\";s:4:\"س\";s:10:\"field_name\";s:5:\"skill\";s:10:\"field_type\";s:7:\"varchar\";s:10:\"field_leng\";i:50;s:9:\"form_type\";s:4:\"text\";s:15:\"field_inputleng\";s:2:\"20\";s:8:\"form_set\";s:0:\"\";s:10:\"form_value\";s:0:\"\";s:10:\"form_units\";s:0:\"\";s:10:\"form_title\";s:0:\"\";s:8:\"mustfill\";s:1:\"0\";s:8:\"listshow\";s:1:\"0\";s:6:\"search\";s:1:\"0\";s:9:\"orderlist\";i:14;s:9:\"allowview\";N;}s:8:\"workyear\";a:15:{s:5:\"title\";s:8:\"\";s:10:\"field_name\";s:8:\"workyear\";s:10:\"field_type\";s:3:\"int\";s:10:\"field_leng\";i:2;s:9:\"form_type\";s:4:\"text\";s:15:\"field_inputleng\";s:1:\"2\";s:8:\"form_set\";s:0:\"\";s:10:\"form_value\";s:0:\"\";s:10:\"form_units\";s:2:\"\";s:10:\"form_title\";s:0:\"\";s:8:\"mustfill\";s:1:\"1\";s:8:\"listshow\";s:1:\"1\";s:6:\"search\";s:1:\"0\";s:9:\"orderlist\";i:13;s:9:\"allowview\";N;}s:10:\"experience\";a:15:{s:5:\"title\";s:8:\"\";s:10:\"field_name\";s:10:\"experience\";s:10:\"field_type\";s:10:\"mediumtext\";s:10:\"field_leng\";i:2;s:9:\"form_type\";s:8:\"textarea\";s:15:\"field_inputleng\";s:1:\"2\";s:8:\"form_set\";s:0:\"\";s:10:\"form_value\";s:0:\"\";s:10:\"form_units\";s:0:\"\";s:10:\"form_title\";s:0:\"\";s:8:\"mustfill\";s:1:\"1\";s:8:\"listshow\";s:1:\"0\";s:6:\"search\";s:1:\"0\";s:9:\"orderlist\";i:12;s:9:\"allowview\";N;}s:4:\"wage\";a:15:{s:5:\"title\";s:8:\"н\";s:10:\"field_name\";s:4:\"wage\";s:10:\"field_type\";s:7:\"varchar\";s:10:\"field_leng\";i:20;s:9:\"form_type\";s:6:\"select\";s:15:\"field_inputleng\";s:0:\"\";s:8:\"form_set\";s:73:\"\r\n1000Ԫ\r\n1000Ԫ-2000Ԫ\r\n2000Ԫ-3000Ԫ\r\n3000Ԫ-4000Ԫ\r\n4000Ԫ\";s:10:\"form_value\";s:0:\"\";s:10:\"form_units\";s:0:\"\";s:10:\"form_title\";s:0:\"\";s:8:\"mustfill\";s:1:\"0\";s:8:\"listshow\";s:1:\"0\";s:6:\"search\";s:1:\"0\";s:9:\"orderlist\";i:11;s:9:\"allowview\";N;}s:7:\"address\";a:15:{s:5:\"title\";s:10:\"ǰס\";s:10:\"field_name\";s:7:\"address\";s:10:\"field_type\";s:7:\"varchar\";s:10:\"field_leng\";i:255;s:9:\"form_type\";s:4:\"text\";s:15:\"field_inputleng\";s:2:\"70\";s:8:\"form_set\";s:0:\"\";s:10:\"form_value\";s:0:\"\";s:10:\"form_units\";s:0:\"\";s:10:\"form_title\";s:0:\"\";s:8:\"mustfill\";s:1:\"0\";s:8:\"listshow\";s:1:\"0\";s:6:\"search\";s:1:\"0\";s:9:\"orderlist\";i:10;s:9:\"allowview\";N;}s:9:\"telephone\";a:15:{s:5:\"title\";s:8:\"ϵ绰\";s:10:\"field_name\";s:9:\"telephone\";s:10:\"field_type\";s:7:\"varchar\";s:10:\"field_leng\";i:25;s:9:\"form_type\";s:4:\"text\";s:15:\"field_inputleng\";s:0:\"\";s:8:\"form_set\";s:0:\"\";s:10:\"form_value\";s:0:\"\";s:10:\"form_units\";s:0:\"\";s:10:\"form_title\";s:0:\"\";s:8:\"mustfill\";s:1:\"0\";s:8:\"listshow\";s:1:\"0\";s:6:\"search\";s:1:\"0\";s:9:\"orderlist\";i:9;s:9:\"allowview\";N;}s:5:\"email\";a:15:{s:5:\"title\";s:8:\"ϵ\";s:10:\"field_name\";s:5:\"email\";s:10:\"field_type\";s:7:\"varchar\";s:10:\"field_leng\";i:50;s:9:\"form_type\";s:4:\"text\";s:15:\"field_inputleng\";s:2:\"20\";s:8:\"form_set\";s:0:\"\";s:10:\"form_value\";s:0:\"\";s:10:\"form_units\";s:0:\"\";s:10:\"form_title\";s:0:\"\";s:8:\"mustfill\";s:1:\"0\";s:8:\"listshow\";s:1:\"0\";s:6:\"search\";s:1:\"0\";s:9:\"orderlist\";i:8;s:9:\"allowview\";N;}s:4:\"oicq\";a:15:{s:5:\"title\";s:6:\"QQ\";s:10:\"field_name\";s:4:\"oicq\";s:10:\"field_type\";s:7:\"varchar\";s:10:\"field_leng\";i:11;s:9:\"form_type\";s:4:\"text\";s:15:\"field_inputleng\";s:1:\"9\";s:8:\"form_set\";s:0:\"\";s:10:\"form_value\";s:0:\"\";s:10:\"form_units\";s:0:\"\";s:10:\"form_title\";s:0:\"\";s:8:\"mustfill\";s:1:\"0\";s:8:\"listshow\";s:1:\"0\";s:6:\"search\";s:1:\"0\";s:9:\"orderlist\";i:7;s:9:\"allowview\";N;}s:8:\"worktime\";a:15:{s:5:\"title\";s:8:\"\";s:10:\"field_name\";s:8:\"worktime\";s:10:\"field_type\";s:7:\"varchar\";s:10:\"field_leng\";i:15;s:9:\"form_type\";s:5:\"radio\";s:15:\"field_inputleng\";s:0:\"\";s:8:\"form_set\";s:34:\"ʱ\r\n1\r\n2\r\n3\r\n1\";s:10:\"form_value\";s:0:\"\";s:10:\"form_units\";s:0:\"\";s:10:\"form_title\";s:0:\"\";s:8:\"mustfill\";s:1:\"1\";s:8:\"listshow\";s:1:\"0\";s:6:\"search\";s:1:\"0\";s:9:\"orderlist\";i:6;s:9:\"allowview\";N;}}s:7:\"is_html\";a:1:{s:7:\"content\";s:4:\"\";}s:11:\"listshow_db\";a:7:{s:6:\"my_537\";s:8:\"\";s:6:\"my_425\";s:8:\"\";s:8:\"truename\";s:4:\"\";s:5:\"myage\";s:4:\"\";s:8:\"workyear\";s:8:\"\";s:3:\"sex\";s:4:\"Ա\";s:12:\"workposition\";s:8:\"ְλ\";}}','','0','','0','1','¼','','0','','');
INSERT INTO `qb_form_module` VALUES ('7','Ʒ','0','','a:3:{s:8:\"field_db\";a:11:{s:7:\"product\";a:15:{s:5:\"title\";s:8:\"Ʒ\";s:10:\"field_name\";s:7:\"product\";s:10:\"field_type\";s:7:\"varchar\";s:10:\"field_leng\";i:50;s:9:\"form_type\";s:4:\"text\";s:15:\"field_inputleng\";s:2:\"40\";s:8:\"form_set\";s:0:\"\";s:10:\"form_value\";s:0:\"\";s:10:\"form_units\";s:0:\"\";s:10:\"form_title\";s:0:\"\";s:8:\"mustfill\";s:1:\"1\";s:8:\"listshow\";s:1:\"0\";s:6:\"search\";s:1:\"0\";s:9:\"orderlist\";s:2:\"30\";s:9:\"allowview\";N;}s:7:\"paytype\";a:15:{s:5:\"title\";s:8:\"ʽ\";s:10:\"field_name\";s:7:\"paytype\";s:10:\"field_type\";s:7:\"varchar\";s:10:\"field_leng\";i:25;s:9:\"form_type\";s:5:\"radio\";s:15:\"field_inputleng\";s:0:\"\";s:8:\"form_set\";s:70:\"olpay|֧\r\nת\r\nATM/й̨תʻ\r\n\r\nʽ\r\n\";s:10:\"form_value\";s:5:\"olpay\";s:10:\"form_units\";s:0:\"\";s:10:\"form_title\";s:0:\"\";s:8:\"mustfill\";s:1:\"1\";s:8:\"listshow\";s:1:\"1\";s:6:\"search\";s:1:\"0\";s:9:\"orderlist\";s:2:\"29\";s:9:\"allowview\";N;}s:7:\"paytime\";a:14:{s:5:\"title\";s:8:\"\";s:10:\"field_name\";s:7:\"paytime\";s:10:\"field_type\";s:7:\"varchar\";s:10:\"field_leng\";i:15;s:9:\"form_type\";s:4:\"time\";s:15:\"field_inputleng\";s:0:\"\";s:8:\"form_set\";s:0:\"\";s:10:\"form_value\";s:0:\"\";s:10:\"form_units\";s:0:\"\";s:10:\"form_title\";s:0:\"\";s:8:\"mustfill\";s:1:\"0\";s:6:\"search\";s:1:\"0\";s:9:\"orderlist\";i:28;s:9:\"allowview\";N;}s:11:\"receivebank\";a:14:{s:5:\"title\";s:12:\"ת\";s:10:\"field_name\";s:11:\"receivebank\";s:10:\"field_type\";s:7:\"varchar\";s:10:\"field_leng\";i:30;s:9:\"form_type\";s:4:\"text\";s:15:\"field_inputleng\";s:2:\"20\";s:8:\"form_set\";s:0:\"\";s:10:\"form_value\";s:0:\"\";s:10:\"form_units\";s:0:\"\";s:10:\"form_title\";s:0:\"\";s:8:\"mustfill\";s:1:\"0\";s:6:\"search\";s:1:\"0\";s:9:\"orderlist\";i:27;s:9:\"allowview\";N;}s:8:\"sendbank\";a:14:{s:5:\"title\";s:12:\"ת\";s:10:\"field_name\";s:8:\"sendbank\";s:10:\"field_type\";s:7:\"varchar\";s:10:\"field_leng\";i:30;s:9:\"form_type\";s:4:\"text\";s:15:\"field_inputleng\";s:2:\"20\";s:8:\"form_set\";s:0:\"\";s:10:\"form_value\";s:0:\"\";s:10:\"form_units\";s:0:\"\";s:10:\"form_title\";s:0:\"\";s:8:\"mustfill\";s:1:\"0\";s:6:\"search\";s:1:\"0\";s:9:\"orderlist\";i:26;s:9:\"allowview\";N;}s:8:\"paymoney\";a:15:{s:5:\"title\";s:8:\"֧\";s:10:\"field_name\";s:8:\"paymoney\";s:10:\"field_type\";s:7:\"varchar\";s:10:\"field_leng\";i:15;s:9:\"form_type\";s:4:\"text\";s:15:\"field_inputleng\";s:2:\"10\";s:8:\"form_set\";s:0:\"\";s:10:\"form_value\";s:0:\"\";s:10:\"form_units\";s:2:\"Ԫ\";s:10:\"form_title\";s:0:\"\";s:8:\"mustfill\";s:1:\"1\";s:8:\"listshow\";s:1:\"1\";s:6:\"search\";s:1:\"0\";s:9:\"orderlist\";s:2:\"25\";s:9:\"allowview\";N;}s:8:\"truename\";a:15:{s:5:\"title\";s:10:\"ϵ\";s:10:\"field_name\";s:8:\"truename\";s:10:\"field_type\";s:7:\"varchar\";s:10:\"field_leng\";i:15;s:9:\"form_type\";s:4:\"text\";s:15:\"field_inputleng\";s:2:\"10\";s:8:\"form_set\";s:0:\"\";s:10:\"form_value\";s:0:\"\";s:10:\"form_units\";s:0:\"\";s:10:\"form_title\";s:0:\"\";s:8:\"mustfill\";s:1:\"0\";s:8:\"listshow\";s:1:\"1\";s:6:\"search\";s:1:\"0\";s:9:\"orderlist\";s:2:\"24\";s:9:\"allowview\";N;}s:4:\"oicq\";a:14:{s:5:\"title\";s:8:\"ϵQQ\";s:10:\"field_name\";s:4:\"oicq\";s:10:\"field_type\";s:7:\"varchar\";s:10:\"field_leng\";i:11;s:9:\"form_type\";s:4:\"text\";s:15:\"field_inputleng\";s:2:\"11\";s:8:\"form_set\";s:0:\"\";s:10:\"form_value\";s:0:\"\";s:10:\"form_units\";s:0:\"\";s:10:\"form_title\";s:0:\"\";s:8:\"mustfill\";s:1:\"0\";s:6:\"search\";s:1:\"0\";s:9:\"orderlist\";s:2:\"23\";s:9:\"allowview\";N;}s:9:\"telephone\";a:14:{s:5:\"title\";s:10:\"ϵ˵绰\";s:10:\"field_name\";s:9:\"telephone\";s:10:\"field_type\";s:7:\"varchar\";s:10:\"field_leng\";i:30;s:9:\"form_type\";s:4:\"text\";s:15:\"field_inputleng\";s:2:\"15\";s:8:\"form_set\";s:0:\"\";s:10:\"form_value\";s:0:\"\";s:10:\"form_units\";s:0:\"\";s:10:\"form_title\";s:0:\"\";s:8:\"mustfill\";s:1:\"0\";s:6:\"search\";s:1:\"0\";s:9:\"orderlist\";s:2:\"22\";s:9:\"allowview\";N;}s:8:\"mobphone\";a:14:{s:5:\"title\";s:10:\"ϵֻ\";s:10:\"field_name\";s:8:\"mobphone\";s:10:\"field_type\";s:7:\"varchar\";s:10:\"field_leng\";i:11;s:9:\"form_type\";s:4:\"text\";s:15:\"field_inputleng\";s:2:\"11\";s:8:\"form_set\";s:0:\"\";s:10:\"form_value\";s:0:\"\";s:10:\"form_units\";s:0:\"\";s:10:\"form_title\";s:0:\"\";s:8:\"mustfill\";s:1:\"0\";s:6:\"search\";s:1:\"0\";s:9:\"orderlist\";i:21;s:9:\"allowview\";N;}s:7:\"address\";a:14:{s:5:\"title\";s:10:\"ϵ˵ַ\";s:10:\"field_name\";s:7:\"address\";s:10:\"field_type\";s:7:\"varchar\";s:10:\"field_leng\";i:150;s:9:\"form_type\";s:4:\"text\";s:15:\"field_inputleng\";s:2:\"60\";s:8:\"form_set\";s:0:\"\";s:10:\"form_value\";s:0:\"\";s:10:\"form_units\";s:0:\"\";s:10:\"form_title\";s:0:\"\";s:8:\"mustfill\";s:1:\"0\";s:6:\"search\";s:1:\"0\";s:9:\"orderlist\";s:2:\"20\";s:9:\"allowview\";N;}}s:7:\"is_html\";a:1:{s:7:\"content\";s:4:\"\";}s:11:\"listshow_db\";a:3:{s:7:\"paytype\";s:8:\"ʽ\";s:8:\"truename\";s:10:\"ϵ\";s:8:\"paymoney\";s:8:\"֧\";}}','','0','','0','1','','','0','','');
INSERT INTO `qb_form_module` VALUES ('8','Ƶ귿Ԥ','0','','a:3:{s:8:\"field_db\";a:6:{s:8:\"roomtype\";a:15:{s:5:\"title\";s:12:\"Ԥ\";s:10:\"field_name\";s:8:\"roomtype\";s:10:\"field_type\";s:7:\"varchar\";s:10:\"field_leng\";i:30;s:9:\"form_type\";s:5:\"radio\";s:15:\"field_inputleng\";s:0:\"\";s:8:\"form_set\";s:44:\"׼˫˷\r\n׼˷\r\n˷\r\nͳ׷\";s:10:\"form_value\";s:0:\"\";s:10:\"form_units\";s:0:\"\";s:10:\"form_title\";s:0:\"\";s:8:\"mustfill\";s:1:\"1\";s:8:\"listshow\";s:1:\"1\";s:6:\"search\";s:1:\"0\";s:9:\"orderlist\";i:10;s:9:\"allowview\";N;}s:7:\"roomnum\";a:15:{s:5:\"title\";s:8:\"Ԥ\";s:10:\"field_name\";s:7:\"roomnum\";s:10:\"field_type\";s:3:\"int\";s:10:\"field_leng\";i:3;s:9:\"form_type\";s:4:\"text\";s:15:\"field_inputleng\";s:1:\"2\";s:8:\"form_set\";s:0:\"\";s:10:\"form_value\";s:0:\"\";s:10:\"form_units\";s:2:\"\";s:10:\"form_title\";s:0:\"\";s:8:\"mustfill\";s:1:\"1\";s:8:\"listshow\";s:1:\"1\";s:6:\"search\";s:1:\"0\";s:9:\"orderlist\";i:9;s:9:\"allowview\";N;}s:6:\"numday\";a:15:{s:5:\"title\";s:8:\"ס\";s:10:\"field_name\";s:6:\"numday\";s:10:\"field_type\";s:3:\"int\";s:10:\"field_leng\";i:3;s:9:\"form_type\";s:4:\"text\";s:15:\"field_inputleng\";s:1:\"2\";s:8:\"form_set\";s:0:\"\";s:10:\"form_value\";s:0:\"\";s:10:\"form_units\";s:2:\"\";s:10:\"form_title\";s:0:\"\";s:8:\"mustfill\";s:1:\"0\";s:8:\"listshow\";s:1:\"0\";s:6:\"search\";s:1:\"0\";s:9:\"orderlist\";i:8;s:9:\"allowview\";N;}s:8:\"intotime\";a:15:{s:5:\"title\";s:8:\"סʱ\";s:10:\"field_name\";s:8:\"intotime\";s:10:\"field_type\";s:7:\"varchar\";s:10:\"field_leng\";i:30;s:9:\"form_type\";s:4:\"time\";s:15:\"field_inputleng\";s:0:\"\";s:8:\"form_set\";s:0:\"\";s:10:\"form_value\";s:0:\"\";s:10:\"form_units\";s:0:\"\";s:10:\"form_title\";s:0:\"\";s:8:\"mustfill\";s:1:\"1\";s:8:\"listshow\";s:1:\"0\";s:6:\"search\";s:1:\"0\";s:9:\"orderlist\";i:7;s:9:\"allowview\";N;}s:8:\"truename\";a:15:{s:5:\"title\";s:8:\"˿\";s:10:\"field_name\";s:8:\"truename\";s:10:\"field_type\";s:7:\"varchar\";s:10:\"field_leng\";i:30;s:9:\"form_type\";s:4:\"text\";s:15:\"field_inputleng\";s:2:\"12\";s:8:\"form_set\";s:0:\"\";s:10:\"form_value\";s:0:\"\";s:10:\"form_units\";s:0:\"\";s:10:\"form_title\";s:0:\"\";s:8:\"mustfill\";s:1:\"1\";s:8:\"listshow\";s:1:\"1\";s:6:\"search\";s:1:\"0\";s:9:\"orderlist\";i:6;s:9:\"allowview\";N;}s:9:\"telephone\";a:15:{s:5:\"title\";s:8:\"ϵ绰\";s:10:\"field_name\";s:9:\"telephone\";s:10:\"field_type\";s:7:\"varchar\";s:10:\"field_leng\";i:20;s:9:\"form_type\";s:4:\"text\";s:15:\"field_inputleng\";s:2:\"12\";s:8:\"form_set\";s:0:\"\";s:10:\"form_value\";s:0:\"\";s:10:\"form_units\";s:0:\"\";s:10:\"form_title\";s:0:\"\";s:8:\"mustfill\";s:1:\"1\";s:8:\"listshow\";s:1:\"0\";s:6:\"search\";s:1:\"0\";s:9:\"orderlist\";i:5;s:9:\"allowview\";N;}}s:7:\"is_html\";a:1:{s:7:\"content\";s:4:\"\";}s:11:\"listshow_db\";a:3:{s:8:\"roomtype\";s:12:\"Ԥ\";s:7:\"roomnum\";s:8:\"Ԥ\";s:8:\"truename\";s:8:\"˿\";}}','','0','','0','1','','','0','','');
INSERT INTO `qb_form_reply` VALUES ('6','25','3','1237255555','1','admin','<p><u>yyyyyy</u></p>\r\n<p><u>yyyyyyyy</u></p><strong>\r\n<hr width=\"100%\" color=#98fb98 SIZE=1 />\r\n</strong>','192.168.0.99');
INSERT INTO `qb_form_reply` VALUES ('10','27','3','1239591974','1','admin','ffffffffffff ','192.168.0.99');
INSERT INTO `qb_friendlink` VALUES ('12','PHPWINDٷ̳','http://www.phpwind.net/','friendlink/1_20121224171239_tldms.gif','PHPWINDٷ̳','32','0','0','0','0','0','','1','0','0','0');
INSERT INTO `qb_friendlink` VALUES ('5','벩CMS','http://www.qibosoft.com','../images/default/friendlink.gif','CMSվϵͳṩ!!','40','0','0','0','0','0','','1','0','0','2');
INSERT INTO `qb_friendlink` VALUES ('17','̳','http://www.dvbbs.net/','','̳','0','0','0','0','0','0','','1','0','0','0');
INSERT INTO `qb_friendlink` VALUES ('25','վ','http://www.admin5.com/','friendlink/1_20090418160400_wqpAk.gif','վ','37','0','0','0','0','0','','1','0','0','0');
INSERT INTO `qb_friendlink` VALUES ('29','еƼ','http://www.chinaccnet.com/','','еƼ','9','0','0','0','0','0','','1','0','0','0');
INSERT INTO `qb_friendlink` VALUES ('34','CNZZ','http://www.cnzz.cn/','','CNZZ','8','0','0','0','0','0','','1','0','0','0');
INSERT INTO `qb_friendlink` VALUES ('35','','http://www.sudu.cn/','','','10','0','0','0','1293588992','0','','1','0','0','0');
INSERT INTO `qb_friendlink_sort` VALUES ('2','','0');
INSERT INTO `qb_friendlink_sort` VALUES ('3','','0');
INSERT INTO `qb_friendlink_sort` VALUES ('4','','0');
INSERT INTO `qb_gather_rule` VALUES ('1','0','article','article','','Ѷ˲ż','','','0','0','1','0','http://edu.qq.com/job/jlgc_more.htm\r\nhttp://edu.qq.com/job/jlgc_more1.htm\r\nhttp://edu.qq.com/job/jlgc_more2.htm','','','','','','','','','0','','','','','','<table|<table style=\"display:none;\"','','','0','1172984270','1172984423','0','0','','0','0','','','','0','','<tr><td height=\"24\" class=\"font14px\"><div align=\"left\"><a target=\"_blank\" class=\"blackul\" href=\"{url=NO\"}\">{title=NO<}</a> ','<div id=\"ArticleCnt\">{content=*}</div><div id=\"copyweb\">','','','0');
INSERT INTO `qb_gather_rule` VALUES ('2','0','article','article','','ԭѧռ----->ɢ >> ','http://wind.yinsha.com/ashow.php?sid=10&%20size=20&page=[page]','','1','3','1','0','','','','','','','','','','0','','','','<tr><td><p class=s11>','</td></tr>','','','','0','1165498531','1165498610','0','0','','0','0','','','','0','','<img src=images/{NO\"} border=0>\r\n                    \r\n            <a href=\"{url=NO\"}\" target=_blank>{title=NO<}</a> ','','','','0');
INSERT INTO `qb_gather_rule` VALUES ('3','0','article','article','','̺ɴ-> ɢ >> ','http://wind.yinsha.com/ashow.php?sid=5&%20size=20&page=[page]','','1','8','1','0','','','','','','','','','','0','','','','','','','','','0','1166582291','1166582456','0','0','','0','0','','','','0','','<img src=images/{NO\"} border=0>\r\n                    \r\n            <a href=\"{url=NO }\" target=_blank>{title=NO<}</a> ','<div align=\"center\" class=\"s3\">: {author=NO\"}</div>{*}<tr><td><p class=s11>&nbsp;&nbsp;{content=*}</td></tr>\r\n\r\n','','','0');
INSERT INTO `qb_pm` VALUES ('12','0','','0','SYSTEM','rebox','1','пͻ¶','1461137486','뾡鿴<A HREF=\'http://life.net/wap/shop/member/joinshow.php?id=6\' target=\'_blank\'>http://life.net/wap/shop/member/joinshow.php?id=6</A>');
INSERT INTO `qb_pm` VALUES ('13','0','','0','SYSTEM','rebox','1','пͻ¶','1461137567','뾡鿴<A HREF=\'http://life.net/wap/shop/member/joinshow.php?id=7\' target=\'_blank\'>http://life.net/wap/shop/member/joinshow.php?id=7</A>');
INSERT INTO `qb_pm` VALUES ('14','0','','0','SYSTEM','rebox','1','пͻ¶','1461138821','뾡鿴<A HREF=\'http://life.net/shop/member/wapjoinshow.php?id=8\' target=\'_blank\'>http://life.net/shop/member/wapjoinshow.php?id=8</A>');
INSERT INTO `qb_pm` VALUES ('15','0','','0','SYSTEM','rebox','1','пͻ¶','1461140372','뾡鿴<A HREF=\'http://life.net/wap/shop/member/joinshow.php?id=9\' target=\'_blank\'>http://life.net/wap/shop/member/joinshow.php?id=9</A>');
INSERT INTO `qb_pm` VALUES ('16','0','','0','SYSTEM','rebox','1','пͻ¶','1461725703','뾡鿴<A HREF=\'http://life.net/shop/member/wapjoinshow.php?id=10\' target=\'_blank\'>http://life.net/shop/member/wapjoinshow.php?id=10</A>');
INSERT INTO `qb_pm` VALUES ('19','0','','0','SYSTEM','rebox','1','пͻ¶','1462343933','뾡鿴<A HREF=\'http://life.net/shop/member/wapjoinshow.php?id=13\' target=\'_blank\'>http://life.net/shop/member/wapjoinshow.php?id=13</A>');
INSERT INTO `qb_pm` VALUES ('20','0','','0','SYSTEM','rebox','1','пͻ¶','1462344139','뾡鿴<A HREF=\'http://life.net/shop/member/wapjoinshow.php?id=14\' target=\'_blank\'>http://life.net/shop/member/wapjoinshow.php?id=14</A>');
INSERT INTO `qb_pm` VALUES ('29','0','','0','SYSTEM','rebox','1','пͻ¶','1462420832','뾡鿴<A HREF=\'http://life.net/shop/member/wapjoinshow.php?id=15\' target=\'_blank\'>http://life.net/shop/member/wapjoinshow.php?id=15</A>');
INSERT INTO `qb_pm` VALUES ('49','1','','1','admin','rebox','0','ǩȡȯ','1486630217','ЭƼ޹˾̻ȡȯ0.01Ԫ');
INSERT INTO `qb_pm` VALUES ('33','0','','0','SYSTEM','rebox','1','пͻ¶','1482137100','뾡鿴<A HREF=\'http://wz.net/shop/member/wapjoinshow.php?id=1\' target=\'_blank\'>http://wz.net/shop/member/wapjoinshow.php?id=1</A>');
INSERT INTO `qb_pm` VALUES ('38','0','','0','SYSTEM','rebox','1','пͻ¶','1484298239','뾡鿴<A HREF=\'http://wz.net/shop/member/wapjoinshow.php?id=5\' target=\'_blank\'>http://wz.net/shop/member/wapjoinshow.php?id=5</A>');
INSERT INTO `qb_pm` VALUES ('39','0','','0','SYSTEM','rebox','1','пͻ¶','1484298245','뾡鿴<A HREF=\'http://wz.net/shop/member/wapjoinshow.php?id=6\' target=\'_blank\'>http://wz.net/shop/member/wapjoinshow.php?id=6</A>');
INSERT INTO `qb_pm` VALUES ('40','0','','0','SYSTEM','rebox','1','пͻ¶','1484298255','뾡鿴<A HREF=\'http://wz.net/shop/member/wapjoinshow.php?id=7\' target=\'_blank\'>http://wz.net/shop/member/wapjoinshow.php?id=7</A>');
INSERT INTO `qb_pm` VALUES ('41','0','','0','SYSTEM','rebox','1','пͻ¶','1484298373','뾡鿴<A HREF=\'http://wz.net/shop/member/wapjoinshow.php?id=8\' target=\'_blank\'>http://wz.net/shop/member/wapjoinshow.php?id=8</A>');
INSERT INTO `qb_pm` VALUES ('43','0','','0','SYSTEM','rebox','1','пͻ¶','1484364984','뾡鿴<A HREF=\'http://wz.net/shop/member/wapjoinshow.php?id=10\' target=\'_blank\'>http://wz.net/shop/member/wapjoinshow.php?id=10</A>');
INSERT INTO `qb_pm` VALUES ('44','0','','0','SYSTEM','rebox','1','пͻ¶','1484536713','뾡鿴<A HREF=\'http://wz.net/shop/member/wapjoinshow.php?id=11\' target=\'_blank\'>http://wz.net/shop/member/wapjoinshow.php?id=11</A>');
INSERT INTO `qb_pm` VALUES ('46','0','','0','SYSTEM','rebox','1','пͻ¶','1484644084','뾡鿴<A HREF=\'http://wz.net/shop/member/wapjoinshow.php?id=13\' target=\'_blank\'>http://wz.net/shop/member/wapjoinshow.php?id=13</A>');
INSERT INTO `qb_guestbook_content` VALUES ('12','0','1','','','','','1','admin','192.168.0.99','ǿƽվ̨ķ:޸/data/global.phpļ,$ForceEnter=0;0ĳ1,ǿƽվĺ̨.','1','1240206881','1240206881','','');
INSERT INTO `qb_guestbook_content` VALUES ('13','0','1','','','','','1','admin','192.168.0.99','ͨԱΪԱķ,޸ļ/data/admin.php,ߵʺŸһ¼','1','1240206958','1240206958','','');
INSERT INTO `qb_guestbook_content` VALUES ('14','0','1','','','','','1','admin','192.168.0.99','վϵͳݿļ/data/mysql_config.php','1','1240207079','1240207079','','');
INSERT INTO `qb_guestbook_content` VALUES ('15','0','1','','','','','1','admin','192.168.0.99','ĬϴļСΪ2M,޸ķ.վϵͳϴ2Mļ.ǲԵ.޸ķ.һ˵PHPļc:\\windows\\php.ini.','1','1240207216','1240207216','','');
INSERT INTO `qb_guestbook_content` VALUES ('16','0','1','','','','','1','admin','192.168.0.99','.޷ʹòɼ.','1','1240207330','1240207330','','');
INSERT INTO `qb_guestbook_sort` VALUES ('1','0','չ','0','1','0','0','','0','0','','','','','','','0','','','','0','','','','','0','b:0;','0','0','','','0');
INSERT INTO `qb_guestbook_sort` VALUES ('2','0','Ͷ','0','1','0','0','','0','0','','','','','','','0','','','','1','','','','','0','','0','0','','','0');
INSERT INTO `qb_guestbook_config` VALUES ('module_id','18','');
INSERT INTO `qb_guestbook_config` VALUES ('GuestBookNum','20','');
INSERT INTO `qb_guestbook_config` VALUES ('groupPassPassGuestBook','3,4','');
INSERT INTO `qb_guestbook_config` VALUES ('viewNoPassGuestBook','0','');
INSERT INTO `qb_guestbook_config` VALUES ('yzImgGuestBook','1','');
INSERT INTO `qb_guestbook_config` VALUES ('module_pre','guestbook_','');
INSERT INTO `qb_guestbook_config` VALUES ('ifOpenGuestBook','1','');
INSERT INTO `qb_guestbook_config` VALUES ('Info_webname','Ա','');
INSERT INTO `qb_guestbook_config` VALUES ('Info_webOpen','1','');
INSERT INTO `qb_keyword` VALUES ('1','Ʒ','0','1','1','','0');
INSERT INTO `qb_keyword` VALUES ('2','','0','1','1','','1');
INSERT INTO `qb_keywordid` VALUES ('2','883');
INSERT INTO `qb_limitword` VALUES ('1','췴','**');
INSERT INTO `qb_limitword` VALUES ('2','ֹ','**');
INSERT INTO `qb_upfile` VALUES ('1','0','0','0','1','1343208090','0_G中国人民WM0E0zfeGxr.jpg','1_20120725170731_ds7pr.jpg','0','0');
INSERT INTO `qb_upfile` VALUES ('2','0','0','0','1','1343209967','_pushi.jpg','1_20120725170747_eytto.jpg','0','0');
INSERT INTO `qb_upfile` VALUES ('3','0','0','0','1','1344223118','Chrysanthemum.jpg','1_20120806110838_xrlsx.jpg','0','0');
INSERT INTO `qb_upfile` VALUES ('4','0','0','0','1','1344233542','Chrysanthemum.jpg','1_20120806140822_xn2e2.jpg','0','0');
INSERT INTO `qb_upfile` VALUES ('5','0','0','0','1','1344233552','Chrysanthemum.jpg','1_20120806140832_znlef.jpg','0','0');
INSERT INTO `qb_upfile` VALUES ('6','0','0','0','1','1344233581','Chrysanthemum.jpg','1_20120806140801_1xqwo.jpg','0','0');
INSERT INTO `qb_upfile` VALUES ('7','0','0','0','1','1344233623','_pushi.jpg','1_20120806140843_lzbry.jpg','0','0');
INSERT INTO `qb_upfile` VALUES ('8','0','0','0','1','1344233674','Chrysanthemum.jpg','1_20120806140834_ca1ic.jpg','0','0');
INSERT INTO `qb_upfile` VALUES ('9','0','0','0','1','1344233795','Chrysanthemum.jpg','1_20120806140835_3rko2.jpg','0','0');
INSERT INTO `qb_upfile` VALUES ('10','0','0','0','1','1344233919','_pushi.jpg','1_20120806140839_piiun.jpg','0','0');
INSERT INTO `qb_upfile` VALUES ('11','0','0','0','1','1344237385','Chrysanthemum.jpg','1_20120806150825_hrbqs.jpg','0','0');
INSERT INTO `qb_upfile` VALUES ('12','0','0','0','1','1344237415','_pushi.jpg','1_20120806150855_8pacf.jpg','0','0');
INSERT INTO `qb_upfile` VALUES ('13','0','0','0','1','1344237446','_pushi.jpg','1_20120806150826_jyzy6.jpg','0','0');
INSERT INTO `qb_upfile` VALUES ('14','0','0','0','1','1344237503','_pushi.jpg','1_20120806150823_ljadd.jpg','0','0');
INSERT INTO `qb_upfile` VALUES ('15','0','0','0','1','1344237523','_pushi.jpg','1_20120806150843_fycf6.jpg','0','0');
INSERT INTO `qb_upfile` VALUES ('16','0','0','0','1','1344237547','_pushi.jpg','1_20120806150807_58akh.jpg','0','0');
INSERT INTO `qb_upfile` VALUES ('17','0','0','0','1','1344237564','3_7NX4gnIxMp33.jpg','1_20120806150824_bm5ld.jpg','0','0');
INSERT INTO `qb_upfile` VALUES ('18','0','0','0','1','1344237614','1.jpg','1_20120806150814_mrejx.jpg','0','0');
INSERT INTO `qb_upfile` VALUES ('19','0','0','0','1','1344237632','_pushi.jpg','1_20120806150832_5rm0i.jpg','0','0');
INSERT INTO `qb_upfile` VALUES ('20','0','0','0','1','1344237640','_pushi.jpg','1_20120806150840_trt9f.jpg','0','0');
INSERT INTO `qb_upfile` VALUES ('21','0','0','0','1','1344237651','Chrysanthemum.jpg','1_20120806150851_hcxhc.jpg','0','0');
INSERT INTO `qb_upfile` VALUES ('22','0','0','0','1','1344237660','Chrysanthemum.jpg','1_20120806150800_xfuul.jpg','0','0');
INSERT INTO `qb_upfile` VALUES ('23','0','0','0','1','1344237817','_pushi.jpg','1_20120806150837_pdfyf.jpg','0','0');
INSERT INTO `qb_upfile` VALUES ('24','0','0','0','1','1344237840','照片.jpg','1_20120806150800_f17yj.jpg','0','0');
INSERT INTO `qb_upfile` VALUES ('25','0','0','0','1','1344237844','照片.jpg','1_20120806150804_2kuhs.jpg','0','0');
INSERT INTO `qb_upfile` VALUES ('26','0','0','0','1','1344237854','Chrysanthemum.jpg','1_20120806150814_jc835.jpg','0','0');
INSERT INTO `qb_upfile` VALUES ('27','0','0','0','1','1344237858','Chrysanthemum.jpg','1_20120806150818_3icin.jpg','0','0');
INSERT INTO `qb_upfile` VALUES ('28','0','0','0','1','1344237858','Desert.jpg','1_20120806150818_on4j2.jpg','0','0');
INSERT INTO `qb_upfile` VALUES ('29','0','0','0','1','1344237906','003.jpg','1_20120806150806_0hpsg.jpg','0','0');
INSERT INTO `qb_upfile` VALUES ('30','0','0','0','1','1344237906','3.jpg','1_20120806150806_3okle.jpg','0','0');
INSERT INTO `qb_upfile` VALUES ('31','0','0','0','1','1344492529','002.jpg','1_20120809140849_g3jeh.jpg','0','0');
INSERT INTO `qb_upfile` VALUES ('32','0','0','0','1','1344494435','sf.jpg','1_20120809140835_gnfe0.jpg','0','0');
INSERT INTO `qb_upfile` VALUES ('33','0','0','0','1','1344826433','_pushi.jpg','1_20120813100853_52edo.jpg','0','0');
INSERT INTO `qb_upfile` VALUES ('34','0','0','0','1','1344831098','_pushi.jpg','1_20120813120838_jqnmt.jpg','0','0');
INSERT INTO `qb_upfile` VALUES ('35','0','0','0','1','1344831128','_pushi.jpg','1_20120813120808_sgk0h.jpg','0','0');
INSERT INTO `qb_upfile` VALUES ('36','0','0','0','1','1346983423','Blue hills.jpg','1_20120907100943_oraow.jpg','0','0');
INSERT INTO `qb_upfile` VALUES ('37','0','0','0','1','1346983992','待做功能.txt','1_20120907100912_qjyqq.txt','0','0');
INSERT INTO `qb_upfile` VALUES ('38','0','0','0','1','1346984180','Sunset.jpg','1_20120907100920_h82ce.jpg','0','0');
INSERT INTO `qb_upfile` VALUES ('39','0','0','0','1','1346984337','Sunset.jpg','1_20120907100957_9131r.jpg','0','0');
INSERT INTO `qb_upfile` VALUES ('40','0','0','0','1','1351148407','_pushi.jpg','1_20121025151007_wy1rm.jpg','0','0');
INSERT INTO `qb_upfile` VALUES ('41','0','0','0','1','1351148525','0DBF70FD11264B44874670CCFE4C6B4D200608021754.jpg','1_20121025151005_q0oku.jpg','0','0');
INSERT INTO `qb_upfile` VALUES ('42','0','0','0','1','1351148621','4ab7fdcfg6562927498b4.jpg','1_20121025151041_314jy.jpg','0','0');
INSERT INTO `qb_upfile` VALUES ('43','0','0','0','1','1351148705','6_qTLhZRnq8r2v.jpg','1_20121025151005_g4w9m.jpg','0','0');
INSERT INTO `qb_upfile` VALUES ('44','0','0','0','1','1351152435','ҵ().JPG','1_20121025161015_suqqv.jpg','0','0');
INSERT INTO `qb_upfile` VALUES ('45','0','0','0','1','1353649828','1.jpg','1_20121123131128_cqiwg.jpg','0','0');
INSERT INTO `qb_upfile` VALUES ('46','0','0','0','1','1353649853','2.jpg','1_20121123131153_gseby.jpg','0','0');
INSERT INTO `qb_upfile` VALUES ('47','0','0','0','1','1353649875','3.jpg','1_20121123131115_v1qtp.jpg','0','0');
INSERT INTO `qb_upfile` VALUES ('48','0','0','0','1','1353649907','4.jpg','1_20121123131147_owsnb.jpg','0','0');
INSERT INTO `qb_upfile` VALUES ('52','0','0','0','1','1355973040','.txt','1_20121220111240_inftd.txt','0','0');
INSERT INTO `qb_upfile` VALUES ('53','0','0','0','1','1355973187','2012-9-4.rar','1_20121220111207_mtx36.rar','0','0');
INSERT INTO `qb_upfile` VALUES ('54','0','0','0','1','1355973256','װƵ.rar','1_20121220111216_rrtbw.rar','0','0');
INSERT INTO `qb_upfile` VALUES ('55','0','0','0','1','1355973317','v6.rar','1_20121220111217_7jwp6.rar','0','0');
INSERT INTO `qb_upfile` VALUES ('56','0','0','0','1','1355973550','Ϣϵͳ 1.5.rar','1_20121220111210_egzfh.rar','0','0');
INSERT INTO `qb_upfile` VALUES ('57','0','0','0','1','1355973563','벩̳.rar','1_20121220111223_zrxbt.rar','0','0');
INSERT INTO `qb_upfile` VALUES ('58','0','0','0','1','1355973627','ͼʽ԰CD1.rmvb.rar','1_20121220111227_sins8.rar','0','0');
INSERT INTO `qb_upfile` VALUES ('59','0','0','0','1','1356341619','logo.gif','1_20121224171239_tldms.gif','0','0');
INSERT INTO `qb_upfile` VALUES ('60','0','0','0','1','1356492338','0607231704802.JPG','1_20121226111238_tnupf.jpg','0','0');
INSERT INTO `qb_upfile` VALUES ('61','0','0','0','1','1356502075','_pushi.jpg','1_20121226141255_bmejq.jpg','0','0');
INSERT INTO `qb_upfile` VALUES ('62','0','0','0','1','1356772127','_pushi.jpg','1_20121229171247_uxwzn.jpg','0','0');
INSERT INTO `qb_upfile` VALUES ('63','0','0','0','1','1356772552','_pushi.jpg','1_20121229171252_7ajnv.jpg','0','0');
INSERT INTO `qb_upfile` VALUES ('64','0','0','0','1','1356772557','001.jpg','1_20121229171257_xcl5p.jpg','0','0');
INSERT INTO `qb_upfile` VALUES ('65','0','0','0','1','1357102300','_pushi.jpg','1_20130102120140_43b9c.jpg','0','0');
INSERT INTO `qb_upfile` VALUES ('66','0','0','0','1','1357102306','0_GйWM0E0zfeGxr.jpg','1_20130102120146_suecq.jpg','0','0');
INSERT INTO `qb_upfile` VALUES ('67','0','0','0','1','1357103266','1_B4jrfXg3G2Af.jpg','1_20130102130146_cxk06.jpg','0','0');
INSERT INTO `qb_upfile` VALUES ('68','0','0','0','1','1357113302','_pushi.jpg','1_20130102150102_0tnju.jpg','0','0');
INSERT INTO `qb_upfile` VALUES ('69','0','0','0','1','1357190100','2.jpg','1_20130103130100_plhtn.jpg','0','0');
INSERT INTO `qb_upfile` VALUES ('70','0','0','0','1','1357191581','1.jpg','1_20130103130141_al9ps.jpg','0','0');
INSERT INTO `qb_upfile` VALUES ('71','0','0','0','1','1357191614','1.jpg','1_20130103130114_u9prw.jpg','0','0');
INSERT INTO `qb_upfile` VALUES ('72','0','0','0','1','1357191620','1.jpg','1_20130103130120_nvibd.jpg','0','0');
INSERT INTO `qb_upfile` VALUES ('73','0','0','0','1','1358301646','1.jpg','1_20130116100146_qp2qk.jpg','0','0');
INSERT INTO `qb_upfile` VALUES ('74','0','0','0','1','1365642062','_pushi.jpg','1_20130411090402_wypan.jpg','0','0');
INSERT INTO `qb_upfile` VALUES ('75','0','0','0','1','1365642081','0_GйWM0E0zfeGxr.jpg','1_20130411090421_xaozm.jpg','0','0');
INSERT INTO `qb_upfile` VALUES ('79','0','0','0','1','1368669325','_pushi.jpg','1_20130516090525_vrhrc.jpg','0','0');
INSERT INTO `qb_upfile` VALUES ('81','0','0','0','1','1377067544','Winter.jpg','1_20130821140844_zzghu.jpg','0','0');
INSERT INTO `qb_upfile` VALUES ('82','0','0','0','1','1383186060','_pushi.jpg','1_20131031101000_5hrl0.jpg','0','0');
INSERT INTO `qb_upfile` VALUES ('83','0','0','0','1','1384499038','已婚材料清单.jpg','1_20131115151159_zumjv.jpg','0','0');
INSERT INTO `qb_upfile` VALUES ('84','0','0','0','1','1389767741','Water lilies.jpg','1_20140115140141_y2ir2.jpg','0','0');
INSERT INTO `qb_upfile` VALUES ('85','0','0','0','1','1389767767','Sunset.jpg','1_20140115140107_e1gzf.jpg','0','0');
INSERT INTO `qb_upfile` VALUES ('86','0','0','0','1','1389767787','Winter.jpg','1_20140115140127_op0hf.jpg','0','0');
INSERT INTO `qb_upfile` VALUES ('87','0','0','0','1','1391848562','演示','1_20140208160202_zrd6s.txt','0','0');
INSERT INTO `qb_upfile` VALUES ('88','0','0','0','1','1395305315','Blue hills.jpg','1_20140320160335_zlk4d.jpg','0','0');
INSERT INTO `qb_upfile` VALUES ('89','0','0','0','1','1395305315','Water lilies.jpg','1_20140320160336_jtmse.jpg','0','0');
INSERT INTO `qb_upfile` VALUES ('90','0','0','0','1','1395305429','Sunset.jpg','1_20140320160329_yfxuf.jpg','0','0');
INSERT INTO `qb_upfile` VALUES ('91','0','0','0','1','1461577982','Сbanner.png','1_20160425170402_mbyiv.png','0','0');
INSERT INTO `qb_upfile` VALUES ('92','0','0','0','1','1461651073','1.jpg','1_20160426140413_p45bu.jpg','0','0');
INSERT INTO `qb_upfile` VALUES ('93','0','0','0','1','1461651156','2.jpg','1_20160426140436_23xwb.jpg','0','0');
INSERT INTO `qb_upfile` VALUES ('94','0','0','0','1','1461651210','3.jpg','1_20160426140430_prlax.jpg','0','0');
INSERT INTO `qb_upfile` VALUES ('95','0','0','0','1','1461651251','4.jpg','1_20160426140411_552jc.jpg','0','0');
INSERT INTO `qb_upfile` VALUES ('96','0','0','0','1','1461651306','5.jpg','1_20160426140406_stytv.jpg','0','0');
INSERT INTO `qb_upfile` VALUES ('97','0','0','0','1','1461651358','6.jpg','1_20160426140458_amzxt.jpg','0','0');
INSERT INTO `qb_upfile` VALUES ('98','0','0','0','1','1461651412','7.jpg','1_20160426140452_lumr6.jpg','0','0');
INSERT INTO `qb_upfile` VALUES ('99','0','0','0','1','1461651469','8.jpg','1_20160426140449_cxnsp.jpg','0','0');
INSERT INTO `qb_upfile` VALUES ('100','0','0','0','1','1461651795','mp47017443_1449537744593_9.jpg','1_20160426140415_p939h.jpg','0','0');
INSERT INTO `qb_upfile` VALUES ('101','0','0','0','1','1461652464','5.jpg','1_20160426140424_unkr3.jpg','0','0');
INSERT INTO `qb_upfile` VALUES ('102','0','0','0','1','1461653093','mp47017443_1449537744593_9.jpg','1_20160426140453_authm.jpg','0','0');
INSERT INTO `qb_upfile` VALUES ('103','0','0','0','1','1461657365','2dc_1_20151105211113_wpi74.jpg','1_20160426150405_3qizy.jpg','0','0');
INSERT INTO `qb_upfile` VALUES ('104','0','0','0','1','1461722887','1.jpg','1_20160427100407_0j4ke.jpg','0','0');
INSERT INTO `qb_upfile` VALUES ('105','0','0','0','1','1461722971','2.jpg','1_20160427100431_5gdmc.jpg','0','0');
INSERT INTO `qb_upfile` VALUES ('106','0','0','0','1','1461723020','3.jpg','1_20160427100420_wt4tz.jpg','0','0');
INSERT INTO `qb_upfile` VALUES ('107','0','0','0','1','1461723076','4.jpg','1_20160427100416_obzpj.jpg','0','0');
INSERT INTO `qb_upfile` VALUES ('108','0','0','0','1','1461723136','5.jpg','1_20160427100416_zewyy.jpg','0','0');
INSERT INTO `qb_upfile` VALUES ('109','0','0','0','1','1461723230','6.jpg','1_20160427100450_xxpqs.jpg','0','0');
INSERT INTO `qb_upfile` VALUES ('110','0','0','0','1','1461723337','7.jpg','1_20160427100437_7ehir.jpg','0','0');
INSERT INTO `qb_upfile` VALUES ('111','0','0','0','1','1461723408','8.jpg','1_20160427100448_n0lt7.jpg','0','0');
INSERT INTO `qb_upfile` VALUES ('112','0','0','0','1','1461723458','9.jpg','1_20160427100438_cyuln.jpg','0','0');
INSERT INTO `qb_upfile` VALUES ('113','0','0','0','1','1461723503','10.jpg','1_20160427100423_wqi2y.jpg','0','0');
INSERT INTO `qb_upfile` VALUES ('114','0','0','0','1','1461723583','11.jpg','1_20160427100443_dhlj5.jpg','0','0');
INSERT INTO `qb_upfile` VALUES ('126','0','0','0','1','1463727410','0.jpg','1_20160520140550_lhpaz.jpg','0','0');
INSERT INTO `qb_upfile` VALUES ('116','0','0','0','1','1462863342','2.jpg','1_20160510140542_1zzdj.jpg','0','0');
INSERT INTO `qb_upfile` VALUES ('117','0','0','0','1','1462863497','3.jpg','1_20160510140517_leuej.jpg','0','0');
INSERT INTO `qb_upfile` VALUES ('118','0','0','0','1','1462863502','4.jpg','1_20160510140522_rrkpc.jpg','0','0');
INSERT INTO `qb_upfile` VALUES ('119','0','0','0','1','1463726180','QQͼ20160520143454.jpg','1_20160520140520_b87sl.jpg','0','0');
INSERT INTO `qb_upfile` VALUES ('120','0','0','0','1','1463726295','7.jpg','1_20160520140515_ev4nb.jpg','0','0');
INSERT INTO `qb_upfile` VALUES ('121','0','0','0','1','1463726532','3.jpg','1_20160520140512_zwphr.jpg','0','0');
INSERT INTO `qb_upfile` VALUES ('122','0','0','0','1','1463726667','2.jpg','1_20160520140527_6fbea.jpg','0','0');
INSERT INTO `qb_upfile` VALUES ('123','0','0','0','1','1463727030','0.jpg','1_20160520140530_ohbzo.jpg','0','0');
INSERT INTO `qb_upfile` VALUES ('124','0','0','0','1','1463727137','δ-2.jpg','1_20160520140517_q5psj.jpg','0','0');
INSERT INTO `qb_upfile` VALUES ('125','0','0','0','1','1463727294','0.jpg','1_20160520140555_golnj.jpg','0','0');
INSERT INTO `qb_upfile` VALUES ('127','0','0','0','1','1463727441','0.jpg','1_20160520140521_eyqsi.jpg','0','0');
INSERT INTO `qb_upfile` VALUES ('128','0','0','0','1','1463727467','0.jpg','1_20160520140547_v8vai.jpg','0','0');
INSERT INTO `qb_upfile` VALUES ('129','0','0','0','1','1463727493','0.jpg','1_20160520140513_l6fr1.jpg','0','0');
INSERT INTO `qb_upfile` VALUES ('132','0','0','0','1','1463727890','2.jpg','1_20160520150550_xzgwg.jpg','0','0');
INSERT INTO `qb_upfile` VALUES ('131','0','0','0','1','1463727861','1.jpg','1_20160520150521_ozyhu.jpg','0','0');
INSERT INTO `qb_upfile` VALUES ('133','0','0','0','1','1465985513','2707401_213321144000_2.jpg','1_20160615180653_syezn.jpg','0','0');
INSERT INTO `qb_upfile` VALUES ('139','0','0','0','1','1466130804','12.jpg','1_20160617100624_l1mhr.jpg','0','0');
INSERT INTO `qb_upfile` VALUES ('138','0','0','0','1','1466130758','12.jpg','1_20160617100638_xlyit.jpg','0','0');
INSERT INTO `qb_upfile` VALUES ('140','0','0','0','1','1466579435','2114732_212656094202_2.jpg','1_20160622150635_boapa.jpg','0','0');
INSERT INTO `qb_upfile` VALUES ('141','0','0','0','1','1466653299','219049-12092915361321.jpg','1_20160623110639_fk3jx.jpg','0','0');
INSERT INTO `qb_upfile` VALUES ('142','0','0','0','1','1467258399','2.1.png','1_20160630110639_2obj6.png','0','0');
INSERT INTO `qb_upfile` VALUES ('143','0','0','0','1','1467258841','2.1.png','1_20160630110601_kj2yz.png','0','0');
INSERT INTO `qb_upfile` VALUES ('144','0','0','0','1','1467258995','2.1.png','1_20160630110635_vvanv.png','0','0');
INSERT INTO `qb_upfile` VALUES ('147','0','0','0','1','1481765899','a.jpg','1_20161215091219_xxacw.jpg','0','0');
INSERT INTO `qb_upfile` VALUES ('148','0','0','0','31','1482129667','a.jpg','31_20161219141207_rvgml.jpg','0','0');
INSERT INTO `qb_upfile` VALUES ('149','0','0','0','1','1484617393','̨޸.png','1_20170117090113_3tyxy.png','0','0');
INSERT INTO `qb_upfile` VALUES ('154','0','0','0','1','1486610692','LOGO-blue.gif','1_20170209110252_rs8jy.gif','0','0');
INSERT INTO `qb_upfile` VALUES ('155','0','0','0','1','1486610706','LOGO-blue.gif','1_20170209110206_cqn0m.gif','0','0');
INSERT INTO `qb_upfile` VALUES ('156','0','0','0','1','1486610782','LOGO-blue.gif','1_20170209110222_761ue.gif','0','0');
INSERT INTO `qb_upfile` VALUES ('157','0','0','0','1','1486610810','LOGO-blue.gif','1_20170209110250_cj9wz.gif','0','0');
INSERT INTO `qb_upfile` VALUES ('158','0','0','0','1','1486610814','LOGO-link.gif','1_20170209110254_pg4w7.gif','0','0');
INSERT INTO `qb_upfile` VALUES ('159','0','0','0','1','1486610819','LOGO-link.gif','1_20170209110259_uy0hl.gif','0','0');
INSERT INTO `qb_upfile` VALUES ('160','0','0','0','1','1486610857','LOGO-link.gif','1_20170209110237_yf7q5.gif','0','0');
INSERT INTO `qb_upfile` VALUES ('161','0','0','0','1','1486610885','LOGO-link.gif','1_20170209110206_pldsa.gif','0','0');
INSERT INTO `qb_upfile` VALUES ('162','0','0','0','1','1486611087','LOGO-link.gif','1_20170209110227_zgwdy.gif','0','0');
INSERT INTO `qb_upfile` VALUES ('180','0','0','0','1','1490344011','9.jpg','1_20170324160351_ksrf0.jpg','0','0');
INSERT INTO `qb_upfile` VALUES ('183','0','0','0','1','1494643055','1f8e0001620356c9d352.jpg','1_20170513100535_hv8q4.jpg','0','0');
INSERT INTO `qb_upfile` VALUES ('184','0','0','0','1','1494643196','19f30004504acd7acd5b.jpg','1_20170513100556_qkigh.jpg','0','0');
INSERT INTO `qb_upfile` VALUES ('185','0','0','0','1','1494643425','1dcb00226a4d7bda1393.jpg','1_20170513100545_pfowb.jpg','0','0');
INSERT INTO `qb_upfile` VALUES ('186','0','0','0','1','1494643550','QQͼ20170513104535.jpg','1_20170513100550_rdqnu.jpg','0','0');
INSERT INTO `qb_upfile` VALUES ('187','0','0','0','1','1494643869','1f89000327d264622454.jpg','1_20170513100509_icto0.jpg','0','0');
INSERT INTO `qb_upfile` VALUES ('188','0','0','0','1','1494643926','1f8c00013c287610dbb2.jpg','1_20170513100506_w3ytf.jpg','0','0');
INSERT INTO `qb_vote_element` VALUES ('37','6','','4','10','','','');
INSERT INTO `qb_vote_element` VALUES ('38','6','','4','7','','','');
INSERT INTO `qb_vote_element` VALUES ('39','6','','2','5','','','');
INSERT INTO `qb_vote_element` VALUES ('41','6','','6','6','','','');
INSERT INTO `qb_vote_element` VALUES ('81','11','Աϲ','0','4','vote/1_20090418220434_DSazk.jpg','','http://www.admin5.com/article/20081231/124093.shtml');
INSERT INTO `qb_vote_element` VALUES ('80','11','Chinaz֮CNIDC','0','9','vote/1_20090419090435_51j39.jpg','','http://www.admin5.com/article/20081231/124093.shtml');
INSERT INTO `qb_vote_element` VALUES ('68','6','','12','9','','','');
INSERT INTO `qb_vote_element` VALUES ('70','10','ٶȷ˿','6','0','vote/1_20090317160304_1cyPh.gif','ǰٶȷ˿','http://www.baidu.com');
INSERT INTO `qb_vote_element` VALUES ('71','10','ȸ˿','1','0','vote/1_20090317160317_NO50S.gif','ǹȸ˿','http://www.google.cn');
INSERT INTO `qb_vote_element` VALUES ('72','11','SNS','1','8','vote/1_20090419090425_nkqeB.jpg','','http://www.admin5.com/article/20081231/124093.shtml');
INSERT INTO `qb_vote_element` VALUES ('73','11','CNײ˵','4','10','vote/1_20090419090455_L5Iz8.jpg','','http://www.admin5.com/article/20081231/124093.shtml');
INSERT INTO `qb_vote_element` VALUES ('74','11','ž','1','3','vote/1_20090419090414_BVe9o.jpg','','http://www.admin5.com/article/20081231/124093.shtml');
INSERT INTO `qb_vote_element` VALUES ('75','11','ѻ԰','3','6','vote/1_20090419090445_qQiaW.jpg','','http://www.admin5.com/article/20081231/124093.shtml');
INSERT INTO `qb_vote_element` VALUES ('76','11','ȫվ','2','5','vote/1_20090419090445_QVf6M.jpg','','http://www.admin5.com/article/20081231/124093.shtml');
INSERT INTO `qb_vote_element` VALUES ('77','11','','0','7','vote/1_20090419090459_1MkWx.jpg','','http://bbs.chinaz.com/Shuiba/thread-1240750-1-1.html');
INSERT INTO `qb_vote_comment` VALUES ('11','10','0','1','admin','1237279209','rrrrrrrrrrrrrrr','192.168.0.99','0','1');
INSERT INTO `qb_vote_comment` VALUES ('12','10','0','1','admin','1237279223','dddddddddddddddd','192.168.0.99','0','1');
INSERT INTO `qb_vote_comment` VALUES ('14','6','0','1','admin','1239025849','&nbsp;֤&nbsp;:','127.0.0.1','0','1');
INSERT INTO `qb_vote_comment` VALUES ('22','6','0','1','admin','1283825218','fdsadf','127.0.0.1','0','1');
INSERT INTO `qb_vote_comment` VALUES ('19','11','0','1','admin','1240210890','ѽ','192.168.0.99','0','1');
INSERT INTO `qb_vote_comment` VALUES ('20','11','0','1','admin','1255082863','fdsa','127.0.0.1','0','1');
INSERT INTO `qb_vote_comment` VALUES ('21','11','0','1','admin','1283823884','ll','127.0.0.1','0','1');
INSERT INTO `qb_vote_topic` VALUES ('6','Щǰֵ֧','Щǰֺ֧Ӱ쵽ģ','2','600','0','','1164793927','','1233749543','1265256743','0','1','<div class=\"voteid\" title=\"$describes\">{$button}{$title}({$votenum})</div>','0','0','0');
INSERT INTO `qb_vote_topic` VALUES ('11','2008йվʮ¼ͶƱ','-------Ϊ2008ŵվ¼ͶһƱ.','2','30','0','','1237281523','','1233749543','1580789543','0','1','<table width=\"100%\" border=\"0\" cellspacing=\"0\" cellpadding=\"0\" style=\"width:118px;float:left;margin-top:4px;\" class=\"voteid\">\r\n  <tr> \r\n    <td align=\"center\"><A HREF=\"$url\" target=\"_blank\" style=\"border:1px solid #ccc;display:block;width:100px;height:75px;\"><img alt=\"{$title}\" style=\"border:1px solid #fff;\" src=\"$img\" border=\"0\" width=\"100\" height=\"75\"></A></td>\r\n  </tr>\r\n  <tr> \r\n    <td align=\"center\">\r\n      <div  style=\"width:110px;overflow:hidden;text-overflow:ellipsis;white-space:nowrap;\">{$button}(<b><font color=\"#FF0000\" >{$votenum}</font></b>)<a HREF=\"$url\" target=\"_blank\" title=\"{$title}\">{$title}</a></div>\r\n    </td>\r\n  </tr>\r\n  <tr> \r\n    <td>{$describes}</td>\r\n  </tr>\r\n  <tr> \r\n    <td></td>\r\n  </tr>\r\n</table>\r\n\r\n','1','0','0');
INSERT INTO `qb_vote_topic` VALUES ('10','ĸ?','ϲʹĸ,ͶһƱ?','1','15','0','','1237275830','','0','0','0','1','<table width=\"100%\" border=\"0\" cellspacing=\"0\" cellpadding=\"0\" style=\"width:90px;float:left;\">\r\n  <tr> \r\n    <td align=\"center\" valign=\"middle\" style=\"line-height:40px;\"> <a href=\"$url\" target=_blank> \r\n      <b>$title</b></a> </td>\r\n  </tr>\r\n  <tr> \r\n    <td align=\"center\"><a href=\"$url\" target=\"_blank\"><img alt=\"$describes\" src=\"$img\" width=\"80\" height=\"30\" border=\"0\"></a></td>\r\n  </tr>\r\n  <tr> \r\n    <td align=\"center\" style=\"line-height:20px;\"> <font color=\"#990000\"> <b><font color=\"#FF0000\">$votenum</font> Ʊ \r\n      </b></font></td>\r\n  </tr>\r\n  <tr> \r\n    <td align=\"center\" style=\"line-height:40px;\"><a href=\"$webdb[www_url]/do/vote.php?action=vote&voteId=$id\" target=\"_blank\"><u>ͶһƱ</u></a> \r\n      <a href=\"$webdb[www_url]/do/vote.php?job=show&cid=$cid#postcomment\" target=\"_blank\"><u>һ</u></a></td>\r\n  </tr>\r\n</table>','2','0','0');
INSERT INTO `qb_vote_config` VALUES ('module_id','23','');
INSERT INTO `qb_vote_config` VALUES ('Info_webOpen','1','');
INSERT INTO `qb_vote_config` VALUES ('Info_webname','ͶƱϵͳ','');
INSERT INTO `qb_vote_config` VALUES ('module_pre','vote_','');
INSERT INTO `qb_area` VALUES ('1','0','ֱϽ','1','0','0','','0','0','','','','','','','0','','','1','','','','','0','','','0');
INSERT INTO `qb_area` VALUES ('2','0','㶫','1','0','0','','0','0','','','','','','','0','','','1','','','','','0','','','0');
INSERT INTO `qb_area` VALUES ('3','0','㽭','1','0','0','','0','0','','','','','','','0','','','1','','','','','0','','','0');
INSERT INTO `qb_area` VALUES ('4','0','','1','0','0','','0','0','','','','','','','0','','','1','','','','','0','','','0');
INSERT INTO `qb_area` VALUES ('5','0','','1','0','0','','0','0','','','','','','','0','','','1','','','','','0','','','0');
INSERT INTO `qb_area` VALUES ('6','0','','1','0','0','','0','0','','','','','','','0','','','1','','','','','0','','','0');
INSERT INTO `qb_area` VALUES ('7','0','','1','0','0','','0','0','','','','','','','0','','','1','','','','','0','','','0');
INSERT INTO `qb_area` VALUES ('8','0','','1','0','0','','0','0','','','','','','','0','','','1','','','','','0','','','0');
INSERT INTO `qb_area` VALUES ('9','0','','1','0','0','','0','0','','','','','','','0','','','1','','','','','0','','','0');
INSERT INTO `qb_area` VALUES ('10','0','ӱ','1','0','0','','0','0','','','','','','','0','','','1','','','','','0','','','0');
INSERT INTO `qb_area` VALUES ('11','0','','1','0','0','','0','0','','','','','','','0','','','1','','','','','0','','','0');
INSERT INTO `qb_area` VALUES ('12','0','','1','0','0','','0','0','','','','','','','0','','','1','','','','','0','','','0');
INSERT INTO `qb_area` VALUES ('13','0','','1','0','0','','0','0','','','','','','','0','','','1','','','','','0','','','0');
INSERT INTO `qb_area` VALUES ('14','0','','1','0','0','','0','0','','','','','','','0','','','1','','','','','0','','','0');
INSERT INTO `qb_area` VALUES ('15','0','','1','0','0','','0','0','','','','','','','0','','','1','','','','','0','','','0');
INSERT INTO `qb_area` VALUES ('16','0','','1','0','0','','0','0','','','','','','','0','','','1','','','','','0','','','0');
INSERT INTO `qb_area` VALUES ('17','0','','1','0','0','','0','0','','','','','','','0','','','1','','','','','0','','','0');
INSERT INTO `qb_area` VALUES ('18','0','','1','0','0','','0','0','','','','','','','0','','','1','','','','','0','','','0');
INSERT INTO `qb_area` VALUES ('19','0','ɹ','1','0','0','','0','0','','','','','','','0','','','1','','','','','0','','','0');
INSERT INTO `qb_area` VALUES ('20','0','','1','0','0','','0','0','','','','','','','0','','','1','','','','','0','','','0');
INSERT INTO `qb_area` VALUES ('21','0','ຣ','1','0','0','','0','0','','','','','','','0','','','1','','','','','0','','','0');
INSERT INTO `qb_area` VALUES ('22','0','ɽ','1','0','0','','0','0','','','','','','','0','','','1','','','','','0','','','0');
INSERT INTO `qb_area` VALUES ('23','0','ɽ','1','0','0','','0','0','','','','','','','0','','','1','','','','','0','','','0');
INSERT INTO `qb_area` VALUES ('24','0','','1','0','0','','0','0','','','','','','','0','','','1','','','','','0','','','0');
INSERT INTO `qb_area` VALUES ('25','0','Ĵ','1','0','0','','0','0','','','','','','','0','','','1','','','','','0','','','0');
INSERT INTO `qb_area` VALUES ('26','0','','1','0','0','','0','0','','','','','','','0','','','1','','','','','0','','','0');
INSERT INTO `qb_area` VALUES ('27','0','½','1','0','0','','0','0','','','','','','','0','','','1','','','','','0','','','0');
INSERT INTO `qb_area` VALUES ('28','0','','1','0','0','','0','0','','','','','','','0','','','1','','','','','0','','','0');
INSERT INTO `qb_jfabout` VALUES ('5','1','ûעɵ{$webdb[regmoney]}','','0');
INSERT INTO `qb_jfabout` VALUES ('8','2','±Ϊɵ{$webdb[comArticleMoney]}','','0');
INSERT INTO `qb_jfabout` VALUES ('9','1','ÿ㿨ɶһ{$webdb[MoneyRatio]},㿨ֵͨ߳.','','0');
INSERT INTO `qb_jfsort` VALUES ('1','Ա','0');
INSERT INTO `qb_jfsort` VALUES ('2','','0');
INSERT INTO `qb_moneycard` VALUES ('4','727','3','3','1','1','admin','1385371615');
INSERT INTO `qb_moneycard` VALUES ('5','145','3','3','1','1','admin','1385371692');
INSERT INTO `qb_moneycard` VALUES ('6','145','6','6','1','1','admin','1385371767');
INSERT INTO `qb_propagandize` VALUES ('1','0','1','2130706433','257','1347595930','');
INSERT INTO `qb_template` VALUES ('5','ͷװ','7','template/default/none.htm','','0');
INSERT INTO `qb_template` VALUES ('6','ײװ','8','template/default/none.htm','','0');
INSERT INTO `qb_template` VALUES ('23','бҳ(խ)','2','template/default/list.htm','','0');
INSERT INTO `qb_template` VALUES ('22','ҳ(խ)','3','template/default/bencandy.htm','','0');
INSERT INTO `qb_template` VALUES ('24','ҳ(խ)','1','template/default/index.htm','','0');
INSERT INTO `qb_template` VALUES ('20','ҳ()','3','template/default/bencandy_tpl_2.htm','','0');
INSERT INTO `qb_template` VALUES ('21','ҳ','9','template/default/alonepage.htm','','0');
INSERT INTO `qb_template` VALUES ('25','רģһ(ͷҪװ)','11','template/special/showsp2.htm','','0');
INSERT INTO `qb_template` VALUES ('26','רģ(ͷҪװ)','11','template/special/special_sport.htm','','0');
INSERT INTO `qb_template` VALUES ('27','רģ(ͷҪװ)','11','template/special/special_car.htm','','0');
INSERT INTO `qb_template` VALUES ('28','רģ(ͷҪװ)','11','template/special/special_finance.htm','','0');
INSERT INTO `qb_template` VALUES ('29','רģ(ͷҪװ)','11','template/special/sp1.htm','','0');
INSERT INTO `qb_crontab` VALUES ('2','ݿ','0','0300','0','1292489459','inc/crontab/mysqlbak.php','','1');
INSERT INTO `qb_crontab` VALUES ('4','ո','0','','1296504125','0','inc/crontab/delete_table_upfile.php','','1');
INSERT INTO `qb_yzimg` VALUES ('wmx3zxzu','Ud3Y','1490432148');
INSERT INTO `qb_yzimg` VALUES ('4zf91n46','6c0t','1494656116');
INSERT INTO `qb_article_pic` VALUES ('1','884','34','0','1','0','artic_img/34/1_20170513100535_hv8q4.jpg','');
INSERT INTO `qb_article_pic` VALUES ('2','885','34','0','1','0','artic_img/34/1_20170513100556_qkigh.jpg','');
INSERT INTO `qb_article_pic` VALUES ('3','886','4','0','1','0','artic_img/4/1_20170513100545_pfowb.jpg','');
INSERT INTO `qb_article_pic` VALUES ('4','550','32','0','1','0','artic_img/32/1_20170513100550_rdqnu.jpg','');
INSERT INTO `qb_city` VALUES ('1','1','','0','0','0','','0','0','','','','','|||','','0','','','0','','','','','0','','1','B','','','','');
INSERT INTO `qb_hy_company` VALUES ('17','ЭƼ޹˾','',',ţŹ,,KTV,,񷿲,ѵ','1','admin','2','0','0','1282284007','0','0','homepage/imgs/1/1_20170209110227_zgwdy.gif','','1','','1282284007','3315','1','1282719160','1487902492','<p> &nbsp; <strong> </strong><strong>벩CMS</strong>йȵĿԴCMSƽ̨ṩ̣רעڻƽ̨з˾Ա70%ΪԱӵйרҵWebӦƽ̨зŶӣ벩CMSӵй㷺ӰΪӦ㷺ϵͳ֮һҲйϷPHPĿԴϵͳṩ<br /><br /><a style=\"font-weight:bold;font-size:14px;color:#990000\">չ</a><br /> &nbsp; &nbsp;200310벩CMS V1.0γվVϵкý屨ŻSharpϵУSϵУSϵǧ򼶺Ӧý屨վȺӦγõƷƿڱԡ+ϵͳ+ģ+ܹϵΪڸܡģ黯ĿԴPHPϵͳ漰ýŻҵϢվȺϵͳB2BҵڲOAȺݸ߶˻ӦãΪʮûṩӦƽ̨</p>','1','1','0','0','徭Ӫ','','100','2007-10-02','㶫ʡ','зخ˴403ų','','CMSվ  طŻ Ϣϵͳ','PHP˲','еҵ豸','','ܲ','0','02028998648','15920222222','0106665555','0342@fdsg.cn','','65284322','765','','ѻƷ','','0','1','company/renzheng/1_20101016111001_krbfo.jpg','company/renzheng/1_20101016111026_ienzi.jpg','company/renzheng/1_20101016111030_dbedh.jpg','company/renzheng/1_20101016111032_g2s7m.jpg','company/renzheng/1_20101016111035_nlvue.jpg','106.522073,29.624917','4','1481164094','default','default','0','0','0','homepage/imgs/1/1_20170209110250_cj9wz.gif','homepage/imgs/1/1_20170209110259_uy0hl.gif');
INSERT INTO `qb_hy_company` VALUES ('22','жʵҵ˾','',',,,ۺг,ѵ','27','test1','0','0','0','1288661741','0','0','homepage/logo/1/27_20101102091141_e1uuj.jpg','','1','','1288661741','64','1','1288663982','1484726717','    ˾1992꣬ռ5000ƽף8900ƽףԸӻеľģͼΪ,жͼĻеӹӲʺϽ𹤾ߵǥ   ӦеĦ䣩ͼص𹤾ߡǥӲʺϽ𹤾ߡ泵ߡGּСĦгּͼ','0','1','1','1','徭Ӫ','','999','2010-11-03','㶫ʡ','','','ֲ','','еҵ豸','','','0','020555444','','','gfds@afds.cn','','','','','','','0','1','','','','','','39.88880517803271,116.4656920374756','0','0','style1','education','0','0','0','','');
INSERT INTO `qb_hy_company` VALUES ('23','۴Ϫ𹤾߳','',',,,񷿲,ѵ','28','test2','0','0','0','1288662180','0','0','homepage/logo/1/logo_28_20101102091100_6jeu7.jpg','','1','','1288662180','27','1','1288663984','1484987016','    һӵʮʷרҵ԰ֹߵƬϵ֦Ƭĳ   ƼͨԱĿ̿๥أֿȽˮƽĸӲȣԵϵвƷ˹ڵƬûӲȣӲûԵļ֣˵Ƭʹ õ̵ܶ׿ϣֱӳŷ޺  ƷɽϵƷȫ߲Ʒһӹܵõ󻯡ֽ߳磬ǽڴĹ١','0','1','14','0','徭Ӫ','','900','2010-11-13','','','','','','еҵ豸','ţ','','0','0205544447','','','fds@ds.cn','','','','','','','0','1','','','','','','39.87655466879821,116.39410924328615','0','0','style2','education_3','0','0','0','','');
INSERT INTO `qb_hy_company` VALUES ('24','Ͼֽģ޹˾','',',,,񷿲,ѵ','29','test3','0','0','0','1288662327','0','0','homepage/logo/1/29_20101102091127_bcl6e.jpg','','1','','1288662327','30','1','1288663984','1482130732','   Ͼֽģ޹˾йװ¼˾齨ɣ°˾ֽģܼо豸졢Ʒƹרҵ˾жʸ񡢿ơóһ廯͹ɷҵ   ˾ΧֽģܼмģġеӹƷʾ̰װȲţֽܼרҵ̼Առ35%߼ʦ3(һֽģܷ⹱סܹԺ䷢֤)ʦ8ˣۺʩȫжĿоʾ۵ľʵ塣ѹ˾˰˾˲ţȫ̳Соȫ濪ֽģܼˣֽģ򱣳˼ȫ桢豸ȽƷȫƣ','0','1','9','0','徭Ӫ','','600','2010-11-06','Ϻ','','','Ļǽ','','еҵ豸','','','0','0204448554','','','fdsg@sda.cn','','','','','','','0','1','','','','','','39.899999965538825,116.44955586804201','0','0','style3','education_4','0','0','0','','');
INSERT INTO `qb_hy_company` VALUES ('25','Ϻ޹˾','',',ţŹ,,KTV,,񷿲,ѵ','30','test4','0','0','0','1288662567','0','0','homepage/logo/1/30_20101102091127_ibn2r.jpg','','1','','1288662567','26','1','1288663985','1487065125','    㽭˫޹˾йרҵϵвƷͷҵ㽭ʡAAAغͬҵ㽭ʡ¼ҵISO9001QS9000ϵ֤λ ˾һ֧ǿ²ƷзƵʩΪ㽭ʡġƷ50%ϳڵ¹ձ¼¡ǫ̂20Һ͵ ѾõĹ   ˾ĿǰҪƷУSFϵСJF˫СFBͭСJDBǶе12ϵ16000Ʒ֣Ӧ¡ٵȸֳϵʹá˾Ƶļ豸֤100%ĺϸƷṩ˿ͣÿλZOB','0','1','1','12','徭Ӫ','','600','2010-11-04','Ϻ','','','','','еҵ豸','','','0','02054477877','','','fds@sda.cn','','','','','','','0','1','','','','','','39.90065842550712,116.39719914807131','0','0','style3','entertainment','0','0','0','','');
INSERT INTO `qb_hy_company` VALUES ('26','޹˾','',',ţŹ,,,񷿲','31','test5','0','0','0','1288662786','0','0','homepage/logo/1/31_20101102091106_ijzou.jpg','','1','','1288662786','25','1','1288663985','1487230179','    ˾רҵ𡢻ܽƷ̼ȲƷĳҵй翪DIYϵвƷ֪ҵҵʼռЧ֮·ǿȫЧӪעҵͲƷ󣬲ƷԶأùͻڷ׷ӵгУʼռسšڴ¡  ˾չгչƣ졢𡢱׼Ǳ׼̼ܽƷȲƷΪг飬DIYװγ30ϵн1000Ʒ֣ƾϸͳڵƷڹгŷгγõͷгռ','0','1','1','1','徭Ӫ','','300','2010-11-06','','','','','Ҳ','еҵ豸','','','0','0204544744','','','fds@fsa.cn','','','','','','','0','1','','','','','','39.89947319300862,116.42998647106936','0','0','style4','entertainment_2','0','0','0','','');
INSERT INTO `qb_hy_company` VALUES ('27','綯߳','',',,,񷿲,ѵ','32','test6','0','0','0','1288662947','0','0','homepage/logo/1/32_20101102091147_9pqhn.jpg','','1','','1288662947','23','1','1288663986','1482129783','<p>&nbsp;&nbsp;㽭˫޹˾йרҵϵвƷͷҵ㽭ʡAAAغͬҵ㽭ʡ¼ҵISO9001QS9000ϵ֤λ&nbsp;˾һ֧ǿ²ƷзƵʩΪ㽭ʡġƷ50%ϳڵ¹ձ¼¡ǫ̂20Һ͵&nbsp;ѾõĹ&nbsp;&nbsp;&nbsp;˾ĿǰҪƷУSFϵСJF˫СFBͭСJDBǶе12ϵ16000Ʒ֣Ӧ¡ٵȸֳϵʹá˾Ƶļ豸֤100%ĺϸƷṩ˿ͣÿλZOBĹ˿⡣&nbsp;&nbsp;&nbsp;ϸ&nbsp;ISO-TS16949&nbsp;ϵԭͶ롢ģ졢Ρսᡭֱȫ̼ԿơȽԼ죬רְԱѲؼ죬ÿ򶼽ϸѹأÿоݿɲ顣ͬʱȽļ豸֤˲Ʒ100%ĳϸʣ</p>','0','1','2','0','徭Ӫ','','300','2010-11-04','','','','','ֻ','еҵ豸','','','0','020544777','','','fda@dsa.cn','','','','','','','0','1','','','','','','39.93436312005218,116.36115025891115','0','0','style2','food_5','0','0','0','','');
INSERT INTO `qb_hy_company` VALUES ('28','ͼƼڣ޹˾','',',,,񷿲,ѵ','33','test7','0','0','0','1288663129','0','0','homepage/logo/1/33_20101102091149_ofqqf.jpg','','1','','1288663129','25','1','1288663987','1482129946','   רҵһ廯ӡӡˢĲƿ̶ҵ˾жĽȨṩ˺ֱɵóƽ̨˾ӵ5000ƽ׵ִȫյ޳¡ʪ䡣豸ȫõԻԶơȽ̣֤˲Ʒ׿ԽƷʣ2003ͨISO9001-2000ϵ֤˾ʼѭԿͻΪƷȡʤԷȡķչֲƷרҵϸ»ľӪģ⡣ͨŬи׷󣬳ͻĸԻҪӮ˿ͻĳϿ϶ʹ˾Ϊ֪ͬȵĹӦ̡','0','1','1','3','徭Ӫ','','600','2010-11-13','','','','','','еҵ豸','','','0','02087744454','','','dfsafs@dsa.cn','','','','','','','0','1','','','','','','39.896312472789994,116.40337895764162','0','0','style3','food_5','0','0','0','','');
INSERT INTO `qb_hy_company` VALUES ('29','дʵҵչ޹˾','',',,,񷿲,ѵ','34','test8','0','0','0','1288663299','0','0','homepage/logo/1/34_20101102101139_apfdl.jpg','','1','','1288663299','32','1','1288663987','1482130053','    һҼƷơһ壬𡢵ɡѵзۣӵнھӪȨĸ߿ƼӪҵ˾ʵۺз죬ùȽĹģʽƷӲƣۺʡ ˾ӵг600ƽף̶ʲ500ԪԱ60ˣй̼Ա10ˣ۶500Ԫ˾ͨISO9001-2000ϵ֤ĿǰƹISO/TS16949-2002ϵСһ걸ĲƷ豸ͼԱ飬ȷƷȶɿûнϸߵ ','0','1','1','1','徭Ӫ','','100','','','','','','','еҵ豸','','','0','02054787741','','','fsgfd@dsa.cn','','','','','','','0','1','','','','','','39.87879417267252,116.39462422741701','0','0','style1','education_3','0','0','0','','');
INSERT INTO `qb_hy_company` VALUES ('30','ι˾','',',,,񷿲,ѵ','35','test9','0','0','0','1288663462','0','0','homepage/logo/1/35_20101102101122_jvufs.jpg','','1','','1288663462','108','1','1288663988','1482130089','    ι˾ش㽭ʡأϺ80ຼ65ڷ羰ϱ羰뻦ٹ·ڴ7ˮ½ͨʮֱ˾ȫԱʮĬĬ£ӵʲ300Ԫռ30000ƽףг20000ƽף豸120̨ףȫ豸ȽϵҪ豸250KGƵ¯3׼ģˮ10ּּȴ¯ӹ豸80̨ĿǰҵԱ130и๤̼Ա38','0','1','2','0','徭Ӫ','','300','2010-11-06','㽭ʡ','','','','','еҵ豸','','','0','02045789654','','','safsa@dfsa.cn','','','','','','','0','1','','','','','','39.898287940009965,116.43101643933107','0','0','style2','entertainment_2','0','0','0','','');
INSERT INTO `qb_hy_company` VALUES ('31','ݸл޹˾','',',,,񷿲,ѵ','36','test10','0','0','0','1288663617','0','0','homepage/logo/1/36_20101102101157_jugc3.jpg','','1','','1288663617','99','1','1288663988','1482130175','     һҼзۺͷһۺ͵ҵ˾λڹ㶫ʡݸлƽ򣬾ݸٹ·3ݸվ10ңͨʮֱݡ˾ռ2000ƽףӵȫһ豸ĿǰѡʮµCNCԶɻ߾С0.08MM-10MMǶݸ׼ӵп10mm߾CNCɻеɴʽػ¯ϴɼ豸ȫ磺ԪͶӰǡŤԻѹԻԻȣȫЧؿ˵ɵƷиྫܵɣí˿ѹƷ㷺ڵӡߡߡľߡͯгƷƷߡӡ칫豸豸ཻͨߵȡ˾ĵɲƷ磺ɡϵɡɡλɡ浯ɵ ҵ','0','1','1','3','徭Ӫ','','350','2010-11-04','ݸ','','','ֲ','','еҵ豸','','','0','02054484444','','','fsdafd@sa.cn','','','','','','','0','1','','','','','','39.91316796269466,116.37865971936037','2','1329964625','style4','default','0','0','0','','');
INSERT INTO `qb_hy_company` VALUES ('32','ݽҶƷ޹˾','',',,,񷿲,ѵ','37','test11','0','0','0','1288663816','0','0','homepage/logo/1/37_20101102101116_xmwaa.jpg','','1','','1288663816','264','1','1288663989','1487230173','    ǰݺ棩ɳרҵ桢浯ĳҡʮ꣬һһӡչ죬ӵгǧƽףȽĵɡ߼ѹ豸 ճȺˣƷоԱ ϸϵϸISO90012000ϵISO14000ϵ׼УƷͨй֤CFR1633׼ӢBS5852׼Ϊ缶ƷƲƷмʵ֤ĿǰҶ˾Ĵ桢оƷɾѹװؿ̵估ִƾ浯ɳصľ飬ȫƴ֮оԱоƣйĸ߶Ʒƴ桪ҶϵвƷ','0','1','1','2','徭Ӫ','','200','2010-11-04','','','','','','еҵ豸','','','0','0205447777','','','dfsaf@dsa.cn','','','','','','','0','1','','','','','','39.91659122736889,116.42792653454592','0','0','style1','education_4','0','0','0','','');
INSERT INTO `qb_hy_company_fid` VALUES ('1','11');
INSERT INTO `qb_hy_company_fid` VALUES ('1','12');
INSERT INTO `qb_hy_company_fid` VALUES ('1','21');
INSERT INTO `qb_hy_company_fid` VALUES ('1','22');
INSERT INTO `qb_hy_company_fid` VALUES ('1','33');
INSERT INTO `qb_hy_company_fid` VALUES ('1','46');
INSERT INTO `qb_hy_company_fid` VALUES ('1','59');
INSERT INTO `qb_hy_company_fid` VALUES ('27','11');
INSERT INTO `qb_hy_company_fid` VALUES ('27','21');
INSERT INTO `qb_hy_company_fid` VALUES ('27','33');
INSERT INTO `qb_hy_company_fid` VALUES ('27','48');
INSERT INTO `qb_hy_company_fid` VALUES ('27','59');
INSERT INTO `qb_hy_company_fid` VALUES ('28','11');
INSERT INTO `qb_hy_company_fid` VALUES ('28','21');
INSERT INTO `qb_hy_company_fid` VALUES ('28','33');
INSERT INTO `qb_hy_company_fid` VALUES ('28','46');
INSERT INTO `qb_hy_company_fid` VALUES ('28','59');
INSERT INTO `qb_hy_company_fid` VALUES ('29','11');
INSERT INTO `qb_hy_company_fid` VALUES ('29','21');
INSERT INTO `qb_hy_company_fid` VALUES ('29','33');
INSERT INTO `qb_hy_company_fid` VALUES ('29','46');
INSERT INTO `qb_hy_company_fid` VALUES ('29','59');
INSERT INTO `qb_hy_company_fid` VALUES ('30','11');
INSERT INTO `qb_hy_company_fid` VALUES ('30','12');
INSERT INTO `qb_hy_company_fid` VALUES ('30','21');
INSERT INTO `qb_hy_company_fid` VALUES ('30','22');
INSERT INTO `qb_hy_company_fid` VALUES ('30','33');
INSERT INTO `qb_hy_company_fid` VALUES ('30','46');
INSERT INTO `qb_hy_company_fid` VALUES ('30','59');
INSERT INTO `qb_hy_company_fid` VALUES ('31','11');
INSERT INTO `qb_hy_company_fid` VALUES ('31','12');
INSERT INTO `qb_hy_company_fid` VALUES ('31','21');
INSERT INTO `qb_hy_company_fid` VALUES ('31','33');
INSERT INTO `qb_hy_company_fid` VALUES ('31','46');
INSERT INTO `qb_hy_company_fid` VALUES ('32','11');
INSERT INTO `qb_hy_company_fid` VALUES ('32','21');
INSERT INTO `qb_hy_company_fid` VALUES ('32','33');
INSERT INTO `qb_hy_company_fid` VALUES ('32','46');
INSERT INTO `qb_hy_company_fid` VALUES ('32','59');
INSERT INTO `qb_hy_company_fid` VALUES ('33','11');
INSERT INTO `qb_hy_company_fid` VALUES ('33','21');
INSERT INTO `qb_hy_company_fid` VALUES ('33','33');
INSERT INTO `qb_hy_company_fid` VALUES ('33','46');
INSERT INTO `qb_hy_company_fid` VALUES ('33','59');
INSERT INTO `qb_hy_company_fid` VALUES ('34','11');
INSERT INTO `qb_hy_company_fid` VALUES ('34','21');
INSERT INTO `qb_hy_company_fid` VALUES ('34','33');
INSERT INTO `qb_hy_company_fid` VALUES ('34','46');
INSERT INTO `qb_hy_company_fid` VALUES ('34','59');
INSERT INTO `qb_hy_company_fid` VALUES ('35','11');
INSERT INTO `qb_hy_company_fid` VALUES ('35','21');
INSERT INTO `qb_hy_company_fid` VALUES ('35','33');
INSERT INTO `qb_hy_company_fid` VALUES ('35','46');
INSERT INTO `qb_hy_company_fid` VALUES ('35','59');
INSERT INTO `qb_hy_company_fid` VALUES ('36','11');
INSERT INTO `qb_hy_company_fid` VALUES ('36','21');
INSERT INTO `qb_hy_company_fid` VALUES ('36','33');
INSERT INTO `qb_hy_company_fid` VALUES ('36','46');
INSERT INTO `qb_hy_company_fid` VALUES ('36','59');
INSERT INTO `qb_hy_company_fid` VALUES ('37','11');
INSERT INTO `qb_hy_company_fid` VALUES ('37','21');
INSERT INTO `qb_hy_company_fid` VALUES ('37','33');
INSERT INTO `qb_hy_company_fid` VALUES ('37','46');
INSERT INTO `qb_hy_company_fid` VALUES ('37','59');
INSERT INTO `qb_hy_config` VALUES ('Info_webOpen','1','');
INSERT INTO `qb_hy_config` VALUES ('sort_layout','1,5#3,8,7#2,4,6#','');
INSERT INTO `qb_hy_config` VALUES ('module_id','16','');
INSERT INTO `qb_hy_config` VALUES ('gg_map_api','ABQIAAAAlNgPp05cAGeYiuhUaYZaQxT2hWcVQgqOjltVi_oi0-IXnv8sfRRB0xK-_hJ6X9fvCiWkheAw1gnL8Q','');
INSERT INTO `qb_hy_config` VALUES ('Private_tpl_head','','');
INSERT INTO `qb_hy_config` VALUES ('company_need_yz','0','');
INSERT INTO `qb_hy_config` VALUES ('IF_Private_tpl','0','');
INSERT INTO `qb_hy_config` VALUES ('vipselfdomaincannot','','');
INSERT INTO `qb_hy_config` VALUES ('vipselfdomain','','');
INSERT INTO `qb_hy_config` VALUES ('creat_home_money','0','');
INSERT INTO `qb_hy_config` VALUES ('module_pre','hy_','');
INSERT INTO `qb_hy_config` VALUES ('Index_listsortnum','3','');
INSERT INTO `qb_hy_config` VALUES ('module_close','1','');
INSERT INTO `qb_hy_config` VALUES ('SEO_description','','');
INSERT INTO `qb_hy_config` VALUES ('SEO_keywords','','');
INSERT INTO `qb_hy_config` VALUES ('SEO_title','','');
INSERT INTO `qb_hy_config` VALUES ('Info_webname','ҳģ','');
INSERT INTO `qb_hy_config` VALUES ('Private_tpl_foot','','');
INSERT INTO `qb_hy_dianping` VALUES ('3','1','0','1','0','1','admin','1290066331','̫!!','127.0.0.1','0','1','1','3','5','4','0','4','1','52','','','');
INSERT INTO `qb_hy_dianping` VALUES ('4','1','0','1','0','1','admin','1290495895','̼,ܽ!','127.0.0.1','0','1','1','1','2','4','2','3','2','23','','','');
INSERT INTO `qb_hy_dianping` VALUES ('5','36','0','36','0','1','admin','1329964258','fffffffffff','127.0.0.1','0','1','0','0','0','0','0','0','0','0','','','');
INSERT INTO `qb_hy_dianping` VALUES ('6','36','0','36','0','1','admin','1329964625','tttttttttttttt','127.0.0.1','0','1','2','4','4','4','3','0','0','55','','','');
INSERT INTO `qb_hy_dianping` VALUES ('7','1','0','1','0','1','admin','1337937037','fdafdsafds','127.0.0.1','0','1','0','0','0','0','2','2','1','3','','','');
INSERT INTO `qb_hy_dianping` VALUES ('8','1','0','0','0','1','admin','1481164094','gfdsgfds','127.0.0.1','0','1','4','4','4','4','4','1','0','0','','','');
INSERT INTO `qb_hy_guestbook` VALUES ('1','1','1','admin','127.0.0.1','fdsgfds','1','1340964772','1340964772');
INSERT INTO `qb_hy_guestbook` VALUES ('2','1','1','admin','127.0.0.1','6666666666','1','1341214722','1341214722');
INSERT INTO `qb_hy_home` VALUES ('1','admin','vip_1','base,tongji,ck,shopsort','r_photo,r_news,r_coupon,dping','a:7:{s:9:\"guestbook\";s:1:\"4\";s:7:\"visitor\";s:2:\"10\";s:8:\"newslist\";s:2:\"10\";s:10:\"friendlink\";s:2:\"10\";s:10:\"Mguestbook\";s:2:\"10\";s:8:\"Mvisitor\";s:2:\"40\";s:9:\"Mnewslist\";s:2:\"10\";}','homepage/banner/1_20160630110601_kj2yz.png	410	110','','0','0	192.168.0.100	1463564409\r\n0	192.168.0.107	1352447714\r\n0	192.168.2.5	1352364340\r\n32	test6	1341368596\r\n27	test1	1328780992\r\n9	fdsafsdw	1282633598','3077','a:18:{i:0;a:4:{s:5:\"title\";s:8:\"̼ҳ\";s:3:\"url\";s:1:\"?\";s:5:\"order\";s:2:\"10\";s:6:\"ifshow\";i:1;}i:1;a:4:{s:5:\"title\";s:8:\"̼ҽ\";s:3:\"url\";s:7:\"?m=info\";s:5:\"order\";s:1:\"9\";s:6:\"ifshow\";i:1;}i:2;a:4:{s:5:\"title\";s:8:\"̼\";s:3:\"url\";s:7:\"?m=news\";s:5:\"order\";s:1:\"8\";s:6:\"ifshow\";i:1;}i:11;a:4:{s:5:\"title\";s:8:\"̼ҲƷ\";s:3:\"url\";s:7:\"?m=shop\";s:5:\"order\";s:1:\"7\";s:6:\"ifshow\";i:1;}i:12;a:4:{s:5:\"title\";s:8:\"Ϣ\";s:3:\"url\";s:9:\"?m=coupon\";s:5:\"order\";s:1:\"5\";s:6:\"ifshow\";i:1;}i:13;a:4:{s:5:\"title\";s:8:\"ƸϢ\";s:3:\"url\";s:6:\"?m=job\";s:5:\"order\";s:1:\"4\";s:6:\"ifshow\";i:1;}i:14;a:4:{s:5:\"title\";s:8:\"˿͵\";s:3:\"url\";s:11:\"?m=dianping\";s:5:\"order\";s:1:\"2\";s:6:\"ifshow\";i:1;}i:4;a:4:{s:5:\"title\";s:8:\"ͼƬչʾ\";s:3:\"url\";s:7:\"?m=pics\";s:5:\"order\";s:1:\"2\";s:6:\"ifshow\";i:1;}i:20;a:4:{s:5:\"title\";s:8:\"̼Ź\";s:3:\"url\";s:8:\"?m=house\";s:5:\"order\";s:1:\"1\";s:6:\"ifshow\";i:0;}i:23;a:4:{s:5:\"title\";s:8:\"Ϣ\";s:3:\"url\";s:8:\"?m=2shou\";s:5:\"order\";s:1:\"1\";s:6:\"ifshow\";i:0;}i:22;a:4:{s:5:\"title\";s:8:\"̼ҵ\";s:3:\"url\";s:12:\"?m=dianpings\";s:5:\"order\";s:1:\"1\";s:6:\"ifshow\";i:0;}i:21;a:4:{s:5:\"title\";s:8:\"Ϣ\";s:3:\"url\";s:9:\"?m=shoptg\";s:5:\"order\";s:1:\"1\";s:6:\"ifshow\";i:0;}i:19;a:4:{s:5:\"title\";s:8:\"̼Ʒ\";s:3:\"url\";s:7:\"?m=gift\";s:5:\"order\";s:1:\"1\";s:6:\"ifshow\";i:0;}i:18;a:4:{s:5:\"title\";s:8:\"ۻ\";s:3:\"url\";s:5:\"?m=tg\";s:5:\"order\";s:1:\"1\";s:6:\"ifshow\";i:0;}i:15;a:4:{s:5:\"title\";s:6:\"ҳ\";s:3:\"url\";s:7:\"?m=page\";s:5:\"order\";s:1:\"1\";s:6:\"ifshow\";i:0;}i:17;a:4:{s:5:\"title\";s:8:\"ÿ\";s:3:\"url\";s:6:\"?m=msg\";s:5:\"order\";s:1:\"1\";s:6:\"ifshow\";i:0;}i:16;a:4:{s:5:\"title\";s:8:\"Ϣ\";s:3:\"url\";s:9:\"?m=fenlei\";s:5:\"order\";s:1:\"1\";s:6:\"ifshow\";i:0;}i:8;a:4:{s:5:\"title\";s:8:\"ϵʽ\";s:3:\"url\";s:12:\"?m=contactus\";s:5:\"order\";s:1:\"1\";s:6:\"ifshow\";i:1;}}','','','','','<p><br /></p>');
INSERT INTO `qb_hy_home` VALUES ('30','test4','vip_a4','base,tongji,ck','info,dping','a:7:{s:9:\"guestbook\";s:1:\"4\";s:7:\"visitor\";s:2:\"10\";s:8:\"newslist\";s:2:\"10\";s:10:\"friendlink\";s:2:\"10\";s:10:\"Mguestbook\";s:2:\"10\";s:8:\"Mvisitor\";s:2:\"40\";s:9:\"Mnewslist\";s:2:\"10\";}','','','0','0	192.168.0.100	1461836256\r\n32	test6	1341368589\r\n1	admin	1338887924','23','a:10:{i:0;a:4:{s:5:\"title\";s:8:\"̼ҳ\";s:3:\"url\";s:1:\"?\";s:5:\"order\";s:2:\"10\";s:6:\"ifshow\";i:1;}i:1;a:4:{s:5:\"title\";s:8:\"̼ҽ\";s:3:\"url\";s:7:\"?m=info\";s:5:\"order\";s:1:\"9\";s:6:\"ifshow\";i:1;}i:2;a:4:{s:5:\"title\";s:8:\"̼\";s:3:\"url\";s:7:\"?m=news\";s:5:\"order\";s:1:\"8\";s:6:\"ifshow\";i:1;}i:11;a:4:{s:5:\"title\";s:8:\"̼ҲƷ\";s:3:\"url\";s:7:\"?m=shop\";s:5:\"order\";s:1:\"7\";s:6:\"ifshow\";i:1;}i:12;a:4:{s:5:\"title\";s:8:\"Ϣ\";s:3:\"url\";s:9:\"?m=coupon\";s:5:\"order\";s:1:\"5\";s:6:\"ifshow\";i:1;}i:13;a:4:{s:5:\"title\";s:8:\"ƸϢ\";s:3:\"url\";s:6:\"?m=job\";s:5:\"order\";s:1:\"4\";s:6:\"ifshow\";i:1;}i:14;a:4:{s:5:\"title\";s:8:\"˿͵\";s:3:\"url\";s:11:\"?m=dianping\";s:5:\"order\";s:1:\"2\";s:6:\"ifshow\";i:1;}i:4;a:4:{s:5:\"title\";s:8:\"ͼƬչʾ\";s:3:\"url\";s:7:\"?m=pics\";s:5:\"order\";s:1:\"2\";s:6:\"ifshow\";i:1;}i:8;a:4:{s:5:\"title\";s:8:\"ϵʽ\";s:3:\"url\";s:12:\"?m=contactus\";s:5:\"order\";s:1:\"1\";s:6:\"ifshow\";i:1;}i:15;a:4:{s:5:\"title\";s:6:\"ҳ\";s:3:\"url\";s:7:\"?m=page\";s:5:\"order\";s:1:\"1\";s:6:\"ifshow\";i:0;}}','','','','','');
INSERT INTO `qb_hy_home` VALUES ('29','test3','vip_a3','base,tongji,ck','info,dping','a:7:{s:9:\"guestbook\";s:1:\"4\";s:7:\"visitor\";s:2:\"10\";s:8:\"newslist\";s:2:\"10\";s:10:\"friendlink\";s:2:\"10\";s:10:\"Mguestbook\";s:2:\"10\";s:8:\"Mvisitor\";s:2:\"40\";s:9:\"Mnewslist\";s:2:\"10\";}','','','0','0	192.168.0.129	1461901932\r\n0	192.168.0.100	1461827511\r\n0	192.168.0.107	1352451930\r\n1	admin	1341460147\r\n32	test6	1341368592','27','a:10:{i:0;a:4:{s:5:\"title\";s:8:\"̼ҳ\";s:3:\"url\";s:1:\"?\";s:5:\"order\";s:2:\"10\";s:6:\"ifshow\";i:1;}i:1;a:4:{s:5:\"title\";s:8:\"̼ҽ\";s:3:\"url\";s:7:\"?m=info\";s:5:\"order\";s:1:\"9\";s:6:\"ifshow\";i:1;}i:2;a:4:{s:5:\"title\";s:8:\"̼\";s:3:\"url\";s:7:\"?m=news\";s:5:\"order\";s:1:\"8\";s:6:\"ifshow\";i:1;}i:11;a:4:{s:5:\"title\";s:8:\"̼ҲƷ\";s:3:\"url\";s:7:\"?m=shop\";s:5:\"order\";s:1:\"7\";s:6:\"ifshow\";i:1;}i:12;a:4:{s:5:\"title\";s:8:\"Ϣ\";s:3:\"url\";s:9:\"?m=coupon\";s:5:\"order\";s:1:\"5\";s:6:\"ifshow\";i:1;}i:13;a:4:{s:5:\"title\";s:8:\"ƸϢ\";s:3:\"url\";s:6:\"?m=job\";s:5:\"order\";s:1:\"4\";s:6:\"ifshow\";i:1;}i:14;a:4:{s:5:\"title\";s:8:\"˿͵\";s:3:\"url\";s:11:\"?m=dianping\";s:5:\"order\";s:1:\"2\";s:6:\"ifshow\";i:1;}i:4;a:4:{s:5:\"title\";s:8:\"ͼƬչʾ\";s:3:\"url\";s:7:\"?m=pics\";s:5:\"order\";s:1:\"2\";s:6:\"ifshow\";i:1;}i:15;a:4:{s:5:\"title\";s:6:\"ҳ\";s:3:\"url\";s:7:\"?m=page\";s:5:\"order\";s:1:\"1\";s:6:\"ifshow\";i:0;}i:8;a:4:{s:5:\"title\";s:8:\"ϵʽ\";s:3:\"url\";s:12:\"?m=contactus\";s:5:\"order\";s:1:\"1\";s:6:\"ifshow\";i:1;}}','','','','','');
INSERT INTO `qb_hy_home` VALUES ('28','test2','vip_a2','base,tongji,ck','info,dping','a:7:{s:9:\"guestbook\";s:1:\"4\";s:7:\"visitor\";s:2:\"10\";s:8:\"newslist\";s:2:\"10\";s:10:\"friendlink\";s:2:\"10\";s:10:\"Mguestbook\";s:2:\"10\";s:8:\"Mvisitor\";s:2:\"40\";s:9:\"Mnewslist\";s:2:\"10\";}','','','0','0	192.168.0.100	1461827369\r\n1	admin	1365576097\r\n32	test6	1341368594','22','a:10:{i:0;a:4:{s:5:\"title\";s:8:\"̼ҳ\";s:3:\"url\";s:1:\"?\";s:5:\"order\";s:2:\"10\";s:6:\"ifshow\";i:1;}i:1;a:4:{s:5:\"title\";s:8:\"̼ҽ\";s:3:\"url\";s:7:\"?m=info\";s:5:\"order\";s:1:\"9\";s:6:\"ifshow\";i:1;}i:2;a:4:{s:5:\"title\";s:8:\"̼\";s:3:\"url\";s:7:\"?m=news\";s:5:\"order\";s:1:\"8\";s:6:\"ifshow\";i:1;}i:11;a:4:{s:5:\"title\";s:8:\"̼ҲƷ\";s:3:\"url\";s:7:\"?m=shop\";s:5:\"order\";s:1:\"7\";s:6:\"ifshow\";i:1;}i:12;a:4:{s:5:\"title\";s:8:\"Ϣ\";s:3:\"url\";s:9:\"?m=coupon\";s:5:\"order\";s:1:\"5\";s:6:\"ifshow\";i:1;}i:13;a:4:{s:5:\"title\";s:8:\"ƸϢ\";s:3:\"url\";s:6:\"?m=job\";s:5:\"order\";s:1:\"4\";s:6:\"ifshow\";i:1;}i:14;a:4:{s:5:\"title\";s:8:\"˿͵\";s:3:\"url\";s:11:\"?m=dianping\";s:5:\"order\";s:1:\"2\";s:6:\"ifshow\";i:1;}i:4;a:4:{s:5:\"title\";s:8:\"ͼƬչʾ\";s:3:\"url\";s:7:\"?m=pics\";s:5:\"order\";s:1:\"2\";s:6:\"ifshow\";i:1;}i:15;a:4:{s:5:\"title\";s:6:\"ҳ\";s:3:\"url\";s:7:\"?m=page\";s:5:\"order\";s:1:\"1\";s:6:\"ifshow\";i:0;}i:8;a:4:{s:5:\"title\";s:8:\"ϵʽ\";s:3:\"url\";s:12:\"?m=contactus\";s:5:\"order\";s:1:\"1\";s:6:\"ifshow\";i:1;}}','','','','','');
INSERT INTO `qb_hy_home` VALUES ('27','test1','vip_3','base,tongji,news,ck','info','a:7:{s:9:\"guestbook\";s:1:\"4\";s:7:\"visitor\";s:2:\"10\";s:8:\"newslist\";s:2:\"10\";s:10:\"friendlink\";s:2:\"10\";s:10:\"Mguestbook\";s:2:\"10\";s:9:\"Mnewslist\";s:2:\"10\";s:8:\"Mvisitor\";s:2:\"40\";}','','','0','1	admin	1466057163\r\n0	192.168.0.100	1461827365','57','a:9:{i:0;a:4:{s:5:\"title\";s:8:\"̼ҳ\";s:3:\"url\";s:1:\"?\";s:5:\"order\";s:2:\"10\";s:6:\"ifshow\";i:1;}i:1;a:4:{s:5:\"title\";s:8:\"̼ҽ\";s:3:\"url\";s:7:\"?m=info\";s:5:\"order\";s:1:\"9\";s:6:\"ifshow\";i:1;}i:2;a:4:{s:5:\"title\";s:8:\"̼\";s:3:\"url\";s:7:\"?m=news\";s:5:\"order\";s:1:\"8\";s:6:\"ifshow\";i:1;}i:11;a:4:{s:5:\"title\";s:8:\"̼ҲƷ\";s:3:\"url\";s:7:\"?m=shop\";s:5:\"order\";s:1:\"7\";s:6:\"ifshow\";i:1;}i:12;a:4:{s:5:\"title\";s:8:\"Ϣ\";s:3:\"url\";s:9:\"?m=coupon\";s:5:\"order\";s:1:\"5\";s:6:\"ifshow\";i:1;}i:13;a:4:{s:5:\"title\";s:8:\"ƸϢ\";s:3:\"url\";s:6:\"?m=job\";s:5:\"order\";s:1:\"4\";s:6:\"ifshow\";i:1;}i:4;a:4:{s:5:\"title\";s:8:\"ͼƬչʾ\";s:3:\"url\";s:7:\"?m=pics\";s:5:\"order\";s:1:\"2\";s:6:\"ifshow\";i:1;}i:14;a:4:{s:5:\"title\";s:8:\"˿͵\";s:3:\"url\";s:11:\"?m=dianping\";s:5:\"order\";s:1:\"2\";s:6:\"ifshow\";i:1;}i:8;a:4:{s:5:\"title\";s:8:\"ϵʽ\";s:3:\"url\";s:12:\"?m=contactus\";s:5:\"order\";s:1:\"1\";s:6:\"ifshow\";i:1;}}','','','','','');
INSERT INTO `qb_hy_home` VALUES ('31','test5','vip_a5','base,tongji,ck','info,dping','a:7:{s:9:\"guestbook\";s:1:\"4\";s:7:\"visitor\";s:2:\"10\";s:8:\"newslist\";s:2:\"10\";s:10:\"friendlink\";s:2:\"10\";s:10:\"Mguestbook\";s:2:\"10\";s:8:\"Mvisitor\";s:2:\"40\";s:9:\"Mnewslist\";s:2:\"10\";}','','','0','0	192.168.0.100	1461825127\r\n1	admin	1341393072','22','a:10:{i:0;a:4:{s:5:\"title\";s:8:\"̼ҳ\";s:3:\"url\";s:1:\"?\";s:5:\"order\";s:2:\"10\";s:6:\"ifshow\";i:1;}i:1;a:4:{s:5:\"title\";s:8:\"̼ҽ\";s:3:\"url\";s:7:\"?m=info\";s:5:\"order\";s:1:\"9\";s:6:\"ifshow\";i:1;}i:2;a:4:{s:5:\"title\";s:8:\"̼\";s:3:\"url\";s:7:\"?m=news\";s:5:\"order\";s:1:\"8\";s:6:\"ifshow\";i:1;}i:11;a:4:{s:5:\"title\";s:8:\"̼ҲƷ\";s:3:\"url\";s:7:\"?m=shop\";s:5:\"order\";s:1:\"7\";s:6:\"ifshow\";i:1;}i:12;a:4:{s:5:\"title\";s:8:\"Ϣ\";s:3:\"url\";s:9:\"?m=coupon\";s:5:\"order\";s:1:\"5\";s:6:\"ifshow\";i:1;}i:13;a:4:{s:5:\"title\";s:8:\"ƸϢ\";s:3:\"url\";s:6:\"?m=job\";s:5:\"order\";s:1:\"4\";s:6:\"ifshow\";i:1;}i:14;a:4:{s:5:\"title\";s:8:\"˿͵\";s:3:\"url\";s:11:\"?m=dianping\";s:5:\"order\";s:1:\"2\";s:6:\"ifshow\";i:1;}i:4;a:4:{s:5:\"title\";s:8:\"ͼƬչʾ\";s:3:\"url\";s:7:\"?m=pics\";s:5:\"order\";s:1:\"2\";s:6:\"ifshow\";i:1;}i:15;a:4:{s:5:\"title\";s:6:\"ҳ\";s:3:\"url\";s:7:\"?m=page\";s:5:\"order\";s:1:\"1\";s:6:\"ifshow\";i:0;}i:8;a:4:{s:5:\"title\";s:8:\"ϵʽ\";s:3:\"url\";s:12:\"?m=contactus\";s:5:\"order\";s:1:\"1\";s:6:\"ifshow\";i:1;}}','','','','','');
INSERT INTO `qb_hy_home` VALUES ('32','test6','vip_2','base,tongji,ck','info','a:7:{s:9:\"guestbook\";s:1:\"4\";s:7:\"visitor\";s:2:\"10\";s:8:\"newslist\";s:2:\"10\";s:10:\"friendlink\";s:2:\"10\";s:10:\"Mguestbook\";s:2:\"10\";s:8:\"Mvisitor\";s:2:\"40\";s:9:\"Mnewslist\";s:2:\"10\";}','','','0','0	127.0.0.1	1341390356\r\n1	admin	1338886657','17','a:10:{i:0;a:4:{s:5:\"title\";s:8:\"̼ҳ\";s:3:\"url\";s:1:\"?\";s:5:\"order\";s:2:\"10\";s:6:\"ifshow\";i:1;}i:1;a:4:{s:5:\"title\";s:8:\"̼ҽ\";s:3:\"url\";s:7:\"?m=info\";s:5:\"order\";s:1:\"9\";s:6:\"ifshow\";i:1;}i:2;a:4:{s:5:\"title\";s:8:\"̼\";s:3:\"url\";s:7:\"?m=news\";s:5:\"order\";s:1:\"8\";s:6:\"ifshow\";i:1;}i:11;a:4:{s:5:\"title\";s:8:\"̼ҲƷ\";s:3:\"url\";s:7:\"?m=shop\";s:5:\"order\";s:1:\"7\";s:6:\"ifshow\";i:1;}i:12;a:4:{s:5:\"title\";s:8:\"Ϣ\";s:3:\"url\";s:9:\"?m=coupon\";s:5:\"order\";s:1:\"5\";s:6:\"ifshow\";i:1;}i:13;a:4:{s:5:\"title\";s:8:\"ƸϢ\";s:3:\"url\";s:6:\"?m=job\";s:5:\"order\";s:1:\"4\";s:6:\"ifshow\";i:1;}i:4;a:4:{s:5:\"title\";s:8:\"ͼƬչʾ\";s:3:\"url\";s:7:\"?m=pics\";s:5:\"order\";s:1:\"2\";s:6:\"ifshow\";i:1;}i:14;a:4:{s:5:\"title\";s:8:\"˿͵\";s:3:\"url\";s:11:\"?m=dianping\";s:5:\"order\";s:1:\"2\";s:6:\"ifshow\";i:1;}i:15;a:4:{s:5:\"title\";s:6:\"ҳ\";s:3:\"url\";s:7:\"?m=page\";s:5:\"order\";s:1:\"1\";s:6:\"ifshow\";i:0;}i:8;a:4:{s:5:\"title\";s:8:\"ϵʽ\";s:3:\"url\";s:12:\"?m=contactus\";s:5:\"order\";s:1:\"1\";s:6:\"ifshow\";i:1;}}','','','','','');
INSERT INTO `qb_hy_home` VALUES ('33','test7','vip_3','base,tongji,news,ck','info','a:7:{s:9:\"guestbook\";i:4;s:7:\"visitor\";i:10;s:8:\"newslist\";i:10;s:10:\"friendlink\";i:10;s:10:\"Mguestbook\";i:10;s:8:\"Mvisitor\";i:40;s:9:\"Mnewslist\";i:10;}','','left','0','0	192.168.0.100	1464056577\r\n0	192.168.0.109	1460950078\r\n1	admin	1364454491\r\n32	test6	1341368584','23','a:9:{i:0;a:4:{s:5:\"title\";s:8:\"̼ҳ\";s:3:\"url\";s:1:\"?\";s:5:\"order\";s:2:\"10\";s:6:\"ifshow\";i:1;}i:1;a:4:{s:5:\"title\";s:8:\"̼ҽ\";s:3:\"url\";s:7:\"?m=info\";s:5:\"order\";s:1:\"9\";s:6:\"ifshow\";i:1;}i:2;a:4:{s:5:\"title\";s:8:\"̼\";s:3:\"url\";s:7:\"?m=news\";s:5:\"order\";s:1:\"8\";s:6:\"ifshow\";i:1;}i:11;a:4:{s:5:\"title\";s:8:\"̼ҲƷ\";s:3:\"url\";s:7:\"?m=shop\";s:5:\"order\";s:1:\"7\";s:6:\"ifshow\";i:1;}i:12;a:4:{s:5:\"title\";s:8:\"Ϣ\";s:3:\"url\";s:9:\"?m=coupon\";s:5:\"order\";s:1:\"5\";s:6:\"ifshow\";i:1;}i:13;a:4:{s:5:\"title\";s:8:\"ƸϢ\";s:3:\"url\";s:6:\"?m=job\";s:5:\"order\";s:1:\"4\";s:6:\"ifshow\";i:1;}i:4;a:4:{s:5:\"title\";s:8:\"ͼƬչʾ\";s:3:\"url\";s:7:\"?m=pics\";s:5:\"order\";s:1:\"2\";s:6:\"ifshow\";i:1;}i:14;a:4:{s:5:\"title\";s:8:\"˿͵\";s:3:\"url\";s:11:\"?m=dianping\";s:5:\"order\";s:1:\"2\";s:6:\"ifshow\";i:1;}i:8;a:4:{s:5:\"title\";s:8:\"ϵʽ\";s:3:\"url\";s:12:\"?m=contactus\";s:5:\"order\";s:1:\"1\";s:6:\"ifshow\";i:1;}}','','','','','');
INSERT INTO `qb_hy_home` VALUES ('34','test8','vip_1','base,tongji,news,ck','info','a:7:{s:9:\"guestbook\";i:4;s:7:\"visitor\";i:10;s:8:\"newslist\";i:10;s:10:\"friendlink\";i:10;s:10:\"Mguestbook\";i:10;s:8:\"Mvisitor\";i:40;s:9:\"Mnewslist\";i:10;}','','left','0','0	127.0.0.1	1466057098\r\n0	192.168.0.100	1464056571\r\n1	admin	1346232745\r\n32	test6	1341368580','28','a:9:{i:0;a:4:{s:5:\"title\";s:8:\"̼ҳ\";s:3:\"url\";s:1:\"?\";s:5:\"order\";s:2:\"10\";s:6:\"ifshow\";i:1;}i:1;a:4:{s:5:\"title\";s:8:\"̼ҽ\";s:3:\"url\";s:7:\"?m=info\";s:5:\"order\";s:1:\"9\";s:6:\"ifshow\";i:1;}i:2;a:4:{s:5:\"title\";s:8:\"̼\";s:3:\"url\";s:7:\"?m=news\";s:5:\"order\";s:1:\"8\";s:6:\"ifshow\";i:1;}i:11;a:4:{s:5:\"title\";s:8:\"̼ҲƷ\";s:3:\"url\";s:7:\"?m=shop\";s:5:\"order\";s:1:\"7\";s:6:\"ifshow\";i:1;}i:12;a:4:{s:5:\"title\";s:8:\"Ϣ\";s:3:\"url\";s:9:\"?m=coupon\";s:5:\"order\";s:1:\"5\";s:6:\"ifshow\";i:1;}i:13;a:4:{s:5:\"title\";s:8:\"ƸϢ\";s:3:\"url\";s:6:\"?m=job\";s:5:\"order\";s:1:\"4\";s:6:\"ifshow\";i:1;}i:4;a:4:{s:5:\"title\";s:8:\"ͼƬչʾ\";s:3:\"url\";s:7:\"?m=pics\";s:5:\"order\";s:1:\"2\";s:6:\"ifshow\";i:1;}i:14;a:4:{s:5:\"title\";s:8:\"˿͵\";s:3:\"url\";s:11:\"?m=dianping\";s:5:\"order\";s:1:\"2\";s:6:\"ifshow\";i:1;}i:8;a:4:{s:5:\"title\";s:8:\"ϵʽ\";s:3:\"url\";s:12:\"?m=contactus\";s:5:\"order\";s:1:\"1\";s:6:\"ifshow\";i:1;}}','','','','','');
INSERT INTO `qb_hy_home` VALUES ('35','test9','vip_2','base,tongji,news,ck','info','a:7:{s:9:\"guestbook\";i:4;s:7:\"visitor\";i:10;s:8:\"newslist\";i:10;s:10:\"friendlink\";i:10;s:10:\"Mguestbook\";i:10;s:8:\"Mvisitor\";i:40;s:9:\"Mnewslist\";i:10;}','','left','0','1	admin	1481853522\r\n32	test6	1341368582','107','a:9:{i:0;a:4:{s:5:\"title\";s:8:\"̼ҳ\";s:3:\"url\";s:1:\"?\";s:5:\"order\";s:2:\"10\";s:6:\"ifshow\";i:1;}i:1;a:4:{s:5:\"title\";s:8:\"̼ҽ\";s:3:\"url\";s:7:\"?m=info\";s:5:\"order\";s:1:\"9\";s:6:\"ifshow\";i:1;}i:2;a:4:{s:5:\"title\";s:8:\"̼\";s:3:\"url\";s:7:\"?m=news\";s:5:\"order\";s:1:\"8\";s:6:\"ifshow\";i:1;}i:11;a:4:{s:5:\"title\";s:8:\"̼ҲƷ\";s:3:\"url\";s:7:\"?m=shop\";s:5:\"order\";s:1:\"7\";s:6:\"ifshow\";i:1;}i:12;a:4:{s:5:\"title\";s:8:\"Ϣ\";s:3:\"url\";s:9:\"?m=coupon\";s:5:\"order\";s:1:\"5\";s:6:\"ifshow\";i:1;}i:13;a:4:{s:5:\"title\";s:8:\"ƸϢ\";s:3:\"url\";s:6:\"?m=job\";s:5:\"order\";s:1:\"4\";s:6:\"ifshow\";i:1;}i:4;a:4:{s:5:\"title\";s:8:\"ͼƬչʾ\";s:3:\"url\";s:7:\"?m=pics\";s:5:\"order\";s:1:\"2\";s:6:\"ifshow\";i:1;}i:14;a:4:{s:5:\"title\";s:8:\"˿͵\";s:3:\"url\";s:11:\"?m=dianping\";s:5:\"order\";s:1:\"2\";s:6:\"ifshow\";i:1;}i:8;a:4:{s:5:\"title\";s:8:\"ϵʽ\";s:3:\"url\";s:12:\"?m=contactus\";s:5:\"order\";s:1:\"1\";s:6:\"ifshow\";i:1;}}','','','','','');
INSERT INTO `qb_hy_home` VALUES ('36','test10','vip_3','base,tongji,news,ck','info','a:7:{s:9:\"guestbook\";i:4;s:7:\"visitor\";i:10;s:8:\"newslist\";i:10;s:10:\"friendlink\";i:10;s:10:\"Mguestbook\";i:10;s:8:\"Mvisitor\";i:40;s:9:\"Mnewslist\";i:10;}','','left','0','1	admin	1481853519\r\n0	192.168.0.100	1464056566\r\n0	192.168.0.109	1460950046\r\n32	test6	1341368574','92','a:9:{i:0;a:4:{s:5:\"title\";s:8:\"̼ҳ\";s:3:\"url\";s:1:\"?\";s:5:\"order\";s:2:\"10\";s:6:\"ifshow\";i:1;}i:1;a:4:{s:5:\"title\";s:8:\"̼ҽ\";s:3:\"url\";s:7:\"?m=info\";s:5:\"order\";s:1:\"9\";s:6:\"ifshow\";i:1;}i:2;a:4:{s:5:\"title\";s:8:\"̼\";s:3:\"url\";s:7:\"?m=news\";s:5:\"order\";s:1:\"8\";s:6:\"ifshow\";i:1;}i:11;a:4:{s:5:\"title\";s:8:\"̼ҲƷ\";s:3:\"url\";s:7:\"?m=shop\";s:5:\"order\";s:1:\"7\";s:6:\"ifshow\";i:1;}i:12;a:4:{s:5:\"title\";s:8:\"Ϣ\";s:3:\"url\";s:9:\"?m=coupon\";s:5:\"order\";s:1:\"5\";s:6:\"ifshow\";i:1;}i:13;a:4:{s:5:\"title\";s:8:\"ƸϢ\";s:3:\"url\";s:6:\"?m=job\";s:5:\"order\";s:1:\"4\";s:6:\"ifshow\";i:1;}i:4;a:4:{s:5:\"title\";s:8:\"ͼƬչʾ\";s:3:\"url\";s:7:\"?m=pics\";s:5:\"order\";s:1:\"2\";s:6:\"ifshow\";i:1;}i:14;a:4:{s:5:\"title\";s:8:\"˿͵\";s:3:\"url\";s:11:\"?m=dianping\";s:5:\"order\";s:1:\"2\";s:6:\"ifshow\";i:1;}i:8;a:4:{s:5:\"title\";s:8:\"ϵʽ\";s:3:\"url\";s:12:\"?m=contactus\";s:5:\"order\";s:1:\"1\";s:6:\"ifshow\";i:1;}}','','','','','');
INSERT INTO `qb_hy_home` VALUES ('37','test11','vip_1','base,tongji,news,ck','info','a:7:{s:9:\"guestbook\";i:4;s:7:\"visitor\";i:10;s:8:\"newslist\";i:10;s:10:\"friendlink\";i:10;s:10:\"Mguestbook\";i:10;s:8:\"Mvisitor\";i:40;s:9:\"Mnewslist\";i:10;}','','left','0','1	admin	1481853515\r\n0	192.168.0.100	1464056560\r\n0	192.168.0.129	1463017722\r\n0	192.168.0.107	1352447732\r\n32	test6	1341368570','252','a:9:{i:0;a:4:{s:5:\"title\";s:8:\"̼ҳ\";s:3:\"url\";s:1:\"?\";s:5:\"order\";s:2:\"10\";s:6:\"ifshow\";i:1;}i:1;a:4:{s:5:\"title\";s:8:\"̼ҽ\";s:3:\"url\";s:7:\"?m=info\";s:5:\"order\";s:1:\"9\";s:6:\"ifshow\";i:1;}i:2;a:4:{s:5:\"title\";s:8:\"̼\";s:3:\"url\";s:7:\"?m=news\";s:5:\"order\";s:1:\"8\";s:6:\"ifshow\";i:1;}i:11;a:4:{s:5:\"title\";s:8:\"̼ҲƷ\";s:3:\"url\";s:7:\"?m=shop\";s:5:\"order\";s:1:\"7\";s:6:\"ifshow\";i:1;}i:12;a:4:{s:5:\"title\";s:8:\"Ϣ\";s:3:\"url\";s:9:\"?m=coupon\";s:5:\"order\";s:1:\"5\";s:6:\"ifshow\";i:1;}i:13;a:4:{s:5:\"title\";s:8:\"ƸϢ\";s:3:\"url\";s:6:\"?m=job\";s:5:\"order\";s:1:\"4\";s:6:\"ifshow\";i:1;}i:4;a:4:{s:5:\"title\";s:8:\"ͼƬչʾ\";s:3:\"url\";s:7:\"?m=pics\";s:5:\"order\";s:1:\"2\";s:6:\"ifshow\";i:1;}i:14;a:4:{s:5:\"title\";s:8:\"˿͵\";s:3:\"url\";s:11:\"?m=dianping\";s:5:\"order\";s:1:\"2\";s:6:\"ifshow\";i:1;}i:8;a:4:{s:5:\"title\";s:8:\"ϵʽ\";s:3:\"url\";s:12:\"?m=contactus\";s:5:\"order\";s:1:\"1\";s:6:\"ifshow\";i:1;}}','','','','','');
INSERT INTO `qb_hy_mymember` VALUES ('1','1','1','1483782340','0.01','1487902492');
INSERT INTO `qb_hy_mymember` VALUES ('2','1','27','1484726659','0','1484726717');
INSERT INTO `qb_hy_qd` VALUES ('1','1','1','20170209');
INSERT INTO `qb_hy_qd` VALUES ('2','1','27','20170118');
INSERT INTO `qb_hy_sort` VALUES ('1','0','ʳ','0','1','0','0','','0','1','','','','','N;','','0','','','','0','','','','','0','','0','0','','','0');
INSERT INTO `qb_hy_sort` VALUES ('2','0','','0','1','0','0','','0','0','','','','','N;','','0','','','','0','','','','','0','','0','0','','','0');
INSERT INTO `qb_hy_sort` VALUES ('3','0','ξƵ','0','1','0','0','','0','0','','','','','N;','','0','','','','0','','','','','0','','0','0','','','0');
INSERT INTO `qb_hy_sort` VALUES ('4','0','','0','1','0','0','','0','0','','','','','N;','','0','','','','0','','','','','0','','0','0','','','0');
INSERT INTO `qb_hy_sort` VALUES ('5','0','ݱ','0','1','0','0','','0','0','','','','','N;','','0','','','','0','','','','','0','','0','0','','','0');
INSERT INTO `qb_hy_sort` VALUES ('6','0','Ҿ','0','1','0','0','','0','0','','','','','N;','','0','','','','0','','','','','0','','0','0','','','0');
INSERT INTO `qb_hy_sort` VALUES ('7','0','','0','1','0','0','','0','0','','','','','N;','','0','','','','0','','','','','0','','0','0','','','0');
INSERT INTO `qb_hy_sort` VALUES ('8','0','ҽƽ','0','1','0','0','','0','0','','','','','N;','','0','','','','0','','','','','0','','0','0','','','0');
INSERT INTO `qb_hy_sort` VALUES ('9','0','ѯн','0','1','0','0','','0','0','','','','','N;','','0','','','','0','','','','','0','','0','0','','','0');
INSERT INTO `qb_hy_sort` VALUES ('10','0','ѵ','0','1','0','0','','0','0','','','','','N;','','0','','','','0','','','','','0','','0','0','','','0');
INSERT INTO `qb_hy_sort` VALUES ('11','1','','0','2','0','0','','0','0','','','','','N;','','0','','','','0','','','','','0','','0','0','','','0');
INSERT INTO `qb_hy_sort` VALUES ('12','1','ţŹ','0','2','0','0','','0','0','','','','','N;','','0','','','','0','','','','','0','','0','0','','','0');
INSERT INTO `qb_hy_sort` VALUES ('13','1','','0','2','0','0','','0','0','','','','','N;','','0','','','','0','','','','','0','','0','0','','','0');
INSERT INTO `qb_hy_sort` VALUES ('14','1','/ɰ','0','2','0','0','','0','0','','','','','','','0','','','','1','','','','','0','','0','0','','','0');
INSERT INTO `qb_hy_sort` VALUES ('15','1','ձ','0','2','0','0','','0','0','','','','','','','0','','','','1','','','','','0','','0','0','','','0');
INSERT INTO `qb_hy_sort` VALUES ('16','1','','0','2','0','0','','0','0','','','','','','','0','','','','1','','','','','0','','0','0','','','0');
INSERT INTO `qb_hy_sort` VALUES ('17','1','','0','2','0','0','','0','0','','','','','','','0','','','','1','','','','','0','','0','0','','','0');
INSERT INTO `qb_hy_sort` VALUES ('18','1','/ũҲ','0','2','0','0','','0','0','','','','','','','0','','','','1','','','','','0','','0','0','','','0');
INSERT INTO `qb_hy_sort` VALUES ('19','1','/С','0','2','0','0','','0','0','','','','','','','0','','','','1','','','','','0','','0','0','','','0');
INSERT INTO `qb_hy_sort` VALUES ('20','1','/','0','2','0','0','','0','0','','','','','','','0','','','','1','','','','','0','','0','0','','','0');
INSERT INTO `qb_hy_sort` VALUES ('21','2','','0','2','0','0','','0','0','','','','','','','0','','','','1','','','','','0','','0','0','','','0');
INSERT INTO `qb_hy_sort` VALUES ('22','2','KTV','0','2','0','0','','0','0','','','','','','','0','','','','1','','','','','0','','0','0','','','0');
INSERT INTO `qb_hy_sort` VALUES ('23','2','','0','2','0','0','','0','0','','','','','','','0','','','','1','','','','','0','','0','0','','','0');
INSERT INTO `qb_hy_sort` VALUES ('24','2','','0','2','0','0','','0','0','','','','','','','0','','','','1','','','','','0','','0','0','','','0');
INSERT INTO `qb_hy_sort` VALUES ('25','2','ֳ','0','2','0','0','','0','0','','','','','','','0','','','','1','','','','','0','','0','0','','','0');
INSERT INTO `qb_hy_sort` VALUES ('26','3','ù//','0','2','0','0','','0','0','','','','','','','0','','','','1','','','','','0','','0','0','','','0');
INSERT INTO `qb_hy_sort` VALUES ('27','3','ǩ֤','0','2','0','0','','0','0','','','','','','','0','','','','1','','','','','0','','0','0','','','0');
INSERT INTO `qb_hy_sort` VALUES ('28','3','㾰','0','2','0','0','','0','0','','','','','','','0','','','','1','','','','','0','','0','0','','','0');
INSERT INTO `qb_hy_sort` VALUES ('29','3','סԤ','0','2','0','0','','0','0','','','','','','','0','','','','1','','','','','0','','0','0','','','0');
INSERT INTO `qb_hy_sort` VALUES ('30','3','ͱݾƵ','0','2','0','0','','0','0','','','','','','','0','','','','1','','','','','0','','0','0','','','0');
INSERT INTO `qb_hy_sort` VALUES ('31','4','/άά','0','2','0','0','','0','0','','','','','','','0','','','','1','','','','','0','','0','0','','','0');
INSERT INTO `qb_hy_sort` VALUES ('32','4','/','0','2','0','0','','0','0','','','','','','','0','','','','1','','','','','0','','0','0','','','0');
INSERT INTO `qb_hy_sort` VALUES ('33','4','','0','2','0','0','','0','0','','','','','','','0','','','','1','','','','','0','','0','0','','','0');
INSERT INTO `qb_hy_sort` VALUES ('34','4','Ӱ//ϴ','0','2','0','0','','0','0','','','','','','','0','','','','1','','','','','0','','0','0','','','0');
INSERT INTO `qb_hy_sort` VALUES ('35','4','Ӫҵ','0','2','0','0','','0','0','','','','','','','0','','','','1','','','','','0','','0','0','','','0');
INSERT INTO `qb_hy_sort` VALUES ('36','4','/Ӱ','0','2','0','0','','0','0','','','','','','','0','','','','1','','','','','0','','0','0','','','0');
INSERT INTO `qb_hy_sort` VALUES ('37','4','/','0','2','0','0','','0','0','','','','','','','0','','','','1','','','','','0','','0','0','','','0');
INSERT INTO `qb_hy_sort` VALUES ('38','5','Ʒ','0','2','0','0','','0','0','','','','','','','0','','','','1','','','','','0','','0','0','','','0');
INSERT INTO `qb_hy_sort` VALUES ('39','5','Ʒ','0','2','0','0','','0','0','','','','','N;','','0','','','','0','','','','','0','','0','0','','','0');
INSERT INTO `qb_hy_sort` VALUES ('40','5','','0','2','0','0','','0','0','','','','','','','0','','','','1','','','','','0','','0','0','','','0');
INSERT INTO `qb_hy_sort` VALUES ('41','5','','0','2','0','0','','0','0','','','','','','','0','','','','1','','','','','0','','0','0','','','0');
INSERT INTO `qb_hy_sort` VALUES ('42','6','','0','2','0','0','','0','0','','','','','','','0','','','','1','','','','','0','','0','0','','','0');
INSERT INTO `qb_hy_sort` VALUES ('43','6','װװ諷','0','2','0','0','','0','0','','','','','','','0','','','','1','','','','','0','','0','0','','','0');
INSERT INTO `qb_hy_sort` VALUES ('44','6','Ҿӵ','0','2','0','0','','0','0','','','','','','','0','','','','1','','','','','0','','0','0','','','0');
INSERT INTO `qb_hy_sort` VALUES ('45','6','','0','2','0','0','','0','0','','','','','','','0','','','','1','','','','','0','','0','0','','','0');
INSERT INTO `qb_hy_sort` VALUES ('46','6','񷿲','0','2','0','0','','0','0','','','','','','','0','','','','1','','','','','0','','0','0','','','0');
INSERT INTO `qb_hy_sort` VALUES ('47','7','Ьñ//Ƥ','0','2','0','0','','0','0','','','','','','','0','','','','1','','','','','0','','0','0','','','0');
INSERT INTO `qb_hy_sort` VALUES ('48','7','ۺг','0','2','0','0','','0','0','','','','','','','0','','','','1','','','','','0','','0','0','','','0');
INSERT INTO `qb_hy_sort` VALUES ('49','7','','0','2','0','0','','0','0','','','','','','','0','','','','1','','','','','0','','0','0','','','0');
INSERT INTO `qb_hy_sort` VALUES ('50','7','Ӥ׶Ʒ','0','2','0','0','','0','0','','','','','','','0','','','','1','','','','','0','','0','0','','','0');
INSERT INTO `qb_hy_sort` VALUES ('51','7','װг','0','2','0','0','','0','0','','','','','','','0','','','','1','','','','','0','','0','0','','','0');
INSERT INTO `qb_hy_sort` VALUES ('52','7','б','0','2','0','0','','0','0','','','','','','','0','','','','1','','','','','0','','0','0','','','0');
INSERT INTO `qb_hy_sort` VALUES ('53','7','Ʒ/Ʒ','0','2','0','0','','0','0','','','','','','','0','','','','1','','','','','0','','0','0','','','0');
INSERT INTO `qb_hy_sort` VALUES ('54','8','ҽԺ','0','2','0','0','','0','0','','','','','','','0','','','','1','','','','','0','','0','0','','','0');
INSERT INTO `qb_hy_sort` VALUES ('55','8','ѯ','0','2','0','0','','0','0','','','','','','','0','','','','1','','','','','0','','0','0','','','0');
INSERT INTO `qb_hy_sort` VALUES ('56','8','ŮԽ','0','2','0','0','','0','0','','','','','','','0','','','','1','','','','','0','','0','0','','','0');
INSERT INTO `qb_hy_sort` VALUES ('57','8','','0','2','0','0','','0','0','','','','','','','0','','','','1','','','','','0','','0','0','','','0');
INSERT INTO `qb_hy_sort` VALUES ('58','10','ѵѧУ','0','2','0','0','','0','0','','','','','','','0','','','','1','','','','','0','','0','0','','','0');
INSERT INTO `qb_hy_sort` VALUES ('59','10','ѵ','0','2','0','0','','0','0','','','','','','','0','','','','1','','','','','0','','0','0','','','0');
INSERT INTO `qb_hy_sort` VALUES ('60','10','У/','0','2','0','0','','0','0','','','','','','','0','','','','1','','','','','0','','0','0','','','0');
INSERT INTO `qb_hy_sort` VALUES ('61','10','','0','2','0','0','','0','0','','','','','','','0','','','','1','','','','','0','','0','0','','','0');
INSERT INTO `qb_hy_sort` VALUES ('62','10','ѧ/','0','2','0','0','','0','0','','','','','','','0','','','','1','','','','','0','','0','0','','','0');
INSERT INTO `qb_hy_sort` VALUES ('63','10','˽','0','2','0','0','','0','0','','','','','N;','','0','','','','0','','','','','0','','0','0','','','0');
INSERT INTO `qb_hy_sort` VALUES ('64','9','нѯ','0','2','0','0','','0','0','','','','','','','0','','','','1','','','','','0','','0','0','','','0');
INSERT INTO `qb_hy_sort` VALUES ('65','9','/','0','2','0','0','','0','0','','','','','','','0','','','','1','','','','','0','','0','0','','','0');
INSERT INTO `qb_hy_sort` VALUES ('66','9','/','0','2','0','0','','0','0','','','','','','','0','','','','1','','','','','0','','0','0','','','0');
INSERT INTO `qb_hy_sort` VALUES ('67','9','ѧ','0','2','0','0','','0','0','','','','','','','0','','','','1','','','','','0','','0','0','','','0');
INSERT INTO `qb_hy_sort` VALUES ('68','9','Ƹ','0','2','0','0','','0','0','','','','','','','0','','','','1','','','','','0','','0','0','','','0');
INSERT INTO `qb_hy_sort` VALUES ('69','9','/','0','2','0','0','','0','0','','','','','','','0','','','','1','','','','','0','','0','0','','','0');
INSERT INTO `qb_hy_sort` VALUES ('70','9','̴','0','2','0','0','','0','0','','','','','','','0','','','','1','','','','','0','','0','0','','','0');
INSERT INTO `qb_hy_sort` VALUES ('71','9','ʦ','0','2','0','0','','0','0','','','','','','','0','','','','1','','','','','0','','0','0','','','0');
INSERT INTO `qb_hy_sort` VALUES ('72','9','ѯ/','0','2','0','0','','0','0','','','','','','','0','','','','1','','','','','0','','0','0','','','0');
INSERT INTO `qb_hy_style` VALUES ('1','1','2','education_3','a:10:{s:4:\"menu\";a:7:{i:0;a:4:{s:5:\"title\";s:8:\"̼ҳ\";s:3:\"url\";s:6:\"?uid=1\";s:4:\"icon\";s:59:\"http://www_qibosoft_com/hy/wapstyle/default/images/home.png\";s:6:\"bcolor\";s:6:\"green1\";}i:1;a:4:{s:5:\"title\";s:8:\"̼ҽ\";s:3:\"url\";s:19:\"?uid=1&myinfo=about\";s:4:\"icon\";s:60:\"http://www_qibosoft_com/hy/wapstyle/default/images/about.png\";s:6:\"bcolor\";s:5:\"blue1\";}i:2;a:4:{s:5:\"title\";s:8:\"̼\";s:3:\"url\";s:18:\"?uid=1&myinfo=news\";s:4:\"icon\";s:59:\"http://www_qibosoft_com/hy/wapstyle/default/images/news.png\";s:6:\"bcolor\";s:5:\"blue2\";}i:3;a:4:{s:5:\"title\";s:8:\"̼ҲƷ\";s:3:\"url\";s:18:\"?uid=1&myinfo=shop\";s:4:\"icon\";s:59:\"http://www_qibosoft_com/hy/wapstyle/default/images/shop.png\";s:6:\"bcolor\";s:6:\"orange\";}i:4;a:4:{s:5:\"title\";s:8:\"̼Ҷ̬\";s:3:\"url\";s:28:\"../picmsg/waphymsg.php?uid=1\";s:4:\"icon\";s:61:\"http://www_qibosoft_com/hy/wapstyle/default/images/coupon.png\";s:6:\"bcolor\";s:5:\"blue2\";}i:5;a:4:{s:5:\"title\";s:8:\"˿͵\";s:3:\"url\";s:22:\"?uid=1&myinfo=dianping\";s:4:\"icon\";s:63:\"http://www_qibosoft_com/hy/wapstyle/default/images/dianping.png\";s:6:\"bcolor\";s:7:\"purple1\";}i:6;a:4:{s:5:\"title\";s:8:\"ϵʽ\";s:3:\"url\";s:21:\"?uid=1&myinfo=contact\";s:4:\"icon\";s:62:\"http://www_qibosoft_com/hy/wapstyle/default/images/contact.png\";s:6:\"bcolor\";s:7:\"yellow2\";}}s:11:\"aboutbanner\";a:1:{s:3:\"img\";s:60:\"http://www_qibosoft_com/hy/wapstyle/default/images/about.jpg\";}s:10:\"newsbanner\";a:1:{s:3:\"img\";s:59:\"http://www_qibosoft_com/hy/wapstyle/default/images/news.jpg\";}s:10:\"shopbanner\";a:1:{s:3:\"img\";s:59:\"http://www_qibosoft_com/hy/wapstyle/default/images/shop.jpg\";}s:12:\"couponbanner\";a:1:{s:3:\"img\";s:61:\"http://www_qibosoft_com/hy/wapstyle/default/images/coupon.jpg\";}s:8:\"hrbanner\";a:1:{s:3:\"img\";s:57:\"http://www_qibosoft_com/hy/wapstyle/default/images/hr.jpg\";}s:13:\"contactbanner\";a:1:{s:3:\"img\";s:62:\"http://www_qibosoft_com/hy/wapstyle/default/images/contact.jpg\";}s:9:\"MainbgImg\";s:61:\"http://www_qibosoft_com/hy/wapstyle/education_3/images/bg.jpg\";s:9:\"SiteTitle\";s:24:\"ЭƼ޹˾\";s:9:\"hide_menu\";s:1:\"0\";}','0');
INSERT INTO `qb_hy_style` VALUES ('2','1','2','default','a:10:{s:4:\"menu\";a:7:{i:0;a:4:{s:5:\"title\";s:8:\"̼ҳ\";s:3:\"url\";s:6:\"?uid=1\";s:4:\"icon\";s:59:\"http://www_qibosoft_com/hy/wapstyle/default/images/home.png\";s:6:\"bcolor\";s:6:\"green1\";}i:1;a:4:{s:5:\"title\";s:8:\"̼ҽ\";s:3:\"url\";s:19:\"?uid=1&myinfo=about\";s:4:\"icon\";s:60:\"http://www_qibosoft_com/hy/wapstyle/default/images/about.png\";s:6:\"bcolor\";s:5:\"blue1\";}i:2;a:4:{s:5:\"title\";s:8:\"̼\";s:3:\"url\";s:18:\"?uid=1&myinfo=news\";s:4:\"icon\";s:59:\"http://www_qibosoft_com/hy/wapstyle/default/images/news.png\";s:6:\"bcolor\";s:5:\"blue2\";}i:3;a:4:{s:5:\"title\";s:8:\"̼ҲƷ\";s:3:\"url\";s:18:\"?uid=1&myinfo=shop\";s:4:\"icon\";s:59:\"http://www_qibosoft_com/hy/wapstyle/default/images/shop.png\";s:6:\"bcolor\";s:6:\"orange\";}i:4;a:4:{s:5:\"title\";s:8:\"̼Ҷ̬\";s:3:\"url\";s:28:\"../picmsg/waphymsg.php?uid=1\";s:4:\"icon\";s:61:\"http://www_qibosoft_com/hy/wapstyle/default/images/coupon.png\";s:6:\"bcolor\";s:5:\"blue2\";}i:5;a:4:{s:5:\"title\";s:8:\"˿͵\";s:3:\"url\";s:22:\"?uid=1&myinfo=dianping\";s:4:\"icon\";s:63:\"http://www_qibosoft_com/hy/wapstyle/default/images/dianping.png\";s:6:\"bcolor\";s:7:\"purple1\";}i:6;a:4:{s:5:\"title\";s:8:\"ϵʽ\";s:3:\"url\";s:21:\"?uid=1&myinfo=contact\";s:4:\"icon\";s:62:\"http://www_qibosoft_com/hy/wapstyle/default/images/contact.png\";s:6:\"bcolor\";s:7:\"yellow2\";}}s:5:\"slide\";a:3:{i:0;a:3:{s:5:\"title\";s:14:\"ˮ豸\";s:3:\"url\";s:19:\"?uid=1&myinfo=about\";s:3:\"img\";s:56:\"http://www_qibosoft_com/hy/wapstyle/default/images/a.jpg\";}i:1;a:3:{s:5:\"title\";s:14:\"Ȫˮ\";s:3:\"url\";s:18:\"?uid=1&myinfo=shop\";s:3:\"img\";s:56:\"http://www_qibosoft_com/hy/wapstyle/default/images/b.jpg\";}i:2;a:3:{s:5:\"title\";s:20:\"ھӶĽװ\";s:3:\"url\";s:21:\"?uid=1&myinfo=contact\";s:3:\"img\";s:56:\"http://www_qibosoft_com/hy/wapstyle/default/images/c.jpg\";}}s:11:\"aboutbanner\";a:1:{s:3:\"img\";s:60:\"http://www_qibosoft_com/hy/wapstyle/default/images/about.jpg\";}s:10:\"newsbanner\";a:1:{s:3:\"img\";s:59:\"http://www_qibosoft_com/hy/wapstyle/default/images/news.jpg\";}s:10:\"shopbanner\";a:1:{s:3:\"img\";s:59:\"http://www_qibosoft_com/hy/wapstyle/default/images/shop.jpg\";}s:12:\"couponbanner\";a:1:{s:3:\"img\";s:61:\"http://www_qibosoft_com/hy/wapstyle/default/images/coupon.jpg\";}s:8:\"hrbanner\";a:1:{s:3:\"img\";s:57:\"http://www_qibosoft_com/hy/wapstyle/default/images/hr.jpg\";}s:13:\"contactbanner\";a:1:{s:3:\"img\";s:62:\"http://www_qibosoft_com/hy/wapstyle/default/images/contact.jpg\";}s:10:\"hide_slide\";s:1:\"0\";s:10:\"size_slide\";s:1:\"1\";}','0');
INSERT INTO `qb_news_comments` VALUES ('1','963','32','0','1','1','admin','1484809150','jgkjhgkjh','127.0.0.1','0','0','0','0','0','0');
INSERT INTO `qb_news_comments` VALUES ('2','963','32','1','1','1','admin','1484809155','hgfjhgf','127.0.0.1','0','0','0','0','0','0');
INSERT INTO `qb_news_config` VALUES ('Private_tpl_foot','','');
INSERT INTO `qb_news_config` VALUES ('Info_webOpen','1','');
INSERT INTO `qb_news_config` VALUES ('Info_adminfen','','');
INSERT INTO `qb_news_config` VALUES ('GroupPostjumpurl','3,4','');
INSERT INTO `qb_news_config` VALUES ('GroupPostIframe','3,4','');
INSERT INTO `qb_news_config` VALUES ('Private_tpl_head','','');
INSERT INTO `qb_news_config` VALUES ('UseArea','0','');
INSERT INTO `qb_news_config` VALUES ('Info_forbidOutPost','0','');
INSERT INTO `qb_news_config` VALUES ('Info_closeWhy','','');
INSERT INTO `qb_news_config` VALUES ('IF_Private_tpl','0','');
INSERT INTO `qb_news_config` VALUES ('GroupPostYZ','3,4,8','');
INSERT INTO `qb_news_config` VALUES ('Info_ShowCommentRows','0','');
INSERT INTO `qb_news_config` VALUES ('Info_PassCommentType','1','');
INSERT INTO `qb_news_config` VALUES ('Info_PostCommentType','1','');
INSERT INTO `qb_news_config` VALUES ('module_close','1','');
INSERT INTO `qb_news_config` VALUES ('topArticleMoney','2','');
INSERT INTO `qb_news_config` VALUES ('frontArticleMoney','1','');
INSERT INTO `qb_news_config` VALUES ('comArticleMoney','5','');
INSERT INTO `qb_news_config` VALUES ('deleteArticleMoney','-2','');
INSERT INTO `qb_news_config` VALUES ('postArticleMoney','2','');
INSERT INTO `qb_news_config` VALUES ('module_pre','news_','');
INSERT INTO `qb_news_config` VALUES ('Info_GroupPostYZ','3','');
INSERT INTO `qb_news_config` VALUES ('allowGroupPost','3,8','');
INSERT INTO `qb_news_config` VALUES ('module_id','20','');
INSERT INTO `qb_news_config` VALUES ('Info_description','','');
INSERT INTO `qb_news_config` VALUES ('Info_metakeywords','','');
INSERT INTO `qb_news_config` VALUES ('Info_webname','ѶƵ','');
INSERT INTO `qb_news_content` VALUES ('940','ΪʲôҪƻԱ?','','44','0','ָ','16','1','0','1287391687','1287391687','1','admin','','','','','0','','0','1','','0','1','1294648671','Ϊʲô   Ա','','','','a:3:{s:4:\"head\";s:0:\"\";s:4:\"foot\";s:0:\"\";s:8:\"bencandy\";s:0:\"\";}','0','','0','0','','','','','','0','0','0','','1465271342','0','0','0','0','','','1','0','0','0','');
INSERT INTO `qb_news_content` VALUES ('941','עͨԱҪշ','','44','0','ָ','5','1','0','1287452794','1287452794','1','admin','','','','','0','','0','1','','0','0','0','ע ͨ Ա շ','','','','a:3:{s:4:\"head\";s:0:\"\";s:4:\"foot\";s:0:\"\";s:8:\"bencandy\";s:0:\"\";}','0','','0','0','','','','','','0','0','0','','1462257420','0','0','0','0','','','1','0','0','0','');
INSERT INTO `qb_news_content` VALUES ('942','עǵ¼ô죿','','44','0','ָ','8','1','0','1287452845','1287452845','1','admin','','','','','0','','0','1','','0','0','0','ע  ¼  ô','','','','a:3:{s:4:\"head\";s:0:\"\";s:4:\"foot\";s:0:\"\";s:8:\"bencandy\";s:0:\"\";}','0','','0','0','','','','','','0','0','0','','1487129465','0','0','0','0','','','1','0','0','0','');
INSERT INTO `qb_news_content` VALUES ('955','ӪʦԷ ζ뽡','','39','0','ʳĻ','8','1','0','1292983367','1292983367','1','admin','','','','','0','qb_news_/39/1_20160426140449_cxnsp.jpg','1','1','','0','0','0','Ӫʦ Է ζ ','','','','a:3:{s:4:\"head\";s:0:\"\";s:4:\"foot\";s:0:\"\";s:8:\"bencandy\";s:0:\"\";}','0','','0','0','','','','','','0','0','0','','1359348736','0','0','0','0','','','1','0','0','0','');
INSERT INTO `qb_news_content` VALUES ('956','ζ Ź','','37','0','ʳ','9','1','0','1292986247','1292986247','1','admin','','','','','0','qb_news_/37/1_20160426140452_lumr6.jpg','1','1','','0','0','0',' ζ  Ź ','','','','a:3:{s:4:\"head\";s:0:\"\";s:4:\"foot\";s:0:\"\";s:8:\"bencandy\";s:0:\"\";}','0','','0','0','','','','','','0','0','0','','1484901056','0','0','0','0','','','1','0','0','0','');
INSERT INTO `qb_news_content` VALUES ('957',' ˬθ','','37','0','ʳ','9','1','0','1292986403','1292986403','1','admin','','','','','0','qb_news_/37/1_20160426140458_amzxt.jpg','1','1','','0','0','0',' ','','','','a:3:{s:4:\"head\";s:0:\"\";s:4:\"foot\";s:0:\"\";s:8:\"bencandy\";s:0:\"\";}','0','','0','0','','','','','','0','0','0','','1461720802','0','0','0','0','','','1','0','0','0','');
INSERT INTO `qb_news_content` VALUES ('958','һźʳ Ƭ','','37','0','ʳ','7','1','0','1292986473','1292986473','1','admin','','','','','0','qb_news_/37/1_20160426140406_stytv.jpg','1','1','','0','0','0',' ','','','','a:3:{s:4:\"head\";s:0:\"\";s:4:\"foot\";s:0:\"\";s:8:\"bencandy\";s:0:\"\";}','0','','0','0','','','','','','0','0','0','','1462238401','0','0','0','0','','','1','0','0','0','');
INSERT INTO `qb_news_content` VALUES ('959','ͷ齪гƬ Ѫǿ','','39','0','ʳĻ','6','1','0','1292986534','1292986534','1','admin','','','','','0','qb_news_/39/1_20160426140411_552jc.jpg','1','1','','0','0','0','г ǿ','','','','a:3:{s:4:\"head\";s:0:\"\";s:4:\"foot\";s:0:\"\";s:8:\"bencandy\";s:0:\"\";}','0','','0','0','','','','','','0','0','0','','1484728274','0','0','0','0','','','1','0','0','0','');
INSERT INTO `qb_news_content` VALUES ('960','ݻ֭˶ ','','39','0','ʳĻ','23','1','0','1292986577','1292986577','1','admin','','','','','0','qb_news_/39/1_20160426140430_prlax.jpg','1','1','','0','0','0',' ֭  ','','','','a:3:{s:4:\"head\";s:0:\"\";s:4:\"foot\";s:0:\"\";s:8:\"bencandy\";s:0:\"\";}','0','','0','0','','','','','','0','0','0','','1469698182','0','0','0','0','','','1','0','0','0','');
INSERT INTO `qb_news_content` VALUES ('961','Զ ζѵ','','39','0','ʳĻ','61','1','0','1292986635','1292986635','1','admin','','','','','0','qb_news_/39/1_20160426140415_p939h.jpg','1','1','','0','0','0','Զ ζ','','','','a:3:{s:4:\"head\";s:0:\"\";s:4:\"foot\";s:0:\"\";s:8:\"bencandy\";s:0:\"\";}','0','','0','0','','','','','','0','0','0','','1484882795','0','0','0','0','','','1','0','0','0','');
INSERT INTO `qb_news_content` VALUES ('962','6߱ ͽͼ','','31','0','Ļ','94','1','0','1292986709','1292986709','1','admin','','','','','0','qb_news_/31/1_20160615180653_syezn.jpg','1','1','','0','0','0','6 ߱  ͽ ͼ','','','','a:3:{s:4:\"head\";s:0:\"\";s:4:\"foot\";s:0:\"\";s:8:\"bencandy\";s:0:\"\";}','0','','0','0','','','','','','0','0','0','','1487229035','0','0','0','0','','','1','0','0','0','');
INSERT INTO `qb_news_content` VALUES ('963',' ŷ޻̱','','32','0','ɼ','239','1','2','1292986746','1683119616','1','admin','','','','','0','qb_news_/32/1_20170121160105_yjb6n.jpg','1','1','','0','1','0','   ŷ   ̱','','','','a:3:{s:4:\"head\";s:0:\"\";s:4:\"foot\";s:0:\"\";s:8:\"bencandy\";s:0:\"\";}','0','','0','0','','','','','','0','0','0','','1487313636','0','0','0','0','','','1','1','0','0','a:4:{i:0;s:38:\"qb_news_/32/1_20170121160105_yjb6n.jpg\";i:1;s:38:\"qb_news_/32/1_20170119100111_lmuj3.jpg\";i:2;s:38:\"qb_news_/32/1_20170119100100_izuyb.jpg\";i:3;s:38:\"qb_news_/32/1_20170119100152_z8fgu.jpg\";}');
INSERT INTO `qb_news_content` VALUES ('943','ηӦϢ','','44','0','ָ','6','1','0','1287452874','1287452874','1','admin','','','','','0','','0','1','','0','0','0','  Ӧ Ϣ','','','','a:3:{s:4:\"head\";s:0:\"\";s:4:\"foot\";s:0:\"\";s:8:\"bencandy\";s:0:\"\";}','0','','0','0','','','','','','0','0','0','','1462257462','0','0','0','0','','','1','0','0','0','');
INSERT INTO `qb_news_content` VALUES ('944','ηϢ','','44','0','ָ','2','1','0','1287452913','1287452913','1','admin','','','','','0','','0','1','','0','0','0','   Ϣ','','','','a:3:{s:4:\"head\";s:0:\"\";s:4:\"foot\";s:0:\"\";s:8:\"bencandy\";s:0:\"\";}','0','','0','0','','','','','','0','0','0','','1462257514','0','0','0','0','','','1','0','0','0','');
INSERT INTO `qb_news_content` VALUES ('945','μ˾⡱','','44','0','ָ','5','1','0','1287452960','1287452960','1','admin','','','','','0','','0','1','','0','0','0','   ˾','','','','a:3:{s:4:\"head\";s:0:\"\";s:4:\"foot\";s:0:\"\";s:8:\"bencandy\";s:0:\"\";}','0','','0','0','','','','','','0','0','0','','1487229064','0','0','0','0','','','1','0','0','0','');
INSERT INTO `qb_news_content` VALUES ('946','?','','44','0','ָ','6','1','0','1287466830','1287466830','1','admin','','','','','0','','0','1','','0','0','0','  ','','','','a:3:{s:4:\"head\";s:0:\"\";s:4:\"foot\";s:0:\"\";s:8:\"bencandy\";s:0:\"\";}','0','','0','0','','','','','','0','0','0','','1351149532','0','0','0','0','','','1','0','0','0','');
INSERT INTO `qb_news_content` VALUES ('947','ƻԱͨ','','44','0','ָ','5','1','0','1287467237','1287467237','1','admin','','','','','0','','0','1','','0','0','0',' Ա ͨ ','','','','a:3:{s:4:\"head\";s:0:\"\";s:4:\"foot\";s:0:\"\";s:8:\"bencandy\";s:0:\"\";}','0','','0','0','','','','','','0','0','0','','1359348741','0','0','0','0','','','1','0','0','0','');
INSERT INTO `qb_news_content` VALUES ('948','뿪ͨƻԱ','','44','0','ָ','3','1','0','1287467259','1287467259','1','admin','','','','','0','','0','1','','0','0','0',' ͨ  Ա','','','','a:3:{s:4:\"head\";s:0:\"\";s:4:\"foot\";s:0:\"\";s:8:\"bencandy\";s:0:\"\";}','0','','0','0','','','','','','0','0','0','','1294796051','0','0','0','0','','','1','0','0','0','');
INSERT INTO `qb_news_content` VALUES ('949','ƻԱ','','44','0','ָ','3','1','0','1287467280','1287467280','1','admin','','','','','0','','0','1','','0','0','0',' Ա ','','','','a:3:{s:4:\"head\";s:0:\"\";s:4:\"foot\";s:0:\"\";s:8:\"bencandy\";s:0:\"\";}','0','','0','0','','','','','','0','0','0','','1294796044','0','0','0','0','','','1','0','0','0','');
INSERT INTO `qb_news_content` VALUES ('950','Ʊѯ','','45','0','Ϣѯ','8','1','0','1290405701','1290405701','1','admin','','','','','0','','0','1','','0','0','0','Ʊ ѯ','','http://search.huochepiao.com/','','a:3:{s:4:\"head\";s:0:\"\";s:4:\"foot\";s:0:\"\";s:8:\"bencandy\";s:0:\"\";}','0','','0','0','','','','','','0','0','0','','1295314025','0','0','0','0','','','1','0','0','0','');
INSERT INTO `qb_news_content` VALUES ('951','Ԥѯ','','45','0','Ϣѯ','9','1','0','1290405834','1290405834','1','admin','','','','','0','','0','1','','0','0','0','Ԥ ѯ','','http://www.nmc.gov.cn/publish/forecast/AGD/guangzhou.html','','a:3:{s:4:\"head\";s:0:\"\";s:4:\"foot\";s:0:\"\";s:8:\"bencandy\";s:0:\"\";}','0','','0','0','','','','','','0','0','0','','1461920956','0','0','0','0','','','1','0','0','0','');
INSERT INTO `qb_news_content` VALUES ('952','Ʊѯ','','45','0','Ϣѯ','10','1','0','1290405915','1290405915','1','admin','','','','','0','','0','1','','0','0','0','Ʊѯ','','http://flight.elong.com/index_cn.html','','a:3:{s:4:\"head\";s:0:\"\";s:4:\"foot\";s:0:\"\";s:8:\"bencandy\";s:0:\"\";}','0','','0','0','','','','','','0','0','0','','1462242587','0','0','0','0','','','1','0','0','0','');
INSERT INTO `qb_news_content` VALUES ('953','ѯ','','45','0','Ϣѯ','8','1','0','1290405979','1290405979','1','admin','','','','','0','','0','1','','0','1','1294648673',' ѯ','','http://www.zuoche.com/','','a:3:{s:4:\"head\";s:0:\"\";s:4:\"foot\";s:0:\"\";s:8:\"bencandy\";s:0:\"\";}','0','','0','0','','','','','','0','0','0','','1461650902','0','0','0','0','','','1','0','0','0','');
INSERT INTO `qb_news_content` VALUES ('954','ȫͨΥ²ѯ','','45','0','Ϣѯ','7','1','0','1290406047','1290406047','1','admin','','','','','0','','0','1','','0','0','0','ȫ  ͨ Υ ѯ','','','','a:3:{s:4:\"head\";s:0:\"\";s:4:\"foot\";s:0:\"\";s:8:\"bencandy\";s:0:\"\";}','0','','0','0','','','','','','0','0','0','','1482137005','0','0','0','0','','','1','0','0','0','');
INSERT INTO `qb_news_content_1` VALUES ('934','','940','44','1','1','ô!','0');
INSERT INTO `qb_news_content_1` VALUES ('935','','941','44','1','1','ѡΪͨԱȫѵģ<br />\r\nעΪͨԱ·<br />\r\n˾<br />\r\nƷչ̨ <br />\r\nѼйĸ!<br />\r\n۵绰ĲƷ5ΪVIPƻԱ','0');
INSERT INTO `qb_news_content_1` VALUES ('936','','942','44','1','1','ԲǵĿͷ 0500-87382000Ƕݽк˶ԹԽʺźȷϵķʽ֪ͨ<br />\r\n','0');
INSERT INTO `qb_news_content_1` VALUES ('937','','943','44','1','1','עΪԱ󣬶ԷϢ£<br />\r\nǻԱעԱǻԱһ<br />\r\nҳұߵġԱ¼¼󣬽롰Աҡ<br />\r\nѡҳֵ߲ Ϣ룻<br />\r\nѡʵҵ<br />\r\nҪȷдݲͱ<br />\r\n','0');
INSERT INTO `qb_news_content_1` VALUES ('938','','944','44','1','1','ǸԱ<br />\r\nעΪԱͿԷϢ£<br />\r\n¼Աңġ̻ӣ<br />\r\nѡΪ򡱼ʵķࣻ<br />\r\nȷдݲύϢ <br />\r\n<br />\r\nǸԱ<br />\r\nҳ Ϣ Աߵ ɹϢ ťֱӷϢ','0');
INSERT INTO `qb_news_content_1` VALUES ('939','','945','44','1','1','ҪעΪԱ<br />\r\n¼Աңڡ˾ܡĿﰴʾһһϸд<p>&nbsp;</p>\r\n','0');
INSERT INTO `qb_news_content_1` VALUES ('940','','946','44','1','1','Ҫע,ȻԱľͿ','0');
INSERT INTO `qb_news_content_1` VALUES ('941','','947','44','1','1','ע','0');
INSERT INTO `qb_news_content_1` VALUES ('942','','948','44','1','1','<p>ע</p>\r\n<p>&nbsp;</p>\r\n<p>&nbsp;</p>\r\n','0');
INSERT INTO `qb_news_content_1` VALUES ('943','','949','44','1','1','<p>ע</p>\r\n<p>&nbsp;</p>\r\n','0');
INSERT INTO `qb_news_content_1` VALUES ('949','','955','39','1','1','<p>ӪʦԷ᲻һֻˣȻѧԺ˶뽡ϵ˶Ӫѧר˼򵥵һٷȴ׵߸˼ߡóԵľͲ뷨˵ӪζͬһãؼѧʳĴԼӪʳĳԷһѼ㡢ɳԡרһǿһƬΣһ٣ԵýһҪᴩʽУܵõ֡ </p>','0');
INSERT INTO `qb_news_content_1` VALUES ('950','','956','37','1','1','<p> </p><p>άpбѪܱڵԵãÿ100б㺬άp750ˡ߲޳Ըըַӣᵼάʧ50%֮ࡣƼԽŹƣм飬𵽵׺á</p><p>ϣ200ˡŹ250ˡ15ˡͷ飩15ˡл10ˡ15ˣΡǡۡ顢</p><p>ŹϴնΡ顢ۡͰȱãȥѣϴ鱸ãϴг״ƽ׹㱸ãͣ⡢飬ŹǴ𷭳׾ƣˮӡ飬Ρǡ۵ζл͸ϵϴлɡ</p><p> </p><p><br /></p>','0');
INSERT INTO `qb_news_content_1` VALUES ('951','','957','37','1','1','<p>ζ</p><p>ڴƼһϵĳԷϵѿڸˬࡢۣҪﵽЧԭϵ֮⣬һҪھлҪˮˮȴǸʩμΪϣһθĳԷ</p><p>ϣ300ˡܾ30ˡж30ˡը10ˡ콷˿10ˡըƬ5ˡ֥Ρ¶͡͸</p><p>ϴС飬죬ȡˮȴȻȡڣܾ硢жΡ콷˿Ρ¶ͺͻͰȣը֥ըƬɡ<br /></p>','0');
INSERT INTO `qb_news_content_1` VALUES ('952','','958','37','1','1','<p><span style=\"color:#000000;font-size:medium;font-family:simsun;font-weight:normal;font-style:normal;\"><span style=\"color:#6a6a6a;font-size:14px;font-family:;\"><p>خɳʮӿ¿źźͲԲźƤϺɫŨ۶࣬дۡźƽζʣƵ΢Ԫء죬һźһźʳϻźźƬԾʡ </p><p style=\"text-align:center;\"><img onload=\"if(this.width&gt;600)makesmallpic(this,600,1800);\" src=\"http://food.gznet.com/Admin/Upfile/Image/20101215/1292376497141.jpg\" width=\"500\" height=\"331\" /></p><p>ź̶</p><p>ԭϣźͲ600ˡ250ˡ̶130ˡ2Ƭ5 </p><p>1Ƚźϴɾ2ϴˮ3̶30ӣ4źͲ濪ڣ̶źͲȻǩڷãʣµ̶ 5вϷŽڼˮҹ󣬸ΪС2Сʱαã 6źȡõƬϵ </p></span></span></p>','0');
INSERT INTO `qb_news_content_1` VALUES ('953','','959','39','1','1','<p><span style=\"color:#000000;font-size:medium;font-family:simsun;font-weight:normal;font-style:normal;\"><span style=\"color:#6a6a6a;font-size:14px;font-family:;\"><p style=\"text-align:center;\"><img onload=\"if(this.width&gt;600)makesmallpic(this,600,1800);\" src=\"http://food.gznet.com/Admin/Upfile/Image/20101207/1291681868746.jpg\" width=\"300\" height=\"264\" /></p><p>ζ</p><p>ζӪߣÿ100ке18ԼάأвѪǿʳЧ㳴ըսԿɣƼԽ֮ټͷζŪһζСˡע䣬벤ͬʳ¸к빷ͬʳʹò</p><p>ϣ500ˡƬ20ˡж20ˡͷȥ飩15ˣΡǡۡͷ顢ۡ׾ơ͸</p><p>׺ȥ࣬ˮ80棬30룬ȻȡõȥϵİɫҺˮϴɾƬãͣ⡢ƬʹжΣƬ𷭳Ȼ֭ƺͷζͼɡ</p></span></span></p>','0');
INSERT INTO `qb_news_content_1` VALUES ('954','','960','39','1','1','<p><span style=\"color:#000000;font-size:medium;font-family:simsun;font-weight:normal;font-style:normal;\"><span style=\"color:#6a6a6a;font-size:14px;font-family:;\"><p style=\"text-align:center;\"><img onload=\"if(this.width&gt;600)makesmallpic(this,600,1800);\" src=\"http://food.gznet.com/Admin/Upfile/Image/20101209/1291870424250.jpg\" width=\"300\" height=\"278\" /></p><p>ζ</p><p>ﶬʱвͬʱСˣ߽վƷһݻ֭󶹸ݻΪʳϵĳʳЧ֮Ϊһֶصķ񡣳ݻͶһֺгӪˣڸк˳</p><p>ϣ4顢ݻ5ˡˮ50ˡ˿50ˡж15ˡͷȥ飩15ˣΡǡ͡Ũ֧֭װ͸</p><p>ݻϴãС飬ƽ׹ƱãƬãͣ⡢жκ˿붹СķȻˮŨ֭ͳݻͣζл5ζɡ</p></span></span></p>','0');
INSERT INTO `qb_news_content_1` VALUES ('955','','961','39','1','1','<p><span style=\"color:#000000;font-size:medium;font-family:simsun;font-weight:normal;font-style:normal;\"><span style=\"color:#6a6a6a;font-size:14px;font-family:;\"></span></span></p><p style=\"text-align:center;\"><img onload=\"if(this.width&gt;600)makesmallpic(this,600,1800);\" src=\"http://food.gznet.com/Admin/Upfile/Image/20101117/1289956817840.jpg\" width=\"480\" height=\"365\" /><br />о䱦</p><p>/  &nbsp;ʵϰ ƽ ͼ/</p><p>ƣʾÿ11µ4£յļڡʱ򺣬Ϊ׼ȹĺŬڻڵֺ֬Լ÷顢֭ˮ㣬֪øǴ󱥿ڸĻᡣ</p><p>¡Ƶвġ硱 ʱǵҰٿɼѰ</p><p style=\"text-align:center;\"><img onload=\"if(this.width&gt;600)makesmallpic(this,600,1800);\" src=\"http://food.gznet.com/Admin/Upfile/Image/20101117/1289956849260.jpg\" width=\"480\" height=\"333\" /><br />޹</p><p><strong><span style=\"color:#800000;\">ͬ &nbsp;н</span></strong></p><p>Ρ硱ĴܣƷ磬ѡõأҪ롰򺡱֮¡</p><p>а޵ʺżͣˬڣ嵭ֲʧϢζޱƳģǲ̵ˮӵķ¡ӿڵζڷḻĿʣ񼶵Ͷױʵݣ˳ģۣԴ⡣</p><p>˽ʱ⣬Ӧע˳ɵŨԵͬĶζŨȡںĺˮ̶ȣѵ˳Ӧȳձ򺣬ȻϷǡո򺣬ֵ򺡣</p><p>һԷ޹ֻ߶һ˽ֻʢ5ֲֻڱϡһ͵ܱ򺡢ɽɽ򺡢򺡢򺡢ʡΣЩȹĸͷҪС࣬Ǳƽȫͬڹ򺰼͹ƽĿǱԵ㣬Ӧ֪ı߿ʼ˰ɣ</p><p><br/></p>','0');
INSERT INTO `qb_news_content_1` VALUES ('956','','962','31','1','1','<p>ʺ·ĳС</p><p>ֻҪһִ߽ͻᰮϹݡԽ2000ʷĹݳǣСдźܶѰζʹͳ̽ѰӵĶ</p><p>ﵵ</p><p>Karl Fjellstrom ()</p><p> Ĵ</p><p>Karl ļǰĴǵĲ˹࣬뿪ǸĳֵĹݣѾˡΪк޷չнͨרңͬʱһӪԻ֯ITDPͨ뷢չойִиܲãKarlоٽɳͨйռ䷢չĿݵBRT̡гȷ涼Karl칫ṩĴ֧ԮKarlһСɫͨĻⶼǳð͹õǣKarlԼҲǸΪϲеˡ</p>','0');
INSERT INTO `qb_news_content_1` VALUES ('957','','963','32','1','1','<p>» ְ֣ǵ͢𣿡Ӣ׶ϣ˼޻һСѿ׷ʡΪ򷢺ʱ䣬׸ͯ顢κ˿ơ</p><p>Ƴÿ͵ӣ1219ռŷ޶ͨŦݡ</p><p>ǿѩӰ죬ŷһЩҪɡ̱ߡ̱һЩ¡ֻԭʥʱڵĻȡ</p><p>ѩ¡¹ʡŷýİ档</p><p>19գӢФ´ﵽ19϶ȣ޵ǱСΤĳ21϶ȵ£ʱֵӭ11³ĵ18ѩա</p><p>Ӣ˵12Ӣѩǿȿ198112¡ӢԤ⣬˵20Խֽѩ˿Ҫڱѩжȹʥڡ</p><p>ŷԣƣδһʱڣԽŷ޴½ɡ</p><p><br /></p>','0');
INSERT INTO `qb_news_content_1` VALUES ('944','','950','45','1','1','','0');
INSERT INTO `qb_news_content_1` VALUES ('945','','951','45','1','1','','0');
INSERT INTO `qb_news_content_1` VALUES ('946','','952','45','1','1','','0');
INSERT INTO `qb_news_content_1` VALUES ('947','','953','45','1','1','','0');
INSERT INTO `qb_news_content_1` VALUES ('948','','954','45','1','1','<p align=\"center\"><strong><span><font color=\"#339900\" size=\"4\">ȫͨΥ²ѯ</font></span></strong> </p>\r\n<table border=\"1\" cellspacing=\"1\" cellpadding=\"4\" width=\"770\"><tbody><tr><td><strong><font color=\"#ffffff\">ֱϽнͨΥ²ѯ</font></strong> </td><td><strong><font color=\"#ffffff\">ʡͨΥ²ѯ</font></strong></td><td><a href=\"http://www.jg7777.com:8080/\"><strong><font color=\"#ffffff\">ӱʡͨΥ²ѯ</font></strong></a></td></tr><tr><td><a href=\"http://www.bjjtgl.gov.cn/publish/portal0/tab72/\"><font color=\"#1c5f82\"></font></a></td><td><a href=\"http://www.xianjj.com/index.aspx\"><font color=\"#1c5f82\"></font></a></td><td><a href=\"http://jgxx.hengshui.com/\"><font color=\"#1c5f82\">ˮ</font></a></td></tr><tr><td><a href=\"http://www.shjtaq.com/\"><font color=\"#1c5f82\">Ϻ</font></a></td><td><a href=\"http://www.tc122.com/\"><font color=\"#1c5f82\">ͭ</font></a></td><td><a href=\"http://www.hdjj.gov.cn/\"><font color=\"#1c5f82\"></font></a></td></tr><tr><td><a href=\"http://www.tjits.cn/wfcx/index.asp\"><font color=\"#1c5f82\"></font></a></td><td><a href=\"http://gaj.baoji.gov.cn/clcx.asp\"><font color=\"#1c5f82\"></font></a></td><td><a href=\"http://www.zjkjjw.com.cn/\"><font color=\"#1c5f82\">żҿ</font></a></td></tr><tr><td><a href=\"http://www.cqjg.gov.cn/DriverFind.html\"><font color=\"#1c5f82\"></font></a></td><td><a href=\"http://www.xyjjzd.gov.cn/\"><font color=\"#1c5f82\"></font></a></td><td><a href=\"http://ts.jdcjsr.com/\"><font color=\"#1c5f82\">ɽ</font></a></td></tr><tr><td>&nbsp;</td><td><a href=\"http://www.hzjjd.com/weifachaxun/Index.asp\"><font color=\"#1c5f82\"></font></a></td><td><a href=\"http://www.qhdjtgl.com.cn/\"><font color=\"#1c5f82\">ػʵ</font></a></td></tr><tr><td>&nbsp;</td><td><a href=\"http://www.0912158.com/jtwz/index.html\"><font color=\"#1c5f82\"></font></a></td><td><a href=\"http://www.jdcjsr.com/cheliangweizhang/cdweizhang.aspx\"><font color=\"#1c5f82\">е</font></a></td></tr><tr><td>&nbsp;</td><td><a href=\"http://cx.akjjzd.gov.cn/\"><font color=\"#1c5f82\"></font></a></td><td><a href=\"http://www.jdcjsr.com/weizhang.aspx\"><font color=\"#1c5f82\">ʯׯ</font></a></td></tr><tr><td>&nbsp;</td><td><a href=\"http://www.yajjzd.com/Index.asp\"><font color=\"#1c5f82\">Ӱ</font></a></td><td><a href=\"http://www.bdjiaojing.cn/\"><font color=\"#1c5f82\"></font></a></td></tr><tr><td>&nbsp;</td><td><a href=\"http://www.wnsjj.cn/\"><font color=\"#1c5f82\">μ</font></a></td><td><a href=\"http://www.jdcjsr.com/cheliangweizhang/czweizhang.aspx\"><font color=\"#1c5f82\"></font></a></td></tr><tr><td>&nbsp;</td><td>&nbsp;</td><td><a href=\"http://www.xtjdcjsr.com/\"><font color=\"#1c5f82\">̨</font></a></td></tr><tr><td><strong><a href=\"http://www.gdga.gov.cn/service/jjwzcx/index.jsp\"><font color=\"#ffffff\">㶫ʡͨΥ²ѯ</font></a></strong></td><td><strong><a href=\"http://cgs.lnga.gov.cn:9080/lngg/indexjdc.jsp\"><font color=\"#ffffff\">ʡͨΥ²ѯ</font></a></strong></td><td><strong><a href=\"http://find.96911.com/jxj/\"><font color=\"#ffffff\">ʡͨΥ²ѯ</font></a></strong></td></tr><tr><td><a href=\"http://www.gzjd.gov.cn/jiaotong/transgressQuery_jsp_catid_61_69.html\"><font color=\"#1c5f82\"></font></a></td><td><a href=\"http://www.sygajj.gov.cn/\"><font color=\"#1c5f82\"></font></a></td><td><a href=\"http://www.njjg.net/\"><font color=\"#1c5f82\">Ͼ</font></a></td></tr><tr><td><a href=\"http://www.stc.gov.cn/search/vehicle_peccacy.asp\"><font color=\"#1c5f82\"></font></a></td><td><a href=\"http://www.zgcy.gov.cn/car_seek/\"><font color=\"#1c5f82\"></font></a></td><td><a href=\"http://58.210.126.206:9091/QueryVD/\"><font color=\"#1c5f82\"></font></a></td></tr><tr><td><a href=\"http://mzjj.meizhou.net/\"><font color=\"#1c5f82\">÷</font></a></td><td><a href=\"http://www.dlutc.gov.cn/\"><font color=\"#1c5f82\"></font></a></td><td><a href=\"http://czjxj.czinfo.net/dzjccx.htm\"><font color=\"#1c5f82\"></font></a></td></tr><tr><td><a href=\"http://wz.zhga.gov.cn/\"><font color=\"#1c5f82\">麣</font></a></td><td><a href=\"http://www.ykjj.gov.cn/wfcx.php\"><font color=\"#1c5f82\">Ӫ</font></a></td><td><a href=\"http://www.ntjxj.com/InternetWeb/\"><font color=\"#1c5f82\">ͨ</font></a></td></tr><tr><td><a href=\"http://weizhang.jmjgj.gov.cn/\"><font color=\"#1c5f82\"></font></a></td><td><a href=\"http://jjd.panjin.gov.cn/index.php\"><font color=\"#1c5f82\">̽</font></a></td><td><a href=\"http://www.sqjg.net/wzcx/TipInfo.aspx\"><font color=\"#1c5f82\">Ǩ</font></a></td></tr><tr><td><a href=\"http://www.hzinfo168.com/v2new/result2.asp\"><font color=\"#1c5f82\"></font></a></td><td><a href=\"http://www.tlga.gov.cn/jdc.jsp?name1=list_jdc.jsp&name2=kb.html?lb=2\"><font color=\"#1c5f82\"></font></a></td><td><a href=\"http://jxj.wuxi.gov.cn/\"><font color=\"#1c5f82\"></font></a></td></tr><tr><td><a href=\"http://www.0662.com.cn/police/index.asp\"><font color=\"#1c5f82\"></font></a></td><td><a href=\"http://www.bxgaggfwpt.gov.cn/\"><font color=\"#1c5f82\">Ϫ</font></a></td><td><a href=\"http://www.xzjgw.com/\"><font color=\"#1c5f82\"></font></a></td></tr><tr><td><a href=\"http://www.fsga.gov.cn/Main/Common/QueryPage.aspx?formID=D8928000CDCD4566A001C4554628F3F1&parentName=572R5LiK6K2m5Yqh\"><font color=\"#1c5f82\">ɽ</font></a></td><td><a href=\"http://www.dd122.com/pages/xxcx.asp\"><font color=\"#1c5f82\"></font></a></td><td><a href=\"http://www.zjcgs.com/\"><font color=\"#1c5f82\"></font></a></td></tr><tr><td><a href=\"http://www.gddg110.cn/publicfiles/business/htmlfiles/dgjch/s14385/list.htm\"><font color=\"#1c5f82\">ݸ</font></a></td><td><a href=\"http://www.jzgajx.com/homepart/default2.aspx\"><font color=\"#1c5f82\"></font></a></td><td><a href=\"http://www.lygjg.net/traffic.aspx\"><font color=\"#1c5f82\">Ƹ</font></a></td></tr><tr><td><a href=\"http://mmjj.maoming.gov.cn/\"><font color=\"#1c5f82\">ï</font></a></td><td><a href=\"http://www.liaoyang.gov.cn/moban/wsfw/wscx07.asp\"><font color=\"#1c5f82\"></font></a></td><td><a href=\"http://www.tzpolice.gov.cn/\"><font color=\"#1c5f82\">̩</font></a></td></tr><tr><td><a href=\"http://www.gdst110.gov.cn/\"><font color=\"#1c5f82\">ͷ</font></a></td><td><a href=\"http://www.hldgajjzd.com/sjcx/Index.asp\"><font color=\"#1c5f82\">«</font></a></td><td><a href=\"http://www.ycjxj.cn/InfoSearch.asp\"><font color=\"#1c5f82\">γ</font></a></td></tr><tr><td><a href=\"http://www.zqga.gov.cn/\"><font color=\"#1c5f82\"></font></a></td><td><a href=\"http://www.asgajj.com/\"><font color=\"#1c5f82\">ɽ</font></a></td><td><a href=\"http://www.ntjxj.com/InternetWeb/\"><font color=\"#1c5f82\">ͨ</font></a></td></tr><tr><td><a href=\"http://www.cztp.gov.cn/news/4.asp\"><font color=\"#1c5f82\"></font></a></td><td>&nbsp;</td><td><a href=\"http://0517b2c.oicp.net/default.asp\"><font color=\"#1c5f82\"></font></a></td></tr><tr><td><a href=\"http://www.jyjj.gov.cn/wzcxjg.asp\"><font color=\"#1c5f82\"></font></a></td><td>&nbsp;</td><td><a href=\"http://www.yangzhou.gov.cn/jtcx/index.php\"><font color=\"#1c5f82\"></font></a></td></tr><tr><td><a href=\"http://www.qyga.gov.cn/qysms20/wfclxx/wfywcx.jsp\"><font color=\"#1c5f82\">Զ</font></a></td><td><strong><font color=\"#ffffff\">ɽʡͨΥ²ѯ</font></strong></td><td><b><a href=\"http://s.jljj.cn/\"><font color=\"#ffffff\">ʡͨΥ²ѯ</font></a></b></td></tr><tr><td><a href=\"http://www.gdsw110.gov.cn/\"><font color=\"#1c5f82\">β</font></a></td><td><a href=\"http://www.jnjj.com/\"><font color=\"#1c5f82\"></font></a></td><td><a href=\"http://www.ybjg.gov.cn/wzch/index.asp?Modid=013001\"><font color=\"#1c5f82\">Ӽ</font></a></td></tr><tr><td><a href=\"http://www.sgjjzd.gov.cn/jdcwf.aspx\"><font color=\"#1c5f82\">ع</font></a></td><td><a href=\"http://www.ytjj.gov.cn/\"><font color=\"#1c5f82\">̨</font></a></td><td><a href=\"http://fw.0437.gov.cn/wz/\"><font color=\"#1c5f82\">Դ</font></a></td></tr><tr><td><a href=\"http://www.zjjj.gov.cn/\"><font color=\"#1c5f82\">տ</font></a></td><td><a href=\"http://traffic.qingdaomedia.com/122/dzjc-cx.asp\"><font color=\"#1c5f82\">ൺ</font></a></td><td><a href=\"http://www.ccjg.gov.cn/\"><font color=\"#1c5f82\"></font></a></td></tr><tr><td><a href=\"http://www.gdzs110.gov.cn/\"><font color=\"#1c5f82\">ɽ</font></a></td><td><a href=\"http://www.zbjj.gov.cn/\"><font color=\"#1c5f82\">Ͳ</font></a></td><td><a href=\"http://www.ybjg.gov.cn/wzch/index.asp?Modid=013001\"><font color=\"#1c5f82\">ӱ</font></a></td></tr><tr><td><a href=\"http://www.gdhy110.gov.cn/cms/index.htm#\"><font color=\"#1c5f82\">Դ</font></a></td><td><a href=\"http://www.sdzzjj.com/veh/index.htm\"><font color=\"#1c5f82\">ׯ</font></a></td><td><a href=\"http://221.8.71.21/dhjl/site/dhjlcms/wssc/tonghua.html\"><font color=\"#1c5f82\">ͨ</font></a></td></tr><tr><td><a href=\"http://www.yfga.gov.cn/website/newdeptemps/gaj/index.jsp?topid=009001054\"><font color=\"#1c5f82\">Ƹ</font></a></td><td><a href=\"http://www.jnjj.gov.cn/\"><font color=\"#1c5f82\"></font></a></td><td><a href=\"http://www.bcjjzd.com/web/qx/cl.asp\"><font color=\"#1c5f82\">׳</font></a></td></tr><tr><td>&nbsp;</td><td><a href=\"http://www.whdzjc.com/\"><font color=\"#1c5f82\"></font></a></td><td><a href=\"http://www.jlzxz.com/c/\"><font color=\"#1c5f82\">ɽ</font></a></td></tr><tr><td>&nbsp;</td><td><a href=\"http://www.rzjj.com.cn:8810/\"><font color=\"#1c5f82\"></font></a></td><td>&nbsp;</td></tr><tr><td>&nbsp;</td><td><a href=\"http://www.laiwu.gov.cn/car/weizhang_search.asp\"><font color=\"#1c5f82\"></font></a></td><td>&nbsp;</td></tr><tr><td>&nbsp;</td><td><a href=\"http://www.hzjjxx.cn/\"><font color=\"#1c5f82\"></font></a></td><td>&nbsp;</td></tr><tr><td>&nbsp;</td><td><a href=\"http://www.dzjiaojing.com/zbhm/WT_index.aspx\"><font color=\"#1c5f82\"></font></a></td><td>&nbsp;</td></tr><tr><td>&nbsp;</td><td><a href=\"http://119.191.61.214:9080/wsgg/jdccx.do\"><font color=\"#1c5f82\">Ϋ</font></a></td><td>&nbsp;</td></tr><tr><td>&nbsp;</td><td><a href=\"http://www.dygajj.gov.cn:9080/jncmp/html/jdcwf/jdcwf2.html\"><font color=\"#1c5f82\">Ӫ</font></a></td><td>&nbsp;</td></tr><tr><td>&nbsp;</td><td><a href=\"http://www.lcjxj.com/\"><font color=\"#1c5f82\">ĳ</font></a></td><td>&nbsp;</td></tr><tr><td><a href=\"http://www.hnjj.gov.cn/query/xxcx1.jsp\"><strong><font color=\"#ffffff\">ʡͨΥ²ѯ</font></strong></a></td><td><strong><a href=\"http://www.jxhld.gov.cn/\"><font color=\"#ffffff\">ʡͨΥ²ѯ</font></a></strong></td><td><strong><font color=\"#ffffff\">㽭ʡ</font><font color=\"#ffffff\">ͨΥ²ѯ</font></strong></td></tr><tr><td><a href=\"http://www.hncsjj.gov.cn/DefaultIE.aspx\"><font color=\"#1c5f82\">ɳ</font></a></td><td><a href=\"http://ncjj.nc.gov.cn/infos.asp\"><font color=\"#1c5f82\">ϲ</font></a></td><td><a href=\"http://www.hzti.com/service/qry/peccancy.aspx?type=2&node=248\"><font color=\"#1c5f82\"></font></a></td></tr><tr><td><a href=\"http://www.cz110.gov.cn/\"><font color=\"#1c5f82\"></font></a></td><td><a href=\"http://www.gz0797.com/122/auto.asp\"><font color=\"#1c5f82\"></font></a></td><td><a href=\"http://wf.nbjj.gov.cn/\"><font color=\"#1c5f82\"></font></a></td></tr><tr><td><a href=\"http://www.hnhyjj.gov.cn/HYJJXXW/\"><font color=\"#1c5f82\"></font></a></td><td><a href=\"http://www.jjjj.com.cn/\"><font color=\"#1c5f82\">Ž</font></a></td><td><a href=\"http://www.jhjxj.gov.cn/find/\"><font color=\"#1c5f82\"></font></a></td></tr><tr><td><a href=\"http://www.cdjjzd.gov.cn/\"><font color=\"#1c5f82\"></font></a></td><td><a href=\"http://www.jdzxx.com/\"><font color=\"#1c5f82\"></font></a></td><td><a href=\"http://www.wzsjj.cn/\"><font color=\"#1c5f82\"></font></a></td></tr><tr><td><a href=\"http://so.jtjc.cn/\"><font color=\"#1c5f82\"></font></a></td><td><a href=\"http://www.jxyjb.com/\"><font color=\"#1c5f82\"></font></a></td><td><a href=\"http://www.police.zhoushan.gov.cn/Services_Illegal.asp\"><font color=\"#1c5f82\">ɽ</font></a></td></tr><tr><td><a href=\"http://www.sysgajj.gov.cn/\"><font color=\"#1c5f82\"></font></a></td><td><a href=\"http://www.jxfzjj.cn/web/jdc_search.asp\"><font color=\"#1c5f82\"></font></a></td><td><a href=\"http://www.hzgaj.gov.cn/\"><font color=\"#1c5f82\"></font></a></td></tr><tr><td><a href=\"http://www.hnloudi.gov.cn/Category_811/index.aspx\"><font color=\"#1c5f82\">¦</font></a></td><td><a href=\"http://www.ycsga.gov.cn/\"><font color=\"#1c5f82\">˴</font></a></td><td><a href=\"http://www.zjjxjj.gov.cn/\"><font color=\"#1c5f82\"></font></a></td></tr><tr><td>&nbsp;</td><td><a href=\"http://www.jagajj.gov.cn/\"><font color=\"#1c5f82\"></font></a></td><td><a href=\"http://gaj.qz.gov.cn/eleclist.asp\"><font color=\"#1c5f82\"></font></a></td></tr><tr><td>&nbsp;</td><td>&nbsp;</td><td><a href=\"http://www.tzga.gov.cn/\"><font color=\"#1c5f82\">̨</font></a></td></tr><tr><td>&nbsp;</td><td>&nbsp;</td><td><a href=\"http://61.153.62.58/\"><font color=\"#1c5f82\">ˮ</font></a></td></tr><tr><td>&nbsp;</td><td>&nbsp;</td><td><a href=\"http://122.224.38.212/\"><font color=\"#1c5f82\"></font></a></td></tr><tr><td><b><a href=\"http://www.135000.com/\"><font color=\"#ffffff\">ʡͨΥ²ѯ</font></a></b></td><td><strong><a href=\"http://www.ahjtxx.com/query.aspx\"><font color=\"#ffffff\">ʡͨΥ²ѯ</font></a></strong></td><td><a href=\"http://www.scjj.gov.cn/\"><font color=\"#ffffff\"><b>ĴʡͨΥ²ѯ</b></font></a></td></tr><tr><td><a href=\"http://www.zzcgs.com.cn/peccancy/search_info.jsp\"><font color=\"#1c5f82\">֣</font></a></td><td><a href=\"http://www.hfjjzd.gov.cn/List.asp?Class=1\"><font color=\"#1c5f82\">Ϸ</font></a></td><td><a href=\"http://www.cdjg.gov.cn/\"><font color=\"#1c5f82\">ɶ</font></a></td></tr><tr><td><a href=\"http://www.nydzjc.com/\"><font color=\"#1c5f82\"></font></a></td><td><a href=\"http://218.22.27.66:8888/Main.aspx?fzjg=B\"><font color=\"#1c5f82\">ߺ</font></a></td><td><a href=\"http://www.myjtaq.com/newsmore.asp?ClassID=29\"><font color=\"#1c5f82\"></font></a></td></tr><tr><td><a href=\"http://www.jzga.gov.cn/wzcx/lookup.aspx\"><font color=\"#1c5f82\"></font></a></td><td><a href=\"http://www.ahhnjj.net/\"><font color=\"#1c5f82\"></font></a></td><td><a href=\"http://www.122114.com/\"><font color=\"#1c5f82\">Թ</font></a></td></tr><tr><td><a href=\"http://www.lyjjzd.com/\"><font color=\"#1c5f82\"></font></a></td><td><a href=\"http://jjzd.mas.gov.cn/\"><font color=\"#1c5f82\">ɽ</font></a></td><td><a href=\"http://www.sclzjj.gov.cn/t_Search.aspx\"><font color=\"#1c5f82\"></font></a></td></tr><tr><td><a href=\"http://cx.395.cn/wzcx/\"><font color=\"#1c5f82\"></font></a></td><td><a href=\"http://www.chga.gov.cn/jtwfcx/jtwfcx.asp\"><font color=\"#1c5f82\"></font></a></td><td><a href=\"http://www.pzh122.com/\"><font color=\"#1c5f82\">֦</font></a></td></tr><tr><td><a href=\"http://www.puyang.gov.cn/wmjdcwz.asp\"><font color=\"#1c5f82\"></font></a></td><td><a href=\"http://bzjj.bz163.net/Index.asp\"><font color=\"#1c5f82\"></font></a></td><td><a href=\"http://dzjj.dz169.net/\"><font color=\"#1c5f82\"></font></a></td></tr><tr><td><a href=\"http://www.sqradio.com/old945/jdccx.htm\"><font color=\"#1c5f82\"></font></a></td><td><a href=\"http://www.ahczjj.gov.cn/\"><font color=\"#1c5f82\"></font></a></td><td><a href=\"http://www.scgajj.gov.cn/TrafficSeach.aspx\"><font color=\"#1c5f82\">㰲</font></a></td></tr><tr><td><a href=\"http://wzcx.smx.shangdu.com/\"><font color=\"#1c5f82\">Ͽ</font></a></td><td><a href=\"http://www.bbjj.gov.cn/maincx.php\"><font color=\"#1c5f82\"></font></a></td><td><a href=\"http://www.bzjjdd.com/Index.html\"><font color=\"#1c5f82\"></font></a></td></tr><tr><td><a href=\"http://www.ayjjw.net.cn/allSearch/\"><font color=\"#1c5f82\"></font></a></td><td><a href=\"http://www.aqjj.gov.cn/AQWebQuery/Default.aspx\"><font color=\"#1c5f82\"></font></a></td><td><a href=\"http://www.scnjjj.gov.cn/\"><font color=\"#1c5f82\">ڽ</font></a></td></tr><tr><td><a href=\"http://www.xxcgs.com/infosearchs.aspx\"><font color=\"#1c5f82\"></font></a></td><td><a href=\"http://www.ahszjj.gov.cn/\"><font color=\"#1c5f82\"></font></a></td><td><a href=\"http://www.sczyjj.gov.cn/\"><font color=\"#1c5f82\"></font></a></td></tr><tr><td><a href=\"http://www.xcjjw.gov.cn/\"><font color=\"#1c5f82\"></font></a></td><td><a href=\"http://www.huangshan.gov.cn/wsbs/MotoPecc.aspx\"><font color=\"#1c5f82\">ɽ</font></a></td><td><a href=\"http://www.lsiptv.cn/traffic/\"><font color=\"#1c5f82\">ɽ</font></a></td></tr><tr><td><a href=\"http://www.pds122.com/\"><font color=\"#1c5f82\">ƽɽ</font></a></td><td><a href=\"http://218.22.27.66:8888/Main.aspx?fzjg=F\"><font color=\"#1c5f82\"></font></a></td><td><a href=\"http://www.dyjj.gov.cn/InfoQuery.aspx\"><font color=\"#1c5f82\"></font></a></td></tr><tr><td><a href=\"http://www.kfpolice.com/\"><font color=\"#1c5f82\"></font></a></td><td><a href=\"http://218.23.49.250/wfcx/Main.aspx?fzjg=G\"><font color=\"#1c5f82\">ͭ</font></a></td><td><a href=\"http://www.scgyjj.gov.cn/Default.aspx\"><font color=\"#1c5f82\">Ԫ</font></a></td></tr><tr><td><a href=\"http://www.zkga.gov.cn/\"><font color=\"#1c5f82\">ܿ</font></a></td><td><a href=\"http://www.lajjzd.gov.cn/frmVehVio.aspx\"><font color=\"#1c5f82\"></font></a></td><td>&nbsp;</td></tr><tr><td><a href=\"http://www.zhumadian.gov.cn/Traffic/index.asp\"><font color=\"#1c5f82\">פ</font></a></td><td><a href=\"http://www.chizhou.gov.cn/channels/1086.html\"><font color=\"#1c5f82\"></font></a></td><td>&nbsp;</td></tr><tr><td><strong><font color=\"#ffffff\">½ͨΥ²ѯ</font></strong></td><td><a href=\"http://hainanjj.gov.cn/index/index.html\"><strong><font color=\"#ffffff\">ʡͨΥ²ѯ</font></strong></a></td><td><strong><font color=\"#ffffff\">ؽͨΥ²ѯ</font></strong></td></tr><tr><td><a href=\"http://bbs.hm169.com/wzcx/wz.aspx\"><font color=\"#1c5f82\"></font></a></td><td><a href=\"http://www.hkjxj.gov.cn/php/wei_zcx.php\"><font color=\"#1c5f82\"></font></a></td><td><a href=\"http://www.xzlzysgs.com/Service/\"><font color=\"#1c5f82\">֥</font></a></td></tr><tr><td><a href=\"http://www.xjbzjj.com/default.asp\"><font color=\"#1c5f82\"></font></a></td><td><a href=\"http://www.syjtjc.gov.cn/\"><font color=\"#1c5f82\"></font></a></td><td>&nbsp;</td></tr><tr><td><strong><font color=\"#ffffff\">ʡͨΥ²ѯ</font></strong></td><td><a href=\"http://gsgajt.gov.cn:9080/GajtInter/InfoSerch/vehinfo.jsp\"><strong><font color=\"#ffffff\">ʡͨΥ²ѯ</font></strong></a></td><td><a href=\"http://www.gzjjzd.gov.cn/subindex.asp?leftname=subleft7&rightname=jtwfcx/hphm_cx\"><b><font color=\"#ffffff\">ʡͨΥ²ѯ</font></b></a></td></tr><tr><td><a href=\"http://www.km122.cn/q/query.html\"><font color=\"#1c5f82\"></font></a></td><td><a href=\"http://www.lzgajj.gov.cn/web/index.do\"><font color=\"#1c5f82\"></font></a></td><td><a href=\"http://jjzd.gygov.gov.cn/jjzd/2380434977553645568/\"><font color=\"#1c5f82\"></font></a></td></tr><tr><td><a href=\"http://www.yxjjzd.gov.cn/\"><font color=\"#1c5f82\">Ϫ</font></a></td><td><a href=\"http://www.tsjjzd.com/\"><font color=\"#1c5f82\">ˮ</font></a></td><td><a href=\"http://gaj.zunyi.gov.cn/cms/cms/website/gongan/jsp/index.jsp?channelId=1476\"><font color=\"#1c5f82\"></font></a></td></tr><tr><td><a href=\"http://www.dhjjxx.com/\"><font color=\"#1c5f82\">º</font></a></td><td><a href=\"http://byjj.baiyin.cn/\"><font color=\"#1c5f82\"></font></a></td><td><a href=\"http://58.16.136.34/\"><font color=\"#1c5f82\">˳</font></a></td></tr><tr><td><a href=\"http://www.hb122.org/xxcx/xxcx.jsp\"><strong><font color=\"#ffffff\">ʡͨΥ²ѯ</font></strong></a></td><td><strong><font color=\"#ffffff\">ɹŽͨΥ²ѯ</font></strong></td><td><b><a href=\"http://www.fjjj.gov.cn/\"><font color=\"#ffffff\">ʡͨΥ²ѯ</font></a></b></td></tr><tr><td><a href=\"http://wh122.cjn.cn/\"><font color=\"#1c5f82\">人</font></a></td><td><a href=\"http://www.cfauto.cn/cgs/wzcx.asp\"><font color=\"#1c5f82\"></font></a></td><td><a href=\"http://www.fzjj.net/lyb/result.php\"><font color=\"#1c5f82\"></font></a></td></tr><tr><td><a href=\"http://www.hsjj.gov.cn/\"><font color=\"#1c5f82\">ʯ</font></a></td><td><a href=\"http://www.btjj.gov.cn/\"><font color=\"#1c5f82\">ͷ</font></a></td><td><a href=\"http://www.0597car.com/weizhang.aspx\"><font color=\"#1c5f82\"></font></a></td></tr><tr><td><a href=\"http://jmapp.jingmen.gov.cn/jiaojing/\"><font color=\"#1c5f82\"></font></a></td><td><a href=\"http://cgs.hhhtgajt.com/\"><font color=\"#1c5f82\">ͺ</font></a></td><td><a href=\"http://www.xmjj.gov.cn/\"><font color=\"#1c5f82\"></font></a></td></tr><tr><td><a href=\"http://xfwfcx.com/wf.asp\"><font color=\"#1c5f82\">差</font></a></td><td><a href=\"http://www.whcgs.gov.cn/\"><font color=\"#1c5f82\">ں</font></a></td><td><a href=\"http://www.fjsmjj.com/\"><font color=\"#1c5f82\"></font></a></td></tr><tr><td><a href=\"http://www.ez122.org/\"><font color=\"#1c5f82\"></font></a></td><td><a href=\"http://www.tlcgs.com/\"><font color=\"#1c5f82\">ͨ</font></a></td><td><a href=\"http://npjjzd.net/wfcx/index.asp\"><font color=\"#1c5f82\">ƽ</font></a></td></tr><tr><td><a href=\"http://www.hbxgjj.com/_index.asp\"><font color=\"#1c5f82\">Т</font></a></td><td><a href=\"http://www.bsgajj.gov.cn/\"><font color=\"#1c5f82\">׶</font></a></td><td><a href=\"http://www.fcgjj.com/\"><font color=\"#1c5f82\">Ǹ</font></a></td></tr><tr><td><a href=\"http://www.yichang.gov.cn/col/col3062/\"><font color=\"#1c5f82\">˲</font></a></td><td>&nbsp;</td><td><a href=\"http://www.lb122.com/\"><font color=\"#1c5f82\"></font></a></td></tr><tr><td><a href=\"http://www.es122.com.cn/\"><font color=\"#1c5f82\">ʩ</font></a></td><td>&nbsp;</td><td><a href=\"http://gaj.liuzhou.gov.cn/\"><font color=\"#1c5f82\"></font></a></td></tr><tr><td><a href=\"http://www.hbsycg.com/\"><font color=\"#1c5f82\">ʮ</font></a></td><td>&nbsp;</td><td><a href=\"http://www.gg122.com/Index.html\"><font color=\"#1c5f82\"></font></a></td></tr><tr><td>&nbsp;</td><td>&nbsp;</td><td><a href=\"http://www.gxqzjj.cn/\"><font color=\"#1c5f82\"></font></a></td></tr><tr><td>&nbsp;</td><td>&nbsp;</td><td><a href=\"http://www.beihaijj.com/\"><font color=\"#1c5f82\"></font></a></td></tr><tr><td><b><font color=\"#ffffff\">ɽʡͨΥ²ѯ</font></b></td><td><b><a href=\"http://www.966096.com/\"><font color=\"#ffffff\">ʡͨΥ²ѯ</font></a></b></td><td><a href=\"http://www.hlj122.com/search/jdc_search.asp\"><b><font color=\"#ffffff\">ʡͨΥ²ѯ</font></b></a></td></tr><tr><td><a href=\"http://www.sxdt.net.cn/clwz.asp\"><font color=\"#1c5f82\">ͬ</font></a></td><td><a href=\"http://www.nn122.com/wfsx.aspx\"><font color=\"#1c5f82\"></font></a></td><td><a href=\"http://www.hrbgaj.gov.cn/wzcx/index.php\"><font color=\"#1c5f82\"></font></a> <a href=\"http://www.hrbjtwf.com/wzseachxxx4.ASP\"><font color=\"#1c5f82\">ӽ</font></a></td></tr><tr><td><a href=\"http://wzcx.jconline.cn/\"><font color=\"#1c5f82\"></font></a></td><td><a href=\"http://www.glga.gov.cn:8085/jjzd/\"><font color=\"#1c5f82\"></font></a></td><td><a href=\"http://www.dqjj.gov.cn/\"><font color=\"#1c5f82\"></font></a></td></tr><tr><td><a href=\"http://www.tyjj.gov.cn/\"><font color=\"#1c5f82\">̫ԭ</font></a></td><td><a href=\"http://www.gg122.com/Index.html\"><font color=\"#1c5f82\"></font></a></td><td><a href=\"http://www.jtaqxx.com/\"><font color=\"#1c5f82\"></font></a></td></tr><tr><td><a href=\"http://www.ycjjzd.com/index_gb.asp\"><font color=\"#1c5f82\">˳</font></a></td><td>&nbsp;</td><td><a href=\"http://www.jidongche.com/\"><font color=\"#1c5f82\">׸</font></a></td></tr><tr><td><a href=\"http://www.sxszjj.gov.cn/\"><font color=\"#1c5f82\">˷</font></a></td><td>&nbsp;</td><td>&nbsp;</td></tr><tr><td><a href=\"http://www.sxxzjj.gov.cn/\"><font color=\"#1c5f82\"></font></a></td><td>&nbsp;</td><td>&nbsp;</td></tr><tr><td><a href=\"http://www.nxjj.gov.cn/\"><b><font color=\"#ffffff\">ʡͨΥ²ѯ</font></b></a></td><td>&nbsp;</td><td>&nbsp;</td></tr><tr><td><a href=\"http://www.nx.cninfo.net/zhuanti/wz/index.html\"><font color=\"#1c5f82\"></font></a></td><td>&nbsp;</td><td>&nbsp;</td></tr><tr><td><a href=\"http://www.zwjj.net/\"><font color=\"#1c5f82\"></font></a></td><td>&nbsp;</td></tr></tbody></table>\r\n','0');
INSERT INTO `qb_news_digguser` VALUES ('14','963','1','1484809146');
INSERT INTO `qb_news_digguser` VALUES ('15','964','1','1486537579');
INSERT INTO `qb_news_sort` VALUES ('1','0','0','ҵѶ','1','4','1','','0','0','','','','','a:4:{s:4:\"head\";s:0:\"\";s:4:\"foot\";s:0:\"\";s:4:\"list\";s:0:\"\";s:8:\"bencandy\";s:0:\"\";}','','0','','','','0','','','','','0','a:13:{s:11:\"sonTitleRow\";N;s:12:\"sonTitleLeng\";N;s:9:\"cachetime\";N;s:12:\"sonListorder\";N;s:14:\"listContentNum\";N;s:12:\"ListShowType\";N;s:14:\"label_bencandy\";s:0:\"\";s:10:\"channelDir\";s:4:\"nnew\";s:13:\"channelDomain\";s:0:\"\";s:10:\"label_list\";s:2:\"33\";s:15:\"ListShowBigType\";s:13:\"bigsort_tpl/4\";s:7:\"is_html\";N;s:11:\"field_value\";N;}','','','','');
INSERT INTO `qb_news_sort` VALUES ('43','0','0','Ϣ','1','2','1','','-1','0','','','','','a:4:{s:4:\"head\";s:0:\"\";s:4:\"foot\";s:0:\"\";s:4:\"list\";s:0:\"\";s:8:\"bencandy\";s:0:\"\";}','','0','','','','0','','','','','0','a:8:{s:11:\"sonTitleRow\";N;s:12:\"sonTitleLeng\";N;s:9:\"cachetime\";N;s:12:\"sonListorder\";N;s:14:\"listContentNum\";N;s:12:\"ListShowType\";N;s:15:\"ListShowBigType\";s:0:\"\";s:11:\"field_value\";N;}','','','','');
INSERT INTO `qb_news_sort` VALUES ('44','43','106','ָ','2','0','0','','0','0','','','','','','','0','','','','1','','','','','0','','','','','');
INSERT INTO `qb_news_sort` VALUES ('31','1','0','Ļ','2','0','0','','0','0','','','','','a:4:{s:4:\"head\";s:0:\"\";s:4:\"foot\";s:0:\"\";s:4:\"list\";s:0:\"\";s:8:\"bencandy\";s:0:\"\";}','','0','','','','1','','','','','0','a:9:{s:11:\"sonTitleRow\";N;s:12:\"sonTitleLeng\";N;s:9:\"cachetime\";N;s:12:\"sonListorder\";N;s:14:\"listContentNum\";N;s:12:\"ListShowType\";N;s:15:\"ListShowBigType\";N;s:7:\"is_html\";N;s:11:\"field_value\";N;}','','','','');
INSERT INTO `qb_news_sort` VALUES ('32','1','0','ɼ','2','0','0','','0','0','','','','','a:4:{s:4:\"head\";s:0:\"\";s:4:\"foot\";s:0:\"\";s:4:\"list\";s:0:\"\";s:8:\"bencandy\";s:0:\"\";}','','0','','','','1','','','','','0','a:9:{s:11:\"sonTitleRow\";N;s:12:\"sonTitleLeng\";N;s:9:\"cachetime\";N;s:12:\"sonListorder\";N;s:14:\"listContentNum\";N;s:12:\"ListShowType\";N;s:15:\"ListShowBigType\";N;s:7:\"is_html\";N;s:11:\"field_value\";N;}','','','','');
INSERT INTO `qb_news_sort` VALUES ('33','1','0','α','2','0','0','','0','0','','','','','a:4:{s:4:\"head\";s:0:\"\";s:4:\"foot\";s:0:\"\";s:4:\"list\";s:0:\"\";s:8:\"bencandy\";s:0:\"\";}','','0','','','','1','','','','','1','a:7:{s:11:\"sonTitleRow\";N;s:12:\"sonTitleLeng\";N;s:9:\"cachetime\";N;s:12:\"sonListorder\";N;s:14:\"listContentNum\";s:0:\"\";s:12:\"ListShowType\";s:0:\"\";s:15:\"ListShowBigType\";N;}','','','','');
INSERT INTO `qb_news_sort` VALUES ('34','1','0','','2','0','0','','0','0','','','','','a:4:{s:4:\"head\";s:0:\"\";s:4:\"foot\";s:0:\"\";s:4:\"list\";s:0:\"\";s:8:\"bencandy\";s:0:\"\";}','','0','','','','1','','','','','0','a:7:{s:11:\"sonTitleRow\";N;s:12:\"sonTitleLeng\";N;s:9:\"cachetime\";N;s:12:\"sonListorder\";N;s:14:\"listContentNum\";s:0:\"\";s:12:\"ListShowType\";s:10:\"list_tpl/2\";s:15:\"ListShowBigType\";N;}','','','','');
INSERT INTO `qb_news_sort` VALUES ('36','0','0','ɹ','1','2','1','','0','0','','','','','a:4:{s:4:\"head\";s:0:\"\";s:4:\"foot\";s:0:\"\";s:4:\"list\";s:0:\"\";s:8:\"bencandy\";s:0:\"\";}','','0','','','','0','','','','','0','a:8:{s:11:\"sonTitleRow\";N;s:12:\"sonTitleLeng\";N;s:9:\"cachetime\";N;s:12:\"sonListorder\";N;s:14:\"listContentNum\";N;s:12:\"ListShowType\";N;s:15:\"ListShowBigType\";s:0:\"\";s:11:\"field_value\";N;}','','','','');
INSERT INTO `qb_news_sort` VALUES ('37','36','0','ʳ','2','0','0','','0','0','','','','','a:4:{s:4:\"head\";s:0:\"\";s:4:\"foot\";s:0:\"\";s:4:\"list\";s:0:\"\";s:8:\"bencandy\";s:0:\"\";}','','0','','','','1','','','','','0','a:7:{s:11:\"sonTitleRow\";N;s:12:\"sonTitleLeng\";N;s:9:\"cachetime\";N;s:12:\"sonListorder\";N;s:14:\"listContentNum\";s:0:\"\";s:12:\"ListShowType\";s:0:\"\";s:15:\"ListShowBigType\";N;}','','','','');
INSERT INTO `qb_news_sort` VALUES ('39','36','0','ʳĻ','2','0','0','','0','0','','','','','a:4:{s:4:\"head\";s:0:\"\";s:4:\"foot\";s:0:\"\";s:4:\"list\";s:0:\"\";s:8:\"bencandy\";s:0:\"\";}','','0','','','','1','','','','','0','a:7:{s:11:\"sonTitleRow\";N;s:12:\"sonTitleLeng\";N;s:9:\"cachetime\";N;s:12:\"sonListorder\";N;s:14:\"listContentNum\";s:0:\"\";s:12:\"ListShowType\";s:10:\"list_tpl/8\";s:15:\"ListShowBigType\";N;}','','','','');
INSERT INTO `qb_news_sort` VALUES ('45','43','0','Ϣѯ','2','0','0','','0','0','','','','','a:4:{s:4:\"head\";s:0:\"\";s:4:\"foot\";s:0:\"\";s:4:\"list\";s:0:\"\";s:8:\"bencandy\";s:0:\"\";}','','0','','','','1','','','','','0','a:8:{s:11:\"sonTitleRow\";N;s:12:\"sonTitleLeng\";N;s:9:\"cachetime\";N;s:12:\"sonListorder\";N;s:14:\"listContentNum\";N;s:12:\"ListShowType\";N;s:7:\"is_html\";N;s:11:\"field_value\";N;}','','','','');
INSERT INTO `qb_picmsg_config` VALUES ('module_id','21','');
INSERT INTO `qb_picmsg_config` VALUES ('Info_webname','̼Ҷ̬','');
INSERT INTO `qb_picmsg_config` VALUES ('Info_webOpen','1','');
INSERT INTO `qb_picmsg_config` VALUES ('module_pre','picmsg_','');
INSERT INTO `qb_picmsg_config` VALUES ('module_close','1','');
INSERT INTO `qb_picmsg_content` VALUES ('1','˾װްӭָ','','3','1','','13','1','0','1487063986','1487063986','1','admin','','','','','0','qb_picmsg_//1_20170214170254_ro6v6.jpg','1','1','','0','1','1487638893','','','','','','0','127.0.0.1','0','0','','','','','','0','0','0','','1487293631','0','0','0','0','','','1','1','0','0','a:8:{i:0;s:38:\"qb_picmsg_//1_20170214170254_ro6v6.jpg\";i:1;s:38:\"qb_picmsg_//1_20170214170254_bfogf.jpg\";i:2;s:38:\"qb_picmsg_//1_20170214170254_vao4j.jpg\";i:3;s:39:\"qb_picmsg_/3/1_20170215110208_e18wf.jpg\";i:4;s:39:\"qb_picmsg_/3/1_20170215110208_2nw80.jpg\";i:5;s:39:\"qb_picmsg_/3/1_20170215110208_xwb10.jpg\";i:6;s:39:\"qb_picmsg_/3/1_20170215110208_48gld.jpg\";i:7;s:39:\"qb_picmsg_/3/1_20170215110209_b8zk8.jpg\";}','0');
INSERT INTO `qb_picmsg_content` VALUES ('2','ſԼ۱ߵʳ','','1','1','','37','1','0','1487064823','1487064823','1','admin','','','','','0','qb_picmsg_/1/1_20170214170254_higwh.jpg','1','1','','0','1','1487638890','','','','','','0','127.0.0.1','0','0','','','','','','0','0','0','','1487841461','0','0','0','0','','','1','1','0','0','a:9:{i:0;s:39:\"qb_picmsg_/1/1_20170214170254_higwh.jpg\";i:1;s:39:\"qb_picmsg_/1/1_20170214170254_i5ezo.jpg\";i:2;s:39:\"qb_picmsg_/1/1_20170214170254_tr02d.jpg\";i:3;s:39:\"qb_picmsg_/1/1_20170214170246_xbj5k.jpg\";i:4;s:39:\"qb_picmsg_/1/1_20170214170247_aytb0.jpg\";i:5;s:39:\"qb_picmsg_/1/1_20170214170247_ism4i.jpg\";i:6;s:39:\"qb_picmsg_/1/1_20170214170247_e4vbl.jpg\";i:7;s:39:\"qb_picmsg_/1/1_20170214170247_xk58j.jpg\";i:8;s:39:\"qb_picmsg_/1/1_20170214170247_k7px0.jpg\";}','1');
INSERT INTO `qb_picmsg_content_1` VALUES ('1','','1','3','1','1','<p>˾װްӭָ</p>','0');
INSERT INTO `qb_picmsg_content_1` VALUES ('2','','2','1','1','1','ſԼ۱ߵʳ','0');
INSERT INTO `qb_picmsg_digguser` VALUES ('14','1','1','1487122332');
INSERT INTO `qb_picmsg_mysort` VALUES ('1','','1','','0');
INSERT INTO `qb_picmsg_mysort` VALUES ('2','','1','','0');
INSERT INTO `qb_picmsg_sort` VALUES ('1','0','0','Ʒչʾ','1','0','0','','0','0','','','','','a:4:{s:4:\"head\";s:0:\"\";s:4:\"foot\";s:0:\"\";s:4:\"list\";s:0:\"\";s:8:\"bencandy\";s:0:\"\";}','','0','','','','1','','','','','0','a:7:{s:11:\"sonTitleRow\";N;s:12:\"sonTitleLeng\";N;s:9:\"cachetime\";N;s:12:\"sonListorder\";N;s:14:\"listContentNum\";N;s:12:\"ListShowType\";N;s:11:\"field_value\";N;}','','','','');
INSERT INTO `qb_picmsg_sort` VALUES ('2','0','1','̻','1','0','0','','0','0','','','','','','','0','','','','1','','','','','0','','','','','');
INSERT INTO `qb_picmsg_sort` VALUES ('3','0','0','ɹ','1','0','0','','0','0','','','','','a:4:{s:4:\"head\";s:0:\"\";s:4:\"foot\";s:0:\"\";s:4:\"list\";s:0:\"\";s:8:\"bencandy\";s:0:\"\";}','','0','','','','1','','','','','0','a:7:{s:11:\"sonTitleRow\";N;s:12:\"sonTitleLeng\";N;s:9:\"cachetime\";N;s:12:\"sonListorder\";N;s:14:\"listContentNum\";N;s:12:\"ListShowType\";N;s:11:\"field_value\";N;}','','','','');
INSERT INTO `qb_picmsg_zan` VALUES ('1','2','1');
INSERT INTO `qb_purse` VALUES ('1','a:19:{s:12:\"chinabank_id\";s:0:\"\";s:13:\"chinabank_key\";s:0:\"\";s:9:\"paypal_id\";s:0:\"\";s:10:\"paypal_key\";s:0:\"\";s:11:\"paypal_type\";s:1:\"0\";s:9:\"yeepay_id\";s:0:\"\";s:10:\"yeepay_key\";s:0:\"\";s:9:\"tenpay_id\";s:0:\"\";s:10:\"tenpay_key\";s:0:\"\";s:9:\"alipay_id\";s:0:\"\";s:10:\"alipay_key\";s:0:\"\";s:14:\"alipay_partner\";s:0:\"\";s:14:\"alipay_service\";s:25:\"create_direct_pay_by_user\";s:16:\"alipay_transport\";s:5:\"https\";s:9:\"back_code\";s:90:\"62223333333333373  йб**֧\r\n62284444444919  йũҵб***\";s:9:\"norm_send\";s:0:\"\";s:8:\"ems_send\";s:0:\"\";s:9:\"slow_send\";s:0:\"\";s:4:\"BACK\";a:2:{s:17:\"62223333333333373\";s:27:\" йб**֧\";s:14:\"62284444444919\";s:28:\" йũҵб***\";}}');
INSERT INTO `qb_rmb_consume` VALUES ('2','1','-1','ʻֵ','1484559319','0');
INSERT INTO `qb_rmb_consume` VALUES ('3','1','-1','ʻֵ','1484559553','0');
INSERT INTO `qb_rmb_consume` VALUES ('4','1','2','ֵ߳','1490344226','0');
INSERT INTO `qb_sell_telephone` VALUES ('12','1','admin','1292053191','0','1526923591','5000','1','1','010-58787878','ˮŷ','ˮŷ');
INSERT INTO `qb_sell_telephone` VALUES ('3','1','admin','1290404210','0','1526923591','18000','1','1','020-24754563','ú','');
INSERT INTO `qb_sell_telephone` VALUES ('4','1','admin','1290404247','0','1526923591','18000','1','1','020-23654125','ŷ','');
INSERT INTO `qb_sell_telephone` VALUES ('5','1','admin','1290404276','0','1526923591','18000','1','1','020-21254785','ҵ','');
INSERT INTO `qb_sell_telephone` VALUES ('6','1','admin','1290404345','0','1526923591','18000','1','1','020-25632563','ɩ','');
INSERT INTO `qb_sell_telephone` VALUES ('7','1','admin','1290404447','0','1526923591','18000','1','1','020-85214521','ȫԤ','');
INSERT INTO `qb_sell_telephone` VALUES ('8','1','admin','1290404470','0','1526923591','18000','1','1','010-21254541','ƵԤ','');
INSERT INTO `qb_sell_telephone` VALUES ('9','1','admin','1290404503','0','1526923591','18000','1','1','020-21212125','ۻƱ','');
INSERT INTO `qb_sell_telephone` VALUES ('10','1','admin','1290404525','0','1526923591','18000','1','1','020-21212145','  Ʊ','');
INSERT INTO `qb_sell_telephone` VALUES ('11','1','admin','1290404585','0','1526923591','18000','1','1','020-21236541','ѧ 9Ż','');
INSERT INTO `qb_shop_address` VALUES ('2','1','ѧ','02028349635','13399999999','54325@qq.com','888888','510660','cvbnmmm');
INSERT INTO `qb_shop_class` VALUES ('31','0','λ','1');
INSERT INTO `qb_shop_class` VALUES ('32','31','/','0');
INSERT INTO `qb_shop_class` VALUES ('33','31','Դ//ְԱ','0');
INSERT INTO `qb_shop_class` VALUES ('34','31','ҽ/ݱ','0');
INSERT INTO `qb_shop_class` VALUES ('38','34','ʿ/Ա','0');
INSERT INTO `qb_shop_class` VALUES ('37','34','ҽ/ҽʦ','0');
INSERT INTO `qb_shop_class` VALUES ('39','33','Ա/','0');
INSERT INTO `qb_shop_class` VALUES ('40','33','/Դܼ','0');
INSERT INTO `qb_shop_class` VALUES ('41','32','ʦ','0');
INSERT INTO `qb_shop_class` VALUES ('42','32','Ӳʦ','0');
INSERT INTO `qb_shop_collection` VALUES ('1','8','1','1467256347');
INSERT INTO `qb_shop_config` VALUES ('sort_layout','1,75#2,4#71,65#5,54#3#','');
INSERT INTO `qb_shop_config` VALUES ('daili_receive','1','');
INSERT INTO `qb_shop_config` VALUES ('Info_index_cache','','');
INSERT INTO `qb_shop_config` VALUES ('Info_list_cache','','');
INSERT INTO `qb_shop_config` VALUES ('Info_TopNum','10','');
INSERT INTO `qb_shop_config` VALUES ('Info_TopDay','10','');
INSERT INTO `qb_shop_config` VALUES ('Info_TopMoney','10','');
INSERT INTO `qb_shop_config` VALUES ('Info_TopColor','#FF0000','');
INSERT INTO `qb_shop_config` VALUES ('Info_webOpen','1','');
INSERT INTO `qb_shop_config` VALUES ('comment_limit','0','');
INSERT INTO `qb_shop_config` VALUES ('module_close','1','');
INSERT INTO `qb_shop_config` VALUES ('giveMoneyFromSystem','0','');
INSERT INTO `qb_shop_config` VALUES ('give_send_sms','0','');
INSERT INTO `qb_shop_config` VALUES ('give_send_mail','0','');
INSERT INTO `qb_shop_config` VALUES ('ForbidDelOrder','0','');
INSERT INTO `qb_shop_config` VALUES ('pay_send_sms2Seller','0','');
INSERT INTO `qb_shop_config` VALUES ('pay_send_mail2Seller','0','');
INSERT INTO `qb_shop_config` VALUES ('Info_description','','');
INSERT INTO `qb_shop_config` VALUES ('Info_metakeywords','̳','');
INSERT INTO `qb_shop_config` VALUES ('order_send_sms','0','');
INSERT INTO `qb_shop_config` VALUES ('order_send_mail','0','');
INSERT INTO `qb_shop_config` VALUES ('order_send_msg','1','');
INSERT INTO `qb_shop_config` VALUES ('UpdatePostTime','1','');
INSERT INTO `qb_shop_config` VALUES ('showNoPassComment','0','');
INSERT INTO `qb_shop_config` VALUES ('Info_ShowNoYz','1','');
INSERT INTO `qb_shop_config` VALUES ('PostInfoMoney','10','');
INSERT INTO `qb_shop_config` VALUES ('ForbidSellerDelNoPayOrder','1','');
INSERT INTO `qb_shop_config` VALUES ('ForbidDelPayOrder','1','');
INSERT INTO `qb_shop_config` VALUES ('postShopNeedQy','0','');
INSERT INTO `qb_shop_config` VALUES ('Info_allowGuesSearch','1','');
INSERT INTO `qb_shop_config` VALUES ('module_pre','shop_','');
INSERT INTO `qb_shop_config` VALUES ('module_id','29','');
INSERT INTO `qb_shop_config` VALUES ('SEO_description','','');
INSERT INTO `qb_shop_config` VALUES ('SEO_keywords','','');
INSERT INTO `qb_shop_config` VALUES ('SEO_title','','');
INSERT INTO `qb_shop_config` VALUES ('Info_webname','̳ϵͳ','');
INSERT INTO `qb_shop_config` VALUES ('rmb_pay','1','');
INSERT INTO `qb_shop_config` VALUES ('rmb_late_pay','0','');
INSERT INTO `qb_shop_config` VALUES ('Info_ReportDB','ΥϢ\r\nϢ\r\nϢ','');
INSERT INTO `qb_shop_config` VALUES ('IF_Private_tpl','0','');
INSERT INTO `qb_shop_config` VALUES ('Private_tpl_head','','');
INSERT INTO `qb_shop_config` VALUES ('Private_tpl_foot','','');
INSERT INTO `qb_shop_content` VALUES ('1','ɫ޶tŮĿݰٴŮװŮʿѧ','1','55','Ůװ','20','0','1288753253','1288753253','1','admin','','https://img.alicdn.com/imgextra/i1/292829878/TB2ZOsgkpXXXXbsXXXXXXXXXXXX_!!292829878.jpg','1','1','1','1461726462','','127.0.0.1','0','0','','0','0','1482127177','1','3','40','0','0','','0','0','0','');
INSERT INTO `qb_shop_content` VALUES ('2','ļŮװ˶ŷɴñɹŮ','1','55','Ůװ','15','0','1288753418','1288753418','1','admin','','https://img.alicdn.com/imgextra/i2/13410985/TB2pi1oqpXXXXbxXXXXXXXXXXXX_!!13410985.jpg','1','1','0','0','','127.0.0.1','0','0','','0','0','1481766375','1','3','120','0','0','','0','0','0','');
INSERT INTO `qb_shop_content` VALUES ('3','װ¿ʱ ѩvС黨̿Ů5502','1','55','Ůװ','16','0','1288753647','1288753647','1','admin','','https://img.alicdn.com/imgextra/i3/20868741/TB2t2OYpFXXXXaTXpXXXXXXXXXX_!!20868741.jpg','1','1','0','0','','127.0.0.1','0','0','','0','0','1487147511','1','3','120','0','0','','0','0','0','');
INSERT INTO `qb_shop_content` VALUES ('4','ĸ̿߷ɹ','1','55','Ůװ','16','1','1288753828','1288753828','1','admin','','https://gd2.alicdn.com/bao/uploaded/i2/1723790336/TB2LD1NpXXXXXcJXpXXXXXXXXXX_!!1723790336.jpg','1','1','0','0','','127.0.0.1','0','0','','0','0','1481853495','1','3','3000','0','0','','0','0','0','');
INSERT INTO `qb_shop_content` VALUES ('5','װ¿Ůװ2016 ʱ廨ٴɹ','1','55','Ůװ','23','0','1288753985','1288753985','1','admin','','https://img.alicdn.com/imgextra/i2/20604171/TB2HmxinFXXXXcIXpXXXXXXXXXX_!!20604171.jpg','1','1','0','0','','127.0.0.1','0','0','','0','0','1487147655','1','3','100','0','0','','0','0','0','');
INSERT INTO `qb_shop_content` VALUES ('6','С*2016ļ¿ñɹ·ɹгŮ','1','55','Ůװ','16','0','1288754067','1288754067','1','admin','','https://img.alicdn.com/imgextra/i1/13410985/TB2XhQwpXXXXXcoXXXXXXXXXXXX_!!13410985.jpg','1','1','0','0','','127.0.0.1','0','0','','0','0','1481853502','1','3','100','0','0','','0','0','0','');
INSERT INTO `qb_shop_content` VALUES ('7','A ļɫʱŮװԸа¶TŮ6241','1','55','Ůװ','151','0','1288754153','1288754153','1','admin','','https://img.alicdn.com/imgextra/i4/20868741/TB2GxrSqpXXXXXcXpXXXXXXXXXX_!!20868741.jpg','1','1','1','1461726460','','127.0.0.1','0','0','','0','0','1484728849','1','3','110','0','0','','0','0','0','');
INSERT INTO `qb_shop_content` VALUES ('8','¿2016װŮװӡѩĳE-10','1','55','Ůװ','103','0','1288754209','1288754209','1','admin','','https://img.alicdn.com/imgextra/i3/56651352/TB2pRrtopXXXXbAXXXXXXXXXXXX_!!56651352.jpg','1','1','1','1461726464','','127.0.0.1','0','0','','0','0','1484899584','1','3','90','7','0','','0','0','0','');
INSERT INTO `qb_shop_content` VALUES ('9','T5777-2016¿Ůװƴɫưٴ0530','1','56','Ůʿ/ʿ/Ҿӷ','261','2','1288754323','1288754323','1','admin','','https://img.alicdn.com/imgextra/i4/14197825/TB2PulMpFXXXXXdXFXXXXXXXXXX_!!14197825.jpg','1','1','0','0','','127.0.0.1','0','0','','0','0','1487584120','1','3','100','0','5','','0','0','0','');
INSERT INTO `qb_shop_content` VALUES ('10','FANFAN ˳ţ˿ɹ´ɫСױ͸Ů','1','55','Ůװ','783','1','1288754600','1288754600','1','admin','','https://gd2.alicdn.com/bao/uploaded/i2/108727117/TB2P38gpXXXXXb3XpXXXXXXXXXX_!!108727117.jpg','1','1','0','0','','127.0.0.1','0','8','','0','0','1487147498','0','2','90','5','2','','0','0','0','');
INSERT INTO `qb_shop_content_1` VALUES ('1','1','55','1','<p style=\"text-align:center\"><img onload=\'if(this.width>600)makesmallpic(this,600,800);\' align=\"absmiddle\" src=\"https://img.alicdn.com/imgextra/i4/292829878/TB2MHr.kpXXXXc1XXXXXXXXXXXX_!!292829878.jpg\" style=\"border:0px;vertical-align:top;margin:0px;padding:0px;font-family:tahoma, arial, , sans-serif;font-size:14px;line-height:1.5;background-color:#ffffff;\" /></p><p style=\"text-align:center\"><img onload=\'if(this.width>600)makesmallpic(this,600,800);\' align=\"absmiddle\" src=\"https://img.alicdn.com/imgextra/i3/292829878/TB2xZgikpXXXXbtXXXXXXXXXXXX_!!292829878.jpg\" style=\"border:0px;vertical-align:top;margin:0px;padding:0px;font-family:tahoma, arial, , sans-serif;font-size:14px;line-height:1.5;background-color:#ffffff;\" /></p><p style=\"text-align:center\"><img onload=\'if(this.width>600)makesmallpic(this,600,800);\' src=\"https://img.alicdn.com/imgextra/i2/292829878/TB253NUspXXXXcaXXXXXXXXXXXX_!!292829878.jpg\" align=\"absmiddle\" style=\"border:0px;vertical-align:top;margin:0px;padding:0px;font-family:tahoma, arial, , sans-serif;font-size:14px;line-height:21px;background-color:#ffffff;\" /></p>','80','N455','99999');
INSERT INTO `qb_shop_content_1` VALUES ('2','2','55','1','<p style=\"text-align:center\"><img onload=\'if(this.width>600)makesmallpic(this,600,800);\' onload=\"if(this.width&gt;600)makesmallpic(this,600,800);\" src=\"https://img.alicdn.com/imgextra/i4/13410985/TB2WwdYqpXXXXawXpXXXXXXXXXX_!!13410985.jpg\" width=\"750\" height=\"750\" style=\"border:0px;vertical-align:top;margin:0px;padding:0px;font-family:tahoma, arial, , sans-serif;font-size:14px;line-height:21px;text-align:-webkit-center;background-color:#ffffff;\" /></p><p style=\"text-align:left;\"><br style=\"font-family:tahoma, arial, , sans-serif;font-size:14px;line-height:21px;text-align:-webkit-center;background-color:#ffffff;\" /><br style=\"font-family:tahoma, arial, , sans-serif;font-size:14px;line-height:21px;text-align:-webkit-center;background-color:#ffffff;\" /></p><p style=\"text-align:center\"><img onload=\'if(this.width>600)makesmallpic(this,600,800);\' onload=\"if(this.width&gt;600)makesmallpic(this,600,800);\" src=\"https://img.alicdn.com/imgextra/i3/13410985/TB2GsuCqpXXXXadXXXXXXXXXXXX_!!13410985.jpg\" width=\"750\" height=\"750\" style=\"border:0px;vertical-align:top;margin:0px;padding:0px;font-family:tahoma, arial, , sans-serif;font-size:14px;line-height:21px;text-align:-webkit-center;background-color:#ffffff;\" /></p><p style=\"text-align:left;\"><br style=\"font-family:tahoma, arial, , sans-serif;font-size:14px;line-height:21px;text-align:-webkit-center;background-color:#ffffff;\" /><br style=\"font-family:tahoma, arial, , sans-serif;font-size:14px;line-height:21px;text-align:-webkit-center;background-color:#ffffff;\" /></p><p style=\"text-align:center\"><img onload=\'if(this.width>600)makesmallpic(this,600,800);\' onload=\"if(this.width&gt;600)makesmallpic(this,600,800);\" src=\"https://img.alicdn.com/imgextra/i2/13410985/TB2QKNVqpXXXXaYXpXXXXXXXXXX_!!13410985.jpg\" width=\"750\" height=\"750\" style=\"border:0px;vertical-align:top;margin:0px;padding:0px;font-family:tahoma, arial, , sans-serif;font-size:14px;line-height:21px;text-align:-webkit-center;background-color:#ffffff;\" /></p><p style=\"text-align:left;\"><br style=\"font-family:tahoma, arial, , sans-serif;font-size:14px;line-height:21px;text-align:-webkit-center;background-color:#ffffff;\" /><br style=\"font-family:tahoma, arial, , sans-serif;font-size:14px;line-height:21px;text-align:-webkit-center;background-color:#ffffff;\" /></p><p style=\"text-align:center\"><img onload=\'if(this.width>600)makesmallpic(this,600,800);\' onload=\"if(this.width&gt;600)makesmallpic(this,600,800);\" src=\"https://img.alicdn.com/imgextra/i1/13410985/TB24SuNqpXXXXXjXXXXXXXXXXXX_!!13410985.jpg\" width=\"750\" height=\"750\" style=\"border:0px;vertical-align:top;margin:0px;padding:0px;font-family:tahoma, arial, , sans-serif;font-size:14px;line-height:21px;text-align:-webkit-center;background-color:#ffffff;\" /></p><p style=\"text-align:left;\"><br style=\"font-family:tahoma, arial, , sans-serif;font-size:14px;line-height:21px;text-align:-webkit-center;background-color:#ffffff;\" /><br style=\"font-family:tahoma, arial, , sans-serif;font-size:14px;line-height:21px;text-align:-webkit-center;background-color:#ffffff;\" /></p><p style=\"text-align:center\"><img onload=\'if(this.width>600)makesmallpic(this,600,800);\' onload=\"if(this.width&gt;600)makesmallpic(this,600,800);\" src=\"https://img.alicdn.com/imgextra/i3/13410985/TB2lvasqpXXXXaYXXXXXXXXXXXX_!!13410985.jpg\" width=\"750\" height=\"750\" style=\"border:0px;vertical-align:top;margin:0px;padding:0px;font-family:tahoma, arial, , sans-serif;font-size:14px;line-height:21px;text-align:-webkit-center;background-color:#ffffff;\" /></p><p style=\"text-align:left;\"><br style=\"font-family:tahoma, arial, , sans-serif;font-size:14px;line-height:21px;text-align:-webkit-center;background-color:#ffffff;\" /><br style=\"font-family:tahoma, arial, , sans-serif;font-size:14px;line-height:21px;text-align:-webkit-center;background-color:#ffffff;\" /></p><p style=\"text-align:center\"><img onload=\'if(this.width>600)makesmallpic(this,600,800);\' onload=\"if(this.width&gt;600)makesmallpic(this,600,800);\" src=\"https://img.alicdn.com/imgextra/i2/13410985/TB2pi1oqpXXXXbxXXXXXXXXXXXX_!!13410985.jpg\" width=\"750\" height=\"750\" style=\"border:0px;vertical-align:top;margin:0px;padding:0px;font-family:tahoma, arial, , sans-serif;font-size:14px;line-height:21px;text-align:-webkit-center;background-color:#ffffff;\" /></p><p style=\"text-align:left;\"><br style=\"font-family:tahoma, arial, , sans-serif;font-size:14px;line-height:21px;text-align:-webkit-center;background-color:#ffffff;\" /><br style=\"font-family:tahoma, arial, , sans-serif;font-size:14px;line-height:21px;text-align:-webkit-center;background-color:#ffffff;\" /></p><p style=\"text-align:center\"><img onload=\'if(this.width>600)makesmallpic(this,600,800);\' onload=\"if(this.width&gt;600)makesmallpic(this,600,800);\" src=\"https://img.alicdn.com/imgextra/i1/13410985/TB2XC8EqpXXXXcWXpXXXXXXXXXX_!!13410985.jpg\" width=\"750\" height=\"750\" style=\"border:0px;vertical-align:top;margin:0px;padding:0px;font-family:tahoma, arial, , sans-serif;font-size:14px;line-height:21px;text-align:-webkit-center;background-color:#ffffff;\" /></p><p style=\"text-align:left;\"><br style=\"font-family:tahoma, arial, , sans-serif;font-size:14px;line-height:21px;text-align:-webkit-center;background-color:#ffffff;\" /><br style=\"font-family:tahoma, arial, , sans-serif;font-size:14px;line-height:21px;text-align:-webkit-center;background-color:#ffffff;\" /></p><p style=\"text-align:center\"><img onload=\'if(this.width>600)makesmallpic(this,600,800);\' onload=\"if(this.width&gt;600)makesmallpic(this,600,800);\" src=\"https://img.alicdn.com/imgextra/i2/13410985/TB2APqdqpXXXXcGXXXXXXXXXXXX_!!13410985.jpg\" width=\"750\" height=\"750\" style=\"border:0px;vertical-align:top;margin:0px;padding:0px;font-family:tahoma, arial, , sans-serif;font-size:14px;line-height:21px;text-align:-webkit-center;background-color:#ffffff;\" /></p><p style=\"text-align:left;\"><br style=\"font-family:tahoma, arial, , sans-serif;font-size:14px;line-height:21px;text-align:-webkit-center;background-color:#ffffff;\" /><br style=\"font-family:tahoma, arial, , sans-serif;font-size:14px;line-height:21px;text-align:-webkit-center;background-color:#ffffff;\" /></p><p style=\"text-align:center\"><img onload=\'if(this.width>600)makesmallpic(this,600,800);\' onload=\"if(this.width&gt;600)makesmallpic(this,600,800);\" src=\"https://img.alicdn.com/imgextra/i1/13410985/TB2TxpTqpXXXXa6XpXXXXXXXXXX_!!13410985.jpg\" width=\"750\" height=\"750\" style=\"border:0px;vertical-align:top;margin:0px;padding:0px;font-family:tahoma, arial, , sans-serif;font-size:14px;line-height:21px;text-align:-webkit-center;background-color:#ffffff;\" /></p><p style=\"text-align:left;\"><br style=\"font-family:tahoma, arial, , sans-serif;font-size:14px;line-height:21px;text-align:-webkit-center;background-color:#ffffff;\" /><br style=\"font-family:tahoma, arial, , sans-serif;font-size:14px;line-height:21px;text-align:-webkit-center;background-color:#ffffff;\" /></p><p style=\"text-align:center\"><img onload=\'if(this.width>600)makesmallpic(this,600,800);\' onload=\"if(this.width&gt;600)makesmallpic(this,600,800);\" src=\"https://img.alicdn.com/imgextra/i3/13410985/TB2mOaCqpXXXXadXXXXXXXXXXXX_!!13410985.jpg\" width=\"750\" height=\"750\" style=\"border:0px;vertical-align:top;margin:0px;padding:0px;font-family:tahoma, arial, , sans-serif;font-size:14px;line-height:21px;text-align:-webkit-center;background-color:#ffffff;\" /></p><p style=\"text-align:left;\"><br style=\"font-family:tahoma, arial, , sans-serif;font-size:14px;line-height:21px;text-align:-webkit-center;background-color:#ffffff;\" /><br style=\"font-family:tahoma, arial, , sans-serif;font-size:14px;line-height:21px;text-align:-webkit-center;background-color:#ffffff;\" /></p><p style=\"text-align:center\"><img onload=\'if(this.width>600)makesmallpic(this,600,800);\' onload=\"if(this.width&gt;600)makesmallpic(this,600,800);\" src=\"https://img.alicdn.com/imgextra/i4/13410985/TB2cMqEqpXXXXX1XXXXXXXXXXXX_!!13410985.jpg\" width=\"750\" height=\"750\" style=\"border:0px;vertical-align:top;margin:0px;padding:0px;font-family:tahoma, arial, , sans-serif;font-size:14px;line-height:21px;text-align:-webkit-center;background-color:#ffffff;\" /></p><p style=\"text-align:left;\"><br style=\"font-family:tahoma, arial, , sans-serif;font-size:14px;line-height:21px;text-align:-webkit-center;background-color:#ffffff;\" /><br style=\"font-family:tahoma, arial, , sans-serif;font-size:14px;line-height:21px;text-align:-webkit-center;background-color:#ffffff;\" /></p><p style=\"text-align:center\"><img onload=\'if(this.width>600)makesmallpic(this,600,800);\' onload=\"if(this.width&gt;600)makesmallpic(this,600,800);\" src=\"https://img.alicdn.com/imgextra/i2/13410985/TB2RNGoqpXXXXbyXXXXXXXXXXXX_!!13410985.jpg\" width=\"750\" height=\"750\" style=\"border:0px;vertical-align:top;margin:0px;padding:0px;font-family:tahoma, arial, , sans-serif;font-size:14px;line-height:21px;text-align:-webkit-center;background-color:#ffffff;\" /></p><p style=\"text-align:left;\"><br style=\"font-family:tahoma, arial, , sans-serif;font-size:14px;line-height:21px;text-align:-webkit-center;background-color:#ffffff;\" /><br style=\"font-family:tahoma, arial, , sans-serif;font-size:14px;line-height:21px;text-align:-webkit-center;background-color:#ffffff;\" /></p><p style=\"text-align:center\"><img onload=\'if(this.width>600)makesmallpic(this,600,800);\' onload=\"if(this.width&gt;600)makesmallpic(this,600,800);\" src=\"https://img.alicdn.com/imgextra/i2/13410985/TB2Wpt4qpXXXXXxXpXXXXXXXXXX_!!13410985.jpg\" width=\"750\" height=\"750\" style=\"border:0px;vertical-align:top;margin:0px;padding:0px;font-family:tahoma, arial, , sans-serif;font-size:14px;line-height:21px;text-align:-webkit-center;background-color:#ffffff;\" /></p>','300','N148-DP03','99999');
INSERT INTO `qb_shop_content_1` VALUES ('3','3','55','1','<div class=\"sub-wrap\" id=\"J_SubWrap\" style=\"margin:0px;padding:0px;position:relative;z-index:99999998;width:750px;\"><div id=\"description\" class=\"J_DetailSection tshop-psm ke-post\" style=\"margin:0px 0px 20px;padding:0px;clear:both;font-stretch:normal;font-size:14px;line-height:1.5;font-family:tahoma, arial, , sans-serif;background:#ffffff !important;\"><div id=\"J_DivItemDesc\" class=\"content\" style=\"margin:0px;padding:10px 0px 0px;width:750px;overflow:hidden;word-wrap:break-word;position:relative !important;\"><p style=\"padding:0px;margin-top:1.12em;margin-bottom:1.12em;\"><img onload=\'if(this.width>600)makesmallpic(this,600,800);\' align=\"absmiddle\" src=\"https://img.alicdn.com/imgextra/i2/20868741/TB27w2qpFXXXXa5XXXXXXXXXXXX_!!20868741.jpg\" width=\"750\" height=\"800\" style=\"border:0px;vertical-align:top;margin:0px;padding:0px;line-height:1.5;\" /><img onload=\'if(this.width>600)makesmallpic(this,600,800);\' align=\"absmiddle\" src=\"https://img.alicdn.com/imgextra/i3/20868741/TB2vb9_pFXXXXc5XXXXXXXXXXXX_!!20868741.jpg\" width=\"750\" height=\"800\" style=\"border:0px;vertical-align:top;margin:0px;padding:0px;line-height:1.5;\" /><img onload=\'if(this.width>600)makesmallpic(this,600,800);\' align=\"absmiddle\" src=\"https://img.alicdn.com/imgextra/i4/20868741/TB27SuvpFXXXXaVXFXXXXXXXXXX_!!20868741.jpg\" width=\"750\" height=\"800\" style=\"border:0px;vertical-align:top;margin:0px;padding:0px;line-height:1.5;\" /><img onload=\'if(this.width>600)makesmallpic(this,600,800);\' align=\"absmiddle\" src=\"https://img.alicdn.com/imgextra/i1/20868741/TB25Q_lpFXXXXbLXXXXXXXXXXXX_!!20868741.jpg\" width=\"750\" height=\"800\" style=\"border:0px;vertical-align:top;margin:0px;padding:0px;line-height:1.5;\" /><img onload=\'if(this.width>600)makesmallpic(this,600,800);\' align=\"absmiddle\" src=\"https://img.alicdn.com/imgextra/i4/20868741/TB2656gpFXXXXcmXXXXXXXXXXXX_!!20868741.jpg\" width=\"750\" height=\"800\" style=\"border:0px;vertical-align:top;margin:0px;padding:0px;line-height:1.5;\" /><img onload=\'if(this.width>600)makesmallpic(this,600,800);\' align=\"absmiddle\" src=\"https://img.alicdn.com/imgextra/i2/20868741/TB2gmfjpFXXXXbNXXXXXXXXXXXX_!!20868741.jpg\" width=\"750\" height=\"800\" style=\"border:0px;vertical-align:top;margin:0px;padding:0px;line-height:1.5;\" /><img onload=\'if(this.width>600)makesmallpic(this,600,800);\' align=\"absmiddle\" src=\"https://img.alicdn.com/imgextra/i2/20868741/TB23n1KpFXXXXcQXpXXXXXXXXXX_!!20868741.jpg\" width=\"750\" height=\"800\" style=\"border:0px;vertical-align:top;margin:0px;padding:0px;line-height:1.5;\" /><img onload=\'if(this.width>600)makesmallpic(this,600,800);\' align=\"absmiddle\" src=\"https://img.alicdn.com/imgextra/i2/20868741/TB2PZThpFXXXXcnXXXXXXXXXXXX_!!20868741.jpg\" width=\"750\" height=\"800\" style=\"border:0px;vertical-align:top;margin:0px;padding:0px;line-height:1.5;\" /><img onload=\'if(this.width>600)makesmallpic(this,600,800);\' align=\"absmiddle\" src=\"https://img.alicdn.com/imgextra/i3/20868741/TB2bGmZpFXXXXaEXpXXXXXXXXXX_!!20868741.jpg\" width=\"750\" height=\"800\" style=\"border:0px;vertical-align:top;margin:0px;padding:0px;line-height:1.5;\" /><img onload=\'if(this.width>600)makesmallpic(this,600,800);\' align=\"absmiddle\" src=\"https://img.alicdn.com/imgextra/i3/20868741/TB2LWmRpFXXXXakXpXXXXXXXXXX_!!20868741.jpg\" width=\"750\" height=\"800\" style=\"border:0px;vertical-align:top;margin:0px;padding:0px;line-height:1.5;\" /><img onload=\'if(this.width>600)makesmallpic(this,600,800);\' align=\"absmiddle\" src=\"https://img.alicdn.com/imgextra/i1/20868741/TB2h6SVpFXXXXaOXpXXXXXXXXXX_!!20868741.jpg\" width=\"750\" height=\"800\" style=\"border:0px;vertical-align:top;margin:0px;padding:0px;line-height:1.5;\" /><img onload=\'if(this.width>600)makesmallpic(this,600,800);\' align=\"absmiddle\" src=\"https://img.alicdn.com/imgextra/i4/20868741/TB23F1WpFXXXXa0XpXXXXXXXXXX_!!20868741.jpg\" width=\"750\" height=\"800\" style=\"border:0px;vertical-align:top;margin:0px;padding:0px;line-height:1.5;\" /><img onload=\'if(this.width>600)makesmallpic(this,600,800);\' align=\"absmiddle\" src=\"https://img.alicdn.com/imgextra/i1/20868741/TB2lQrzpFXXXXXiXXXXXXXXXXXX_!!20868741.jpg\" width=\"750\" height=\"800\" style=\"border:0px;vertical-align:top;margin:0px;padding:0px;line-height:1.5;\" /><img onload=\'if(this.width>600)makesmallpic(this,600,800);\' align=\"absmiddle\" src=\"https://img.alicdn.com/imgextra/i3/20868741/TB2HyGvpFXXXXX7XFXXXXXXXXXX_!!20868741.jpg\" width=\"750\" height=\"800\" style=\"border:0px;vertical-align:top;margin:0px;padding:0px;line-height:1.5;\" /></p></div></div></div><div class=\"J_AsyncDC tb-custom-area tb-shop\" data-type=\"main\" id=\"J_AsyncDCMain\" style=\"margin:0px;padding:0px;overflow:hidden;position:relative;\"><div class=\"J_TModule\" data-widgetid=\"6635877204\" id=\"shop6635877204\" data-componentid=\"7546767\" data-spm=\"110.0.7546767-6635877204\" microscope-data=\"7546767-6635877204\" data-title=\"ͼ޷Ʒ\" data-spm-max-idx=\"12\" style=\"margin:0px;padding:0px;\"><div class=\"tb-module tshop-um tshop-um-ow-cpmkI\" style=\"margin:0px 0px 50px;padding:0px;position:relative;z-index:5;overflow:hidden;font-family:΢ź, tahoma, arial, ;\"><div class=\"cpmkI\" style=\"margin:0px;padding:0px;overflow:hidden;background:#ffffff;\"><div class=\"myhd\" style=\"margin:0px;padding:30px 0px 50px;overflow:hidden;width:750px;font-weight:bold;text-align:center;\"><a target=\"_blank\" style=\"color:#3366cc;outline:0px;margin:0px;padding:0px;\"><span style=\"font-size:12px;line-height:18px;\"></span></a></div></div></div></div></div><p><br /></p>','200','N450','99999');
INSERT INTO `qb_shop_content_1` VALUES ('4','4','55','1','<p style=\"padding:0px;font-family:tahoma, arial, , sans-serif;font-size:14px;line-height:21px;text-align:left;background-color:#ffffff;margin-top:1.12em;margin-bottom:1.12em;\"><span style=\"font-size:18px;\"><strong><span style=\"background-color:#ff0000;\">ɫСѾйɫɫ</span></strong></span></p><p style=\"text-align:center\"><img onload=\'if(this.width>600)makesmallpic(this,600,800);\' onload=\"if(this.width&gt;600)makesmallpic(this,600,800);\" align=\"absmiddle\" src=\"https://img.alicdn.com/imgextra/i2/1723790336/TB2J7DfpXXXXXcXXXXXXXXXXXXX_!!1723790336.jpg\" style=\"border:0px;vertical-align:top;margin:0px;padding:0px;\" /></p><p style=\"padding:0px;font-family:tahoma, arial, , sans-serif;font-size:14px;line-height:21px;text-align:left;background-color:#ffffff;margin-top:1.12em;margin-bottom:1.12em;\"><span style=\"font-size:18px;\"><strong><span style=\"background-color:#ff0000;\"></span></strong></span><br /></p><p style=\"text-align:center\"><img onload=\'if(this.width>600)makesmallpic(this,600,800);\' onload=\"if(this.width&gt;600)makesmallpic(this,600,800);\" src=\"https://img.alicdn.com/imgextra/i2/1723790336/TB2aJPJqXXXXXb8XXXXXXXXXXXX_!!1723790336.jpg\" align=\"absmiddle\" style=\"border:0px;vertical-align:top;margin:0px;padding:0px;\" /></p><p style=\"text-align:center\"><img onload=\'if(this.width>600)makesmallpic(this,600,800);\' onload=\"if(this.width&gt;600)makesmallpic(this,600,800);\" align=\"absmiddle\" src=\"https://img.alicdn.com/imgextra/i3/1723790336/TB2hU9YqXXXXXcmXpXXXXXXXXXX_!!1723790336.jpg\" style=\"border:0px;vertical-align:top;margin:0px;padding:0px;line-height:1.5;\" /></p><p style=\"text-align:center\"><img onload=\'if(this.width>600)makesmallpic(this,600,800);\' onload=\"if(this.width&gt;600)makesmallpic(this,600,800);\" align=\"absmiddle\" src=\"https://img.alicdn.com/imgextra/i1/1723790336/TB22OLJepXXXXX1XpXXXXXXXXXX_!!1723790336.jpg\" style=\"border:0px;vertical-align:top;margin:0px;padding:0px;\" /></p><p><br /></p>','4000','T1 T2','99999');
INSERT INTO `qb_shop_content_1` VALUES ('5','5','55','1','<p style=\"text-align:center\"><img onload=\'if(this.width>600)makesmallpic(this,600,800);\' align=\"absmiddle\" src=\"https://img.alicdn.com/imgextra/i1/20604171/TB2j6JrnFXXXXbaXpXXXXXXXXXX_!!20604171.jpg\" width=\"750\" height=\"750\" style=\"border:0px;vertical-align:top;margin:0px;padding:0px;\" /></p><p style=\"text-align:center\"><img onload=\'if(this.width>600)makesmallpic(this,600,800);\' align=\"absmiddle\" src=\"https://img.alicdn.com/imgextra/i3/20604171/TB2aftnnFXXXXbSXpXXXXXXXXXX_!!20604171.jpg\" width=\"750\" height=\"750\" style=\"border:0px;vertical-align:top;margin:0px;padding:0px;\" /></p><p style=\"text-align:center\"><img onload=\'if(this.width>600)makesmallpic(this,600,800);\' align=\"absmiddle\" src=\"https://img.alicdn.com/imgextra/i3/20604171/TB2W6BbnFXXXXXlXFXXXXXXXXXX_!!20604171.jpg\" width=\"750\" height=\"750\" style=\"border:0px;vertical-align:top;margin:0px;padding:0px;\" /></p><p style=\"text-align:center\"><img onload=\'if(this.width>600)makesmallpic(this,600,800);\' align=\"absmiddle\" src=\"https://img.alicdn.com/imgextra/i3/20604171/TB2njNpnFXXXXbsXpXXXXXXXXXX_!!20604171.jpg\" width=\"750\" height=\"750\" style=\"border:0px;vertical-align:top;margin:0px;padding:0px;\" /></p><p style=\"text-align:center\"><img onload=\'if(this.width>600)makesmallpic(this,600,800);\' align=\"absmiddle\" src=\"https://img.alicdn.com/imgextra/i3/20604171/TB2dhNjnFXXXXcFXpXXXXXXXXXX_!!20604171.jpg\" width=\"750\" height=\"750\" style=\"border:0px;vertical-align:top;margin:0px;padding:0px;\" /></p><p><br /></p>','200','KG90/KG800','99999');
INSERT INTO `qb_shop_content_1` VALUES ('6','6','55','1','<p><br style=\"font-family:tahoma, arial, , sans-serif;font-size:14px;line-height:21px;text-align:-webkit-center;background-color:#ffffff;\" /><img onload=\'if(this.width>600)makesmallpic(this,600,800);\' src=\"https://img.alicdn.com/imgextra/i2/13410985/TB2MwgIpXXXXXaLXXXXXXXXXXXX_!!13410985.jpg\" width=\"750\" height=\"750\" style=\"border:0px;vertical-align:top;margin:0px;padding:0px;font-family:tahoma, arial, , sans-serif;font-size:14px;line-height:21px;text-align:-webkit-center;background-color:#ffffff;\" /><br style=\"font-family:tahoma, arial, , sans-serif;font-size:14px;line-height:21px;text-align:-webkit-center;background-color:#ffffff;\" /><br style=\"font-family:tahoma, arial, , sans-serif;font-size:14px;line-height:21px;text-align:-webkit-center;background-color:#ffffff;\" /><img onload=\'if(this.width>600)makesmallpic(this,600,800);\' src=\"https://img.alicdn.com/imgextra/i4/13410985/TB2wfQUpXXXXXXsXXXXXXXXXXXX_!!13410985.jpg\" width=\"750\" height=\"750\" style=\"border:0px;vertical-align:top;margin:0px;padding:0px;font-family:tahoma, arial, , sans-serif;font-size:14px;line-height:21px;text-align:-webkit-center;background-color:#ffffff;\" /><br style=\"font-family:tahoma, arial, , sans-serif;font-size:14px;line-height:21px;text-align:-webkit-center;background-color:#ffffff;\" /><br style=\"font-family:tahoma, arial, , sans-serif;font-size:14px;line-height:21px;text-align:-webkit-center;background-color:#ffffff;\" /><img onload=\'if(this.width>600)makesmallpic(this,600,800);\' src=\"https://img.alicdn.com/imgextra/i3/13410985/TB2w4MHpXXXXXaFXXXXXXXXXXXX_!!13410985.jpg\" width=\"750\" height=\"750\" style=\"border:0px;vertical-align:top;margin:0px;padding:0px;font-family:tahoma, arial, , sans-serif;font-size:14px;line-height:21px;text-align:-webkit-center;background-color:#ffffff;\" /><br style=\"font-family:tahoma, arial, , sans-serif;font-size:14px;line-height:21px;text-align:-webkit-center;background-color:#ffffff;\" /><br style=\"font-family:tahoma, arial, , sans-serif;font-size:14px;line-height:21px;text-align:-webkit-center;background-color:#ffffff;\" /><img onload=\'if(this.width>600)makesmallpic(this,600,800);\' src=\"https://img.alicdn.com/imgextra/i3/13410985/TB2tkAmpXXXXXbWXpXXXXXXXXXX_!!13410985.jpg\" width=\"750\" height=\"750\" style=\"border:0px;vertical-align:top;margin:0px;padding:0px;font-family:tahoma, arial, , sans-serif;font-size:14px;line-height:21px;text-align:-webkit-center;background-color:#ffffff;\" /><br style=\"font-family:tahoma, arial, , sans-serif;font-size:14px;line-height:21px;text-align:-webkit-center;background-color:#ffffff;\" /><br style=\"font-family:tahoma, arial, , sans-serif;font-size:14px;line-height:21px;text-align:-webkit-center;background-color:#ffffff;\" /><img onload=\'if(this.width>600)makesmallpic(this,600,800);\' src=\"https://img.alicdn.com/imgextra/i1/13410985/TB2e9oCpXXXXXbtXXXXXXXXXXXX_!!13410985.jpg\" width=\"750\" height=\"750\" style=\"border:0px;vertical-align:top;margin:0px;padding:0px;font-family:tahoma, arial, , sans-serif;font-size:14px;line-height:21px;text-align:-webkit-center;background-color:#ffffff;\" /><br style=\"font-family:tahoma, arial, , sans-serif;font-size:14px;line-height:21px;text-align:-webkit-center;background-color:#ffffff;\" /><br style=\"font-family:tahoma, arial, , sans-serif;font-size:14px;line-height:21px;text-align:-webkit-center;background-color:#ffffff;\" /><img onload=\'if(this.width>600)makesmallpic(this,600,800);\' src=\"https://img.alicdn.com/imgextra/i3/13410985/TB2R4.ppXXXXXXqXpXXXXXXXXXX_!!13410985.jpg\" width=\"750\" height=\"750\" style=\"border:0px;vertical-align:top;margin:0px;padding:0px;font-family:tahoma, arial, , sans-serif;font-size:14px;line-height:21px;text-align:-webkit-center;background-color:#ffffff;\" /><br style=\"font-family:tahoma, arial, , sans-serif;font-size:14px;line-height:21px;text-align:-webkit-center;background-color:#ffffff;\" /><br style=\"font-family:tahoma, arial, , sans-serif;font-size:14px;line-height:21px;text-align:-webkit-center;background-color:#ffffff;\" /><img onload=\'if(this.width>600)makesmallpic(this,600,800);\' src=\"https://img.alicdn.com/imgextra/i2/13410985/TB2iXIrpXXXXXXfXpXXXXXXXXXX_!!13410985.jpg\" width=\"750\" height=\"750\" style=\"border:0px;vertical-align:top;margin:0px;padding:0px;font-family:tahoma, arial, , sans-serif;font-size:14px;line-height:21px;text-align:-webkit-center;background-color:#ffffff;\" /><br style=\"font-family:tahoma, arial, , sans-serif;font-size:14px;line-height:21px;text-align:-webkit-center;background-color:#ffffff;\" /><br style=\"font-family:tahoma, arial, , sans-serif;font-size:14px;line-height:21px;text-align:-webkit-center;background-color:#ffffff;\" /><img onload=\'if(this.width>600)makesmallpic(this,600,800);\' src=\"https://img.alicdn.com/imgextra/i1/13410985/TB2xyEopXXXXXXIXpXXXXXXXXXX_!!13410985.jpg\" width=\"750\" height=\"750\" style=\"border:0px;vertical-align:top;margin:0px;padding:0px;font-family:tahoma, arial, , sans-serif;font-size:14px;line-height:21px;text-align:-webkit-center;background-color:#ffffff;\" /><br style=\"font-family:tahoma, arial, , sans-serif;font-size:14px;line-height:21px;text-align:-webkit-center;background-color:#ffffff;\" /><br style=\"font-family:tahoma, arial, , sans-serif;font-size:14px;line-height:21px;text-align:-webkit-center;background-color:#ffffff;\" /><img onload=\'if(this.width>600)makesmallpic(this,600,800);\' src=\"https://img.alicdn.com/imgextra/i2/13410985/TB2JJQKpXXXXXaOXXXXXXXXXXXX_!!13410985.jpg\" width=\"750\" height=\"750\" style=\"border:0px;vertical-align:top;margin:0px;padding:0px;font-family:tahoma, arial, , sans-serif;font-size:14px;line-height:21px;text-align:-webkit-center;background-color:#ffffff;\" /><br /></p>','200','F66','99999');
INSERT INTO `qb_shop_content_1` VALUES ('7','7','55','1','<div class=\"sub-wrap\" id=\"J_SubWrap\" style=\"margin:0px;padding:0px;position:relative;z-index:99999998;width:750px;\"><div id=\"description\" class=\"J_DetailSection tshop-psm ke-post\" style=\"margin:0px 0px 20px;padding:0px;clear:both;font-stretch:normal;font-size:14px;line-height:1.5;font-family:tahoma, arial, , sans-serif;background:#ffffff !important;\"><div id=\"J_DivItemDesc\" class=\"content\" style=\"margin:0px;padding:10px 0px 0px;width:750px;overflow:hidden;word-wrap:break-word;position:relative !important;\"><p style=\"padding:0px;margin-top:1.12em;margin-bottom:1.12em;\"><img onload=\'if(this.width>600)makesmallpic(this,600,800);\' align=\"absmiddle\" src=\"https://img.alicdn.com/imgextra/i4/20868741/TB2p5nxqpXXXXbOXpXXXXXXXXXX_!!20868741.jpg\" style=\"border:0px;vertical-align:top;margin:0px;padding:0px;\" /><img onload=\'if(this.width>600)makesmallpic(this,600,800);\' align=\"absmiddle\" src=\"https://img.alicdn.com/imgextra/i4/20868741/TB2GxrSqpXXXXXcXpXXXXXXXXXX_!!20868741.jpg\" style=\"border:0px;vertical-align:top;margin:0px;padding:0px;\" /><img onload=\'if(this.width>600)makesmallpic(this,600,800);\' align=\"absmiddle\" src=\"https://img.alicdn.com/imgextra/i1/20868741/TB21ZvDqpXXXXboXpXXXXXXXXXX_!!20868741.jpg\" style=\"border:0px;vertical-align:top;margin:0px;padding:0px;\" /><img onload=\'if(this.width>600)makesmallpic(this,600,800);\' align=\"absmiddle\" src=\"https://img.alicdn.com/imgextra/i4/20868741/TB2tJDBqpXXXXbFXpXXXXXXXXXX_!!20868741.jpg\" style=\"border:0px;vertical-align:top;margin:0px;padding:0px;\" /></p></div></div></div><div class=\"J_AsyncDC tb-custom-area tb-shop\" data-type=\"main\" id=\"J_AsyncDCMain\" style=\"margin:0px;padding:0px;overflow:hidden;position:relative;\"><div class=\"J_TModule\" data-widgetid=\"6635877204\" id=\"shop6635877204\" data-componentid=\"7546767\" data-spm=\"110.0.7546767-6635877204\" microscope-data=\"7546767-6635877204\" data-title=\"ͼ޷Ʒ\" data-spm-max-idx=\"12\" style=\"margin:0px;padding:0px;\"><div class=\"tb-module tshop-um tshop-um-ow-cpmkI\" style=\"margin:0px 0px 50px;padding:0px;position:relative;z-index:5;overflow:hidden;font-family:΢ź, tahoma, arial, ;\"><div class=\"cpmkI\" style=\"margin:0px;padding:0px;overflow:hidden;background:#ffffff;\"><div class=\"myhd\" style=\"margin:0px;padding:30px 0px 50px;overflow:hidden;width:750px;font-weight:bold;text-align:center;\"><a target=\"_blank\" style=\"color:#3366cc;outline:0px;margin:0px;padding:0px;\"><span style=\"font-size:12px;line-height:18px;\"></span></a></div></div></div></div></div><p><br /></p>','150','A495','99999');
INSERT INTO `qb_shop_content_1` VALUES ('8','8','55','1','<p style=\"text-align:center\"><img onload=\'if(this.width>600)makesmallpic(this,600,800);\' onload=\"if(this.width&gt;600)makesmallpic(this,600,800);\" align=\"absmiddle\" src=\"https://img.alicdn.com/imgextra/i4/56651352/TB2KGfEopXXXXXnXXXXXXXXXXXX_!!56651352.jpg\" width=\"750\" height=\"739\" style=\"border:0px;vertical-align:top;margin:0px;padding:0px;font-family:tahoma, arial, , sans-serif;font-size:14px;line-height:21px;text-align:-webkit-center;background-color:#ffffff;\" /></p><p style=\"text-align:center\"><img onload=\'if(this.width>600)makesmallpic(this,600,800);\' onload=\"if(this.width&gt;600)makesmallpic(this,600,800);\" align=\"absmiddle\" src=\"https://img.alicdn.com/imgextra/i2/56651352/TB2x5TdopXXXXabXpXXXXXXXXXX_!!56651352.jpg\" width=\"750\" height=\"651\" style=\"border:0px;vertical-align:top;margin:0px;padding:0px;font-family:tahoma, arial, , sans-serif;font-size:14px;line-height:21px;text-align:-webkit-center;background-color:#ffffff;\" /></p>','1600','ST60','99992');
INSERT INTO `qb_shop_content_1` VALUES ('9','9','56','1','<table align=\"center\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\" width=\"748\" style=\"border-spacing:0px;font-family:tahoma, arial, , sans-serif;font-size:14px;line-height:21px;background-color:#ffffff;\"><tbody><tr><td align=\"center\" bgcolor=\"#f3f3f3\" height=\"30\" style=\"margin:0px;padding:0px;border:1px solid #cccccc;font-weight:bold;\">ʵչʾ Product show</td></tr></tbody></table><table align=\"center\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\" width=\"750\" style=\"border-spacing:0px;font-family:tahoma, arial, , sans-serif;font-size:14px;line-height:21px;clear:both;background-color:#FFFFFF;\"><tbody><tr><td align=\"center\" style=\"margin:0px;padding:0px;font-family:΢ź;\"><p style=\"text-align:center\"><img onload=\'if(this.width>600)makesmallpic(this,600,800);\' align=\"absmiddle\" src=\"https://img.alicdn.com/imgextra/i4/14197825/TB2X4VppFXXXXXuXFXXXXXXXXXX_!!14197825.jpg\" style=\"border:0px;vertical-align:top;margin:0px;padding:0px;\" /></p><p style=\"padding:0px;text-align:left;margin-top:1.12em;margin-bottom:1.12em;\"><span style=\"color:#404040;\"><span style=\"font-size:18px;line-height:15.6px;\"></span></span></p><p style=\"text-align:center\"><span style=\"font-size:18px;\"><span style=\"color:#404040;line-height:15.6px;\"><img onload=\'if(this.width>600)makesmallpic(this,600,800);\' align=\"absmiddle\" src=\"https://img.alicdn.com/imgextra/i2/14197825/TB2nldSpFXXXXbmXXXXXXXXXXXX_!!14197825.jpg\" style=\"border:0px;vertical-align:top;margin:0px;padding:0px;float:none;\" /></span></span></p><p style=\"text-align:center\"><span style=\"font-size:18px;\"><span style=\"color:#404040;line-height:15.6px;\"><img onload=\'if(this.width>600)makesmallpic(this,600,800);\' align=\"absmiddle\" src=\"https://img.alicdn.com/imgextra/i2/14197825/TB2.yXFpFXXXXa4XpXXXXXXXXXX_!!14197825.jpg\" style=\"border:0px;vertical-align:top;margin:0px;padding:0px;float:none;\" /></span></span></p><p style=\"padding:0px;text-align:left;margin-top:1.12em;margin-bottom:1.12em;\"><span style=\"color:#404040;\"><span style=\"font-size:18px;line-height:15.6px;\">й</span></span></p><p style=\"text-align:center\"><span style=\"font-size:18px;\"><span style=\"color:#404040;line-height:15.6px;\"><img onload=\'if(this.width>600)makesmallpic(this,600,800);\' align=\"absmiddle\" src=\"https://img.alicdn.com/imgextra/i1/14197825/TB2OF87pFXXXXXeXXXXXXXXXXXX_!!14197825.jpg\" style=\"border:0px;vertical-align:top;margin:0px;padding:0px;float:none;\" /></span></span></p><p style=\"padding:0px;font-size:12px;text-align:left;margin-top:1.12em;margin-bottom:1.12em;\"><span style=\"font-size:18px;\"><span style=\"color:#404040;line-height:15.6px;\">ӣ</span></span></p><p style=\"text-align:center\"><span style=\"font-size:18px;\"><span style=\"color:#404040;line-height:15.6px;\"><img onload=\'if(this.width>600)makesmallpic(this,600,800);\' align=\"absmiddle\" src=\"https://img.alicdn.com/imgextra/i1/14197825/TB20hJupFXXXXcxXpXXXXXXXXXX_!!14197825.jpg\" style=\"border:0px;vertical-align:top;margin:0px;padding:0px;float:none;\" /></span></span></p><p style=\"text-align:center\"><span style=\"font-size:18px;\"><span style=\"color:#404040;line-height:15.6px;\"><img onload=\'if(this.width>600)makesmallpic(this,600,800);\' align=\"absmiddle\" src=\"https://img.alicdn.com/imgextra/i1/14197825/TB2lsF2pFXXXXX6XXXXXXXXXXXX_!!14197825.jpg\" style=\"border:0px;vertical-align:top;margin:0px;padding:0px;float:none;\" /></span></span></p><p style=\"text-align:center\"><span style=\"font-size:18px;\"><span style=\"color:#404040;line-height:15.6px;\"><img onload=\'if(this.width>600)makesmallpic(this,600,800);\' align=\"absmiddle\" src=\"https://img.alicdn.com/imgextra/i4/14197825/TB2g0xgpFXXXXaEXFXXXXXXXXXX_!!14197825.jpg\" style=\"border:0px;vertical-align:top;margin:0px;padding:0px;float:none;\" /></span></span></p><p style=\"padding:0px;font-size:12px;text-align:left;margin-top:1.12em;margin-bottom:1.12em;\"><span style=\"font-size:18px;\"><span style=\"color:#404040;line-height:15.6px;\"></span></span></p><p style=\"text-align:center\"><img onload=\'if(this.width>600)makesmallpic(this,600,800);\' align=\"absmiddle\" src=\"https://img.alicdn.com/imgextra/i4/14197825/TB2M0lzpFXXXXbgXpXXXXXXXXXX_!!14197825.jpg\" style=\"border:0px;vertical-align:top;margin:0px;padding:0px;\" /></p><p style=\"padding:0px;font-size:12px;text-align:left;margin-top:1.12em;margin-bottom:1.12em;\"><span style=\"font-size:18px;\"><span style=\"color:#404040;line-height:15.6px;\"> &nbsp;</span></span><br /></p></td></tr></tbody></table><p><br /></p>','150','S1770','99999');
INSERT INTO `qb_shop_content_1` VALUES ('10','10','55','1','<p><img onload=\'if(this.width>600)makesmallpic(this,600,800);\' onload=\"if(this.width&gt;600)makesmallpic(this,600,800);\" align=\"absmiddle\" src=\"https://img.alicdn.com/imgextra/i1/108727117/TB2AZ90pXXXXXbnXXXXXXXXXXXX_!!108727117.jpg\" style=\"border:0px;vertical-align:top;margin:0px;padding:0px;font-family:tahoma, arial, , sans-serif;font-size:14px;line-height:21px;text-align:-webkit-center;background-color:#ffffff;\" /><img onload=\'if(this.width>600)makesmallpic(this,600,800);\' onload=\"if(this.width&gt;600)makesmallpic(this,600,800);\" align=\"absmiddle\" src=\"https://img.alicdn.com/imgextra/i4/108727117/TB2YMKnpXXXXXcNXpXXXXXXXXXX_!!108727117.jpg\" style=\"border:0px;vertical-align:top;margin:0px;padding:0px;font-family:tahoma, arial, , sans-serif;font-size:14px;line-height:21px;text-align:-webkit-center;background-color:#ffffff;\" /><br /></p>','110','16M','99999');
INSERT INTO `qb_shop_content_2` VALUES ('1','1','0','1','','ѧ','02028349635','13399999999','54325@qq.com','888888','510660','0','0','cvbnmmm');
INSERT INTO `qb_shop_content_2` VALUES ('2','2','0','1','','ѧ','02028349635','13399999999','54325@qq.com','888888','510660','1','1','cvbnmmm');
INSERT INTO `qb_shop_content_2` VALUES ('3','3','0','1','','ѧ','02028349635','13399999999','54325@qq.com','888888','510660','1','4','cvbnmmm');
INSERT INTO `qb_shop_content_2` VALUES ('13','13','0','1','','ѧ','02028349635','13399999999','54325@qq.com','888888','510660','1','1','cvbnmmm');
INSERT INTO `qb_shop_field` VALUES ('86','1','Ʒ','content','mediumtext','0','1','ieedit','600','250','','','','','0','0','0','0','','','','','31','');
INSERT INTO `qb_shop_field` VALUES ('151','2','֧ʽ','order_paytype','int','1','2','radio','0','0','1|¸\r\n4|ϼʱ֧','1','','','0','0','0','0','','','','','0','');
INSERT INTO `qb_shop_field` VALUES ('152','2','ϵַ','order_address','varchar','100','1','text','200','0','','','','','0','0','0','0','','','','','31','');
INSERT INTO `qb_shop_field` VALUES ('80','1','ͺ','shoptype','varchar','50','7','text','10','0','','','','','0','0','0','0','','','','','31','');
INSERT INTO `qb_shop_field` VALUES ('142','2','ע','content','mediumtext','0','-1','textarea','400','50','','','','','0','0','0','0','','','','','31','');
INSERT INTO `qb_shop_field` VALUES ('78','1','г۸','market_price','varchar','10','9','text','12','0','','','Ԫ','','0','1','0','0','','','','','31','');
INSERT INTO `qb_shop_field` VALUES ('145','2','ϵ绰','order_phone','varchar','20','8','text','100','0','','','','','0','0','0','0','','','','','31','');
INSERT INTO `qb_shop_field` VALUES ('144','2','˿','order_username','varchar','20','9','text','100','0','','','','','0','0','0','0','','','','','31','');
INSERT INTO `qb_shop_field` VALUES ('146','2','ϵֻ','order_mobphone','varchar','15','7','text','100','0','','','','','0','0','0','0','','','','','31','');
INSERT INTO `qb_shop_field` VALUES ('147','2','ϵ','order_email','varchar','50','6','text','100','0','','','','','0','0','0','0','','','','','31','');
INSERT INTO `qb_shop_field` VALUES ('148','2','ϵQQ','order_qq','varchar','11','5','text','100','0','','','','','0','0','0','0','','','','','31','');
INSERT INTO `qb_shop_field` VALUES ('149','2','','order_postcode','varchar','6','4','text','100','0','','','','','0','0','0','0','','','','','31','');
INSERT INTO `qb_shop_field` VALUES ('150','2','ͷʽ','order_sendtype','int','1','3','radio','0','0','1|\r\n2|ͻ','1','','','0','0','0','0','','','','','0','');
INSERT INTO `qb_shop_field` VALUES ('153','1','','storage','int','7','6','text','50','0','','999','','','0','0','0','0','','','','','31','');
INSERT INTO `qb_shop_join` VALUES ('1','2','1','1','0','1482137100','1','admin','0','127.0.0.1','0','0','0','40','','','1=1','0','0','0','');
INSERT INTO `qb_shop_join` VALUES ('2','2','9','1','0','1483925731','1','admin','0','127.0.0.1','0','0','0','210','','','7=1,9=1','0','0','0','');
INSERT INTO `qb_shop_join` VALUES ('3','2','10','1','0','1484278544','1','admin','0','127.0.0.1','0','0','0','190','','','5=1,10=1','0','0','0','');
INSERT INTO `qb_shop_join` VALUES ('13','2','9','1','0','1484644084','1','admin','0','127.0.0.1','0','0','0','200','','','5=1,9=1','0','0','0','9hmzj0874x');
INSERT INTO `qb_shop_module` VALUES ('2','0','','1','','','','0','0','a:4:{s:4:\"list\";s:12:\"joinlist.htm\";s:4:\"show\";s:12:\"joinshow.htm\";s:4:\"post\";s:8:\"join.htm\";s:6:\"search\";s:0:\"\";}');
INSERT INTO `qb_shop_module` VALUES ('1','0','ʵ','4','','','','1','0','');
INSERT INTO `qb_shop_mysort` VALUES ('3','0','0','ҵƷ','1','0');
INSERT INTO `qb_shop_mysort` VALUES ('2','0','1','Ʒ','1','1');
INSERT INTO `qb_shop_mysort` VALUES ('4','3','1','','1','0');
INSERT INTO `qb_shop_mysort` VALUES ('5','2','1','ֻ','1','0');
INSERT INTO `qb_shop_pic` VALUES ('1','1','21','0','1','0','https://img.alicdn.com/imgextra/i1/292829878/TB2ZOsgkpXXXXbsXXXXXXXXXXXX_!!292829878.jpg','','0');
INSERT INTO `qb_shop_pic` VALUES ('2','2','21','0','1','0','https://img.alicdn.com/imgextra/i2/13410985/TB2pi1oqpXXXXbxXXXXXXXXXXXX_!!13410985.jpg','','0');
INSERT INTO `qb_shop_pic` VALUES ('3','3','21','0','1','0','https://img.alicdn.com/imgextra/i3/20868741/TB2t2OYpFXXXXaTXpXXXXXXXXXX_!!20868741.jpg','','0');
INSERT INTO `qb_shop_pic` VALUES ('4','3','21','0','1','0','https://img.alicdn.com/imgextra/i3/20868741/TB2YViQpFXXXXbWXpXXXXXXXXXX_!!20868741.jpg','','0');
INSERT INTO `qb_shop_pic` VALUES ('5','4','21','0','1','0','https://gd2.alicdn.com/bao/uploaded/i2/1723790336/TB2LD1NpXXXXXcJXpXXXXXXXXXX_!!1723790336.jpg','','0');
INSERT INTO `qb_shop_pic` VALUES ('6','5','22','0','1','0','https://img.alicdn.com/imgextra/i2/20604171/TB2HmxinFXXXXcIXpXXXXXXXXXX_!!20604171.jpg','','0');
INSERT INTO `qb_shop_pic` VALUES ('7','6','22','0','1','0','https://img.alicdn.com/imgextra/i1/13410985/TB2XhQwpXXXXXcoXXXXXXXXXXXX_!!13410985.jpg','','0');
INSERT INTO `qb_shop_pic` VALUES ('8','7','23','0','1','0','https://img.alicdn.com/imgextra/i4/20868741/TB2GxrSqpXXXXXcXpXXXXXXXXXX_!!20868741.jpg','','0');
INSERT INTO `qb_shop_pic` VALUES ('9','8','23','0','1','0','https://img.alicdn.com/imgextra/i3/56651352/TB2pRrtopXXXXbAXXXXXXXXXXXX_!!56651352.jpg','','0');
INSERT INTO `qb_shop_pic` VALUES ('10','9','23','0','1','0','https://img.alicdn.com/imgextra/i4/14197825/TB2PulMpFXXXXXdXFXXXXXXXXXX_!!14197825.jpg','','0');
INSERT INTO `qb_shop_pic` VALUES ('11','10','64','0','1','0','https://gd2.alicdn.com/bao/uploaded/i2/108727117/TB2P38gpXXXXXb3XpXXXXXXXXXX_!!108727117.jpg','','1');
INSERT INTO `qb_shop_pic` VALUES ('13','10','64','0','1','0','https://gd1.alicdn.com/imgextra/i1/108727117/TB2sW4spXXXXXchXpXXXXXXXXXX_!!108727117.jpg','','0');
INSERT INTO `qb_shop_pic` VALUES ('14','9','23','0','1','0','https://img.alicdn.com/imgextra/i1/14197825/TB2cVqvpFXXXXbbXpXXXXXXXXXX_!!14197825.jpg','','0');
INSERT INTO `qb_shop_pic` VALUES ('15','9','23','0','1','0','https://img.alicdn.com/imgextra/i1/14197825/TB2voqlpFXXXXcOXpXXXXXXXXXX_!!14197825.jpg','','0');
INSERT INTO `qb_shop_pic` VALUES ('16','8','23','0','1','0','https://img.alicdn.com/imgextra/i2/56651352/TB2seHsopXXXXbNXXXXXXXXXXXX_!!56651352.jpg','','0');
INSERT INTO `qb_shop_pic` VALUES ('17','8','23','0','1','0','https://img.alicdn.com/imgextra/i3/56651352/TB2eeviopXXXXXpXpXXXXXXXXXX_!!56651352.jpg','','0');
INSERT INTO `qb_shop_pic` VALUES ('18','7','23','0','1','0','https://img.alicdn.com/imgextra/i2/20868741/TB2RKTtqpXXXXcbXpXXXXXXXXXX_!!20868741.jpg','','0');
INSERT INTO `qb_shop_pic` VALUES ('19','7','23','0','1','0','https://img.alicdn.com/imgextra/i1/20868741/TB2PrLQqpXXXXXTXpXXXXXXXXXX_!!20868741.jpg','','0');
INSERT INTO `qb_shop_pic` VALUES ('20','6','22','0','1','0','https://img.alicdn.com/imgextra/i3/13410985/TB2PncDpXXXXXbbXXXXXXXXXXXX_!!13410985.jpg','','0');
INSERT INTO `qb_shop_pic` VALUES ('21','6','22','0','1','0','https://img.alicdn.com/imgextra/i4/13410985/TB2wfQUpXXXXXXsXXXXXXXXXXXX_!!13410985.jpg','','0');
INSERT INTO `qb_shop_pic` VALUES ('22','5','22','0','1','0','https://img.alicdn.com/imgextra/i2/20604171/TB2.BXEnFXXXXcoXXXXXXXXXXXX_!!20604171.jpg','','0');
INSERT INTO `qb_shop_pic` VALUES ('23','5','22','0','1','0','https://img.alicdn.com/imgextra/i4/20604171/TB2LANOnFXXXXaGXXXXXXXXXXXX_!!20604171.jpg','','0');
INSERT INTO `qb_shop_pic` VALUES ('24','4','21','0','1','0','https://gd3.alicdn.com/imgextra/i3/1723790336/TB2KwjMepXXXXXLXpXXXXXXXXXX_!!1723790336.jpg','','0');
INSERT INTO `qb_shop_pic` VALUES ('25','4','21','0','1','0','https://gd2.alicdn.com/imgextra/i2/1723790336/TB2XCDRepXXXXcvXXXXXXXXXXXX_!!1723790336.jpg','','0');
INSERT INTO `qb_shop_pic` VALUES ('26','3','21','0','1','0','https://img.alicdn.com/imgextra/i3/20868741/TB2.GKFpFXXXXaxXFXXXXXXXXXX_!!20868741.jpg','','0');
INSERT INTO `qb_shop_pic` VALUES ('27','2','21','0','1','0','https://img.alicdn.com/imgextra/i1/13410985/TB2XC8EqpXXXXcWXpXXXXXXXXXX_!!13410985.jpg','','0');
INSERT INTO `qb_shop_pic` VALUES ('28','2','21','0','1','0','https://img.alicdn.com/imgextra/i4/13410985/TB2cMqEqpXXXXX1XXXXXXXXXXXX_!!13410985.jpg','','0');
INSERT INTO `qb_shop_pic` VALUES ('29','1','21','0','1','0','https://img.alicdn.com/imgextra/i1/292829878/TB2UY67kpXXXXX6XpXXXXXXXXXX_!!292829878.jpg','','0');
INSERT INTO `qb_shop_pic` VALUES ('30','1','21','0','1','0','https://img.alicdn.com/imgextra/i2/292829878/TB2eSAhkpXXXXbzXXXXXXXXXXXX_!!292829878.jpg','','0');
INSERT INTO `qb_shop_sort` VALUES ('1','0','ҾƷ','1','1','0','1','','0','0','','../images/wins/info3.png','','','a:4:{s:4:\"head\";s:0:\"\";s:4:\"foot\";s:0:\"\";s:4:\"list\";s:0:\"\";s:8:\"bencandy\";s:0:\"\";}','','0','','','','0','','','','','0','a:1:{s:11:\"field_value\";N;}','0','0','','','0');
INSERT INTO `qb_shop_sort` VALUES ('2','0','','1','1','0','1','','0','0','','../images/wins/info7.png','','','a:4:{s:4:\"head\";s:0:\"\";s:4:\"foot\";s:0:\"\";s:4:\"list\";s:0:\"\";s:8:\"bencandy\";s:0:\"\";}','','0','','','','0','','','','','0','a:1:{s:11:\"field_value\";N;}','0','0','','','0');
INSERT INTO `qb_shop_sort` VALUES ('4','0','','1','1','0','1','','0','0','','../images/wins/info6.png','','','a:4:{s:4:\"head\";s:0:\"\";s:4:\"foot\";s:0:\"\";s:4:\"list\";s:0:\"\";s:8:\"bencandy\";s:0:\"\";}','','0','','','','0','','','','','0','a:1:{s:11:\"field_value\";N;}','0','0','','','0');
INSERT INTO `qb_shop_sort` VALUES ('5','0','Ӱ','1','1','0','1','','10','0','','../images/wins/info2.png','','','a:4:{s:4:\"head\";s:0:\"\";s:4:\"foot\";s:0:\"\";s:4:\"list\";s:0:\"\";s:8:\"bencandy\";s:0:\"\";}','','0','','','','0','','','','','0','a:1:{s:11:\"field_value\";N;}','0','0','','','0');
INSERT INTO `qb_shop_sort` VALUES ('6','1','Ҿ/Ҿ߶/˼Ҵ','1','2','0','0','','0','0','','','','','a:4:{s:4:\"head\";s:0:\"\";s:4:\"foot\";s:0:\"\";s:4:\"list\";s:0:\"\";s:8:\"bencandy\";s:0:\"\";}','','0','','','','0','','','','','0','a:1:{s:11:\"field_value\";N;}','0','0','','jiaju','0');
INSERT INTO `qb_shop_sort` VALUES ('7','1','װ꽨','1','2','0','0','','0','0','','','','','','','0','','','','1','','','','','0','','0','0','','','0');
INSERT INTO `qb_shop_sort` VALUES ('8','1','','1','2','0','0','','0','0','','','','','a:4:{s:4:\"head\";s:0:\"\";s:4:\"foot\";s:0:\"\";s:4:\"list\";s:0:\"\";s:8:\"bencandy\";s:0:\"\";}','','0','','','','0','','','','','0','a:1:{s:11:\"field_value\";N;}','0','0','','richangyongpin','0');
INSERT INTO `qb_shop_sort` VALUES ('9','2','ʳ','1','2','0','0','','0','0','','','','','','','0','','','','1','','','','','0','','0','0','','','0');
INSERT INTO `qb_shop_sort` VALUES ('10','2','','1','2','0','0','','0','0','','','','','','','0','','','','1','','','','','0','','0','0','','','0');
INSERT INTO `qb_shop_sort` VALUES ('11','2','ˮ','1','2','0','0','','0','0','','','','','','','0','','','','1','','','','','0','','0','0','','','0');
INSERT INTO `qb_shop_sort` VALUES ('48','4','ֱ','1','2','0','0','','0','0','','','','','','','0','','','','1','','','','','0','','0','0','','','0');
INSERT INTO `qb_shop_sort` VALUES ('49','4','Ʒ//ʱƷ','1','2','0','0','','0','0','','','','','','','0','','','','1','','','','','0','','0','0','','','0');
INSERT INTO `qb_shop_sort` VALUES ('50','4','רʩ','1','2','0','0','','0','0','','','','','','','0','','','','1','','','','','0','','0','0','','','0');
INSERT INTO `qb_shop_sort` VALUES ('20','2','KTV','1','2','0','0','','0','0','','','','','','','0','','','','1','','','','','0','','0','0','','','0');
INSERT INTO `qb_shop_sort` VALUES ('21','5','','1','2','0','0','','0','0','','','','','','','0','','','','1','','','','','0','','0','0','','','0');
INSERT INTO `qb_shop_sort` VALUES ('22','5','ֻ','1','2','0','0','','0','0','','','','','','','0','','','','1','','','','','0','','0','0','','','0');
INSERT INTO `qb_shop_sort` VALUES ('23','5','','1','2','0','0','','0','0','','','','','','','0','','','','1','','','','','0','','0','0','','','0');
INSERT INTO `qb_shop_sort` VALUES ('30','1','װƷ//̺','1','2','0','0','','0','0','','','','','','','0','','','','1','','','','','0','','0','0','','','0');
INSERT INTO `qb_shop_sort` VALUES ('31','1','Ӽ//','1','2','0','0','','0','0','','','','','','','0','','','','1','','','','','0','','0','0','','','0');
INSERT INTO `qb_shop_sort` VALUES ('32','1','Ʒ//ë/','1','2','0','0','','0','0','','','','','','','0','','','','1','','','','','0','','0','0','','','0');
INSERT INTO `qb_shop_sort` VALUES ('33','1','ջ//','1','2','0','0','','0','0','','','','','','','0','','','','1','','','','','0','','0','0','','','0');
INSERT INTO `qb_shop_sort` VALUES ('34','1','','1','2','0','0','','0','0','','','','','','','0','','','','1','','','','','0','','0','0','','','0');
INSERT INTO `qb_shop_sort` VALUES ('35','1','/Ʒ/Ʒ','1','2','0','0','','0','0','','','','','','','0','','','','1','','','','','0','','0','0','','','0');
INSERT INTO `qb_shop_sort` VALUES ('51','4','鱦/ʯ//ƽ','1','2','0','0','','0','0','','','','','','','0','','','','1','','','','','0','','0','0','','','0');
INSERT INTO `qb_shop_sort` VALUES ('52','4','۾','1','2','0','0','','0','0','','','','','','','0','','','','1','','','','','0','','0','0','','','0');
INSERT INTO `qb_shop_sort` VALUES ('53','4','zippo/ʿ/̾','1','2','0','0','','0','0','','','','','','','0','','','','1','','','','','0','','0','0','','','0');
INSERT INTO `qb_shop_sort` VALUES ('54','0','װ','1','1','0','1','','0','0','','../images/wins/info1.png','','','a:4:{s:4:\"head\";s:0:\"\";s:4:\"foot\";s:0:\"\";s:4:\"list\";s:0:\"\";s:8:\"bencandy\";s:0:\"\";}','','0','','','','0','','','','','0','a:1:{s:11:\"field_value\";N;}','0','0','','','0');
INSERT INTO `qb_shop_sort` VALUES ('55','54','Ůװ','1','2','0','0','','0','0','','','','','','','0','','','','1','','','','','0','','0','0','','','0');
INSERT INTO `qb_shop_sort` VALUES ('56','54','Ůʿ/ʿ/Ҿӷ','1','2','0','0','','0','0','','','','','','','0','','','','1','','','','','0','','0','0','','','0');
INSERT INTO `qb_shop_sort` VALUES ('57','54','ŮЬ/Ь//Ь/','1','2','0','0','','0','0','','','','','','','0','','','','1','','','','','0','','0','0','','','0');
INSERT INTO `qb_shop_sort` VALUES ('58','54','Ů///','1','2','0','0','','0','0','','','','','','','0','','','','1','','','','','0','','0','0','','','0');
INSERT INTO `qb_shop_sort` VALUES ('59','54','Ů/Χ/ñ/Ƥ','1','2','0','0','','0','0','','','','','','','0','','','','1','','','','','0','','0','0','','','0');
INSERT INTO `qb_shop_sort` VALUES ('60','54','װ','1','2','0','0','','0','0','','','','','','','0','','','','1','','','','','0','','0','0','','','0');
INSERT INTO `qb_shop_sort` VALUES ('61','54','Ь/ƤЬ/Ь','1','2','0','0','','0','0','','','','','','','0','','','','1','','','','','0','','0','0','','','0');
INSERT INTO `qb_shop_sort` VALUES ('62','54','˶Ь/ܲЬ/Ь','1','2','0','0','','0','0','','','','','','','0','','','','1','','','','','0','','0','0','','','0');
INSERT INTO `qb_shop_sort` VALUES ('63','54','˶/T/̿/װ','1','2','0','0','','0','0','','','','','','','0','','','','1','','','','','0','','0','0','','','0');
INSERT INTO `qb_shop_sort` VALUES ('64','5','MP3/MP4/iPod/¼','1','2','0','0','','0','0','','','','','','','0','','','','1','','','','','0','','0','0','','','0');
INSERT INTO `qb_shop_sort` VALUES ('71','0','','1','1','0','1','','0','0','','../images/wins/info4.png','','','a:4:{s:4:\"head\";s:0:\"\";s:4:\"foot\";s:0:\"\";s:4:\"list\";s:0:\"\";s:8:\"bencandy\";s:0:\"\";}','','0','','','','0','','','','','0','a:1:{s:11:\"field_value\";N;}','0','0','','','0');
INSERT INTO `qb_shop_sort` VALUES ('72','71','չ˾','1','2','0','0','','0','0','','','','','','','0','','','','1','','','','','0','','0','0','','','0');
INSERT INTO `qb_shop_sort` VALUES ('73','71','ͨ','1','2','0','0','','0','0','','','','','','','0','','','','1','','','','','0','','0','0','','','0');
INSERT INTO `qb_shop_sort` VALUES ('74','71','Ҳ','1','2','0','0','','0','0','','','','','','','0','','','','1','','','','','0','','0','0','','','0');
INSERT INTO `qb_shop_sort` VALUES ('75','0','','1','1','0','1','','0','0','','../images/wins/info5.png','','','a:4:{s:4:\"head\";s:0:\"\";s:4:\"foot\";s:0:\"\";s:4:\"list\";s:0:\"\";s:8:\"bencandy\";s:0:\"\";}','','0','','','','0','','','','','0','a:1:{s:11:\"field_value\";N;}','0','0','','','0');
INSERT INTO `qb_shop_sort` VALUES ('76','75','Ϸ㿨','1','2','0','0','','0','0','','','','','','','0','','','','1','','','','','0','','0','0','','','0');
INSERT INTO `qb_shop_sort` VALUES ('77','75','װ/Ϸ/ʺ/','1','2','0','0','','0','0','','','','','','','0','','','','1','','','','','0','','0','0','','','0');
INSERT INTO `qb_shop_sort` VALUES ('78','75','ӿƱ','1','2','0','0','','0','0','','','','','','','0','','','','1','','','','','0','','0','0','','','0');
INSERT INTO `qb_shop_sort` VALUES ('79','75','ƶֵͨ','1','2','0','0','','0','0','','','','','','','0','','','','1','','','','','0','','0','0','','','0');
INSERT INTO `qb_shop_sort` VALUES ('80','75','Ʊ','1','2','0','0','','0','0','','','','','','','0','','','','1','','','','','0','','0','0','','','0');
INSERT INTO `qb_street` VALUES ('1','1','̫ƽׯ','0','0','0','','0','0','','','','','','','0','','','1','','','','','0','','BeiTaiPingZhuang');
INSERT INTO `qb_street` VALUES ('2','1','','0','0','0','','0','0','','','','','','','0','','','1','','','','','0','','DaZhongSi');
INSERT INTO `qb_street` VALUES ('3','1','','0','0','0','','0','0','','','','','','','0','','','1','','','','','0','','DingHuiSi');
INSERT INTO `qb_street` VALUES ('4','1','ʼҿ','0','0','0','','0','0','','','','','','','0','','','1','','','','','0','','GanJiaKou');
INSERT INTO `qb_street` VALUES ('5','1','','0','0','0','','0','0','','','','','','','0','','','1','','','','','0','','GongZhuFen');
INSERT INTO `qb_street` VALUES ('6','1','','0','0','0','','0','0','','','','','','','0','','','1','','','','','0','','HangTianQiao');
INSERT INTO `qb_street` VALUES ('7','1','','0','0','0','','0','0','','','','','','','0','','','1','','','','','0','','JianXiangQiao');
INSERT INTO `qb_street` VALUES ('8','1','峧','0','0','0','','0','0','','','','','','','0','','','1','','','','','0','','LanDianChang');
INSERT INTO `qb_street` VALUES ('9','1','','0','0','0','','0','0','','','','','','','0','','','1','','','','','0','','MaDian');
INSERT INTO `qb_street` VALUES ('10','1','','0','0','0','','0','0','','','','','','','0','','','1','','','','','0','','QingHe');
INSERT INTO `qb_street` VALUES ('11','1','ϵ','0','0','0','','0','0','','','','','','','0','','','1','','','','','0','','ShangDi');
INSERT INTO `qb_street` VALUES ('12','1','ׯ','0','0','0','','0','0','','','','','','','0','','','1','','','','','0','','ShangZhuang');
INSERT INTO `qb_street` VALUES ('13','1','ļ','0','0','0','','0','0','','','','','','','0','','','1','','','','','0','','SiJiQing');
INSERT INTO `qb_street` VALUES ('14','1','κ','0','0','0','','0','0','','','','','','','0','','','1','','','','','0','','WeiGongCun');
INSERT INTO `qb_street` VALUES ('15','1','','0','0','0','','0','0','','','','','','','0','','','1','','','','','0','','XiErQi');
INSERT INTO `qb_street` VALUES ('16','1','','0','0','0','','0','0','','','','','','','0','','','1','','','','','0','','WuDaoKou');
INSERT INTO `qb_street` VALUES ('17','1','','0','0','0','','0','0','','','','','','','0','','','1','','','','','0','','XiSanQi');
INSERT INTO `qb_street` VALUES ('18','1','ֱ','0','0','0','','0','0','','','','','','','0','','','1','','','','','0','','XiZhiMen');
INSERT INTO `qb_street` VALUES ('19','1','ɽ','0','0','0','','0','0','','','','','','','0','','','1','','','','','0','','WaiXiangShan');
INSERT INTO `qb_street` VALUES ('20','1','ѧԺ·','0','0','0','','0','0','','','','','','','0','','','1','','','','','0','','XueYuanLu');
INSERT INTO `qb_street` VALUES ('21','1','Ȫ·','0','0','0','','0','0','','','','','','','0','','','1','','','','','0','','YuQuanLu');
INSERT INTO `qb_street` VALUES ('22','1','Բ԰','0','0','0','','0','0','','','','','','','0','','','1','','','','','0','','YuanMingYuan');
INSERT INTO `qb_street` VALUES ('23','1','йش','0','0','0','','0','0','','','','','','','0','','','1','','','','','0','','ZhongGuanCun');
INSERT INTO `qb_weixinmenu` VALUES ('1','1','0','վҳ','','http://life7.php168.com/','0','0','0');
INSERT INTO `qb_weixinmenu` VALUES ('2','1','0','Ա','','http://life7.php168.com/member/wapindex.php','0','0','0');
INSERT INTO `qb_weixinword` VALUES ('2','۸','Żϵͳ۸ֱ6800Ԫ9500Ԫϵͳ۸3500Ԫ4500Ԫ','10','0');
INSERT INTO `qb_weixinword` VALUES ('3','Ʒ Ʒ','ǵĲƷеطŻϵͳCMSϵͳB2BϵͳϢϵͳ','11','0');
INSERT INTO `qb_wxlogin` VALUES ('dwsqufea','cd72e8c0e7f11a9','','1468392922');
INSERT INTO `qb_zone` VALUES ('1','1','','0','0','0','','0','0','','','','','','','0','','','1','','','','','0','','HaiDian');
INSERT INTO `qb_zone` VALUES ('2','1','','0','0','0','','0','0','','','','','','','0','','','1','','','','','0','','ChaoYang');
INSERT INTO `qb_zone` VALUES ('3','1','','0','0','0','','0','0','','','','','','','0','','','1','','','','','0','','DongCheng');
INSERT INTO `qb_zone` VALUES ('4','1','','0','0','0','','0','0','','','','','','','0','','','1','','','','','0','','XiCheng');
INSERT INTO `qb_zone` VALUES ('5','1','','0','0','0','','0','0','','','','','','','0','','','1','','','','','0','','ChongWen');
INSERT INTO `qb_zone` VALUES ('6','1','','0','0','0','','0','0','','','','','','','0','','','1','','','','','0','','XuanWu');
INSERT INTO `qb_zone` VALUES ('7','1','̨','0','0','0','','0','0','','','','','','','0','','','1','','','','','0','','FengTai');
INSERT INTO `qb_zone` VALUES ('8','1','ʯɽ','0','0','0','','0','0','','','','','','','0','','','1','','','','','0','','ShiJingShan');
INSERT INTO `qb_zone` VALUES ('9','1','ɽ','0','0','0','','0','0','','','','','','','0','','','1','','','','','0','','FangShan');
INSERT INTO `qb_zone` VALUES ('10','1','','0','0','0','','0','0','','','','','','','0','','','1','','','','','0','','DaXing');
INSERT INTO `qb_zone` VALUES ('11','1','ͨ','0','0','0','','0','0','','','','','','','0','','','1','','','','','0','','TongZhou');
INSERT INTO `qb_zone` VALUES ('12','1','˳','0','0','0','','0','0','','','','','','','0','','','1','','','','','0','','ShunYi');
INSERT INTO `qb_zone` VALUES ('13','1','ƽ','0','0','0','','0','0','','','','','','','0','','','1','','','','','0','','ChangPing');
INSERT INTO `qb_zone` VALUES ('14','1','','0','0','0','','0','0','','','','','','','0','','','1','','','','','0','','MiYun');
INSERT INTO `qb_zone` VALUES ('15','1','','0','0','0','','0','0','','','','','','','0','','','1','','','','','0','','HuaiRou');
INSERT INTO `qb_zone` VALUES ('16','1','','0','0','0','','0','0','','','','','','','0','','','1','','','','','0','','YanQing');
INSERT INTO `qb_zone` VALUES ('17','1','ƽ','0','0','0','','0','0','','','','','','','0','','','1','','','','','0','','PingGu');
INSERT INTO `qb_zone` VALUES ('18','1','ͷ','0','0','0','','0','0','','','','','','','0','','','1','','','','','0','','MenTouGou');
