<?php
/**
* 小说处理器
*
* @version        $Id: novel.novel.php 2016年4月27日 20:31  weimeng
* @package        WMCMS
* @copyright      Copyright (c) 2015 WeiMengCMS, Inc.
* @link           http://www.weimengcms.com
*
*/
$conSer = AdminNewClass('system.config');

$curModule = 'novel';
$table = '@novel_novel';
$code = 300;

//修改分类信息
if ( $type == 'edit' || $type == "add"  )
{
	$pinyinSer = NewClass('pinyin');
	$novelMod = NewModel('novel.novel');
	$chapterMod = NewModel('novel.chapter');
	$recSer = AdminNewClass('novel.rec');
	
	//小说数据
	$data = str::Escape( $post['novel'], 'e' );
	//推荐数据
	$rec = str::Escape( Request('rec') , 'e' );

	$where['novel_id'] = Request('novel_id');
	$data['novel_cover'] = file::GetImg($data['novel_cover'], @$post['down_cover']);
	$data['novel_clicktime'] = strtotime(@$data['novel_clicktime']);
	$data['novel_uptime'] = strtotime(@$data['novel_uptime']);
	$data['novel_colltime'] = strtotime(@$data['novel_colltime']);
	$data['novel_rectime'] = strtotime(@$data['novel_rectime']);
	$data['novel_createtime'] = strtotime(@$data['novel_createtime']);
	//检查拼音是否为空
	if( $data['novel_pinyin'] == '' )
	{
		$data['novel_pinyin'] = $pinyinSer->topy($data['novel_name']);
	}
	
	//小说名字检查
	$wheresql['table'] = $table;
	$wheresql['where']['novel_id'] = array('<>',$where['novel_id']);
	$wheresql['where']['novel_name'] = $data['novel_name'];
	$novelData = wmsql::GetOne($wheresql);

	
	if ( $data['novel_name'] == '' || $data['novel_author'] == '' )
	{
		$info = '对不起，小说名字和小说作者必须填写！';
	}
	else if( !str::Number($data['type_id']) )
	{
		$info = '对不起，小说分类必须选择！';
	}
	else if ( $novelData )
	{
		$info = '对不起，该小说已经存在！';
	}
	else
	{
		//拼音是否存在查询
		unset($wheresql['where']['novel_name']);
		$wheresql['where']['novel_pinyin'] = $data['novel_pinyin'];
		$pinyinCount = wmsql::GetCount($wheresql);
		
		//新增数据
		if( $type == 'add' )
		{
			//引入小说配置
			$novelConfig = AdminInc('novel');
			//写入新小说作者和来源的数据
			$mangerSer = AdminNewClass('manager');
			//写入标签
			$mangerSer->SetTags('novel' , $data['novel_tags']);

			$code = 200;
			$info = '恭喜您，小说添加成功！';
			$where['novel_id'] = wmsql::Insert($table, $data);
			$novelData['novel_id'] = $where['novel_id'];
			$novelData['chapter_number'] = 0;
			
			//写入操作记录
			SetOpLog( '新增了小说'.$data['novel_name'] , 'novel' , 'insert' , $table , $where , $data );
		}
		//修改分类
		else
		{
			//原始小说数据
			$oldData = $novelMod->GetOne($where['novel_id']);
			
			$code = 200;
			$info = '恭喜您，小说修改成功！';
			$result = wmsql::Update($table, $data, $where);

			//修改小说分类移动文件
			if( $result )
			{
				$novelMod->MoveNovelFolder($oldData['type_id'],$data['type_id'],$where['novel_id']);
			}
			
			//写入操作记录
			SetOpLog( '修改了小说'.$data['novel_name'] , 'novel' , 'update' , $table , $where , $data );
		}
		
		//拼音已经存在就重新设置
		if ( $pinyinCount > 0 )
		{
			$pinyinData['novel_pinyin'] = $data['novel_pinyin'].$where['novel_id'];
			wmsql::Update($table, $pinyinData, $where);
		}
		
		//写入自定义字段
		$fieldArr['module'] = $curModule;
		$fieldArr['option'] = @$post['field'];
		$fieldArr['tid'] = $data['type_id'];
		$fieldArr['cid'] = $where['novel_id'];
		$fieldArr['ft'] = '2';
		$conSer->SetFieldOption($fieldArr);
		
		//修改小说推荐-先检查是否存在推荐的信息
		$recSer->SetRec( $where['novel_id'] , $rec , false);
	}
	if( @$isReturn == true )
	{
		return array('message'=>$info,'code'=>$code,'data'=>$novelData);
	}
	else
	{
		Ajax($info , $code);
	}
}
//删除数据和永久删除数据
else if ( $type == 'del' )
{
	$applyMod = NewModel('system.apply' , 'author');
	
	$where['novel_id'] = GetDelId();
	$wheresql['table'] = $table;
	$wheresql['field'] = 'type_id,novel_id';
	$wheresql['where'] = $where;
	$novelData = wmsql::GetAll($wheresql);
	if( $novelData )
	{
		//删除申请记录
		$applyWhere['apply_cid'] = GetDelId();
		$applyWhere['apply_module'] = 'author';
		$applyWhere['apply_type'] = array('or','novel_editnovel,novel_cover,novel_editchapter');
		$applyMod->Delete($applyWhere);

		//删除章节
		wmsql::Delete('@novel_chapter' , array("chapter_nid"=>$where['novel_id']));
		
		//写入操作记录
		SetOpLog( '删除了小说' , 'novel' , 'delete' , $table , $where);
		wmsql::Delete($table , $where);
		
		foreach ($novelData as $k=>$v)
		{
			//删除文件
			$novelSer = AdminNewClass('novel.novel');
			$novelSer->DelNovelFile($v['type_id'],$v['novel_id']);
		}
	}
	
	
	Ajax('小说删除成功!');
}
//审核数据
else if ( $type == 'status' )
{
	$data['novel_status'] = Request('status');
	$where['novel_id'] = GetDelId();

	if( Request('status') == '1')
	{
		//修改申请记录
		$applyMod = NewModel('system.apply','author');
		$applyMod->BatchUpdateStatus('novel_editnovel' , $where['novel_id']);
		
		$msg = '审核通过';
	}
	else
	{
		$msg = '取消审核';
	}
	//写入操作记录
	SetOpLog( $msg.'了小说' , 'novel' , 'update' , $table , $where);
	
	wmsql::Update($table, $data, $where);
	Ajax('小说'.$msg.'成功!');
}
//移动数据
else if ( $type == 'move' )
{
	$data['type_id'] = Request('tid');
	$where['novel_id'] = GetDelId();

	//写入操作记录
	SetOpLog( '移动了小说' , 'novel' , 'update' , $table , $where);
	
	wmsql::Update($table, $data, $where);
	Ajax('小说移动成功!');
}
//小说搜索操作
else if ( $type == 'search' )
{
	$st = Request('st');
	$keyword = Request('keyword');
	//返回类型。默认全部，否则是键值对
	$rt = Request('rt');
	
	$where['table'] = $table;
	//判断是否搜索标题
	switch ($st)
	{
		case 'author':
			$where['where']['novel_author'] = array('like',$keyword);
			break;
			
		default:
			$where['where']['novel_name'] = array('like',$keyword);
			break;
	}
	$where['limit'] = '0,20';
	
	$data = wmsql::GetAll($where);
	if( $data && $rt == 'key')
	{
		foreach ($data as $k=>$v)
		{
			$data[$k] = array('key'=>$v['novel_id'],'val'=>$v['novel_name']);
		}
	}
	
	Ajax('查询成功!',null,$data);
}
?>