<?php
/**
* 公共函数库
*
* @version        $Id: function.php 2016年3月21日 13:52  weimeng
* @package        WMCMS
* @copyright      Copyright (c) 2015 WeiMengCMS, Inc.
* @link           http://www.weimengcms.com
* @uptime		  2016年5月31日 15:00 weimeng
*
*/

if(!defined('WMINC')){ exit("dont alone open!"); }


//判断是否是ajax请求
function IsAjax()
{
	if(@isset($_SERVER['HTTP_X_REQUESTED_WITH']) && @strtolower($_SERVER['HTTP_X_REQUESTED_WITH']) == 'xmlhttprequest')
	{
		return true;
	}
	else
	{
		return false;
	}
}

/**
 * 是否是GET提交的
 */
function IsGet()
{
	return @$_SERVER['REQUEST_METHOD'] == 'GET' ? true : false;
}

/**
 * 是否是POST提交
 */
function IsPost() {
	return (@$_SERVER['REQUEST_METHOD'] == 'POST' && (empty($_SERVER['HTTP_REFERER']) || preg_replace("~https?:\/\/([^\:\/]+).*~i", "\\1", @$_SERVER['HTTP_REFERER']) == preg_replace("~([^\:]+).*~", "\\1", @$_SERVER['HTTP_HOST']))) ? true : false;
}


/**
 * 引入文件，如果文件存在则引入
 * @param 参数1，文件路径。
 * @param 参数2，是否为配置文件，
 */
function Inc( $path , $name = ''){
	if( file_exists($path) )
	{
		if ( DEVELOPER )
		{
			echo '载入文件：'.$path.'<br/>';
		}
		//是否需要返回配置文件内容
		if( $name != '')
		{
			require $path;
			$arr = $name.'Config';
			return $$arr;
		}
		else
		{
			return require $path;
		}
	}
	else if ( DEVELOPER )
	{
		if ( ERR )
		{
			exit( C('system.file.no', null , 'lang') . '<br/>文件路径:'.$path );
		}
		else
		{
			echo '警告：'.$path.'不存在<br/><br/>';
		}
	}
}


/**
 * 导入类文件操作
 * @param 参数1，必须，类名
 * @param 参数2，选填，是否传入默认值
 * @param 参数3，选填，置顶的路径
 * @param 参数4，选填，文件的后缀
 */
function NewClass( $name , $data = '' , $path = WMCLASS , $type = 'class' )
{
	$file = $path.$name.'.'.$type.'.php';
	if( file_exists($file) )
	{
		if ( DEVELOPER )
		{
			echo '载入文件：'.$file.'<br/>';
		}

		if( $type == 'model' )
		{
			$className = $name.'model';
		}
		else if( $type == 'label' )
		{
			$className = $name.'label';
		}
		else
		{
			$className = $name;
		}
		if( !class_exists($className) )
		{
			require_once $file;
		}
		$ob = new $className( $data );
		
		return $ob;
	}
	else if ( DEVELOPER )
	{
		if ( ERR )
		{
			exit( C('system.file.no', null , 'lang') . '<br/>文件路径:'.$file );
		}
		else
		{
			echo '警告：类文件'.$file.'不存在<br/><br/>';
		}
	}
}
/**
 * 载入模块类/module
 * @param 参数1，必须，载入的模块
 * @param 参数2，选填，默认的数据
 */
function NewModuleClass($module, $data = '' , $isSys = false)
{
	if( $isSys == false )
	{
		$path = WMMODULE.$module;
	}
	else
	{
		$path = WMSYSMODULE.$module;
	}
	
	return NewClass( $module , $data , $path.'/' );
}
/**
 * 载入模型/wmcms/models
 * @param 参数1，必须，模型的地址
 * @param 参数2，选填，默认的数据
 */
function NewModel($model, $data = '')
{
	$arr = explode('.', $model);
	return NewClass( $arr[1] , $data , WMMODELS.$arr[0].'/' , 'model');
}
/**
 * 载入单功能模块/wmcms/module
 * @param 参数1，必须，模块的名字
 */
function IncModule($module)
{
	global $C;
	$modulePath = WMSYSMODULE.$module.'/';
	$configName = $module.'Config';
	
	//如果配置文件不存在就引入配置文件
	global $$configName;
	if( !is_array($$configName) )
	{
		$$configName = Inc( $modulePath.$module.'.config.php' , $module);
	}
	
	NewClass( $module , '' , $modulePath );
	NewClass( $module , '' , $modulePath , 'label');
}
/**
 * 获取模块的配置/module/module
 * @param 参数1，必须，模块的名字
 */
function GetModuleConfig($module , $isSys = false)
{
	if( $isSys == false )
	{
		$path = WMMODULE.$module.'/'.$module.'.config.php';
	}
	else
	{
		$path = WMSYSMODULE.$module.'/'.$module.'.config.php';
	}
	return Inc( $path , $module);
}

function GetModuleLang($module)
{
	return Inc( WMMODULE.$module.'/lang/'.C('config.web.lang').'/system.php');
}

/**
 * 根据传入的模块标识获得模块的名字
 * @param 参数1，选填，模块标识，如果为空就返回全部数组，如果是xx.xx格式表示删除里面的模块
 * @param unknown $name
 */
function GetModuleName( $name = '')
{
	$arr = array(
		'all'=>'全站首页',
		'novel'=>'小说模块',
		'app'=>'应用模块',
		'article'=>'文章模块',
		'picture'=>'图集模块',
		'message'=>'留言模块',
		'bbs'=>'论坛模块',
		'link'=>'友链模块',
		'author'=>'原创模块',
		'user'=>'用户模块',
		'zt'=>'专题模块',
		'about'=>'信息模块',
		'diy'=>'单页模块',
		'down'=>'下载模块',
		'replay'=>'评论模块',
		'search'=>'搜索模块',
	);
	$notModule = explode(',', NOTMODULE);
	foreach ($notModule as $k=>$v)
	{
		unset($arr[$v]);
	}
	
	if( $name == '' )
	{
		return $arr;
	}
	else
	{
		//判断是否存在删除模块
		$nameArr = explode('.', $name);
		if( count($nameArr) > 1 )
		{
			foreach ($nameArr as $k=>$v)
			{
				unset($arr[$v]);
			}
			return $arr;
		}
		else
		{
			return @$arr[$name];
		}
	}
}


/**
 * 多维数组取值和赋值
 * @param 参数1，必须，字符串， 键名。
 * @param 参数2，选填，字符串， 值名。
 * @param 参数3，选填，操作的数组或者数组名字。
 * 返回值：取得的值或者true
 */
function C( $key , $val = '' , $default = ''){
	global $C;
	
	//如果默认为数组就设置为数组
	if ( is_array( $default ) )
	{
		$value = $default;
	}
	//如果默认为字符串则读取相应的数组
	else if ( trim( $default ) != '')
	{
		global $$default;
		$value = $$default;
		$config = &$$default;
	}
	//否则就设置
	else
	{
		$value = $C;
		$config = &$C;
	}
	//如果返回全部数组
	if( $key == '' && $default != '' )
	{
		return $value;
	}
	else
	{
		//分割键
		$nodes = explode('.', $key);
	
		//如果没有值就读取数组
		if( !is_array($val) && trim( $val ) == '' )
		{
			foreach ($nodes as $node)
			{
				if ( isset($value[$node]) )
				{
					$value = $value[$node];
				}
				else
				{
					$value = null;
					break;
				}
			}
	
			if( $value != '' || $value == '0' )
			{
				if( !is_array($value) )
				{
					//$value = htmlspecialchars($value);
				}
				if( class_exists('str') && !is_int($value))
				{
					return str::Escape($value);
				}
				else
				{
					return $value;
				}
			}
		}
		//如果有值就写入数组
		else
		{
			//循环赋值
			foreach ( $nodes as $node )
			{
				if ( isset($config[$node]) )
				{
					$config = & $config[$node];
				}
				else
				{
					$config[$node] = array();
					$config = & $config[$node];
				}
			}

			$config = $val;
			if( $val === 'delete' )
			{
				$config = '';
			}

			return true;
		}
	}
}


/**
 * 设置session和取得session的值
 * @param 参数1，必须，session的键
 * @param 参数2，选填，如果有值则为设置session，否则为调用session
 */
function Session( $key , $val = '' )
{
	$value = true;
	//开启session
	if( @!isset($_SESSION) )
	{
		session_start();
	}
	//@session_start();
	if(	!is_array($val) && $val != '0' && empty( $val ) )
	{
		$value = @$_SESSION[$key];
		if ($value == '')
		{
			$value = false;
		}
	}
	//设置为空
	else if ( $val == 'delete' )
	{
		unset($_SESSION[$key]);
	}
	else
	{
		$_SESSION[$key] = $val;
	}
	//关闭session
	//session_write_close();
	return $value;
}


/**
 * 设置cookie和取得cookie的值
 * @param 参数1，必须，cookie的键
 * @param 参数2，选填，如果有值则为设置cookie，否则为调用cookie
 * @param 参数3，选填，cookie时的有效时间，默认为30天
 * @param 参数4，选填，cookie的保存目录
 * @param 参数5，选填，cookie的保存服务器
 */
function Cookie( $key , $val = '' , $time = '' , $path = '/' ,  $server = '' )
{
	$value = '';


	//设置cookie默认的保存时间
	if ( $time == '')
	{
		$time = time()+3600*24*30;
	}
	else if( $time == 'auto' || $time == '0')
	{
		$time = 0;
	}
	else
	{
		$time = time()+$time;
	}
	
	
	//如果没有值就取出键对应的cookie
	if(	trim( $val ) == '' && $val != 'delete' )
	{
		$value = InputFilter(@$_COOKIE[$key]);
	}
	//否则就设置cookie
	else if( trim( $val ) != '' )
	{
		//设置为空
		if ( $val == 'delete' )
		{
			$val = '';
		}
		//设置cookie服务器
		if( $server == '' )
		{
			$server = SetServer();
		} 

		$value = setcookie( $key , $val , $time , $path , $server );
	}
	return $value;
}


/**
 * 获得cook和session的保存服务器地址
 */
SetServer();
function SetServer(){
	$domain = $_SERVER['SERVER_NAME'];
	$server = '';

	//如果不是本地服务器就设置cookie服务器
	if( GetIp() == '127.0.0.1')
	{
		$domain = '127.0.0.1';
	}
	if( $domain <> '127.0.0.1' && $domain <> 'localhost' && C('config.web.cookie_type') == '1')
	{
		$realIp = str_replace( '.' , '' , $domain );
		//检查IP是否为数字
		if( intval($realIp) )
		{
			$server = $domain;
		}
		else
		{
			$cd=str_ireplace('http://','',C('config.web.weburl'));

			//如果以/结尾了
			if( substr($cd, -1) == '/' )
			{
				$cd = substr($cd,0,-1);
			}

			//顶域名的时候
			if( substr_count($cd,'.') == '1' ){
				$server='.'.$cd;
			}
			//子域名的时候
			else
			{
				$cdarr=explode('.',$cd);
				for($i=1;$i<count($cdarr);$i++)
				{
					$server .= '.'.$cdarr[$i];
				}
			}
		}
	}

	return $server;
}


/**
 *
 * 获得get的值
 * @param 参数1，选填，键名，不填则取出所有get请求参数
 * @param 参数2，选填，默认值
 * @param 参数3，选填，是否进行参数过滤。
 */
function Get( $key = '' , $default = ''  , $isFilter = true)
{
	$value = '';
	if ( $key == '' )
	{
		$getStr = $_SERVER['QUERY_STRING'];
		if ( $getStr != '' )
		{
			$getArr = explode('&', $getStr);
			foreach ($getArr as $k=>$v)
			{
				if( strstr($v , '=') )
				{
					$arr = explode('=', $v);
					if( $arr[0] != '_' )
					{
						@$value[$arr[0]] = $arr[1];
					}
				}
			}
		}
	}
	else
	{
		if(	trim( $key ) != '' )
		{
			if( !isset( $_GET[$key] ) && $default != '')
			{
				$value = $default;
			}
			else if( isset( $_GET[$key] ) )
			{
				//是否过滤
				if( $isFilter )
				{
					$value = InputFilter(stripslashes($_GET[$key]));
				}
				else
				{
					$value = stripslashes($_GET[$key]);
				}
				if( $value == '' && $default != '' )
				{
					$value = $default;
				}
			}
		}
	}

	return $value;
}


/**
 *
 * 获得post的值
 * @param 参数1，必须，键名，不填则取出所有post请求参数
 * @param 参数2，选填，默认值。
 * @param 参数3，选填，是否进行参数过滤。
 */
function Post( $key = '' , $default = '' , $isFilter = true)
{
	if ( $key == '' )
	{
		$value = $_POST;
	}
	else
	{
		$value = '';
		if(	trim( $key ) != '' )
		{
			$value = @$_POST[$key];
			if( !is_array($value) )
			{
				$value = @stripslashes($value);
			}
			if( $value == '' && $default != '')
			{
				$value = $default;
			}
			//是否过滤
			else if( $isFilter == true )
			{
				$value = InputFilter($value);
			}
		}
	}
	return $value;
}


/**
 * 获取请求参数，先从post提取，然后从get提取
 * @param 参数1，选填，参数键名。
 */
function Request( $key = '' , $val = '')
{
	$value = Post( $key );
	if ( $value == '' )
	{
		$value = Get( $key , $val);
	}
	return $value;
}
/**
 * post，get，session,cookie数据过滤
 */
function InputFilter($str)
{
	if( !is_array($str) && $str != '' )
	{
		$array = array(
			//"<"			=>	'{#lt}',
			//">"			=>	'{#gt}',
			"'"			=>	'&#39;',
			"<"			=>	'&lt;',
			">"			=>	'&gt;',
		);
	
		$str = strtr($str,$array);
	}
	return $str;
}


/**
 * 方法调用器
 * @param 参数1，选填，类名
 * @param 参数2，选填，方法名
 * @param 参数3，选填，变量或参数
 * @example 只填参数2表示调用普通方法
 * @example 参数1和参数2表示调用类里面的方法
 * @example 参数1和参数3表示类里面的变量
 * @example 类可以是对象可以是类名，类名使用的是静态调用。
 */
function Call($class='',$func='',$data='')
{
	if( $class == '' )
	{
		if( function_exists($func) )
		{
			return $func($data);
		}
		else if( DEBUG == TRUE && ERR == false)
		{
			tpl::ErrInfo('方法 '.$func.' 不存在!');
		}
		else if( DEBUG == TRUE)
		{
			die('function '.$func.' not exists!');
		}
	}
	else
	{
		//如果是字符串
		if( gettype($class) == 'string' )
		{
			if( !class_exists($class) )
			{
				die('class not fund');
			}
			else if( $func == '' )
			{
				return $class::$$data;
			}
			else
			{
				if( method_exists($class,$func) )
				{
					$class::$func($data);
				}
				else if( DEBUG == TRUE && ERR == false)
				{
					tpl::ErrInfo('方法 '.$class.'::'.$func.' 不存在!');
				}
				else if( DEBUG == TRUE )
				{
					die('class '.$class.'::'.$func.' not exists');
				}
			}
		}
		else
		{
			if( $func == '' )
			{
				return $class->$data;
			}
			else
			{
				if( method_exists($class,$func) )
				{
					return $class->$func($data);
				}
				else if( DEBUG == TRUE && ERR == false)
				{
					tpl::ErrInfo('方法 '.$class.'->'.$func.' 不存在!');
				}
				else if( DEBUG == TRUE )
				{
					die('class '.$class.'->'.$func.' not exists');
				}
			}
		}
	}
}


//检查是否是手机浏览器
function IsPhone(){
	if ( isset ($_SERVER['HTTP_X_WAP_PROFILE']) )
	{
		return true;
	}
	if (isset ($_SERVER['HTTP_VIA']) )
	{
		return stristr($_SERVER['HTTP_VIA'], "wap") ? true : false;
	}
	if (isset ($_SERVER['HTTP_USER_AGENT']))
	{
		$clientkeywords = array (
			'nokia','sony','ericsson','mot','samsung','htc','sgh','lg','sharp','sie-','philips','panasonic','alcatel','lenovo',
			'iphone','ipod','ipad','blackberry','meizu','android','netfront','symbian','ucweb','windowsce','palm','operamini',
			'operamobi','openwave','nexusone','cldc','midp','wap','mobile','android'
		);
		// 从HTTP_USER_AGENT中查找手机浏览器的关键字
		if ( preg_match("/(" . implode('|', $clientkeywords) . ")/i", strtolower($_SERVER['HTTP_USER_AGENT']) ) )
		{
			return true;
		}
	}
	if ( isset ($_SERVER['HTTP_ACCEPT']) )
	{
		if ((strpos($_SERVER['HTTP_ACCEPT'], 'vnd.wap.wml') !== false) && (strpos($_SERVER['HTTP_ACCEPT'], 'text/html') === false || (strpos($_SERVER['HTTP_ACCEPT'], 'vnd.wap.wml') < strpos($_SERVER['HTTP_ACCEPT'], 'text/html')))){
			return true;
		}
	}
	return false;
}

//是否是蜘蛛
function IsSpider()
{
	$userAgent = strtolower($_SERVER['HTTP_USER_AGENT']);
	$spiderArr = GetSpider(2);
	foreach ($spiderArr as $k=>$v)
	{
		if (strpos($userAgent,$k) !== false)
		{
			return GetSpider(2,$k);
		}
	}
	return false;
}

/**
 * 获得蜘蛛
 * @param 参数1，选填，1为返回数组，2为返回列表。
 * @param 参数2，选填，是否指定了蜘蛛id，返回蜘蛛信息。
 */
function GetSpider($type=1,$spiderId='')
{
	$spiderArr = array(
		'baidu'=>array('name'=>'百度蜘蛛','list'=>array(
				'baiduspider-image'=>'百度图片蜘蛛','baiduspider-mobile'=>'百度移动蜘蛛',
				'baiduspider-video'=>'百度视频蜘蛛','baiduspider-news'=>'百度新闻蜘蛛','baiduspider'=>'百度网页蜘蛛',
		)),
		'360'=>array('name'=>'360蜘蛛','list'=>array(
				'360spider'=>'360网页蜘蛛','haosouspider'=>'好搜网页蜘蛛',
		)),
		'google'=>array('name'=>'谷歌蜘蛛','list'=>array(
				'googlebot-mobile'=>'谷歌移动蜘蛛','googlebot-image'=>'谷歌图片蜘蛛','mediapartners-google'=>'谷歌adsense蜘蛛',
				'adsbot-google'=>'谷歌广告蜘蛛','googlebot'=>'谷歌网页蜘蛛',
		)),
		'sogou'=>array('name'=>'搜狗蜘蛛','list'=>array(
				'sosospider'=>'搜搜网页蜘蛛','sogou news spider'=>'搜狗新闻蜘蛛','sogou web spider'=>'搜狗网页蜘蛛',
				'sogou inst spider'=>'搜狗蜘蛛','sogou orion spider'=>'搜狗蜘蛛','sogou spider'=>'搜狗蜘蛛',
				'sogou spider2'=>'搜狗蜘蛛','sogou blog'=>'搜狗蜘蛛','sogouspider'=>'搜狗蜘蛛',
		)),
		'yahoo'=>array('name'=>'雅虎蜘蛛','list'=>array(
				'yahoo'=>'雅虎蜘蛛',
		)),
		'youdao'=>array('name'=>'有道蜘蛛','list'=>array(
				'youdaobot'=>'有道蜘蛛','yodaobot'=>'有道蜘蛛',
		)),
		'msn'=>array('name'=>'微软蜘蛛','list'=>array(
				'msnbot-media'=>'微软视频蜘蛛','msnbot-new'=>'微软新闻蜘蛛','msnbot-products'=>'微软产品蜘蛛',
				'msnbot-academic'=>'微软广告蜘蛛','msnbot'=>'微软蜘蛛',
		)),
		'bing'=>array('name'=>'必应蜘蛛','list'=>array(
				'bingbot'=>'必应蜘蛛',
		)),
		'yisou'=>array('name'=>'一搜蜘蛛','list'=>array(
				'yisouspider'=>'一搜蜘蛛',
		)),
		'archiver'=>array('name'=>'Alexa蜘蛛','list'=>array(
				'ia_archiver'=>'Alexa蜘蛛',
		)),
		'easou'=>array('name'=>'宜搜蜘蛛','list'=>array(
				'easouspider'=>'宜搜蜘蛛',
		)),
		'jike'=>array('name'=>'即刻蜘蛛','list'=>array(
				'jikespider'=>'即刻蜘蛛',
		)),
		'etao'=>array('name'=>'一淘蜘蛛','list'=>array(
				'etaospider'=>'一淘蜘蛛',
		)),
	);
	//如果等于2就只返回所有的键值对
	if( $type==2 )
	{
		$newArr = array();
		foreach ($spiderArr as $k=>$v)
		{
			foreach ($v['list'] as $key=>$val)
			{
				if($spiderId != '' && $key==$spiderId)
				{
					return array('group'=>$k,'group_name'=>$v['name'],'spider'=>$key,'spider_name'=>$val);
				}
				$newArr[$key] = $val; 
			}
		}
		$spiderArr = $newArr;
	}
	return $spiderArr;
}


/**
 * 判断是否是序列化字符串
 * @param 参数1，必填，字符串。
 */
function IsSerialize( $str ) {
     $str = trim( $str );
     if ( preg_match( '/^s:[0-9]+:.*;$/s', $str ) )
	 {
         return true;
	 }
	 else
	 {
		return false;
	 }
}


/**
 * 处理参数匹配
 * @param 参数1，必填，id和pinyin的字段名数组。
 * @param 参数2，必填，参数值。
 * @param 参数3，选填，是否已经有where条件了。
 */
function CheckPar(  $parName , $par , $where = '' )
{
	if ( str::Number($par) )
	{
		$newWhere[$parName['id']] = $par;
	}
	else
	{
		$newWhere[$parName['pinyin']] = $par;
	}

	if( is_array($where) )
	{
		$newWhere = array_merge($where,$newWhere);
	}
	return $newWhere;
}




//返回jsonp格式数据
function ReturnJsonp( $msg = '' , $code = 200 , $data = '' )
{
	ReturnData( $msg , $ajax = true , $code , $data ,  $type = 'jsonp');
}
//返回json格式数据
function ReturnJson( $msg = '' , $code = 200 , $data = '' )
{
	ReturnData( $msg , $ajax = true , $code , $data ,  $type = 'json');
}
//返回xml格式数据
function ReturnXml( $msg = '' , $code = 200 , $data = '' )
{
	ReturnData( $msg , $ajax = true , $code , $data ,  $type = 'xml');
}
/**
 * 通用返回，自动识别成功失败。
 * @param 参数1，必须，返回消息
 * @param 参数2，选填，默认200成功有数据状态，300成功但是没有数据,500失败。
 * @param 参数3，选填，sql语句是否执行成功。
 * @param 参数4，选填，返回的值
 */
function ReturnData( $msg = '操作成功！' , $ajax = '' , $code = 500 , $data = '' ,  $type = 'json')
{
	if( $msg == '' )
	{
		$msg = '操作成功！';
	}
	//追加的返回字段
	$res = C('res');
	if( is_array($res) )
	{
		foreach ($res as $k=>$v)
		{
			$res[$k] = $v;
			if( IsSerialize($v) )
			{
				$res[$k] = unserialize($v);
			}
		}
	}
	$res['msg'] = $msg;
	$res['code'] = $code;
	$res['data'] = $data;
	$res['count'] = count($data);
	//每次请求都要清空掉
	C('res','delete');
	
	
	//如果ajax返回为空
	if( $ajax == '' )
	{
		$ajax = str::IsTrue( Request('ajax') , 'yes' , 'page.ajax');
	}

	//如果是ajax返回。
	if ( $ajax || C('page.ajax') )
	{
		if( $type == 'json' )
		{
			die(urldecode(json_encode( $res )));
		}
		else if( $type == 'jsonp' )
		{
			$callback = Request('callback');
			if( $callback != '' )
			{
				die($callback.'('.urldecode(json_encode( $res )).')');
			}
			else
			{
				die(urldecode(json_encode( $res )));
			}
		}
	}
	//否则直接返回。
	else
	{
		tpl::ErrInfo( $res['msg'] );
	}
}


//获得ip
function GetIp()
{
	if ( getenv("HTTP_CLIENT_IP") )
	{
		$ip = getenv("HTTP_CLIENT_IP");
	}
	else if( getenv("HTTP_X_FORWARDED_FOR") )
	{
		$ip = getenv("HTTP_X_FORWARDED_FOR");
	}
	else if( getenv("REMOTE_ADDR") )
	{
		$ip = getenv("REMOTE_ADDR");
	}
	else
	{
		$ip = "0.0.0.0";
	}
	
	/*
	$realIp = str_replace( '.' , '' , $ip );
	//检查IP是否为数字
	if( $realIp != '::1' )
	{
		str::Int($realIp , C('system.par.ip_err',null,'lang') );
	}*/
	
	return $ip;
}


/**
 * 获取url中的域名。
 * @param 参数1，必须，字符串，url地址
 * @param 参数2，选填，是否返回主域名
 */
function GetDomain( $url , $isMain = true)
{
	if ( $url == '' )
	{
		return false;
	}
	
	$pattern = "/[w-] .(com|net|org|gov|cc|biz|info|cn|cc|pw|wang)(.(cn|hk))*/";
	preg_match($pattern, $url, $matches);
	if(count($matches) > 0)
	{
		return $matches[0];
	}
	else
	{
		$rs = parse_url($url);
		$mainUrl = @$rs["host"];
		if( $isMain === false)
		{
			return $mainUrl;
		}
		
		if( !strcmp( long2ip(sprintf("%u",ip2long($mainUrl))) , $mainUrl ) )
		{
			return $mainUrl;
		}
		else
		{
			$arr = explode(".",$mainUrl);
			$count=count($arr);
			$endArr = array("com","net","org","3322");//com.cn net.cn 等情况
			if ( in_array($arr[$count-2],$endArr) )
			{
				$domain = $arr[$count-3].".".$arr[$count-2].".".$arr[$count-1];
			}
			else
			{
				$domain = $arr[$count-2].".".$arr[$count-1];
			}
			return $domain;
		}
	}
}


/**
 * 保留/禁用字符检查
 * @param 参数1，必须，需要检查的字符串
 * @param 参数2，选填，错误的提示字符串，如果为空则直接返回false
 */
function CheckShield( $str , $info = '' , $type = 'shield' )
{
	//文件设置
	if ( $type == 'shield' )
	{
		$file = 'key.shield.txt';
	}
	else
	{
		$file = 'key.disable.txt';
	}
	
	$shield = file::GetFile(WMCONFIG.$file);
	if ( $shield == '' )
	{
		return true;
	}
	else
	{
		$shieldArr = explode("\r\n",$shield);
		foreach ( $shieldArr as $k=>$v )
		{
			if ( str_replace($v,'',$str) != $str )
			{
				if ( $info == '' )
				{
					return false;
				}
				else
				{
					$info = str_replace('{字符}',$v,$info);
					tpl::ErrInfo( $info );
				}
			}
		}
	}
}



/**
 * 图片地址生成缩略图地址  _s.jpg格式
 * @param 参数1，必须，图片的路径或者地址
 */
function SImg( $path )
{
	$fileName = strrchr( $path ,'/');
	$fileName = str_replace('/','',$fileName);
	$ext = explode('.',$fileName);
	return $ext[0].'_s.'.$ext['1'];
}


/**
 * 获得毫秒数
 */
function GetMtime()
{
	list($usec, $sec) = explode(" ", microtime());
	return ((float)$usec)*1000000;
}



/**
 * 获得版本的名字
 * @param 参数1，必须，版本类型
 */
function GetPtName( $pt )
{
	$pt = (string)$pt;
	if ( $pt == '1' || $pt == 'wap' )
	{
		$ptName = '简洁版';
	}
	else if ( $pt == '2' || $pt == '3g' )
	{
		$ptName = '3G版';
	}
	else if ( $pt == '3' || $pt == 'm' )
	{
		$ptName = '触屏版';
	}
	else if ( $pt == '4' || $pt == 'web' )
	{
		$ptName = '电脑版';
	}
	
	return $ptName;
}

/**
 * 获得版本的标识
 * @param 参数1，选填，版本的数字
 */
function GetPtMark( $pt = '' )
{
	//如果不存在就读取ua设置的pt数字
	if( $pt == '' )
	{
		$pt = C('ua.pt_int');
	}

	//进行判断
	if ( $pt == '1' )
	{
		$ptMark = 'wap';
	}
	else if ( $pt == '2' )
	{
		$ptMark = '3g';
	}
	else if ( $pt == '3' )
	{
		$ptMark = 'm';
	}
	else if ( $pt == '4' )
	{
		$ptMark = 'web';
	}

	return $ptMark;
}


/**
 * 获得当前完整的url
 */
function GetUrl()
{
	$par = '';
	if( $_SERVER['QUERY_STRING'] != '' )
	{
		$par = '?'.$_SERVER['QUERY_STRING'];
	}
	return 'http://'.$_SERVER['HTTP_HOST'].$_SERVER['PHP_SELF'].$par;
}

/**
 * getURL参数格式化成数组
 * @param 参数1，选填，是否指定url
 * @param 参数2，选填，格式化方式，1为转为数组，2为转为字符串。
 */
function UrlFormat($url='' , $type = '1')
{
	//转为数组操作
	if( $type == '1' )
	{
		if( $url == ''  )
		{
			$url = @$_SERVER['QUERY_STRING'];
		}
		else
		{
			if( strpos($url , '.php?') )
			{
				$urlArr = explode('.php?', $url);
				$url = $urlArr[1];
			}
		}
	
		$arr = array();
		if( $url != '' )
		{
			foreach (explode('&', $url) as $k=>$v)
			{
				if( count(explode('=', $v)) > 1)
				{
					list($key,$val) = explode('=', $v);
					$arr[$key] = $val;
				}
			}
		}
	}
	//还原成url操作
	else
	{
		$arr = '';
		foreach ($url as $k=>$v)
		{
			$arr .= $k.'='.$v;
			if(!IsLast($url, $k))
			{
				$arr .= '&';
			}
		}
	}
	return $arr;
}

/**
 * 获得当前网址的路径或者文件名字
 * @param 参数1，选填，返回类型，0为全部,1为路径，2为文件名，3为包含文件名的路径
 * @param 参数2，选填，是否返回文件名字（加密文件名字和参数），默认为false
 */
function GetUrlPath($returnType = 0 , $returnFileName = false)
{
	$path = '';
	$self = $_SERVER['PHP_SELF'];

	//返回全部
	if( $returnType == '0' )
	{
		$path = $self;
	}
	else
	{
		$pathArr = explode('/' ,$_SERVER['PHP_SELF']);
		foreach ($pathArr as $k=>$v)
		{
			$isLast = IsLast($pathArr, $k);
			//最后一个数组并且不是返回文件名字
			if ( $isLast )
			{
				$fileName = $v;
				if( $returnType == '3' )
				{
					@list($pagename,$ext) = @explode('.', $v);
					$path = $path.$pagename.'/';
				}
			}
			//不是最后一个数组
			else if ( !$isLast )
			{
				$path .= $v.'/';
			}
		}
		
		
		if( $returnFileName == true )
		{
			$path = $path.md5(Encrypt($fileName.$_SERVER['QUERY_STRING']));
		}
		else if( $returnType == '2')
		{
			$path = $fileName;
		}
	}
	return $path;
}


/**
 * 检查网页刷新的时间间隔
 * @param 参数1，选填，两次刷新网页的间隔的时间。
 * @param 参数2，选填，错误的提示。
 */
function CheckRefTime( $time = 0 , $info = '' )
{
	if( $time > 0 )
	{
		$refTime = time() - Session('ref_time');
		if ($refTime < $time)
		{
			if( $info == '' )
			{
				$info = '请不要频繁刷新，休息'.($time-$refTime).'秒再刷新吧';
			}
			tpl::ErrInfo($info);
		}
		Session('ref_time' , time());
	}
}


/**
 * 检查需要操作的内容的条数
 * @param 参数1，必须,表名
 * @param 参数2，必须，字段名字
 * @param 参数3，必须，字段的值
 */
function GetContentCount($table , $field , $cid)
{
	$where['table'] = $table;
	$where['where'][$field] = $cid;
	$count = wmsql::GetCount( $where , $field );
	return $count;
}


/**
 * 判断是否是数组最后一个元素
 * @param 参数1，必须，数组
 * @param 参数2，必须，当前的元素顺序
 */
function IsLast($arr , $k)
{
	if( count($arr)-1 == $k)
	{
		return true;
	}
	else
	{
		return false;
	}
}


/**
 * 获得自定义字段的条件
 * @param 参数1，必须，模块
 * @param 参数2，选填，查询类型，默认为分类
 */
function GetFieldWhere($module , $where , $type='1')
{
	if( @$where['field'] == '' )
	{
		$where['field'] = '*';
	}
	$where['field'] = $where['field'].',ft.field_option as t_field,ft.value_option as t_value';
	$where['left']['@config_field_value as ft'] = 'ft.value_field_module="'.$module.'" and ft.value_field_type="1" and ft.value_content_id = t.type_id';
	
	if( $type == '2' )
	{
		$where['field'] = $where['field'].',fv.field_option as c_field,fv.value_option as c_value';
		$where['left']['@config_field_value as fv'] = 'fv.value_field_module="'.$module.'" and fv.value_field_type="2" and fv.value_content_id = '.$module.'_id';

		//配置查询指定栏目下面的子栏目数据
		if( isset($where['where']['t.type_id']) )
		{
			$tidWhere = $where['where']['t.type_id'];
			if( is_array($tidWhere) )
			{
				$andOrWhere = array('rin',$tidWhere[1]);
			}
			else
			{
				$andOrWhere = array('rin',$tidWhere);
			}
			$where['where']['type_pid'] = array('and-or',$andOrWhere,array('t.type_id'=>$tidWhere));
			unset($where['where']['t.type_id']);
		}
	}

	return $where;
}
/**
 * 替换自定义的字段
 * @param 参数1，必须，数组2
 * @param 参数2，选填，数组1
 * @param 参数3，必须，内容数组
 * @param 参数4，选填，默认为1分类字段，2为内容字段。
 */
function RepField($arr2 , $arr1 = '' , $value , $type = '1')
{
	$arr = array_merge($arr1 , $arr2);

	$fieldArr['t_option'] = @array('field'=>$value['t_field'],'value'=>$value['t_value']);
	$fieldArr['v_option'] = @array('field'=>$value['c_field'],'value'=>$value['c_value']);

	//循环替换分类和内容的自定义字段
	foreach ($fieldArr as $k=>$v)
	{
		if( $v['field'] != '' && $v['value'] != '' )
		{
			$fieldOption = unserialize($v['field']);
			$valueOption = unserialize($v['value']);

			if( $fieldOption )
			{
				foreach ($fieldOption as $k=>$v)
				{
					if( array_key_exists($k, $valueOption) )
					{
						if( is_array($valueOption[$k]) )
						{
							$arr3['field:'.$v['title']] = implode(',', $valueOption[$k]);
						}
						else
						{
							$arr3['field:'.$v['title']] = $valueOption[$k];
						}
					}
				}
			}
		}
	}
	if( !empty($arr3) )
	{
		$arr = array_merge($arr,$arr3);
	}

	$arr = ArrMerge($value , $arr);
	return $arr;
}

/**
 * 标签数组合并
 * @param 参数1，数字
 * @param string $arr2
 * @return multitype:
 */
function ArrMerge($data , $arr1 ='', $arr2='')
{
	if( is_array($arr2) )
	{
		$arr = array_merge($arr1,$arr2);
	}
	else if( is_array($arr1) )
	{
		$arr = $arr1;
	}

	//检查是否有回调标签函数
	$callbackLabel = C('page.callback_label');
	if( is_array($callbackLabel) )
	{
		$callbackModule = $callbackLabel[0];
		$callbackFunction = $callbackLabel[1];
		if( is_array($arr1) )
		{
			$arr = array_merge($arr,$callbackModule::$callbackFunction($data));
		}
		else
		{
			$arr = $callbackModule::$callbackFunction($data);
		}
	}
	return $arr;
}


/**
 * 对二维数组进行排序
 * @param 参数1，必须，需要排序的数组
 * @param 参数2，必须，对哪个字段进行排序
 * @param 参数3，选填，是顺序还是倒序
 */
function ArrSort($arr , $key , $type='asc')
{
	foreach($arr as $k=>$v)
	{
		$newData[$v[$key]] = $v;
	}
	if($type == 'asc' )
	{	
		ksort($newData);
	}
	else
	{
		krsort($newData);
	}
	foreach($newData as $k=>$v)
	{
		$dataList[] = $v;
	}
	return $dataList;
}


/**
 * 合并where条件,如有条件有where则进行合并
 * @param 参数1，必须，现有的条件
 * @param 参数2，必须，追加的条件
 */
function MergeWhere($where , $wheresql)
{
	if( !array_key_exists('where',$wheresql) )
	{
		$where['where'] = $wheresql;
	}
	else
	{
		$where = array_merge($where,$wheresql);
	}
	
	return $where;
}



/**
 * 字符串加密解密函数
 * @param 参数1：字符串类型，需要加密的字符串。
 * @param 参数2：字符串类型，加密解密方式，D为解密，E为加密。
 * @param 参数3：字符串类型，加解密混淆的字符串。
 **/
function Encrypt($string,$operation='E',$key='')
{
	//默认为系统密匙混淆
	if( $key == '' )
	{
		$key = C('config.api.system.api_apikey');
	}
	$key = md5($key);
	$key_length = strlen($key);
	$string = $operation == 'D' ? base64_decode($string) : substr(md5($string . $key) , 0, 8) . $string;
	$string_length = strlen($string);
	$rndkey = $box = array();
	$result = '';
	for ($i = 0; $i <= 255; $i++) {
		$rndkey[$i] = ord($key[$i % $key_length]);
		$box[$i] = $i;
	}
	for ($j = $i = 0; $i < 256; $i++) {
		$j = ($j + $box[$i] + $rndkey[$i]) % 256;
		$tmp = $box[$i];
		$box[$i] = $box[$j];
		$box[$j] = $tmp;
	}
	for ($a = $j = $i = 0; $i < $string_length; $i++) {
		$a = ($a + 1) % 256;
		$j = ($j + $box[$a]) % 256;
		$tmp = $box[$a];
		$box[$a] = $box[$j];
		$box[$j] = $tmp;
		$result.= chr(ord($string[$i]) ^ ($box[($box[$a] + $box[$j]) % 256]));
	}
	if ($operation == 'D') {
		if (substr($result, 0, 8) == substr(md5(substr($result, 8) . $key) , 0, 8)) {
			return substr($result, 8);
		} else {
			return '';
		}
	} else {
		return str_replace('=', '', base64_encode($result));
	}
}

/**
 * MD5 16 位加密
 * @param 参数1，必须，需要加密的字符串
 */
function md5_16($str)
{
	return substr(md5($str), 8, 16);
}


/**
 * 前置方法验证，在模块class文件调用存入验证方法，在common引用模版文件后会验证前置方法
 * @param 参数1：必须，需要验证的参数
 * array('类名','方法名字，可以是多个方法');
 **/
function beforVer(array $arr)
{
	$beforVer = C('beforVer');
	foreach ($arr as $k=>$v)
	{
		$beforVer[$k] = $v;
	}
	C('beforVer',$beforVer);
}


/**
 * 获得表单的token
 */
function FormTokenCreate($isReturn = false)
{
	$newToken = array();
	$sessionToken = Session('form_token');
	$apikey = C('config.api.system.api_apikey');
	$token = md5($apikey.'|wmcms|' .time());
	$url = md5($apikey.$_SERVER['HTTP_HOST'].$_SERVER['REQUEST_URI']);
	if( is_array($sessionToken) )
	{
		$sessionToken[$url] = $token;
		$newToken = $sessionToken;
	}
	else
	{
		$newToken[$url] = $token;
	}
	Session('form_token' , $newToken);
	if( $isReturn == false )
	{
		$html = '<input type="hidden" name="form_token" value="'.$token.'">';
	}
	else
	{
		$html = $token;
	}
	return $html;
}
/**
 * 检查表单的token
 * @param 参数1：选填，是否只返回结果,默认为false不返回。
 */
function FormTokenCheck($isReturn = false)
{
	$isPast = true;
	$formToken = Request('form_token');
	$sessionToken = Session('form_token');
	//token为空或者session为空
	if( $formToken == '' || !is_array($sessionToken) || !$sessionToken )
	{
		$lang = 'token_err';
		$isPast = false;
	}
	else if(is_array($sessionToken))
	{
		foreach($sessionToken as $k=>$v)
		{
			$lang = 'token_err';
			$isPast = false;
			if( $v == $formToken )
			{
				unset($sessionToken[$k]);
				$isPast = true;
				break;
			}
		}
	}
	//没有通过验证
	if( $isPast == false )
	{
		//不返回结果
		if( $isReturn == false )
		{
			ReturnData(C('system.par.'.$lang,null,'lang'), null , 500);
		}
		else
		{
			return false;
		}
	}
	else
	{
		return true;
	}
}

/**
 * 创建表单验证码
 * @param 参数1：必填，需要生成验证码的表单。
 */
function FormCodeCreate($id)
{
	if( C('config.web.'.$id) == '1' )
	{
		switch(C('config.web.'.$id.'_type'))
		{
			case '1':
				$html = '<img src="/wmcms/inc/imgcode.php?id='.$id.'" id="refresh" onClick="document.getElementById(\'refresh\').src=\'/wmcms/inc/imgcode.php?id='.$id.'&t=\'+Math.random()" class="imgcode" style="cursor: pointer;vertical-align: middle;display:-webkit-inline-box" />';
				break;
				
			case '2':
				$sp = array('+','-','*');
				$num1 = rand(1, 9);
				$num2 = rand(1, 9);
				$spStr = $sp[rand(0,2)];
				$html =  '<span class="txtcode">'.$num1.$spStr.$num2.' = ?</span>';
				eval('$number = '.$num1.$spStr.$num2.';');
				Session($id,$number);
				break;
				
			case '3':
				$questionArr = explode("\n", C('config.web.code_question'));
				$questions = $questionArr[rand(0,count($questionArr)-1)];
				$question = explode('|', $questions);
				$html = '<span class="txtcode">'.$question[0].'</span>';
				Session($id,$question[1]);
				break;
		}
		return $html;
	}
	return true;
}
/**
 * 检查表单的验证码
 * @param 参数1：选填，表单的验证码id。
 * @param 参数2：选填，是否只返回结果,默认为false不返回。
 */
function FormCodeCheck($id = '', $isReturn = false)
{
	if( C('config.web.'.$id) == '1' )
	{
		$isPast = true;
		$code = Request('code');
		//如果存在自定义code名字
		if( $id != '' )
		{
			$sessionCode = Session($id);
		}
		else
		{
			$sessionCode = Session('form_code');
		}
		//验证码不通过
		if( strtolower($sessionCode) != strtolower($code) || $code == '')
		{
			//不返回结果
			if( $isReturn == false )
			{
				if( $code == '' )
				{
					$lang = 'code_no';
				}
				else
				{
					$lang = 'code_err';
				}
				ReturnData(C('system.par.'.$lang,null,'lang'), null , 500);
			}
			else
			{
				return false;
			}
		}
		else
		{
			Session('form_code' , 'delete');
			Session('form_code_name' , 'delete');
		}
	}
	return true;
}
?>