<?php
/**
* SEO模块模型
*
* @version        $Id: seo.model.php 2017年6月6日 20:31  weimeng
* @package        WMCMS
* @copyright      Copyright (c) 2015 WeiMengCMS, Inc.
* @link           http://www.weimengcms.com
*/
class SeoModel
{
	public $errpageTable = '@seo_errpage';
	public $spiderTable = '@seo_spider';
	
	function __construct( $data = '' ){}


	/**
	 * 写入错误页面数据
	 * @param 参数1，必须，错误页面代码
	 */
	function AddErrPage( $code )
	{
		$data['errpage_code'] = $code;
		$data['errpage_url'] = GetUrl();
		$data['errpage_ua'] = $_SERVER['HTTP_USER_AGENT'];
		$data['errpage_time'] = time();
		return wmsql::Insert($this->errpageTable, $data);
	}
	

	/**
	 * 写入蜘蛛爬行记录
	 * @param 参数1，必须，蜘蛛数据
	 */
	function AddSpider( $spiderData )
	{
		$data['spider_group'] = $spiderData['group'];
		$data['spider_group_name'] = $spiderData['group_name'];
		$data['spider_title'] = $spiderData['spider'];
		$data['spider_name'] = $spiderData['spider_name'];
		$data['spider_url'] = GetUrl();
		$data['spider_ua'] = $_SERVER['HTTP_USER_AGENT'];
		$data['spider_time'] = time();
		return wmsql::Insert($this->spiderTable, $data);
	}
}
?>