<?php
/**
* 用户消息模型
*
* @version        $Id: msg.model.php 2016年5月28日 21:48  weimeng
* @package        WMCMS
* @copyright      Copyright (c) 2015 WeiMengCMS, Inc.
* @link           http://www.weimengcms.com
*/
class MsgModel
{
	public $table = '@user_msg';
	//用户id
	public $userId;
	//消息id
	public $msgId;
	
	
	
	/**
	 * 构造函数
	 */
	function __construct(){}
	
	
	
	/**
	 * 获得查询的条件
	 */
	function GetWhere()
	{
		$where['msg_id'] = $this->msgId;
		$where['msg_tuid'] = $this->userId;
		return $where;
	}
	
	
	/**
	 * 查询一条数据
	 * @param 参数1，必须，条件
	 */
	function GetOne( $id = '' )
	{
		if( $id != '' )
		{
			$this->msgId = $id;
		}
		$where['table'] = $this->table;
		$where['where'] = $this->GetWhere();
		$data = wmsql::GetOne($where);
		return $data;
	}
	
	
	/**
	 * 删除一条数据
	 */
	function DelOne()
	{
		return wmsql::Delete($this->table , $this->GetWhere());
	}
	
	
	/**
	 * 插入消息记录
	 * @param 参数1，必须，收信用户id
	 * @param 参数2，必须，发送的消息
	 * @param 参数2，必须，发信用户id
	 */
	function Insert($uid , $content , $fuid=0)
	{
		$data['msg_fuid'] = $fuid;
		$data['msg_tuid'] = $uid;
		$data['msg_content'] = $content;
		$data['msg_time'] = time();
		return wmsql::Insert($this->table, $data);
	}
}
?>