﻿/// <reference path="../plugs/jquery-1.7.2.js" />
if (!window.Jade) {
    window.Jade = {};
}

Jade.Comm = {
    getPage: function (cn, para, fn) {
        para.start = para.start || 0;
        para.limit = para.limit || Jade.pageSize;
        para.sort = para.sort || "AppTime";
        para.dir = para.dir || "desc";

        Jade.ajax(cn.replace("+", "Server"), para.methodname || "GetPage", para, function (d) {
            if (fn) fn(d);
        });
    },
    render: function (tn, gn, list, fn, appcode) {
        var arr = [];
        var template = YayaTemplate(document.getElementById(tn).innerHTML);
        $(list).each(function (i, o) {
            if (fn) fn(o, i);
            arr.push(template.render(o));
        });
        return arr.join('');
        //document.getElementById(gn).innerHTML = arr.join('') + (appcode || "");
    },
    //设为首页 
    SetHome: function (obj, url) {
        try {
            obj.style.behavior = 'url(#default#homepage)';
            obj.setHomePage(url);
        } catch (e) {
            if (window.netscape) {
                try {
                    netscape.security.PrivilegeManager.enablePrivilege("UniversalXPConnect");
                } catch (e) {
                    alert("抱歉，此操作被浏览器拒绝！\n\n请在浏览器地址栏输入“about:config”并回车然后将[signed.applets.codebase_principal_support]设置为'true'");
                }
            } else {
                alert("抱歉，您所使用的浏览器无法完成此操作。\n\n您需要手动将【" + url + "】设置为首页。");
            }
        }
    },
    //收藏本站
    AddFavorite: function (title, url) {
        try {
            window.external.addFavorite(url, title);
        }
        catch (e) {
            try {
                window.sidebar.addPanel(title, url, "");
            }
            catch (e) {
                alert("抱歉，您所使用的浏览器无法完成此操作。\n\n加入收藏失败，请使用Ctrl+D进行添加");
            }
        }
    }
}

// 得到作者等级
function GetAuthorLevel(mywork) {
    if (mywork > 0) {
        if (mywork > 0 && mywork <= 50) {
            return "布衣";
        }
        else if (mywork > 50 && mywork <= 100) {
            return "童生";
        }
        else if (mywork > 100 && mywork <= 200) {
            return "秀才";
        }
        else if (mywork > 200 && mywork <= 300) {
            return "举人";
        }
        else {
            return "进士";
        }
    }
    else {
        return "布衣";
    }
}

$(function () {
    //导航高亮 
    var pathname = location.pathname + location.search;
    $(".help-list li a").each(function () {
        if (pathname.indexOf($(this).attr("href")) > -1) {
            $(this).parent().addClass("help-on").siblings("li").removeClass("help-on");
        }
    });

    $("div.nav-list a").each(function () {
        if ($(this).attr("href") == pathname) {
            $(this).addClass("nav-on").siblings("a").removeClass("nav-on");
        } else {
            $(this).removeClass("nav-on");
        }
    });

    $("a.fix-item").click(function () {
        if ($(window).scrollTop() >= 0) {
            $('html,body').animate({ scrollTop: '0px' }, 400);
        }
    });

    Jade.User.register(function (d) {
        var html;
        if (d.USERID > 0) {
            html = "<li><b class='collect b-img'></b><a href='/infocontent/Index.aspx' style='color:#a02424;display: block;overflow: hidden;text-overflow: ellipsis;white-space: nowrap;  width: 70px;'>" + (d.Nick || d.UName || d.Mobile || d.Email) + "</a>" +
            "<a href='/user/LoginOut.aspx'>&nbsp;[退出]</a></li><li><b class='home b-img'></b><a href='javascript:;' onclick='Jade.Comm.SetHome(this,document.location.href)'>设为首页</a></li><li><b class='about  b-img'></b><a href='/InfoDetail.aspx?k=29'>联系我们</a></li>";
        } else {
            html = "<li><b class='collect b-img'></b><a href='/user/Login.aspx'>登录</a></li>" +
            "<li><b class='home  b-img'></b><a href='javascript:;' onclick='Jade.Comm.SetHome(this,document.location.href)'>设为首页</a></li>" +
            "<li><b class='about  b-img'></b><a href='/InfoDetail.aspx?k=29'>联系我们</a></li>";
        }
        $("ul.top-right").html(html);
    });
    if (location.pathname != '/article/search.php') {
        $("div.soso-left a").click(function () {
            var py = $(this).data("py");
            if (py) {
                location.href = "/article/search.php?py=" + py;
            }
        });
        $("input.soso-button").click(function () {
            var val = $(".soso-text").val();
            if (val) {
                location.href = location.href.indexOf("?py") > -1 ? location.href + "&kw=" + encodeURI(encodeURI(val)) : "/article/search.php?kw=" + encodeURI(encodeURI(val));
            }
        });
    }
})