﻿/*
* 存放后台对应的所有枚举
*/

Jade.Renderer = {
    //所有审核状态都用这个枚举
    verifyStatus: function (v) {
        return {
            "0": "<font>初始</font>",
            "1": "<i class='p-red'>待审核</i>",
            "2": "<i class='p-ye'>审核通过</i>",
            "3": "<i class='p-n'>未通过</i>"
        }[v] || "";
    },
    infoType: function (v) {
        return {
            "0": "初始",
            "1": "现代诗",
            "2": "旧体诗",
            "3": "散文诗",
            "4": "新歌词",
            "5": "楹联",
            "6": "微诗",
            "7": "异域诗笺",
            "8": "诗论",
            "9": "学生作品",
            "10": "诗赛征文",
            "11": "学生风采",
            "12": "市场服务"
        }[v] || "";
    },
    isRead: function (v) {
        return {
            'false': '<i class="p-ye">未读</i>',
            'true': '<i class="p-n">已读</i>'
        }[v] || "";
    },
    sex: function (v) {
        return {
            "1": "男",
            "2": "女",
            "3": "保密"
        }[v] || "";
    },
    infoStatus: function (v) {
        return {
            "1": "草稿",
            "2": "发布",
            "3": "垃圾箱"
        }[v] || "";
    },
    keyValueType: function (v) {
        return Jade.Enum.keyValueType[v];
    },
    //对于是否的renderer。xjlong
    yesNo: function (v) {
        return {
            'true': "<font color='green'>是</font>",
            'false': "<font color='gray'>否</font>"
        }[v] || "";
    },
    //时间格式化, 如 2014-05-12  。xjlong
    shortDate: function (v) {
        try {
            return Easy.Date.format(v, "yyyy-MM-dd");
        } catch (e) {
            return "";
        }
    },
    //时间格式化, 如2014-04-18 15:33   。xjlong
    fullDate: function (v) {
        try {
            return Easy.Date.format(v, "yyyy-MM-dd HH:mm");
        } catch (e) {
            return "";
        }
    }
};

Easy.apply(Easy.UI.Grid, {
    defaultRenderer: function (v, r, cfg, colIndex, rowIndex) {
        return v === null || v === undefined ? "" : ("<a title='" + v + "'>" + v + "</a>");
    }
});
