<?php if(!defined('access') or !access) die('This file cannot be directly accessed.'); ?><!DOCTYPE HTML>
<html <?php echo CHV\Render\get_html_tags(); ?>>
<head>
<meta charset="utf-8">
<meta name="apple-mobile-web-app-status-bar-style" content="black">
<meta name="apple-mobile-web-app-capable" content="yes">
<meta name="viewport" content="width=device-width, initial-scale=1, user-scalable=no, maximum-scale=1">
<?php if(get_meta_description()) { ?>
<meta name="description" content="<?php echo get_meta_description(); ?>">
<?php } ?>
<?php if(get_meta_keywords()) { ?>
<meta name="keywords" content="<?php echo get_meta_keywords(); ?>">
<?php } ?>

<title><?php echo get_doctitle(); ?> ---- www.yikaowo.com</title>

<?php CHV\Render\include_peafowl_head(); ?>

<link rel="stylesheet" href="<?php echo CHV\Render\get_theme_file_url('style.css'); ?>">
<link rel="shortcut icon" href="<?php echo CHV\get_system_image_url(CHV\getSetting('favicon_image')); ?>">
<link rel="apple-touch-icon" href="<?php echo CHV\get_system_image_url(CHV\getSetting('favicon_image')); ?>" sizes="114x114">

<?php

if(CHV\getSetting('theme_logo_height') > 0) {
	$logo_height = CHV\getSetting('theme_logo_height');
	echo '<style type="text/css">.top-bar-logo, .top-bar-logo img { height: '.CHV\getSetting('theme_logo_height').'px; } .top-bar-logo { margin-top: -'.(CHV\getSetting('theme_logo_height')/2).'px; } </style>';
}

$open_graph = [
	'type'			=> 'website',
	'url'			=> G\get_current_url(),
	'title'			=> CHV\getSetting('website_doctitle'),
	'image'			=> CHV\get_system_image_url(CHV\getSetting('homepage_cover_image')),
	'site_name' 	=> CHV\getSetting('website_name'),
	'description'	=> CHV\getSetting('website_description')
];

switch(true) {
	case function_exists('get_image') and G\is_route('image'):
		$open_graph_extend = [
			'title'			=> get_pre_doctitle(),
			'description'	=> get_image()['description'],
			'image'			=> get_image()['display_url'],
			'image:width'	=> get_image()['width'],
			'image:height'	=> get_image()['height']
		];
	break;
	case function_exists('get_user') and G\is_route('user'):
		$open_graph_extend = [
			'type'			=> 'profile',
			'title'			=> get_user()['name'],
			'description'	=> sprintf(is_user_images() ? _s("%s's Images") : _s("%s's Albums"), get_user()["name_short"]),
			'image'			=> get_user()['avatar']['url'],
		];
	break;
	case function_exists('get_album') and G\is_route('album'):
		$open_graph_extend = [
			'title'			=> get_album()['name'],
			'description'	=> get_album()['description'],
		];
	break;
}
if($open_graph_extend) {
	$open_graph = array_merge($open_graph, $open_graph_extend);
}
foreach($open_graph  as $k => $v) {
	if(!$v) continue;
	echo '<meta property="og:'.$k.'" content="'.G\safe_html($v).'">' . "\n";
}

// Set twitter card
$twitter_card = [
	'card'			=> 'summary',
	'description'	=> function_exists('get_meta_description') ? get_meta_description() : NULL,
	'title'			=> G\str_replace_last(' - ' . CHV\getSetting('website_name'), NULL, get_doctitle()),
	'site' 			=> CHV\getSetting('twitter_account') ? ('@' . CHV\getSetting('twitter_account')) : NULL
];
switch(true) {
	case G\is_route('image'):
		$twitter_card['card'] = 'photo';
	break;
	case function_exists('get_admin') and G\is_route('album'):
	case function_exists('get_user') and G\is_route('user'):
		$twitter_card['card'] = 'gallery';
		if(G\is_route('album')) {
			$twitter_card['creator'] = get_album()['user']['twitter']['username'];
		} else {
			$twitter_card['creator'] = get_user()['twitter']['username'];
		}
		$list_output = function_exists('get_list') ? get_list()->output_assoc : NULL;
		if(count($list_output) > 0) {
			for($i=0; $i<4; $i++) {
				$twitter_card['image' . $i] = $list_output[$i]['display_url'];
			}
		}
	break;
}
foreach($twitter_card as $k => $v) {
	if(!$v) continue;
	echo '<meta name="twitter:'.$k.'" content="'.$v.'">' . "\n";
}
?>
<?php if(function_exists('get_image') and G\is_route('image')) { ?>
<link rel="image_src" href="<?php echo get_image()['url']; ?>">
<?php } ?>
<?php if(CHV\getSetting('theme_custom_css_code')) { ?>
<style><?php echo CHV\Render\get_cond_minified_code(CHV\getSetting('theme_custom_css_code'), 'css'); ?></style>
<?php } ?>
<?php if(CHV\getSetting('theme_custom_js_code')) { ?>
<script><?php echo CHV\Render\get_cond_minified_code(CHV\getSetting('theme_custom_js_code'), 'js'); ?></script>
<?php } ?>

<?php CHV\Render\show_theme_inline_code('snippets/theme_colors.css'); ?>

<?php if(CHV\Render\theme_file_exists('custom_hooks/style.css')) { ?>
<link rel="stylesheet" href="<?php echo CHV\Render\get_theme_file_url('custom_hooks/style.css'); ?>">
<?php } ?>

<?php G\Render\include_theme_file('custom_hooks/head'); ?>

</head>

<?php
	G\Render\include_theme_file('custom_hooks/header');
	if(!G\is_prevented_route() and in_array(G\get_template_used(), ['user', 'image']) and !is_404()) {	
		$body_class = (G\is_route('image') or (G\is_route('user') and get_user()["background"]) or is_owner() or is_admin()) ? " no-margin-top" : "";
	}
	if(G\get_route_name() == 'index') {
		$body_class = CHV\getSetting('homepage_style');
	}
	$top_bar_class = CHV\getSetting('theme_top_bar_color');
?>
<?php
	if(G\get_route_name() == 'index') {
		$top_bar_class = in_array(CHV\getSetting('homepage_style'), ['landing', 'split']) ? 'black' : CHV\getSetting('theme_top_bar_color');
?>
<style>
#home-cover {
	background-image: url(<?php echo G\starts_with('http', CHV\getSetting('homepage_cover_image')) ? CHV\getSetting('homepage_cover_image') : CHV\get_system_image_url(CHV\getSetting('homepage_cover_image')); ?>);
}
</style>
<?php
	}
?>

<body id="<?php echo (preg_match('/^\d/', G\get_route_name()) ? 'route-' : NULL) . G\get_route_name(); ?>" class="<?php echo $body_class; ?>">

<?php if(!is_maintenance()) {; ?>
<header id="top-bar" class="top-bar<?php if(in_array($body_class, ['landing', 'split']) and $top_bar_class == 'black') { echo ' transparent'; } ?><?php echo ' ' . $top_bar_class;?>">
	<?php if(is_private_gate()) { ?>
	<div class="c24 center-box content-width">
	<?php } ?>
    <div class="content-width">
		<?php
			$logo_header = CHV\getSetting('logo_vector_enable') ? 'logo_vector' : 'logo_image';
			if(G\get_route_name() == 'index' and in_array(CHV\getSetting('homepage_style'), ['landing', 'split'])) {
				$logo_header .= '_homepage';
			}
			$logo_header = CHV\getSetting($logo_header);
		?>
        <div id="logo" class="top-bar-logo<?php if(is_private_gate()) { ?> text-align-left<?php } ?>"><a href="<?php echo get_header_logo_link(); ?>"><img class="replace-svg" src="<?php echo CHV\get_system_image_url($logo_header); ?>" alt="<?php echo CHV\getSetting('website_name'); ?>"></a></div>
        
		<?php if(CHV\getSetting('website_privacy_mode') == 'public' or (CHV\getSetting('website_privacy_mode') == 'private' and CHV\Login::getUser())) { ?>
        <ul class="top-bar-left float-left">
			
			<li data-action="top-bar-menu-full" data-nav="mobile-menu" class="top-btn-el phone-show hidden">
				<span class="top-btn-text"><span class="icon icon-menu3"></span></span>
			</li>
			
			<?php
				if(CHV\getSetting('website_explore_page')) {
					// Category selector
					$categories = get_categories();
					
					if(count($categories) > 0) {
						array_unshift($categories, [
							'id'		=> NULL,
							'name'		=> _s('All'),
							'url_key'	=> NULL,
							'url'		=> G\get_base_url('explore')
						]);
						$cols = min(5, round(count($categories)/5, 0, PHP_ROUND_HALF_UP));
			?>
			<li id="top-bar-explore" data-nav="explore" class="phone-hide pop-btn pop-btn-auto pop-btn-auto pop-btn-show<?php if(G\get_route_name() == 'explore') { ?> current<?php } ?>">
				<?php
					
				?>
                <span class="top-btn-text"><span class="icon icon-images2"></span><span class="btn-text phone-hide phablet-hide"><?php _se('Explore'); ?></span></span>
                <div class="pop-box <?php if($cols > 1) { echo sprintf('pbcols%d ', $cols); } ?>arrow-box arrow-box-top anchor-left">
                    <div class="pop-box-inner pop-box-menu<?php if($cols > 1) { ?> pop-box-menucols<?php } ?>">
                        <ul>
						<?php
							foreach($categories as $k => $v){
								echo '<li data-content="category" data-category-id="' . $v['id'] . '"><a data-content="category-name" data-link="category-url" href="' . $v['url'] . '">' . $v["name"] . '</a></li>'."\n";
								$count++;
							}
						?>
                        </ul>
                    </div>
                </div>
			</li>
            <?php
            	} else {
            ?>
            <li id="top-bar-explore" data-nav="explore" class="phone-hide top-btn-el<?php if(G\get_route_name() == 'explore') { ?> current<?php } ?>">
            	<a href="<?php echo G\get_base_url('explore'); ?>"><span class="top-btn-text"><span class="icon icon-images2"></span><span class="btn-text phone-hide phablet-hide"><?php _se('Explore'); ?></span></span></a>
            </li>
            <?php
            	}	
            }
			?>
			
			<?php if(CHV\getSetting('website_search')) { ?>
            <li data-action="top-bar-search"  data-nav="search" class="phone-hide pop-btn">
                <span class="top-btn-text"><span class="icon icon-search"></span><span class="btn-text phone-hide phablet-hide"><?php _se('Search'); ?></span></span>
            </li>
            <li data-action="top-bar-search-input" class="top-bar-search-input phone-hide pop-btn pop-keep-click hidden">
                <div class="input-search">
                	<form action="<?php echo G\get_base_url("search/images"); ?>" method="get">
                    	<input class="search" type="text" placeholder="<?php _se('Search'); ?>" autocomplete="off" spellcheck="false" name="q">
                    </form>
                    <span class="icon-search"></span><span class="icon close icon-close" data-action="clear-search" title="<?php _se('Close'); ?>"></span><span class="icon settings icon-triangle-down" data-modal="form" data-target="advanced-search" title="<?php _se('Advanced search'); ?>"></span>
                </div>
            </li>
			<div class="hidden" data-modal="advanced-search">
				<span class="modal-box-title"><?php _se('Advanced search'); ?></span>
				<?php G\Render\include_theme_file('snippets/form_advanced_search'); ?>
			</div>
			<?php } ?>
			
			<?php if(CHV\getSetting('website_random')) { ?>
			<li id="top-bar-random"  data-nav="random" class="top-btn-el">
                <a href="<?php echo G\get_base_url("?random"); ?>"><span class="top-btn-text"><span class="icon icon-shuffle"></span><span class="btn-text phone-hide phablet-hide"><?php _se('Random'); ?></span></span></a>
            </li>
			<?php } ?>
            
        </ul>
		<?php } ?>
        <ul class="top-bar-right float-right keep-visible">
			
			<?php if(get_system_notices()) { ?>
				<li data-nav="notices" class="phone-hide pop-btn pop-keep-click">
                <span class="top-btn-text"><span class="icon icon-notification color-red"></span><span class="btn-text phone-hide phablet-hide"><?php _se('Notices (%s)', count(get_system_notices())); ?></span></span>
				<div class="pop-box anchor-center c8 arrow-box arrow-box-top anchor-center">
					<div class="pop-box-inner padding-20">
						<ul class="list-style-type-disc list-style-position-inside">
						<?php foreach(get_system_notices() as $notice) { ?>
							<li><?php echo $notice; ?></li>
						<?php } ?>
						</ul>
					</div>
				</div>
            </li>
			<?php } ?>
			
			<?php if(is_upload_allowed()) { ?>
            <li data-action="top-bar-upload" data-nav="upload" class="phone-hide pop-btn"<?php if(!CHV\getSetting('guest_uploads')) { ?> data-login-needed="true"<?php } ?>>
                <span class="top-btn-text"><span class="icon icon-cloud-upload"></span><span class="btn-text phone-hide phablet-hide"><?php _se('Upload'); ?></span></span>
            </li>
			<?php } ?>
			
        	<?php
				if(!CHV\Login::isLoggedUser()) {
			?>
            <?php
					if(is_captcha_needed()) {
			?>
			<li id="top-bar-signin" data-nav="signin" class="<?php if(G\is_route("login")) echo "current "; ?>top-btn-el">
				<a href="<?php echo G\get_base_url('login'); ?>" class="top-btn-text"><span class="icon icon-login tablet-hide laptop-hide desktop-hide"></span><span class="text phone-hide phablet-hide"><?php _se('Sign in'); ?></span></a>
			</li>
			<?php
					} else {
			?>
			<li id="top-bar-signin" data-nav="signin" class="<?php if(G\is_route("login")) echo "current "; ?>pop-btn pop-btn-delayed pop-account pop-keep-click">
				<span class="top-btn-text"><span class="icon icon-login tablet-hide laptop-hide desktop-hide"></span><span class="text phone-hide phablet-hide"><?php _se('Sign in'); ?></span></span>
                <div id="top-signin-menu" class="pop-box anchor-center c8 arrow-box arrow-box-top anchor-center">
                    <div class="pop-box-inner">
                    	<?php
                        	if(CHV\getSetting('social_signin')) {
						?>
                        <span class="title"><?php _se('Sign in with another account'); ?></span>
                   		<ul class="sign-services text-align-center">
                            <?php G\Render\include_theme_file('snippets/sign_services_buttons'); ?>
                        </ul>
                        <div class="or-separator"><span><?php _se('or'); ?></span></div>
                        <?php
							}
						?>
                        <form method="post" action="<?php echo G\get_base_url("login"); ?>" autocomplete="off">
							<?php echo G\Render\get_input_auth_token(); ?>
                        	<div class="input"><input type="text" class="text-input" name="login-subject" placeholder="<?php _se('Username or Email address'); ?>" autocomplete="off" required></div>
                            <div class="input"><input type="password" class="text-input" name="password" placeholder="<?php _se('Password'); ?>" autocomplete="off" required><button type="submit" class="icon-input-submit"></button></div>
                            <div class="input margin-bottom-0 overflow-auto">
                            	<div class="checkbox-label"><label for="keep-login"><input type="checkbox" name="keep-login" id="keep-login" value="1"><?php _se('Keep me logged in'); ?></label></div>
                                <div class="float-right"><a href="<?php echo G\get_base_url("account/password-forgot"); ?>"><?php _se('Forgot password?'); ?></a></div>
                            </div>
                        </form>
						<?php
							if(CHV\getSetting('enable_signups')) {
						?>
						<div class="input text-align-center margin-top-10 margin-bottom-0"><?php _se("Don't have an account? <a href='%s'>Sign up</a> now.", G\get_base_url('signup')); ?></div>
						<?php
							}
						?>
                    </div>
                </div>
            </li>
			<?php
					}
			?>
			<?php
					if(CHV\getSetting('enable_signups')) {
						if(is_captcha_needed()) {
			?>
			<li id="top-bar-signup" data-nav="signup" class="<?php if(G\is_route("signup")) echo "current "; ?>phone-hide top-btn-el">
				<a href="<?php echo G\get_base_url('signup'); ?>" class="top-btn-text top-btn-create-account btn <?php echo CHV\getSetting('theme_top_bar_button_color'); ?> text"><span class="icon icon-user phablet-hide tablet-hide laptop-hide desktop-hide"></span><?php _se('Create account'); ?></a>
			</li>
			<?php
						} else {		
			?>
			<li id="top-bar-signup" data-nav="signup" class="<?php if(G\is_route("signup")) echo "current "; ?>phone-hide pop-btn pop-btn-delayed pop-account pop-keep-click">
            	<span class="top-btn-text top-btn-create-account btn <?php echo CHV\getSetting('theme_top_bar_button_color'); ?> text"><span class="icon icon-user phablet-hide tablet-hide laptop-hide desktop-hide"></span><?php _se('Create account'); ?></span>
                <div id="top-signup-menu" class="pop-box anchor-<?php echo get_pages_link_visible() ? 'center' : 'right'; ?> c8 arrow-box arrow-box-top">
                    <div class="pop-box-inner">
                    	<?php
                        	if(CHV\getSetting('social_signin')) {
						?>
                        <span class="title"><?php _se('Sign up with another account'); ?></span>
                   		<ul class="sign-services text-align-center">
                        	<?php G\Render\include_theme_file('snippets/sign_services_buttons'); ?>
                        </ul>
                        <div class="or-separator"><span><?php _se('or'); ?></span></div>
                        <?php
							}
						?>
                        <form method="post" action="<?php echo G\get_base_url("signup"); ?>" autocomplete="off">
							<?php echo G\Render\get_input_auth_token(); ?>
                        	<div class="input"><input type="email" class="text-input" name="email" placeholder="<?php _se('Email address'); ?>" autocomplete="off" required></div>
                        	<div class="input"><input type="text" class="text-input" name="username" placeholder="<?php _se('Username'); ?>" autocomplete="off" required></div>
                            <div class="input"><input type="password" class="text-input" name="password" placeholder="<?php _se('Password'); ?>" autocomplete="off" required><button type="submit" class="icon-input-submit"></button></div>
                            <div class="input text-align-center margin-bottom-0"><?php _se('By signing up you agree to our <a href="%s">Terms of service</a>', G\get_base_url('page/tos')); ?></div>
                        </form>
                    </div>
                </div>
            </li>
			<?php
						} 
					} // signups
			?>
            
			<?php
				} else {
					$notifications_unread = CHV\Login::getUser()['notifications_unread'];
					$notifications_display = CHV\Login::getUser()['notifications_unread_display'];
					$notifications_counter = strtr('<span data-content="notifications-counter" class="top-btn-number%c">'.$notifications_display.'</span>', ['%c' => $notifications_unread > 0 ? ' on' : NULL]);
			?>
			<li data-action="top-bar-notifications" class="top-bar-notifications pop-btn pop-keep-click margin-right-5">
				<div class="top-btn-text">
					<div class="soft-hidden menu-fullscreen-show"><span class="icon icon-bell2"></span><?php echo $notifications_counter; ?><span class="btn-text"><?php _se('Notifications'); ?></span></div>
					<div class="menu-fullscreen-hide"><?php echo $notifications_counter; ?></div>
				</div>
                <div class="top-bar-notifications-container c9 pop-box arrow-box arrow-box-top anchor-right">
                    <div class="pop-box-inner">
                    	<div class="top-bar-notifications-header phone-hide phablet-hide">
                    		<h2><?php _se('Notifications'); ?></h2>
                            <!--<a href="#setting"><?php _se('Settings'); ?></a>-->
                        </div>
						<div class="top-bar-notifications-list antiscroll-wrap hidden">
							<ul class="antiscroll-inner r8 overflow-scroll overflow-x-hidden touch-scroll"></ul>
						</div>
						<div class="loading text-align-center margin-top-20 margin-bottom-20 hidden">
							<div class="loading-indicator"></div>
							<div class="loading-text"><?php _se('loading'); ?></div>
						</div>
						<div class="empty text-align-center margin-top-20 margin-bottom-20 hidden">
							<?php _se("You don't have notifications"); ?>
						</div>
                    </div>
                </div>
            </li>
            <li id="top-bar-user" data-nav="user" class="pop-btn pop-btn-delayed margin-left-0">
                <span class="top-btn-text">
					<?php if(CHV\Login::getUser()["avatar"]["url"]) { ?>
					<img src="<?php echo CHV\Login::getUser()["avatar"]["url"]; ?>" alt="" class="user-image">
					<?php } else { ?>
					<img src="" alt="" class="user-image hidden">
					<?php } ?>
					<span class="user-image default-user-image<?php echo (CHV\Login::getUser()["avatar"]["url"] ? ' hidden' : ''); ?>"><span class="icon icon-user"></span></span>
					<span class="text phone-hide"><?php echo CHV\Login::getUser()["name_short_html"]; ?></span><span class="arrow-down"></span>
				</span>
                <div class="pop-box arrow-box arrow-box-top anchor-right">
                    <div class="pop-box-inner pop-box-menu">
                        <ul>
                            <li><a href="<?php echo CHV\Login::getUser()["url"]; ?>"><?php _se('My Profile'); ?></a></li>
							<li><a href="<?php echo CHV\Login::getUser()["url_albums"]; ?>"><?php _se('Albums'); ?></a></li>
							<li><a href="<?php echo CHV\Login::getUser()["url_liked"]; ?>"><?php _se('Liked'); ?></a></li>
                            <li><a href="<?php echo G\get_base_url("settings"); ?>"><?php _se('Settings'); ?></a></li>
							<?php if(is_admin()) { ?>
							<li><a href="<?php echo G\get_base_url("dashboard"); ?>"><?php _se('Dashboard'); ?></a></li>
							<?php } ?>
                            <li><a href="<?php echo G\get_base_url(sprintf("logout?auth_token=%s", get_auth_token())); ?>"><?php _se('Sign out'); ?></a></li>
                        </ul>
                    </div>
                </div>
            </li>
			<?php
				}
			?>
			<?php 
				if(CHV\getSetting('website_privacy_mode') == 'public' or (CHV\getSetting('website_privacy_mode') == 'private' and CHV\Login::getUser())) {
			?>
			<?php
					if(get_pages_link_visible()) {
			?>
            <li data-nav="about" class="phone-hide pop-btn pop-btn-delayed">
                <span class="top-btn-text"><span class="icon icon-info tablet-hide laptop-hide desktop-hide"></span><span class="text phone-hide phablet-hide"><?php _se('About'); ?></span><span class="arrow-down"></span></span>
                <div class="pop-box arrow-box arrow-box-top anchor-right">
                    <div class="pop-box-inner pop-box-menu">
                        <ul>
                            <?php
								foreach(get_pages_link_visible() as $page) {
							?>
							<li<?php if($page['icon']) echo ' class="with-icon"'; ?>><a <?php echo $page['link_attr']; ?>><?php echo $page['title_html']; ?></a></li>
							<?php
								}
							?>
                        </ul>
                    </div>
                </div>
            </li>
            <?php
					}
			?>
			<?php
					if(!CHV\Login::isLoggedUser() and CHV\getSetting('language_chooser_enable')) {
			?>
            <li data-nav="language" class="phablet-hide phone-hide pop-btn">
				<?php
					// Language selector
					$enabled_languages = CHV\get_enabled_languages();
					$cols = min(6, ceil(count($enabled_languages) / 6));
				?>
                <span class="top-btn-text"><span class="text"><?php echo CHV\get_language_used()['short_name']; ?></span><span class="arrow-down"></span></span>
                <div class="pop-box <?php if($cols > 1) { echo sprintf('pbcols%d ', $cols); } ?>arrow-box arrow-box-top anchor-right">
                    <div class="pop-box-inner pop-box-menu<?php if($cols > 1) { ?> pop-box-menucols<?php } ?>">
                        <ul>
						<?php
							foreach($enabled_languages as $k => $v){
								echo '<li' . (CHV\get_language_used()['code'] == $k ? ' class="current"' : '') . '><a href="' . G\get_base_url('?lang=' . $k) . '">' . $v["name"] . '</a></li>'."\n";
								$count++;
							}
						?>
                        </ul>
                    </div>
                </div>
            </li>
			<?php
					}
			?>
			<?php
				}
			?>
			
        </ul>
        
    </div>
	<?php if(is_private_gate()) { ?>
	</div>
	<?php } ?>
</header>
<?php } ?>