<?php
// This file was auto-generated from sdk-root/src/data/acm/2015-12-08/docs-2.json
return [ 'version' => '2.0', 'operations' => [ 'DeleteCertificate' => '<p> Deletes an ACM Certificate and its associated private key. If this action succeeds, the certificate no longer appears in the list of ACM Certificates that can be displayed by calling the <a>ListCertificates</a> action or be retrieved by calling the <a>GetCertificate</a> action. The certificate will not be available for use by other AWS services.</p> <note>You cannot delete an ACM Certificate that is being used by another AWS service. To delete a certificate that is in use, the certificate association must first be removed. </note>', 'DescribeCertificate' => '<p> Returns a list of the fields contained in the specified ACM Certificate. For example, this action returns the certificate status, a flag that indicates whether the certificate is associated with any other AWS service, and the date at which the certificate request was created. The ACM Certificate is specified on input by its Amazon Resource Name (ARN]. </p>', 'GetCertificate' => '<p> Retrieves an ACM Certificate and certificate chain for the certificate specified by an ARN. The chain is an ordered list of certificates that contains the root certificate, intermediate certificates of subordinate CAs, and the ACM Certificate. The certificate and certificate chain are base64 encoded. If you want to decode the certificate chain to see the individual certificate fields, you can use OpenSSL. </p> <note> Currently, ACM Certificates can be used only with Elastic Load Balancing and Amazon CloudFront. </note>', 'ListCertificates' => '<p> Retrieves a list of the ACM Certificate ARNs, and the domain name for each ARN, owned by the calling account. You can filter the list based on the <code>CertificateStatuses</code> parameter, and you can display up to <code>MaxItems</code> certificates at one time. If you have more than <code>MaxItems</code> certificates, use the <code>NextToken</code> marker from the response object in your next call to the <code>ListCertificates</code> action to retrieve the next set of certificate ARNs. </p>', 'RequestCertificate' => '<p> Requests an ACM Certificate for use with other AWS services. To request an ACM Certificate, you must specify the fully qualified domain name (FQDN] for your site. You can also specify additional FQDNs if users can reach your site by using other names. For each domain name you specify, email is sent to the domain owner to request approval to issue the certificate. After receiving approval from the domain owner, the ACM Certificate is issued. For more information, see the <a href="http://docs.aws.amazon.com/acm/latest/userguide/overview.html"> AWS Certificate Manager User Guide </a>. </p>', 'ResendValidationEmail' => '<p> Resends the email that requests domain ownership validation. The domain owner or an authorized representative must approve the ACM Certificate before it can be issued. The certificate can be approved by clicking a link in the mail to navigate to the Amazon certificate approval website and then clicking <b>I Approve</b>. However, the validation email can be blocked by spam filters. Therefore, if you do not receive the original mail, you can request that the mail be resent within 72 hours of requesting the ACM Certificate. If more than 72 hours have elapsed since your original request or since your last attempt to resend validation mail, you must request a new certificate. </p>', ], 'service' => '<fullname>AWS Certificate Manager</fullname> <p>Welcome to the AWS Certificate Manager (ACM] CLI Command Reference. This guide provides descriptions, syntax, and usage examples for each ACM CLI command. You can use AWS Certificate Manager to request ACM Certificates for your AWS-based websites and applications. For general information about using ACM and for more information about using the console, see the <a href="url-acm-ug;acm-overview.html">AWS Certificate Manager User Guide</a>. For more information about using the ACM API, see the <a href="http://docs.aws.amazon.com/acm/latest/APIReference/Welcome.html"> AWS Certificate Manager API Reference</a>. </p>', 'shapes' => [ 'Arn' => [ 'base' => NULL, 'refs' => [ 'CertificateDetail$CertificateArn' => '<p> Amazon Resource Name (ARN] of the certificate. This is of the form: </p> <p> <code>arn:aws:acm:region:123456789012:certificate/12345678-1234-1234-1234-123456789012</code> </p> <p> For more information about ARNs, see <a href="http://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs] and AWS Service Namespaces</a>. </p>', 'CertificateSummary$CertificateArn' => '<p> Amazon Resource Name (ARN] of the certificate. This is of the form: </p> <p> <code>arn:aws:acm:region:123456789012:certificate/12345678-1234-1234-1234-123456789012</code> </p> <p> For more information about ARNs, see <a href="http://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs] and AWS Service Namespaces</a>. </p>', 'DeleteCertificateRequest$CertificateArn' => '<p> String that contains the ARN of the ACM Certificate to be deleted. This must be of the form: </p> <p> <code>arn:aws:acm:region:123456789012:certificate/12345678-1234-1234-1234-123456789012</code> </p> <p> For more information about ARNs, see <a href="http://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs] and AWS Service Namespaces</a>. </p>', 'DescribeCertificateRequest$CertificateArn' => '<p> String that contains an ACM Certificate ARN. The ARN must be of the form: </p> <p> <code>arn:aws:acm:region:123456789012:certificate/12345678-1234-1234-1234-123456789012</code> </p> <p> For more information about ARNs, see <a href="http://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs] and AWS Service Namespaces</a>. </p>', 'GetCertificateRequest$CertificateArn' => '<p> String that contains a certificate ARN in the following format: </p> <p> <code>arn:aws:acm:region:123456789012:certificate/12345678-1234-1234-1234-123456789012</code> </p> <p> For more information about ARNs, see <a href="http://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs] and AWS Service Namespaces</a>. </p>', 'RequestCertificateResponse$CertificateArn' => '<p> String that contains the ARN of the issued certificate. This must be of the form: </p> <p> <code>arn:aws:acm:us-east-1:123456789012:certificate/12345678-1234-1234-1234-123456789012</code> </p>', 'ResendValidationEmailRequest$CertificateArn' => '<p> String that contains the ARN of the requested certificate. The certificate ARN is generated and returned by <a>RequestCertificate</a> as soon as the request is made. By default, using this parameter causes email to be sent to all top-level domains you specified in the certificate request. </p> <p> The ARN must be of the form: </p> <p> <code>arn:aws:acm:us-east-1:123456789012:certificate/12345678-1234-1234-1234-123456789012</code> </p>', ], ], 'CertificateBody' => [ 'base' => NULL, 'refs' => [ 'GetCertificateResponse$Certificate' => '<p> String that contains the ACM Certificate represented by the ARN specified at input. </p>', ], ], 'CertificateChain' => [ 'base' => NULL, 'refs' => [ 'GetCertificateResponse$CertificateChain' => '<p> The certificate chain that contains the root certificate issued by the certificate authority (CA]. </p>', ], ], 'CertificateDetail' => [ 'base' => '<p> This structure is returned in the response object of the <a>DescribeCertificate</a> action. </p>', 'refs' => [ 'DescribeCertificateResponse$Certificate' => '<p>Contains a <a>CertificateDetail</a> structure that lists the fields of an ACM Certificate.</p>', ], ], 'CertificateStatus' => [ 'base' => NULL, 'refs' => [ 'CertificateDetail$Status' => '<p> A <code>CertificateStatus</code> enumeration value that can contain one of the following: <ul> <li>PENDING_VALIDATION</li> <li>ISSUED</li> <li>INACTIVE</li> <li>EXPIRED</li> <li>REVOKED</li> <li>FAILED</li> <li>VALIDATION_TIMED_OUT</li> </ul> </p>', 'CertificateStatuses$member' => NULL, ], ], 'CertificateStatuses' => [ 'base' => NULL, 'refs' => [ 'ListCertificatesRequest$CertificateStatuses' => '<p> Identifies the statuses of the ACM Certificates for which you want to retrieve the ARNs. This can be one or more of the following values: <ul> <li><code>PENDING_VALIDATION</code></li> <li><code>ISSUED</code></li> <li><code>INACTIVE</code></li> <li><code>EXPIRED</code></li> <li><code>VALIDATION_TIMED_OUT</code></li> <li><code>REVOKED</code></li> <li><code>FAILED</code></li> </ul> </p>', ], ], 'CertificateSummary' => [ 'base' => '<p> This structure is returned in the response object of <a>ListCertificates</a> action. </p>', 'refs' => [ 'CertificateSummaryList$member' => NULL, ], ], 'CertificateSummaryList' => [ 'base' => NULL, 'refs' => [ 'ListCertificatesResponse$CertificateSummaryList' => '<p> A list of the certificate ARNs. </p>', ], ], 'DeleteCertificateRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeCertificateRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeCertificateResponse' => [ 'base' => NULL, 'refs' => [], ], 'DomainList' => [ 'base' => NULL, 'refs' => [ 'CertificateDetail$SubjectAlternativeNames' => '<p> One or more domain names (subject alternative names] included in the certificate request. After the certificate is issued, this list includes the domain names bound to the public key contained in the certificate. The subject alternative names include the canonical domain name (CN] of the certificate and additional domain names that can be used to connect to the website. </p>', 'RequestCertificateRequest$SubjectAlternativeNames' => '<p> Additional FQDNs to be included in the Subject Alternative Name extension of the ACM Certificate. For example, add the name www.example.net to a certificate for which the <code>DomainName</code> field is www.example.com if users can reach your site by using either name. </p>', ], ], 'DomainNameString' => [ 'base' => NULL, 'refs' => [ 'CertificateDetail$DomainName' => '<p> Fully qualified domain name (FQDN], such as www.example.com or example.com, for the certificate. </p>', 'CertificateSummary$DomainName' => '<p> Fully qualified domain name (FQDN], such as www.example.com or example.com, for the certificate. </p>', 'DomainList$member' => NULL, 'DomainValidation$DomainName' => '<p> Fully Qualified Domain Name (FQDN] of the form <code>www.example.com or </code><code>example.com</code> </p>', 'DomainValidation$ValidationDomain' => '<p> The base validation domain that acts as the suffix of the email addresses that are used to send the emails. </p>', 'DomainValidationOption$DomainName' => '<p> Fully Qualified Domain Name (FQDN] of the certificate being requested. </p>', 'DomainValidationOption$ValidationDomain' => '<p> The domain to which validation email is sent. This is the base validation domain that will act as the suffix of the email addresses. This must be the same as the <code>DomainName</code> value or a superdomain of the <code>DomainName</code> value. For example, if you requested a certificate for <code>site.subdomain.example.com</code> and specify a <b>ValidationDomain</b> of <code>subdomain.example.com</code>, ACM sends email to the domain registrant, technical contact, and administrative contact in WHOIS for the base domain and the and the following five addresses: <ul> <li>admin@subdomain.example.com</li> <li>administrator@subdomain.example.com</li> <li>hostmaster@subdomain.example.com</li> <li>postmaster@subdomain.example.com</li> <li>webmaster@subdomain.example.com</li> </ul> </p>', 'RequestCertificateRequest$DomainName' => '<p> Fully qualified domain name (FQDN], such as www.example.com, of the site you want to secure with an ACM Certificate. Use an asterisk (*] to create a wildcard certificate that protects several sites in the same domain. For example, *.example.com protects www.example.com, site.example.com, and images.example.com. </p>', 'ResendValidationEmailRequest$Domain' => '<p> The Fully Qualified Domain Name (FQDN] of the certificate that needs to be validated. </p>', 'ResendValidationEmailRequest$ValidationDomain' => '<p> The base validation domain that will act as the suffix of the email addresses that are used to send the emails. This must be the same as the <code>Domain</code> value or a superdomain of the <code>Domain</code> value. For example, if you requested a certificate for <code>site.subdomain.example.com</code> and specify a <b>ValidationDomain</b> of <code>subdomain.example.com</code>, ACM sends email to the domain registrant, technical contact, and administrative contact in WHOIS and the following five addresses: <ul> <li>admin@subdomain.example.com</li> <li>administrator@subdomain.example.com</li> <li>hostmaster@subdomain.example.com</li> <li>postmaster@subdomain.example.com</li> <li>webmaster@subdomain.example.com</li> </ul> </p>', ], ], 'DomainValidation' => [ 'base' => '<p> Structure that contains the domain name, the base validation domain to which validation email is sent, and the email addresses used to validate the domain identity. </p>', 'refs' => [ 'DomainValidationList$member' => NULL, ], ], 'DomainValidationList' => [ 'base' => NULL, 'refs' => [ 'CertificateDetail$DomainValidationOptions' => '<p> References a <a>DomainValidation</a> structure that contains the domain name in the certificate and the email address that can be used for validation. </p>', ], ], 'DomainValidationOption' => [ 'base' => '<p> This structure is used in the request object of the <a>RequestCertificate</a> action. </p>', 'refs' => [ 'DomainValidationOptionList$member' => NULL, ], ], 'DomainValidationOptionList' => [ 'base' => NULL, 'refs' => [ 'RequestCertificateRequest$DomainValidationOptions' => '<p> The base validation domain that will act as the suffix of the email addresses that are used to send the emails. This must be the same as the <code>Domain</code> value or a superdomain of the <code>Domain</code> value. For example, if you requested a certificate for <code>www.example.com</code> and specify <b>DomainValidationOptions</b> of <code>example.com</code>, ACM sends email to the domain registrant, technical contact, and administrative contact in WHOIS and the following five addresses: <ul> <li>admin@example.com</li> <li>administrator@example.com</li> <li>hostmaster@example.com</li> <li>postmaster@example.com</li> <li>webmaster@example.com</li> </ul> </p>', ], ], 'GetCertificateRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetCertificateResponse' => [ 'base' => NULL, 'refs' => [], ], 'IdempotencyToken' => [ 'base' => NULL, 'refs' => [ 'RequestCertificateRequest$IdempotencyToken' => '<p> Customer chosen string that can be used to distinguish between calls to <code>RequestCertificate</code>. Idempotency tokens time out after one hour. Therefore, if you call <code>RequestCertificate</code> multiple times with the same idempotency token within one hour, ACM recognizes that you are requesting only one certificate and will issue only one. If you change the idempotency token for each call, ACM recognizes that you are requesting multiple certificates. </p>', ], ], 'InUseList' => [ 'base' => NULL, 'refs' => [ 'CertificateDetail$InUseBy' => '<p> List that identifies ARNs that are using the certificate. A single ACM Certificate can be used by multiple AWS resources. </p>', ], ], 'InvalidArnException' => [ 'base' => '<p> The requested Amazon Resource Name (ARN] does not refer to an existing resource. </p>', 'refs' => [], ], 'InvalidDomainValidationOptionsException' => [ 'base' => '<p> One or more values in the <a>DomainValidationOption</a> structure is incorrect. </p>', 'refs' => [], ], 'InvalidStateException' => [ 'base' => '<p> Processing has reached an invalid state. For example, this exception can occur if the specified domain is not using email validation, or the current certificate status does not permit the requested operation. See the exception message returned by ACM to determine which state is not valid. </p>', 'refs' => [], ], 'KeyAlgorithm' => [ 'base' => NULL, 'refs' => [ 'CertificateDetail$KeyAlgorithm' => '<p> Asymmetric algorithm used to generate the public and private key pair. Currently the only supported value is <code>RSA_2048</code>. </p>', ], ], 'LimitExceededException' => [ 'base' => '<p> An ACM limit has been exceeded. For example, you may have input more domains than are allowed or you\'ve requested too many certificates for your account. See the exception message returned by ACM to determine which limit you have violated. For more information about ACM limits, see the <a href="http://docs.amazon.com/acm/latest/userguide/limits.html">Limits</a> topic. </p>', 'refs' => [], ], 'ListCertificatesRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListCertificatesResponse' => [ 'base' => NULL, 'refs' => [], ], 'MaxItems' => [ 'base' => NULL, 'refs' => [ 'ListCertificatesRequest$MaxItems' => '<p> Specify this parameter when paginating results to indicate the maximum number of ACM Certificates that you want to display for each response. If there are additional certificates beyond the maximum you specify, use the <code>NextToken</code> value in your next call to the <code>ListCertificates</code> action. </p>', ], ], 'NextToken' => [ 'base' => NULL, 'refs' => [ 'ListCertificatesRequest$NextToken' => '<p> String that contains an opaque marker of the next ACM Certificate ARN to be displayed. Use this parameter when paginating results, and only in a subsequent request after you\'ve received a response where the results have been truncated. Set it to an empty string the first time you call this action, and set it to the value of the <code>NextToken</code> element you receive in the response object for subsequent calls. </p>', 'ListCertificatesResponse$NextToken' => '<p> If the list has been truncated, this value is present and should be used for the <code>NextToken</code> input parameter on your next call to <code>ListCertificates</code>. </p>', ], ], 'RequestCertificateRequest' => [ 'base' => NULL, 'refs' => [], ], 'RequestCertificateResponse' => [ 'base' => NULL, 'refs' => [], ], 'RequestInProgressException' => [ 'base' => '<p> The certificate request is in process and the certificate in your account has not yet been issued. </p>', 'refs' => [], ], 'ResendValidationEmailRequest' => [ 'base' => NULL, 'refs' => [], ], 'ResourceInUseException' => [ 'base' => '<p> The certificate is in use by another AWS service in the caller\'s account. Remove the association and try again. </p>', 'refs' => [], ], 'ResourceNotFoundException' => [ 'base' => '<p> The specified certificate cannot be found in the caller\'s account, or the caller\'s account cannot be found. </p>', 'refs' => [], ], 'RevocationReason' => [ 'base' => NULL, 'refs' => [ 'CertificateDetail$RevocationReason' => '<p> A <code>RevocationReason</code> enumeration value that indicates why the certificate was revoked. This value exists only if the certificate has been revoked. This can be one of the following vales: <ul> <li>UNSPECIFIED</li> <li>KEY_COMPROMISE</li> <li>CA_COMPROMISE</li> <li>AFFILIATION_CHANGED</li> <li>SUPERCEDED</li> <li>CESSATION_OF_OPERATION</li> <li>CERTIFICATE_HOLD</li> <li>REMOVE_FROM_CRL</li> <li>PRIVILEGE_WITHDRAWN</li> <li>A_A_COMPROMISE</li> </ul> </p>', ], ], 'String' => [ 'base' => NULL, 'refs' => [ 'CertificateDetail$Serial' => '<p> String that contains the serial number of the certificate. </p>', 'CertificateDetail$Subject' => '<p> The X.500 distinguished name of the entity associated with the public key contained in the certificate. </p>', 'CertificateDetail$Issuer' => '<p> The X.500 distinguished name of the CA that issued and signed the certificate. </p>', 'CertificateDetail$SignatureAlgorithm' => '<p> Algorithm used to generate a signature. Currently the only supported value is <code>SHA256WITHRSA</code>. </p>', 'InUseList$member' => NULL, 'InvalidArnException$message' => NULL, 'InvalidDomainValidationOptionsException$message' => NULL, 'InvalidStateException$message' => NULL, 'LimitExceededException$message' => NULL, 'RequestInProgressException$message' => NULL, 'ResourceInUseException$message' => NULL, 'ResourceNotFoundException$message' => NULL, 'ValidationEmailList$member' => NULL, ], ], 'TStamp' => [ 'base' => NULL, 'refs' => [ 'CertificateDetail$CreatedAt' => '<p> Time at which the certificate was requested. </p>', 'CertificateDetail$IssuedAt' => '<p> Time at which the certificate was issued. </p>', 'CertificateDetail$RevokedAt' => '<p> The time, if any, at which the certificate was revoked. This value exists only if the certificate has been revoked. </p>', 'CertificateDetail$NotBefore' => '<p> Time before which the certificate is not valid. </p>', 'CertificateDetail$NotAfter' => '<p> Time after which the certificate is not valid. </p>', ], ], 'ValidationEmailList' => [ 'base' => NULL, 'refs' => [ 'DomainValidation$ValidationEmails' => '<p> A list of contact address for the domain registrant. </p>', ], ], ],];
