<?php
// This file was auto-generated from sdk-root/src/data/apigateway/2015-07-09/api-2.json
return [ 'version' => '2.0', 'metadata' => [ 'apiVersion' => '2015-07-09', 'endpointPrefix' => 'apigateway', 'protocol' => 'rest-json', 'serviceFullName' => 'Amazon API Gateway', 'signatureVersion' => 'v4', ], 'operations' => [ 'CreateApiKey' => [ 'name' => 'CreateApiKey', 'http' => [ 'method' => 'POST', 'requestUri' => '/apikeys', 'responseCode' => 201, ], 'input' => [ 'shape' => 'CreateApiKeyRequest', ], 'output' => [ 'shape' => 'ApiKey', ], 'errors' => [ [ 'shape' => 'UnauthorizedException', 'error' => [ 'httpStatusCode' => 401, ], 'exception' => true, ], [ 'shape' => 'NotFoundException', 'error' => [ 'httpStatusCode' => 404, ], 'exception' => true, ], [ 'shape' => 'TooManyRequestsException', 'error' => [ 'httpStatusCode' => 429, ], 'exception' => true, ], [ 'shape' => 'LimitExceededException', 'error' => [ 'httpStatusCode' => 429, ], 'exception' => true, ], [ 'shape' => 'BadRequestException', 'error' => [ 'httpStatusCode' => 400, ], 'exception' => true, ], ], ], 'CreateBasePathMapping' => [ 'name' => 'CreateBasePathMapping', 'http' => [ 'method' => 'POST', 'requestUri' => '/domainnames/{domain_name}/basepathmappings', 'responseCode' => 201, ], 'input' => [ 'shape' => 'CreateBasePathMappingRequest', ], 'output' => [ 'shape' => 'BasePathMapping', ], 'errors' => [ [ 'shape' => 'UnauthorizedException', 'error' => [ 'httpStatusCode' => 401, ], 'exception' => true, ], [ 'shape' => 'ConflictException', 'error' => [ 'httpStatusCode' => 409, ], 'exception' => true, ], [ 'shape' => 'BadRequestException', 'error' => [ 'httpStatusCode' => 400, ], 'exception' => true, ], [ 'shape' => 'NotFoundException', 'error' => [ 'httpStatusCode' => 404, ], 'exception' => true, ], [ 'shape' => 'TooManyRequestsException', 'error' => [ 'httpStatusCode' => 429, ], 'exception' => true, ], ], ], 'CreateDeployment' => [ 'name' => 'CreateDeployment', 'http' => [ 'method' => 'POST', 'requestUri' => '/restapis/{restapi_id}/deployments', 'responseCode' => 201, ], 'input' => [ 'shape' => 'CreateDeploymentRequest', ], 'output' => [ 'shape' => 'Deployment', ], 'errors' => [ [ 'shape' => 'UnauthorizedException', 'error' => [ 'httpStatusCode' => 401, ], 'exception' => true, ], [ 'shape' => 'BadRequestException', 'error' => [ 'httpStatusCode' => 400, ], 'exception' => true, ], [ 'shape' => 'NotFoundException', 'error' => [ 'httpStatusCode' => 404, ], 'exception' => true, ], [ 'shape' => 'ConflictException', 'error' => [ 'httpStatusCode' => 409, ], 'exception' => true, ], [ 'shape' => 'LimitExceededException', 'error' => [ 'httpStatusCode' => 429, ], 'exception' => true, ], [ 'shape' => 'TooManyRequestsException', 'error' => [ 'httpStatusCode' => 429, ], 'exception' => true, ], [ 'shape' => 'ServiceUnavailableException', 'error' => [ 'httpStatusCode' => 503, ], 'exception' => true, 'fault' => true, ], ], ], 'CreateDomainName' => [ 'name' => 'CreateDomainName', 'http' => [ 'method' => 'POST', 'requestUri' => '/domainnames', 'responseCode' => 201, ], 'input' => [ 'shape' => 'CreateDomainNameRequest', ], 'output' => [ 'shape' => 'DomainName', ], 'errors' => [ [ 'shape' => 'UnauthorizedException', 'error' => [ 'httpStatusCode' => 401, ], 'exception' => true, ], [ 'shape' => 'BadRequestException', 'error' => [ 'httpStatusCode' => 400, ], 'exception' => true, ], [ 'shape' => 'TooManyRequestsException', 'error' => [ 'httpStatusCode' => 429, ], 'exception' => true, ], ], ], 'CreateModel' => [ 'name' => 'CreateModel', 'http' => [ 'method' => 'POST', 'requestUri' => '/restapis/{restapi_id}/models', 'responseCode' => 201, ], 'input' => [ 'shape' => 'CreateModelRequest', ], 'output' => [ 'shape' => 'Model', ], 'errors' => [ [ 'shape' => 'BadRequestException', 'error' => [ 'httpStatusCode' => 400, ], 'exception' => true, ], [ 'shape' => 'UnauthorizedException', 'error' => [ 'httpStatusCode' => 401, ], 'exception' => true, ], [ 'shape' => 'NotFoundException', 'error' => [ 'httpStatusCode' => 404, ], 'exception' => true, ], [ 'shape' => 'ConflictException', 'error' => [ 'httpStatusCode' => 409, ], 'exception' => true, ], [ 'shape' => 'LimitExceededException', 'error' => [ 'httpStatusCode' => 429, ], 'exception' => true, ], [ 'shape' => 'TooManyRequestsException', 'error' => [ 'httpStatusCode' => 429, ], 'exception' => true, ], ], ], 'CreateResource' => [ 'name' => 'CreateResource', 'http' => [ 'method' => 'POST', 'requestUri' => '/restapis/{restapi_id}/resources/{parent_id}', 'responseCode' => 201, ], 'input' => [ 'shape' => 'CreateResourceRequest', ], 'output' => [ 'shape' => 'Resource', ], 'errors' => [ [ 'shape' => 'UnauthorizedException', 'error' => [ 'httpStatusCode' => 401, ], 'exception' => true, ], [ 'shape' => 'NotFoundException', 'error' => [ 'httpStatusCode' => 404, ], 'exception' => true, ], [ 'shape' => 'ConflictException', 'error' => [ 'httpStatusCode' => 409, ], 'exception' => true, ], [ 'shape' => 'LimitExceededException', 'error' => [ 'httpStatusCode' => 429, ], 'exception' => true, ], [ 'shape' => 'BadRequestException', 'error' => [ 'httpStatusCode' => 400, ], 'exception' => true, ], [ 'shape' => 'TooManyRequestsException', 'error' => [ 'httpStatusCode' => 429, ], 'exception' => true, ], ], ], 'CreateRestApi' => [ 'name' => 'CreateRestApi', 'http' => [ 'method' => 'POST', 'requestUri' => '/restapis', 'responseCode' => 201, ], 'input' => [ 'shape' => 'CreateRestApiRequest', ], 'output' => [ 'shape' => 'RestApi', ], 'errors' => [ [ 'shape' => 'UnauthorizedException', 'error' => [ 'httpStatusCode' => 401, ], 'exception' => true, ], [ 'shape' => 'LimitExceededException', 'error' => [ 'httpStatusCode' => 429, ], 'exception' => true, ], [ 'shape' => 'BadRequestException', 'error' => [ 'httpStatusCode' => 400, ], 'exception' => true, ], [ 'shape' => 'TooManyRequestsException', 'error' => [ 'httpStatusCode' => 429, ], 'exception' => true, ], ], ], 'CreateStage' => [ 'name' => 'CreateStage', 'http' => [ 'method' => 'POST', 'requestUri' => '/restapis/{restapi_id}/stages', 'responseCode' => 201, ], 'input' => [ 'shape' => 'CreateStageRequest', ], 'output' => [ 'shape' => 'Stage', ], 'errors' => [ [ 'shape' => 'UnauthorizedException', 'error' => [ 'httpStatusCode' => 401, ], 'exception' => true, ], [ 'shape' => 'BadRequestException', 'error' => [ 'httpStatusCode' => 400, ], 'exception' => true, ], [ 'shape' => 'NotFoundException', 'error' => [ 'httpStatusCode' => 404, ], 'exception' => true, ], [ 'shape' => 'ConflictException', 'error' => [ 'httpStatusCode' => 409, ], 'exception' => true, ], [ 'shape' => 'LimitExceededException', 'error' => [ 'httpStatusCode' => 429, ], 'exception' => true, ], [ 'shape' => 'TooManyRequestsException', 'error' => [ 'httpStatusCode' => 429, ], 'exception' => true, ], ], ], 'DeleteApiKey' => [ 'name' => 'DeleteApiKey', 'http' => [ 'method' => 'DELETE', 'requestUri' => '/apikeys/{api_Key}', 'responseCode' => 202, ], 'input' => [ 'shape' => 'DeleteApiKeyRequest', ], 'errors' => [ [ 'shape' => 'UnauthorizedException', 'error' => [ 'httpStatusCode' => 401, ], 'exception' => true, ], [ 'shape' => 'NotFoundException', 'error' => [ 'httpStatusCode' => 404, ], 'exception' => true, ], [ 'shape' => 'TooManyRequestsException', 'error' => [ 'httpStatusCode' => 429, ], 'exception' => true, ], ], ], 'DeleteBasePathMapping' => [ 'name' => 'DeleteBasePathMapping', 'http' => [ 'method' => 'DELETE', 'requestUri' => '/domainnames/{domain_name}/basepathmappings/{base_path}', 'responseCode' => 202, ], 'input' => [ 'shape' => 'DeleteBasePathMappingRequest', ], 'errors' => [ [ 'shape' => 'UnauthorizedException', 'error' => [ 'httpStatusCode' => 401, ], 'exception' => true, ], [ 'shape' => 'NotFoundException', 'error' => [ 'httpStatusCode' => 404, ], 'exception' => true, ], [ 'shape' => 'TooManyRequestsException', 'error' => [ 'httpStatusCode' => 429, ], 'exception' => true, ], ], ], 'DeleteClientCertificate' => [ 'name' => 'DeleteClientCertificate', 'http' => [ 'method' => 'DELETE', 'requestUri' => '/clientcertificates/{clientcertificate_id}', 'responseCode' => 202, ], 'input' => [ 'shape' => 'DeleteClientCertificateRequest', ], 'errors' => [ [ 'shape' => 'UnauthorizedException', 'error' => [ 'httpStatusCode' => 401, ], 'exception' => true, ], [ 'shape' => 'TooManyRequestsException', 'error' => [ 'httpStatusCode' => 429, ], 'exception' => true, ], [ 'shape' => 'BadRequestException', 'error' => [ 'httpStatusCode' => 400, ], 'exception' => true, ], [ 'shape' => 'NotFoundException', 'error' => [ 'httpStatusCode' => 404, ], 'exception' => true, ], ], ], 'DeleteDeployment' => [ 'name' => 'DeleteDeployment', 'http' => [ 'method' => 'DELETE', 'requestUri' => '/restapis/{restapi_id}/deployments/{deployment_id}', 'responseCode' => 202, ], 'input' => [ 'shape' => 'DeleteDeploymentRequest', ], 'errors' => [ [ 'shape' => 'UnauthorizedException', 'error' => [ 'httpStatusCode' => 401, ], 'exception' => true, ], [ 'shape' => 'NotFoundException', 'error' => [ 'httpStatusCode' => 404, ], 'exception' => true, ], [ 'shape' => 'BadRequestException', 'error' => [ 'httpStatusCode' => 400, ], 'exception' => true, ], [ 'shape' => 'TooManyRequestsException', 'error' => [ 'httpStatusCode' => 429, ], 'exception' => true, ], ], ], 'DeleteDomainName' => [ 'name' => 'DeleteDomainName', 'http' => [ 'method' => 'DELETE', 'requestUri' => '/domainnames/{domain_name}', 'responseCode' => 202, ], 'input' => [ 'shape' => 'DeleteDomainNameRequest', ], 'errors' => [ [ 'shape' => 'UnauthorizedException', 'error' => [ 'httpStatusCode' => 401, ], 'exception' => true, ], [ 'shape' => 'NotFoundException', 'error' => [ 'httpStatusCode' => 404, ], 'exception' => true, ], [ 'shape' => 'TooManyRequestsException', 'error' => [ 'httpStatusCode' => 429, ], 'exception' => true, ], ], ], 'DeleteIntegration' => [ 'name' => 'DeleteIntegration', 'http' => [ 'method' => 'DELETE', 'requestUri' => '/restapis/{restapi_id}/resources/{resource_id}/methods/{http_method}/integration', 'responseCode' => 204, ], 'input' => [ 'shape' => 'DeleteIntegrationRequest', ], 'errors' => [ [ 'shape' => 'UnauthorizedException', 'error' => [ 'httpStatusCode' => 401, ], 'exception' => true, ], [ 'shape' => 'NotFoundException', 'error' => [ 'httpStatusCode' => 404, ], 'exception' => true, ], [ 'shape' => 'TooManyRequestsException', 'error' => [ 'httpStatusCode' => 429, ], 'exception' => true, ], ], ], 'DeleteIntegrationResponse' => [ 'name' => 'DeleteIntegrationResponse', 'http' => [ 'method' => 'DELETE', 'requestUri' => '/restapis/{restapi_id}/resources/{resource_id}/methods/{http_method}/integration/responses/{status_code}', 'responseCode' => 204, ], 'input' => [ 'shape' => 'DeleteIntegrationResponseRequest', ], 'errors' => [ [ 'shape' => 'UnauthorizedException', 'error' => [ 'httpStatusCode' => 401, ], 'exception' => true, ], [ 'shape' => 'NotFoundException', 'error' => [ 'httpStatusCode' => 404, ], 'exception' => true, ], [ 'shape' => 'TooManyRequestsException', 'error' => [ 'httpStatusCode' => 429, ], 'exception' => true, ], ], ], 'DeleteMethod' => [ 'name' => 'DeleteMethod', 'http' => [ 'method' => 'DELETE', 'requestUri' => '/restapis/{restapi_id}/resources/{resource_id}/methods/{http_method}', 'responseCode' => 204, ], 'input' => [ 'shape' => 'DeleteMethodRequest', ], 'errors' => [ [ 'shape' => 'UnauthorizedException', 'error' => [ 'httpStatusCode' => 401, ], 'exception' => true, ], [ 'shape' => 'NotFoundException', 'error' => [ 'httpStatusCode' => 404, ], 'exception' => true, ], [ 'shape' => 'TooManyRequestsException', 'error' => [ 'httpStatusCode' => 429, ], 'exception' => true, ], ], ], 'DeleteMethodResponse' => [ 'name' => 'DeleteMethodResponse', 'http' => [ 'method' => 'DELETE', 'requestUri' => '/restapis/{restapi_id}/resources/{resource_id}/methods/{http_method}/responses/{status_code}', 'responseCode' => 204, ], 'input' => [ 'shape' => 'DeleteMethodResponseRequest', ], 'errors' => [ [ 'shape' => 'UnauthorizedException', 'error' => [ 'httpStatusCode' => 401, ], 'exception' => true, ], [ 'shape' => 'NotFoundException', 'error' => [ 'httpStatusCode' => 404, ], 'exception' => true, ], [ 'shape' => 'TooManyRequestsException', 'error' => [ 'httpStatusCode' => 429, ], 'exception' => true, ], ], ], 'DeleteModel' => [ 'name' => 'DeleteModel', 'http' => [ 'method' => 'DELETE', 'requestUri' => '/restapis/{restapi_id}/models/{model_name}', 'responseCode' => 202, ], 'input' => [ 'shape' => 'DeleteModelRequest', ], 'errors' => [ [ 'shape' => 'UnauthorizedException', 'error' => [ 'httpStatusCode' => 401, ], 'exception' => true, ], [ 'shape' => 'NotFoundException', 'error' => [ 'httpStatusCode' => 404, ], 'exception' => true, ], [ 'shape' => 'TooManyRequestsException', 'error' => [ 'httpStatusCode' => 429, ], 'exception' => true, ], [ 'shape' => 'BadRequestException', 'error' => [ 'httpStatusCode' => 400, ], 'exception' => true, ], [ 'shape' => 'ConflictException', 'error' => [ 'httpStatusCode' => 409, ], 'exception' => true, ], ], ], 'DeleteResource' => [ 'name' => 'DeleteResource', 'http' => [ 'method' => 'DELETE', 'requestUri' => '/restapis/{restapi_id}/resources/{resource_id}', 'responseCode' => 202, ], 'input' => [ 'shape' => 'DeleteResourceRequest', ], 'errors' => [ [ 'shape' => 'UnauthorizedException', 'error' => [ 'httpStatusCode' => 401, ], 'exception' => true, ], [ 'shape' => 'NotFoundException', 'error' => [ 'httpStatusCode' => 404, ], 'exception' => true, ], [ 'shape' => 'BadRequestException', 'error' => [ 'httpStatusCode' => 400, ], 'exception' => true, ], [ 'shape' => 'TooManyRequestsException', 'error' => [ 'httpStatusCode' => 429, ], 'exception' => true, ], ], ], 'DeleteRestApi' => [ 'name' => 'DeleteRestApi', 'http' => [ 'method' => 'DELETE', 'requestUri' => '/restapis/{restapi_id}', 'responseCode' => 202, ], 'input' => [ 'shape' => 'DeleteRestApiRequest', ], 'errors' => [ [ 'shape' => 'UnauthorizedException', 'error' => [ 'httpStatusCode' => 401, ], 'exception' => true, ], [ 'shape' => 'NotFoundException', 'error' => [ 'httpStatusCode' => 404, ], 'exception' => true, ], [ 'shape' => 'TooManyRequestsException', 'error' => [ 'httpStatusCode' => 429, ], 'exception' => true, ], ], ], 'DeleteStage' => [ 'name' => 'DeleteStage', 'http' => [ 'method' => 'DELETE', 'requestUri' => '/restapis/{restapi_id}/stages/{stage_name}', 'responseCode' => 202, ], 'input' => [ 'shape' => 'DeleteStageRequest', ], 'errors' => [ [ 'shape' => 'UnauthorizedException', 'error' => [ 'httpStatusCode' => 401, ], 'exception' => true, ], [ 'shape' => 'NotFoundException', 'error' => [ 'httpStatusCode' => 404, ], 'exception' => true, ], [ 'shape' => 'TooManyRequestsException', 'error' => [ 'httpStatusCode' => 429, ], 'exception' => true, ], ], ], 'FlushStageCache' => [ 'name' => 'FlushStageCache', 'http' => [ 'method' => 'DELETE', 'requestUri' => '/restapis/{restapi_id}/stages/{stage_name}/cache/data', 'responseCode' => 202, ], 'input' => [ 'shape' => 'FlushStageCacheRequest', ], 'errors' => [ [ 'shape' => 'UnauthorizedException', 'error' => [ 'httpStatusCode' => 401, ], 'exception' => true, ], [ 'shape' => 'NotFoundException', 'error' => [ 'httpStatusCode' => 404, ], 'exception' => true, ], [ 'shape' => 'BadRequestException', 'error' => [ 'httpStatusCode' => 400, ], 'exception' => true, ], [ 'shape' => 'TooManyRequestsException', 'error' => [ 'httpStatusCode' => 429, ], 'exception' => true, ], ], ], 'GenerateClientCertificate' => [ 'name' => 'GenerateClientCertificate', 'http' => [ 'method' => 'POST', 'requestUri' => '/clientcertificates', 'responseCode' => 201, ], 'input' => [ 'shape' => 'GenerateClientCertificateRequest', ], 'output' => [ 'shape' => 'ClientCertificate', ], 'errors' => [ [ 'shape' => 'UnauthorizedException', 'error' => [ 'httpStatusCode' => 401, ], 'exception' => true, ], [ 'shape' => 'TooManyRequestsException', 'error' => [ 'httpStatusCode' => 429, ], 'exception' => true, ], [ 'shape' => 'LimitExceededException', 'error' => [ 'httpStatusCode' => 429, ], 'exception' => true, ], ], ], 'GetAccount' => [ 'name' => 'GetAccount', 'http' => [ 'method' => 'GET', 'requestUri' => '/account', ], 'input' => [ 'shape' => 'GetAccountRequest', ], 'output' => [ 'shape' => 'Account', ], 'errors' => [ [ 'shape' => 'UnauthorizedException', 'error' => [ 'httpStatusCode' => 401, ], 'exception' => true, ], [ 'shape' => 'NotFoundException', 'error' => [ 'httpStatusCode' => 404, ], 'exception' => true, ], [ 'shape' => 'TooManyRequestsException', 'error' => [ 'httpStatusCode' => 429, ], 'exception' => true, ], ], ], 'GetApiKey' => [ 'name' => 'GetApiKey', 'http' => [ 'method' => 'GET', 'requestUri' => '/apikeys/{api_Key}', ], 'input' => [ 'shape' => 'GetApiKeyRequest', ], 'output' => [ 'shape' => 'ApiKey', ], 'errors' => [ [ 'shape' => 'UnauthorizedException', 'error' => [ 'httpStatusCode' => 401, ], 'exception' => true, ], [ 'shape' => 'NotFoundException', 'error' => [ 'httpStatusCode' => 404, ], 'exception' => true, ], [ 'shape' => 'TooManyRequestsException', 'error' => [ 'httpStatusCode' => 429, ], 'exception' => true, ], ], ], 'GetApiKeys' => [ 'name' => 'GetApiKeys', 'http' => [ 'method' => 'GET', 'requestUri' => '/apikeys', ], 'input' => [ 'shape' => 'GetApiKeysRequest', ], 'output' => [ 'shape' => 'ApiKeys', ], 'errors' => [ [ 'shape' => 'UnauthorizedException', 'error' => [ 'httpStatusCode' => 401, ], 'exception' => true, ], [ 'shape' => 'TooManyRequestsException', 'error' => [ 'httpStatusCode' => 429, ], 'exception' => true, ], ], ], 'GetBasePathMapping' => [ 'name' => 'GetBasePathMapping', 'http' => [ 'method' => 'GET', 'requestUri' => '/domainnames/{domain_name}/basepathmappings/{base_path}', ], 'input' => [ 'shape' => 'GetBasePathMappingRequest', ], 'output' => [ 'shape' => 'BasePathMapping', ], 'errors' => [ [ 'shape' => 'UnauthorizedException', 'error' => [ 'httpStatusCode' => 401, ], 'exception' => true, ], [ 'shape' => 'NotFoundException', 'error' => [ 'httpStatusCode' => 404, ], 'exception' => true, ], [ 'shape' => 'TooManyRequestsException', 'error' => [ 'httpStatusCode' => 429, ], 'exception' => true, ], ], ], 'GetBasePathMappings' => [ 'name' => 'GetBasePathMappings', 'http' => [ 'method' => 'GET', 'requestUri' => '/domainnames/{domain_name}/basepathmappings', ], 'input' => [ 'shape' => 'GetBasePathMappingsRequest', ], 'output' => [ 'shape' => 'BasePathMappings', ], 'errors' => [ [ 'shape' => 'UnauthorizedException', 'error' => [ 'httpStatusCode' => 401, ], 'exception' => true, ], [ 'shape' => 'NotFoundException', 'error' => [ 'httpStatusCode' => 404, ], 'exception' => true, ], [ 'shape' => 'TooManyRequestsException', 'error' => [ 'httpStatusCode' => 429, ], 'exception' => true, ], ], ], 'GetClientCertificate' => [ 'name' => 'GetClientCertificate', 'http' => [ 'method' => 'GET', 'requestUri' => '/clientcertificates/{clientcertificate_id}', ], 'input' => [ 'shape' => 'GetClientCertificateRequest', ], 'output' => [ 'shape' => 'ClientCertificate', ], 'errors' => [ [ 'shape' => 'UnauthorizedException', 'error' => [ 'httpStatusCode' => 401, ], 'exception' => true, ], [ 'shape' => 'NotFoundException', 'error' => [ 'httpStatusCode' => 404, ], 'exception' => true, ], [ 'shape' => 'TooManyRequestsException', 'error' => [ 'httpStatusCode' => 429, ], 'exception' => true, ], ], ], 'GetClientCertificates' => [ 'name' => 'GetClientCertificates', 'http' => [ 'method' => 'GET', 'requestUri' => '/clientcertificates', ], 'input' => [ 'shape' => 'GetClientCertificatesRequest', ], 'output' => [ 'shape' => 'ClientCertificates', ], 'errors' => [ [ 'shape' => 'UnauthorizedException', 'error' => [ 'httpStatusCode' => 401, ], 'exception' => true, ], [ 'shape' => 'TooManyRequestsException', 'error' => [ 'httpStatusCode' => 429, ], 'exception' => true, ], ], ], 'GetDeployment' => [ 'name' => 'GetDeployment', 'http' => [ 'method' => 'GET', 'requestUri' => '/restapis/{restapi_id}/deployments/{deployment_id}', ], 'input' => [ 'shape' => 'GetDeploymentRequest', ], 'output' => [ 'shape' => 'Deployment', ], 'errors' => [ [ 'shape' => 'UnauthorizedException', 'error' => [ 'httpStatusCode' => 401, ], 'exception' => true, ], [ 'shape' => 'NotFoundException', 'error' => [ 'httpStatusCode' => 404, ], 'exception' => true, ], [ 'shape' => 'TooManyRequestsException', 'error' => [ 'httpStatusCode' => 429, ], 'exception' => true, ], [ 'shape' => 'ServiceUnavailableException', 'error' => [ 'httpStatusCode' => 503, ], 'exception' => true, 'fault' => true, ], ], ], 'GetDeployments' => [ 'name' => 'GetDeployments', 'http' => [ 'method' => 'GET', 'requestUri' => '/restapis/{restapi_id}/deployments', ], 'input' => [ 'shape' => 'GetDeploymentsRequest', ], 'output' => [ 'shape' => 'Deployments', ], 'errors' => [ [ 'shape' => 'UnauthorizedException', 'error' => [ 'httpStatusCode' => 401, ], 'exception' => true, ], [ 'shape' => 'TooManyRequestsException', 'error' => [ 'httpStatusCode' => 429, ], 'exception' => true, ], [ 'shape' => 'ServiceUnavailableException', 'error' => [ 'httpStatusCode' => 503, ], 'exception' => true, 'fault' => true, ], ], ], 'GetDomainName' => [ 'name' => 'GetDomainName', 'http' => [ 'method' => 'GET', 'requestUri' => '/domainnames/{domain_name}', ], 'input' => [ 'shape' => 'GetDomainNameRequest', ], 'output' => [ 'shape' => 'DomainName', ], 'errors' => [ [ 'shape' => 'UnauthorizedException', 'error' => [ 'httpStatusCode' => 401, ], 'exception' => true, ], [ 'shape' => 'NotFoundException', 'error' => [ 'httpStatusCode' => 404, ], 'exception' => true, ], [ 'shape' => 'ServiceUnavailableException', 'error' => [ 'httpStatusCode' => 503, ], 'exception' => true, 'fault' => true, ], [ 'shape' => 'TooManyRequestsException', 'error' => [ 'httpStatusCode' => 429, ], 'exception' => true, ], ], ], 'GetDomainNames' => [ 'name' => 'GetDomainNames', 'http' => [ 'method' => 'GET', 'requestUri' => '/domainnames', ], 'input' => [ 'shape' => 'GetDomainNamesRequest', ], 'output' => [ 'shape' => 'DomainNames', ], 'errors' => [ [ 'shape' => 'UnauthorizedException', 'error' => [ 'httpStatusCode' => 401, ], 'exception' => true, ], [ 'shape' => 'TooManyRequestsException', 'error' => [ 'httpStatusCode' => 429, ], 'exception' => true, ], ], ], 'GetIntegration' => [ 'name' => 'GetIntegration', 'http' => [ 'method' => 'GET', 'requestUri' => '/restapis/{restapi_id}/resources/{resource_id}/methods/{http_method}/integration', ], 'input' => [ 'shape' => 'GetIntegrationRequest', ], 'output' => [ 'shape' => 'Integration', ], 'errors' => [ [ 'shape' => 'UnauthorizedException', 'error' => [ 'httpStatusCode' => 401, ], 'exception' => true, ], [ 'shape' => 'NotFoundException', 'error' => [ 'httpStatusCode' => 404, ], 'exception' => true, ], [ 'shape' => 'TooManyRequestsException', 'error' => [ 'httpStatusCode' => 429, ], 'exception' => true, ], ], ], 'GetIntegrationResponse' => [ 'name' => 'GetIntegrationResponse', 'http' => [ 'method' => 'GET', 'requestUri' => '/restapis/{restapi_id}/resources/{resource_id}/methods/{http_method}/integration/responses/{status_code}', ], 'input' => [ 'shape' => 'GetIntegrationResponseRequest', ], 'output' => [ 'shape' => 'IntegrationResponse', ], 'errors' => [ [ 'shape' => 'UnauthorizedException', 'error' => [ 'httpStatusCode' => 401, ], 'exception' => true, ], [ 'shape' => 'NotFoundException', 'error' => [ 'httpStatusCode' => 404, ], 'exception' => true, ], [ 'shape' => 'TooManyRequestsException', 'error' => [ 'httpStatusCode' => 429, ], 'exception' => true, ], ], ], 'GetMethod' => [ 'name' => 'GetMethod', 'http' => [ 'method' => 'GET', 'requestUri' => '/restapis/{restapi_id}/resources/{resource_id}/methods/{http_method}', ], 'input' => [ 'shape' => 'GetMethodRequest', ], 'output' => [ 'shape' => 'Method', ], 'errors' => [ [ 'shape' => 'UnauthorizedException', 'error' => [ 'httpStatusCode' => 401, ], 'exception' => true, ], [ 'shape' => 'NotFoundException', 'error' => [ 'httpStatusCode' => 404, ], 'exception' => true, ], [ 'shape' => 'TooManyRequestsException', 'error' => [ 'httpStatusCode' => 429, ], 'exception' => true, ], ], ], 'GetMethodResponse' => [ 'name' => 'GetMethodResponse', 'http' => [ 'method' => 'GET', 'requestUri' => '/restapis/{restapi_id}/resources/{resource_id}/methods/{http_method}/responses/{status_code}', ], 'input' => [ 'shape' => 'GetMethodResponseRequest', ], 'output' => [ 'shape' => 'MethodResponse', ], 'errors' => [ [ 'shape' => 'UnauthorizedException', 'error' => [ 'httpStatusCode' => 401, ], 'exception' => true, ], [ 'shape' => 'NotFoundException', 'error' => [ 'httpStatusCode' => 404, ], 'exception' => true, ], [ 'shape' => 'TooManyRequestsException', 'error' => [ 'httpStatusCode' => 429, ], 'exception' => true, ], ], ], 'GetModel' => [ 'name' => 'GetModel', 'http' => [ 'method' => 'GET', 'requestUri' => '/restapis/{restapi_id}/models/{model_name}', ], 'input' => [ 'shape' => 'GetModelRequest', ], 'output' => [ 'shape' => 'Model', ], 'errors' => [ [ 'shape' => 'UnauthorizedException', 'error' => [ 'httpStatusCode' => 401, ], 'exception' => true, ], [ 'shape' => 'NotFoundException', 'error' => [ 'httpStatusCode' => 404, ], 'exception' => true, ], [ 'shape' => 'TooManyRequestsException', 'error' => [ 'httpStatusCode' => 429, ], 'exception' => true, ], ], ], 'GetModelTemplate' => [ 'name' => 'GetModelTemplate', 'http' => [ 'method' => 'GET', 'requestUri' => '/restapis/{restapi_id}/models/{model_name}/default_template', ], 'input' => [ 'shape' => 'GetModelTemplateRequest', ], 'output' => [ 'shape' => 'Template', ], 'errors' => [ [ 'shape' => 'UnauthorizedException', 'error' => [ 'httpStatusCode' => 401, ], 'exception' => true, ], [ 'shape' => 'NotFoundException', 'error' => [ 'httpStatusCode' => 404, ], 'exception' => true, ], [ 'shape' => 'BadRequestException', 'error' => [ 'httpStatusCode' => 400, ], 'exception' => true, ], [ 'shape' => 'TooManyRequestsException', 'error' => [ 'httpStatusCode' => 429, ], 'exception' => true, ], ], ], 'GetModels' => [ 'name' => 'GetModels', 'http' => [ 'method' => 'GET', 'requestUri' => '/restapis/{restapi_id}/models', ], 'input' => [ 'shape' => 'GetModelsRequest', ], 'output' => [ 'shape' => 'Models', ], 'errors' => [ [ 'shape' => 'UnauthorizedException', 'error' => [ 'httpStatusCode' => 401, ], 'exception' => true, ], [ 'shape' => 'NotFoundException', 'error' => [ 'httpStatusCode' => 404, ], 'exception' => true, ], [ 'shape' => 'TooManyRequestsException', 'error' => [ 'httpStatusCode' => 429, ], 'exception' => true, ], ], ], 'GetResource' => [ 'name' => 'GetResource', 'http' => [ 'method' => 'GET', 'requestUri' => '/restapis/{restapi_id}/resources/{resource_id}', ], 'input' => [ 'shape' => 'GetResourceRequest', ], 'output' => [ 'shape' => 'Resource', ], 'errors' => [ [ 'shape' => 'UnauthorizedException', 'error' => [ 'httpStatusCode' => 401, ], 'exception' => true, ], [ 'shape' => 'NotFoundException', 'error' => [ 'httpStatusCode' => 404, ], 'exception' => true, ], [ 'shape' => 'TooManyRequestsException', 'error' => [ 'httpStatusCode' => 429, ], 'exception' => true, ], ], ], 'GetResources' => [ 'name' => 'GetResources', 'http' => [ 'method' => 'GET', 'requestUri' => '/restapis/{restapi_id}/resources', ], 'input' => [ 'shape' => 'GetResourcesRequest', ], 'output' => [ 'shape' => 'Resources', ], 'errors' => [ [ 'shape' => 'UnauthorizedException', 'error' => [ 'httpStatusCode' => 401, ], 'exception' => true, ], [ 'shape' => 'NotFoundException', 'error' => [ 'httpStatusCode' => 404, ], 'exception' => true, ], [ 'shape' => 'TooManyRequestsException', 'error' => [ 'httpStatusCode' => 429, ], 'exception' => true, ], ], ], 'GetRestApi' => [ 'name' => 'GetRestApi', 'http' => [ 'method' => 'GET', 'requestUri' => '/restapis/{restapi_id}', ], 'input' => [ 'shape' => 'GetRestApiRequest', ], 'output' => [ 'shape' => 'RestApi', ], 'errors' => [ [ 'shape' => 'UnauthorizedException', 'error' => [ 'httpStatusCode' => 401, ], 'exception' => true, ], [ 'shape' => 'NotFoundException', 'error' => [ 'httpStatusCode' => 404, ], 'exception' => true, ], [ 'shape' => 'TooManyRequestsException', 'error' => [ 'httpStatusCode' => 429, ], 'exception' => true, ], ], ], 'GetRestApis' => [ 'name' => 'GetRestApis', 'http' => [ 'method' => 'GET', 'requestUri' => '/restapis', ], 'input' => [ 'shape' => 'GetRestApisRequest', ], 'output' => [ 'shape' => 'RestApis', ], 'errors' => [ [ 'shape' => 'UnauthorizedException', 'error' => [ 'httpStatusCode' => 401, ], 'exception' => true, ], [ 'shape' => 'TooManyRequestsException', 'error' => [ 'httpStatusCode' => 429, ], 'exception' => true, ], ], ], 'GetSdk' => [ 'name' => 'GetSdk', 'http' => [ 'method' => 'GET', 'requestUri' => '/restapis/{restapi_id}/stages/{stage_name}/sdks/{sdk_type}', 'responseCode' => 200, ], 'input' => [ 'shape' => 'GetSdkRequest', ], 'output' => [ 'shape' => 'SdkResponse', ], 'errors' => [ [ 'shape' => 'UnauthorizedException', 'error' => [ 'httpStatusCode' => 401, ], 'exception' => true, ], [ 'shape' => 'NotFoundException', 'error' => [ 'httpStatusCode' => 404, ], 'exception' => true, ], [ 'shape' => 'BadRequestException', 'error' => [ 'httpStatusCode' => 400, ], 'exception' => true, ], [ 'shape' => 'TooManyRequestsException', 'error' => [ 'httpStatusCode' => 429, ], 'exception' => true, ], ], ], 'GetStage' => [ 'name' => 'GetStage', 'http' => [ 'method' => 'GET', 'requestUri' => '/restapis/{restapi_id}/stages/{stage_name}', ], 'input' => [ 'shape' => 'GetStageRequest', ], 'output' => [ 'shape' => 'Stage', ], 'errors' => [ [ 'shape' => 'UnauthorizedException', 'error' => [ 'httpStatusCode' => 401, ], 'exception' => true, ], [ 'shape' => 'NotFoundException', 'error' => [ 'httpStatusCode' => 404, ], 'exception' => true, ], [ 'shape' => 'TooManyRequestsException', 'error' => [ 'httpStatusCode' => 429, ], 'exception' => true, ], ], ], 'GetStages' => [ 'name' => 'GetStages', 'http' => [ 'method' => 'GET', 'requestUri' => '/restapis/{restapi_id}/stages', ], 'input' => [ 'shape' => 'GetStagesRequest', ], 'output' => [ 'shape' => 'Stages', ], 'errors' => [ [ 'shape' => 'UnauthorizedException', 'error' => [ 'httpStatusCode' => 401, ], 'exception' => true, ], [ 'shape' => 'NotFoundException', 'error' => [ 'httpStatusCode' => 404, ], 'exception' => true, ], [ 'shape' => 'TooManyRequestsException', 'error' => [ 'httpStatusCode' => 429, ], 'exception' => true, ], ], ], 'PutIntegration' => [ 'name' => 'PutIntegration', 'http' => [ 'method' => 'PUT', 'requestUri' => '/restapis/{restapi_id}/resources/{resource_id}/methods/{http_method}/integration', 'responseCode' => 201, ], 'input' => [ 'shape' => 'PutIntegrationRequest', ], 'output' => [ 'shape' => 'Integration', ], 'errors' => [ [ 'shape' => 'UnauthorizedException', 'error' => [ 'httpStatusCode' => 401, ], 'exception' => true, ], [ 'shape' => 'BadRequestException', 'error' => [ 'httpStatusCode' => 400, ], 'exception' => true, ], [ 'shape' => 'NotFoundException', 'error' => [ 'httpStatusCode' => 404, ], 'exception' => true, ], [ 'shape' => 'TooManyRequestsException', 'error' => [ 'httpStatusCode' => 429, ], 'exception' => true, ], ], ], 'PutIntegrationResponse' => [ 'name' => 'PutIntegrationResponse', 'http' => [ 'method' => 'PUT', 'requestUri' => '/restapis/{restapi_id}/resources/{resource_id}/methods/{http_method}/integration/responses/{status_code}', 'responseCode' => 201, ], 'input' => [ 'shape' => 'PutIntegrationResponseRequest', ], 'output' => [ 'shape' => 'IntegrationResponse', ], 'errors' => [ [ 'shape' => 'UnauthorizedException', 'error' => [ 'httpStatusCode' => 401, ], 'exception' => true, ], [ 'shape' => 'NotFoundException', 'error' => [ 'httpStatusCode' => 404, ], 'exception' => true, ], [ 'shape' => 'LimitExceededException', 'error' => [ 'httpStatusCode' => 429, ], 'exception' => true, ], [ 'shape' => 'BadRequestException', 'error' => [ 'httpStatusCode' => 400, ], 'exception' => true, ], [ 'shape' => 'TooManyRequestsException', 'error' => [ 'httpStatusCode' => 429, ], 'exception' => true, ], ], ], 'PutMethod' => [ 'name' => 'PutMethod', 'http' => [ 'method' => 'PUT', 'requestUri' => '/restapis/{restapi_id}/resources/{resource_id}/methods/{http_method}', 'responseCode' => 201, ], 'input' => [ 'shape' => 'PutMethodRequest', ], 'output' => [ 'shape' => 'Method', ], 'errors' => [ [ 'shape' => 'BadRequestException', 'error' => [ 'httpStatusCode' => 400, ], 'exception' => true, ], [ 'shape' => 'UnauthorizedException', 'error' => [ 'httpStatusCode' => 401, ], 'exception' => true, ], [ 'shape' => 'NotFoundException', 'error' => [ 'httpStatusCode' => 404, ], 'exception' => true, ], [ 'shape' => 'ConflictException', 'error' => [ 'httpStatusCode' => 409, ], 'exception' => true, ], [ 'shape' => 'LimitExceededException', 'error' => [ 'httpStatusCode' => 429, ], 'exception' => true, ], [ 'shape' => 'TooManyRequestsException', 'error' => [ 'httpStatusCode' => 429, ], 'exception' => true, ], ], ], 'PutMethodResponse' => [ 'name' => 'PutMethodResponse', 'http' => [ 'method' => 'PUT', 'requestUri' => '/restapis/{restapi_id}/resources/{resource_id}/methods/{http_method}/responses/{status_code}', 'responseCode' => 201, ], 'input' => [ 'shape' => 'PutMethodResponseRequest', ], 'output' => [ 'shape' => 'MethodResponse', ], 'errors' => [ [ 'shape' => 'UnauthorizedException', 'error' => [ 'httpStatusCode' => 401, ], 'exception' => true, ], [ 'shape' => 'NotFoundException', 'error' => [ 'httpStatusCode' => 404, ], 'exception' => true, ], [ 'shape' => 'ConflictException', 'error' => [ 'httpStatusCode' => 409, ], 'exception' => true, ], [ 'shape' => 'LimitExceededException', 'error' => [ 'httpStatusCode' => 429, ], 'exception' => true, ], [ 'shape' => 'BadRequestException', 'error' => [ 'httpStatusCode' => 400, ], 'exception' => true, ], [ 'shape' => 'TooManyRequestsException', 'error' => [ 'httpStatusCode' => 429, ], 'exception' => true, ], ], ], 'TestInvokeMethod' => [ 'name' => 'TestInvokeMethod', 'http' => [ 'method' => 'POST', 'requestUri' => '/restapis/{restapi_id}/resources/{resource_id}/methods/{http_method}', ], 'input' => [ 'shape' => 'TestInvokeMethodRequest', ], 'output' => [ 'shape' => 'TestInvokeMethodResponse', ], 'errors' => [ [ 'shape' => 'BadRequestException', 'error' => [ 'httpStatusCode' => 400, ], 'exception' => true, ], [ 'shape' => 'UnauthorizedException', 'error' => [ 'httpStatusCode' => 401, ], 'exception' => true, ], [ 'shape' => 'NotFoundException', 'error' => [ 'httpStatusCode' => 404, ], 'exception' => true, ], [ 'shape' => 'TooManyRequestsException', 'error' => [ 'httpStatusCode' => 429, ], 'exception' => true, ], ], ], 'UpdateAccount' => [ 'name' => 'UpdateAccount', 'http' => [ 'method' => 'PATCH', 'requestUri' => '/account', ], 'input' => [ 'shape' => 'UpdateAccountRequest', ], 'output' => [ 'shape' => 'Account', ], 'errors' => [ [ 'shape' => 'UnauthorizedException', 'error' => [ 'httpStatusCode' => 401, ], 'exception' => true, ], [ 'shape' => 'BadRequestException', 'error' => [ 'httpStatusCode' => 400, ], 'exception' => true, ], [ 'shape' => 'NotFoundException', 'error' => [ 'httpStatusCode' => 404, ], 'exception' => true, ], [ 'shape' => 'TooManyRequestsException', 'error' => [ 'httpStatusCode' => 429, ], 'exception' => true, ], ], ], 'UpdateApiKey' => [ 'name' => 'UpdateApiKey', 'http' => [ 'method' => 'PATCH', 'requestUri' => '/apikeys/{api_Key}', ], 'input' => [ 'shape' => 'UpdateApiKeyRequest', ], 'output' => [ 'shape' => 'ApiKey', ], 'errors' => [ [ 'shape' => 'UnauthorizedException', 'error' => [ 'httpStatusCode' => 401, ], 'exception' => true, ], [ 'shape' => 'NotFoundException', 'error' => [ 'httpStatusCode' => 404, ], 'exception' => true, ], [ 'shape' => 'BadRequestException', 'error' => [ 'httpStatusCode' => 400, ], 'exception' => true, ], [ 'shape' => 'TooManyRequestsException', 'error' => [ 'httpStatusCode' => 429, ], 'exception' => true, ], ], ], 'UpdateBasePathMapping' => [ 'name' => 'UpdateBasePathMapping', 'http' => [ 'method' => 'PATCH', 'requestUri' => '/domainnames/{domain_name}/basepathmappings/{base_path}', ], 'input' => [ 'shape' => 'UpdateBasePathMappingRequest', ], 'output' => [ 'shape' => 'BasePathMapping', ], 'errors' => [ [ 'shape' => 'UnauthorizedException', 'error' => [ 'httpStatusCode' => 401, ], 'exception' => true, ], [ 'shape' => 'NotFoundException', 'error' => [ 'httpStatusCode' => 404, ], 'exception' => true, ], [ 'shape' => 'ConflictException', 'error' => [ 'httpStatusCode' => 409, ], 'exception' => true, ], [ 'shape' => 'BadRequestException', 'error' => [ 'httpStatusCode' => 400, ], 'exception' => true, ], [ 'shape' => 'TooManyRequestsException', 'error' => [ 'httpStatusCode' => 429, ], 'exception' => true, ], ], ], 'UpdateClientCertificate' => [ 'name' => 'UpdateClientCertificate', 'http' => [ 'method' => 'PATCH', 'requestUri' => '/clientcertificates/{clientcertificate_id}', ], 'input' => [ 'shape' => 'UpdateClientCertificateRequest', ], 'output' => [ 'shape' => 'ClientCertificate', ], 'errors' => [ [ 'shape' => 'UnauthorizedException', 'error' => [ 'httpStatusCode' => 401, ], 'exception' => true, ], [ 'shape' => 'TooManyRequestsException', 'error' => [ 'httpStatusCode' => 429, ], 'exception' => true, ], [ 'shape' => 'BadRequestException', 'error' => [ 'httpStatusCode' => 400, ], 'exception' => true, ], [ 'shape' => 'NotFoundException', 'error' => [ 'httpStatusCode' => 404, ], 'exception' => true, ], ], ], 'UpdateDeployment' => [ 'name' => 'UpdateDeployment', 'http' => [ 'method' => 'PATCH', 'requestUri' => '/restapis/{restapi_id}/deployments/{deployment_id}', ], 'input' => [ 'shape' => 'UpdateDeploymentRequest', ], 'output' => [ 'shape' => 'Deployment', ], 'errors' => [ [ 'shape' => 'UnauthorizedException', 'error' => [ 'httpStatusCode' => 401, ], 'exception' => true, ], [ 'shape' => 'NotFoundException', 'error' => [ 'httpStatusCode' => 404, ], 'exception' => true, ], [ 'shape' => 'BadRequestException', 'error' => [ 'httpStatusCode' => 400, ], 'exception' => true, ], [ 'shape' => 'TooManyRequestsException', 'error' => [ 'httpStatusCode' => 429, ], 'exception' => true, ], [ 'shape' => 'ServiceUnavailableException', 'error' => [ 'httpStatusCode' => 503, ], 'exception' => true, 'fault' => true, ], ], ], 'UpdateDomainName' => [ 'name' => 'UpdateDomainName', 'http' => [ 'method' => 'PATCH', 'requestUri' => '/domainnames/{domain_name}', ], 'input' => [ 'shape' => 'UpdateDomainNameRequest', ], 'output' => [ 'shape' => 'DomainName', ], 'errors' => [ [ 'shape' => 'UnauthorizedException', 'error' => [ 'httpStatusCode' => 401, ], 'exception' => true, ], [ 'shape' => 'NotFoundException', 'error' => [ 'httpStatusCode' => 404, ], 'exception' => true, ], [ 'shape' => 'BadRequestException', 'error' => [ 'httpStatusCode' => 400, ], 'exception' => true, ], [ 'shape' => 'TooManyRequestsException', 'error' => [ 'httpStatusCode' => 429, ], 'exception' => true, ], ], ], 'UpdateIntegration' => [ 'name' => 'UpdateIntegration', 'http' => [ 'method' => 'PATCH', 'requestUri' => '/restapis/{restapi_id}/resources/{resource_id}/methods/{http_method}/integration', ], 'input' => [ 'shape' => 'UpdateIntegrationRequest', ], 'output' => [ 'shape' => 'Integration', ], 'errors' => [ [ 'shape' => 'UnauthorizedException', 'error' => [ 'httpStatusCode' => 401, ], 'exception' => true, ], [ 'shape' => 'NotFoundException', 'error' => [ 'httpStatusCode' => 404, ], 'exception' => true, ], [ 'shape' => 'BadRequestException', 'error' => [ 'httpStatusCode' => 400, ], 'exception' => true, ], [ 'shape' => 'TooManyRequestsException', 'error' => [ 'httpStatusCode' => 429, ], 'exception' => true, ], ], ], 'UpdateIntegrationResponse' => [ 'name' => 'UpdateIntegrationResponse', 'http' => [ 'method' => 'PATCH', 'requestUri' => '/restapis/{restapi_id}/resources/{resource_id}/methods/{http_method}/integration/responses/{status_code}', ], 'input' => [ 'shape' => 'UpdateIntegrationResponseRequest', ], 'output' => [ 'shape' => 'IntegrationResponse', ], 'errors' => [ [ 'shape' => 'UnauthorizedException', 'error' => [ 'httpStatusCode' => 401, ], 'exception' => true, ], [ 'shape' => 'NotFoundException', 'error' => [ 'httpStatusCode' => 404, ], 'exception' => true, ], [ 'shape' => 'BadRequestException', 'error' => [ 'httpStatusCode' => 400, ], 'exception' => true, ], [ 'shape' => 'TooManyRequestsException', 'error' => [ 'httpStatusCode' => 429, ], 'exception' => true, ], ], ], 'UpdateMethod' => [ 'name' => 'UpdateMethod', 'http' => [ 'method' => 'PATCH', 'requestUri' => '/restapis/{restapi_id}/resources/{resource_id}/methods/{http_method}', ], 'input' => [ 'shape' => 'UpdateMethodRequest', ], 'output' => [ 'shape' => 'Method', ], 'errors' => [ [ 'shape' => 'UnauthorizedException', 'error' => [ 'httpStatusCode' => 401, ], 'exception' => true, ], [ 'shape' => 'NotFoundException', 'error' => [ 'httpStatusCode' => 404, ], 'exception' => true, ], [ 'shape' => 'BadRequestException', 'error' => [ 'httpStatusCode' => 400, ], 'exception' => true, ], [ 'shape' => 'TooManyRequestsException', 'error' => [ 'httpStatusCode' => 429, ], 'exception' => true, ], ], ], 'UpdateMethodResponse' => [ 'name' => 'UpdateMethodResponse', 'http' => [ 'method' => 'PATCH', 'requestUri' => '/restapis/{restapi_id}/resources/{resource_id}/methods/{http_method}/responses/{status_code}', 'responseCode' => 201, ], 'input' => [ 'shape' => 'UpdateMethodResponseRequest', ], 'output' => [ 'shape' => 'MethodResponse', ], 'errors' => [ [ 'shape' => 'UnauthorizedException', 'error' => [ 'httpStatusCode' => 401, ], 'exception' => true, ], [ 'shape' => 'NotFoundException', 'error' => [ 'httpStatusCode' => 404, ], 'exception' => true, ], [ 'shape' => 'ConflictException', 'error' => [ 'httpStatusCode' => 409, ], 'exception' => true, ], [ 'shape' => 'LimitExceededException', 'error' => [ 'httpStatusCode' => 429, ], 'exception' => true, ], [ 'shape' => 'BadRequestException', 'error' => [ 'httpStatusCode' => 400, ], 'exception' => true, ], [ 'shape' => 'TooManyRequestsException', 'error' => [ 'httpStatusCode' => 429, ], 'exception' => true, ], ], ], 'UpdateModel' => [ 'name' => 'UpdateModel', 'http' => [ 'method' => 'PATCH', 'requestUri' => '/restapis/{restapi_id}/models/{model_name}', ], 'input' => [ 'shape' => 'UpdateModelRequest', ], 'output' => [ 'shape' => 'Model', ], 'errors' => [ [ 'shape' => 'UnauthorizedException', 'error' => [ 'httpStatusCode' => 401, ], 'exception' => true, ], [ 'shape' => 'NotFoundException', 'error' => [ 'httpStatusCode' => 404, ], 'exception' => true, ], [ 'shape' => 'BadRequestException', 'error' => [ 'httpStatusCode' => 400, ], 'exception' => true, ], [ 'shape' => 'TooManyRequestsException', 'error' => [ 'httpStatusCode' => 429, ], 'exception' => true, ], ], ], 'UpdateResource' => [ 'name' => 'UpdateResource', 'http' => [ 'method' => 'PATCH', 'requestUri' => '/restapis/{restapi_id}/resources/{resource_id}', ], 'input' => [ 'shape' => 'UpdateResourceRequest', ], 'output' => [ 'shape' => 'Resource', ], 'errors' => [ [ 'shape' => 'UnauthorizedException', 'error' => [ 'httpStatusCode' => 401, ], 'exception' => true, ], [ 'shape' => 'NotFoundException', 'error' => [ 'httpStatusCode' => 404, ], 'exception' => true, ], [ 'shape' => 'ConflictException', 'error' => [ 'httpStatusCode' => 409, ], 'exception' => true, ], [ 'shape' => 'BadRequestException', 'error' => [ 'httpStatusCode' => 400, ], 'exception' => true, ], [ 'shape' => 'TooManyRequestsException', 'error' => [ 'httpStatusCode' => 429, ], 'exception' => true, ], ], ], 'UpdateRestApi' => [ 'name' => 'UpdateRestApi', 'http' => [ 'method' => 'PATCH', 'requestUri' => '/restapis/{restapi_id}', ], 'input' => [ 'shape' => 'UpdateRestApiRequest', ], 'output' => [ 'shape' => 'RestApi', ], 'errors' => [ [ 'shape' => 'UnauthorizedException', 'error' => [ 'httpStatusCode' => 401, ], 'exception' => true, ], [ 'shape' => 'NotFoundException', 'error' => [ 'httpStatusCode' => 404, ], 'exception' => true, ], [ 'shape' => 'ConflictException', 'error' => [ 'httpStatusCode' => 409, ], 'exception' => true, ], [ 'shape' => 'BadRequestException', 'error' => [ 'httpStatusCode' => 400, ], 'exception' => true, ], [ 'shape' => 'TooManyRequestsException', 'error' => [ 'httpStatusCode' => 429, ], 'exception' => true, ], ], ], 'UpdateStage' => [ 'name' => 'UpdateStage', 'http' => [ 'method' => 'PATCH', 'requestUri' => '/restapis/{restapi_id}/stages/{stage_name}', ], 'input' => [ 'shape' => 'UpdateStageRequest', ], 'output' => [ 'shape' => 'Stage', ], 'errors' => [ [ 'shape' => 'UnauthorizedException', 'error' => [ 'httpStatusCode' => 401, ], 'exception' => true, ], [ 'shape' => 'NotFoundException', 'error' => [ 'httpStatusCode' => 404, ], 'exception' => true, ], [ 'shape' => 'ConflictException', 'error' => [ 'httpStatusCode' => 409, ], 'exception' => true, ], [ 'shape' => 'BadRequestException', 'error' => [ 'httpStatusCode' => 400, ], 'exception' => true, ], [ 'shape' => 'TooManyRequestsException', 'error' => [ 'httpStatusCode' => 429, ], 'exception' => true, ], ], ], ], 'shapes' => [ 'Account' => [ 'type' => 'structure', 'members' => [ 'cloudwatchRoleArn' => [ 'shape' => 'String', ], 'throttleSettings' => [ 'shape' => 'ThrottleSettings', ], ], ], 'ApiKey' => [ 'type' => 'structure', 'members' => [ 'id' => [ 'shape' => 'String', ], 'name' => [ 'shape' => 'String', ], 'description' => [ 'shape' => 'String', ], 'enabled' => [ 'shape' => 'Boolean', ], 'stageKeys' => [ 'shape' => 'ListOfString', ], 'createdDate' => [ 'shape' => 'Timestamp', ], 'lastUpdatedDate' => [ 'shape' => 'Timestamp', ], ], ], 'ApiKeys' => [ 'type' => 'structure', 'members' => [ 'position' => [ 'shape' => 'String', ], 'items' => [ 'shape' => 'ListOfApiKey', 'locationName' => 'item', ], ], ], 'BadRequestException' => [ 'type' => 'structure', 'members' => [ 'message' => [ 'shape' => 'String', ], ], 'error' => [ 'httpStatusCode' => 400, ], 'exception' => true, ], 'BasePathMapping' => [ 'type' => 'structure', 'members' => [ 'basePath' => [ 'shape' => 'String', ], 'restApiId' => [ 'shape' => 'String', ], 'stage' => [ 'shape' => 'String', ], ], ], 'BasePathMappings' => [ 'type' => 'structure', 'members' => [ 'position' => [ 'shape' => 'String', ], 'items' => [ 'shape' => 'ListOfBasePathMapping', 'locationName' => 'item', ], ], ], 'Blob' => [ 'type' => 'blob', ], 'Boolean' => [ 'type' => 'boolean', ], 'CacheClusterSize' => [ 'type' => 'string', 'enum' => [ '0.5', '1.6', '6.1', '13.5', '28.4', '58.2', '118', '237', ], ], 'CacheClusterStatus' => [ 'type' => 'string', 'enum' => [ 'CREATE_IN_PROGRESS', 'AVAILABLE', 'DELETE_IN_PROGRESS', 'NOT_AVAILABLE', 'FLUSH_IN_PROGRESS', ], ], 'ClientCertificate' => [ 'type' => 'structure', 'members' => [ 'clientCertificateId' => [ 'shape' => 'String', ], 'description' => [ 'shape' => 'String', ], 'pemEncodedCertificate' => [ 'shape' => 'String', ], 'createdDate' => [ 'shape' => 'Timestamp', ], 'expirationDate' => [ 'shape' => 'Timestamp', ], ], ], 'ClientCertificates' => [ 'type' => 'structure', 'members' => [ 'position' => [ 'shape' => 'String', ], 'items' => [ 'shape' => 'ListOfClientCertificate', 'locationName' => 'item', ], ], ], 'ConflictException' => [ 'type' => 'structure', 'members' => [ 'message' => [ 'shape' => 'String', ], ], 'error' => [ 'httpStatusCode' => 409, ], 'exception' => true, ], 'CreateApiKeyRequest' => [ 'type' => 'structure', 'members' => [ 'name' => [ 'shape' => 'String', ], 'description' => [ 'shape' => 'String', ], 'enabled' => [ 'shape' => 'Boolean', ], 'stageKeys' => [ 'shape' => 'ListOfStageKeys', ], ], ], 'CreateBasePathMappingRequest' => [ 'type' => 'structure', 'required' => [ 'domainName', 'restApiId', ], 'members' => [ 'domainName' => [ 'shape' => 'String', 'location' => 'uri', 'locationName' => 'domain_name', ], 'basePath' => [ 'shape' => 'String', ], 'restApiId' => [ 'shape' => 'String', ], 'stage' => [ 'shape' => 'String', ], ], ], 'CreateDeploymentRequest' => [ 'type' => 'structure', 'required' => [ 'restApiId', 'stageName', ], 'members' => [ 'restApiId' => [ 'shape' => 'String', 'location' => 'uri', 'locationName' => 'restapi_id', ], 'stageName' => [ 'shape' => 'String', ], 'stageDescription' => [ 'shape' => 'String', ], 'description' => [ 'shape' => 'String', ], 'cacheClusterEnabled' => [ 'shape' => 'NullableBoolean', ], 'cacheClusterSize' => [ 'shape' => 'CacheClusterSize', ], 'variables' => [ 'shape' => 'MapOfStringToString', ], ], ], 'CreateDomainNameRequest' => [ 'type' => 'structure', 'required' => [ 'domainName', 'certificateName', 'certificateBody', 'certificatePrivateKey', 'certificateChain', ], 'members' => [ 'domainName' => [ 'shape' => 'String', ], 'certificateName' => [ 'shape' => 'String', ], 'certificateBody' => [ 'shape' => 'String', ], 'certificatePrivateKey' => [ 'shape' => 'String', ], 'certificateChain' => [ 'shape' => 'String', ], ], ], 'CreateModelRequest' => [ 'type' => 'structure', 'required' => [ 'restApiId', 'name', 'contentType', ], 'members' => [ 'restApiId' => [ 'shape' => 'String', 'location' => 'uri', 'locationName' => 'restapi_id', ], 'name' => [ 'shape' => 'String', ], 'description' => [ 'shape' => 'String', ], 'schema' => [ 'shape' => 'String', ], 'contentType' => [ 'shape' => 'String', ], ], ], 'CreateResourceRequest' => [ 'type' => 'structure', 'required' => [ 'restApiId', 'parentId', 'pathPart', ], 'members' => [ 'restApiId' => [ 'shape' => 'String', 'location' => 'uri', 'locationName' => 'restapi_id', ], 'parentId' => [ 'shape' => 'String', 'location' => 'uri', 'locationName' => 'parent_id', ], 'pathPart' => [ 'shape' => 'String', ], ], ], 'CreateRestApiRequest' => [ 'type' => 'structure', 'required' => [ 'name', ], 'members' => [ 'name' => [ 'shape' => 'String', ], 'description' => [ 'shape' => 'String', ], 'cloneFrom' => [ 'shape' => 'String', ], ], ], 'CreateStageRequest' => [ 'type' => 'structure', 'required' => [ 'restApiId', 'stageName', 'deploymentId', ], 'members' => [ 'restApiId' => [ 'shape' => 'String', 'location' => 'uri', 'locationName' => 'restapi_id', ], 'stageName' => [ 'shape' => 'String', ], 'deploymentId' => [ 'shape' => 'String', ], 'description' => [ 'shape' => 'String', ], 'cacheClusterEnabled' => [ 'shape' => 'Boolean', ], 'cacheClusterSize' => [ 'shape' => 'CacheClusterSize', ], 'variables' => [ 'shape' => 'MapOfStringToString', ], ], ], 'DeleteApiKeyRequest' => [ 'type' => 'structure', 'required' => [ 'apiKey', ], 'members' => [ 'apiKey' => [ 'shape' => 'String', 'location' => 'uri', 'locationName' => 'api_Key', ], ], ], 'DeleteBasePathMappingRequest' => [ 'type' => 'structure', 'required' => [ 'domainName', 'basePath', ], 'members' => [ 'domainName' => [ 'shape' => 'String', 'location' => 'uri', 'locationName' => 'domain_name', ], 'basePath' => [ 'shape' => 'String', 'location' => 'uri', 'locationName' => 'base_path', ], ], ], 'DeleteClientCertificateRequest' => [ 'type' => 'structure', 'required' => [ 'clientCertificateId', ], 'members' => [ 'clientCertificateId' => [ 'shape' => 'String', 'location' => 'uri', 'locationName' => 'clientcertificate_id', ], ], ], 'DeleteDeploymentRequest' => [ 'type' => 'structure', 'required' => [ 'restApiId', 'deploymentId', ], 'members' => [ 'restApiId' => [ 'shape' => 'String', 'location' => 'uri', 'locationName' => 'restapi_id', ], 'deploymentId' => [ 'shape' => 'String', 'location' => 'uri', 'locationName' => 'deployment_id', ], ], ], 'DeleteDomainNameRequest' => [ 'type' => 'structure', 'required' => [ 'domainName', ], 'members' => [ 'domainName' => [ 'shape' => 'String', 'location' => 'uri', 'locationName' => 'domain_name', ], ], ], 'DeleteIntegrationRequest' => [ 'type' => 'structure', 'required' => [ 'restApiId', 'resourceId', 'httpMethod', ], 'members' => [ 'restApiId' => [ 'shape' => 'String', 'location' => 'uri', 'locationName' => 'restapi_id', ], 'resourceId' => [ 'shape' => 'String', 'location' => 'uri', 'locationName' => 'resource_id', ], 'httpMethod' => [ 'shape' => 'String', 'location' => 'uri', 'locationName' => 'http_method', ], ], ], 'DeleteIntegrationResponseRequest' => [ 'type' => 'structure', 'required' => [ 'restApiId', 'resourceId', 'httpMethod', 'statusCode', ], 'members' => [ 'restApiId' => [ 'shape' => 'String', 'location' => 'uri', 'locationName' => 'restapi_id', ], 'resourceId' => [ 'shape' => 'String', 'location' => 'uri', 'locationName' => 'resource_id', ], 'httpMethod' => [ 'shape' => 'String', 'location' => 'uri', 'locationName' => 'http_method', ], 'statusCode' => [ 'shape' => 'StatusCode', 'location' => 'uri', 'locationName' => 'status_code', ], ], ], 'DeleteMethodRequest' => [ 'type' => 'structure', 'required' => [ 'restApiId', 'resourceId', 'httpMethod', ], 'members' => [ 'restApiId' => [ 'shape' => 'String', 'location' => 'uri', 'locationName' => 'restapi_id', ], 'resourceId' => [ 'shape' => 'String', 'location' => 'uri', 'locationName' => 'resource_id', ], 'httpMethod' => [ 'shape' => 'String', 'location' => 'uri', 'locationName' => 'http_method', ], ], ], 'DeleteMethodResponseRequest' => [ 'type' => 'structure', 'required' => [ 'restApiId', 'resourceId', 'httpMethod', 'statusCode', ], 'members' => [ 'restApiId' => [ 'shape' => 'String', 'location' => 'uri', 'locationName' => 'restapi_id', ], 'resourceId' => [ 'shape' => 'String', 'location' => 'uri', 'locationName' => 'resource_id', ], 'httpMethod' => [ 'shape' => 'String', 'location' => 'uri', 'locationName' => 'http_method', ], 'statusCode' => [ 'shape' => 'StatusCode', 'location' => 'uri', 'locationName' => 'status_code', ], ], ], 'DeleteModelRequest' => [ 'type' => 'structure', 'required' => [ 'restApiId', 'modelName', ], 'members' => [ 'restApiId' => [ 'shape' => 'String', 'location' => 'uri', 'locationName' => 'restapi_id', ], 'modelName' => [ 'shape' => 'String', 'location' => 'uri', 'locationName' => 'model_name', ], ], ], 'DeleteResourceRequest' => [ 'type' => 'structure', 'required' => [ 'restApiId', 'resourceId', ], 'members' => [ 'restApiId' => [ 'shape' => 'String', 'location' => 'uri', 'locationName' => 'restapi_id', ], 'resourceId' => [ 'shape' => 'String', 'location' => 'uri', 'locationName' => 'resource_id', ], ], ], 'DeleteRestApiRequest' => [ 'type' => 'structure', 'required' => [ 'restApiId', ], 'members' => [ 'restApiId' => [ 'shape' => 'String', 'location' => 'uri', 'locationName' => 'restapi_id', ], ], ], 'DeleteStageRequest' => [ 'type' => 'structure', 'required' => [ 'restApiId', 'stageName', ], 'members' => [ 'restApiId' => [ 'shape' => 'String', 'location' => 'uri', 'locationName' => 'restapi_id', ], 'stageName' => [ 'shape' => 'String', 'location' => 'uri', 'locationName' => 'stage_name', ], ], ], 'Deployment' => [ 'type' => 'structure', 'members' => [ 'id' => [ 'shape' => 'String', ], 'description' => [ 'shape' => 'String', ], 'createdDate' => [ 'shape' => 'Timestamp', ], 'apiSummary' => [ 'shape' => 'PathToMapOfMethodSnapshot', ], ], ], 'Deployments' => [ 'type' => 'structure', 'members' => [ 'position' => [ 'shape' => 'String', ], 'items' => [ 'shape' => 'ListOfDeployment', 'locationName' => 'item', ], ], ], 'DomainName' => [ 'type' => 'structure', 'members' => [ 'domainName' => [ 'shape' => 'String', ], 'certificateName' => [ 'shape' => 'String', ], 'certificateUploadDate' => [ 'shape' => 'Timestamp', ], 'distributionDomainName' => [ 'shape' => 'String', ], ], ], 'DomainNames' => [ 'type' => 'structure', 'members' => [ 'position' => [ 'shape' => 'String', ], 'items' => [ 'shape' => 'ListOfDomainName', 'locationName' => 'item', ], ], ], 'Double' => [ 'type' => 'double', ], 'FlushStageCacheRequest' => [ 'type' => 'structure', 'required' => [ 'restApiId', 'stageName', ], 'members' => [ 'restApiId' => [ 'shape' => 'String', 'location' => 'uri', 'locationName' => 'restapi_id', ], 'stageName' => [ 'shape' => 'String', 'location' => 'uri', 'locationName' => 'stage_name', ], ], ], 'GenerateClientCertificateRequest' => [ 'type' => 'structure', 'members' => [ 'description' => [ 'shape' => 'String', ], ], ], 'GetAccountRequest' => [ 'type' => 'structure', 'members' => [], ], 'GetApiKeyRequest' => [ 'type' => 'structure', 'required' => [ 'apiKey', ], 'members' => [ 'apiKey' => [ 'shape' => 'String', 'location' => 'uri', 'locationName' => 'api_Key', ], ], ], 'GetApiKeysRequest' => [ 'type' => 'structure', 'members' => [ 'position' => [ 'shape' => 'String', 'location' => 'querystring', 'locationName' => 'position', ], 'limit' => [ 'shape' => 'NullableInteger', 'location' => 'querystring', 'locationName' => 'limit', ], ], ], 'GetBasePathMappingRequest' => [ 'type' => 'structure', 'required' => [ 'domainName', 'basePath', ], 'members' => [ 'domainName' => [ 'shape' => 'String', 'location' => 'uri', 'locationName' => 'domain_name', ], 'basePath' => [ 'shape' => 'String', 'location' => 'uri', 'locationName' => 'base_path', ], ], ], 'GetBasePathMappingsRequest' => [ 'type' => 'structure', 'required' => [ 'domainName', ], 'members' => [ 'domainName' => [ 'shape' => 'String', 'location' => 'uri', 'locationName' => 'domain_name', ], 'position' => [ 'shape' => 'String', 'location' => 'querystring', 'locationName' => 'position', ], 'limit' => [ 'shape' => 'NullableInteger', 'location' => 'querystring', 'locationName' => 'limit', ], ], ], 'GetClientCertificateRequest' => [ 'type' => 'structure', 'required' => [ 'clientCertificateId', ], 'members' => [ 'clientCertificateId' => [ 'shape' => 'String', 'location' => 'uri', 'locationName' => 'clientcertificate_id', ], ], ], 'GetClientCertificatesRequest' => [ 'type' => 'structure', 'members' => [ 'position' => [ 'shape' => 'String', 'location' => 'querystring', 'locationName' => 'position', ], 'limit' => [ 'shape' => 'NullableInteger', 'location' => 'querystring', 'locationName' => 'limit', ], ], ], 'GetDeploymentRequest' => [ 'type' => 'structure', 'required' => [ 'restApiId', 'deploymentId', ], 'members' => [ 'restApiId' => [ 'shape' => 'String', 'location' => 'uri', 'locationName' => 'restapi_id', ], 'deploymentId' => [ 'shape' => 'String', 'location' => 'uri', 'locationName' => 'deployment_id', ], ], ], 'GetDeploymentsRequest' => [ 'type' => 'structure', 'required' => [ 'restApiId', ], 'members' => [ 'restApiId' => [ 'shape' => 'String', 'location' => 'uri', 'locationName' => 'restapi_id', ], 'position' => [ 'shape' => 'String', 'location' => 'querystring', 'locationName' => 'position', ], 'limit' => [ 'shape' => 'NullableInteger', 'location' => 'querystring', 'locationName' => 'limit', ], ], ], 'GetDomainNameRequest' => [ 'type' => 'structure', 'required' => [ 'domainName', ], 'members' => [ 'domainName' => [ 'shape' => 'String', 'location' => 'uri', 'locationName' => 'domain_name', ], ], ], 'GetDomainNamesRequest' => [ 'type' => 'structure', 'members' => [ 'position' => [ 'shape' => 'String', 'location' => 'querystring', 'locationName' => 'position', ], 'limit' => [ 'shape' => 'NullableInteger', 'location' => 'querystring', 'locationName' => 'limit', ], ], ], 'GetIntegrationRequest' => [ 'type' => 'structure', 'required' => [ 'restApiId', 'resourceId', 'httpMethod', ], 'members' => [ 'restApiId' => [ 'shape' => 'String', 'location' => 'uri', 'locationName' => 'restapi_id', ], 'resourceId' => [ 'shape' => 'String', 'location' => 'uri', 'locationName' => 'resource_id', ], 'httpMethod' => [ 'shape' => 'String', 'location' => 'uri', 'locationName' => 'http_method', ], ], ], 'GetIntegrationResponseRequest' => [ 'type' => 'structure', 'required' => [ 'restApiId', 'resourceId', 'httpMethod', 'statusCode', ], 'members' => [ 'restApiId' => [ 'shape' => 'String', 'location' => 'uri', 'locationName' => 'restapi_id', ], 'resourceId' => [ 'shape' => 'String', 'location' => 'uri', 'locationName' => 'resource_id', ], 'httpMethod' => [ 'shape' => 'String', 'location' => 'uri', 'locationName' => 'http_method', ], 'statusCode' => [ 'shape' => 'StatusCode', 'location' => 'uri', 'locationName' => 'status_code', ], ], ], 'GetMethodRequest' => [ 'type' => 'structure', 'required' => [ 'restApiId', 'resourceId', 'httpMethod', ], 'members' => [ 'restApiId' => [ 'shape' => 'String', 'location' => 'uri', 'locationName' => 'restapi_id', ], 'resourceId' => [ 'shape' => 'String', 'location' => 'uri', 'locationName' => 'resource_id', ], 'httpMethod' => [ 'shape' => 'String', 'location' => 'uri', 'locationName' => 'http_method', ], ], ], 'GetMethodResponseRequest' => [ 'type' => 'structure', 'required' => [ 'restApiId', 'resourceId', 'httpMethod', 'statusCode', ], 'members' => [ 'restApiId' => [ 'shape' => 'String', 'location' => 'uri', 'locationName' => 'restapi_id', ], 'resourceId' => [ 'shape' => 'String', 'location' => 'uri', 'locationName' => 'resource_id', ], 'httpMethod' => [ 'shape' => 'String', 'location' => 'uri', 'locationName' => 'http_method', ], 'statusCode' => [ 'shape' => 'StatusCode', 'location' => 'uri', 'locationName' => 'status_code', ], ], ], 'GetModelRequest' => [ 'type' => 'structure', 'required' => [ 'restApiId', 'modelName', ], 'members' => [ 'restApiId' => [ 'shape' => 'String', 'location' => 'uri', 'locationName' => 'restapi_id', ], 'modelName' => [ 'shape' => 'String', 'location' => 'uri', 'locationName' => 'model_name', ], 'flatten' => [ 'shape' => 'Boolean', 'location' => 'querystring', 'locationName' => 'flatten', ], ], ], 'GetModelTemplateRequest' => [ 'type' => 'structure', 'required' => [ 'restApiId', 'modelName', ], 'members' => [ 'restApiId' => [ 'shape' => 'String', 'location' => 'uri', 'locationName' => 'restapi_id', ], 'modelName' => [ 'shape' => 'String', 'location' => 'uri', 'locationName' => 'model_name', ], ], ], 'GetModelsRequest' => [ 'type' => 'structure', 'required' => [ 'restApiId', ], 'members' => [ 'restApiId' => [ 'shape' => 'String', 'location' => 'uri', 'locationName' => 'restapi_id', ], 'position' => [ 'shape' => 'String', 'location' => 'querystring', 'locationName' => 'position', ], 'limit' => [ 'shape' => 'NullableInteger', 'location' => 'querystring', 'locationName' => 'limit', ], ], ], 'GetResourceRequest' => [ 'type' => 'structure', 'required' => [ 'restApiId', 'resourceId', ], 'members' => [ 'restApiId' => [ 'shape' => 'String', 'location' => 'uri', 'locationName' => 'restapi_id', ], 'resourceId' => [ 'shape' => 'String', 'location' => 'uri', 'locationName' => 'resource_id', ], ], ], 'GetResourcesRequest' => [ 'type' => 'structure', 'required' => [ 'restApiId', ], 'members' => [ 'restApiId' => [ 'shape' => 'String', 'location' => 'uri', 'locationName' => 'restapi_id', ], 'position' => [ 'shape' => 'String', 'location' => 'querystring', 'locationName' => 'position', ], 'limit' => [ 'shape' => 'NullableInteger', 'location' => 'querystring', 'locationName' => 'limit', ], ], ], 'GetRestApiRequest' => [ 'type' => 'structure', 'required' => [ 'restApiId', ], 'members' => [ 'restApiId' => [ 'shape' => 'String', 'location' => 'uri', 'locationName' => 'restapi_id', ], ], ], 'GetRestApisRequest' => [ 'type' => 'structure', 'members' => [ 'position' => [ 'shape' => 'String', 'location' => 'querystring', 'locationName' => 'position', ], 'limit' => [ 'shape' => 'NullableInteger', 'location' => 'querystring', 'locationName' => 'limit', ], ], ], 'GetSdkRequest' => [ 'type' => 'structure', 'required' => [ 'restApiId', 'stageName', 'sdkType', ], 'members' => [ 'restApiId' => [ 'shape' => 'String', 'location' => 'uri', 'locationName' => 'restapi_id', ], 'stageName' => [ 'shape' => 'String', 'location' => 'uri', 'locationName' => 'stage_name', ], 'sdkType' => [ 'shape' => 'String', 'location' => 'uri', 'locationName' => 'sdk_type', ], 'parameters' => [ 'shape' => 'MapOfStringToString', 'location' => 'querystring', ], ], ], 'GetStageRequest' => [ 'type' => 'structure', 'required' => [ 'restApiId', 'stageName', ], 'members' => [ 'restApiId' => [ 'shape' => 'String', 'location' => 'uri', 'locationName' => 'restapi_id', ], 'stageName' => [ 'shape' => 'String', 'location' => 'uri', 'locationName' => 'stage_name', ], ], ], 'GetStagesRequest' => [ 'type' => 'structure', 'required' => [ 'restApiId', ], 'members' => [ 'restApiId' => [ 'shape' => 'String', 'location' => 'uri', 'locationName' => 'restapi_id', ], 'deploymentId' => [ 'shape' => 'String', 'location' => 'querystring', 'locationName' => 'deploymentId', ], ], ], 'Integer' => [ 'type' => 'integer', ], 'Integration' => [ 'type' => 'structure', 'members' => [ 'type' => [ 'shape' => 'IntegrationType', ], 'httpMethod' => [ 'shape' => 'String', ], 'uri' => [ 'shape' => 'String', ], 'credentials' => [ 'shape' => 'String', ], 'requestParameters' => [ 'shape' => 'MapOfStringToString', ], 'requestTemplates' => [ 'shape' => 'MapOfStringToString', ], 'cacheNamespace' => [ 'shape' => 'String', ], 'cacheKeyParameters' => [ 'shape' => 'ListOfString', ], 'integrationResponses' => [ 'shape' => 'MapOfIntegrationResponse', ], ], ], 'IntegrationResponse' => [ 'type' => 'structure', 'members' => [ 'statusCode' => [ 'shape' => 'StatusCode', ], 'selectionPattern' => [ 'shape' => 'String', ], 'responseParameters' => [ 'shape' => 'MapOfStringToString', ], 'responseTemplates' => [ 'shape' => 'MapOfStringToString', ], ], ], 'IntegrationType' => [ 'type' => 'string', 'enum' => [ 'HTTP', 'AWS', 'MOCK', ], ], 'LimitExceededException' => [ 'type' => 'structure', 'members' => [ 'retryAfterSeconds' => [ 'shape' => 'String', 'location' => 'header', 'locationName' => 'Retry-After', ], 'message' => [ 'shape' => 'String', ], ], 'error' => [ 'httpStatusCode' => 429, ], 'exception' => true, ], 'ListOfApiKey' => [ 'type' => 'list', 'member' => [ 'shape' => 'ApiKey', ], ], 'ListOfBasePathMapping' => [ 'type' => 'list', 'member' => [ 'shape' => 'BasePathMapping', ], ], 'ListOfClientCertificate' => [ 'type' => 'list', 'member' => [ 'shape' => 'ClientCertificate', ], ], 'ListOfDeployment' => [ 'type' => 'list', 'member' => [ 'shape' => 'Deployment', ], ], 'ListOfDomainName' => [ 'type' => 'list', 'member' => [ 'shape' => 'DomainName', ], ], 'ListOfModel' => [ 'type' => 'list', 'member' => [ 'shape' => 'Model', ], ], 'ListOfPatchOperation' => [ 'type' => 'list', 'member' => [ 'shape' => 'PatchOperation', ], ], 'ListOfResource' => [ 'type' => 'list', 'member' => [ 'shape' => 'Resource', ], ], 'ListOfRestApi' => [ 'type' => 'list', 'member' => [ 'shape' => 'RestApi', ], ], 'ListOfStage' => [ 'type' => 'list', 'member' => [ 'shape' => 'Stage', ], ], 'ListOfStageKeys' => [ 'type' => 'list', 'member' => [ 'shape' => 'StageKey', ], ], 'ListOfString' => [ 'type' => 'list', 'member' => [ 'shape' => 'String', ], ], 'Long' => [ 'type' => 'long', ], 'MapOfHeaderValues' => [ 'type' => 'map', 'key' => [ 'shape' => 'String', ], 'value' => [ 'shape' => 'String', ], ], 'MapOfIntegrationResponse' => [ 'type' => 'map', 'key' => [ 'shape' => 'String', ], 'value' => [ 'shape' => 'IntegrationResponse', ], ], 'MapOfMethod' => [ 'type' => 'map', 'key' => [ 'shape' => 'String', ], 'value' => [ 'shape' => 'Method', ], ], 'MapOfMethodResponse' => [ 'type' => 'map', 'key' => [ 'shape' => 'String', ], 'value' => [ 'shape' => 'MethodResponse', ], ], 'MapOfMethodSettings' => [ 'type' => 'map', 'key' => [ 'shape' => 'String', ], 'value' => [ 'shape' => 'MethodSetting', ], ], 'MapOfMethodSnapshot' => [ 'type' => 'map', 'key' => [ 'shape' => 'String', ], 'value' => [ 'shape' => 'MethodSnapshot', ], ], 'MapOfStringToBoolean' => [ 'type' => 'map', 'key' => [ 'shape' => 'String', ], 'value' => [ 'shape' => 'NullableBoolean', ], ], 'MapOfStringToString' => [ 'type' => 'map', 'key' => [ 'shape' => 'String', ], 'value' => [ 'shape' => 'String', ], ], 'Method' => [ 'type' => 'structure', 'members' => [ 'httpMethod' => [ 'shape' => 'String', ], 'authorizationType' => [ 'shape' => 'String', ], 'apiKeyRequired' => [ 'shape' => 'NullableBoolean', ], 'requestParameters' => [ 'shape' => 'MapOfStringToBoolean', ], 'requestModels' => [ 'shape' => 'MapOfStringToString', ], 'methodResponses' => [ 'shape' => 'MapOfMethodResponse', ], 'methodIntegration' => [ 'shape' => 'Integration', ], ], ], 'MethodResponse' => [ 'type' => 'structure', 'members' => [ 'statusCode' => [ 'shape' => 'StatusCode', ], 'responseParameters' => [ 'shape' => 'MapOfStringToBoolean', ], 'responseModels' => [ 'shape' => 'MapOfStringToString', ], ], ], 'MethodSetting' => [ 'type' => 'structure', 'members' => [ 'metricsEnabled' => [ 'shape' => 'Boolean', ], 'loggingLevel' => [ 'shape' => 'String', ], 'dataTraceEnabled' => [ 'shape' => 'Boolean', ], 'throttlingBurstLimit' => [ 'shape' => 'Integer', ], 'throttlingRateLimit' => [ 'shape' => 'Double', ], 'cachingEnabled' => [ 'shape' => 'Boolean', ], 'cacheTtlInSeconds' => [ 'shape' => 'Integer', ], 'cacheDataEncrypted' => [ 'shape' => 'Boolean', ], ], ], 'MethodSnapshot' => [ 'type' => 'structure', 'members' => [ 'authorizationType' => [ 'shape' => 'String', ], 'apiKeyRequired' => [ 'shape' => 'Boolean', ], ], ], 'Model' => [ 'type' => 'structure', 'members' => [ 'id' => [ 'shape' => 'String', ], 'name' => [ 'shape' => 'String', ], 'description' => [ 'shape' => 'String', ], 'schema' => [ 'shape' => 'String', ], 'contentType' => [ 'shape' => 'String', ], ], ], 'Models' => [ 'type' => 'structure', 'members' => [ 'position' => [ 'shape' => 'String', ], 'items' => [ 'shape' => 'ListOfModel', 'locationName' => 'item', ], ], ], 'NotFoundException' => [ 'type' => 'structure', 'members' => [ 'message' => [ 'shape' => 'String', ], ], 'error' => [ 'httpStatusCode' => 404, ], 'exception' => true, ], 'NullableBoolean' => [ 'type' => 'boolean', ], 'NullableInteger' => [ 'type' => 'integer', ], 'PatchOperation' => [ 'type' => 'structure', 'members' => [ 'op' => [ 'shape' => 'op', ], 'path' => [ 'shape' => 'String', ], 'value' => [ 'shape' => 'String', ], 'from' => [ 'shape' => 'String', ], ], ], 'PathToMapOfMethodSnapshot' => [ 'type' => 'map', 'key' => [ 'shape' => 'String', ], 'value' => [ 'shape' => 'MapOfMethodSnapshot', ], ], 'PutIntegrationRequest' => [ 'type' => 'structure', 'required' => [ 'restApiId', 'resourceId', 'httpMethod', 'type', ], 'members' => [ 'restApiId' => [ 'shape' => 'String', 'location' => 'uri', 'locationName' => 'restapi_id', ], 'resourceId' => [ 'shape' => 'String', 'location' => 'uri', 'locationName' => 'resource_id', ], 'httpMethod' => [ 'shape' => 'String', 'location' => 'uri', 'locationName' => 'http_method', ], 'type' => [ 'shape' => 'IntegrationType', ], 'integrationHttpMethod' => [ 'shape' => 'String', 'locationName' => 'httpMethod', ], 'uri' => [ 'shape' => 'String', ], 'credentials' => [ 'shape' => 'String', ], 'requestParameters' => [ 'shape' => 'MapOfStringToString', ], 'requestTemplates' => [ 'shape' => 'MapOfStringToString', ], 'cacheNamespace' => [ 'shape' => 'String', ], 'cacheKeyParameters' => [ 'shape' => 'ListOfString', ], ], ], 'PutIntegrationResponseRequest' => [ 'type' => 'structure', 'required' => [ 'restApiId', 'resourceId', 'httpMethod', 'statusCode', ], 'members' => [ 'restApiId' => [ 'shape' => 'String', 'location' => 'uri', 'locationName' => 'restapi_id', ], 'resourceId' => [ 'shape' => 'String', 'location' => 'uri', 'locationName' => 'resource_id', ], 'httpMethod' => [ 'shape' => 'String', 'location' => 'uri', 'locationName' => 'http_method', ], 'statusCode' => [ 'shape' => 'StatusCode', 'location' => 'uri', 'locationName' => 'status_code', ], 'selectionPattern' => [ 'shape' => 'String', ], 'responseParameters' => [ 'shape' => 'MapOfStringToString', ], 'responseTemplates' => [ 'shape' => 'MapOfStringToString', ], ], ], 'PutMethodRequest' => [ 'type' => 'structure', 'required' => [ 'restApiId', 'resourceId', 'httpMethod', 'authorizationType', ], 'members' => [ 'restApiId' => [ 'shape' => 'String', 'location' => 'uri', 'locationName' => 'restapi_id', ], 'resourceId' => [ 'shape' => 'String', 'location' => 'uri', 'locationName' => 'resource_id', ], 'httpMethod' => [ 'shape' => 'String', 'location' => 'uri', 'locationName' => 'http_method', ], 'authorizationType' => [ 'shape' => 'String', ], 'apiKeyRequired' => [ 'shape' => 'Boolean', ], 'requestParameters' => [ 'shape' => 'MapOfStringToBoolean', ], 'requestModels' => [ 'shape' => 'MapOfStringToString', ], ], ], 'PutMethodResponseRequest' => [ 'type' => 'structure', 'required' => [ 'restApiId', 'resourceId', 'httpMethod', 'statusCode', ], 'members' => [ 'restApiId' => [ 'shape' => 'String', 'location' => 'uri', 'locationName' => 'restapi_id', ], 'resourceId' => [ 'shape' => 'String', 'location' => 'uri', 'locationName' => 'resource_id', ], 'httpMethod' => [ 'shape' => 'String', 'location' => 'uri', 'locationName' => 'http_method', ], 'statusCode' => [ 'shape' => 'StatusCode', 'location' => 'uri', 'locationName' => 'status_code', ], 'responseParameters' => [ 'shape' => 'MapOfStringToBoolean', ], 'responseModels' => [ 'shape' => 'MapOfStringToString', ], ], ], 'Resource' => [ 'type' => 'structure', 'members' => [ 'id' => [ 'shape' => 'String', ], 'parentId' => [ 'shape' => 'String', ], 'pathPart' => [ 'shape' => 'String', ], 'path' => [ 'shape' => 'String', ], 'resourceMethods' => [ 'shape' => 'MapOfMethod', ], ], ], 'Resources' => [ 'type' => 'structure', 'members' => [ 'position' => [ 'shape' => 'String', ], 'items' => [ 'shape' => 'ListOfResource', 'locationName' => 'item', ], ], ], 'RestApi' => [ 'type' => 'structure', 'members' => [ 'id' => [ 'shape' => 'String', ], 'name' => [ 'shape' => 'String', ], 'description' => [ 'shape' => 'String', ], 'createdDate' => [ 'shape' => 'Timestamp', ], ], ], 'RestApis' => [ 'type' => 'structure', 'members' => [ 'position' => [ 'shape' => 'String', ], 'items' => [ 'shape' => 'ListOfRestApi', 'locationName' => 'item', ], ], ], 'SdkResponse' => [ 'type' => 'structure', 'members' => [ 'contentType' => [ 'shape' => 'String', 'location' => 'header', 'locationName' => 'Content-Type', ], 'contentDisposition' => [ 'shape' => 'String', 'location' => 'header', 'locationName' => 'Content-Disposition', ], 'body' => [ 'shape' => 'Blob', ], ], 'payload' => 'body', ], 'ServiceUnavailableException' => [ 'type' => 'structure', 'members' => [ 'retryAfterSeconds' => [ 'shape' => 'String', 'location' => 'header', 'locationName' => 'Retry-After', ], 'message' => [ 'shape' => 'String', ], ], 'error' => [ 'httpStatusCode' => 503, ], 'exception' => true, 'fault' => true, ], 'Stage' => [ 'type' => 'structure', 'members' => [ 'deploymentId' => [ 'shape' => 'String', ], 'clientCertificateId' => [ 'shape' => 'String', ], 'stageName' => [ 'shape' => 'String', ], 'description' => [ 'shape' => 'String', ], 'cacheClusterEnabled' => [ 'shape' => 'Boolean', ], 'cacheClusterSize' => [ 'shape' => 'CacheClusterSize', ], 'cacheClusterStatus' => [ 'shape' => 'CacheClusterStatus', ], 'methodSettings' => [ 'shape' => 'MapOfMethodSettings', ], 'variables' => [ 'shape' => 'MapOfStringToString', ], 'createdDate' => [ 'shape' => 'Timestamp', ], 'lastUpdatedDate' => [ 'shape' => 'Timestamp', ], ], ], 'StageKey' => [ 'type' => 'structure', 'members' => [ 'restApiId' => [ 'shape' => 'String', ], 'stageName' => [ 'shape' => 'String', ], ], ], 'Stages' => [ 'type' => 'structure', 'members' => [ 'item' => [ 'shape' => 'ListOfStage', ], ], ], 'StatusCode' => [ 'type' => 'string', 'pattern' => '[1-5]\\d\\d', ], 'String' => [ 'type' => 'string', ], 'Template' => [ 'type' => 'structure', 'members' => [ 'value' => [ 'shape' => 'String', ], ], ], 'TestInvokeMethodRequest' => [ 'type' => 'structure', 'required' => [ 'restApiId', 'resourceId', 'httpMethod', ], 'members' => [ 'restApiId' => [ 'shape' => 'String', 'location' => 'uri', 'locationName' => 'restapi_id', ], 'resourceId' => [ 'shape' => 'String', 'location' => 'uri', 'locationName' => 'resource_id', ], 'httpMethod' => [ 'shape' => 'String', 'location' => 'uri', 'locationName' => 'http_method', ], 'pathWithQueryString' => [ 'shape' => 'String', ], 'body' => [ 'shape' => 'String', ], 'headers' => [ 'shape' => 'MapOfHeaderValues', ], 'clientCertificateId' => [ 'shape' => 'String', ], 'stageVariables' => [ 'shape' => 'MapOfStringToString', ], ], ], 'TestInvokeMethodResponse' => [ 'type' => 'structure', 'members' => [ 'status' => [ 'shape' => 'Integer', ], 'body' => [ 'shape' => 'String', ], 'headers' => [ 'shape' => 'MapOfHeaderValues', ], 'log' => [ 'shape' => 'String', ], 'latency' => [ 'shape' => 'Long', ], ], ], 'ThrottleSettings' => [ 'type' => 'structure', 'members' => [ 'burstLimit' => [ 'shape' => 'Integer', ], 'rateLimit' => [ 'shape' => 'Double', ], ], ], 'Timestamp' => [ 'type' => 'timestamp', ], 'TooManyRequestsException' => [ 'type' => 'structure', 'members' => [ 'retryAfterSeconds' => [ 'shape' => 'String', 'location' => 'header', 'locationName' => 'Retry-After', ], 'message' => [ 'shape' => 'String', ], ], 'error' => [ 'httpStatusCode' => 429, ], 'exception' => true, ], 'UnauthorizedException' => [ 'type' => 'structure', 'members' => [ 'message' => [ 'shape' => 'String', ], ], 'error' => [ 'httpStatusCode' => 401, ], 'exception' => true, ], 'UpdateAccountRequest' => [ 'type' => 'structure', 'members' => [ 'patchOperations' => [ 'shape' => 'ListOfPatchOperation', ], ], ], 'UpdateApiKeyRequest' => [ 'type' => 'structure', 'required' => [ 'apiKey', ], 'members' => [ 'apiKey' => [ 'shape' => 'String', 'location' => 'uri', 'locationName' => 'api_Key', ], 'patchOperations' => [ 'shape' => 'ListOfPatchOperation', ], ], ], 'UpdateBasePathMappingRequest' => [ 'type' => 'structure', 'required' => [ 'domainName', 'basePath', ], 'members' => [ 'domainName' => [ 'shape' => 'String', 'location' => 'uri', 'locationName' => 'domain_name', ], 'basePath' => [ 'shape' => 'String', 'location' => 'uri', 'locationName' => 'base_path', ], 'patchOperations' => [ 'shape' => 'ListOfPatchOperation', ], ], ], 'UpdateClientCertificateRequest' => [ 'type' => 'structure', 'required' => [ 'clientCertificateId', ], 'members' => [ 'clientCertificateId' => [ 'shape' => 'String', 'location' => 'uri', 'locationName' => 'clientcertificate_id', ], 'patchOperations' => [ 'shape' => 'ListOfPatchOperation', ], ], ], 'UpdateDeploymentRequest' => [ 'type' => 'structure', 'required' => [ 'restApiId', 'deploymentId', ], 'members' => [ 'restApiId' => [ 'shape' => 'String', 'location' => 'uri', 'locationName' => 'restapi_id', ], 'deploymentId' => [ 'shape' => 'String', 'location' => 'uri', 'locationName' => 'deployment_id', ], 'patchOperations' => [ 'shape' => 'ListOfPatchOperation', ], ], ], 'UpdateDomainNameRequest' => [ 'type' => 'structure', 'required' => [ 'domainName', ], 'members' => [ 'domainName' => [ 'shape' => 'String', 'location' => 'uri', 'locationName' => 'domain_name', ], 'patchOperations' => [ 'shape' => 'ListOfPatchOperation', ], ], ], 'UpdateIntegrationRequest' => [ 'type' => 'structure', 'required' => [ 'restApiId', 'resourceId', 'httpMethod', ], 'members' => [ 'restApiId' => [ 'shape' => 'String', 'location' => 'uri', 'locationName' => 'restapi_id', ], 'resourceId' => [ 'shape' => 'String', 'location' => 'uri', 'locationName' => 'resource_id', ], 'httpMethod' => [ 'shape' => 'String', 'location' => 'uri', 'locationName' => 'http_method', ], 'patchOperations' => [ 'shape' => 'ListOfPatchOperation', ], ], ], 'UpdateIntegrationResponseRequest' => [ 'type' => 'structure', 'required' => [ 'restApiId', 'resourceId', 'httpMethod', 'statusCode', ], 'members' => [ 'restApiId' => [ 'shape' => 'String', 'location' => 'uri', 'locationName' => 'restapi_id', ], 'resourceId' => [ 'shape' => 'String', 'location' => 'uri', 'locationName' => 'resource_id', ], 'httpMethod' => [ 'shape' => 'String', 'location' => 'uri', 'locationName' => 'http_method', ], 'statusCode' => [ 'shape' => 'StatusCode', 'location' => 'uri', 'locationName' => 'status_code', ], 'patchOperations' => [ 'shape' => 'ListOfPatchOperation', ], ], ], 'UpdateMethodRequest' => [ 'type' => 'structure', 'required' => [ 'restApiId', 'resourceId', 'httpMethod', ], 'members' => [ 'restApiId' => [ 'shape' => 'String', 'location' => 'uri', 'locationName' => 'restapi_id', ], 'resourceId' => [ 'shape' => 'String', 'location' => 'uri', 'locationName' => 'resource_id', ], 'httpMethod' => [ 'shape' => 'String', 'location' => 'uri', 'locationName' => 'http_method', ], 'patchOperations' => [ 'shape' => 'ListOfPatchOperation', ], ], ], 'UpdateMethodResponseRequest' => [ 'type' => 'structure', 'required' => [ 'restApiId', 'resourceId', 'httpMethod', 'statusCode', ], 'members' => [ 'restApiId' => [ 'shape' => 'String', 'location' => 'uri', 'locationName' => 'restapi_id', ], 'resourceId' => [ 'shape' => 'String', 'location' => 'uri', 'locationName' => 'resource_id', ], 'httpMethod' => [ 'shape' => 'String', 'location' => 'uri', 'locationName' => 'http_method', ], 'statusCode' => [ 'shape' => 'StatusCode', 'location' => 'uri', 'locationName' => 'status_code', ], 'patchOperations' => [ 'shape' => 'ListOfPatchOperation', ], ], ], 'UpdateModelRequest' => [ 'type' => 'structure', 'required' => [ 'restApiId', 'modelName', ], 'members' => [ 'restApiId' => [ 'shape' => 'String', 'location' => 'uri', 'locationName' => 'restapi_id', ], 'modelName' => [ 'shape' => 'String', 'location' => 'uri', 'locationName' => 'model_name', ], 'patchOperations' => [ 'shape' => 'ListOfPatchOperation', ], ], ], 'UpdateResourceRequest' => [ 'type' => 'structure', 'required' => [ 'restApiId', 'resourceId', ], 'members' => [ 'restApiId' => [ 'shape' => 'String', 'location' => 'uri', 'locationName' => 'restapi_id', ], 'resourceId' => [ 'shape' => 'String', 'location' => 'uri', 'locationName' => 'resource_id', ], 'patchOperations' => [ 'shape' => 'ListOfPatchOperation', ], ], ], 'UpdateRestApiRequest' => [ 'type' => 'structure', 'required' => [ 'restApiId', ], 'members' => [ 'restApiId' => [ 'shape' => 'String', 'location' => 'uri', 'locationName' => 'restapi_id', ], 'patchOperations' => [ 'shape' => 'ListOfPatchOperation', ], ], ], 'UpdateStageRequest' => [ 'type' => 'structure', 'required' => [ 'restApiId', 'stageName', ], 'members' => [ 'restApiId' => [ 'shape' => 'String', 'location' => 'uri', 'locationName' => 'restapi_id', ], 'stageName' => [ 'shape' => 'String', 'location' => 'uri', 'locationName' => 'stage_name', ], 'patchOperations' => [ 'shape' => 'ListOfPatchOperation', ], ], ], 'op' => [ 'type' => 'string', 'enum' => [ 'add', 'remove', 'replace', 'move', 'copy', 'test', ], ], ],];
