<?php
// This file was auto-generated from sdk-root/src/data/cognito-sync/2014-06-30/docs-2.json
return [ 'version' => '2.0', 'operations' => [ 'BulkPublish' => '<p>Initiates a bulk publish of all existing datasets for an Identity Pool to the configured stream. Customers are limited to one successful bulk publish per 24 hours. Bulk publish is an asynchronous request, customers can see the status of the request via the GetBulkPublishDetails operation.</p> <p>This API can only be called with developer credentials. You cannot call this API with the temporary user credentials provided by Cognito Identity.</p>', 'DeleteDataset' => '<p>Deletes the specific dataset. The dataset will be deleted permanently, and the action can\'t be undone. Datasets that this dataset was merged with will no longer report the merge. Any subsequent operation on this dataset will result in a ResourceNotFoundException.</p> <p>This API can be called with temporary user credentials provided by Cognito Identity or with developer credentials.</p>', 'DescribeDataset' => '<p>Gets meta data about a dataset by identity and dataset name. With Amazon Cognito Sync, each identity has access only to its own data. Thus, the credentials used to make this API call need to have access to the identity data.</p> <p>This API can be called with temporary user credentials provided by Cognito Identity or with developer credentials. You should use Cognito Identity credentials to make this API call.</p>', 'DescribeIdentityPoolUsage' => '<p>Gets usage details (for example, data storage] about a particular identity pool.</p> <p>This API can only be called with developer credentials. You cannot call this API with the temporary user credentials provided by Cognito Identity.</p>', 'DescribeIdentityUsage' => '<p>Gets usage information for an identity, including number of datasets and data usage.</p> <p>This API can be called with temporary user credentials provided by Cognito Identity or with developer credentials.</p>', 'GetBulkPublishDetails' => '<p>Get the status of the last BulkPublish operation for an identity pool.</p> <p>This API can only be called with developer credentials. You cannot call this API with the temporary user credentials provided by Cognito Identity.</p>', 'GetCognitoEvents' => '<p>Gets the events and the corresponding Lambda functions associated with an identity pool.</p> <p>This API can only be called with developer credentials. You cannot call this API with the temporary user credentials provided by Cognito Identity.</p>', 'GetIdentityPoolConfiguration' => '<p>Gets the configuration settings of an identity pool.</p> <p>This API can only be called with developer credentials. You cannot call this API with the temporary user credentials provided by Cognito Identity.</p>', 'ListDatasets' => '<p>Lists datasets for an identity. With Amazon Cognito Sync, each identity has access only to its own data. Thus, the credentials used to make this API call need to have access to the identity data.</p> <p>ListDatasets can be called with temporary user credentials provided by Cognito Identity or with developer credentials. You should use the Cognito Identity credentials to make this API call.</p>', 'ListIdentityPoolUsage' => '<p>Gets a list of identity pools registered with Cognito.</p> <p>ListIdentityPoolUsage can only be called with developer credentials. You cannot make this API call with the temporary user credentials provided by Cognito Identity.</p>', 'ListRecords' => '<p>Gets paginated records, optionally changed after a particular sync count for a dataset and identity. With Amazon Cognito Sync, each identity has access only to its own data. Thus, the credentials used to make this API call need to have access to the identity data.</p> <p>ListRecords can be called with temporary user credentials provided by Cognito Identity or with developer credentials. You should use Cognito Identity credentials to make this API call.</p>', 'RegisterDevice' => '<p>Registers a device to receive push sync notifications.</p> <p>This API can only be called with temporary credentials provided by Cognito Identity. You cannot call this API with developer credentials.</p>', 'SetCognitoEvents' => '<p>Sets the AWS Lambda function for a given event type for an identity pool. This request only updates the key/value pair specified. Other key/values pairs are not updated. To remove a key value pair, pass a empty value for the particular key.</p> <p>This API can only be called with developer credentials. You cannot call this API with the temporary user credentials provided by Cognito Identity.</p>', 'SetIdentityPoolConfiguration' => '<p>Sets the necessary configuration for push sync.</p> <p>This API can only be called with developer credentials. You cannot call this API with the temporary user credentials provided by Cognito Identity.</p>', 'SubscribeToDataset' => '<p>Subscribes to receive notifications when a dataset is modified by another device.</p> <p>This API can only be called with temporary credentials provided by Cognito Identity. You cannot call this API with developer credentials.</p>', 'UnsubscribeFromDataset' => '<p>Unsubscribes from receiving notifications when a dataset is modified by another device.</p> <p>This API can only be called with temporary credentials provided by Cognito Identity. You cannot call this API with developer credentials.</p>', 'UpdateRecords' => '<p>Posts updates to records and adds and deletes records for a dataset and user.</p> <p>The sync count in the record patch is your last known sync count for that record. The server will reject an UpdateRecords request with a ResourceConflictException if you try to patch a record with a new value but a stale sync count.</p> <p>For example, if the sync count on the server is 5 for a key called highScore and you try and submit a new highScore with sync count of 4, the request will be rejected. To obtain the current sync count for a record, call ListRecords. On a successful update of the record, the response returns the new sync count for that record. You should present that sync count the next time you try to update that same record. When the record does not exist, specify the sync count as 0.</p> <p>This API can be called with temporary user credentials provided by Cognito Identity or with developer credentials.</p>', ], 'shapes' => [ 'AlreadyStreamedException' => [ 'base' => 'An exception thrown when a bulk publish operation is requested less than 24 hours after a previous bulk publish operation completed successfully.', 'refs' => [], ], 'ApplicationArn' => [ 'refs' => [], ], 'ApplicationArnList' => [ 'refs' => [ 'PushSync$ApplicationArns' => '<p>List of SNS platform application ARNs that could be used by clients.</p>', ], ], 'AssumeRoleArn' => [ 'refs' => [ 'CognitoStreams$RoleArn' => 'The ARN of the role Amazon Cognito can assume in order to publish to the stream. This role must grant access to Amazon Cognito (cognito-sync] to invoke PutRecord on your Cognito stream.', 'PushSync$RoleArn' => '<p>A role configured to allow Cognito to call SNS on behalf of the developer.</p>', ], ], 'Boolean' => [ 'refs' => [ 'ListRecordsResponse$DatasetDeletedAfterRequestedSyncCount' => 'A boolean value specifying whether to delete the dataset locally.', 'ListRecordsResponse$DatasetExists' => 'Indicates whether the dataset exists.', ], ], 'BulkPublishRequest' => [ 'base' => 'The input for the BulkPublish operation.', 'refs' => [], ], 'BulkPublishResponse' => [ 'base' => 'The output for the BulkPublish operation.', 'refs' => [], ], 'BulkPublishStatus' => [ 'refs' => [ 'GetBulkPublishDetailsResponse$BulkPublishStatus' => 'Status of the last bulk publish operation, valid values are: <p>NOT_STARTED - No bulk publish has been requested for this identity pool</p> <p>IN_PROGRESS - Data is being published to the configured stream</p> <p>SUCCEEDED - All data for the identity pool has been published to the configured stream</p> <p>FAILED - Some portion of the data has failed to publish, check FailureMessage for the cause.</p>', ], ], 'ClientContext' => [ 'refs' => [ 'UpdateRecordsRequest$ClientContext' => 'Intended to supply a device ID that will populate the lastModifiedBy field referenced in other methods. The ClientContext field is not yet implemented.', ], ], 'CognitoEventType' => [ 'refs' => [], ], 'CognitoStreams' => [ 'base' => 'Configuration options for configure Cognito streams.', 'refs' => [ 'GetIdentityPoolConfigurationResponse$CognitoStreams' => 'Options to apply to this identity pool for Amazon Cognito streams.', 'SetIdentityPoolConfigurationRequest$CognitoStreams' => 'Options to apply to this identity pool for Amazon Cognito streams.', 'SetIdentityPoolConfigurationResponse$CognitoStreams' => 'Options to apply to this identity pool for Amazon Cognito streams.', ], ], 'ConcurrentModificationException' => [ 'base' => '<p>Thrown if there are parallel requests to modify a resource.</p>', 'refs' => [], ], 'Dataset' => [ 'base' => 'A collection of data for an identity pool. An identity pool can have multiple datasets. A dataset is per identity and can be general or associated with a particular entity in an application (like a saved game]. Datasets are automatically created if they don\'t exist. Data is synced by dataset, and a dataset can hold up to 1MB of key-value pairs.', 'refs' => [ 'DeleteDatasetResponse$Dataset' => 'A collection of data for an identity pool. An identity pool can have multiple datasets. A dataset is per identity and can be general or associated with a particular entity in an application (like a saved game]. Datasets are automatically created if they don\'t exist. Data is synced by dataset, and a dataset can hold up to 1MB of key-value pairs.', 'DescribeDatasetResponse$Dataset' => 'Meta data for a collection of data for an identity. An identity can have multiple datasets. A dataset can be general or associated with a particular entity in an application (like a saved game]. Datasets are automatically created if they don\'t exist. Data is synced by dataset, and a dataset can hold up to 1MB of key-value pairs.', ], ], 'DatasetList' => [ 'refs' => [ 'ListDatasetsResponse$Datasets' => 'A set of datasets.', ], ], 'DatasetName' => [ 'refs' => [ 'Dataset$DatasetName' => 'A string of up to 128 characters. Allowed characters are a-z, A-Z, 0-9, \'_\' (underscore], \'-\' (dash], and \'.\' (dot].', 'DeleteDatasetRequest$DatasetName' => 'A string of up to 128 characters. Allowed characters are a-z, A-Z, 0-9, \'_\' (underscore], \'-\' (dash], and \'.\' (dot].', 'DescribeDatasetRequest$DatasetName' => 'A string of up to 128 characters. Allowed characters are a-z, A-Z, 0-9, \'_\' (underscore], \'-\' (dash], and \'.\' (dot].', 'ListRecordsRequest$DatasetName' => 'A string of up to 128 characters. Allowed characters are a-z, A-Z, 0-9, \'_\' (underscore], \'-\' (dash], and \'.\' (dot].', 'SubscribeToDatasetRequest$DatasetName' => '<p>The name of the dataset to subcribe to.</p>', 'UnsubscribeFromDatasetRequest$DatasetName' => '<p>The name of the dataset from which to unsubcribe.</p>', 'UpdateRecordsRequest$DatasetName' => 'A string of up to 128 characters. Allowed characters are a-z, A-Z, 0-9, \'_\' (underscore], \'-\' (dash], and \'.\' (dot].', ], ], 'Date' => [ 'refs' => [ 'Dataset$CreationDate' => 'Date on which the dataset was created.', 'Dataset$LastModifiedDate' => 'Date when the dataset was last modified.', 'GetBulkPublishDetailsResponse$BulkPublishCompleteTime' => 'If BulkPublishStatus is SUCCEEDED, the time the last bulk publish operation completed.', 'GetBulkPublishDetailsResponse$BulkPublishStartTime' => 'The date/time at which the last bulk publish was initiated.', 'IdentityPoolUsage$LastModifiedDate' => 'Date on which the identity pool was last modified.', 'IdentityUsage$LastModifiedDate' => 'Date on which the identity was last modified.', 'Record$DeviceLastModifiedDate' => 'The last modified date of the client device.', 'Record$LastModifiedDate' => 'The date on which the record was last modified.', 'RecordPatch$DeviceLastModifiedDate' => 'The last modified date of the client device.', ], ], 'DeleteDatasetRequest' => [ 'base' => 'A request to delete the specific dataset.', 'refs' => [], ], 'DeleteDatasetResponse' => [ 'base' => 'Response to a successful DeleteDataset request.', 'refs' => [], ], 'DescribeDatasetRequest' => [ 'base' => 'A request for meta data about a dataset (creation date, number of records, size] by owner and dataset name.', 'refs' => [], ], 'DescribeDatasetResponse' => [ 'base' => 'Response to a successful DescribeDataset request.', 'refs' => [], ], 'DescribeIdentityPoolUsageRequest' => [ 'base' => 'A request for usage information about the identity pool.', 'refs' => [], ], 'DescribeIdentityPoolUsageResponse' => [ 'base' => 'Response to a successful DescribeIdentityPoolUsage request.', 'refs' => [], ], 'DescribeIdentityUsageRequest' => [ 'base' => 'A request for information about the usage of an identity pool.', 'refs' => [], ], 'DescribeIdentityUsageResponse' => [ 'base' => 'The response to a successful DescribeIdentityUsage request.', 'refs' => [], ], 'DeviceId' => [ 'refs' => [ 'RegisterDeviceResponse$DeviceId' => '<p>The unique ID generated for this device by Cognito.</p>', 'SubscribeToDatasetRequest$DeviceId' => '<p>The unique ID generated for this device by Cognito.</p>', 'UnsubscribeFromDatasetRequest$DeviceId' => '<p>The unique ID generated for this device by Cognito.</p>', 'UpdateRecordsRequest$DeviceId' => '<p>The unique ID generated for this device by Cognito.</p>', ], ], 'DuplicateRequestException' => [ 'base' => 'An exception thrown when there is an IN_PROGRESS bulk publish operation for the given identity pool.', 'refs' => [], ], 'Events' => [ 'refs' => [ 'GetCognitoEventsResponse$Events' => '<p>The Cognito Events returned from the GetCognitoEvents request</p>', 'SetCognitoEventsRequest$Events' => '<p>The events to configure</p>', ], ], 'ExceptionMessage' => [ 'refs' => [ 'AlreadyStreamedException$message' => 'The message associated with the AlreadyStreamedException exception.', 'DuplicateRequestException$message' => 'The message associated with the DuplicateRequestException exception.', 'InternalErrorException$message' => 'Message returned by InternalErrorException.', 'InvalidConfigurationException$message' => 'Message returned by InvalidConfigurationException.', 'InvalidLambdaFunctionOutputException$message' => '<p>A message returned when an InvalidLambdaFunctionOutputException occurs</p>', 'InvalidParameterException$message' => 'Message returned by InvalidParameterException.', 'LambdaThrottledException$message' => '<p>A message returned when an LambdaThrottledException is thrown</p>', 'LimitExceededException$message' => 'Message returned by LimitExceededException.', 'NotAuthorizedException$message' => 'The message returned by a NotAuthorizedException.', 'ResourceConflictException$message' => 'The message returned by a ResourceConflictException.', 'ResourceNotFoundException$message' => 'Message returned by a ResourceNotFoundException.', 'TooManyRequestsException$message' => 'Message returned by a TooManyRequestsException.', ], ], 'GetBulkPublishDetailsRequest' => [ 'base' => 'The input for the GetBulkPublishDetails operation.', 'refs' => [], ], 'GetBulkPublishDetailsResponse' => [ 'base' => 'The output for the GetBulkPublishDetails operation.', 'refs' => [], ], 'GetCognitoEventsRequest' => [ 'base' => '<p>A request for a list of the configured Cognito Events</p>', 'refs' => [], ], 'GetCognitoEventsResponse' => [ 'base' => '<p>The response from the GetCognitoEvents request</p>', 'refs' => [], ], 'GetIdentityPoolConfigurationRequest' => [ 'base' => '<p>The input for the GetIdentityPoolConfiguration operation.</p>', 'refs' => [], ], 'GetIdentityPoolConfigurationResponse' => [ 'base' => '<p>The output for the GetIdentityPoolConfiguration operation.</p>', 'refs' => [], ], 'IdentityId' => [ 'refs' => [ 'Dataset$IdentityId' => 'A name-spaced GUID (for example, us-east-1:23EC4050-6AEA-7089-A2DD-08002EXAMPLE] created by Amazon Cognito. GUID generation is unique within a region.', 'DeleteDatasetRequest$IdentityId' => 'A name-spaced GUID (for example, us-east-1:23EC4050-6AEA-7089-A2DD-08002EXAMPLE] created by Amazon Cognito. GUID generation is unique within a region.', 'DescribeDatasetRequest$IdentityId' => 'A name-spaced GUID (for example, us-east-1:23EC4050-6AEA-7089-A2DD-08002EXAMPLE] created by Amazon Cognito. GUID generation is unique within a region.', 'DescribeIdentityUsageRequest$IdentityId' => 'A name-spaced GUID (for example, us-east-1:23EC4050-6AEA-7089-A2DD-08002EXAMPLE] created by Amazon Cognito. GUID generation is unique within a region.', 'IdentityUsage$IdentityId' => 'A name-spaced GUID (for example, us-east-1:23EC4050-6AEA-7089-A2DD-08002EXAMPLE] created by Amazon Cognito. GUID generation is unique within a region.', 'ListDatasetsRequest$IdentityId' => 'A name-spaced GUID (for example, us-east-1:23EC4050-6AEA-7089-A2DD-08002EXAMPLE] created by Amazon Cognito. GUID generation is unique within a region.', 'ListRecordsRequest$IdentityId' => 'A name-spaced GUID (for example, us-east-1:23EC4050-6AEA-7089-A2DD-08002EXAMPLE] created by Amazon Cognito. GUID generation is unique within a region.', 'RegisterDeviceRequest$IdentityId' => '<p>The unique ID for this identity.</p>', 'SubscribeToDatasetRequest$IdentityId' => '<p>Unique ID for this identity.</p>', 'UnsubscribeFromDatasetRequest$IdentityId' => '<p>Unique ID for this identity.</p>', 'UpdateRecordsRequest$IdentityId' => 'A name-spaced GUID (for example, us-east-1:23EC4050-6AEA-7089-A2DD-08002EXAMPLE] created by Amazon Cognito. GUID generation is unique within a region.', ], ], 'IdentityPoolId' => [ 'refs' => [ 'BulkPublishRequest$IdentityPoolId' => 'A name-spaced GUID (for example, us-east-1:23EC4050-6AEA-7089-A2DD-08002EXAMPLE] created by Amazon Cognito. GUID generation is unique within a region.', 'BulkPublishResponse$IdentityPoolId' => 'A name-spaced GUID (for example, us-east-1:23EC4050-6AEA-7089-A2DD-08002EXAMPLE] created by Amazon Cognito. GUID generation is unique within a region.', 'DeleteDatasetRequest$IdentityPoolId' => 'A name-spaced GUID (for example, us-east-1:23EC4050-6AEA-7089-A2DD-08002EXAMPLE] created by Amazon Cognito. GUID generation is unique within a region.', 'DescribeDatasetRequest$IdentityPoolId' => 'A name-spaced GUID (for example, us-east-1:23EC4050-6AEA-7089-A2DD-08002EXAMPLE] created by Amazon Cognito. GUID generation is unique within a region.', 'DescribeIdentityPoolUsageRequest$IdentityPoolId' => 'A name-spaced GUID (for example, us-east-1:23EC4050-6AEA-7089-A2DD-08002EXAMPLE] created by Amazon Cognito. GUID generation is unique within a region.', 'DescribeIdentityUsageRequest$IdentityPoolId' => 'A name-spaced GUID (for example, us-east-1:23EC4050-6AEA-7089-A2DD-08002EXAMPLE] created by Amazon Cognito. GUID generation is unique within a region.', 'GetBulkPublishDetailsRequest$IdentityPoolId' => 'A name-spaced GUID (for example, us-east-1:23EC4050-6AEA-7089-A2DD-08002EXAMPLE] created by Amazon Cognito. GUID generation is unique within a region.', 'GetBulkPublishDetailsResponse$IdentityPoolId' => 'A name-spaced GUID (for example, us-east-1:23EC4050-6AEA-7089-A2DD-08002EXAMPLE] created by Amazon Cognito. GUID generation is unique within a region.', 'GetCognitoEventsRequest$IdentityPoolId' => '<p>The Cognito Identity Pool ID for the request</p>', 'GetIdentityPoolConfigurationRequest$IdentityPoolId' => '<p>A name-spaced GUID (for example, us-east-1:23EC4050-6AEA-7089-A2DD-08002EXAMPLE] created by Amazon Cognito. This is the ID of the pool for which to return a configuration.</p>', 'GetIdentityPoolConfigurationResponse$IdentityPoolId' => '<p>A name-spaced GUID (for example, us-east-1:23EC4050-6AEA-7089-A2DD-08002EXAMPLE] created by Amazon Cognito.</p>', 'IdentityPoolUsage$IdentityPoolId' => 'A name-spaced GUID (for example, us-east-1:23EC4050-6AEA-7089-A2DD-08002EXAMPLE] created by Amazon Cognito. GUID generation is unique within a region.', 'IdentityUsage$IdentityPoolId' => 'A name-spaced GUID (for example, us-east-1:23EC4050-6AEA-7089-A2DD-08002EXAMPLE] created by Amazon Cognito. GUID generation is unique within a region.', 'ListDatasetsRequest$IdentityPoolId' => 'A name-spaced GUID (for example, us-east-1:23EC4050-6AEA-7089-A2DD-08002EXAMPLE] created by Amazon Cognito. GUID generation is unique within a region.', 'ListRecordsRequest$IdentityPoolId' => 'A name-spaced GUID (for example, us-east-1:23EC4050-6AEA-7089-A2DD-08002EXAMPLE] created by Amazon Cognito. GUID generation is unique within a region.', 'RegisterDeviceRequest$IdentityPoolId' => '<p>A name-spaced GUID (for example, us-east-1:23EC4050-6AEA-7089-A2DD-08002EXAMPLE] created by Amazon Cognito. Here, the ID of the pool that the identity belongs to.</p>', 'SetCognitoEventsRequest$IdentityPoolId' => '<p>The Cognito Identity Pool to use when configuring Cognito Events</p>', 'SetIdentityPoolConfigurationRequest$IdentityPoolId' => '<p>A name-spaced GUID (for example, us-east-1:23EC4050-6AEA-7089-A2DD-08002EXAMPLE] created by Amazon Cognito. This is the ID of the pool to modify.</p>', 'SetIdentityPoolConfigurationResponse$IdentityPoolId' => '<p>A name-spaced GUID (for example, us-east-1:23EC4050-6AEA-7089-A2DD-08002EXAMPLE] created by Amazon Cognito.</p>', 'SubscribeToDatasetRequest$IdentityPoolId' => '<p>A name-spaced GUID (for example, us-east-1:23EC4050-6AEA-7089-A2DD-08002EXAMPLE] created by Amazon Cognito. The ID of the pool to which the identity belongs.</p>', 'UnsubscribeFromDatasetRequest$IdentityPoolId' => '<p>A name-spaced GUID (for example, us-east-1:23EC4050-6AEA-7089-A2DD-08002EXAMPLE] created by Amazon Cognito. The ID of the pool to which this identity belongs.</p>', 'UpdateRecordsRequest$IdentityPoolId' => 'A name-spaced GUID (for example, us-east-1:23EC4050-6AEA-7089-A2DD-08002EXAMPLE] created by Amazon Cognito. GUID generation is unique within a region.', ], ], 'IdentityPoolUsage' => [ 'base' => 'Usage information for the identity pool.', 'refs' => [ 'DescribeIdentityPoolUsageResponse$IdentityPoolUsage' => 'Information about the usage of the identity pool.', ], ], 'IdentityPoolUsageList' => [ 'refs' => [ 'ListIdentityPoolUsageResponse$IdentityPoolUsages' => 'Usage information for the identity pools.', ], ], 'IdentityUsage' => [ 'base' => 'Usage information for the identity.', 'refs' => [ 'DescribeIdentityUsageResponse$IdentityUsage' => 'Usage information for the identity.', ], ], 'Integer' => [ 'refs' => [ 'IdentityUsage$DatasetCount' => 'Number of datasets for the identity.', 'ListDatasetsResponse$Count' => 'Number of datasets returned.', 'ListIdentityPoolUsageResponse$Count' => 'Total number of identities for the identity pool.', 'ListIdentityPoolUsageResponse$MaxResults' => 'The maximum number of results to be returned.', 'ListRecordsResponse$Count' => 'Total number of records.', ], ], 'IntegerString' => [ 'refs' => [ 'ListDatasetsRequest$MaxResults' => 'The maximum number of results to be returned.', 'ListIdentityPoolUsageRequest$MaxResults' => 'The maximum number of results to be returned.', 'ListRecordsRequest$MaxResults' => 'The maximum number of results to be returned.', ], ], 'InternalErrorException' => [ 'base' => 'Indicates an internal service error.', 'refs' => [], ], 'InvalidConfigurationException' => [ 'refs' => [], ], 'InvalidLambdaFunctionOutputException' => [ 'base' => '<p>The AWS Lambda function returned invalid output or an exception.</p>', 'refs' => [], ], 'InvalidParameterException' => [ 'base' => 'Thrown when a request parameter does not comply with the associated constraints.', 'refs' => [], ], 'LambdaFunctionArn' => [ 'refs' => [], ], 'LambdaThrottledException' => [ 'base' => '<p>AWS Lambda throttled your account, please contact AWS Support</p>', 'refs' => [], ], 'LimitExceededException' => [ 'base' => 'Thrown when the limit on the number of objects or operations has been exceeded.', 'refs' => [], ], 'ListDatasetsRequest' => [ 'base' => 'Request for a list of datasets for an identity.', 'refs' => [], ], 'ListDatasetsResponse' => [ 'base' => 'Returned for a successful ListDatasets request.', 'refs' => [], ], 'ListIdentityPoolUsageRequest' => [ 'base' => 'A request for usage information on an identity pool.', 'refs' => [], ], 'ListIdentityPoolUsageResponse' => [ 'base' => 'Returned for a successful ListIdentityPoolUsage request.', 'refs' => [], ], 'ListRecordsRequest' => [ 'base' => 'A request for a list of records.', 'refs' => [], ], 'ListRecordsResponse' => [ 'base' => 'Returned for a successful ListRecordsRequest.', 'refs' => [], ], 'Long' => [ 'refs' => [ 'Dataset$DataStorage' => 'Total size in bytes of the records in this dataset.', 'Dataset$NumRecords' => 'Number of records in this dataset.', 'IdentityPoolUsage$DataStorage' => 'Data storage information for the identity pool.', 'IdentityPoolUsage$SyncSessionsCount' => 'Number of sync sessions for the identity pool.', 'IdentityUsage$DataStorage' => 'Total data storage for this identity.', 'ListRecordsRequest$LastSyncCount' => 'The last server sync count for this record.', 'ListRecordsResponse$DatasetSyncCount' => 'Server sync count for this dataset.', 'Record$SyncCount' => 'The server sync count for this record.', 'RecordPatch$SyncCount' => 'Last known server sync count for this record. Set to 0 if unknown.', ], ], 'MergedDatasetNameList' => [ 'refs' => [ 'ListRecordsResponse$MergedDatasetNames' => 'Names of merged datasets.', ], ], 'NotAuthorizedException' => [ 'base' => 'Thrown when a user is not authorized to access the requested resource.', 'refs' => [], ], 'Operation' => [ 'refs' => [ 'RecordPatch$Op' => 'An operation, either replace or remove.', ], ], 'Platform' => [ 'refs' => [ 'RegisterDeviceRequest$Platform' => '<p>The SNS platform type (e.g. GCM, SDM, APNS, APNS_SANDBOX].</p>', ], ], 'PushSync' => [ 'base' => '<p>Configuration options to be applied to the identity pool.</p>', 'refs' => [ 'GetIdentityPoolConfigurationResponse$PushSync' => '<p>Options to apply to this identity pool for push synchronization.</p>', 'SetIdentityPoolConfigurationRequest$PushSync' => '<p>Options to apply to this identity pool for push synchronization.</p>', 'SetIdentityPoolConfigurationResponse$PushSync' => '<p>Options to apply to this identity pool for push synchronization.</p>', ], ], 'PushToken' => [ 'refs' => [ 'RegisterDeviceRequest$Token' => '<p>The push token.</p>', ], ], 'Record' => [ 'base' => 'The basic data structure of a dataset.', 'refs' => [], ], 'RecordKey' => [ 'refs' => [ 'Record$Key' => 'The key for the record.', 'RecordPatch$Key' => 'The key associated with the record patch.', ], ], 'RecordList' => [ 'refs' => [ 'ListRecordsResponse$Records' => 'A list of all records.', 'UpdateRecordsResponse$Records' => 'A list of records that have been updated.', ], ], 'RecordPatch' => [ 'base' => 'An update operation for a record.', 'refs' => [], ], 'RecordPatchList' => [ 'refs' => [ 'UpdateRecordsRequest$RecordPatches' => 'A list of patch operations.', ], ], 'RecordValue' => [ 'refs' => [ 'Record$Value' => 'The value for the record.', 'RecordPatch$Value' => 'The value associated with the record patch.', ], ], 'RegisterDeviceRequest' => [ 'base' => '<p>A request to RegisterDevice.</p>', 'refs' => [], ], 'RegisterDeviceResponse' => [ 'base' => '<p>Response to a RegisterDevice request.</p>', 'refs' => [], ], 'ResourceConflictException' => [ 'base' => 'Thrown if an update can\'t be applied because the resource was changed by another call and this would result in a conflict.', 'refs' => [], ], 'ResourceNotFoundException' => [ 'base' => 'Thrown if the resource doesn\'t exist.', 'refs' => [], ], 'SetCognitoEventsRequest' => [ 'base' => '<p>A request to configure Cognito Events"</p>"', 'refs' => [], ], 'SetIdentityPoolConfigurationRequest' => [ 'base' => '<p>The input for the SetIdentityPoolConfiguration operation.</p>', 'refs' => [], ], 'SetIdentityPoolConfigurationResponse' => [ 'base' => '<p>The output for the SetIdentityPoolConfiguration operation</p>', 'refs' => [], ], 'StreamName' => [ 'refs' => [ 'CognitoStreams$StreamName' => 'The name of the Cognito stream to receive updates. This stream must be in the developers account and in the same region as the identity pool.', ], ], 'StreamingStatus' => [ 'refs' => [ 'CognitoStreams$StreamingStatus' => 'Status of the Cognito streams. Valid values are: <p>ENABLED - Streaming of updates to identity pool is enabled.</p> <p>DISABLED - Streaming of updates to identity pool is disabled. Bulk publish will also fail if StreamingStatus is DISABLED.</p>', ], ], 'String' => [ 'refs' => [ 'ConcurrentModificationException$message' => '<p>The message returned by a ConcurrentModicationException.</p>', 'Dataset$LastModifiedBy' => 'The device that made the last change to this dataset.', 'GetBulkPublishDetailsResponse$FailureMessage' => 'If BulkPublishStatus is FAILED this field will contain the error message that caused the bulk publish to fail.', 'ListDatasetsRequest$NextToken' => 'A pagination token for obtaining the next page of results.', 'ListDatasetsResponse$NextToken' => 'A pagination token for obtaining the next page of results.', 'ListIdentityPoolUsageRequest$NextToken' => 'A pagination token for obtaining the next page of results.', 'ListIdentityPoolUsageResponse$NextToken' => 'A pagination token for obtaining the next page of results.', 'ListRecordsRequest$NextToken' => 'A pagination token for obtaining the next page of results.', 'ListRecordsResponse$LastModifiedBy' => 'The user/device that made the last change to this record.', 'ListRecordsResponse$NextToken' => 'A pagination token for obtaining the next page of results.', 'ListRecordsResponse$SyncSessionToken' => 'A token containing a session ID, identity ID, and expiration.', 'Record$LastModifiedBy' => 'The user/device that made the last change to this record.', ], ], 'SubscribeToDatasetRequest' => [ 'base' => '<p>A request to SubscribeToDatasetRequest.</p>', 'refs' => [], ], 'SubscribeToDatasetResponse' => [ 'base' => '<p>Response to a SubscribeToDataset request.</p>', 'refs' => [], ], 'SyncSessionToken' => [ 'refs' => [ 'ListRecordsRequest$SyncSessionToken' => 'A token containing a session ID, identity ID, and expiration.', 'UpdateRecordsRequest$SyncSessionToken' => 'The SyncSessionToken returned by a previous call to ListRecords for this dataset and identity.', ], ], 'TooManyRequestsException' => [ 'base' => 'Thrown if the request is throttled.', 'refs' => [], ], 'UnsubscribeFromDatasetRequest' => [ 'base' => '<p>A request to UnsubscribeFromDataset.</p>', 'refs' => [], ], 'UnsubscribeFromDatasetResponse' => [ 'base' => '<p>Response to an UnsubscribeFromDataset request.</p>', 'refs' => [], ], 'UpdateRecordsRequest' => [ 'base' => 'A request to post updates to records or add and delete records for a dataset and user.', 'refs' => [], ], 'UpdateRecordsResponse' => [ 'base' => 'Returned for a successful UpdateRecordsRequest.', 'refs' => [], ], ], 'service' => '<fullname>Amazon Cognito Sync</fullname> <p>Amazon Cognito Sync provides an AWS service and client library that enable cross-device syncing of application-related user data. High-level client libraries are available for both iOS and Android. You can use these libraries to persist data locally so that it\'s available even if the device is offline. Developer credentials don\'t need to be stored on the mobile device to access the service. You can use Amazon Cognito to obtain a normalized user ID and credentials. User data is persisted in a dataset that can store up to 1 MB of key-value pairs, and you can have up to 20 datasets per user identity.</p> <p>With Amazon Cognito Sync, the data stored for each identity is accessible only to credentials assigned to that identity. In order to use the Cognito Sync service, you need to make API calls using credentials retrieved with <a href="http://docs.aws.amazon.com/cognitoidentity/latest/APIReference/Welcome.html">Amazon Cognito Identity service</a>.</p> <p>If you want to use Cognito Sync in an Android or iOS application, you will probably want to make API calls via the AWS Mobile SDK. To learn more, see the <a href="http://docs.aws.amazon.com/mobile/sdkforandroid/developerguide/cognito-sync.html">Developer Guide for Android</a> and the <a href="http://docs.aws.amazon.com/mobile/sdkforios/developerguide/cognito-sync.html">Developer Guide for iOS</a>.</p>',];
