<?php
// This file was auto-generated from sdk-root/src/data/elasticloadbalancing/2012-06-01/docs-2.json
return [ 'version' => '2.0', 'operations' => [ 'AddTags' => '<p>Adds the specified tags to the specified load balancer. Each load balancer can have a maximum of 10 tags.</p> <p>Each tag consists of a key and an optional value. If a tag with the same key is already associated with the load balancer, <code>AddTags</code> updates its value.</p> <p>For more information, see <a href="http://docs.aws.amazon.com/ElasticLoadBalancing/latest/DeveloperGuide/add-remove-tags.html">Tag Your Load Balancer</a> in the <i>Elastic Load Balancing Developer Guide</i>.</p>', 'ApplySecurityGroupsToLoadBalancer' => '<p>Associates one or more security groups with your load balancer in a virtual private cloud (VPC]. The specified security groups override the previously associated security groups.</p> <p>For more information, see <a href="http://docs.aws.amazon.com/ElasticLoadBalancing/latest/DeveloperGuide/elb-security-groups.html#elb-vpc-security-groups">Security Groups for Load Balancers in a VPC</a> in the <i>Elastic Load Balancing Developer Guide</i>.</p>', 'AttachLoadBalancerToSubnets' => '<p>Adds one or more subnets to the set of configured subnets for the specified load balancer.</p> <p>The load balancer evenly distributes requests across all registered subnets. For more information, see <a href="http://docs.aws.amazon.com/ElasticLoadBalancing/latest/DeveloperGuide/elb-manage-subnets.html">Add or Remove Subnets for Your Load Balancer in a VPC</a> in the <i>Elastic Load Balancing Developer Guide</i>.</p>', 'ConfigureHealthCheck' => '<p>Specifies the health check settings to use when evaluating the health state of your back-end instances.</p> <p>For more information, see <a href="http://docs.aws.amazon.com/ElasticLoadBalancing/latest/DeveloperGuide/elb-healthchecks.html">Configure Health Checks</a> in the <i>Elastic Load Balancing Developer Guide</i>.</p>', 'CreateAppCookieStickinessPolicy' => '<p>Generates a stickiness policy with sticky session lifetimes that follow that of an application-generated cookie. This policy can be associated only with HTTP/HTTPS listeners.</p> <p>This policy is similar to the policy created by <a>CreateLBCookieStickinessPolicy</a>, except that the lifetime of the special Elastic Load Balancing cookie, <code>AWSELB</code>, follows the lifetime of the application-generated cookie specified in the policy configuration. The load balancer only inserts a new stickiness cookie when the application response includes a new application cookie.</p> <p>If the application cookie is explicitly removed or expires, the session stops being sticky until a new application cookie is issued.</p> <p>For more information, see <a href="http://docs.aws.amazon.com/ElasticLoadBalancing/latest/DeveloperGuide/elb-sticky-sessions.html#enable-sticky-sessions-application">Application-Controlled Session Stickiness</a> in the <i>Elastic Load Balancing Developer Guide</i>.</p>', 'CreateLBCookieStickinessPolicy' => '<p>Generates a stickiness policy with sticky session lifetimes controlled by the lifetime of the browser (user-agent] or a specified expiration period. This policy can be associated only with HTTP/HTTPS listeners.</p> <p>When a load balancer implements this policy, the load balancer uses a special cookie to track the back-end server instance for each request. When the load balancer receives a request, it first checks to see if this cookie is present in the request. If so, the load balancer sends the request to the application server specified in the cookie. If not, the load balancer sends the request to a server that is chosen based on the existing load-balancing algorithm.</p> <p>A cookie is inserted into the response for binding subsequent requests from the same user to that server. The validity of the cookie is based on the cookie expiration time, which is specified in the policy configuration.</p> <p>For more information, see <a href="http://docs.aws.amazon.com/ElasticLoadBalancing/latest/DeveloperGuide/elb-sticky-sessions.html#enable-sticky-sessions-duration">Duration-Based Session Stickiness</a> in the <i>Elastic Load Balancing Developer Guide</i>.</p>', 'CreateLoadBalancer' => '<p>Creates a load balancer.</p> <p>If the call completes successfully, a new load balancer is created with a unique Domain Name Service (DNS] name. The load balancer receives incoming traffic and routes it to the registered instances. For more information, see <a href="http://docs.aws.amazon.com/ElasticLoadBalancing/latest/DeveloperGuide/how-elb-works.html">How Elastic Load Balancing Works</a> in the <i>Elastic Load Balancing Developer Guide</i>.</p> <p>You can create up to 20 load balancers per region per account. You can request an increase for the number of load balancers for your account. For more information, see <a href="http://docs.aws.amazon.com/ElasticLoadBalancing/latest/DeveloperGuide/elb-limits.html">Elastic Load Balancing Limits</a> in the <i>Elastic Load Balancing Developer Guide</i>.</p>', 'CreateLoadBalancerListeners' => '<p>Creates one or more listeners for the specified load balancer. If a listener with the specified port does not already exist, it is created; otherwise, the properties of the new listener must match the properties of the existing listener.</p> <p>For more information, see <a href="http://docs.aws.amazon.com/ElasticLoadBalancing/latest/DeveloperGuide/us-add-listener.html">Add a Listener to Your Load Balancer</a> in the <i>Elastic Load Balancing Developer Guide</i>.</p>', 'CreateLoadBalancerPolicy' => '<p>Creates a policy with the specified attributes for the specified load balancer.</p> <p>Policies are settings that are saved for your load balancer and that can be applied to the front-end listener or the back-end application server, depending on the policy type.</p>', 'DeleteLoadBalancer' => '<p>Deletes the specified load balancer.</p> <p>If you are attempting to recreate a load balancer, you must reconfigure all settings. The DNS name associated with a deleted load balancer are no longer usable. The name and associated DNS record of the deleted load balancer no longer exist and traffic sent to any of its IP addresses is no longer delivered to back-end instances.</p> <p>If the load balancer does not exist or has already been deleted, the call to <code>DeleteLoadBalancer</code> still succeeds.</p>', 'DeleteLoadBalancerListeners' => '<p>Deletes the specified listeners from the specified load balancer.</p>', 'DeleteLoadBalancerPolicy' => '<p>Deletes the specified policy from the specified load balancer. This policy must not be enabled for any listeners.</p>', 'DeregisterInstancesFromLoadBalancer' => '<p>Deregisters the specified instances from the specified load balancer. After the instance is deregistered, it no longer receives traffic from the load balancer.</p> <p>You can use <a>DescribeLoadBalancers</a> to verify that the instance is deregistered from the load balancer.</p> <p>For more information, see <a href="http://docs.aws.amazon.com/ElasticLoadBalancing/latest/DeveloperGuide/US_DeReg_Reg_Instances.html">Deregister and Register Amazon EC2 Instances</a> in the <i>Elastic Load Balancing Developer Guide</i>.</p>', 'DescribeInstanceHealth' => '<p>Describes the state of the specified instances with respect to the specified load balancer. If no instances are specified, the call describes the state of all instances that are currently registered with the load balancer. If instances are specified, their state is returned even if they are no longer registered with the load balancer. The state of terminated instances is not returned.</p>', 'DescribeLoadBalancerAttributes' => '<p>Describes the attributes for the specified load balancer.</p>', 'DescribeLoadBalancerPolicies' => '<p>Describes the specified policies.</p> <p>If you specify a load balancer name, the action returns the descriptions of all policies created for the load balancer. If you specify a policy name associated with your load balancer, the action returns the description of that policy. If you don\'t specify a load balancer name, the action returns descriptions of the specified sample policies, or descriptions of all sample policies. The names of the sample policies have the <code>ELBSample-</code> prefix.</p>', 'DescribeLoadBalancerPolicyTypes' => '<p>Describes the specified load balancer policy types.</p> <p>You can use these policy types with <a>CreateLoadBalancerPolicy</a> to create policy configurations for a load balancer.</p>', 'DescribeLoadBalancers' => '<p>Describes the specified the load balancers. If no load balancers are specified, the call describes all of your load balancers.</p>', 'DescribeTags' => '<p>Describes the tags associated with the specified load balancers.</p>', 'DetachLoadBalancerFromSubnets' => '<p>Removes the specified subnets from the set of configured subnets for the load balancer.</p> <p>After a subnet is removed, all EC2 instances registered with the load balancer in the removed subnet go into the <code>OutOfService</code> state. Then, the load balancer balances the traffic among the remaining routable subnets.</p>', 'DisableAvailabilityZonesForLoadBalancer' => '<p>Removes the specified Availability Zones from the set of Availability Zones for the specified load balancer.</p> <p>There must be at least one Availability Zone registered with a load balancer at all times. After an Availability Zone is removed, all instances registered with the load balancer that are in the removed Availability Zone go into the <code>OutOfService</code> state. Then, the load balancer attempts to equally balance the traffic among its remaining Availability Zones.</p> <p>For more information, see <a href="http://docs.aws.amazon.com/ElasticLoadBalancing/latest/DeveloperGuide/US_ShrinkLBApp04.html">Disable an Availability Zone from a Load-Balanced Application</a> in the <i>Elastic Load Balancing Developer Guide</i>.</p>', 'EnableAvailabilityZonesForLoadBalancer' => '<p>Adds the specified Availability Zones to the set of Availability Zones for the specified load balancer.</p> <p>The load balancer evenly distributes requests across all its registered Availability Zones that contain instances.</p> <p>For more information, see <a href="http://docs.aws.amazon.com/ElasticLoadBalancing/latest/DeveloperGuide/US_AddLBAvailabilityZone.html">Add Availability Zone</a> in the <i>Elastic Load Balancing Developer Guide</i>.</p>', 'ModifyLoadBalancerAttributes' => '<p>Modifies the attributes of the specified load balancer.</p> <p>You can modify the load balancer attributes, such as <code>AccessLogs</code>, <code>ConnectionDraining</code>, and <code>CrossZoneLoadBalancing</code> by either enabling or disabling them. Or, you can modify the load balancer attribute <code>ConnectionSettings</code> by specifying an idle connection timeout value for your load balancer.</p> <p>For more information, see the following in the <i>Elastic Load Balancing Developer Guide</i>:</p> <ul> <li><a href="http://docs.aws.amazon.com/ElasticLoadBalancing/latest/DeveloperGuide/TerminologyandKeyConcepts.html#request-routing">Cross-Zone Load Balancing</a></li> <li><a href="http://docs.aws.amazon.com/ElasticLoadBalancing/latest/DeveloperGuide/TerminologyandKeyConcepts.html#conn-drain">Connection Draining</a></li> <li><a href="http://docs.aws.amazon.com/ElasticLoadBalancing/latest/DeveloperGuide/access-log-collection.html">Access Logs</a></li> <li><a href="http://docs.aws.amazon.com/ElasticLoadBalancing/latest/DeveloperGuide/TerminologyandKeyConcepts.html#idle-timeout">Idle Connection Timeout</a></li> </ul>', 'RegisterInstancesWithLoadBalancer' => '<p>Adds the specified instances to the specified load balancer.</p> <p>The instance must be a running instance in the same network as the load balancer (EC2-Classic or the same VPC]. If you have EC2-Classic instances and a load balancer in a VPC with ClassicLink enabled, you can link the EC2-Classic instances to that VPC and then register the linked EC2-Classic instances with the load balancer in the VPC.</p> <p>Note that <code>RegisterInstanceWithLoadBalancer</code> completes when the request has been registered. Instance registration takes a little time to complete. To check the state of the registered instances, use <a>DescribeLoadBalancers</a> or <a>DescribeInstanceHealth</a>.</p> <p>After the instance is registered, it starts receiving traffic and requests from the load balancer. Any instance that is not in one of the Availability Zones registered for the load balancer is moved to the <code>OutOfService</code> state. If an Availability Zone is added to the load balancer later, any instances registered with the load balancer move to the <code>InService</code> state.</p> <p>If you stop an instance registered with a load balancer and then start it, the IP addresses associated with the instance changes. Elastic Load Balancing cannot recognize the new IP address, which prevents it from routing traffic to the instances. We recommend that you use the following sequence: stop the instance, deregister the instance, start the instance, and then register the instance. To deregister instances from a load balancer, use <a>DeregisterInstancesFromLoadBalancer</a>.</p> <p>For more information, see <a href="http://docs.aws.amazon.com/ElasticLoadBalancing/latest/DeveloperGuide/US_DeReg_Reg_Instances.html">Deregister and Register EC2 Instances</a> in the <i>Elastic Load Balancing Developer Guide</i>.</p>', 'RemoveTags' => '<p>Removes one or more tags from the specified load balancer.</p>', 'SetLoadBalancerListenerSSLCertificate' => '<p>Sets the certificate that terminates the specified listener\'s SSL connections. The specified certificate replaces any prior certificate that was used on the same load balancer and port.</p> <p>For more information about updating your SSL certificate, see <a href="http://docs.aws.amazon.com/ElasticLoadBalancing/latest/DeveloperGuide/US_UpdatingLoadBalancerSSL.html">Updating an SSL Certificate for a Load Balancer</a> in the <i>Elastic Load Balancing Developer Guide</i>.</p>', 'SetLoadBalancerPoliciesForBackendServer' => '<p>Replaces the set of policies associated with the specified port on which the back-end server is listening with a new set of policies. At this time, only the back-end server authentication policy type can be applied to the back-end ports; this policy type is composed of multiple public key policies.</p> <p>Each time you use <code>SetLoadBalancerPoliciesForBackendServer</code> to enable the policies, use the <code>PolicyNames</code> parameter to list the policies that you want to enable.</p> <p>You can use <a>DescribeLoadBalancers</a> or <a>DescribeLoadBalancerPolicies</a> to verify that the policy is associated with the back-end server.</p>', 'SetLoadBalancerPoliciesOfListener' => '<p>Associates, updates, or disables a policy with a listener for the specified load balancer. You can associate multiple policies with a listener.</p>', ], 'shapes' => [ 'AccessLog' => [ 'base' => '<p>Information about the <code>AccessLog</code> attribute.</p>', 'refs' => [ 'LoadBalancerAttributes$AccessLog' => '<p>If enabled, the load balancer captures detailed information of all requests and delivers the information to the Amazon S3 bucket that you specify.</p> <p>For more information, see <a href="http://docs.aws.amazon.com/ElasticLoadBalancing/latest/DeveloperGuide/enable-access-logs.html">Enable Access Logs</a> in the <i>Elastic Load Balancing Developer Guide</i>.</p>', ], ], 'AccessLogEnabled' => [ 'refs' => [ 'AccessLog$Enabled' => '<p>Specifies whether access log is enabled for the load balancer.</p>', ], ], 'AccessLogInterval' => [ 'refs' => [ 'AccessLog$EmitInterval' => '<p>The interval for publishing the access logs. You can specify an interval of either 5 minutes or 60 minutes.</p> <p>Default: 60 minutes</p>', ], ], 'AccessLogPrefix' => [ 'refs' => [ 'AccessLog$S3BucketPrefix' => '<p>The logical hierarchy you created for your Amazon S3 bucket, for example <code>my-bucket-prefix/prod</code>. If the prefix is not provided, the log is placed at the root level of the bucket.</p>', ], ], 'AccessPointName' => [ 'refs' => [ 'AddAvailabilityZonesInput$LoadBalancerName' => '<p>The name of the load balancer.</p>', 'ApplySecurityGroupsToLoadBalancerInput$LoadBalancerName' => '<p>The name of the load balancer.</p>', 'AttachLoadBalancerToSubnetsInput$LoadBalancerName' => '<p>The name of the load balancer.</p>', 'ConfigureHealthCheckInput$LoadBalancerName' => '<p>The name of the load balancer.</p>', 'CreateAccessPointInput$LoadBalancerName' => '<p>The name of the load balancer.</p> <p>This name must be unique within your set of load balancers for the region, must have a maximum of 32 characters, must contain only alphanumeric characters or hyphens, and cannot begin or end with a hyphen.</p>', 'CreateAppCookieStickinessPolicyInput$LoadBalancerName' => '<p>The name of the load balancer.</p>', 'CreateLBCookieStickinessPolicyInput$LoadBalancerName' => '<p>The name of the load balancer.</p>', 'CreateLoadBalancerListenerInput$LoadBalancerName' => '<p>The name of the load balancer.</p>', 'CreateLoadBalancerPolicyInput$LoadBalancerName' => '<p>The name of the load balancer.</p>', 'DeleteAccessPointInput$LoadBalancerName' => '<p>The name of the load balancer.</p>', 'DeleteLoadBalancerListenerInput$LoadBalancerName' => '<p>The name of the load balancer.</p>', 'DeleteLoadBalancerPolicyInput$LoadBalancerName' => '<p>The name of the load balancer.</p>', 'DeregisterEndPointsInput$LoadBalancerName' => '<p>The name of the load balancer.</p>', 'DescribeEndPointStateInput$LoadBalancerName' => '<p>The name of the load balancer.</p>', 'DescribeLoadBalancerAttributesInput$LoadBalancerName' => '<p>The name of the load balancer.</p>', 'DescribeLoadBalancerPoliciesInput$LoadBalancerName' => '<p>The name of the load balancer.</p>', 'DetachLoadBalancerFromSubnetsInput$LoadBalancerName' => '<p>The name of the load balancer.</p>', 'LoadBalancerDescription$LoadBalancerName' => '<p>The name of the load balancer.</p>', 'ModifyLoadBalancerAttributesInput$LoadBalancerName' => '<p>The name of the load balancer.</p>', 'ModifyLoadBalancerAttributesOutput$LoadBalancerName' => '<p>The name of the load balancer.</p>', 'RegisterEndPointsInput$LoadBalancerName' => '<p>The name of the load balancer.</p>', 'RemoveAvailabilityZonesInput$LoadBalancerName' => '<p>The name of the load balancer.</p>', 'SetLoadBalancerListenerSSLCertificateInput$LoadBalancerName' => '<p>The name of the load balancer.</p>', 'SetLoadBalancerPoliciesForBackendServerInput$LoadBalancerName' => '<p>The name of the load balancer.</p>', 'SetLoadBalancerPoliciesOfListenerInput$LoadBalancerName' => '<p>The name of the load balancer.</p>', 'TagDescription$LoadBalancerName' => '<p>The name of the load balancer.</p>', ], ], 'AccessPointNotFoundException' => [ 'base' => '<p>The specified load balancer does not exist.</p>', 'refs' => [], ], 'AccessPointPort' => [ 'refs' => [ 'Listener$LoadBalancerPort' => '<p>The port on which the load balancer is listening. On EC2-VPC, you can specify any port from the range 1-65535. On EC2-Classic, you can specify any port from the following list: 25, 80, 443, 465, 587, 1024-65535.</p>', 'SetLoadBalancerListenerSSLCertificateInput$LoadBalancerPort' => '<p>The port that uses the specified SSL certificate.</p>', 'SetLoadBalancerPoliciesOfListenerInput$LoadBalancerPort' => '<p>The external port of the load balancer for the policy.</p>', ], ], 'AddAvailabilityZonesInput' => [ 'refs' => [], ], 'AddAvailabilityZonesOutput' => [ 'refs' => [], ], 'AddTagsInput' => [ 'refs' => [], ], 'AddTagsOutput' => [ 'refs' => [], ], 'AdditionalAttribute' => [ 'base' => '<p>This data type is reserved.</p>', 'refs' => [], ], 'AdditionalAttributes' => [ 'refs' => [ 'LoadBalancerAttributes$AdditionalAttributes' => '<p>This parameter is reserved.</p>', ], ], 'AppCookieStickinessPolicies' => [ 'refs' => [ 'Policies$AppCookieStickinessPolicies' => '<p>The stickiness policies created using <a>CreateAppCookieStickinessPolicy</a>.</p>', ], ], 'AppCookieStickinessPolicy' => [ 'base' => '<p>Information about a policy for application-controlled session stickiness.</p>', 'refs' => [], ], 'ApplySecurityGroupsToLoadBalancerInput' => [ 'refs' => [], ], 'ApplySecurityGroupsToLoadBalancerOutput' => [ 'refs' => [], ], 'AttachLoadBalancerToSubnetsInput' => [ 'refs' => [], ], 'AttachLoadBalancerToSubnetsOutput' => [ 'refs' => [], ], 'AttributeName' => [ 'refs' => [ 'PolicyAttribute$AttributeName' => '<p>The name of the attribute.</p>', 'PolicyAttributeDescription$AttributeName' => '<p>The name of the attribute.</p>', 'PolicyAttributeTypeDescription$AttributeName' => '<p>The name of the attribute.</p>', ], ], 'AttributeType' => [ 'refs' => [ 'PolicyAttributeTypeDescription$AttributeType' => '<p>The type of the attribute. For example, <code>Boolean</code> or <code>Integer</code>.</p>', ], ], 'AttributeValue' => [ 'refs' => [ 'PolicyAttribute$AttributeValue' => '<p>The value of the attribute.</p>', 'PolicyAttributeDescription$AttributeValue' => '<p>The value of the attribute.</p>', ], ], 'AvailabilityZone' => [ 'refs' => [], ], 'AvailabilityZones' => [ 'refs' => [ 'AddAvailabilityZonesInput$AvailabilityZones' => '<p>The Availability Zones. These must be in the same region as the load balancer.</p>', 'AddAvailabilityZonesOutput$AvailabilityZones' => '<p>The updated list of Availability Zones for the load balancer.</p>', 'CreateAccessPointInput$AvailabilityZones' => '<p>One or more Availability Zones from the same region as the load balancer. Traffic is equally distributed across all specified Availability Zones.</p> <p>You must specify at least one Availability Zone.</p> <p>You can add more Availability Zones after you create the load balancer using <a>EnableAvailabilityZonesForLoadBalancer</a>.</p>', 'LoadBalancerDescription$AvailabilityZones' => '<p>The Availability Zones for the load balancer.</p>', 'RemoveAvailabilityZonesInput$AvailabilityZones' => '<p>The Availability Zones.</p>', 'RemoveAvailabilityZonesOutput$AvailabilityZones' => '<p>The remaining Availability Zones for the load balancer.</p>', ], ], 'BackendServerDescription' => [ 'base' => '<p>Information about the configuration of a back-end server.</p>', 'refs' => [], ], 'BackendServerDescriptions' => [ 'refs' => [ 'LoadBalancerDescription$BackendServerDescriptions' => '<p>Information about the back-end servers.</p>', ], ], 'Cardinality' => [ 'refs' => [ 'PolicyAttributeTypeDescription$Cardinality' => '<p>The cardinality of the attribute.</p> <p>Valid values:</p> <ul> <li>ONE(1] : Single value required</li> <li>ZERO_OR_ONE(0..1] : Up to one value can be supplied</li> <li>ZERO_OR_MORE(0..*] : Optional. Multiple values are allowed</li> <li>ONE_OR_MORE(1..*0] : Required. Multiple values are allowed</li> </ul>', ], ], 'CertificateNotFoundException' => [ 'base' => '<p>The specified SSL ID does not refer to a valid SSL certificate in AWS Identity and Access Management (IAM].</p>', 'refs' => [], ], 'ConfigureHealthCheckInput' => [ 'refs' => [], ], 'ConfigureHealthCheckOutput' => [ 'refs' => [], ], 'ConnectionDraining' => [ 'base' => '<p>Information about the <code>ConnectionDraining</code> attribute.</p>', 'refs' => [ 'LoadBalancerAttributes$ConnectionDraining' => '<p>If enabled, the load balancer allows existing requests to complete before the load balancer shifts traffic away from a deregistered or unhealthy back-end instance.</p> <p>For more information, see <a href="http://docs.aws.amazon.com/ElasticLoadBalancing/latest/DeveloperGuide/config-conn-drain.html">Enable Connection Draining</a> in the <i>Elastic Load Balancing Developer Guide</i>.</p>', ], ], 'ConnectionDrainingEnabled' => [ 'refs' => [ 'ConnectionDraining$Enabled' => '<p>Specifies whether connection draining is enabled for the load balancer.</p>', ], ], 'ConnectionDrainingTimeout' => [ 'refs' => [ 'ConnectionDraining$Timeout' => '<p>The maximum time, in seconds, to keep the existing connections open before deregistering the instances.</p>', ], ], 'ConnectionSettings' => [ 'base' => '<p>Information about the <code>ConnectionSettings</code> attribute.</p>', 'refs' => [ 'LoadBalancerAttributes$ConnectionSettings' => '<p>If enabled, the load balancer allows the connections to remain idle (no data is sent over the connection] for the specified duration.</p> <p>By default, Elastic Load Balancing maintains a 60-second idle connection timeout for both front-end and back-end connections of your load balancer. For more information, see <a href="http://docs.aws.amazon.com/ElasticLoadBalancing/latest/DeveloperGuide/config-idle-timeout.html">Configure Idle Connection Timeout</a> in the <i>Elastic Load Balancing Developer Guide</i>.</p>', ], ], 'CookieExpirationPeriod' => [ 'refs' => [ 'CreateLBCookieStickinessPolicyInput$CookieExpirationPeriod' => '<p>The time period, in seconds, after which the cookie should be considered stale. If you do not specify this parameter, the sticky session lasts for the duration of the browser session.</p>', 'LBCookieStickinessPolicy$CookieExpirationPeriod' => '<p>The time period, in seconds, after which the cookie should be considered stale. If this parameter is not specified, the stickiness session lasts for the duration of the browser session.</p>', ], ], 'CookieName' => [ 'refs' => [ 'AppCookieStickinessPolicy$CookieName' => '<p>The name of the application cookie used for stickiness.</p>', 'CreateAppCookieStickinessPolicyInput$CookieName' => '<p>The name of the application cookie used for stickiness.</p>', ], ], 'CreateAccessPointInput' => [ 'refs' => [], ], 'CreateAccessPointOutput' => [ 'refs' => [], ], 'CreateAppCookieStickinessPolicyInput' => [ 'refs' => [], ], 'CreateAppCookieStickinessPolicyOutput' => [ 'refs' => [], ], 'CreateLBCookieStickinessPolicyInput' => [ 'refs' => [], ], 'CreateLBCookieStickinessPolicyOutput' => [ 'refs' => [], ], 'CreateLoadBalancerListenerInput' => [ 'refs' => [], ], 'CreateLoadBalancerListenerOutput' => [ 'refs' => [], ], 'CreateLoadBalancerPolicyInput' => [ 'refs' => [], ], 'CreateLoadBalancerPolicyOutput' => [ 'refs' => [], ], 'CreatedTime' => [ 'refs' => [ 'LoadBalancerDescription$CreatedTime' => '<p>The date and time the load balancer was created.</p>', ], ], 'CrossZoneLoadBalancing' => [ 'base' => '<p>Information about the <code>CrossZoneLoadBalancing</code> attribute.</p>', 'refs' => [ 'LoadBalancerAttributes$CrossZoneLoadBalancing' => '<p>If enabled, the load balancer routes the request traffic evenly across all back-end instances regardless of the Availability Zones.</p> <p>For more information, see <a href="http://docs.aws.amazon.com/ElasticLoadBalancing/latest/DeveloperGuide/enable-disable-crosszone-lb.html">Enable Cross-Zone Load Balancing</a> in the <i>Elastic Load Balancing Developer Guide</i>.</p>', ], ], 'CrossZoneLoadBalancingEnabled' => [ 'refs' => [ 'CrossZoneLoadBalancing$Enabled' => '<p>Specifies whether cross-zone load balancing is enabled for the load balancer.</p>', ], ], 'DNSName' => [ 'refs' => [ 'CreateAccessPointOutput$DNSName' => '<p>The DNS name of the load balancer.</p>', 'LoadBalancerDescription$CanonicalHostedZoneName' => '<p>The Amazon Route 53 hosted zone associated with the load balancer.</p> <p>For more information, see <a href="http://docs.aws.amazon.com/ElasticLoadBalancing/latest/DeveloperGuide/using-domain-names-with-elb.html">Using Domain Names With Elastic Load Balancing</a> in the <i>Elastic Load Balancing Developer Guide</i>.</p>', 'LoadBalancerDescription$CanonicalHostedZoneNameID' => '<p>The ID of the Amazon Route 53 hosted zone name associated with the load balancer.</p>', 'LoadBalancerDescription$DNSName' => '<p>The external DNS name of the load balancer.</p>', ], ], 'DefaultValue' => [ 'refs' => [ 'PolicyAttributeTypeDescription$DefaultValue' => '<p>The default value of the attribute, if applicable.</p>', ], ], 'DeleteAccessPointInput' => [ 'refs' => [], ], 'DeleteAccessPointOutput' => [ 'refs' => [], ], 'DeleteLoadBalancerListenerInput' => [ 'refs' => [], ], 'DeleteLoadBalancerListenerOutput' => [ 'refs' => [], ], 'DeleteLoadBalancerPolicyInput' => [ 'base' => '=', 'refs' => [], ], 'DeleteLoadBalancerPolicyOutput' => [ 'refs' => [], ], 'DeregisterEndPointsInput' => [ 'refs' => [], ], 'DeregisterEndPointsOutput' => [ 'refs' => [], ], 'DescribeAccessPointsInput' => [ 'refs' => [], ], 'DescribeAccessPointsOutput' => [ 'refs' => [], ], 'DescribeEndPointStateInput' => [ 'refs' => [], ], 'DescribeEndPointStateOutput' => [ 'refs' => [], ], 'DescribeLoadBalancerAttributesInput' => [ 'refs' => [], ], 'DescribeLoadBalancerAttributesOutput' => [ 'refs' => [], ], 'DescribeLoadBalancerPoliciesInput' => [ 'refs' => [], ], 'DescribeLoadBalancerPoliciesOutput' => [ 'refs' => [], ], 'DescribeLoadBalancerPolicyTypesInput' => [ 'refs' => [], ], 'DescribeLoadBalancerPolicyTypesOutput' => [ 'refs' => [], ], 'DescribeTagsInput' => [ 'refs' => [], ], 'DescribeTagsOutput' => [ 'refs' => [], ], 'Description' => [ 'refs' => [ 'InstanceState$Description' => '<p>A description of the instance state. This string can contain one or more of the following messages.</p> <ul> <li> <p><code>N/A</code></p> </li> <li> <p><code>A transient error occurred. Please try again later.</code></p> </li> <li> <p><code>Instance has failed at least the UnhealthyThreshold number of health checks consecutively.</code></p> </li> <li> <p><code>Instance has not passed the configured HealthyThreshold number of health checks consecutively.</code></p> </li> <li> <p><code>Instance registration is still in progress.</code></p> </li> <li> <p><code>Instance is in the EC2 Availability Zone for which LoadBalancer is not configured to route traffic to.</code></p> </li> <li> <p><code>Instance is not currently registered with the LoadBalancer.</code></p> </li> <li> <p><code>Instance deregistration currently in progress.</code></p> </li> <li> <p><code>Disable Availability Zone is currently in progress.</code></p> </li> <li> <p><code>Instance is in pending state.</code></p> </li> <li> <p><code>Instance is in stopped state.</code></p> </li> <li> <p><code>Instance is in terminated state.</code></p> </li> </ul>', 'PolicyAttributeTypeDescription$Description' => '<p>A description of the attribute.</p>', 'PolicyTypeDescription$Description' => '<p>A description of the policy type.</p>', ], ], 'DetachLoadBalancerFromSubnetsInput' => [ 'refs' => [], ], 'DetachLoadBalancerFromSubnetsOutput' => [ 'refs' => [], ], 'DuplicateAccessPointNameException' => [ 'base' => '<p>The specified load balancer name already exists for this account.</p>', 'refs' => [], ], 'DuplicateListenerException' => [ 'base' => '<p>A listener already exists for the specified <code>LoadBalancerName</code> and <code>LoadBalancerPort</code>, but with a different <code>InstancePort</code>, <code>Protocol</code>, or <code>SSLCertificateId</code>.</p>', 'refs' => [], ], 'DuplicatePolicyNameException' => [ 'base' => '<p>A policy with the specified name already exists for this load balancer.</p>', 'refs' => [], ], 'DuplicateTagKeysException' => [ 'base' => '<p>A tag key was specified more than once.</p>', 'refs' => [], ], 'EndPointPort' => [ 'refs' => [ 'SetLoadBalancerPoliciesForBackendServerInput$InstancePort' => '<p>The port number associated with the back-end server.</p>', ], ], 'HealthCheck' => [ 'base' => '<p>Information about a health check.</p>', 'refs' => [ 'ConfigureHealthCheckInput$HealthCheck' => '<p>The configuration information for the new health check.</p>', 'ConfigureHealthCheckOutput$HealthCheck' => '<p>The updated health check.</p>', 'LoadBalancerDescription$HealthCheck' => '<p>Information about the health checks conducted on the load balancer.</p>', ], ], 'HealthCheckInterval' => [ 'refs' => [ 'HealthCheck$Interval' => '<p>The approximate interval, in seconds, between health checks of an individual instance.</p>', ], ], 'HealthCheckTarget' => [ 'refs' => [ 'HealthCheck$Target' => '<p>The instance being checked. The protocol is either TCP, HTTP, HTTPS, or SSL. The range of valid ports is one (1] through 65535.</p> <p>TCP is the default, specified as a TCP: port pair, for example "TCP:5000". In this case, a health check simply attempts to open a TCP connection to the instance on the specified port. Failure to connect within the configured timeout is considered unhealthy.</p> <p>SSL is also specified as SSL: port pair, for example, SSL:5000.</p> <p>For HTTP/HTTPS, you must include a ping path in the string. HTTP is specified as a HTTP:port;/;PathToPing; grouping, for example "HTTP:80/weather/us/wa/seattle". In this case, a HTTP GET request is issued to the instance on the given port and path. Any answer other than "200 OK" within the timeout period is considered unhealthy.</p> <p>The total length of the HTTP ping target must be 1024 16-bit Unicode characters or less.</p>', ], ], 'HealthCheckTimeout' => [ 'refs' => [ 'HealthCheck$Timeout' => '<p>The amount of time, in seconds, during which no response means a failed health check.</p> <p>This value must be less than the <code>Interval</code> value.</p>', ], ], 'HealthyThreshold' => [ 'refs' => [ 'HealthCheck$HealthyThreshold' => '<p>The number of consecutive health checks successes required before moving the instance to the <code>Healthy</code> state.</p>', ], ], 'IdleTimeout' => [ 'refs' => [ 'ConnectionSettings$IdleTimeout' => '<p>The time, in seconds, that the connection is allowed to be idle (no data has been sent over the connection] before it is closed by the load balancer.</p>', ], ], 'Instance' => [ 'base' => '<p>The ID of a back-end instance.</p>', 'refs' => [], ], 'InstanceId' => [ 'refs' => [ 'Instance$InstanceId' => '<p>The ID of the instance.</p>', 'InstanceState$InstanceId' => '<p>The ID of the instance.</p>', ], ], 'InstancePort' => [ 'refs' => [ 'BackendServerDescription$InstancePort' => '<p>The port on which the back-end server is listening.</p>', 'Listener$InstancePort' => '<p>The port on which the instance is listening.</p>', ], ], 'InstanceState' => [ 'base' => '<p>Information about the state of a back-end instance.</p>', 'refs' => [], ], 'InstanceStates' => [ 'refs' => [ 'DescribeEndPointStateOutput$InstanceStates' => '<p>Information about the health of the instances.</p>', ], ], 'Instances' => [ 'refs' => [ 'DeregisterEndPointsInput$Instances' => '<p>The IDs of the instances.</p>', 'DeregisterEndPointsOutput$Instances' => '<p>The remaining instances registered with the load balancer.</p>', 'DescribeEndPointStateInput$Instances' => '<p>The IDs of the instances.</p>', 'LoadBalancerDescription$Instances' => '<p>The IDs of the instances for the load balancer.</p>', 'RegisterEndPointsInput$Instances' => '<p>The IDs of the instances.</p>', 'RegisterEndPointsOutput$Instances' => '<p>The updated list of instances for the load balancer.</p>', ], ], 'InvalidConfigurationRequestException' => [ 'base' => '<p>The requested configuration change is not valid.</p>', 'refs' => [], ], 'InvalidEndPointException' => [ 'base' => '<p>The specified endpoint is not valid.</p>', 'refs' => [], ], 'InvalidSchemeException' => [ 'base' => '<p>The specified value for the schema is not valid. You can only specify a scheme for load balancers in a VPC.</p>', 'refs' => [], ], 'InvalidSecurityGroupException' => [ 'base' => '<p>One or more of the specified security groups do not exist.</p>', 'refs' => [], ], 'InvalidSubnetException' => [ 'base' => '<p>The specified VPC has no associated Internet gateway.</p>', 'refs' => [], ], 'LBCookieStickinessPolicies' => [ 'refs' => [ 'Policies$LBCookieStickinessPolicies' => '<p>The stickiness policies created using <a>CreateLBCookieStickinessPolicy</a>.</p>', ], ], 'LBCookieStickinessPolicy' => [ 'base' => '<p>Information about a policy for duration-based session stickiness.</p>', 'refs' => [], ], 'Listener' => [ 'base' => '<p>Information about a listener.</p> <p>For information about the protocols and the ports supported by Elastic Load Balancing, see <a href="http://docs.aws.amazon.com/ElasticLoadBalancing/latest/DeveloperGuide/elb-listener-config.html">Listener Configurations for Elastic Load Balancing</a> in the <i>Elastic Load Balancing Developer Guide</i>.</p>', 'refs' => [], ], 'ListenerDescription' => [ 'base' => '<p>The policies enabled for a listener.</p>', 'refs' => [], ], 'ListenerDescriptions' => [ 'refs' => [ 'LoadBalancerDescription$ListenerDescriptions' => '<p>The listeners for the load balancer.</p>', ], ], 'ListenerNotFoundException' => [ 'base' => '<p>The load balancer does not have a listener configured at the specified port.</p>', 'refs' => [], ], 'Listeners' => [ 'refs' => [ 'CreateAccessPointInput$Listeners' => '<p>The listeners.</p> <p>For more information, see <a href="http://docs.aws.amazon.com/ElasticLoadBalancing/latest/DeveloperGuide/elb-listener-config.html">Listeners for Your Load Balancer</a> in the <i>Elastic Load Balancing Developer Guide</i>.</p>', 'CreateLoadBalancerListenerInput$Listeners' => '<p>The listeners.</p>', ], ], 'LoadBalancerAttributeNotFoundException' => [ 'base' => '<p>The specified load balancer attribute does not exist.</p>', 'refs' => [], ], 'LoadBalancerAttributes' => [ 'base' => '<p>The attributes for a load balancer.</p>', 'refs' => [ 'DescribeLoadBalancerAttributesOutput$LoadBalancerAttributes' => '<p>Information about the load balancer attributes.</p>', 'ModifyLoadBalancerAttributesInput$LoadBalancerAttributes' => '<p>The attributes of the load balancer.</p>', ], ], 'LoadBalancerDescription' => [ 'base' => '<p>Information about a load balancer.</p>', 'refs' => [], ], 'LoadBalancerDescriptions' => [ 'refs' => [ 'DescribeAccessPointsOutput$LoadBalancerDescriptions' => '<p>Information about the load balancers.</p>', ], ], 'LoadBalancerNames' => [ 'refs' => [ 'AddTagsInput$LoadBalancerNames' => '<p>The name of the load balancer. You can specify one load balancer only.</p>', 'DescribeAccessPointsInput$LoadBalancerNames' => '<p>The names of the load balancers.</p>', 'RemoveTagsInput$LoadBalancerNames' => '<p>The name of the load balancer. You can specify a maximum of one load balancer name.</p>', ], ], 'LoadBalancerNamesMax20' => [ 'refs' => [ 'DescribeTagsInput$LoadBalancerNames' => '<p>The names of the load balancers.</p>', ], ], 'LoadBalancerScheme' => [ 'refs' => [ 'CreateAccessPointInput$Scheme' => '<p>The type of a load balancer. Valid only for load balancers in a VPC.</p> <p>By default, Elastic Load Balancing creates an Internet-facing load balancer with a publicly resolvable DNS name, which resolves to public IP addresses. For more information about Internet-facing and Internal load balancers, see <a href="http://docs.aws.amazon.com/ElasticLoadBalancing/latest/DeveloperGuide/vpc-loadbalancer-types.html">Internet-facing and Internal Load Balancers</a> in the <i>Elastic Load Balancing Developer Guide</i>.</p> <p>Specify <code>internal</code> to create an internal load balancer with a DNS name that resolves to private IP addresses.</p>', 'LoadBalancerDescription$Scheme' => '<p>The type of load balancer. Valid only for load balancers in a VPC.</p> <p>If <code>Scheme</code> is <code>internet-facing</code>, the load balancer has a public DNS name that resolves to a public IP address.</p> <p>If <code>Scheme</code> is <code>internal</code>, the load balancer has a public DNS name that resolves to a private IP address.</p>', ], ], 'Marker' => [ 'refs' => [ 'DescribeAccessPointsInput$Marker' => '<p>The marker for the next set of results. (You received this marker from a previous call.]</p>', 'DescribeAccessPointsOutput$NextMarker' => '<p>The marker to use when requesting the next set of results. If there are no additional results, the string is empty.</p>', ], ], 'ModifyLoadBalancerAttributesInput' => [ 'refs' => [], ], 'ModifyLoadBalancerAttributesOutput' => [ 'refs' => [], ], 'PageSize' => [ 'refs' => [ 'DescribeAccessPointsInput$PageSize' => '<p>The maximum number of results to return with this call (a number from 1 to 400]. The default is 400.</p>', ], ], 'Policies' => [ 'base' => '<p>The policies for a load balancer.</p>', 'refs' => [ 'LoadBalancerDescription$Policies' => '<p>The policies defined for the load balancer.</p>', ], ], 'PolicyAttribute' => [ 'base' => '<p>Information about a policy attribute.</p>', 'refs' => [], ], 'PolicyAttributeDescription' => [ 'base' => '<p>Information about a policy attribute.</p>', 'refs' => [], ], 'PolicyAttributeDescriptions' => [ 'refs' => [ 'PolicyDescription$PolicyAttributeDescriptions' => '<p>The policy attributes.</p>', ], ], 'PolicyAttributeTypeDescription' => [ 'base' => '<p>Information about a policy attribute type.</p>', 'refs' => [], ], 'PolicyAttributeTypeDescriptions' => [ 'refs' => [ 'PolicyTypeDescription$PolicyAttributeTypeDescriptions' => '<p>The description of the policy attributes associated with the policies defined by Elastic Load Balancing.</p>', ], ], 'PolicyAttributes' => [ 'refs' => [ 'CreateLoadBalancerPolicyInput$PolicyAttributes' => '<p>The attributes for the policy.</p>', ], ], 'PolicyDescription' => [ 'base' => '<p>Information about a policy.</p>', 'refs' => [], ], 'PolicyDescriptions' => [ 'refs' => [ 'DescribeLoadBalancerPoliciesOutput$PolicyDescriptions' => '<p>Information about the policies.</p>', ], ], 'PolicyName' => [ 'refs' => [ 'AppCookieStickinessPolicy$PolicyName' => '<p>The mnemonic name for the policy being created. The name must be unique within a set of policies for this load balancer.</p>', 'CreateAppCookieStickinessPolicyInput$PolicyName' => '<p>The name of the policy being created. Policy names must consist of alphanumeric characters and dashes (-]. This name must be unique within the set of policies for this load balancer.</p>', 'CreateLBCookieStickinessPolicyInput$PolicyName' => '<p>The name of the policy being created. Policy names must consist of alphanumeric characters and dashes (-]. This name must be unique within the set of policies for this load balancer.</p>', 'CreateLoadBalancerPolicyInput$PolicyName' => '<p>The name of the load balancer policy to be created. This name must be unique within the set of policies for this load balancer.</p>', 'DeleteLoadBalancerPolicyInput$PolicyName' => '<p>The name of the policy.</p>', 'LBCookieStickinessPolicy$PolicyName' => '<p>The name for the policy being created. The name must be unique within the set of policies for this load balancer.</p>', 'PolicyDescription$PolicyName' => '<p>The name of the policy.</p>', ], ], 'PolicyNames' => [ 'refs' => [ 'BackendServerDescription$PolicyNames' => '<p>The names of the policies enabled for the back-end server.</p>', 'DescribeLoadBalancerPoliciesInput$PolicyNames' => '<p>The names of the policies.</p>', 'ListenerDescription$PolicyNames' => '<p>The policies. If there are no policies enabled, the list is empty.</p>', 'Policies$OtherPolicies' => '<p>The policies other than the stickiness policies.</p>', 'SetLoadBalancerPoliciesForBackendServerInput$PolicyNames' => '<p>The names of the policies. If the list is empty, then all current polices are removed from the back-end server.</p>', 'SetLoadBalancerPoliciesOfListenerInput$PolicyNames' => '<p>The names of the policies. If the list is empty, the current policy is removed from the listener.</p>', ], ], 'PolicyNotFoundException' => [ 'base' => '<p>One or more of the specified policies do not exist.</p>', 'refs' => [], ], 'PolicyTypeDescription' => [ 'base' => '<p>Information about a policy type.</p>', 'refs' => [], ], 'PolicyTypeDescriptions' => [ 'refs' => [ 'DescribeLoadBalancerPolicyTypesOutput$PolicyTypeDescriptions' => '<p>Information about the policy types.</p>', ], ], 'PolicyTypeName' => [ 'refs' => [ 'CreateLoadBalancerPolicyInput$PolicyTypeName' => '<p>The name of the base policy type. To get the list of policy types, use <a>DescribeLoadBalancerPolicyTypes</a>.</p>', 'PolicyDescription$PolicyTypeName' => '<p>The name of the policy type.</p>', 'PolicyTypeDescription$PolicyTypeName' => '<p>The name of the policy type.</p>', ], ], 'PolicyTypeNames' => [ 'refs' => [ 'DescribeLoadBalancerPolicyTypesInput$PolicyTypeNames' => '<p>The names of the policy types. If no names are specified, describes all policy types defined by Elastic Load Balancing.</p>', ], ], 'PolicyTypeNotFoundException' => [ 'base' => '<p>One or more of the specified policy types do not exist.</p>', 'refs' => [], ], 'Ports' => [ 'refs' => [ 'DeleteLoadBalancerListenerInput$LoadBalancerPorts' => '<p>The client port numbers of the listeners.</p>', ], ], 'Protocol' => [ 'refs' => [ 'Listener$InstanceProtocol' => '<p>The protocol to use for routing traffic to back-end instances: HTTP, HTTPS, TCP, or SSL.</p> <p>If the front-end protocol is HTTP, HTTPS, TCP, or SSL, <code>InstanceProtocol</code> must be at the same protocol.</p> <p>If there is another listener with the same <code>InstancePort</code> whose <code>InstanceProtocol</code> is secure, (HTTPS or SSL], the listener\'s <code>InstanceProtocol</code> must also be secure.</p> <p>If there is another listener with the same <code>InstancePort</code> whose <code>InstanceProtocol</code> is HTTP or TCP, the listener\'s <code>InstanceProtocol</code> must be HTTP or TCP.</p>', 'Listener$Protocol' => '<p>The load balancer transport protocol to use for routing: HTTP, HTTPS, TCP, or SSL.</p>', ], ], 'ReasonCode' => [ 'refs' => [ 'InstanceState$ReasonCode' => '<p>Information about the cause of <code>OutOfService</code> instances. Specifically, whether the cause is Elastic Load Balancing or the instance.</p> <p>Valid values: <code>ELB</code> | <code>Instance</code> | <code>N/A</code></p>', ], ], 'RegisterEndPointsInput' => [ 'refs' => [], ], 'RegisterEndPointsOutput' => [ 'refs' => [], ], 'RemoveAvailabilityZonesInput' => [ 'refs' => [], ], 'RemoveAvailabilityZonesOutput' => [ 'refs' => [], ], 'RemoveTagsInput' => [ 'refs' => [], ], 'RemoveTagsOutput' => [ 'refs' => [], ], 'S3BucketName' => [ 'refs' => [ 'AccessLog$S3BucketName' => '<p>The name of the Amazon S3 bucket where the access logs are stored.</p>', ], ], 'SSLCertificateId' => [ 'refs' => [ 'Listener$SSLCertificateId' => '<p>The Amazon Resource Name (ARN] of the server certificate.</p>', 'SetLoadBalancerListenerSSLCertificateInput$SSLCertificateId' => '<p>The Amazon Resource Name (ARN] of the SSL certificate.</p>', ], ], 'SecurityGroupId' => [ 'refs' => [], ], 'SecurityGroupName' => [ 'refs' => [ 'SourceSecurityGroup$GroupName' => '<p>The name of the security group.</p>', ], ], 'SecurityGroupOwnerAlias' => [ 'refs' => [ 'SourceSecurityGroup$OwnerAlias' => '<p>The owner of the security group.</p>', ], ], 'SecurityGroups' => [ 'refs' => [ 'ApplySecurityGroupsToLoadBalancerInput$SecurityGroups' => '<p>The IDs of the security groups to associate with the load balancer. Note that you cannot specify the name of the security group.</p>', 'ApplySecurityGroupsToLoadBalancerOutput$SecurityGroups' => '<p>The IDs of the security groups associated with the load balancer.</p>', 'CreateAccessPointInput$SecurityGroups' => '<p>The IDs of the security groups to assign to the load balancer.</p>', 'LoadBalancerDescription$SecurityGroups' => '<p>The security groups for the load balancer. Valid only for load balancers in a VPC.</p>', ], ], 'SetLoadBalancerListenerSSLCertificateInput' => [ 'refs' => [], ], 'SetLoadBalancerListenerSSLCertificateOutput' => [ 'refs' => [], ], 'SetLoadBalancerPoliciesForBackendServerInput' => [ 'refs' => [], ], 'SetLoadBalancerPoliciesForBackendServerOutput' => [ 'refs' => [], ], 'SetLoadBalancerPoliciesOfListenerInput' => [ 'refs' => [], ], 'SetLoadBalancerPoliciesOfListenerOutput' => [ 'refs' => [], ], 'SourceSecurityGroup' => [ 'base' => '<p>Information about a source security group.</p>', 'refs' => [ 'LoadBalancerDescription$SourceSecurityGroup' => '<p>The security group that you can use as part of your inbound rules for your load balancer\'s back-end application instances. To only allow traffic from load balancers, add a security group rule to your back end instance that specifies this source security group as the inbound source.</p>', ], ], 'State' => [ 'refs' => [ 'InstanceState$State' => '<p>The current state of the instance.</p> <p>Valid values: <code>InService</code> | <code>OutOfService</code> | <code>Unknown</code></p>', ], ], 'StringVal' => [ 'refs' => [ 'AdditionalAttribute$Key' => '<p>This parameter is reserved.</p>', 'AdditionalAttribute$Value' => '<p>This parameter is reserved.</p>', ], ], 'SubnetId' => [ 'refs' => [], ], 'SubnetNotFoundException' => [ 'base' => '<p>One or more of the specified subnets do not exist.</p>', 'refs' => [], ], 'Subnets' => [ 'refs' => [ 'AttachLoadBalancerToSubnetsInput$Subnets' => '<p>The IDs of the subnets to add for the load balancer. You can add only one subnet per Availability Zone.</p>', 'AttachLoadBalancerToSubnetsOutput$Subnets' => '<p>The IDs of the subnets attached to the load balancer.</p>', 'CreateAccessPointInput$Subnets' => '<p>The IDs of the subnets in your VPC to attach to the load balancer. Specify one subnet per Availability Zone specified in <code>AvailabilityZones</code>.</p>', 'DetachLoadBalancerFromSubnetsInput$Subnets' => '<p>The IDs of the subnets.</p>', 'DetachLoadBalancerFromSubnetsOutput$Subnets' => '<p>The IDs of the remaining subnets for the load balancer.</p>', 'LoadBalancerDescription$Subnets' => '<p>The IDs of the subnets for the load balancer.</p>', ], ], 'Tag' => [ 'base' => '<p>Information about a tag.</p>', 'refs' => [], ], 'TagDescription' => [ 'base' => '<p>The tags associated with a load balancer.</p>', 'refs' => [], ], 'TagDescriptions' => [ 'refs' => [ 'DescribeTagsOutput$TagDescriptions' => '<p>Information about the tags.</p>', ], ], 'TagKey' => [ 'refs' => [ 'Tag$Key' => '<p>The key of the tag.</p>', 'TagKeyOnly$Key' => '<p>The name of the key.</p>', ], ], 'TagKeyList' => [ 'refs' => [ 'RemoveTagsInput$Tags' => '<p>The list of tag keys to remove.</p>', ], ], 'TagKeyOnly' => [ 'base' => '<p>The key of a tag.</p>', 'refs' => [], ], 'TagList' => [ 'refs' => [ 'AddTagsInput$Tags' => '<p>The tags.</p>', 'CreateAccessPointInput$Tags' => '<p>A list of tags to assign to the load balancer.</p> <p>For more information about tagging your load balancer, see <a href="http://docs.aws.amazon.com/ElasticLoadBalancing/latest/DeveloperGuide/TerminologyandKeyConcepts.html#tagging-elb">Tagging</a> in the <i>Elastic Load Balancing Developer Guide</i>.</p>', 'TagDescription$Tags' => '<p>The tags.</p>', ], ], 'TagValue' => [ 'refs' => [ 'Tag$Value' => '<p>The value of the tag.</p>', ], ], 'TooManyAccessPointsException' => [ 'base' => '<p>The quota for the number of load balancers has been reached.</p>', 'refs' => [], ], 'TooManyPoliciesException' => [ 'base' => '<p>The quota for the number of policies for this load balancer has been reached.</p>', 'refs' => [], ], 'TooManyTagsException' => [ 'base' => '<p>The quota for the number of tags that can be assigned to a load balancer has been reached.</p>', 'refs' => [], ], 'UnhealthyThreshold' => [ 'refs' => [ 'HealthCheck$UnhealthyThreshold' => '<p>The number of consecutive health check failures required before moving the instance to the <code>Unhealthy</code> state.</p>', ], ], 'VPCId' => [ 'refs' => [ 'LoadBalancerDescription$VPCId' => '<p>The ID of the VPC for the load balancer.</p>', ], ], ], 'service' => '<fullname>Elastic Load Balancing</fullname> <p>Elastic Load Balancing distributes incoming traffic across your EC2 instances.</p> <p>For information about the features of Elastic Load Balancing, see <a href="http://docs.aws.amazon.com/ElasticLoadBalancing/latest/DeveloperGuide/elastic-load-balancing.html">What Is Elastic Load Balancing?</a> in the <i>Elastic Load Balancing Developer Guide</i>.</p> <p>For information about the AWS regions supported by Elastic Load Balancing, see <a href="http://docs.aws.amazon.com/general/latest/gr/rande.html#elb_region">Regions and Endpoints - Elastic Load Balancing</a> in the <i>Amazon Web Services General Reference</i>.</p> <p>All Elastic Load Balancing operations are <i>idempotent</i>, which means that they complete at most one time. If you repeat an operation, it succeeds with a 200 OK response code.</p>',];
