<?php
// This file was auto-generated from sdk-root/src/data/firehose/2015-08-04/docs-2.json
return [ 'version' => '2.0', 'operations' => [ 'CreateDeliveryStream' => '<p>Creates a delivery stream.</p> <p><a>CreateDeliveryStream</a> is an asynchronous operation that immediately returns. The initial status of the delivery stream is <code>CREATING</code>. After the delivery stream is created, its status is <code>ACTIVE</code> and it now accepts data. Attempts to send data to a delivery stream that is not in the <code>ACTIVE</code> state cause an exception. To check the state of a delivery stream, use <a>DescribeDeliveryStream</a>.</p> <p>The name of a delivery stream identifies it. You can\'t have two delivery streams with the same name in the same region. Two delivery streams in different AWS accounts or different regions in the same AWS account can have the same name.</p> <p>By default, you can create up to 5 delivery streams per region.</p> <p>A delivery stream can only be configured with a single destination, Amazon S3 or Amazon Redshift. For correct <a>CreateDeliveryStream</a> request syntax, specify only one destination configuration parameter: either <code>RedshiftDestinationConfiguration</code> or <code>S3DestinationConfiguration</code></p> <p>As part of <code>S3DestinationConfiguration</code>, optional values <code>BufferingHints</code>, <code>EncryptionConfiguration</code>, and <code>CompressionFormat</code> can be provided. By default, if no <code>BufferingHints</code> value is provided, Amazon Kinesis Firehose buffers data up to 5 MB or for 5 minutes, whichever condition is satisfied first. Note that <code>BufferingHints</code> is a hint, so there are some cases where the service cannot adhere to these conditions strictly; for example, record boundaries are such that the size is a little over or under the configured buffering size. By default, no encryption is performed. We strongly recommend that you enable encryption to ensure secure data storage in Amazon S3.</p> <p>A few notes about <code>RedshiftDestinationConfiguration</code>:</p> <ul> <li>An Amazon Redshift destination requires an S3 bucket as intermediate location, as Amazon Kinesis Firehose first delivers data to S3 and then uses <code>COPY</code> syntax to load data into an Amazon Redshift table. This is specified in the <code>RedshiftDestinationConfiguration.S3Configuration</code> parameter element.</li> <li>The compression formats <code>SNAPPY</code> or <code>ZIP</code> cannot be specified in <code>RedshiftDestinationConfiguration.S3Configuration</code> because the Amazon Redshift <code>COPY</code> operation that reads from the S3 bucket doesn\'t support these compression formats.</li> <li>We strongly recommend that the username and password provided is used exclusively for Amazon Kinesis Firehose purposes, and that the permissions for the account are restricted for Amazon Redshift <code>INSERT</code> permissions.</li> </ul> <p>Amazon Kinesis Firehose assumes the IAM role that is configured as part of destinations. The IAM role should allow the Amazon Kinesis Firehose principal to assume the role, and the role should have permissions that allows the service to deliver the data. For more information, see <a href="http://docs.aws.amazon.com/firehose/latest/dev/controlling-access.html#using-iam-s3">Amazon S3 Bucket Access</a> in the <i>Amazon Kinesis Firehose Developer Guide</i>.</p>', 'DeleteDeliveryStream' => '<p>Deletes a delivery stream and its data.</p> <p>You can delete a delivery stream only if it is in <code>ACTIVE</code> or <code>DELETING</code> state, and not in the <code>CREATING</code> state. While the deletion request is in process, the delivery stream is in the <code>DELETING</code> state.</p> <p>To check the state of a delivery stream, use <a>DescribeDeliveryStream</a>.</p> <p>While the delivery stream is <code>DELETING</code> state, the service may continue to accept the records, but the service doesn\'t make any guarantees with respect to delivering the data. Therefore, as a best practice, you should first stop any applications that are sending records before deleting a delivery stream.</p>', 'DescribeDeliveryStream' => '<p>Describes the specified delivery stream and gets the status. For example, after your delivery stream is created, call <a>DescribeDeliveryStream</a> to see if the delivery stream is <code>ACTIVE</code> and therefore ready for data to be sent to it.</p>', 'ListDeliveryStreams' => '<p>Lists your delivery streams.</p> <p>The number of delivery streams might be too large to return using a single call to <a>ListDeliveryStreams</a>. You can limit the number of delivery streams returned, using the <code>Limit</code> parameter. To determine whether there are more delivery streams to list, check the value of <code>HasMoreDeliveryStreams</code> in the output. If there are more delivery streams to list, you can request them by specifying the name of the last delivery stream returned in the call in the <code>ExclusiveStartDeliveryStreamName</code> parameter of a subsequent call.</p>', 'PutRecord' => '<p>Writes a single data record into an Amazon Kinesis Firehose delivery stream. To write multiple data records into a delivery stream, use <a>PutRecordBatch</a>. Applications using these operations are referred to as producers.</p> <p>By default, each delivery stream can take in up to 2,000 transactions per second, 5,000 records per second, or 5 MB per second. Note that if you use <a>PutRecord</a> and <a>PutRecordBatch</a>, the limits are an aggregate across these two operations for each delivery stream. For more information about limits and how to request an increase, see <a href="http://docs.aws.amazon.com/firehose/latest/dev/limits.html">Amazon Kinesis Firehose Limits</a>. </p> <p>You must specify the name of the delivery stream and the data record when using <a>PutRecord</a>. The data record consists of a data blob that can be up to 1,000 KB in size, and any kind of data, for example, a segment from a log file, geographic location data, web site clickstream data, etc.</p> <p>Amazon Kinesis Firehose buffers records before delivering them to the destination. To disambiguate the data blobs at the destination, a common solution is to use delimiters in the data, such as a newline (<code>\\n</code>] or some other character unique within the data. This allows the consumer application(s] to parse individual data items when reading the data from the destination.</p> <p>Amazon Kinesis Firehose does not maintain data record ordering. If the destination data needs to be re-ordered by the consumer application, the producer should include some form of sequence number in each data record. </p> <p>The <a>PutRecord</a> operation returns a <code>RecordId</code>, which is a unique string assigned to each record. Producer applications can use this ID for purposes such as auditability and investigation.</p> <p>If the <a>PutRecord</a> operation throws a <code>ServiceUnavailableException</code>, back off and retry. If the exception persists, it is possible that the throughput limits have been exceeded for the delivery stream. </p> <p>Data records sent to Amazon Kinesis Firehose are stored for 24 hours from the time they are added to a delivery stream as it attempts to send the records to the destination. If the destination is unreachable for more than 24 hours, the data is no longer available.</p>', 'PutRecordBatch' => '<p>Writes multiple data records into a delivery stream in a single call, which can achieve higher throughput per producer than when writing single records. To write single data records into a delivery stream, use <a>PutRecord</a>. Applications using these operations are referred to as producers.</p> <p>Each <a>PutRecordBatch</a> request supports up to 500 records. Each record in the request can be as large as 1,000 KB (before 64-bit encoding], up to a limit of 4 MB for the entire request. By default, each delivery stream can take in up to 2,000 transactions per second, 5,000 records per second, or 5 MB per second. Note that if you use <a>PutRecord</a> and <a>PutRecordBatch</a>, the limits are an aggregate across these two operations for each delivery stream. For more information about limits and how to request an increase, see <a href="http://docs.aws.amazon.com/firehose/latest/dev/limits.html">Amazon Kinesis Firehose Limits</a>. </p> <p>You must specify the name of the delivery stream and the data record when using <a>PutRecord</a>. The data record consists of a data blob that can be up to 1,000 KB in size, and any kind of data, for example, a segment from a log file, geographic location data, web site clickstream data, and so on.</p> <p>Amazon Kinesis Firehose buffers records before delivering them to the destination. To disambiguate the data blobs at the destination, a common solution is to use delimiters in the data, such as a newline (<code>\\n</code>] or some other character unique within the data. This allows the consumer application(s] to parse individual data items when reading the data from the destination.</p> <p>The <a>PutRecordBatch</a> response includes a count of any failed records, <code>FailedPutCount</code>, and an array of responses, <code>RequestResponses</code>. The <code>FailedPutCount</code> value is a count of records that failed. Each entry in the <code>RequestResponses</code> array gives additional information of the processed record. Each entry in <code>RequestResponses</code> directly correlates with a record in the request array using the same ordering, from the top to the bottom of the request and response. <code>RequestResponses</code> always includes the same number of records as the request array. <code>RequestResponses</code> both successfully and unsuccessfully processed records. Amazon Kinesis Firehose attempts to process all records in each <a>PutRecordBatch</a> request. A single record failure does not stop the processing of subsequent records.</p> <p>A successfully processed record includes a <code>RecordId</code> value, which is a unique value identified for the record. An unsuccessfully processed record includes <code>ErrorCode</code> and <code>ErrorMessage</code> values. <code>ErrorCode</code> reflects the type of error and is one of the following values: <code>ServiceUnavailable</code> or <code>InternalFailure</code>. <code>ErrorMessage</code> provides more detailed information about the error.</p> <p>If <code>FailedPutCount</code> is greater than 0 (zero], retry the request. A retry of the entire batch of records is possible; however, we strongly recommend that you inspect the entire response and resend only those records that failed processing. This minimizes duplicate records and also reduces the total bytes sent (and corresponding charges].</p> <p>If the <a>PutRecordBatch</a> operation throws a <code>ServiceUnavailableException</code>, back off and retry. If the exception persists, it is possible that the throughput limits have been exceeded for the delivery stream.</p> <p>Data records sent to Amazon Kinesis Firehose are stored for 24 hours from the time they are added to a delivery stream as it attempts to send the records to the destination. If the destination is unreachable for more than 24 hours, the data is no longer available.</p>', 'UpdateDestination' => '<p>Updates the specified destination of the specified delivery stream. </p> <p>This operation can be used to change the destination type (for example, to replace the Amazon S3 destination with Amazon Redshift] or change the parameters associated with a given destination (for example, to change the bucket name of the Amazon S3 destination]. The update may not occur immediately. The target delivery stream remains active while the configurations are updated, so data writes to the delivery stream can continue during this process. The updated configurations are normally effective within a few minutes. </p> <p>If the destination type is the same, Amazon Kinesis Firehose merges the configuration parameters specified in the <a>UpdateDestination</a> request with the destination configuration that already exists on the delivery stream. If any of the parameters are not specified in the update request, then the existing configuration parameters are retained. For example, in the Amazon S3 destination, if <a>EncryptionConfiguration</a> is not specified then the existing <a>EncryptionConfiguration</a> is maintained on the destination.</p> <p>If the destination type is not the same, for example, changing the destination from Amazon S3 to Amazon Redshift, Amazon Kinesis Firehose does not merge any parameters. In this case, all parameters must be specified.</p> <p>Amazon Kinesis Firehose uses the <code>CurrentDeliveryStreamVersionId</code> to avoid race conditions and conflicting merges. This is a required field in every request and the service only updates the configuration if the existing configuration matches the <code>VersionId</code>. After the update is applied successfully, the <code>VersionId</code> is updated, which can be retrieved with the <a>DescribeDeliveryStream</a> operation. The new <code>VersionId</code> should be uses to set <code>CurrentDeliveryStreamVersionId</code> in the next <a>UpdateDestination</a> operation.</p>', ], 'shapes' => [ 'AWSKMSKeyARN' => [ 'refs' => [ 'KMSEncryptionConfig$AWSKMSKeyARN' => '<p>The ARN of the encryption key. Must belong to the same region as the destination Amazon S3 bucket.</p>', ], ], 'BooleanObject' => [ 'refs' => [ 'DeliveryStreamDescription$HasMoreDestinations' => '<p>Indicates whether there are more destinations available to list.</p>', 'ListDeliveryStreamsOutput$HasMoreDeliveryStreams' => '<p>Indicates whether there are more delivery streams available to list.</p>', ], ], 'BucketARN' => [ 'refs' => [ 'S3DestinationConfiguration$BucketARN' => '<p>The ARN of the S3 bucket.</p>', 'S3DestinationDescription$BucketARN' => '<p>The ARN of the S3 bucket.</p>', 'S3DestinationUpdate$BucketARN' => '<p>The ARN of the S3 bucket.</p>', ], ], 'BufferingHints' => [ 'base' => '<p>Describes the buffering to perform before delivering data to the destination.</p>', 'refs' => [ 'S3DestinationConfiguration$BufferingHints' => '<p>The buffering option. If no value is specified, <code>BufferingHints</code> object default values are used.</p>', 'S3DestinationDescription$BufferingHints' => '<p>The buffering option. If no value is specified, <code>BufferingHints</code> object default values are used.</p>', 'S3DestinationUpdate$BufferingHints' => '<p>The buffering option. If no value is specified, <code>BufferingHints</code> object default values are used.</p>', ], ], 'ClusterJDBCURL' => [ 'refs' => [ 'RedshiftDestinationConfiguration$ClusterJDBCURL' => '<p>The database connection string.</p>', 'RedshiftDestinationDescription$ClusterJDBCURL' => '<p>The database connection string.</p>', 'RedshiftDestinationUpdate$ClusterJDBCURL' => '<p>The database connection string.</p>', ], ], 'CompressionFormat' => [ 'refs' => [ 'S3DestinationConfiguration$CompressionFormat' => '<p>The compression format. If no value is specified, the default is <code>UNCOMPRESSED</code>.</p> <p>The compression formats <code>SNAPPY</code> or <code>ZIP</code> cannot be specified for Amazon Redshift destinations because they are not supported by the Amazon Redshift <code>COPY</code> operation that reads from the S3 bucket.</p>', 'S3DestinationDescription$CompressionFormat' => '<p>The compression format. If no value is specified, the default is <code>NOCOMPRESSION</code>.</p>', 'S3DestinationUpdate$CompressionFormat' => '<p>The compression format. If no value is specified, the default is <code>NOCOMPRESSION</code>.</p> <p>The compression formats <code>SNAPPY</code> or <code>ZIP</code> cannot be specified for Amazon Redshift destinations because they are not supported by the Amazon Redshift <code>COPY</code> operation that reads from the S3 bucket.</p>', ], ], 'ConcurrentModificationException' => [ 'base' => '<p>Another modification has already happened. Fetch <code>VersionId</code> again and use it to update the destination.</p>', 'refs' => [], ], 'CopyCommand' => [ 'base' => '<p>Describes a <code>COPY</code> command for Amazon Redshift.</p>', 'refs' => [ 'RedshiftDestinationConfiguration$CopyCommand' => '<p>The <code>COPY</code> command.</p>', 'RedshiftDestinationDescription$CopyCommand' => '<p>The <code>COPY</code> command.</p>', 'RedshiftDestinationUpdate$CopyCommand' => '<p>The <code>COPY</code> command.</p>', ], ], 'CopyOptions' => [ 'refs' => [ 'CopyCommand$CopyOptions' => '<p>Optional parameters to use with the Amazon Redshift <code>COPY</code> command. For more information, see the "Optional Parameters" section of <a href="http://docs.aws.amazon.com/redshift/latest/dg/r_COPY.html">Amazon Redshift COPY command</a>. Some possible examples that would apply to Amazon Kinesis Firehose are as follows.</p> <p><code>delimiter \'\\t\' lzop;</code> - fields are delimited with "\\t" (TAB character] and compressed using lzop.</p> <p><code>delimiter \'|</code> - fields are delimited with "|" (this is the default delimiter].</p> <p><code>delimiter \'|\' escape</code> - the delimiter should be escaped.</p> <p><code>fixedwidth \'venueid:3,venuename:25,venuecity:12,venuestate:2,venueseats:6\'</code> - fields are fixed width in the source, with each width specified after every column in the table.</p> <p> <code>JSON \'s3://mybucket/jsonpaths.txt\'</code> - data is in JSON format, and the path specified is the format of the data.</p> <p>For more examples, see and <a href="http://docs.aws.amazon.com/redshift/latest/dg/r_COPY_command_examples.html">Amazon Redshift COPY command exmaples</a>.</p>', ], ], 'CreateDeliveryStreamInput' => [ 'base' => '<p>Contains the parameters for <a>CreateDeliveryStream</a>.</p>', 'refs' => [], ], 'CreateDeliveryStreamOutput' => [ 'base' => '<p>Contains the output of <a>CreateDeliveryStream</a>.</p>', 'refs' => [], ], 'Data' => [ 'refs' => [ 'Record$Data' => '<p>The data blob, which is base64-encoded when the blob is serialized. The maximum size of the data blob, before base64-encoding, is 1,000 KB.</p>', ], ], 'DataTableColumns' => [ 'refs' => [ 'CopyCommand$DataTableColumns' => '<p>A comma-separated list of column names.</p>', ], ], 'DataTableName' => [ 'refs' => [ 'CopyCommand$DataTableName' => '<p>The name of the target table. The table must already exist in the database.</p>', ], ], 'DeleteDeliveryStreamInput' => [ 'base' => '<p>Contains the parameters for <a>DeleteDeliveryStream</a>.</p>', 'refs' => [], ], 'DeleteDeliveryStreamOutput' => [ 'base' => '<p>Contains the output of <a>DeleteDeliveryStream</a>.</p>', 'refs' => [], ], 'DeliveryStreamARN' => [ 'refs' => [ 'CreateDeliveryStreamOutput$DeliveryStreamARN' => '<p>The ARN of the delivery stream.</p>', 'DeliveryStreamDescription$DeliveryStreamARN' => '<p>The Amazon Resource Name (ARN] of the delivery stream.</p>', ], ], 'DeliveryStreamDescription' => [ 'base' => '<p>Contains information about a delivery stream.</p>', 'refs' => [ 'DescribeDeliveryStreamOutput$DeliveryStreamDescription' => '<p>Information about the delivery stream.</p>', ], ], 'DeliveryStreamName' => [ 'refs' => [ 'CreateDeliveryStreamInput$DeliveryStreamName' => '<p>The name of the delivery stream.</p>', 'DeleteDeliveryStreamInput$DeliveryStreamName' => '<p>The name of the delivery stream.</p>', 'DeliveryStreamDescription$DeliveryStreamName' => '<p>The name of the delivery stream.</p>', 'DescribeDeliveryStreamInput$DeliveryStreamName' => '<p>The name of the delivery stream.</p>', 'ListDeliveryStreamsInput$ExclusiveStartDeliveryStreamName' => '<p>The name of the delivery stream to start the list with.</p>', 'PutRecordBatchInput$DeliveryStreamName' => '<p>The name of the delivery stream.</p>', 'PutRecordInput$DeliveryStreamName' => '<p>The name of the delivery stream.</p>', 'UpdateDestinationInput$DeliveryStreamName' => '<p>The name of the delivery stream.</p>', ], ], 'DeliveryStreamNameList' => [ 'refs' => [ 'ListDeliveryStreamsOutput$DeliveryStreamNames' => '<p>The names of the delivery streams.</p>', ], ], 'DeliveryStreamStatus' => [ 'refs' => [ 'DeliveryStreamDescription$DeliveryStreamStatus' => '<p>The status of the delivery stream.</p>', ], ], 'DeliveryStreamVersionId' => [ 'refs' => [ 'DeliveryStreamDescription$VersionId' => '<p>Used when calling the <a>UpdateDestination</a> operation. Each time the destination is updated for the delivery stream, the VersionId is changed, and the current VersionId is required when updating the destination. This is so that the service knows it is applying the changes to the correct version of the delivery stream.</p>', 'UpdateDestinationInput$CurrentDeliveryStreamVersionId' => '<p>Obtain this value from the <code>VersionId</code> result of the <a>DeliveryStreamDescription</a> operation. This value is required, and helps the service to perform conditional operations. For example, if there is a interleaving update and this value is null, then the update destination fails. After the update is successful, the <code>VersionId</code> value is updated. The service then performs a merge of the old configuration with the new configuration.</p>', ], ], 'DescribeDeliveryStreamInput' => [ 'base' => '<p>Contains the parameters for <a>DescribeDeliveryStream</a>.</p>', 'refs' => [], ], 'DescribeDeliveryStreamInputLimit' => [ 'refs' => [ 'DescribeDeliveryStreamInput$Limit' => '<p>The limit on the number of destinations to return. Currently, you can have one destination per delivery stream.</p>', ], ], 'DescribeDeliveryStreamOutput' => [ 'base' => '<p>Contains the output of <a>DescribeDeliveryStream</a>.</p>', 'refs' => [], ], 'DestinationDescription' => [ 'base' => '<p>Describes the destination for a delivery stream.</p>', 'refs' => [], ], 'DestinationDescriptionList' => [ 'refs' => [ 'DeliveryStreamDescription$Destinations' => '<p>The destinations.</p>', ], ], 'DestinationId' => [ 'refs' => [ 'DescribeDeliveryStreamInput$ExclusiveStartDestinationId' => '<p>Specifies the destination ID to start returning the destination information. Currently Amazon Kinesis Firehose supports one destination per delivery stream.</p>', 'DestinationDescription$DestinationId' => '<p>The ID of the destination.</p>', 'UpdateDestinationInput$DestinationId' => '<p>The ID of the destination.</p>', ], ], 'EncryptionConfiguration' => [ 'base' => '<p>Describes the encryption for a destination in Amazon S3.</p>', 'refs' => [ 'S3DestinationConfiguration$EncryptionConfiguration' => '<p>The encryption configuration. If no value is specified, the default is no encryption.</p>', 'S3DestinationDescription$EncryptionConfiguration' => '<p>The encryption configuration. If no value is specified, the default is no encryption.</p>', 'S3DestinationUpdate$EncryptionConfiguration' => '<p>The encryption configuration. If no value is specified, the default is no encryption.</p>', ], ], 'ErrorCode' => [ 'refs' => [ 'PutRecordBatchResponseEntry$ErrorCode' => '<p>The error code for an individual record result.</p>', ], ], 'ErrorMessage' => [ 'refs' => [ 'ConcurrentModificationException$message' => '<p>A message that provides information about the error.</p>', 'InvalidArgumentException$message' => '<p>A message that provides information about the error.</p>', 'LimitExceededException$message' => '<p>A message that provides information about the error.</p>', 'PutRecordBatchResponseEntry$ErrorMessage' => '<p>The error message for an individual record result.</p>', 'ResourceInUseException$message' => '<p>A message that provides information about the error.</p>', 'ResourceNotFoundException$message' => '<p>A message that provides information about the error.</p>', 'ServiceUnavailableException$message' => '<p>A message that provides information about the error.</p>', ], ], 'IntervalInSeconds' => [ 'refs' => [ 'BufferingHints$IntervalInSeconds' => '<p>Buffer incoming data for the specified period of time, in seconds, before delivering it to the destination. The default value is 300.</p>', ], ], 'InvalidArgumentException' => [ 'base' => '<p>The specified input parameter has an value that is not valid.</p>', 'refs' => [], ], 'KMSEncryptionConfig' => [ 'base' => '<p>Describes an encryption key for a destination in Amazon S3.</p>', 'refs' => [ 'EncryptionConfiguration$KMSEncryptionConfig' => '<p>The encryption key.</p>', ], ], 'LimitExceededException' => [ 'base' => '<p>You have already reached the limit for a requested resource.</p>', 'refs' => [], ], 'ListDeliveryStreamsInput' => [ 'base' => '<p>Contains the parameters for <a>ListDeliveryStreams</a>.</p>', 'refs' => [], ], 'ListDeliveryStreamsInputLimit' => [ 'refs' => [ 'ListDeliveryStreamsInput$Limit' => '<p>The maximum number of delivery streams to list.</p>', ], ], 'ListDeliveryStreamsOutput' => [ 'base' => '<p>Contains the output of <a>ListDeliveryStreams</a>.</p>', 'refs' => [], ], 'NoEncryptionConfig' => [ 'refs' => [ 'EncryptionConfiguration$NoEncryptionConfig' => '<p>Specifically override existing encryption information to ensure no encryption is used.</p>', ], ], 'NonNegativeIntegerObject' => [ 'refs' => [ 'PutRecordBatchOutput$FailedPutCount' => '<p>The number of unsuccessfully written records.</p>', ], ], 'Password' => [ 'refs' => [ 'RedshiftDestinationConfiguration$Password' => '<p>The user password.</p>', 'RedshiftDestinationUpdate$Password' => '<p>The user password.</p>', ], ], 'Prefix' => [ 'refs' => [ 'S3DestinationConfiguration$Prefix' => '<p>The "YYYY/MM/DD/HH" time format prefix is automatically used for delivered S3 files. You can specify an extra prefix to be added in front of the time format prefix. Note that if the prefix ends with a slash, it appears as a folder in the S3 bucket. For more information, see <a href="http://docs.aws.amazon.com/firehose/latest/dev/basic-deliver.html">Amazon S3 Object Name Format</a> in the <a href="http://docs.aws.amazon.com/firehose/latest/dev/">guide-fh-dev</a>.</p>', 'S3DestinationDescription$Prefix' => '<p>The "YYYY/MM/DD/HH" time format prefix is automatically used for delivered S3 files. You can specify an extra prefix to be added in front of the time format prefix. Note that if the prefix ends with a slash, it appears as a folder in the S3 bucket. For more information, see <a href="http://docs.aws.amazon.com/firehose/latest/dev/basic-deliver.html">Amazon S3 Object Name Format</a> in the <a href="http://docs.aws.amazon.com/firehose/latest/dev/">guide-fh-dev</a>.</p>', 'S3DestinationUpdate$Prefix' => '<p>The "YYYY/MM/DD/HH" time format prefix is automatically used for delivered S3 files. You can specify an extra prefix to be added in front of the time format prefix. Note that if the prefix ends with a slash, it appears as a folder in the S3 bucket. For more information, see <a href="http://docs.aws.amazon.com/firehose/latest/dev/basic-deliver.html">Amazon S3 Object Name Format</a> in the <a href="http://docs.aws.amazon.com/firehose/latest/dev/">guide-fh-dev</a>.</p>', ], ], 'PutRecordBatchInput' => [ 'base' => '<p>Contains the parameters for <a>PutRecordBatch</a>.</p>', 'refs' => [], ], 'PutRecordBatchOutput' => [ 'base' => '<p>Contains the output of <a>PutRecordBatch</a>.</p>', 'refs' => [], ], 'PutRecordBatchRequestEntryList' => [ 'refs' => [ 'PutRecordBatchInput$Records' => '<p>One or more records.</p>', ], ], 'PutRecordBatchResponseEntry' => [ 'base' => '<p>Contains the result for an individual record from a <a>PutRecordBatch</a> request. If the record is successfully added to your delivery stream, it receives a record ID. If the record fails to be added to your delivery stream, the result includes an error code and an error message.</p>', 'refs' => [], ], 'PutRecordBatchResponseEntryList' => [ 'refs' => [ 'PutRecordBatchOutput$RequestResponses' => '<p>The results for the individual records. The index of each element matches the same index in which records were sent.</p>', ], ], 'PutRecordInput' => [ 'base' => '<p>Contains the parameters for <a>PutRecord</a>.</p>', 'refs' => [], ], 'PutRecordOutput' => [ 'base' => '<p>Contains the output of <a>PutRecord</a>.</p>', 'refs' => [], ], 'PutResponseRecordId' => [ 'refs' => [ 'PutRecordBatchResponseEntry$RecordId' => '<p>The ID of the record.</p>', 'PutRecordOutput$RecordId' => '<p>The ID of the record.</p>', ], ], 'Record' => [ 'base' => '<p>The unit of data in a delivery stream.</p>', 'refs' => [ 'PutRecordInput$Record' => '<p>The record.</p>', ], ], 'RedshiftDestinationConfiguration' => [ 'base' => '<p>Describes the configuration of a destination in Amazon Redshift.</p>', 'refs' => [ 'CreateDeliveryStreamInput$RedshiftDestinationConfiguration' => '<p>The destination in Amazon Redshift. This value cannot be specified if Amazon S3 is the desired destination (see restrictions listed above].</p>', ], ], 'RedshiftDestinationDescription' => [ 'base' => '<p>Describes a destination in Amazon Redshift.</p>', 'refs' => [ 'DestinationDescription$RedshiftDestinationDescription' => '<p>The destination in Amazon Redshift.</p>', ], ], 'RedshiftDestinationUpdate' => [ 'base' => '<p>Describes an update for a destination in Amazon Redshift.</p>', 'refs' => [], ], 'ResourceInUseException' => [ 'base' => '<p>The resource is already in use and not available for this operation.</p>', 'refs' => [], ], 'ResourceNotFoundException' => [ 'base' => '<p>The specified resource could not be found.</p>', 'refs' => [], ], 'RoleARN' => [ 'refs' => [ 'RedshiftDestinationConfiguration$RoleARN' => '<p>The ARN of the AWS credentials.</p>', 'RedshiftDestinationDescription$RoleARN' => '<p>The ARN of the AWS credentials.</p>', 'RedshiftDestinationUpdate$RoleARN' => '<p>The ARN of the AWS credentials.</p>', 'S3DestinationConfiguration$RoleARN' => '<p>The ARN of the AWS credentials.</p>', 'S3DestinationDescription$RoleARN' => '<p>The ARN of the AWS credentials.</p>', 'S3DestinationUpdate$RoleARN' => '<p>The ARN of the AWS credentials.</p>', ], ], 'S3DestinationConfiguration' => [ 'base' => '<p>Describes the configuration of a destination in Amazon S3.</p>', 'refs' => [ 'CreateDeliveryStreamInput$S3DestinationConfiguration' => '<p>The destination in Amazon S3. This value must be specified if <code>RedshiftDestinationConfiguration</code> is specified (see restrictions listed above].</p>', 'RedshiftDestinationConfiguration$S3Configuration' => '<p>The S3 configuration for the intermediate location from which Amazon Redshift obtains data. Restrictions are described in the topic for <a>CreateDeliveryStream</a>.</p> <p>The compression formats <code>SNAPPY</code> or <code>ZIP</code> cannot be specified in <code>RedshiftDestinationConfiguration.S3Configuration</code> because the Amazon Redshift <code>COPY</code> operation that reads from the S3 bucket doesn\'t support these compression formats.</p>', ], ], 'S3DestinationDescription' => [ 'base' => '<p>Describes a destination in Amazon S3.</p>', 'refs' => [ 'DestinationDescription$S3DestinationDescription' => '<p>The Amazon S3 destination.</p>', 'RedshiftDestinationDescription$S3DestinationDescription' => '<p>The Amazon S3 destination.</p>', ], ], 'S3DestinationUpdate' => [ 'base' => '<p>Describes an update for a destination in Amazon S3.</p>', 'refs' => [ 'RedshiftDestinationUpdate$S3Update' => '<p>The Amazon S3 destination.</p> <p>The compression formats <code>SNAPPY</code> or <code>ZIP</code> cannot be specified in <code>RedshiftDestinationUpdate.S3Update</code> because the Amazon Redshift <code>COPY</code> operation that reads from the S3 bucket doesn\'t support these compression formats.</p>', ], ], 'ServiceUnavailableException' => [ 'base' => '<p>The service is unavailable, back off and retry the operation. If you continue to see the exception, throughput limits for the delivery stream may have been exceeded. For more information about limits and how to request an increase, see <a href="http://docs.aws.amazon.com/firehose/latest/dev/limits.html">Amazon Kinesis Firehose Limits</a>.</p>', 'refs' => [], ], 'SizeInMBs' => [ 'refs' => [ 'BufferingHints$SizeInMBs' => '<p>Buffer incoming data to the specified size, in MBs, before delivering it to the destination. The default value is 5.</p> <p>We recommend setting SizeInMBs to a value greater than the amount of data you typically ingest into the delivery stream in 10 seconds. For example, if you typically ingest data at 1 MB/sec set SizeInMBs to be 10 MB or higher.</p>', ], ], 'Timestamp' => [ 'refs' => [ 'DeliveryStreamDescription$CreateTimestamp' => '<p>The date and time that the delivery stream was created.</p>', 'DeliveryStreamDescription$LastUpdateTimestamp' => '<p>The date and time that the delivery stream was last updated.</p>', ], ], 'UpdateDestinationInput' => [ 'base' => '<p>Contains the parameters for <a>UpdateDestination</a>.</p>', 'refs' => [], ], 'UpdateDestinationOutput' => [ 'base' => '<p>Contains the output of <a>UpdateDestination</a>.</p>', 'refs' => [], ], 'Username' => [ 'refs' => [ 'RedshiftDestinationConfiguration$Username' => '<p>The name of the user.</p>', 'RedshiftDestinationDescription$Username' => '<p>The name of the user.</p>', 'RedshiftDestinationUpdate$Username' => '<p>The name of the user.</p>', ], ], ], 'service' => '<fullname>Amazon Kinesis Firehose API Reference</fullname> <p>Amazon Kinesis Firehose is a fully-managed service that delivers real-time streaming data to destinations such as Amazon S3 and Amazon Redshift.</p>',];
