<?php
// This file was auto-generated from sdk-root/src/data/inspector/2015-08-18/docs-2.json
return [ 'version' => '2.0', 'operations' => [ 'AddAttributesToFindings' => '<p>Assigns attributes (key and value pair] to the findings specified by the findings\' ARNs.</p>', 'AttachAssessmentAndRulesPackage' => '<p>Attaches the rules package specified by the rules package ARN to the assessment specified by the assessment ARN.</p>', 'CreateApplication' => '<p>Creates a new application using the resource group ARN generated by <a>CreateResourceGroup</a>. You can create up to 50 applications per AWS account. You can run up to 500 concurrent agents per AWS account. For more information, see <a href="https://docs.aws.amazon.com/inspector/latest/userguide//inspector_applications.html"> Inspector Applications.</a></p>', 'CreateAssessment' => '<p>Creates an assessment for the application specified by the application ARN. You can create up to 500 assessments per AWS account.</p>', 'CreateResourceGroup' => '<p>Creates a resource group using the specified set of tags (key and value pairs] that are used to select the EC2 instances to be included in an Inspector application. The created resource group is then used to create an Inspector application.</p>', 'DeleteApplication' => '<p>Deletes the application specified by the application ARN.</p>', 'DeleteAssessment' => '<p>Deletes the assessment specified by the assessment ARN.</p>', 'DeleteRun' => '<p>Deletes the assessment run specified by the run ARN.</p>', 'DescribeApplication' => '<p>Describes the application specified by the application ARN.</p>', 'DescribeAssessment' => '<p>Describes the assessment specified by the assessment ARN.</p>', 'DescribeCrossAccountAccessRole' => '<p>Describes the IAM role that enables Inspector to access your AWS account.</p>', 'DescribeFinding' => '<p>Describes the finding specified by the finding ARN.</p>', 'DescribeResourceGroup' => '<p>Describes the resource group specified by the resource group ARN.</p>', 'DescribeRulesPackage' => '<p>Describes the rules package specified by the rules package ARN.</p>', 'DescribeRun' => '<p>Describes the assessment run specified by the run ARN.</p>', 'DetachAssessmentAndRulesPackage' => '<p>Detaches the rules package specified by the rules package ARN from the assessment specified by the assessment ARN.</p>', 'GetAssessmentTelemetry' => '<p>Returns the metadata about the telemetry (application behavioral data] for the assessment specified by the assessment ARN.</p>', 'ListApplications' => '<p>Lists the ARNs of the applications within this AWS account. For more information about applications, see <a href="https://docs.aws.amazon.com/inspector/latest/userguide//inspector_applications.html">Inspector Applications</a>.</p>', 'ListAssessmentAgents' => '<p>Lists the agents of the assessment specified by the assessment ARN.</p>', 'ListAssessments' => '<p>Lists the assessments corresponding to applications specified by the applications\' ARNs.</p>', 'ListAttachedAssessments' => '<p>Lists the assessments attached to the rules package specified by the rules package ARN.</p>', 'ListAttachedRulesPackages' => '<p>Lists the rules packages attached to the assessment specified by the assessment ARN.</p>', 'ListFindings' => '<p>Lists findings generated by the assessment run specified by the run ARNs.</p>', 'ListRulesPackages' => '<p>Lists all available Inspector rules packages.</p>', 'ListRuns' => '<p>Lists the assessment runs associated with the assessments specified by the assessment ARNs.</p>', 'ListTagsForResource' => '<p>Lists all tags associated with a resource.</p>', 'LocalizeText' => '<p>Translates a textual identifier into a user-readable text in a specified locale.</p>', 'PreviewAgentsForResourceGroup' => '<p>Previews the agents installed on the EC2 instances that are included in the application created with the specified resource group.</p>', 'RegisterCrossAccountAccessRole' => '<p>Register the role that Inspector uses to list your EC2 instances during the assessment.</p>', 'RemoveAttributesFromFindings' => '<p>Removes the entire attribute (key and value pair] from the findings specified by the finding ARNs where an attribute with the specified key exists.</p>', 'RunAssessment' => '<p>Starts the analysis of the application’s behavior against selected rule packages for the assessment specified by the assessment ARN.</p>', 'SetTagsForResource' => '<p>Sets tags (key and value pairs] to the assessment specified by the assessment ARN.</p>', 'StartDataCollection' => '<p>Starts data collection for the assessment specified by the assessment ARN. For this API to function properly, you must not exceed the limit of running up to 500 concurrent agents per AWS account.</p>', 'StopDataCollection' => '<p>Stop data collection for the assessment specified by the assessment ARN.</p>', 'UpdateApplication' => '<p>Updates application specified by the application ARN.</p>', 'UpdateAssessment' => '<p>Updates the assessment specified by the assessment ARN.</p>', ], 'shapes' => [ 'AccessDeniedException' => [ 'refs' => [], ], 'AddAttributesToFindingsRequest' => [ 'refs' => [], ], 'AddAttributesToFindingsResponse' => [ 'refs' => [], ], 'Agent' => [ 'base' => '<p>Contains information about an Inspector agent. This data type is used as a response element in the <a>ListAssessmentAgents</a> action.</p>', 'refs' => [], ], 'AgentHealth' => [ 'refs' => [ 'Agent$agentHealth' => '<p>The current health state of the agent. Values can be set to <i>HEALTHY</i> or <i>UNHEALTHY</i>.</p>', ], ], 'AgentHealthCode' => [ 'refs' => [ 'Agent$agentHealthCode' => '<p>The detailed health state of the agent. Values can be set to <i>RUNNING</i>, <i>HEALTHY</i>, <i>UNHEALTHY</i>, <i>UNKNOWN</i>, <i>BLACKLISTED</i>, <i>SHUTDOWN</i>, <i>THROTTLED</i>. </p>', ], ], 'AgentHealthDetails' => [ 'refs' => [ 'Agent$agentHealthDetails' => '<p>The description for the agent health code.</p>', ], ], 'AgentHealthList' => [ 'refs' => [ 'AgentsFilter$agentHealthList' => '<p>For a record to match a filter, the value specified for this data type property must be the exact match of the value of the <b>agentHealth</b> property of the <a>Agent</a> data type.</p>', ], ], 'AgentId' => [ 'refs' => [ 'Agent$agentId' => '<p>The EC2 instance ID where the agent is installed.</p>', 'AgentPreview$agentId' => '<p>The id of the EC2 instance where the agent is intalled.</p>', 'Finding$agentId' => '<p>The EC2 instance ID where the agent is installed that is used during the assessment that generates the finding. </p>', ], ], 'AgentList' => [ 'refs' => [ 'ListAssessmentAgentsResponse$agentList' => '<p>A list of ARNs specifying the agents returned by the action.</p>', ], ], 'AgentPreview' => [ 'base' => '<p>This data type is used as a response element in the <a>PreviewAgentsForResourceGroup</a> action.</p>', 'refs' => [], ], 'AgentPreviewList' => [ 'refs' => [ 'PreviewAgentsForResourceGroupResponse$agentPreviewList' => '<p>The resulting list of agents.</p>', ], ], 'AgentsFilter' => [ 'base' => '<p>This data type is used as a response element in the <a>ListAssessmentAgents</a> action.</p>', 'refs' => [ 'ListAssessmentAgentsRequest$filter' => '<p>You can use this parameter to specify a subset of data to be included in the action\'s response.</p> <p>For a record to match a filter, all specified filter attributes must match. When multiple values are specified for a filter attribute, any of the values can match.</p>', ], ], 'Application' => [ 'base' => '<p>Contains information about an Inspector application.</p> <p>This data type is used as the response element in the <a>DescribeApplication</a> action.</p>', 'refs' => [ 'DescribeApplicationResponse$application' => '<p>Information about the application.</p>', ], ], 'ApplicationsFilter' => [ 'base' => '<p>This data type is used as the request parameter in the <a>ListApplications</a> action.</p>', 'refs' => [ 'ListApplicationsRequest$filter' => '<p>You can use this parameter to specify a subset of data to be included in the action\'s response.</p> <p>For a record to match a filter, all specified filter attributes must match. When multiple values are specified for a filter attribute, any of the values can match.</p>', ], ], 'Arn' => [ 'refs' => [ 'Agent$assessmentArn' => '<p>The ARN of the assessment that is associated with the agent.</p>', 'Application$applicationArn' => '<p>The ARN specifying the Inspector application. </p>', 'Application$resourceGroupArn' => '<p>The ARN specifying the resource group that is associated with the application. </p>', 'Assessment$applicationArn' => '<p>The ARN of the application that corresponds to this assessment.</p>', 'Assessment$assessmentArn' => '<p>The ARN of the assessment.</p>', 'AttachAssessmentAndRulesPackageRequest$assessmentArn' => '<p>The ARN specifying the assessment to which you want to attach a rules package.</p>', 'AttachAssessmentAndRulesPackageRequest$rulesPackageArn' => '<p>The ARN specifying the rules package that you want to attach to the assessment.</p>', 'CreateApplicationRequest$resourceGroupArn' => '<p>The ARN specifying the resource group that is used to create the application.</p>', 'CreateApplicationResponse$applicationArn' => '<p>The ARN specifying the application that is created.</p>', 'CreateAssessmentRequest$applicationArn' => '<p>The ARN specifying the application for which you want to create an assessment.</p>', 'CreateAssessmentResponse$assessmentArn' => '<p>The ARN specifying the assessment that is created.</p>', 'CreateResourceGroupResponse$resourceGroupArn' => '<p>The ARN specifying the resource group that is created.</p>', 'DeleteApplicationRequest$applicationArn' => '<p>The ARN specifying the application that you want to delete.</p>', 'DeleteAssessmentRequest$assessmentArn' => '<p>The ARN specifying the assessment that you want to delete.</p>', 'DeleteRunRequest$runArn' => '<p>The ARN specifying the assessment run that you want to delete.</p>', 'DescribeApplicationRequest$applicationArn' => '<p>The ARN specifying the application that you want to describe.</p>', 'DescribeAssessmentRequest$assessmentArn' => '<p>The ARN specifying the assessment that you want to describe.</p>', 'DescribeCrossAccountAccessRoleResponse$roleArn' => '<p>The ARN specifying the IAM role that Inspector uses to access your AWS account.</p>', 'DescribeFindingRequest$findingArn' => '<p>The ARN specifying the finding that you want to describe.</p>', 'DescribeResourceGroupRequest$resourceGroupArn' => '<p>The ARN specifying the resource group that you want to describe.</p>', 'DescribeRulesPackageRequest$rulesPackageArn' => '<p>The ARN specifying the rules package that you want to describe.</p>', 'DescribeRunRequest$runArn' => '<p>The ARN specifying the assessment run that you want to describe.</p>', 'DetachAssessmentAndRulesPackageRequest$assessmentArn' => '<p>The ARN specifying the assessment from which you want to detach a rules package.</p>', 'DetachAssessmentAndRulesPackageRequest$rulesPackageArn' => '<p>The ARN specifying the rules package that you want to detach from the assessment.</p>', 'Finding$findingArn' => '<p>The ARN specifying the finding.</p>', 'Finding$rulesPackageArn' => '<p>The ARN of the rules package that is used to generate the finding.</p>', 'Finding$runArn' => '<p>The ARN of the assessment run that generated the finding.</p>', 'GetAssessmentTelemetryRequest$assessmentArn' => '<p>The ARN specifying the assessment the telemetry of which you want to obtain.</p>', 'ListAssessmentAgentsRequest$assessmentArn' => '<p>The ARN specifying the assessment whose agents you want to list.</p>', 'ListAttachedAssessmentsRequest$rulesPackageArn' => '<p>The ARN specifying the rules package whose assessments you want to list.</p>', 'ListAttachedRulesPackagesRequest$assessmentArn' => '<p>The ARN specifying the assessment whose rules packages you want to list.</p>', 'ListTagsForResourceRequest$resourceArn' => '<p>The ARN specifying the resource whose tags you want to list.</p>', 'PreviewAgentsForResourceGroupRequest$resourceGroupArn' => '<p>The ARN of the resource group that is used to create an application.</p>', 'RegisterCrossAccountAccessRoleRequest$roleArn' => 'The ARN of the IAM role that Inspector uses to list your EC2 instances during the assessment.', 'ResourceGroup$resourceGroupArn' => '<p>The ARN of the resource group. </p>', 'RulesPackage$rulesPackageArn' => '<p> The ARN of the rules package.</p>', 'Run$assessmentArn' => '<p>The ARN of the assessment that is associated with the run.</p>', 'Run$runArn' => '<p>The ARN of the run.</p>', 'RunAssessmentRequest$assessmentArn' => '<p>The ARN of the assessment that you want to run.</p>', 'RunAssessmentResponse$runArn' => '<p>The ARN specifying the run of the assessment.</p>', 'SetTagsForResourceRequest$resourceArn' => '<p>The ARN of the assessment that you want to set tags to.</p>', 'StartDataCollectionRequest$assessmentArn' => '<p>The ARN of the assessment for which you want to start the data collection process.</p>', 'StopDataCollectionRequest$assessmentArn' => '<p>The ARN of the assessment for which you want to stop the data collection process.</p>', 'UpdateApplicationRequest$applicationArn' => '<p>Application ARN that you want to update.</p>', 'UpdateApplicationRequest$resourceGroupArn' => '<p>The resource group ARN that you want to update.</p>', 'UpdateAssessmentRequest$assessmentArn' => '<p>Asessment ARN that you want to update.</p>', ], ], 'ArnList' => [ 'refs' => [ 'AddAttributesToFindingsRequest$findingArns' => '<p>The ARNs specifying the findings that you want to assign attributes to.</p>', 'FindingsFilter$rulesPackageArns' => '<p>For a record to match a filter, the value specified for this data type property must be the exact match of the value of the <b>rulesPackageArn</b> property of the <a>Finding</a> data type.</p>', 'ListApplicationsResponse$applicationArnList' => '<p>A list of ARNs specifying the applications returned by the action.</p>', 'ListAssessmentsRequest$applicationArns' => '<p>A list of ARNs specifying the applications the assessments of which you want to list.</p>', 'ListAssessmentsResponse$assessmentArnList' => '<p>A list of ARNs specifying the assessments returned by the action.</p>', 'ListAttachedAssessmentsResponse$assessmentArnList' => '<p>A list of ARNs specifying the assessments returned by the action.</p>', 'ListAttachedRulesPackagesResponse$rulesPackageArnList' => '<p>A list of ARNs specifying the rules packages returned by the action.</p>', 'ListFindingsRequest$runArns' => '<p>The ARNs of the assessment runs that generate the findings that you want to list.</p>', 'ListFindingsResponse$findingArnList' => '<p>A list of ARNs specifying the findings returned by the action.</p>', 'ListRulesPackagesResponse$rulesPackageArnList' => '<p>The list of ARNs specifying the rules packages returned by the action.</p>', 'ListRunsRequest$assessmentArns' => '<p>The ARNs specifying the assessments whose runs you want to list.</p>', 'ListRunsResponse$runArnList' => '<p>A list of ARNs specifying the assessment runs returned by the action.</p>', 'RemoveAttributesFromFindingsRequest$findingArns' => '<p>The ARNs specifying the findings that you want to remove attributes from.</p>', 'Run$rulesPackages' => '<p>Rules packages selected for the run of the assessment.</p>', 'RunsFilter$rulesPackages' => '<p>For a record to match a filter, the value specified for this data type property must match a list of values of the <b>rulesPackages</b> property of the <a>Run</a> data type.</p>', ], ], 'Assessment' => [ 'base' => '<p>Contains information about an Inspector assessment.</p> <p>This data type is used as the response element in the <a>DescribeAssessment</a> action.</p>', 'refs' => [ 'DescribeAssessmentResponse$assessment' => '<p>Information about the assessment.</p>', ], ], 'AssessmentState' => [ 'refs' => [ 'Assessment$assessmentState' => '<p>The state of the assessment. Values can be set to <i>Created</i>, <i>Collecting Data</i>, <i>Stopping</i>, and <i>Completed</i>.</p>', ], ], 'AssessmentStateList' => [ 'refs' => [ 'AssessmentsFilter$assessmentStates' => '<p>For a record to match a filter, the value specified for this data type property must be the exact match of the value of the <b>assessmentState</b> property of the <a>Assessment</a> data type.</p>', ], ], 'AssessmentsFilter' => [ 'base' => '<p>This data type is used as the request parameter in the <a>ListAssessments</a> and <a>ListAttachedAssessments</a> actions.</p>', 'refs' => [ 'ListAssessmentsRequest$filter' => '<p>You can use this parameter to specify a subset of data to be included in the action\'s response.</p> <p>For a record to match a filter, all specified filter attributes must match. When multiple values are specified for a filter attribute, any of the values can match.</p>', 'ListAttachedAssessmentsRequest$filter' => '<p>You can use this parameter to specify a subset of data to be included in the action\'s response.</p> <p>For a record to match a filter, all specified filter attributes must match. When multiple values are specified for a filter attribute, any of the values can match.</p>', ], ], 'AttachAssessmentAndRulesPackageRequest' => [ 'refs' => [], ], 'AttachAssessmentAndRulesPackageResponse' => [ 'refs' => [], ], 'Attribute' => [ 'base' => '<p>This data type is used as a response element in the <a>AddAttributesToFindings</a> action and a request parameter in the <a>CreateAssessment</a> action.</p>', 'refs' => [], ], 'AttributeKey' => [ 'refs' => [ 'Attribute$key' => '<p>The attribute key.</p>', ], ], 'AttributeKeyList' => [ 'refs' => [ 'RemoveAttributesFromFindingsRequest$attributeKeys' => '<p>The array of attribute keys that you want to remove from specified findings.</p>', ], ], 'AttributeList' => [ 'refs' => [ 'AddAttributesToFindingsRequest$attributes' => '<p>The array of attributes that you want to assign to specified findings.</p>', 'Assessment$userAttributesForFindings' => '<p>The user-defined attributes that are assigned to every generated finding.</p>', 'CreateAssessmentRequest$userAttributesForFindings' => '<p>The user-defined attributes that are assigned to every finding generated by running this assessment.</p>', 'Finding$attributes' => '<p>The system-defined attributes for the finding. </p>', 'Finding$userAttributes' => '<p>The user-defined attributes that are assigned to the finding.</p>', 'FindingsFilter$attributes' => '<p>For a record to match a filter, the value specified for this data type property must be the exact match of the value of the <b>attributes</b> property of the <a>Finding</a> data type.</p>', 'FindingsFilter$userAttributes' => '<p>For a record to match a filter, the value specified for this data type property must be the exact match of the value of the <b>userAttributes</b> property of the <a>Finding</a> data type.</p>', ], ], 'AttributeValue' => [ 'refs' => [ 'Attribute$value' => '<p>The value assigned to the attribute key.</p>', ], ], 'AutoScalingGroup' => [ 'refs' => [ 'Agent$autoScalingGroup' => '<p>This data type property is currently not used.</p>', 'AgentPreview$autoScalingGroup' => '<p>The autoscaling group for the EC2 instance where the agent is installed.</p>', 'Finding$autoScalingGroup' => '<p>The autoscaling group of the EC2 instance where the agent is installed that is used during the assessment that generates the finding.</p>', ], ], 'AwsAccount' => [ 'refs' => [ 'Agent$accountId' => '<p>AWS account of the EC2 instance where the agent is installed.</p>', ], ], 'Bool' => [ 'refs' => [ 'Assessment$dataCollected' => '<p>Boolean value (true or false] specifying whether the data collection process is completed.</p>', 'AssessmentsFilter$dataCollected' => '<p>For a record to match a filter, the value specified for this data type property must be the exact match of the value of the <b>dataCollected</b> property of the <a>Assessment</a> data type.</p>', 'DescribeCrossAccountAccessRoleResponse$valid' => '<p>A Boolean value that specifies whether the IAM role has the necessary policies attached to enable Inspector to access your AWS account.</p>', ], ], 'CreateApplicationRequest' => [ 'refs' => [], ], 'CreateApplicationResponse' => [ 'refs' => [], ], 'CreateAssessmentRequest' => [ 'refs' => [], ], 'CreateAssessmentResponse' => [ 'refs' => [], ], 'CreateResourceGroupRequest' => [ 'refs' => [], ], 'CreateResourceGroupResponse' => [ 'refs' => [], ], 'DeleteApplicationRequest' => [ 'refs' => [], ], 'DeleteApplicationResponse' => [ 'refs' => [], ], 'DeleteAssessmentRequest' => [ 'refs' => [], ], 'DeleteAssessmentResponse' => [ 'refs' => [], ], 'DeleteRunRequest' => [ 'refs' => [], ], 'DeleteRunResponse' => [ 'refs' => [], ], 'DescribeApplicationRequest' => [ 'refs' => [], ], 'DescribeApplicationResponse' => [ 'refs' => [], ], 'DescribeAssessmentRequest' => [ 'refs' => [], ], 'DescribeAssessmentResponse' => [ 'refs' => [], ], 'DescribeCrossAccountAccessRoleResponse' => [ 'refs' => [], ], 'DescribeFindingRequest' => [ 'refs' => [], ], 'DescribeFindingResponse' => [ 'refs' => [], ], 'DescribeResourceGroupRequest' => [ 'refs' => [], ], 'DescribeResourceGroupResponse' => [ 'refs' => [], ], 'DescribeRulesPackageRequest' => [ 'refs' => [], ], 'DescribeRulesPackageResponse' => [ 'refs' => [], ], 'DescribeRunRequest' => [ 'refs' => [], ], 'DescribeRunResponse' => [ 'refs' => [], ], 'DetachAssessmentAndRulesPackageRequest' => [ 'refs' => [], ], 'DetachAssessmentAndRulesPackageResponse' => [ 'refs' => [], ], 'Duration' => [ 'refs' => [ 'Assessment$durationInSeconds' => '<p>The assessment duration in seconds. The default value is 3600 seconds (one hour]. The maximum value is 86400 seconds (one day].</p>', 'CreateAssessmentRequest$durationInSeconds' => '<p>The duration of the assessment in seconds. The default value is 3600 seconds (one hour]. The maximum value is 86400 seconds (one day].</p>', 'DurationRange$maximum' => '<p>The maximum value of the duration range. Must be less than or equal to 604800 seconds (1 week].</p>', 'DurationRange$minimum' => '<p>The minimum value of the duration range. Must be greater than zero.</p>', 'UpdateAssessmentRequest$durationInSeconds' => '<p>Assessment duration in seconds that you want to update. The default value is 3600 seconds (one hour]. The maximum value is 86400 seconds (one day].</p>', ], ], 'DurationRange' => [ 'base' => '<p>This data type is used in the <a>AssessmentsFilter</a> data type.</p>', 'refs' => [ 'AssessmentsFilter$durationRange' => '<p>For a record to match a filter, the value specified for this data type property must inclusively match any value between the specified minimum and maximum values of the <b>durationInSeconds</b> property of the <a>Assessment</a> data type.</p>', ], ], 'FailureMessage' => [ 'refs' => [ 'Assessment$failureMessage' => '<p>This data type property is not currently used.</p>', ], ], 'Finding' => [ 'base' => '<p>Contains information about an Inspector finding.</p> <p>This data type is used as the response element in the <a>DescribeFinding</a> action.</p>', 'refs' => [ 'DescribeFindingResponse$finding' => '<p>Information about the finding.</p>', ], ], 'FindingsFilter' => [ 'base' => '<p>This data type is used as a request parameter in the <a>ListFindings</a> action.</p>', 'refs' => [ 'ListFindingsRequest$filter' => '<p>You can use this parameter to specify a subset of data to be included in the action\'s response.</p> <p>For a record to match a filter, all specified filter attributes must match. When multiple values are specified for a filter attribute, any of the values can match.</p>', ], ], 'GetAssessmentTelemetryRequest' => [ 'refs' => [], ], 'GetAssessmentTelemetryResponse' => [ 'refs' => [], ], 'Integer' => [ 'refs' => [ 'ListApplicationsRequest$maxResults' => '<p>You can use this parameter to indicate the maximum number of items you want in the response. The default value is 10. The maximum value is 500.</p>', 'ListAssessmentAgentsRequest$maxResults' => '<p>You can use this parameter to indicate the maximum number of items you want in the response. The default value is 10. The maximum value is 500.</p>', 'ListAssessmentsRequest$maxResults' => '<p>You can use this parameter to indicate the maximum number of items you want in the response. The default value is 10. The maximum value is 500.</p>', 'ListAttachedAssessmentsRequest$maxResults' => '<p>You can use this parameter to indicate the maximum number of items you want in the response. The default value is 10. The maximum value is 500.</p>', 'ListAttachedRulesPackagesRequest$maxResults' => '<p>You can use this parameter to indicate the maximum number of items you want in the response. The default value is 10. The maximum value is 500.</p>', 'ListFindingsRequest$maxResults' => '<p>You can use this parameter to indicate the maximum number of items you want in the response. The default value is 10. The maximum value is 500.</p>', 'ListRulesPackagesRequest$maxResults' => '<p>You can use this parameter to indicate the maximum number of items you want in the response. The default value is 10. The maximum value is 500.</p>', 'ListRunsRequest$maxResults' => '<p>You can use this parameter to indicate the maximum number of items you want in the response. The default value is 10. The maximum value is 500.</p>', 'PreviewAgentsForResourceGroupRequest$maxResults' => '<p>You can use this parameter to indicate the maximum number of items you want in the response. The default value is 10. The maximum value is 500.</p>', ], ], 'InternalException' => [ 'refs' => [], ], 'InvalidCrossAccountRoleException' => [ 'refs' => [], ], 'InvalidInputException' => [ 'refs' => [], ], 'ListApplicationsRequest' => [ 'refs' => [], ], 'ListApplicationsResponse' => [ 'refs' => [], ], 'ListAssessmentAgentsRequest' => [ 'refs' => [], ], 'ListAssessmentAgentsResponse' => [ 'refs' => [], ], 'ListAssessmentsRequest' => [ 'refs' => [], ], 'ListAssessmentsResponse' => [ 'refs' => [], ], 'ListAttachedAssessmentsRequest' => [ 'refs' => [], ], 'ListAttachedAssessmentsResponse' => [ 'refs' => [], ], 'ListAttachedRulesPackagesRequest' => [ 'refs' => [], ], 'ListAttachedRulesPackagesResponse' => [ 'refs' => [], ], 'ListFindingsRequest' => [ 'refs' => [], ], 'ListFindingsResponse' => [ 'refs' => [], ], 'ListRulesPackagesRequest' => [ 'refs' => [], ], 'ListRulesPackagesResponse' => [ 'refs' => [], ], 'ListRunsRequest' => [ 'refs' => [], ], 'ListRunsResponse' => [ 'refs' => [], ], 'ListTagsForResourceRequest' => [ 'refs' => [], ], 'ListTagsForResourceResponse' => [ 'refs' => [], ], 'Locale' => [ 'refs' => [ 'LocalizeTextRequest$locale' => '<p>The locale that you want to translate a textual identifier into.</p>', ], ], 'LocalizeTextRequest' => [ 'refs' => [], ], 'LocalizeTextResponse' => [ 'refs' => [], ], 'LocalizedFacility' => [ 'refs' => [ 'LocalizedTextKey$facility' => '<p>The module response source of the text.</p>', ], ], 'LocalizedText' => [ 'base' => '<p>The textual identifier. This data type is used as the request parameter in the <a>LocalizeText</a> action.</p>', 'refs' => [ 'Finding$description' => '<p>The description of the finding.</p>', 'Finding$finding' => '<p>A short description that identifies the finding.</p>', 'Finding$recommendation' => '<p>The recommendation for the finding. </p>', 'RulesPackage$description' => '<p>The description of the rules package.</p>', ], ], 'LocalizedTextId' => [ 'refs' => [ 'LocalizedTextKey$id' => '<p>Part of the module response source of the text.</p>', ], ], 'LocalizedTextKey' => [ 'base' => '<p>This data type is used in the <a>LocalizedText</a> data type.</p>', 'refs' => [ 'LocalizedText$key' => '<p>The facility and id properties of the <a>LocalizedTextKey</a> data type.</p>', ], ], 'LocalizedTextList' => [ 'refs' => [ 'LocalizeTextRequest$localizedTexts' => '<p>A list of textual identifiers.</p>', ], ], 'Long' => [ 'refs' => [ 'MessageTypeTelemetry$count' => '<p>The number of times that the behavioral data is collected by the agent during an assessment.</p>', 'MessageTypeTelemetry$dataSize' => '<p>The total size of the behavioral data that is collected by the agent during an assessment.</p>', ], ], 'Message' => [ 'refs' => [ 'AddAttributesToFindingsResponse$message' => '<p>Confirmation details of the action performed.</p>', 'AttachAssessmentAndRulesPackageResponse$message' => '<p>Confirmation details of the action performed.</p>', 'DeleteApplicationResponse$message' => '<p>Confirmation details of the action performed.</p>', 'DeleteAssessmentResponse$message' => '<p>Confirmation details of the action performed.</p>', 'DeleteRunResponse$message' => '<p>Confirmation details of the action performed.</p>', 'DetachAssessmentAndRulesPackageResponse$message' => '<p>Confirmation details of the action performed.</p>', 'LocalizeTextResponse$message' => '<p>Confirmation details of the action performed.</p>', 'RegisterCrossAccountAccessRoleResponse$message' => '<p>Confirmation details of the action performed.</p>', 'RemoveAttributesFromFindingsResponse$message' => '<p>Confirmation details of the action performed.</p>', 'SetTagsForResourceResponse$message' => '<p>Confirmation details of the action performed.</p>', 'StartDataCollectionResponse$message' => '<p>Confirmation details of the action performed.</p>', 'StopDataCollectionResponse$message' => '<p>Confirmation details of the action performed.</p>', 'UpdateApplicationResponse$message' => '<p>Confirmation details of the action performed.</p>', 'UpdateAssessmentResponse$message' => '<p>Confirmation details of the action performed.</p>', ], ], 'MessageType' => [ 'refs' => [ 'MessageTypeTelemetry$messageType' => '<p>A specific type of behavioral data that is collected by the agent.</p>', ], ], 'MessageTypeTelemetry' => [ 'base' => '<p>This data type is used in the <a>Telemetry</a> data type.</p> <p>This is metadata about the behavioral data collected by the Inspector agent on your EC2 instances during an assessment and passed to the Inspector service for analysis. </p>', 'refs' => [], ], 'MessageTypeTelemetryList' => [ 'refs' => [ 'Telemetry$messageTypeTelemetries' => '<p>Counts of individual metrics received by Inspector from the agent.</p>', ], ], 'Name' => [ 'refs' => [ 'Application$applicationName' => '<p>The name of the Inspector application. </p>', 'Assessment$assessmentName' => '<p>The name of the assessment.</p>', 'CreateApplicationRequest$applicationName' => '<p>The user-defined name identifying the application that you want to create. The name must be unique within the AWS account.</p>', 'CreateAssessmentRequest$assessmentName' => '<p>The user-defined name identifying the assessment that you want to create. You can create several assessments for an application. The names of the assessments corresponding to a particular application must be unique.</p>', 'Finding$ruleName' => '<p>The rule name that is used to generate the finding.</p>', 'RulesPackage$provider' => '<p>The provider of the rules package.</p>', 'RulesPackage$rulesPackageName' => '<p>The name of the rules package.</p>', 'Run$runName' => '<p>The auto-generated name for the run. </p>', 'RunAssessmentRequest$runName' => '<p>A name specifying the run of the assessment.</p>', 'UpdateApplicationRequest$applicationName' => '<p>Application name that you want to update.</p>', 'UpdateAssessmentRequest$assessmentName' => '<p>Assessment name that you want to update.</p>', ], ], 'NameList' => [ 'refs' => [ 'FindingsFilter$ruleNames' => '<p>For a record to match a filter, the value specified for this data type property must be the exact match of the value of the <b>ruleName</b> property of the <a>Finding</a> data type.</p>', ], ], 'NamePattern' => [ 'refs' => [], ], 'NamePatternList' => [ 'refs' => [ 'ApplicationsFilter$applicationNamePatterns' => '<p>For a record to match a filter, an explicit value or a string containing a wildcard specified for this data type property must match the value of the <b>applicationName</b> property of the <a>Application</a> data type.</p>', 'AssessmentsFilter$assessmentNamePatterns' => '<p>For a record to match a filter, an explicit value or a string containing a wildcard specified for this data type property must match the value of the <b>assessmentName</b> property of the <a>Assessment</a> data type.</p>', 'RunsFilter$runNamePatterns' => '<p>For a record to match a filter, an explicit value or a string containing a wildcard specified for this data type property must match the value of the <b>runName</b> property of the <a>Run</a> data type.</p>', ], ], 'NoSuchEntityException' => [ 'refs' => [], ], 'OperationInProgressException' => [ 'refs' => [], ], 'PaginationToken' => [ 'refs' => [ 'ListApplicationsRequest$nextToken' => '<p>You can use this parameter when paginating results. Set the value of this parameter to \'null\' on your first call to the <b>ListApplications</b> action. Subsequent calls to the action fill <b>nextToken</b> in the request with the value of <b>NextToken</b> from previous response to continue listing data.</p>', 'ListApplicationsResponse$nextToken' => '<p> When a response is generated, if there is more data to be listed, this parameter is present in the response and contains the value to use for the <b>nextToken</b> parameter in a subsequent pagination request. If there is no more data to be listed, this parameter is set to \'null\'.</p>', 'ListAssessmentAgentsRequest$nextToken' => '<p>You can use this parameter when paginating results. Set the value of this parameter to \'null\' on your first call to the <b>ListAssessmentAgents</b> action. Subsequent calls to the action fill <b>nextToken</b> in the request with the value of <b>NextToken</b> from previous response to continue listing data.</p>', 'ListAssessmentAgentsResponse$nextToken' => '<p> When a response is generated, if there is more data to be listed, this parameter is present in the response and contains the value to use for the <b>nextToken</b> parameter in a subsequent pagination request. If there is no more data to be listed, this parameter is set to \'null\'.</p>', 'ListAssessmentsRequest$nextToken' => '<p>You can use this parameter when paginating results. Set the value of this parameter to \'null\' on your first call to the <b>ListAssessments</b> action. Subsequent calls to the action fill <b>nextToken</b> in the request with the value of <b>NextToken</b> from previous response to continue listing data.</p>', 'ListAssessmentsResponse$nextToken' => '<p> When a response is generated, if there is more data to be listed, this parameter is present in the response and contains the value to use for the <b>nextToken</b> parameter in a subsequent pagination request. If there is no more data to be listed, this parameter is set to \'null\'.</p>', 'ListAttachedAssessmentsRequest$nextToken' => '<p>You can use this parameter when paginating results. Set the value of this parameter to \'null\' on your first call to the <b>ListAttachedAssessments</b> action. Subsequent calls to the action fill <b>nextToken</b> in the request with the value of <b>NextToken</b> from previous response to continue listing data.</p>', 'ListAttachedAssessmentsResponse$nextToken' => '<p> When a response is generated, if there is more data to be listed, this parameter is present in the response and contains the value to use for the <b>nextToken</b> parameter in a subsequent pagination request. If there is no more data to be listed, this parameter is set to \'null\'.</p>', 'ListAttachedRulesPackagesRequest$nextToken' => '<p>You can use this parameter when paginating results. Set the value of this parameter to \'null\' on your first call to the <b>ListAttachedRulesPackages</b> action. Subsequent calls to the action fill <b>nextToken</b> in the request with the value of <b>NextToken</b> from previous response to continue listing data.</p>', 'ListAttachedRulesPackagesResponse$nextToken' => '<p> When a response is generated, if there is more data to be listed, this parameter is present in the response and contains the value to use for the <b>nextToken</b> parameter in a subsequent pagination request. If there is no more data to be listed, this parameter is set to \'null\'.</p>', 'ListFindingsRequest$nextToken' => '<p>You can use this parameter when paginating results. Set the value of this parameter to \'null\' on your first call to the <b>ListFindings</b> action. Subsequent calls to the action fill <b>nextToken</b> in the request with the value of <b>NextToken</b> from previous response to continue listing data.</p>', 'ListFindingsResponse$nextToken' => '<p> When a response is generated, if there is more data to be listed, this parameter is present in the response and contains the value to use for the <b>nextToken</b> parameter in a subsequent pagination request. If there is no more data to be listed, this parameter is set to \'null\'.</p>', 'ListRulesPackagesRequest$nextToken' => '<p>You can use this parameter when paginating results. Set the value of this parameter to \'null\' on your first call to the <b>ListRulesPackages</b> action. Subsequent calls to the action fill <b>nextToken</b> in the request with the value of <b>NextToken</b> from previous response to continue listing data.</p>', 'ListRulesPackagesResponse$nextToken' => '<p> When a response is generated, if there is more data to be listed, this parameter is present in the response and contains the value to use for the <b>nextToken</b> parameter in a subsequent pagination request. If there is no more data to be listed, this parameter is set to \'null\'.</p>', 'ListRunsRequest$nextToken' => '<p>You can use this parameter when paginating results. Set the value of this parameter to \'null\' on your first call to the <b>ListRuns</b> action. Subsequent calls to the action fill <b>nextToken</b> in the request with the value of <b>NextToken</b> from previous response to continue listing data.</p>', 'ListRunsResponse$nextToken' => '<p> When a response is generated, if there is more data to be listed, this parameter is present in the response and contains the value to use for the <b>nextToken</b> parameter in a subsequent pagination request. If there is no more data to be listed, this parameter is set to \'null\'.</p>', 'PreviewAgentsForResourceGroupRequest$nextToken' => '<p>You can use this parameter when paginating results. Set the value of this parameter to \'null\' on your first call to the <b>PreviewAgentsForResourceGroup</b> action. Subsequent calls to the action fill <b>nextToken</b> in the request with the value of <b>NextToken</b> from previous response to continue listing data.</p>', 'PreviewAgentsForResourceGroupResponse$nextToken' => '<p> When a response is generated, if there is more data to be listed, this parameter is present in the response and contains the value to use for the <b>nextToken</b> parameter in a subsequent pagination request. If there is no more data to be listed, this parameter is set to \'null\'.</p>', ], ], 'Parameter' => [ 'base' => '<p>This data type is used in the <a>LocalizedText</a> data type.</p>', 'refs' => [], ], 'ParameterList' => [ 'refs' => [ 'LocalizedText$parameters' => '<p>Values for the dynamic elements of the string specified by the textual identifier.</p>', ], ], 'ParameterName' => [ 'refs' => [ 'Parameter$name' => '<p>The name of the variable that is being replaced.</p>', ], ], 'ParameterValue' => [ 'refs' => [ 'Parameter$value' => '<p>The value assigned to the variable that is being replaced. </p>', ], ], 'PreviewAgentsForResourceGroupRequest' => [ 'refs' => [], ], 'PreviewAgentsForResourceGroupResponse' => [ 'refs' => [], ], 'RegisterCrossAccountAccessRoleRequest' => [ 'refs' => [], ], 'RegisterCrossAccountAccessRoleResponse' => [ 'refs' => [], ], 'RemoveAttributesFromFindingsRequest' => [ 'refs' => [], ], 'RemoveAttributesFromFindingsResponse' => [ 'refs' => [], ], 'ResourceGroup' => [ 'base' => '<p>Contains information about a resource group. The resource group defines a set of tags that, when queried, identify the AWS resources that comprise the application.</p> <p>This data type is used as the response element in the <a>DescribeResourceGroup</a> action.</p>', 'refs' => [ 'DescribeResourceGroupResponse$resourceGroup' => '<p>Information about the resource group.</p>', ], ], 'ResourceGroupTags' => [ 'refs' => [ 'CreateResourceGroupRequest$resourceGroupTags' => '<p>A collection of keys and an array of possible values in JSON format.</p> <p>For example, [{ "key1" : ["Value1","Value2"]},{"Key2": ["Value3"]}]</p>', 'ResourceGroup$resourceGroupTags' => '<p>The tags (key and value pairs] of the resource group.</p> <p>This data type property is used in the <a>CreateResourceGroup</a> action.</p> <p>A collection of keys and an array of possible values in JSON format.</p> <p>For example, [{ "key1" : ["Value1","Value2"]},{"Key2": ["Value3"]}]</p>', ], ], 'RulesPackage' => [ 'base' => '<p>Contains information about an Inspector rules package.</p> <p>This data type is used as the response element in the <a>DescribeRulesPackage</a> action.</p>', 'refs' => [ 'DescribeRulesPackageResponse$rulesPackage' => '<p>Information about the rules package.</p>', ], ], 'Run' => [ 'base' => '<p>A snapshot of an Inspector assessment that contains the assessment\'s findings.</p> <p>This data type is used as the response element in the <a>DescribeRun</a> action.</p>', 'refs' => [ 'DescribeRunResponse$run' => '<p>Information about the assessment run.</p>', ], ], 'RunAssessmentRequest' => [ 'refs' => [], ], 'RunAssessmentResponse' => [ 'refs' => [], ], 'RunState' => [ 'refs' => [ 'Run$runState' => '<p>The state of the run. Values can be set to <i>DataCollectionComplete</i>, <i>EvaluatingPolicies</i>, <i>EvaluatingPoliciesErrorCanRetry</i>, <i>Completed</i>, <i>Failed</i>, <i>TombStoned</i>.</p>', ], ], 'RunStateList' => [ 'refs' => [ 'RunsFilter$runStates' => '<p>For a record to match a filter, the value specified for this data type property must be the exact match of the value of the <b>runState</b> property of the <a>Run</a> data type.</p>', ], ], 'RunsFilter' => [ 'base' => '<p>This data type is used as the request parameter in the <a>ListRuns</a> action.</p>', 'refs' => [ 'ListRunsRequest$filter' => '<p>You can use this parameter to specify a subset of data to be included in the action\'s response.</p> <p>For a record to match a filter, all specified filter attributes must match. When multiple values are specified for a filter attribute, any of the values can match.</p>', ], ], 'SetTagsForResourceRequest' => [ 'refs' => [], ], 'SetTagsForResourceResponse' => [ 'refs' => [], ], 'Severity' => [ 'refs' => [ 'Finding$severity' => '<p>The finding severity. Values can be set to <i>High</i>, <i>Medium</i>, <i>Low</i>, and <i>Informational</i>.</p>', ], ], 'SeverityList' => [ 'refs' => [ 'FindingsFilter$severities' => '<p>For a record to match a filter, the value specified for this data type property must be the exact match of the value of the <b>severity</b> property of the <a>Finding</a> data type.</p>', ], ], 'StartDataCollectionRequest' => [ 'refs' => [], ], 'StartDataCollectionResponse' => [ 'refs' => [], ], 'StopDataCollectionRequest' => [ 'refs' => [], ], 'StopDataCollectionResponse' => [ 'refs' => [], ], 'Tag' => [ 'base' => '<p>A key and value pair.</p> <p>This data type is used as a request parameter in the <a>SetTagsForResource</a> action and a response element in the <a>ListTagsForResource</a> action.</p>', 'refs' => [], ], 'TagKey' => [ 'refs' => [ 'Tag$Key' => '<p>The tag key.</p>', ], ], 'TagList' => [ 'refs' => [ 'ListTagsForResourceResponse$tagList' => '<p>A collection of key and value pairs.</p>', 'SetTagsForResourceRequest$tags' => '<p>A collection of key and value pairs that you want to set to an assessment.</p>', ], ], 'TagValue' => [ 'refs' => [ 'Tag$Value' => '<p>The value assigned to a tag key.</p>', ], ], 'Telemetry' => [ 'base' => '<p>The metadata about the Inspector application data metrics collected by the agent.</p> <p>This data type is used as the response element in the <a>GetAssessmentTelemetry</a> action.</p>', 'refs' => [], ], 'TelemetryList' => [ 'refs' => [ 'Agent$telemetry' => '<p>The Inspector application data metrics collected by the agent. </p>', 'GetAssessmentTelemetryResponse$telemetry' => '<p>Telemetry details.</p>', ], ], 'TelemetryStatus' => [ 'refs' => [ 'Telemetry$status' => '<p>The category of the individual metrics that together constitute the telemetry that Inspector received from the agent.</p>', ], ], 'Text' => [ 'refs' => [], ], 'TextList' => [ 'refs' => [ 'LocalizeTextResponse$results' => '<p>The resulting list of user-readable texts.</p>', ], ], 'Timestamp' => [ 'refs' => [ 'Assessment$endTime' => '<p>The assessment end time.</p>', 'Assessment$startTime' => '<p>The assessment start time.</p>', 'Run$completionTime' => '<p>Run completion time that corresponds to the rules packages evaluation completion time or failure.</p>', 'Run$creationTime' => '<p>Run creation time that corresponds to the data collection completion time or failure.</p>', 'TimestampRange$maximum' => '<p>The maximum value of the timestamp range.</p>', 'TimestampRange$minimum' => '<p>The minimum value of the timestamp range.</p>', ], ], 'TimestampRange' => [ 'base' => '<p>This data type is used in the <a>AssessmentsFilter</a> and <a>RunsFilter</a> data types.</p>', 'refs' => [ 'AssessmentsFilter$endTimeRange' => '<p>For a record to match a filter, the value specified for this data type property must inclusively match any value between the specified minimum and maximum values of the <b>endTime</b> property of the <a>Assessment</a> data type.</p>', 'AssessmentsFilter$startTimeRange' => '<p>For a record to match a filter, the value specified for this data type property must inclusively match any value between the specified minimum and maximum values of the <b>startTime</b> property of the <a>Assessment</a> data type.</p>', 'RunsFilter$completionTime' => '<p>For a record to match a filter, the value specified for this data type property must inclusively match any value between the specified minimum and maximum values of the <b>completionTime</b> property of the <a>Run</a> data type.</p>', 'RunsFilter$creationTime' => '<p>For a record to match a filter, the value specified for this data type property must inclusively match any value between the specified minimum and maximum values of the <b>creationTime</b> property of the <a>Run</a> data type.</p>', ], ], 'UpdateApplicationRequest' => [ 'refs' => [], ], 'UpdateApplicationResponse' => [ 'refs' => [], ], 'UpdateAssessmentRequest' => [ 'refs' => [], ], 'UpdateAssessmentResponse' => [ 'refs' => [], ], 'Version' => [ 'refs' => [ 'RulesPackage$version' => '<p>The version id of the rules package.</p>', ], ], ], 'service' => '<fullname>Amazon Inspector</fullname> <p>Amazon Inspector enables you to analyze the behavior of the applications you run in AWS and to identify potential security issues. For more information, see <a href="https://docs.aws.amazon.com/inspector/latest/userguide/inspector_introduction.html"> Amazon Inspector User Guide</a>.</p>',];
