<?php
// This file was auto-generated from sdk-root/src/data/route53/2013-04-01/api-2.json
return [ 'version' => '2.0', 'metadata' => [ 'apiVersion' => '2013-04-01', 'endpointPrefix' => 'route53', 'globalEndpoint' => 'route53.amazonaws.com', 'protocol' => 'rest-xml', 'serviceAbbreviation' => 'Route 53', 'serviceFullName' => 'Amazon Route 53', 'signatureVersion' => 'v4', ], 'operations' => [ 'AssociateVPCWithHostedZone' => [ 'name' => 'AssociateVPCWithHostedZone', 'http' => [ 'method' => 'POST', 'requestUri' => '/2013-04-01/hostedzone/{Id}/associatevpc', ], 'input' => [ 'shape' => 'AssociateVPCWithHostedZoneRequest', 'locationName' => 'AssociateVPCWithHostedZoneRequest', 'xmlNamespace' => [ 'uri' => 'https://route53.amazonaws.com/doc/2013-04-01/', ], ], 'output' => [ 'shape' => 'AssociateVPCWithHostedZoneResponse', ], 'errors' => [ [ 'shape' => 'NoSuchHostedZone', ], [ 'shape' => 'InvalidVPCId', ], [ 'shape' => 'InvalidInput', ], [ 'shape' => 'PublicZoneVPCAssociation', ], [ 'shape' => 'ConflictingDomainExists', ], [ 'shape' => 'LimitsExceeded', ], ], ], 'ChangeResourceRecordSets' => [ 'name' => 'ChangeResourceRecordSets', 'http' => [ 'method' => 'POST', 'requestUri' => '/2013-04-01/hostedzone/{Id}/rrset/', ], 'input' => [ 'shape' => 'ChangeResourceRecordSetsRequest', 'locationName' => 'ChangeResourceRecordSetsRequest', 'xmlNamespace' => [ 'uri' => 'https://route53.amazonaws.com/doc/2013-04-01/', ], ], 'output' => [ 'shape' => 'ChangeResourceRecordSetsResponse', ], 'errors' => [ [ 'shape' => 'NoSuchHostedZone', ], [ 'shape' => 'NoSuchHealthCheck', ], [ 'shape' => 'InvalidChangeBatch', ], [ 'shape' => 'InvalidInput', ], [ 'shape' => 'PriorRequestNotComplete', ], ], ], 'ChangeTagsForResource' => [ 'name' => 'ChangeTagsForResource', 'http' => [ 'method' => 'POST', 'requestUri' => '/2013-04-01/tags/{ResourceType}/{ResourceId}', ], 'input' => [ 'shape' => 'ChangeTagsForResourceRequest', 'locationName' => 'ChangeTagsForResourceRequest', 'xmlNamespace' => [ 'uri' => 'https://route53.amazonaws.com/doc/2013-04-01/', ], ], 'output' => [ 'shape' => 'ChangeTagsForResourceResponse', ], 'errors' => [ [ 'shape' => 'InvalidInput', ], [ 'shape' => 'NoSuchHealthCheck', ], [ 'shape' => 'NoSuchHostedZone', ], [ 'shape' => 'PriorRequestNotComplete', ], [ 'shape' => 'ThrottlingException', ], ], ], 'CreateHealthCheck' => [ 'name' => 'CreateHealthCheck', 'http' => [ 'method' => 'POST', 'requestUri' => '/2013-04-01/healthcheck', 'responseCode' => 201, ], 'input' => [ 'shape' => 'CreateHealthCheckRequest', 'locationName' => 'CreateHealthCheckRequest', 'xmlNamespace' => [ 'uri' => 'https://route53.amazonaws.com/doc/2013-04-01/', ], ], 'output' => [ 'shape' => 'CreateHealthCheckResponse', ], 'errors' => [ [ 'shape' => 'TooManyHealthChecks', ], [ 'shape' => 'HealthCheckAlreadyExists', ], [ 'shape' => 'InvalidInput', ], ], ], 'CreateHostedZone' => [ 'name' => 'CreateHostedZone', 'http' => [ 'method' => 'POST', 'requestUri' => '/2013-04-01/hostedzone', 'responseCode' => 201, ], 'input' => [ 'shape' => 'CreateHostedZoneRequest', 'locationName' => 'CreateHostedZoneRequest', 'xmlNamespace' => [ 'uri' => 'https://route53.amazonaws.com/doc/2013-04-01/', ], ], 'output' => [ 'shape' => 'CreateHostedZoneResponse', ], 'errors' => [ [ 'shape' => 'InvalidDomainName', ], [ 'shape' => 'HostedZoneAlreadyExists', ], [ 'shape' => 'TooManyHostedZones', ], [ 'shape' => 'InvalidVPCId', ], [ 'shape' => 'InvalidInput', ], [ 'shape' => 'DelegationSetNotAvailable', ], [ 'shape' => 'ConflictingDomainExists', ], [ 'shape' => 'NoSuchDelegationSet', ], [ 'shape' => 'DelegationSetNotReusable', ], ], ], 'CreateReusableDelegationSet' => [ 'name' => 'CreateReusableDelegationSet', 'http' => [ 'method' => 'POST', 'requestUri' => '/2013-04-01/delegationset', 'responseCode' => 201, ], 'input' => [ 'shape' => 'CreateReusableDelegationSetRequest', 'locationName' => 'CreateReusableDelegationSetRequest', 'xmlNamespace' => [ 'uri' => 'https://route53.amazonaws.com/doc/2013-04-01/', ], ], 'output' => [ 'shape' => 'CreateReusableDelegationSetResponse', ], 'errors' => [ [ 'shape' => 'DelegationSetAlreadyCreated', ], [ 'shape' => 'LimitsExceeded', ], [ 'shape' => 'HostedZoneNotFound', ], [ 'shape' => 'InvalidArgument', ], [ 'shape' => 'InvalidInput', ], [ 'shape' => 'DelegationSetNotAvailable', ], [ 'shape' => 'DelegationSetAlreadyReusable', ], ], ], 'CreateTrafficPolicy' => [ 'name' => 'CreateTrafficPolicy', 'http' => [ 'method' => 'POST', 'requestUri' => '/2013-04-01/trafficpolicy', 'responseCode' => 201, ], 'input' => [ 'shape' => 'CreateTrafficPolicyRequest', 'locationName' => 'CreateTrafficPolicyRequest', 'xmlNamespace' => [ 'uri' => 'https://route53.amazonaws.com/doc/2013-04-01/', ], ], 'output' => [ 'shape' => 'CreateTrafficPolicyResponse', ], 'errors' => [ [ 'shape' => 'InvalidInput', ], [ 'shape' => 'TooManyTrafficPolicies', ], [ 'shape' => 'TrafficPolicyAlreadyExists', ], [ 'shape' => 'InvalidTrafficPolicyDocument', ], ], ], 'CreateTrafficPolicyInstance' => [ 'name' => 'CreateTrafficPolicyInstance', 'http' => [ 'method' => 'POST', 'requestUri' => '/2013-04-01/trafficpolicyinstance', 'responseCode' => 201, ], 'input' => [ 'shape' => 'CreateTrafficPolicyInstanceRequest', 'locationName' => 'CreateTrafficPolicyInstanceRequest', 'xmlNamespace' => [ 'uri' => 'https://route53.amazonaws.com/doc/2013-04-01/', ], ], 'output' => [ 'shape' => 'CreateTrafficPolicyInstanceResponse', ], 'errors' => [ [ 'shape' => 'NoSuchHostedZone', ], [ 'shape' => 'InvalidInput', ], [ 'shape' => 'TooManyTrafficPolicyInstances', ], [ 'shape' => 'NoSuchTrafficPolicy', ], [ 'shape' => 'TrafficPolicyInstanceAlreadyExists', ], ], ], 'CreateTrafficPolicyVersion' => [ 'name' => 'CreateTrafficPolicyVersion', 'http' => [ 'method' => 'POST', 'requestUri' => '/2013-04-01/trafficpolicy/{Id}', 'responseCode' => 201, ], 'input' => [ 'shape' => 'CreateTrafficPolicyVersionRequest', 'locationName' => 'CreateTrafficPolicyVersionRequest', 'xmlNamespace' => [ 'uri' => 'https://route53.amazonaws.com/doc/2013-04-01/', ], ], 'output' => [ 'shape' => 'CreateTrafficPolicyVersionResponse', ], 'errors' => [ [ 'shape' => 'NoSuchTrafficPolicy', ], [ 'shape' => 'InvalidInput', ], [ 'shape' => 'ConcurrentModification', ], [ 'shape' => 'InvalidTrafficPolicyDocument', ], ], ], 'DeleteHealthCheck' => [ 'name' => 'DeleteHealthCheck', 'http' => [ 'method' => 'DELETE', 'requestUri' => '/2013-04-01/healthcheck/{HealthCheckId}', ], 'input' => [ 'shape' => 'DeleteHealthCheckRequest', ], 'output' => [ 'shape' => 'DeleteHealthCheckResponse', ], 'errors' => [ [ 'shape' => 'NoSuchHealthCheck', ], [ 'shape' => 'HealthCheckInUse', ], [ 'shape' => 'InvalidInput', ], ], ], 'DeleteHostedZone' => [ 'name' => 'DeleteHostedZone', 'http' => [ 'method' => 'DELETE', 'requestUri' => '/2013-04-01/hostedzone/{Id}', ], 'input' => [ 'shape' => 'DeleteHostedZoneRequest', ], 'output' => [ 'shape' => 'DeleteHostedZoneResponse', ], 'errors' => [ [ 'shape' => 'NoSuchHostedZone', ], [ 'shape' => 'HostedZoneNotEmpty', ], [ 'shape' => 'PriorRequestNotComplete', ], [ 'shape' => 'InvalidInput', ], ], ], 'DeleteReusableDelegationSet' => [ 'name' => 'DeleteReusableDelegationSet', 'http' => [ 'method' => 'DELETE', 'requestUri' => '/2013-04-01/delegationset/{Id}', ], 'input' => [ 'shape' => 'DeleteReusableDelegationSetRequest', ], 'output' => [ 'shape' => 'DeleteReusableDelegationSetResponse', ], 'errors' => [ [ 'shape' => 'NoSuchDelegationSet', ], [ 'shape' => 'DelegationSetInUse', ], [ 'shape' => 'DelegationSetNotReusable', ], [ 'shape' => 'InvalidInput', ], ], ], 'DeleteTrafficPolicy' => [ 'name' => 'DeleteTrafficPolicy', 'http' => [ 'method' => 'DELETE', 'requestUri' => '/2013-04-01/trafficpolicy/{Id}/{Version}', ], 'input' => [ 'shape' => 'DeleteTrafficPolicyRequest', ], 'output' => [ 'shape' => 'DeleteTrafficPolicyResponse', ], 'errors' => [ [ 'shape' => 'NoSuchTrafficPolicy', ], [ 'shape' => 'InvalidInput', ], [ 'shape' => 'TrafficPolicyInUse', ], [ 'shape' => 'ConcurrentModification', ], ], ], 'DeleteTrafficPolicyInstance' => [ 'name' => 'DeleteTrafficPolicyInstance', 'http' => [ 'method' => 'DELETE', 'requestUri' => '/2013-04-01/trafficpolicyinstance/{Id}', ], 'input' => [ 'shape' => 'DeleteTrafficPolicyInstanceRequest', ], 'output' => [ 'shape' => 'DeleteTrafficPolicyInstanceResponse', ], 'errors' => [ [ 'shape' => 'NoSuchTrafficPolicyInstance', ], [ 'shape' => 'InvalidInput', ], [ 'shape' => 'PriorRequestNotComplete', ], ], ], 'DisassociateVPCFromHostedZone' => [ 'name' => 'DisassociateVPCFromHostedZone', 'http' => [ 'method' => 'POST', 'requestUri' => '/2013-04-01/hostedzone/{Id}/disassociatevpc', ], 'input' => [ 'shape' => 'DisassociateVPCFromHostedZoneRequest', 'locationName' => 'DisassociateVPCFromHostedZoneRequest', 'xmlNamespace' => [ 'uri' => 'https://route53.amazonaws.com/doc/2013-04-01/', ], ], 'output' => [ 'shape' => 'DisassociateVPCFromHostedZoneResponse', ], 'errors' => [ [ 'shape' => 'NoSuchHostedZone', ], [ 'shape' => 'InvalidVPCId', ], [ 'shape' => 'VPCAssociationNotFound', ], [ 'shape' => 'LastVPCAssociation', ], [ 'shape' => 'InvalidInput', ], ], ], 'GetChange' => [ 'name' => 'GetChange', 'http' => [ 'method' => 'GET', 'requestUri' => '/2013-04-01/change/{Id}', ], 'input' => [ 'shape' => 'GetChangeRequest', ], 'output' => [ 'shape' => 'GetChangeResponse', ], 'errors' => [ [ 'shape' => 'NoSuchChange', ], [ 'shape' => 'InvalidInput', ], ], ], 'GetChangeDetails' => [ 'name' => 'GetChangeDetails', 'http' => [ 'method' => 'GET', 'requestUri' => '/2013-04-01/changedetails/{Id}', ], 'input' => [ 'shape' => 'GetChangeDetailsRequest', ], 'output' => [ 'shape' => 'GetChangeDetailsResponse', ], 'errors' => [ [ 'shape' => 'NoSuchChange', ], [ 'shape' => 'InvalidInput', ], ], ], 'GetCheckerIpRanges' => [ 'name' => 'GetCheckerIpRanges', 'http' => [ 'method' => 'GET', 'requestUri' => '/2013-04-01/checkeripranges', ], 'input' => [ 'shape' => 'GetCheckerIpRangesRequest', ], 'output' => [ 'shape' => 'GetCheckerIpRangesResponse', ], ], 'GetGeoLocation' => [ 'name' => 'GetGeoLocation', 'http' => [ 'method' => 'GET', 'requestUri' => '/2013-04-01/geolocation', ], 'input' => [ 'shape' => 'GetGeoLocationRequest', ], 'output' => [ 'shape' => 'GetGeoLocationResponse', ], 'errors' => [ [ 'shape' => 'NoSuchGeoLocation', ], [ 'shape' => 'InvalidInput', ], ], ], 'GetHealthCheck' => [ 'name' => 'GetHealthCheck', 'http' => [ 'method' => 'GET', 'requestUri' => '/2013-04-01/healthcheck/{HealthCheckId}', ], 'input' => [ 'shape' => 'GetHealthCheckRequest', ], 'output' => [ 'shape' => 'GetHealthCheckResponse', ], 'errors' => [ [ 'shape' => 'NoSuchHealthCheck', ], [ 'shape' => 'InvalidInput', ], [ 'shape' => 'IncompatibleVersion', ], ], ], 'GetHealthCheckCount' => [ 'name' => 'GetHealthCheckCount', 'http' => [ 'method' => 'GET', 'requestUri' => '/2013-04-01/healthcheckcount', ], 'input' => [ 'shape' => 'GetHealthCheckCountRequest', ], 'output' => [ 'shape' => 'GetHealthCheckCountResponse', ], ], 'GetHealthCheckLastFailureReason' => [ 'name' => 'GetHealthCheckLastFailureReason', 'http' => [ 'method' => 'GET', 'requestUri' => '/2013-04-01/healthcheck/{HealthCheckId}/lastfailurereason', ], 'input' => [ 'shape' => 'GetHealthCheckLastFailureReasonRequest', ], 'output' => [ 'shape' => 'GetHealthCheckLastFailureReasonResponse', ], 'errors' => [ [ 'shape' => 'NoSuchHealthCheck', ], [ 'shape' => 'InvalidInput', ], ], ], 'GetHealthCheckStatus' => [ 'name' => 'GetHealthCheckStatus', 'http' => [ 'method' => 'GET', 'requestUri' => '/2013-04-01/healthcheck/{HealthCheckId}/status', ], 'input' => [ 'shape' => 'GetHealthCheckStatusRequest', ], 'output' => [ 'shape' => 'GetHealthCheckStatusResponse', ], 'errors' => [ [ 'shape' => 'NoSuchHealthCheck', ], [ 'shape' => 'InvalidInput', ], ], ], 'GetHostedZone' => [ 'name' => 'GetHostedZone', 'http' => [ 'method' => 'GET', 'requestUri' => '/2013-04-01/hostedzone/{Id}', ], 'input' => [ 'shape' => 'GetHostedZoneRequest', ], 'output' => [ 'shape' => 'GetHostedZoneResponse', ], 'errors' => [ [ 'shape' => 'NoSuchHostedZone', ], [ 'shape' => 'InvalidInput', ], ], ], 'GetHostedZoneCount' => [ 'name' => 'GetHostedZoneCount', 'http' => [ 'method' => 'GET', 'requestUri' => '/2013-04-01/hostedzonecount', ], 'input' => [ 'shape' => 'GetHostedZoneCountRequest', ], 'output' => [ 'shape' => 'GetHostedZoneCountResponse', ], 'errors' => [ [ 'shape' => 'InvalidInput', ], ], ], 'GetReusableDelegationSet' => [ 'name' => 'GetReusableDelegationSet', 'http' => [ 'method' => 'GET', 'requestUri' => '/2013-04-01/delegationset/{Id}', ], 'input' => [ 'shape' => 'GetReusableDelegationSetRequest', ], 'output' => [ 'shape' => 'GetReusableDelegationSetResponse', ], 'errors' => [ [ 'shape' => 'NoSuchDelegationSet', ], [ 'shape' => 'DelegationSetNotReusable', ], [ 'shape' => 'InvalidInput', ], ], ], 'GetTrafficPolicy' => [ 'name' => 'GetTrafficPolicy', 'http' => [ 'method' => 'GET', 'requestUri' => '/2013-04-01/trafficpolicy/{Id}/{Version}', ], 'input' => [ 'shape' => 'GetTrafficPolicyRequest', ], 'output' => [ 'shape' => 'GetTrafficPolicyResponse', ], 'errors' => [ [ 'shape' => 'NoSuchTrafficPolicy', ], [ 'shape' => 'InvalidInput', ], ], ], 'GetTrafficPolicyInstance' => [ 'name' => 'GetTrafficPolicyInstance', 'http' => [ 'method' => 'GET', 'requestUri' => '/2013-04-01/trafficpolicyinstance/{Id}', ], 'input' => [ 'shape' => 'GetTrafficPolicyInstanceRequest', ], 'output' => [ 'shape' => 'GetTrafficPolicyInstanceResponse', ], 'errors' => [ [ 'shape' => 'NoSuchTrafficPolicyInstance', ], [ 'shape' => 'InvalidInput', ], ], ], 'GetTrafficPolicyInstanceCount' => [ 'name' => 'GetTrafficPolicyInstanceCount', 'http' => [ 'method' => 'GET', 'requestUri' => '/2013-04-01/trafficpolicyinstancecount', ], 'input' => [ 'shape' => 'GetTrafficPolicyInstanceCountRequest', ], 'output' => [ 'shape' => 'GetTrafficPolicyInstanceCountResponse', ], ], 'ListChangeBatchesByHostedZone' => [ 'name' => 'ListChangeBatchesByHostedZone', 'http' => [ 'method' => 'GET', 'requestUri' => '/2013-04-01/hostedzone/{Id}/changes', ], 'input' => [ 'shape' => 'ListChangeBatchesByHostedZoneRequest', ], 'output' => [ 'shape' => 'ListChangeBatchesByHostedZoneResponse', ], 'errors' => [ [ 'shape' => 'NoSuchHostedZone', ], [ 'shape' => 'InvalidInput', ], ], ], 'ListChangeBatchesByRRSet' => [ 'name' => 'ListChangeBatchesByRRSet', 'http' => [ 'method' => 'GET', 'requestUri' => '/2013-04-01/hostedzone/{Id}/rrsChanges', ], 'input' => [ 'shape' => 'ListChangeBatchesByRRSetRequest', ], 'output' => [ 'shape' => 'ListChangeBatchesByRRSetResponse', ], 'errors' => [ [ 'shape' => 'NoSuchHostedZone', ], [ 'shape' => 'InvalidInput', ], ], ], 'ListGeoLocations' => [ 'name' => 'ListGeoLocations', 'http' => [ 'method' => 'GET', 'requestUri' => '/2013-04-01/geolocations', ], 'input' => [ 'shape' => 'ListGeoLocationsRequest', ], 'output' => [ 'shape' => 'ListGeoLocationsResponse', ], 'errors' => [ [ 'shape' => 'InvalidInput', ], ], ], 'ListHealthChecks' => [ 'name' => 'ListHealthChecks', 'http' => [ 'method' => 'GET', 'requestUri' => '/2013-04-01/healthcheck', ], 'input' => [ 'shape' => 'ListHealthChecksRequest', ], 'output' => [ 'shape' => 'ListHealthChecksResponse', ], 'errors' => [ [ 'shape' => 'InvalidInput', ], [ 'shape' => 'IncompatibleVersion', ], ], ], 'ListHostedZones' => [ 'name' => 'ListHostedZones', 'http' => [ 'method' => 'GET', 'requestUri' => '/2013-04-01/hostedzone', ], 'input' => [ 'shape' => 'ListHostedZonesRequest', ], 'output' => [ 'shape' => 'ListHostedZonesResponse', ], 'errors' => [ [ 'shape' => 'InvalidInput', ], [ 'shape' => 'NoSuchDelegationSet', ], [ 'shape' => 'DelegationSetNotReusable', ], ], ], 'ListHostedZonesByName' => [ 'name' => 'ListHostedZonesByName', 'http' => [ 'method' => 'GET', 'requestUri' => '/2013-04-01/hostedzonesbyname', ], 'input' => [ 'shape' => 'ListHostedZonesByNameRequest', ], 'output' => [ 'shape' => 'ListHostedZonesByNameResponse', ], 'errors' => [ [ 'shape' => 'InvalidInput', ], [ 'shape' => 'InvalidDomainName', ], ], ], 'ListResourceRecordSets' => [ 'name' => 'ListResourceRecordSets', 'http' => [ 'method' => 'GET', 'requestUri' => '/2013-04-01/hostedzone/{Id}/rrset', ], 'input' => [ 'shape' => 'ListResourceRecordSetsRequest', ], 'output' => [ 'shape' => 'ListResourceRecordSetsResponse', ], 'errors' => [ [ 'shape' => 'NoSuchHostedZone', ], [ 'shape' => 'InvalidInput', ], ], ], 'ListReusableDelegationSets' => [ 'name' => 'ListReusableDelegationSets', 'http' => [ 'method' => 'GET', 'requestUri' => '/2013-04-01/delegationset', ], 'input' => [ 'shape' => 'ListReusableDelegationSetsRequest', ], 'output' => [ 'shape' => 'ListReusableDelegationSetsResponse', ], 'errors' => [ [ 'shape' => 'InvalidInput', ], ], ], 'ListTagsForResource' => [ 'name' => 'ListTagsForResource', 'http' => [ 'method' => 'GET', 'requestUri' => '/2013-04-01/tags/{ResourceType}/{ResourceId}', ], 'input' => [ 'shape' => 'ListTagsForResourceRequest', ], 'output' => [ 'shape' => 'ListTagsForResourceResponse', ], 'errors' => [ [ 'shape' => 'InvalidInput', ], [ 'shape' => 'NoSuchHealthCheck', ], [ 'shape' => 'NoSuchHostedZone', ], [ 'shape' => 'PriorRequestNotComplete', ], [ 'shape' => 'ThrottlingException', ], ], ], 'ListTagsForResources' => [ 'name' => 'ListTagsForResources', 'http' => [ 'method' => 'POST', 'requestUri' => '/2013-04-01/tags/{ResourceType}', ], 'input' => [ 'shape' => 'ListTagsForResourcesRequest', 'locationName' => 'ListTagsForResourcesRequest', 'xmlNamespace' => [ 'uri' => 'https://route53.amazonaws.com/doc/2013-04-01/', ], ], 'output' => [ 'shape' => 'ListTagsForResourcesResponse', ], 'errors' => [ [ 'shape' => 'InvalidInput', ], [ 'shape' => 'NoSuchHealthCheck', ], [ 'shape' => 'NoSuchHostedZone', ], [ 'shape' => 'PriorRequestNotComplete', ], [ 'shape' => 'ThrottlingException', ], ], ], 'ListTrafficPolicies' => [ 'name' => 'ListTrafficPolicies', 'http' => [ 'method' => 'GET', 'requestUri' => '/2013-04-01/trafficpolicies', ], 'input' => [ 'shape' => 'ListTrafficPoliciesRequest', ], 'output' => [ 'shape' => 'ListTrafficPoliciesResponse', ], 'errors' => [ [ 'shape' => 'InvalidInput', ], ], ], 'ListTrafficPolicyInstances' => [ 'name' => 'ListTrafficPolicyInstances', 'http' => [ 'method' => 'GET', 'requestUri' => '/2013-04-01/trafficpolicyinstances', ], 'input' => [ 'shape' => 'ListTrafficPolicyInstancesRequest', ], 'output' => [ 'shape' => 'ListTrafficPolicyInstancesResponse', ], 'errors' => [ [ 'shape' => 'InvalidInput', ], [ 'shape' => 'NoSuchTrafficPolicyInstance', ], ], ], 'ListTrafficPolicyInstancesByHostedZone' => [ 'name' => 'ListTrafficPolicyInstancesByHostedZone', 'http' => [ 'method' => 'GET', 'requestUri' => '/2013-04-01/trafficpolicyinstances/hostedzone', ], 'input' => [ 'shape' => 'ListTrafficPolicyInstancesByHostedZoneRequest', ], 'output' => [ 'shape' => 'ListTrafficPolicyInstancesByHostedZoneResponse', ], 'errors' => [ [ 'shape' => 'InvalidInput', ], [ 'shape' => 'NoSuchTrafficPolicyInstance', ], [ 'shape' => 'NoSuchHostedZone', ], ], ], 'ListTrafficPolicyInstancesByPolicy' => [ 'name' => 'ListTrafficPolicyInstancesByPolicy', 'http' => [ 'method' => 'GET', 'requestUri' => '/2013-04-01/trafficpolicyinstances/trafficpolicy', ], 'input' => [ 'shape' => 'ListTrafficPolicyInstancesByPolicyRequest', ], 'output' => [ 'shape' => 'ListTrafficPolicyInstancesByPolicyResponse', ], 'errors' => [ [ 'shape' => 'InvalidInput', ], [ 'shape' => 'NoSuchTrafficPolicyInstance', ], [ 'shape' => 'NoSuchTrafficPolicy', ], ], ], 'ListTrafficPolicyVersions' => [ 'name' => 'ListTrafficPolicyVersions', 'http' => [ 'method' => 'GET', 'requestUri' => '/2013-04-01/trafficpolicies/{Id}/versions', ], 'input' => [ 'shape' => 'ListTrafficPolicyVersionsRequest', ], 'output' => [ 'shape' => 'ListTrafficPolicyVersionsResponse', ], 'errors' => [ [ 'shape' => 'InvalidInput', ], [ 'shape' => 'NoSuchTrafficPolicy', ], ], ], 'UpdateHealthCheck' => [ 'name' => 'UpdateHealthCheck', 'http' => [ 'method' => 'POST', 'requestUri' => '/2013-04-01/healthcheck/{HealthCheckId}', ], 'input' => [ 'shape' => 'UpdateHealthCheckRequest', 'locationName' => 'UpdateHealthCheckRequest', 'xmlNamespace' => [ 'uri' => 'https://route53.amazonaws.com/doc/2013-04-01/', ], ], 'output' => [ 'shape' => 'UpdateHealthCheckResponse', ], 'errors' => [ [ 'shape' => 'NoSuchHealthCheck', ], [ 'shape' => 'InvalidInput', ], [ 'shape' => 'HealthCheckVersionMismatch', ], ], ], 'UpdateHostedZoneComment' => [ 'name' => 'UpdateHostedZoneComment', 'http' => [ 'method' => 'POST', 'requestUri' => '/2013-04-01/hostedzone/{Id}', ], 'input' => [ 'shape' => 'UpdateHostedZoneCommentRequest', 'locationName' => 'UpdateHostedZoneCommentRequest', 'xmlNamespace' => [ 'uri' => 'https://route53.amazonaws.com/doc/2013-04-01/', ], ], 'output' => [ 'shape' => 'UpdateHostedZoneCommentResponse', ], 'errors' => [ [ 'shape' => 'NoSuchHostedZone', ], [ 'shape' => 'InvalidInput', ], ], ], 'UpdateTrafficPolicyComment' => [ 'name' => 'UpdateTrafficPolicyComment', 'http' => [ 'method' => 'POST', 'requestUri' => '/2013-04-01/trafficpolicy/{Id}/{Version}', ], 'input' => [ 'shape' => 'UpdateTrafficPolicyCommentRequest', 'locationName' => 'UpdateTrafficPolicyCommentRequest', 'xmlNamespace' => [ 'uri' => 'https://route53.amazonaws.com/doc/2013-04-01/', ], ], 'output' => [ 'shape' => 'UpdateTrafficPolicyCommentResponse', ], 'errors' => [ [ 'shape' => 'InvalidInput', ], [ 'shape' => 'NoSuchTrafficPolicy', ], [ 'shape' => 'ConcurrentModification', ], ], ], 'UpdateTrafficPolicyInstance' => [ 'name' => 'UpdateTrafficPolicyInstance', 'http' => [ 'method' => 'POST', 'requestUri' => '/2013-04-01/trafficpolicyinstance/{Id}', ], 'input' => [ 'shape' => 'UpdateTrafficPolicyInstanceRequest', 'locationName' => 'UpdateTrafficPolicyInstanceRequest', 'xmlNamespace' => [ 'uri' => 'https://route53.amazonaws.com/doc/2013-04-01/', ], ], 'output' => [ 'shape' => 'UpdateTrafficPolicyInstanceResponse', ], 'errors' => [ [ 'shape' => 'InvalidInput', ], [ 'shape' => 'NoSuchTrafficPolicy', ], [ 'shape' => 'NoSuchTrafficPolicyInstance', ], [ 'shape' => 'PriorRequestNotComplete', ], [ 'shape' => 'ConflictingTypes', ], ], ], ], 'shapes' => [ 'AWSAccountID' => [ 'type' => 'string', ], 'AliasHealthEnabled' => [ 'type' => 'boolean', ], 'AliasTarget' => [ 'type' => 'structure', 'required' => [ 'HostedZoneId', 'DNSName', 'EvaluateTargetHealth', ], 'members' => [ 'HostedZoneId' => [ 'shape' => 'ResourceId', ], 'DNSName' => [ 'shape' => 'DNSName', ], 'EvaluateTargetHealth' => [ 'shape' => 'AliasHealthEnabled', ], ], ], 'AssociateVPCComment' => [ 'type' => 'string', ], 'AssociateVPCWithHostedZoneRequest' => [ 'type' => 'structure', 'required' => [ 'HostedZoneId', 'VPC', ], 'members' => [ 'HostedZoneId' => [ 'shape' => 'ResourceId', 'location' => 'uri', 'locationName' => 'Id', ], 'VPC' => [ 'shape' => 'VPC', ], 'Comment' => [ 'shape' => 'AssociateVPCComment', ], ], ], 'AssociateVPCWithHostedZoneResponse' => [ 'type' => 'structure', 'required' => [ 'ChangeInfo', ], 'members' => [ 'ChangeInfo' => [ 'shape' => 'ChangeInfo', ], ], ], 'Change' => [ 'type' => 'structure', 'required' => [ 'Action', 'ResourceRecordSet', ], 'members' => [ 'Action' => [ 'shape' => 'ChangeAction', ], 'ResourceRecordSet' => [ 'shape' => 'ResourceRecordSet', ], ], ], 'ChangeAction' => [ 'type' => 'string', 'enum' => [ 'CREATE', 'DELETE', 'UPSERT', ], ], 'ChangeBatch' => [ 'type' => 'structure', 'required' => [ 'Changes', ], 'members' => [ 'Comment' => [ 'shape' => 'ResourceDescription', ], 'Changes' => [ 'shape' => 'Changes', ], ], ], 'ChangeBatchRecord' => [ 'type' => 'structure', 'required' => [ 'Id', 'Status', ], 'members' => [ 'Id' => [ 'shape' => 'ResourceId', ], 'SubmittedAt' => [ 'shape' => 'TimeStamp', ], 'Status' => [ 'shape' => 'ChangeStatus', ], 'Comment' => [ 'shape' => 'ResourceDescription', ], 'Submitter' => [ 'shape' => 'AWSAccountID', ], 'Changes' => [ 'shape' => 'Changes', ], ], ], 'ChangeBatchRecords' => [ 'type' => 'list', 'member' => [ 'shape' => 'ChangeBatchRecord', 'locationName' => 'ChangeBatchRecord', ], 'min' => 1, ], 'ChangeInfo' => [ 'type' => 'structure', 'required' => [ 'Id', 'Status', 'SubmittedAt', ], 'members' => [ 'Id' => [ 'shape' => 'ResourceId', ], 'Status' => [ 'shape' => 'ChangeStatus', ], 'SubmittedAt' => [ 'shape' => 'TimeStamp', ], 'Comment' => [ 'shape' => 'ResourceDescription', ], ], ], 'ChangeResourceRecordSetsRequest' => [ 'type' => 'structure', 'required' => [ 'HostedZoneId', 'ChangeBatch', ], 'members' => [ 'HostedZoneId' => [ 'shape' => 'ResourceId', 'location' => 'uri', 'locationName' => 'Id', ], 'ChangeBatch' => [ 'shape' => 'ChangeBatch', ], ], ], 'ChangeResourceRecordSetsResponse' => [ 'type' => 'structure', 'required' => [ 'ChangeInfo', ], 'members' => [ 'ChangeInfo' => [ 'shape' => 'ChangeInfo', ], ], ], 'ChangeStatus' => [ 'type' => 'string', 'enum' => [ 'PENDING', 'INSYNC', ], ], 'ChangeTagsForResourceRequest' => [ 'type' => 'structure', 'required' => [ 'ResourceType', 'ResourceId', ], 'members' => [ 'ResourceType' => [ 'shape' => 'TagResourceType', 'location' => 'uri', 'locationName' => 'ResourceType', ], 'ResourceId' => [ 'shape' => 'TagResourceId', 'location' => 'uri', 'locationName' => 'ResourceId', ], 'AddTags' => [ 'shape' => 'TagList', ], 'RemoveTagKeys' => [ 'shape' => 'TagKeyList', ], ], ], 'ChangeTagsForResourceResponse' => [ 'type' => 'structure', 'members' => [], ], 'Changes' => [ 'type' => 'list', 'member' => [ 'shape' => 'Change', 'locationName' => 'Change', ], 'min' => 1, ], 'CheckerIpRanges' => [ 'type' => 'list', 'member' => [ 'shape' => 'IPAddressCidr', ], ], 'ChildHealthCheckList' => [ 'type' => 'list', 'member' => [ 'shape' => 'HealthCheckId', 'locationName' => 'ChildHealthCheck', ], 'max' => 256, ], 'ConcurrentModification' => [ 'type' => 'structure', 'members' => [ 'message' => [ 'shape' => 'ErrorMessage', ], ], 'error' => [ 'httpStatusCode' => 400, ], 'exception' => true, ], 'ConflictingDomainExists' => [ 'type' => 'structure', 'members' => [ 'message' => [ 'shape' => 'ErrorMessage', ], ], 'exception' => true, ], 'ConflictingTypes' => [ 'type' => 'structure', 'members' => [ 'message' => [ 'shape' => 'ErrorMessage', ], ], 'error' => [ 'httpStatusCode' => 400, ], 'exception' => true, ], 'CreateHealthCheckRequest' => [ 'type' => 'structure', 'required' => [ 'CallerReference', 'HealthCheckConfig', ], 'members' => [ 'CallerReference' => [ 'shape' => 'HealthCheckNonce', ], 'HealthCheckConfig' => [ 'shape' => 'HealthCheckConfig', ], ], ], 'CreateHealthCheckResponse' => [ 'type' => 'structure', 'required' => [ 'HealthCheck', 'Location', ], 'members' => [ 'HealthCheck' => [ 'shape' => 'HealthCheck', ], 'Location' => [ 'shape' => 'ResourceURI', 'location' => 'header', 'locationName' => 'Location', ], ], ], 'CreateHostedZoneRequest' => [ 'type' => 'structure', 'required' => [ 'Name', 'CallerReference', ], 'members' => [ 'Name' => [ 'shape' => 'DNSName', ], 'VPC' => [ 'shape' => 'VPC', ], 'CallerReference' => [ 'shape' => 'Nonce', ], 'HostedZoneConfig' => [ 'shape' => 'HostedZoneConfig', ], 'DelegationSetId' => [ 'shape' => 'ResourceId', ], ], ], 'CreateHostedZoneResponse' => [ 'type' => 'structure', 'required' => [ 'HostedZone', 'ChangeInfo', 'DelegationSet', 'Location', ], 'members' => [ 'HostedZone' => [ 'shape' => 'HostedZone', ], 'ChangeInfo' => [ 'shape' => 'ChangeInfo', ], 'DelegationSet' => [ 'shape' => 'DelegationSet', ], 'VPC' => [ 'shape' => 'VPC', ], 'Location' => [ 'shape' => 'ResourceURI', 'location' => 'header', 'locationName' => 'Location', ], ], ], 'CreateReusableDelegationSetRequest' => [ 'type' => 'structure', 'required' => [ 'CallerReference', ], 'members' => [ 'CallerReference' => [ 'shape' => 'Nonce', ], 'HostedZoneId' => [ 'shape' => 'ResourceId', ], ], ], 'CreateReusableDelegationSetResponse' => [ 'type' => 'structure', 'required' => [ 'DelegationSet', 'Location', ], 'members' => [ 'DelegationSet' => [ 'shape' => 'DelegationSet', ], 'Location' => [ 'shape' => 'ResourceURI', 'location' => 'header', 'locationName' => 'Location', ], ], ], 'CreateTrafficPolicyInstanceRequest' => [ 'type' => 'structure', 'required' => [ 'HostedZoneId', 'Name', 'TTL', 'TrafficPolicyId', 'TrafficPolicyVersion', ], 'members' => [ 'HostedZoneId' => [ 'shape' => 'ResourceId', ], 'Name' => [ 'shape' => 'DNSName', ], 'TTL' => [ 'shape' => 'TTL', ], 'TrafficPolicyId' => [ 'shape' => 'TrafficPolicyId', ], 'TrafficPolicyVersion' => [ 'shape' => 'TrafficPolicyVersion', ], ], ], 'CreateTrafficPolicyInstanceResponse' => [ 'type' => 'structure', 'required' => [ 'TrafficPolicyInstance', 'Location', ], 'members' => [ 'TrafficPolicyInstance' => [ 'shape' => 'TrafficPolicyInstance', ], 'Location' => [ 'shape' => 'ResourceURI', 'location' => 'header', 'locationName' => 'Location', ], ], ], 'CreateTrafficPolicyRequest' => [ 'type' => 'structure', 'required' => [ 'Name', 'Document', ], 'members' => [ 'Name' => [ 'shape' => 'TrafficPolicyName', ], 'Document' => [ 'shape' => 'TrafficPolicyDocument', ], 'Comment' => [ 'shape' => 'TrafficPolicyComment', ], ], ], 'CreateTrafficPolicyResponse' => [ 'type' => 'structure', 'required' => [ 'TrafficPolicy', 'Location', ], 'members' => [ 'TrafficPolicy' => [ 'shape' => 'TrafficPolicy', ], 'Location' => [ 'shape' => 'ResourceURI', 'location' => 'header', 'locationName' => 'Location', ], ], ], 'CreateTrafficPolicyVersionRequest' => [ 'type' => 'structure', 'required' => [ 'Id', 'Document', ], 'members' => [ 'Id' => [ 'shape' => 'TrafficPolicyId', 'location' => 'uri', 'locationName' => 'Id', ], 'Document' => [ 'shape' => 'TrafficPolicyDocument', ], 'Comment' => [ 'shape' => 'TrafficPolicyComment', ], ], ], 'CreateTrafficPolicyVersionResponse' => [ 'type' => 'structure', 'required' => [ 'TrafficPolicy', 'Location', ], 'members' => [ 'TrafficPolicy' => [ 'shape' => 'TrafficPolicy', ], 'Location' => [ 'shape' => 'ResourceURI', 'location' => 'header', 'locationName' => 'Location', ], ], ], 'DNSName' => [ 'type' => 'string', 'max' => 1024, ], 'Date' => [ 'type' => 'string', 'max' => 256, ], 'DelegationSet' => [ 'type' => 'structure', 'required' => [ 'NameServers', ], 'members' => [ 'Id' => [ 'shape' => 'ResourceId', ], 'CallerReference' => [ 'shape' => 'Nonce', ], 'NameServers' => [ 'shape' => 'DelegationSetNameServers', ], ], ], 'DelegationSetAlreadyCreated' => [ 'type' => 'structure', 'members' => [ 'message' => [ 'shape' => 'ErrorMessage', ], ], 'exception' => true, ], 'DelegationSetAlreadyReusable' => [ 'type' => 'structure', 'members' => [ 'message' => [ 'shape' => 'ErrorMessage', ], ], 'exception' => true, ], 'DelegationSetInUse' => [ 'type' => 'structure', 'members' => [ 'message' => [ 'shape' => 'ErrorMessage', ], ], 'exception' => true, ], 'DelegationSetNameServers' => [ 'type' => 'list', 'member' => [ 'shape' => 'DNSName', 'locationName' => 'NameServer', ], 'min' => 1, ], 'DelegationSetNotAvailable' => [ 'type' => 'structure', 'members' => [ 'message' => [ 'shape' => 'ErrorMessage', ], ], 'exception' => true, ], 'DelegationSetNotReusable' => [ 'type' => 'structure', 'members' => [ 'message' => [ 'shape' => 'ErrorMessage', ], ], 'exception' => true, ], 'DelegationSets' => [ 'type' => 'list', 'member' => [ 'shape' => 'DelegationSet', 'locationName' => 'DelegationSet', ], ], 'DeleteHealthCheckRequest' => [ 'type' => 'structure', 'required' => [ 'HealthCheckId', ], 'members' => [ 'HealthCheckId' => [ 'shape' => 'HealthCheckId', 'location' => 'uri', 'locationName' => 'HealthCheckId', ], ], ], 'DeleteHealthCheckResponse' => [ 'type' => 'structure', 'members' => [], ], 'DeleteHostedZoneRequest' => [ 'type' => 'structure', 'required' => [ 'Id', ], 'members' => [ 'Id' => [ 'shape' => 'ResourceId', 'location' => 'uri', 'locationName' => 'Id', ], ], ], 'DeleteHostedZoneResponse' => [ 'type' => 'structure', 'required' => [ 'ChangeInfo', ], 'members' => [ 'ChangeInfo' => [ 'shape' => 'ChangeInfo', ], ], ], 'DeleteReusableDelegationSetRequest' => [ 'type' => 'structure', 'required' => [ 'Id', ], 'members' => [ 'Id' => [ 'shape' => 'ResourceId', 'location' => 'uri', 'locationName' => 'Id', ], ], ], 'DeleteReusableDelegationSetResponse' => [ 'type' => 'structure', 'members' => [], ], 'DeleteTrafficPolicyInstanceRequest' => [ 'type' => 'structure', 'required' => [ 'Id', ], 'members' => [ 'Id' => [ 'shape' => 'TrafficPolicyInstanceId', 'location' => 'uri', 'locationName' => 'Id', ], ], ], 'DeleteTrafficPolicyInstanceResponse' => [ 'type' => 'structure', 'members' => [], ], 'DeleteTrafficPolicyRequest' => [ 'type' => 'structure', 'required' => [ 'Id', 'Version', ], 'members' => [ 'Id' => [ 'shape' => 'TrafficPolicyId', 'location' => 'uri', 'locationName' => 'Id', ], 'Version' => [ 'shape' => 'TrafficPolicyVersion', 'location' => 'uri', 'locationName' => 'Version', ], ], ], 'DeleteTrafficPolicyResponse' => [ 'type' => 'structure', 'members' => [], ], 'DisassociateVPCComment' => [ 'type' => 'string', ], 'DisassociateVPCFromHostedZoneRequest' => [ 'type' => 'structure', 'required' => [ 'HostedZoneId', 'VPC', ], 'members' => [ 'HostedZoneId' => [ 'shape' => 'ResourceId', 'location' => 'uri', 'locationName' => 'Id', ], 'VPC' => [ 'shape' => 'VPC', ], 'Comment' => [ 'shape' => 'DisassociateVPCComment', ], ], ], 'DisassociateVPCFromHostedZoneResponse' => [ 'type' => 'structure', 'required' => [ 'ChangeInfo', ], 'members' => [ 'ChangeInfo' => [ 'shape' => 'ChangeInfo', ], ], ], 'ErrorMessage' => [ 'type' => 'string', ], 'ErrorMessages' => [ 'type' => 'list', 'member' => [ 'shape' => 'ErrorMessage', 'locationName' => 'Message', ], ], 'FailureThreshold' => [ 'type' => 'integer', 'max' => 10, 'min' => 1, ], 'FullyQualifiedDomainName' => [ 'type' => 'string', 'max' => 255, ], 'GeoLocation' => [ 'type' => 'structure', 'members' => [ 'ContinentCode' => [ 'shape' => 'GeoLocationContinentCode', ], 'CountryCode' => [ 'shape' => 'GeoLocationCountryCode', ], 'SubdivisionCode' => [ 'shape' => 'GeoLocationSubdivisionCode', ], ], ], 'GeoLocationContinentCode' => [ 'type' => 'string', 'max' => 2, 'min' => 2, ], 'GeoLocationContinentName' => [ 'type' => 'string', 'max' => 32, 'min' => 1, ], 'GeoLocationCountryCode' => [ 'type' => 'string', 'max' => 2, 'min' => 1, ], 'GeoLocationCountryName' => [ 'type' => 'string', 'max' => 64, 'min' => 1, ], 'GeoLocationDetails' => [ 'type' => 'structure', 'members' => [ 'ContinentCode' => [ 'shape' => 'GeoLocationContinentCode', ], 'ContinentName' => [ 'shape' => 'GeoLocationContinentName', ], 'CountryCode' => [ 'shape' => 'GeoLocationCountryCode', ], 'CountryName' => [ 'shape' => 'GeoLocationCountryName', ], 'SubdivisionCode' => [ 'shape' => 'GeoLocationSubdivisionCode', ], 'SubdivisionName' => [ 'shape' => 'GeoLocationSubdivisionName', ], ], ], 'GeoLocationDetailsList' => [ 'type' => 'list', 'member' => [ 'shape' => 'GeoLocationDetails', 'locationName' => 'GeoLocationDetails', ], ], 'GeoLocationSubdivisionCode' => [ 'type' => 'string', 'max' => 3, 'min' => 1, ], 'GeoLocationSubdivisionName' => [ 'type' => 'string', 'max' => 64, 'min' => 1, ], 'GetChangeDetailsRequest' => [ 'type' => 'structure', 'required' => [ 'Id', ], 'members' => [ 'Id' => [ 'shape' => 'ResourceId', 'location' => 'uri', 'locationName' => 'Id', ], ], ], 'GetChangeDetailsResponse' => [ 'type' => 'structure', 'required' => [ 'ChangeBatchRecord', ], 'members' => [ 'ChangeBatchRecord' => [ 'shape' => 'ChangeBatchRecord', ], ], ], 'GetChangeRequest' => [ 'type' => 'structure', 'required' => [ 'Id', ], 'members' => [ 'Id' => [ 'shape' => 'ResourceId', 'location' => 'uri', 'locationName' => 'Id', ], ], ], 'GetChangeResponse' => [ 'type' => 'structure', 'required' => [ 'ChangeInfo', ], 'members' => [ 'ChangeInfo' => [ 'shape' => 'ChangeInfo', ], ], ], 'GetCheckerIpRangesRequest' => [ 'type' => 'structure', 'members' => [], ], 'GetCheckerIpRangesResponse' => [ 'type' => 'structure', 'required' => [ 'CheckerIpRanges', ], 'members' => [ 'CheckerIpRanges' => [ 'shape' => 'CheckerIpRanges', ], ], ], 'GetGeoLocationRequest' => [ 'type' => 'structure', 'members' => [ 'ContinentCode' => [ 'shape' => 'GeoLocationContinentCode', 'location' => 'querystring', 'locationName' => 'continentcode', ], 'CountryCode' => [ 'shape' => 'GeoLocationCountryCode', 'location' => 'querystring', 'locationName' => 'countrycode', ], 'SubdivisionCode' => [ 'shape' => 'GeoLocationSubdivisionCode', 'location' => 'querystring', 'locationName' => 'subdivisioncode', ], ], ], 'GetGeoLocationResponse' => [ 'type' => 'structure', 'required' => [ 'GeoLocationDetails', ], 'members' => [ 'GeoLocationDetails' => [ 'shape' => 'GeoLocationDetails', ], ], ], 'GetHealthCheckCountRequest' => [ 'type' => 'structure', 'members' => [], ], 'GetHealthCheckCountResponse' => [ 'type' => 'structure', 'required' => [ 'HealthCheckCount', ], 'members' => [ 'HealthCheckCount' => [ 'shape' => 'HealthCheckCount', ], ], ], 'GetHealthCheckLastFailureReasonRequest' => [ 'type' => 'structure', 'required' => [ 'HealthCheckId', ], 'members' => [ 'HealthCheckId' => [ 'shape' => 'HealthCheckId', 'location' => 'uri', 'locationName' => 'HealthCheckId', ], ], ], 'GetHealthCheckLastFailureReasonResponse' => [ 'type' => 'structure', 'required' => [ 'HealthCheckObservations', ], 'members' => [ 'HealthCheckObservations' => [ 'shape' => 'HealthCheckObservations', ], ], ], 'GetHealthCheckRequest' => [ 'type' => 'structure', 'required' => [ 'HealthCheckId', ], 'members' => [ 'HealthCheckId' => [ 'shape' => 'HealthCheckId', 'location' => 'uri', 'locationName' => 'HealthCheckId', ], ], ], 'GetHealthCheckResponse' => [ 'type' => 'structure', 'required' => [ 'HealthCheck', ], 'members' => [ 'HealthCheck' => [ 'shape' => 'HealthCheck', ], ], ], 'GetHealthCheckStatusRequest' => [ 'type' => 'structure', 'required' => [ 'HealthCheckId', ], 'members' => [ 'HealthCheckId' => [ 'shape' => 'HealthCheckId', 'location' => 'uri', 'locationName' => 'HealthCheckId', ], ], ], 'GetHealthCheckStatusResponse' => [ 'type' => 'structure', 'required' => [ 'HealthCheckObservations', ], 'members' => [ 'HealthCheckObservations' => [ 'shape' => 'HealthCheckObservations', ], ], ], 'GetHostedZoneCountRequest' => [ 'type' => 'structure', 'members' => [], ], 'GetHostedZoneCountResponse' => [ 'type' => 'structure', 'required' => [ 'HostedZoneCount', ], 'members' => [ 'HostedZoneCount' => [ 'shape' => 'HostedZoneCount', ], ], ], 'GetHostedZoneRequest' => [ 'type' => 'structure', 'required' => [ 'Id', ], 'members' => [ 'Id' => [ 'shape' => 'ResourceId', 'location' => 'uri', 'locationName' => 'Id', ], ], ], 'GetHostedZoneResponse' => [ 'type' => 'structure', 'required' => [ 'HostedZone', ], 'members' => [ 'HostedZone' => [ 'shape' => 'HostedZone', ], 'DelegationSet' => [ 'shape' => 'DelegationSet', ], 'VPCs' => [ 'shape' => 'VPCs', ], ], ], 'GetReusableDelegationSetRequest' => [ 'type' => 'structure', 'required' => [ 'Id', ], 'members' => [ 'Id' => [ 'shape' => 'ResourceId', 'location' => 'uri', 'locationName' => 'Id', ], ], ], 'GetReusableDelegationSetResponse' => [ 'type' => 'structure', 'required' => [ 'DelegationSet', ], 'members' => [ 'DelegationSet' => [ 'shape' => 'DelegationSet', ], ], ], 'GetTrafficPolicyInstanceCountRequest' => [ 'type' => 'structure', 'members' => [], ], 'GetTrafficPolicyInstanceCountResponse' => [ 'type' => 'structure', 'required' => [ 'TrafficPolicyInstanceCount', ], 'members' => [ 'TrafficPolicyInstanceCount' => [ 'shape' => 'TrafficPolicyInstanceCount', ], ], ], 'GetTrafficPolicyInstanceRequest' => [ 'type' => 'structure', 'required' => [ 'Id', ], 'members' => [ 'Id' => [ 'shape' => 'TrafficPolicyInstanceId', 'location' => 'uri', 'locationName' => 'Id', ], ], ], 'GetTrafficPolicyInstanceResponse' => [ 'type' => 'structure', 'required' => [ 'TrafficPolicyInstance', ], 'members' => [ 'TrafficPolicyInstance' => [ 'shape' => 'TrafficPolicyInstance', ], ], ], 'GetTrafficPolicyRequest' => [ 'type' => 'structure', 'required' => [ 'Id', 'Version', ], 'members' => [ 'Id' => [ 'shape' => 'TrafficPolicyId', 'location' => 'uri', 'locationName' => 'Id', ], 'Version' => [ 'shape' => 'TrafficPolicyVersion', 'location' => 'uri', 'locationName' => 'Version', ], ], ], 'GetTrafficPolicyResponse' => [ 'type' => 'structure', 'required' => [ 'TrafficPolicy', ], 'members' => [ 'TrafficPolicy' => [ 'shape' => 'TrafficPolicy', ], ], ], 'HealthCheck' => [ 'type' => 'structure', 'required' => [ 'Id', 'CallerReference', 'HealthCheckConfig', 'HealthCheckVersion', ], 'members' => [ 'Id' => [ 'shape' => 'HealthCheckId', ], 'CallerReference' => [ 'shape' => 'HealthCheckNonce', ], 'HealthCheckConfig' => [ 'shape' => 'HealthCheckConfig', ], 'HealthCheckVersion' => [ 'shape' => 'HealthCheckVersion', ], ], ], 'HealthCheckAlreadyExists' => [ 'type' => 'structure', 'members' => [ 'message' => [ 'shape' => 'ErrorMessage', ], ], 'error' => [ 'httpStatusCode' => 409, ], 'exception' => true, ], 'HealthCheckConfig' => [ 'type' => 'structure', 'required' => [ 'Type', ], 'members' => [ 'IPAddress' => [ 'shape' => 'IPAddress', ], 'Port' => [ 'shape' => 'Port', ], 'Type' => [ 'shape' => 'HealthCheckType', ], 'ResourcePath' => [ 'shape' => 'ResourcePath', ], 'FullyQualifiedDomainName' => [ 'shape' => 'FullyQualifiedDomainName', ], 'SearchString' => [ 'shape' => 'SearchString', ], 'RequestInterval' => [ 'shape' => 'RequestInterval', ], 'FailureThreshold' => [ 'shape' => 'FailureThreshold', ], 'MeasureLatency' => [ 'shape' => 'MeasureLatency', ], 'Inverted' => [ 'shape' => 'Inverted', ], 'HealthThreshold' => [ 'shape' => 'HealthThreshold', ], 'ChildHealthChecks' => [ 'shape' => 'ChildHealthCheckList', ], ], ], 'HealthCheckCount' => [ 'type' => 'long', ], 'HealthCheckId' => [ 'type' => 'string', 'max' => 64, ], 'HealthCheckInUse' => [ 'type' => 'structure', 'members' => [ 'message' => [ 'shape' => 'ErrorMessage', ], ], 'error' => [ 'httpStatusCode' => 400, ], 'exception' => true, ], 'HealthCheckNonce' => [ 'type' => 'string', 'max' => 64, 'min' => 1, ], 'HealthCheckObservation' => [ 'type' => 'structure', 'members' => [ 'IPAddress' => [ 'shape' => 'IPAddress', ], 'StatusReport' => [ 'shape' => 'StatusReport', ], ], ], 'HealthCheckObservations' => [ 'type' => 'list', 'member' => [ 'shape' => 'HealthCheckObservation', 'locationName' => 'HealthCheckObservation', ], ], 'HealthCheckType' => [ 'type' => 'string', 'enum' => [ 'HTTP', 'HTTPS', 'HTTP_STR_MATCH', 'HTTPS_STR_MATCH', 'TCP', 'CALCULATED', ], ], 'HealthCheckVersion' => [ 'type' => 'long', 'min' => 1, ], 'HealthCheckVersionMismatch' => [ 'type' => 'structure', 'members' => [ 'message' => [ 'shape' => 'ErrorMessage', ], ], 'error' => [ 'httpStatusCode' => 409, ], 'exception' => true, ], 'HealthChecks' => [ 'type' => 'list', 'member' => [ 'shape' => 'HealthCheck', 'locationName' => 'HealthCheck', ], ], 'HealthThreshold' => [ 'type' => 'integer', 'max' => 256, 'min' => 0, ], 'HostedZone' => [ 'type' => 'structure', 'required' => [ 'Id', 'Name', 'CallerReference', ], 'members' => [ 'Id' => [ 'shape' => 'ResourceId', ], 'Name' => [ 'shape' => 'DNSName', ], 'CallerReference' => [ 'shape' => 'Nonce', ], 'Config' => [ 'shape' => 'HostedZoneConfig', ], 'ResourceRecordSetCount' => [ 'shape' => 'HostedZoneRRSetCount', ], ], ], 'HostedZoneAlreadyExists' => [ 'type' => 'structure', 'members' => [ 'message' => [ 'shape' => 'ErrorMessage', ], ], 'error' => [ 'httpStatusCode' => 409, ], 'exception' => true, ], 'HostedZoneConfig' => [ 'type' => 'structure', 'members' => [ 'Comment' => [ 'shape' => 'ResourceDescription', ], 'PrivateZone' => [ 'shape' => 'IsPrivateZone', ], ], ], 'HostedZoneCount' => [ 'type' => 'long', ], 'HostedZoneNotEmpty' => [ 'type' => 'structure', 'members' => [ 'message' => [ 'shape' => 'ErrorMessage', ], ], 'error' => [ 'httpStatusCode' => 400, ], 'exception' => true, ], 'HostedZoneNotFound' => [ 'type' => 'structure', 'members' => [ 'message' => [ 'shape' => 'ErrorMessage', ], ], 'exception' => true, ], 'HostedZoneRRSetCount' => [ 'type' => 'long', ], 'HostedZones' => [ 'type' => 'list', 'member' => [ 'shape' => 'HostedZone', 'locationName' => 'HostedZone', ], ], 'IPAddress' => [ 'type' => 'string', 'max' => 15, 'pattern' => '^(([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5]]\\.]{3}([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5]]$', ], 'IPAddressCidr' => [ 'type' => 'string', ], 'IncompatibleVersion' => [ 'type' => 'structure', 'members' => [ 'message' => [ 'shape' => 'ErrorMessage', ], ], 'error' => [ 'httpStatusCode' => 400, ], 'exception' => true, ], 'InvalidArgument' => [ 'type' => 'structure', 'members' => [ 'message' => [ 'shape' => 'ErrorMessage', ], ], 'exception' => true, ], 'InvalidChangeBatch' => [ 'type' => 'structure', 'members' => [ 'messages' => [ 'shape' => 'ErrorMessages', ], ], 'exception' => true, ], 'InvalidDomainName' => [ 'type' => 'structure', 'members' => [ 'message' => [ 'shape' => 'ErrorMessage', ], ], 'error' => [ 'httpStatusCode' => 400, ], 'exception' => true, ], 'InvalidInput' => [ 'type' => 'structure', 'members' => [ 'message' => [ 'shape' => 'ErrorMessage', ], ], 'error' => [ 'httpStatusCode' => 400, ], 'exception' => true, ], 'InvalidTrafficPolicyDocument' => [ 'type' => 'structure', 'members' => [ 'message' => [ 'shape' => 'ErrorMessage', ], ], 'error' => [ 'httpStatusCode' => 400, ], 'exception' => true, ], 'InvalidVPCId' => [ 'type' => 'structure', 'members' => [ 'message' => [ 'shape' => 'ErrorMessage', ], ], 'error' => [ 'httpStatusCode' => 400, ], 'exception' => true, ], 'Inverted' => [ 'type' => 'boolean', ], 'IsPrivateZone' => [ 'type' => 'boolean', ], 'LastVPCAssociation' => [ 'type' => 'structure', 'members' => [ 'message' => [ 'shape' => 'ErrorMessage', ], ], 'error' => [ 'httpStatusCode' => 400, ], 'exception' => true, ], 'LimitsExceeded' => [ 'type' => 'structure', 'members' => [ 'message' => [ 'shape' => 'ErrorMessage', ], ], 'exception' => true, ], 'ListChangeBatchesByHostedZoneRequest' => [ 'type' => 'structure', 'required' => [ 'HostedZoneId', 'StartDate', 'EndDate', ], 'members' => [ 'HostedZoneId' => [ 'shape' => 'ResourceId', 'location' => 'uri', 'locationName' => 'Id', ], 'StartDate' => [ 'shape' => 'Date', 'location' => 'querystring', 'locationName' => 'startDate', ], 'EndDate' => [ 'shape' => 'Date', 'location' => 'querystring', 'locationName' => 'endDate', ], 'MaxItems' => [ 'shape' => 'PageMaxItems', 'location' => 'querystring', 'locationName' => 'maxItems', ], 'Marker' => [ 'shape' => 'PageMarker', 'location' => 'querystring', 'locationName' => 'marker', ], ], ], 'ListChangeBatchesByHostedZoneResponse' => [ 'type' => 'structure', 'required' => [ 'MaxItems', 'Marker', 'ChangeBatchRecords', ], 'members' => [ 'MaxItems' => [ 'shape' => 'PageMaxItems', ], 'Marker' => [ 'shape' => 'PageMarker', ], 'IsTruncated' => [ 'shape' => 'PageTruncated', ], 'ChangeBatchRecords' => [ 'shape' => 'ChangeBatchRecords', ], 'NextMarker' => [ 'shape' => 'PageMarker', ], ], ], 'ListChangeBatchesByRRSetRequest' => [ 'type' => 'structure', 'required' => [ 'HostedZoneId', 'Name', 'Type', 'StartDate', 'EndDate', ], 'members' => [ 'HostedZoneId' => [ 'shape' => 'ResourceId', 'location' => 'uri', 'locationName' => 'Id', ], 'Name' => [ 'shape' => 'DNSName', 'location' => 'querystring', 'locationName' => 'rrSet_name', ], 'Type' => [ 'shape' => 'RRType', 'location' => 'querystring', 'locationName' => 'type', ], 'SetIdentifier' => [ 'shape' => 'ResourceRecordSetIdentifier', 'location' => 'querystring', 'locationName' => 'identifier', ], 'StartDate' => [ 'shape' => 'Date', 'location' => 'querystring', 'locationName' => 'startDate', ], 'EndDate' => [ 'shape' => 'Date', 'location' => 'querystring', 'locationName' => 'endDate', ], 'MaxItems' => [ 'shape' => 'PageMaxItems', 'location' => 'querystring', 'locationName' => 'maxItems', ], 'Marker' => [ 'shape' => 'PageMarker', 'location' => 'querystring', 'locationName' => 'marker', ], ], ], 'ListChangeBatchesByRRSetResponse' => [ 'type' => 'structure', 'required' => [ 'MaxItems', 'Marker', 'ChangeBatchRecords', ], 'members' => [ 'MaxItems' => [ 'shape' => 'PageMaxItems', ], 'Marker' => [ 'shape' => 'PageMarker', ], 'IsTruncated' => [ 'shape' => 'PageTruncated', ], 'ChangeBatchRecords' => [ 'shape' => 'ChangeBatchRecords', ], 'NextMarker' => [ 'shape' => 'PageMarker', ], ], ], 'ListGeoLocationsRequest' => [ 'type' => 'structure', 'members' => [ 'StartContinentCode' => [ 'shape' => 'GeoLocationContinentCode', 'location' => 'querystring', 'locationName' => 'startcontinentcode', ], 'StartCountryCode' => [ 'shape' => 'GeoLocationCountryCode', 'location' => 'querystring', 'locationName' => 'startcountrycode', ], 'StartSubdivisionCode' => [ 'shape' => 'GeoLocationSubdivisionCode', 'location' => 'querystring', 'locationName' => 'startsubdivisioncode', ], 'MaxItems' => [ 'shape' => 'PageMaxItems', 'location' => 'querystring', 'locationName' => 'maxitems', ], ], ], 'ListGeoLocationsResponse' => [ 'type' => 'structure', 'required' => [ 'GeoLocationDetailsList', 'IsTruncated', 'MaxItems', ], 'members' => [ 'GeoLocationDetailsList' => [ 'shape' => 'GeoLocationDetailsList', ], 'IsTruncated' => [ 'shape' => 'PageTruncated', ], 'NextContinentCode' => [ 'shape' => 'GeoLocationContinentCode', ], 'NextCountryCode' => [ 'shape' => 'GeoLocationCountryCode', ], 'NextSubdivisionCode' => [ 'shape' => 'GeoLocationSubdivisionCode', ], 'MaxItems' => [ 'shape' => 'PageMaxItems', ], ], ], 'ListHealthChecksRequest' => [ 'type' => 'structure', 'members' => [ 'Marker' => [ 'shape' => 'PageMarker', 'location' => 'querystring', 'locationName' => 'marker', ], 'MaxItems' => [ 'shape' => 'PageMaxItems', 'location' => 'querystring', 'locationName' => 'maxitems', ], ], ], 'ListHealthChecksResponse' => [ 'type' => 'structure', 'required' => [ 'HealthChecks', 'Marker', 'IsTruncated', 'MaxItems', ], 'members' => [ 'HealthChecks' => [ 'shape' => 'HealthChecks', ], 'Marker' => [ 'shape' => 'PageMarker', ], 'IsTruncated' => [ 'shape' => 'PageTruncated', ], 'NextMarker' => [ 'shape' => 'PageMarker', ], 'MaxItems' => [ 'shape' => 'PageMaxItems', ], ], ], 'ListHostedZonesByNameRequest' => [ 'type' => 'structure', 'members' => [ 'DNSName' => [ 'shape' => 'DNSName', 'location' => 'querystring', 'locationName' => 'dnsname', ], 'HostedZoneId' => [ 'shape' => 'ResourceId', 'location' => 'querystring', 'locationName' => 'hostedzoneid', ], 'MaxItems' => [ 'shape' => 'PageMaxItems', 'location' => 'querystring', 'locationName' => 'maxitems', ], ], ], 'ListHostedZonesByNameResponse' => [ 'type' => 'structure', 'required' => [ 'HostedZones', 'IsTruncated', 'MaxItems', ], 'members' => [ 'HostedZones' => [ 'shape' => 'HostedZones', ], 'DNSName' => [ 'shape' => 'DNSName', ], 'HostedZoneId' => [ 'shape' => 'ResourceId', ], 'IsTruncated' => [ 'shape' => 'PageTruncated', ], 'NextDNSName' => [ 'shape' => 'DNSName', ], 'NextHostedZoneId' => [ 'shape' => 'ResourceId', ], 'MaxItems' => [ 'shape' => 'PageMaxItems', ], ], ], 'ListHostedZonesRequest' => [ 'type' => 'structure', 'members' => [ 'Marker' => [ 'shape' => 'PageMarker', 'location' => 'querystring', 'locationName' => 'marker', ], 'MaxItems' => [ 'shape' => 'PageMaxItems', 'location' => 'querystring', 'locationName' => 'maxitems', ], 'DelegationSetId' => [ 'shape' => 'ResourceId', 'location' => 'querystring', 'locationName' => 'delegationsetid', ], ], ], 'ListHostedZonesResponse' => [ 'type' => 'structure', 'required' => [ 'HostedZones', 'Marker', 'IsTruncated', 'MaxItems', ], 'members' => [ 'HostedZones' => [ 'shape' => 'HostedZones', ], 'Marker' => [ 'shape' => 'PageMarker', ], 'IsTruncated' => [ 'shape' => 'PageTruncated', ], 'NextMarker' => [ 'shape' => 'PageMarker', ], 'MaxItems' => [ 'shape' => 'PageMaxItems', ], ], ], 'ListResourceRecordSetsRequest' => [ 'type' => 'structure', 'required' => [ 'HostedZoneId', ], 'members' => [ 'HostedZoneId' => [ 'shape' => 'ResourceId', 'location' => 'uri', 'locationName' => 'Id', ], 'StartRecordName' => [ 'shape' => 'DNSName', 'location' => 'querystring', 'locationName' => 'name', ], 'StartRecordType' => [ 'shape' => 'RRType', 'location' => 'querystring', 'locationName' => 'type', ], 'StartRecordIdentifier' => [ 'shape' => 'ResourceRecordSetIdentifier', 'location' => 'querystring', 'locationName' => 'identifier', ], 'MaxItems' => [ 'shape' => 'PageMaxItems', 'location' => 'querystring', 'locationName' => 'maxitems', ], ], ], 'ListResourceRecordSetsResponse' => [ 'type' => 'structure', 'required' => [ 'ResourceRecordSets', 'IsTruncated', 'MaxItems', ], 'members' => [ 'ResourceRecordSets' => [ 'shape' => 'ResourceRecordSets', ], 'IsTruncated' => [ 'shape' => 'PageTruncated', ], 'NextRecordName' => [ 'shape' => 'DNSName', ], 'NextRecordType' => [ 'shape' => 'RRType', ], 'NextRecordIdentifier' => [ 'shape' => 'ResourceRecordSetIdentifier', ], 'MaxItems' => [ 'shape' => 'PageMaxItems', ], ], ], 'ListReusableDelegationSetsRequest' => [ 'type' => 'structure', 'members' => [ 'Marker' => [ 'shape' => 'PageMarker', 'location' => 'querystring', 'locationName' => 'marker', ], 'MaxItems' => [ 'shape' => 'PageMaxItems', 'location' => 'querystring', 'locationName' => 'maxitems', ], ], ], 'ListReusableDelegationSetsResponse' => [ 'type' => 'structure', 'required' => [ 'DelegationSets', 'Marker', 'IsTruncated', 'MaxItems', ], 'members' => [ 'DelegationSets' => [ 'shape' => 'DelegationSets', ], 'Marker' => [ 'shape' => 'PageMarker', ], 'IsTruncated' => [ 'shape' => 'PageTruncated', ], 'NextMarker' => [ 'shape' => 'PageMarker', ], 'MaxItems' => [ 'shape' => 'PageMaxItems', ], ], ], 'ListTagsForResourceRequest' => [ 'type' => 'structure', 'required' => [ 'ResourceType', 'ResourceId', ], 'members' => [ 'ResourceType' => [ 'shape' => 'TagResourceType', 'location' => 'uri', 'locationName' => 'ResourceType', ], 'ResourceId' => [ 'shape' => 'TagResourceId', 'location' => 'uri', 'locationName' => 'ResourceId', ], ], ], 'ListTagsForResourceResponse' => [ 'type' => 'structure', 'required' => [ 'ResourceTagSet', ], 'members' => [ 'ResourceTagSet' => [ 'shape' => 'ResourceTagSet', ], ], ], 'ListTagsForResourcesRequest' => [ 'type' => 'structure', 'required' => [ 'ResourceType', 'ResourceIds', ], 'members' => [ 'ResourceType' => [ 'shape' => 'TagResourceType', 'location' => 'uri', 'locationName' => 'ResourceType', ], 'ResourceIds' => [ 'shape' => 'TagResourceIdList', ], ], ], 'ListTagsForResourcesResponse' => [ 'type' => 'structure', 'required' => [ 'ResourceTagSets', ], 'members' => [ 'ResourceTagSets' => [ 'shape' => 'ResourceTagSetList', ], ], ], 'ListTrafficPoliciesRequest' => [ 'type' => 'structure', 'members' => [ 'TrafficPolicyIdMarker' => [ 'shape' => 'TrafficPolicyId', 'location' => 'querystring', 'locationName' => 'trafficpolicyid', ], 'MaxItems' => [ 'shape' => 'PageMaxItems', 'location' => 'querystring', 'locationName' => 'maxitems', ], ], ], 'ListTrafficPoliciesResponse' => [ 'type' => 'structure', 'required' => [ 'TrafficPolicySummaries', 'IsTruncated', 'TrafficPolicyIdMarker', 'MaxItems', ], 'members' => [ 'TrafficPolicySummaries' => [ 'shape' => 'TrafficPolicySummaries', ], 'IsTruncated' => [ 'shape' => 'PageTruncated', ], 'TrafficPolicyIdMarker' => [ 'shape' => 'TrafficPolicyId', ], 'MaxItems' => [ 'shape' => 'PageMaxItems', ], ], ], 'ListTrafficPolicyInstancesByHostedZoneRequest' => [ 'type' => 'structure', 'required' => [ 'HostedZoneId', ], 'members' => [ 'HostedZoneId' => [ 'shape' => 'ResourceId', 'location' => 'querystring', 'locationName' => 'id', ], 'TrafficPolicyInstanceNameMarker' => [ 'shape' => 'DNSName', 'location' => 'querystring', 'locationName' => 'trafficpolicyinstancename', ], 'TrafficPolicyInstanceTypeMarker' => [ 'shape' => 'RRType', 'location' => 'querystring', 'locationName' => 'trafficpolicyinstancetype', ], 'MaxItems' => [ 'shape' => 'PageMaxItems', 'location' => 'querystring', 'locationName' => 'maxitems', ], ], ], 'ListTrafficPolicyInstancesByHostedZoneResponse' => [ 'type' => 'structure', 'required' => [ 'TrafficPolicyInstances', 'IsTruncated', 'MaxItems', ], 'members' => [ 'TrafficPolicyInstances' => [ 'shape' => 'TrafficPolicyInstances', ], 'TrafficPolicyInstanceNameMarker' => [ 'shape' => 'DNSName', ], 'TrafficPolicyInstanceTypeMarker' => [ 'shape' => 'RRType', ], 'IsTruncated' => [ 'shape' => 'PageTruncated', ], 'MaxItems' => [ 'shape' => 'PageMaxItems', ], ], ], 'ListTrafficPolicyInstancesByPolicyRequest' => [ 'type' => 'structure', 'required' => [ 'TrafficPolicyId', 'TrafficPolicyVersion', ], 'members' => [ 'TrafficPolicyId' => [ 'shape' => 'TrafficPolicyId', 'location' => 'querystring', 'locationName' => 'id', ], 'TrafficPolicyVersion' => [ 'shape' => 'TrafficPolicyVersion', 'location' => 'querystring', 'locationName' => 'version', ], 'HostedZoneIdMarker' => [ 'shape' => 'ResourceId', 'location' => 'querystring', 'locationName' => 'hostedzoneid', ], 'TrafficPolicyInstanceNameMarker' => [ 'shape' => 'DNSName', 'location' => 'querystring', 'locationName' => 'trafficpolicyinstancename', ], 'TrafficPolicyInstanceTypeMarker' => [ 'shape' => 'RRType', 'location' => 'querystring', 'locationName' => 'trafficpolicyinstancetype', ], 'MaxItems' => [ 'shape' => 'PageMaxItems', 'location' => 'querystring', 'locationName' => 'maxitems', ], ], ], 'ListTrafficPolicyInstancesByPolicyResponse' => [ 'type' => 'structure', 'required' => [ 'TrafficPolicyInstances', 'IsTruncated', 'MaxItems', ], 'members' => [ 'TrafficPolicyInstances' => [ 'shape' => 'TrafficPolicyInstances', ], 'HostedZoneIdMarker' => [ 'shape' => 'ResourceId', ], 'TrafficPolicyInstanceNameMarker' => [ 'shape' => 'DNSName', ], 'TrafficPolicyInstanceTypeMarker' => [ 'shape' => 'RRType', ], 'IsTruncated' => [ 'shape' => 'PageTruncated', ], 'MaxItems' => [ 'shape' => 'PageMaxItems', ], ], ], 'ListTrafficPolicyInstancesRequest' => [ 'type' => 'structure', 'members' => [ 'HostedZoneIdMarker' => [ 'shape' => 'ResourceId', 'location' => 'querystring', 'locationName' => 'hostedzoneid', ], 'TrafficPolicyInstanceNameMarker' => [ 'shape' => 'DNSName', 'location' => 'querystring', 'locationName' => 'trafficpolicyinstancename', ], 'TrafficPolicyInstanceTypeMarker' => [ 'shape' => 'RRType', 'location' => 'querystring', 'locationName' => 'trafficpolicyinstancetype', ], 'MaxItems' => [ 'shape' => 'PageMaxItems', 'location' => 'querystring', 'locationName' => 'maxitems', ], ], ], 'ListTrafficPolicyInstancesResponse' => [ 'type' => 'structure', 'required' => [ 'TrafficPolicyInstances', 'IsTruncated', 'MaxItems', ], 'members' => [ 'TrafficPolicyInstances' => [ 'shape' => 'TrafficPolicyInstances', ], 'HostedZoneIdMarker' => [ 'shape' => 'ResourceId', ], 'TrafficPolicyInstanceNameMarker' => [ 'shape' => 'DNSName', ], 'TrafficPolicyInstanceTypeMarker' => [ 'shape' => 'RRType', ], 'IsTruncated' => [ 'shape' => 'PageTruncated', ], 'MaxItems' => [ 'shape' => 'PageMaxItems', ], ], ], 'ListTrafficPolicyVersionsRequest' => [ 'type' => 'structure', 'required' => [ 'Id', ], 'members' => [ 'Id' => [ 'shape' => 'TrafficPolicyId', 'location' => 'uri', 'locationName' => 'Id', ], 'TrafficPolicyVersionMarker' => [ 'shape' => 'TrafficPolicyVersionMarker', 'location' => 'querystring', 'locationName' => 'trafficpolicyversion', ], 'MaxItems' => [ 'shape' => 'PageMaxItems', 'location' => 'querystring', 'locationName' => 'maxitems', ], ], ], 'ListTrafficPolicyVersionsResponse' => [ 'type' => 'structure', 'required' => [ 'TrafficPolicies', 'IsTruncated', 'TrafficPolicyVersionMarker', 'MaxItems', ], 'members' => [ 'TrafficPolicies' => [ 'shape' => 'TrafficPolicies', ], 'IsTruncated' => [ 'shape' => 'PageTruncated', ], 'TrafficPolicyVersionMarker' => [ 'shape' => 'TrafficPolicyVersionMarker', ], 'MaxItems' => [ 'shape' => 'PageMaxItems', ], ], ], 'MeasureLatency' => [ 'type' => 'boolean', ], 'Message' => [ 'type' => 'string', 'max' => 1024, ], 'NoSuchChange' => [ 'type' => 'structure', 'members' => [ 'message' => [ 'shape' => 'ErrorMessage', ], ], 'error' => [ 'httpStatusCode' => 404, ], 'exception' => true, ], 'NoSuchDelegationSet' => [ 'type' => 'structure', 'members' => [ 'message' => [ 'shape' => 'ErrorMessage', ], ], 'exception' => true, ], 'NoSuchGeoLocation' => [ 'type' => 'structure', 'members' => [ 'message' => [ 'shape' => 'ErrorMessage', ], ], 'error' => [ 'httpStatusCode' => 404, ], 'exception' => true, ], 'NoSuchHealthCheck' => [ 'type' => 'structure', 'members' => [ 'message' => [ 'shape' => 'ErrorMessage', ], ], 'error' => [ 'httpStatusCode' => 404, ], 'exception' => true, ], 'NoSuchHostedZone' => [ 'type' => 'structure', 'members' => [ 'message' => [ 'shape' => 'ErrorMessage', ], ], 'error' => [ 'httpStatusCode' => 404, ], 'exception' => true, ], 'NoSuchTrafficPolicy' => [ 'type' => 'structure', 'members' => [ 'message' => [ 'shape' => 'ErrorMessage', ], ], 'error' => [ 'httpStatusCode' => 404, ], 'exception' => true, ], 'NoSuchTrafficPolicyInstance' => [ 'type' => 'structure', 'members' => [ 'message' => [ 'shape' => 'ErrorMessage', ], ], 'error' => [ 'httpStatusCode' => 404, ], 'exception' => true, ], 'Nonce' => [ 'type' => 'string', 'max' => 128, 'min' => 1, ], 'PageMarker' => [ 'type' => 'string', 'max' => 64, ], 'PageMaxItems' => [ 'type' => 'string', ], 'PageTruncated' => [ 'type' => 'boolean', ], 'Port' => [ 'type' => 'integer', 'max' => 65535, 'min' => 1, ], 'PriorRequestNotComplete' => [ 'type' => 'structure', 'members' => [ 'message' => [ 'shape' => 'ErrorMessage', ], ], 'error' => [ 'httpStatusCode' => 400, ], 'exception' => true, ], 'PublicZoneVPCAssociation' => [ 'type' => 'structure', 'members' => [ 'message' => [ 'shape' => 'ErrorMessage', ], ], 'error' => [ 'httpStatusCode' => 400, ], 'exception' => true, ], 'RData' => [ 'type' => 'string', 'max' => 4000, ], 'RRType' => [ 'type' => 'string', 'enum' => [ 'SOA', 'A', 'TXT', 'NS', 'CNAME', 'MX', 'PTR', 'SRV', 'SPF', 'AAAA', ], ], 'RequestInterval' => [ 'type' => 'integer', 'max' => 30, 'min' => 10, ], 'ResourceDescription' => [ 'type' => 'string', 'max' => 256, ], 'ResourceId' => [ 'type' => 'string', 'max' => 32, ], 'ResourcePath' => [ 'type' => 'string', 'max' => 255, ], 'ResourceRecord' => [ 'type' => 'structure', 'required' => [ 'Value', ], 'members' => [ 'Value' => [ 'shape' => 'RData', ], ], ], 'ResourceRecordSet' => [ 'type' => 'structure', 'required' => [ 'Name', 'Type', ], 'members' => [ 'Name' => [ 'shape' => 'DNSName', ], 'Type' => [ 'shape' => 'RRType', ], 'SetIdentifier' => [ 'shape' => 'ResourceRecordSetIdentifier', ], 'Weight' => [ 'shape' => 'ResourceRecordSetWeight', ], 'Region' => [ 'shape' => 'ResourceRecordSetRegion', ], 'GeoLocation' => [ 'shape' => 'GeoLocation', ], 'Failover' => [ 'shape' => 'ResourceRecordSetFailover', ], 'TTL' => [ 'shape' => 'TTL', ], 'ResourceRecords' => [ 'shape' => 'ResourceRecords', ], 'AliasTarget' => [ 'shape' => 'AliasTarget', ], 'HealthCheckId' => [ 'shape' => 'HealthCheckId', ], 'TrafficPolicyInstanceId' => [ 'shape' => 'TrafficPolicyInstanceId', ], ], ], 'ResourceRecordSetFailover' => [ 'type' => 'string', 'enum' => [ 'PRIMARY', 'SECONDARY', ], ], 'ResourceRecordSetIdentifier' => [ 'type' => 'string', 'max' => 128, 'min' => 1, ], 'ResourceRecordSetRegion' => [ 'type' => 'string', 'enum' => [ 'us-east-1', 'us-west-1', 'us-west-2', 'eu-west-1', 'eu-central-1', 'ap-southeast-1', 'ap-southeast-2', 'ap-northeast-1', 'sa-east-1', 'cn-north-1', ], 'max' => 64, 'min' => 1, ], 'ResourceRecordSetWeight' => [ 'type' => 'long', 'max' => 255, 'min' => 0, ], 'ResourceRecordSets' => [ 'type' => 'list', 'member' => [ 'shape' => 'ResourceRecordSet', 'locationName' => 'ResourceRecordSet', ], ], 'ResourceRecords' => [ 'type' => 'list', 'member' => [ 'shape' => 'ResourceRecord', 'locationName' => 'ResourceRecord', ], 'min' => 1, ], 'ResourceTagSet' => [ 'type' => 'structure', 'members' => [ 'ResourceType' => [ 'shape' => 'TagResourceType', ], 'ResourceId' => [ 'shape' => 'TagResourceId', ], 'Tags' => [ 'shape' => 'TagList', ], ], ], 'ResourceTagSetList' => [ 'type' => 'list', 'member' => [ 'shape' => 'ResourceTagSet', 'locationName' => 'ResourceTagSet', ], ], 'ResourceURI' => [ 'type' => 'string', 'max' => 1024, ], 'SearchString' => [ 'type' => 'string', 'max' => 255, ], 'Status' => [ 'type' => 'string', ], 'StatusReport' => [ 'type' => 'structure', 'members' => [ 'Status' => [ 'shape' => 'Status', ], 'CheckedTime' => [ 'shape' => 'TimeStamp', ], ], ], 'TTL' => [ 'type' => 'long', 'max' => 2147483647, 'min' => 0, ], 'Tag' => [ 'type' => 'structure', 'members' => [ 'Key' => [ 'shape' => 'TagKey', ], 'Value' => [ 'shape' => 'TagValue', ], ], ], 'TagKey' => [ 'type' => 'string', 'max' => 128, ], 'TagKeyList' => [ 'type' => 'list', 'member' => [ 'shape' => 'TagKey', 'locationName' => 'Key', ], 'max' => 10, 'min' => 1, ], 'TagList' => [ 'type' => 'list', 'member' => [ 'shape' => 'Tag', 'locationName' => 'Tag', ], 'max' => 10, 'min' => 1, ], 'TagResourceId' => [ 'type' => 'string', 'max' => 64, ], 'TagResourceIdList' => [ 'type' => 'list', 'member' => [ 'shape' => 'TagResourceId', 'locationName' => 'ResourceId', ], 'max' => 10, 'min' => 1, ], 'TagResourceType' => [ 'type' => 'string', 'enum' => [ 'healthcheck', 'hostedzone', ], ], 'TagValue' => [ 'type' => 'string', 'max' => 256, ], 'ThrottlingException' => [ 'type' => 'structure', 'members' => [ 'message' => [ 'shape' => 'ErrorMessage', ], ], 'error' => [ 'httpStatusCode' => 400, ], 'exception' => true, ], 'TimeStamp' => [ 'type' => 'timestamp', ], 'TooManyHealthChecks' => [ 'type' => 'structure', 'members' => [ 'message' => [ 'shape' => 'ErrorMessage', ], ], 'exception' => true, ], 'TooManyHostedZones' => [ 'type' => 'structure', 'members' => [ 'message' => [ 'shape' => 'ErrorMessage', ], ], 'error' => [ 'httpStatusCode' => 400, ], 'exception' => true, ], 'TooManyTrafficPolicies' => [ 'type' => 'structure', 'members' => [ 'message' => [ 'shape' => 'ErrorMessage', ], ], 'error' => [ 'httpStatusCode' => 400, ], 'exception' => true, ], 'TooManyTrafficPolicyInstances' => [ 'type' => 'structure', 'members' => [ 'message' => [ 'shape' => 'ErrorMessage', ], ], 'error' => [ 'httpStatusCode' => 400, ], 'exception' => true, ], 'TrafficPolicies' => [ 'type' => 'list', 'member' => [ 'shape' => 'TrafficPolicy', 'locationName' => 'TrafficPolicy', ], ], 'TrafficPolicy' => [ 'type' => 'structure', 'required' => [ 'Id', 'Version', 'Name', 'Type', 'Document', ], 'members' => [ 'Id' => [ 'shape' => 'TrafficPolicyId', ], 'Version' => [ 'shape' => 'TrafficPolicyVersion', ], 'Name' => [ 'shape' => 'TrafficPolicyName', ], 'Type' => [ 'shape' => 'RRType', ], 'Document' => [ 'shape' => 'TrafficPolicyDocument', ], 'Comment' => [ 'shape' => 'TrafficPolicyComment', ], ], ], 'TrafficPolicyAlreadyExists' => [ 'type' => 'structure', 'members' => [ 'message' => [ 'shape' => 'ErrorMessage', ], ], 'error' => [ 'httpStatusCode' => 409, ], 'exception' => true, ], 'TrafficPolicyComment' => [ 'type' => 'string', 'max' => 1024, ], 'TrafficPolicyDocument' => [ 'type' => 'string', 'max' => 102400, ], 'TrafficPolicyId' => [ 'type' => 'string', 'max' => 36, ], 'TrafficPolicyInUse' => [ 'type' => 'structure', 'members' => [ 'message' => [ 'shape' => 'ErrorMessage', ], ], 'error' => [ 'httpStatusCode' => 400, ], 'exception' => true, ], 'TrafficPolicyInstance' => [ 'type' => 'structure', 'required' => [ 'Id', 'HostedZoneId', 'Name', 'TTL', 'State', 'Message', 'TrafficPolicyId', 'TrafficPolicyVersion', 'TrafficPolicyType', ], 'members' => [ 'Id' => [ 'shape' => 'TrafficPolicyInstanceId', ], 'HostedZoneId' => [ 'shape' => 'ResourceId', ], 'Name' => [ 'shape' => 'DNSName', ], 'TTL' => [ 'shape' => 'TTL', ], 'State' => [ 'shape' => 'TrafficPolicyInstanceState', ], 'Message' => [ 'shape' => 'Message', ], 'TrafficPolicyId' => [ 'shape' => 'TrafficPolicyId', ], 'TrafficPolicyVersion' => [ 'shape' => 'TrafficPolicyVersion', ], 'TrafficPolicyType' => [ 'shape' => 'RRType', ], ], ], 'TrafficPolicyInstanceAlreadyExists' => [ 'type' => 'structure', 'members' => [ 'message' => [ 'shape' => 'ErrorMessage', ], ], 'error' => [ 'httpStatusCode' => 409, ], 'exception' => true, ], 'TrafficPolicyInstanceCount' => [ 'type' => 'integer', ], 'TrafficPolicyInstanceId' => [ 'type' => 'string', 'max' => 36, ], 'TrafficPolicyInstanceState' => [ 'type' => 'string', ], 'TrafficPolicyInstances' => [ 'type' => 'list', 'member' => [ 'shape' => 'TrafficPolicyInstance', 'locationName' => 'TrafficPolicyInstance', ], ], 'TrafficPolicyName' => [ 'type' => 'string', 'max' => 512, ], 'TrafficPolicySummaries' => [ 'type' => 'list', 'member' => [ 'shape' => 'TrafficPolicySummary', 'locationName' => 'TrafficPolicySummary', ], ], 'TrafficPolicySummary' => [ 'type' => 'structure', 'required' => [ 'Id', 'Name', 'Type', 'LatestVersion', 'TrafficPolicyCount', ], 'members' => [ 'Id' => [ 'shape' => 'TrafficPolicyId', ], 'Name' => [ 'shape' => 'TrafficPolicyName', ], 'Type' => [ 'shape' => 'RRType', ], 'LatestVersion' => [ 'shape' => 'TrafficPolicyVersion', ], 'TrafficPolicyCount' => [ 'shape' => 'TrafficPolicyVersion', ], ], ], 'TrafficPolicyVersion' => [ 'type' => 'integer', 'max' => 1000, 'min' => 1, ], 'TrafficPolicyVersionMarker' => [ 'type' => 'string', 'max' => 4, ], 'UpdateHealthCheckRequest' => [ 'type' => 'structure', 'required' => [ 'HealthCheckId', ], 'members' => [ 'HealthCheckId' => [ 'shape' => 'HealthCheckId', 'location' => 'uri', 'locationName' => 'HealthCheckId', ], 'HealthCheckVersion' => [ 'shape' => 'HealthCheckVersion', ], 'IPAddress' => [ 'shape' => 'IPAddress', ], 'Port' => [ 'shape' => 'Port', ], 'ResourcePath' => [ 'shape' => 'ResourcePath', ], 'FullyQualifiedDomainName' => [ 'shape' => 'FullyQualifiedDomainName', ], 'SearchString' => [ 'shape' => 'SearchString', ], 'FailureThreshold' => [ 'shape' => 'FailureThreshold', ], 'Inverted' => [ 'shape' => 'Inverted', ], 'HealthThreshold' => [ 'shape' => 'HealthThreshold', ], 'ChildHealthChecks' => [ 'shape' => 'ChildHealthCheckList', ], ], ], 'UpdateHealthCheckResponse' => [ 'type' => 'structure', 'required' => [ 'HealthCheck', ], 'members' => [ 'HealthCheck' => [ 'shape' => 'HealthCheck', ], ], ], 'UpdateHostedZoneCommentRequest' => [ 'type' => 'structure', 'required' => [ 'Id', ], 'members' => [ 'Id' => [ 'shape' => 'ResourceId', 'location' => 'uri', 'locationName' => 'Id', ], 'Comment' => [ 'shape' => 'ResourceDescription', ], ], ], 'UpdateHostedZoneCommentResponse' => [ 'type' => 'structure', 'required' => [ 'HostedZone', ], 'members' => [ 'HostedZone' => [ 'shape' => 'HostedZone', ], ], ], 'UpdateTrafficPolicyCommentRequest' => [ 'type' => 'structure', 'required' => [ 'Id', 'Version', 'Comment', ], 'members' => [ 'Id' => [ 'shape' => 'TrafficPolicyId', 'location' => 'uri', 'locationName' => 'Id', ], 'Version' => [ 'shape' => 'TrafficPolicyVersion', 'location' => 'uri', 'locationName' => 'Version', ], 'Comment' => [ 'shape' => 'TrafficPolicyComment', ], ], ], 'UpdateTrafficPolicyCommentResponse' => [ 'type' => 'structure', 'required' => [ 'TrafficPolicy', ], 'members' => [ 'TrafficPolicy' => [ 'shape' => 'TrafficPolicy', ], ], ], 'UpdateTrafficPolicyInstanceRequest' => [ 'type' => 'structure', 'required' => [ 'Id', 'TTL', 'TrafficPolicyId', 'TrafficPolicyVersion', ], 'members' => [ 'Id' => [ 'shape' => 'TrafficPolicyInstanceId', 'location' => 'uri', 'locationName' => 'Id', ], 'TTL' => [ 'shape' => 'TTL', ], 'TrafficPolicyId' => [ 'shape' => 'TrafficPolicyId', ], 'TrafficPolicyVersion' => [ 'shape' => 'TrafficPolicyVersion', ], ], ], 'UpdateTrafficPolicyInstanceResponse' => [ 'type' => 'structure', 'required' => [ 'TrafficPolicyInstance', ], 'members' => [ 'TrafficPolicyInstance' => [ 'shape' => 'TrafficPolicyInstance', ], ], ], 'VPC' => [ 'type' => 'structure', 'members' => [ 'VPCRegion' => [ 'shape' => 'VPCRegion', ], 'VPCId' => [ 'shape' => 'VPCId', ], ], ], 'VPCAssociationNotFound' => [ 'type' => 'structure', 'members' => [ 'message' => [ 'shape' => 'ErrorMessage', ], ], 'error' => [ 'httpStatusCode' => 404, ], 'exception' => true, ], 'VPCId' => [ 'type' => 'string', 'max' => 1024, ], 'VPCRegion' => [ 'type' => 'string', 'enum' => [ 'us-east-1', 'us-west-1', 'us-west-2', 'eu-west-1', 'eu-central-1', 'ap-southeast-1', 'ap-southeast-2', 'ap-northeast-1', 'sa-east-1', 'cn-north-1', ], 'max' => 64, 'min' => 1, ], 'VPCs' => [ 'type' => 'list', 'member' => [ 'shape' => 'VPC', 'locationName' => 'VPC', ], 'min' => 1, ], ],];
