<?php
// This file was auto-generated from sdk-root/src/data/workspaces/2015-04-08/docs-2.json
return [ 'version' => '2.0', 'operations' => [ 'CreateWorkspaces' => '<p>Creates one or more WorkSpaces.</p> <note> <p>This operation is asynchronous and returns before the WorkSpaces are created.</p> </note>', 'DescribeWorkspaceBundles' => '<p>Obtains information about the WorkSpace bundles that are available to your account in the specified region.</p> <p>You can filter the results with either the <code>BundleIds</code> parameter, or the <code>Owner</code> parameter, but not both.</p> <p>This operation supports pagination with the use of the <code>NextToken</code> request and response parameters. If more results are available, the <code>NextToken</code> response member contains a token that you pass in the next call to this operation to retrieve the next set of items.</p>', 'DescribeWorkspaceDirectories' => '<p>Retrieves information about the AWS Directory Service directories in the region that are registered with Amazon WorkSpaces and are available to your account.</p> <p>This operation supports pagination with the use of the <code>NextToken</code> request and response parameters. If more results are available, the <code>NextToken</code> response member contains a token that you pass in the next call to this operation to retrieve the next set of items.</p>', 'DescribeWorkspaces' => '<p>Obtains information about the specified WorkSpaces. </p> <p>Only one of the filter parameters, such as <code>BundleId</code>, <code>DirectoryId</code>, or <code>WorkspaceIds</code>, can be specified at a time.</p> <p>This operation supports pagination with the use of the <code>NextToken</code> request and response parameters. If more results are available, the <code>NextToken</code> response member contains a token that you pass in the next call to this operation to retrieve the next set of items.</p>', 'RebootWorkspaces' => '<p>Reboots the specified WorkSpaces.</p> <p>To be able to reboot a WorkSpace, the WorkSpace must have a <b>State</b> of <code>AVAILABLE</code>, <code>IMPAIRED</code>, or <code>INOPERABLE</code>.</p> <note> <p>This operation is asynchronous and will return before the WorkSpaces have rebooted.</p> </note>', 'RebuildWorkspaces' => '<p>Rebuilds the specified WorkSpaces.</p> <p>Rebuilding a WorkSpace is a potentially destructive action that can result in the loss of data. Rebuilding a WorkSpace causes the following to occur:</p> <ul> <li>The system is restored to the image of the bundle that the WorkSpace is created from. Any applications that have been installed, or system settings that have been made since the WorkSpace was created will be lost.</li> <li>The data drive (D drive] is re-created from the last automatic snapshot taken of the data drive. The current contents of the data drive are overwritten. Automatic snapshots of the data drive are taken every 12 hours, so the snapshot can be as much as 12 hours old.</li> </ul> <p>To be able to rebuild a WorkSpace, the WorkSpace must have a <b>State</b> of <code>AVAILABLE</code> or <code>ERROR</code>.</p> <note> <p>This operation is asynchronous and will return before the WorkSpaces have been completely rebuilt.</p> </note>', 'TerminateWorkspaces' => '<p>Terminates the specified WorkSpaces.</p> <p>Terminating a WorkSpace is a permanent action and cannot be undone. The user\'s data is not maintained and will be destroyed. If you need to archive any user data, contact Amazon Web Services before terminating the WorkSpace.</p> <p>You can terminate a WorkSpace that is in any state except <code>SUSPENDED</code>.</p> <note> <p>This operation is asynchronous and will return before the WorkSpaces have been completely terminated.</p> </note>', ], 'shapes' => [ 'ARN' => [ 'refs' => [ 'WorkspaceDirectory$IamRoleId' => '<p>The identifier of the IAM role. This is the role that allows Amazon WorkSpaces to make calls to other services, such as Amazon EC2, on your behalf.</p>', ], ], 'Alias' => [ 'refs' => [ 'WorkspaceDirectory$Alias' => '<p>The directory alias.</p>', ], ], 'BooleanObject' => [ 'refs' => [ 'DefaultWorkspaceCreationProperties$EnableInternetAccess' => '<p>A public IP address will be attached to all WorkSpaces that are created or rebuilt.</p>', 'DefaultWorkspaceCreationProperties$EnableWorkDocs' => '<p>Specifies if the directory is enabled for Amazon WorkDocs.</p>', 'DefaultWorkspaceCreationProperties$UserEnabledAsLocalAdministrator' => '<p>The WorkSpace user is an administrator on the WorkSpace.</p>', 'Workspace$RootVolumeEncryptionEnabled' => '<p>Specifies whether the data stored on the root volume, or C: drive, is encrypted.</p>', 'Workspace$UserVolumeEncryptionEnabled' => '<p>Specifies whether the data stored on the user volume, or D: drive, is encrypted.</p>', 'WorkspaceRequest$RootVolumeEncryptionEnabled' => '<p>Specifies whether the data stored on the root volume, or C: drive, is encrypted.</p>', 'WorkspaceRequest$UserVolumeEncryptionEnabled' => '<p>Specifies whether the data stored on the user volume, or D: drive, is encrypted.</p>', ], ], 'BundleId' => [ 'refs' => [ 'DescribeWorkspacesRequest$BundleId' => '<p>The identifier of a bundle to obtain the WorkSpaces for. All WorkSpaces that are created from this bundle will be retrieved. This parameter cannot be combined with any other filter parameter.</p>', 'Workspace$BundleId' => '<p>The identifier of the bundle that the WorkSpace was created from.</p>', 'WorkspaceBundle$BundleId' => '<p>The bundle identifier.</p>', 'WorkspaceRequest$BundleId' => '<p>The identifier of the bundle to create the WorkSpace from. You can use the <a>DescribeWorkspaceBundles</a> operation to obtain a list of the bundles that are available.</p>', ], ], 'BundleIdList' => [ 'refs' => [ 'DescribeWorkspaceBundlesRequest$BundleIds' => '<p>An array of strings that contains the identifiers of the bundles to retrieve. This parameter cannot be combined with any other filter parameter.</p>', ], ], 'BundleList' => [ 'refs' => [ 'DescribeWorkspaceBundlesResult$Bundles' => '<p>An array of structures that contain information about the bundles.</p>', ], ], 'BundleOwner' => [ 'refs' => [ 'DescribeWorkspaceBundlesRequest$Owner' => '<p>The owner of the bundles to retrieve. This parameter cannot be combined with any other filter parameter.</p> <p>This contains one of the following values:</p> <ul> <li>null - Retrieves the bundles that belong to the account making the call.</li> <li> <code>AMAZON</code> - Retrieves the bundles that are provided by AWS.</li> </ul>', 'WorkspaceBundle$Owner' => '<p>The owner of the bundle. This contains the owner\'s account identifier, or <code>AMAZON</code> if the bundle is provided by AWS.</p>', ], ], 'Compute' => [ 'refs' => [ 'ComputeType$Name' => '<p>The name of the compute type for the bundle.</p>', ], ], 'ComputeType' => [ 'base' => '<p>Contains information about the compute type of a WorkSpace bundle.</p>', 'refs' => [ 'WorkspaceBundle$ComputeType' => '<p>A <a>ComputeType</a> object that specifies the compute type for the bundle.</p>', ], ], 'ComputerName' => [ 'refs' => [ 'Workspace$ComputerName' => '<p>The name of the WorkSpace as seen by the operating system.</p>', ], ], 'CreateWorkspacesRequest' => [ 'base' => '<p>Contains the inputs for the <a>CreateWorkspaces</a> operation.</p>', 'refs' => [], ], 'CreateWorkspacesResult' => [ 'base' => '<p>Contains the result of the <a>CreateWorkspaces</a> operation.</p>', 'refs' => [], ], 'DefaultOu' => [ 'refs' => [ 'DefaultWorkspaceCreationProperties$DefaultOu' => '<p>The organizational unit (OU] in the directory that the WorkSpace machine accounts are placed in.</p>', ], ], 'DefaultWorkspaceCreationProperties' => [ 'base' => '<p>Contains default WorkSpace creation information.</p>', 'refs' => [ 'WorkspaceDirectory$WorkspaceCreationProperties' => '<p>A structure that specifies the default creation properties for all WorkSpaces in the directory.</p>', ], ], 'DescribeWorkspaceBundlesRequest' => [ 'base' => '<p>Contains the inputs for the <a>DescribeWorkspaceBundles</a> operation.</p>', 'refs' => [], ], 'DescribeWorkspaceBundlesResult' => [ 'base' => '<p>Contains the results of the <a>DescribeWorkspaceBundles</a> operation.</p>', 'refs' => [], ], 'DescribeWorkspaceDirectoriesRequest' => [ 'base' => '<p>Contains the inputs for the <a>DescribeWorkspaceDirectories</a> operation.</p>', 'refs' => [], ], 'DescribeWorkspaceDirectoriesResult' => [ 'base' => '<p>Contains the results of the <a>DescribeWorkspaceDirectories</a> operation.</p>', 'refs' => [], ], 'DescribeWorkspacesRequest' => [ 'base' => '<p>Contains the inputs for the <a>DescribeWorkspaces</a> operation.</p>', 'refs' => [], ], 'DescribeWorkspacesResult' => [ 'base' => '<p>Contains the results for the <a>DescribeWorkspaces</a> operation.</p>', 'refs' => [], ], 'Description' => [ 'refs' => [ 'FailedCreateWorkspaceRequest$ErrorMessage' => '<p>The textual error message.</p>', 'FailedWorkspaceChangeRequest$ErrorMessage' => '<p>The textual error message.</p>', 'Workspace$ErrorMessage' => '<p>If the WorkSpace could not be created, this contains a textual error message that describes the failure.</p>', 'WorkspaceBundle$Description' => '<p>The bundle description.</p>', ], ], 'DirectoryId' => [ 'refs' => [ 'DescribeWorkspacesRequest$DirectoryId' => '<p>Specifies the directory identifier to which to limit the WorkSpaces. Optionally, you can specify a specific directory user with the <code>UserName</code> parameter. This parameter cannot be combined with any other filter parameter.</p>', 'Workspace$DirectoryId' => '<p>The identifier of the AWS Directory Service directory that the WorkSpace belongs to.</p>', 'WorkspaceDirectory$DirectoryId' => '<p>The directory identifier.</p>', 'WorkspaceRequest$DirectoryId' => '<p>The identifier of the AWS Directory Service directory to create the WorkSpace in. You can use the <a>DescribeWorkspaceDirectories</a> operation to obtain a list of the directories that are available.</p>', ], ], 'DirectoryIdList' => [ 'refs' => [ 'DescribeWorkspaceDirectoriesRequest$DirectoryIds' => '<p>An array of strings that contains the directory identifiers to retrieve information for. If this member is null, all directories are retrieved.</p>', ], ], 'DirectoryList' => [ 'refs' => [ 'DescribeWorkspaceDirectoriesResult$Directories' => '<p>An array of structures that contain information about the directories.</p>', ], ], 'DirectoryName' => [ 'refs' => [ 'WorkspaceDirectory$DirectoryName' => '<p>The name of the directory.</p>', ], ], 'DnsIpAddresses' => [ 'refs' => [ 'WorkspaceDirectory$DnsIpAddresses' => '<p>An array of strings that contains the IP addresses of the DNS servers for the directory.</p>', ], ], 'ErrorType' => [ 'refs' => [ 'FailedCreateWorkspaceRequest$ErrorCode' => '<p>The error code.</p>', 'FailedWorkspaceChangeRequest$ErrorCode' => '<p>The error code.</p>', ], ], 'ExceptionMessage' => [ 'refs' => [ 'InvalidParameterValuesException$message' => '<p>The exception error message.</p>', 'ResourceLimitExceededException$message' => '<p>The exception error message.</p>', 'ResourceUnavailableException$message' => '<p>The exception error message.</p>', ], ], 'FailedCreateWorkspaceRequest' => [ 'base' => '<p>Contains information about a WorkSpace that could not be created.</p>', 'refs' => [], ], 'FailedCreateWorkspaceRequests' => [ 'refs' => [ 'CreateWorkspacesResult$FailedRequests' => '<p>An array of structures that represent the WorkSpaces that could not be created.</p>', ], ], 'FailedRebootWorkspaceRequests' => [ 'refs' => [ 'RebootWorkspacesResult$FailedRequests' => '<p>An array of structures that represent any WorkSpaces that could not be rebooted.</p>', ], ], 'FailedRebuildWorkspaceRequests' => [ 'refs' => [ 'RebuildWorkspacesResult$FailedRequests' => '<p>An array of structures that represent any WorkSpaces that could not be rebuilt.</p>', ], ], 'FailedTerminateWorkspaceRequests' => [ 'refs' => [ 'TerminateWorkspacesResult$FailedRequests' => '<p>An array of structures that represent any WorkSpaces that could not be terminated.</p>', ], ], 'FailedWorkspaceChangeRequest' => [ 'base' => '<p>Contains information about a WorkSpace that could not be rebooted (<a>RebootWorkspaces</a>], rebuilt (<a>RebuildWorkspaces</a>], or terminated (<a>TerminateWorkspaces</a>].</p>', 'refs' => [], ], 'InvalidParameterValuesException' => [ 'base' => '<p>One or more parameter values are not valid.</p>', 'refs' => [], ], 'IpAddress' => [ 'refs' => [ 'Workspace$IpAddress' => '<p>The IP address of the WorkSpace.</p>', ], ], 'Limit' => [ 'refs' => [ 'DescribeWorkspacesRequest$Limit' => '<p>The maximum number of items to return.</p>', ], ], 'NonEmptyString' => [ 'refs' => [ 'ResourceUnavailableException$ResourceId' => '<p>The identifier of the resource that is not available.</p>', 'UserStorage$Capacity' => '<p>The amount of user storage for the bundle.</p>', 'WorkspaceBundle$Name' => '<p>The name of the bundle.</p>', ], ], 'PaginationToken' => [ 'refs' => [ 'DescribeWorkspaceBundlesRequest$NextToken' => '<p>The <code>NextToken</code> value from a previous call to this operation. Pass null if this is the first call.</p>', 'DescribeWorkspaceBundlesResult$NextToken' => '<p>If not null, more results are available. Pass this value for the <code>NextToken</code> parameter in a subsequent call to this operation to retrieve the next set of items. This token is valid for one day and must be used within that timeframe.</p>', 'DescribeWorkspaceDirectoriesRequest$NextToken' => '<p>The <code>NextToken</code> value from a previous call to this operation. Pass null if this is the first call.</p>', 'DescribeWorkspaceDirectoriesResult$NextToken' => '<p>If not null, more results are available. Pass this value for the <code>NextToken</code> parameter in a subsequent call to this operation to retrieve the next set of items. This token is valid for one day and must be used within that timeframe.</p>', 'DescribeWorkspacesRequest$NextToken' => '<p>The <code>NextToken</code> value from a previous call to this operation. Pass null if this is the first call.</p>', 'DescribeWorkspacesResult$NextToken' => '<p>If not null, more results are available. Pass this value for the <code>NextToken</code> parameter in a subsequent call to this operation to retrieve the next set of items. This token is valid for one day and must be used within that timeframe.</p>', ], ], 'RebootRequest' => [ 'base' => '<p>Contains information used with the <a>RebootWorkspaces</a> operation to reboot a WorkSpace.</p>', 'refs' => [], ], 'RebootWorkspaceRequests' => [ 'refs' => [ 'RebootWorkspacesRequest$RebootWorkspaceRequests' => '<p>An array of structures that specify the WorkSpaces to reboot.</p>', ], ], 'RebootWorkspacesRequest' => [ 'base' => '<p>Contains the inputs for the <a>RebootWorkspaces</a> operation.</p>', 'refs' => [], ], 'RebootWorkspacesResult' => [ 'base' => '<p>Contains the results of the <a>RebootWorkspaces</a> operation.</p>', 'refs' => [], ], 'RebuildRequest' => [ 'base' => '<p>Contains information used with the <a>RebuildWorkspaces</a> operation to rebuild a WorkSpace.</p>', 'refs' => [], ], 'RebuildWorkspaceRequests' => [ 'refs' => [ 'RebuildWorkspacesRequest$RebuildWorkspaceRequests' => '<p>An array of structures that specify the WorkSpaces to rebuild.</p>', ], ], 'RebuildWorkspacesRequest' => [ 'base' => '<p>Contains the inputs for the <a>RebuildWorkspaces</a> operation.</p>', 'refs' => [], ], 'RebuildWorkspacesResult' => [ 'base' => '<p>Contains the results of the <a>RebuildWorkspaces</a> operation.</p>', 'refs' => [], ], 'RegistrationCode' => [ 'refs' => [ 'WorkspaceDirectory$RegistrationCode' => '<p>The registration code for the directory. This is the code that users enter in their Amazon WorkSpaces client application to connect to the directory.</p>', ], ], 'ResourceLimitExceededException' => [ 'base' => '<p>Your resource limits have been exceeded.</p>', 'refs' => [], ], 'ResourceUnavailableException' => [ 'base' => '<p>The specified resource is not available.</p>', 'refs' => [], ], 'SecurityGroupId' => [ 'refs' => [ 'DefaultWorkspaceCreationProperties$CustomSecurityGroupId' => '<p>The identifier of any custom security groups that are applied to the WorkSpaces when they are created.</p>', 'WorkspaceDirectory$WorkspaceSecurityGroupId' => '<p>The identifier of the security group that is assigned to new WorkSpaces.</p>', ], ], 'SubnetId' => [ 'refs' => [ 'Workspace$SubnetId' => '<p>The identifier of the subnet that the WorkSpace is in.</p>', ], ], 'SubnetIds' => [ 'refs' => [ 'WorkspaceDirectory$SubnetIds' => '<p>An array of strings that contains the identifiers of the subnets used with the directory.</p>', ], ], 'TerminateRequest' => [ 'base' => '<p>Contains information used with the <a>TerminateWorkspaces</a> operation to terminate a WorkSpace.</p>', 'refs' => [], ], 'TerminateWorkspaceRequests' => [ 'refs' => [ 'TerminateWorkspacesRequest$TerminateWorkspaceRequests' => '<p>An array of structures that specify the WorkSpaces to terminate.</p>', ], ], 'TerminateWorkspacesRequest' => [ 'base' => '<p>Contains the inputs for the <a>TerminateWorkspaces</a> operation.</p>', 'refs' => [], ], 'TerminateWorkspacesResult' => [ 'base' => '<p>Contains the results of the <a>TerminateWorkspaces</a> operation.</p>', 'refs' => [], ], 'UserName' => [ 'refs' => [ 'DescribeWorkspacesRequest$UserName' => '<p>Used with the <code>DirectoryId</code> parameter to specify the directory user for which to obtain the WorkSpace.</p>', 'Workspace$UserName' => '<p>The user that the WorkSpace is assigned to.</p>', 'WorkspaceDirectory$CustomerUserName' => '<p>The user name for the service account.</p>', 'WorkspaceRequest$UserName' => '<p>The username that the WorkSpace is assigned to. This username must exist in the AWS Directory Service directory specified by the <code>DirectoryId</code> member.</p>', ], ], 'UserStorage' => [ 'base' => '<p>Contains information about the user storage for a WorkSpace bundle.</p>', 'refs' => [ 'WorkspaceBundle$UserStorage' => '<p>A <a>UserStorage</a> object that specifies the amount of user storage that the bundle contains.</p>', ], ], 'VolumeEncryptionKey' => [ 'refs' => [ 'Workspace$VolumeEncryptionKey' => '<p>The KMS key used to encrypt data stored on your WorkSpace.</p>', 'WorkspaceRequest$VolumeEncryptionKey' => '<p>The KMS key used to encrypt data stored on your WorkSpace.</p>', ], ], 'Workspace' => [ 'base' => '<p>Contains information about a WorkSpace.</p>', 'refs' => [], ], 'WorkspaceBundle' => [ 'base' => '<p>Contains information about a WorkSpace bundle.</p>', 'refs' => [], ], 'WorkspaceDirectory' => [ 'base' => '<p>Contains information about an AWS Directory Service directory for use with Amazon WorkSpaces.</p>', 'refs' => [], ], 'WorkspaceDirectoryState' => [ 'refs' => [ 'WorkspaceDirectory$State' => '<p>The state of the directory\'s registration with Amazon WorkSpaces</p>', ], ], 'WorkspaceDirectoryType' => [ 'refs' => [ 'WorkspaceDirectory$DirectoryType' => '<p>The directory type.</p>', ], ], 'WorkspaceErrorCode' => [ 'refs' => [ 'Workspace$ErrorCode' => '<p>If the WorkSpace could not be created, this contains the error code.</p>', ], ], 'WorkspaceId' => [ 'refs' => [ 'FailedWorkspaceChangeRequest$WorkspaceId' => '<p>The identifier of the WorkSpace.</p>', 'RebootRequest$WorkspaceId' => '<p>The identifier of the WorkSpace to reboot.</p>', 'RebuildRequest$WorkspaceId' => '<p>The identifier of the WorkSpace to rebuild.</p>', 'TerminateRequest$WorkspaceId' => '<p>The identifier of the WorkSpace to terminate.</p>', 'Workspace$WorkspaceId' => '<p>The identifier of the WorkSpace.</p>', ], ], 'WorkspaceIdList' => [ 'refs' => [ 'DescribeWorkspacesRequest$WorkspaceIds' => '<p>An array of strings that contain the identifiers of the WorkSpaces for which to retrieve information. This parameter cannot be combined with any other filter parameter.</p> <p>Because the <a>CreateWorkspaces</a> operation is asynchronous, the identifier returned by <a>CreateWorkspaces</a> is not immediately available. If you immediately call <a>DescribeWorkspaces</a> with this identifier, no information will be returned.</p>', ], ], 'WorkspaceList' => [ 'refs' => [ 'CreateWorkspacesResult$PendingRequests' => '<p>An array of structures that represent the WorkSpaces that were created.</p> <p>Because this operation is asynchronous, the identifier in <code>WorkspaceId</code> is not immediately available. If you immediately call <a>DescribeWorkspaces</a> with this identifier, no information will be returned.</p>', 'DescribeWorkspacesResult$Workspaces' => '<p>An array of structures that contain the information about the WorkSpaces.</p> <p>Because the <a>CreateWorkspaces</a> operation is asynchronous, some of this information may be incomplete for a newly-created WorkSpace.</p>', ], ], 'WorkspaceRequest' => [ 'base' => '<p>Contains information about a WorkSpace creation request.</p>', 'refs' => [ 'FailedCreateWorkspaceRequest$WorkspaceRequest' => '<p>A <a>WorkspaceRequest</a> object that contains the information about the WorkSpace that could not be created.</p>', ], ], 'WorkspaceRequestList' => [ 'refs' => [ 'CreateWorkspacesRequest$Workspaces' => '<p>An array of structures that specify the WorkSpaces to create.</p>', ], ], 'WorkspaceState' => [ 'refs' => [ 'Workspace$State' => '<p>The operational state of the WorkSpace.</p>', ], ], ], 'service' => '<fullname>Amazon WorkSpaces Service</fullname> <p>This is the <i>Amazon WorkSpaces API Reference</i>. This guide provides detailed information about Amazon WorkSpaces operations, data types, parameters, and errors.</p>',];
