<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Make extends CI_Controller {
	private $title;
	private $keywords;
	private $description;
	private $search;
	private $head;
	function __construct()
	{
		parent::__construct();

		$this->title       = $this->system_model->sysinfo('webtitle');
		$this->keywords    = $this->system_model->sysinfo('keywords');
		$this->description = $this->system_model->sysinfo('description');
		$this->search      = "";

		$this->head['search']      = $this->search;
		$this->head['title']       = $this->title;
		$this->head['keywords']    = $this->keywords;
		$this->head['description'] = $this->description;
	}

	public function index() 
	{
		$this->head['title']  = "标签列表-" . $this->head['title'];
		$this->load->view('default/xi_header.php',$this->head);
		$data['make'] = $this->tags_model->alltags();
	 	$this->load->view('xi_make.php',$data);
		$this->load->view('default/xi_copy.php');
    	$this->load->view('default/xi_footer.php');
	}

	public function discover($tag = "")
	{
		if ( $this->session->userdata('online') )
		{
			$this->load->view('default/xi_header.php',$this->head);

			$query = $this->pic_model->randombytag(urldecode($tag));
			$data['url']  = "";
			$data['tag']  = urldecode($tag);
			foreach ($query as $value) 
			{
				$data['url']  = base_url($value['pic_url']);
			}

			$this->load->view('xi_discover.php',$data);
			$this->load->view('default/xi_copy.php');
			$this->load->view('default/xi_footer.php');
		}
		else
		{
			 redirect(base_url('login'), 'refresh');; 
		}
	}

	public function like($uuid='',$tag='')
	{
		if( $this->session->userdata('online') ) 
		{
			$user = $this->session->userdata('Username');
			if(!$this->love_model->is_love($uuid,$user)) 
			{
				$this->love_model->add_love($uuid,$user);
				$this->pic_model->addlove($uuid);
			}
		}

		$query = $this->pic_model->randombytag(urldecode($tag));

		foreach ($query as $value) 
		{
			echo base_url($value['pic_url']);
		}
	}

	public function nolike($tag='')
	{
		$query = $this->pic_model->randombytag(urldecode($tag));

		foreach ($query as $value) 
		{
			echo base_url($value['pic_url']);
		}
	}
}

/* End of file xixi.php */
/* Location: ./application/controllers/xixi.php */