<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Network extends CI_Controller {
	private $user;
	private $title;
	private $keywords;
	private $description;
	private $search;
	private $head;
	function __construct()
	{
		parent::__construct();
		$this->realip = xi_get_ClientIp();

    	if( $this->session->userdata('online') ) {
			$this->user = $this->session->userdata('Username');
		} else {
			$this->user = 0;
		}

		$this->title       = $this->system_model->sysinfo('webtitle');
		$this->keywords    = $this->system_model->sysinfo('keywords');
		$this->description = $this->system_model->sysinfo('description');
		$this->search      = "";

		$this->head['search']      = $this->search;
		$this->head['title']       = $this->title;
		$this->head['keywords']    = $this->keywords;
		$this->head['description'] = $this->description;
	}

	public function test()
	{
		// $data = file_get_contents();

		// $fp   = @fopen('1.jpg', 'wb');

  //       @fwrite($fp, $data);

  //       fclose($fp);
		$pic_url = 'http://127.0.0.1/xiximage/upload/2014/11/24/daf1740cef91fde3d88ce9a390b40969.jpg';
		$picstr  = explode(".",$pic_url);
		echo $picstr[count($picstr)-1];
	}

	public function index() 
	{
		$this->head['title']  = "网络发布-" . $this->title;

      	$this->load->view('default/xi_header.php',$this->head);
  		if( $this->session->userdata('online') ) {
			$this->load->view('xi_network.php');
		} else {
			redirect(base_url(), 'refresh');
		}
      	$this->load->view('default/xi_copy.php');
      	$this->load->view('default/xi_footer.php');
	}

	public function mkdirFolder()
	{
		$year  = date("Y");
	    $month = date("m");
	    $day   = date("d");

	    if( !is_dir("upload") )
	    {
	      if( !mkdir ("upload", 0755) )
	      {
	        return false;
	      }
	    }
	    chdir("upload");
	    if( !is_dir($year) )
	    {
	      if( !mkdir ($year, 0755) )
	      {
	        return false;
	      }
	    }
	    chdir($year);
	    if( !is_dir($month) )
	    {
	      if( !mkdir ($month, 0755) )
	      {
	        return false;
	      }
	    }
	    chdir($month);
	    if( !is_dir($day) )
	    {
	      if( !mkdir ($day, 0755) )
	      {
	        return false;
	      }
	    }
	    chdir("../../../");

	    $targetFolder = "upload/".$year."/".$month."/".$day."/";

	    return $targetFolder;
	}

	public function release() {
		$this->form_validation->set_error_delimiters('<div class="alert alert-danger">', '</div>');
		$this->form_validation->set_rules('pic_url_0', '图片地址', 'trim|required|min_length[12]|max_length[128]|is_unique[xi_picture.pic_url]|xss_clean|prep_url');
	  	
		$this->head['title']  = "网络发布-" . $this->title;
      	$this->load->view('default/xi_header.php',$this->head);

	  	if($this->form_validation->run() == FALSE) {
		      	$this->load->view('xi_network.php');
		      	$this->load->view('default/xi_copy.php');
		      	$this->load->view('default/xi_footer.php');
	 	} else {
	 		$targetDir = $this->mkdirFolder();

	 		for ($i=0; $i < 10; $i++) { 
	 			$pic_name = 'pic_url_' . $i;
	 			$pic_url  = $this->input->post($pic_name);
	 			if ($pic_url != "") {
	 				$hash    = random_string('unique', 32);
	 				$picstr  = explode(".",$pic_url);
					$savePic = $targetDir . $hash . "." . $picstr[count($picstr)-1];
					$thumPic = $targetDir . $hash . "_thumb." . $picstr[count($picstr)-1];
					$picdata = file_get_contents($pic_url);
					$fp   	 = @fopen($savePic, 'wb');
       				@fwrite($fp, $picdata);
        			fclose($fp);
				    //略缩图
					$src_img    = $savePic;
					$dst_img    = $thumPic;
					$width      = $this->system_model->sysinfo('thumb_width');
					$height     = 0;
					$cut        = 0;
					$proportion = 0;

					$this->img2thumb($src_img, $dst_img, $width, $height, $cut, $proportion);


	 				if ($this->pic_model->release($savePic,$hash) ) {

		  				$data['url']     = base_url();
				     	$data['message'] = "图片发布成功，请等待管理员审核。";
				      	$data['where']   = "首页"; 
		  			} else {
		  			  	$data['url']     = base_url('network');
				     	$data['message'] = "图片发布失败。";
				      	$data['where']   = "图片上传页面";   	
		  			}
	 			} else {
		  			$data['url']     = base_url();
				    $data['message'] = "图片发布成功，请等待管理员审核。";
				    $data['where']   = "首页"; 
	 			}
	 		}
			$this->load->view('default/xi_message.php',$data);
			$this->load->view('default/xi_copy.php');
        	$this->load->view('default/xi_footer.php');
	  	}
	}

/**
 * 生成缩略图
 * @author yangzhiguo0903@163.com
 * @param string     源图绝对完整地址{带文件名及后缀名}
 * @param string     目标图绝对完整地址{带文件名及后缀名}
 * @param int        缩略图宽{0:此时目标高度不能为0，目标宽度为源图宽*(目标高度/源图高)}
 * @param int        缩略图高{0:此时目标宽度不能为0，目标高度为源图高*(目标宽度/源图宽)}
 * @param int        是否裁切{宽,高必须非0}
 * @param int/float  缩放{0:不缩放, 0<this<1:缩放到相应比例(此时宽高限制和裁切均失效)}
 * @return boolean
 */
	public function img2thumb($src_img, $dst_img, $width = 75, $height = 75, $cut = 0, $proportion = 0)
	{
	    if(!is_file($src_img))
	    {
	        return false;
	    }
	    $ot = $this->fileext($dst_img);
	    $otfunc = 'image' . ($ot == 'jpg' ? 'jpeg' : $ot);
	    $srcinfo = getimagesize($src_img);
	    $src_w = $srcinfo[0];
	    $src_h = $srcinfo[1];
	    $type  = strtolower(substr(image_type_to_extension($srcinfo[2]), 1));
	    $createfun = 'imagecreatefrom' . ($type == 'jpg' ? 'jpeg' : $type);

	    $dst_h = $height;
	    $dst_w = $width;
	    $x = $y = 0;

	    /**
	     * 缩略图不超过源图尺寸（前提是宽或高只有一个）
	     */
	    if(($width> $src_w && $height> $src_h) || ($height> $src_h && $width == 0) || ($width> $src_w && $height == 0))
	    {
	        $proportion = 1;
	    }
	    if($width> $src_w)
	    {
	        $dst_w = $width = $src_w;
	    }
	    if($height> $src_h)
	    {
	        $dst_h = $height = $src_h;
	    }

	    if(!$width && !$height && !$proportion)
	    {
	        return false;
	    }
	    if(!$proportion)
	    {
	        if($cut == 0)
	        {
	            if($dst_w && $dst_h)
	            {
	                if($dst_w/$src_w> $dst_h/$src_h)
	                {
	                    $dst_w = $src_w * ($dst_h / $src_h);
	                    $x = 0 - ($dst_w - $width) / 2;
	                }
	                else
	                {
	                    $dst_h = $src_h * ($dst_w / $src_w);
	                    $y = 0 - ($dst_h - $height) / 2;
	                }
	            }
	            else if($dst_w xor $dst_h)
	            {
	                if($dst_w && !$dst_h)  //有宽无高
	                {
	                    $propor = $dst_w / $src_w;
	                    $height = $dst_h  = $src_h * $propor;
	                }
	                else if(!$dst_w && $dst_h)  //有高无宽
	                {
	                    $propor = $dst_h / $src_h;
	                    $width  = $dst_w = $src_w * $propor;
	                }
	            }
	        }
	        else
	        {
	            if(!$dst_h)  //裁剪时无高
	            {
	                $height = $dst_h = $dst_w;
	            }
	            if(!$dst_w)  //裁剪时无宽
	            {
	                $width = $dst_w = $dst_h;
	            }
	            $propor = min(max($dst_w / $src_w, $dst_h / $src_h), 1);
	            $dst_w = (int)round($src_w * $propor);
	            $dst_h = (int)round($src_h * $propor);
	            $x = ($width - $dst_w) / 2;
	            $y = ($height - $dst_h) / 2;
	        }
	    }
	    else
	    {
	        $proportion = min($proportion, 1);
	        $height = $dst_h = $src_h * $proportion;
	        $width  = $dst_w = $src_w * $proportion;
	    }

	    $src = $createfun($src_img);
	    $dst = imagecreatetruecolor($width ? $width : $dst_w, $height ? $height : $dst_h);
	    $white = imagecolorallocate($dst, 255, 255, 255);
	    imagefill($dst, 0, 0, $white);

	    if(function_exists('imagecopyresampled'))
	    {
	        imagecopyresampled($dst, $src, $x, $y, 0, 0, $dst_w, $dst_h, $src_w, $src_h);
	    }
	    else
	    {
	        imagecopyresized($dst, $src, $x, $y, 0, 0, $dst_w, $dst_h, $src_w, $src_h);
	    }
	    $otfunc($dst, $dst_img);
	    imagedestroy($dst);
	    imagedestroy($src);
	    return true;
	}

	public function fileext($file)
	{
	    return strtolower(pathinfo($file, PATHINFO_EXTENSION));
	}
}

/* End of file xixi.php */
/* Location: ./application/controllers/xixi.php */