<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Xixi extends CI_Controller {
	private $realip;
	private $user;
	private $title;
	private $keywords;
	private $description;
	private $search;
	private $head;
	function __construct()
	{
		parent::__construct();
		$this->realip = xi_get_ClientIp();

    	if( $this->session->userdata('online') ) {
			$this->user = $this->session->userdata('Username');
		} else {
			$this->user = 0;
		}

		$this->title       = $this->system_model->sysinfo('webtitle');
		$this->keywords    = $this->system_model->sysinfo('keywords');
		$this->description = $this->system_model->sysinfo('description');
		$this->search      = "";

		$this->head['search']      = $this->search;
		$this->head['title']       = $this->title;
		$this->head['keywords']    = $this->keywords;
		$this->head['description'] = $this->description;
	}

	public function browse()
	{
		if (!$this->browse_model->is_have($this->realip)) 
		{
			$this->browse_model->add($this->realip);
		}
	}

	public function index($page = 1) 
	{
		$this->load->view('default/xi_header.php',$this->head);
		if ($this->system_model->sysinfo('is_auto_layout') == "TRUE") 
		{
			$data['pictureURL'] = base_url('xixi/images');
			$this->load->view('xi_index.php',$data);
		}
		else
		{
			$data['images'] = $this->pic_model->pictures($page);
			$data['width']  = $this->system_model->sysinfo('img_show_width') + 24;
			$data['height'] = $this->system_model->sysinfo('img_show_height');
			$this->load->view('xi_image.php',$data);
			//分页
			$config['base_url']    = base_url();
			$config['total_rows']  = $this->pic_model->picturenum();
			$config['uri_segment'] = 1;
			$this->pagination->initialize($config); 
			$this->load->view('xi_page.php');
			$this->load->view('default/xi_copy.php');
		}

        $this->load->view('default/xi_footer.php');

        $this->browse();
	}

	public function imageInfo($query)
	{
		$ArrImages   = array();
		foreach ($query as $value) {

			if (!file_exists($value['pic_url'])) { //本地文件不存在
				continue;
			}
			$thumb    = explode(".",$value['pic_url']);
			$thumbpic = $thumb[0] . "_thumb." . $thumb[1];
			if (file_exists($thumbpic)) {
				$image_u  = base_url($thumbpic);
			} else {
				$image_u  = base_url($value['pic_url']);
			}
			
			$image_p  = base_url($value['pic_url']);
			
			$image    = GetImageSize($value['pic_url']);
			$image_w  = $image[0];
			$image_h  = $image[1];

			$image_t  = $value['pic_name'];

			$image_love = $this->love_model->is_love($value['pic_uuid'],$this->user);
			$image_like = $this->like_model->is_like($value['pic_uuid'],$this->realip);

			$image_i  = array('title' => $image_t,'viewid' => $value['ID'],'id' => $value['pic_uuid'],'url' => $image_u, 'pic' => $image_p,'width' => $image_w, 'height' => $image_h,'is_love' => $image_love, 'is_like' => $image_like );
			array_push($ArrImages,$image_i);
		}
		echo json_encode($ArrImages);
	}

	public function images( $page = 1, $limit = 0 ) {     //根据记录的发布日期返回所有记录
		$query = $this->pic_model->picturesNew( $page, $limit * 2 );
		$this->imageInfo($query);
	}


	public function search($search,$page=1) {   //搜索
        $this->head['title']    = urldecode($search) . "：" . $this->title . "搜索结果";
		$this->head['keywords'] = $this->keywords . "，" . urldecode($search);
		$this->head['search']   = urldecode($search);
        $this->load->view('default/xi_header.php',$this->head);
		if ($this->system_model->sysinfo('is_auto_layout') == "TRUE") 
		{
			$data['pictureURL'] = base_url('xixi/searcher') . "/" . urldecode($search);
			$this->load->view('xi_index.php',$data);
		}
		else
		{
			$data['images'] = $this->pic_model->search(urldecode($search),$page);
			$data['width']  = $this->system_model->sysinfo('img_show_width') + 24;
			$data['height'] = $this->system_model->sysinfo('img_show_height');
			$this->load->view('xi_image.php',$data);
			//分页
			$config['base_url']    = base_url('search/' . urldecode($search));
			$config['total_rows']  = $this->pic_model->searchnum(urldecode($search));
			$config['uri_segment'] = 3;
			$this->pagination->initialize($config); 
			$this->load->view('xi_page.php');
			$this->load->view('default/xi_copy.php');
		}

        $this->load->view('default/xi_footer.php');
	}

	public function searcher($search = "",$page = 1,$limit) {   //返回指定搜索内容的数据
		$query = $this->pic_model->searchNew( urldecode($search), $page, $limit * 2 );
		$this->imageInfo($query);
	}

	public function catalogue($catalogue = "",$page = 1) 
	{   //分类
		$catname = $this->catalogue_model->name_by_another($catalogue);
		$this->head['title']    = urldecode($catname) . "-" . $this->title;
		$this->head['keywords'] = $this->keywords . "，" . urldecode($catname);
		$this->load->view('default/xi_header.php',$this->head);
		if ($this->system_model->sysinfo('is_auto_layout') == "TRUE") 
		{
			$data['pictureURL'] = base_url('xixi/cat') . "/" . urldecode($catalogue);
			$this->load->view('xi_index.php',$data);
		}
		else
		{
			$data['images'] = $this->pic_model->catalogue(urldecode($catalogue),$page);
			$data['width']  = $this->system_model->sysinfo('img_show_width') + 24;
			$data['height'] = $this->system_model->sysinfo('img_show_height');
			$this->load->view('xi_image.php',$data);
			//分页
			$config['base_url']    = base_url('catalogue/' . urldecode($catalogue));
			$config['total_rows']  = $this->pic_model->cataloguenum(urldecode($catalogue));
			$config['uri_segment'] = 3;
			$this->pagination->initialize($config); 
			$this->load->view('xi_page.php');
			$this->load->view('default/xi_copy.php');
		}

        $this->load->view('default/xi_footer.php');
	}

	public function cat($catalogue = "",$page = 1, $limit = 0) 
	{   //返回指定分类的数据
		$query = $this->pic_model->catalogueNew( urldecode($catalogue), $page,  $limit * 2);
		$this->imageInfo($query);
	}

	public function tag($tag,$page = 1) {   //标签
		$this->head['title']    = urldecode($tag) . "-" . $this->title;
		$this->head['keywords'] = $this->keywords . "，" . urldecode($tag);
		$this->load->view('default/xi_header.php',$this->head);
		
		if ($this->system_model->sysinfo('is_auto_layout') == "TRUE") 
		{
			$data['pictureURL'] = base_url('xixi/gettag') . "/" . urldecode($tag);
			$this->load->view('xi_index.php',$data);
		}
		else
		{
			$data['images'] = $this->pic_model->tag(urldecode($tag),$page);
			$data['width']  = $this->system_model->sysinfo('img_show_width') + 24;
			$data['height'] = $this->system_model->sysinfo('img_show_height');
			$this->load->view('xi_image.php',$data);
			//分页
			$config['base_url']    = base_url('tag/' . urldecode($tag));
			$config['total_rows']  = $this->pic_model->tagnum(urldecode($tag));
			$config['uri_segment'] = 3;
			$this->pagination->initialize($config); 
			$this->load->view('xi_page.php');
			$this->load->view('default/xi_copy.php');
		}

        $this->load->view('default/xi_footer.php');
	}

	public function gettag($tag = "",$page = 1,$limit) {   //返回指定标签的数据
		$query = $this->pic_model->tagNew( urldecode($tag), $page,$limit * 2 );
		$this->imageInfo($query);
	}

	public function love($uuid) {
		$loveArray = array();
		if( $this->session->userdata('online') ) {
			$user = $this->session->userdata('Username');
			if($this->love_model->is_love($uuid,$user)) {
				$this->love_model->remove_love($uuid,$user);
				$this->pic_model->removelove($uuid);
			} else {
				$this->love_model->add_love($uuid,$user);
				$this->pic_model->addlove($uuid);
			}
			$lovenum = $this->love_model->pic_love($uuid);

			$is_love = $this->love_model->is_love($uuid,$user);

			$jsonStr = array('love' => $lovenum, 'is_love' => $is_love, 'is_login' => 1 );
		} else {
			$jsonStr = array('love' => 0, 'is_love' => 0, 'is_login' => 0 );
		}

		array_push($loveArray,$jsonStr);

		echo json_encode($loveArray);
	}

	public function like( $uuid ) {

	    $likeArray = array();

	    $is_like = $this->like_model->is_like($uuid,$this->realip);

		if ($is_like) {
			$this->like_model->remove_like($uuid,$this->realip);
			$this->pic_model->removelike($uuid);
		} else {
			$this->like_model->add_like($uuid,$this->realip);
			$this->pic_model->addlike($uuid);
		}

		$likenum = $this->like_model->pic_like($uuid);

		$is_like = $this->like_model->is_like($uuid,$this->realip);

		$jsonStr = array('like' => $likenum, 'is_like' => $is_like);

		array_push($likeArray,$jsonStr);

		echo json_encode($likeArray);
	}

	public function downImage($uuid='')
	{
		$this->load->helper('download');
		if($this->pic_model->is_view($uuid))
		{
			$down = $this->pic_model->addown($uuid);
			$query = $this->pic_model->one($uuid);
			foreach ($query as $value) 
			{
				$data = file_get_contents(base_url($value['pic_url']));
				force_download(basename($value['pic_url']), $data);
			}
		}
	}

	public function edittag($pic='',$tags='')
	{
		$tags = urldecode($tags);

		$oldtag = $this->pic_model->gettag($pic);

		$tagstr   = preg_replace("/\s|　/","",$tags); //去除所以空格
      	$newtag = str_replace(","," ",$tagstr);
      	$this->pic_model->edittags($pic,$newtag);
      	//更新标签的次数
      	
	    $tag  = explode (" ", $newtag);

      	for ($i = 0; $i < count($tag); $i++) {
        	if ($this->tags_model->is_tag($tag[$i])) 
        	{
        		if(!stristr($oldtag,$tag[$i]))
        		{
          			$this->tags_model->addamount($tag[$i]);
          		}
        	} else {
          		if ($tag[$i] != "") {
            		$this->tags_model->addtag($tag[$i]);
          		}
       		 }
    	}
      	echo "0";
	}

	public function random()
	{
		$pic = $this->pic_model->random();
		foreach ($pic as $value) {
			echo $value['ID'];
		}
	}
}

/* End of file xixi.php */
/* Location: ./application/controllers/xixi.php */