<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

/*
 * 日志记录类
 */
class Logger
{
	var $file_name  = '.log';
	var	$time       = 'H:i:s';
	var $date       = 'Y-m-d';

	/**
	 * 向日志文件中写记录
	 * 日志文件存储在 upload/log 目录下 
	 * 以 YYYY-MM-DD.log 方式命名
	 *
	 * @param string 	信息类型 INFO ERROR WARNING
	 * @param string 	信息内容
	 * @return bool 	成功返回TRUE 失败返回FALSE
	 */
	function write($type = 'INFO', $msg = NULL)
	{
		if ($msg == NULL)
		{
			return FALSE;
		}

		$type = strtoupper($type);

		$log =  'upload' . DIRECTORY_SEPARATOR . 'log' . DIRECTORY_SEPARATOR . date($this->date,time()) . $this->file_name;
		if ( ! $fp = fopen($log, 'ab'))
		{
			return FALSE;
		}

		$message = $type . " " . (($type == 'INFO') ? ' - ' : '- ') . date($this->time,time()) . " --> " . $msg . "\r\n";

		flock($fp, LOCK_EX);
		fwrite($fp, $message);
		flock($fp, LOCK_UN);
		fclose($fp);

		@chmod($log, 0666);
		return TRUE;
	}

	/*
	 * 清空日志文件
	 */
	function clean()
	{
		$path = 'upload' . DIRECTORY_SEPARATOR . 'log';
		$dir  = opendir($path);
		while( ( $file = readdir( $dir ) ) !== false )
		{
          	$sub_dir = $path . DIRECTORY_SEPARATOR . $file;
          	if( $file == '.' || $file == '..' ) 
          	{
            	continue;
          	} 
          	else if( is_dir( $sub_dir ) )
          	{
          		continue; 
          	}
          	else
          	{
          		@unlink($sub_dir);
          	}
		}
	}
}

/* End of file Logger.php */
/* Location: ./application/libraries/Logger.php */