<!DOCTYPE html>
<html>
  <head>
    <meta charset="utf-8">
    <title><?php echo $title ?></title>
    <meta name="keywords" content="<?php echo $keywords ?>" />
    <meta name="description" content="<?php echo $description ?>" />
    <meta name="author" content="root@dolphin" />
    <meta name="copyright" content="© http://hbdx.cc" />
    <link rel="icon" href="<?php echo base_url('favicon.ico') ?>" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <!-- Bootstrap -->
    <?php if ($this->system_model->sysinfo('is_loacl_debug') == "TRUE"): ?>
    <link href="<?php echo base_url('dist/css/bootstrap.min.css') ?>" rel="stylesheet">
    <link href="<?php echo base_url('dist/css/font-awesome.min.css') ?>" rel="stylesheet">
    <link href="<?php echo base_url('dist/css/normalize.css') ?>" rel="stylesheet">
    <link href="<?php echo base_url('dist/css/lightbox.css') ?>" rel="stylesheet">
    <link href="<?php echo base_url('dist/css/webuploader.css') ?>" rel="stylesheet">
    <script src="<?php echo base_url('dist/js/jquery-1.11.1.min.js') ?>"></script>
    <?php else: ?>
    <link href="http://cdn.bootcss.com/bootstrap/3.2.0/css/bootstrap.min.css" rel="stylesheet">
    <link href="http://cdn.bootcss.com/font-awesome/4.2.0/css/font-awesome.min.css" rel="stylesheet">
    <link href="http://cdn.bootcss.com/normalize/3.0.1/normalize.min.css" rel="stylesheet">
    <link href="http://cdn.bootcss.com/lightbox2/2.7.1/css/lightbox.css" rel="stylesheet">
    <link href="http://cdn.bootcss.com/webuploader/0.1.1/webuploader.css" rel="stylesheet">
    <script src="http://cdn.bootcss.com/jquery/2.1.1/jquery.min.js"></script>
    <?php endif; ?>
    <link href="<?php echo base_url('dist/css/signin.css') ?>" rel="stylesheet">
    <link href="<?php echo base_url('dist/css/upload.css') ?>" rel="stylesheet">
    <link href="<?php echo base_url('dist/css/bootstrap-tagsinput.css') ?>" rel="stylesheet">
    <!-- HTML5 Shim and Respond.js IE8 support of HTML5 elements and media queries -->
    <!-- WARNING: Respond.js doesn't work if you view the page via file:// -->
    <!--[if lt IE 9]>
        <script src="http://cdn.bootcss.com/html5shiv/3.7.0/html5shiv.min.js"></script>
        <script src="http://cdn.bootcss.com/respond.js/1.3.0/respond.min.js"></script>
    <![endif]-->
    <script>
      var Home = "<?php echo base_url() ?>";
    </script>
  </head>
  <body>
    <div class="wrap">
      <nav class="navbar navbar-default border navbar-fixed-top" role="navigation">
        <div class="navbar-header">
          <button type="button" class="navbar-toggle" data-toggle="collapse" data-target="#bs-example-navbar-collapse-1">
            <span class="sr-only">Toggle navigation</span>
            <span class="icon-bar"></span>
            <span class="icon-bar"></span>
            <span class="icon-bar"></span>
          </button>
          <a class="navbar-brand" style="font-size: 14px; color: #009933; font-weight: bold;" href="<?php echo base_url() ?>"><?php echo $this->system_model->sysinfo('webtitle') ?></a>
        </div>

        <div class="collapse navbar-collapse" id="bs-example-navbar-collapse-1">
          <ul class="nav navbar-nav">
            <li class="dropdown dropdown-large">
              <a href="javascript:void()" alt="导航" class="dropdown-toggle" data-toggle="dropdown"><i class="fa fa-align-justify fa-lg"></i></a>
              <ul class="dropdown-menu dropdown-menu-large row">
                <li class="col-sm-4">
                  <ul>
                  <?php
                  $query = $this->catalogue_model->catalogue();
                  foreach ($query as $key => $value) {
                    $catalogue_url = base_url('catalogue') . '/' . $value['cat_another_name'];
                    if($key % 3 == 0) {
                  ?>
                  <li><a href="<?php echo $catalogue_url ?>"><?php echo $value['cat_name'] ?></a></li>
                  <li class="divider"></li>
                  <?php } } ?> 
                  </ul>
                </li>
                <li class="col-sm-4">
                  <ul>
                  <?php
                  $query = $this->catalogue_model->catalogue();
                  foreach ($query as $key => $value) {
                    $catalogue_url = base_url('catalogue') . '/' . $value['cat_another_name'];
                    if($key % 3 == 1) {
                  ?>
                  <li><a href="<?php echo $catalogue_url ?>"><?php echo $value['cat_name'] ?></a></li>
                  <li class="divider"></li>
                  <?php } } ?> 
                  </ul>
                </li>
                <li class="col-sm-4">
                  <ul>
                  <?php
                  $query = $this->catalogue_model->catalogue();
                  foreach ($query as $key => $value) {
                    $catalogue_url = base_url('catalogue') . '/' . $value['cat_another_name'];
                    if($key % 3 == 2) {
                  ?>
                  <li><a href="<?php echo $catalogue_url ?>"><?php echo $value['cat_name'] ?></a></li>
                  <li class="divider"></li>
                  <?php } } ?> 
                  </ul>
                </li>
              </ul>
            </li>
            <li class="<?php if(stristr(current_url(),'make')) { echo 'active'; } ?>"><a href="<?php echo site_url('make') ?>"><i class="fa fa-tags fa-lg"></i></a></li>
          </ul>

          <div class="navbar-form navbar-left" role="search">
            <div class="form-group">
              <input type="text" id="search" value="<?php echo $search ?>" class="form-control border" placeholder="Search" onkeypress="EnterSearch()">
            </div>
            <button type="submit" class="btn btn-default border" onClick="Search()">Search</button>
          </div>

          <ul class="nav navbar-nav navbar-right">
            <?php if( $this->session->userdata('online') ) { ?>
            <?php $username = $this->session->userdata('Username'); ?>

            <?php
              $picture = 'upload/user/' . $this->user_model->picture($username) . '_3.jpg';
              if (file_exists($picture)) {
                $userpic = base_url('upload/user/' . $this->user_model->picture($username) . '_3.jpg');
              } else {
                $userpic = base_url('upload/user/default_3.jpg');
              }
            ?>

            <li><a href="<?php echo site_url('setting') ?>" style="padding: 9px 10px;" alt="个人主页"><img src="<?php echo $userpic ?>" class="img-circle"></a></li>
            <li class="dropdown">
              <a href="javascript:void()" class="dropdown-toggle right-border" data-toggle="dropdown" alt="功能"><i class="fa fa-align-justify fa-lg"></i></a>
              <ul class="dropdown-menu" role="menu">
                <?php if ($this->user_model->is_admin($username)) { ?>
                <li><a href="<?php echo site_url('admin') ?>"><i class="fa fa-key"></i> 管理中心</a></li>
                <li class="divider"></li>
                <?php } ?>

                <li><a href="<?php echo site_url('upload') ?>"><i class="fa fa-upload"></i> 本地图片</a></li>
                <li class="divider"></li>
                <li><a href="<?php echo site_url('network') ?>"><i class="fa fa-upload"></i> 网络图片</a></li>
                <li class="divider"></li>
                <li><a href="<?php echo site_url('logout') ?>"><i class="fa fa-sign-out"></i> 退出登录</a></li>
              </ul>
            </li>
            <li><a></a></li>
            <?php } else { ?>
            <a type="button" class="btn btn-success btn-circle navbar-btn" href="<?php echo site_url('register') ?>">注册</a>
            <a type="button" style="margin-right:40px;" class="btn btn-success btn-circle navbar-btn" href="<?php echo site_url('login') ?>">登录</a>
            <?php } ?> 
          </ul>
        </div>
      </nav>