<?php
/**
 * BackendPro
 *
 * An open source development control panel written in PHP
 *
 * @package		BackendPro
 * @author		Adam Price
 * @copyright	Copyright (c) 2008, Adam Price
 * @license		http://www.gnu.org/licenses/lgpl.html
 * @link		http://www.kaydoo.co.uk/projects/backendpro
 * @filesource
 */

// ------------------------------------------------------------------------

/**
 * Perform File Replacement
 *
 * Replace the files in the basic CodeIgniter install with the
 * custom created files using the Users entered data
 *
 * @package 	BackendPro
 * @subpackage 	Install
 * @param 		string $fromFile Source filename
 * @param 		string $toFile Destination filename
 * @param 		array  $replacementArray Array of replacement strings
 * @return 		bool
 */
function PerformOverWrite($fromFile, $toFile, $replacementArray)
{
	global $logger;

	$file = $fromFile;
	$contents = file_get_contents($file);

	// Lets run our replacement
	foreach($replacementArray as $key => $value)
	{
		$contents = preg_replace('/{' . $key . '}/', $value, $contents);
	}

	// Lets copy the files to there correct locations
	if( !$fp = @fopen($toFile, 'wb'))
	{
		return "Could not open " . $toFile . " to write new content to";
	}

	flock($fp, LOCK_EX);
	fwrite($fp, $contents);
	flock($fp, LOCK_UN);
	fclose($fp);
	return TRUE;
}

/**
 * Overwrite System Config
 *
 * Overwrite the default system config file with the new
 * custom file created using the Users input
 *
 * @package 	BackendPro
 * @subpackage 	Install
 */
class OverWriteSystemConfig extends Component
{
	var $name 		= "Create new system config file";
	var $copyFrom 	= "files/config.txt";
	var $copyTo 	= "../application/config/config.php";

	function Install()
	{
		global $logger;
		
		// Base chars
		$base = "ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789";
		$max = strlen($base)-1;

		$encrypt_key = '';
		mt_srand((double)microtime()*1000000);
		while (strlen($encrypt_key)<32)
		{
			$encrypt_key .= $base{mt_rand(0,$max)};
		}

		// Define what variables need replacing in this file
		$replace = array(
				'base_url'			=> $_POST['weburl'],
		    	'encryption_key' 	=> $encrypt_key);

		if ($result = PerformOverWrite($this->copyFrom, $this->copyTo, $replace) !== TRUE)
		{
			$this->error = $result;
			$logger->write('error',$this->error);
		}
		else
		{
			$this->status = TRUE;
		}

		return $this->status;
	}
}

/**
 * Overwrite Database Config
 *
 * Overwrite the default database config file with the new
 * custom file created using the Users input
 *
 * @package  	BackendPro
 * @subpackage 	Install
 */
class OverWriteDatabaseConfig extends Component
{
	var $name 		= "Create new database config file";
	var $copyFrom 	= "files/database.txt";
	var $copyTo 	= "../application/config/database.php";

	function Install()
	{
		global $logger;
		
		// Define what variables need replacing in this file
		$replace = array(
				'database_host'		=> $_POST['database_host'],
                'database_user'		=> $_POST['database_user'],
                'database_password'	=> $_POST['database_password'],
                'database_name'		=> $_POST['database_name']);

		if ($result = PerformOverWrite($this->copyFrom, $this->copyTo, $replace) !== TRUE)
		{
			$this->error = $result;
			$logger->write('error',$this->error);
		}
		else
		{
			$this->status = TRUE;
		}

		return $this->status;
	}
}




/* End of file SetupFileSystem.php */
/* Location: ./install/components/SetupFileSystem.php */