<?php

    // +----------------------------------------------------------------------
    // | 后台控制器基类
    // +----------------------------------------------------------------------
    // | Copyright (c) 2015-2019 http://www.yicmf.com, All rights reserved.
    // +----------------------------------------------------------------------
    // | Author: 微尘 <yicmf@qq.com>
    // +----------------------------------------------------------------------

    namespace app\common\controller;

    use app\common\traits\controller\Bjui;
    use PhpOffice\PhpSpreadsheet\Spreadsheet;
    use think\facade\Config;

    class Admin extends Base
    {
        use Bjui;

        /**
         * 导入Excel表格
         * @param $file
         * @return array
         * @throws \Exception
         * @author  : 微尘 <yicmf@qq.com>
         * @datetime: 2019/2/17 12:43
         */
        protected function excelImport($file)
        {
            if ( $file->getInfo()['type'] !== 'application/vnd.ms-excel' ) {
                throw new \Exception('暂时仅支持Excel2003');
            } else {
                $objReader = \PHPExcel_IOFactory::createReader('Excel5');
                $objPHPExcel = $objReader->load($file->getPathname(), $encode = 'utf-8');
                $sheet = $objPHPExcel->getSheet(0);
                $highestRow = $sheet->getHighestRow(); // 取得总行数
                $col = ord($sheet->getHighestColumn()) - ord('A'); // 取得总列数
                $exc_arr = [];
                for ( $i = 1; $i <= $highestRow; $i++ ) {
                    $start = ord('A');
                    $temp = [];
                    for ( $k = 0; $k <= $col; $k++ ) {
                        $temp[] = (string)$objPHPExcel->getActiveSheet()->getCell(chr($start) . $i)->getValue(); //读取类型正常
                        $start++;
                    }
                    $exc_arr[] = $temp;
                }

                return $exc_arr;
            }
        }

        /**
         * 输出Excel文件.
         * @param     $fileName 文件名
         * @param     $headArr  列表头
         * @param     $data     数据
         * @return string
         * @throws \PhpOffice\PhpSpreadsheet\Exception
         * @author  : 微尘 <yicmf@qq.com>
         * @datetime: 2019/2/17 10:59
         */
        protected function excelOut($fileName, $headArr, $data)
        {
            set_time_limit(0);
            // 对数据进行检验
            if ( empty($fileName) || empty($headArr) || empty($data) ) {
                throw new \Exception('参数不合法');
            }
            $date = date('Y_m_d', time());
            $fileName .= "_{$date}.csv";
            $spreadsheet = new Spreadsheet();
            $sheet = $spreadsheet->getActiveSheet();
            //设置表头
            $column = 1;
            $span = ord('A');
            foreach ( $headArr as $v ) {
                $j = chr($span);
                $sheet->setCellValue($j . $column, $v);
                $span += 1;
            }
            //设置为文本格式
            foreach ( $data as $key => $rows ) { //行写入
                $column++;
                $span = ord('A');
                foreach ( is_object($rows) ? $rows->toArray() : $rows as $keyName => $value ) {// 列写入
                    $j = chr($span);
                    $sheet->setCellValue($j . $column, $value);
                    $span++;
                }
            }
            $column = $column + 3;
            $sheet->setCellValue('A' . $column, 'Power by YiCmf ' . Config::get('yicmf.version'));
            // 设置单元格格式 可以省略
            //        $styleArray = [
            //            'font' => [
            //                'bold' => true,
            //                'size' => 14,
            //            ],
            //        ];
            //        $spreadsheet->getActiveSheet()->getStyle('A1:B1')->applyFromArray($styleArray);
            //        $spreadsheet->getActiveSheet()->getColumnDimension('A')->setWidth(25);
            //        $spreadsheet->getActiveSheet()->getColumnDimension('B')->setWidth(25);
            //        $spreadsheet->getActiveSheet()->fromArray($data);
            $writer = new \PhpOffice\PhpSpreadsheet\Writer\Csv($spreadsheet);
            //        header('Content-Description: File Transfer');
            //        header('Expires: 0');
            //        header('Cache-Control: must-revalidate');
            //        header('Pragma: public');
            //        header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
            //        header('Content-Disposition: attachment;filename=test.csv');
            //        header('Cache-Control: max-age=0');
            # 浏览器下载
            header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
            header('Content-Disposition: attachment;filename=' . $fileName);
            header('Cache-Control: max-age=0');
            $writer->save('php://output');
            return;
            //        halt($spreadsheet);
            $fp = fopen('php://output', 'a');//打开output流
            mb_convert_variables('GBK', 'UTF-8', $columns);
            fputcsv($fp, $columns);//将数据格式化为csv格式并写入到output流中
            $dataNum = count($arrData);
            $perSize = 1000;//每次导出的条数
            $pages = ceil($dataNum / $perSize);

            for ( $i = 1; $i <= $pages; $i++ ) {
                foreach ( $arrData as $item ) {
                    mb_convert_variables('GBK', 'UTF-8', $item);
                    fputcsv($fp, $item);
                }
                //刷新输出缓冲到浏览器
                ob_flush();
                flush();//必须同时使用 ob_flush() 和flush() 函数来刷新输出缓冲。
            }
            fclose($fp);
        }

    }
