<?php

    // +----------------------------------------------------------------------
    // | 所有控制器共有类
    // +----------------------------------------------------------------------
    // | Copyright (c) 2015-2019 http://www.yicmf.com, All rights reserved.
    // +----------------------------------------------------------------------
    // | Author: 微尘 <yicmf@qq.com>
    // +----------------------------------------------------------------------

    namespace app\common\controller;

    use think\Controller;

    /* 所有控制器共有类 */

    class Base extends Controller
    {
        // 页面seo信息
        protected $_seo = [];

        /**
         * base初始化.
         */
        protected function initialize()
        {
            // 模板添加Request
            $this->assign('request', $this->request);
        }

        /**
         * 设置页面seo信息.
         * @param string $title
         * @param string $keywords
         * @param string $description
         * @author 微尘 <yicmf@qq.com>
         */
        protected function setSeo($title = '', $keywords = '', $description = '')
        {
            $this->_seo['title'] = $title;
            $this->_seo['keywords'] = $keywords;
            $this->_seo['description'] = $description;
            $this->assign('seo', $this->_seo);
        }

        public function _empty()
        {
            header('HTTP/1.0 404 Not Found'); // 使HTTP返回404状态码
            return '这里是空操作，控制器：' . $this->request->controller() . '方法：' . $this->request->action();
        }
    }
