<?php

    // +----------------------------------------------------------------------
    // | 模型安装类
    // +----------------------------------------------------------------------
    // | Copyright (c) 2015-2019 http://www.yicmf.com, All rights reserved.
    // +----------------------------------------------------------------------
    // | Author: 微尘 <yicmf@qq.com>
    // +----------------------------------------------------------------------

    namespace app\common\event;

    use think\facade\Config;
    use think\facade\Env;

    class Setting
    {

        /**
         * 更新模块配置
         * 模版文件请保存在\data\tpl\ 目录下，且跟模块同名
         * @param      $update
         * @param      $module
         * @param null $path
         * @return bool|int
         * @author  : 微尘 <yicmf@qq.com>
         * @datetime: 2019/1/26 13:36
         */
        public static function update($update, $module, $path = null)
        {
            $config = Config::get($module . '.');
            if (is_array($config) && is_array($update))
            {
                $config = array_merge($config, $update);
            }elseif (!$config && $update)
            {
                $config = $update;
            }
            // 配置文件模版
            $config_tpl = file_get_contents(Env::get('root_path') . 'data' . DIRECTORY_SEPARATOR . 'tpl' . DIRECTORY_SEPARATOR . $module . '.tpl');
            //替换配置项
            foreach ( $config as $name => $value ) {
                if ( is_array($value) ) {
                    $temp = '[';
                    foreach ( $value as $key2 => $value2 ) {
                        if ( count($value) == ($key2 + 1) ) {
                            $temp .= '\'' . $value2 . '\'';
                        } else {
                            $temp .= '\'' . $value2 . '\',';
                        }
                    }
                    $temp .= ']';
                    $config_tpl = str_replace('{$' . $name . '}', $temp, $config_tpl);
                } else {
                    $config_tpl = str_replace('{$' . $name . '}', $value, $config_tpl);
                }
            }
            $path || $path = Env::get('root_path') . 'config' . DIRECTORY_SEPARATOR . $module . '.php';
            // 写入配置
            return file_put_contents($path, $config_tpl);
        }
    }
