<?php

// +----------------------------------------------------------------------
// | YiCMf系统标签库
// +----------------------------------------------------------------------
// | Copyright (c) 2015-2019 http://www.yicmf.com, All rights reserved.
// +----------------------------------------------------------------------
// | Author: 微尘 <yicmf@qq.com>
// +----------------------------------------------------------------------

namespace app\common\taglib;

use think\template\TagLib;

class Yicmf extends TagLib
{
    // 标签定义
    protected $tags = [
        // 标签定义： attr 属性列表 close 是否闭合（0 或者1 默认1） alias 标签别名 level 嵌套层次
        'hook'      => ['attr' => 'name,type,param', 'close' => 0], //钩子标签
        'editor'      => ['attr' => 'name,type,param', 'close' => 0], //钩子标签
        'config'    => ['attr' => 'name', 'close' => 0], //简化输出配置
        'define'    => ['attr' => 'name', 'close' => 0], //define定义输出
        'query'     => ['attr'=>'sql,result', 'close'=>0],
        ];

    public function tagDefine($tag)
    {
        if (empty($tag['name'])) {
            return '';
        }

        return  '<?php echo '.$tag['name'].'; ?>';
    }

    /**
     * 简化说出配置文件
     *
     * @param array $tag
     *
     * @return string
     */
    public function tagConfig($tag)
    {
        $parseStr = '<?php ';
        if (empty($tag['name'])) {
            return '';
        } else {
            $parseStr .= 'echo \think\facade\Config::get(\''.$tag['name'].'\');';
        }
        $parseStr .= ' ?>';

        return $parseStr;
    }

    /**
     * 钩子在模版的调用
     * {Yicmf:hook name='hookName'}.
     *
     * @param unknown $tag
     * @param unknown $content
     *
     * @return unknown|string
     */
    public function tagHook($tag)
    {
        $style = empty($tag['type']) ? 'listen' : $tag['type'];
        $parseStr = '<?php ';
        if (empty($tag['name'])) {
            return '';
        } else {
            switch ($style) {
                case 'listen':
                    if (empty($tag['param'])) {
                        $parseStr .= '$hook_return = \think\facade\Hook::listen("'.$tag['name'].'");';
                    } else {
                        $parseStr .= '$hook_return = \think\facade\Hook::listen("'.$tag['name'].'",'.$tag['param'].');';
                    }
                    $parseStr .= 'if (is_array($hook_return)&&!empty($hook_return)){';
                    $parseStr .= 'foreach($hook_return as $hook){echo $hook;}};';
                    break;
                default:;
                    break;
            }
        }
        $parseStr .= ' ?>';

        return $parseStr;
    }
    // sql查询
    public function tagQuery($tag, $content)
    {
        $sql = $tag['sql'];
        $result = !empty($tag['result']) ? $tag['result'] : 'result';
        $parseStr = '<?php $'.$result.' = M()->query("'.$sql.'");';
        $parseStr .= 'if($'.$result.'):?>'.$content;
        $parseStr .= '<?php endif;?>';

        return $parseStr;
    }
}
