<?php

    // +----------------------------------------------------------------------
    // | Bjui需要的traits
    // +----------------------------------------------------------------------
    // | Copyright (c) 2015-2019 http://www.yicmf.com, All rights reserved.
    // +----------------------------------------------------------------------
    // | Author: 微尘 <yicmf@qq.com>
    // +----------------------------------------------------------------------

    namespace app\common\traits\controller;

    use app\ucenter\event\User;
    use think\exception\HttpResponseException;
    use think\facade\Response;
    use app\ucenter\event\Action as ActionEvent;
    use think\facade\Config;
    use think\facade\Cache;
    use think\Db;
    use think\Loader;

    trait Bjui
    {

        protected function _search($dbname = '')
        {
            $map = [];
            $dbname = $dbname ?: $this->request->controller();
            if ( false !== strpos($dbname, '.') ) {
                $dbname = explode('.', $dbname)[1];
            }
            $cache = 'fields_search_db_' . $dbname;
            if ( !Cache::get($cache) ) {
                Cache::set($cache, Db::getTableFields(Config::get('database.prefix') . Loader::parseName($dbname)));
            }
            $params = $this->request->param();
            if ( !empty($params) ) {
                foreach ( $params as $key => $param ) {
                    if ( $param && in_array($key, Cache::get($cache)) ) {
                        if ( in_array($key, Config::get('ucenter.search_like')) ) {
                            $map[$key] = ['like', '%' . trim($param) . '%'];
                        } elseif ( in_array($key, Config::get('ucenter.search_between_time')) ) {
                            if ( $param[0] && $param[1] ) {
                                $map[$key] = ['between time', $param];
                            }
                        } else {
                            $map[$key] = $param;
                        }
                    }
                }
            }
            return $map;
        }

        /**
         * 获取\think\facade\Response\Json对象实例.
         * @param mixed $data    返回的数据
         * @param int   $code    状态码
         * @param array $header  头部
         * @param array $options 参数
         * @return \think\response
         * @author  : 微尘 <yicmf@qq.com>
         * @datetime: 2019/3/12 10:21
         */
        protected function json($data = [], $code = 200, $header = [], $options = [])
        {
            return Response::create($data, 'json', $code, $header, $options);
        }

        /**
         * 返回请求信息.
         * @param int          $status
         * @param string|array $info   返回的信息，可以是数组、字符串
         * @param bool string       $closeCurrent 是否关闭当前窗口(navtab或dialog)。
         * @param array|null   $result $navTabId     待刷新navtab id，多个id以英文逗号分隔开，当前的navtab id不需要填写，填写后可能会导致当前navtab重复刷新。
         * @throws \Exception
         * @author  : 微尘 <yicmf@qq.com>
         * @datetime: 2019/3/12 10:20
         */
        protected function ajax($status, $info, $closeCurrent = false, $result = [])
        {
            // 记录日志
            if ( is_string($info) ) {
                ActionEvent::log('admin_operation_log', 'admin_return', ['id' => 0], User::getLogin(), [
                    'info' => $info,
                    'status_code' => $status,
                ]);
            }
            $result['statusCode'] = $status;
            $result['closeCurrent'] = $closeCurrent;
            $result['forward'] = '';
            $result['forwardConfirm'] = '';
            if ( is_array($info) ) {
                $result = array_merge($result, $info);
            } else {
                $result['message'] = $info;
            }
            $response = Response::create($result, 'json');
            throw new HttpResponseException($response);
        }
    }
