<?php

    // +----------------------------------------------------------------------
    // | 图片文件管理
    // +----------------------------------------------------------------------
    // | Copyright (c) 2015-2019 http://www.yicmf.com, All rights reserved.
    // +----------------------------------------------------------------------
    // | Author: 微尘 <yicmf@qq.com>
    // +----------------------------------------------------------------------

    namespace app\file\controller;

    use think\facade\Config;
    use app\ucenter\event\User as UserEvent;
    use app\file\event\Picture as PictureEvent;
    use app\file\model\Picture as PictureModel;
    use think\facade\Session;
    use think\response\Download;

    class Picture extends Common
    {
        public function index()
        {
        }

        /* 图片上传 */
        public function upload()
        {
            if ( $this->request->isPost() ) {
                $file = $this->request->file('file');
                $picture = new PictureEvent();
                $data = $picture->upload($this->request->post(), $file, Config::get('upload_picture.'), UserEvent::getLogin());
            } else {
                $data['code'] = 910002;
                $data['type'] = 'error';
                $data['message'] = '请求错误';
            }
            if (0 !== $data['code'])
            {
                return json($data,500);
            }else{
                return json($data);
            }
        }
        /* 图片上传 */
        public function avatar()
        {
            if ( $this->request->isPost() ) {
                $file = $this->request->file('file');
                $picture = new PictureEvent();
                $data = $picture->upload($this->request->post(), $file, Config::get('upload_picture.'), UserEvent::getLogin());
                $data['data']['url_normal'] = $data['data']['url_normal'];
            } else {
                $data['code'] = 910002;
                $data['type'] = 'error';
                $data['message'] = '请求错误';
            }
            return json_encode($data);
        }
        /**
         * 显示加密封面
         * @author 微尘 <yicmf@qq.com>
         * @datetime: 2019/6/9 7:30
         */
        public function cover()
        {
            $picture = PictureModel::find($this->request->param('id'));
            if ($picture){
                $path = '.'.str_replace($this->request->domain(),'',$picture['url_small']);
                if (is_file($path))
                {
                    $download = new Download($path);
                    $name = $picture['name'];
                }else{
                    $download = new Download('default.gif');
                    $name = 'default.gif';
                }
            }else{
                $download = new Download('default.gif');
                $name = 'default.gif';
            }
            return $download->name($name);
        }
        /**
         * 显示加密封面
         * @author 微尘 <yicmf@qq.com>
         * @datetime: 2019/6/9 7:30
         */
        public function preview()
        {
            $picture = PictureModel::find($this->request->param('id'));
            if ($picture){
                $path = '.'.str_replace($this->request->domain(),'',$picture['url_preview']);
                if (is_file($path))
                {
                    $download = new Download($path);
                    $name = $picture['name'];
                }else{
                    $download = new Download('default.gif');
                    $name = 'default.gif';
                }
            }else{
                $download = new Download('default.gif');
                $name = 'default.gif';
            }
            return $download->name($name);
        }

        /**
         * 显示加密封面
         * @author 微尘 <yicmf@qq.com>
         * @datetime: 2019/6/9 7:30
         */
        public function download()
        {
            if (Session::has('download_token'))
            {
                $token = Session::pull('download_token');
                if ($token == $this->request->get('token'))
                {
                    $picture = PictureModel::find($this->request->param('id'));
                    if ($picture){
                        $path = '.'.str_replace($this->request->domain(),'',$picture['url']);
                        if (is_file($path))
                        {
                            $download = new Download($path);
                            $name = $picture['name'];
                        }else{
                            $download = new Download('default.gif');
                            $name = 'default.gif';
                        }
                    }else{
                        $download = new Download('default.gif');
                        $name = 'default.gif';
                    }
                    return $download->name($name);
                }else{
                    $this->error('链接已经失效');
                }
            }else{
                $this->error('链接不合法');
            }

        }

    }

