<?php

    // +----------------------------------------------------------------------
    // | 图片模型--负责图片的上传.
    // +----------------------------------------------------------------------
    // | Copyright (c) 2015-2019 http://www.yicmf.com, All rights reserved.
    // +----------------------------------------------------------------------
    // | Author: 微尘 <yicmf@qq.com>
    // +----------------------------------------------------------------------

    namespace app\file\event;

    use app\common\event\Queue;
    use Qiniu\Storage\BucketManager;
    use think\Exception;
    use think\Image;
    use think\facade\Log;
    use think\File;
    use think\facade\Config;
    use app\file\model\Picture as PictureModel;
    use app\common\event\Base;
    use think\facade\Env;
    use think\Db;
    use wechat\official_account\Media as MediaOfficial;
    use Qiniu\Auth as QuniuAuth;
    use Qiniu\Storage\UploadManager as QiniuUploadManager;

    class Picture extends Base
    {

        /**
         * 删除资源
         * @param      $param
         * @param      $user
         * @param bool $forever
         * @return mixed
         * @author  : 微尘 <yicmf@qq.com>
         * @datetime: 2019/1/29 20:10
         */
        public function delete($param,$user,$forever = false)
        {
            $picture = PictureModel::find($param['id']);
            if ($picture)
            {
                $picture['status'] = $forever?-2:-1;
                $picture->save();
                if ($forever)
                {
                    // 删除文件
                    $ext = '.'.pathinfo($picture['savename'], PATHINFO_EXTENSION) ;
                    $basename = basename($picture['savename'],$ext);
                    $this->_deleteFile($picture,$basename,$ext,'original');
                    $this->_deleteFile($picture,$basename,$ext,1280);
//                    $this->_deleteFile($picture,$basename,$ext,360);
//                    $this->_deleteFile($picture,$basename,$ext,240);
                    $this->_deleteFile($picture,$basename,$ext,60);
                }
                // 删除对应文件
                $data['code'] = 0;
                $data['message'] = '删除成功';
            }else{
                $data['code'] = 1;
                $data['message'] = '资源不存在';
            }
            return $data;
        }
        protected function _deleteFile($picture,$basename,$ext,$width)
        {
            $path = str_replace($picture['savename'],$basename.'_'.$width.$ext,$picture->getData('path'));
            if (is_file($path))
            {
                @unlink($path);
            }
            // 七牛的也删除，默认保留30天
            if ('qiniu' == $picture['driver'] && 'original' != $width)
            {
                $setting = Config::get('upload_picture.');
                // 构建鉴权对象
                $auth = new QuniuAuth($setting['qiniu_access_key'], $setting['qiniu_secrect_key']);
                $key = str_replace($picture['savename'],$basename.'_'.$width.$ext,$picture->getData('url'));
                $config = new \Qiniu\Config();
                $bucketManager = new BucketManager($auth, $config);
                // 上传到七牛后保存的文件名
                $key = ltrim($key, '/');
                $bucketManager->delete($setting['qiniu_bucket'], $key);
//                $bucketManager->deleteAfterDays($setting['qiniu_bucket'], $key, 30);

            }
        }
        public static function info($id, $field = 'url')
        {
            $picture = PictureModel::find($id);
            if ( $picture ) {
                return $picture[$field];
            } else {
                return ' ';
            }
        }

        /**
         * @param $str
         * @param $wechat_media_id
         * @param $url
         * @return array
         * @throws \Exception
         * @author  : 微尘 <yicmf@qq.com>
         * @datetime: 2019/1/15 17:22
         */
        public function uploadByMaterial($str, $wechat_media_id, $url)
        {
            $file = PictureModel::where('wechat_media_id', $wechat_media_id)->find();
            if ( $file ) {
                $result = [
                    'code' => 0,
                    'data' => $file
                ];
                return $result;
            }
            $filename = uniqid() . '.png';
            // 检查路径是否存在，如不存在则创建
            $dir = Env::get('root_path') . 'public/uploads/picture/' . time_format(time(), 'Y/m/d/');
            $dir = str_replace('/', DIRECTORY_SEPARATOR, $dir);
            if ( !is_dir($dir) ) {
                //第三个参数是“true”表示能创建多级目录，iconv防止中文目录乱码
                mkdir(iconv("UTF-8", "GBK", $dir), 0777, true);
            }
            $resource = fopen($dir . $filename, 'a');
            fwrite($resource, $str);
            fclose($resource);
            $file = new File($dir . $filename);
            $data = [];
            $data['md5'] = $file->hash('md5');
            $data['wechat_url'] = $url;
            $data['wechat_media_id'] = $wechat_media_id;
            $data['sha1'] = $file->hash('sha1');
            //        $data['driver'] = $setting['driver'];
            $data['name'] = $file->getInfo('name');
            $data['remark'] = $file->getInfo('name');
            $data['size'] = $file->getInfo('size');
            $data['mime'] = $file->getMime();
            $data['path'] = $dir . $filename;
            $data['ext'] = pathinfo($data['path'], PATHINFO_EXTENSION);
            $data['savename'] = pathinfo($data['path'], PATHINFO_BASENAME);
            $data['savepath'] = pathinfo($data['path'], PATHINFO_DIRNAME);
            $picture = PictureModel::create($data);
            if ( !$picture ) {
                throw new \Exception('保存图片信息失败');
            }
            $result = [
                'code' => 0,
                'data' => $picture
            ];
            return $result;
        }

        public function uploadUrl($url)
        {
            $path = $this->downLoad_pic($url);
            $file = new File($path);
            $data = [];
            $data['md5'] = $file->hash('md5');
            $data['wechat_url'] = $url;
            $data['sha1'] = $file->hash('sha1');
            //        $data['driver'] = $setting['driver'];
            $data['name'] = $file->getInfo('name');
            $data['remark'] = $file->getInfo('name');
            $data['size'] = $file->getInfo('size');
            $data['mime'] = $file->getMime();
            $data['path'] = $path;
            $data['ext'] = pathinfo($path, PATHINFO_EXTENSION);
            $data['savename'] = pathinfo($path, PATHINFO_BASENAME);
            $data['savepath'] = pathinfo($path, PATHINFO_DIRNAME);
            $picture = PictureModel::create($data);
            if ( !$picture ) {
                throw new \Exception('保存图片信息失败');
            }
            $result = [
                'code' => 0,
                'data' => $picture
            ];
            return $result;
        }

        protected function downLoad_pic($url)
        {
            if ( $url == "" ) {
                return false;
            }
            $filename = uniqid() . '.png';
            // 检查路径是否存在，如不存在则创建
            $dir = Env::get('root_path') . 'public/uploads/picture/' . time_format(time(), 'Y/m/d/');
            $dir = str_replace('/', DIRECTORY_SEPARATOR, $dir);
            if ( !is_dir($dir) ) {
                //第三个参数是“true”表示能创建多级目录，iconv防止中文目录乱码
                mkdir(iconv("UTF-8", "GBK", $dir), 0777, true);
            }
            ob_start();
            readfile($url);
            $img = ob_get_contents();
            ob_end_clean();
            $fp2 = fopen($dir . $filename, "a");
            if ( fwrite($fp2, $img) === false ) {
                throw new Exception('无法写入图片');
            }
            fclose($fp2);
            return $dir . $filename;
        }

        /**
         * 文件上传.
         * @param array $param   post信息
         * @param File $file   要上传的文件列表（需要使用request获取的请求）
         * @param array $setting 文件上传配置
         * @param 0|1 $is_editor  是否为编辑器
         * @return array 文件上传成功后的信息
         */
        public function upload($param, $file, $setting, $user = null, $is_editor = 0)
        {
//            try {
                if ( !is_object($file) ) {
                    // 上传失败获取错误信息
                    throw new \Exception('上传信息错误');
                }
                // 检测文件是否存在
                Db::startTrans();
                $picture = PictureModel::find(['md5' => $file->hash('md5')]);
                if ( !$picture ) {
                    /* 图片预处理 --- 上传文件 */
                    $data = [];
                    isset($param['user_id']) && $data['user_id'] = $param['user_id'];
                    $user && $data['user_id'] = $user['id'];
                    $data['md5'] = $file->hash('md5');
                    $data['sha1'] = $file->hash('sha1');
                    // 默认本地驱动
                    $data['driver'] = 'local';
                    $data['name'] = $file->getInfo('name');
                    $data['remark'] = $file->getInfo('name');
                    $data['size'] = $file->getInfo('size');
                    $data['mime'] = $file->getMime();
                    $image = Image::open($file);
                    $data['height'] = $image->height();
                    $data['width'] = $image->width();
                    $data['ext'] = pathinfo($file->getInfo('name'), PATHINFO_EXTENSION);
                    $save_name = $this->pretreatment($file, $setting, $is_editor);
                    $data['savename'] = pathinfo($save_name, PATHINFO_BASENAME);
                    $data['savepath'] = pathinfo($setting['save_path'] . $save_name, PATHINFO_DIRNAME);
                    $data['path'] = $setting['save_path'] . $save_name;
                    if ( !$save_name ) {
                        // 上传失败获取错误信息
                        throw new \Exception($file->getError());
                    }
                    $data = array_merge($data, $this->distinguish($param, $data));
                    $picture = PictureModel::create($data);
                    if ('qiniu' == $setting['driver']){
                        // 添加队列
                        Queue::add('\app\file\event\Picture@queueUploudPictureQiniuJob', ['picture_id' => $picture['id'], 'param' => $param]);
                    }
                     if ( !$picture ) {
                        throw new \Exception('保存图片信息失败');
                    }
                }
                // 提交事务
                Db::commit();
                $result['code'] = 0;
                $result['data'] = $picture;
                $result['type'] = 'success';
//            } catch ( \Exception $e ) {
//                // 回滚事务
//                Db::rollback();
//                $result['code'] = 1;
//                $result['type'] = 'error';
//                $result['message'] = $e->getMessage();
//            }
            return $result;
        }

        /**
         * 图片预处理
         * @param     $file
         * @param     $setting
         * @param int $is_editor
         * @return string
         * @throws Exception
         * @author  : 微尘 <yicmf@qq.com>
         * @datetime: 2019/1/29 16:42
         */
        protected function pretreatment($file, $setting, $is_editor = 0)
        {
            $save_name = $this->buildSaveName($file, $setting['save_name']);
            // 创建目录
            $dir = pathinfo($setting['save_path'] . $save_name, PATHINFO_DIRNAME);
            if ( !is_dir($dir) ) {
                mkdir($dir, 0755, true);
            }
            $path = pathinfo($setting['save_path'] . $save_name, PATHINFO_DIRNAME);
            $ext = '.' . pathinfo($save_name, PATHINFO_EXTENSION);
            $basename = basename($save_name, $ext);
            if ( 1 == $setting['has_original'] ) {
                // 备份原图
                $result = $file->move($path . DIRECTORY_SEPARATOR, $basename . '_original' . $ext);
                if ( !$result ) {
                    throw new Exception($file->getError());
                }
                $file = new File($path . DIRECTORY_SEPARATOR . $basename . '_original' . $ext);
            }
            $image = Image::open($file);
            // 是否开启水印
            if ( 'none' !== $setting['water_type'] && $image->width() >= $setting['water_mini_width']) {
                // 完成水印mkdir($path, 0755, true)
                if ( 'text' == $setting['water_type'] ) {
                    $result = $image->text($setting['text_content'],
                        $setting['watar_text_dir'] . DIRECTORY_SEPARATOR . $setting['font_file'],
                        $setting['text_size'], $setting['text_color'], $setting['loaction_id'], [$setting['water_dx'], $setting['water_dy']],
                        $setting['text_angle'])->save($setting['save_path'] . $save_name);
                } else {
                    // 图片水印
                    $water_image = PictureModel::find($setting['water_image']);
                    if ( $water_image && is_file($water_image['path'])) {
                         $result = $image->water($water_image['path'], $setting['loaction_id'], $setting['water_transparency'])->save($setting['save_path'] . $save_name);
                        if ( !$result ) {
                            throw new Exception('水印保存失败');
                        }
                    }else{
                        $result = false;
                    }
                }
                if (!$result)
                {
                    Log::write('水印保存失败');
                }
            }else{
                $result = false;
            }
            if (!$result)
            {
                $image->save($setting['save_path'] . $save_name);
            }
            $file = new File($setting['save_path'] . $save_name);
            $image = Image::open($file);
            // 按照原图的比例生成一个最大为150*150的缩略图并保存为thumb.png
            //60*60
            $name_60 = $path . DIRECTORY_SEPARATOR . $basename . '_60' . $ext;
            $name_240 = $path . DIRECTORY_SEPARATOR . $basename . '_240' . $ext;
            $name_360 = $path . DIRECTORY_SEPARATOR . $basename . '_360' . $ext;
            $name_720 = $path . DIRECTORY_SEPARATOR . $basename . '_720' . $ext;
            $name_1280 = $path . DIRECTORY_SEPARATOR . $basename . '_1280' . $ext;
            $image->thumb(1280, 1280)->save($name_1280);
            $image->thumb(360, 360)->save($name_360);
            $image->thumb(240, 240)->save($name_240);
            $image->thumb(720, 720)->save($name_720);
            $image->thumb(60, 60)->save($name_60);
            // 注册图片上传完成钩子
            //         Hook::listen('upload_picture_complete', new File($setting['save_path'] . $save_name));
            return $save_name;
        }

        /**
         * 上传文件到七牛的任务
         * @throws \Exception
         * @author  : 微尘 <yicmf@qq.com>
         * @datetime: 2019/1/29 16:47
         */
        public static function queueUploudPictureQiniuJob($data)
        {
            $setting = Config::get('upload_picture.');
            // 数据迁移到七牛
            if ('qiniu' == $setting['driver']) {
                // 构建鉴权对象
                // 构建鉴权对象
                $auth = new QuniuAuth($setting['qiniu_access_key'], $setting['qiniu_secrect_key']);
                // 生成上传 Token
                $token = $auth->uploadToken($setting['qiniu_bucket']);
                $picture = PictureModel::find($data['picture_id']);
                $ext = '.'.pathinfo($picture['savename'], PATHINFO_EXTENSION) ;
                $basename = basename($picture['savename'],$ext);
                // 初始化 UploadManager 对象并进行文件的上传。
                $uploadMgr = new QiniuUploadManager();
                list($result, $err)  = self::_uploadQiniu($picture,$basename,$ext,1280,$uploadMgr,$token);
                Log::record(var_export($result,true));
//                $picture['hash'] = $result['hash'];
                if ($err !== null) {
                    Log::write('七牛迁移错误：' . var_export($err, true));
                }
                self::_uploadQiniu($picture,$basename,$ext,360,$uploadMgr,$token);
//                self::_uploadQiniu($picture,$basename,$ext,240,$uploadMgr,$token);
                self::_uploadQiniu($picture,$basename,$ext,60,$uploadMgr,$token);
                $picture['driver'] = 'qiniu';
                $picture->save();
                return 'success';
            }else{
                return 'fail';
            }
        }

        /**
         * 执行上传到七牛
         * @param $picture
         * @param $basename
         * @param $ext
         * @param $width
         * @param $uploadMgr
         * @param $token
         * @return bool
         * @author  : 微尘 <yicmf@qq.com>
         * @datetime: 2019/1/29 18:25
         */
        protected static function _uploadQiniu($picture,$basename,$ext,$width,$uploadMgr,$token)
        {
            $key = str_replace($picture['savename'],$basename.'_'.$width.$ext,$picture->getData('url'));
            // 要上传文件的本地路径
            $path = str_replace($picture['savename'],$basename.'_'.$width.$ext,$picture->getData('path'));
            if (is_file($path))
            {
                // 上传到七牛后保存的文件名
                $key = ltrim($key, '/');
                // 调用 UploadManager 的 putFile 方法进行文件的上传。
                return $uploadMgr->putFile($token, $key, $path);
            }else{
                return false;
            }

        }
        /**
         * 解析信息
         * @throws \Exception
         */
        protected function distinguish($param, $data)
        {
            if ( isset($param['type']) && 'idcard' == $param['type'] ) {
                // 调用身份证识别
                // 调用通用文字识别, 图片参数为本地图片
                $data['type'] = 'idcard';
                $image = file_get_contents($data['path']);
                // 百度识别信息
                $client = new AipOcr(Config::get('aibaidu.app_id'), Config::get('aibaidu.app_key'), Config::get('aibaidu.secret_key'));
                $idCardSide = isset($param['side']) ? $param['side'] : 'front';
                // 如果有可选参数
                $options = [];
                $options['detect_direction'] = 'true';
                $options['detect_risk'] = 'true';
                $result = $client->idcard($image, $idCardSide, $options);
                if ( 'normal' != $result['image_status'] ) {
                    $tips = [
                        'reversed_side' => '身份证正反面颠倒',
                        'non_idcard' => '上传的图片中不包含身份证',
                        'blurred' => '身份证模糊',
                        'other_type_card' => '其他类型证照',
                        'over_exposure' => '身份证关键字段反光或过曝',
                        'unknown' => '未知状态',
                    ];
                    throw new \Exception($tips[$result['image_status']]);
                } else {
                    if ( 'front' == $idCardSide ) {
                        $data['info'] = [
                            'address' => $result['words_result']['住址']['words'],
                            'birthday' => $result['words_result']['出生']['words'],
                            'name' => $result['words_result']['姓名']['words'],
                            'idcard_no' => $result['words_result']['公民身份号码']['words'],
                            'sex' => $result['words_result']['性别']['words'],
                            'nation' => $result['words_result']['民族']['words'],
                        ];
                    } else {
                        $data['info'] = [
                            'start_time' => $result['words_result']['签发日期']['words'],
                            'end_time' => $result['words_result']['失效日期']['words'],
                            'address' => $result['words_result']['签发机关']['words'],
                        ];
                    }
                }
            } elseif ( isset($param['type']) && 'hand' == $param['type'] ) {
                if ( empty($param['idcard_frant_id']) ) {
                    throw new \Exception('没有发现对比图片');
                }
                $idCardFrand = PictureModel::get($param['idcard_frant_id']);
                if ( !is_file($idCardFrand['path']) ) {
                    throw new \Exception('没有发现对比图片');;
                }
                $client = new AipFace(Config::get('aibaidu.app_id'), Config::get('aibaidu.app_key'), Config::get('aibaidu.secret_key'));
                $result = $client->match([
                    [
                        'image' => base64_encode(file_get_contents($idCardFrand['path'])),
                        'face_type' => 'CERT',
                        'image_type' => 'BASE64'
                    ],
                    [
                        'image' => base64_encode(file_get_contents($data['path'])),
                        'image_type' => 'BASE64',
                        'liveness_control' => 'HIGH'
                    ]
                ]);
                if ( isset($result['error_code']) && 0 != $result['error_code'] ) {
                    $tips = [
                        'liveness check fail' => '活体检测未通过',
                        'pic not has face' => '图片中没有人脸',
                        'image check fail' => '无法解析人脸',
                    ];
                    throw new \Exception(isset($tips[$result['error_msg']]) ? $tips[$result['error_msg']] : $result['error_msg']);
                } else {
                    //face_list [] score
                    // 两个人脸及得分
                    if ( 80 < $result['result']['score'] ) {
                        throw new \Exception('失败分值' . $result['result']['score'] . '，分值过低，请重新拍照审核');
                    }
                    $data['info'] = $result['result'];
                }
            } elseif ( isset($param['type']) && 'license' == $param['type'] ) {
                // 营业执照
                $client = new AipOcr(Config::get('aibaidu.app_id'), Config::get('aibaidu.app_key'), Config::get('aibaidu.secret_key'));
                $image = file_get_contents($data['path']);
                // 调用营业执照识别
                $result = $client->businessLicense($image);
                if ( isset($result['error_code']) && 0 != $result['error_code'] ) {
                    throw new \Exception($result['error_msg']);
                } else {
                    $result = $result['words_result'];
                    $info = [];
                    if ( isset($result['社会信用代码']) ) {
                        $info['store_social_credit_code'] = $result['社会信用代码']['words'];
                    }
                    if ( isset($result['单位名称']) ) {
                        $info['store_name'] = $result['单位名称']['words'];
                    }
                    if ( isset($result['法人']) ) {
                        $info['store_legal_person'] = $result['法人']['words'];
                    }
                    if ( isset($result['证件编号']) ) {
                        $info['store_no'] = $result['证件编号']['words'];
                    }
                    if ( isset($result['成立日期']) ) {
                        $info['store_start_time'] = $result['成立日期']['words'];
                    }
                    if ( isset($result['地址']) ) {
                        $info['store_address'] = $result['地址']['words'];
                    }
                    if ( isset($result['有效期']) ) {
                        $info['store_effective_date'] = $result['有效期']['words'];
                    }
                    $data['info'] = $info;
                }
            }
            if ( isset($param['module']) && 'wechat' == $param['module'] ) {
                // 微信模块上传，则同步到公众号
                $media = new MediaOfficial();
                $result = $media->uploadimg($data['path'], $data['savename']);
                if ( isset($result['url']) ) {
                    $data['wechat_url'] = $result['url'];
                }
            }
            return $data;
        }

        /**
         * 生成保存名称
         * @param File   $file
         * @param string $flag
         * @return  string
         */
        protected function buildSaveName($file, $flag = 'date')
        {
            return str_replace('/', DIRECTORY_SEPARATOR, date('Ym/d') . DIRECTORY_SEPARATOR . uniqid()) . '.' . pathinfo($file->getInfo('name'), PATHINFO_EXTENSION);
        }

    }
