<?php

    // +----------------------------------------------------------------------
    // | 商城模块公共控制器
    // +----------------------------------------------------------------------
    // | Copyright (c) 2015-2019 http://www.yicmf.com, All rights reserved.
    // +----------------------------------------------------------------------
    // | Author: 微尘 <yicmf@qq.com>
    // +----------------------------------------------------------------------

    namespace app\index\controller;

    use app\common\controller\Base;
    use think\facade\Config;
    use think\facade\Hook;
    use app\ucenter\event\User as UserEvent;
    use app\ucenter\model\User as UserModel;
    use think\facade\Url;
    use wechat\official_account\Jssdk;
    use wechat\official_account\Oauth as OauthOfficial;
    use app\cms\model\Category as CategoryModel;

    class Common extends Base
    {
        /**
         * 当前登录用户
         * @var UserModel
         */
        protected $user;
        protected $middleware = [
        ];

        // 初始化
        public function initialize()
        {
            parent::initialize();

        }

        /* 分类检测 */
        protected function category()
        {
            if (!$this->request->has('category_id'))
            {
                $this->error('分类不存在');
            }
            $category  = CategoryModel::find($this->request->param('category_id'));
            // 是否有信息
            // 是否显示
            // 权限
            return $category;
        }
        /**
         * 设置页面分享信息
         * @param string $title
         * @param string $description
         * @param string $url
         * @param string $imgUrl
         */
        protected function setWechatShare($title, $description, $url, $imgUrl)
        {
            if ( !$imgUrl ) {
                $imgUrl = get_cover(Config::get('wechat.share_logo_id'), 'url');
            }
            $wechat_share = [];
            $wechat_share['wechat_title'] = $this->display($title);
            $wechat_share['link'] = $url;
            $wechat_share['img_url'] = $imgUrl;
            $wechat_share['wechat_description'] = $this->display($description);;
            $this->assign('wechat_share', $wechat_share);
        }
    }
