<?php
    // +----------------------------------------------------------------------
    // | ThinkPHP [ WE CAN DO IT JUST THINK ]
    // +----------------------------------------------------------------------
    // | Copyright (c) 2006~2018 http://thinkphp.cn All rights reserved.
    // +----------------------------------------------------------------------
    // | Licensed ( http://www.apache.org/licenses/LICENSE-2.0 )
    // +----------------------------------------------------------------------
    // | Author: liu21st <liu21st@gmail.com>
    // +----------------------------------------------------------------------

    // +----------------------------------------------------------------------
    // | 模板设置
    // +----------------------------------------------------------------------

    return [
        // 模板引擎类型 支持 php think 支持扩展
        'type'         => 'Think',
        // 默认模板渲染规则 1 解析为小写+下划线 2 全部转换小写 3 保持操作方法
        'auto_rule'    => 1,
        // 需要额外加载的标签库(须指定标签库名称)，多个以逗号分隔
        'taglib_pre_load' => 'app\common\taglib\Yicmf',
        'tpl_replace_string' => [
            '__COMMON__' => '/static/common',
            '__BJUI__' => '/static/b-jui',
            '__STATIC__' => '/static',
            '__LOGIN__' => '/static/b-jui/login',
            '__ADDONS__' => '/static/admin/addon',
            '__IMG__' => '/static/b-jui/images',
            '__OTHER__' => '/static/b-jui/other',
            '__UCENTER__' => '/static/ucenter',
            '__BASE__' => '/static/b-jui',
            '__ASSETS__' => '/static/b-jui/assets',
            '__CSS__' => '/static/b-jui/css',
            '__JS__' => '/static/b-jui/js',
            '__DOC__' => '/static/b-jui/doc',
            '__UPLOADS__' => '/uploads',
            '__PUBLIC__' => '/'
        ],
        // 模板路径
        'view_path'    => '',
        // 模板后缀
        'view_suffix'  => 'html',
        // 模板文件名分隔符
        'view_depr'    => DIRECTORY_SEPARATOR,
        // 模板引擎普通标签开始标记
        'tpl_begin'    => '{',
        // 模板引擎普通标签结束标记
        'tpl_end'      => '}',
        // 标签库标签开始标记
        'taglib_begin' => '{',
        // 标签库标签结束标记
        'taglib_end'   => '}',
        // 默认过滤方法 用于普通标签输出
        'default_filter'     => '',
    ];
