<?php

    // +----------------------------------------------------------------------
    // | 用户中心公开控制器
    // +----------------------------------------------------------------------
    // | Copyright (c) 2015-2019 http://www.yicmf.com, All rights reserved.
    // +----------------------------------------------------------------------
    // | Author: 微尘 <yicmf@qq.com>
    // +----------------------------------------------------------------------

    namespace app\ucenter\controller;

    use app\ucenter\event\User as UserEvent;
    use app\ucenter\event\Sms as SmsEvent;
    use think\facade\Cookie;
    use think\facade\Url;
    use think\facade\Config;
    use think\facade\Session;
    use think\facade\Lang;
    use yicmf\Http;

    class Foreign extends Common
    {
        /**
         * 退出登陆.
         */
        public function logout()
        {
            if ( UserEvent::isLogin() && UserEvent::logout() ) {
                // 主动退出的情况下不再自动登陆
                Cookie::delete('auto_login');
                Cookie::set('login_redirect', $this->request->server('HTTP_REFERER'));
                if ( $this->request->param('module') == 'mobile' ) {
                    $this->redirect(Url::build('mobile/Foreign/login'));
                } else {
                    $this->redirect(Url::build('ucenter/Foreign/login', ['module' => $this->request->param('module')]));
                }
            } else {
                $this->error(Lang::get('user_no_login'));
            }
        }
        public function check()
        {
            $data['code'] = 0;
            $data['message'] = 'ok';
            return json($data);
        }
        /**
         * 用户登陆.
         * @return mixed|string
         */
        public function login()
        {
            if ( $this->request->isPost() ) {
                // 图像验证码
                $result = $this->validate($this->request->post(), 'app\ucenter\validate\User.login');
                if ( true !== $result ) {
                    $data['code'] = 20002;
                    $data['message'] = $result;
                } else {
                    $result = tencent_captcha_check($this->request->post());
                    if ( 1 == $result['response'] ) {
                        $user_event = new UserEvent();
                        $data = $user_event->login($this->request->param());
                        if ( 0 == $data['code'] ) {
                            // 非自动模式
                            if ( 1 != $this->request->post('auto') && 1 == $this->request->post('auto_login') ) {
                                Cookie::set('auto_login', 1, 7 * 86400);
                                Cookie::set('auto_login_account', $this->request->post('account'), 7 * 86400);
                                Cookie::set('auto_login_password', $this->request->post('password'), 7 * 86400);
                            }
                            Cookie::delete('login_redirect');
                            Cookie::delete('login_module');
                        } else {
                            // 强制输入验证码
                            Session::set('input_verify', 1);
                        }
                    } else {
                        $data['code'] = 1;
                        $data['message'] = $result['err_msg'];
                    }
                }
                return json($data);
            } else {
                if ( !UserEvent::isLogin() ) {
                    $module = $this->request->param('module','');
                    if (!$module || $module == 'admin')
                    {
                        $module = Config::get('login_theme');
                    }
                    return $this->fetch('login/' . $module);
                } else {
                    $this->error('用户已经登陆');
                }
            }
        }

        public function forget()
        {
            // 忘记重置密码
            if ( $this->request->isPost() ) {
                $user = new UserEvent();
                $data = $user->forget($this->request->post());
                return json($data);
            } else {
                return $this->fetch();
            }
        }
        /**
         * 用户注册
         */
        public function register()
        {
            if ( $this->request->isPost() ) {
                // 安全验证
                // 数据验证
                $result = $this->validate($this->request->post(), 'User.register');
                if ( true !== $result ) {
                    // 验证失败 输出错误信息
                    $data['code'] = 20003;
                    $data['message'] = $result;
                } else {
                    $user = new UserEvent();
                    $data = $user->register($this->request->post());
                    if (0 == $data['code'])
                    {
                        $this->assign('data',$data);
                        $data['html'] = $this->fetch('popupbox');
                    }
                }
                return json($data);
            } else {
                if ( !UserEvent::isLogin() ) {
                    $this->assign('url', Url::build('ucenter/Foreign/login', ['module' => 'ask']));
                    return $this->fetch();
                } else {
                    $this->error('用户已经登陆');
                }
            }
        }

        /**
         * 获取手机验证码
         */
        public function sms()
        {
            $validate = $this->validate($this->request->post(), 'Sms');
            if ( true === $validate ) {

//                $result = tencent_captcha_check($this->request->post());
//                if ( 1 == $result['response'] ) {
                    $data = SmsEvent::send($this->request->param(), $this->user);
//                } else {
//                    $data['code'] = 1;
//                    $data['message'] = $result['err_msg'];
//                }
            } else {
                $data['code'] = 1;
                $data['message'] = $validate;
            }
            return json($data);
        }

        public function carousel()
        {
            $pic1['src'] = __ROOT__ . 'static/ucenter/carousel/images/img1.jpg';
            $pic1['link'] = '';
            $pic1['background'] = '#d0e3ea';
            $pic2['src'] = __ROOT__ . 'static/ucenter/carousel/images/img2.jpg';
            $pic2['link'] = '';
            $pic2['background'] = '#dbf6ff';
            $pic3['src'] = __ROOT__ . 'static/ucenter/carousel/images/img3.jpg';
            $pic3['link'] = '';
            $pic3['background'] = '#ebfbff';
            $data['rtn'] = 0;
            $data['data'] = ['message' => '', 'intersec' => '7'];
            $data['data']['pics'][] = $pic1;
            $data['data']['pics'][] = $pic2;
            $data['data']['pics'][] = $pic3;
            return json($data);
        }
    }
