<?php

    // +----------------------------------------------------------------------
    // | 用户管理
    // +----------------------------------------------------------------------
    // | Copyright (c) 2015-2019 http://www.yicmf.com, All rights reserved.
    // +----------------------------------------------------------------------
    // | Author: 微尘 <yicmf@qq.com>
    // +----------------------------------------------------------------------

    namespace app\ucenter\controller\admin;

    use app\ucenter\model\User as UserModel;
    use app\ucenter\event\User as UserEvent;
    use app\ucenter\model\Vip as VipModel;
    use app\common\builder\Edit;
    use app\common\builder\Lists;
    use think\Db;
    use think\facade\Url;
    use app\admin\controller\Common;
    use app\common\model\Module;
    use think\facade\Config;

    class User extends Common
    {
        public function initialize()
        {
            parent::initialize();
            $this->model = new UserModel();
        }

        public function _filter(&$map)
        {
        }

        public function index()
        {
            // 读取规则列表
            $map = $this->_search($this->dbname);
            if ( method_exists($this, '_filter') ) {
                $this->_filter($map);
            }
            $data = $this->model->_list($map, $this->model->getPk());
            // 显示页面
            $builder = new Lists();
            $builder->setSearchPostUrl('', '')
//                ->suggest('管理用户信息')
                ->searchText('nickname', '用户昵称', '需要精确查询')
//                ->buttonNew(Url::build('ucenter/admin.User/update'),'新增')
                ->keyId('id', 'ID', 'desc')
//                ->keyText('account', '用户登陆账号')
                ->keyText('{$data->getData(\'nickname\')}', '用户昵称')
                ->keyText('mobile', '手机号')
                ->keyUser('invite_id','上级邀请人')
                ->keyText('vip.short_name','VIP')
                ->keyText('coin','金币')
                ->keyLink('{$data->invites|count}','直推人数','index?invite_id={$id}')
//                ->keyBool('is_vip','金牌卖家')
                ->keyText('login_count', '登陆次数')
                ->keyTime('last_login_time', '最近登陆')
                ->keyTime('create_time', '注册时间')
                ->keyStatus()
//                ->groupOutxls()
//                ->groupOutxlsCheck()
//                ->groupBr()
//                ->groupDel()
                ->data($data)
                ->keyDoActionEdit('ucenter/admin.User/update?id={$id}')
                //             ->keyDoActionEdit('ucenter/admin.AuthGroup/group?id={$id}', '授权')
                ->keyDoActionRestore('ucenter/admin.User/restore?id={$id}')
                ->keyDoActionForbid('ucenter/admin.User/forbid?id={$id}');

            return $builder->fetch();
        }

        public function update()
        {
            if ( $this->request->isPost() ) {
                $param = $this->request->param();
                if ( !$param['id']) {
                    $param['password_confirm'] = $param['password'];
                    $result = $this->validate($param, 'User.register');
                } else {
                    $result = $this->validate($param, 'User.update');
                }
                if ( $result !== true ) {
                    $this->ajax(300, '用户数据验证失败：' . $result);
                }
                $event = new UserEvent();
                $result = $event->updateByAdmin($param,$this->user);
                if (0 == $result['code']) {
                    $this->ajax(200, $result['message'], true);
                } else {
                    $this->ajax(300, $result['message']);
                }
            } else {
                $id = $this->request->get($this->model->getPk(), 0);
                if ( $id ) {
                    $data = $this->model->get($id);
                    if ( !$data ) {
                        $this->ajax(300, '用户信息不存在');
                    }
                    // 查询权限组
                    $role = $data->roles()->find();
                    if ( $role ) {
                        $data['auth_group_ids'] = $role['id'];
                    } else {
                        $data['auth_group_ids'] = 101;
                    }
                } else {
                    $data  = [];
                    $data['is_vip'] = 0;
                    $data['password'] = '000000';
                }
                $vips = VipModel::where('status',1)->column('short_name','id');
                $vips = [0 =>'无'] + $vips;
                $builder = new Edit();
                $builder->title($id?'编辑用户':'新增用户');
                $builder->keyHidden('id')->keyReadOnly('account', '登录名', '具有唯一性，用户仅可以修改一次')
                   ->keyText('new_password', '新密码', '密码至少要求6个字符')
                ->keyText('nickname', '昵称', '不可重复')
//                    ->keyImage('avatar','头像')
                    ->keyText('mobile', '手机')
                    ->keyText('qq', 'QQ')
                    ->keyRadio('is_vip','VIP',$vips)
                    ->keyTime('vip_time','vip到期时间')
                    ->keyEmail('email','邮箱')
                    ->keyTextArea('introduction','个性签名')
                    ->explain('手动修改VIP用户无记录显示')
                    ->data($data)
                    ->buttonSubmit('ucenter/admin.User/update', '保存')
                    ->buttonBack();

                return $builder->fetch();
            }
        }
        public function tree()
        {
            if ($this->request->param('data'))
            {
                $result = $this->model->where('status', 1)
                    ->field('DATE_FORMAT(create_time,"%Y%m") days,count(id) num')->whereTime('create_time', date('Y-m-01') . ' -6 month')->group('days')->select();

                //            $chart = new Chart();
                $data = [];
                $data['tooltip'] = ['trigger' => 'axis'];
                $data['legend'] = ['data' => ['注册量']];
                $data['toolbox'] = ['show' => true, 'feature'=>[
                    'restore'=>[
                        'show'=>true
                    ],
                    'mark'=>[
                        'show'=>false
                    ],
                    'saveAsImage'=>[
                        'show'=>true
                    ],
                ]];
                $x = [];
                $series = [];
                for ( $i = 6; $i >= 0; $i-- ) {
                    $day = date('Ym', strtotime(date('Y-m-01') . ' -' . $i . '  month'));
                    $num = 0;
                    $x[] = $day;
                    foreach ( $result as $item ) {
                        if ( $item['days'] == $day ) {
                            $num = $item['num'];
                            break;
                        }
                    }
                    $series[] = $num;
                }

                $data['xAxis'] = ['type' => 'category', 'data' => $x];
                $data['yAxis'] = ['type' => 'value'];
                $data['series'] = [
                    ['name' => '注册量', 'type' => 'line', 'data' => $series]
                ];
                return json($data);
            }else{
                return $this->fetch();
            }
        }
        public function find()
        {
            if ( $this->request->isPost() ) {
                $user = $this->model->where('id|account', $this->request->post('account'))->find();
                if ( $user ) {
                    $data['code'] = 0;
                    $data['data'] = $user;
                } else {
                    $data['code'] = 1;
                    $data['message'] = '暂无';
                }
                return json($data);
            } else {
                $this->assign('users', $this->model->all());
                $this->assign('value', $this->request->get('value', ''));
                $this->assign('callback', $this->request->get('callback'));
                return $this->fetch();
            }
        }

        /**
         * 修改密码
         * @return mixed
         * @throws \Exception
         * @author  : 微尘 <yicmf@qq.com>
         * @datetime: 2019/3/16 8:17
         */
        public function password()
        {
            if ( $this->request->isPost() ) {
                if ( false === UserEvent::checkPassword($this->request->post('old_password'), $this->user) ) {
                    $this->ajax(300, '旧密码验证失败');
                } else {
                    $result = $this->validate($this->request->post(), 'User.changepassword');
                    if ( false === $result ) {
                        $this->ajax(300, $result);
                    } else {
                        $this->user['password'] = $this->request->post('password');
                        if ( $this->user->save() ) {
                            $this->ajax(200, '密码修改成功！',true);
                        } else {
                            $this->ajax(300, '修改失败，错误信息：' . $result);
                        }
                    }
                }
            } else {
                $builder = new Edit();
                $builder->title('修改密码')->form(false,false);
                $builder->keyText('old_password', '旧密码')
                    ->keyPassword('password_confirm', '新密码')
                    ->keyPassword('password', '确认新密码')
                    ->buttonSubmit('ucenter/admin.User/password', '保存')
                    ->buttonBack();
                return $builder->fetch();
            }
        }

        /**
         * 修改资料
         * @return string
         * @throws \Exception
         * @author  : 微尘 <yicmf@qq.com>
         * @datetime: 2019/3/25 12:41
         */
        public function profile()
        {
            if ( $this->request->isPost() ) {

                    $result = $this->validate($this->request->post(), 'User.profile');
                    if ( true === $result ) {
                        $this->user['mobile'] = $this->request->post('mobile');
                        $this->user['email'] = $this->request->post('email');
                        $this->user['introduction'] = $this->request->post('introduction');
                        if ( $this->user->save()) {
                            $this->ajax(200, '资料修改成功！', true);
                        } else {
                            $this->ajax(300, '资料失败，错误信息：' . $result);
                        }
                    } else {
                        $this->ajax(300, '修改失败，错误信息：' . $result);
                    }
            } else {
                $builder = new Edit();
                $builder->title('编辑资料')->form(false,false);
                $builder->keyText('mobile', '手机')
                    ->keyEmail('email','邮箱')
                    ->keyTextArea('introduction', '个性签名')
                    ->data($this->user)
                    ->buttonSubmit('ucenter/admin.User/profile', '保存')
                    ->buttonBack();

                return $builder->fetch();
            }
        }

        /**
         * 用户配置
         */
        public function config()
        {

            $builder = new Edit();
            $builder->title('用户配置')
                ->keyCheckBox('register', '注册渠道', ['mobile' => '手机', 'email' => '邮箱'], '均不选择则关闭注册')
                ->keyRadio('mobile_type', '手机验证类型', ['不验证', '注册前发送验证短信'])
                ->keyRadio('email_type', '邮箱验证类型', ['不验证', '注册后发送激活邮件', '注册前发送验证邮件 '])
                ->keySpinner('register_times', '当天最大注册次数', '同一个ip下限制')
                ->keyCheckBox('register_module', '注册开通模块', Module::getAll())
                ->keySpinner('login_times', '最大登陆失败次数', '超过后禁止登陆，0为不限制')
                ->keySpinner('deny_time', '登陆失败后禁止登陆时间', '与次数匹配，单位小时')
                ->keyTextArea('deny_ip', '禁止登陆ip', '开启后当前ip无法登陆')
                ->keyTextArea('allow_ip', '登陆白名单', '开启后仅当前ip可以登陆')
                ->keyBool('invite_must', '仅通过邀请注册', '开启后，非邀请不可注册')
                ->keyRadio('invite_url', '邀请地址类型', ['单一地址', '生成库'], '使用生成库需要手动在后台生成')
                ->keyText('host', '邮箱host')
                ->keyText('port', '邮箱port')
                ->keyText('username', '邮箱登陆账号')
                ->keyText('password', '邮箱登陆密码')
                ->keyText('set_from_address', '配置来源地址')
                ->keyText('set_from_name', '配置来源名字')
                ->keyText('set_reply_address', '配置回复地址')
                ->keyText('set_reply_name', '配置回复名字')
                ->group('注册配置', 'register,mobile_type,email_type,register_times,login_times,register_module')
                ->group('登陆配置', 'login_times,deny_time,deny_ip,allow_ip')
                ->group('基础配置', 'test')
                ->group('邀请配置', 'invite_must,invite_url')
                ->group('邮箱配置', 'host,port,username,password,set_from_address,set_from_name,set_reply_address,set_reply_name')
                ->explain('所有模块登陆需要配置相关模块权限')
                ->explain('如果没有注册渠道，邀请链接无效')
                ->explain('配置验证类型时，需要配置相关信息')
                ->data(Config::get('ucenter'))
                ->buttonSubmit('ucenter/admin.User/config', '保存')
                ->buttonBack();

            return $builder->fetch();
        }

        public function statistics()
        {
            $result = $this->model->where('status', 1)
                ->field('DATE_FORMAT(create_time,"%Y%m") days,count(id) num')->whereTime('create_time', date('Y-m-01') . ' -6 month')->group('days')->select();

            //            $chart = new Chart();
            $data = [];
            $data['tooltip'] = ['trigger' => 'axis'];
            $data['legend'] = ['data' => ['注册量']];
            $data['toolbox'] = ['show' => true, 'feature'=>[
                'restore'=>[
                    'show'=>true
                ],
                'mark'=>[
                    'show'=>false
                ],
                'saveAsImage'=>[
                    'show'=>true
                ],
            ]];
            $x = [];
            $series = [];
            for ( $i = 6; $i >= 0; $i-- ) {
                $day = date('Ym', strtotime(date('Y-m-01') . ' -' . $i . '  month'));
                $num = 0;
                $x[] = $day;
                foreach ( $result as $item ) {
                    if ( $item['days'] == $day ) {
                        $num = $item['num'];
                        break;
                    }
                }
                $series[] = $num;
            }

            $data['xAxis'] = ['type' => 'category', 'data' => $x];
            $data['yAxis'] = ['type' => 'value'];
            $data['series'] = [
                ['name' => '注册量', 'type' => 'line', 'data' => $series]
            ];
            return json($data);
        }

        public function outxls()
        {
            $map = $this->_search();
            if ( method_exists($this, '_filter') ) {
                $this->_filter($map);
            }
            $list = $this->model->where($map)
                ->order($this->request->get('orderField') . ' ' . $this->request->get('orderDirection'))
                ->limit(2000)
                ->field('id,nickname,true_name,mobile,is_vip,good_at,income_balance,create_time')
                ->select();
            $headArr = [
                'ID',
                '昵称',
                '真实姓名',
                '手机号',
                '认证讲师',
                '擅长',
                '累积收益',
                '注册时间'
            ];
            $filename = '用户导出';
            $this->excelOut($filename, $headArr, $list);
        }

        public function outxls_check()
        {
            $list = $this->model->where('id','in',$this->request->param('expids'))
                ->field('id,nickname,true_name,mobile,is_vip,good_at,income_balance,create_time')
                ->select();
            $headArr = [
                'ID',
                '昵称',
                '真实姓名',
                '手机号',
                '认证讲师',
                '擅长',
                '累积收益',
                '注册时间'
            ];
            $filename = '用户导出';
            $this->excelOut($filename, $headArr, $list);
        }
    }
