<?php

// +----------------------------------------------------------------------
// | User的event操作
// +----------------------------------------------------------------------
// | Copyright (c) 2015-2019 http://www.yicmf.com, All rights reserved.
// +----------------------------------------------------------------------
// | Author: 微尘 <yicmf@qq.com>
// +----------------------------------------------------------------------

namespace app\ucenter\event;

use app\ucenter\model\User as UserModel;
use app\ucenter\event\Sms as SmsEvent;
use app\ucenter\event\Message as MessageEvent;
use app\ucenter\model\UserGroup as UserGroupModel;
use app\ucenter\event\UserBalance as UserBalanceEvent;
use app\ucenter\model\UserBalanceRecharge as UserBalanceRechargeModel;
use think\Exception;
use think\facade\Cache;
use think\facade\Config;
use think\facade\Session;
use app\common\event\Base;
use app\ucenter\model\UserFriend;
use think\facade\Hook;
use think\facade\Cookie;
use think\facade\Url;

class User extends Base
{
    protected $user;

    /**
     * 管理员修改用户信息
     * @param           $param
     * @param UserModel $admin
     * @return bool
     * @author  : 微尘 <yicmf@qq.com>
     * @datetime: 2019/2/16 18:11
     */
    public function updateByAdmin($param, $admin)
    {
        try {
            // 验证权限
            if (!$admin) {
                throw new Exception('您没有权限');
            }
            if (empty($param['id'])) {
                // 新增
                $result = $this->register($param, 'admin');
                if (0 != $result['code']) {
                    throw new Exception($result['message']);
                }
                $user = $result['data'];
                $user['true_name'] = $param['true_name'];
                $user['introduction'] = $param['introduction'];
                $user->save();
                $data['message'] = '注册成功';
            } else {
                // 修改
                $user = UserModel::find($param['id']);
                if (!$user) {
                    throw new Exception('未发现需要操作用户');
                }
                if (!empty($param['new_password'])) {
                    $user['new_password'] = $param['new_password'];
                }
                $user->nickname = $param['nickname'];
                $user->mobile = $param['mobile'];
                $user->email = $param['email'];
                $user['is_vip'] = $param['is_vip'];
                $user['qq'] = $param['qq'];
                $user['vip_time'] = $param['vip_time'];
                $user->introduction = $param['introduction'];
                if (!$user->save()) {
                    throw new Exception('用户信息未更新');
                }
                $data['message'] = '用户信息修改成功';
            }
            $data['data'] = $user;
            $data['code'] = 0;
        } catch (\Exception $e) {
            $data['code'] = 1;
            $data['message'] = $e->getMessage();
        }
        return $data;

    }

    /**
     * 获取当前登陆用户，没有登陆返回0.
     */
    public static function isLogin()
    {
        return Session::has('user_auth')?Session::get('user_auth.id'):false;
    }

    /**
     * 检测是否是管理员
     * @param int $user_id
     * @return bool
     * @author  : 微尘 <yicmf@qq.com>
     * @datetime: 2019/2/16 18:08
     */
    public static function isAdministrator($user_id = null)
    {
        is_null($user_id)&& $user_id = self::isLogin();
        return in_array(intval($user_id), Config::get('ucenter.user_administrator'));
    }

    /**
     * 获取当前登陆用户
     * @param string $module
     * @return bool|UserModel
     * @author 微尘 <yicmf@qq.com>
     * @datetime: 2019/5/29 7:47
     */
    public static function getLogin($module = null)
    {
        if (self::isLogin($module)) {
            return UserModel::find(self::isLogin());
        } else {
            return false;
        }
    }


    /**
     * 更新手机号
     * @param UserModel $user
     * @param           $param
     * @return mixed
     * @author  : 微尘 <yicmf@qq.com>
     * @datetime: 2019/2/16 18:07
     */
    public function updatePassword($param, $user)
    {
        try {
            /* 验证用户密码 */
            if (true !== password_verify($param['old_password'], $user->password)) {
                throw new Exception('旧密码验证错误');
            }
            $user['password'] = $param['password'];
            if (!$user->save()) {
                throw new Exception('密码修改异常');
            }
            $data['code'] = 0;
            $data['message'] = '密码修改成功';
            $data['type'] = 'success';
            $data['redirect'] = Url::build('index/User/info');
        } catch (\Exception $e) {
            $data['code'] = 1;
            $data['message'] = $e->getMessage();
            $data['type'] = 'error';
            $data['redirect'] = '';
        }
        return $data;
    }

    /**
     * 验证密码正确性
     * @param string $password
     *            验证的密码
     * @param UserModel $user
     *            需要验证的用户，默认登录用户
     * @return bool
     * @return bool
     * @author 微尘 <yicmf@qq.com>
     */
    public static function checkPassword($password, $user)
    {
        /* 验证用户密码 */
        return password_verify($password, $user->password);
    }

    /**
     * 用户登录认证
     * @param $param
     * @return mixed
     * @author  : 微尘 <yicmf@qq.com>
     * @datetime: 2019/2/20 12:02
     */
    public function login($param)
    {
        try {
            /* 获取用户数据 */
            if (isset($param['mobile'])) {
                $user = UserModel::where('account|mobile', $param['mobile'])->find();
            } else {
                $user = UserModel::where('account|mobile', $param['account'])->find();
            }
            if (!$user) {
                throw new \Exception('未查询到用户');
            }
            /* 验证用户密码 */
            if (!self::checkPassword($param['password'], $user)) {
                // 记录密码异常
                Action::log('user_input_password_error', 'user', $user, $user);
                throw new \Exception('密码验证错误');
            }
            if (1 !== $user->status) {
                throw new \Exception('用户被禁用！');
            }
            $this->_checkAccess($user, $param);
            $param['channel'] = '账号密码';
            $this->_login($user, $param);
            /* 返回用户对象 */
            $data['code'] = 0;
//            $data['data'] = $user;
            $data['redirect'] = Url::build('index/User/index');
            $data['message'] = '登录成功';
        } catch (\Exception $e) {
            $data['code'] = 1;
            $data['message'] = $e->getMessage();
        }
        return $data;
    }

    /**
     * 权限检查
     * @param UserModel $user
     * @param           $param
     */
    protected function _checkAccess($user, $param)
    {
        /*检测是否有当前应用权限*/
        if (!$this->isAdministrator($user['id'])) {
        }
    }

    /**
     * 登录信息保存
     * @param UserModel $user 要登录的用户
     * @param           $param
     * @throws \Exception
     * @author  : 微尘 <yicmf@qq.com>
     * @datetime: 2019/3/8 15:35
     */
    protected function _login($user, $param)
    {
        //记录行为
        Action::log('user_login', 'user', $user, $user, $param);
        // 保存用户信息
        $auth = [
            'id' => $user['id'],
            'nickname' => $user['nickname'],
            'account' => $user['account'],
            'last_login_time' => $user['last_login_time'],
            'last_login_ip' => $user['last_login_ip'],
        ];
        Session::set('user_auth', $auth);
        Session::set('user_auth_sign', data_auth_sign($auth));
        /* 更新登录信息 */
        $user->login_count = $user->login_count + 1;
        $user->last_login_time = time_format();
        $user->last_login_ip = $this->request->ip();
        $user->save();
    }

    /**
     * 注销当前用户
     * @return bool
     * @author  : 微尘 <yicmf@qq.com>
     * @datetime: 2019/1/29 12:24
     */
    public static function logout()
    {
        Session::clear();
        return true;
    }

}
