<?php

// +----------------------------------------------------------------------
// | 行为模型
// +----------------------------------------------------------------------
// | Copyright (c) 2015-2019 http://www.yicmf.com, All rights reserved.
// +----------------------------------------------------------------------
// | Author: 微尘 <yicmf@qq.com>
// +----------------------------------------------------------------------

namespace app\ucenter\model;

use think\facade\Cache;
use think\facade\Lang;

class Action extends Common
{
    public $action_type = ['1'=>'系统', 2=>'用户'];

    public static function test()
    {
        $a = self::get(1);
    }

    /**
     * 新增更新一体操作.
     * {@inheritDoc
     * @author @微尘 <yicmf@qq.com>)
     */
    public function commonUpdateData($param = [],$user = null)
    {
        if (!isset($param)) {
            $this->error = Lang::get('__data_format_error_');

            return false;
        }
        //注册写入后调用事件
        $this->event('after_write', [$this, 'afterActionWrite']);
        if (isset($data[$this->getPk()])) {//更新
            return $this->allowField(['title', 'remark', 'action_rule', 'log_rule', 'type'])->save($param, [$this->getPk()=>$param[$this->getPk()]]) ?: false;
        } else { //新增
            return $this->save($param) ?: false;
        }
    }

    /**
     * 获取行为列表.
     *
     * @author 微尘 <yicmf@qq.com>
     */
    public static function getActionOpt()
    {
        return self::where('status', 1)->column('name,title', 'name');
    }

    /***
     * 定义关联
     */
    public function logs()
    {
        return $this->hasMany('action_log');
    }

    //获取器
    public function getTypeTextAttr($value, $data)
    {
        return $this->action_type[$data['type']];
    }

    //类型转换
    protected $type = [];
    //自动完成
    protected $insert = [
        'status'=> 1,
    ];

    /**
     * 写入后调用事件.
     */
    protected function afterActionWrite($data)
    {
        // 删除缓存
        Cache::rm('action_list');
    }
}
