<?php

    // +----------------------------------------------------------------------
    // | User模型
    // +----------------------------------------------------------------------
    // | Copyright (c) 2015-2019 http://www.yicmf.com, All rights reserved.
    // +----------------------------------------------------------------------
    // | Author: 微尘 <yicmf@qq.com>
    // +----------------------------------------------------------------------

    namespace app\ucenter\model;

    use app\cms\model\Document;
    use app\index\model\UserDownload;
    use app\ucenter\model\Common as CommonModel;
    use app\common\model\Order;

    class User extends CommonModel
    {

        public $sex_list = [
            '0' => '保密',
            '1' => '男',
            '2' => '女'
        ];
        /**
         * 我的关注
         */
        public function follows()
        {
            return $this->belongsToMany(User::class,UserFriend::class,'follow_id','user_id');
        }

        public function downloads()
        {
            return $this->hasMany(UserDownload::class);
        }
        public function messages()
        {
            return $this->hasMany(Message::class);
        }
        /**
         * 我的收藏
         * @author 微尘 <yicmf@qq.com>
         * @datetime: 2019/6/6 0:14
         */
        public function collections()
        {
            return $this->hasMany(Collection::class);
        }
        public function vip()
        {
            return $this->belongsTo(Vip::class,'is_vip');
        }
        public function vips()
        {
            return $this->hasMany(UserVip::class);
        }
        /**
         * 我的粉丝
         */
        public function fans()
        {
            return $this->belongsToMany(User::class,UserFriend::class,'user_id','follow_id');
        }
        /**
         * 我的文档
         */
        public function documents()
        {
            return $this->hasMany(Document::class);
        }

        /**
         * 我的积分记录
         */
        public function points()
        {
            return $this->hasMany(UserPoint::class);
        }

        /**
         * 我的经验记录
         */
        public function experiences()
        {
            return $this->hasMany(UserExperience::class);
        }

        /**
         * 我的订单
         */
        public function orders()
        {
            return $this->hasMany(Order::class, 'store_id');
        }

        /**
         * 我的消息
         */
        public function chats()
        {
            return $this->hasMany(Chat::class);
        }
        /*
         * 我的直推邀请
         * @return \think\model\relation\HasMany
         * @author  : 微尘 <yicmf@qq.com>
         * @datetime: 2019/1/23 15:39
         */
        public function invites()
        {
            return $this->hasMany(User::class, 'invite_id');
        }

        /**
         * 我的第三方授权
         * @return \think\model\relation\HasMany
         * @author  : 微尘 <yicmf@qq.com>
         * @datetime: 2019/1/23 15:40
         */
        public function oauths()
        {
            return $this->hasMany(UserOauth::class);
        }

        /**
         * 我的认证
         * @return \think\model\relation\HasMany
         * @author  : 微尘 <yicmf@qq.com>
         * @datetime: 2019/1/23 15:40
         */
        public function auths()
        {
            return $this->hasMany(UserAuth::class);
        }

        /**
         * 我的签到
         */
        public function signs()
        {
            return $this->hasMany(UserSign::class);
        }

        /**
         * 用户后台角色
         */
        public function roles()
        {
            return $this->belongsToMany('AuthGroup', 'AuthGroupAccess');
        }

        public function logs()
        {
            return $this->hasMany(ActionLog::class);
        }

        /**
         * 提现账户
         */
        public function accounts()
        {
            return $this->hasMany(UserBalanceAccount::class);
        }

        /**
         * 用户账户余额变更记录
         */
        public function balances()
        {
            return $this->hasMany(UserBalance::class);
        }
        /**
         * 用户账户金币变更记录
         */
        public function changes()
        {
            return $this->hasMany(UserChange::class);
        }
        /**
         * 用户账户金币变更记录
         */
        public function coins()
        {
            return $this->hasMany(UserCoin::class);
        }
        /**
         * 充值记录
         */
        public function recharges()
        {
            return $this->hasMany(UserBalanceRecharge::class);
        }
        /**
         * 金币充值记录
         */
        public function coinRecharges()
        {
            return $this->hasMany(UserCoinRecharge::class);
        }

        /**
         * 在线记录
         * @return \think\model\relation\HasMany
         * @author  : 微尘 <yicmf@qq.com>
         * @datetime: 2019/3/11 12:19
         */
        public function onlines()
        {
            return $this->hasMany(UserOnline::class);
        }
        /**
         * 活跃时间
         * @param $value
         * @param $data
         * @return string
         * @author  : 微尘 <yicmf@qq.com>
         * @datetime: 2019/3/7 9:09
         */
        public function getLastActiveTimeTextAttr($value, $data)
        {
            $strap = strtotime($data['last_active_time']);
            if ( $strap > strtotime('-10 minute') ) {
                return '在线';
            } elseif ( $strap > strtotime('-1 hours') ) {
                return '刚刚在线';
            } elseif ( $strap > strtotime('-1 day') ) {
                return '近期在线';
            } elseif ( $strap > strtotime('-1 week') ) {
                return '本周活跃';
            } elseif ( $strap > strtotime('-1 month') ) {
                return '本月活跃';
                //        }elseif ($strap > strtotime(date("Y",time()).'-1-1'))
            } elseif ( $strap > strtotime('-1 year') ) {
                return '今年活跃';
            } else {
                return '不活跃';
            }
        }

        /**
         * 提现
         */
        public function cashes()
        {
            return $this->hasMany(UserBalanceCash::class);
        }

        protected $insert = [
            'create_ip',
            'account',
            'status' => 1
        ];
        // 类型转换
        protected $type = [
            'privacy_setting' => 'array',
            'notice_setting' => 'array'
        ];

        /**
         * 头像
         * @param $value
         * @return string
         * @author  : 微尘 <yicmf@qq.com>
         * @datetime: 2019/1/29 12:05
         */
        public function getAvatarAttr($value)
        {
            if ( !$value ) {
                return '/static/common/images/default_user_portrait.gif';
            } else {
                // 默认头像
                return $value;
            }
        }

        public function getLevelAttr($value, $data)
        {
            // TODO:用户等级算法
            return $value;
            //        return ($data['online_time'] + $data['experience']);
        }

        public function group()
        {
            return $this->belongsTo(UserGroup::class);
        }

        public function getBalanceAttr($value)
        {
            return sprintf("%.2f", $value);
        }

        public function getIncomeBalanceAttr($value)
        {
            return sprintf("%.2f", $value);
        }

        public function getFreezeBalanceAttr($value)
        {
            return sprintf("%.2f", $value);
        }

        // 自动完成
        protected function setPasswordAttr($value)
        {
            return password_hash($value, PASSWORD_DEFAULT);
        }

        protected function setAccountAttr($value)
        {
            return $value ? $value : 'yg' . uniqid();
        }

        protected function setCreateIpAttr($value)
        {
            return $this->request->ip();
        }
    }
