<?php

// +----------------------------------------------------------------------
// | 行为验证器
// +----------------------------------------------------------------------
// | Copyright (c) 2015-2019 http://www.yicmf.com, All rights reserved.
// +----------------------------------------------------------------------
// | Author: 微尘 <yicmf@qq.com>
// +----------------------------------------------------------------------

namespace app\ucenter\validate;

use think\Validate;

class Action extends Validate
{
    protected $rule = [
        'name|行为标识'             => 'require|max:39|unique:action|alphaDash',
        'title|标题'              => 'require|length:1,80', //一个汉字的长度utf8长度在2~4个
        'remark|行为描述'           => 'require|max:140',
        'module|所属模块'           => 'require',
    ];

    protected $message = [
        'remark.require'    => '行为描述不能为空',
        'remark.max'        => '行为描述不能超过140个字符',
        'title.require'     => '标题不能为空',
    ];
    protected $scene = [
        'edit'  => ['title', 'remark'],
    ];
}
