<?php

// +----------------------------------------------------------------------
// | 用户预存款操作
// +----------------------------------------------------------------------
// | Copyright (c) 2015-2019 http://www.yicmf.com, All rights reserved.
// +----------------------------------------------------------------------
// | Author: 微尘 <yicmf@qq.com>
// +----------------------------------------------------------------------

namespace app\ucenter\validate;

use think\Validate;
use app\ucenter\model\User;

class Advance extends Validate
{
    /* 用户模型自动验证 */
    protected $rule = [
        'user|用户' => [
            'require',
            'length'          => '1,11',
            'checkUser' => 'account',
        ],
        'money|金额' => [
            'require',
            'regex=' > '/^(?!0+(?:\.0+)?$)(?:[1-9]\d*|0)(?:\.\d{1,2})?$/'
        ],
        'type|调整类型'  =>'in:1,2,3,5'
    ];
    protected $scene = [
        'login' => [
            'account'=>'require|length:3,28|checkDenyUser:login',
            'password'=>'length:5,28',
            'verify',
        ],
    ];
    protected $message = [
        'account.require' => '您填写的账号已经占用',
    ];
    /**
     * 验证用户信息
     * @param unknown $value
     * @param unknown $rule
     * @param unknown $data
     */
    protected function checkUser($value, $rule, $data)
    {
        if (User::get($value)) {
            return true;
        }else {
            return '用户不存在';
        }
    }
}
